/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*
 * set file permissions.
 */
gboolean apply_rule_setperms(gchar *fullfilename, gchar *mode, gchar *rw);

/*
 * this will copy the contents of an ID3V1tag to the V2 tag.
 */
gboolean apply_rule_v1tov2(gchar *fullfilename);

/*
 * this will copy the contents of an ID3V2tag to an V1 tag.
 */
gboolean apply_rule_v2tov1(gchar *fullfilename);

/*
 * this will change padding spaces in an ID3V1tag to NULL
 */
gboolean apply_rule_tagcleanup(gchar *fullfilename);

/*
 * this will extract infos from the current filename and put
 * and put it together again with a new format.
 */
void apply_rule_format_to_format(gchar *filename, gchar *sformat, gchar *dformat);

/*
 * this will kill spaces at the start/end/both of source
 */
void apply_rule_wipe_spaces(gchar *source, gint loc);


/*
 * this get data from an id3tag and store formatted in filename.
 */
gboolean apply_rule_gettag(gchar *source, gchar *fullfilename, gchar *format, gboolean v1);

/*
 * will strip all characters from the beginning of the string to the first occurence of a digit
 */
extern void apply_rule_strip_to_digit(gchar *source);

/*
 * this will remove parentheses. either all (all==TRUE) or only the first two.
 */
extern void apply_rule_remove_parentheses(gchar *source, gboolean all);

/*
 * this will replace all multiple spaces by one space.
 * spaces are: single space, tab, vertical tab, form feed, carriage return, or newline
 */
extern void apply_rule_strip_multiple_spaces(gchar *source);

/*
 * this will set the first single(!!!) digit to twodigit.
 */
extern void apply_rule_digit_to_twodigit(gchar *source);

/*
 * this will insert a char befor each uppercase character exept the first.
 */
extern void apply_rule_insert_char_before_uppercase(gchar *source, gchar *insert);

/*
 * should be self-explanatory
 */
extern void apply_rule_replace(gchar *source, gchar *from, gchar *to);

/*
 * this will delete all chars in "source" from position "from" to "to".
 */
extern void apply_rule_delete_char(gchar *source, gint from, gint to);

/*
 * this will increase the first digit in source by number.
 */
extern void apply_rule_number_increase(gchar *source, gint number);

/*
 * this will set the characters case:
 * mode=1:first word uppercase;
 * mode=2:every word uppercase;
 * mode=3:anything to lower;
 * mode=4:every character to upper.
 */
extern void apply_rule_forcecc(gchar *source, gint mode);

/*
 * this will get the first two digit number from the filename,
 * and store it in the tags as track.
 */
gint apply_rule_twodigit_to_tag(gchar *fullfilename, gchar *source);

extern void apply_rule_replace_invalid_characters(gchar *source);

extern void apply_rule_strip_to_str(gchar *source, gchar *to, gchar *string);

extern void apply_rule_romandigit_toupper(gchar *source);

extern gint apply_rule_move_file_to(gchar *fullfilename, gchar *curdir, gchar *destdir);
