/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "support.h"
#include "memory.h"

#include "queue.h"
#include "configfile.h"
#include "gui_filelist.h"
#include "gui_queue.h"
#include "mp3info.h"
#include "gui_shared.h"
#include "shared.h"

/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

// Removes all items from haystack that have a filename that is in needle.
static GList *
g_list_remove_matching_filenames(GList *haystack, GList *needle)
{
	GList *haystack_item = NULL;
	GList *needle_item = NULL;
	Mp3Info *haystack_mp3info = NULL;
	Mp3Info *needle_mp3info = NULL;

	haystack_item = g_list_first(haystack);
	while(haystack_item)
	{
		haystack_mp3info = (Mp3Info *)haystack_item->data;
		haystack_item = haystack_item->next;
		
		needle_item = g_list_first(needle);
		while(needle_item)
		{
			needle_mp3info = (Mp3Info *)needle_item->data;
			needle_item = needle_item->next;
			if( strncmp(needle_mp3info->filename, haystack_mp3info->filename, 2048) == 0 )
			{
				haystack = mem_free_1(haystack, haystack_mp3info);
				break;
			}
		}
	}
	return g_list_first(haystack);
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/





/**********************************************************************
 * Adds all selected items in the filelist to a queue list
 **********************************************************************/
void
queue_files_add_selected(void)
{
	extern GtkWidget *cantus;
	extern gchar *current_dir;
	extern GList *queue;
	extern Cfg cfg;
	
	GList *filelist = NULL;
	GList *queuelist = NULL;

// Get a list of all filenames selected
	filelist = clist_filenames_get_selected(GTK_CLIST(lookup_widget(cantus, "clist_cantus_filelist")), current_dir);
// Get all tag and mpeg infos (and other) for that file
	queuelist = mp3file_get_infos(filelist);
// Free the filename list and its data
	mem_free(filelist);
	
// set the column titles
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), cfg.qcols);
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), cfg.qcols);
	
// Remove items from the list which are already in the queue.
	queuelist = g_list_remove_matching_filenames(queuelist, queue);

// Add the desired data to the queue (both)
	clist_queue_add_files(GTK_CLIST (lookup_widget (cantus, "clist_cantus_queue")), &queuelist, cfg.qcols);
	clist_queue_add_files(GTK_CLIST (lookup_widget (cantus, "clist_cantus_queueonly_queue")), &queuelist, cfg.qcols);
	queue = g_list_concat(queue, queuelist);

// set every second row to grey background
	if( cfg.togglequeuebg )
	{
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queue")));
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queueonly_queue")));
	}

	return;
}







/**********************************************************************
 * Removes all files from the queue and adds them again
 **********************************************************************/
void
queue_update(gboolean reset)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	extern Cfg cfg;
	
	gtk_clist_freeze (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")));
	gtk_clist_freeze (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")));

// empty lists out.
	gtk_clist_clear (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")));
	gtk_clist_clear (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")));
	
// set the column titles
	if(reset)
	{
		clist_set_titles (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), cfg.qcols);
		clist_set_titles (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), cfg.qcols);
	}
		
// Add the desired data to the queue (both)
	clist_queue_add_files (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), &queue, cfg.qcols);
	clist_queue_add_files (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), &queue, cfg.qcols);
	
// set every second row to grey background
	if( cfg.togglequeuebg )
	{
		clist_queue_toggle_colors (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")));
		clist_queue_toggle_colors (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")));
	}
	
	gtk_clist_thaw (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")));
	gtk_clist_thaw (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")));

	return;
}





/**********************************************************************
 * Empties out all queue lists and frees the allocated memory
 **********************************************************************/
void
queue_clear(void)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	
// empty lists out.
	gtk_clist_clear(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")));
	gtk_clist_clear(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")));
	queue = mem_free(queue);
}





/**********************************************************************
 * Removes all selected items from the queue and from the gui clist
 * Arguments: A queue clist.
 **********************************************************************/
void
queue_files_remove_selected(GtkCList *clist)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	extern Cfg cfg;
	
	GList *selected = NULL;

// Get a list of all filenames selected
	selected = clist_get_selected(clist);
	
// set the column titles
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), cfg.qcols);
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), cfg.qcols);
	
// Remove items from the gui
	clist_files_remove(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), selected);
	clist_files_remove(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), selected);

// Remove it from the queue list.
	queue = g_list_remove_matching_filenames(queue, selected);

	g_list_free(selected);

// set every second row to grey background
	if( cfg.togglequeuebg )
	{
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queue")));
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queueonly_queue")));
	}
	
	return;
}









/**********************************************************************
 * Adds files recursive to a queue list, beginning at current_dir
 **********************************************************************/
void
queue_files_add_recursive(gchar *current_dir)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	extern Cfg cfg;
	
	GList *filelist = NULL;
	GList *filelist2 = NULL;
	GList *queuelist = NULL;

	gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(cantus, "appbar")), "Prescanning directories...");
	while(g_main_iteration(FALSE));

// Get a list of all filenames ("*.mp3") in currentdir and its subs. CASE INSENSITIVE.
	filelist = get_files_recursive(current_dir, "*.mp3", FALSE);
  filelist2 = get_files_recursive(current_dir, "*.flac", FALSE);
  filelist = g_list_concat(filelist, filelist2);
#ifdef HAVE_OGG_H
	if( (filelist2 = get_files_recursive(current_dir, "*.ogg", FALSE)) )
		filelist = g_list_concat(filelist, filelist2);
#endif

// Get all tag and mpeg infos (and other) for that filenames
	queuelist = mp3file_get_infos(filelist);
// Free the filename list and its data
	mem_free(filelist);
	
// set the column titles
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), cfg.qcols);
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), cfg.qcols);
	
// Remove items from the list which are already in the queue.
	queuelist = g_list_remove_matching_filenames(queuelist, queue);

// Add the desired data to the queue (both)
	clist_queue_add_files(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queue")), &queuelist, cfg.qcols);
	clist_queue_add_files(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queueonly_queue")), &queuelist, cfg.qcols);
	queue = g_list_concat(queue, queuelist);
	
// set every second row to grey background
	if( cfg.togglequeuebg )
	{
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queue")));
		clist_queue_toggle_colors(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queueonly_queue")));
	}

	return;
}
