/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "support.h"

#include "lib_id3v1.h"
#include "lib_id3v2.3.h"
#include "lib_vorbis.h"
#include "mp3info.h"
#include "rules.h"
#include "queue.h"
#include "rules_plugs.h"
#include "plugs.h"
#include "gui_log.h"
#include "gui_queue.h"
#include "shared.h"


/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/


/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/









/**********************************************************************
 * will apply all rules specified by the user to a queuelist "todo"
 * if preview is TRUE, the tags won't be changed.
 **********************************************************************/
void
rules_plugs_apply_1(Mp3Info *mp3info, gboolean preview, GtkCTreeNode *logparent)
{
	extern GList *rulelist;
	GList *rulelistitem = NULL;
	Rule *rule = NULL;
	
	gchar filename_noext[2048];
	gchar fullfilename[2048];
	gchar extension[2048];
	
	snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
	
	strncpy(extension, strrchr(fullfilename,'.'), 2047);
	strncpy(filename_noext, strrchr(fullfilename,'/') + 1, 2047);
	*strrchr(filename_noext,'.')='\0';
	
// Change extension to lowercase
#ifdef HAVE_OGG_H
	if( strtoucmp(extension, ".ogg")==0 )
		strncpy(extension, ".ogg", 5);
#endif
	if( strtoucmp(extension, ".mp3")==0 )
		strncpy(extension, ".mp3", 5);
	if( strtoucmp(extension, ".flac")==0 )
		strncpy(extension, ".flac", 6);
	
	rulelistitem = g_list_first(rulelist);
	while (rulelistitem)
	{
		rule = (Rule *)rulelistitem->data;

// Apply this rules to all filenames in queue.
		if(strcmp(rule->name, "gettag_v1")==0)
			apply_rule_gettag (filename_noext, fullfilename, rule->option1, 1);
		if(strcmp(rule->name, "gettag_v2")==0)
			apply_rule_gettag (filename_noext, fullfilename, rule->option1, 2);
#ifdef HAVE_OGG_H
		if(strcmp(rule->name, "gettag_vorbis")==0)
			apply_rule_gettag (filename_noext, fullfilename, rule->option1, 3);
#endif
		if(strcmp(rule->name, "replace")==0)
			apply_rule_replace (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "format")==0)
			apply_rule_format_to_format (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "parentheses")==0)
		{
			if(strcmp(rule->name, "all")==0)
				apply_rule_remove_parentheses (filename_noext, TRUE);
			else
				apply_rule_remove_parentheses (filename_noext, FALSE);
		}
		if(strcmp(rule->name, "forcecc")==0)
		{
			if(strcmp(rule->option1, "only first letter to upper")==0)
				apply_rule_forcecc (filename_noext, 1);
			else if(strcmp(rule->option1, "all words begin uppercase")==0)
				apply_rule_forcecc (filename_noext, 2);
			else if(strcmp(rule->option1, "every character lowercase")==0)
				apply_rule_forcecc (filename_noext, 3);
			else if(strcmp(rule->option1, "every character uppercase")==0)
				apply_rule_forcecc (filename_noext, 4);
			else if(strcmp(rule->option1, "roman digits uppercase")==0)
				apply_rule_romandigit_toupper(filename_noext);
		}
		if(strcmp(rule->name, "deletechar")==0)
			apply_rule_delete_char (filename_noext, atoi(rule->option1), atoi(rule->option2));
		if(strcmp(rule->name, "increase")==0)
			apply_rule_number_increase (filename_noext, atoi(rule->option1));
		if(strcmp(rule->name, "stripchar")==0)
			apply_rule_strip_to_digit (filename_noext);
		if(strcmp(rule->name, "stripoccurence")==0)
			apply_rule_strip_to_str (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "twodigit")==0)
			apply_rule_digit_to_twodigit (filename_noext);
		if(strcmp(rule->name, "insertspace")==0)
			apply_rule_insert_char_before_uppercase (filename_noext, " ");
		if(strcmp(rule->name, "stripspace")==0)
			apply_rule_strip_multiple_spaces(filename_noext);
		if(strcmp(rule->name, "killspace")==0)
		{
			if(strcmp(rule->option1, "start and end")==0)
				apply_rule_wipe_spaces (filename_noext, 2);
			else if(strcmp(rule->option1, "start")==0)
				apply_rule_wipe_spaces (filename_noext, 0);
			else
				apply_rule_wipe_spaces (filename_noext, 1);
		}
		
		if(!preview)
		{
// This rules can not be previewed (tag changers!)
			if(strcmp(rule->name, "movetodir")==0)
			{
				if(apply_rule_move_file_to(fullfilename, mp3info->directory, rule->option1) == 0)
					log_add(logparent, "Moved file to the destination directory!", 2);
				else if(apply_rule_move_file_to(fullfilename, mp3info->directory, rule->option1) == 1)
					log_add(logparent, "Failed moving the file to the destination directory! (File exists)", 3);
				else
					log_add(logparent, "Failed moving the file to the destination directory! (Unknown reason, check permissions)", 3);
			}
			if(strcmp(rule->name, "twodigit2tag")==0)
			{
				if(apply_rule_twodigit_to_tag(fullfilename, filename_noext) != 0)
					log_add(logparent, "Failed to copy two digit number to tag!", 3);
				else
					log_add(logparent, "Successfully copied two digit number to the tag's track field!", 2);
			}
			if(strcmp(rule->name, "setperms")==0)
			{
				if(!apply_rule_setperms(fullfilename, rule->option1, rule->option2))
					log_add(logparent, "Failed to set permissions!", 3);
				else
					log_add(logparent, "Successfully set permissions!", 2);
			}
			if(strcmp(rule->name, "v1tov2")==0)
			{
				if(!apply_rule_v1tov2(fullfilename))
					log_add(logparent, "Failed to copy the V1 tag to the V2 tag!", 3);
				else
					log_add(logparent, "Successfully copied the V1 tag to the V2 tag!", 2);
			}
			if(strcmp(rule->name, "v2tov1")==0)
			{
				if(!apply_rule_v2tov1(fullfilename))
					log_add(logparent, "Failed to copy the V2 tag to the V1 tag!", 3);
				else
					log_add(logparent, "Successfully copied the V2 tag to the V1 tag!", 2);
			}
			if(strcmp(rule->name, "v1delete")==0)
			{
				if(access(fullfilename, W_OK)==0)
				{
					if(del_id3v1_tag(fullfilename)!=0)
						log_add(logparent, "Failed to remove the ID3V1 tag!", 3);
					else
						log_add(logparent, "Succesfully removed the ID3V1 tag!", 2);
				}
				else
					log_add(logparent, "Failed to delete the ID3V1 tag!", 3);
			}
			if(strcmp(rule->name, "v2delete")==0)
			{
				if(access(fullfilename, W_OK)==0)
				{
					if(del_id3v2_tag(fullfilename)!=0)
						log_add(logparent, "Failed to delete the ID3V2 tag!", 3);
					else
						log_add(logparent, "Succesfully deleted the ID3V2 tag!", 2);
				}
				else
					log_add(logparent, "Failed to delete the ID3V1 tag!", 3);
			}
#ifdef HAVE_OGG_H
			if(strcmp(rule->name, "vorbisdelete")==0)
			{
				if(access(fullfilename, W_OK)==0)
				{
					if(del_vorbis_tag(fullfilename)!=0)
						log_add(logparent, "Failed to delete the Vorbis tag!", 3);
					else
						log_add(logparent, "Succesfully deleted the Vorbis tag!", 2);
				}
				else
					log_add(logparent, "Failed to delete the Vorbis tag!", 3);
			}
#endif
			if(strcmp(rule->name, "tagcleanup")==0)
			{
				if(!apply_rule_tagcleanup(fullfilename))
					log_add(logparent, "Failed to cleanup the ID3 tags!", 3);
				else
					log_add(logparent, "Cleaned up the ID3 tags!", 2);
			}
		}

		rulelistitem = rulelistitem->next;
	}
// Cleanup the new generated filename from invalid characters.
	apply_rule_replace_invalid_characters(filename_noext);

	if(!preview)
		mp3file_get_info_1(mp3info->directory, mp3info->filename, mp3info);
	
	snprintf(mp3info->destinationfilename, 2047, "%s%s", filename_noext, extension);
	
// Check if the changed filename is different, and set the staus
	if( strncmp(mp3info->filename, mp3info->destinationfilename, 2047) != 0 )
		strncpy(mp3info->status, "Todo", 255);
	else
		strncpy(mp3info->status, "Unchanged", 255);
}









void
rules_plugs_rename(GList *queue)
{
	extern GtkWidget *cantus;
	extern gchar *active_tag;
	
	GList *item = NULL;
	Mp3Info *mp3info = NULL;
	gchar fullfilename[2048];
	gchar fullfilename_new[2048];
	gchar status[2048];
	gint numrows = 0, currentrow = 0;
	gchar logentry[4096];
	GtkCTreeNode *logparent = NULL;
	
// Count rows (needed for the statusbar)
	item = g_list_first(queue);
	while(item)
	{
		item = item->next;
		++numrows;
	}
	
// Go through the whole list "todo", applying filters to each item.
	item = g_list_first(queue);
	while(item)
	{
		mp3info = (Mp3Info *)item->data;
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
		
		snprintf(status, 2047, "Applying rules: %s", fullfilename);
		gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), status);
		gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), (gfloat)100/numrows*(currentrow++)*0.01);
		while(g_main_iteration(FALSE));
		
		logparent = log_add(NULL, fullfilename, 1);
		
		if(access(fullfilename, W_OK)!=0)
		{
			strncpy(mp3info->status, "Locked!", 255);
			log_add(logparent, "The file is locked!!", 3);
		}

// Apply rules and recalculate the fullfilename, cause the file may have been moved by the move_file_to rule.
		rules_plugs_apply_1(mp3info, FALSE, logparent);
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
		
		if( strncmp(mp3info->filename, mp3info->destinationfilename, 2047)!=0
			&& access(fullfilename, W_OK)==0 )
		{
			snprintf(fullfilename_new, 2047, "%s%s", mp3info->directory, mp3info->destinationfilename);
			
// Check if the new filename already exists.
			if(access(fullfilename_new, F_OK)!=0)
			{
				if( rename(fullfilename, fullfilename_new) == 0 )
				{
					snprintf(logentry, 2047, "Successfully renamed to: %s", mp3info->destinationfilename);
					log_add(logparent, logentry, 2);
					strncpy(mp3info->status, "Renamed!", 255);
					strncpy(mp3info->filename, mp3info->destinationfilename, 2047);
					strncpy(mp3info->destinationfilename, "", 2047);
					if(strcmp(active_tag, fullfilename) == 0)
						strncpy(active_tag, fullfilename_new, 2047);
				}
				else
				{
					snprintf(logentry, 2047, "Failed renaming to: %s", mp3info->destinationfilename);
					log_add(logparent, logentry, 3);
					strncpy(mp3info->status, "Rename failed!", 255);
				}
			}
			else
			{
				snprintf(logentry, 2047, "Failed renaming! File exists: %s", mp3info->destinationfilename);
				log_add(logparent, logentry, 3);
				strncpy(mp3info->status, "File exists!", 255);
			}
		}
		
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
		
		item = item->next;
	}
	
	gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), "Ready.");
	gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), 0);
}
















/**********************************************************************
 * will apply all rules specified by the user to the first item of the queue
 * if preview is TRUE, the tags won't be changed.
 **********************************************************************/
gchar *
rules_plugs_update_example(GList *todo)
{
	extern GList *rulelist;
	
	GList *todoitem = NULL;
	GList *rulelistitem = NULL;
	Rule *rule = NULL;
	Mp3Info *mp3info = NULL;
	gchar fullfilename[2048];
	gchar filename_noext[2048];
	gchar extension[2048];
	gchar minipreview[2048];

	if(!todo)
		return NULL;
	
	todoitem = g_list_first(todo);
	
	mp3info = (Mp3Info *)todoitem->data;
	snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
	
	strncpy(extension, strrchr(fullfilename,'.'), 2047);
	strncpy(filename_noext, strrchr(fullfilename,'/') + 1, 2047);
	*strrchr(filename_noext,'.')='\0';
	
	rulelistitem = g_list_first(rulelist);
	while (rulelistitem)
	{
		rule = (Rule *)rulelistitem->data;

// Apply this rules to all filenames in queue.
		if(strcmp(rule->name, "gettag_v1")==0)
			apply_rule_gettag (filename_noext, fullfilename, rule->option1, TRUE);
		if(strcmp(rule->name, "gettag_v2")==0)
			apply_rule_gettag (filename_noext, fullfilename, rule->option1, FALSE);
		if(strcmp(rule->name, "replace")==0)
			apply_rule_replace (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "format")==0)
			apply_rule_format_to_format (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "parentheses")==0)
		{
			if(strcmp(rule->name, "all")==0)
				apply_rule_remove_parentheses (filename_noext, TRUE);
			else
				apply_rule_remove_parentheses (filename_noext, FALSE);
		}
		if(strcmp(rule->name, "forcecc")==0)
		{
			if(strcmp(rule->option1, "only first letter to upper")==0)
				apply_rule_forcecc (filename_noext, 1);
			else if(strcmp(rule->option1, "all words begin uppercase")==0)
				apply_rule_forcecc (filename_noext, 2);
			else if(strcmp(rule->option1, "every character lowercase")==0)
				apply_rule_forcecc (filename_noext, 3);
			else if(strcmp(rule->option1, "every character uppercase")==0)
				apply_rule_forcecc (filename_noext, 4);
			else if(strcmp(rule->option1, "roman digits uppercase")==0)
				apply_rule_romandigit_toupper(filename_noext);
		}
		if(strcmp(rule->name, "deletechar")==0)
			apply_rule_delete_char (filename_noext, atoi(rule->option1), atoi(rule->option2));
		if(strcmp(rule->name, "stripoccurence")==0)
			apply_rule_strip_to_str (filename_noext, rule->option1, rule->option2);
		if(strcmp(rule->name, "increase")==0)
			apply_rule_number_increase (filename_noext, atoi(rule->option1));
		if(strcmp(rule->name, "stripchar")==0)
			apply_rule_strip_to_digit (filename_noext);
		if(strcmp(rule->name, "twodigit")==0)
			apply_rule_digit_to_twodigit (filename_noext);
		if(strcmp(rule->name, "insertspace")==0)
			apply_rule_insert_char_before_uppercase (filename_noext, " ");
		if(strcmp(rule->name, "stripspace")==0)
			apply_rule_strip_multiple_spaces(filename_noext);
		if(strcmp(rule->name, "killspace")==0)
		{
			if(strcmp(rule->option1, "start and end")==0)
				apply_rule_wipe_spaces (filename_noext, 2);
			else if(strcmp(rule->option1, "start")==0)
				apply_rule_wipe_spaces (filename_noext, 0);
			else
				apply_rule_wipe_spaces (filename_noext, 1);
		}
		
		rulelistitem = rulelistitem->next;
	}
	
	snprintf(minipreview, 2047, "Example: %s\n-> %s%s", mp3info->filename, filename_noext, extension);
	
	return strdup(minipreview);
}













void
rules_plugs_preview(GList *queue)
{
	extern GtkWidget *cantus;
	GList *item = NULL;
	Mp3Info *mp3info = NULL;
	gchar fullfilename[2048];
	gchar status[2048];
	gint numrows = 0, currentrow = 0;
	
// Count rows (needed for the statusbar)
	item = g_list_first(queue);
	while(item)
	{
		item = item->next;
		++numrows;
	}
	
// Go through the whole list "todo", applying filters to each item.
	item = g_list_first(queue);
	while(item)
	{
		mp3info = (Mp3Info *)item->data;
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
		
		snprintf(status, 2047, "Applying rules: %s", fullfilename);
		gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), status);
		gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), (gfloat)100/numrows*(currentrow++)*0.01);
		while(g_main_iteration(FALSE));
		
		rules_plugs_apply_1(mp3info, TRUE, NULL);
		
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
		
		item = item->next;
	}
	gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), "Ready.");
	gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), 0);
}
