/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <support.h>
#include "tag2filename.h"
#include "mp3info.h"
#include "plugs.h"
#include "gui_queue.h"


void
tag2filename_selection(void)
{
	extern GtkWidget *cantus;
	extern gchar *active_tag;
	
	GtkCList *clist = NULL;
	GList *selection = NULL;
	GList *item = NULL;
	gchar *format = NULL;
	gchar fullfilename[2048];
	gchar fullfilename_new[2048];
	gchar newfilename[2048];
	gchar extension[2048];
	gint whichtag = 0;
	gint row = 0;
	Mp3Info *mp3info = NULL;
	
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_id3v1"))) )
		whichtag = 1;
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_id3v2"))) )
		whichtag = 2;
#ifdef HAVE_OGG_H
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_vorbis"))) )
		whichtag = 3;
#endif
	
	format = gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tag2filename_format")));
	clist = GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue"));
	
// we must copy the list, because while updating the queue it may change.
// if nothing is selected, return the empty glist.
	if( !(selection = g_list_copy(clist->selection)) )
		return;

	item = g_list_first(selection);
	while(item)
	{
		row = (gint)item->data;
		mp3info = gtk_clist_get_row_data(clist, row);
		
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
		strncpy(extension, strrchr(mp3info->filename, '.'), 2047);

		memset(newfilename, 0, 2048);
		
		if( apply_rule_gettag(newfilename, fullfilename, format, whichtag) )
		{
			apply_rule_replace_invalid_characters(newfilename);
			
			snprintf(fullfilename_new, 2047, "%s%s%s", mp3info->directory, newfilename, extension);
			
			if ( access (fullfilename, W_OK) != 0 )
				strncpy(mp3info->status, "Locked!", 255);
			
			
			if( strncmp(fullfilename, fullfilename_new, 2047)!=0
				&& access(fullfilename, W_OK)==0 )
			{
				if(access(fullfilename_new, F_OK)!=0)
				{
					if(rename(fullfilename, fullfilename_new)==0)
					{
						strncpy(mp3info->status, "Renamed!", 255);
						strncpy(mp3info->filename, strrchr(fullfilename_new, '/')+1, 2047);
						if(strcmp(active_tag, fullfilename) == 0)
							strncpy(active_tag, fullfilename_new, 2047);
					}
					else
						strncpy(mp3info->status, "Rename failed!", 255);
				}
				else
					strncpy(mp3info->status, "File exists!", 255);
			}
			else
			{
				strncpy(mp3info->status, "Unchanged", 255);
			}
		}
		else
		{
			strncpy(mp3info->status, "Missing field", 255);
		}

		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
		gtk_clist_select_row(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), row, 0);
		
		item = item->next;
	}
	
	g_list_free(selection);
}






void
tag2filename_queue(void)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	extern gchar *active_tag;
	
	GList *item = NULL;
	gchar *format = NULL;
	gchar fullfilename[2048];
	gchar fullfilename_new[2048];
	gchar newfilename[2048];
	gchar extension[2048];
	gint whichtag = 0;
	Mp3Info *mp3info = NULL;
	
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_id3v1"))) )
		whichtag = 1;
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_id3v2"))) )
		whichtag = 2;
#ifdef HAVE_OGG_H
	if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tag2filename_get_vorbis"))) )
		whichtag = 3;
#endif
	
	format = gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_tag2filename_format")));
	
	if(!queue)
		return;
	
	item = g_list_first(queue);
	
	while(item)
	{
		mp3info = (Mp3Info *)item->data;
		
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
		strncpy(extension, strrchr(mp3info->filename, '.'), 2047);

		memset(newfilename, 0, 2048);
		
		if( apply_rule_gettag(newfilename, fullfilename, format, whichtag) )
		{
			apply_rule_replace_invalid_characters(fullfilename_new);

			snprintf(fullfilename_new, 2047, "%s%s%s", mp3info->directory, newfilename, extension);
			
			if(access(fullfilename, W_OK)!=0)
				strncpy(mp3info->status, "Locked!", 255);
			
			if( strncmp(fullfilename, fullfilename_new, 2047)!=0
				&& access(fullfilename, W_OK)==0 )
			{
				if(access(fullfilename_new, F_OK)!=0)
				{
					if(rename(fullfilename, fullfilename_new)==0)
					{
						strncpy(mp3info->status, "Renamed!", 255);
						strncpy(mp3info->filename, strrchr(fullfilename_new, '/')+1, 2047);
						if(strcmp(active_tag, fullfilename) == 0)
							strncpy(active_tag, fullfilename_new, 2047);
					}
					else
						strncpy(mp3info->status, "Rename failed!", 255);
				}
				else
					strncpy(mp3info->status, "File exists!", 255);
			}
			else
			{
				strncpy(mp3info->status, "Unchanged", 255);
			}
		}
		else
		{
			strncpy(mp3info->status, "Missing field", 255);
		}
		
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
		
		item = item->next;
	}
}
