/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_CANTUSHASH_H
#define HAVE_CANTUSHASH_H

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <glib-object.h>
#include "cantushashvalue.h"


#define CantusHash GHashTable

CantusHash *cantushash_create(void);
void cantushash_destroy(CantusHash *hash);
CantusHash *cantushash_duplicate(CantusHash *hash);
void cantushash_set(CantusHash *hash, const gchar *key, gint type, gpointer val);

void cantushash_set_int(CantusHash *hash, const gchar *key, gint val);
void cantushash_set_char(CantusHash *hash, const gchar *key, const gchar *val);
void cantushash_set_bool(CantusHash *hash, const gchar *key, gboolean val);
void cantushash_set_pointer(CantusHash *hash, const gchar *key, gpointer val);

gint         cantushash_get_int(CantusHash *hash, const gchar *key);
const gchar *cantushash_get_char(CantusHash *hash, const gchar *key);
gboolean     cantushash_get_bool(CantusHash *hash, const gchar *key);
gpointer     cantushash_get_pointer(CantusHash *hash, const gchar *key);

#endif
