/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_CANTUSHASHVALUE_H
#define HAVE_CANTUSHASHVALUE_H

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <glib-object.h>


typedef struct {
  int   type;
  void *value;
} CantusHashValue;

// Common for all containers.
CantusHashValue *new_value(void);
CantusHashValue *value_duplicate(CantusHashValue *hvalue);
void value_delete(CantusHashValue *hvalue);
int value_get_type(CantusHashValue *hvalue);
void value_set(CantusHashValue *hvalue, int type, void *value);

// Integer container.
void value_set_int(CantusHashValue *hvalue, int value);
int value_get_int(CantusHashValue *hvalue);
CantusHashValue *value_duplicate_int(CantusHashValue *hvalue);

// Bool container.
void value_set_bool(CantusHashValue *hvalue, gboolean value);
gboolean value_get_bool(CantusHashValue *hvalue);
CantusHashValue *value_duplicate_bool(CantusHashValue *hvalue);

// Pointer container.
void value_set_pointer(CantusHashValue *hvalue, void *value);
void *value_get_pointer(CantusHashValue *hvalue);
CantusHashValue *value_duplicate_pointer(CantusHashValue *hvalue);

// Char container.
void value_set_char(CantusHashValue *hvalue, const gchar *value);
const gchar *value_get_char(CantusHashValue *hvalue);
CantusHashValue *value_duplicate_char(CantusHashValue *hvalue);

#endif
