/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "editarea.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
Editarea::Editarea()
{
}


Editarea::~Editarea(void)
{
#ifdef _DEBUG_
  printf(EDITAREANAME "(): Editarea::~Editarea(): Called.\n");
#endif
}


/******************************************************************************
 * Public
 ******************************************************************************/
GtkWidget *Editarea::build(gboolean vertical)
{
  std::list<Gtk::Widget*> focuschain;
  Gtk::Table          *top    = NULL;
  Gtk::Label          *label  = NULL;
  Gtk::RadioButton    *radio  = NULL;
  Gtk::CheckButton    *check  = NULL;
  Gtk::Button         *button = NULL;
  Gtk::Fixed          *fixed  = NULL;
  Gtk::AttachOptions   yfill  = vertical ? Gtk::FILL : Gtk::FILL|Gtk::EXPAND;
  // The main table.
  if (vertical)
    table = new Gtk::Table(11, 7);
  else
    table = new Gtk::Table(5, 11);
  table->set_row_spacings(3);
  table->set_col_spacings(5);
  table->set_border_width(5);
  table->set_col_spacing(1, 0);
  table->set_col_spacing(5, 0);
  
  // Labels, Entries and CheckButtons.
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Artist:</b>"));
  table->attach(*label, 0, 1, 0, 1, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  table->attach(*label, 1, 6, 0, 1, Gtk::FILL|Gtk::EXPAND, yfill);
  widgets["Artist"] = label;
  check = new Gtk::CheckButton;
  widgets["Artist:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 0, 1, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Song:</b>"));
  table->attach(*label, 0, 1, 1, 2, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Song"] = label;
  table->attach(*label, 1, 6, 1, 2, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Song:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 1, 2, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Album:</b>"));
  table->attach(*label, 0, 1, 2, 3, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Album"] = label;
  table->attach(*label, 1, 6, 2, 3, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Album:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 2, 3, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Year:</b>"));
  table->attach(*label, 0, 1, 3, 4, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  widgets["Year"] = label;
  table->attach(*label, 1, 6, 3, 4, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Year:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 3, 4, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Track:</b>"));
  table->attach(*label, 0, 1, 4, 5, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  label->set_size_request(30, -1);
  widgets["Track"] = label;
  table->attach(*label, 1, 2, 4, 5, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Track:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 2, 3, 4, 5, Gtk::FILL, yfill);
  
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Genre:</b>"));
  table->attach(*label, 3, 4, 4, 5, Gtk::FILL, yfill);
  label = new Gtk::Label("", 0, 0.5);
  label->set_size_request(70, -1);
  widgets["Genre"] = label;
  table->attach(*label, 4, 5, 4, 5, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Genre:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 4, 5, Gtk::FILL, yfill);
  
  // The comment field.
  label = new Gtk::Label("", 0, 0.5);
  label->set_markup(_("<b>Comment:</b>"));
  if (vertical)
    table->attach(*label, 0, 7, 5, 6, Gtk::FILL, yfill);
  else
    table->attach(*label, 0, 1, 5, 6, Gtk::FILL, yfill);
  if (vertical) {
    label = new Gtk::Label("", 0, 0);
    widgets["Comment"] = label;
    label->set_size_request(-1, 60);
    table->attach(*label, 0, 7, 6, 7, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
  }
  else {
    label = new Gtk::Label("", 0, 0.5);
    widgets["Comment"] = label;
    table->attach(*label, 1, 6, 5, 6, Gtk::FILL, Gtk::FILL);
  }
  check = new Gtk::CheckButton;
  widgets["Comment:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 5, 6, Gtk::FILL, Gtk::FILL);
  
  // Radiobuttons (copy direction selector).
  radio = new Gtk::RadioButton(_("ID3V1 -> ID3V2"));
  widgets["ID3V1toID3V2:Check"] = radio;
  focuschain.push_back(radio);
  Gtk::RadioButton::Group group = radio->get_group();
  if (vertical)
    table->attach(*radio, 0, 3, 8, 9, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
  else
    table->attach(*radio, 9, 10, 0, 1, Gtk::FILL, Gtk::FILL);
  radio = new Gtk::RadioButton(group, _("ID3V2 -> ID3V1"));
  if (vertical)
    table->attach(*radio, 4, 7, 8, 9, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
  else
    table->attach(*radio, 9, 10, 1, 2, Gtk::FILL, Gtk::FILL);
  radio->signal_toggled().connect(signal_radio_directionselector_changed);
  
  // Some distance between the fields and the buttons.
  fixed = new Gtk::Fixed;
  fixed->set_size_request(0, -1);
  if (vertical)
    table->attach(*fixed, 0, 7, 9, 10, Gtk::FILL, Gtk::FILL|Gtk::EXPAND);
  else
    table->attach(*fixed, 10, 11, 0, 5, Gtk::FILL, Gtk::FILL);
  
  // Buttons
  if (vertical) {
    hvbox = new Gtk::HBox;
    hvbox->set_spacing(6);
    hvbox->set_border_width(3);
    table->attach(*hvbox, 0, 7, 10, 11, Gtk::FILL, Gtk::FILL);
    // Vertical boxes should have something expanding benath the buttons to make
    // them right-aligned.
    fixed = new Gtk::Fixed;
    hvbox->pack_start(*fixed, TRUE, TRUE);
  }
  else {
    hvbox = new Gtk::VBox;
    hvbox->set_spacing(6);
    table->attach(*hvbox, 11, 12, 0, 5, Gtk::FILL, Gtk::FILL, 0, 0);
  }
  
  button = new Gtk::Button(Gtk::Stock::SAVE);
  button->set_size_request(-1, 35);
  if (vertical)
    hvbox->pack_end(*button, FALSE, TRUE);
  else
    hvbox->pack_start(*button, FALSE, TRUE);
  button->signal_clicked().connect(signal_button_save_clicked);
  
  // A container table holding everything.
  top = new Gtk::Table(1, 1);
  top->attach(*table, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND, Gtk::FILL|Gtk::EXPAND);
  top->show_all();
  
  // Set the focus chain.
  table->set_focus_chain(focuschain);
  
  return (GtkWidget*)Glib::unwrap(top);
}


Gtk::Widget *Editarea::get_widget(const gchar *widgetname)
{
  Gtk::Widget *widget = widgets[widgetname];
  if (!widget)
    g_warning("Editarea::get_widget(): Widget not found: %s\n", widgetname);
  g_assert(widget != NULL);
  return widget;
}


void Editarea::set_label_text(const gchar *widgetname, const gchar *str)
{
#ifdef _DEBUG_
  printf("Editarea::~set_label_text(): Called. (%s)\n", str);
#endif
  Gtk::Label *label = (Gtk::Label*)get_widget(widgetname);
  label->set_text(str ? str : "");
}


gboolean Editarea::get_check_active(const gchar *widgetname)
{
  Gtk::CheckButton *check = (Gtk::CheckButton*)get_widget(widgetname);
  return check->get_active();
}


void Editarea::set_active(gboolean active)
{
  hvbox->set_sensitive(active);
}


/******************************************************************************
 * Private
 ******************************************************************************/
