/* charset.h - 2001/12/04 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef HAVE_LIB_CHARSET_H
#define HAVE_LIB_CHARSET_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <libintl.h>
#include <iconv.h>
#include <langinfo.h>

#define HAVE_LANGINFO_CODESET
#define HAVE_ICONV_OPEN

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef DLL_H
#define DLL_H
typedef struct DLL_s {
  void *prev;
  void *data;
  void *next;
} DLL;
#endif


/***************
 * Declaration *
 ***************/

typedef struct {
  char *charset_title;
  char *charset_name;
} CharsetInfo;

/* translated charset titles */
extern const CharsetInfo charset_trans_array[];


/**************
 * Prototypes *
 **************/
char *get_current_charset(void);

char *convert_to_utf8 (const char *string);
char *convert_from_utf8(const char *string);
char *convert_string_to(const char *string, const char *encoding);
char *convert_string_from(const char *string, const char *encoding);
char *convert_string(const char *string, const char *from, const char *to);

char *convert_from_file_to_user(const char *string);
char *convert_from_user_to_file(const char *string);

DLL  *Charset_Create_List(void);
char *Charset_Get_Name_From_Title(char *charset_title);
char *Charset_Get_Title_From_Name(char *charset_name);

short int test_conversion_charset(char *from, char *to);


#endif /* HAVE_LIB_CHARSET_H */
