/* lib_mpgheader.
 * (c)2002, 2003 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef HAVE_MPEGHEADER_H
#define HAVE_MPEGHEADER_H

#include <stdio.h>
#include <string.h>

typedef struct {
  char version[30];
  int layer;
  short int protection;
  int bitrate;
  int frequency;
  short int padding;
  short int is_private;
  int mode;
  short int intensity_stereo;
  short int ms_stereo;
  short int copyright;
  short int original;
  int emphasis;
  int frames;
  int seconds;
} MpgHeader;

int get_mpgheader(MpgHeader *header, const char *filename);

#endif
