/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_pluginarea.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
PluginArea::PluginArea(gboolean is_vertical)
{
  vertical = is_vertical;
  set_show_border(FALSE);
  set_scrollable();
}


PluginArea::~PluginArea(void)
{
  remove_unneeded(NULL);
}


/******************************************************************************
 * Public
 ******************************************************************************/
void PluginArea::plugin_attach(Plugin *plugin)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugin_attach(): Called. ("
            << plugin->get_name() << ")\n";
#endif
  if (plugin_is_visible(plugin))
    return;
#ifdef _DEBUG_
  std::cout << "PluginArea::plugin_attach(): Not visible. ("
            << plugin->get_name() << ")\n";
#endif
  
  plugin->ref();
  
  // Grab the plugin's widget.
  GtkWidget *cwidget = (GtkWidget*)plugin->get_uiwidget(vertical);
  g_return_if_fail(cwidget != NULL);
  Gtk::Widget *widget = Glib::wrap(cwidget);
  widget->show();
  
  this->append_page(*widget, plugin->get_label());
  
  // Since the wrapped widget is not part of the plugin, we need to hold it
  // somewhere. That's why we use a map instead of a list.
  visibleplugins[plugin] = widget;
}


void PluginArea::plugin_remove(Plugin *plugin)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugin_remove(): Called. ("
            << plugin->get_name() << ")\n";
#endif
  Gtk::Widget *widget = visibleplugins[plugin];
  if (!widget)
    return;
  visibleplugins.erase(plugin);
  this->remove_page(*widget);
  signal_widget_removed.emit(plugin);
  delete widget;
  plugin->unref();
}


gboolean PluginArea::plugin_is_visible(Plugin *plugin)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugin_is_visible(): Called. ("
            << plugin->get_name() << ")\n";
#endif
  std::map<Plugin*, Gtk::Widget*>::iterator iter;
  for (iter = visibleplugins.begin(); iter != visibleplugins.end(); iter++) {
    if (iter->first != plugin)
      continue;
    return TRUE;
  }
  return FALSE;
}


void PluginArea::plugins_set(std::list<Plugin*> *plugins)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugins_set(): Called.\n";
#endif
  // Remove unneeded plugins first.
  this->remove_unneeded(plugins);
  
#ifdef _DEBUG_
  std::cout << "PluginArea::plugins_set(): Removed unneeded.\n";
#endif
  
  // Now, make every responsible plugin visible.
  this->plugins_attach(plugins);
  
#ifdef _DEBUG_
  std::cout << "PluginArea::plugins_set(): Insert ready.\n";
#endif
}


void PluginArea::plugins_attach(std::list<Plugin*> *plugins)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugins_attach(): Called.\n";
#endif
  std::list<Plugin*>::iterator iter;
  for (iter = plugins->begin(); iter != plugins->end(); iter++)
    this->plugin_attach(*iter);
}


void PluginArea::plugins_remove(std::list<Plugin*> *plugins)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::plugins_remove(): Called.\n";
#endif
  std::list<Plugin*>::iterator iter;
  for (iter = plugins->begin(); iter != plugins->end(); iter++)
    this->plugin_remove(*iter);
}


/******************************************************************************
 * Protected
 ******************************************************************************/
void PluginArea::remove_unneeded(std::list<Plugin*> *required)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::remove_unneeded(): Called.\n";
#endif
  std::map<Plugin*, Gtk::Widget*>::iterator iter;
  for (iter = visibleplugins.begin(); iter != visibleplugins.end(); iter++) {
    if (required && in_list(iter->first, required))
      continue;
    this->plugin_remove(iter->first);
  }
}


gboolean PluginArea::in_list(Plugin *plugin, std::list<Plugin*> *required)
{
#ifdef _DEBUG_
  std::cout << "PluginArea::in_list(): Called.\n";
#endif
  std::list<Plugin*>::iterator iter;
  for (iter = required->begin(); iter != required->end(); iter++) {
    if (*iter != plugin)
      continue;
    return TRUE;
  }
  return FALSE;
}
