/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "main.h"

Mainwindow    mainwindow;
Controller    controller;    // This also inits gthreads!
GUIController guicontroller;

int main(int argc, char **argv)
{
#ifdef ENABLE_NLS
  bindtextdomain(GETTEXTPACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset(GETTEXTPACKAGE, "UTF-8");
  textdomain(GETTEXTPACKAGE);
#endif
  
  Gtk::Main    gtkmain(argc, argv);
  Gtk::Window *pwindow    = mainwindow.create();
  std::string  configfile = getenv("HOME");
  configfile.append("/.cantus3rc");
  
  g_assert(pwindow != NULL);
  
  guicontroller.init();
  
  // Set the default preferences.
  controller.preferences->set_bool("General:UnicodeEnabled", TRUE);
  controller.preferences->set_bool("UIGTK2:Pluginarea1:Visible", FALSE);
  controller.preferences->set_bool("UIGTK2:Pluginarea2:Visible", TRUE);
  controller.preferences->set_char("UIGTK2:Browser:Defaultdir", getenv("HOME"));
  controller.preferences->set_char("UIGTK2:Browser:Filetypes", "*.mp3,*.ogg");
  controller.preferences->commit();
  
  // Initialize the configuration file.
  controller.configfile->set_filename(configfile);
  if (controller.configfile->check() != 0
    && controller.configfile_save() != 0) {
    std::cerr << "Error: Configfile initialization failed ("
              << configfile << "). Aborting.\n";
    return 1;
  }
  
  // Now, the configuration file *must* exist. Load the config.
  if (controller.configfile_load() != 0) {
    std::cerr << "Error: Failed to load config. (" << configfile << ")\n";
    return 1;
  }
  if (!controller.preferences->commit()) {
    std::cerr << "Error: Invalid configfile. (" << configfile << ")\n";
    return 1;
  }
  
  // Load plugins.
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "id3v1.so", 1);
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "id3v2.so", 2);
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "vorbis.so", 3);
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "id3copier.so", 4);
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "tag2filename.so", 5);
  controller.pluginhandler->reg(PACKAGE_LIB_DIR "mpegheader.so", 6);
  
  // Apply the preferences.
  mainwindow.filebrowser->set_dir(
                 controller.preferences->get_char("UIGTK2:Browser:Defaultdir"));
  controller.preferences->commit();
  
  // Run.
  gtkmain.run(*pwindow);
  
  // Save config.
  if (controller.configfile_save() != 0) {
    std::cerr << "Error: Unable to save config (" << configfile << ").\n";
    return 1;
  }
  
  return(0);
}
