{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetBeginCap: boolean;
    procedure SetBeginCap(const Value: boolean);
    function GetCcw: boolean;
    procedure SetCcw(const Value: boolean);
    function GetConvex: boolean;
    procedure SetConvex(const Value: boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
    function GetEndCap: boolean;
    procedure SetEndCap(const Value: boolean);
  public
    property BeginCap: boolean read GetBeginCap write SetBeginCap;
    property Ccw: boolean read GetCcw write SetCcw;
    property Convex: boolean read GetConvex write SetConvex;
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;
    property EndCap: boolean read GetEndCap write SetEndCap;

{$endif read_interface}

{$ifdef read_implementation}

{ TExtrusionNode ----------------------------------------------- }

function TExtrusionNode.GetBeginCap: boolean;
begin
  Result := FdBeginCap.Value;
end;

procedure TExtrusionNode.SetBeginCap(const Value: boolean);
begin
  FdBeginCap.Send(Value);
end;

function TExtrusionNode.GetCcw: boolean;
begin
  Result := FdCcw.Value;
end;

procedure TExtrusionNode.SetCcw(const Value: boolean);
begin
  FdCcw.Send(Value);
end;

function TExtrusionNode.GetConvex: boolean;
begin
  Result := FdConvex.Value;
end;

procedure TExtrusionNode.SetConvex(const Value: boolean);
begin
  FdConvex.Send(Value);
end;

function TExtrusionNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TExtrusionNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

function TExtrusionNode.GetEndCap: boolean;
begin
  Result := FdEndCap.Value;
end;

procedure TExtrusionNode.SetEndCap(const Value: boolean);
begin
  FdEndCap.Send(Value);
end;

{$endif read_implementation}
