{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetTimeOriginAtLoad: boolean;
    procedure SetTimeOriginAtLoad(const Value: boolean);
    function GetHeadBobbing: Single;
    procedure SetHeadBobbing(const Value: Single);
    function GetHeadBobbingTime: Single;
    procedure SetHeadBobbingTime(const Value: Single);
  public
    property TimeOriginAtLoad: boolean read GetTimeOriginAtLoad write SetTimeOriginAtLoad;
    property HeadBobbing: Single read GetHeadBobbing write SetHeadBobbing;
    property HeadBobbingTime: Single read GetHeadBobbingTime write SetHeadBobbingTime;

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiNavigationInfoNode ----------------------------------------------- }

function TKambiNavigationInfoNode.GetTimeOriginAtLoad: boolean;
begin
  Result := FdTimeOriginAtLoad.Value;
end;

procedure TKambiNavigationInfoNode.SetTimeOriginAtLoad(const Value: boolean);
begin
  FdTimeOriginAtLoad.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbing: Single;
begin
  Result := FdHeadBobbing.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbing(const Value: Single);
begin
  FdHeadBobbing.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbingTime: Single;
begin
  Result := FdHeadBobbingTime.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbingTime(const Value: Single);
begin
  FdHeadBobbingTime.Send(Value);
end;

{$endif read_implementation}
