/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ConstantPool;

public class ClassName {
    static String processClassData(InputStream in) throws JasperException, IOException {
        int i;
        DataInputStream din = new DataInputStream(in);
        din.readInt();
        din.readUnsignedShort();
        din.readUnsignedShort();
        int count = din.readUnsignedShort();
        ConstantPool[] constantPool = new ConstantPool[count];
        constantPool[0] = new ConstantPool();
        for (i = 1; i < constantPool.length; ++i) {
            constantPool[i] = new ConstantPool();
            if (!constantPool[i].read(din)) {
                throw new JasperException(Constants.getString("jsp.error.classname"));
            }
            if (constantPool[i].type != 5 && constantPool[i].type != 6) continue;
            ++i;
        }
        for (i = 1; i < constantPool.length; ++i) {
            if (constantPool[i] == null) continue;
            if (constantPool[i].index1 > 0) {
                constantPool[i].arg1 = constantPool[constantPool[i].index1];
            }
            if (constantPool[i].index2 <= 0) continue;
            constantPool[i].arg2 = constantPool[constantPool[i].index2];
        }
        int accessFlags = din.readUnsignedShort();
        ConstantPool thisClass = constantPool[din.readUnsignedShort()];
        din.close();
        return ClassName.printClassName(thisClass.arg1.strValue);
    }

    private static String printClassName(String s) {
        if (s.charAt(0) == '[') {
            return ClassName.typeString(s, "");
        }
        StringBuffer x = new StringBuffer();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '/') {
                x.append('.');
                continue;
            }
            x.append(s.charAt(j));
        }
        return x.toString();
    }

    private static String typeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuffer x = new StringBuffer();
        while (typeString.charAt(ndx) == '[') {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x.append("byte ");
                break;
            }
            case 'C': {
                x.append("char ");
                break;
            }
            case 'D': {
                x.append("double ");
                break;
            }
            case 'F': {
                x.append("float ");
                break;
            }
            case 'I': {
                x.append("int ");
                break;
            }
            case 'J': {
                x.append("long ");
                break;
            }
            case 'L': {
                for (int i = ndx + 1; i < typeString.indexOf(59); ++i) {
                    if (typeString.charAt(i) != '/') {
                        x.append(typeString.charAt(i));
                        continue;
                    }
                    x.append('.');
                }
                x.append(" ");
                break;
            }
            case 'V': {
                x.append("void ");
                break;
            }
            case 'S': {
                x.append("short ");
                break;
            }
            case 'Z': {
                x.append("boolean ");
            }
        }
        x.append(varName);
        while (isArray > 0) {
            x.append("[]");
            --isArray;
        }
        return x.toString();
    }

    public static String getClassName(String classFile) throws JasperException {
        try {
            FileInputStream fin = new FileInputStream(classFile);
            return ClassName.processClassData(fin);
        }
        catch (IOException ex) {
            throw new JasperException(Constants.getString("jsp.error.classname"), ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Filename: " + args[i] + " Classname: " + ClassName.getClassName(args[i]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

