/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.3.6. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCITERMODEL_H
#define C2BCITERMODEL_H


#include <QAbstractTableModel>
#include <QColor>
#include <QStringList>
#include <QVector>


class c2bCiterModel : public QAbstractTableModel
{

    Q_OBJECT

public:
    c2bCiterModel(QObject* parento = 0);
    ~c2bCiterModel();

    enum Format {AJYT, JYA, T, YAJT};

    QList<int> sizeHintForColumns() const;
    QStringList dataSelectedCiteIds() const;
    QVariant data(const QModelIndex& i, int role = Qt::DisplayRole) const;
    void clearSelection();
    void setFilter(const QString& pattern, QModelIndex* current_index);
    void setSelectedFilter(QModelIndex* current_index);
    void updateFormat(const Format format, QModelIndex* current_index);

    inline QString dataBibTeXPosition(const QModelIndex& i) const
    {
        if (_is_index_valid(i))
            return _bibtex_position.at(_offset(i.row()));
        else
            return QString();
    }
    inline QString dataBibTeXFile(const QModelIndex& i) const
    {
        return dataBibTeXPosition(i).remove(QRegExp(":(\\d+)$"));
    }
    inline QString dataFile(const QModelIndex& i) const
    {
        if (_is_index_valid(i))
            return _file.at(_offset(i.row()));
        else
            return QString();
    }
    inline QString dataUrl(const QModelIndex& i) const
    {
        if (_is_index_valid(i))
            return _url.at(_offset(i.row()));
        else
            return QString();
    }
    inline Qt::ItemFlags flags(const QModelIndex& /* i */) const
    {
        return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    }
    inline int count() const
    {
        return _row_count;
    }
    inline int rowCount(const QModelIndex& /* parent */ = QModelIndex()) const
    {
        return _row_count;
    }
    inline int columnCount(const QModelIndex& /* parent */ = QModelIndex()) const
    {
        return _column_count;
    }


public slots:
    void loadCitations(const QString& fn);
    void loadCitations(const QStringList& fns);
    void selectCitation(const QModelIndex& i);


signals:
    void statusMessage(const QString& ms);


private:
    Q_DISABLE_COPY(c2bCiterModel)

    QColor _first_column_color;
    QString _display_ajyt(const int row, const int column) const;
    QString _display_jya(const int row, const int column) const;
    QString _display_t(const int row, const int column) const;
    QString _display_yajt(const int row, const int column) const;
    QString(c2bCiterModel::*_display_ptr)(const int row, const int column) const;
    int _offset(const int i) const;
    void _add_citations(const QString& fn);
    void _clear();
    void _set_mapping();
    void _set_sort_indices();
    void _set_table_data();
    void _update_current_index(const int current_citation, QModelIndex* current_index);
    void _update_format(const Format format = AJYT, QModelIndex* current_index = 0);

    inline bool _is_index_valid(const QModelIndex& i) const
    {
        const int r(i.row());
        return _row_count > 0 && r >= 0 && r < _row_count;
    }

    // Model data
    Format _format;
    QStringList _author_string;
    QStringList _bibtex_position;
    QStringList _citeId;
    QStringList _file;
    QStringList _journal;
    QStringList _title;
    QStringList _url;
    QStringList _year;
    QVector<QString> _author;
    QVector<QString> _search_string;
    QVector<bool> _is_selected;
    QVector<bool> _matches_filter;
    QVector<int> _map_ajyt;
    QVector<int> _map_author;
    QVector<int> _map_filter;
    QVector<int> _map_jya;
    QVector<int> _map_t;
    QVector<int> _map_yajt;
    QVector<int>* _mapping;
    bool _is_filter_set;
    int _author_count;
    int _author_max_length;
    int _citation_count;
    int _column_count;
    int _journal_max_length;
    int _row_count;

};

#endif
