/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.3.6. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCLIPBOARD_H
#define C2BCLIPBOARD_H

#include <QObject>
#include <QClipboard>
#include <QTimer>


/**
    cb2Bib Clipboard

    Implements clipboard functionatility as required by cb2Bib This should fix
    acrobat, mozilla, qt 3.3.3 issues Using clipboardPoll

    @author Pere Constans
*/

#ifdef CB_POLL
class clipboardPoll;
#endif

class c2bClipboard : public QObject
{
    Q_OBJECT
public:
    c2bClipboard(QObject* parento = 0);
    ~c2bClipboard();

    const QString text();


signals:
    void cbDataChanged(const QString&);


public slots:
    void setConnected(bool);


private:
    bool isConnected;
    bool supportsSelection;
    QClipboard* cb;
    QString clip;
    QString clipS;
    QTimer* timer;
    uint interval;
#ifdef CB_POLL
    clipboardPoll* poll;
#endif


private slots:
    void checkClipboardData();
    void checkData();
    void checkSelectionData();
    void dataChanged();
    void newClipboardData(bool selectionMode);
    void selectionChanged();

};

#endif
