/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

/* vga.h -- definitions used in video drivers */

#ifndef	CCE_VGA_H
#define	CCE_VGA_H

/* Sequencer */
#define	VGASEQ_ADDR	0x3C4
#define	VGASEQ_DATA	0x3C5
#define	VGASEQ_CNT	5

/* CRT controller */
#define	VGACRT_ADDR	0x3D4
#define	VGACRT_DATA	0x3D5
#define	CGACRT_ADDR	0x3D4
#define	CGACRT_DATA	0x3D5
#define	VGACRT_CNT	25
#define	CGACRT_CNT	25

/* Graphics controller */
#define	VGAGRP_ADDR	0x3CE
#define	VGAGRP_DATA	0x3CF
#define	VGAGRP_CNT	9

/* Attribute controller */
#define	VGAATTR_A_O	0x3C0
#define	VGAATTR_DATA	0x3C1
#define	VGAATTR_CNT	21
#define	EGAATTR_CNT	20

#if defined(linux)
#define GRAPH_BASE 0xA0000
#elif defined(__FreeBSD__)
#define GRAPH_BASE 0x0
#endif
#define FONT_SIZE  0x2000

#define	VGA_FONT_SIZE	128
#define	VGA_FONT_HEIGHT	16

/* DAC Palette */
#define	VGAPAL_OADR	0x3C8
#define	VGAPAL_IADR	0x3C7
#define	VGAPAL_DATA	0x3C9

/* Misc */
#define	VGAMISC_IN	0x3CC
#define	VGAMISC_OUT	0x3C2

/* Input Stat 1 */
/*#define	VGAST1_ADDR	0x3DA*/

#define	MAX_PELS	16

struct vgaRegs 
{
	u_char	crt[VGACRT_CNT],
		att[VGAATTR_CNT],
		gra[VGAGRP_CNT],
		seq[VGASEQ_CNT],
		mis;
};

struct pelRegs {
	u_char	red[MAX_PELS],
		grn[MAX_PELS],
		blu[MAX_PELS];
};

static inline void	VgaOutByte(u_char value)
{
    __asm__	("movb %%al, %%ah\n\t"
		 "movb $8, %%al\n\t"
		 "outw %%ax, %w1"
		 :/* no outputs */
		 :"a" ((u_char) value),
		 "d" ((u_short)VGAGRP_ADDR));
}

//void VgaSetRegisters(struct vgaRegs *regs);
void VgaInit(void);
void VgaTextMode(void);
void VgaGraphMode(void);
void VgaWput(u_char *code, u_char fc, u_char bc);
void VgaSput(u_char *code, u_char fc, u_char bc);
void VgaInputSput(int x, unsigned char ch,int fg,int bg);
void VgaInputWput(int x,u_char ch1,u_char ch2,int fg,int bg);
/*
void VgaResetHardScroll(void);
void VgaHardScrollUp(int line, int color);
void VgaHardScrollDown(int line, int color);
*/
void VgaSetCursorAddress(CursorInfo *ci, u_int x, u_int y);
void VgaSetAddress(u_int p);
void VgaSetStartAddress(void);
void VgaSetInputAddress(u_int p);
void VgaCursor(CursorInfo *ci);
void VgaClearAll(int color);
void VgaClearInput(int color);
void VgaScreenSaver(bool blank);
//int VgaReadPels(const char *str);
//int VgaReadNewRegs();
int VgaAttach(void);
void VgaDetach(void);
void VgaDefaultCaps();

extern u_short red16[], green16[], blue16[];
extern VideoInfo VgaInfo, VgaS3Info, VgaFBInfo;

extern char    *gramMem;     
extern u_int   writeAddr;          
extern bool    kanjiCursor;
extern u_char  cursorTop, cursorBtm;

#endif
