/****************************************************************************
          Hyper's CD Catalog
A multiplatform qt and xml based catalog program
 
Author    : Christoph Thielecke (crissi99@gmx.de)
License   : GPL
Copyright : (C) 2003 Christoph Thielecke
****************************************************************************/

#include <qmessagebox.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include <qprogressdialog.h>
#include <expat.h>
#include <iostream>

#include <qfileinfo.h>
#include <qregexp.h>

#include "import.h"
#include "importdialog.h"
#include "mainwidget.h"
#include "dbase.h"
#include "config.h"

using namespace std;

lineObject::lineObject( QString medianame, QString path, QString filename,
                        float size, QDateTime datetime ) {
	this->medianame = medianame;
	this->path = path;
	this->filename = filename;
	this->size = size;
	this->datetime = datetime;
}

lineObject::~lineObject() {}

QString lineObject::getMediaName() {
	return medianame;
}

QString lineObject::getPath() {
	return path;
}

QString lineObject::getFileName() {
	return filename;
}

float lineObject::getSize() {
	return size;
}

QDateTime lineObject::getDateTime() {
	return datetime;
}

/*
 * import a file with folling format:
 * <media>/<path>/..../<file><seperator><size><seperator><day/month/year><space><hour>:<minute>:<second>
 * the hashmark '#' can be used as comment in csv file.
 *
 */
importCsv::importCsv( GuiSlave * parent, QString seperator, QString filename, bool createdatabase, bool correctbadstyle ) {

	this->filename = filename;
	this->correctbadstyle =correctbadstyle;
	this->createdatabase = createdatabase;
	this->seperator = seperator;

	if (!filename.isEmpty()) {

		if(parent->mainw->db == NULL)
			parent->newEvent();
		else {
			if (createdatabase) {
				while(parent->closeEvent() != 0);
				parent->newEvent();
			}
		}

		if (parent->mainw->db != NULL) {

			guislave = parent;
			db = parent->mainw->db;
			mediacount=0;
			filecount=0;
			dircount=0;
			refreshcount=0;
			int linecount=0;
			int lines=0;


			QApplication::setOverrideCursor(waitCursor);
			guislave->panelsOFF();

			QFile f(filename);

			if ( f.open( IO_ReadOnly ) ) {
				lines = f.readAll().contains( '\n' ) + 1;
				f.close();
			}

			if (f.open(IO_ReadOnly)) {	// file opened successfully

				QProgressDialog progress(0,"progressdialog",true);
				progress.setLabelText(tr("Importing CSV..."));
				progress.setCancelButton(0);
				progress.setTotalSteps(lines);

				QTextStream t(&f);	// use a text stream
				QString medianame = "";

				medialines = new QList < lineObject > ();
				medialines->setAutoDelete(TRUE);	// the list owns the objects

				while (!t.eof()) {
					QString line;
					QString fullpath;
					QString path;
					float size;
					QDate date;
					QString new_medianame;
					QString datetimestring;


					line = t.readLine();	// line of text excluding '\n'

					if (!line.startsWith("#") && !line.isEmpty()) {

						if (correctbadstyle) {
							//     QMessageBox::warning (0, "wrong", line);
							int idx=0;
							while(idx!= -1) {
								idx=line.find(QString(seperator+"/"),idx);
								if (idx!=-1) {
									line.replace(idx,QString(seperator+"/").length(),"/");
								}
							}
							idx=0;
							while(idx!= -1) {
								idx=line.find(QString("/"+seperator),idx);
								if (idx!=-1) {
									line.replace(idx,QString("/"+seperator).length(),"/");
								}
							}
							//   QMessageBox::warning (0, "fine", line);
						}

						int mediaindex = line.find('/',0);
						int pathindex = line.find(seperator, mediaindex+1);
						fullpath = (line.mid(mediaindex,pathindex-mediaindex));
						new_medianame = (line.left(mediaindex));


						//   path = fullpath.mid(mediaindex + 1, medianame.length()+1);

						int sizeindex = line.find(seperator, pathindex+1);
						QString sizestring = line.mid(pathindex+1, sizeindex-pathindex-1).stripWhiteSpace();
						size =  ((line.mid(pathindex + 1, sizeindex-pathindex-1)).stripWhiteSpace()).toFloat();

						datetimestring = (line.mid(sizeindex + 1, line.length())).stripWhiteSpace();

						int dayindex = datetimestring.find("/");
						int monthindex = datetimestring.find("/", dayindex + 1);
						int yearindex = datetimestring.find(" ", monthindex + 1);
						int hourindex = datetimestring.find(":", yearindex + 1);
						int minuteindex = datetimestring.find(":", hourindex + 1);

						int day = (datetimestring.mid(0, dayindex)).toInt();
						QString day_ = (datetimestring.mid(0, dayindex));
						int month = (datetimestring.mid(dayindex + 1, monthindex - dayindex - 1)).toInt();
						int year = (datetimestring.mid(monthindex + 1, hourindex - monthindex - 4)).toInt();
						bool validDate = date.setYMD(year, month, day);

						int hour = (datetimestring.mid(yearindex + 1, minuteindex - hourindex - 1)).toInt();
						int minute = (datetimestring.mid(hourindex + 1, minuteindex - 1 - hourindex)).toInt();
						;
						int second = (datetimestring.mid(minuteindex + 1, datetimestring.length() -1)).toInt();
						QDate date(year,month,day);
						QTime time (hour,minute,second);

						QDateTime datetime = QDateTime(date,time);

						int fileindex = fullpath.findRev('/');

						QString dirpath="";
						if (fileindex != 0)
							dirpath= fullpath.mid(1,fileindex-1);
						QString filename = fullpath.mid(fileindex + 1, fullpath.length()-fileindex);

						/*
						//if (!validDate)
						{
							QString msg;
							msg += "line: " + line + "\n";
							msg += "path: " + path + "\n";
							msg += "fullpath: " + fullpath + "\n";
							msg += "sizestring: "+ sizestring + "\n";
							msg += "sizeindex: " + QString().setNum(sizeindex) + "\n";
							msg += "size: " + QString().setNum(size) + "\n";
							msg += "day: " + QString().setNum(day) + "\n";
							msg += "month: " + QString().setNum(month) + "\n";
							msg += "hour: " + QString().setNum(hour) + "\n";
							msg += "minute: " + QString().setNum(minute) + "\n";
							msg += "second: " + QString().setNum(second) + "\n";
							msg += "year: " + QString().setNum(year) + "\n";
							msg += "dat_: " + day_ + "\n";
							msg += "datetimestring: " + datetimestring + "\n";
							msg += "new_medianame: " + new_medianame + "\n";
							msg+= "directory path:"+dirpath+"\n";
							msg+="file name: "+filename+"\n";

							QMessageBox::warning(0, "line", msg);
						}
						*/
						if (medianame == "")
							medianame = new_medianame;

						if (medianame != new_medianame) {
							//        QMessageBox::warning (0, "info", medianame);
							addNewMedia(medianame, medialines);
							medialines->clear();
							medianame = new_medianame;
							addNewItem(new_medianame, dirpath, filename, size,datetime);
						} else {
							//        QMessageBox::warning (0, "info", "new item");
							addNewItem(new_medianame, dirpath, filename, size,datetime);
						}

					}			// valid line
					linecount++;
					progress.setProgress(linecount);
				}
				f.close();
				if (!medialines->isEmpty()) {
					addNewMedia(medianame, medialines);
					medialines->clear();
				}

				delete medialines;
				(db->getRootNode())->touchDB();
				guislave->panelsON();
				QApplication::restoreOverrideCursor();

				QString msg;
				msg+=tr("Import was successful.");
				msg+="\n";
				if (mediacount < 2)
					msg+=tr("1 media")+",\n";
				else
					msg+=QString().setNum(mediacount)+" "+QString(tr("media"))+",\n";

				if (dircount < 2)
					msg+=QString(tr("1 directory:,\n"));
				else
					msg+=QString().setNum(dircount)+" "+QString(tr("directories"))+",\n";

				if (filecount < 2)
					msg+=tr("1 File")+",\n";
				else
					msg+=QString().setNum(filecount)+" "+QString(tr("files"))+"\n";

				msg+=tr("are imported.");

				QMessageBox::information(0,tr("Import successful"),msg);

			} else {

				if (f.status() == IO_ReadError)
					QMessageBox::critical(0, tr("file read error"), tr("Could not read file"));

				else if (f.status() == IO_FatalError)
					QMessageBox::critical(0, tr("Fatal error"), tr("Fatal error occured."));

				else if (f.status() == IO_OpenError)
					QMessageBox::critical(0, tr("file open error"), tr("Could not open file"));
			}
		} // file dialog canceled
	}

}

importCsv::~importCsv() {}

int
importCsv::addNewItem( QString medianame, QString path,
                       QString filename, float size, QDateTime datetime ) {
	medialines->append( new lineObject( medianame, path, filename, size, datetime ) );

	// QMessageBox::critical( 0, "item", "new item!");
	return 0;

}

#if QT_VERSION >= 0x030100 // Qt 3.1.0 or better
int importCsv::addNewMedia( QString new_medianame, QPtrList < lineObject > *medialines ) {
#else
int importCsv::addNewMedia( QString new_medianame, QList < lineObject > *medialines ) {
#endif
	// QMessageBox::critical(0, "media", new_medianame);

	if ( guislave->mainw->db == NULL )
		guislave->newEvent();
	if ( guislave->mainw->db == NULL )
		return 0;

	/* create new media */
	Node *env, *curr;
	curr = db->getMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ) );
	if ( curr == NULL )
		curr = db->putMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ), mediacount, ( ( char* ) ( ( const char * ) tr( "importuser" ) ) ), CD, "" );

	QString msg;
	lineObject *obj;

	for ( obj = medialines->first(); obj; obj = medialines->next() ) {

		env = curr;

		QString path = obj->getPath();

		//        QMessageBox::warning(0, "path", obj->getPath());
		int startindex = 0;
		int dirindex = 0;


		if ( !obj->getPath().isEmpty()) {
			path += "/";
			dirindex = path.find( "/" );
			while ( dirindex != -1 ) {

				QString dir = path.mid( startindex, dirindex - startindex );
				//       QMessageBox::warning(0, "new dir", dir);

				curr = db->getDirectoryNode( env, ( char * ) ( ( const char * ) * new QString( dir ) ) );
				if ( curr == NULL ) {
					curr = db->putDirectoryNode( env, ( char * ) ( ( const char * ) * new QString( dir ) ), getTime( obj->getDateTime() ), "" );
					dircount++;

				}

				startindex = dirindex + 1;
				dirindex = path.find( "/", dirindex + 1 );

				env = curr;

			}
		}
		dirindex = -1;

		uint size = ( uint ) obj->getSize();
		float s;
		int st;

		if ( size > ( uint ) ( 1024 * 1024 * 1024 * 2 ) ) {
			s = ( double ) size / ( double ) ( 1024 * 1024 * 1024 );
			st = GBYTE;
		} else if ( size > ( uint ) ( 1024 * 1024 ) ) {
			s = ( double ) size / ( double ) ( 1024 * 1024 );
			st = MBYTE;
		} else if ( size > ( uint ) 1024 ) {
			s = ( double ) size / ( double ) 1024;
			st = KBYTE;
		} else {
			s = size;
			st = BYTE;
		}

		env = curr;
		curr = db->getFileNode( env, ( ( char * ) ( ( const char* ) * new QString( obj->getFileName() ) ) ) );
		if ( curr == NULL )
			curr = db->putFileNode( env, ( ( char * ) ( ( const char * ) * new QString( obj->getFileName() ) ) ), getTime( obj->getDateTime() ), "", st, s );

		curr = db->getMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ) );

		filecount++;
	} // over all items in list

	mediacount++;
	refreshcount++;
	if ( refreshcount == 10 ) {
		guislave->mainw->app->processEvents();
		refreshcount = 0;
	}

	return 0;
}



/*
 * Import a xml report from gtktalog

 example entry:


 <directory>
	<disc_name><![CDATA[_disc_]]></disc_name>
	<directory_name><![CDATA[/_dir_/]]></directory_name>
	<file_name><![CDATA[_filename_]]></file_name>
	<file_size><![CDATA[_size_]]></file_size>
	<file_date><![CDATA[_date_]]></file_date>
	<category><![CDATA[_category_]]></category>
	<description><![CDATA[_descripion_]]></description>
	<information><![CDATA[_information_]]></information>
</directory>

 dummy values are:
 _disc_ 					==> disc name
 _dir_						==> directory
 _filename_			==> filename
 _size_					==> size
 _category_			==> category
 _descripion_		==> description
 _information_		==> information

 */


importXml* class_link;

QString tmpdirname;
extern "C" {
	static void startElement( void * userData, const char * name, const char **atts ) {
		int *depthPtr = ( int * ) userData;
		QString name2 = QString::fromLatin1( name ).stripWhiteSpace();

		class_link->last_tag = name2;

		/*
		if (name2 == "information"){
			// found information

		}
		*/

		*depthPtr += 1;
	}

	static void endElement( void * userData, const char * name ) {

		QString name2 = QString::fromLatin1( name ).stripWhiteSpace();

		class_link->last_tag = "";
		QString line = "";

		class_link->path = class_link->directory + "/" + class_link->filename;

		if ( name2 == "name" ) {
			line += "catalogName: " + class_link->catalogName + "\n";
		} else if ( name2 == "report" ) {
			class_link->guislave->mainw->db->setName( class_link->catalogName );
		} else if ( name2 == "directory" ) {

			line += "new_medianame: " + class_link->new_medianame + "\n";
			line += "directory: " + class_link->directory + "\n";
			line += "filename: " + class_link->filename + "\n";
			line += "Full path: " + class_link->path + "\n";
			line += "size: " + QString().setNum( class_link->size ) + "\n";
			line += "datetimestring: " + class_link->datetimestring + "\n";
			line += "category: " + class_link->categorie + "\n";
			line += "description: " + class_link->description + "\n";
			line += "information: " + class_link->information + "\n";

                        //cerr << line << endl << endl << endl;

			if ( class_link->medianame == "" )
				class_link->medianame = class_link->new_medianame;

			if ( class_link->medianame != class_link->new_medianame ) {
				//        QMessageBox::warning (0, "info", class_link->medianame);
				class_link->addNewMedia( class_link->medianame, class_link->medialines );
				class_link->medialines->clear();
				class_link->medianame = class_link->new_medianame;
				class_link->addNewItem( class_link->new_medianame, class_link->directory, class_link->filename, class_link->size, class_link->datetime );
			} else {
				//        QMessageBox::warning (0, "info", "new item");
				class_link->addNewItem( class_link->medianame, class_link->directory, class_link->filename, class_link->size, class_link->datetime );
			}

			class_link->new_medianame = "";
			class_link->directory = "";
			class_link->filename = "";
			class_link->size = 0;
			class_link->categorie = "";
			class_link->description = "";
			class_link->information = "";
			class_link->datetimestring = "";
                        tmpdirname = "";

			class_link->linecount++;
			class_link->progress->setProgress( class_link->linecount );
		}


		int * depthPtr = ( int * ) userData;
		*depthPtr -= 1;
	}

	static void getCdata( void * userData, const XML_Char * s, int len ) {

		QString tmp2 = "";
		for ( int i = 0;i < len;i++ ) {
			tmp2 += s[ i ];
		}

		QString name2 = tmp2.stripWhiteSpace();

		if ( class_link->last_tag == "name" ) {
			// found catalog name
			class_link->catalogName += name2;
		}


		if ( class_link->last_tag == "directory" ) {
			// found directory entry: for each file there is one
			// just the start of each file
		}

		if ( class_link->last_tag == "disc_name" ) {
			// found disc name
			class_link->new_medianame += name2;
		}

		if ( class_link->last_tag == "directory_name" ) {
			// found directory name
			tmpdirname += name2;
			class_link->directory = tmpdirname.mid( 1, tmpdirname.length() - 2 );
		}

		if ( class_link->last_tag == "file_name" ) {
			// found file name
			class_link->filename += name2;
		}

		if ( class_link->last_tag == "file_size" ) {
			// found file size
			class_link->size = name2.toInt();
		}

		if ( class_link->last_tag == "file_date" ) {
			// found file size
			class_link->datetimestring = name2.stripWhiteSpace();

			int dayindex = class_link->datetimestring.find( "/" );
			int monthindex = class_link->datetimestring.find( "/", dayindex + 1 );
			int yearindex = class_link->datetimestring.find( " ", monthindex + 1 );
			int hourindex = class_link->datetimestring.find( ":", yearindex + 1 );
			int minuteindex = class_link->datetimestring.find( ":", hourindex + 1 );

			int day = ( class_link->datetimestring.mid( 0, dayindex ) ).toInt();
			QString day_ = ( class_link->datetimestring.mid( 0, dayindex ) );
			int month = ( class_link->datetimestring.mid( dayindex + 1, monthindex - dayindex - 1 ) ).toInt();
			int year = ( class_link->datetimestring.mid( monthindex + 1, hourindex - monthindex - 4 ) ).toInt();

			int hour = ( class_link->datetimestring.mid( yearindex + 1, minuteindex - hourindex - 1 ) ).toInt();
			int minute = ( class_link->datetimestring.mid( hourindex + 1, minuteindex - 1 - hourindex ) ).toInt();

			int second = ( class_link->datetimestring.mid( minuteindex + 1, class_link->datetimestring.length() - 1 ) ).toInt();
			QDate date( year, month, day );
			QTime time ( hour, minute, second );

			class_link->datetime = QDateTime( date, time );

		}


		if ( class_link->last_tag == "file_category" ) {
			// found category
			class_link->categorie = name2;
		}

		if ( class_link->last_tag == "description" ) {
			// found description
			class_link->description = name2;
		}


		if ( class_link->last_tag == "information" ) {
			// found information
			class_link->information = name2;
		}


	}

}

importXml::importXml( GuiSlave * parent, QString filename, bool createdatabase ) {
	this->guislave = parent;
	bool import_ok = true;
	last_tag = "";
	if ( !filename.isEmpty() ) {

		if ( parent->mainw->db == NULL )
			parent->newEvent();
		else {
			if ( createdatabase ) {
				while ( parent->closeEvent() != 0 )
					;
				parent->newEvent();
			}
		}

		guislave = parent;
		db = parent->mainw->db;
		mediacount = 0;
		filecount = 0;
		dircount = 0;
		refreshcount = 0;
		linecount = 0;
		lines = 0;


		QApplication::setOverrideCursor( waitCursor );
		guislave->panelsOFF();

		QFile f( filename );
		QTextStream t( &f );	// use a text stream

		if ( f.open( IO_ReadOnly ) ) {
			QString tmp = "";
			while ( !t.eof() ) {
				tmp = t.readLine();
				if ( tmp.contains( "<directory>" ) )
					lines++;
			}

			f.close();
		}

		progress = new QProgressDialog( 0, "progressdialog", true );
		progress->setLabelText( tr( "Importing XML..." ) );
		progress->setCancelButton( 0 );
		progress->setTotalSteps( lines );

		medialines = new QList < lineObject > ();
		medialines->setAutoDelete( TRUE );	// the list owns the objects

		line = "";
		fullpath = "";
		path = "";
		size = 0.0;
		new_medianame = "";
		datetimestring = "";

		// now we need a link to itself :(
		class_link = this;

		/*

		XML_ParserCreate(ISO-8859-1);
		*/

		//char buf[ BUFSIZ ];
		parser = XML_ParserCreate( NULL );
		int done  = 0;
		int depth = 0;
		XML_SetUserData( parser, &depth );
		XML_SetElementHandler( parser, startElement, endElement );
		XML_SetCharacterDataHandler( class_link->parser, getCdata );

		QString document_string = "";
		QByteArray array;
		if ( f.open( IO_ReadOnly ) ) {
			array = f.readAll();
		}
		int len = array.size();

		if (len>0){
			if (! XML_Parse( parser, (char*)array.data(), len, done )) {
				fprintf( stderr,
				         "%s at line %d\n",
				         XML_ErrorString( XML_GetErrorCode( parser ) ),
				         XML_GetCurrentLineNumber( parser ) );
				import_ok = false;
			}
			document_string = "";
		}


		XML_ParserFree( parser );
		// end parse

	} else {
		import_ok = false;
	}

	if ( import_ok ) {

		if ( !medialines->isEmpty() ) {
			addNewMedia( medianame, medialines );
			medialines->clear();
		}

		delete medialines;
		( guislave->mainw->db->getRootNode() ) ->touchDB();
		guislave->panelsON();
		QApplication::restoreOverrideCursor();

		QString msg;
		msg += tr( "XML import was successful." );
		msg += "\n";
		if ( mediacount == 1 )
			msg += tr( "1 media" ) + ",\n";
		else
			msg += QString().setNum( mediacount ) + " " + QString( tr( "media" ) ) + ",\n";

		if ( dircount == 1 )
			msg += QString( tr( "1 directory:,\n" ) );
		else
			msg += QString().setNum( dircount ) + " " + QString( tr( "directories" ) ) + ",\n";

		if ( filecount == 1 )
			msg += tr( "1 File" ) + ",\n";
		else
			msg += QString().setNum( filecount ) + " " + QString( tr( "files" ) ) + "\n";

		msg += tr( "are imported." );

		QMessageBox::information( 0, tr( "Import successful" ), msg );
		progress->hide();

	} else {
		QMessageBox::critical( 0, tr( "parse error" ), tr( "error during parsing" ) );
		QApplication::restoreOverrideCursor();
	} // file dialog canceled

}

importXml::~importXml() {
	delete ( progress );
}

int importXml::addNewItem( QString medianame, QString path, QString filename, float size, QDateTime datetime ) {
	medialines->append( new lineObject( medianame, path, filename, size, datetime ) );

	// QMessageBox::critical( 0, "item", "new item!");
	return 0;

}

int importXml::addNewMedia( QString new_medianame,
                            QList < lineObject > *medialines ) {
	// QMessageBox::critical(0, "media", new_medianame);

	if ( guislave->mainw->db == NULL )
		guislave->newEvent();
	if ( guislave->mainw->db == NULL )
		return 0;

	/* create new media */
	Node *env, *curr;
	curr = db->getMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ) );
	if ( curr == NULL )
		curr = db->putMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ), mediacount, ( ( char* ) ( ( const char * ) tr( "importuser" ) ) ), CD, "" );

	QString msg;
	lineObject *obj;

	for ( obj = medialines->first(); obj; obj = medialines->next() ) {

		env = curr;

		QString path = obj->getPath();

		//        QMessageBox::warning(0, "path", obj->getPath());
		int startindex = 0;
		int dirindex = 0;


		if ( !obj->getPath().isEmpty()) {
			path += "/";
			dirindex = path.find( "/" );
			while ( dirindex != -1 ) {

				QString dir = path.mid( startindex, dirindex - startindex );
				//       QMessageBox::warning(0, "new dir", dir);

				curr = db->getDirectoryNode( env, ( char * ) ( ( const char * ) * new QString( dir ) ) );
				if ( curr == NULL ) {
					curr = db->putDirectoryNode( env, ( char * ) ( ( const char * ) * new QString( dir ) ), getTime( obj->getDateTime() ), "" );
					dircount++;

				}

				startindex = dirindex + 1;
				dirindex = path.find( "/", dirindex + 1 );

				env = curr;

			}
		}
		dirindex = -1;

		uint size = ( uint ) obj->getSize();
		float s;
		int st;

		if ( size > ( uint ) ( 1024 * 1024 * 1024 * 2 ) ) {
			s = ( double ) size / ( double ) ( 1024 * 1024 * 1024 );
			st = GBYTE;
		} else if ( size > ( uint ) ( 1024 * 1024 ) ) {
			s = ( double ) size / ( double ) ( 1024 * 1024 );
			st = MBYTE;
		} else if ( size > ( uint ) 1024 ) {
			s = ( double ) size / ( double ) 1024;
			st = KBYTE;
		} else {
			s = size;
			st = BYTE;
		}

		env = curr;
		curr = db->getFileNode( env, ( ( char * ) ( ( const char* ) * new QString( obj->getFileName() ) ) ) );
		if ( curr == NULL )
			curr = db->putFileNode( env, ( ( char * ) ( ( const char * ) * new QString( obj->getFileName() ) ) ), getTime( obj->getDateTime() ), "", st, s );

		curr = db->getMediaNode( ( char * ) ( ( const char * ) * new QString( new_medianame ) ) );

		filecount++;
	} // over all items in list

	mediacount++;
	refreshcount++;
	if ( refreshcount == 10 ) {
		guislave->mainw->app->processEvents();
		refreshcount = 0;
	}

	return 0;
}


import::import( GuiSlave * parent ) {
	bool createdatabase = false;
	bool correctbadstyle = false;
	QString seperator = ";";
	QString filename;
	int type = -1;
	ImportDialog *d = new ImportDialog( 0 );
	d->exec();

	if ( d->OK == 1 ) {
		seperator = d->seperator;
		filename = d->filename;
		createdatabase = d->newdatabase;
		correctbadstyle=d->correctbadstyle;
		seperator=d->seperator;
		type = d->type;

		delete d;

		if ( type == 0 )
			importCsv import0( parent, seperator, filename, createdatabase, correctbadstyle );
		else if ( type == 1 )
			importXml import1( parent, filename, createdatabase );
		else {
			//		cerr << "wrong type!!!" << endl;
		}
	}
}
