/****************************************************************************
                             Hyper's CD Catalog 
		A multiplatform qt and xml based catalog program
  
 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#include "mainwidget.h"

#include <qvariant.h>
#include <qmenubar.h>
#include <qframe.h>
#include <qheader.h>
#include <qlistview.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qlabel.h>
#include <qfontmetrics.h>
#include <qsplitter.h>

#include "commwidget.h"
#include "hdirview.h"
#include "dbase.h"
#include "guibase.h"
#include "config.h"
#include "icons.h"

/* 
 *  Constructs a CdCatMainWidget as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 */
CdCatMainWidget::CdCatMainWidget( CdCatConfig *ccp,QApplication *appp,QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{

    app = appp;
    
    int fontHeight = (new QFontMetrics(app->font()))->height();
    
    if ( !name )
	setName( "CdCatMainWidget" );
    setIcon( *get_p_icon() );
    
    
    db = NULL;
    cconfig = ccp;
    cconfig->startProgram(&db,this);
    
    splitMain = new QSplitter(this);
    
    Toolbar = new QFrame( this, "Toolbar" );
    Toolbar->setFrameShape( QFrame::StyledPanel );
    Toolbar->setFrameShadow( QFrame::Raised );
    Toolbar->setMaximumHeight(36);
    Toolbar->setMinimumHeight(36);

    ButtonNew = new QToolButton( Toolbar, "ButtonNew" );
    ButtonNew->setPixmap( *get_t_new_icon() );
    ButtonNew->setMaximumSize( 30,30 );

    ButtonOpen = new QToolButton( Toolbar, "ButtonOpen" );
    ButtonOpen->setMaximumSize( 30,30 );
    ButtonOpen->setPixmap( *get_t_open_icon() );

    ButtonSave = new QToolButton( Toolbar, "ButtonSave" );
    ButtonSave->setMaximumSize( 30,30 );
    ButtonSave->setPixmap( *get_t_save_icon() );

    ButtonSaveAs = new QToolButton( Toolbar, "ButtonSaveAs" );
    ButtonSaveAs->setMaximumSize( 30,30 );
    ButtonSaveAs->setPixmap(* get_t_saveas_icon() );

    ButtonClose = new QToolButton( Toolbar, "ButtonClose" );
    ButtonClose->setMaximumSize( 30,30 );
    ButtonClose->setPixmap( *get_t_close_icon() );

    ButtonAdd = new QToolButton( Toolbar, "ButtonAdd" );
    ButtonAdd->setMaximumSize( 30,30 );
    ButtonAdd->setPixmap( *get_t_add_icon() );

    ButtonRescan = new QToolButton( Toolbar, "ButtonRescan" );
    ButtonRescan->setMaximumSize( 30,30 );
    ButtonRescan->setPixmap( *get_t_rescan_icon() );

    ButtonDelete = new QToolButton( Toolbar, "ButtonDelete" );
    ButtonDelete->setMaximumSize( 30,30 );
    ButtonDelete->setPixmap( *get_t_delete_icon() );

    ButtonConfig = new QToolButton( Toolbar, "ButtonConfig" );
    ButtonConfig->setMaximumSize( 30,30 );
    ButtonConfig->setPixmap( *get_t_config_icon() );

    ButtonHelp = new QToolButton( Toolbar, "ButtonHelp" );
    ButtonHelp->setMaximumSize( 30,30 );
    ButtonHelp->setPixmap( *get_t_help_icon() );


    ButtonFind = new QToolButton( Toolbar, "ButtonFind" );
    ButtonFind->setMaximumSize( 30,30 );
    ButtonFind->setPixmap( *get_t_find_icon() );

    ButtonAbout = new QToolButton( Toolbar, "ButtonAbout" );
    ButtonAbout->setMaximumSize( 30,30 );
    ButtonAbout->setPixmap( *get_t_about_icon() );
    
    statusl=new QLabel(tr("No selected item"),this,"statusl");
    statusl->setMaximumHeight(fontHeight+2);


    DirView = new HDirectoryView(&db, splitMain, "DirView" );
    DirView->header()->setLabel( 0, tr( "Directory Tree" ) );

    listView = new HQListView(this, splitMain, "listView" );
    listView->header()->setLabel( 0, tr( "Name" ) );
    listView->header()->setLabel( 1, tr( "Size" ) );
    listView->clear();


    commentWidget = new CommentWidget(app,splitMain,"CoomentWiget");
    
    guis=new GuiSlave(this);
    
    
  /*Menubar*/
    QMenuBar   *mainMenu = new QMenuBar(this,"menu");
    mainMenu->setMaximumHeight(fontHeight*2);
    mainMenu->setMinimumHeight(fontHeight*2);
    QPopupMenu *fileMenu = new QPopupMenu();
    QPopupMenu *editMenu = new QPopupMenu();
    QPopupMenu *inoutMenu = new QPopupMenu();
    QPopupMenu *othersMenu = new QPopupMenu();
    QPopupMenu *helpMenu = new QPopupMenu();


    fileMenu->insertItem(*get_t_new_icon(),tr("New..."),guis,SLOT(newEvent()));
    fileMenu->insertItem(*get_t_open_icon(),tr("Open..."),guis,SLOT(openEvent()));
    fileMenu->insertItem(*get_t_save_icon() ,tr("Save"),guis,SLOT(saveEvent()));
    fileMenu->insertItem(*get_t_saveas_icon() ,tr("Save As..."),guis,SLOT(saveasEvent()));
    fileMenu->insertSeparator ();
    historyMenu = new QPopupMenu();
    fileMenu->insertItem(*get_t_open_icon(),tr("Recent files..."),historyMenu);
    connect( historyMenu, SIGNAL(activated(int)), guis, SLOT(openHistoryElementEvent(int)));

    for(QStringList::Iterator it = cconfig->hlist.begin(); it != cconfig->hlist.end(); ++it){
        if (!QString(*it).isEmpty()){
            historyMenu->insertItem(*get_t_open_icon(),QString(*it));
        }
    }
    fileMenu->insertItem(*get_t_close_icon() ,tr("Close"),guis,SLOT(closeEvent()));
    fileMenu->insertSeparator();
    fileMenu->insertItem(tr("Quit"),this,SLOT(close()));

    editMenu->insertItem(*get_t_add_icon() ,tr("Add media..."),guis,SLOT(addEvent()));
    editMenu->insertItem(*get_t_rescan_icon() ,tr("Rescan media..."),guis,SLOT(rescanEvent()));
    editMenu->insertSeparator();
    editMenu->insertItem(*get_m_import_icon(),tr("Insert Catalog..."),guis,SLOT(insertcEvent()));
    editMenu->insertSeparator();
    editMenu->insertItem(tr("Rename node..."),guis,SLOT(renameEvent()));
    editMenu->insertItem(tr("Re-Number media node..."),guis,SLOT(renumberEvent()));
    editMenu->insertItem(*get_t_delete_icon() ,tr("Delete node"),guis,SLOT(deleteEvent()));
    editMenu->insertSeparator();
    editMenu->insertItem(tr("Sort media by number"),guis,SLOT(sortNuEvent()));
    editMenu->insertItem(tr("Sort media by name"),guis,SLOT(sortNaEvent()));
    editMenu->insertItem(tr("Sort media by type"),guis,SLOT(sortTyEvent()));
    editMenu->insertItem(tr("Sort media by time"),guis,SLOT(sortTiEvent()));
    
    othersMenu->insertItem(*get_t_find_icon(),tr("Seek in database..."),guis,SLOT(findEvent()));
    othersMenu->insertItem(*get_m_borrow_icon(),tr("Borrowing info..."),guis,SLOT(borrowingEvent()));
    othersMenu->insertItem(tr("Node size"),guis,SLOT(sizeEvent()));
    othersMenu->insertItem(*get_t_config_icon() ,tr("Configuration..."),guis,SLOT(configEvent()));

    helpMenu->insertItem(*get_t_help_icon(),tr("Help") ,guis,SLOT(helpEvent()));
    helpMenu->insertItem(*get_t_about_icon(),tr("About"),guis,SLOT(aboutEvent()));

    inoutMenu->insertItem(*get_m_import_icon(),tr("Import database (csv/gtktalog)") ,guis,SLOT(importEvent()));
    inoutMenu->insertItem(*get_m_export_icon(),tr("Export database") ,guis,SLOT(exportEvent()));

    mainMenu->insertItem(tr("Catalog"),fileMenu);
    mainMenu->insertItem(tr("Edit"),editMenu);
    mainMenu->insertItem(tr("Import/Export"),inoutMenu);
    mainMenu->insertItem(tr("Others"),othersMenu);
    mainMenu->insertItem(tr("Help"),helpMenu);
    
    languageChange();

    lvMain   = new QVBoxLayout(this);
    lToolbar = new QHBoxLayout(Toolbar);
    
    lvMain->insertWidget (0,mainMenu,1);
    lvMain->insertWidget (1,Toolbar,1);
    lvMain->insertSpacing(2,4);
    lvMain->insertWidget (3,splitMain,8);
    lvMain->insertSpacing(4,4);
    lvMain->insertWidget (5,statusl,1);
    lvMain->insertSpacing(6,4);
    
    lToolbar->insertSpacing(0,4);
    lToolbar->insertWidget (1,ButtonNew,1);
    lToolbar->insertSpacing(2,2);
    lToolbar->insertWidget (3,ButtonOpen,1);
    lToolbar->insertSpacing(4,2);
    lToolbar->insertWidget (5,ButtonSave,1);
    lToolbar->insertSpacing(6,2);
    lToolbar->insertWidget (7,ButtonSaveAs,1);
    lToolbar->insertSpacing(8,2);
    lToolbar->insertWidget (9,ButtonClose,1);
    lToolbar->insertSpacing(10,16);
    lToolbar->insertWidget (11,ButtonAdd,1);
    lToolbar->insertSpacing(12,2);
    lToolbar->insertWidget (13,ButtonRescan,1);
    lToolbar->insertSpacing(14,2);
    lToolbar->insertWidget (15,ButtonDelete,1);
    lToolbar->insertSpacing(16,15);
    lToolbar->insertWidget (17,ButtonFind,1);
    lToolbar->insertSpacing(18,15);
    lToolbar->insertWidget (19,ButtonConfig,1);
    lToolbar->insertSpacing(20,8);
    lToolbar->insertStretch(21);
    lToolbar->insertSpacing(22,8);        
    lToolbar->insertWidget (23,ButtonHelp,1);
    lToolbar->insertSpacing(24,2);
    lToolbar->insertWidget (25,ButtonAbout,1);
    lToolbar->insertSpacing(26,4); 

    resize( (cconfig->windowSize).expandedTo(minimumSizeHint()) );
    
    move  (  cconfig->windowPos );
   
    QValueList<int> splitterSizesList;
    splitterSizesList.append( cconfig->mainP1 );
    splitterSizesList.append( cconfig->mainP2 ); // remaining space for listView
    splitterSizesList.append( cconfig->mainP3 );
			    
    splitMain->setSizes( splitterSizesList );
    splitMain->setResizeMode( DirView, QSplitter::Stretch );
    splitMain->setResizeMode( listView, QSplitter::Stretch );


    connect(DirView ,SIGNAL(folderSelected(const QString&)),guis,SLOT(listUpdate(const QString&)));
    connect(DirView ,SIGNAL(hitkey(QKeyEvent *)),guis,SLOT(hotKeys(QKeyEvent *)));
    connect(DirView,SIGNAL(rightButtonPressed (QListViewItem *, const QPoint&, int)),
             guis,SLOT(showTreeContextMenu(QListViewItem *, const QPoint &, int)));
    connect(listView,SIGNAL(rightButtonClicked (QListViewItem *, const QPoint &, int)),
             guis,SLOT(showListviewContextMenu(QListViewItem *, const QPoint &, int)));
    
    
    connect(listView,SIGNAL(currentChanged(QListViewItem *)),guis,SLOT(standOn(QListViewItem *)));
    connect(listView,SIGNAL(clicked(QListViewItem *)),guis,SLOT(standOn(QListViewItem *)));
    connect(listView,SIGNAL(doubleClicked(QListViewItem *)),guis,SLOT(doubleClickOn(QListViewItem *)));    

    connect(ButtonNew   ,SIGNAL(clicked()),guis,SLOT(newEvent   ()));     
    connect(ButtonOpen  ,SIGNAL(clicked()),guis,SLOT(openEvent  ()));         
    connect(ButtonSave  ,SIGNAL(clicked()),guis,SLOT(saveEvent  ()));
    connect(ButtonSaveAs,SIGNAL(clicked()),guis,SLOT(saveasEvent()));         
    connect(ButtonClose ,SIGNAL(clicked()),guis,SLOT(closeEvent ()));
    connect(ButtonAdd   ,SIGNAL(clicked()),guis,SLOT(addEvent   ()));         
    connect(ButtonDelete,SIGNAL(clicked()),guis,SLOT(deleteEvent()));
    connect(ButtonRescan,SIGNAL(clicked()),guis,SLOT(rescanEvent()));         
    connect(ButtonFind  ,SIGNAL(clicked()),guis,SLOT(findEvent  ()));
    connect(ButtonConfig,SIGNAL(clicked()),guis,SLOT(configEvent()));         
    connect(ButtonHelp  ,SIGNAL(clicked()),guis,SLOT(helpEvent  ()));
    connect(ButtonAbout ,SIGNAL(clicked()),guis,SLOT(aboutEvent ()));         
    
    connect(commentWidget ,SIGNAL(touchdb()),guis,SLOT(cHcaption()));         

    listView ->setFocus();
    
    if(cconfig->autoload)
     guis->checkversion(this,db);

}

/*
 *  Destroys the object and frees any allocated resources
 */
CdCatMainWidget::~CdCatMainWidget()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CdCatMainWidget::languageChange()
{
    setCaption( tr( "Hyper's CD Catalogizer" ) );
    ButtonOpen->setText( QString::null );
    QToolTip::add( ButtonOpen, tr( "Open a catalog from a file." ) );
    ButtonSave->setText( QString::null );
    QToolTip::add( ButtonSave, tr( "Save all modifications to the disc." ) );
    ButtonSaveAs->setText( QString::null );
    QToolTip::add( ButtonSaveAs, tr( "Save the catalog to a new file." ) );
    ButtonClose->setText( QString::null );
    QToolTip::add( ButtonClose, tr( "Close the actual catalog." ) );
    QWhatsThis::add( ButtonClose, QString::null );
    ButtonAdd->setText( QString::null );
    QToolTip::add( ButtonAdd, tr( "Add a new media to the catalog." ) );
    ButtonRescan->setText( QString::null );
    QToolTip::add( ButtonRescan, tr( "Rescan the selected media from the disk." ) );
    ButtonDelete->setText( QString::null );
    QToolTip::add( ButtonDelete, tr( "Delete the selected media from the catalog." ) );
    ButtonConfig->setText( QString::null );
    QToolTip::add( ButtonConfig, tr( "Configuration of the program." ) );
    ButtonHelp->setText( QString::null );
    QToolTip::add( ButtonHelp, tr( "Help" ) );
    ButtonNew->setText( QString::null );
    QToolTip::add( ButtonNew, tr( "Create a new, empty catalog and close the previous." ) );
    ButtonFind->setText( QString::null );
    QToolTip::add( ButtonFind, tr( "Search an element in the database(catalog).You can search filenames, directory names, name parts or mp3 tags etc..." ) );
    QWhatsThis::add( ButtonFind, tr( "Search an element." ) );
    ButtonAbout->setText( QString::null );
    QToolTip::add( ButtonAbout, tr( "About" ) );

}

void CdCatMainWidget::closeEvent(QCloseEvent *e)
 {
  
 // An error occured during the REQUISTED saving of the database 
 // (eg: access denied for writing...)
  if(guis->closeEvent() != 0) 
   return;
  
  cconfig->windowSize = size();
  cconfig->windowPos  =  pos();
  cconfig->mainP1 = (splitMain->sizes())[0];
  cconfig->mainP2 = (splitMain->sizes())[1];
  cconfig->mainP3 = (splitMain->sizes())[2];
  
  cconfig->writeConfig();
  QWidget::closeEvent(e);
 }
