/*
 * prepare.c
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2005-07-01 20:21:31 +0200 (Fr, 01 Jul 2005) $
 * $LastChangedRevision: 1007 $
 */

#include <config.h>

#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "execute.h"
#include "install.h"
#include "prepare.h"

int prepare_download (void)
{
  int ret = 0;
  ret |= prepare_dir ("/var/cache/bootstrap");
  return ret != 0;
}

int prepare_install (void)
{
  int ret = 0;
  ret |= prepare_dir ("/var/lib/dpkg");
  ret |= prepare_file ("/var/lib/dpkg/available");
  ret |= prepare_file ("/var/lib/dpkg/diversions");
  ret |= prepare_file ("/var/lib/dpkg/status");
  ret |= prepare_dir ("/var/log");
  return ret != 0;
}

int prepare_dir (const char *dir)
{
  char buf[PATH_MAX];
  struct stat statbuf;
  snprintf (buf, sizeof (buf), "%s/%s", install_root, dir);
  if (!stat (buf, &statbuf))
    return 0;
  snprintf (buf, sizeof (buf), "mkdir -p %s/%s", install_root, dir);
  return execute (buf);
}

int prepare_file (const char *file)
{
  char buf[PATH_MAX];
  int fd;
  snprintf (buf, sizeof (buf), "%s/%s", install_root, file);
  fd = open (buf, O_WRONLY | O_CREAT | O_TRUNC);
  if (fd < 0)
    return 1;
  close (fd);
  return 0;
}
