#ifndef _TABLE_H
#define _TABLE_H

static PAR echam4[] = {
  {   4, "precip",      "total precipitation",                      "m/s"      },
  {  34, "low_cld",     "low cloud",                                 NULL      },
  {  35, "mid_cld",     "mid cloud",                                 NULL      },
  {  36, "hih_cld",     "high cloud",                                NULL      },
  { 129, "geosp",       "surface geopotential (orography)",         "m^2/s^2"  },
  { 130, "t",           "temperature",                              "K"        },
  { 131, "u",           "u-velocity",                               "m/s"      },
  { 132, "v",           "v-velocity",                               "m/s"      },
  { 133, "sq",          "specific humidity",                        "kg/kg"    },
  { 134, "aps",         "Surface pressure",                         "Pa"       },
  { 135, "omega",       "vertical velocity",                        "Pa/s"     },
  { 138, "svo",         "vorticity",                                "1/s"      },
  { 139, "ts",          "surface temperature",                      "K"        },
  { 140, "ws",          "soil wetness",                             "m"        },
  { 141, "sn",          "snow depth",                               "m"        },
  { 142, "aprl",        "large scale precipitation",                "m/s"      },
  { 143, "aprc",        "convective  precipitation",                "m/s"      },
  { 144, "aprs",        "snow fall",                                "m/s"      },
  { 145, "vdis",        "boundary layer dissipation",               "W/m^2"    },
  { 146, "ahfs",        "surface sensible heat flux",               "W/m^2"    },
  { 147, "ahfl",        "surface latent heat flux",                 "W/m^2"    },
  { 148, "stream",      "streamfunction",                           "m^2/s"    },
  { 149, "velopot",     "velocity potential",                       "m^2/s"    },
  { 151, "slp",         "mean sea level pressure",                  "Pa"       },
  { 152, "lsp",         "log surface pressure",                      NULL      },
  { 153, "sx",          "liquid water content",                     "kg/kg"    },
  { 155, "sd",          "divergence",                               "1/s"      },
  { 156, "geopoth",     "geopotential height",                      "m"        },
  { 157, "rhumidity",   "relative humidity",                        "fraction" },
  { 158, "var158",      "tendency of surface pressure",             "Pa/s"     },
  { 159, "ustar3",      "ustar3",                                   "m^3/s^3"  },
  { 160, "runoff",      "surface runoff",                           "m/s"      },
  { 161, "alwc",        "liquid water content",                     "kg/kg"    },
  { 162, "aclc",        "cloud cover",                              "fraction" },
  { 163, "aclcv",       "total cloud cover",                        "fraction" },
  { 164, "aclcov",      "total cloud cover",                        "fraction" },
  { 165, "u10",         "10m u-velocity",                           "m/s"      },
  { 166, "v10",         "10m v-velocity",                           "m/s"      },
  { 167, "temp2",       "2m temperature",                           "K"        },
  { 168, "dew2",        "2m dew point temperature",                 "K"        },
  { 169, "tsurf",       "surface temperature",                      "K"        },
  { 170, "td",          "deep soil temperature",                    "K"        },
  { 171, "wind10",      "10m windspeed",                            "m/s"      },
  { 172, "slm",         "land sea mask",                            "fraction" },
  { 173, "az0",         "surface roughness length",                 "m"        },
  { 174, "alb",         "surface background albedo",                "fraction" },
  { 175, "albedo",      "surface albedo",                           "fraction" },
  { 176, "srads",       "net surface solar radiation",              "W/m^2"    },
  { 177, "trads",       "net surface thermal radiation",            "W/m^2"    },
  { 178, "srad0",       "net top solar radiation",                  "W/m^2"    },
  { 179, "trad0",       "top thermal radiation (OLR)",              "W/m^2"    },
  { 180, "ustr",        "surface u-stress",                         "Pa"       },
  { 181, "vstr",        "surface v-stress",                         "Pa"       },
  { 182, "evap",        "surface evaporation",                      "m/s"      },
  { 183, "tdcl",        "soil temperature",                         "K"        },
  { 185, "srafs",       "net surf. solar radiation   (clear sky)",  "W/m^2"    },
  { 186, "trafs",       "net surf. thermal radiation (clear sky)",  "W/m^2"    },
  { 187, "sraf0",       "net top solar radiation     (clear sky)",  "W/m^2"    },
  { 188, "traf0",       "net top thermal radiation   (clear sky)",  "W/m^2"    },
  { 189, "sclfs",       "surface solar cloud forcing",              "W/m^2"    },
  { 190, "tclfs",       "surface thermal cloud forcing",            "W/m^2"    },
  { 191, "sclf0",       "top solar cloud forcing",                  "W/m^2"    },
  { 192, "tclf0",       "top thermal cloud forcing",                "W/m^2"    },
  { 193, "wl",          "skin reservoir content",                   "m"        },
  { 194, "wlm1",        "skin reservoir content of plants",         "m"        },
  { 195, "ustrgw",      "u-gravity wave stress",                    "Pa"       },
  { 196, "vstrgw",      "v-gravity wave stress",                    "Pa"       },
  { 197, "vdisgw",      "gravity wave dissipation",                 "W/m^2"    },
  { 198, "vgrat",       "vegetation ratio",                         "fraction" },
  { 199, "varor",       "orographic variance",                      "m^2"      },
  { 200, "vlt",         "leaf area index",                           NULL      },
  { 201, "t2max",       "maximum 2m-temperature",                   "K"        },
  { 202, "t2min",       "minimum 2m-temperature",                   "K"        },
  { 203, "srad0u",      "top solar radiation upward",               "W/m^2"    },
  { 204, "sradsu",      "surface solar radiation upward",           "W/m^2"    },
  { 205, "tradsu",      "surface thermal radiation upward",         "W/m^2"    },
  { 206, "tsn",         "snow temperature",                         "K"        },
  { 207, "td3",         "soil temperature 3",                       "K"        },
  { 208, "td4",         "soil temperature 4",                       "K"        },
  { 209, "td5",         "soil temperature 5",                       "K"        },
  { 210, "seaice",      "sea ice cover",                            "fraction" },
  { 211, "siced",       "sea ice depth",                            "m"        },
  { 212, "forest",      "vegetation type",                          "fraction" },
  { 213, "teff",        "(effective) sea-ice skin temperature",     "K"        },
  { 214, "tsmax",       "maximum surface temperature",              "K"        },
  { 215, "tsmin",       "minimum surface temperature",              "K"        },
  { 216, "wimax",       "maximum 10m-wind speed",                   "m/s"      },
  { 217, "topmax",      "maximum height of convective cloud tops",  "Pa"       },
  { 218, "snmel",       "snow melt",                                "m/s"      },
  { 219, "runtoc",      "surface runoff into ocean",                 NULL      },
  { 220, "tslin",       "land: residual surface heat budget",       "W/m^2"    },
  { 221, "dsnac",       "snow depth change",                        "m/s"      },
  { 222, "alwcac",      "liquid water content",                     "kg/kg"    },
  { 223, "aclcac",      "cloud cover",                              "fraction" },
  { 224, "tke",         "turbulent kinetic energy",                  NULL      },
  { 225, "tkem1",       "turbulent kinetic energy (t-1)",            NULL      },
  { 226, "fao",         "FAO data set (soil data flags)",            NULL      },
  { 227, "rgcgn",       "heat capacity of soil",                     NULL      },
  { 228, "sodif",       "soil diffusivity",                          NULL      },
  { 229, "wsmx",        "field capacity of soil",                   "m"        },
  { 230, "qvi",         "vertically integrated specific humidity",  "kg/m^2"   },
  { 231, "alwcvi",      "vertically integrated liquid water cont.", "kg/m^2"   },
  { 232, "glac",        "glacier mask",                             "fraction" },
  { 233, "runlnd",      "surface runoff not running into ocean",     NULL      },
  { 259, "windspeed",   "windspeed (sqrt(u^2+v^2))",                 NULL      },
  { 260, "precip",      "total precipitation",                      "m/s"      },
  { 261, "net_top",     "total top radiation",                       NULL      },
  { 262, "net_bot",     "total surface radiation",                   NULL      },
  { 263, "net_heat",    "net surface heat flux",                     NULL      },
  { 264, "net_water",   "total surface water",                       NULL      },
  { 268, "sw_atm",       NULL,                                       NULL      },
  { 269, "lw_atm",       NULL,                                       NULL      },
  { 270, "net_atm",      NULL,                                       NULL      },
  { 271, "surf_runoff", "surface runoff",                            NULL      },
  { 275, "fresh_water",  NULL,                                       NULL      },
};

static PAR echam5[] = {
  {   4, "precip",     "total precipitation",                       "kg/m^2s" },
  {  79, "swnirac",    "net surface NIR flux acc.",                 "W/m^2"   },
  {  80, "swdifnirac", "fraction of diffuse NIR acc.",              "W/m^2"   },
  {  81, "swvisac",    "net surface visible flux acc.",             "W/m^2"   },
  {  82, "swdifvisac", "fraction of diffuse visible acc.",          "W/m^2"   },
  {  83, "ocu",        "ocean eastw. velocity (coupled mode)",      "m/s"     },
  {  84, "ocv",        "ocean northw. velocity (coupled mode)",     "m/s"     },
  {  85, "tradl",      "net LW radiation 200mb",                    "W/m^2"   },
  {  86, "sradl",      "net SW radiation 200mb",                    "W/m^2"   },
  {  87, "trafl",      "net LW radiation 200mb (clear sky)",        "W/m^2"   },
  {  88, "srafl",      "net SW radiation 200mb (clear sky)",        "W/m^2"   },
  {  89, "amlcorac",   "mixed layer flux correction",               "W/m^2"   },
  {  90, "amlheatac",  "mixed layer heat content",                  "J/m^2"   },
  {  91, "trfliac",    "net LW radiation over ice",                 "W/m^2"   },
  {  92, "trflwac",    "net LW radiation over water",               "W/m^2"   },
  {  93, "trfllac",    "net LW radiation over land",                "W/m^2"   },
  {  94, "sofliac",    "net SW radiation over ice",                 "W/m^2"   },
  {  95, "soflwac",    "net SW radiation over water",               "W/m^2"   },
  {  96, "sofllac",    "net SW radiation over land",                "W/m^2"   },
  {  97, "friac",      "ice cover (fraction of grid box)",           NULL     },
  { 102, "tsi",        "surface temperature of ice",                "K"       },
  { 103, "tsw",        "surface temperature of water",              "K"       },
  { 104, "ustri",      "zonal      wind stress over ice",           "Pa"      },
  { 105, "vstri",      "meridional wind stress over ice",           "Pa"      },
  { 106, "ustrw",      "zonal      wind stress over water",         "Pa"      },
  { 107, "vstrw",      "meridional wind stress over water",         "Pa"      },
  { 108, "ustrl",      "zonal      wind stress over land",          "Pa"      },
  { 109, "vstrl",      "meridional wind stress over land",          "Pa"      },
  { 110, "ahfliac",    "latent heat flux over ice",                 "W/m^2"   },
  { 111, "ahflwac",    "latent heat flux over water",               "W/m^2"   },
  { 112, "ahfllac",    "latent heat flux over land",                "W/m^2"   },
  { 113, "evapiac",    "evaporation over ice",                      "kg/m^2s" },
  { 114, "evapwac",    "evaporation over water",                    "kg/m^2s" },
  { 115, "evaplac",    "evaporation over land",                     "kg/m^2s" },
  { 116, "az0i",       "roughness length over ice",                 "m"       },
  { 117, "az0w",       "roughness length over water",               "m"       },
  { 118, "az0l",       "roughness length over land",                "m"       },
  { 119, "ahfsiac",    "sensible heat flux over ice",               "W/m^2"   },
  { 120, "ahfswac",    "sensible heat flux over water",             "W/m^2"   },
  { 121, "ahfslac",    "sensible heat flux over land",              "W/m^2"   },
  { 122, "alsoi",      "albedo of ice",                              NULL     },
  { 123, "alsow",      "albedo of water",                            NULL     },
  { 124, "alsol",      "albedo of land",                             NULL     },
  { 125, "ahfice",     "conductive heat flux through ice",          "W/m^2"   },
  { 126, "qres",       "residual heat flux for melting sea ice",    "W/m^2"   },
  { 127, "alake",      "lake fraction",                              NULL     },
  { 128, "rintop",     "low level inversion",                        NULL     },
  { 129, "geosp",      "surface geopotential (orography)",          "m^2/s^2" },
  { 130, "t",          "temperature",                               "K"       },
  { 131, "u",          "u-velocity",                                "m/s"     },
  { 132, "v",          "v-velocity",                                "m/s"     },
  { 133, "q",          "specific humidity",                         "kg/kg"   },
  { 134, "aps",        "surface pressure",                          "Pa"      },
  { 135, "omega",      "vertical velocity",                         "Pa/s"    },
  { 136, "acdnc",      "cloud droplet number concentration",        "1/m^3"   },
  { 137, "apmeb",      "(P-E) error",                               "kg/m^2s" },
  { 138, "svo",        "vorticity",                                 "1/s"     },
  { 139, "tslm1",      "surface temperature of land",               "K"       },
  { 140, "ws",         "soil wetness",                              "m"       },
  { 141, "sn",         "water equivalent snow depth",               "m"       },
  { 142, "aprl",       "large scale precipitation",                 "kg/m^2s" },
  { 143, "aprc",       "convective  precipitation",                 "kg/m^2s" },
  { 144, "aprs",       "snow fall",                                 "kg/m^2s" },
  { 145, "vdis",       "boundary layer dissipation",                "W/m^2"   },
  { 146, "ahfs",       "sensible heat flux",                        "W/m^2"   },
  { 147, "ahfl",       "latent heat flux",                          "W/m^2"   },
  { 148, "stream",     "streamfunction",                            "m^2/s"   },
  { 149, "velopot",    "velocity potential",                        "m^2/s"   },
  { 150, "xivi",       "vertically integrated cloud ice",           "kg/m^2"  },
  { 151, "slp",        "mean sea level pressure",                   "Pa"      },
  { 152, "lsp",        "log surface pressure",                       NULL     },
  { 153, "xl",         "cloud water",                               "kg/kg"   },
  { 154, "xi",         "cloud ice",                                 "kg/kg"   },
  { 155, "sd",         "divergence",                                "1/s"     },
  { 156, "geopoth",    "geopotential height",                       "m"       },
  { 157, "rhumidity",  "relative humidity",                          NULL     },
  { 159, "wind10w",    "10m windspeed over water",                  "m/s"     },
  { 160, "runoff",     "surface runoff and drainage",               "kg/m^2s" },
  { 161, "drain",      "drainage",                                  "kg/m^2s" },
  { 162, "aclc",       "cloud cover",                                NULL     },
  { 164, "aclcov",     "total cloud cover",                          NULL     },
  { 165, "u10",        "10m u-velocity",                            "m/s"     },
  { 166, "v10",        "10m v-velocity",                            "m/s"     },
  { 167, "temp2",      "2m temperature",                            "K"       },
  { 168, "dew2",       "2m dew point temperature",                  "K"       },
  { 169, "tsurf",      "surface temperature",                       "K"       },
  { 170, "xvar",       "variance of total water amount",            "kg/kg"   },
  { 171, "wind10",     "10m windspeed",                             "m/s"     },
  { 172, "slm",        "land sea mask (1. = land, 0. = sea/lakes)",  NULL     },
  { 173, "az0",        "roughness length",                          "m"       },
  { 174, "alb",        "surface background albedo",                  NULL     },
  { 175, "albedo",     "surface albedo",                             NULL     },
  { 176, "srads",      "net surface SW radiation",                  "W/m^2"   },
  { 177, "trads",      "net surface LW radiation",                  "W/m^2"   },
  { 178, "srad0",      "net top SW radiation",                      "W/m^2"   },
  { 179, "trad0",      "net top LW radiation (-OLR)",               "W/m^2"   },
  { 180, "ustr",       "u-stress",                                  "Pa"      },
  { 181, "vstr",       "v-stress",                                  "Pa"      },
  { 182, "evap",       "evaporation",                               "kg/m^2s" },
  { 183, "xskew",      "skewness of total water amount qv+qi+ql",    NULL     },
  { 184, "srad0d",     "top incoming SW radiation",                 "W/m^2"   },
  { 185, "srafs",      "net surface SW radiation (clear sky)",      "W/m^2"   },
  { 186, "trafs",      "net surface LW radiation (clear sky)",      "W/m^2"   },
  { 187, "sraf0",      "net top SW radiation   (clear sky)",        "W/m^2"   },
  { 188, "traf0",      "net top LW radiation   (clear sky)",        "W/m^2"   },
  { 189, "sclfs",      "net surface SW cloud forcing (176-185)",    "W/m^2"   },
  { 190, "tclfs",      "net surface LW cloud forcing (177-186)",    "W/m^2"   },
  { 191, "sclf0",      "net SW top cloud forcing (178-187)",        "W/m^2"   },
  { 192, "tclf0",      "net LW top cloud forcing (179-188)",        "W/m^2"   },
  { 193, "wl",         "skin reservoir content",                    "m"       },
  { 194, "slf",        "fractional land cover",                      NULL     },
  { 195, "ustrgw",     "u-gravity wave stress",                     "Pa"      },
  { 196, "vstrgw",     "v-gravity wave stress",                     "Pa"      },
  { 197, "vdisgw",     "gravity wave dissipation",                  "W/m^2"   },
  { 198, "vgrat",      "vegetation ratio",                           NULL     },
  { 199, "orostd",     "orographic standard deviation",             "m"       },
  { 200, "vlt",        "leaf area index",                            NULL     },
  { 201, "t2max",      "maximum 2m-temperature",                    "K"       },
  { 202, "t2min",      "minimum 2m-temperature",                    "K"       },
  { 203, "srad0u",     "top SW radiation upward",                   "W/m^2"   },
  { 204, "sradsu",     "surface SW radiation upward",               "W/m^2"   },
  { 205, "tradsu",     "surface LW radiation upward",               "W/m^2"   },
  { 206, "grndflux",   "surface ground heat flux",                   NULL     },
  { 207, "tsoil",      "deep soil temperatures (5 layers)",         "K"       },
  { 208, "ahfcon",     "conductive heat flux through ice",          "W/m^2"   },
  { 209, "ahfres",     "res. heat flux for melting ice",            "W/m^2"   },
  { 210, "seaice",     "ice cover (fraction of ice+water)",          NULL     },
  { 211, "siced",      "ice thickness",                             "m"       },
  { 212, "forest",     "forest fraction",                            NULL     },
  { 213, "gld",        "glacier thickness",                         "m"       },
  { 214, "sni",        "water equivalent of snow on ice",           "m"       },
  { 215, "rogl",       "glacier runoff",                            "kg/m^2s" },
  { 216, "wimax",      "maximum 10m-wind speed",                    "m/s"     },
  { 217, "topmax",     "maximum height of convective cloud tops",   "Pa"      },
  { 218, "snmel",      "snow melt",                                 "kg/m^2s" },
  { 219, "runtoc",     "surface runoff into ocean",                 "kg/m^2s" },
  { 220, "runlnd",     "surface runoff not running into ocean",     "kg/m^2s" },
  { 221, "apmegl",     "P-E over land ice",                         "kg/m^2s" },
  { 222, "snacl",      "snow accumulation over land",               "kg/m^2s" },
  { 223, "aclcac",     "cloud cover",                                NULL     },
  { 224, "tke",        "turbulent kinetic energy",                  "m^2/s^2" },
  { 225, "tkem1",      "turbulent kinetic energy (t-1)",            "m^2/s^2" },
  { 226, "fao",        "FAO data set (soil data flags) 0...5",       NULL     },
  { 227, "rgcgn",      "heat capacity of soil",                      NULL     },
  { 228, "sodif",      "soil diffusivity",                          "m^2/s"   },
  { 229, "wsmx",       "field capacity of soil",                    "m"       },
  { 230, "qvi",        "vertically integrated water vapor",         "kg/m^2"  },
  { 231, "xlvi",       "vertically integrated cloud water",         "kg/m^2"  },
  { 232, "glac",       "fraction of land covered by glaciers",       NULL     },
  { 233, "snc",        "snow depth at the canopy",                  "m"       },
  { 234, "rtype",      "type of convection",                        "0...3"   },
  { 235, "abso4",      "anthropogenic sulfur burden",               "kg/m^2"  },
  { 236, "ao3",        "ipcc ozone",                                "kg/m^2"  },
  { 237, "tropo",      "WMO defined tropopause height",             "Pa"      },
  { 259, "windspeed",  "windspeed (sqrt(u^2+v^2))",                 "m/s"     },
  { 260, "precip",     "total precipitation  (142+143)",            "kg/m^2s" },
  { 261, "net_top",    "total top radiation  (178+179)",            "W/m^2"   },
  { 262, "net_bot",    "total surface radiation (176+177)",         "W/m^2"   },
  { 272, "mastrfu",    "mass stream function",                      "kg/s"    },
};

static PAR echam6[] = {
  {   4, "precip",         "total precipitation",                       "kg/m^2s"  },
  {  34, "low_cld",        "low cloud",                                  NULL      },
  {  35, "mid_cld",        "mid cloud",                                  NULL      },
  {  36, "hih_cld",        "high cloud",                                 NULL      },
  {  68, "fage",           "aging factor of snow on ice",                NULL      },
  {  69, "snifrac",        "fraction of ice covered with snow",          NULL      },
  {  70, "barefrac",       "bare ice fraction",                          NULL      },
  {  71, "alsom",          "albedo of melt ponds",                       NULL      },
  {  72, "alsobs",         "albedo of bare ice and snow",                NULL      },
  {  73, "sicepdw",        "melt pond depth on sea-ice",                "m"        },
  {  74, "sicepdi",        "ice thickness on melt pond",                "m"        },
  {  75, "tsicepdi",       "ice temperature on frozen melt pond",       "K"        },
  {  76, "sicepres",       "residual heat flux",                        "W/m**2"   },
  {  77, "ameltdepth",     "total melt pond depth",                     "m"        },
  {  78, "ameltfrac",      "fractional area of melt ponds on sea-ice",   NULL      },
  {  79, "albedo_vis_dir", "surface albedo visible range direct",        NULL      },
  {  80, "albedo_nir_dir", "surface albedo NIR range direct",            NULL      },
  {  81, "albedo_vis_dif", "surface albedo visible range diffuse",       NULL      },
  {  82, "albedo_nir_dif", "surface albedo NIR range diffuse",           NULL      },
  {  83, "ocu",            "ocean eastw. velocity (coupled mode)",      "m/s"      },
  {  84, "ocv",            "ocean northw. velocity (coupled mode)",     "m/s"      },
  {  85, "tradl",          "thermal radiation 200mb",                   "W/m**2"   },
  {  86, "sradl",          "solar radiation 200mb",                     "W/m**2"   },
  {  87, "trafl",          "thermal radiation 200mb (clear sky)",       "W/m**2"   },
  {  88, "srafl",          "solar radiation 200mb (clear sky)",         "W/m**2"   },
  {  89, "amlcorac",       "mixed layer flux correction",               "W/m**2"   },
  {  90, "amlheatac",      "mixed layer heat content",                  "J/m**2"   },
  {  91, "trfliac",        "LW flux over ice",                          "W/m^2"    },
  {  92, "trflwac",        "LW flux over water",                        "W/m^2"    },
  {  93, "trfllac",        "LW flux over land",                         "W/m^2"    },
  {  94, "sofliac",        "SW flux over ice",                          "W/m^2"    },
  {  95, "soflwac",        "SW flux over water",                        "W/m^2"    },
  {  96, "sofllac",        "SW flux over land",                         "W/m^2"    },
  {  97, "friac",          "ice cover (fraction of grid box)",           NULL      },
  { 102, "tsi",            "surface temperature of ice",                "K"        },
  { 103, "tsw",            "surface temperature of water",              "K"        },
  { 104, "ustri",          "zonal      wind stress over ice",           "Pa"       },
  { 105, "vstri",          "meridional wind stress over ice",           "Pa"       },
  { 106, "ustrw",          "zonal      wind stress over water",         "Pa"       },
  { 107, "vstrw",          "meridional wind stress over water",         "Pa"       },
  { 108, "ustrl",          "zonal      wind stress over land",          "Pa"       },
  { 109, "vstrl",          "meridional wind stress over land",          "Pa"       },
  { 110, "ahfliac",        "latent heat flux over ice",                 "W/m^2"    },
  { 111, "ahflwac",        "latent heat flux over water",               "W/m^2"    },
  { 112, "ahfllac",        "latent heat flux over land",                "W/m^2"    },
  { 113, "evapiac",        "evaporation over ice",                      "kg/m^2s"  },
  { 114, "evapwac",        "evaporation over water",                    "kg/m^2s"  },
  { 115, "evaplac",        "evaporation over land",                     "kg/m^2s"  },
  { 116, "az0i",           "roughness length over ice",                 "m"        },
  { 117, "az0w",           "roughness length over water",               "m"        },
  { 118, "az0l",           "roughness length over land",                "m"        },
  { 119, "ahfsiac",        "sensible heat flux over ice",               "W/m^2"    },
  { 120, "ahfswac",        "sensible heat flux over water",             "W/m^2"    },
  { 121, "ahfslac",        "sensible heat flux over land",              "W/m^2"    },
  { 122, "alsoi",          "albedo of ice",                              NULL      },
  { 123, "alsow",          "albedo of water",                            NULL      },
  { 124, "alsol",          "albedo of land",                             NULL      },
  { 125, "ahfice",         "conductive heat flux",                      "W/m^2"    },
  { 126, "qres",           "residual heat flux for melting sea ice",    "W/m^2"    },
  { 127, "alake",          "lake fraction of grid box",                 "fraction" },
  { 128, "rintop",         "low level inversion",                        NULL      },
  { 129, "geosp",          "surface geopotential (orography)",          "m^2/s^2"  },
  { 130, "t",              "temperature",                               "K"        },
  { 131, "u",              "u-velocity",                                "m/s"      },
  { 132, "v",              "v-velocity",                                "m/s"      },
  { 133, "q",              "specific humidity",                         "kg/kg"    },
  { 134, "aps",            "surface pressure",                          "Pa"       },
  { 135, "omega",          "vertical velocity",                         "Pa/s"     },
  { 136, "acdnc",          "cloud droplet number concentration",        "1/m^3"    },
  { 137, "apmeb",          "vert. integr. tendencies of water",         "kg/m^2s"  },
  { 138, "svo",            "vorticity",                                 "1/s"      },
  { 139, "tslm1",          "surface temperature of land",               "K"        },
  { 140, "ws",             "soil wetness",                              "m"        },
  { 141, "sn",             "snow depth",                                "m"        },
  { 142, "aprl",           "large scale precipitation",                 "kg/m^2s"  },
  { 143, "aprc",           "convective  precipitation",                 "kg/m^2s"  },
  { 144, "aprs",           "snow fall",                                 "kg/m^2s"  },
  { 145, "vdis",           "boundary layer dissipation",                "W/m^2"    },
  { 146, "ahfs",           "sensible heat flux",                        "W/m^2"    },
  { 147, "ahfl",           "latent heat flux",                          "W/m^2"    },
  { 148, "stream",         "streamfunction",                            "m^2/s"    },
  { 149, "velopot",        "velocity potential",                        "m^2/s"    },
  { 150, "xivi",           "vertically integrated cloud ice",           "kg/m^2"   },
  { 151, "slp",            "mean sea level pressure",                   "Pa"       },
  { 152, "stp(20)",        "log surface pressure",                       NULL      },
  { 153, "xl",             "cloud water",                               "kg/kg"    },
  { 154, "xi",             "cloud ice",                                 "kg/kg"    },
  { 155, "sd",             "divergence",                                "1/s"      },
  { 156, "geopoth",        "geopotential height",                       "m"        },
  { 157, "rhumidity",      "relative humidity",                         "fraction" },
  { 158, "var158",         "tendency of surface pressure",              "Pa/s"     },
  { 159, "wind10w",        "10m windspeed over water",                  "m/s"      },
  { 160, "runoff",         "surface runoff and drainage",               "kg/m^2s"  },
  { 161, "drain",          "drainage",                                  "kg/m^2s"  },
  { 162, "aclc",           "cloud cover",                                NULL      },
  { 163, "aclcv",          "total cloud cover",                          NULL      },
  { 164, "aclcov",         "total cloud cover (mean)",                   NULL      },
  { 165, "u10",            "10m u-velocity",                            "m/s"      },
  { 166, "v10",            "10m v-velocity",                            "m/s"      },
  { 167, "temp2",          "2m temperature",                            "K"        },
  { 168, "dew2",           "2m dew point temperature",                  "K"        },
  { 169, "tsurf",          "surface temperature",                       "K"        },
  { 170, "xvar",           "variance of total water amount qv+qi+ql",   "kg/kg"    },
  { 171, "wind10",         "10m windspeed",                             "m/s"      },
  { 172, "slm",            "land sea mask (1. = land, 0. = sea/lakes)",  NULL      },
  { 173, "az0",            "roughness length",                          "m"        },
  { 174, "alb",            "surface background albedo",                  NULL      },
  { 175, "albedo",         "surface albedo",                             NULL      },
  { 176, "srads",          "net surface solar radiation",               "W/m^2"    },
  { 177, "trads",          "net surface thermal radiation",             "W/m^2"    },
  { 178, "srad0",          "net top solar radiation",                   "W/m^2"    },
  { 179, "trad0",          "top thermal radiation (OLR)",               "W/m^2"    },
  { 180, "ustr",           "u-stress",                                  "Pa"       },
  { 181, "vstr",           "v-stress",                                  "Pa"       },
  { 182, "evap",           "evaporation",                               "kg/m^2s"  },
  { 183, "xskew",          "skewness of total water amount qv+qi+ql",    NULL      },
  { 184, "srad0d",         "top incoming solar radiation",              "W/m^2"    },
  { 185, "srafs",          "net surf. solar radiation   (clear sky)",   "W/m^2"    },
  { 186, "trafs",          "net surf. thermal radiation (clear sky)",   "W/m^2"    },
  { 187, "sraf0",          "net top solar radiation     (clear sky)",   "W/m^2"    },
  { 188, "traf0",          "net top thermal radiation   (clear sky)",   "W/m^2"    },
  { 189, "sclfs",          "surface solar cloud forcing",               "W/m^2"    },
  { 190, "tclfs",          "surface thermal cloud forcing",             "W/m^2"    },
  { 191, "sclf0",          "SW top cloud forcing (178-187)",            "W/m^2"    },
  { 192, "tclf0",          "LW top cloud forcing (179-188)",            "W/m^2"    },
  { 193, "wl",             "skin reservoir content",                    "m"        },
  { 194, "slf",            "sea land fraction",                          NULL      },
  { 195, "ustrgw",         "u-gravity wave stress",                     "Pa"       },
  { 196, "vstrgw",         "v-gravity wave stress",                     "Pa"       },
  { 197, "vdisgw",         "gravity wave dissipation",                  "W/m^2"    },
  { 198, "vgrat",          "vegetation ratio",                           NULL      },
  { 199, "orostd",         "orographic standard deviation",             "m"        },
  { 200, "vlt",            "leaf area index",                            NULL      },
  { 201, "t2max",          "maximum 2m-temperature",                    "K"        },
  { 202, "t2min",          "minimum 2m-temperature",                    "K"        },
  { 203, "srad0u",         "top solar radiation upward",                "W/m^2"    },
  { 204, "sradsu",         "surface solar radiation upward",            "W/m^2"    },
  { 205, "tradsu",         "surface thermal radiation upward",          "W/m^2"    },
  { 206, "grndflux",       "surface ground heat flux",                   NULL      },
  { 207, "tsoil",          "deep soil temperatures (5 layers)",         "K"        },
  { 208, "ahfcon",         "conductive heat flux through ice",          "W/m^2"    },
  { 209, "ahfres",         "melting of ice",                            "W/m^2"    },
  { 210, "seaice",         "ice cover (fraction of 1-SLM)",              NULL      },
  { 211, "siced",          "ice depth",                                 "m"        },
  { 212, "forest",         "forest fraction",                            NULL      },
  { 213, "gld",            "glacier depth",                             "m"        },
  { 214, "sni",            "water equivalent of snow on ice",           "m"        },
  { 215, "rogl",           "glacier runoff",                            "kg/m^2s"  },
  { 216, "wimax",          "maximum 10m-wind speed",                    "m/s"      },
  { 217, "topmax",         "maximum height of convective cloud tops",   "Pa"       },
  { 218, "snmel",          "snow melt",                                 "kg/m^2s"  },
  { 219, "runtoc",         "surface runoff into ocean",                 "kg/m^2s"  },
  { 220, "runlnd",         "surface runoff not running into ocean",     "kg/m^2s"  },
  { 221, "apmegl",         "P-E over land ice",                         "kg/m^2s"  },
  { 222, "snacl",          "snow accumulation over land",               "kg/m^2s"  },
  { 223, "aclcac",         "cloud cover",                                NULL      },
  { 224, "tke",            "turbulent kinetic energy",                  "m^2/s^2"  },
  { 225, "tkem1",          "turbulent kinetic energy (t-1)",            "m^2/s^2"  },
  { 226, "fao",            "FAO data set (soil data flags)",            "0...5"    },
  { 227, "rgcgn",          "heat capacity of soil",                      NULL      },
  { 228, "sodif",          "diffusivity of soil and land ice",          "m^2/s"    },
  { 229, "wsmx",           "field capacity of soil",                    "m"        },
  { 230, "qvi",            "vertically integrated water vapor",         "kg/m^2"   },
  { 231, "xlvi",           "vertically integrated cloud water",         "kg/m^2"   },
  { 232, "glac",           "fraction of land covered by glaciers",       NULL      },
  { 233, "snc",            "snow depth at the canopy",                  "m"        },
  { 234, "rtype",          "type of convection",                        "0...3"    },
  { 235, "abso4",          "antropogenic sulfur burden",                "kg/m**2"  },
  { 236, "ao3",            "ipcc ozone",                                "kg/m**2"  },
  { 237, "tropo",          "WMO defined tropopause height",             "Pa"       },
  { 259, "windspeed",      "windspeed (sqrt(u^2+v^2))",                 "m/s"      },
  { 260, "precip",         "total precipitation  (142+143)",            "kg/m^2s"  },
  { 261, "net_top",        "total top radiation  (178+179)",            "W/m^2"    },
  { 262, "net_bot",        "total surface radiation (176+177)",         "W/m^2"    },
  { 272, "mastfru",        "mass stream function",                      "kg/s"     },
};

static PAR mpiom1[] = {
  {   2, "THO",      "temperature",                     "C"        },
  {   5, "SAO",      "salinity",                        "psu"      },
  {   3, "UKO",      "zon. velocity",                   "m/s"      },
  {   4, "VKE",      "mer. velocity",                   "m/s"      },
  { 303, "UKOMFL",   "zon. velocity (divergence free)", "m/s"      },
  { 304, "VKEMFL",   "mer. velocity (divergence free)", "m/s"      },
  {   7, "WO",       "ver. velocity",                   "m/s"      },
  {   8, "RHO",      "insitu density",                  "kg/m**3"  },
  {   6, "PO",       "pressure",                        "Pa"       },
  {  67, "EMINPO",   "freshwaterflux by restoring",     "m/s"      },
  {  70, "FLUM",     "total heatflux",                  "W/m**2"   },
  {  79, "PEM",      "total freshwaterflux",            "m/s"      },
  {  13, "SICTHO",   "ice thickness",                   "m"        },
  {  15, "SICOMO",   "ice compactness",                 "frac."    },
  {  35, "SICUO",    "zon. ice velocity",               "m/s"      },
  {  36, "SICVE",    "mer. ice velocity",               "m/s"      },
  {  92, "TAFO",     "surface air temperature",         "C"        },
  { 164, "FCLOU",    "cloud cover",                      NULL      },
  {  52, "TXO",      "surface u-stress",                "Pa/1025." },
  {  53, "TYE",      "surface v-stress",                "Pa/1025." },
  { 260, "FPREC",    "prescr. precipitation",           "m/s"      },
  {  80, "FSWR",     "downward shortwave rad.",         "W/m**2"   },
  {  81, "FTDEW",    "dewpoint temperature",            "K"        },
  { 171, "FU10",     "10m windspeed",                   "m/s"      },
  { 141, "SICSNO",   "snow thickness",                  "m"        },
  { 176, "QSWO",     "heat flux shortwave",             "W/m**2"   },
  { 177, "QLWO",     "heat flux longwave",              "W/m**2"   },
  { 147, "QLAO",     "heat flux latent",                "W/m**2"   },
  { 146, "QSEO",     "heat flux sensible",              "W/m**2"   },
  {  65, "PRECO",    "net freshwater flux + runoff",    "m/s"      },
  {   1, "ZO",       "sealevel",                        "m"        },
  {  82, "Z1O",      "sealevel change",                 "m"        },
  {  69, "KCONDEP",  "depth of convection",             "level"    },
  {  27, "PSIUWE",   "hor. bar. streamfunction",        "Sv"       },
  {  83, "AMLD",     "mixed layer depth",               "m"        },
  { 172, "WETO",     "landseamask (pressure points)",    NULL      },
  { 507, "AMSUE",    "landseamask (vector points v)",    NULL      },
  { 508, "AMSUO",    "landseamask (vector points u)",    NULL      },
  {  84, "DEPTO",    "depth at pressure points",        "m"        },
  { 484, "DEUTO",    "depth at vector points (u)",      "m"        },
  { 584, "DEUTE",    "depth at vector points (v)",      "m"        },
  { 184, "DDUO",     "level thickness (vector u )",     "m"        },
  { 284, "DDUE",     "level thickness (vector v )",     "m"        },
  { 384, "DDPO",     "level thickness (pressure )",     "m"        },
  {  85, "DLXP",     "grid distance x",                 "m"        },
  {  86, "DLYP",     "grid distance y",                 "m"        },
  { 185, "DLXU",     "grid distance x  (vector u)",     "m"        },
  { 186, "DLYU",     "grid distance y  (vector u)",     "m"        },
  { 285, "DLXV",     "grid distance x  (vector v)",     "m"        },
  { 286, "DLYV",     "grid distance y  (vector v)",     "m"        },
  {  54, "GILA",     "latitude in radiants",            "rad"      },
  {  55, "GIPH",     "longitude in radiants",           "rad"      },
  { 354, "ALAT",     "latitude in degrees (pressure)",  "deg"      },
  { 355, "ALON",     "longitude in degrees (pressure)", "deg"      },
  { 154, "ALATU",    "latitude in degrees (vector u)",  "deg"      },
  { 155, "ALONU",    "longitude in degrees (vector u)", "deg"      },
  { 254, "ALATV",    "latitude in degrees (vector v)",  "deg"      },
  { 255, "ALONV",    "longitude in degrees (vector v)", "deg"      },
  { 110, "AVO",      "vertical impuls diffusion",       "m**2/s"   },
  { 111, "DVO",      "vertical T,S diffusion",          "m**2/s"   },
  { 142, "SICTRU",   "seaice transport x",              "m**2/s"   },
  { 143, "SICTRV",   "seaice transport y",              "m**2/s"   },
  { 612, "WTMIX",    "wind mixing",                     "m**2/s"   },
  { 183, "zmld",     "mixed layer depth (SJ)",          "m"        },
  { 207, "WGO",      "GM vertical velocity",            "m/s"      },
  { 305, "rivrun",   "RiverRunoff",                     "m/s"      },
  { 158, "TMCDO",    "mon. mean depth of convection",   "level"    },
  { 247, "DQSWO",    "heatflux sw over water",          "W/m**2"   },
  { 248, "DQLWO",    "heatflux lw over water",          "W/m**2"   },
  { 249, "DQSEO",    "heatflux se over water",          "W/m**2"   },
  { 250, "DQLAO",    "heatflux la over water",          "W/m**2"   },
  { 251, "DQTHO",    "heatflux net over water",         "W/m**2"   },
  { 252, "DQSWI",    "heatflux sw over seaice",         "W/m**2"   },
  { 253, "DQLWI",    "heatflux lw over seaice",         "W/m**2"   },
  { 254, "DQSEI",    "heatflux se over seaice",         "W/m**2"   },
  { 255, "DQLAI",    "heatflux la over seaice",         "W/m**2"   },
  { 256, "DQTHI",    "heatflux net over seaice",        "W/m**2"   },
  { 257, "DTICEO",   "Equi. temp over seaice",          "K"        },
  { 270, "AOFLNHWO", "oasis net heat flux water",       "W/m**2"   },
  { 271, "AOFLSHWO", "oasis downward short wave",       "W/m**2"   },
  { 272, "AOFLRHIO", "oasis residual heat flux ice",    "W/m**2"   },
  { 273, "AOFLCHIO", "oasis conduct. heat flux ice",    "W/m**2"   },
  { 274, "AOFLFRWO", "oasis fluid fresh water flux",    "m/s"      },
  { 275, "AOFLFRIO", "oasis solid fresh water flux",    "m/s"      },
  { 276, "AOFLTXWO", "oasis wind stress water x",       "Pa/102"   },
  { 277, "AOFLTYWO", "oasis wind stress water y",       "Pa/102"   },
  { 278, "AOFLTXIO", "oasis wind stress ice x",         "Pa/102"   },
  { 279, "AOFLTYIO", "oasis wind stress ice x",         "Pa/102"   },
  { 280, "AOFLWSVO", "oasis wind speed",                "m/s"      },
};

static PAR ecmwf[] = {
  {   1, "STRF",   "Stream function",                                            "m**2 s**-1"            },
  {   2, "VPOT",   "Velocity potential",                                         "m**2 s**-1"            },
  {   3, "PT",     "Potential temperature",                                      "K"                     },
  {   4, "EQPT",   "Equivalent potential temperature",                           "K"                     },
  {   5, "SEPT",   "Saturated equivalent potential temperature",                 "K"                     },
  {  11, "UDVW",   "U component of divergent wind",                              "m s**-1"               },
  {  12, "VDVW",   "V component of divergent wind",                              "m s**-1"               },
  {  13, "URTW",   "U component of rotational wind",                             "m s**-1"               },
  {  14, "VRTW",   "V component of rotational wind",                             "m s**-1"               },
  {  21, "UCTP",   "Unbalanced component of temperature",                        "K"                     },
  {  22, "UCLN",   "Unbalanced component of logarithm of surface pressure",       NULL                   },
  {  23, "UCDV",   "Unbalanced component of divergence",                         "s**-1"                 },
  {  26, "CL",     "Lake cover",                                                  NULL                   },
  {  27, "CVL",    "Low vegetation cover",                                        NULL                   },
  {  28, "CVH",    "High vegetation cover",                                       NULL                   },
  {  29, "TVL",    "Type of low vegetation",                                      NULL                   },
  {  30, "TVH",    "Type of high vegetation",                                     NULL                   },
  {  31, "CI",     "Sea-ice cover",                                               NULL                   },
  {  32, "ASN",    "Snow albedo",                                                 NULL                   },
  {  33, "RSN",    "Snow density kg",                                            "m**-3"                 },
  {  34, "SSTK",   "Sea surface temperature",                                    "K"                     },
  {  35, "ISTL1",  "Ice surface temperature layer 1",                            "K"                     },
  {  36, "ISTL2",  "Ice surface temperature layer 2",                            "K"                     },
  {  37, "ISTL3",  "Ice surface temperature layer 3",                            "K"                     },
  {  38, "ISTL4",  "Ice surface temperature layer 4",                            "K"                     },
  {  39, "SWVL1",  "Volumetric soil water layer 1",                              "m**3 m**-3"            },
  {  40, "SWVL2",  "Volumetric soil water layer 2",                              "m**3 m**-3"            },
  {  41, "SWVL3",  "Volumetric soil water layer 3",                              "m**3 m**-3"            },
  {  42, "SWVL4",  "Volumetric soil water layer 4",                              "m**3 m**-3"            },
  {  43, "SLT",    "Soil type",                                                   NULL                   },
  {  44, "ES",     "Snow evaporation m of water",                                 NULL                   },
  {  45, "SMLT",   "Snowmelt m of water",                                         NULL                   },
  {  46, "SDUR",   "Solar duration",                                             "s"                     },
  {  47, "DSRP",   "Direct solar radiation",                                     "w m**-2"               },
  {  48, "MAGSS",  "Magnitude of surface stress",                                "N m**-2 s"             },
  {  49, "WG10",   "Wind gust at 10 metres",                                     "m s**-1"               },
  {  50, "LSPF",   "Large-scale precipitation fraction",                         "s"                     },
  {  51, "MX2T24", "Maximum 2 metre temperature",                                "K"                     },
  {  52, "MN2T24", "Minimum 2 metre temperature",                                "K"                     },
  {  53, "MONT",   "Montgomery potential",                                       "m**2 s**-2"            },
  {  54, "PRES",   "Pressure",                                                   "Pa"                    },
  {  55, "MN2T24", "Mean 2 metre temperature past 24 hours",                     "K"                     },
  {  56, "MN2D24", "Mean 2 metre dewpoint temperature past 24 hours",            "K"                     },
  {  60, "PV",     "Potential vorticity",                                        "K m**2 kg**-1 s**-1"   },
  { 127, "AT",     "Atmospheric tide",                                            NULL                   },
  { 128, "BV",     "Budget values",                                               NULL                   },
  { 129, "Z",      "Geopotential",                                               "m**2 s**-2"            },
  { 130, "T",      "Temperature",                                                "K"                     },
  { 131, "U",      "U velocity",                                                 "m s**-1"               },
  { 132, "V",      "V velocity",                                                 "m s**-1"               },
  { 133, "Q",      "Specific humidity",                                          "kg kg**-1"             },
  { 134, "SP",     "Surface pressure",                                           "Pa"                    },
  { 135, "W",      "Vertical velocity",                                          "Pa s**-1"              },
  { 136, "TCW",    "Total column water",                                         "kg m**-2"              },
  { 137, "TCWV",   "Total column water vapour",                                  "kg m**-2"              },
  { 138, "VO",     "Vorticity (relative)",                                       "s**-1"                 },
  { 139, "STL1",   "Soil temperature level 1",                                   "K"                     },
  { 140, "SWL1",   "Soil wetness level 1 m of water",                             NULL                   },
  { 141, "SD",     "Snow depth         1 m of water equivalent",                  NULL                   },
  { 142, "LSP",    "Stratiform precipitation (Large scale precipitation)",       "m"                     },
  { 143, "CP",     "Convective precipitation",                                   "m"                     },
  { 144, "SF",     "Snowfall (convective + stratiform)",                         "m"                     },
  { 145, "BLD",    "Boundary layer dissipation",                                 "W m**-2 s"             },
  { 146, "SSHF",   "Surface sensible heat flux",                                 "W m**-2 s"             },
  { 147, "SLHF",   "Surface latent heat flux",                                   "W m**-2 s"             },
  { 148, "CHNK",   "Charnock",                                                    NULL                   },
  { 149, "SNR",    "Surface net radiation",                                      "W m**-2 s"             },
  { 150, "TNR",    "Top net radiation",                                           NULL                   },
  { 151, "MSL",    "Mean sea-level pressure",                                    "Pa"                    },
  { 152, "LNSP",   "Logarithm of surface pressure",                               NULL                   },
  { 153, "SWHR",   "Short-wave heating rate",                                    "K"                     },
  { 154, "LWHR",   "Long-wave heating rate",                                     "K"                     },
  { 155, "D",      "Divergence",                                                 "s**-1"                 },
  { 156, "GH",     "Height m Geopotential height",                                NULL                   },
  { 157, "R",      "Relative humidity",                                          "%"                     },
  { 158, "TSP",    "Tendency of surface pressure",                               "Pa s**-1"              },
  { 159, "BLH",    "Boundary layer height",                                      "m"                     },
  { 160, "SDOR",   "Standard deviation of orography",                             NULL                   },
  { 161, "ISOR",   "Anisotropy of sub-gridscale orography",                       NULL                   },
  { 162, "ANOR",   "Angle of sub-gridscale orography",                           "rad"                   },
  { 163, "SLOR",   "Slope of sub-gridscale orography",                            NULL                   },
  { 164, "TCC",    "Total cloud cover",                                           NULL                   },
  { 165, "U10M",   "10 metre U wind component",                                  "m s**-1"               },
  { 166, "V10M",   "10 metre V wind component",                                  "m s**-1"               },
  { 167, "T2M",    "2 metre temperature",                                        "K"                     },
  { 168, "D2M",    "2 metre dewpoint temperature",                               "K"                     },
  { 169, "SSRD",   "Surface solar radiation downwards",                          "W m**-2 s"             },
  { 170, "STL2",   "Soil temperature level 2",                                   "K"                     },
  { 171, "SWL2",   "Soil wetness level 2",                                       "m of water"            },
  { 172, "LSM",    "Land/sea mask",                                               NULL                   },
  { 173, "SR",     "Surface roughness",                                          "m"                     },
  { 174, "AL",     "Albedo",                                                      NULL                   },
  { 175, "STRD",   "Surface thermal radiation downwards",                        "W m**-2 s"             },
  { 176, "SSR",    "Surface solar radiation",                                    "W m**-2 s"             },
  { 177, "STR",    "Surface thermal radiation",                                  "W m**-2 s"             },
  { 178, "TSR",    "Top solar radiation",                                        "W m**-2 s"             },
  { 179, "TTR",    "Top thermal radiation",                                      "W m**-2 s"             },
  { 180, "EWSS",   "East/West surface stress",                                   "N m**-2 s"             },
  { 181, "NSSS",   "North/South surface stress",                                 "N m**-2 s"             },
  { 182, "E",      "Evaporation",                                                "m of water"            },
  { 183, "STL3",   "Soil temperature level 3",                                   "K"                     },
  { 184, "SWL3",   "Soil wetness level 3",                                       "m of water"            },
  { 185, "CCC",    "Convective cloud cover",                                      NULL                   },
  { 186, "LCC",    "Low cloud cover",                                             NULL                   },
  { 187, "MCC",    "Medium cloud cover",                                          NULL                   },
  { 188, "HCC",    "High cloud cover",                                            NULL                   },
  { 189, "SUND",   "Sunshine duration",                                          "s"                     },
  { 190, "EWOV",   "EW component of subgrid orographic variance",                "m**2"                  },
  { 191, "NSOV",   "NS component of subgrid orographic variance",                "m**2"                  },
  { 192, "NWOV",   "NWSE component of subgrid orographic variance",              "m**2"                  },
  { 193, "NEOV",   "NESW component of subgrid orographic variance",              "m**2"                  },
  { 194, "BTMP",   "Brightness temperature",                                     "K"                     },
  { 195, "LGWS",   "Lat. component of gravity wave stress",                      "N m**-2 s"             },
  { 196, "MGWS",   "Meridional component of gravity wave stress",                "N m**-2 s"             },
  { 197, "GWD",    "Gravity wave dissipation",                                   "W m**-2 s"             },
  { 198, "SRC",    "Skin reservoir content",                                     "m of water"            },
  { 199, "VEG",    "Vegetation fraction",                                         NULL                   },
  { 200, "VSO",    "Variance of sub-gridscale orography",                        "m**2"                  },
  { 201, "MX2T",   "Maximum 2 metre temperature since previous post-processing", "K"                     },
  { 202, "MN2T",   "Minimum 2 metre temperature since previous post-processing", "K"                     },
  { 203, "O3",     "Ozone mass mixing ratio",                                    "kg kg**-1"             },
  { 204, "PAW",    "Precipiation analysis weights",                               NULL                   },
  { 205, "RO",     "Runoff",                                                     "m"                     },
  { 206, "TCO3",   "Total column ozone",                                         "kg m**-2"              },
  { 207, "WS10",   "10 meter windspeed",                                         "m s**-1"               },
  { 208, "TSRC",   "Top net solar radiation, clear sky",                         "W m**-2"               },
  { 209, "TTRC",   "Top net thermal radiation, clear sky",                       "W m**-2"               },
  { 210, "SSRC",   "Surface net solar radiation, clear sky",                     "W m**-2"               },
  { 211, "STRC",   "Surface net thermal radiation, clear sky",                   "W m**-2"               },
  { 212, "SI",     "Solar insolation",                                           "W m**-2"               },
  { 214, "DHR",    "Diabatic heating by radiation",                              "K"                     },
  { 215, "DHVD",   "Diabatic heating by vertical diffusion",                     "K"                     },
  { 216, "DHCC",   "Diabatic heating by cumulus convection",                     "K"                     },
  { 217, "DHLC",   "Diabatic heating large-scale condensation",                  "K"                     },
  { 218, "VDZW",   "Vertical diffusion of zonal wind",                           "m s**-1"               },
  { 219, "VDMW",   "Vertical diffusion of meridional wind",                      "m s**-1"               },
  { 220, "EWGD",   "EW gravity wave drag tendency",                              "m s**-1"               },
  { 221, "NSGD",   "NS gravity wave drag tendency",                              "m s**-1"               },
  { 222, "CTZW",   "Convective tendency of zonal wind",                          "m s**-1"               },
  { 223, "CTMW",   "Convective tendency of meridional wind",                     "m s**-1"               },
  { 224, "VDH",    "Vertical diffusion of humidity",                             "kg kg**-1"             },
  { 225, "HTCC",   "Humidity tendency by cumulus convection",                    "kg kg**-1"             },
  { 226, "HTLC",   "Humidity tendency large-scale condensation",                 "kg kg**-1"             },
  { 227, "CRNH",   "Change from removing negative humidity",                     "kg kg**-1"             },
  { 228, "TP",     "Total precipitation",                                        "m"                     },
  { 229, "IEWS",   "Instantaneous X surface stress",                             "N m**-2"               },
  { 230, "INSS",   "Instantaneous Y surface stress",                             "N m**-2"               },
  { 231, "ISHF",   "Instantaneous surface heat flux",                            "W m**-2"               },
  { 232, "IE",     "Instantaneous moisture flux",                                "kg m**-2 s"            },
  { 233, "ASQ",    "Apparent surface humidity",                                  "kg kg**-1"             },
  { 234, "LSRH",   "Logarithm of surface roughness length for heat",              NULL                   },
  { 235, "SKT",    "Skin temperature",                                           "K"                     },
  { 236, "STL4",   "Soil temperature level 4",                                   "K"                     },
  { 237, "SWL4",   "Soil wetness level 4",                                       "m"                     },
  { 238, "TSN",    "Temperature of snow layer",                                  "K"                     },
  { 239, "CSF",    "Convective snowfall",                                        "m of water equivalent" },
  { 240, "LSF",    "Large-scale snowfall",                                       "m of water equivalent" },
  { 241, "ACF",    "Accumulated cloud fraction tendency",                         NULL                   },
  { 242, "ALW",    "Accumulated liquid water tendency",                           NULL                   },
  { 243, "FAL",    "Forecast albedo",                                             NULL                   },
  { 244, "FSR",    "Forecast surface roughness",                                 "m"                     },
  { 245, "FLSR",   "Forecast log of surface roughness for heat",                  NULL                   },
  { 246, "CLWC",   "Cloud liquid water content",                                 "kg kg**-1"             },
  { 247, "CIWC",   "Cloud ice water content",                                    "kg kg**-1"             },
  { 248, "CC",     "Cloud cover",                                                 NULL                   },
  { 249, "AIW",    "Accumulated ice water tendency",                              NULL                   },
  { 250, "ICE",    "Ice age",                                                     NULL                   },
  { 251, "ATTE",   "Adiabatic tendency of temperature",                          "K"                     },
  { 252, "ATHE",   "Adiabatic tendency of humidity",                             "kg kg**-1"             },
  { 253, "ATZE",   "Adiabatic tendency of zonal wind",                           "m s**-1"               },
  { 254, "ATMW",   "Adiabatic tendency of meridional wind",                      "m s**-1"               },
};

static PAR remo[] = {
  {  14, "FTKVM",     "turbulent transfer coefficient of momentum in the atmosphere",   NULL           },
  {  15, "FTKVH",     "turbulent transfer coefficient of heat in the atmosphere",       NULL           },
  {  38, "U10ER",     "10m u-velocity",                                                "m/s"           },
  {  39, "V10ER",     "10m v-velocity",                                                "m/s"           },
  {  40, "CAPE",      "convetive available potential energy",                           NULL           },
  {  41, "GHPBL",     "height of the planetary boudary layer",                         "gpm"           },
  {  42, "BETA",      "BETA",                                                           NULL           },
  {  43, "WMINLOK",   "WMINLOK",                                                        NULL           },
  {  44, "WMAXLOK",   "WMAXLOK",                                                        NULL           },
  {  45, "VBM10M",    "maximum of the expected gust velocity near the surface",        "m/s"           },
  {  46, "BFLHS",     "surface sensible heat flux",                                    "W/m**2"        },
  {  47, "BFLQDS",    "surface latent heat flux",                                      "W/m**2"        },
  {  48, "TMCM",      "turbulent transfer coefficient of momentum at the surface",      NULL           },
  {  49, "TRSOL",     "TRSOL",                                                          NULL           },
  {  50, "TMCH",      "turbulent transfer coefficient of heat at the surface",          NULL           },
  {  51, "EMTEF",     "EMTEF",                                                          NULL           },
  {  52, "TRSOF",     "TRSOF",                                                          NULL           },
  {  53, "DRAIN",     "drainage",                                                      "mm"            },
  {  54, "TSL",       "surface temperature (land)",                                    "K"             },
  {  55, "TSW",       "surface temperature (water)",                                   "K"             },
  {  56, "TSI",       "surface temperature (ice)",                                     "K"             },
  {  57, "USTRL",     "surface u-stress (land)",                                       "Pa"            },
  {  58, "USTRW",     "surface u-stress (water)",                                      "Pa"            },
  {  59, "USTRI",     "surface u-stress (ice)",                                        "Pa"            },
  {  60, "VSTRL",     "surface v-stress (land)",                                       "Pa"            },
  {  61, "VSTRW",     "surface v-stress (water)",                                      "Pa"            },
  {  62, "VSTRI",     "surface v-stress (ice)",                                        "Pa"            },
  {  63, "EVAPL",     "surface evaporation (land)",                                    "mm"            },
  {  64, "EVAPW",     "surface evaporation (water)",                                   "mm"            },
  {  65, "EVAPI",     "surface evaporation (ice)",                                     "mm"            },
  {  66, "AHFLL",     "surface latent heat flux (land)",                               "W/m**2"        },
  {  67, "AHFLW",     "surface latent heat flux (water)",                              "W/m**2"        },
  {  68, "AHFLI",     "surface latent heat flux (ice)",                                "W/m**2"        },
  {  69, "AHFSL",     "surface sensible heat flux (land)",                             "W/m**2"        },
  {  70, "AHFSW",     "surface sensible heat flux (water)",                            "W/m**2"        },
  {  71, "AHFSI",     "surface sensible heat flux (ice)",                              "W/m**2"        },
  {  72, "AZ0L",      "surface roughness length (land)",                               "m"             },
  {  73, "AZ0W",      "surface roughness length (water)",                              "m"             },
  {  74, "AZ0I",      "surface roughness length (ice)",                                "m"             },
  {  75, "ALSOL",     "surface albedo (land)",                                         "fract."        },
  {  76, "ALSOW",     "surface albedo (water)",                                        "fract."        },
  {  77, "ALSOI",     "surface albedo (ice)",                                          "fract."        },
  {  81, "TMCHL",     "turbulent transfer coefficient of heat at the surface (land)",   NULL           },
  {  82, "TMCHW",     "turbulent transfer coefficient of heat at the surface (water)",  NULL           },
  {  83, "TMCHI",     "turbulent transfer coefficient of heat at the surface (ice)",    NULL           },
  {  84, "QDBL",      "specific humidity surface (land)",                              "kg/kg"         },
  {  85, "QDBW",      "specific humidity surface (water)",                             "kg/kg"         },
  {  86, "QDBI",      "specific humidity surface (ice)",                               "kg/kg"         },
  {  87, "BFLHSL",    "surface sensible heat flux (land)",                             "W/m**2"        },
  {  88, "BFLHSW",    "surface sensible heat flux (water)",                            "W/m**2"        },
  {  89, "BFLHSI",    "surface sensible heat flux (ice)",                              "W/m**2"        },
  {  90, "BFLQDSL",   "surface latent heat flux (land)",                               "W/m**2"        },
  {  91, "BFLQDSW",   "surface latent heat flux (water)",                              "W/m**2"        },
  {  92, "BFLQDSI",   "surface latent heat flux (ice)",                                "W/m**2"        },
  {  93, "AHFICE",    "sea-ice: conductive heat",                                      "W/m"           },
  {  94, "QRES",      "residual heat flux for melting sea ice",                        "W/m**2"        },
  {  95, "SRFL",      "SRFL",                                                           NULL           },
  {  96, "QDBOXS",    "horizontal transport of water vapour",                          "kg/m**2"       },
  {  97, "QWBOXS",    "horizontal transport of cloud water",                           "kg/m**2"       },
  {  98, "EKBOXS",    "horizontal transport of kinetic energy",                        "(3600*J)/m**2" },
  {  99, "FHBOXS",    "horizontal transport of sensible heat",                         "(3600*J)/m**2" },
  { 100, "FIBOXS",    "horizontal transport of potential energy",                      "(3600*J)/m**2" },
  { 101, "TLAMBDA",   "heat conductivity of dry soil",                                 "W/(K*m)"       },
  { 103, "DLAMBDA",   "parameter for increasing the heat conductivity of the soil",     NULL           },
  { 104, "PORVOL",    "pore volume",                                                    NULL           },
  { 105, "FCAP",      "field capacity of soil",                                         NULL           },
  { 106, "WI3",       "fraction of frozen soil",                                        NULL           },
  { 107, "WI4",       "fraction of frozen soil",                                        NULL           },
  { 108, "WI5",       "fraction of frozen soil",                                        NULL           },
  { 109, "WI",        "fraction of frozen soil",                                        NULL           },
  { 110, "WICL",      "fraction of frozen soil",                                        NULL           },
  { 112, "QDB",       "specific humidity surface",                                     "kg/kg"         },
  { 129, "FIB",       "surface geopotential (orography)",                              "m"             },
  { 130, "T",         "temperature",                                                   "K"             },
  { 131, "U",         "u-velocity",                                                    "m/s"           },
  { 132, "V",         "v-velocity",                                                    "m/s"           },
  { 133, "QD",        "specific humidity",                                             "kg/kg"         },
  { 134, "PS",        "Surface pressure",                                              "Pa"            },
  { 135, "VERVEL",    "Vertical velocity",                                             "Pa/s"          },
  { 138, "SVO",       "vorticity",                                                     "1/s"           },
  { 139, "TS",        "surface temperature",                                           "K"             },
  { 140, "WS",        "soil wetness",                                                  "m"             },
  { 141, "SN",        "snow depth",                                                    "m"             },
  { 142, "APRL",      "large scale precipitation",                                     "mm"            },
  { 143, "APRC",      "convective  precipitation",                                     "mm"            },
  { 144, "APRS",      "snow fall",                                                     "mm"            },
  { 145, "VDIS",      "boundary layer dissipation",                                    "W/m**2"        },
  { 146, "AHFS",      "surface sensible heat flux",                                    "W/m**2"        },
  { 147, "AHFL",      "surface latent heat flux",                                      "W/m**2"        },
  { 148, "STREAM",    "streamfunction",                                                "m**2/s"        },
  { 149, "VELOPOT",   "velocity potential",                                            "m**2/s"        },
  { 151, "PSRED",     "mean sea level pressure",                                       "Pa"            },
  { 152, "LSP",       "log surface pressure",                                           NULL           },
  { 153, "QW",        "liquid water content",                                          "kg/kg"         },
  { 155, "SD",        "divergence",                                                    "1/s"           },
  { 156, "FI",        "geopotential height",                                           "gpm"           },
  { 159, "USTAR3",    "ustar**3",                                                      "m**3/s**3"     },
  { 160, "RUNOFF",    "surface runoff",                                                "mm"            },
  { 162, "ACLC",      "cloud cover",                                                   "fract."        },
  { 163, "ACLCV",     "total cloud cover",                                             "fract."        },
  { 164, "ACLCOV",    "total cloud cover",                                             "fract."        },
  { 165, "U10",       "10m u-velocity",                                                "m/s"           },
  { 166, "V10",       "10m v-velocity",                                                "m/s"           },
  { 167, "TEMP2",     "2m temperature",                                                "K"             },
  { 168, "DEW2",      "2m dew point temperature",                                      "K"             },
  { 169, "TSURF",     "surface temperature (land)",                                    "K"             },
  { 170, "TD",        "deep soil temperature",                                         "K"             },
  { 171, "WIND10",    "10m windspeed",                                                 "m/s"           },
  { 172, "BLA",       "land sea mask",                                                 "fract."        },
  { 173, "AZ0",       "surface roughness length",                                      "m"             },
  { 174, "ALB",       "surface background albedo",                                     "fract."        },
  { 175, "ALBEDO",    "surface albedo",                                                "fract."        },
  { 176, "SRADS",     "net surface solar radiation",                                   "W/m**2"        },
  { 177, "TRADS",     "net surface thermal radiation",                                 "W/m**2"        },
  { 178, "SRAD0",     "net top solar radiation",                                       "W/m**2"        },
  { 179, "TRAD0",     "top thermal radiation (OLR)",                                   "W/m**2"        },
  { 180, "USTR",      "surface u-stress",                                              "Pa"            },
  { 181, "VSTR",      "surface v-stress",                                              "Pa"            },
  { 182, "EVAP",      "surface evaporation",                                           "mm"            },
  { 183, "TDCL",      "soil temperature",                                              "K"             },
  { 185, "SRAFS",     "net surf. solar radiation   (clear sky)",                       "W/m**2"        },
  { 186, "TRAFS",     "net surf. thermal radiation (clear sky)",                       "W/m**2"        },
  { 187, "SRAF0",     "net top solar radiation     (clear sky)",                       "W/m**2"        },
  { 188, "TRAF0",     "net top thermal radiation   (clear sky)",                       "W/m**2"        },
  { 189, "SCLFS",     "surface solar cloud forcing",                                   "W/m**2"        },
  { 190, "TCLFS",     "surface thermal cloud forcing",                                 "W/m**2"        },
  { 191, "SCLF0",     "top solar cloud forcing",                                       "W/m**2"        },
  { 192, "TCLF0",     "top thermal cloud forcing",                                     "W/m**2"        },
  { 194, "WL",        "skin reservoir content",                                        "m"             },
  { 195, "USTRGW",    "u-gravity wave stress",                                         "Pa"            },
  { 196, "VSTRGW",    "v-gravity wave stress",                                         "Pa"            },
  { 197, "VDISGW",    "gravity wave dissipation",                                      "W/m**2"        },
  { 198, "VGRAT",     "vegetation ratio",                                               NULL           },
  { 199, "VAROR",     "orographic variance (for surface runoff)",                       NULL           },
  { 200, "VLT",       "leaf area index",                                                NULL           },
  { 201, "T2MAX",     "maximum 2m-temperature",                                        "K"             },
  { 202, "T2MIN",     "minimum 2m-temperature",                                        "K"             },
  { 203, "SRAD0U",    "top solar radiation upward",                                    "W/m**2"        },
  { 204, "SRADSU",    "surface solar radiation upward",                                "W/m**2"        },
  { 205, "TRADSU",    "surface thermal radiation upward",                              "W/m**2"        },
  { 206, "TSN",       "snow temperature",                                              "K"             },
  { 207, "TD3",       "soil temperature",                                              "K"             },
  { 208, "TD4",       "soil temperature",                                              "K"             },
  { 209, "TD5",       "soil temperature",                                              "K"             },
  { 210, "SEAICE",    "sea ice cover",                                                 "fract."        },
  { 211, "SICED",     "sea ice depth",                                                 "m"             },
  { 212, "FOREST",    "vegetation type",                                                NULL           },
  { 213, "TEFF",      "(effective) sea-ice skin temperature",                          "K"             },
  { 214, "TSMAX",     "maximum surface temperature",                                   "K"             },
  { 215, "TSMIN",     "minimum surface temperature",                                   "K"             },
  { 216, "WIMAX",     "maximum 10m-wind speed",                                        "m/s"           },
  { 217, "TOPMAX",    "maximum height of convective cloud tops",                       "Pa"            },
  { 218, "SNMEL",     "snow melt",                                                     "mm"            },
  { 220, "TSLIN",     "land: residual surface heat budget",                            "W/m**2"        },
  { 221, "DSNAC",     "snow depth change",                                             "mm"            },
  { 222, "EMTER",     "EMTER",                                                          NULL           },
  { 223, "ACLCAC",    "cloud cover",                                                   "fract."        },
  { 224, "TKE",       "turbulent kinetic energy",                                       NULL           },
  { 226, "FAO",       "FAO data set (soil data flags)",                                 NULL           },
  { 227, "RGCGN",     "heat capacity of soil",                                          NULL           },
  { 229, "WSMX",      "field capacity of soil",                                         NULL           },
  { 230, "QVI",       "vertically integrated specific humidity",                       "kg/m**2"       },
  { 231, "ALWCVI",    "vertically integrated liquid water cont.",                      "kg/m**2"       },
  { 232, "GLAC",      "glacier mask",                                                   NULL           },
  { 253, "PHI",       "latitude in real coordinates",                                  "degrees_north" },
  { 254, "RLA",       "longitude in real coordinates",                                 "degrees_east"  },
  { 259, "WINDSPEED", "windspeed (sqrt(u**2+v**2))",                                    NULL           },
  { 260, "PRECIP",    "total precipitation",                                            NULL           },
};

static PAR cosmo002[] = {
  {   1, "P",         "pressure",                                          "Pa"         },
  {   2, "PMSL",      "mean sea level pressure",                           "Pa"         },
  {   3, "DPSDT",     "surface pressure change",                           "Pa s-1"     },
  {   6, "FI",        "geopotential",                                      "m2 s-2"     },
  {   8, "HH",        "height",                                            "m"          },
  {  10, "TO3",       "vertical integrated ozone content",                 "Dobson"     },
  {  11, "T",         "temperature",                                       "K"          },
  {  15, "TMAX",      "2m maximum temperature",                            "K"          },
  {  16, "TMIN",      "2m minimum temperature",                            "K"          },
  {  17, "TD",        "2m dew point temperature",                          "K"          },
  {  31, "DD",        "undefined",                                         "undefined"  },
  {  32, "FF",        "undefined",                                         "undefined"  },
  {  33, "U",         "U-component of wind",                               "m s-1"      },
  {  34, "V",         "V-component of wind",                               "m s-1"      },
  {  39, "OMEGA",     "omega",                                             "Pa s-1"     },
  {  40, "W",         "vertical wind velocity",                            "m s-1"      },
  {  51, "QV",        "specific humidity",                                 "kg kg-1"    },
  {  52, "RELHUM",    "relative humidity",                                 "%"          },
  {  54, "TQV",       "precipitable water",                                "kg m-2"     },
  {  57, "AEVAP",     "surface evaporation",                               "kg m-2"     },
  {  58, "TQI",       "vertical integrated cloud ice",                     "kg m-2"     },
  {  59, "TOT_PR",    "total precipitation rate",                          "kg m-2 s-1" },
  {  61, "TOT_PREC",  "total precipitation amount",                        "kg m-2"     },
  {  65, "W_SNOW",    "surface snow amount",                               "m"          },
  {  66, "H_SNOW",    "thickness of snow",                                 "m"          },
  {  71, "CLCT",      "total cloud cover",                                 "1"          },
  {  72, "CLC_CON",   "convective cloud area fraction",                    "1"          },
  {  73, "CLCL",      "low cloud cover",                                   "1"          },
  {  74, "CLCM",      "medium cloud cover",                                "1"          },
  {  75, "CLCH",      "high cloud cover",                                  "1"          },
  {  76, "TQC",       "vertical integrated cloud water",                   "kg m-2"     },
  {  78, "SNOW_CON",  "convective snowfall",                               "kg m-2"     },
  {  79, "SNOW_GSP",  "large scale snowfall",                              "kg m-2"     },
  {  81, "FR_LAND",   "land-sea fraction",                                 "1"          },
  {  83, "Z0",        "surface roughness length",                          "m"          },
  {  84, "ALB_RAD",   "surface albedo",                                    "1"          },
  {  85, "TSOIL",     "soil surface temperature",                          "K"          },
  {  86, "WSOIL",     "water content of 1. soil layer",                    "m"          },
  {  87, "PLCOV",     "vegetation area fraction",                          "1"          },
  {  90, "RUNOFF",    "subsurface runoff",                                 "kg m-2"     },
  {  91, "FR_ICE",    "sea ice area fraction",                             "1"          },
  {  92, "H_ICE",     "sea ice thickness",                                 "m"          },
  { 111, "ASOB",      "averaged surface net downward shortwave radiation", "W m-2"      },
  { 112, "ATHB",      "averaged surface net downward longwave radiation",  "W m-2"      },
  { 113, "ASOB",      "averaged TOA net downward shortwave radiation",     "W m-2"      },
  { 114, "ATHB",      "averaged TOA outgoing longwave radiation",          "W m-2"      },
  { 115, "ASWDIR",    "direct downward sw radiation at the surface",       "W m-2"      },
  { 116, "ASWDIFD",   "diffuse downward sw radiation at the surface",      "W m-2"      },
  { 117, "ASWDIFU",   "diffuse upwnward sw radiation at the surface",      "W m-2"      },
  { 118, "ALWD",      "downward lw radiation at the surface",              "W m-2"      },
  { 119, "ALWU",      "upward lw radiation at the surface",                "W m-2"      },
  { 121, "ALHFL",     "averaged surface latent heat flux",                 "W m-2"      },
  { 122, "ASHFL",     "averaged surface sensible heat flux",               "W m-2"      },
  { 124, "AUMFL",     "averaged eastward stress",                          "Pa"         },
  { 125, "AVMFL",     "averaged northward stress",                         "Pa"         },
  { 128, "SUNSH",     "undefined",                                         "undefined"  },
  { 129, "SUNSH2",    "undefined",                                         "undefined"  },
  { 130, "SUN_SUM",   "undefined",                                         "undefined"  },
  { 131, "SUN_SUM2",  "undefined",                                         "undefined"  },
  { 133, "FCOR",      "undefined",                                         "undefined"  },
  { 134, "SKYVIEW",   "sky-view factor",                                   "1"          },
  { 137, "SWDIR_COR", "topo correction of direct solar radiarion",         "1"          },
};

static PAR cosmo201[] = {
  {   5, "APAB",      "&",                                                         "W m-2"      },
  {  13, "SOHR_RAD",  "&",                                                         "K s-1"      },
  {  14, "THHR_RAD",  "&",                                                         "K s-1"      },
  {  20, "DURSUN",    "duration of sunshine",                                      "s"          },
  {  29, "CLC",       "cloud area fraction",                                       "1"          },
  {  30, "CLC_SGS",   "grid scale cloud area fraction",                            "1"          },
  {  31, "QC",        "specific cloud liquid water content",                       "kg kg-1"    },
  {  33, "QI",        "specific cloud ice content",                                "kg kg-1"    },
  {  35, "QR",        "specific rain content",                                     "kg kg-1"    },
  {  36, "QS",        "specific snow content",                                     "kg kg-1"    },
  {  37, "TQR",       "total rain water content vertically integrated",            "kg m-2"     },
  {  38, "TQS",       "total snow content vertically integrated",                  "kg m-2"     },
  {  39, "QG",        "specific graupel content",                                  "kg kg-1"    },
  {  40, "TQG",       "total graupel content vertically integrated",               "kg m-2"     },
  {  41, "TWATER",    "cloud condensed water content",                             "kg m-2"     },
  {  42, "TDIV_HUM",  "atmosphere water divergence",                               "kg m-2"     },
  {  43, "QC_RAD",    "sub scale specific cloud liquid water content",             "kg kg-1"    },
  {  44, "QI_RAD",    "sub scale specific cloud ice content",                      "kg kg-1"    },
  {  61, "CLW_CON",   "convective cloud liquid water",                             "1"          },
  {  68, "HBAS_CON",  "height of convective cloud base",                           "m"          },
  {  69, "HTOP_CON",  "height of convective cloud top",                            "m"          },
  {  70, "HBAS_CONI", "height of convective cloud base",                           "m"          },
  {  71, "HTOP_CONI", "height of convective cloud top",                            "m"          },
  {  72, "BAS_CON",   "index of convective cloud base",                            "1"          },
  {  73, "TOP_CON",   "index of convective cloud top",                             "1"          },
  {  74, "DT_CON",    "convective tendency of temperature",                        "K s-1"      },
  {  75, "DQV_CON",   "convective tendency of specific humidity",                  "s-1"        },
  {  78, "DU_CON",    "convective tendency of u-wind component",                   "m s-2"      },
  {  79, "DV_CON",    "convective tendency of v-wind component",                   "m s-2"      },
  {  82, "HTOP_DC",   "height of dry convection top",                              "m"          },
  {  84, "HZEROCL",   "height of freezing level",                                  "m"          },
  {  85, "SNOWLMT",   "height of the snow fall limit in m above sea level",        "m"          },
  {  86, "HCBAS",     "height of cloud base",                                      "m"          },
  {  87, "HCTOP",     "height of cloud top",                                       "m"          },
  {  91, "C_T_LK",    "&",                                                         "1"          },
  {  92, "GAMSO_LK",  "&",                                                         "m-1"        },
  {  93, "DP_BS_LK",  "&",                                                         "m"          },
  {  94, "H_B1_LK",   "&",                                                         "m"          },
  {  95, "H_ML_LK",   "&",                                                         "m"          },
  {  96, "DEPTH_LK",  "lake depth",                                                "m"          },
  {  97, "FETCH_LK",  "wind fetch over lake",                                      "m"          },
  {  99, "QRS",       "precipitation water (water loading)",                       "1"          },
  { 100, "PRR_GSP",   "mass flux density of large scale rainfall",                 "kg m-2 s-1" },
  { 101, "PRS_GSP",   "mass flux density of large scale snowfall",                 "kg m-2 s-1" },
  { 102, "RAIN_GSP",  "large scale rainfall",                                      "kg m-2"     },
  { 111, "PRR_CON",   "mass flux density of convective rainfall",                  "kg m-2 s-1" },
  { 112, "PRS_CON",   "mass flux density of convective snowfall",                  "kg m-2 s-1" },
  { 113, "RAIN_CON",  "convective rainfall",                                       "kg m-2"     },
  { 129, "FRESHSNW",  "freshness of snow",                                         "undefined"  },
  { 131, "PRG_GSP",   "mass flux density of large scale graupel",                  "kg m-2 s-1" },
  { 132, "GRAU_GSP",  "large scale graupel",                                       "kg m-2"     },
  { 133, "RHO_SNOW",  "density of snow",                                           "kg m-3"     },
  { 139, "PP",        "deviation from reference pressure",                         "Pa"         },
  { 140, "RCLD",      "standard deviation of saturation deficit",                  "undefined"  },
  { 143, "CAPE_MU",   "cape of most unstable parcel",                              "J kg-1"     },
  { 144, "CIN_MU",    "convective inhibition of most unstable parcel",             "J kg-1"     },
  { 145, "CAPE_ML",   "cape of mean surface layer parcel",                         "J kg-1"     },
  { 146, "CIN_ML",    "convective inhibition of mean surface layer parcel",        "J kg-1"     },
  { 147, "TKE_CON",   "convective turbulent kinetic energy",                       "undefined"  },
  { 148, "TKETENS",   "tendency of turbulent kinetic energy",                      "undefined"  },
  { 152, "TKE",       "turbulent kinetic energy",                                  "m2 s-2"     },
  { 153, "TKVM",      "diffusion coefficient of momentum",                         "m2 s-1"     },
  { 154, "TKVH",      "diffusion coefficient of heat",                             "m2 s-1"     },
  { 170, "TCM",       "drag coefficient of momentum",                              "1"          },
  { 171, "TCH",       "drag coefficient of heat",                                  "1"          },
  { 187, "VMAX",      "maximum turbulent wind gust in 10m",                        "m s-1"      },
  { 190, "TSOIL",     "&",                                                         "K"          },
  { 191, "TSOIL",     "&",                                                         "K"          },
  { 192, "TSOIL",     "&",                                                         "K"          },
  { 193, "TSOIL",     "mixed layer temperature",                                   "K"          },
  { 194, "TSOIL",     "mean temperature of water column",                          "K"          },
  { 197, "TSOIL",     "soil temperature",                                          "K"          },
  { 198, "W_SO",      "soil water content",                                        "m"          },
  { 199, "W_SO_ICE",  "soil frozen water content",                                 "m"          },
  { 200, "W_I",       "canopy water amount",                                       "m"          },
  { 203, "TSOIL",     "snow surface temperature",                                  "K"          },
  { 215, "TSOIL",     "temperature of ice upper surface",                          "K"          },
  { 230, "dBZ",       "unattenuated radar reflectivity in Rayleigh approximation", "1"          },
  { 240, "MFLX_CON",  "convective mass flux density",                              "kg m-2 s-1" },
  { 241, "CAPE_CON",  "&",                                                         "J kg-1"     },
  { 243, "QCVG_CON",  "&",                                                         "s-1"        },
};

static PAR cosmo202[] = {
  {  46, "SSO_STDH",  "standard deviation of subgrid scale height",                "m"         },
  {  47, "SSO_GAMMA", "anisotropy of topography",                                  "-"         },
  {  48, "SSO_THETA", "angle between principal axis of orography and global east", "-"         },
  {  49, "SSO_SIGMA", "mean slope of subgrid scale orography",                     "-"         },
  {  55, "FR_LAKE",   "fraction of inland lake water",                             "1"         },
  {  57, "SOILTYP",   "soil type",                                                 "1"         },
  {  61, "LAI",       "leaf area index",                                           "1"         },
  {  62, "ROOTDP",    "root depth",                                                "m"         },
  {  64, "HMO3",      "air pressure at ozone maximum",                             "Pa"        },
  {  65, "VIO3",      "vertical integrated ozone amount",                          "Pa"        },
  {  67, "PLCOV_MX",  "vegetation area fraction maximum",                          "1"         },
  {  68, "PLCOV_MN",  "vegetation area fraction minimum",                          "1"         },
  {  69, "LAI_MX",    "leaf area index maximum",                                   "1"         },
  {  70, "LAI_MN",    "leaf area index minimum",                                   "1"         },
  {  75, "FOR_E",     "ground fraction covered by evergreen forest",               "-"         },
  {  76, "FOR_D",     "ground fraction covered by deciduous forest",               "-"         },
  { 104, "DQVDT",     "tendency of water vapor",                                   "s-1"       },
  { 105, "QVSFLX",    "surface flux of water vapour",                              "s-1m-2"    },
  { 113, "FC",        "coriolis parameter",                                        "s-1"       },
  { 114, "RLAT",      "latitude",                                                  "radian"    },
  { 115, "RLON",      "longitude",                                                 "radian"    },
  { 121, "ZTD",       "integrated total atmospheric refractivity",                 "undefined" },
  { 122, "ZWD",       "integrated wet atmospheric refractivity",                   "undefined" },
  { 123, "ZHD",       "integrated dry atmospheric refractivity",                   "undefined" },
  { 180, "O3",        "ozone mass mixing ratio",                                   "kg kg-1"   },
  { 200, "I131a",     "undefined",                                                 "undefined" },
  { 201, "I131a_DD",  "undefined",                                                 "undefined" },
  { 202, "I131a_WD",  "undefined",                                                 "undefined" },
  { 203, "Cs137",     "undefined",                                                 "undefined" },
  { 204, "Cs137_DD",  "undefined",                                                 "undefined" },
  { 205, "Cs137_WD",  "undefined",                                                 "undefined" },
  { 206, "Te132",     "undefined",                                                 "undefined" },
  { 207, "Te132_DD",  "undefined",                                                 "undefined" },
  { 208, "Te132_WD",  "undefined",                                                 "undefined" },
  { 209, "Zr95",      "undefined",                                                 "undefined" },
  { 210, "Zr95_DD",   "undefined",                                                 "undefined" },
  { 211, "Zr95_WD",   "undefined",                                                 "undefined" },
  { 212, "Kr85",      "undefined",                                                 "undefined" },
  { 213, "Kr85_DD",   "undefined",                                                 "undefined" },
  { 214, "Kr85_WD",   "undefined",                                                 "undefined" },
  { 215, "TRACER",    "undefined",                                                 "undefined" },
  { 216, "TRACER_DD", "undefined",                                                 "undefined" },
  { 217, "TRACER_WD", "undefined",                                                 "undefined" },
  { 218, "Xe133",     "undefined",                                                 "undefined" },
  { 219, "Xe133_DD",  "undefined",                                                 "undefined" },
  { 220, "Xe133_WD",  "undefined",                                                 "undefined" },
  { 221, "I131g",     "undefined",                                                 "undefined" },
  { 222, "I131g_DD",  "undefined",                                                 "undefined" },
  { 223, "I131g_WD",  "undefined",                                                 "undefined" },
  { 224, "I131o",     "undefined",                                                 "undefined" },
  { 225, "I131o_DD",  "undefined",                                                 "undefined" },
  { 226, "I131o_WD",  "undefined",                                                 "undefined" },
  { 227, "Ba140",     "undefined",                                                 "undefined" },
  { 228, "Ba140_DD",  "undefined",                                                 "undefined" },
  { 229, "Ba140_WD",  "undefined",                                                 "undefined" },
  { 230, "Sr90",      "undefined",                                                 "undefined" },
  { 231, "Sr90_DD",   "undefined",                                                 "undefined" },
  { 232, "Sr90_WD",   "undefined",                                                 "undefined" },
  { 233, "Ru103",     "undefined",                                                 "undefined" },
  { 234, "Ru103_DD",  "undefined",                                                 "undefined" },
  { 235, "Ru103_WD",  "undefined",                                                 "undefined" },
};

static PAR cosmo203[] = {
  { 135, "LCL_ML",   "undefined",                  "undefined" },
  { 136, "LFC_ML",   "undefined",                  "undefined" },
  { 137, "CAPE_3KM", "undefined",                  "undefined" },
  { 138, "SWISS00",  "swiss00 index",              "1"         },
  { 139, "SWISS12",  "swiss12 index",              "1"         },
  { 147, "SLI",      "surface lifted index",       "K"         },
  { 149, "SI",       "showalter index",            "K"         },
  { 155, "BRN",      "undefined",                  "undefined" },
  { 156, "HPBL",     "undefined",                  "undefined" },
  { 203, "CLDEPTH",  "normalized cloud depth",     "1"         },
  { 204, "CLCT_MOD", "modified_total_cloud_cover", "1"         },
};

static PAR cosmo205[] = {
  {   1, "SYNME5", "synthetic satellite images Meteosat5", "-" },
  {   2, "SYNME6", "synthetic satellite images Meteosat6", "-" },
  {   3, "SYNME7", "synthetic satellite images Meteosat7", "-" },
  {   4, "SYNMSG", "synthetic satellite images MSG",       "-" },
};

static PAR cosmo250[] = {
  {   1, "QNH",       "sea level air pressure",                                         "hPa"                                },
  {  11, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  12, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  13, "D_T_2M_K",  "kalman correction to 2m temperature",                            "K"                                  },
  {  14, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  15, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  16, "RH_ICE",    "relative humidity over ice",                                     "%"                                  },
  {  17, "TD",        "dew point temperature",                                          "K"                                  },
  {  18, "D_TD",      "dew point depression",                                           "K"                                  },
  {  19, "THETAE",    "equivalent potential temperature",                               "K"                                  },
  {  20, "TD_2M_K",   "2m dew point temperature",                                       "K"                                  },
  {  21, "D_TD_2M_K", "kalman correction to 2m dew point temperature",                  "K"                                  },
  {  22, "TD_2M_OLD", "2m dew point temperature",                                       "K"                                  },
  {  23, "TD_2M_BUZ", "2m dew point temperature",                                       "K"                                  },
  {  24, "HI",        "heat index",                                                     "Fahrenheit"                         },
  {  25, "DURSUN_M",  "maximum duration of sunshine",                                   "s"                                  },
  {  26, "DURSUN_R",  "relative duration of sunshine",                                  "%"                                  },
  {  52, "RH_2M_K",   "2m relative humidity",                                           "%"                                  },
  {  53, "D_RH_2M_K", "kalman correction to 2m relative humidity",                      "%"                                  },
  {  58, "CLI_RATIO", "cloud ice ratio (Qi/Qc+Qi)",                                     "%"                                  },
  {  61, "TOT_SNOW",  "total precipitation in snow",                                    "kg/m**2"                            },
  {  62, "TOT_RAIN",  "total precipitation in rain",                                    "kg/m**2"                            },
  {  63, "TOT_CON",   "total convective precipitation",                                 "kg/m**2"                            },
  {  64, "TOT_GSP",   "total large scale precipitation",                                "kg/m**2"                            },
  {  65, "SNOW_%",    "percentage of precipitation in snow",                            "%"                                  },
  {  66, "CONV_%",    "percentage of convective precipitation",                         "%"                                  },
  {  67, "VORTP_ABS", "absolute",                                                       "VORTP_ABS 67 -1 absolute vorticity" },
  {  68, "VORTP_REL", "relative",                                                       "VORTP_REL 68 -1 relative vorticity" },
  {  70, "PDIFF_CON", "pressure difference between cloud base and cloud top",           "Pa"                                 },
  {  71, "TTOP_CON",  "temperature at cloud top",                                       "K"                                  },
  {  80, "GEM",       "emissivity of the ground",                                       "%"                                  },
  {  82, "Z0LOC",     "local surface roughness length",                                 "m"                                  },
  { 110, "LUM",       "luminosity",                                                     "klux"                               },
  { 111, "GLOB",      "global shortwave radiation at surface",                          "W/m**2"                             },
  { 112, "LW_IN_TG",  "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 113, "LW_IN_TS",  "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 114, "LW_IN_T2M", "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 115, "SWISS_WE",  "Swiss",                                                          "SWISS_WE 115 1 Swiss coordinates"   },
  { 116, "SWISS_SN",  "Swiss",                                                          "SWISS_SN 116 1 Swiss coordinates"   },
  { 150, "KOINDEX",   "KO index",                                                       "K"                                  },
  { 151, "TTINDEX",   "total-totals index",                                             "K"                                  },
  { 152, "DCI",       "deep convection index",                                          "K"                                  },
  { 153, "SWEAT",     "severe weather thread index",                                    "undefined"                          },
  { 154, "ADEDO2",    "adedokun 2 index",                                               "K"                                  },
  { 160, "C_TSTORM",  "thunderstorm index using AdaBoost classifier",                   "undefined"                          },
  { 161, "CN_TSTORM", "thunderstorm probabilty using AdaBoost classifier",              "%"                                  },
  { 200, "WSHEARL",   "wind shear between surface and 3 km asl",                        "1/s"                                },
  { 201, "WSHEARM",   "wind shear between surface and 6 km asl",                        "1/s"                                },
  { 202, "WSHEARU",   "wind shear between 3 km (or surface) and 6 km asl",              "1/s"                                },
  { 211, "VWIN",      "maximum OLD turbulent wind gust in 10m",                         "m s-1"                              },
  { 212, "VW10M_20",  "maximum 10m wind speed",                                         "m s-1"                              },
  { 213, "VW10M_25",  "duration of VWIN_10M above 25 knots",                            "s"                                  },
  { 214, "VW10M_30",  "duration of VWIN_10M above 30 knots",                            "s"                                  },
  { 215, "VW10M_35",  "duration of VWIN_10M above 35 knots",                            "s"                                  },
  { 216, "VW10M_40",  "duration of VWIN_10M above 40 knots",                            "s"                                  },
  { 217, "VW10M_45",  "duration of VWIN_10M above 45 knots",                            "s"                                  },
  { 218, "VW10M_50",  "duration of VWIN_10M above 50 knots",                            "s"                                  },
  { 219, "VOLD",      "maximum turbulent wind gust in 10m",                             "m s-1"                              },
  { 220, "VJPS",      "maximum turbulent wind gust in 10m",                             "m s-1"                              },
  { 221, "VBRA",      "maximum Brasseur turbulent wind gust in 10m",                    "m s-1"                              },
  { 222, "VB10M_20",  "duration of VBRA_10M above 20 knots",                            "s"                                  },
  { 223, "VB10M_25",  "duration of VBRA_10M above 25 knots",                            "s"                                  },
  { 224, "VB10M_30",  "duration of VBRA_10M above 30 knots",                            "s"                                  },
  { 225, "VB10M_35",  "duration of VBRA_10M above 35 knots",                            "s"                                  },
  { 226, "VB10M_40",  "duration of VBRA_10M above 40 knots",                            "s"                                  },
  { 227, "VB10M_45",  "duration of VBRA_10M above 45 knots",                            "s"                                  },
  { 228, "VB10M_50",  "duration of VBRA_10M above 50 knots",                            "s"                                  },
  { 231, "VCON",      "maximum convective wind gust in 10m",                            "m s-1"                              },
  { 232, "VC10M_20",  "duration of VCON_10M above 20 knots",                            "s"                                  },
  { 233, "VC10M_25",  "duration of VCON_10M above 25 knots",                            "s"                                  },
  { 234, "VC10M_30",  "duration of VCON_10M above 30 knots",                            "s"                                  },
  { 235, "VC10M_35",  "duration of VCON_10M above 35 knots",                            "s"                                  },
  { 236, "VC10M_40",  "duration of VCON_10M above 40 knots",                            "s"                                  },
  { 237, "VC10M_45",  "duration of VCON_10M above 45 knots",                            "s"                                  },
  { 238, "VC10M_50",  "duration of VCON_10M above 50 knots",                            "s"                                  },
  { 241, "FMAX",      "maximum wind speed at k=ke",                                     "m s-1"                              },
  { 242, "USTARMAX",  "maximal u*=SQRT(Drag_coef)*fmax_10m",                            "m s-1"                              },
  { 243, "GLOB_DIF",  "global diffuse shortwave radiation at the surface",              "W/m**2"                             },
  { 244, "GLOB_DIR",  "global direct (beam) shortwave radiation at the surface",        "W/m**2"                             },
  { 245, "GLOB_vE",   "global shortwave radiation on a vertical surface facing east",   "W/m**2"                             },
  { 246, "GLOB_vS",   "global shortwave radiation on a vertical surface facing south",  "W/m**2"                             },
  { 247, "GLOB_vW",   "global shortwave radiation on a vertical surface facing west",   "W/m**2"                             },
  { 248, "GLOB_vN",   "global shortwave radiation on a vertical surface facing north",  "W/m**2"                             },
  { 249, "LW_TG_vS",  "incoming longwave radiation on a vertical surface facing south", "W/m**2"                             },
  { 250, "ENTH",      "enthalpy",                                                       "kJ/kg"                              },
  { 251, "ENTH",      "enthalpy",                                                       "kJ/kg"                              },
  { 252, "MIXRAT",    "mixing ratio",                                                   "g/kg"                               },
  { 253, "MIXRAT",    "mixing ratio",                                                   "g/kg"                               },
  { 254, "TW",        "wet bulb temperature",                                           "degC"                               },
  { 255, "TW",        "wet bulb temperature",                                           "degC"                               },
};


void
tableDefault(void)
{
  int tableID, instID, modelID;


  /*
   *  define table : echam4
   */

  instID  = institutInq(98, 255, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(98, 255, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "ECHAM4");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "ECHAM4");

  tableID = tableDef(modelID, 128, "echam4");

  tableLink(tableID, echam4, sizeof(echam4) / sizeof(PAR));

  /*
   *  define table : echam5
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "ECHAM5");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "ECHAM5");

  tableID = tableDef(modelID, 128, "echam5");

  tableLink(tableID, echam5, sizeof(echam5) / sizeof(PAR));

  /*
   *  define table : echam6
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "ECHAM6");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "ECHAM6");

  tableID = tableDef(modelID, 128, "echam6");

  tableLink(tableID, echam6, sizeof(echam6) / sizeof(PAR));

  /*
   *  define table : mpiom1
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "MPIOM1");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "MPIOM1");

  tableID = tableDef(modelID, 128, "mpiom1");

  tableLink(tableID, mpiom1, sizeof(mpiom1) / sizeof(PAR));

  /*
   *  define table : ecmwf
   */

  instID  = institutInq(0, 0, "ECMWF", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "ECMWF", NULL);

  modelID = modelInq(instID, 0, "");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "");

  tableID = tableDef(modelID, 128, "ecmwf");

  tableLink(tableID, ecmwf, sizeof(ecmwf) / sizeof(PAR));

  /*
   *  define table : remo
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "REMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "REMO");

  tableID = tableDef(modelID, 128, "remo");

  tableLink(tableID, remo, sizeof(remo) / sizeof(PAR));

  /*
   *  define table : cosmo002
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 002, "cosmo002");

  tableLink(tableID, cosmo002, sizeof(cosmo002) / sizeof(PAR));

  /*
   *  define table : cosmo201
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 201, "cosmo201");

  tableLink(tableID, cosmo201, sizeof(cosmo201) / sizeof(PAR));

  /*
   *  define table : cosmo202
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 202, "cosmo202");

  tableLink(tableID, cosmo202, sizeof(cosmo202) / sizeof(PAR));

  /*
   *  define table : cosmo203
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 203, "cosmo203");

  tableLink(tableID, cosmo203, sizeof(cosmo203) / sizeof(PAR));

  /*
   *  define table : cosmo205
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 205, "cosmo205");

  tableLink(tableID, cosmo205, sizeof(cosmo205) / sizeof(PAR));

  /*
   *  define table : cosmo250
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 250, "cosmo250");

  tableLink(tableID, cosmo250, sizeof(cosmo250) / sizeof(PAR));
}

#endif  /* _TABLE_H */
