/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2018 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef GRID_CELL_SEARCH_H
#define GRID_CELL_SEARCH_H

extern "C" {
#include "lib/yac/grid_cell.h"
}

enum struct CellSearchMethod
{
  spherepart,
  latbins
};

struct GridCellSearch
{
  CellSearchMethod method;

  bool is_reg2d;
  size_t dims[2];

  // reg2d search
  double gridBoundboxReg2d[4];
  double *reg2d_corner_lon, *reg2d_corner_lat;

  void *yacSrcGrid;
  void *yacSearch;
};


GridCellSearch *gridCellSearchCreateReg2d(size_t dims[2], const double *reg2d_corner_lon, const double *reg2d_corner_lat);
GridCellSearch *gridCellSearchCreate(size_t numCells, size_t numCellCorners, double *cellCornerLon, double *cellCornerLat);
void gridCellSearchDelete(GridCellSearch *gcs);
size_t doGridCellSearch(GridCellSearch *gcs, bool isLonLatCell, grid_cell &gridCell, size_t *srchAddr);

#endif
