(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

open Value
open Ident
open Lambda

val ns_table: Ns.table ref

val register_op: string -> (t list -> t) -> unit

val get_global: (Types.CompUnit.t -> int -> t) ref
val set_global: (Types.CompUnit.t -> int -> t -> unit) ref
val get_external: (Types.CompUnit.t -> int -> t) ref
val set_external: (Types.CompUnit.t -> int -> t -> unit) ref
val get_builtin: (string -> t) ref

val get_slot : Types.CompUnit.t -> int -> t
val set_slot : Types.CompUnit.t -> int -> t -> unit

val dump: Format.formatter -> unit
val push: Value.t -> unit
val var: var_loc -> t

val expr: Lambda.expr -> t
val eval_apply: t -> t -> t
val code_items: code_item list -> unit

val stack: t array ref

val new_stack: ('a -> 'b) -> 'a -> 'b

