/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include <ncursesw/ncurses.h>
#include <ncursesw/menu.h>
#include <ncursesw/form.h>

#include <nl_types.h>
#include <libintl.h>
#include "options.h"
#include "config.h"
#include "color.h"
#include "gettext.h"

struct optwins {
    WINDOW *main;
} optwin;

struct conf config;

void clear_main_win()
{
    WINDOW *subwin;
    
    subwin=derwin(optwin.main, 18, 58, 1, 1);
    werase(subwin);
    wrefresh(subwin);
}

void write_conf(struct conf config)
{
    FILE *conffile;
    char home[256], opt[41], prop[256];

    sprintf(home,"%.225s/.cdw.conf", getenv("HOME"));
    if ( (conffile = fopen(home, "w")) != NULL ){
	fprintf(conffile,"################################\n");
	fprintf(conffile,"#    cdw configuration file    #\n");
	fprintf(conffile,"################################\n");
	fprintf(conffile,"scsi-dev=%s\n",config.scsi);
	fprintf(conffile,"cdrwdevice=%s\n",config.cdrwdevice);
	fprintf(conffile,"tempdir=%s\n",config.tempdir);
	fprintf(conffile,"speed=%s\n",config.speed);
	fprintf(conffile,"blank=%s\n",config.blank);
	fprintf(conffile,"logfile=%s\n",config.logfile);
	fprintf(conffile,"other=%s\n",config.other);
	fprintf(conffile,"eject=%s\n",config.eject);
	fprintf(conffile,"dao=%s\n",config.dao);
	fprintf(conffile,"joliet=%s\n",config.joliet);
	fprintf(conffile,"rockridge=%s\n",config.rockridge);
	fprintf(conffile,"dummy=%s\n",config.dummy);
	fprintf(conffile,"volumeid=%s\n",config.volumeid);
	fprintf(conffile,"cdrom=%s\n",config.cdrom);
	fprintf(conffile,"usefulRR=%s\n",config.usefulRR);
	fprintf(conffile,"showlog=%s\n",config.showlog);
	fprintf(conffile,"showvol=%s\n",config.showvol);
	fprintf(conffile,"cdsize=%d\n",config.cdsize);
	fprintf(conffile,"pad=%s\n",config.pad);
	fprintf(conffile,"WriteFromImage=%s\n",config.fromimage);
	fprintf(conffile,"multi=%s\n",config.multi);
	fprintf(conffile,"burnproof=%s\n",config.burnproof);
	fprintf(conffile,"mountpoint=%s\n",config.mountpoint);
	fprintf(conffile,"autodic=%s\n",config.autodic);
	fprintf(conffile,"audiodir=%s\n",config.audiodir);
	fprintf(conffile,"stereo=%s\n",config.stereo);
	fprintf(conffile,"bitsperchn=%s\n",config.bitsperchn);
	fprintf(conffile,"echosound=%s\n",config.echosound);
	fprintf(conffile,"encode=%s\n",config.encode);
	fprintf(conffile,"lame=%s\n",config.lame);
	fprintf(conffile,"highq=%s\n",config.highq);
	fprintf(conffile,"bitrate=%s\n",config.bitrate);
	fprintf(conffile,"cdbhost=%s\n",config.cdbhost);
	fprintf(conffile,"cdbuser=%s\n",config.cdbuser);
	fprintf(conffile,"sqlite_file=%s\n",config.sqlite_file);
	fprintf(conffile,"bootimg=%s\n",config.bootimg);
	fclose(conffile);
    }
}

struct conf read_conf()
{
    FILE *conffile;
    char home[256], confhome[256], opt[41], prop[256];
    int line=0;
    
    sprintf(home,"%s", getenv("HOME"));
    sprintf(confhome,"%s/.cdw.conf", getenv("HOME"));
    strcpy(config.other,"\0");
    strcpy(config.scsi,"0,0,0\0");
    strcpy(config.cdrwdevice,"/dev/scd0\0");
    strcpy(config.tempdir,"/tmp/image.iso\0");
    strcpy(config.speed,"52\0");
    strcpy(config.blank,"fast\0");
    strcpy(config.logfile,"/var/log/cdw.log\0");
    strcpy(config.eject,"0\0");
    strcpy(config.dao,"0\0");
    strcpy(config.joliet,"1\0");
    strcpy(config.rockridge,"1\0");
    strcpy(config.dummy,"0\0");
    strcpy(config.volumeid,"cdrom\0");
    strcpy(config.cdrom,"/dev/cdrom\0");
    strcpy(config.usefulRR,"1\0");
    strcpy(config.showlog,"1\0");
    strcpy(config.showvol,"0\0");
    strcpy(config.pad,"1\0");
    strcpy(config.fromimage,"1\0");
    strcpy(config.multi,"0\0");
    strcpy(config.burnproof,"1\0");
    strcpy(config.mountpoint,"cdrom\0");
    sprintf(config.audiodir,"%s/audio\0", home);
    strcpy(config.stereo,"1\0");
    strcpy(config.bitsperchn,"16\0");
    strcpy(config.echosound,"0\0");
    strcpy(config.encode,"0\0");
    strcpy(config.lame,"0\0");
    strcpy(config.highq,"1\0");
    strcpy(config.bitrate,"192\0");
    strcpy(config.cdbhost,"localhost\0");
    strcpy(config.cdbuser,"root\0");
    sprintf(config.sqlite_file,"%s/cdw.db\0", home);
    sprintf(config.sqlite_file,"\0");
    config.cdsize=657;
    if ( (conffile = fopen(confhome, "r")) == NULL ){
	conffile = fopen(confhome, "w");
	fprintf(conffile,"################################\n#    cdw configuration file    #\n");
	fprintf(conffile,"################################\nscsi-dev=0,0,0\ntempdir=/tmp/image.iso\nspeed=52\nblank=fast\n");
	fprintf(conffile,"logfile=/tmp/cdw.log\neject=0\ndao=0\njoliet=1\nrockridge=1\nusefulRR=1\ndummy=0\nvolumeid=cdrom\ncdrom=/dev/cdrom\n");
	fprintf(conffile,"showlog=0\nshowvol=0\ncdsize=657\npad=1\nWriteFromImage=1\nmulti=0\nburnproof=1\ncdrwdevice=/dev/scd0\nmountpoint=/cdrom\nautodic=0\naudiodir=%s/audio\n", home);
	fprintf(conffile,"stereo=1\nbitsperchn=16\nechosound=0\nencode=0\nlame=0\nhighq=1\nbitrate=192\ncdbhost=localhost\ncdbuser=root\nsqlite_file=%s/cdw.db\nbootimg=\n", home);
	fclose(conffile);
	conffile = fopen(confhome, "r");
    }
    while (NULL != fgets(confhome, 255, conffile)) {
	if ( sscanf(confhome, "%30[^=]=%[^\n]", opt, prop) == 2 ) {
	    if ( (strcmp(opt,"scsi-dev")) == 0 )
		strcpy(config.scsi, prop);
	    if ( (strcmp(opt,"cdrwdevice")) == 0 )
		strcpy(config.cdrwdevice, prop);
	    if ( (strcmp(opt,"tempdir")) == 0 )
		strcpy(config.tempdir, prop);
	    if ( (strcmp(opt,"speed")) == 0 )
		strcpy(config.speed, prop);
	    if ( (strcmp(opt,"other")) == 0 )
		strcpy(config.other, prop);
	    if ( (strcmp(opt,"blank")) == 0 )
		strcpy(config.blank, prop);
	    if ( (strcmp(opt,"logfile")) == 0 )
		strcpy(config.logfile, prop);
	    if ( (strcmp(opt,"eject")) == 0 )
		strcpy(config.eject, prop);
	    if ( (strcmp(opt,"dao")) == 0 )
		strcpy(config.dao, prop);
	    if ( (strcmp(opt,"joliet")) == 0 )
		strcpy(config.joliet, prop);
	    if ( (strcmp(opt,"rockridge")) == 0 )
		strcpy(config.rockridge, prop);
	    if ( (strcmp(opt,"dummy")) == 0 )
		strcpy(config.dummy, prop);
	    if ( (strcmp(opt,"volumeid")) == 0 )
		strcpy(config.volumeid, prop);
	    if ( (strcmp(opt,"cdrom")) == 0 )
		strcpy(config.cdrom, prop);
	    if ( (strcmp(opt,"usefulRR")) == 0 )
		strcpy(config.usefulRR, prop);
	    if ( (strcmp(opt,"showlog")) == 0 )
		strcpy(config.showlog, prop);
	    if ( (strcmp(opt,"showvol")) == 0 )
		strcpy(config.showvol, prop);
	    if ( (strcmp(opt,"cdsize")) == 0 )
		config.cdsize=atoi(prop);
	    if ( (strcmp(opt,"pad")) == 0 )
		strcpy(config.pad, prop);
	    if ( (strcmp(opt,"WriteFromImage")) == 0 )
		strcpy(config.fromimage, prop);
	    if ( (strcmp(opt,"multi")) == 0 )
		strcpy(config.multi, prop);
	    if ( (strcmp(opt,"burnproof")) == 0 )
		strcpy(config.burnproof, prop);
	    if ( (strcmp(opt,"mountpoint")) == 0 )
		strcpy(config.mountpoint, prop);
	    if ( (strcmp(opt,"autodic")) == 0 )
		strcpy(config.autodic, prop);
	    if ( (strcmp(opt,"audiodir")) == 0 )
		strcpy(config.audiodir, prop);
	    if ( (strcmp(opt,"stereo")) == 0 )
		strcpy(config.stereo, prop);
	    if ( (strcmp(opt,"bitsperchn")) == 0 )
		strcpy(config.bitsperchn, prop);
	    if ( (strcmp(opt,"echosound")) == 0 )
		strcpy(config.echosound, prop);
	    if ( (strcmp(opt,"encode")) == 0 )
		strcpy(config.encode, prop);
	    if ( (strcmp(opt,"lame")) == 0 )
		strcpy(config.lame, prop);
	    if ( (strcmp(opt,"highq")) == 0 )
		strcpy(config.highq, prop);
	    if ( (strcmp(opt,"bitrate")) == 0 )
		strcpy(config.bitrate, prop);
	    if ( (strcmp(opt,"cdbhost")) == 0 )
		strcpy(config.cdbhost, prop);
    	    if ( (strcmp(opt,"cdbuser")) == 0 )
		strcpy(config.cdbuser, prop);
	    if ( (strcmp(opt,"sqlite_file")) == 0 )
	    	strcpy(config.sqlite_file, prop);
	    if ( (strcmp(opt,"bootimg")) == 0 )
	    	strcpy(config.bootimg, prop);
	}
    }
    fclose(conffile);
    return config;
}

int inbox(WINDOW *input, char *init)
{
    int in_x, ch=0, i, pos;
    char instr[256], instr2[256];

    keypad(input, TRUE);
    werase(input);
    strcpy(instr, init);
    if ( strlen(init)==0 )
	instr[0]='\0';
    else
	strcpy(instr, init);
    if (strlen(init)<getmaxx(input)-1){
    	mvwprintw(input, 0, 0, init);
	pos=strlen(instr);
    }
    else {
	for (i=strlen(init)-(getmaxx(input)/2)-1; i<strlen(init); i++){
		waddch(input, instr[i]);
	}
	pos=(getmaxx(input)/2)+1;
    }
    in_x=strlen(instr);
    while ( (ch!=10) && (ch!=27) ) {
	ch=wgetch(input);
	if ( ch==27 ) {
	    strcpy(instr, init);
	}
	if ( (ch==KEY_BACKSPACE || ch==KEY_DC) && in_x>0) {
	    instr[in_x-1]='\0';
	    in_x--;
	    pos--;
	    mvwaddch(input, 0, pos, ' ');
	    wmove(input, 0, pos);
	    if ((pos==(getmaxx(input)/2)-1) && (in_x>(getmaxx(input)/2)+1)){
		werase(input);
		if (in_x-(getmaxx(input)-1)>=0){
		   for (i=in_x-(getmaxx(input)-1); i<in_x; i++){
			waddch(input, instr[i]);
		   }
		   pos=getmaxx(input)-1;
		}
		else {
		   for (i=0; i<in_x; i++){
			waddch(input, instr[i]);
		   }
		   pos=in_x;
		}
	    } 
	}
	if ( isprint(ch) ) {
	   if (pos<getmaxx(input)-1){
	    	waddch(input, ch);
	    	instr[in_x]=ch;
	    	instr[in_x+1]='\0';
	    	in_x++;
		pos++;
	   } 
	   if (pos==getmaxx(input)-1){
		werase(input);
	//	instr[in_x]=ch;
	//	instr[in_x+1]='\0';
		for (i=in_x-(getmaxx(input)/2); i<in_x; i++){
			waddch(input, instr[i]);
		}
	//	in_x++;
		pos=(getmaxx(input)/2);
	   }
	}
	wrefresh(input);    
    }
    strcpy(init, instr);
    if (ch==27) return 0;
    else return 1;
}

int inpass(WINDOW *input, char *init)
{
    int in_x, ch=0, i, pos;
    char instr[256], instr2[256];

    keypad(input, TRUE);
    werase(input);
    strcpy(instr, init);
    if ( strlen(init)==0 )
	instr[0]='\0';
    else
	strcpy(instr, init);
    if (strlen(init)<getmaxx(input)-1){
    	mvwprintw(input, 0, 0, init);
	pos=strlen(instr);
    }
    else {
	for (i=strlen(init)-(getmaxx(input)/2)-1; i<strlen(init); i++){
		waddch(input, '*');
	}
	pos=(getmaxx(input)/2)+1;
    }
    in_x=strlen(instr);
    while ( (ch!=10) && (ch!=27) ) {
	ch=wgetch(input);
	if (( ch==27 )){
	    strcpy(instr, init);
	}
	if ( ch==KEY_BACKSPACE && in_x>0) {
	    instr[in_x-1]='\0';
	    in_x--;
	    pos--;
	    mvwaddch(input, 0, pos, ' ');
	    wmove(input, 0, pos);
	    if ((pos==(getmaxx(input)/2)-1) && (in_x>(getmaxx(input)/2)+1)){
		werase(input);
		if (in_x-(getmaxx(input)-1)>=0){
		   for (i=in_x-(getmaxx(input)-1); i<in_x; i++){
			waddch(input, '*');
		   }
		   pos=getmaxx(input)-1;
		}
		else {
		   for (i=0; i<in_x; i++){
			waddch(input, '*');
		   }
		   pos=in_x;
		}
	    } 
	}
	if ( isprint(ch) ) {
	   if (pos<getmaxx(input)-1){
	    	waddch(input, '*');
	    	instr[in_x]=ch;
	    	instr[in_x+1]='\0';
	    	in_x++;
		pos++;
	   } 
	   if (pos==getmaxx(input)-1){
		werase(input);
	//	instr[in_x]=ch;
	//	instr[in_x+1]='\0';
		for (i=in_x-(getmaxx(input)/2); i<in_x; i++){
			waddch(input, '*');
		}
	//	in_x++;
		pos=(getmaxx(input)/2);
	   }
	}
	wrefresh(input);    
    }
    
    strcpy(init, instr);
    if (ch==27) 
	return 0;
    else 
	return 1;
}

int input_passwd(char *title, char *label, char *prop)
{
    WINDOW *volwin, *edit;
    int ret;
      
    volwin=newwin(10,30,(LINES-10)/2,(COLS-30)/2);
    wbkgd(volwin, COLOR_PAIR(2));
    werase(volwin);
    box(volwin,0,0);
    mvwaddch(volwin, 0, 2, ACS_RTEE);
    mvwprintw(volwin, 0, 3, " %s ", _(title));
    waddch(volwin, ACS_LTEE);
    mvwprintw(volwin, 3, 3, _(label));
    wrefresh(volwin);
    edit=derwin(volwin, 1, 24, 5, 3);
    wbkgd(edit, COLOR_PAIR(6));
    werase(edit);
    wrefresh(edit);
    ret=inpass(edit, prop);
}

void put_ckbox(WINDOW *win, int y, int x)
{
    mvwprintw(win, y, x, "[");
    mvwprintw(win, y, x+2, "]");
}

static int page_one()
{
    char *in;
    int ch, i;
    int pos;
    char tempstr[30], catfile[256];
    FIELD *field[43];
    FORM *form_page[1];

    clear_main_win();
        
    field[0]=new_field(1, 20, 1, 1, 0, 0);
    set_field_buffer(field[0], 0, _("SCSI device"));    
    field[1]=new_field(1, 12, 1, 22, 0, 0);
    set_field_buffer(field[1], 0, config.scsi);

    field[2]=new_field(1, 19, 1, 34, 0, 0);
    set_field_buffer(field[2], 0, _("Speed"));
    field[3]=new_field(1, 3, 1, 54, 0, 0);
    set_field_buffer(field[3], 0, config.speed);

    field[4]=new_field(1, 20, 2, 1, 0, 0);
    set_field_buffer(field[4], 0, _("Image file"));
    field[5]=new_field(1, 35, 2, 22, 0, 0);
    set_field_buffer(field[5], 0, config.tempdir);
    
    field[6]=new_field(1, 24, 3, 29, 0, 0);
    set_field_buffer(field[6], 0, _("Write CD from image"));
    field[7]=new_field(1, 1, 3, 55, 0, 0);
    set_field_buffer(field[7], 0, (!strncmp(config.fromimage, "1", 1)?"X":"_"));

    field[8]=new_field(1, 20, 4, 1, 0, 0);
    set_field_buffer(field[8], 0, _("Logfile"));
    field[9]=new_field(1, 35, 4, 22, 0, 0);
    set_field_buffer(field[9], 0, config.logfile);
    
    field[10]=new_field(1, 20, 5, 1, 0, 0);
    set_field_buffer(field[10], 0, _("CD-ROM"));
    field[11]=new_field(1, 35, 5, 22, 0, 0);
    set_field_buffer(field[11], 0, config.cdrom);
    
    field[12]=new_field(1, 20, 6, 1, 0, 0);
    set_field_buffer(field[12], 0, _("CD-RW device"));
    field[13]=new_field(1, 35, 6, 22, 0, 0);
    set_field_buffer(field[13], 0, config.cdrwdevice);
    
    field[14]=new_field(1, 20, 7, 1, 0, 0);
    set_field_buffer(field[14], 0, _("Volume ID"));
    field[15]=new_field(1, 35, 7, 22, 0, 0);
    set_field_buffer(field[15], 0, config.volumeid);
    
    field[16]=new_field(1, 20, 8, 1, 0, 0);
    set_field_buffer(field[16], 0, _("Blank fast"));
    field[17]=new_field(1, 1, 8, 23, 0, 0);
    set_field_buffer(field[17], 0, (!strncmp(config.blank, "fast", 4)?"X":"_"));
    
    field[18]=new_field(1, 24, 8, 29, 0, 0);
    set_field_buffer(field[18], 0, _("Eject when done"));
    field[19]=new_field(1, 1, 8, 55, 0, 0);
    set_field_buffer(field[19], 0, (!strncmp(config.eject, "1", 1)?"X":"_"));
    
    field[20]=new_field(1, 20, 9, 1, 0, 0);
    set_field_buffer(field[20], 0, _("Disk at once"));
    field[21]=new_field(1, 1, 9, 23, 0, 0);
    set_field_buffer(field[21], 0, (!strncmp(config.dao, "1", 1)?"X":"_"));
    
    field[22]=new_field(1, 24, 9, 29, 0, 0);
    set_field_buffer(field[22], 0, _("Joliet information"));
    field[23]=new_field(1, 1, 9, 55, 0, 0);
    set_field_buffer(field[23], 0, (!strncmp(config.joliet, "1", 1)?"X":"_"));
    
    field[24]=new_field(1, 20, 10, 1, 0, 0);
    set_field_buffer(field[24], 0, _("Rock Ridge"));
    field[25]=new_field(1, 1, 10, 23, 0, 0);
    set_field_buffer(field[25], 0, (!strncmp(config.rockridge, "1", 1)?"X":"_"));
    
    field[26]=new_field(1, 24, 10, 29, 0, 0);
    set_field_buffer(field[26], 0, _("Useful RR attributes"));
    field[27]=new_field(1, 1, 10, 55, 0, 0);
    set_field_buffer(field[27], 0, (!strncmp(config.usefulRR, "1", 1)?"X":"_"));
    
    field[28]=new_field(1, 20, 11, 1, 0, 0);
    set_field_buffer(field[28], 0, _("Dummy write"));
    field[29]=new_field(1, 1, 11, 23, 0, 0);
    set_field_buffer(field[29], 0, (!strncmp(config.dummy, "1", 1)?"X":"_"));
    
    field[30]=new_field(1, 24, 11, 29, 0, 0);
    set_field_buffer(field[30], 0, _("Show log after write"));
    field[31]=new_field(1, 1, 11, 55, 0, 0);
    set_field_buffer(field[31], 0, (!strncmp(config.showlog, "1", 1)?"X":"_"));
    
    field[32]=new_field(1, 20, 12, 1, 0, 0);
    set_field_buffer(field[32], 0, _("Auto show volume"));
    field[33]=new_field(1, 1, 12, 23, 0, 0);
    set_field_buffer(field[33], 0, (!strncmp(config.showvol, "1", 1)?"X":"_"));
    
    field[34]=new_field(1, 24, 12, 29, 0, 0);
    set_field_buffer(field[34], 0, _("Pad"));
    field[35]=new_field(1, 1, 12, 55, 0, 0);
    set_field_buffer(field[35], 0, (!strncmp(config.pad, "1", 1)?"X":"_"));
    
    field[36]=new_field(1, 20, 13, 1, 0, 0);
    set_field_buffer(field[36], 0, _("Multi-session"));
    field[37]=new_field(1, 1, 13, 23, 0, 0);
    set_field_buffer(field[37], 0, (!strncmp(config.multi, "1", 1)?"X":"_"));
    
    field[38]=new_field(1, 24, 13, 29, 0, 0);
    set_field_buffer(field[38], 0, _("Burnproof"));
    field[39]=new_field(1, 1, 13, 55, 0, 0);
    set_field_buffer(field[39], 0, (!strncmp(config.burnproof, "1", 1)?"X":"_"));
    
    field[40]=new_field(1, 20, 14, 1, 0, 0);
    set_field_buffer(field[40], 0, _("Boot image"));
    field[41]=new_field(1, 35, 14, 22, 0, 0);
    set_field_buffer(field[41], 0, config.bootimg);
    
    field[42]=NULL;
    /* Input fields */
    for (i=1; i<=21; i++) { 
	switch (i){
	    case 1:
	    case 2:
	    case 3:
	    case 5:
	    case 6:
	    case 7:
	    case 8:
	    case 21:
		switch(i) {
		    case 1:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "^(ATAPI:|REMOTE:){0,1}[0-9],[0-9],[0-9]");
			break;
		    case 2:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "[0-9]{1,2}");
			break;
		}
		set_field_back(field[(i*2)-1], COLOR_PAIR(6));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(6));
		break;
	    default:
		set_field_type(field[(i*2)-1], TYPE_REGEXP, "^(X|_)$");
		set_field_back(field[(i*2)-1], COLOR_PAIR(2));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(2));
		break;
	}
    }
    /* Lables */
    for (i=1; i<=21; i++) {
	set_field_just(field[(i*2)-2], JUSTIFY_RIGHT);
	field_opts_off(field[(i*2)-2], O_ACTIVE);
	set_field_back(field[(i*2)-2], COLOR_PAIR(2));
	set_field_fore(field[(i*2)-2], COLOR_PAIR(2));
    }

    form_page[0]=new_form(field);
    set_form_win(form_page[0], optwin.main);
    set_form_sub(form_page[0], derwin(optwin.main, 18, 58, 1, 1));
    post_form(form_page[0]);
    
    put_ckbox(optwin.main, 4, 55);
    put_ckbox(optwin.main, 9, 23);
    put_ckbox(optwin.main, 9, 55);
    put_ckbox(optwin.main, 10, 23);
    put_ckbox(optwin.main, 10, 55);
    put_ckbox(optwin.main, 11, 23);
    put_ckbox(optwin.main, 11, 55);
    put_ckbox(optwin.main, 12, 23);
    put_ckbox(optwin.main, 12, 55);
    put_ckbox(optwin.main, 13, 23);
    put_ckbox(optwin.main, 13, 55);
    put_ckbox(optwin.main, 14, 23);
    put_ckbox(optwin.main, 14, 55);
    mvwaddch(optwin.main, 17, 0, ACS_VLINE);
    mvwaddch(optwin.main, 17, 15, ACS_ULCORNER);
    mvwaddch(optwin.main, 18, 15, ACS_VLINE);
    mvwprintw(optwin.main, 18, 1, _("<F1> General"));
    mvwhline(optwin.main, 17, 16, ACS_HLINE, 43);
    mvwaddch(optwin.main, 17, 59, ACS_RTEE);
    mvwprintw(optwin.main, 18, 18, _("<F2> Other"));
    mvwaddch(optwin.main, 18, 30, ACS_VLINE);

    form_driver(form_page[0], REQ_END_LINE);
    wrefresh(optwin.main);
    
    while ( (ch=wgetch(optwin.main)) != 27 ){
	switch(ch){
	    case KEY_HOME:
		form_driver(form_page[0], REQ_BEG_LINE);
		break;
	    case KEY_END:
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_LEFT:
		form_driver(form_page[0], REQ_PREV_CHAR);
		break;
	    case KEY_RIGHT:
		form_driver(form_page[0], REQ_NEXT_CHAR);
		break;
	    case KEY_DOWN:
		form_driver(form_page[0], REQ_NEXT_FIELD);
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_UP:
		form_driver(form_page[0], REQ_PREV_FIELD);
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_BACKSPACE:
		form_driver(form_page[0], REQ_DEL_PREV);
		break;
	    case KEY_DC:
		form_driver(form_page[0], REQ_DEL_CHAR);
		break;
	    // case KEY_F(2): not in this release
	    case KEY_F(10):
		// return main loop
		form_driver(form_page[0], REQ_VALIDATION);
		sprintf(config.scsi, rtrim(field_buffer(field[1], 0)));
		sprintf(config.speed, rtrim(field_buffer(field[3], 0)));
		sprintf(config.tempdir, rtrim(field_buffer(field[5], 0)));
		sprintf(config.fromimage, (!strncmp(field_buffer(field[7], 0), "X", 1)?"1":"0"));
		sprintf(config.logfile, rtrim(field_buffer(field[9], 0)));
		sprintf(config.cdrom, rtrim(field_buffer(field[11], 0)));
		sprintf(config.cdrwdevice, rtrim(field_buffer(field[13], 0)));
		sprintf(config.volumeid, rtrim(field_buffer(field[15], 0)));
		sprintf(config.blank, (!strncmp(field_buffer(field[17], 0), "X", 1)?"fast":"all"));
		sprintf(config.eject, (!strncmp(field_buffer(field[19], 0), "X", 1)?"1":"0"));
		sprintf(config.dao, (!strncmp(field_buffer(field[21], 0), "X", 1)?"1":"0"));
		sprintf(config.joliet, (!strncmp(field_buffer(field[23], 0), "X", 1)?"1":"0"));
		sprintf(config.rockridge, (!strncmp(field_buffer(field[25], 0), "X", 1)?"1":"0"));
		sprintf(config.usefulRR, (!strncmp(field_buffer(field[27], 0), "X", 1)?"1":"0"));
		sprintf(config.dummy, (!strncmp(field_buffer(field[29], 0), "X", 1)?"1":"0"));
		sprintf(config.showlog, (!strncmp(field_buffer(field[31], 0), "X", 1)?"1":"0"));
		sprintf(config.showvol, (!strncmp(field_buffer(field[33], 0), "X", 1)?"1":"0"));
		sprintf(config.pad, (!strncmp(field_buffer(field[35], 0), "X", 1)?"1":"0"));
		sprintf(config.multi, (!strncmp(field_buffer(field[37], 0), "X", 1)?"1":"0"));
		sprintf(config.burnproof, (!strncmp(field_buffer(field[39], 0), "X", 1)?"1":"0"));
		sprintf(config.bootimg, rtrim(field_buffer(field[41], 0)));
		return ch;
		break;
	    default:
		if (ch==' ') {
		    FIELD *cur;
		    int fld_index;

		    cur=current_field(form_page[0]);
		    fld_index=field_index(cur);
		    switch (fld_index) {
			case 7:
			case 17:
			case 19:
			case 21:
			case 23:
			case 25:
			case 27:
			case 29:
			case 31:
			case 33:
			case 35:
			case 37:
			case 39:
			    ch=(!strncmp(field_buffer(cur, 0), "X", 1)?'_':'X');
			    if ((fld_index==7) && (!strcmp(field_buffer(field[7], 0), "_"))){
				set_field_buffer(field[37], 0, "_");
			    }
			    if ((fld_index==37) && (!strcmp(field_buffer(field[37], 0), "_"))){
				set_field_buffer(field[7], 0, "_");
			    }
			    break;
		    }
		}
		form_driver(form_page[0], ch);
		break;
	    wrefresh(optwin.main);
	}
    }
    unpost_form(form_page[0]);
    free_form(form_page[0]);
    for (i=0; i<40; i++) free_field(field[i]);
    return ch;
}

static int page_two()
{
    char *in;
    int ch, i;
    int pos;
    char tempstr[30], catfile[256];
    FIELD *field[27];
    FORM *form_page[1];
    
    clear_main_win();
    
    field[0]=new_field(1, 20, 1, 1, 0, 0);
    set_field_buffer(field[0], 0, _("CD mountpoint"));    
    field[1]=new_field(1, 35, 1, 22, 0, 0);
    set_field_buffer(field[1], 0, config.mountpoint);
    
    field[2]=new_field(1, 20, 2, 1, 0, 0);
    set_field_buffer(field[2], 0, _("MySQL host"));    
    field[3]=new_field(1, 35, 2, 22, 0, 0);
    set_field_buffer(field[3], 0, config.cdbhost);
    
    field[4]=new_field(1, 20, 3, 1, 0, 0);
    set_field_buffer(field[4], 0, _("MySQL user"));    
    field[5]=new_field(1, 6, 3, 22, 0, 0);
    set_field_buffer(field[5], 0, config.cdbuser);
    
    field[6]=new_field(1, 24, 3, 29, 0, 0);
    set_field_buffer(field[6], 0, _("Auto Disk Catalog"));
    field[7]=new_field(1, 1, 3, 55, 0, 0);
    set_field_buffer(field[7], 0, (!strncmp(config.autodic, "1", 1)?"X":"_"));

    field[8]=new_field(1, 20, 4, 1, 0, 0);
    set_field_buffer(field[8], 0, _("SQLite DB file"));    
    field[9]=new_field(1, 35, 4, 22, 0, 0);
    set_field_buffer(field[9], 0, config.sqlite_file);
    
    field[10]=new_field(1, 20, 5, 1, 0, 0);
    set_field_buffer(field[10], 0, _("Audio directory"));    
    field[11]=new_field(1, 35, 5, 22, 0, 0);
    set_field_buffer(field[11], 0, config.audiodir);
    
    field[12]=new_field(1, 20, 6, 1, 0, 0);
    set_field_buffer(field[12], 0, _("Grab stereo mode"));
    field[13]=new_field(1, 1, 6, 23, 0, 0);
    set_field_buffer(field[13], 0, (!strncmp(config.stereo, "1", 1)?"X":"_"));
    
    field[14]=new_field(1, 24, 6, 29, 0, 0);
    set_field_buffer(field[14], 0, _("Bits per channel"));
    field[15]=new_field(1, 3, 6, 54, 0, 0);
    set_field_buffer(field[15], 0, config.bitsperchn);
    
    field[16]=new_field(1, 20, 7, 1, 0, 0);
    set_field_buffer(field[16], 0, _("Echo to sound dev."));
    field[17]=new_field(1, 1, 7, 23, 0, 0);
    set_field_buffer(field[17], 0, (!strncmp(config.echosound, "1", 1)?"X":"_"));
    
    field[18]=new_field(1, 20, 8, 1, 0, 0);
    set_field_buffer(field[18], 0, _("Encode to Ogg Vorbis"));
    field[19]=new_field(1, 1, 8, 23, 0, 0);
    set_field_buffer(field[19], 0, (!strncmp(config.encode, "1", 1)?"X":"_"));
    
    field[20]=new_field(1, 24, 8, 29, 0, 0);
    set_field_buffer(field[20], 0, _("High Quality"));
    field[21]=new_field(1, 1, 8, 55, 0, 0);
    set_field_buffer(field[21], 0, (!strncmp(config.highq, "1", 1)?"X":"_"));
    
    field[22]=new_field(1, 20, 9, 1, 0, 0);
    set_field_buffer(field[22], 0, _("Encode to Mp3"));
    field[23]=new_field(1, 1, 9, 23, 0, 0);
    set_field_buffer(field[23], 0, (!strncmp(config.lame, "1", 1)?"X":"_"));
    
    field[24]=new_field(1, 24, 9, 29, 0, 0);
    set_field_buffer(field[24], 0, _("Bitrate"));
    field[25]=new_field(1, 4, 9, 54, 0, 0);
    set_field_buffer(field[25], 0, config.bitrate);
    
    field[26]=NULL;
    /* Input fields */
    for (i=1; i<=13; i++) { 
	switch (i){
#ifndef HAVE_LIBMYSQLCLIENT
	    case 2:
	    case 3:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef HAVE_LIBSQLITE
	    case 5:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef OGGENC
	    case 10:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef LAME
	    case 12:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
	    case 1:
#ifdef HAVE_LIBMYSQLCLIENT
	    case 2:
	    case 3:
#endif
#ifdef HAVE_LIBSQLITE
	    case 5:
#endif
	    case 6:
	    case 8:
	    case 13:
		switch(i) {
		    case 8:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "(8|12|16)+");
			break;
		    case 13:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "(32|56|64|96|128|192|320)+");
			break;
		}
		set_field_back(field[(i*2)-1], COLOR_PAIR(6));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(6));
		break;
	    default:
		set_field_type(field[(i*2)-1], TYPE_REGEXP, "^(X|_)$");
		set_field_back(field[(i*2)-1], COLOR_PAIR(2));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(2));
		break;
	}
    }
    /* Lables */
    for (i=1; i<=13; i++) {
	set_field_just(field[(i*2)-2], JUSTIFY_RIGHT);
	field_opts_off(field[(i*2)-2], O_ACTIVE);
	switch (i){
#ifndef HAVE_LIBMYSQLCLIENT
	    case 2:
	    case 3:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef HAVE_LIBSQLITE
	    case 5:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef OGGENC
	    case 10:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef LAME
	    case 12:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
	    default:
		set_field_back(field[(i*2)-2], COLOR_PAIR(2));
		set_field_fore(field[(i*2)-2], COLOR_PAIR(2));
		break;
	}
    }
    
    form_page[0]=new_form(field);
    set_form_win(form_page[0], optwin.main);
    set_form_sub(form_page[0], derwin(optwin.main, 18, 58, 1, 1));

    post_form(form_page[0]);
    put_ckbox(optwin.main, 4, 55);
    put_ckbox(optwin.main, 7, 23);
    put_ckbox(optwin.main, 8, 23);
#ifdef OGGENC
    put_ckbox(optwin.main, 9, 23);
#endif
    put_ckbox(optwin.main, 9, 55);
#ifdef LAME
    put_ckbox(optwin.main, 10, 23);
#endif
    mvwaddch(optwin.main, 17, 0, ACS_LTEE);
    mvwhline(optwin.main, 17, 1, ACS_HLINE, 15);
    mvwaddch(optwin.main, 17, 15, ACS_URCORNER);
    mvwaddch(optwin.main, 18, 15, ACS_VLINE);
    mvwprintw(optwin.main, 18, 1, _("<F1> General"));
    mvwaddch(optwin.main, 17, 30, ACS_ULCORNER);
    mvwhline(optwin.main, 17, 31, ACS_HLINE, 28);
    mvwaddch(optwin.main, 17, 59, ACS_RTEE);
    mvwprintw(optwin.main, 18, 18, _("<F2> Other"));
    mvwaddch(optwin.main, 18, 30, ACS_VLINE);
    
    form_driver(form_page[0], REQ_END_LINE);
    wrefresh(optwin.main);
    ch=0;
    while ( (ch=wgetch(optwin.main)) != 27 ){
	switch(ch){
	    case KEY_HOME:
		form_driver(form_page[0], REQ_BEG_LINE);
		break;
	    case KEY_END:
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_LEFT:
		form_driver(form_page[0], REQ_PREV_CHAR);
		break;
	    case KEY_RIGHT:
		form_driver(form_page[0], REQ_NEXT_CHAR);
		break;
	    case KEY_DOWN:
		form_driver(form_page[0], REQ_NEXT_FIELD);
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_UP:
		form_driver(form_page[0], REQ_PREV_FIELD);
		form_driver(form_page[0], REQ_END_LINE);
		break;
	    case KEY_BACKSPACE:
		form_driver(form_page[0], REQ_DEL_PREV);
		break;
	    case KEY_DC:
		form_driver(form_page[0], REQ_DEL_CHAR);
		break;
	    case KEY_F(1):
	    case KEY_F(10):
		form_driver(form_page[0], REQ_VALIDATION);
		sprintf(config.mountpoint, rtrim(field_buffer(field[1], 0)));
		sprintf(config.cdbhost, rtrim(field_buffer(field[3], 0)));
		sprintf(config.cdbuser, rtrim(field_buffer(field[5], 0)));
		sprintf(config.autodic, (!strncmp(field_buffer(field[7], 0), "X", 1)?"1":"0"));
		sprintf(config.audiodir, rtrim(field_buffer(field[11], 0)));
		sprintf(config.stereo, (!strncmp(field_buffer(field[13], 0), "X", 1)?"1":"0"));
		sprintf(config.bitsperchn, rtrim(field_buffer(field[15], 0)));
		sprintf(config.echosound, (!strncmp(field_buffer(field[17], 0), "X", 1)?"1":"0"));
		sprintf(config.encode, (!strncmp(field_buffer(field[19], 0), "X", 1)?"1":"0"));
		sprintf(config.highq, (!strncmp(field_buffer(field[21], 0), "X", 1)?"1":"0"));
		sprintf(config.lame, (!strncmp(field_buffer(field[23], 0), "X", 1)?"1":"0"));
		sprintf(config.bitrate, rtrim(field_buffer(field[25], 0)));
		sprintf(config.sqlite_file, rtrim(field_buffer(field[9], 0)));
		return ch;
		break;
	    default:
		if (ch==' ') {
		    FIELD *cur;
		    int fld_index;

		    cur=current_field(form_page[0]);
		    fld_index=field_index(cur);
		    switch (fld_index) {
			case 7:
			case 13:
			case 17:
			case 19:
			case 21:
			case 23:
			    ch=(!strncmp(field_buffer(cur, 0), "X", 1)?'_':'X');
			    if ((fld_index==19) && (!strcmp(field_buffer(field[19], 0), "_"))){
				set_field_buffer(field[23], 0, "_");
			    }
			    if ((fld_index==23) && (!strcmp(field_buffer(field[23], 0), "_"))){
				set_field_buffer(field[19], 0, "_");
			    }
			    break;
		    }
		}
		form_driver(form_page[0], ch);
		break;
	wrefresh(optwin.main);
	}
    }
    ch=KEY_F(10);
    unpost_form(form_page[0]);
    free_form(form_page[0]);
    for (i=0; i<14; i++) free_field(field[i]);
    return ch;
}

void options_window(void)
{
    char *in;
    int ch, i, page=1;
    
    config=read_conf();
    optwin.main=newwin(20,60,(LINES-20)/2,(COLS-60)/2);
    wbkgd(optwin.main, COLOR_PAIR(2));
    werase(optwin.main);
    box(optwin.main,0,0);
    keypad(optwin.main, TRUE);
    mvwaddch(optwin.main, 0, 2, ACS_RTEE);
    mvwprintw(optwin.main, 0, 3, " %s ", _("Options"));
    waddch(optwin.main, ACS_LTEE);    
    mvwprintw(optwin.main, 19, 2, "( %s )", _("Press F10 to save config or ESC to cancel"));

    ch=page_one();
    while (ch!=27) {
	switch(ch){
	    case KEY_F(1):
		if ( page!=1 ) {
		    page=1;
		    ch=page_one();
		}
		break;
#if 0 // not in this release
	    case KEY_F(2):
		if ( page!=2 ) {
		    page=2;
		    ch=page_two();
		}
		break;
#endif
	    case KEY_F(10):
		write_conf(config);
		delwin(optwin.main);
		return;
		break;
	wrefresh(optwin.main);
	}
    }
    delwin(optwin.main);
}
