/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <ncursesw/ncurses.h>
#include <string.h>
#include <dirent.h>
#include <libintl.h>
#include <nl_types.h>
#include "options.h"
#include "config.h"
#include "gettext.h"

#ifdef GTK_GUI
#include <gtk/gtk.h>
#include <glib.h>
#include "gtkgui.h"
#include "gtk_thread.h"
#include "gtk_cddb.h"

#ifdef HAVE_LIBMYSQLCLIENT
#include "gtk_cddb.h"
#include <mysql/mysql.h>

#define HAVE_DISKCATALOG
MYSQL mysql;
MYSQL_RES *result;
MYSQL_ROW row;
#endif

#ifdef HAVE_LIBSQLITE
#include "gtk_cddb.h"
#include <sqlite.h>

#define HAVE_DISKCATALOG
typedef struct SQLITE_RST {
    char **result;
    int nrow;
    int ncol;
} SQLITE_RES;

sqlite *sqlite_db;
int rc;
char *errmsg;
SQLITE_RES *result;
char **row;
#endif

#ifdef HAVE_DISKCATALOG
char query[255];
struct file_list_struct {
    char *files;
    int	type;
    char *type_name;
    char *cd_name;
    int size;
    int cd_num;
} file_list_gtk[202000];
int i, choices, dir_level, search_gtk=0, maxfiles_gtk=0, list_index=0;
char var_type[60], var_disk[60], var_dir[2000];
struct conf config;
char cdbpass[60];
char msg[60], file[255];
GtkWidget *filelist, *path_label;
GtkWidget *buttons[4], *labels[4], *check_search, *scrollwin, *frames[3], *vbox[3], *hbox, *check_search;

void status_line_gtk(struct file_list_struct info);

void gtk_error_dialog(char *message)
{
    GtkWidget *dialog;
    gint result;

    dialog = gtk_message_dialog_new(GTK_WINDOW(window1), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, message);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

int connect_database_gtk()
{
    char message[200];
    GtkWidget *dialog;
    gint result;

#ifdef HAVE_LIBMYSQLCLIENT
    mysql_init(&mysql);
    if (!mysql_real_connect(&mysql, config.cdbhost, config.cdbuser, cdbpass, "cdw", 0, NULL, 0)){
	sprintf(message, "%s", mysql_error(&mysql));
#endif
#ifdef HAVE_LIBSQLITE
    sqlite_db=sqlite_open("/home/vbali/tmp/sqlite/test.db", 0, &errmsg);
    if (!sqlite_db) {
	sprintf(message, "%s", errmsg);
#endif
	if (strlen(message)<=0)
	    sprintf(message, _("Unknown error! Check the settings!"));
	dialog = gtk_message_dialog_new(GTK_WINDOW(window1), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, message);
	gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
	result=gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
	return 1;
    }
    return 0;
}

void insert_disk_gtk(char *disk, char *cd_num, char *type)
{
    int id;

    if (switch_type((char *)type)==0){
	add_type((char *)type);
    }
    id=add_disk((char *)disk, atoi(cd_num), switch_type((char *)type), "2004-01-01");
    add_content(config.mountpoint, id);
}

int add_to_dic_gtk()
{
    char cdname[60], category[60], cd_num[5], command[255], cmd[255];
    int ret;
    gboolean passwd_entered;

#ifdef HAVE_LIBMYSQLCLIENT
    if (strlen(cdbpass)<=0) {
	strcpy(cdbpass, "\0");
	passwd_entered=gtk_input(msg, _("Enter password:"), cdbpass, 60, TRUE);
    } else
	passwd_entered=TRUE;
#endif
#ifdef HAVE_LIBSQLITE
	passwd_entered=TRUE;
#endif
    if (passwd_entered){
	strcpy(cdname, "\0");
	strcpy(cd_num, "\0");
	strcpy(category, "none\0");
	if (gtk_input(_("CD name"), _("Enter CD name:"), cdname, 60, FALSE)) {
	    if (gtk_input(_("CD Number"), _("Number of disk:"), cd_num, 5, FALSE)){
		if (gtk_input(_("Category"), _("Enter category:"), category, 60, FALSE)==1){
		    sprintf(cmd, "mount %s", config.cdrwdevice);
		    run_command_gtk(cmd, _("Mounting cdrom..."), 0, 0, 0, "");
		    insert_disk_gtk(cdname, cd_num, category);
		    sprintf(cmd, "umount %s", config.mountpoint);
		    run_command_gtk(cmd, _("Unmounting cdrom..."), 0, 0, 0, "");
		    return 1;
		}
	    }
	}
    }
}

int add_to_dic_sub_gtk()
{
    int i;
    if (add_to_dic_gtk()==1){
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	dir_level=0;
	sprintf(var_type, "*");
	sprintf(var_disk, "*");
	sprintf(var_dir, "*");
	i=load_disk_gtk("*", "*", "*");
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
    if ( strcmp(config.eject, "1")==0 ){
        eject_tray(config.cdrom);
    }
    return i;
}

/***/

int none_gtk(struct dirent *unused)
{
    if (strcmp(unused->d_name,".") && strcmp(unused->d_name,"..")) {
	return 1;
    }
    else
	return 0;
}

/***/
int load_disk_gtk(char *type, char *diskname, char* dir)
{
#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *disk;
#endif
#ifdef HAVE_LIBSQLITE
    SQLITE_RES *disk;
#endif
    int c=0, i, found, count, forcounter;
    char *line, itemname[100];
    char *linestr;
    char *column[2];

    file_list_gtk[0].cd_num=0;
    file_list_gtk[0].files=(char *)malloc(1);
    file_list_gtk[0].files[0]='\0';
    file_list_gtk[0].cd_name=(char *)malloc(1);
    file_list_gtk[0].cd_name[0]='\0';
    if (dir_level==0) {
	if ((disk=query_type("*"))!=NULL) {
#ifdef HAVE_LIBMYSQLCLIENT
	    while (row=mysql_fetch_row(disk)) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=disk->nrow; forcounter++) {
		row=disk->result;
		row+=forcounter*result->ncol;
#endif
		file_list_gtk[c].files=(char *)malloc(strlen(row[1])+2);
		sprintf(file_list_gtk[c].files, "%s", row[1]);
		file_list_gtk[c].cd_name=(char *)malloc(1);
		sprintf(file_list_gtk[c].cd_name, "");
		file_list_gtk[c].type_name=(char *)malloc(1);
		sprintf(file_list_gtk[c].type_name, "");
		file_list_gtk[c].type=0;
		file_list_gtk[c].size=0;
		column[0]=(char *)malloc(strlen(file_list_gtk[c].files)+2);
		sprintf(column[0], "/%s", file_list_gtk[c].files);
		column[1]=NULL;
		gtk_clist_append(GTK_CLIST(filelist), column);
		c++;
	    }
	}
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	//sqlite_free_table(disk->result);
	sqlite_close(sqlite_db);
#endif
    }
    if (dir_level==1) {
	char num[6];
	if ( (search_gtk!=1) && ((disk=query_disk(diskname, 0, type))!=NULL) ) {
#ifdef HAVE_LIBMYSQLCLIENT
	    while ((row=mysql_fetch_row(disk))) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=disk->nrow; forcounter++) {
		row=disk->result;
		row+=forcounter*result->ncol;
#endif
		file_list_gtk[c].files=(char *)malloc(strlen(row[1])+4);
		sprintf(file_list_gtk[c].files, "%s", row[1]);
		file_list_gtk[c].cd_name=(char *)malloc(1);
		sprintf(file_list_gtk[c].cd_name, "");
		file_list_gtk[c].type_name=(char *)malloc(strlen(row[3])+1);
		sprintf(file_list_gtk[c].type_name, "%s", row[3]);
		file_list_gtk[c].type=1;
		file_list_gtk[c].size=0;
		file_list_gtk[c].cd_num=atoi(row[2]);
		sprintf(num, "%d", file_list_gtk[c].cd_num);
		column[0]=(char *)malloc(strlen(file_list_gtk[c].files)+strlen(num)+5);
		sprintf(column[0], "/%d - %s", file_list_gtk[c].cd_num, file_list_gtk[c].files);
		column[1]=NULL;
		gtk_clist_append(GTK_CLIST(filelist), column);
		c++;
	    }
	}
	if ( (search_gtk==1) && ((disk=search_content(file, type, diskname, dir))!=NULL) ) {
#ifdef HAVE_LIBMYSQLCLIENT
 	    while ((row=mysql_fetch_row(disk))) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=disk->nrow; forcounter++) {
		row=disk->result;
		row+=forcounter*result->ncol;
#endif
  		line=file_list_gtk[c].files=(char *)malloc(strlen(row[1])+4);
		sprintf(line, "%s", row[1]);
		found=0;
		for (i=0; i<c; i++){
		   if (strcmp(line, file_list_gtk[i].files)==0)
			found=1;
		}
		if (found==0) {
		   file_list_gtk[c].files=(char *)malloc(strlen(row[1])+4);
		   sprintf(file_list_gtk[c].files, "%s", row[1]);
		   file_list_gtk[c].cd_name=(char *)malloc(1);
		   sprintf(file_list_gtk[c].cd_name, "");
		   file_list_gtk[c].type_name=(char *)malloc(strlen(row[5])+1);
		   sprintf(file_list_gtk[c].type_name, "%s", row[5]);
		   file_list_gtk[c].type=1;
		   file_list_gtk[c].size=0;
		   file_list_gtk[c].cd_num=atoi(row[0]);
		   sprintf(num, "%d", file_list_gtk[c].cd_num);
		   column[0]=(char *)malloc(strlen(file_list_gtk[c].files)+strlen(num)+5);
		   sprintf(column[0], "/%d - %s", file_list_gtk[c].cd_num, file_list_gtk[c].files);
		   column[1]=NULL;
		   gtk_clist_append(GTK_CLIST(filelist), column);
		   c++;
		}
	    }
	}
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	sqlite_free_table(result->result);
	sqlite_close(sqlite_db);
#endif
    }
    if (dir_level>=2) {
	if (search_gtk==1){
	    disk=search_content(file, type, diskname, dir);
	} else {
	    disk=query_content(type, diskname, dir);
	}
	if (disk!=NULL) {
	    int count;
	    for (count=0; count<2; count++){
#ifdef HAVE_LIBMYSQLCLIENT
		while (row=mysql_fetch_row(disk)) {
#endif
#ifdef HAVE_LIBSQLITE
		for (forcounter=1; forcounter<=disk->nrow; forcounter++) {
		    row=(*disk).result+(forcounter*disk->ncol);
#endif
		    line=(char *) malloc(strlen(row[2])+5);
		    file_list_gtk[c].type_name=(char *)malloc(strlen(row[5])+4);
		    sprintf(file_list_gtk[c].type_name, "%s", row[5]);
		    file_list_gtk[c].cd_name=(char *)malloc(strlen(row[1])+1);
		    sprintf(file_list_gtk[c].cd_name, "%s", row[1]);
		    sprintf(line, "%s", row[2]);
		    linestr=strtok(line, "/");
		    if (dir_level>2)
			for (i=1; i<=(dir_level-2); i++){
			    linestr=strtok(NULL, "/");
			}
		    line=linestr;
		    linestr=strtok(NULL, "/");
		    if (linestr==NULL)
			file_list_gtk[c].type=3;
		    else
			file_list_gtk[c].type=2;
		    if (line!=NULL) {
			found=0;
			for (i=0; i<c; i++){
			    if (strcmp(line, file_list_gtk[i].files)==0)
				found=1;
			}
			if (found==0) {
			    if ((count==0) && (file_list_gtk[c].type==2)){
				file_list_gtk[c].files=(char *)malloc(strlen(line)+1);
				sprintf(file_list_gtk[c].files, "%s", line);
				file_list_gtk[c].size=0;
				file_list_gtk[c].cd_num=atoi(row[0]);
				c++;
			    }
			    if ((count==1) && (file_list_gtk[c].type==3)){
				file_list_gtk[c].files=(char *)malloc(strlen(line)+2);
				sprintf(file_list_gtk[c].files, "%s", line);
				file_list_gtk[c].size=atoi(row[3]);
				file_list_gtk[c].cd_num=atoi(row[0]);
				c++;
			    }
			}
		    }
		}
#ifdef HAVE_LIBMYSQLCLIENT
		mysql_data_seek(disk, 0);
#endif
#ifdef HAVE_LIBSQLITE
		row=disk->result;
		row+=forcounter*result->nrow;
#endif
	    }
	    for (i=0; i<c; i++){
			if (file_list_gtk[i].type==2){
			    column[0]=(char *)malloc(strlen(file_list_gtk[i].files)+2);
			    sprintf(column[0], "/%s", file_list_gtk[i].files);
			    column[1]=(char *)malloc(4);
			    sprintf(column[1], "DIR");
			    gtk_clist_append(GTK_CLIST(filelist), column);
			} else {
			    column[0]=(char *)malloc(strlen(file_list_gtk[i].files)+1);
			    sprintf(column[0], "%s", file_list_gtk[i].files);
			    column[1]=(char *)malloc(5);
			    sprintf(column[1], "File");
			    gtk_clist_append(GTK_CLIST(filelist), column);
			}
	    }
#ifdef HAVE_LIBMYSQLCLIENT
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    sqlite_free_table(result->result);
	    sqlite_close(sqlite_db);
#endif
	}
    }
    maxfiles_gtk=--c;
    return maxfiles_gtk;
}

void status_line_gtk(struct file_list_struct info)
{
    char str[10];
    int maxpage, page;
    char page_str[10];
    char dir_str[255];
    char settext[255];

    switch (info.type) {
	case 0:
	    strcpy(str, "Type");
	    break;
	case 1:
	    strcpy(str, "Disk");
	    break;
	case 2:
	    strcpy(str, "Directory");
	    break;
	case 3:
	    strcpy(str, "File");
	    break;
    }
    if (search_gtk==1)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_search), TRUE);
    else
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_search), FALSE);
    if (maxfiles_gtk>=0) {
	if (info.type<3){
	    sprintf(settext, "%s [ %s ]", _("Name: "), info.files);
	    gtk_label_set_text(GTK_LABEL(labels[0]), settext);
	} else {
	    sprintf(settext, "%s %s", _("Name: "), info.files);
	    gtk_label_set_text(GTK_LABEL(labels[0]), settext);
	}

	sprintf(settext, "%s %d Kb", _("Size: "), info.size / 1024);
	gtk_label_set_text(GTK_LABEL(labels[1]), settext);
	if (strcmp(info.type_name, "")!=0){
	    sprintf(settext, "%s %s", _("Type: "), info.type_name);
	    gtk_label_set_text(GTK_LABEL(labels[2]), settext);
	}
	if (strcmp(info.cd_name, "")!=0){
	    sprintf(settext, "%s (%d) %s", _("Disk: "), info.cd_num, info.cd_name);
	    gtk_label_set_text(GTK_LABEL(labels[3]), settext);
	}
	if (dir_level>=3) {
	    sprintf(dir_str, "(/%s)", var_dir);
	    gtk_label_set_text(GTK_LABEL(path_label), dir_str);
	}
    }
}

void go_up(GtkWidget *widget, gpointer *user_data)
{
    if (dir_level==1) {
	dir_level--;
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	sprintf(var_disk, "*");
	sprintf(var_type, "*");
	sprintf(var_dir, "*");
	load_disk_gtk("*", "*", "*");
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
    else if (dir_level==2) {
	dir_level--;
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	sprintf(var_disk, "*");
	sprintf(var_dir, "*");
	load_disk_gtk((char *)var_type, "*", "*");
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
    else if (dir_level==3) {
	dir_level--;
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	sprintf(var_dir, "*");
	load_disk_gtk((char *)var_type, (char *)var_disk, (char *)var_dir);
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
    else if (dir_level>3) {
	char *dir;
	char *line;

	dir_level--;
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	line=(char *) malloc(strlen(var_dir)+5);
	sprintf(line, "%s", var_dir);
	dir=strtok(line, "/");
	sprintf(var_dir, "%s", dir);
	for (i=1; i<=(dir_level-3); i++){
	    dir=strtok(NULL, "/");
	    sprintf(var_dir, "%s/%s", var_dir, dir);
	}
	gtk_clist_clear(GTK_CLIST(filelist));
	load_disk_gtk((char *)var_type, (char *)var_disk, (char *)var_dir);
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
}

void select_row(GtkCList *clist, gint pos, gint column, GdkEventKey *event, gpointer user_data)
{
    list_index=pos;
    if (event!=NULL){
	if (event->type==GDK_BUTTON_RELEASE)
	    status_line_gtk(file_list_gtk[pos]);
	if (event->type==GDK_2BUTTON_PRESS) {
	    if (file_list_gtk[pos].type==0) {
		dir_level=dir_level+1;
		for (i=0; i<4; i++)
		    gtk_label_set_text(GTK_LABEL(labels[i]), "");
		gtk_label_set_text(GTK_LABEL(path_label), "");
		gtk_clist_clear(GTK_CLIST(filelist));
		sprintf(var_type, "%s", file_list_gtk[pos].files);
		load_disk_gtk((char *)var_type, "*", "*");
		if (file_list_gtk[0].cd_num==0){
		    dir_level=0;
		    sprintf(var_type, "%s", file_list_gtk[pos].files);
		    load_disk_gtk((char *)var_type, "*", "*");
		}
	    }
	    else if (file_list_gtk[pos].type==1) {
		dir_level=dir_level+1;
		for (i=0; i<4; i++)
		    gtk_label_set_text(GTK_LABEL(labels[i]), "");
		gtk_label_set_text(GTK_LABEL(path_label), "");
		gtk_clist_clear(GTK_CLIST(filelist));
		sprintf(var_disk, "%s", file_list_gtk[pos].files);
		sprintf(var_dir, "*");
		load_disk_gtk((char *)var_type, (char *)var_disk, "*");
	    }
	    else if (file_list_gtk[pos].type==2) {
		dir_level=dir_level+1;
		for (i=0; i<4; i++)
		    gtk_label_set_text(GTK_LABEL(labels[i]), "");
		gtk_label_set_text(GTK_LABEL(path_label), "");
		gtk_clist_clear(GTK_CLIST(filelist));
		if (dir_level>3)
		    sprintf(var_dir, "%s/%s", var_dir, file_list_gtk[pos].files);
		else
		    sprintf(var_dir, "%s", file_list_gtk[pos].files);
		load_disk_gtk((char *)var_type, (char *)var_disk, (char *)var_dir);
	    }
	    list_index=0;
	    status_line_gtk(file_list_gtk[list_index]);
	}
    }
}

void show_all_gtk()
{
    for (i=0; i<4; i++)
	gtk_label_set_text(GTK_LABEL(labels[i]), "");
    gtk_label_set_text(GTK_LABEL(path_label), "");
    gtk_clist_clear(GTK_CLIST(filelist));
    dir_level=1;
    sprintf(var_type, "*");
    sprintf(var_disk, "*");
    sprintf(var_dir, "*");
    search_gtk=0;
    i=load_disk_gtk("*", "*", "*");
    status_line_gtk(file_list_gtk[list_index]);
}

int search_in_dic_gtk()
{
    int ret;
#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *disk;
#endif
#ifdef HAVE_LIBSQLITE
    SQLITE_RES *disk;
#endif
    int c=0, i, found, count;
    char *line, itemname[100];
    char *linestr;

    if (gtk_input(_("Search in content"), _("Enter query string:"), file, 255, FALSE)) {
	if (file[0]=='\0'){
	   search_gtk==0;
	   for (i=0; i<4; i++)
		gtk_label_set_text(GTK_LABEL(labels[i]), "");
	   gtk_label_set_text(GTK_LABEL(path_label), "");
	   gtk_clist_clear(GTK_CLIST(filelist));
           sprintf(var_type, "*");
	   sprintf(var_disk, "*");
	   sprintf(var_dir, "*");
	   i=load_disk_gtk("*", "*", "*");
	   list_index=0;
	   status_line_gtk(file_list_gtk[list_index]);
	} else {
	    dir_level=1;
	    search_gtk=1;
	    for (i=0; i<4; i++)
		gtk_label_set_text(GTK_LABEL(labels[i]), "");
	    gtk_label_set_text(GTK_LABEL(path_label), "");
	    gtk_clist_clear(GTK_CLIST(filelist));
	    sprintf(var_type, "*");
	    sprintf(var_disk, "*");
	    sprintf(var_dir, "*");
	    i=load_disk_gtk("*", "*", "*");
	    list_index=0;
	    status_line_gtk(file_list_gtk[list_index]);
	}
    }
}

void delete_from_db_gtk(struct file_list_struct info)
{
    int cd_id;

    if (dir_level==1) {
	cd_id=delete_disk(info.files, info.cd_num, info.type_name);
	delete_content(cd_id);
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	i=load_disk_gtk(var_type, var_disk, "*");
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
    if (dir_level==0) {
	for (i=0; i<4; i++)
	    gtk_label_set_text(GTK_LABEL(labels[i]), "");
	gtk_label_set_text(GTK_LABEL(path_label), "");
	gtk_clist_clear(GTK_CLIST(filelist));
	delete_type(info.files);
	i=load_disk_gtk("*", "*", "*");
	list_index=0;
	status_line_gtk(file_list_gtk[list_index]);
    }
}

void delete_gtk(GtkWidget *widget, gpointer user_data)
{
    if (strlen(file_list_gtk[list_index].files)>0){
	if (dir_level==0) {
	    char message[600];
	    sprintf(message, "%s\n %s?", _("Are you sure do you want to delete category:"), file_list_gtk[list_index].files);
	    if (gtk_message(message)) {
	       delete_from_db_gtk(file_list_gtk[list_index]);
	       if (file_list_gtk[0].cd_num==0){
		  dir_level=0;
		  for (i=0; i<4; i++)
		      gtk_label_set_text(GTK_LABEL(labels[i]), "");
		  gtk_clist_clear(GTK_CLIST(filelist));
		  sprintf(var_type, "%s", file_list_gtk[list_index].files);
		  load_disk_gtk((char *)var_type, "*", "*");
	       }
	    }
	}
	if (dir_level==1) {
	   char message[600];
	   sprintf(message, "%s\n %s?", _("Are you sure do you want to delete disk:"), file_list_gtk[list_index].files);
	   if (gtk_message(message)) {
	       delete_from_db_gtk(file_list_gtk[list_index]);
	       if (file_list_gtk[0].cd_num==0){
		   dir_level=0;
		   for (i=0; i<4; i++)
		       gtk_label_set_text(GTK_LABEL(labels[i]), "");
		   gtk_clist_clear(GTK_CLIST(filelist));
		   sprintf(var_type, "%s", file_list_gtk[list_index].files);
		   load_disk_gtk((char *)var_type, "*", "*");
	       }
	   }
	}
    }
}

int cddb_window_gtk(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *dialog, *toolbar, *main_vbox, *path_hbox;
    GtkWidget *toolbar_items[5], *toolbar_images[5];
    int i;
    gboolean result;
    gboolean passwd_entered;

    read_conf();
    strcpy(cdbpass, "\0");
    sprintf(msg, "%s %s", config.cdbuser, _("password"));
#ifdef HAVE_LIBMYSQLCLIENT
    passwd_entered=gtk_input(msg, _("Enter password:"), cdbpass, 60, TRUE);
#endif
#ifdef HAVE_LIBSQLITE
    passwd_entered=TRUE;
#endif
    if (passwd_entered){
	dialog=gtk_dialog_new_with_buttons(_("Disk catalog"), GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_CLOSE, GTK_RESPONSE_ACCEPT, NULL);
	gtk_window_set_default_size (GTK_WINDOW (dialog), 580, 440);
	main_vbox=gtk_vbox_new(FALSE, 1);

	toolbar=gtk_toolbar_new();
	gtk_box_pack_start(GTK_BOX(main_vbox), toolbar, FALSE, FALSE, 0);
	gtk_widget_show(toolbar);

	add_toolbar_item(toolbar, _("Show all"), _("Show all disks"), "showall.png", 0, toolbar_images[0], toolbar_items[0], GTK_SIGNAL_FUNC(show_all_gtk));
	add_toolbar_item(toolbar, _("Add disk"), _("Add new disk to catalog"), "cdadd.png", 1, toolbar_images[1], toolbar_items[1], GTK_SIGNAL_FUNC(add_to_dic_sub_gtk));
	add_toolbar_item(toolbar, _("Search"), _("Search files and directories"), "search.png", 2, toolbar_images[2], toolbar_items[2], GTK_SIGNAL_FUNC(search_in_dic_gtk));
	add_toolbar_item(toolbar, _("Delete"), _("Delete selected item"), "delete.png", 3, toolbar_images[3], toolbar_items[3], GTK_SIGNAL_FUNC(delete_gtk));
	add_toolbar_item(toolbar, _("Up"), _("Go up one level"), "up.png", 4, toolbar_images[4], toolbar_items[4], GTK_SIGNAL_FUNC(go_up));

	hbox=gtk_hbox_new(FALSE, 2);
	for (i=0; i<3; i++)
	    vbox[i]=gtk_vbox_new(FALSE, 0);

	gtk_box_pack_start(GTK_BOX(hbox), vbox[1], TRUE, TRUE, 0);
	frames[1]=gtk_frame_new(_("Catalogized files"));
	scrollwin=gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 	gtk_container_add(GTK_CONTAINER(frames[1]), scrollwin);
	filelist=gtk_clist_new(2);
	gtk_clist_set_column_title(GTK_CLIST(filelist), 0, _("Filename/Dirname"));
	gtk_clist_set_column_width(GTK_CLIST(filelist), 0, 300);
	gtk_clist_set_column_title(GTK_CLIST(filelist), 1, _("Size/Type"));
	gtk_signal_connect(GTK_OBJECT(filelist), "select-row", G_CALLBACK(select_row), NULL);
	gtk_clist_column_titles_show(GTK_CLIST(filelist));
	gtk_container_add(GTK_CONTAINER(scrollwin), filelist);
	gtk_box_pack_start(GTK_BOX(vbox[1]), frames[1], TRUE, TRUE, 0);
	path_hbox=gtk_hbox_new(FALSE, 0);
	path_label=gtk_label_new("");
	check_search=gtk_check_button_new_with_label(_("Search"));
	gtk_misc_set_alignment(GTK_MISC(path_label), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(path_hbox), path_label, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(path_hbox), check_search, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox[1]), path_hbox, FALSE, FALSE, 0);
	frames[2]=gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox[1]), frames[2], FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frames[2]), vbox[2]);
	for (i=0; i<4; i++){
	    labels[i]=gtk_label_new(NULL);
	    gtk_misc_set_alignment(GTK_MISC(labels[i]), 0, 0.5);
	    gtk_box_pack_start(GTK_BOX(vbox[2]), labels[i], TRUE, TRUE, 0);
	}
	gtk_container_add(GTK_CONTAINER(main_vbox), hbox);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), main_vbox);
	gtk_widget_show_all(dialog);

	dir_level=0;
	if (connect_database()!=0){
	    gtk_widget_destroy(dialog);
	    return -1;
	} else {
#ifdef HAVE_LIBMYSQLCLIENT
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    sqlite_close(sqlite_db);
#endif
	    i=load_disk_gtk("*", "*", "*");
	    status_line_gtk(file_list_gtk[list_index]);
	}
	result=gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
    }
}
#endif
#endif
