/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2010 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define _GNU_SOURCE /* asprintf() */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdbool.h>

#include "cdw_ext_tools.h"
#include "cdw_which.h"
#include "cdw_debug.h"

#if 0

int main(void)
{
	char **table = cdw_which("cdrecord");

	if (table != (char **) NULL) {
		int i = 0;
		while (table[i] != (char *) NULL) {


			cdw_vdm ("INFO: table[i] = \"%s\"", table[i]);

			free(table[i]);
			table[i] = (char *) NULL;
			i++;
		}

		free(table);
		table = (char **) NULL;
	} else {
		cdw_vdm ("INFO: no table of paths\n");
	}
	return 0;
}

#endif




/* it is possible that the function returns non-NULL table, but all
   elements of the table are (char *) NULL; it means that there
   were N potential locations of executable \p tool_name, but none of the
   locations contained executable file \p tool_name */
char **cdw_which(const char *tool_name)
{
	const char *tmp = getenv("PATH");
	if (tmp == (char *) NULL) {
		cdw_vdm ("WARNING: getenv(\"PATH\") returns NULL\n");
		return (char **) NULL;
	}
#if 0
	const char *test_string = ":/home/acerion/bin: :/usr/local/bin::/usr/bin:/bin:/usr/games:";
	char *path = strdup(test_string);
#else
	char *path = strdup(tmp);
#endif
	if (path == (char *) NULL) {
		cdw_vdm ("ERROR: failed to strdup() string \"%s\"\n", tmp);
		return (char **) NULL;
	}

	size_t n_paths_max = 0;
	for (size_t i = 0; i < strlen(path); i++) {
		if (path[i] == ':') {
			n_paths_max++;
		}
	}
	n_paths_max++; /* there is no ':' at the beginning nor end of $PATH */
	n_paths_max++; /* additional element for guard */

	char **paths_table = (char **) malloc(n_paths_max * sizeof(char *));
	for (size_t i = 0; i < n_paths_max; i++) {
		paths_table[i] = (char *) NULL;
	}

	cdw_vdm ("INFO: searching for tool \"%s\"\n", tool_name);
	size_t n_instances = 0;
	const char *delim = ":";
	char *dirpath = strtok(path, delim);
	bool success = true;
	while (dirpath != (char *) NULL) {

		size_t len = strlen(dirpath);
		if (len != 0) {
			cdw_vdm ("INFO:    inspecting dirpath \"%s\"\n", dirpath);
			char *fullpath = (char *) NULL;
			int a = 0;
			if (dirpath[len - 1] == '/') {
				/* unlikely, unless user manually adds path
				   that ends with slash */
				a = asprintf(&fullpath, "%s%s", dirpath, tool_name);
			} else {
				a = asprintf(&fullpath, "%s/%s", dirpath, tool_name);
			}
			if (a == -1) {
				cdw_vdm ("ERROR: asprintf() fails\n");
				success = false;
				break;
			}

			if (!access(fullpath, X_OK)) {
				/* if there will be zero executable files then no
				   file will be put into table, even though the
				   table will be allocated */
				cdw_vdm ("INFO:      found: \"%s\"\n", fullpath);
				paths_table[n_instances] = fullpath;
				n_instances++;
			} else {
				free(fullpath);
				fullpath = (char *) NULL;
			}
		} else { /* strlen(dirpath) == 0 - malformed PATH? */
			;
		}

		dirpath = strtok((char *) NULL, delim);
		if (n_instances == CDW_EXT_TOOLS_N_INSTANCES_MAX && dirpath != (char *) NULL) {
			cdw_vdm ("WARNING: not all paths checked, but number of instances now equals limit: %zd\n",
				 n_instances);
			break;
		}
	}

	if (!success) {
		for (size_t i = 0; i < n_paths_max; i++) {
			if (paths_table[i] == (char *) NULL) {
				break;
			} else {
				free(paths_table[i]);
				paths_table[i] = (char *) NULL;
			}
		}
		free(paths_table);
		paths_table = (char **) NULL;
	}

	if (path != (char *) NULL) {
		free(path);
		path = (char *) NULL;
	}
	return paths_table;
}

#ifdef CDW_UNIT_TEST_CODE
void cdw_which_test(void)
{

	//printf("hello word\n");
	return;
}

#endif /* CDW_UNIT_TEST_CODE */
