#ifndef H_CDW_MAIN
#define H_CDW_MAIN



/** \brief Default name (volume ID) of created iso file or burned disc */
#define DEFAULT_VOLUMEID "cdrom"

/** \brief Maximum lenght of name of file created when copying tracks to hard disc
 *
 * 30 chars for core of output file name, track number and file name
 * extension not included; 30 is an arbitrary size, but it seems to be ok;
 * the value does not include ending '\0' char */
#define TRACK_CORE_NAME_LEN 30


/* About 'ENTER' and 'ESCAPE':
   These two replace key values: 10 and 27.
   They are different than cdw function return values defined below.
   These two variables should not be used as cdw return values. They are
   valid names only when checking values returned by getch() and similar
   functions. */
#define CDW_ENTER 10
#define CDW_ESCAPE 27
#define CDW_KEY_ENTER 10
#define CDW_KEY_ESCAPE 27
#define CDW_KEY_TAB '\t'



/* boolean, but with three values */
enum {
	CDW_UNKNOWN = -1, /* also known as "init" */
	CDW_FALSE   =  0,
	CDW_TRUE    = +1
};



/**
 * \brief Return values of most of cdw functions
 *
 * Introduced to avoid using magic numbers and to increase redability of code.
 */
typedef enum cdw_return_value {
	CDW_OK = 0,                /**< \brief usually means that function call was successful, also means pressing CDW_ENTER in buttonless widgets or OK/YES button in widgets with buttons */
	CDW_CANCEL = -1,           /**< \brief use e.g after user pressed CDW_ESCAPE in buttonless widgets, when user selected Cancel in widgets with buttons or sometimes when function returns with failure */
	CDW_NO = -2,               /**< \brief use after user pressed NO in widgets with buttons */

	CDW_GEN_ERROR = -30,       /**< \brief general error, may be used when no other error applies */
	CDW_FILE_INVALID = -31,    /**< \brief file properties are diffrent than assumed, e.g. is not a directory */

	CDW_MEM_ERROR = -36,       /**< \brief memory error: malloc() or its friends returning NULL is most common case */
	CDW_SYS_ERROR = -37,       /**< \brief system function (e.g. lstat()) call returns error */
	CDW_ARG_ERROR = -38,       /**< \brief bad function's argument */

	CDW_FAILSAFE_MODE = -99    /**< \brief options module works without reading/writing conf file on disk, because of previous errors */
} cdw_rv_t;


/* this is different than cdw_dropdown_item_t, because here
   label is a const string, allocated on compile time */
typedef struct {
	long int id;
	const char *label;
} cdw_id_label_t;



#endif /* H_CDW_MAIN */
