/* ProjectSettings.m
 * project settings for document
 *
 * Copyright (C) 2002-2003 by vhf interservice GmbH
 * Author: Georg Fleischmann
 *
 * Created:  2002-11-23
 * Modified: 2003-08-08
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <VHFShared/VHFSystemAdditions.h>
#include "ProjectSettings.h"
#include "PSSettings.h"
#include "PSInfo.h"
#include "PSFontInfo.h"
#include "DocWindow.h"	// Notification macro

@implementation ProjectSettings

- init
{   NSNotificationCenter	*notificationCenter = [NSNotificationCenter defaultCenter];

    [panel setFrameAutosaveName:@"ProjectSettingsPanel"];

    /* add observer for changes of document window (DocWindow) */
    [notificationCenter addObserver:self
                           selector:@selector(documentHasChanged:)
                               name:DocWindowDidChange
                             object:nil];

    [panel setDelegate:self];

    [levPopup setTarget:self];
    [levPopup setAction:@selector(setLevel:)];
    [self setLevel:self];

    return [super init];
}

- (void)makeKeyAndOrderFront:sender
{
    [panel makeKeyAndOrderFront:sender];
}

- (void)update:sender
{
    [activeWindow update:sender];
}

- (void)setLevel:sender
{
    [self setLevelAt:Max(0, [levPopup indexOfSelectedItem])];
}

/* attention with the -init if it is not subclassed you will loss the window!
 */
- (void)setLevelAt:(int)level
{
//    [activeWindow displayWillEnd];
    if (level < 10)
        [levPopup selectItemAtIndex:level];
    switch (level)
    {
        case PS_SETTINGS:	// settings
            activeWindow = [self windowAt:PS_SETTINGS];
            [self setLevelView:[activeWindow view]];
            break;
        case PS_INFO:		// info (depends on project type)
            activeWindow = [self windowAt:PS_INFO];
            [self setLevelView:[activeWindow view]];
            break;
        /*case PS_FONTINFO:	// fontinfo
            [self windowAt:PS_FONTINFO];
            [self setLevelView:[fontInfo view]];
            activeWindow = fontInfo;
            break;*/
        default:
            [self setLevelView:NULL];
            activeWindow = self;
            return;
    }

    [activeWindow update:self];
    [panel orderFront:self];
}

- (void)setLevelView:theView
{
    [(NSBox*)levView setContentView:[theView retain]];
    [levView setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];

    [panel display];
    [panel flushWindow];
}

- windowAt:(int)level
{
    switch (level)
    {
        case PS_SETTINGS:
            if (!settings)
                settings = [[PSSettings alloc] init];
            return settings;
        case PS_INFO:
            if ( 0 )	// font
            {
                if (!fontInfo)
                    fontInfo = [[PSFontInfo alloc] init];
                return fontInfo;
            }
            if (!info)
                info = [[PSInfo alloc] init];
            return info;
        /*case PS_FONTINFO:
            if (!fontInfo)
                fontInfo = [[PSFontInfo alloc] init];
            return fontInfo;*/
        default: return nil;
    }
}

- (void)windowDidResignKey:(NSNotification*)notification
{   //NSWindow *theWindow = [notification object];

    if ( [activeWindow respondsToSelector:@selector(set:)] )
        [activeWindow set:nil];
}

/* notification that the DocWindow has changed
 */
- (void)documentHasChanged:(NSNotification*)notification
{
    [self update:[notification object]];
}

@end
