/* PreferencesMacros.h
 * Macros for easier access of basic preferences from default database
 *
 * Copyright (C) 1996-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  1999-03-15
 * Modified: 2003-11-06
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_PREFERENCEMACROS
#define VHF_H_PREFERENCEMACROS

/* general */
#define Prefs_Caching		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"doCaching"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ExpertMode	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"expertMode"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_RemoveBackups	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"removeBackups"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_SelectNonEditable	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"selectNonEditable"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_DisableAntiAlias	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"disbaleAntiAliasing"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_OSPropertyList	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"writeOSPropertyList"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Snap		[[NSUserDefaults standardUserDefaults] integerForKey:@"snap"]
#define Prefs_Unit		[[NSUserDefaults standardUserDefaults] integerForKey:@"unit"]

/* import */
#define Prefs_ColorToLayer	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"colorToLayer"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_FillObjects	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"fillObjects"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_DXFRes		[[[NSUserDefaults standardUserDefaults] objectForKey:@"dxfRes"] floatValue]
#define Prefs_PSPreferArcs	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"psPreferArcs"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_PSFlattenText	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"psFlattenText"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_GerberParmsFileName	[[NSUserDefaults standardUserDefaults] objectForKey:@"gerberParmsFileName"]
#define Prefs_HPGLParmsFileName	[[NSUserDefaults standardUserDefaults] objectForKey:@"hpglParmsFileName"]
#define Prefs_DINParmsFileName	[[NSUserDefaults standardUserDefaults] objectForKey:@"dinParmsFileName"]

/* export */
#define Prefs_ExportFlattenText	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"exportFlattenText"] isEqual:@"YES"]) ? YES : NO )

/* CAM */
#define Prefs_ParmsFileName	[[NSUserDefaults standardUserDefaults] objectForKey:@"parmsFileName"]
#define Prefs_UseRaster		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"useRaster"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_GotoParkingPosition	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"gotoParkingPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_IncrementSerial	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"incrementSerial"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_OptimizeMoves	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"optimizeMoves"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Chamfering	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"chamfering"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ContourFill	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"contourFill"] isEqual:@"YES"]) ? YES : NO )

#endif // VHF_H_PREFERENCEMACROS
