C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RM (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4M
C       PARAMETER (ISET=1)                                            
        DATA  DrI, FlI, AlI /              2.,   5.,  .2020 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .203369D+01, .265779D+01, .358285D+01, .500000D+01,
     +  .794903D+01, .135129D+02, .248012D+02, .496935D+02, .110086D+03,
     +  .273574D+03, .775412D+03, .255482D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .249593D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .109939D+06,
     +  .836226D+05, .625689D+05, .467779D+05, .349512D+05,
     +  .260904D+05, .194631D+05, .145049D+05, .108020D+05,
     +  .803585D+04, .597336D+04, .443516D+04, .329024D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .243788D+04, .180463D+04, .133410D+04, .985250D+03,
     +  .726573D+03, .535215D+03, .393644D+03, .289177D+03,
     +  .212084D+03, .155341D+03, .113582D+03, .829290D+02,
     +  .604451D+02, .440089D+02, .318351D+02, .231044D+02,
     +  .167372D+02, .121125D+02, .875186D+01, .631872D+01,
     +  .456147D+01, .329051D+01, .237314D+01, .171355D+01,
     +  .123816D+01, .896766D+00, .650669D+00, .474010D+00,
     +  .346336D+00, .254176D+00, .187248D+00, .138667D+00,
     +  .103095D+00, .771410D-01, .578085D-01, .436300D-01,
     +  .329573D-01, .250181D-01, .190244D-01, .145080D-01,
     +  .110719D-01, .846326D-02, .646360D-02, .493553D-02,
     +  .376024D-02, .286145D-02, .216882D-02, .163912D-02,
     +  .123183D-02, .921052D-03, .684718D-03, .504192D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .367096D-03, .264259D-03, .187276D-03, .130483D-03,
     +  .887238D-04, .586261D-04, .370796D-04, .220463D-04,
     +  .117496D-04, .506466D-05, .811806D-06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .247210D+06, .187576D+06,
     +  .139949D+06, .104327D+06, .777218D+05, .578463D+05,
     +  .430226D+05, .319652D+05, .237313D+05, .175991D+05,
     +  .130404D+05, .965129D+04, .713635D+04, .527011D+04,
     +  .388799D+04, .286443D+04, .210802D+04, .154907D+04,
     +  .113697D+04, .833168D+03, .609765D+03, .445508D+03,
     +  .325043D+03, .236725D+03, .172141D+03, .124951D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .905881D+02, .652433D+02, .471404D+02, .339960D+02,
     +  .244880D+02, .176103D+02, .126522D+02, .908851D+01,
     +  .652248D+01, .467958D+01, .336069D+01, .241510D+01,
     +  .173933D+01, .125484D+01, .908775D+00, .660066D+00,
     +  .481470D+00, .352525D+00, .259420D+00, .191655D+00,
     +  .142478D+00, .106082D+00, .795305D-01, .596769D-01,
     +  .449940D-01, .339845D-01, .257386D-01, .195087D-01,
     +  .148087D-01, .112322D-01, .851783D-02, .644597D-02,
     +  .487246D-02, .366952D-02, .275629D-02, .205978D-02,
     +  .153242D-02, .113454D-02, .833083D-03, .606073D-03,
     +  .437140D-03, .311657D-03, .219714D-03, .152515D-03,
     +  .104275D-03, .697946D-04, .456149D-04, .288886D-04,
     +  .177421D-04, .103064D-04, .558852D-05, .268532D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .101834D-05, .125810D-06, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .416737D+06, .315408D+06, .234623D+06,
     +  .174381D+06, .129515D+06, .960990D+05, .712499D+05,
     +  .527715D+05, .390527D+05, .288682D+05, .213203D+05,
     +  .157270D+05, .115896D+05, .852968D+04, .627086D+04,
     +  .460379D+04, .337595D+04, .247183D+04, .180754D+04,
     +  .131962D+04, .962094D+03, .700208D+03, .508850D+03,
     +  .369101D+03, .267301D+03, .193211D+03, .139473D+03,
     +  .100007D+03, .719343D+02, .516411D+02, .370236D+02,
     +  .264985D+02, .189445D+02, .135408D+02, .966761D+01,
     +  .689984D+01, .492839D+01, .352237D+01, .252247D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .180950D+01, .130280D+01, .940670D+00, .681994D+00,
     +  .496314D+00, .362955D+00, .266468D+00, .196831D+00,
     +  .145615D+00, .108454D+00, .808487D-01, .605509D-01,
     +  .454330D-01, .341775D-01, .257318D-01, .193991D-01,
     +  .146145D-01, .110071D-01, .827376D-02, .621151D-02,
     +  .464698D-02, .346739D-02, .257471D-02, .190363D-02,
     +  .140114D-02, .102326D-02, .741006D-03, .532531D-03,
     +  .378886D-03, .267093D-03, .185975D-03, .128080D-03,
     +  .869160D-04, .581256D-04, .382265D-04, .248840D-04,
     +  .158757D-04, .100071D-04, .622256D-05, .385341D-05,
     +  .237643D-05, .148422D-05, .935417D-06, .599450D-06,
     +  .383387D-06, .240728D-06, .142060D-06, .750588D-07,
     +  .322562D-07, .888025D-08, .610333D-09, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .624038D+06, .471069D+06, .349334D+06, .258834D+06,
     +  .191634D+06, .141740D+06, .104751D+06, .773329D+05,
     +  .570405D+05, .420250D+05, .309323D+05, .227398D+05,
     +  .166995D+05, .122475D+05, .897208D+04, .656326D+04,
     +  .479521D+04, .349802D+04, .254831D+04, .185334D+04,
     +  .134596D+04, .975722D+03, .706218D+03, .510175D+03,
     +  .367928D+03, .264814D+03, .190330D+03, .135863D+03,
     +  .972831D+02, .695189D+02, .496055D+02, .353337D+02,
     +  .251364D+02, .178768D+02, .126974D+02, .901476D+01,
     +  .640423D+01, .455218D+01, .324163D+01, .231221D+01,
     +  .165503D+01, .118798D+01, .856116D+00, .619270D+00,
     +  .450077D+00, .328382D+00, .241034D+00, .177191D+00,
     +  .131120D+00, .971157D-01, .722575D-01, .538646D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .402520D-01, .301059D-01, .225445D-01, .168713D-01,
     +  .126215D-01, .942451D-02, .702795D-02, .522324D-02,
     +  .387165D-02, .285651D-02, .209863D-02, .153527D-02,
     +  .111466D-02, .802949D-03, .574368D-03, .407181D-03,
     +  .286359D-03, .199318D-03, .137560D-03, .938977D-04,
     +  .634809D-04, .425095D-04, .284140D-04, .188431D-04,
     +  .125154D-04, .833286D-05, .560070D-05, .379065D-05,
     +  .259384D-05, .177320D-05, .120087D-05, .790189D-06,
     +  .494775D-06, .284508D-06, .143356D-06, .577387D-07,
     +  .148429D-07, .106063D-08, .000000D+00, .874987D+06,
     +  .658730D+06, .486950D+06, .359648D+06, .265414D+06,
     +  .195673D+06, .144132D+06, .106052D+06, .779596D+05,
     +  .572420D+05, .419873D+05, .307593D+05, .225090D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .164493D+05, .120065D+05, .875084D+04, .636968D+04,
     +  .462909D+04, .335938D+04, .243376D+04, .176050D+04,
     +  .127114D+04, .916288D+03, .659197D+03, .473398D+03,
     +  .339262D+03, .242768D+03, .172513D+03, .122964D+03,
     +  .874653D+02, .621153D+02, .440317D+02, .311692D+02,
     +  .220564D+02, .155850D+02, .110070D+02, .777739D+01,
     +  .549813D+01, .389334D+01, .276138D+01, .196510D+01,
     +  .140231D+01, .100454D+01, .722285D+00, .521737D+00,
     +  .378329D+00, .275966D+00, .201604D+00, .148235D+00,
     +  .109095D+00, .806473D-01, .597342D-01, .443479D-01,
     +  .329548D-01, .245156D-01, .182268D-01, .135459D-01,
     +  .100491D-01, .744442D-02, .549710D-02, .404827D-02,
     +  .296805D-02, .216697D-02, .157572D-02, .113737D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .814958D-03, .580164D-03, .409681D-03, .287282D-03,
     +  .199707D-03, .137920D-03, .944752D-04, .643304D-04,
     +  .435965D-04, .296378D-04, .201196D-04, .137546D-04,
     +  .947151D-05, .659148D-05, .461301D-05, .324114D-05,
     +  .225669D-05, .153906D-05, .101037D-05, .624998D-06,
     +  .352353D-06, .172625D-06, .669864D-07, .165319D-07,
     +  .120648D-08, .000000D+00, .117573D+07, .882720D+06,
     +  .650416D+06, .478815D+06, .352192D+06, .258786D+06,
     +  .189979D+06, .139312D+06, .102058D+06, .746767D+05,
     +  .545834D+05, .398455D+05, .290533D+05, .211548D+05,
     +  .153843D+05, .111711D+05, .810065D+04, .586462D+04,
     +  .423952D+04, .305936D+04, .220421D+04, .158509D+04,
     +  .113790D+04, .815219D+03, .582961D+03, .415972D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .296347D+03, .209632D+03, .148739D+03, .105310D+03,
     +  .744331D+02, .525094D+02, .369867D+02, .260421D+02,
     +  .183065D+02, .128615D+02, .903899D+01, .635532D+01,
     +  .447531D+01, .315632D+01, .223325D+01, .158442D+01,
     +  .112830D+01, .806451D+00, .579011D+00, .417310D+00,
     +  .302528D+00, .219645D+00, .160488D+00, .117372D+00,
     +  .862159D-01, .634565D-01, .468106D-01, .345637D-01,
     +  .255468D-01, .188720D-01, .139352D-01, .102721D-01,
     +  .756085D-02, .554792D-02, .405993D-02, .295837D-02,
     +  .214678D-02, .155192D-02, .111387D-02, .794007D-03,
     +  .562623D-03, .395782D-03, .276744D-03, .192122D-03,
     +  .132730D-03, .911770D-04, .624478D-04, .427229D-04,
     +  .294192D-04, .203087D-04, .141530D-04, .994743D-05 /
        DATA (UPDI(I),I=989,1040) /
     +  .705482D-05, .501646D-05, .355987D-05, .248922D-05,
     +  .169307D-05, .110240D-05, .672432D-06, .371987D-06,
     +  .177777D-06, .668169D-07, .159294D-07, .118309D-08,
     +  .000000D+00, .153257D+07, .114744D+07, .842686D+06,
     +  .618306D+06, .453272D+06, .331935D+06, .242848D+06,
     +  .177469D+06, .129558D+06, .944663D+05, .688027D+05,
     +  .500454D+05, .363579D+05, .263766D+05, .191104D+05,
     +  .138246D+05, .998668D+04, .720222D+04, .518613D+04,
     +  .372767D+04, .267494D+04, .191578D+04, .136961D+04,
     +  .977114D+03, .695756D+03, .494299D+03, .350592D+03,
     +  .246878D+03, .174366D+03, .122883D+03, .864414D+02,
     +  .606875D+02, .425365D+02, .298002D+02, .208409D+02,
     +  .145658D+02, .101822D+02, .712047D+01, .498645D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .349721D+01, .246035D+01, .173551D+01, .122867D+01,
     +  .873027D+00, .623065D+00, .446363D+00, .321628D+00,
     +  .232089D+00, .168533D+00, .122494D+00, .894181D-01,
     +  .654056D-01, .479460D-01, .351811D-01, .258390D-01,
     +  .189685D-01, .139183D-01, .101959D-01, .745784D-02,
     +  .543877D-02, .395568D-02, .286529D-02, .206704D-02,
     +  .148588D-02, .106071D-02, .752415D-03, .530825D-03,
     +  .372099D-03, .259518D-03, .179964D-03, .124395D-03,
     +  .856862D-04, .590024D-04, .406991D-04, .283250D-04,
     +  .198098D-04, .139979D-04, .997256D-05, .715158D-05,
     +  .512532D-05, .364763D-05, .254680D-05, .172094D-05,
     +  .110881D-05, .666386D-06, .361797D-06, .168858D-06,
     +  .616008D-07, .142289D-07, .107404D-08, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .195183D+07, .145726D+07, .106666D+07, .780026D+06,
     +  .569893D+06, .415917D+06, .303242D+06, .220835D+06,
     +  .160650D+06, .116722D+06, .847076D+05, .613916D+05,
     +  .444376D+05, .321191D+05, .231839D+05, .167081D+05,
     +  .120234D+05, .863753D+04, .619523D+04, .443533D+04,
     +  .316992D+04, .226102D+04, .160974D+04, .114361D+04,
     +  .810833D+03, .573549D+03, .405005D+03, .283899D+03,
     +  .199599D+03, .140015D+03, .980278D+02, .684920D+02,
     +  .477713D+02, .333013D+02, .231706D+02, .161104D+02,
     +  .112023D+02, .779187D+01, .542679D+01, .378499D+01,
     +  .264780D+01, .185711D+01, .130715D+01, .923396D+00,
     +  .655124D+00, .466546D+00, .334161D+00, .239682D+00,
     +  .172990D+00, .124969D+00, .906660D-01, .659146D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .480220D-01, .350212D-01, .255626D-01, .186507D-01,
     +  .136011D-01, .990316D-02, .719961D-02, .521914D-02,
     +  .377344D-02, .271761D-02, .194945D-02, .139382D-02,
     +  .989908D-03, .698974D-03, .491142D-03, .343199D-03,
     +  .238845D-03, .165509D-03, .114500D-03, .791005D-04,
     +  .547512D-04, .380498D-04, .267238D-04, .188866D-04,
     +  .134838D-04, .969429D-05, .699655D-05, .503030D-05,
     +  .357642D-05, .248571D-05, .166533D-05, .106043D-05,
     +  .627631D-06, .334436D-06, .152513D-06, .540707D-07,
     +  .121250D-07, .929498D-09, .000000D+00, .243973D+07,
     +  .181643D+07, .132510D+07, .965760D+06, .703190D+06,
     +  .511441D+06, .371596D+06, .269669D+06, .195483D+06,
     +  .141525D+06, .102338D+06, .738999D+05, .532951D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .383784D+05, .275979D+05, .198138D+05, .142036D+05,
     +  .101642D+05, .726156D+04, .517809D+04, .368584D+04,
     +  .261829D+04, .185638D+04, .131329D+04, .927177D+03,
     +  .652998D+03, .459075D+03, .320344D+03, .224200D+03,
     +  .156549D+03, .109088D+03, .758563D+02, .526497D+02,
     +  .365211D+02, .252823D+02, .174884D+02, .120967D+02,
     +  .836933D+01, .579742D+01, .402136D+01, .279747D+01,
     +  .195104D+01, .136543D+01, .959022D+00, .676439D+00,
     +  .478905D+00, .340993D+00, .243132D+00, .174432D+00,
     +  .125257D+00, .903284D-01, .652763D-01, .472703D-01,
     +  .342661D-01, .248604D-01, .180297D-01, .130695D-01,
     +  .945982D-02, .683664D-02, .492733D-02, .354205D-02,
     +  .253687D-02, .180997D-02, .128749D-02, .909998D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .639822D-03, .447945D-03, .312159D-03, .216873D-03,
     +  .150240D-03, .104065D-03, .721179D-04, .501737D-04,
     +  .351087D-04, .248537D-04, .177141D-04, .127434D-04,
     +  .921663D-05, .667286D-05, .479834D-05, .339971D-05,
     +  .234764D-05, .155748D-05, .979393D-06, .570686D-06,
     +  .298448D-06, .133028D-06, .458742D-07, .100024D-07,
     +  .778361D-09, .000000D+00, .675837D+05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .355046D+05, .274229D+05, .208889D+05,
     +  .159024D+05, .121030D+05, .920528D+04, .699917D+04,
     +  .531795D+04, .403913D+04, .306543D+04, .232552D+04,
     +  .176269D+04, .133546D+04, .101084D+04, .764730D+03,
     +  .577943D+03, .436530D+03, .329342D+03, .248314D+03,
     +  .186990D+03, .140715D+03, .105752D+03, .794158D+02,
     +  .595545D+02, .446222D+02, .333897D+02, .249717D+02,
     +  .185703D+02, .138590D+02, .103278D+02, .769432D+01,
     +  .572560D+01, .426075D+01, .317121D+01, .236078D+01,
     +  .175764D+01, .131130D+01, .979249D+00, .733652D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .550743D+00, .415435D+00, .314329D+00, .239070D+00,
     +  .182515D+00, .140174D+00, .108065D+00, .838869D-01,
     +  .652148D-01, .510813D-01, .400398D-01, .315501D-01,
     +  .248937D-01, .197059D-01, .156053D-01, .123829D-01,
     +  .981361D-02, .777825D-02, .614951D-02, .485851D-02,
     +  .382261D-02, .300074D-02, .234291D-02, .182162D-02,
     +  .140943D-02, .108188D-02, .822459D-03, .619790D-03,
     +  .461502D-03, .339700D-03, .245969D-03, .175210D-03,
     +  .121858D-03, .826371D-04, .537596D-04, .335625D-04,
     +  .193111D-04, .977642D-05, .362099D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .804558D+05, .619957D+05, .470952D+05, .357542D+05,
     +  .271350D+05, .205795D+05, .156018D+05, .118193D+05,
     +  .894995D+04, .677174D+04, .512118D+04, .386952D+04,
     +  .292221D+04, .220469D+04, .166236D+04, .125211D+04,
     +  .942484D+03, .708602D+03, .532366D+03, .399460D+03,
     +  .299501D+03, .224254D+03, .167767D+03, .125329D+03,
     +  .935362D+02, .697131D+02, .519243D+02, .384526D+02,
     +  .285748D+02, .212031D+02, .157263D+02, .116502D+02,
     +  .862927D+01, .639272D+01, .473574D+01, .350860D+01,
     +  .260418D+01, .193478D+01, .144175D+01, .107651D+01,
     +  .807486D+00, .607554D+00, .459400D+00, .348700D+00,
     +  .266193D+00, .203996D+00, .157376D+00, .121602D+00,
     +  .946452D-01, .737253D-01, .577207D-01, .452577D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .355956D-01, .280112D-01, .220836D-01, .173918D-01,
     +  .136975D-01, .107634D-01, .845166D-02, .661109D-02,
     +  .516037D-02, .400793D-02, .310111D-02, .238910D-02,
     +  .182743D-02, .138604D-02, .104370D-02, .778263D-03,
     +  .575315D-03, .420121D-03, .303514D-03, .216020D-03,
     +  .151626D-03, .104230D-03, .707563D-04, .467492D-04,
     +  .302117D-04, .189162D-04, .114813D-04, .666793D-05,
     +  .370116D-05, .192348D-05, .923940D-06, .391329D-06,
     +  .138122D-06, .314258D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .136434D+06,
     +  .104879D+06, .794510D+05, .601498D+05, .455195D+05,
     +  .344231D+05, .260202D+05, .196534D+05, .148371D+05,
     +  .111918D+05, .843749D+04, .635526D+04, .478398D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .359764D+04, .270367D+04, .202965D+04, .152254D+04,
     +  .114078D+04, .854049D+03, .638568D+03, .477039D+03,
     +  .355883D+03, .265242D+03, .197399D+03, .146754D+03,
     +  .108948D+03, .808213D+02, .596058D+02, .441086D+02,
     +  .325917D+02, .240677D+02, .177513D+02, .130883D+02,
     +  .965166D+01, .711580D+01, .524662D+01, .387470D+01,
     +  .286428D+01, .212325D+01, .157709D+01, .117655D+01,
     +  .880440D+00, .662002D+00, .499679D+00, .379241D+00,
     +  .288962D+00, .221605D+00, .170231D+00, .131692D+00,
     +  .101972D+00, .793463D-01, .618406D-01, .483386D-01,
     +  .378089D-01, .296228D-01, .231872D-01, .181491D-01,
     +  .141757D-01, .110628D-01, .860222D-02, .667439D-02,
     +  .515397D-02, .396510D-02, .303788D-02, .231127D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .174452D-02, .130787D-02, .971724D-03, .716330D-03,
     +  .522382D-03, .377487D-03, .269451D-03, .190249D-03,
     +  .132254D-03, .912964D-04, .619175D-04, .415641D-04,
     +  .274953D-04, .180326D-04, .116706D-04, .751869D-05,
     +  .478573D-05, .301747D-05, .186022D-05, .111142D-05,
     +  .622205D-06, .314362D-06, .132052D-06, .368176D-07,
     +  .246566D-08, .000000D+00, .207680D+06, .157419D+06,
     +  .118917D+06, .897727D+05, .677409D+05, .510783D+05,
     +  .384952D+05, .289889D+05, .218182D+05, .164071D+05,
     +  .123306D+05, .925827D+04, .694682D+04, .520719D+04,
     +  .390032D+04, .291822D+04, .218166D+04, .162903D+04,
     +  .121531D+04, .905474D+03, .673992D+03, .500986D+03,
     +  .372000D+03, .275812D+03, .204262D+03, .151051D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .111608D+03, .819745D+02, .604104D+02, .444508D+02,
     +  .326837D+02, .240013D+02, .176169D+02, .129325D+02,
     +  .948981D+01, .696393D+01, .511770D+01, .376451D+01,
     +  .277633D+01, .205163D+01, .152247D+01, .113327D+01,
     +  .847446D+00, .636175D+00, .480128D+00, .363792D+00,
     +  .277397D+00, .211881D+00, .162955D+00, .125450D+00,
     +  .970384D-01, .751902D-01, .584241D-01, .454297D-01,
     +  .353800D-01, .275302D-01, .214196D-01, .166320D-01,
     +  .129021D-01, .997396D-02, .769300D-02, .590642D-02,
     +  .451782D-02, .344178D-02, .260388D-02, .195498D-02,
     +  .145821D-02, .107842D-02, .791634D-03, .575331D-03,
     +  .414672D-03, .295640D-03, .208810D-03, .145600D-03,
     +  .101059D-03, .692060D-04, .471180D-04, .317997D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .213996D-04, .143033D-04, .955747D-05, .632831D-05,
     +  .414410D-05, .264382D-05, .162060D-05, .922579D-06,
     +  .468371D-06, .194901D-06, .530683D-07, .364493D-08,
     +  .000000D+00, .310689D+06, .237539D+06, .178816D+06,
     +  .134521D+06, .101145D+06, .759931D+05, .570629D+05,
     +  .428138D+05, .321025D+05, .240502D+05, .180051D+05,
     +  .134668D+05, .100648D+05, .751447D+04, .560574D+04,
     +  .417718D+04, .310985D+04, .231242D+04, .171776D+04,
     +  .127434D+04, .944380D+03, .698866D+03, .516577D+03,
     +  .381260D+03, .281035D+03, .206841D+03, .152087D+03,
     +  .111152D+03, .814996D+02, .596655D+02, .436409D+02,
     +  .318792D+02, .232715D+02, .169902D+02, .123964D+02,
     +  .904501D+01, .660760D+01, .483167D+01, .354141D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .260096D+01, .191783D+01, .141852D+01, .105381D+01,
     +  .785963D+00, .589197D+00, .443473D+00, .335852D+00,
     +  .254803D+00, .194606D+00, .148791D+00, .114286D+00,
     +  .879458D-01, .678520D-01, .523938D-01, .405107D-01,
     +  .313004D-01, .241766D-01, .186389D-01, .143517D-01,
     +  .110134D-01, .842975D-02, .642265D-02, .487305D-02,
     +  .368168D-02, .276051D-02, .205325D-02, .151586D-02,
     +  .110861D-02, .803510D-03, .575623D-03, .407876D-03,
     +  .284963D-03, .196328D-03, .132790D-03, .887254D-04,
     +  .579025D-04, .370776D-04, .231609D-04, .141468D-04,
     +  .839402D-05, .486476D-05, .273485D-05, .150111D-05,
     +  .798268D-06, .414424D-06, .205137D-06, .953817D-07,
     +  .384474D-07, .106951D-07, .673350D-09, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .443527D+06, .338065D+06, .253584D+06, .190084D+06,
     +  .142403D+06, .106599D+06, .797470D+05, .596092D+05,
     +  .445259D+05, .332294D+05, .247801D+05, .184614D+05,
     +  .137425D+05, .102191D+05, .759218D+04, .563409D+04,
     +  .417691D+04, .309274D+04, .228752D+04, .168967D+04,
     +  .124663D+04, .918426D+03, .675780D+03, .496469D+03,
     +  .364244D+03, .266808D+03, .195228D+03, .141971D+03,
     +  .103574D+03, .754427D+02, .548932D+02, .398882D+02,
     +  .289605D+02, .210286D+02, .152565D+02, .110687D+02,
     +  .803867D+01, .584357D+01, .425715D+01, .310765D+01,
     +  .227712D+01, .167373D+01, .123542D+01, .915523D+00,
     +  .681815D+00, .509827D+00, .383528D+00, .289041D+00,
     +  .219254D+00, .166505D+00, .127012D+00, .970765D-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .743778D-01, .570396D-01, .437940D-01, .336035D-01,
     +  .257737D-01, .197330D-01, .150872D-01, .114978D-01,
     +  .873878D-02, .661237D-02, .498212D-02, .373834D-02,
     +  .278372D-02, .205685D-02, .150870D-02, .109671D-02,
     +  .790339D-03, .563390D-03, .397548D-03, .276989D-03,
     +  .190609D-03, .129172D-03, .867589D-04, .572310D-04,
     +  .372929D-04, .239473D-04, .152213D-04, .955683D-05,
     +  .596751D-05, .369051D-05, .226231D-05, .135936D-05,
     +  .791366D-06, .431337D-06, .211205D-06, .846838D-07,
     +  .221247D-07, .152744D-08, .000000D+00, .608710D+06,
     +  .462541D+06, .345702D+06, .258193D+06, .192715D+06,
     +  .143726D+06, .107118D+06, .797645D+05, .593522D+05,
     +  .441225D+05, .327743D+05, .243203D+05, .180311D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .133538D+05, .988029D+04, .730165D+04, .539037D+04,
     +  .397426D+04, .292684D+04, .215247D+04, .158105D+04,
     +  .115958D+04, .849335D+03, .621098D+03, .453544D+03,
     +  .330637D+03, .240760D+03, .174211D+03, .126458D+03,
     +  .916446D+02, .663361D+02, .479504D+02, .346267D+02,
     +  .250065D+02, .180411D+02, .130152D+02, .939748D+01,
     +  .679145D+01, .491808D+01, .356851D+01, .259869D+01,
     +  .189827D+01, .139231D+01, .102526D+01, .758609D+00,
     +  .563589D+00, .421195D+00, .315350D+00, .237617D+00,
     +  .179252D+00, .135815D+00, .103113D+00, .784672D-01,
     +  .597709D-01, .455770D-01, .347348D-01, .264590D-01,
     +  .201207D-01, .152779D-01, .115644D-01, .872923D-02,
     +  .656076D-02, .490973D-02, .365939D-02, .270669D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .198705D-02, .144835D-02, .104662D-02, .750051D-03,
     +  .532082D-03, .373922D-03, .259799D-03, .178553D-03,
     +  .121173D-03, .817276D-04, .543800D-04, .359222D-04,
     +  .235433D-04, .153794D-04, .100016D-04, .650427D-05,
     +  .420495D-05, .268922D-05, .167799D-05, .100368D-05,
     +  .555986D-06, .272629D-06, .107849D-06, .274820D-07,
     +  .194659D-08, .000000D+00, .811749D+06, .614910D+06,
     +  .457907D+06, .340739D+06, .253383D+06, .188264D+06,
     +  .139779D+06, .103688D+06, .768551D+05, .569111D+05,
     +  .421065D+05, .311207D+05, .229798D+05, .169493D+05,
     +  .124887D+05, .919082D+04, .675633D+04, .496009D+04,
     +  .363704D+04, .266306D+04, .194740D+04, .142185D+04,
     +  .103668D+04, .754600D+03, .548446D+03, .397914D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .288344D+03, .207603D+03, .149944D+03, .108116D+03,
     +  .778542D+02, .559816D+02, .402100D+02, .288816D+02,
     +  .207212D+02, .148648D+02, .106713D+02, .766730D+01,
     +  .551944D+01, .398095D+01, .288138D+01, .209187D+01,
     +  .152473D+01, .111576D+01, .820319D+00, .605552D+00,
     +  .449640D+00, .334473D+00, .250376D+00, .187642D+00,
     +  .141233D+00, .106523D+00, .805237D-01, .609320D-01,
     +  .461510D-01, .349385D-01, .264361D-01, .199698D-01,
     +  .150617D-01, .113252D-01, .849165D-02, .634033D-02,
     +  .471347D-02, .349024D-02, .256485D-02, .187118D-02,
     +  .135564D-02, .974074D-03, .694369D-03, .490325D-03,
     +  .343267D-03, .237890D-03, .163329D-03, .110994D-03,
     +  .751509D-04, .503823D-04, .336616D-04, .224169D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .149366D-04, .994246D-05, .662238D-05, .438062D-05,
     +  .285311D-05, .180299D-05, .108352D-05, .598600D-06,
     +  .290090D-06, .112301D-06, .278329D-07, .200850D-08,
     +  .000000D+00, .105852D+07, .799343D+06, .593066D+06,
     +  .439684D+06, .325740D+06, .241114D+06, .178337D+06,
     +  .131782D+06, .972988D+05, .717670D+05, .528873D+05,
     +  .389322D+05, .286313D+05, .210313D+05, .154323D+05,
     +  .113095D+05, .827860D+04, .605164D+04, .441817D+04,
     +  .322083D+04, .234480D+04, .170431D+04, .123695D+04,
     +  .896217D+03, .648321D+03, .468133D+03, .337585D+03,
     +  .241848D+03, .173808D+03, .124691D+03, .893276D+02,
     +  .638970D+02, .456511D+02, .326135D+02, .232697D+02,
     +  .165999D+02, .118490D+02, .846454D+01, .605761D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .434326D+01, .312469D+01, .225475D+01, .163334D+01,
     +  .118785D+01, .867843D+00, .636603D+00, .469698D+00,
     +  .347169D+00, .258206D+00, .192263D+00, .143773D+00,
     +  .107739D+00, .809119D-01, .608281D-01, .457698D-01,
     +  .344240D-01, .258761D-01, .194198D-01, .145508D-01,
     +  .108702D-01, .809748D-02, .600733D-02, .443726D-02,
     +  .326497D-02, .238428D-02, .172900D-02, .124539D-02,
     +  .890039D-03, .631319D-03, .443920D-03, .309722D-03,
     +  .214180D-03, .146964D-03, .100036D-03, .679959D-04,
     +  .459063D-04, .309779D-04, .209015D-04, .141381D-04,
     +  .956495D-05, .646613D-05, .433035D-05, .284148D-05,
     +  .180012D-05, .107775D-05, .589834D-06, .281200D-06,
     +  .106237D-06, .255855D-07, .187745D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .135515D+07, .102017D+07, .754119D+06, .557015D+06,
     +  .411121D+06, .303165D+06, .223377D+06, .164429D+06,
     +  .120931D+06, .888476D+05, .652145D+05, .478142D+05,
     +  .350207D+05, .256194D+05, .187210D+05, .136623D+05,
     +  .995845D+04, .724845D+04, .526900D+04, .382425D+04,
     +  .277173D+04, .200557D+04, .144898D+04, .104500D+04,
     +  .752413D+03, .540710D+03, .388041D+03, .276620D+03,
     +  .197811D+03, .141198D+03, .100636D+03, .716128D+02,
     +  .508932D+02, .361642D+02, .256622D+02, .182053D+02,
     +  .129216D+02, .917813D+01, .653017D+01, .465467D+01,
     +  .332879D+01, .238762D+01, .171907D+01, .124257D+01,
     +  .902209D+00, .657703D+00, .482234D+00, .354196D+00,
     +  .261764D+00, .193676D+00, .143906D+00, .107154D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .799580D-01, .597274D-01, .446522D-01, .333687D-01,
     +  .249219D-01, .185846D-01, .138358D-01, .102707D-01,
     +  .760240D-02, .560489D-02, .411422D-02, .300877D-02,
     +  .218395D-02, .157461D-02, .112795D-02, .802025D-03,
     +  .566281D-03, .396669D-03, .275941D-03, .190502D-03,
     +  .130708D-03, .891494D-04, .608427D-04, .413527D-04,
     +  .281547D-04, .192051D-04, .131424D-04, .899332D-05,
     +  .613511D-05, .413375D-05, .271663D-05, .171620D-05,
     +  .101941D-05, .550893D-06, .257820D-06, .949593D-07,
     +  .222270D-07, .165705D-08, .000000D+00, .170796D+07,
     +  .128177D+07, .944022D+06, .694705D+06, .510830D+06,
     +  .375272D+06, .275453D+06, .201983D+06, .147973D+06,
     +  .108290D+06, .791700D+05, .578140D+05, .421735D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .307260D+05, .223598D+05, .162497D+05, .117944D+05,
     +  .854812D+04, .618689D+04, .447085D+04, .322603D+04,
     +  .232385D+04, .167131D+04, .119981D+04, .859857D+03,
     +  .614996D+03, .439236D+03, .311573D+03, .221708D+03,
     +  .157467D+03, .111661D+03, .790493D+02, .558836D+02,
     +  .394999D+02, .278773D+02, .196683D+02, .138820D+02,
     +  .980468D+01, .693592D+01, .491525D+01, .349448D+01,
     +  .249161D+01, .178318D+01, .128114D+01, .924539D+00,
     +  .669853D+00, .488121D+00, .356300D+00, .261678D+00,
     +  .192404D+00, .142065D+00, .105124D+00, .779497D-01,
     +  .578623D-01, .429849D-01, .319213D-01, .236913D-01,
     +  .175568D-01, .129888D-01, .958239D-02, .704914D-02,
     +  .516550D-02, .376879D-02, .273988D-02, .197728D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .141777D-02, .101033D-02, .714994D-03, .502717D-03,
     +  .350955D-03, .243544D-03, .167944D-03, .115283D-03,
     +  .788174D-04, .540198D-04, .369509D-04, .253589D-04,
     +  .174557D-04, .120518D-04, .831158D-05, .569878D-05,
     +  .384730D-05, .252289D-05, .158429D-05, .931376D-06,
     +  .496091D-06, .227650D-06, .817130D-07, .186008D-07,
     +  .140812D-08, .000000D+00, .212326D+07, .158854D+07,
     +  .116567D+07, .854656D+06, .626106D+06, .458231D+06,
     +  .335069D+06, .244758D+06, .178617D+06, .130205D+06,
     +  .948161D+05, .689639D+05, .501043D+05, .363556D+05,
     +  .263477D+05, .190683D+05, .137820D+05, .994624D+04,
     +  .716787D+04, .515723D+04, .370493D+04, .265694D+04,
     +  .190225D+04, .135936D+04, .969701D+03, .690296D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .490668D+03, .346355D+03, .245254D+03, .173328D+03,
     +  .122289D+03, .861320D+02, .605745D+02, .425908D+02,
     +  .298977D+02, .209793D+02, .147255D+02, .103424D+02,
     +  .727482D+01, .512590D+01, .362308D+01, .256818D+01,
     +  .182711D+01, .130489D+01, .936020D+00, .674076D+00,
     +  .488222D+00, .354199D+00, .258541D+00, .188930D+00,
     +  .138641D+00, .101961D+00, .751379D-01, .554319D-01,
     +  .409247D-01, .302046D-01, .222794D-01, .164098D-01,
     +  .120661D-01, .884801D-02, .646982D-02, .471308D-02,
     +  .341860D-02, .247116D-02, .177348D-02, .126500D-02,
     +  .897064D-03, .632063D-03, .442729D-03, .308174D-03,
     +  .213441D-03, .147096D-03, .101069D-03, .692882D-04,
     +  .476953D-04, .328224D-04, .226844D-04, .157307D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .109325D-04, .757710D-05, .520593D-05, .351123D-05,
     +  .229173D-05, .142755D-05, .829314D-06, .434884D-06,
     +  .195544D-06, .683987D-07, .151541D-07, .116448D-08,
     +  .000000D+00, .260727D+07, .194470D+07, .142183D+07,
     +  .103865D+07, .758083D+06, .552751D+06, .402660D+06,
     +  .293012D+06, .213009D+06, .154673D+06, .112193D+06,
     +  .812796D+05, .588156D+05, .425042D+05, .306778D+05,
     +  .221104D+05, .159140D+05, .114365D+05, .820663D+04,
     +  .587914D+04, .420510D+04, .300231D+04, .213991D+04,
     +  .152227D+04, .108093D+04, .765884D+03, .541827D+03,
     +  .380616D+03, .268209D+03, .188622D+03, .132416D+03,
     +  .927940D+02, .649245D+02, .454124D+02, .317095D+02,
     +  .221312D+02, .154493D+02, .107909D+02, .754786D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .528824D+01, .371641D+01, .261913D+01, .185248D+01,
     +  .131525D+01, .937865D+00, .671386D+00, .483374D+00,
     +  .348574D+00, .252902D+00, .183693D+00, .133982D+00,
     +  .979405D-01, .717382D-01, .526042D-01, .386016D-01,
     +  .283185D-01, .207626D-01, .152013D-01, .111109D-01,
     +  .809965D-02, .588803D-02, .426475D-02, .307593D-02,
     +  .221130D-02, .157859D-02, .112043D-02, .790920D-03,
     +  .555041D-03, .387471D-03, .269046D-03, .186071D-03,
     +  .128219D-03, .882216D-04, .606618D-04, .419387D-04,
     +  .290226D-04, .201801D-04, .140762D-04, .982742D-05,
     +  .682919D-05, .469092D-05, .315403D-05, .204527D-05,
     +  .126193D-05, .723669D-06, .373318D-06, .164413D-06,
     +  .560506D-07, .120971D-07, .943303D-09, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .562964D+05, .335803D+05, .261493D+05, .203628D+05,
     +  .158569D+05, .123482D+05, .961594D+04, .748835D+04,
     +  .583160D+04, .454148D+04, .353685D+04, .275454D+04,
     +  .214535D+04, .167096D+04, .130153D+04, .101385D+04,
     +  .789825D+03, .615361D+03, .479493D+03, .373681D+03,
     +  .291272D+03, .227089D+03, .177098D+03, .138158D+03,
     +  .107825D+03, .841930D+02, .657803D+02, .512528D+02,
     +  .401130D+02, .314271D+02, .246526D+02, .193667D+02,
     +  .152402D+02, .120253D+02, .950491D+01, .753311D+01,
     +  .598825D+01, .477565D+01, .382166D+01, .306870D+01,
     +  .247328D+01, .199983D+01, .162193D+01, .131888D+01,
     +  .107471D+01, .877066D+00, .716926D+00, .585384D+00,
     +  .478300D+00, .389830D+00, .317347D+00, .257673D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .208549D+00, .168142D+00, .134963D+00, .107787D+00,
     +  .856021D-01, .675644D-01, .529688D-01, .412229D-01,
     +  .318278D-01, .243637D-01, .184774D-01, .138917D-01,
     +  .103133D-01, .756704D-02, .548145D-02, .391574D-02,
     +  .275502D-02, .190635D-02, .129518D-02, .862356D-03,
     +  .561301D-03, .356045D-03, .220449D-03, .131831D-03,
     +  .760670D-04, .421219D-04, .222368D-04, .110985D-04,
     +  .518115D-05, .223406D-05, .867731D-06, .297969D-06,
     +  .866440D-07, .200793D-07, .334989D-08, .332462D-09,
     +  .127895D-10, .484556D-13, .000000D+00, .776833D+05,
     +  .606271D+05, .467450D+05, .360370D+05, .277821D+05,
     +  .214150D+05, .165072D+05, .127223D+05, .980520D+04,
     +  .755588D+04, .582257D+04, .448622D+04, .345661D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .266293D+04, .205153D+04, .158030D+04, .121737D+04,
     +  .937685D+03, .722312D+03, .556370D+03, .428613D+03,
     +  .330193D+03, .254429D+03, .196070D+03, .151148D+03,
     +  .116552D+03, .899313D+02, .691696D+02, .534467D+02,
     +  .413310D+02, .320022D+02, .248104D+02, .192683D+02,
     +  .150030D+02, .117033D+02, .915335D+01, .718210D+01,
     +  .565373D+01, .446737D+01, .354250D+01, .282093D+01,
     +  .225419D+01, .180773D+01, .145401D+01, .117269D+01,
     +  .947603D+00, .767480D+00, .621103D+00, .503363D+00,
     +  .407056D+00, .328985D+00, .265299D+00, .213372D+00,
     +  .171016D+00, .136531D+00, .108489D+00, .857627D-01,
     +  .674021D-01, .526425D-01, .408275D-01, .314295D-01,
     +  .239975D-01, .181614D-01, .136323D-01, .101095D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .741199D-02, .536800D-02, .383546D-02, .270066D-02,
     +  .187070D-02, .127282D-02, .848466D-03, .552821D-03,
     +  .350198D-03, .215964D-03, .127689D-03, .718873D-04,
     +  .377761D-04, .178194D-04, .680936D-05, .120238D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .122180D+06, .948420D+05,
     +  .726725D+05, .556718D+05, .426449D+05, .326575D+05,
     +  .250071D+05, .191436D+05, .146537D+05, .112136D+05,
     +  .858034D+04, .656353D+04, .502031D+04, .383881D+04,
     +  .293513D+04, .224352D+04, .171476D+04, .131025D+04,
     +  .100112D+04, .764734D+03, .584175D+03, .446163D+03,
     +  .340785D+03, .260271D+03, .198816D+03, .151886D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .116095D+03, .884228D+02, .676563D+02, .517971D+02,
     +  .397009D+02, .304621D+02, .234113D+02, .180368D+02,
     +  .139206D+02, .107708D+02, .836087D+01, .651100D+01,
     +  .509017D+01, .399377D+01, .314750D+01, .248965D+01,
     +  .197692D+01, .157488D+01, .125854D+01, .100796D+01,
     +  .809519D+00, .649796D+00, .522621D+00, .419536D+00,
     +  .336742D+00, .269777D+00, .215641D+00, .171829D+00,
     +  .136434D+00, .107854D+00, .848515D-01, .663847D-01,
     +  .516332D-01, .398903D-01, .306019D-01, .232929D-01,
     +  .175804D-01, .131665D-01, .974701D-02, .713718D-02,
     +  .516615D-02, .369213D-02, .260332D-02, .180808D-02,
     +  .123588D-02, .829679D-03, .546391D-03, .351596D-03,
     +  .222005D-03, .136031D-03, .810261D-04, .466607D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .259091D-04, .137583D-04, .695526D-05, .330249D-05,
     +  .144922D-05, .568141D-06, .188393D-06, .428181D-07,
     +  .486234D-09, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .177723D+06, .137382D+06, .104761D+06,
     +  .798591D+05, .608669D+05, .463747D+05, .353270D+05,
     +  .269010D+05, .204810D+05, .155871D+05, .118603D+05,
     +  .902091D+04, .685996D+04, .521450D+04, .396296D+04,
     +  .301053D+04, .228658D+04, .173599D+04, .131776D+04,
     +  .999887D+03, .758608D+03, .575350D+03, .436336D+03,
     +  .330821D+03, .250830D+03, .190163D+03, .144228D+03,
     +  .108965D+03, .826980D+02, .627872D+02, .477175D+02,
     +  .362966D+02, .276499D+02, .211120D+02, .161462D+02,
     +  .123780D+02, .951964D+01, .734434D+01, .568830D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .442166D+01, .345284D+01, .270649D+01, .213008D+01,
     +  .168221D+01, .133305D+01, .105895D+01, .843857D+00,
     +  .672233D+00, .536797D+00, .427931D+00, .341222D+00,
     +  .271644D+00, .215835D+00, .171001D+00, .135042D+00,
     +  .106202D+00, .831419D-01, .647440D-01, .501367D-01,
     +  .385735D-01, .294779D-01, .223571D-01, .168187D-01,
     +  .125588D-01, .927286D-02, .677470D-02, .489517D-02,
     +  .349428D-02, .246275D-02, .171123D-02, .117170D-02,
     +  .789247D-03, .522718D-03, .339340D-03, .217141D-03,
     +  .135729D-03, .832922D-04, .501206D-04, .297115D-04,
     +  .173661D-04, .101107D-04, .587469D-05, .342828D-05,
     +  .199712D-05, .114991D-05, .630829D-06, .315749D-06,
     +  .132185D-06, .368227D-07, .246568D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .196869D+06, .189590D+06, .143968D+06, .109281D+06,
     +  .829315D+05, .629077D+05, .477067D+05, .361623D+05,
     +  .274042D+05, .207573D+05, .157182D+05, .118965D+05,
     +  .900140D+04, .680735D+04, .514657D+04, .388891D+04,
     +  .293773D+04, .221800D+04, .167413D+04, .126296D+04,
     +  .952548D+03, .718082D+03, .541223D+03, .407755D+03,
     +  .307165D+03, .231331D+03, .174268D+03, .130737D+03,
     +  .985183D+02, .742558D+02, .560147D+02, .422847D+02,
     +  .319617D+02, .242119D+02, .183681D+02, .139664D+02,
     +  .106526D+02, .814994D+01, .625947D+01, .482492D+01,
     +  .373643D+01, .290464D+01, .226747D+01, .177644D+01,
     +  .139679D+01, .110117D+01, .871094D+00, .688983D+00,
     +  .546426D+00, .432726D+00, .342861D+00, .271286D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .214292D+00, .168827D+00, .132609D+00, .103750D+00,
     +  .808207D-01, .626381D-01, .482865D-01, .369894D-01,
     +  .281515D-01, .212684D-01, .159411D-01, .118630D-01,
     +  .873137D-02, .636074D-02, .458452D-02, .326569D-02,
     +  .229812D-02, .159546D-02, .109250D-02, .736815D-03,
     +  .489406D-03, .319352D-03, .206012D-03, .130379D-03,
     +  .814745D-04, .503013D-04, .308809D-04, .188923D-04,
     +  .116289D-04, .719119D-05, .446657D-05, .275024D-05,
     +  .165020D-05, .929138D-06, .469413D-06, .195000D-06,
     +  .530720D-07, .364495D-08, .000000D+00, .351056D+06,
     +  .269315D+06, .203560D+06, .153789D+06, .116149D+06,
     +  .876772D+05, .661612D+05, .498990D+05, .376198D+05,
     +  .283467D+05, .213509D+05, .160724D+05, .120939D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .909476D+04, .683646D+04, .513573D+04, .385643D+04,
     +  .289396D+04, .217075D+04, .162725D+04, .121934D+04,
     +  .913127D+03, .683563D+03, .511431D+03, .382531D+03,
     +  .285999D+03, .213850D+03, .159196D+03, .119027D+03,
     +  .889987D+02, .665861D+02, .498453D+02, .373534D+02,
     +  .280501D+02, .210900D+02, .158911D+02, .120090D+02,
     +  .910246D+01, .692552D+01, .528827D+01, .405684D+01,
     +  .312439D+01, .241649D+01, .187603D+01, .146194D+01,
     +  .114251D+01, .896150D+00, .702944D+00, .553061D+00,
     +  .434589D+00, .341763D+00, .268469D+00, .210589D+00,
     +  .164797D+00, .128603D+00, .999856D-01, .774148D-01,
     +  .596467D-01, .457188D-01, .348297D-01, .263658D-01,
     +  .198160D-01, .147764D-01, .109413D-01, .801260D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .580778D-02, .416446D-02, .295069D-02, .206461D-02,
     +  .142436D-02, .968287D-03, .647389D-03, .425343D-03,
     +  .273646D-03, .173222D-03, .106800D-03, .643352D-04,
     +  .377263D-04, .215505D-04, .119473D-04, .645416D-05,
     +  .339075D-05, .174374D-05, .877495D-06, .436208D-06,
     +  .209909D-06, .961308D-07, .385180D-07, .106977D-07,
     +  .673363D-09, .000000D+00, .483401D+06, .369454D+06,
     +  .278026D+06, .209118D+06, .157224D+06, .118140D+06,
     +  .887340D+05, .666076D+05, .499755D+05, .374731D+05,
     +  .280848D+05, .210349D+05, .157466D+05, .117798D+05,
     +  .880759D+04, .658067D+04, .491411D+04, .366693D+04,
     +  .273476D+04, .203805D+04, .151803D+04, .112988D+04,
     +  .840546D+03, .624881D+03, .464340D+03, .344849D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .256096D+03, .189297D+03, .140521D+03, .104303D+03,
     +  .774517D+02, .575357D+02, .427781D+02, .318676D+02,
     +  .237644D+02, .177576D+02, .133060D+02, .999940D+01,
     +  .754216D+01, .570916D+01, .434160D+01, .331471D+01,
     +  .254155D+01, .195631D+01, .151167D+01, .117162D+01,
     +  .911564D+00, .709368D+00, .553823D+00, .431916D+00,
     +  .337181D+00, .262994D+00, .204872D+00, .159252D+00,
     +  .123467D+00, .953856D-01, .733983D-01, .562142D-01,
     +  .428367D-01, .324496D-01, .244289D-01, .182625D-01,
     +  .135472D-01, .998082D-02, .727348D-02, .524740D-02,
     +  .374593D-02, .264318D-02, .184248D-02, .126701D-02,
     +  .859117D-03, .573506D-03, .376706D-03, .242822D-03,
     +  .154441D-03, .961010D-04, .587893D-04, .353394D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .209616D-04, .122866D-04, .717661D-05, .418434D-05,
     +  .244295D-05, .141765D-05, .807188D-06, .434757D-06,
     +  .211734D-06, .847331D-07, .221266D-07, .152745D-08,
     +  .000000D+00, .648098D+06, .493547D+06, .369846D+06,
     +  .276994D+06, .207355D+06, .155126D+06, .115995D+06,
     +  .866772D+05, .647351D+05, .483142D+05, .360383D+05,
     +  .268621D+05, .200104D+05, .148951D+05, .110806D+05,
     +  .823639D+04, .611830D+04, .454119D+04, .336837D+04,
     +  .249637D+04, .184891D+04, .136825D+04, .101189D+04,
     +  .747760D+03, .552247D+03, .407564D+03, .300733D+03,
     +  .220818D+03, .162822D+03, .120031D+03, .885060D+02,
     +  .652775D+02, .481784D+02, .356232D+02, .263621D+02,
     +  .195458D+02, .145301D+02, .108319D+02, .810390D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .608440D+01, .458904D+01, .347497D+01, .264266D+01,
     +  .201768D+01, .154660D+01, .118921D+01, .918084D+00,
     +  .708983D+00, .549399D+00, .425331D+00, .329671D+00,
     +  .255350D+00, .197566D+00, .152556D+00, .117509D+00,
     +  .902095D-01, .689862D-01, .525167D-01, .397826D-01,
     +  .299626D-01, .224294D-01, .166758D-01, .123035D-01,
     +  .901712D-02, .653749D-02, .469315D-02, .333444D-02,
     +  .234239D-02, .162613D-02, .111423D-02, .753318D-03,
     +  .501901D-03, .329464D-03, .212679D-03, .135826D-03,
     +  .852123D-04, .528382D-04, .324336D-04, .198201D-04,
     +  .120940D-04, .742189D-05, .457587D-05, .282337D-05,
     +  .172076D-05, .101514D-05, .558430D-06, .273002D-06,
     +  .107883D-06, .274832D-07, .194660D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .850658D+06, .645539D+06, .481757D+06, .359311D+06,
     +  .267844D+06, .199525D+06, .148548D+06, .110516D+06,
     +  .821720D+05, .610513D+05, .453304D+05, .336311D+05,
     +  .249346D+05, .184715D+05, .136741D+05, .101138D+05,
     +  .747509D+04, .551982D+04, .407291D+04, .300250D+04,
     +  .221175D+04, .162774D+04, .119705D+04, .879517D+03,
     +  .645759D+03, .473728D+03, .347423D+03, .253490D+03,
     +  .185724D+03, .136026D+03, .996333D+02, .729862D+02,
     +  .534939D+02, .392744D+02, .288539D+02, .212361D+02,
     +  .156685D+02, .115921D+02, .860602D+01, .641142D+01,
     +  .479806D+01, .360494D+01, .272014D+01, .206076D+01,
     +  .156748D+01, .119610D+01, .916496D+00, .702520D+00,
     +  .540447D+00, .415416D+00, .319737D+00, .245965D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .189030D+00, .145009D+00, .110977D+00, .846586D-01,
     +  .643412D-01, .486844D-01, .366602D-01, .274503D-01,
     +  .204314D-01, .151055D-01, .110837D-01, .807955D-02,
     +  .582691D-02, .416178D-02, .294249D-02, .205757D-02,
     +  .142235D-02, .970970D-03, .654464D-03, .435143D-03,
     +  .285443D-03, .184511D-03, .118297D-03, .747847D-04,
     +  .469432D-04, .293391D-04, .183639D-04, .115425D-04,
     +  .731717D-05, .465855D-05, .295250D-05, .183430D-05,
     +  .109180D-05, .600343D-06, .290353D-06, .112325D-06,
     +  .278337D-07, .200851D-08, .000000D+00, .109695D+07,
     +  .829599D+06, .616625D+06, .458030D+06, .340025D+06,
     +  .252238D+06, .186998D+06, .138526D+06, .102550D+06,
     +  .758564D+05, .560714D+05, .414116D+05, .305619D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .225346D+05, .166028D+05, .122210D+05, .898827D+04,
     +  .660422D+04, .484843D+04, .355585D+04, .260567D+04,
     +  .190744D+04, .139513D+04, .101939D+04, .744244D+03,
     +  .542833D+03, .395768D+03, .287014D+03, .209002D+03,
     +  .152122D+03, .110714D+03, .805768D+02, .586652D+02,
     +  .427807D+02, .312129D+02, .228111D+02, .167103D+02,
     +  .122734D+02, .904497D+01, .668863D+01, .496823D+01,
     +  .370493D+01, .277468D+01, .208644D+01, .157524D+01,
     +  .119320D+01, .907643D+00, .690732D+00, .527627D+00,
     +  .402734D+00, .307854D+00, .235235D+00, .179590D+00,
     +  .136874D+00, .104084D+00, .789029D-01, .595975D-01,
     +  .448225D-01, .335511D-01, .249756D-01, .184826D-01,
     +  .135878D-01, .991460D-02, .718810D-02, .515637D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .366391D-02, .257770D-02, .179413D-02, .123494D-02,
     +  .839907D-03, .564425D-03, .374541D-03, .245558D-03,
     +  .158969D-03, .102329D-03, .651753D-04, .413818D-04,
     +  .262786D-04, .167771D-04, .107855D-04, .699093D-05,
     +  .453810D-05, .291494D-05, .182299D-05, .108373D-05,
     +  .591074D-06, .281384D-06, .106254D-06, .255861D-07,
     +  .187746D-08, .000000D+00, .139312D+07, .105005D+07,
     +  .777392D+06, .575137D+06, .425232D+06, .314153D+06,
     +  .231932D+06, .171090D+06, .126118D+06, .928867D+05,
     +  .683594D+05, .502630D+05, .369273D+05, .271039D+05,
     +  .198768D+05, .145622D+05, .106591D+05, .779394D+04,
     +  .569368D+04, .415488D+04, .302913D+04, .220595D+04,
     +  .160497D+04, .116643D+04, .846946D+03, .614294D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .445326D+03, .321060D+03, .232416D+03, .168147D+03,
     +  .121626D+03, .879654D+02, .636354D+02, .461042D+02,
     +  .334144D+02, .242554D+02, .176463D+02, .128708D+02,
     +  .941846D+01, .691534D+01, .509983D+01, .377572D+01,
     +  .280731D+01, .209580D+01, .157096D+01, .118147D+01,
     +  .892397D+00, .674372D+00, .511580D+00, .387820D+00,
     +  .294463D+00, .223517D+00, .169533D+00, .128383D+00,
     +  .970095D-01, .730832D-01, .548637D-01, .410139D-01,
     +  .305178D-01, .225849D-01, .166172D-01, .121475D-01,
     +  .881426D-02, .635554D-02, .453478D-02, .320563D-02,
     +  .224418D-02, .155480D-02, .106572D-02, .722198D-03,
     +  .483948D-03, .320581D-03, .210132D-03, .136283D-03,
     +  .880996D-04, .565326D-04, .362852D-04, .233720D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .151695D-04, .992218D-05, .653054D-05, .428865D-05,
     +  .277079D-05, .173286D-05, .102370D-05, .551773D-06,
     +  .257949D-06, .949708D-07, .222275D-07, .165706D-08,
     +  .000000D+00, .174546D+07, .131130D+07, .967011D+06,
     +  .712606D+06, .524769D+06, .386126D+06, .283904D+06,
     +  .208563D+06, .153097D+06, .112279D+06, .822760D+05,
     +  .602324D+05, .440564D+05, .321920D+05, .235011D+05,
     +  .171382D+05, .124860D+05, .908656D+04, .660603D+04,
     +  .479710D+04, .347997D+04, .252149D+04, .182512D+04,
     +  .131950D+04, .952998D+03, .687462D+03, .495619D+03,
     +  .355285D+03, .255720D+03, .183931D+03, .132252D+03,
     +  .950721D+02, .683518D+02, .492109D+02, .354375D+02,
     +  .255565D+02, .184699D+02, .133812D+02, .972539D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .709174D+01, .519374D+01, .381853D+01, .281934D+01,
     +  .209011D+01, .155580D+01, .116196D+01, .871639D+00,
     +  .654182D+00, .492918D+00, .371173D+00, .279966D+00,
     +  .211133D+00, .159112D+00, .119729D+00, .899051D-01,
     +  .673139D-01, .502257D-01, .373220D-01, .276064D-01,
     +  .203115D-01, .148588D-01, .108009D-01, .779359D-02,
     +  .558908D-02, .396670D-02, .278973D-02, .194354D-02,
     +  .134044D-02, .915051D-03, .617977D-03, .413039D-03,
     +  .273223D-03, .179121D-03, .116428D-03, .756090D-04,
     +  .488815D-04, .316977D-04, .206769D-04, .136050D-04,
     +  .901670D-05, .599599D-05, .396252D-05, .256272D-05,
     +  .159640D-05, .934458D-06, .496714D-06, .227740D-06,
     +  .817209D-07, .186011D-07, .140812D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .216031D+07, .161770D+07, .118838D+07, .872338D+06,
     +  .639874D+06, .468951D+06, .343416D+06, .251257D+06,
     +  .183677D+06, .134145D+06, .978836D+05, .713521D+05,
     +  .519636D+05, .378031D+05, .274745D+05, .199455D+05,
     +  .144647D+05, .104777D+05, .758148D+04, .547912D+04,
     +  .395541D+04, .285184D+04, .205389D+04, .147732D+04,
     +  .106145D+04, .761641D+03, .546146D+03, .389335D+03,
     +  .278669D+03, .199304D+03, .142478D+03, .101823D+03,
     +  .727667D+02, .520713D+02, .372647D+02, .267050D+02,
     +  .191762D+02, .138028D+02, .996586D+01, .721885D+01,
     +  .525142D+01, .383493D+01, .281229D+01, .207078D+01,
     +  .153097D+01, .113570D+01, .846239D+00, .630874D+00,
     +  .472218D+00, .353253D+00, .264723D+00, .198362D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .148542D+00, .111077D+00, .828928D-01, .616854D-01,
     +  .457488D-01, .337934D-01, .248496D-01, .181775D-01,
     +  .132219D-01, .955723D-02, .685813D-02, .489176D-02,
     +  .345356D-02, .241664D-02, .167561D-02, .115060D-02,
     +  .782418D-03, .526727D-03, .351252D-03, .232114D-03,
     +  .152263D-03, .992317D-04, .647561D-04, .421774D-04,
     +  .276146D-04, .182151D-04, .121198D-04, .811107D-05,
     +  .542877D-05, .359671D-05, .232095D-05, .143633D-05,
     +  .831520D-06, .435324D-06, .195607D-06, .684042D-07,
     +  .151543D-07, .116448D-08, .000000D+00, .264386D+07,
     +  .197351D+07, .144426D+07, .105612D+07, .771682D+06,
     +  .563340D+06, .410905D+06, .299431D+06, .218007D+06,
     +  .158564D+06, .115222D+06, .836379D+05, .606515D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .439333D+05, .317902D+05, .229763D+05, .165879D+05,
     +  .119609D+05, .861474D+04, .619668D+04, .445214D+04,
     +  .319447D+04, .228936D+04, .163849D+04, .117128D+04,
     +  .836104D+03, .596396D+03, .422860D+03, .301024D+03,
     +  .214105D+03, .152200D+03, .108150D+03, .768388D+02,
     +  .546611D+02, .388825D+02, .276940D+02, .197628D+02,
     +  .141355D+02, .101410D+02, .729843D+01, .527479D+01,
     +  .382679D+01, .278786D+01, .203927D+01, .149773D+01,
     +  .110372D+01, .817035D+00, .605118D+00, .450009D+00,
     +  .334470D+00, .249053D+00, .185445D+00, .138004D+00,
     +  .102560D+00, .760695D-01, .562664D-01, .414810D-01,
     +  .304606D-01, .222685D-01, .161961D-01, .117141D-01,
     +  .842041D-02, .600935D-02, .426358D-02, .299452D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .208511D-02, .143908D-02, .984037D-03, .666716D-03,
     +  .447542D-03, .297877D-03, .196724D-03, .129185D-03,
     +  .844475D-04, .553903D-04, .363412D-04, .240059D-04,
     +  .159877D-04, .107329D-04, .723259D-05, .485760D-05,
     +  .321730D-05, .206666D-05, .126827D-05, .725245D-06,
     +  .373628D-06, .164457D-06, .560543D-07, .120972D-07,
     +  .943304D-09, .000000D+00, .449221D+05, .671864D+05,
     +  .523200D+05, .407435D+05, .317288D+05, .247090D+05,
     +  .192426D+05, .149858D+05, .116710D+05, .908961D+04,
     +  .707944D+04, .551405D+04, .429501D+04, .334567D+04,
     +  .260636D+04, .203059D+04, .158219D+04, .123296D+04,
     +  .960964D+03, .749114D+03, .584101D+03, .455564D+03,
     +  .355432D+03, .277423D+03, .216641D+03, .169278D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .132364D+03, .103231D+03, .808839D+02, .634534D+02,
     +  .498529D+02, .392364D+02, .309446D+02, .244812D+02,
     +  .194114D+02, .154426D+02, .123310D+02, .988661D+01,
     +  .796162D+01, .644028D+01, .523514D+01, .427454D+01,
     +  .350526D+01, .288560D+01, .238339D+01, .197382D+01,
     +  .163886D+01, .136063D+01, .113114D+01, .938695D+00,
     +  .778385D+00, .644003D+00, .531224D+00, .436564D+00,
     +  .357186D+00, .290756D+00, .235328D+00, .189259D+00,
     +  .151151D+00, .119803D+00, .941792D-01, .733801D-01,
     +  .566274D-01, .433028D-01, .326918D-01, .243838D-01,
     +  .179499D-01, .130266D-01, .930796D-02, .653894D-02,
     +  .450896D-02, .304609D-02, .201113D-02, .129366D-02,
     +  .811952D-03, .492117D-03, .287712D-03, .161387D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .862826D-04, .436014D-04, .206038D-04, .899074D-05,
     +  .353340D-05, .122737D-05, .360954D-06, .845836D-07,
     +  .142663D-07, .143114D-08, .556383D-10, .212997D-12,
     +  .000000D+00, .119893D+06, .938572D+05, .726227D+05,
     +  .561897D+05, .434762D+05, .336375D+05, .260260D+05,
     +  .201358D+05, .155792D+05, .120531D+05, .932547D+04,
     +  .721483D+04, .558218D+04, .431888D+04, .334172D+04,
     +  .258564D+04, .200083D+04, .154835D+04, .119837D+04,
     +  .927576D+03, .718137D+03, .556085D+03, .430741D+03,
     +  .333750D+03, .258721D+03, .200657D+03, .155743D+03,
     +  .120540D+03, .937351D+02, .729731D+02, .568947D+02,
     +  .444323D+02, .347714D+02, .272941D+02, .214733D+02,
     +  .169486D+02, .134280D+02, .106815D+02, .853479D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .684999D+01, .552536D+01, .447690D+01, .364347D+01,
     +  .297689D+01, .244078D+01, .200667D+01, .165442D+01,
     +  .136392D+01, .112624D+01, .928389D+00, .764865D+00,
     +  .628808D+00, .515499D+00, .421094D+00, .342518D+00,
     +  .277225D+00, .223127D+00, .178470D+00, .141781D+00,
     +  .111796D+00, .874431D-01, .678004D-01, .520711D-01,
     +  .396355D-01, .297875D-01, .221189D-01, .162119D-01,
     +  .117152D-01, .833599D-02, .583179D-02, .400462D-02,
     +  .269362D-02, .177045D-02, .113271D-02, .706452D-03,
     +  .424469D-03, .245015D-03, .134641D-03, .694424D-04,
     +  .328047D-04, .134324D-04, .406892D-05, .771110D-07,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .163936D+06, .127714D+06, .982714D+05, .756075D+05,
     +  .581700D+05, .447485D+05, .344234D+05, .264774D+05,
     +  .203654D+05, .156624D+05, .120455D+05, .926275D+04,
     +  .712296D+04, .547691D+04, .421139D+04, .323800D+04,
     +  .248976D+04, .191431D+04, .147202D+04, .113192D+04,
     +  .870552D+03, .669594D+03, .515169D+03, .396440D+03,
     +  .305202D+03, .235056D+03, .181169D+03, .139211D+03,
     +  .107482D+03, .830702D+02, .642973D+02, .498450D+02,
     +  .387198D+02, .301680D+02, .235579D+02, .184548D+02,
     +  .145122D+02, .114573D+02, .908650D+01, .723842D+01,
     +  .579567D+01, .466147D+01, .376622D+01, .305511D+01,
     +  .248730D+01, .203069D+01, .166289D+01, .136167D+01,
     +  .111707D+01, .914908D+00, .749044D+00, .612023D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .498738D+00, .405019D+00, .327563D+00, .263639D+00,
     +  .211032D+00, .167893D+00, .132682D+00, .104087D+00,
     +  .810079D-01, .625075D-01, .477785D-01, .362023D-01,
     +  .270861D-01, .200264D-01, .146178D-01, .105223D-01,
     +  .746055D-02, .520278D-02, .356334D-02, .239234D-02,
     +  .157134D-02, .100612D-02, .629614D-03, .381008D-03,
     +  .222925D-03, .125476D-03, .675865D-04, .345773D-04,
     +  .166639D-04, .748131D-05, .306553D-05, .112037D-05,
     +  .347711D-06, .794411D-07, .653121D-08, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .219043D+06,
     +  .169911D+06, .130092D+06, .995866D+05, .762299D+05,
     +  .583394D+05, .446449D+05, .341581D+05, .261331D+05,
     +  .199894D+05, .152892D+05, .116919D+05, .894061D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .683546D+04, .522586D+04, .399460D+04, .305345D+04,
     +  .233371D+04, .178371D+04, .136320D+04, .104196D+04,
     +  .796416D+03, .608867D+03, .465537D+03, .356073D+03,
     +  .272432D+03, .208590D+03, .159191D+03, .122076D+03,
     +  .937028D+02, .720262D+02, .554468D+02, .427685D+02,
     +  .330869D+02, .256535D+02, .199526D+02, .155778D+02,
     +  .122103D+02, .961445D+01, .760425D+01, .604550D+01,
     +  .482817D+01, .387374D+01, .312067D+01, .252345D+01,
     +  .204640D+01, .166480D+01, .135438D+01, .110410D+01,
     +  .898652D+00, .731268D+00, .593941D+00, .481186D+00,
     +  .388538D+00, .312481D+00, .250125D+00, .199141D+00,
     +  .157599D+00, .123907D+00, .967123D-01, .748970D-01,
     +  .575142D-01, .437536D-01, .330003D-01, .245790D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .180930D-01, .131507D-01, .942795D-02, .665931D-02,
     +  .462788D-02, .315999D-02, .211641D-02, .138805D-02,
     +  .888536D-03, .556996D-03, .338648D-03, .200022D-03,
     +  .114495D-03, .634958D-04, .341103D-04, .178526D-04,
     +  .917770D-05, .469337D-05, .242498D-05, .127196D-05,
     +  .658564D-06, .320270D-06, .132626D-06, .368396D-07,
     +  .246575D-08, .000000D+00, .185942D+06, .221788D+06,
     +  .169041D+06, .128807D+06, .981379D+05, .747504D+05,
     +  .569297D+05, .433454D+05, .329986D+05, .251147D+05,
     +  .191122D+05, .145403D+05, .110608D+05, .841176D+04,
     +  .639656D+04, .486292D+04, .369674D+04, .280959D+04,
     +  .213529D+04, .162254D+04, .123298D+04, .936859D+03,
     +  .711960D+03, .541062D+03, .411300D+03, .312726D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .237938D+03, .180416D+03, .137461D+03, .104822D+03,
     +  .800422D+02, .612069D+02, .468938D+02, .360328D+02,
     +  .277470D+02, .214329D+02, .166184D+02, .129362D+02,
     +  .101159D+02, .794592D+01, .627404D+01, .497671D+01,
     +  .396609D+01, .317382D+01, .254961D+01, .205423D+01,
     +  .166058D+01, .134246D+01, .108768D+01, .879932D+00,
     +  .711801D+00, .574775D+00, .463012D+00, .371778D+00,
     +  .297368D+00, .236750D+00, .187498D+00, .147617D+00,
     +  .115468D+00, .896759D-01, .691078D-01, .528144D-01,
     +  .399881D-01, .300212D-01, .222585D-01, .163120D-01,
     +  .118050D-01, .842808D-02, .592957D-02, .410559D-02,
     +  .279408D-02, .186613D-02, .122146D-02, .781159D-03,
     +  .490023D-03, .298865D-03, .177745D-03, .103022D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .583457D-04, .324001D-04, .178225D-04, .981087D-05,
     +  .546042D-05, .308303D-05, .174409D-05, .950239D-06,
     +  .472811D-06, .195328D-06, .530846D-07, .364500D-08,
     +  .000000D+00, .391455D+06, .301119D+06, .228326D+06,
     +  .173077D+06, .131169D+06, .993751D+05, .752713D+05,
     +  .569942D+05, .431458D+05, .326508D+05, .247033D+05,
     +  .186838D+05, .141281D+05, .106795D+05, .807111D+04,
     +  .609777D+04, .460611D+04, .347826D+04, .262622D+04,
     +  .198237D+04, .149629D+04, .112918D+04, .852160D+03,
     +  .643057D+03, .485341D+03, .366348D+03, .276693D+03,
     +  .208219D+03, .157445D+03, .119145D+03, .902743D+02,
     +  .684916D+02, .520594D+02, .396839D+02, .303126D+02,
     +  .232255D+02, .178620D+02, .137912D+02, .106967D+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .833390D+01, .652721D+01, .513600D+01, .406041D+01,
     +  .322373D+01, .256955D+01, .205440D+01, .164821D+01,
     +  .132251D+01, .106371D+01, .854348D+00, .686235D+00,
     +  .550301D+00, .440287D+00, .351179D+00, .279054D+00,
     +  .220742D+00, .173714D+00, .135915D+00, .105664D+00,
     +  .815662D-01, .624842D-01, .474727D-01, .357338D-01,
     +  .266728D-01, .196614D-01, .143254D-01, .103069D-01,
     +  .731514D-02, .511550D-02, .351977D-02, .237951D-02,
     +  .157781D-02, .102443D-02, .648939D-03, .402392D-03,
     +  .241752D-03, .140856D-03, .793008D-04, .430294D-04,
     +  .224200D-04, .112120D-04, .538399D-05, .249214D-05,
     +  .112542D-05, .505351D-06, .225265D-06, .985742D-07,
     +  .387513D-07, .107066D-07, .673407D-09, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .523307D+06, .400870D+06, .302491D+06, .228170D+06,
     +  .172061D+06, .129696D+06, .977330D+05, .736163D+05,
     +  .554340D+05, .417247D+05, .313963D+05, .236144D+05,
     +  .177559D+05, .133452D+05, .100271D+05, .753093D+04,
     +  .565460D+04, .424405D+04, .318462D+04, .238879D+04,
     +  .179154D+04, .134324D+04, .100703D+04, .754845D+03,
     +  .565841D+03, .424162D+03, .318116D+03, .237668D+03,
     +  .178418D+03, .134030D+03, .100800D+03, .759054D+02,
     +  .572568D+02, .433129D+02, .328291D+02, .249583D+02,
     +  .190447D+02, .145892D+02, .112269D+02, .867847D+01,
     +  .674402D+01, .526540D+01, .413057D+01, .325437D+01,
     +  .257434D+01, .204283D+01, .162686D+01, .129584D+01,
     +  .103481D+01, .825246D+00, .658249D+00, .524250D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .416620D+00, .330102D+00, .260594D+00, .204815D+00,
     +  .160158D+00, .124526D+00, .962126D-01, .738191D-01,
     +  .562101D-01, .424535D-01, .317680D-01, .235755D-01,
     +  .172783D-01, .125176D-01, .895593D-02, .632157D-02,
     +  .439719D-02, .301008D-02, .202515D-02, .133699D-02,
     +  .864862D-03, .546398D-03, .338435D-03, .203608D-03,
     +  .119255D-03, .679139D-04, .376414D-04, .203438D-04,
     +  .108005D-04, .568668D-05, .300061D-05, .160018D-05,
     +  .857432D-06, .445766D-06, .213461D-06, .848960D-07,
     +  .221328D-07, .152748D-08, .000000D+00, .687519D+06,
     +  .524582D+06, .394013D+06, .295815D+06, .222012D+06,
     +  .166541D+06, .124884D+06, .936007D+05, .701272D+05,
     +  .525141D+05, .393095D+05, .294102D+05, .219953D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .164414D+05, .122852D+05, .917503D+04, .684972D+04,
     +  .511122D+04, .381269D+04, .284277D+04, .211903D+04,
     +  .157894D+04, .117629D+04, .876076D+03, .652447D+03,
     +  .485847D+03, .361936D+03, .268538D+03, .200198D+03,
     +  .149338D+03, .111514D+03, .833691D+02, .624281D+02,
     +  .468781D+02, .352670D+02, .266111D+02, .201528D+02,
     +  .153214D+02, .117009D+02, .897640D+01, .692280D+01,
     +  .536429D+01, .417660D+01, .326617D+01, .256462D+01,
     +  .202025D+01, .159729D+01, .126318D+01, .100165D+01,
     +  .793233D+00, .628379D+00, .497083D+00, .392400D+00,
     +  .308871D+00, .242254D+00, .189183D+00, .147001D+00,
     +  .113583D+00, .872171D-01, .665099D-01, .503396D-01,
     +  .377938D-01, .281138D-01, .207419D-01, .151132D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .108863D-01, .774468D-02, .543630D-02, .376100D-02,
     +  .256124D-02, .171477D-02, .112709D-02, .726394D-03,
     +  .457721D-03, .283232D-03, .170669D-03, .100512D-03,
     +  .578990D-04, .327436D-04, .182783D-04, .101756D-04,
     +  .570545D-05, .323788D-05, .185480D-05, .105156D-05,
     +  .566302D-06, .274220D-06, .107996D-06, .274875D-07,
     +  .194662D-08, .000000D+00, .889600D+06, .676197D+06,
     +  .505631D+06, .377904D+06, .282323D+06, .210801D+06,
     +  .157330D+06, .117356D+06, .874986D+05, .652001D+05,
     +  .485618D+05, .361482D+05, .268952D+05, .199989D+05,
     +  .148640D+05, .110410D+05, .819754D+04, .608285D+04,
     +  .451175D+04, .334462D+04, .247851D+04, .183580D+04,
     +  .135936D+04, .100620D+04, .744667D+03, .550986D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .407810D+03, .300562D+03, .222579D+03, .164912D+03,
     +  .122300D+03, .907978D+02, .675125D+02, .503368D+02,
     +  .375971D+02, .281641D+02, .211735D+02, .159797D+02,
     +  .121141D+02, .922520D+01, .706250D+01, .543252D+01,
     +  .419889D+01, .325983D+01, .254122D+01, .198753D+01,
     +  .156035D+01, .122531D+01, .964909D+00, .758901D+00,
     +  .597120D+00, .469207D+00, .367955D+00, .287747D+00,
     +  .224234D+00, .173999D+00, .134352D+00, .103165D+00,
     +  .787297D-01, .596722D-01, .448922D-01, .335031D-01,
     +  .247742D-01, .181708D-01, .131625D-01, .942633D-02,
     +  .666790D-02, .465437D-02, .320257D-02, .216962D-02,
     +  .144552D-02, .945985D-03, .607488D-03, .381867D-03,
     +  .236127D-03, .142561D-03, .844454D-04, .492010D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .283538D-04, .162781D-04, .940467D-05, .550584D-05,
     +  .325989D-05, .193250D-05, .111814D-05, .605959D-06,
     +  .291209D-06, .112404D-06, .278367D-07, .200852D-08,
     +  .000000D+00, .113542D+07, .859885D+06, .640210D+06,
     +  .476397D+06, .354328D+06, .263377D+06, .195673D+06,
     +  .145282D+06, .107812D+06, .799548D+05, .592635D+05,
     +  .438980D+05, .324987D+05, .240434D+05, .177782D+05,
     +  .131368D+05, .970185D+04, .716032D+04, .528185D+04,
     +  .389372D+04, .286909D+04, .211288D+04, .155539D+04,
     +  .114445D+04, .841866D+03, .619069D+03, .455342D+03,
     +  .333436D+03, .245335D+03, .180585D+03, .133036D+03,
     +  .981060D+02, .724503D+02, .536482D+02, .397920D+02,
     +  .295997D+02, .220958D+02, .165577D+02, .124630D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .942331D+01, .716279D+01, .547049D+01, .419824D+01,
     +  .323632D+01, .250517D+01, .194565D+01, .151694D+01,
     +  .118301D+01, .925280D+00, .722820D+00, .564943D+00,
     +  .441000D+00, .343581D+00, .266955D+00, .206704D+00,
     +  .159384D+00, .122298D+00, .933279D-01, .707856D-01,
     +  .533252D-01, .398757D-01, .295819D-01, .217446D-01,
     +  .158551D-01, .114177D-01, .812953D-02, .571783D-02,
     +  .396895D-02, .271619D-02, .183064D-02, .121384D-02,
     +  .791011D-03, .506254D-03, .317555D-03, .196300D-03,
     +  .118803D-03, .708132D-04, .417332D-04, .244808D-04,
     +  .144030D-04, .856956D-05, .517208D-05, .314233D-05,
     +  .189475D-05, .110272D-05, .595070D-06, .281985D-06,
     +  .106308D-06, .255882D-07, .187747D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .143112D+07, .107997D+07, .800690D+06, .593281D+06,
     +  .439361D+06, .325157D+06, .240502D+06, .177765D+06,
     +  .131316D+06, .969352D+05, .715126D+05, .527191D+05,
     +  .388405D+05, .285943D+05, .210379D+05, .154668D+05,
     +  .113639D+05, .834318D+04, .612173D+04, .448853D+04,
     +  .328925D+04, .240880D+04, .176318D+04, .128987D+04,
     +  .943286D+03, .689511D+03, .504087D+03, .366833D+03,
     +  .268225D+03, .196186D+03, .143601D+03, .105210D+03,
     +  .771845D+02, .567744D+02, .418273D+02, .309028D+02,
     +  .229107D+02, .170505D+02, .127454D+02, .957015D+01,
     +  .722404D+01, .547910D+01, .417577D+01, .319684D+01,
     +  .245763D+01, .189568D+01, .146798D+01, .113709D+01,
     +  .883427D+00, .685536D+00, .532282D+00, .412803D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .319540D+00, .246691D+00, .189804D+00, .145435D+00,
     +  .110901D+00, .841100D-01, .634044D-01, .474754D-01,
     +  .352881D-01, .260227D-01, .190148D-01, .137833D-01,
     +  .986772D-02, .698535D-02, .488520D-02, .337221D-02,
     +  .229547D-02, .153925D-02, .101588D-02, .659342D-03,
     +  .420682D-03, .263420D-03, .162868D-03, .988653D-04,
     +  .593275D-04, .353681D-04, .210957D-04, .126787D-04,
     +  .772139D-05, .476184D-05, .293857D-05, .178518D-05,
     +  .103737D-05, .554611D-06, .258370D-06, .950085D-07,
     +  .222289D-07, .165707D-08, .000000D+00, .178300D+07,
     +  .134085D+07, .990026D+06, .730529D+06, .538727D+06,
     +  .396996D+06, .292369D+06, .215156D+06, .158232D+06,
     +  .116278D+06, .853908D+05, .626585D+05, .459462D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .336641D+05, .246479D+05, .180316D+05, .131822D+05,
     +  .962899D+04, .702875D+04, .512657D+04, .373681D+04,
     +  .272174D+04, .198129D+04, .144133D+04, .104806D+04,
     +  .761661D+03, .553566D+03, .400406D+03, .291003D+03,
     +  .211542D+03, .153878D+03, .112029D+03, .816620D+02,
     +  .596812D+02, .436819D+02, .320606D+02, .236115D+02,
     +  .174548D+02, .129602D+02, .966603D+01, .724727D+01,
     +  .545967D+01, .413292D+01, .314275D+01, .239983D+01,
     +  .183871D+01, .141441D+01, .108832D+01, .839986D+00,
     +  .647555D+00, .499532D+00, .384915D+00, .296052D+00,
     +  .227113D+00, .173644D+00, .132225D+00, .100205D+00,
     +  .755325D-01, .565922D-01, .421191D-01, .311195D-01,
     +  .228123D-01, .165703D-01, .119411D-01, .849907D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .598193D-02, .415991D-02, .285581D-02, .193373D-02,
     +  .129028D-02, .847757D-03, .548147D-03, .348778D-03,
     +  .218115D-03, .134958D-03, .822186D-04, .496945D-04,
     +  .299660D-04, .181527D-04, .111120D-04, .689207D-05,
     +  .431480D-05, .268621D-05, .163444D-05, .944272D-06,
     +  .498724D-06, .228035D-06, .817469D-07, .186020D-07,
     +  .140813D-08, .000000D+00, .219739D+07, .164690D+07,
     +  .121111D+07, .890044D+06, .653662D+06, .479689D+06,
     +  .351779D+06, .257770D+06, .188749D+06, .138095D+06,
     +  .100960D+06, .737486D+05, .538302D+05, .392572D+05,
     +  .286072D+05, .208279D+05, .151522D+05, .110134D+05,
     +  .799891D+04, .580444D+04, .420899D+04, .304953D+04,
     +  .220803D+04, .159754D+04, .115523D+04, .834822D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .603277D+03, .433802D+03, .313423D+03, .226484D+03,
     +  .163751D+03, .118488D+03, .858352D+02, .623392D+02,
     +  .453383D+02, .330638D+02, .241934D+02, .177692D+02,
     +  .131076D+02, .971209D+01, .723406D+01, .541392D+01,
     +  .407133D+01, .307557D+01, .233311D+01, .177586D+01,
     +  .135717D+01, .103745D+01, .795552D+00, .609339D+00,
     +  .467045D+00, .357596D+00, .273305D+00, .208349D+00,
     +  .158307D+00, .119801D+00, .902336D-01, .676020D-01,
     +  .503441D-01, .372440D-01, .273536D-01, .199332D-01,
     +  .143937D-01, .103122D-01, .729723D-02, .510679D-02,
     +  .353155D-02, .241136D-02, .162438D-02, .107869D-02,
     +  .705722D-03, .454723D-03, .288656D-03, .180376D-03,
     +  .111756D-03, .683684D-04, .416373D-04, .253906D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .156011D-04, .969979D-05, .610139D-05, .385833D-05,
     +  .241162D-05, .146392D-05, .838549D-06, .436744D-06,
     +  .195812D-06, .684221D-07, .151549D-07, .116449D-08,
     +  .000000D+00, .268050D+07, .200235D+07, .146672D+07,
     +  .107361D+07, .785302D+06, .573947D+06, .419165D+06,
     +  .305865D+06, .223017D+06, .162466D+06, .118261D+06,
     +  .860051D+05, .624953D+05, .453695D+05, .329089D+05,
     +  .238478D+05, .172669D+05, .124899D+05, .902693D+04,
     +  .651788D+04, .470247D+04, .338960D+04, .244148D+04,
     +  .175710D+04, .126379D+04, .908265D+03, .652709D+03,
     +  .466669D+03, .335245D+03, .240852D+03, .173117D+03,
     +  .124521D+03, .896627D+02, .647238D+02, .467829D+02,
     +  .339057D+02, .246541D+02, .179936D+02, .131891D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .971025D+01, .718648D+01, .534384D+01, .399282D+01,
     +  .299688D+01, .225879D+01, .170823D+01, .129713D+01,
     +  .985192D+00, .750669D+00, .571300D+00, .435122D+00,
     +  .331062D+00, .251446D+00, .190496D+00, .143849D+00,
     +  .108192D+00, .809940D-01, .603129D-01, .446458D-01,
     +  .328315D-01, .239700D-01, .173648D-01, .124656D-01,
     +  .887919D-02, .624717D-02, .434730D-02, .298984D-02,
     +  .203068D-02, .136110D-02, .899704D-03, .586270D-03,
     +  .376569D-03, .238588D-03, .149050D-03, .925244D-04,
     +  .568700D-04, .349063D-04, .215174D-04, .133915D-04,
     +  .843432D-05, .536126D-05, .341112D-05, .213307D-05,
     +  .128824D-05, .730266D-06, .374629D-06, .164599D-06,
     +  .560666D-07, .120976D-07, .943307D-09, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .448666D+05, .671640D+05, .522999D+05, .407255D+05,
     +  .317127D+05, .246945D+05, .192296D+05, .149742D+05,
     +  .116605D+05, .908025D+04, .707105D+04, .550652D+04,
     +  .428825D+04, .333961D+04, .260092D+04, .202571D+04,
     +  .157780D+04, .122902D+04, .957427D+03, .745934D+03,
     +  .581242D+03, .452990D+03, .353113D+03, .275330D+03,
     +  .214751D+03, .167568D+03, .130815D+03, .101825D+03,
     +  .796029D+02, .622825D+02, .487789D+02, .382472D+02,
     +  .300295D+02, .236304D+02, .186166D+02, .146964D+02,
     +  .116272D+02, .922015D+01, .732834D+01, .583717D+01,
     +  .466013D+01, .372653D+01, .298387D+01, .239108D+01,
     +  .191639D+01, .153521D+01, .122946D+01, .981418D+00,
     +  .782476D+00, .620965D+00, .491281D+00, .386916D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .303152D+00, .236151D+00, .182784D+00, .140487D+00,
     +  .107155D+00, .810577D-01, .607705D-01, .451240D-01,
     +  .331597D-01, .240959D-01, .172985D-01, .122760D-01,
     +  .857052D-02, .589099D-02, .398066D-02, .263976D-02,
     +  .171453D-02, .108813D-02, .672897D-03, .404085D-03,
     +  .234567D-03, .130826D-03, .700362D-04, .353229D-04,
     +  .166226D-04, .713749D-05, .268402D-05, .802209D-06,
     +  .125292D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .119866D+06,
     +  .938327D+05, .726008D+05, .561700D+05, .434586D+05,
     +  .336217D+05, .260118D+05, .201231D+05, .155677D+05,
     +  .120429D+05, .931629D+04, .720660D+04, .557479D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .431226D+04, .333577D+04, .258030D+04, .199604D+04,
     +  .154404D+04, .119450D+04, .924101D+03, .715012D+03,
     +  .553273D+03, .428207D+03, .331466D+03, .256658D+03,
     +  .198792D+03, .154054D+03, .119008D+03, .923409D+02,
     +  .717005D+02, .557292D+02, .433611D+02, .337828D+02,
     +  .263778D+02, .206203D+02, .161513D+02, .126795D+02,
     +  .997644D+01, .786878D+01, .621980D+01, .492863D+01,
     +  .391225D+01, .311021D+01, .247492D+01, .197034D+01,
     +  .156820D+01, .124822D+01, .990484D+00, .785401D+00,
     +  .620044D+00, .488212D+00, .382797D+00, .298736D+00,
     +  .231887D+00, .178943D+00, .137186D+00, .104434D+00,
     +  .788919D-01, .591128D-01, .439005D-01, .322981D-01,
     +  .235224D-01, .169453D-01, .120855D-01, .849472D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .588983D-02, .402464D-02, .270659D-02, .178932D-02,
     +  .116047D-02, .737196D-03, .457162D-03, .275972D-03,
     +  .160818D-03, .904371D-04, .477580D-04, .230353D-04,
     +  .925062D-05, .200673D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .163907D+06, .127688D+06,
     +  .982475D+05, .755861D+05, .581508D+05, .447313D+05,
     +  .344080D+05, .264635D+05, .203530D+05, .156513D+05,
     +  .120355D+05, .925380D+04, .711494D+04, .546972D+04,
     +  .420493D+04, .323221D+04, .248455D+04, .190964D+04,
     +  .146782D+04, .112815D+04, .867163D+03, .666545D+03,
     +  .512423D+03, .393965D+03, .302968D+03, .233037D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .179342D+03, .137556D+03, .105977D+03, .816983D+02,
     +  .630428D+02, .486943D+02, .376604D+02, .291889D+02,
     +  .226496D+02, .176090D+02, .137217D+02, .107165D+02,
     +  .839054D+01, .658380D+01, .517971D+01, .408250D+01,
     +  .322318D+01, .254752D+01, .201496D+01, .159359D+01,
     +  .126083D+01, .994655D+00, .784416D+00, .616033D+00,
     +  .482694D+00, .376743D+00, .292778D+00, .226389D+00,
     +  .174101D+00, .133069D+00, .101038D+00, .761662D-01,
     +  .569841D-01, .422803D-01, .311006D-01, .226647D-01,
     +  .163533D-01, .116950D-01, .825397D-02, .575524D-02,
     +  .396298D-02, .269223D-02, .180387D-02, .119050D-02,
     +  .773948D-03, .494869D-03, .311315D-03, .192013D-03,
     +  .117026D-03, .696937D-04, .407999D-04, .233592D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .131000D-04, .712626D-05, .375761D-05, .188288D-05,
     +  .883901D-06, .369689D-06, .129659D-06, .289890D-07,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .219011D+06, .169882D+06, .130066D+06,
     +  .995635D+05, .762091D+05, .583207D+05, .446282D+05,
     +  .341431D+05, .261196D+05, .199774D+05, .152784D+05,
     +  .116822D+05, .893194D+04, .682768D+04, .521888D+04,
     +  .398834D+04, .304784D+04, .232867D+04, .177918D+04,
     +  .135913D+04, .103831D+04, .793128D+03, .605907D+03,
     +  .462870D+03, .353668D+03, .270260D+03, .206625D+03,
     +  .157414D+03, .120462D+03, .922330D+02, .706846D+02,
     +  .542187D+02, .416405D+02, .320472D+02, .246921D+02,
     +  .190608D+02, .147478D+02, .114361D+02, .889090D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .692751D+01, .541251D+01, .423692D+01, .332277D+01,
     +  .260909D+01, .205061D+01, .161180D+01, .126773D+01,
     +  .994371D+00, .779956D+00, .609345D+00, .475113D+00,
     +  .369107D+00, .285603D+00, .219952D+00, .168527D+00,
     +  .128376D+00, .971820D-01, .730673D-01, .545471D-01,
     +  .404027D-01, .296851D-01, .216210D-01, .156019D-01,
     +  .111675D-01, .789591D-02, .552111D-02, .381740D-02,
     +  .260791D-02, .176055D-02, .117332D-02, .772541D-03,
     +  .502126D-03, .322609D-03, .204494D-03, .129083D-03,
     +  .804977D-04, .500549D-04, .310168D-04, .192949D-04,
     +  .120177D-04, .755506D-05, .475053D-05, .298514D-05,
     +  .184318D-05, .110488D-05, .620350D-06, .314002D-06,
     +  .132011D-06, .368158D-07, .246565D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .185872D+06, .221756D+06, .169014D+06, .128782D+06,
     +  .981154D+05, .747303D+05, .569117D+05, .433293D+05,
     +  .329842D+05, .251018D+05, .191005D+05, .145298D+05,
     +  .110515D+05, .840339D+04, .638906D+04, .485619D+04,
     +  .369071D+04, .280417D+04, .213043D+04, .161817D+04,
     +  .122905D+04, .933331D+03, .708785D+03, .538203D+03,
     +  .408723D+03, .310401D+03, .235837D+03, .178516D+03,
     +  .135737D+03, .103256D+03, .786147D+02, .599028D+02,
     +  .456989D+02, .349345D+02, .267346D+02, .204971D+02,
     +  .157511D+02, .121309D+02, .936697D+01, .724914D+01,
     +  .562601D+01, .437503D+01, .340886D+01, .265972D+01,
     +  .207751D+01, .162313D+01, .126926D+01, .989954D+00,
     +  .772332D+00, .600265D+00, .465732D+00, .360126D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .277422D+00, .212763D+00, .162386D+00, .123252D+00,
     +  .929942D-01, .697094D-01, .519028D-01, .383566D-01,
     +  .281295D-01, .204594D-01, .147503D-01, .105543D-01,
     +  .746455D-02, .522477D-02, .361932D-02, .247975D-02,
     +  .168093D-02, .112650D-02, .747154D-03, .490236D-03,
     +  .318784D-03, .205201D-03, .132000D-03, .842941D-04,
     +  .539469D-04, .345993D-04, .223868D-04, .145666D-04,
     +  .957992D-05, .629802D-05, .411795D-05, .263037D-05,
     +  .161552D-05, .921161D-06, .468099D-06, .194870D-06,
     +  .530670D-07, .364492D-08, .000000D+00, .391417D+06,
     +  .301085D+06, .228296D+06, .173050D+06, .131145D+06,
     +  .993531D+05, .752517D+05, .569766D+05, .431300D+05,
     +  .326367D+05, .246906D+05, .186724D+05, .141179D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .106704D+05, .806294D+04, .609045D+04, .459954D+04,
     +  .347237D+04, .262093D+04, .197763D+04, .149202D+04,
     +  .112535D+04, .848718D+03, .639960D+03, .482552D+03,
     +  .363833D+03, .274422D+03, .206169D+03, .155589D+03,
     +  .117461D+03, .887429D+02, .670961D+02, .507844D+02,
     +  .385159D+02, .292401D+02, .222384D+02, .169516D+02,
     +  .129504D+02, .991932D+01, .761525D+01, .586332D+01,
     +  .452391D+01, .349768D+01, .270842D+01, .209994D+01,
     +  .162886D+01, .126489D+01, .979862D+00, .759503D+00,
     +  .586592D+00, .452391D+00, .347806D+00, .266467D+00,
     +  .203304D+00, .154406D+00, .116654D+00, .876347D-01,
     +  .654281D-01, .485341D-01, .357458D-01, .261346D-01,
     +  .189572D-01, .136342D-01, .973538D-02, .687251D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .480245D-02, .332153D-02, .227201D-02, .153699D-02,
     +  .102717D-02, .678371D-03, .442138D-03, .284488D-03,
     +  .180186D-03, .113120D-03, .696858D-04, .423530D-04,
     +  .252952D-04, .148855D-04, .858407D-05, .487651D-05,
     +  .270987D-05, .148082D-05, .788094D-06, .410653D-06,
     +  .204100D-06, .951859D-07, .384258D-07, .106941D-07,
     +  .673344D-09, .000000D+00, .523266D+06, .400833D+06,
     +  .302458D+06, .228140D+06, .172034D+06, .129672D+06,
     +  .977116D+05, .735972D+05, .554169D+05, .417094D+05,
     +  .313825D+05, .236020D+05, .177449D+05, .133353D+05,
     +  .100183D+05, .752298D+04, .564747D+04, .423767D+04,
     +  .317889D+04, .238365D+04, .178693D+04, .133910D+04,
     +  .100331D+04, .751502D+03, .562833D+03, .421452D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .315674D+03, .235466D+03, .176427D+03, .132227D+03,
     +  .991650D+02, .744190D+02, .559028D+02, .420767D+02,
     +  .316982D+02, .239220D+02, .180935D+02, .137153D+02,
     +  .104235D+02, .794040D+01, .606663D+01, .464514D+01,
     +  .356437D+01, .273967D+01, .210876D+01, .162409D+01,
     +  .125250D+01, .963718D+00, .742135D+00, .569554D+00,
     +  .436575D+00, .333680D+00, .254203D+00, .192900D+00,
     +  .145746D+00, .109569D+00, .819254D-01, .608945D-01,
     +  .449824D-01, .330011D-01, .240410D-01, .173816D-01,
     +  .124638D-01, .887645D-02, .625205D-02, .436102D-02,
     +  .301230D-02, .205908D-02, .139296D-02, .931778D-03,
     +  .616618D-03, .403316D-03, .260906D-03, .166642D-03,
     +  .105868D-03, .663671D-04, .413349D-04, .255589D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .157674D-04, .969145D-05, .597195D-05, .367010D-05,
     +  .224670D-05, .135174D-05, .788599D-06, .430589D-06,
     +  .211066D-06, .846687D-07, .221241D-07, .152743D-08,
     +  .000000D+00, .687474D+06, .524541D+06, .393977D+06,
     +  .295783D+06, .221983D+06, .166515D+06, .124861D+06,
     +  .935799D+05, .701086D+05, .524974D+05, .392945D+05,
     +  .293968D+05, .219833D+05, .164307D+05, .122756D+05,
     +  .916643D+04, .684202D+04, .510432D+04, .380651D+04,
     +  .283723D+04, .211406D+04, .157448D+04, .117228D+04,
     +  .872480D+03, .649215D+03, .482939D+03, .359318D+03,
     +  .266182D+03, .198072D+03, .147416D+03, .109775D+03,
     +  .817924D+02, .609961D+02, .455751D+02, .340796D+02,
     +  .255277D+02, .191630D+02, .144168D+02, .108741D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .822133D+01, .623424D+01, .473804D+01, .360891D+01,
     +  .275381D+01, .210452D+01, .160949D+01, .123277D+01,
     +  .942190D+00, .720852D+00, .549717D+00, .418787D+00,
     +  .318187D+00, .241010D+00, .181877D+00, .136683D+00,
     +  .102228D+00, .760595D-01, .562681D-01, .413775D-01,
     +  .302269D-01, .219311D-01, .157964D-01, .112871D-01,
     +  .801230D-02, .562664D-02, .391458D-02, .269801D-02,
     +  .184115D-02, .124418D-02, .832020D-03, .550981D-03,
     +  .361121D-03, .234485D-03, .150729D-03, .966615D-04,
     +  .614463D-04, .390111D-04, .247566D-04, .157817D-04,
     +  .100962D-04, .650427D-05, .418844D-05, .267726D-05,
     +  .167230D-05, .100166D-05, .555449D-06, .272531D-06,
     +  .107838D-06, .274815D-07, .194659D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .889552D+06, .676153D+06, .505592D+06, .377869D+06,
     +  .282292D+06, .210773D+06, .157305D+06, .117333D+06,
     +  .874785D+05, .651821D+05, .485457D+05, .361338D+05,
     +  .268823D+05, .199874D+05, .148537D+05, .110317D+05,
     +  .818923D+04, .607541D+04, .450509D+04, .333865D+04,
     +  .247316D+04, .183101D+04, .135507D+04, .100234D+04,
     +  .741205D+03, .547875D+03, .405014D+03, .298050D+03,
     +  .220316D+03, .162871D+03, .120457D+03, .891316D+02,
     +  .660038D+02, .489687D+02, .363552D+02, .270358D+02,
     +  .201476D+02, .150469D+02, .112663D+02, .845555D+01,
     +  .636508D+01, .480240D+01, .363161D+01, .275144D+01,
     +  .208797D+01, .158582D+01, .120645D+01, .915946D+00,
     +  .696250D+00, .527596D+00, .399464D+00, .301694D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .227191D+00, .170484D+00, .127421D+00, .947970D-01,
     +  .701703D-01, .516559D-01, .378055D-01, .274921D-01,
     +  .198601D-01, .142458D-01, .101390D-01, .717077D-02,
     +  .501828D-02, .348042D-02, .239216D-02, .162870D-02,
     +  .109870D-02, .734019D-03, .486066D-03, .318979D-03,
     +  .207733D-03, .134255D-03, .867945D-04, .558342D-04,
     +  .360158D-04, .233275D-04, .152316D-04, .100083D-04,
     +  .661986D-05, .436737D-05, .284398D-05, .179875D-05,
     +  .108204D-05, .598215D-06, .290021D-06, .112294D-06,
     +  .278325D-07, .200850D-08, .000000D+00, .113537D+07,
     +  .859838D+06, .640168D+06, .476359D+06, .354294D+06,
     +  .263347D+06, .195646D+06, .145258D+06, .107791D+06,
     +  .799353D+05, .592461D+05, .438824D+05, .324847D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .240309D+05, .177670D+05, .131268D+05, .969292D+04,
     +  .715233D+04, .527470D+04, .388731D+04, .286336D+04,
     +  .210774D+04, .155079D+04, .114033D+04, .838169D+03,
     +  .615752D+03, .452364D+03, .330765D+03, .242934D+03,
     +  .178425D+03, .131089D+03, .963513D+02, .708664D+02,
     +  .522169D+02, .384978D+02, .284289D+02, .210363D+02,
     +  .155993D+02, .115967D+02, .864152D+01, .645879D+01,
     +  .483857D+01, .363319D+01, .273344D+01, .206001D+01,
     +  .155394D+01, .117432D+01, .885683D+00, .668925D+00,
     +  .503692D+00, .379021D+00, .284539D+00, .213019D+00,
     +  .158940D+00, .118134D+00, .874138D-01, .643662D-01,
     +  .471429D-01, .343328D-01, .248483D-01, .178682D-01,
     +  .127609D-01, .904394D-02, .637074D-02, .444157D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .306975D-02, .210334D-02, .142826D-02, .961465D-03,
     +  .641486D-03, .424636D-03, .278931D-03, .182135D-03,
     +  .118299D-03, .770519D-04, .501018D-04, .327672D-04,
     +  .215828D-04, .143536D-04, .961030D-05, .646236D-05,
     +  .431980D-05, .283454D-05, .179698D-05, .107668D-05,
     +  .589558D-06, .281151D-06, .106232D-06, .255853D-07,
     +  .187745D-08, .000000D+00, .143107D+07, .107992D+07,
     +  .800644D+06, .593241D+06, .439325D+06, .325124D+06,
     +  .240473D+06, .177738D+06, .131293D+06, .969143D+05,
     +  .714939D+05, .527024D+05, .388255D+05, .285809D+05,
     +  .210259D+05, .154561D+05, .113543D+05, .833460D+04,
     +  .611406D+04, .448167D+04, .328311D+04, .240330D+04,
     +  .175827D+04, .128547D+04, .939348D+03, .685983D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .500925D+03, .364002D+03, .265685D+03, .193906D+03,
     +  .141553D+03, .103368D+03, .755272D+02, .552820D+02,
     +  .404831D+02, .296919D+02, .218202D+02, .160690D+02,
     +  .118631D+02, .877864D+01, .651570D+01, .484738D+01,
     +  .361469D+01, .270091D+01, .202170D+01, .151481D+01,
     +  .113721D+01, .852103D+00, .639462D+00, .478483D+00,
     +  .357842D+00, .267029D+00, .198737D+00, .147433D+00,
     +  .108967D+00, .801904D-01, .587329D-01, .427942D-01,
     +  .310086D-01, .223328D-01, .159835D-01, .113629D-01,
     +  .801776D-02, .562421D-02, .390549D-02, .268934D-02,
     +  .183659D-02, .124359D-02, .835267D-03, .556484D-03,
     +  .368207D-03, .242089D-03, .158500D-03, .103454D-03,
     +  .678687D-04, .445729D-04, .295108D-04, .197131D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .132991D-04, .902418D-05, .613089D-05, .412541D-05,
     +  .271137D-05, .171388D-05, .101863D-05, .550697D-06,
     +  .257785D-06, .949558D-07, .222269D-07, .165705D-08,
     +  .000000D+00, .178294D+07, .134080D+07, .989977D+06,
     +  .730485D+06, .538687D+06, .396961D+06, .292338D+06,
     +  .215128D+06, .158206D+06, .116256D+06, .853707D+05,
     +  .626405D+05, .459300D+05, .336497D+05, .246350D+05,
     +  .180201D+05, .131719D+05, .961981D+04, .702054D+04,
     +  .511924D+04, .373025D+04, .271589D+04, .197606D+04,
     +  .143665D+04, .104388D+04, .757919D+03, .550218D+03,
     +  .397414D+03, .288324D+03, .209143D+03, .151727D+03,
     +  .110101D+03, .799332D+02, .581300D+02, .422902D+02,
     +  .308125D+02, .224926D+02, .164530D+02, .120645D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .886720D+01, .653677D+01, .483009D+01, .357744D+01,
     +  .265512D+01, .197417D+01, .146942D+01, .109596D+01,
     +  .815896D+00, .608420D+00, .452413D+00, .336277D+00,
     +  .249434D+00, .184551D+00, .136122D+00, .100040D+00,
     +  .732152D-01, .533355D-01, .386575D-01, .278676D-01,
     +  .199708D-01, .142240D-01, .100649D-01, .706984D-02,
     +  .493790D-02, .341489D-02, .234264D-02, .159440D-02,
     +  .107648D-02, .721395D-03, .479947D-03, .317459D-03,
     +  .208948D-03, .137193D-03, .899944D-04, .594571D-04,
     +  .394159D-04, .263838D-04, .178333D-04, .121652D-04,
     +  .833228D-05, .569458D-05, .384075D-05, .251892D-05,
     +  .158258D-05, .930811D-06, .495951D-06, .227626D-06,
     +  .817106D-07, .186007D-07, .140812D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .219733D+07, .164684D+07, .121106D+07, .889996D+06,
     +  .653620D+06, .479651D+06, .351745D+06, .257739D+06,
     +  .188722D+06, .138071D+06, .100939D+06, .737293D+05,
     +  .538130D+05, .392418D+05, .285934D+05, .208156D+05,
     +  .151413D+05, .110036D+05, .799016D+04, .579663D+04,
     +  .420201D+04, .304330D+04, .220247D+04, .159258D+04,
     +  .115080D+04, .830861D+03, .599741D+03, .430648D+03,
     +  .310605D+03, .223966D+03, .161501D+03, .116477D+03,
     +  .840372D+02, .607317D+02, .439019D+02, .317811D+02,
     +  .230490D+02, .167497D+02, .122012D+02, .890835D+01,
     +  .652354D+01, .478832D+01, .352300D+01, .259747D+01,
     +  .191863D+01, .141878D+01, .105140D+01, .777722D+00,
     +  .576320D+00, .425888D+00, .314636D+00, .231988D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .170637D+00, .125135D+00, .914455D-01, .665549D-01,
     +  .482210D-01, .347657D-01, .249324D-01, .177775D-01,
     +  .125999D-01, .887363D-02, .620451D-02, .431461D-02,
     +  .297151D-02, .203075D-02, .137745D-02, .927359D-03,
     +  .620121D-03, .412058D-03, .272523D-03, .179614D-03,
     +  .118301D-03, .780003D-04, .518926D-04, .347044D-04,
     +  .234567D-04, .160104D-04, .110141D-04, .759074D-05,
     +  .520203D-05, .350612D-05, .228875D-05, .142629D-05,
     +  .828906D-06, .434784D-06, .195527D-06, .683971D-07,
     +  .151540D-07, .116448D-08, .000000D+00, .268043D+07,
     +  .200229D+07, .146666D+07, .107356D+07, .785256D+06,
     +  .573906D+06, .419129D+06, .305832D+06, .222988D+06,
     +  .162441D+06, .118238D+06, .859844D+05, .624768D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .453530D+05, .328942D+05, .238347D+05, .172551D+05,
     +  .124795D+05, .901760D+04, .650956D+04, .469505D+04,
     +  .338298D+04, .243558D+04, .175184D+04, .125910D+04,
     +  .904084D+03, .648982D+03, .463353D+03, .332288D+03,
     +  .238217D+03, .170769D+03, .122429D+03, .877981D+02,
     +  .630628D+02, .453047D+02, .325914D+02, .234871D+02,
     +  .169592D+02, .122745D+02, .890392D+01, .647800D+01,
     +  .472399D+01, .345308D+01, .252942D+01, .185631D+01,
     +  .136388D+01, .100431D+01, .738201D+00, .543640D+00,
     +  .399267D+00, .293187D+00, .214890D+00, .157136D+00,
     +  .114572D+00, .832535D-01, .602571D-01, .434212D-01,
     +  .311390D-01, .222156D-01, .157602D-01, .111152D-01,
     +  .779085D-02, .542239D-02, .375425D-02, .257494D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .175312D-02, .118520D-02, .795756D-03, .531063D-03,
     +  .352525D-03, .233191D-03, .153948D-03, .101743D-03,
     +  .674364D-04, .451708D-04, .304557D-04, .207604D-04,
     +  .142827D-04, .988596D-05, .683799D-05, .468745D-05,
     +  .315007D-05, .204304D-05, .126100D-05, .723375D-06,
     +  .373248D-06, .164402D-06, .560494D-07, .120970D-07,
     +  .943302D-09, .000000D+00, .154639D+07, .120297D+07,
     +  .924168D+06, .709984D+06, .545442D+06, .419036D+06,
     +  .321927D+06, .247325D+06, .190013D+06, .145984D+06,
     +  .112159D+06, .861734D+05, .662101D+05, .508733D+05,
     +  .390906D+05, .300384D+05, .230839D+05, .177408D+05,
     +  .136357D+05, .104816D+05, .805825D+04, .619622D+04,
     +  .476543D+04, .366595D+04, .282102D+04, .217164D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .167252D+04, .128408D+04, .990295D+03, .764356D+03,
     +  .590554D+03, .456822D+03, .353886D+03, .274830D+03,
     +  .213754D+03, .166685D+03, .130376D+03, .102335D+03,
     +  .806442D+02, .638266D+02, .507748D+02, .405986D+02,
     +  .326404D+02, .263913D+02, .214614D+02, .175525D+02,
     +  .144464D+02, .119390D+02, .992733D+01, .828297D+01,
     +  .694376D+01, .584165D+01, .492904D+01, .416880D+01,
     +  .353194D+01, .299569D+01, .254209D+01, .215687D+01,
     +  .182866D+01, .154829D+01, .130831D+01, .110267D+01,
     +  .926353D+00, .775854D+00, .646165D+00, .535337D+00,
     +  .440864D+00, .360601D+00, .292693D+00, .235529D+00,
     +  .187699D+00, .147960D+00, .115193D+00, .884088D-01,
     +  .669450D-01, .497056D-01, .361639D-01, .257011D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .177722D-01, .118993D-01, .766597D-02, .471728D-02,
     +  .273255D-02, .147384D-02, .721886D-03, .309964D-03,
     +  .109981D-03, .288639D-04, .436888D-05, .172087D-06,
     +  .000000D+00, .240317D+07, .186447D+07, .142772D+07,
     +  .109293D+07, .836649D+06, .640255D+06, .489961D+06,
     +  .374819D+06, .286731D+06, .219268D+06, .167673D+06,
     +  .128172D+06, .979736D+05, .748618D+05, .571997D+05,
     +  .436879D+05, .333665D+05, .254738D+05, .194475D+05,
     +  .148413D+05, .113260D+05, .864037D+04, .659181D+04,
     +  .502755D+04, .383492D+04, .292459D+04, .223092D+04,
     +  .169538D+04, .129404D+04, .987975D+03, .754883D+03,
     +  .577175D+03, .441852D+03, .338944D+03, .260347D+03,
     +  .200416D+03, .154738D+03, .119854D+03, .932047D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .727803D+02, .571283D+02, .450673D+02, .357537D+02,
     +  .285255D+02, .228942D+02, .184799D+02, .150150D+02,
     +  .122497D+02, .100573D+02, .828567D+01, .685970D+01,
     +  .569962D+01, .475024D+01, .396858D+01, .332152D+01,
     +  .278321D+01, .233337D+01, .195607D+01, .163856D+01,
     +  .137078D+01, .114449D+01, .953136D+00, .791122D+00,
     +  .654671D+00, .538629D+00, .440817D+00, .358555D+00,
     +  .289637D+00, .232127D+00, .184405D+00, .145034D+00,
     +  .112804D+00, .866309D-01, .655539D-01, .489222D-01,
     +  .357801D-01, .256242D-01, .179141D-01, .121736D-01,
     +  .800331D-02, .505479D-02, .304598D-02, .172392D-02,
     +  .906723D-03, .431634D-03, .179544D-03, .613714D-04,
     +  .154413D-04, .225090D-05, .901006D-07, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .356326D+07, .275505D+07, .210122D+07, .160178D+07,
     +  .122096D+07, .930204D+06, .708621D+06, .539536D+06,
     +  .410748D+06, .312529D+06, .237763D+06, .180779D+06,
     +  .137430D+06, .104412D+06, .793130D+05, .602097D+05,
     +  .456987D+05, .346628D+05, .262867D+05, .199218D+05,
     +  .150951D+05, .114305D+05, .865419D+04, .654833D+04,
     +  .495437D+04, .374627D+04, .283291D+04, .213322D+04,
     +  .161317D+04, .121982D+04, .922876D+03, .698467D+03,
     +  .529159D+03, .401596D+03, .305120D+03, .232273D+03,
     +  .177317D+03, .135772D+03, .104369D+03, .805507D+02,
     +  .624924D+02, .487232D+02, .382042D+02, .301260D+02,
     +  .238992D+02, .190683D+02, .153162D+02, .123521D+02,
     +  .100265D+02, .816658D+01, .668497D+01, .549208D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .452601D+01, .373901D+01, .309446D+01, .256407D+01,
     +  .212570D+01, .176213D+01, .145963D+01, .120747D+01,
     +  .996844D+00, .820886D+00, .673642D+00, .551146D+00,
     +  .448244D+00, .362599D+00, .291474D+00, .232657D+00,
     +  .184210D+00, .144543D+00, .112254D+00, .861893D-01,
     +  .653228D-01, .487579D-01, .358789D-01, .258586D-01,
     +  .182367D-01, .125465D-01, .838238D-02, .541287D-02,
     +  .335295D-02, .197910D-02, .109477D-02, .561611D-03,
     +  .259904D-03, .104737D-03, .344949D-04, .832215D-05,
     +  .116766D-05, .470146D-07, .000000D+00, .507877D+07,
     +  .391250D+07, .297131D+07, .225519D+07, .171135D+07,
     +  .129786D+07, .984072D+06, .745668D+06, .564885D+06,
     +  .427641D+06, .323655D+06, .244780D+06, .185071D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .139823D+06, .105602D+06, .796949D+05, .601219D+05,
     +  .453194D+05, .341487D+05, .257101D+05, .193495D+05,
     +  .145503D+05, .109375D+05, .821515D+04, .616845D+04,
     +  .462783D+04, .347153D+04, .259228D+04, .194372D+04,
     +  .145698D+04, .109245D+04, .819239D+03, .614830D+03,
     +  .462147D+03, .347687D+03, .262038D+03, .198015D+03,
     +  .150065D+03, .114161D+03, .871878D+02, .669321D+02,
     +  .516354D+02, .400610D+02, .312573D+02, .245359D+02,
     +  .193705D+02, .153964D+02, .122864D+02, .986930D+01,
     +  .795449D+01, .644353D+01, .523865D+01, .427222D+01,
     +  .349261D+01, .286041D+01, .234541D+01, .192408D+01,
     +  .157828D+01, .129360D+01, .105883D+01, .864881D+00,
     +  .704650D+00, .572044D+00, .462984D+00, .372422D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .297937D+00, .236814D+00, .186882D+00, .146258D+00,
     +  .113414D+00, .870184D-01, .659915D-01, .493847D-01,
     +  .363799D-01, .264111D-01, .187685D-01, .130428D-01,
     +  .883585D-02, .580786D-02, .368626D-02, .224139D-02,
     +  .129700D-02, .701958D-03, .351619D-03, .158426D-03,
     +  .619573D-04, .197102D-04, .457535D-05, .619620D-06,
     +  .246649D-07, .000000D+00, .700627D+07, .537752D+07,
     +  .406638D+07, .307287D+07, .232143D+07, .175253D+07,
     +  .132263D+07, .997451D+06, .751955D+06, .566444D+06,
     +  .426532D+06, .320917D+06, .241350D+06, .181355D+06,
     +  .136210D+06, .102211D+06, .766596D+05, .574419D+05,
     +  .430191D+05, .321863D+05, .240682D+05, .179799D+05,
     +  .134245D+05, .100135D+05, .746537D+04, .555997D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .413962D+04, .306717D+04, .228171D+04, .169657D+04,
     +  .126159D+04, .938098D+03, .697942D+03, .520006D+03,
     +  .387694D+03, .289516D+03, .216745D+03, .162714D+03,
     +  .122605D+03, .927386D+02, .705060D+02, .538655D+02,
     +  .413846D+02, .319760D+02, .248554D+02, .194314D+02,
     +  .152949D+02, .120859D+02, .961390D+01, .767285D+01,
     +  .615469D+01, .495493D+01, .400124D+01, .323899D+01,
     +  .262657D+01, .213242D+01, .173201D+01, .140660D+01,
     +  .114136D+01, .924851D+00, .747816D+00, .603092D+00,
     +  .484573D+00, .388150D+00, .308956D+00, .244547D+00,
     +  .192290D+00, .150092D+00, .116163D+00, .890586D-01,
     +  .675413D-01, .506150D-01, .374183D-01, .272182D-01,
     +  .195048D-01, .136739D-01, .936874D-02, .625347D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .404667D-02, .252624D-02, .150900D-02, .856770D-03,
     +  .454151D-03, .222388D-03, .976982D-04, .371446D-04,
     +  .114427D-04, .256396D-05, .335885D-06, .129192D-07,
     +  .000000D+00, .983350D+07, .751477D+07, .565377D+07,
     +  .425051D+07, .319424D+07, .239862D+07, .180037D+07,
     +  .135023D+07, .101215D+07, .758071D+06, .567469D+06,
     +  .424406D+06, .317226D+06, .236887D+06, .176783D+06,
     +  .131795D+06, .981903D+05, .730763D+05, .543473D+05,
     +  .403736D+05, .299708D+05, .222232D+05, .164662D+05,
     +  .121868D+05, .901300D+04, .665758D+04, .491530D+04,
     +  .361025D+04, .266209D+04, .196164D+04, .144527D+04,
     +  .106459D+04, .784423D+03, .578731D+03, .427158D+03,
     +  .315749D+03, .233940D+03, .173788D+03, .129563D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .969561D+02, .729193D+02, .551073D+02, .418783D+02,
     +  .320049D+02, .246059D+02, .190255D+02, .148115D+02,
     +  .115746D+02, .910587D+01, .718679D+01, .570082D+01,
     +  .453847D+01, .362398D+01, .290071D+01, .232574D+01,
     +  .186683D+01, .149905D+01, .120350D+01, .965339D+00,
     +  .773183D+00, .617913D+00, .492499D+00, .391030D+00,
     +  .309497D+00, .243373D+00, .190282D+00, .147767D+00,
     +  .113889D+00, .870160D-01, .658430D-01, .492699D-01,
     +  .364201D-01, .265489D-01, .190331D-01, .134376D-01,
     +  .927520D-02, .625307D-02, .410394D-02, .260901D-02,
     +  .159852D-02, .935975D-03, .520243D-03, .269482D-03,
     +  .128703D-03, .550104D-04, .202907D-04, .604400D-05,
     +  .130587D-05, .165096D-06, .585686D-08, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .134794D+08, .102562D+08, .767707D+07, .574190D+07,
     +  .429233D+07, .320604D+07, .239333D+07, .178506D+07,
     +  .133058D+07, .990881D+06, .737424D+06, .548255D+06,
     +  .407323D+06, .302300D+06, .224184D+06, .166069D+06,
     +  .122918D+06, .908730D+05, .671239D+05, .495207D+05,
     +  .365008D+05, .268700D+05, .197623D+05, .145160D+05,
     +  .106528D+05, .780664D+04, .571716D+04, .416412D+04,
     +  .304459D+04, .222419D+04, .162426D+04, .118570D+04,
     +  .865628D+03, .632691D+03, .462530D+03, .338588D+03,
     +  .248393D+03, .182688D+03, .134826D+03, .998685D+02,
     +  .743397D+02, .556018D+02, .418155D+02, .316245D+02,
     +  .240592D+02, .184076D+02, .141801D+02, .109639D+02,
     +  .853425D+01, .666383D+01, .522955D+01, .411869D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .325336D+01, .257590D+01, .204285D+01, .162184D+01,
     +  .128800D+01, .102263D+01, .811133D+00, .642398D+00,
     +  .507601D+00, .399978D+00, .313919D+00, .245591D+00,
     +  .190849D+00, .147438D+00, .113112D+00, .861096D-01,
     +  .649696D-01, .485347D-01, .358456D-01, .261439D-01,
     +  .187976D-01, .132855D-01, .924366D-02, .628386D-02,
     +  .416972D-02, .269161D-02, .168159D-02, .101149D-02,
     +  .580757D-03, .316121D-03, .160080D-03, .745985D-04,
     +  .310374D-04, .111126D-04, .320297D-05, .667590D-06,
     +  .812412D-07, .246764D-08, .000000D+00, .180676D+08,
     +  .136887D+08, .101950D+08, .758648D+07, .564192D+07,
     +  .419204D+07, .311269D+07, .230906D+07, .171169D+07,
     +  .126758D+07, .937977D+06, .693335D+06, .512074D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .377770D+06, .278441D+06, .204982D+06, .150759D+06,
     +  .110738D+06, .812585D+05, .595470D+05, .435904D+05,
     +  .318652D+05, .232688D+05, .169674D+05, .123590D+05,
     +  .898799D+04, .653119D+04, .471876D+04, .342212D+04,
     +  .247933D+04, .179525D+04, .129923D+04, .940151D+03,
     +  .681018D+03, .493308D+03, .357770D+03, .259990D+03,
     +  .189394D+03, .138424D+03, .101535D+03, .748365D+02,
     +  .554198D+02, .412632D+02, .308948D+02, .232678D+02,
     +  .176224D+02, .134381D+02, .102841D+02, .792360D+01,
     +  .612341D+01, .475597D+01, .370700D+01, .289774D+01,
     +  .227039D+01, .178167D+01, .139958D+01, .109970D+01,
     +  .863814D+00, .677807D+00, .531011D+00, .415024D+00,
     +  .323447D+00, .251042D+00, .194213D+00, .149214D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .113953D+00, .864084D-01, .650057D-01, .484592D-01,
     +  .357592D-01, .260814D-01, .187804D-01, .133272D-01,
     +  .929255D-02, .637647D-02, .427267D-02, .279308D-02,
     +  .177510D-02, .109108D-02, .645143D-03, .363764D-03,
     +  .194241D-03, .963576D-04, .439225D-04, .178437D-04,
     +  .622530D-05, .174486D-05, .352866D-06, .414393D-07,
     +  .952125D-09, .000000D+00, .237232D+08, .178990D+08,
     +  .132653D+08, .982217D+07, .726765D+07, .537237D+07,
     +  .396835D+07, .292829D+07, .215906D+07, .159019D+07,
     +  .117017D+07, .860109D+06, .631607D+06, .463245D+06,
     +  .339417D+06, .248366D+06, .181544D+06, .132518D+06,
     +  .966202D+05, .703449D+05, .511535D+05, .371417D+05,
     +  .269348D+05, .195026D+05, .141034D+05, .101812D+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .734283D+04, .526403D+04, .378772D+04, .272235D+04,
     +  .195516D+04, .140323D+04, .100679D+04, .723021D+03,
     +  .519128D+03, .373137D+03, .268698D+03, .193942D+03,
     +  .140430D+03, .102040D+03, .744970D+02, .546427D+02,
     +  .402940D+02, .298782D+02, .222840D+02, .167129D+02,
     +  .126204D+02, .956316D+01, .729572D+01, .558224D+01,
     +  .429257D+01, .331245D+01, .256338D+01, .198822D+01,
     +  .154446D+01, .120092D+01, .933973D+00, .726112D+00,
     +  .563880D+00, .437176D+00, .338119D+00, .260743D+00,
     +  .200227D+00, .153251D+00, .116469D+00, .879733D-01,
     +  .659706D-01, .490738D-01, .361665D-01, .263795D-01,
     +  .190139D-01, .135269D-01, .948152D-02, .652767D-02,
     +  .442165D-02, .292334D-02, .188475D-02, .118077D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .715042D-03, .416272D-03, .230925D-03, .121219D-03,
     +  .590559D-04, .264097D-04, .105142D-04, .359010D-05,
     +  .983863D-06, .194236D-06, .220769D-07, .299569D-09,
     +  .000000D+00, .305659D+08, .229685D+08, .169409D+08,
     +  .124829D+08, .919089D+07, .676019D+07, .496815D+07,
     +  .364723D+07, .267509D+07, .195982D+07, .143440D+07,
     +  .104856D+07, .765708D+06, .558428D+06, .406801D+06,
     +  .295935D+06, .215025D+06, .156007D+06, .113043D+06,
     +  .817847D+05, .590906D+05, .426245D+05, .307046D+05,
     +  .220810D+05, .158570D+05, .113658D+05, .813787D+04,
     +  .579031D+04, .413496D+04, .294908D+04, .210135D+04,
     +  .149609D+04, .106463D+04, .758221D+03, .539786D+03,
     +  .384648D+03, .274565D+03, .196423D+03, .140951D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .101491D+03, .734195D+02, .533570D+02, .389811D+02,
     +  .286356D+02, .211572D+02, .157185D+02, .117578D+02,
     +  .882476D+01, .666854D+01, .505351D+01, .384877D+01,
     +  .294144D+01, .225431D+01, .173158D+01, .133203D+01,
     +  .102564D+01, .789849D+00, .608029D+00, .467520D+00,
     +  .358876D+00, .274796D+00, .209789D+00, .159473D+00,
     +  .120824D+00, .908831D-01, .679373D-01, .504139D-01,
     +  .371057D-01, .270543D-01, .195196D-01, .139149D-01,
     +  .978887D-02, .678348D-02, .461585D-02, .308977D-02,
     +  .201796D-02, .128483D-02, .794618D-03, .474850D-03,
     +  .272670D-03, .149129D-03, .771375D-04, .370090D-04,
     +  .162890D-04, .637915D-05, .214125D-05, .576723D-06,
     +  .111767D-06, .123337D-07, .366811D-10, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .387052D+08, .289707D+08, .212680D+08, .155973D+08,
     +  .114288D+08, .836540D+07, .611747D+07, .446852D+07,
     +  .326080D+07, .237662D+07, .173034D+07, .125818D+07,
     +  .913806D+06, .662780D+06, .480120D+06, .347291D+06,
     +  .250880D+06, .180951D+06, .130332D+06, .937184D+05,
     +  .672918D+05, .482333D+05, .345204D+05, .246617D+05,
     +  .175911D+05, .125220D+05, .890294D+04, .628879D+04,
     +  .445818D+04, .315597D+04, .223169D+04, .157660D+04,
     +  .111306D+04, .786355D+03, .555229D+03, .392365D+03,
     +  .277706D+03, .196972D+03, .140120D+03, .100010D+03,
     +  .717092D+02, .516506D+02, .373963D+02, .272241D+02,
     +  .199324D+02, .146739D+02, .108767D+02, .808849D+01,
     +  .605626D+01, .454717D+01, .343121D+01, .259809D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .197272D+01, .150122D+01, .114408D+01, .872711D+00,
     +  .665793D+00, .507730D+00, .386733D+00, .294068D+00,
     +  .223046D+00, .168669D+00, .126994D+00, .952993D-01,
     +  .709937D-01, .525555D-01, .386196D-01, .281457D-01,
     +  .203182D-01, .145130D-01, .102414D-01, .713100D-02,
     +  .489051D-02, .329271D-02, .218069D-02, .140875D-02,
     +  .887042D-03, .542421D-03, .320419D-03, .181830D-03,
     +  .982552D-04, .501993D-04, .237827D-04, .103336D-04,
     +  .399449D-05, .132307D-05, .351671D-06, .671801D-07,
     +  .722018D-08, .000000D+00, .000000D+00, .482370D+08,
     +  .359675D+08, .262843D+08, .191873D+08, .139935D+08,
     +  .101941D+08, .741893D+07, .539278D+07, .391578D+07,
     +  .283969D+07, .205694D+07, .148793D+07, .107499D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .775527D+06, .558742D+06, .401934D+06, .288723D+06,
     +  .207058D+06, .148268D+06, .105985D+06, .756406D+05,
     +  .538847D+05, .383234D+05, .272038D+05, .192778D+05,
     +  .136313D+05, .962586D+04, .675173D+04, .475255D+04,
     +  .334015D+04, .234456D+04, .164394D+04, .115172D+04,
     +  .807361D+03, .565544D+03, .396439D+03, .278297D+03,
     +  .195757D+03, .138089D+03, .977262D+02, .694732D+02,
     +  .496098D+02, .356075D+02, .256964D+02, .186495D+02,
     +  .136088D+02, .999885D+01, .736988D+01, .546961D+01,
     +  .407027D+01, .304416D+01, .228460D+01, .171931D+01,
     +  .129677D+01, .979504D+00, .740538D+00, .559943D+00,
     +  .423219D+00, .319500D+00, .240787D+00, .181011D+00,
     +  .135665D+00, .101234D+00, .752940D-01, .555886D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .407820D-01, .296985D-01, .214486D-01, .153433D-01,
     +  .108596D-01, .759317D-02, .523828D-02, .355912D-02,
     +  .237380D-02, .155735D-02, .996463D-03, .621400D-03,
     +  .376284D-03, .220095D-03, .123656D-03, .661500D-04,
     +  .334534D-04, .156867D-04, .674520D-05, .258030D-05,
     +  .845581D-06, .222365D-06, .419722D-07, .440587D-08,
     +  .000000D+00, .000000D+00, .592390D+08, .440074D+08,
     +  .320167D+08, .232668D+08, .168913D+08, .122484D+08,
     +  .887215D+07, .641853D+07, .463811D+07, .334710D+07,
     +  .241244D+07, .173631D+07, .124802D+07, .895683D+06,
     +  .641902D+06, .459280D+06, .328115D+06, .234003D+06,
     +  .166616D+06, .118416D+06, .840173D+05, .594953D+05,
     +  .420563D+05, .296687D+05, .208915D+05, .146767D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .102960D+05, .717261D+04, .501423D+04, .349948D+04,
     +  .243889D+04, .169768D+04, .118056D+04, .821359D+03,
     +  .570934D+03, .397101D+03, .276555D+03, .192974D+03,
     +  .135022D+03, .947727D+02, .668171D+02, .473163D+02,
     +  .336771D+02, .240991D+02, .173427D+02, .125481D+02,
     +  .914170D+01, .668074D+01, .491623D+01, .362734D+01,
     +  .268991D+01, .200165D+01, .149364D+01, .111706D+01,
     +  .836655D+00, .627224D+00, .470288D+00, .352483D+00,
     +  .263880D+00, .197216D+00, .147027D+00, .109283D+00,
     +  .808735D-01, .596563D-01, .436804D-01, .317818D-01,
     +  .229541D-01, .164416D-01, .116650D-01, .818845D-02,
     +  .567847D-02, .388518D-02, .261804D-02, .173169D-02,
     +  .112675D-02, .714961D-03, .442149D-03, .265505D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .153999D-03, .857932D-04, .455081D-04, .228183D-04,
     +  .106078D-04, .452145D-05, .171430D-05, .556565D-06,
     +  .144952D-06, .270558D-07, .278056D-08, .000000D+00,
     +  .000000D+00, .717676D+08, .531227D+08, .384807D+08,
     +  .278416D+08, .201225D+08, .145258D+08, .104737D+08,
     +  .754209D+07, .542440D+07, .389589D+07, .279441D+07,
     +  .200137D+07, .143137D+07, .102208D+07, .728719D+06,
     +  .518676D+06, .368580D+06, .261443D+06, .185131D+06,
     +  .130840D+06, .923033D+05, .649841D+05, .456648D+05,
     +  .320204D+05, .224088D+05, .156438D+05, .109043D+05,
     +  .754625D+04, .524038D+04, .363256D+04, .251414D+04,
     +  .173775D+04, .119975D+04, .828628D+03, .571704D+03,
     +  .394635D+03, .272732D+03, .188830D+03, .131085D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .912807D+02, .638413D+02, .448456D+02, .316607D+02,
     +  .224724D+02, .160407D+02, .115115D+02, .831848D+01,
     +  .602948D+01, .440105D+01, .322082D+01, .236914D+01,
     +  .174876D+01, .129446D+01, .960363D+00, .713573D+00,
     +  .530718D+00, .394796D+00, .293585D+00, .218077D+00,
     +  .161722D+00, .119638D+00, .882456D-01, .648083D-01,
     +  .474457D-01, .344782D-01, .248983D-01, .178487D-01,
     +  .126899D-01, .893692D-02, .622737D-02, .428698D-02,
     +  .291174D-02, .194785D-02, .127904D-02, .826245D-03,
     +  .520492D-03, .319564D-03, .190507D-03, .109699D-03,
     +  .606674D-04, .319444D-04, .158974D-04, .733388D-05,
     +  .310108D-05, .116599D-05, .375127D-06, .967440D-07,
     +  .178527D-07, .179977D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .448666D+05, .675853D+05, .526777D+05, .410642D+05,
     +  .320164D+05, .249669D+05, .194738D+05, .151932D+05,
     +  .118569D+05, .925642D+04, .722905D+04, .564823D+04,
     +  .441537D+04, .345364D+04, .270322D+04, .211750D+04,
     +  .166018D+04, .130296D+04, .102381D+04, .805545D+03,
     +  .634789D+03, .501108D+03, .396373D+03, .314244D+03,
     +  .249777D+03, .199119D+03, .159261D+03, .127462D+03,
     +  .102772D+03, .832516D+02, .677885D+02, .555134D+02,
     +  .457460D+02, .379747D+02, .317406D+02, .267391D+02,
     +  .227118D+02, .194555D+02, .168100D+02, .146480D+02,
     +  .128723D+02, .114009D+02, .101719D+02, .913581D+01,
     +  .825347D+01, .749398D+01, .683523D+01, .625172D+01,
     +  .573557D+01, .526858D+01, .484628D+01, .445968D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .410320D+01, .377248D+01, .346417D+01, .317570D+01,
     +  .290510D+01, .265087D+01, .241188D+01, .218728D+01,
     +  .197639D+01, .177870D+01, .159378D+01, .142203D+01,
     +  .126134D+01, .111251D+01, .975234D+00, .849205D+00,
     +  .734100D+00, .629570D+00, .535239D+00, .450700D+00,
     +  .375471D+00, .309027D+00, .251428D+00, .201285D+00,
     +  .158471D+00, .122394D+00, .924549D-01, .680450D-01,
     +  .485545D-01, .333980D-01, .218934D-01, .135594D-01,
     +  .777950D-02, .402130D-02, .178746D-02, .626004D-03,
     +  .141934D-03, .111153D-04, .000000D+00, .120373D+06,
     +  .942878D+05, .730087D+05, .565358D+05, .437865D+05,
     +  .339158D+05, .262755D+05, .203595D+05, .157797D+05,
     +  .122329D+05, .948672D+04, .735943D+04, .571185D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .443518D+04, .344603D+04, .267920D+04, .208477D+04,
     +  .162366D+04, .126595D+04, .988238D+03, .772602D+03,
     +  .605000D+03, .474689D+03, .373253D+03, .294248D+03,
     +  .232632D+03, .184540D+03, .146460D+03, .117127D+03,
     +  .941072D+02, .760172D+02, .617613D+02, .505049D+02,
     +  .416113D+02, .345290D+02, .288833D+02, .243677D+02,
     +  .207370D+02, .178046D+02, .154193D+02, .134700D+02,
     +  .118609D+02, .105226D+02, .939791D+01, .844368D+01,
     +  .762492D+01, .691738D+01, .629288D+01, .574281D+01,
     +  .524724D+01, .480132D+01, .439517D+01, .402280D+01,
     +  .367937D+01, .336122D+01, .306543D+01, .278980D+01,
     +  .253258D+01, .229243D+01, .206828D+01, .185926D+01,
     +  .166469D+01, .148391D+01, .131716D+01, .116220D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .101965D+01, .889060D+00, .769987D+00, .661968D+00,
     +  .564545D+00, .477223D+00, .399508D+00, .330848D+00,
     +  .270624D+00, .218794D+00, .174008D+00, .136055D+00,
     +  .104328D+00, .782104D-01, .571031D-01, .403970D-01,
     +  .275328D-01, .178665D-01, .109434D-01, .620053D-02,
     +  .315987D-02, .138118D-02, .474089D-03, .105300D-03,
     +  .833329D-05, .000000D+00, .164452D+06, .128177D+06,
     +  .986863D+05, .759794D+05, .585034D+05, .450473D+05,
     +  .346913D+05, .267175D+05, .205807D+05, .158554D+05,
     +  .122185D+05, .941788D+04, .726205D+04, .560162D+04,
     +  .432321D+04, .333827D+04, .257968D+04, .199496D+04,
     +  .154437D+04, .119682D+04, .928804D+03, .721883D+03,
     +  .562123D+03, .438618D+03, .343111D+03, .269149D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .211850D+03, .166801D+03, .132356D+03, .105518D+03,
     +  .845826D+02, .682011D+02, .553594D+02, .452825D+02,
     +  .373133D+02, .310007D+02, .259839D+02, .219729D+02,
     +  .187515D+02, .161439D+02, .140232D+02, .122796D+02,
     +  .108353D+02, .962582D+01, .860334D+01, .772897D+01,
     +  .697610D+01, .631398D+01, .573315D+01, .521201D+01,
     +  .474528D+01, .432223D+01, .393643D+01, .358254D+01,
     +  .325661D+01, .295538D+01, .267639D+01, .241766D+01,
     +  .217762D+01, .195500D+01, .174873D+01, .155798D+01,
     +  .138184D+01, .122043D+01, .107138D+01, .935165D+00,
     +  .811165D+00, .698833D+00, .597586D+00, .506866D+00,
     +  .426079D+00, .354659D+00, .291996D+00, .237398D+00,
     +  .190739D+00, .150709D+00, .117037D+00, .891056D-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .662955D-01, .480163D-01, .336737D-01, .227373D-01,
     +  .146030D-01, .884336D-02, .494643D-02, .248374D-02,
     +  .106668D-02, .358398D-03, .778542D-04, .623256D-05,
     +  .000000D+00, .219595D+06, .170407D+06, .130537D+06,
     +  .999849D+05, .765869D+05, .586593D+05, .449316D+05,
     +  .344151D+05, .263634D+05, .201959D+05, .154743D+05,
     +  .118578D+05, .908928D+04, .696871D+04, .534530D+04,
     +  .410167D+04, .314944D+04, .241977D+04, .186087D+04,
     +  .143240D+04, .110403D+04, .852103D+03, .658844D+03,
     +  .510401D+03, .396368D+03, .308645D+03, .241150D+03,
     +  .188444D+03, .148421D+03, .117450D+03, .934586D+02,
     +  .748125D+02, .602952D+02, .489784D+02, .400873D+02,
     +  .330881D+02, .275593D+02, .231637D+02, .196524D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .168239D+02, .145343D+02, .126597D+02, .111129D+02,
     +  .982230D+01, .873511D+01, .780857D+01, .701359D+01,
     +  .631695D+01, .570822D+01, .516427D+01, .467927D+01,
     +  .424170D+01, .384464D+01, .348233D+01, .315044D+01,
     +  .284543D+01, .256455D+01, .230560D+01, .206679D+01,
     +  .184663D+01, .164388D+01, .145753D+01, .128649D+01,
     +  .113070D+01, .987723D+00, .857850D+00, .740350D+00,
     +  .634565D+00, .539809D+00, .455435D+00, .380770D+00,
     +  .315186D+00, .258023D+00, .208539D+00, .166537D+00,
     +  .130753D+00, .100866D+00, .762604D-01, .563214D-01,
     +  .404744D-01, .281454D-01, .188329D-01, .119748D-01,
     +  .717208D-02, .396175D-02, .196099D-02, .827972D-03,
     +  .272575D-03, .579899D-04, .469378D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .185872D+06, .222317D+06, .169516D+06, .129232D+06,
     +  .985190D+05, .750920D+05, .572358D+05, .436197D+05,
     +  .332444D+05, .253350D+05, .193095D+05, .147171D+05,
     +  .112193D+05, .855374D+04, .652379D+04, .497692D+04,
     +  .379891D+04, .290115D+04, .221735D+04, .169609D+04,
     +  .129892D+04, .995985D+03, .764990D+03, .588636D+03,
     +  .453997D+03, .351068D+03, .272383D+03, .211331D+03,
     +  .165273D+03, .129862D+03, .102611D+03, .815692D+02,
     +  .652925D+02, .526848D+02, .428413D+02, .351390D+02,
     +  .290902D+02, .243075D+02, .205069D+02, .174601D+02,
     +  .150048D+02, .130029D+02, .113574D+02, .998936D+01,
     +  .884099D+01, .786565D+01, .703168D+01, .630348D+01,
     +  .566957D+01, .510536D+01, .460444D+01, .415453D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .374822D+01, .337929D+01, .304310D+01, .273577D+01,
     +  .245432D+01, .219627D+01, .195964D+01, .174275D+01,
     +  .154416D+01, .136270D+01, .119710D+01, .104715D+01,
     +  .910332D+00, .786789D+00, .675675D+00, .576236D+00,
     +  .487696D+00, .409333D+00, .340410D+00, .280245D+00,
     +  .228142D+00, .183322D+00, .145529D+00, .113548D+00,
     +  .870249D-01, .653470D-01, .479135D-01, .341687D-01,
     +  .235643D-01, .156278D-01, .983972D-02, .582986D-02,
     +  .318116D-02, .155271D-02, .644826D-03, .208155D-03,
     +  .434229D-04, .355237D-05, .000000D+00, .392093D+06,
     +  .301692D+06, .228840D+06, .173537D+06, .131582D+06,
     +  .997442D+05, .756020D+05, .572905D+05, .434112D+05,
     +  .328885D+05, .249163D+05, .188745D+05, .142989D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .108325D+05, .820818D+04, .622053D+04, .471607D+04,
     +  .357674D+04, .271444D+04, .206140D+04, .156708D+04,
     +  .119261D+04, .909006D+03, .694009D+03, .531027D+03,
     +  .407332D+03, .313468D+03, .241182D+03, .187060D+03,
     +  .145766D+03, .114228D+03, .900635D+02, .715110D+02,
     +  .572492D+02, .461951D+02, .376081D+02, .309103D+02,
     +  .256495D+02, .214946D+02, .181834D+02, .155293D+02,
     +  .133761D+02, .116146D+02, .101566D+02, .893778D+01,
     +  .790699D+01, .702927D+01, .626621D+01, .560493D+01,
     +  .501919D+01, .450175D+01, .403951D+01, .362438D+01,
     +  .324967D+01, .291026D+01, .260194D+01, .232138D+01,
     +  .206585D+01, .183307D+01, .162115D+01, .142842D+01,
     +  .125353D+01, .109499D+01, .952432D+00, .823246D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .707405D+00, .603944D+00, .512002D+00, .430716D+00,
     +  .359287D+00, .296912D+00, .242865D+00, .196411D+00,
     +  .156748D+00, .123564D+00, .957056D-01, .727915D-01,
     +  .542235D-01, .394237D-01, .278643D-01, .190332D-01,
     +  .124940D-01, .777865D-02, .455232D-02, .245007D-02,
     +  .117736D-02, .480197D-03, .151825D-03, .310518D-04,
     +  .256866D-05, .000000D+00, .523997D+06, .401489D+06,
     +  .303045D+06, .228667D+06, .172506D+06, .130094D+06,
     +  .980898D+05, .739358D+05, .557202D+05, .419809D+05,
     +  .316257D+05, .238198D+05, .179398D+05, .135098D+05,
     +  .101745D+05, .766286D+04, .577270D+04, .434977D+04,
     +  .327925D+04, .247350D+04, .186738D+04, .141113D+04,
     +  .106782D+04, .809282D+03, .614602D+03, .467857D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .357277D+03, .272722D+03, .209864D+03, .162253D+03,
     +  .126151D+03, .986908D+02, .777591D+02, .617841D+02,
     +  .494882D+02, .400023D+02, .326518D+02, .269149D+02,
     +  .224107D+02, .188414D+02, .159951D+02, .136974D+02,
     +  .118259D+02, .102836D+02, .899968D+01, .791823D+01,
     +  .700111D+01, .620718D+01, .552215D+01, .491822D+01,
     +  .438732D+01, .391551D+01, .349407D+01, .311583D+01,
     +  .277522D+01, .246770D+01, .218959D+01, .193789D+01,
     +  .171008D+01, .150404D+01, .131789D+01, .115009D+01,
     +  .998986D+00, .864018D+00, .742537D+00, .634348D+00,
     +  .538383D+00, .453693D+00, .379341D+00, .314465D+00,
     +  .258219D+00, .209837D+00, .168565D+00, .133591D+00,
     +  .104556D+00, .803768D-01, .606543D-01, .448108D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .322969D-01, .226161D-01, .152945D-01, .993221D-02,
     +  .611071D-02, .352964D-02, .187180D-02, .884400D-03,
     +  .353639D-03, .109255D-03, .218503D-04, .183067D-05,
     +  .000000D+00, .688263D+06, .525249D+06, .394611D+06,
     +  .296350D+06, .222491D+06, .166970D+06, .125268D+06,
     +  .939447D+05, .704352D+05, .527897D+05, .395562D+05,
     +  .296309D+05, .221929D+05, .166182D+05, .124434D+05,
     +  .931656D+04, .697634D+04, .522449D+04, .391402D+04,
     +  .293341D+04, .220011D+04, .165146D+04, .124116D+04,
     +  .934111D+03, .704374D+03, .532325D+03, .403538D+03,
     +  .305725D+03, .233506D+03, .179182D+03, .138272D+03,
     +  .107371D+03, .839779D+02, .662469D+02, .526903D+02,
     +  .423007D+02, .343002D+02, .280942D+02, .232491D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .194305D+02, .164004D+02, .139658D+02, .119914D+02,
     +  .103712D+02, .902765D+01, .790052D+01, .694845D+01,
     +  .612768D+01, .542253D+01, .480371D+01, .426230D+01,
     +  .378360D+01, .335826D+01, .297863D+01, .263873D+01,
     +  .233365D+01, .205942D+01, .181277D+01, .159093D+01,
     +  .139156D+01, .121261D+01, .105234D+01, .908954D+00,
     +  .781722D+00, .667965D+00, .567332D+00, .478674D+00,
     +  .400966D+00, .333214D+00, .274510D+00, .223976D+00,
     +  .180822D+00, .144284D+00, .113551D+00, .882350D-01,
     +  .673212D-01, .504035D-01, .369304D-01, .263851D-01,
     +  .183048D-01, .122552D-01, .787285D-02, .478631D-02,
     +  .272850D-02, .142565D-02, .662273D-03, .259628D-03,
     +  .783904D-04, .153376D-04, .130155D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .890402D+06, .676916D+06, .506275D+06, .378480D+06,
     +  .282839D+06, .211263D+06, .157743D+06, .117725D+06,
     +  .878296D+05, .654962D+05, .488267D+05, .363852D+05,
     +  .271072D+05, .201885D+05, .150335D+05, .111926D+05,
     +  .833306D+04, .620400D+04, .462005D+04, .344141D+04,
     +  .256502D+04, .191311D+04, .142846D+04, .106794D+04,
     +  .799850D+03, .600319D+03, .451907D+03, .339921D+03,
     +  .257777D+03, .196394D+03, .150473D+03, .116017D+03,
     +  .901044D+02, .705929D+02, .557700D+02, .444817D+02,
     +  .358413D+02, .291780D+02, .240040D+02, .199473D+02,
     +  .167436D+02, .141811D+02, .121115D+02, .104201D+02,
     +  .902291D+01, .785528D+01, .687284D+01, .602931D+01,
     +  .530764D+01, .467717D+01, .412816D+01, .364515D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .321819D+01, .283919D+01, .250174D+01, .220062D+01,
     +  .193155D+01, .169101D+01, .147600D+01, .128397D+01,
     +  .111270D+01, .960288D+00, .824806D+00, .705364D+00,
     +  .599270D+00, .506037D+00, .424448D+00, .353418D+00,
     +  .291911D+00, .238988D+00, .193750D+00, .155398D+00,
     +  .123165D+00, .962532D-01, .742567D-01, .562296D-01,
     +  .417678D-01, .303498D-01, .214938D-01, .147725D-01,
     +  .979108D-02, .622195D-02, .373768D-02, .210278D-02,
     +  .108251D-02, .494414D-03, .190042D-03, .560976D-04,
     +  .107464D-04, .923543D-06, .000000D+00, .113628D+07,
     +  .860658D+06, .640902D+06, .477016D+06, .354883D+06,
     +  .263873D+06, .196117D+06, .145680D+06, .108168D+06,
     +  .802725D+05, .595476D+05, .441520D+05, .327257D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .242464D+05, .179596D+05, .132989D+05, .984668D+04,
     +  .728969D+04, .539741D+04, .399692D+04, .296124D+04,
     +  .219515D+04, .162884D+04, .121002D+04, .900395D+03,
     +  .671326D+03, .501987D+03, .375005D+03, .282446D+03,
     +  .213721D+03, .162629D+03, .124541D+03, .960765D+02,
     +  .747788D+02, .586979D+02, .465257D+02, .372623D+02,
     +  .301583D+02, .246709D+02, .203896D+02, .170238D+02,
     +  .143433D+02, .121870D+02, .104316D+02, .898690D+01,
     +  .778410D+01, .677591D+01, .591369D+01, .517908D+01,
     +  .454015D+01, .398632D+01, .350146D+01, .307504D+01,
     +  .269854D+01, .236516D+01, .206937D+01, .180660D+01,
     +  .157309D+01, .136562D+01, .118147D+01, .101825D+01,
     +  .873923D+00, .746431D+00, .634750D+00, .536193D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .450150D+00, .375350D+00, .310667D+00, .255036D+00,
     +  .207497D+00, .167147D+00, .133183D+00, .104846D+00,
     +  .813640D-01, .623179D-01, .468328D-01, .345130D-01,
     +  .248700D-01, .174583D-01, .118866D-01, .779905D-02,
     +  .490233D-02, .290983D-02, .161551D-02, .819381D-03,
     +  .367943D-03, .138686D-03, .400369D-04, .751514D-05,
     +  .653977D-06, .000000D+00, .143205D+07, .108080D+07,
     +  .801434D+06, .593947D+06, .439957D+06, .325690D+06,
     +  .240978D+06, .178191D+06, .131697D+06, .972757D+05,
     +  .718169D+05, .529910D+05, .390834D+05, .288113D+05,
     +  .212317D+05, .156399D+05, .115184D+05, .848112D+04,
     +  .624484D+04, .459838D+04, .338724D+04, .249620D+04,
     +  .184113D+04, .135937D+04, .100525D+04, .744759D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .553329D+03, .410645D+03, .307272D+03, .230985D+03,
     +  .174618D+03, .132855D+03, .101834D+03, .787639D+02,
     +  .614471D+02, .484154D+02, .385525D+02, .310290D+02,
     +  .252462D+02, .207559D+02, .172409D+02, .144531D+02,
     +  .122191D+02, .104071D+02, .892127D+01, .768871D+01,
     +  .665940D+01, .578253D+01, .503848D+01, .439416D+01,
     +  .383819D+01, .335381D+01, .292995D+01, .255769D+01,
     +  .222984D+01, .194059D+01, .168510D+01, .145940D+01,
     +  .126007D+01, .108422D+01, .929316D+00, .793187D+00,
     +  .673689D+00, .569672D+00, .478466D+00, .399358D+00,
     +  .331038D+00, .272350D+00, .222215D+00, .179665D+00,
     +  .143802D+00, .113829D+00, .890054D-01, .685860D-01,
     +  .521514D-01, .388955D-01, .284364D-01, .203204D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .141388D-01, .953607D-02, .619358D-02, .385077D-02,
     +  .225831D-02, .123725D-02, .618250D-03, .272959D-03,
     +  .100900D-03, .284971D-04, .524519D-05, .462120D-06,
     +  .000000D+00, .178400D+07, .134174D+07, .990825D+06,
     +  .731244D+06, .539366D+06, .397567D+06, .292880D+06,
     +  .215613D+06, .158640D+06, .116643D+06, .857164D+05,
     +  .629493D+05, .462058D+05, .338958D+05, .248547D+05,
     +  .182162D+05, .133468D+05, .977587D+04, .715971D+04,
     +  .524332D+04, .384085D+04, .281445D+04, .206387D+04,
     +  .151487D+04, .111354D+04, .819963D+03, .605450D+03,
     +  .446492D+03, .332004D+03, .248012D+03, .186316D+03,
     +  .140876D+03, .107321D+03, .825113D+02, .639939D+02,
     +  .501361D+02, .397031D+02, .317852D+02, .257280D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .210457D+02, .173954D+02, .145117D+02, .122092D+02,
     +  .103485D+02, .882787D+01, .757094D+01, .652509D+01,
     +  .563754D+01, .488745D+01, .424069D+01, .368513D+01,
     +  .320342D+01, .278399D+01, .241753D+01, .209653D+01,
     +  .181489D+01, .156754D+01, .135030D+01, .115957D+01,
     +  .992318D+00, .845885D+00, .717992D+00, .606416D+00,
     +  .509903D+00, .425815D+00, .353349D+00, .291174D+00,
     +  .238116D+00, .193095D+00, .155144D+00, .123380D+00,
     +  .970208D-01, .753488D-01, .576536D-01, .435208D-01,
     +  .322118D-01, .233626D-01, .165549D-01, .114168D-01,
     +  .762758D-02, .490379D-02, .301554D-02, .174724D-02,
     +  .944592D-03, .465018D-03, .201859D-03, .731870D-04,
     +  .202291D-04, .365370D-05, .325859D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .219846D+07, .164786D+07, .121197D+07, .890810D+06,
     +  .654347D+06, .480301D+06, .352325D+06, .258258D+06,
     +  .189185D+06, .138485D+06, .101308D+06, .740591D+05,
     +  .541073D+05, .395044D+05, .288277D+05, .210245D+05,
     +  .153275D+05, .111695D+05, .813803D+04, .592834D+04,
     +  .431929D+04, .314770D+04, .229537D+04, .167523D+04,
     +  .122431D+04, .896237D+03, .657845D+03, .482189D+03,
     +  .356391D+03, .264628D+03, .197606D+03, .148526D+03,
     +  .112486D+03, .859883D+02, .663182D+02, .516759D+02,
     +  .407078D+02, .324241D+02, .261155D+02, .212596D+02,
     +  .174887D+02, .145209D+02, .121594D+02, .102576D+02,
     +  .870866D+01, .743271D+01, .637484D+01, .548044D+01,
     +  .472758D+01, .408120D+01, .352844D+01, .305144D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .263815D+01, .227892D+01, .196592D+01, .169282D+01,
     +  .145432D+01, .124605D+01, .106427D+01, .905812D+00,
     +  .767917D+00, .648214D+00, .544422D+00, .455201D+00,
     +  .377956D+00, .311812D+00, .255429D+00, .207630D+00,
     +  .167341D+00, .133609D+00, .105571D+00, .824691D-01,
     +  .636125D-01, .483297D-01, .362171D-01, .266015D-01,
     +  .191394D-01, .134484D-01, .919205D-02, .608304D-02,
     +  .387100D-02, .235432D-02, .134769D-02, .718922D-03,
     +  .348674D-03, .148816D-03, .529280D-04, .143222D-04,
     +  .254018D-05, .229298D-06, .000000D+00, .268164D+07,
     +  .200338D+07, .146764D+07, .107443D+07, .786035D+06,
     +  .574602D+06, .419750D+06, .306387D+06, .223483D+06,
     +  .162883D+06, .118632D+06, .863363D+05, .627907D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .456328D+05, .331436D+05, .240569D+05, .174531D+05,
     +  .126557D+05, .917450D+04, .664918D+04, .481924D+04,
     +  .349340D+04, .253372D+04, .183903D+04, .133653D+04,
     +  .972846D+03, .709997D+03, .517376D+03, .380188D+03,
     +  .280668D+03, .208378D+03, .155733D+03, .117284D+03,
     +  .891675D+02, .684039D+02, .530262D+02, .415624D+02,
     +  .329443D+02, .264090D+02, .213989D+02, .175226D+02,
     +  .144827D+02, .120719D+02, .101367D+02, .856576D+01,
     +  .727603D+01, .621049D+01, .531295D+01, .456044D+01,
     +  .391708D+01, .336936D+01, .289893D+01, .249334D+01,
     +  .214260D+01, .183862D+01, .157483D+01, .134575D+01,
     +  .114685D+01, .974260D+00, .824700D+00, .695325D+00,
     +  .583696D+00, .487493D+00, .405307D+00, .334599D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .274437D+00, .223484D+00, .180569D+00, .144637D+00,
     +  .114757D+00, .900913D-01, .699111D-01, .535586D-01,
     +  .404029D-01, .300560D-01, .219071D-01, .156356D-01,
     +  .108938D-01, .737954D-02, .483714D-02, .304672D-02,
     +  .183260D-02, .103636D-02, .545496D-03, .260638D-03,
     +  .109379D-03, .381662D-04, .101143D-04, .176271D-05,
     +  .161023D-06, .000000D+00, .449221D+05, .673987D+05,
     +  .525112D+05, .409157D+05, .318839D+05, .248488D+05,
     +  .193686D+05, .150995D+05, .117735D+05, .918218D+04,
     +  .716304D+04, .558957D+04, .436328D+04, .340741D+04,
     +  .266223D+04, .208118D+04, .162802D+04, .127451D+04,
     +  .998665D+03, .783343D+03, .615201D+03, .483843D+03,
     +  .381167D+03, .300861D+03, .238007D+03, .188770D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .150164D+03, .119479D+03, .957472D+02, .770618D+02,
     +  .623225D+02, .506712D+02, .414377D+02, .341184D+02,
     +  .282651D+02, .235798D+02, .198116D+02, .167641D+02,
     +  .142839D+02, .122500D+02, .105714D+02, .917178D+01,
     +  .799497D+01, .699646D+01, .614173D+01, .540403D+01,
     +  .476475D+01, .420158D+01, .370879D+01, .327033D+01,
     +  .288279D+01, .253810D+01, .223109D+01, .195743D+01,
     +  .171349D+01, .149617D+01, .130276D+01, .113090D+01,
     +  .978486D+00, .843608D+00, .724548D+00, .619737D+00,
     +  .527740D+00, .447595D+00, .377283D+00, .316230D+00,
     +  .263435D+00, .217984D+00, .179049D+00, .145876D+00,
     +  .117784D+00, .941544D-01, .744172D-01, .580575D-01,
     +  .447491D-01, .338820D-01, .251878D-01, .183315D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .130154D-01, .897495D-02, .597649D-02, .381768D-02,
     +  .230840D-02, .130824D-02, .679239D-03, .312888D-03,
     +  .121184D-03, .356809D-04, .636955D-05, .334388D-06,
     +  .000000D+00, .120150D+06, .940886D+05, .728310D+05,
     +  .563773D+05, .436453D+05, .337899D+05, .261634D+05,
     +  .202597D+05, .156909D+05, .121540D+05, .941655D+04,
     +  .729710D+04, .565652D+04, .438610D+04, .340252D+04,
     +  .264067D+04, .205066D+04, .159349D+04, .123929D+04,
     +  .964700D+03, .751834D+03, .586691D+03, .458557D+03,
     +  .359048D+03, .281745D+03, .221627D+03, .174855D+03,
     +  .137946D+03, .109621D+03, .874798D+02, .701505D+02,
     +  .565506D+02, .458557D+02, .374384D+02, .307585D+02,
     +  .254486D+02, .212098D+02, .178047D+02, .150535D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .128121D+02, .109754D+02, .945400D+01, .818377D+01,
     +  .711313D+01, .620320D+01, .542316D+01, .475206D+01,
     +  .416491D+01, .365487D+01, .320420D+01, .280868D+01,
     +  .245928D+01, .215021D+01, .187654D+01, .163420D+01,
     +  .141968D+01, .122995D+01, .106240D+01, .914701D+00,
     +  .784771D+00, .670742D+00, .570954D+00, .483840D+00,
     +  .408383D+00, .342544D+00, .285698D+00, .236810D+00,
     +  .194961D+00, .159312D+00, .129114D+00, .103687D+00,
     +  .824258D-01, .647783D-01, .502383D-01, .384864D-01,
     +  .289541D-01, .213800D-01, .154507D-01, .108879D-01,
     +  .744841D-02, .491709D-02, .311195D-02, .186231D-02,
     +  .104467D-02, .536036D-03, .243618D-03, .928607D-04,
     +  .268385D-04, .470897D-05, .250876D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .164214D+06, .127965D+06, .984972D+05, .758109D+05,
     +  .583533D+05, .449136D+05, .345723D+05, .266116D+05,
     +  .204865D+05, .157717D+05, .121442D+05, .935185D+04,
     +  .720346D+04, .554966D+04, .427717D+04, .329750D+04,
     +  .254360D+04, .196306D+04, .151618D+04, .117194D+04,
     +  .906844D+03, .702518D+03, .545055D+03, .423582D+03,
     +  .329866D+03, .257482D+03, .201569D+03, .157751D+03,
     +  .124365D+03, .984489D+02, .783126D+02, .626203D+02,
     +  .503692D+02, .407942D+02, .332501D+02, .272942D+02,
     +  .225732D+02, .188058D+02, .157828D+02, .133359D+02,
     +  .113443D+02, .970505D+01, .834552D+01, .720693D+01,
     +  .624572D+01, .542705D+01, .472743D+01, .411930D+01,
     +  .359460D+01, .313398D+01, .273239D+01, .237992D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .207010D+01, .179751D+01, .155759D+01, .134650D+01,
     +  .116091D+01, .997965D+00, .855141D+00, .730213D+00,
     +  .621180D+00, .526298D+00, .443901D+00, .372917D+00,
     +  .311308D+00, .258401D+00, .213143D+00, .174612D+00,
     +  .141967D+00, .114468D+00, .914417D-01, .722993D-01,
     +  .565063D-01, .435704D-01, .331804D-01, .248072D-01,
     +  .181985D-01, .130618D-01, .913773D-02, .620332D-02,
     +  .406120D-02, .254761D-02, .150976D-02, .836993D-03,
     +  .423858D-03, .189810D-03, .711050D-04, .201425D-04,
     +  .346805D-05, .187783D-06, .000000D+00, .219343D+06,
     +  .170182D+06, .130336D+06, .998062D+05, .764277D+05,
     +  .585176D+05, .448056D+05, .343030D+05, .262638D+05,
     +  .201073D+05, .153956D+05, .117880D+05, .902737D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .691384D+04, .529669D+04, .405864D+04, .311137D+04,
     +  .238611D+04, .183113D+04, .140614D+04, .108086D+04,
     +  .831665D+03, .640823D+03, .494518D+03, .382368D+03,
     +  .296302D+03, .230263D+03, .178849D+03, .139938D+03,
     +  .109934D+03, .867805D+02, .688583D+02, .549619D+02,
     +  .441741D+02, .357323D+02, .291118D+02, .238992D+02,
     +  .197664D+02, .164719D+02, .138221D+02, .116791D+02,
     +  .992625D+01, .848160D+01, .727922D+01, .627053D+01,
     +  .541675D+01, .469173D+01, .406542D+01, .352845D+01,
     +  .305999D+01, .265408D+01, .229999D+01, .199064D+01,
     +  .172006D+01, .148332D+01, .127621D+01, .109515D+01,
     +  .937072D+00, .799266D+00, .679379D+00, .575301D+00,
     +  .485216D+00, .407381D+00, .340677D+00, .283078D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .233872D+00, .191997D+00, .156535D+00, .126647D+00,
     +  .101606D+00, .807511D-01, .635110D-01, .493704D-01,
     +  .378541D-01, .286605D-01, .212980D-01, .155248D-01,
     +  .110684D-01, .768856D-02, .518050D-02, .336416D-02,
     +  .209217D-02, .122810D-02, .673810D-03, .337283D-03,
     +  .149099D-03, .550365D-04, .153395D-04, .260852D-05,
     +  .143921D-06, .000000D+00, .185942D+06, .222079D+06,
     +  .169304D+06, .129043D+06, .983507D+05, .749422D+05,
     +  .571025D+05, .435013D+05, .331392D+05, .252415D+05,
     +  .192265D+05, .146435D+05, .111540D+05, .849589D+04,
     +  .647255D+04, .493157D+04, .375880D+04, .286569D+04,
     +  .218603D+04, .166843D+04, .127451D+04, .974450D+03,
     +  .745997D+03, .571887D+03, .439226D+03, .338035D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .260877D+03, .201180D+03, .156286D+03, .121890D+03,
     +  .955186D+02, .752369D+02, .596131D+02, .475628D+02,
     +  .381944D+02, .308943D+02, .251835D+02, .206841D+02,
     +  .171198D+02, .142706D+02, .119804D+02, .101185D+02,
     +  .859310D+01, .733109D+01, .627873D+01, .539326D+01,
     +  .464583D+01, .400399D+01, .345702D+01, .298263D+01,
     +  .257402D+01, .221965D+01, .191183D+01, .164413D+01,
     +  .141120D+01, .120856D+01, .103236D+01, .879354D+00,
     +  .746668D+00, .631837D+00, .532662D+00, .447262D+00,
     +  .373838D+00, .311232D+00, .257441D+00, .211719D+00,
     +  .173006D+00, .140388D+00, .113040D+00, .902455D-01,
     +  .713623D-01, .558374D-01, .431760D-01, .329221D-01,
     +  .247849D-01, .183084D-01, .132624D-01, .939353D-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .647988D-02, .433403D-02, .279215D-02, .172174D-02,
     +  .100126D-02, .543780D-03, .269117D-03, .117466D-03,
     +  .427398D-04, .117277D-04, .197042D-05, .110728D-06,
     +  .000000D+00, .391807D+06, .301437D+06, .228613D+06,
     +  .173335D+06, .131402D+06, .995842D+05, .754597D+05,
     +  .571640D+05, .432989D+05, .327888D+05, .248278D+05,
     +  .187961D+05, .142294D+05, .107709D+05, .815363D+04,
     +  .617227D+04, .467338D+04, .353901D+04, .268111D+04,
     +  .203196D+04, .154110D+04, .116968D+04, .888779D+03,
     +  .676164D+03, .515279D+03, .393425D+03, .301179D+03,
     +  .230330D+03, .177441D+03, .137223D+03, .106617D+03,
     +  .832592D+02, .654012D+02, .517342D+02, .411889D+02,
     +  .330351D+02, .267040D+02, .217537D+02, .178608D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .147719D+02, .123068D+02, .103171D+02, .869851D+01,
     +  .736889D+01, .626789D+01, .534803D+01, .457698D+01,
     +  .391950D+01, .336310D+01, .288391D+01, .247400D+01,
     +  .212093D+01, .181632D+01, .155317D+01, .132571D+01,
     +  .112911D+01, .959251D+00, .812678D+00, .686363D+00,
     +  .577718D+00, .484457D+00, .404636D+00, .336411D+00,
     +  .278584D+00, .229194D+00, .187463D+00, .152341D+00,
     +  .122927D+00, .984157D-01, .781125D-01, .613988D-01,
     +  .477468D-01, .366874D-01, .277907D-01, .207802D-01,
     +  .152411D-01, .109582D-01, .770069D-02, .526799D-02,
     +  .349229D-02, .222834D-02, .135993D-02, .781850D-03,
     +  .419283D-03, .204550D-03, .878256D-04, .313381D-04,
     +  .840114D-05, .137768D-05, .782230D-07, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .523691D+06, .401216D+06, .302802D+06, .228451D+06,
     +  .172313D+06, .129923D+06, .979379D+05, .738009D+05,
     +  .556004D+05, .418746D+05, .315314D+05, .237362D+05,
     +  .178658D+05, .134442D+05, .101165D+05, .761152D+04,
     +  .572731D+04, .430965D+04, .324381D+04, .244221D+04,
     +  .183975D+04, .138675D+04, .104630D+04, .790287D+03,
     +  .597829D+03, .453036D+03, .344170D+03, .261136D+03,
     +  .199585D+03, .153114D+03, .118002D+03, .913991D+02,
     +  .712069D+02, .558671D+02, .441169D+02, .350979D+02,
     +  .281454D+02, .227483D+02, .185339D+02, .152135D+02,
     +  .125819D+02, .104724D+02, .876779D+01, .737707D+01,
     +  .623318D+01, .528389D+01, .449350D+01, .382404D+01,
     +  .326129D+01, .277988D+01, .237078D+01, .202076D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .172072D+01, .146321D+01, .124204D+01, .105209D+01,
     +  .888989D+00, .749118D+00, .629311D+00, .526888D+00,
     +  .439493D+00, .365140D+00, .301957D+00, .248719D+00,
     +  .203516D+00, .165550D+00, .133787D+00, .107347D+00,
     +  .854483D-01, .674217D-01, .526758D-01, .407095D-01,
     +  .310811D-01, .233876D-01, .173681D-01, .126470D-01,
     +  .902470D-02, .629179D-02, .426816D-02, .280432D-02,
     +  .177224D-02, .107049D-02, .608531D-03, .322335D-03,
     +  .155111D-03, .655878D-04, .230049D-04, .605462D-05,
     +  .978964D-06, .568151D-07, .000000D+00, .687936D+06,
     +  .524957D+06, .394352D+06, .296120D+06, .222286D+06,
     +  .166788D+06, .125107D+06, .938009D+05, .703076D+05,
     +  .526765D+05, .394558D+05, .295420D+05, .221141D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .165485D+05, .123817D+05, .926199D+04, .692810D+04,
     +  .518186D+04, .387636D+04, .290016D+04, .217075D+04,
     +  .162554D+04, .121828D+04, .913909D+03, .686528D+03,
     +  .516546D+03, .389575D+03, .293374D+03, .222541D+03,
     +  .169425D+03, .129566D+03, .995769D+02, .769718D+02,
     +  .599197D+02, .469484D+02, .370623D+02, .294936D+02,
     +  .236590D+02, .191337D+02, .155925D+02, .128042D+02,
     +  .105838D+02, .880128D+01, .735640D+01, .617556D+01,
     +  .520193D+01, .439647D+01, .371865D+01, .315254D+01,
     +  .267138D+01, .226512D+01, .191974D+01, .162556D+01,
     +  .137466D+01, .116051D+01, .977713D+00, .821716D+00,
     +  .688746D+00, .575530D+00, .479316D+00, .397706D+00,
     +  .328680D+00, .270362D+00, .221509D+00, .180272D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .145841D+00, .117206D+00, .935125D-01, .740080D-01,
     +  .580515D-01, .450812D-01, .346241D-01, .262663D-01,
     +  .196331D-01, .144800D-01, .104681D-01, .741355D-02,
     +  .512756D-02, .344922D-02, .224605D-02, .140583D-02,
     +  .840450D-03, .472396D-03, .247159D-03, .117323D-03,
     +  .488626D-04, .168522D-04, .435720D-05, .695445D-06,
     +  .412640D-07, .000000D+00, .890053D+06, .676605D+06,
     +  .505998D+06, .378234D+06, .282621D+06, .211069D+06,
     +  .157571D+06, .117572D+06, .876938D+05, .653758D+05,
     +  .487200D+05, .362906D+05, .270235D+05, .201144D+05,
     +  .149680D+05, .111346D+05, .828183D+04, .615874D+04,
     +  .458007D+04, .340611D+04, .253385D+04, .188559D+04,
     +  .140415D+04, .104648D+04, .780880D+03, .583538D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .437051D+03, .326772D+03, .246097D+03, .185997D+03,
     +  .141191D+03, .107706D+03, .826336D+02, .638479D+02,
     +  .496533D+02, .389078D+02, .307356D+02, .244776D+02,
     +  .196553D+02, .159062D+02, .129729D+02, .106517D+02,
     +  .879978D+01, .730803D+01, .609638D+01, .510353D+01,
     +  .428726D+01, .360460D+01, .303799D+01, .255941D+01,
     +  .215785D+01, .181858D+01, .153139D+01, .128795D+01,
     +  .108142D+01, .906200D+00, .757560D+00, .631612D+00,
     +  .525007D+00, .434941D+00, .358990D+00, .295123D+00,
     +  .241472D+00, .196787D+00, .159287D+00, .128160D+00,
     +  .102425D+00, .812589D-01, .639401D-01, .498588D-01,
     +  .384848D-01, .293742D-01, .221412D-01, .164394D-01,
     +  .120412D-01, .864218D-02, .607417D-02, .416779D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .278004D-02, .179412D-02, .111218D-02, .658062D-03,
     +  .365725D-03, .189006D-03, .885060D-04, .363095D-04,
     +  .123161D-04, .312950D-05, .493249D-06, .299129D-07,
     +  .000000D+00, .113591D+07, .860326D+06, .640607D+06,
     +  .476754D+06, .354650D+06, .263666D+06, .195934D+06,
     +  .145517D+06, .108023D+06, .801444D+05, .594342D+05,
     +  .440516D+05, .326368D+05, .241677D+05, .178900D+05,
     +  .132373D+05, .979231D+04, .724166D+04, .535498D+04,
     +  .395945D+04, .292816D+04, .216594D+04, .160304D+04,
     +  .118723D+04, .880248D+03, .653499D+03, .486198D+03,
     +  .361026D+03, .270026D+03, .202661D+03, .152755D+03,
     +  .115700D+03, .881313D+02, .676098D+02, .522032D+02,
     +  .406160D+02, .318597D+02, .251972D+02, .200953D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .161534D+02, .130878D+02, .106768D+02, .876452D+01,
     +  .723342D+01, .599718D+01, .499022D+01, .416727D+01,
     +  .348317D+01, .291878D+01, .244497D+01, .204980D+01,
     +  .171796D+01, .143874D+01, .120348D+01, .100507D+01,
     +  .837735D+00, .696620D+00, .577746D+00, .477711D+00,
     +  .393685D+00, .323236D+00, .264334D+00, .215134D+00,
     +  .174392D+00, .140397D+00, .112343D+00, .892861D-01,
     +  .704348D-01, .551034D-01, .427145D-01, .327706D-01,
     +  .248569D-01, .186161D-01, .137296D-01, .998709D-02,
     +  .711601D-02, .496359D-02, .337862D-02, .223465D-02,
     +  .142922D-02, .877461D-03, .513836D-03, .282361D-03,
     +  .144139D-03, .665868D-04, .269110D-04, .897956D-05,
     +  .224313D-05, .349239D-06, .216406D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .143165D+07, .108045D+07, .801120D+06, .593668D+06,
     +  .439709D+06, .325469D+06, .240783D+06, .178017D+06,
     +  .131543D+06, .971396D+05, .716964D+05, .528844D+05,
     +  .389890D+05, .287278D+05, .211579D+05, .155746D+05,
     +  .114608D+05, .843018D+04, .619985D+04, .455865D+04,
     +  .335216D+04, .246522D+04, .181376D+04, .133519D+04,
     +  .983873D+03, .725840D+03, .536570D+03, .395804D+03,
     +  .294084D+03, .219242D+03, .164135D+03, .123472D+03,
     +  .934061D+02, .711661D+02, .545727D+02, .421709D+02,
     +  .328564D+02, .258128D+02, .204512D+02, .163334D+02,
     +  .131497D+02, .106602D+02, .869709D+01, .713430D+01,
     +  .587966D+01, .486358D+01, .403798D+01, .335566D+01,
     +  .279603D+01, .232898D+01, .194175D+01, .161849D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .134809D+01, .112159D+01, .931691D+00, .772463D+00,
     +  .638961D+00, .527148D+00, .433594D+00, .355460D+00,
     +  .290324D+00, .236174D+00, .191198D+00, .154164D+00,
     +  .123442D+00, .982351D-01, .776396D-01, .609006D-01,
     +  .473691D-01, .365019D-01, .278342D-01, .209807D-01,
     +  .156120D-01, .114368D-01, .826174D-02, .584391D-02,
     +  .404528D-02, .273152D-02, .179139D-02, .113543D-02,
     +  .690374D-03, .400109D-03, .217395D-03, .109619D-03,
     +  .499603D-04, .198932D-04, .653119D-05, .160450D-05,
     +  .246846D-06, .156243D-07, .000000D+00, .178358D+07,
     +  .134137D+07, .990490D+06, .730946D+06, .539102D+06,
     +  .397333D+06, .292672D+06, .215429D+06, .158476D+06,
     +  .116498D+06, .855884D+05, .628360D+05, .461056D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .338072D+05, .247764D+05, .181470D+05, .132857D+05,
     +  .972186D+04, .711202D+04, .520121D+04, .380368D+04,
     +  .278162D+04, .203487D+04, .148925D+04, .109088D+04,
     +  .799908D+03, .587684D+03, .430759D+03, .318024D+03,
     +  .235565D+03, .175209D+03, .130939D+03, .984033D+02,
     +  .744813D+02, .567395D+02, .435592D+02, .337185D+02,
     +  .263208D+02, .207220D+02, .164468D+02, .131597D+02,
     +  .106039D+02, .859942D+01, .701258D+01, .574564D+01,
     +  .472530D+01, .390087D+01, .322335D+01, .267082D+01,
     +  .221235D+01, .183441D+01, .152073D+01, .125985D+01,
     +  .104259D+01, .861483D+00, .710493D+00, .584621D+00,
     +  .479797D+00, .392587D+00, .320164D+00, .260129D+00,
     +  .210501D+00, .169511D+00, .135951D+00, .108269D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .856883D-01, .673463D-01, .525268D-01, .406193D-01,
     +  .311148D-01, .235818D-01, .176640D-01, .130591D-01,
     +  .950234D-02, .681667D-02, .478661D-02, .328812D-02,
     +  .220245D-02, .143217D-02, .899569D-03, .541688D-03,
     +  .310695D-03, .166915D-03, .831378D-04, .373847D-04,
     +  .146675D-04, .473915D-05, .114534D-05, .174175D-06,
     +  .112581D-07, .000000D+00, .219801D+07, .164745D+07,
     +  .121162D+07, .890494D+06, .654066D+06, .480052D+06,
     +  .352105D+06, .258062D+06, .189012D+06, .138331D+06,
     +  .101172D+06, .739389D+05, .540011D+05, .394104D+05,
     +  .287446D+05, .209511D+05, .152627D+05, .111123D+05,
     +  .808752D+04, .588374D+04, .427992D+04, .311293D+04,
     +  .226466D+04, .164809D+04, .120032D+04, .875000D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .639034D+03, .465533D+03, .341594D+03, .251459D+03,
     +  .185861D+03, .138027D+03, .103073D+03, .775243D+02,
     +  .586851D+02, .447707D+02, .344408D+02, .267195D+02,
     +  .209081D+02, .164949D+02, .131200D+02, .105098D+02,
     +  .847368D+01, .687033D+01, .559702D+01, .457704D+01,
     +  .375739D+01, .308748D+01, .254418D+01, .209590D+01,
     +  .172845D+01, .142519D+01, .117440D+01, .966732D+00,
     +  .794592D+00, .651891D+00, .533600D+00, .435643D+00,
     +  .354603D+00, .287680D+00, .232517D+00, .187169D+00,
     +  .149924D+00, .119601D+00, .947329D-01, .745634D-01,
     +  .582757D-01, .451937D-01, .347456D-01, .264572D-01,
     +  .199294D-01, .148343D-01, .108961D-01, .787489D-02,
     +  .560986D-02, .391041D-02, .266567D-02, .177115D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .114193D-02, .710785D-03, .423873D-03, .240606D-03,
     +  .127809D-03, .628838D-04, .279007D-04, .107872D-04,
     +  .343084D-05, .815938D-06, .122694D-06, .809612D-08,
     +  .000000D+00, .268116D+07, .200295D+07, .146726D+07,
     +  .107409D+07, .785737D+06, .574337D+06, .419516D+06,
     +  .306179D+06, .223299D+06, .162720D+06, .118488D+06,
     +  .862089D+05, .626780D+05, .455333D+05, .330557D+05,
     +  .239792D+05, .173845D+05, .125952D+05, .912103D+04,
     +  .660198D+04, .477757D+04, .345661D+04, .250123D+04,
     +  .181032D+04, .131115D+04, .950384D+03, .690105D+03,
     +  .499769D+03, .364553D+03, .266760D+03, .195983D+03,
     +  .144664D+03, .107373D+03, .802695D+02, .603951D+02,
     +  .457980D+02, .350207D+02, .270088D+02, .210108D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .164799D+02, .130329D+02, .103807D+02, .832228D+01,
     +  .670975D+01, .543573D+01, .442050D+01, .360896D+01,
     +  .294923D+01, .241708D+01, .198041D+01, .162444D+01,
     +  .133229D+01, .109204D+01, .894199D+00, .731123D+00,
     +  .596690D+00, .485873D+00, .394616D+00, .319539D+00,
     +  .257885D+00, .207346D+00, .166032D+00, .132288D+00,
     +  .104970D+00, .826925D-01, .647283D-01, .503061D-01,
     +  .387908D-01, .296493D-01, .224419D-01, .168013D-01,
     +  .124271D-01, .906863D-02, .650973D-02, .460498D-02,
     +  .318640D-02, .215546D-02, .142060D-02, .908113D-03,
     +  .560132D-03, .330800D-03, .185831D-03, .976042D-04,
     +  .474388D-04, .207691D-04, .791394D-05, .247813D-05,
     +  .580147D-06, .862900D-07, .581116D-08, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
