/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _absimg_h_
#define _absimg_h_

#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#ifdef HAVE_IMLIB1
#include <Imlib.h>

typedef struct {
	int		rgb_width;
	int		rgb_height;

	char		*filename;
	ImlibImage	*image;
} absimg_image_t;
#endif

#ifdef HAVE_GDKIMLIB1
#include <gdk_imlib.h>

typedef struct {
	int		rgb_width;
	int		rgb_height;

	char		*filename;
	GdkImlibImage	*image;
} absimg_image_t;
#endif

#if defined HAVE_GDKPIXBUF || defined HAVE_GDKPIXBUF2
#include <gdk-pixbuf/gdk-pixbuf.h>

typedef struct {
	int		rgb_width;
	int		rgb_height;

	char		*filename;
	GdkPixbuf 	*image;
} absimg_image_t;
#endif

#ifdef HAVE_IMLIB2
#include <Imlib2.h>

typedef struct {
	int		rgb_width;
	int		rgb_height;

	char		*filename;
	Imlib_Image	image;
} absimg_image_t;
#endif


extern void absimg_init();
extern absimg_image_t *absimg_load(char *);
extern absimg_image_t * absimg_scale(absimg_image_t *, int, int);
extern absimg_image_t * absimg_from_pixmap(GdkPixmap *);
extern void absimg_flip_vertical(absimg_image_t *);
extern void absimg_flip_horizontal(absimg_image_t *);
extern GdkPixmap *absimg_render(absimg_image_t *, int, int);
extern void absimg_destroy(absimg_image_t *);
extern void absimg_destroy_pixmap(GdkPixmap *);
extern int absimg_have_alpha(absimg_image_t *);
extern void absimg_render_alpha_to_pixmap(GdkPixmap *, absimg_image_t *, int, int);

#define absimg_filename(image) (image->filename)

typedef struct {
	unsigned char	*rgb;
	unsigned char	*alpha;
	int		width;
	int		height;
} absimg_rgb_t;

#define ABSIMG_ALPHA(fg, bg, alpha) \
        bg = (unsigned char) (((int)fg * (int)alpha + (int)bg * (255 - (int)alpha)) >> 8);

extern absimg_rgb_t *absimg_rgb_new(int, int);
extern absimg_rgb_t *absimg_to_rgb(absimg_image_t *);
extern absimg_rgb_t *absimg_to_rgba(absimg_image_t *);
extern absimg_rgb_t *absimg_dup(absimg_rgb_t *);
extern void absimg_rgb_fill(absimg_rgb_t *, guchar, guchar, guchar);
extern int absimg_rgb_savePNG(absimg_rgb_t *, char *);
extern void absimg_render_to_rgb(absimg_rgb_t *, absimg_image_t *, int, int, gfloat, gfloat);
extern void absimg_rgb_tile(absimg_rgb_t *, absimg_image_t *, int, int);
extern void absimg_rgb_grayfy(absimg_rgb_t *);

#define absimg_rgb_free(rgbs) \
	if (rgbs) {g_free(rgbs->rgb); g_free(rgbs->alpha); g_free(rgbs); rgbs = NULL;}

#endif

