/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <glib.h>
#include <gdk/gdkx.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "config.h"

#ifdef HAVE_ENLIGHTENMENT_SUPPORT
#include <X11/X.h>
#include <X11/Xatom.h>
static Window find_named_tl_window(char *win_name)
{
	Window root,parent,*chld;
	Window win = None;
	int num;
	int i;
	char *name;
	Status s;

	XQueryTree(GDK_DISPLAY() , GDK_WINDOW_XWINDOW(GDK_ROOT_PARENT()) , 
		&root , &parent , &chld , &num);

	for (i = 0 ; i < num ; i++)
	{
		s = XFetchName(GDK_DISPLAY() ,chld[i] , &name);

		if (s)
		{
			if (!strcmp(win_name , name))
			{
				win = chld[i];
				XFree(name);
				break;
			}
			XFree(name);
		}
	}
	if (chld) XFree(chld);

	return win;
}

static char *get_string_atom(Display *dpy, Window win, Atom atom)
{
	int result;
	Atom actual_type;
	int actual_format;
	unsigned long nitems, bytes_after;
	unsigned char *data = 0;

	result = XGetWindowProperty(dpy, win, atom,
		0, (65536 / sizeof (long)), False,
		XA_STRING,
		&actual_type, &actual_format,
		&nitems, &bytes_after,
		&data);

	if ((result == Success) && data && data[0])
	{
		return g_strdup(data);
	}
	return NULL;
}

/* Returns true if running under E, false otherwise */
unsigned char
check_for_enlightenment(void)
{
	static Atom XA_ENLIGHTENMENT_COMMS = None;
	static Atom XA_WIN_WM_VERSION = None;
	static signed char have_e = -1;
	Display *dpy = GDK_DISPLAY();
	Window win = GDK_ROOT_WINDOW();

	if (!XA_ENLIGHTENMENT_COMMS)
		XA_ENLIGHTENMENT_COMMS = XInternAtom (dpy, "ENLIGHTENMENT_COMMS", False);
	if (!XA_WIN_WM_VERSION)
		XA_WIN_WM_VERSION = XInternAtom (dpy, "_WIN_WM_VERSION", False);

	if (have_e == -1)
	{
		char *p;

		have_e = FALSE;

		if ((p = get_string_atom(dpy, win, XA_ENLIGHTENMENT_COMMS)))
		{
			g_free(p);

			if ((p = get_string_atom(dpy, win, XA_WIN_WM_VERSION)))
			{
				int major,minor,micro;

				if (sscanf(p, "%d.%d.%d", &major, &minor, &micro) == 3)
				{
					if ((major > 0) ||
					    ((major == 0) && (minor >= 16)))
					{
						if (find_named_tl_window("Enlightenment") && check_program("eesh"))
						{
							have_e = TRUE;
						}
					}
				}
				g_free(p);
			}
		}
	}

	return have_e;
}
#else /* HAVE_ENLIGHTENMENT_SUPPORT */

unsigned char
check_for_enlightenment(void)
{
	return FALSE;
}

#endif /* HAVE_ENLIGHTENMENT_SUPPORT */

