/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <gtk/gtk.h>
#include "gprop.h"

static GtkWidget *extop_label[CHBG_EXTERNOPENER];
static GtkWidget *extop_cmd[CHBG_EXTERNOPENER];
static GtkWidget *slideint;
static GtkWidget *sho_width;
static GtkWidget *sho_height;
static GtkWidget *sh_per_page;
static GtkWidget *view_type[2];
static GtkWidget *drag_type[2];
static GtkWidget *confirm_rm;

static void SetingsApply()
{
	int i;

	for (i = 0; i < CHBG_EXTERNOPENER; i++)
	{
		char pom[50];
		char *cmd, *label;

		cmd = gtk_entry_get_text(GTK_ENTRY(extop_cmd[i]));
		sprintf(pom , "option-extop%02d-cmd", i);
		if (cmd && *cmd)
			gprop_set_str(pom, cmd);
		else
			gprop_remove(pom);

		label = gtk_entry_get_text(GTK_ENTRY(extop_label[i]));
		sprintf(pom , "option-extop%02d-label", i);
		if (label && *label)
			gprop_set_str(pom, label);
		else
			gprop_remove(pom);
	}

	gprop_set_int("view-slide-interval",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(slideint)));

	gprop_set_int("shader_open_width",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sho_width)));

	gprop_set_int("shader_open_height",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sho_height)));

	gprop_set_int("shaders_per_page",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sh_per_page)));

	gprop_set_int("view_window_type", GTK_TOGGLE_BUTTON(view_type[1])->active);
	gprop_set_int("view_drag_type", GTK_TOGGLE_BUTTON(drag_type[1])->active);

	gprop_set_bool("confirm_remove", GTK_TOGGLE_BUTTON(confirm_rm)->active);
}

static void SettingsScrollTypeSens(w, frame)
GtkWidget *w;
GtkWidget *frame;
{
	gtk_widget_set_sensitive(frame, GTK_TOGGLE_BUTTON(w)->active);
}

static void SetingsBuildMain(notebook)
GtkWidget *notebook;
{
	GtkWidget *label, *row, *frame, *box;
	GtkAdjustment *adj;
	int iv;

	row = gtk_table_new(3, 6, FALSE);
	gtk_widget_show(row);
	label = gtk_label_new(gettext("Main"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), row, label);

	label = gtk_label_new(gettext("Slideshow interval: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	if (!gprop_get_int("view-slide-interval", &iv))
		iv = 10;
	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) iv, 
                        0.0, 1000000.0, 1.0, 10.0, 0.0);
	slideint = gtk_spin_button_new(adj , 0 , 0);
	SET_TOOLTIP(slideint, gettext("In picture preview you can activate automatic slideshows, this value is used to determine period for picture changes."));
	gtk_widget_set_usize(slideint , 
		gdk_string_width(slideint->style->font , "wwwwwwwww") , -1);
	gtk_table_attach(GTK_TABLE(row), slideint, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(slideint);

	label = gtk_label_new(gettext(" sec."));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Shader open width: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	if (!gprop_get_int("shader_open_width", &iv))
		iv = 320;
	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) iv, 
                        1.0, 32768.0, 1.0, 10.0, 0.0);
	sho_width = gtk_spin_button_new(adj , 0 , 0);
	SET_TOOLTIP(sho_width, gettext("From shader preview dialog, you can create pictures in PNG format and thus way export it to external image processing programs. This value specifies the width of shaded picture which will be passed to external program."));
	gtk_widget_set_usize(sho_width, 
		gdk_string_width(sho_width->style->font , "wwwwwwwww") , -1);
	gtk_table_attach(GTK_TABLE(row), sho_width, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(sho_width);

	label = gtk_label_new(gettext(" pixels"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Shader open height: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	if (!gprop_get_int("shader_open_height", &iv))
		iv = 320;
	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) iv, 
                        1.0, 32768.0, 1.0, 10.0, 0.0);
	sho_height = gtk_spin_button_new(adj , 0 , 0);
	SET_TOOLTIP(sho_height, gettext("From shader preview dialog, you can create pictures in PNG format and thus way export it to external image processing programs. This value specifies the height of shaded picture which will be passed to external program."));
	gtk_widget_set_usize(sho_height, 
		gdk_string_width(sho_height->style->font , "wwwwwwwww") , -1);
	gtk_table_attach(GTK_TABLE(row), sho_height, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(sho_height);

	label = gtk_label_new(gettext(" pixels"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Shaders per page: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	if (!gprop_get_int("shaders_per_page", &iv))
		iv = 100;

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) iv, 
                        1.0, shader_get_cnt()-1, 1.0, 10.0, 0.0);
	sh_per_page = gtk_spin_button_new(adj , 0 , 0);
	SET_TOOLTIP(sh_per_page, gettext("Currently chbg have many shading effects. It takes horrible ammount of time to render such amount of pictures, so it is clever to let it render per pages. This value allows you to specify how many shaders will be on one page."));
	gtk_widget_set_usize(sh_per_page, 
		gdk_string_width(sh_per_page->style->font , "wwwwwwwww") , -1);
	gtk_table_attach(GTK_TABLE(row), sh_per_page, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(sh_per_page);


	if (!gprop_get_bool("confirm_remove", &iv))
		iv = TRUE;

	confirm_rm = gtk_check_button_new_with_label(gettext("Confirm picture remove"));
	SET_TOOLTIP(confirm_rm, gettext("In thumbnail preview dialogs you can select multiple pictures for removing. At default chbg shows dialog to confirm removing of each picture. With this option you can turn on/off displaying of that dialog. When picture removing dialog is disallowed, all selected pictures will be removed without any question !"));
	gtk_table_attach(GTK_TABLE(row), confirm_rm, 0, 3, 4, 5, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(confirm_rm);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(confirm_rm), iv);


	frame = gtk_frame_new(gettext("Picture preview window type"));
	gtk_table_attach(GTK_TABLE(row), frame, 0, 3, 5, 6, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(frame);

	box = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(frame), box);
	gtk_widget_show(box);

	if (!gprop_get_int("view_window_type", &iv))
		iv = 0;

	view_type[0] = gtk_radio_button_new_with_label(NULL, gettext("Raw - fullsize window"));
	SET_TOOLTIP(view_type[0], gettext("With this option you can contol what type of picture preview dialog you will see. When you will select this option, chbg will display picture always in window with same size as have picture. This is not good idea when picture is too big to fit to screen size, but is ideal for normal size pictures."));
	gtk_box_pack_start(GTK_BOX(box), view_type[0], FALSE, FALSE, 1);
	gtk_widget_show(view_type[0]);
	if (iv == 0)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(view_type[0]), TRUE);

	view_type[1] = gtk_radio_button_new_with_label(
		gtk_radio_button_group(GTK_RADIO_BUTTON(view_type[0])),
		gettext("Scrolled window"));
	SET_TOOLTIP(view_type[1], gettext("With this option you can contol what type of picture preview dialog you will see. When you will select this option, chbg will display picture in window inside which you can scroll picture by draging mouse, when picture is bigger than current size of window. Size of this dialog always attempt to fit to screen size."));
	gtk_box_pack_start(GTK_BOX(box), view_type[1], FALSE, FALSE, 1);
	gtk_widget_show(view_type[1]);
	if (iv == 1)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(view_type[1]), TRUE);

	frame = gtk_frame_new(gettext("Picture scrolling type"));
	gtk_table_attach(GTK_TABLE(row), frame, 0, 3, 6, 7, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(frame);

	box = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(frame), box);
	gtk_widget_show(box);

	if (!gprop_get_int("view_drag_type", &iv))
		iv = 0;

	drag_type[0] = gtk_radio_button_new_with_label(NULL, gettext("Smooth drag"));
	SET_TOOLTIP(drag_type[0], gettext("If you have selected above \"Scrolled window\" preview window type. With this options you can control when will be picture redisplayed when draging it. If you will select this option, the preview window will be redrawed immediatly when you move your mouse. I suggest to use it only when you have fast enough computer."));
	gtk_box_pack_start(GTK_BOX(box), drag_type[0], FALSE, FALSE, 1);
	gtk_widget_show(drag_type[0]);
	if (iv == 0)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(drag_type[0]), TRUE);

	drag_type[1] = gtk_radio_button_new_with_label(
		gtk_radio_button_group(GTK_RADIO_BUTTON(drag_type[0])),
		gettext("Jumping drag"));
	SET_TOOLTIP(drag_type[1], gettext("If you have selected above \"Scrolled window\" preview window type. With this options you can control when will be picture redisplayed when draging it. If you will select this option, the preview window will be redrawed just when you will finish the mouse drag. I suggest to use it only when you have slower computer."));
	gtk_box_pack_start(GTK_BOX(box), drag_type[1], FALSE, FALSE, 1);
	gtk_widget_show(drag_type[1]);
	if (iv == 1)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(drag_type[1]), TRUE);


	gtk_widget_set_sensitive(frame, GTK_TOGGLE_BUTTON(view_type[1])->active);
	gtk_signal_connect(GTK_OBJECT(view_type[1]), "toggled",
		GTK_SIGNAL_FUNC(SettingsScrollTypeSens), frame);
}

static void SetingsBuildExtern(notebook)
GtkWidget *notebook;
{
	GtkWidget *label, *box;
	int i;

	box = gtk_table_new(CHBG_EXTERNOPENER + 1, 3, FALSE);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("External editors"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	label = gtk_label_new(gettext("No."));
	gtk_table_attach(GTK_TABLE(box), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Label"));
	gtk_table_attach(GTK_TABLE(box), label,  1, 2, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Command"));
	gtk_table_attach(GTK_TABLE(box), label,  2, 3, 0, 1, GTK_FILL, GTK_FILL, 1, 1);
	gtk_widget_show(label);

	for (i = 0; i < CHBG_EXTERNOPENER; i++)
	{
		char pom[50];
		char *p;

		sprintf(pom, "%d", i+1);
		label = gtk_label_new(pom);
		gtk_table_attach(GTK_TABLE(box), label, 0, 1, i+1, i+2, GTK_FILL, GTK_FILL, 1, 1);
		gtk_widget_show(label);

		sprintf(pom , "option-extop%02d-label", i);
		if (!gprop_get_str(pom, &p))
			p = NULL;
		extop_label[i] = gtk_entry_new();
		if (p) gtk_entry_set_text(GTK_ENTRY(extop_label[i]), p);
		gtk_table_attach(GTK_TABLE(box), extop_label[i], 1, 2, i+1, i+2, GTK_FILL, GTK_FILL, 1, 1);
		gtk_widget_show(extop_label[i]);

		sprintf(pom , "option-extop%02d-cmd", i);
		if (!gprop_get_str(pom, &p))
			p = NULL;
		extop_cmd[i] = gtk_entry_new();
		if (p) gtk_entry_set_text(GTK_ENTRY(extop_cmd[i]), p);
		gtk_table_attach(GTK_TABLE(box), extop_cmd[i], 2, 3, i+1, i+2, GTK_FILL, GTK_FILL, 1, 1);
		gtk_widget_show(extop_cmd[i]);
	}
}

void SetingsDo()
{
	static GtkWidget *tl = NULL;

	if (!tl)
	{
		GtkWidget *col, *bbox, *button, *notebook;

		tl = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(tl), gettext("ChBg: Options"));
		gtk_container_border_width(GTK_CONTAINER(tl), 4);
		gtk_signal_connect(GTK_OBJECT(tl), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &tl);

		col = gtk_vbox_new(FALSE, 3);
		gtk_container_add(GTK_CONTAINER(tl), col);
		gtk_widget_show(col);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(col), notebook, TRUE, TRUE, 0);
		gtk_widget_show(notebook);

		SetingsBuildMain(notebook);
		SetingsBuildExtern(notebook);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox) , GTK_BUTTONBOX_SPREAD);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 2);
		gtk_box_pack_end(GTK_BOX(col), bbox, FALSE, FALSE, 0);
		gtk_widget_show(bbox);

		button = gtk_button_new_with_label(gettext("Ok"));
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_container_add(GTK_CONTAINER(bbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(SetingsApply), NULL);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(KillWin), tl);

		button = gtk_button_new_with_label(gettext("Cancel"));
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_container_add(GTK_CONTAINER(bbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(KillWin), tl);
	}

	gtk_widget_show(tl);
	if (GTK_WIDGET_REALIZED(tl))
		gdk_window_raise(tl->window);
}

