/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "absimg.h"
#include <gdk/gdkx.h>
#include "gaccel.h"
#include "gprop.h"
#include "gimpgradient.h"
#include "gtkclrbutton.h"
#include "gtkbgpixmap.h"

#include "pixmaps/chbg_logo.xpm"
#include "pixmaps/stock_open.xpm"
#include "pixmaps/stock_save_as.xpm"
#include "pixmaps/stock_exit.xpm"
#include "pixmaps/stock_exec.xpm"
#include "pixmaps/stock_exec_term.xpm"
#include "pixmaps/stock_apply.xpm"
#include "pixmaps/stock_append.xpm"
#include "pixmaps/stock_stop.xpm"
#include "pixmaps/stock_close.xpm"
#include "pixmaps/stock_restart.xpm"
#include "pixmaps/stock_clear.xpm"
#include "pixmaps/stock_delete.xpm"
#include "pixmaps/stock_choose.xpm"

GtkWidget *toplevel_window = NULL;
GtkWidget *picture_list;
GtkTooltips *chbg_tooltips;

typedef struct {
	GtkWidget *max_size;
	GtkWidget *max_grow;
	GtkWidget *xpos;
	GtkWidget *ypos;
	GtkWidget *mode;
	banner_prop_t *prop;
} banner_prop_dlg_info_t;

typedef struct {
	GtkWidget *notebook;
	int ismain;
	prop_t *prop;
	GtkWidget *interval_m;
	GtkWidget *interval_s;
	GtkWidget *max_grow;
	GtkWidget *max_size;
	GtkWidget *type[10];
	GtkWidget *background;
	GtkWidget *background2;
	GtkWidget *efect;
	GtkWidget *shader;
	GtkWidget *tiles;
	GtkWidget *grad;
	GtkWidget *rand_colors;
	GtkWidget *smart_frame;
	GtkWidget *use_grad;
	GtkWidget *interval_end_m;
	GtkWidget *interval_end_s;
	GtkWidget *clr_sens[5];
	GtkWidget *xpos;
	GtkWidget *ypos;
	GtkWidget *use_banner;
	GtkWidget *banners;
	banner_prop_dlg_info_t banner_prop;
} prop_dlg_info_t;

static prop_dlg_info_t pic_propinfo;
static prop_dlg_info_t main_propinfo;
static banner_prop_dlg_info_t perbanner_props;

static GtkWidget *box_size;
static GtkWidget *fract_iter;
static GtkWidget *min_psize;
static GtkWidget *d_efect;
static GtkWidget *d_shader;
static GtkWidget *speed;
static GtkWidget *recurse;
static GtkWidget *prop_pname;
static GtkWidget *prop_have;
static GtkWidget *randomized;
static GtkWidget *blank;
static GtkWidget *screensaver;
#ifdef HAVE_XSS_SUPPORT
static GtkWidget *xscreensaver;
#endif
#ifdef HAVE_ENLIGHTENMENT_SUPPORT
static GtkWidget *enlightenment;
#endif
static GtkAccelGroup *menu_accel_group;
static GtkWidget *inwindow;
static GtkWidget *infwindow;
static GtkWidget *patternw;
static GtkWidget *cycle_blank;
static GtkWidget *stop_button,*stop_mi;
static GtkWidget *run_button,*run_mi;
static GtkWidget *progres;
static GtkWidget *status,*status_effect,*status_shader,
		 *status_image,*status_grad,
		 *status_tile,*status_banner;
static GtkWidget *enable_tooltips;
static GtkWidget *remember_last;
static GtkWidget *sort_pics;
static GtkWidget *tofile;
static GtkWidget *outfile;
static GtkWidget *outfile_width;
static GtkWidget *outfile_height;
static GtkWidget *fake_nautilus;
static GtkWidget *windowid;
static GtkWidget *send_expose;

#define LASTSCN_NUM 10
static GSList *lastscn=NULL;
static GtkWidget *lastscn_menu;

char *combo_patterns[] = {
	"",
	"*.gif",
	"*.png",
	"*.jpg *.jpeg",
	"*.tif *.tiff",
	"*.bmp",
	"*.gif *.jpg *.png *.jpeg *.tif *.tiff *.bmp",
	NULL,
};

char *effect_texts[] = {
	gettext_nop("0) None") ,
	gettext_nop("1) Random") ,
	gettext_nop("2) C-Left, C-Right") ,
	gettext_nop("3) C-Top, C-Bottom") ,
	gettext_nop("4) Left-C, Right-C") ,
	gettext_nop("5) Top-C, Bottom-C") ,
	gettext_nop("6) Top-Bottom") ,
	gettext_nop("7) Left-Right") ,
	gettext_nop("8) Expanding Box-Full Screen") ,
	gettext_nop("9) Full Screen-Tiny Box") ,
	gettext_nop("10) Line Mesh Left-Right") ,
	gettext_nop("11) Line Fill Fade In Top-Bottom") ,
	gettext_nop("12) Boxed Mesh Fade In TopL-BottomR") ,
	gettext_nop("13) TopL-BottomR") ,
	gettext_nop("14) All 4 Corners-Center") ,
	gettext_nop("15) All 4 Corners Scissor Cut-Center") ,
	gettext_nop("16) Rectangular Border Fill In-Center") ,
	gettext_nop("17) Center-Rectangular Border Fill In") ,
	gettext_nop("18) Boxed Mesh Fill Out") ,
	gettext_nop("19) Diagonal Scissor Cut Fill In") ,
	gettext_nop("20) Zigzag Diagonal Scissor Cut Fill In") ,
	gettext_nop("21) R-C, L-C Center Line Fill In") ,
	gettext_nop("22) T-C, B-C Line Fill In") ,
	gettext_nop("23) Pixel Fill In") ,
	gettext_nop("24) Line Draw Top-Bottom") ,
	gettext_nop("25) Line Draw Left-Right") ,
	gettext_nop("26) Line Mesh Fade In Side-C, C-Side") ,
	gettext_nop("27) Line Mesh Fade In Top&B-C, C-Top&B") ,
	gettext_nop("28) Wiggly Squiggly Left-Right") ,
	gettext_nop("29) Wiggy Jiggy Outer-Inner") ,
};

struct {char *label; int speed;} speed_table[] = {
	{gettext_nop("Super fast"), 0},
	{gettext_nop("Very fast"), 10},
	{gettext_nop("Fast"), 100},
	{gettext_nop("Medium"), 500},
	{gettext_nop("Slow"), 1000},
	{gettext_nop("Very slow"), 5000},
	{gettext_nop("Super slow"), 15000},
};

guint run = FALSE;
guint restart_loop = FALSE;

static void build_propt();
static void update_prop_tiles_combo();
static void update_prop_banners_combo();

extern gboolean have_setup;
extern char *cfg_get_color_str();
extern void run_changing_process();

static GtkTargetEntry dragtypes[] = {
	{"STRING",		0,	0},
	{"text/plain",		0,	0}
};

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

static void set_title()
{
	char pom[1024];

	if (cfg.scenario)
		sprintf(pom, gettext("ChBg setup [%s]"),
				g_basename(cfg.scenario));
	else
		strcpy(pom, gettext("ChBg setup"));

	gtk_window_set_title(GTK_WINDOW(toplevel_window), pom);
}

static void get_banner_propcfg(prop, propinfo)
banner_prop_t *prop;
banner_prop_dlg_info_t *propinfo;
{
	prop->max_size = gtk_spin_button_get_value_as_int(
		GTK_SPIN_BUTTON(propinfo->max_size));
	prop->max_grow = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->max_grow));

	prop->xpos = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->xpos));

	prop->ypos = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->ypos));

	prop->mode = GTK_OPTION_MENU(propinfo->mode)->menu_item ?
		(gint)gtk_object_get_user_data(GTK_OBJECT(
			GTK_OPTION_MENU(propinfo->mode)->menu_item)) : 0;
}

static void get_propcfg(prop, propinfo)
prop_t *prop;
prop_dlg_info_t *propinfo;
{
	int i;

	prop->interval = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->interval_m));
	prop->interval += gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->interval_s))/59.0;

	prop->interval_end = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->interval_end_m));
	prop->interval_end += gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->interval_end_s))/59.0;

	prop->max_size = gtk_spin_button_get_value_as_int(
		GTK_SPIN_BUTTON(propinfo->max_size));
	prop->max_grow = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->max_grow));

	prop->xpos = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->xpos));

	prop->ypos = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(propinfo->ypos));

	prop->efect = GTK_CLIST(propinfo->efect)->selection ?
		(guint) gtk_clist_get_row_data(GTK_CLIST(propinfo->efect),
			(guint)(GTK_CLIST(propinfo->efect)->selection->data))
		: 0;

	prop->shade = GTK_CLIST(propinfo->shader)->selection ?
		(guint) gtk_clist_get_row_data(GTK_CLIST(propinfo->shader),
			(guint)(GTK_CLIST(propinfo->shader)->selection->data))
		: 0;

	if (cfg.grads)
	{
		prop->gradnr = GTK_CLIST(propinfo->grad)->selection ?
			(guint)(GTK_CLIST(propinfo->grad)->selection->data) : 0;

		prop->use_grad = GTK_OPTION_MENU(propinfo->use_grad)->menu_item?
			((gint)gtk_object_get_user_data(GTK_OBJECT(
				GTK_OPTION_MENU(propinfo->use_grad)->menu_item))
			 == SHADE_GRADIENTS)
			: 0;
	}

	if (cfg.tiles)
	{
		prop->use_tiles = GTK_OPTION_MENU(propinfo->use_grad)->menu_item?
                        ((gint)gtk_object_get_user_data(GTK_OBJECT(
                                GTK_OPTION_MENU(propinfo->use_grad)->menu_item))
			 == SHADE_TILES)
                        : 0;
	}

	g_free(prop->tile);
	prop->tile = NULL;
	if (propinfo->ismain)
	{
		GList *ptr;
		int row;

		if (GTK_CLIST(propinfo->tiles)->selection)
		{
			row = (guint)
				(GTK_CLIST(propinfo->tiles)->selection->data);
			gtk_clist_get_text(GTK_CLIST(propinfo->tiles), row, 0,
				&prop->tile);
			prop->tile = g_strdup(prop->tile);
		}

		for (ptr = cfg.tiles; ptr; ptr = g_list_remove_link(ptr, ptr))
			g_free(ptr->data);
		cfg.tiles = NULL;

		for (row = 1; row < GTK_CLIST(propinfo->tiles)->rows; row++)
		{
			char *p;

			gtk_clist_get_text(GTK_CLIST(propinfo->tiles),
				row, 0, &p);

			cfg.tiles = g_list_append(cfg.tiles, g_strdup(p));
		}
	}
	else
	{
		char *p;
		p = gtk_entry_get_text(
			GTK_ENTRY(GTK_COMBO(propinfo->tiles)->entry));

		if (p && *p)
			prop->tile = g_strdup(p);
	}

	prop->rand_colors = GTK_TOGGLE_BUTTON(propinfo->rand_colors)->active;

	gtk_color_button_get_color(GTK_COLOR_BUTTON(propinfo->background),
		&prop->background);
	gtk_color_button_get_color(GTK_COLOR_BUTTON(propinfo->background2),
		&prop->background2);

	prop->use_banners = GTK_TOGGLE_BUTTON(propinfo->use_banner)->active;

	g_free(prop->banner);
	prop->banner = NULL;
	if (propinfo->ismain)
	{
		GList *ptr;
		int row;

		if (GTK_CLIST(propinfo->banners)->selection)
		{
			row = (guint)
				(GTK_CLIST(propinfo->banners)->selection->data);
			gtk_clist_get_text(GTK_CLIST(propinfo->banners), row, 0,
				&prop->banner);
			prop->banner = g_strdup(prop->banner);
		}

		for (ptr = cfg.banners; ptr; ptr = g_list_remove_link(ptr, ptr))
			banner_free(ptr->data);
		cfg.banners = NULL;

		for (row = 1; row < GTK_CLIST(propinfo->banners)->rows; row++)
		{
			char *p;
			banner_t *bn;

			gtk_clist_get_text(GTK_CLIST(propinfo->banners),
				row, 0, &p);

			bn = banner_new(g_strdup(p));

			bn->prop = gtk_clist_get_row_data(
				GTK_CLIST(propinfo->banners), row);

			if (bn->prop)
				bn->prop = banner_prop_dup(bn->prop);

			cfg.banners = g_list_append(cfg.banners, bn);
		}

		get_banner_propcfg(&prop->banner_prop, &propinfo->banner_prop);
	}
	else
	{
		char *p;
		p = gtk_entry_get_text(
			GTK_ENTRY(GTK_COMBO(propinfo->banners)->entry));

		if (p && *p)
			prop->banner = g_strdup(p);
	}

	for (i = 0; i < 10 ; i++)
		if (GTK_TOGGLE_BUTTON(propinfo->type[i])->active)
			prop->type = i;
}

static void get_cfg()
{
	char *p;
	int l;
	guint row;
	prop_t *pprop;
	GList *ptr;

	get_propcfg(&cfg.properties, &main_propinfo);

	g_slist_free(cfg.d_effects);
	cfg.d_effects = NULL;
	for (ptr = GTK_LIST(d_efect)->children ; ptr ; ptr = ptr->next)
	{
		if (!GTK_TOGGLE_BUTTON(GTK_BIN(ptr->data)->child)->active)
			cfg.d_effects = g_slist_append(cfg.d_effects,
				gtk_object_get_user_data(GTK_OBJECT(ptr->data)));
	}

	g_slist_free(cfg.d_shaders);
	cfg.d_shaders = NULL;
	for (ptr = GTK_LIST(d_shader)->children ; ptr ; ptr = ptr->next)
	{
		if (!GTK_TOGGLE_BUTTON(GTK_BIN(ptr->data)->child)->active)
			cfg.d_shaders = g_slist_append(cfg.d_shaders,
				gtk_object_get_user_data(GTK_OBJECT(ptr->data)));
	}

	cfg.speed = (gfloat) ((gint) (GTK_OPTION_MENU(speed)->menu_item ?
                (gint) gtk_object_get_user_data(
			GTK_OBJECT(GTK_OPTION_MENU(speed)->menu_item)) : 100));

	cfg.min_size = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(min_psize));

	cfg.fract_iter = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(fract_iter));
	cfg.box_size = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(box_size));

	cfg.randomize = GTK_TOGGLE_BUTTON(randomized)->active;
	cfg.blank = GTK_TOGGLE_BUTTON(blank)->active;
	cfg.screensaver = GTK_TOGGLE_BUTTON(screensaver)->active;
#ifdef HAVE_XSS_SUPPORT
	cfg.xscreensaver = GTK_TOGGLE_BUTTON(xscreensaver)->active;
	cfg.send_expose = GTK_TOGGLE_BUTTON(send_expose)->active;
#endif
#ifdef HAVE_ENLIGHTENMENT_SUPPORT
	cfg.use_ebg = GTK_TOGGLE_BUTTON(enlightenment)->active;
#endif
	cfg.recurse = GTK_TOGGLE_BUTTON(recurse)->active;
	cfg.sort = GTK_TOGGLE_BUTTON(sort_pics)->active;
	cfg.inwindow = GTK_TOGGLE_BUTTON(inwindow)->active;
	cfg.infwindow = GTK_TOGGLE_BUTTON(infwindow)->active;
	cfg.tofile = GTK_TOGGLE_BUTTON(tofile)->active;
	cfg.cycle_blank = GTK_TOGGLE_BUTTON(cycle_blank)->active;
	cfg.remember_last = GTK_TOGGLE_BUTTON(remember_last)->active;
	cfg.tooltips = GTK_CHECK_MENU_ITEM(enable_tooltips)->active;
	cfg.fake_nautilus = GTK_TOGGLE_BUTTON(fake_nautilus)->active;

	cfg.windowid = strtol(gtk_entry_get_text(GTK_ENTRY(windowid)), NULL, 0);

	g_free(cfg.outfile);
	p = gtk_entry_get_text(GTK_ENTRY(outfile));
	if (p && p[0])
		cfg.outfile = g_strdup(p);
	else
		cfg.outfile = NULL;

	cfg.outfile_width = gtk_spin_button_get_value_as_int(
		GTK_SPIN_BUTTON(outfile_width));
	cfg.outfile_height = gtk_spin_button_get_value_as_int(
		GTK_SPIN_BUTTON(outfile_height));

	while (cfg.pattern)
	{
		g_free(cfg.pattern->data);
		cfg.pattern = g_slist_remove_link(cfg.pattern, cfg.pattern);
	}
	p = gtk_entry_get_text(GTK_ENTRY(patternw));

	while (*p)
	{
		p += strspn(p, " ");
		l = strcspn(p, " ");
		if (l)
			cfg.pattern = g_slist_append(cfg.pattern, g_strndup(p, l));
		p += l;
	}
	
	while (cfg.pics)
	{
		picentry_free(cfg.pics->data);
		cfg.pics = g_list_remove_link(cfg.pics, cfg.pics);
	}
	cfg.num_pics = 0;

	for (row = 0 ; row < GTK_CLIST(picture_list)->rows ; row++)
	{
		picentry_t *pe;

		gtk_clist_get_text(GTK_CLIST(picture_list), row, 0, &p);
		pe = picentry_new(g_strdup(p));

		pprop = gtk_clist_get_row_data(GTK_CLIST(picture_list), row);
		if (pprop) pe->prop = prop_dup(pprop);

		cfg.pics = g_list_append(cfg.pics, (gpointer)pe);
		cfg.num_pics ++;
	}
	if (run)
		restart_loop = TRUE;
}

static int find_clist_row(clist, text)
GtkWidget *clist;
char *text;
{
	int i;
	char *p;

	if (!text)
		return -1;

	for (i = 0; i < GTK_CLIST(clist)->rows; i++)
	{
		gtk_clist_get_text(GTK_CLIST(clist), i, 0, &p);
		if (!strcmp(p, text))
			return i;
	}

	return -1;
}

static void set_banner_propcfg(prop, propinfo)
banner_prop_t *prop;
banner_prop_dlg_info_t *propinfo;
{
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->max_grow),
		(gfloat)prop->max_grow);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->max_grow))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->max_size),
		(gfloat)prop->max_size);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->max_size))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->xpos),
		(gfloat)prop->xpos);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->xpos))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->ypos),
		(gfloat)prop->ypos);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->ypos))), "value_changed");

	gtk_option_menu_set_history(GTK_OPTION_MENU(propinfo->mode),
		prop->mode);
}

static void set_propcfg(prop, propinfo)
prop_t *prop;
prop_dlg_info_t *propinfo;
{
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->interval_m),
		(gfloat)floor(prop->interval));
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->interval_m))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->interval_s),
		(gfloat)(59.0 * (prop->interval - floor(prop->interval))));
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->interval_s))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->interval_end_m),
		(gfloat)floor(prop->interval_end));
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->interval_end_m))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->interval_end_s),
		(gfloat)(59.0 * (prop->interval_end - floor(prop->interval_end))));
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->interval_end_s))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->max_grow),
		(gfloat)prop->max_grow);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->max_grow))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->max_size),
		(gfloat)prop->max_size);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->max_size))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->xpos),
		(gfloat)prop->xpos);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->xpos))), "value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(propinfo->ypos),
		(gfloat)prop->ypos);
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(
		GTK_SPIN_BUTTON(propinfo->ypos))), "value_changed");

	gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(propinfo->type[prop->type]), TRUE);

	gtk_clist_select_row(GTK_CLIST(propinfo->efect), prop->efect, 0);
	gtk_clist_moveto(GTK_CLIST(propinfo->efect), prop->efect, 0, 0.0 ,0.0);

	gtk_clist_select_row(GTK_CLIST(propinfo->shader), prop->shade, 0);
	gtk_clist_moveto(GTK_CLIST(propinfo->shader), prop->shade, 0, 0.0 ,0.0);

	if (cfg.grads)
	{
		gtk_clist_select_row(GTK_CLIST(propinfo->grad),
			prop->gradnr, 0);
		gtk_clist_moveto(GTK_CLIST(propinfo->grad),
			prop->gradnr, 0, 0.0 ,0.0);

	}

	gtk_option_menu_set_history(GTK_OPTION_MENU(propinfo->use_grad),
		(prop->use_tiles) ? 1 : (prop->use_grad ? 1 : 0));

	if (propinfo->ismain)
	{
		int row;
		char *p;
		GList *ptr;

		gtk_clist_freeze(GTK_CLIST(propinfo->tiles));
		gtk_clist_clear(GTK_CLIST(propinfo->tiles));
		p = gettext("Random");
		gtk_clist_append(GTK_CLIST(propinfo->tiles), (gchar **)&p);
		for (ptr = cfg.tiles; ptr; ptr = ptr->next)
		{
			p = (char *)ptr->data;

			gtk_clist_append(GTK_CLIST(propinfo->tiles),
				(gchar **)&p);
		}
		gtk_clist_thaw(GTK_CLIST(propinfo->tiles));

		row = find_clist_row(propinfo->tiles, prop->tile);

		if (row >= 0)
		{
			gtk_clist_select_row(GTK_CLIST(propinfo->tiles),
				row, 0);
			gtk_clist_moveto(GTK_CLIST(propinfo->tiles),
				row, 0, 0.0 ,0.0);
		}
		update_prop_tiles_combo();
	}
	else
	{
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(propinfo->tiles)->entry),
			prop->tile ? prop->tile : "");
	}

	gtk_color_button_set_color(GTK_COLOR_BUTTON(propinfo->background),
		&prop->background);
	gtk_color_button_set_color(GTK_COLOR_BUTTON(propinfo->background2),
		&prop->background2);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(propinfo->rand_colors),
		prop->rand_colors);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(propinfo->use_banner),
		prop->use_banners);

	if (propinfo->ismain)
	{
		int row;
		char *p;
		GList *ptr;

		gtk_clist_freeze(GTK_CLIST(propinfo->banners));
		gtk_clist_clear(GTK_CLIST(propinfo->banners));
		p = gettext("Random");
		gtk_clist_append(GTK_CLIST(propinfo->banners), (gchar **)&p);
		for (ptr = cfg.banners; ptr; ptr = ptr->next)
		{
			int row;
			banner_t *bn = ptr->data;

			row = gtk_clist_append(GTK_CLIST(propinfo->banners),
				(gchar **)&bn->name);

			if (bn->prop)
			{
				gtk_clist_set_row_data_full(
					GTK_CLIST(propinfo->banners), row,
					bn->prop ? banner_prop_dup(bn->prop) : NULL,
					(GtkDestroyNotify)banner_prop_free);
			}
		}
		gtk_clist_thaw(GTK_CLIST(propinfo->banners));

		row = find_clist_row(propinfo->banners, prop->banner);

		if (row >= 0)
		{
			gtk_clist_select_row(GTK_CLIST(propinfo->banners),
				row, 0);
			gtk_clist_moveto(GTK_CLIST(propinfo->banners),
				row, 0, 0.0 ,0.0);
		}
		update_prop_banners_combo();
		set_banner_propcfg(&cfg.properties.banner_prop,
				&propinfo->banner_prop);
	}
	else
	{
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(propinfo->banners)->entry),
			prop->banner ? prop->banner : "");
	}
}

static void set_cfg()
{
	GSList *ptr;
	GList *cptr;
	gint row;
	int i;
	char pom[15];

	set_propcfg(&cfg.properties, &main_propinfo);

	for (i = sizeof(speed_table)/sizeof(*speed_table) - 1; i ; i--)
	{
		if (cfg.speed >= speed_table[i].speed)
			break;
	}
	gtk_option_menu_set_history(GTK_OPTION_MENU(speed), i);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(min_psize),
		(gfloat)cfg.min_size);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(min_psize))),
		"value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(fract_iter),
		(gfloat)cfg.fract_iter);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(fract_iter))),
		"value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(box_size),
		(gfloat)cfg.box_size);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(box_size))),
		"value_changed");

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(screensaver),
		cfg.screensaver);
#ifdef HAVE_XSS_SUPPORT
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(xscreensaver),
		cfg.xscreensaver);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(send_expose),
		cfg.send_expose);
#endif
#ifdef HAVE_ENLIGHTENMENT_SUPPORT
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enlightenment),
		cfg.use_ebg);
#endif
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inwindow), cfg.inwindow);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(infwindow), cfg.infwindow);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tofile), cfg.tofile);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fake_nautilus), cfg.fake_nautilus);

	gtk_entry_set_text(GTK_ENTRY(outfile), cfg.outfile ? cfg.outfile : "");

	sprintf(pom, "0x%08lx", cfg.windowid);
	gtk_entry_set_text(GTK_ENTRY(windowid), pom);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(outfile_width),
		(gfloat)cfg.outfile_width);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(outfile_width))),
		"value_changed");

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(outfile_height),
		(gfloat)cfg.outfile_height);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(outfile_height))),
		"value_changed");

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(randomized),
		cfg.randomize);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(blank), cfg.blank);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(recurse), cfg.recurse);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sort_pics), cfg.sort);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cycle_blank),
		cfg.cycle_blank);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(remember_last),
		cfg.remember_last);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(enable_tooltips),
		cfg.tooltips);

	for (i = 2, cptr = GTK_LIST(d_efect)->children ; cptr ; cptr = cptr->next, i++)
	{
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(GTK_BIN(cptr->data)->child),
			!g_slist_find(cfg.d_effects, (gpointer) i));

	}

	for (i = 2, cptr = GTK_LIST(d_shader)->children ; cptr ; cptr = cptr->next, i++)
	{
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(GTK_BIN(cptr->data)->child),
			!g_slist_find(cfg.d_shaders, (gpointer) i));

	}

	ptr = cfg.pattern;
	gtk_entry_set_text(GTK_ENTRY(patternw), "");
	while (ptr)
	{
		gtk_entry_append_text(GTK_ENTRY(patternw), (char *)ptr->data);
		ptr = ptr->next;
		if (ptr)
			gtk_entry_append_text(GTK_ENTRY(patternw), " ");
	}

	gtk_clist_freeze(GTK_CLIST(picture_list));
	gtk_clist_clear(GTK_CLIST(picture_list));
	cptr = cfg.pics;
	while (cptr)
	{
		picentry_t *pe = (picentry_t *)cptr->data;

		row = gtk_clist_append(GTK_CLIST(picture_list),
			(gchar **)&pe->name);
		if (pe->prop)
			gtk_clist_set_row_data_full(GTK_CLIST(picture_list),
				row, (void *)prop_dup(pe->prop),
				(GtkDestroyNotify)prop_free);
		cptr = cptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(picture_list));
	if (run)
		restart_loop = TRUE;
}

static void lastscn_fill()
{
	int i;

	for (i = 0; i < LASTSCN_NUM; i++)
	{
		char pom[20];
		char *p;

		sprintf(pom, "lastscn%d", i);

		if (gprop_get_str(pom, &p))
		{
			lastscn = g_slist_append(lastscn, g_strdup(p));
		}
	}
}

static void lastscn_flush()
{
	int i;
	GSList *ptr;

	
	for (i = 0, ptr = lastscn; ptr && i < LASTSCN_NUM; i++, ptr= ptr->next)
	{
		char pom[20];

		sprintf(pom, "lastscn%d", i);

		gprop_set_str(pom, ptr->data);
	}
}

static void lastscn_update_menu();

static void lastscn_add(scn)
char *scn;
{
	GSList *ptr;

	if ((ptr = g_slist_find_custom(lastscn, scn, (void *)strcmp)))
	{
		g_free(ptr->data);
		lastscn = g_slist_remove_link(lastscn, ptr);
	}

	lastscn = g_slist_prepend(lastscn, g_strdup(scn));
	lastscn_update_menu();
}

static void lastscn_load(w, fn)
GtkWidget *w;
char *fn;
{
	if (!access(fn, R_OK))
	{
		cfg_clear();	
		cfg_scenario(fn);
		lastscn_add(fn);
		set_cfg();

		if (cfg.scenario)
			g_free(cfg.scenario);
		cfg.scenario = g_strdup(fn);
		set_title();

		if (run)
		{
			if (cfg.recurse)
				load_pictures();
			restart_loop = TRUE;
		}
	}
	else
	{
		chbg_status_what(gettext("Unable to load scenario"), 5);	
		gdk_beep();
	}
}
	
static void lastscn_update_menu()
{
	GSList *sptr;
	GtkWidget *mi;
	int i;

	while (GTK_MENU_SHELL(lastscn_menu)->children)
	{
		gtk_widget_destroy(GTK_WIDGET(GTK_MENU_SHELL(lastscn_menu)->children->data));
	}

	for (sptr = lastscn, i = 0; sptr; sptr = sptr->next, i++)
	{
		char *p;
		char pom[50];

		if (access((char *)sptr->data, R_OK))
			continue;

		mi = gtk_menu_item_new_with_label(
			g_basename((char *)sptr->data));
		sprintf(pom, "file/last/item%d", i);
		gaccel_bind_widget(pom, "activate", mi, NULL, toplevel_window);
		p = g_strdup((char *)sptr->data);
		gtk_object_set_data_full(GTK_OBJECT(mi), "filename", p,
			(GtkDestroyNotify) g_free);

		gtk_menu_append(GTK_MENU(lastscn_menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(lastscn_load), p);
	}
}

GtkWidget *menubar_item(field)
gchar *field;
{
	GtkWidget *item,*label;
	guint accelerator_key;
 
	item = gtk_menu_item_new();

	label = gtk_accel_label_new(field);
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(item), label);

	accelerator_key = 
		gtk_label_parse_uline (GTK_LABEL (label), field);

	if (accelerator_key != GDK_VoidSymbol)
	{
		if (!menu_accel_group)
			menu_accel_group = gtk_accel_group_new ();

		gtk_widget_add_accelerator (item,
			"activate_item",
			menu_accel_group,
			accelerator_key,
			GDK_MOD1_MASK,
			GTK_ACCEL_LOCKED);
	}

	return item;
}

static void set_dir(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gchar **p = (gchar **) func_data;

	if (*p) g_free(*p);

	*p = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(object)));
}

static void SelectAll(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(func_data)->rows > 0)
		gtk_clist_select_all(GTK_CLIST(func_data));
}

static void Quit(object, func_data)
GtkObject *object;
gpointer func_data;
{
	lastscn_flush();
	cfg_save_prop();

	gtk_widget_destroy(toplevel_window);

	if (!run)  gtk_exit(0);
}

static void QuitReal(object, func_data)
GtkObject *object;
gpointer func_data;
{
	lastscn_flush();
	cfg_save_prop();

	gtk_exit(0);
}

void KillWin(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_destroy(GTK_WIDGET(func_data));
}

void KillAll(object, func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget **w = (GtkWidget **)func_data;

	if (*w)
		gtk_widget_destroy(*w);
}

static void SwitchMode(object, propinfo)
GtkObject *object;
prop_dlg_info_t *propinfo;
{
	if (GTK_TOGGLE_BUTTON(object)->active)
		propinfo->prop->type =
			(rendering_type)gtk_object_get_user_data(object);

	if (propinfo->smart_frame)
		gtk_widget_set_sensitive(propinfo->smart_frame,
			propinfo->prop->type == RENDERT_SMART);
}

static void LoadIt(object, func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));

	if (fn && *fn)
	{
		if (!access(fn, R_OK))
		{
			cfg_clear();	
			cfg_scenario(fn);
			lastscn_add(fn);

			if (cfg.tiles)
				load_tiles();
			if (cfg.banners)
				load_banners();

			set_cfg();

			if (cfg.scenario)
				g_free(cfg.scenario);
			cfg.scenario = g_strdup(fn);
			set_title();

			if (run)
			{
				if (cfg.recurse)
					load_pictures();
				restart_loop = TRUE;
			}

			gtk_widget_destroy(GTK_WIDGET(func_data));
		}
		else
		{
			chbg_status_what(gettext("Unable to load scenario"), 5);	
			gdk_beep();
		}
	}
	else gdk_beep();
}

static void LoadScn(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_file_selection_new(gettext("ChBg: Load scenario"));
	gtk_signal_connect(GTK_OBJECT(w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w), dir);

	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(w));

	gtk_signal_connect(GTK_OBJECT(w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(LoadIt), w);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void SaveIt(object, func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));

	if (fn && *fn)
	{
		get_cfg();
		cfg_save_scenario(fn);
		lastscn_add(fn);

		if (cfg.scenario)
			g_free(cfg.scenario);
		cfg.scenario = g_strdup(fn);
		set_title();

		if (run)
		{
			if (cfg.recurse)
				load_pictures();
		}
		gtk_widget_destroy(GTK_WIDGET(func_data));
	}
	else gdk_beep();
}

static void SaveScn(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_file_selection_new(gettext("ChBg: Save scenario"));
	gtk_signal_connect(GTK_OBJECT(w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (cfg.scenario)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w), cfg.scenario);
	else if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w), dir);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(SaveIt), w);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void Run(object, func_data)
GtkObject *object;
gpointer func_data;
{
	stop_changing = FALSE;
	if (run)
	{
		gdk_beep();
		return;
	}

	gtk_widget_set_sensitive(run_button, FALSE);
	gtk_widget_set_sensitive(run_mi, FALSE);
	gtk_widget_set_sensitive(stop_button, TRUE);
	gtk_widget_set_sensitive(stop_mi, TRUE);
	get_cfg();
	run = TRUE;
	run_changing_process();
	gdk_event_handler_set ((GdkEventFunc)gtk_main_do_event, NULL, NULL);
	run = FALSE;
	gtk_widget_set_sensitive(run_button, TRUE);
	gtk_widget_set_sensitive(run_mi, TRUE);
	gtk_widget_set_sensitive(stop_button, FALSE);
	gtk_widget_set_sensitive(stop_mi, FALSE);

	chbg_status_progress(0,1);
	chbg_status_clear();
}

static void RunTerm(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gboolean is_run = run;

	stop_changing = FALSE;
	run = TRUE;
	get_cfg();
	gtk_widget_destroy(toplevel_window);
	while (gtk_events_pending()) gtk_main_iteration();
	have_setup = FALSE;
	if (!is_run)
	{
		run = TRUE;
		run_changing_process();
		gtk_main_quit();
	}
	toplevel_window = NULL;
}

static void ApplyChanges(object, func_data)
GtkObject *object;
gpointer func_data;
{
	get_cfg();
	if (run)
	{
		if (cfg.recurse)
			load_pictures();
		restart_loop = TRUE;
	}
}

static void ResetConfig(object, func_data)
GtkObject *object;
gpointer func_data;
{
	cfg_clear();
	set_cfg();
	if (run)
		restart_loop = TRUE;
}


static void Stop(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (run)
	{
		stop_changing = TRUE;
	}
}

static void About(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	GtkWidget *button, *col, *label, *box, *pixmap, *frame;
	gchar pom[PATH_MAX];
	GdkPixmap *pmap;
	GdkBitmap *mask;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(w), gettext("ChBg: About"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	col = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(w), col);
	gtk_widget_show(col);

	frame = gtk_frame_new(NULL);
	gtk_container_add(GTK_CONTAINER(col), frame);
	gtk_widget_show(frame);

	box = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame), box);
	gtk_widget_show(box);

	pmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(toplevel_window)->window,
			&mask, NULL, chbg_logo_xpm);

	pixmap = gtk_pixmap_new(pmap, mask);
	gtk_container_add(GTK_CONTAINER(box), pixmap);
	gtk_widget_show(pixmap);

	sprintf(pom, gettext(
		"ChBg %s\n\nManager & changer of background pictures\n\n"
		"By Stefan Ondrejicka\n\n(ondrej@idata.sk)\n\n"
		"URL: http://www.idata.sk/~ondrej/chbg/\n"), VERSION);

	label = gtk_label_new(pom);
	gtk_container_add(GTK_CONTAINER(box), label);
	gtk_widget_show(label);

	button = guitl_pixmap_button(stock_close_xpm, gettext("Cancel"));
	gtk_box_pack_start(GTK_BOX(col), button, FALSE, TRUE, 1);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(KillWin), (gpointer)w);

	gtk_widget_show(w);

	frst = FALSE;
}

static guint listed(clist, str)
GtkWidget *clist;
gchar *str;
{
	int i;
	gchar *p;

	for (i = 0 ; i < GTK_CLIST(clist)->rows ; i++)
	{
		gtk_clist_get_text(GTK_CLIST(clist) ,
			i, 0, &p);

		if (!strcmp(str, p))
			return TRUE;
	}

	return FALSE;
}

static void AppendIt(object, func_data)
GtkObject *object;
gpointer func_data;
{
	GList *ptr;
	gchar *p;
	gchar pom[PATH_MAX];
	gchar dir[PATH_MAX];

	ptr = GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list)->selection;

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));
	strcpy(dir, p);
	p = strrchr(dir, '/');
	if (p) *p = '\0';

	gtk_clist_freeze(GTK_CLIST(picture_list));

	if (!ptr && dir)
	{
		if (!listed(picture_list, dir))
		{
			p = dir;
			gtk_clist_append(GTK_CLIST(picture_list), (gchar **)&p);
		}
	}

	while (ptr)
	{
		gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list),
			GPOINTER_TO_INT(ptr->data), 0, &p);
		sprintf(pom, "%s/%s", dir, p);
		p = pom;
		if (!listed(picture_list, p))
		{
			gtk_clist_append(GTK_CLIST(picture_list), (gchar **)&p);
		}
		ptr = ptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(picture_list));
}


static void AppendDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static guitl_picsel_t spicsel = {NULL, NULL, NULL, NULL, NULL, NULL};
	guitl_picsel_t *picsel;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	picsel = &spicsel;

	guitl_picsel_new(picsel, gettext("ChBg: Get pictures"));

	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->filesel), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(picsel->filesel), dir);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(AppendIt), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->button_append), "clicked",
			GTK_SIGNAL_FUNC(AppendIt),
			(gpointer)picsel->filesel);

	frst = FALSE;
}

static void PreviewDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gchar *p = NULL;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
		gtk_clist_get_text(GTK_CLIST(picture_list),
			GTK_CLIST(picture_list)->focus_row, 0, &p);

	if (p)
		ThumbViewSA(p);
	else
		gdk_beep();
}

static void PreviewFullDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gchar *p = NULL;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
		gtk_clist_get_text(GTK_CLIST(picture_list),
			GTK_CLIST(picture_list)->focus_row, 0, &p);

	if (p)
		ThumbViewFullSA(p);
	else
		gdk_beep();
}

#define RED	0
#define GREEN	1
#define BLUE	2
#define OPACITY	3

static void ResetProp(object, func_data)
GtkObject *object;
gpointer func_data;
{
	set_propcfg(&cfg.properties, &pic_propinfo);
}

static void SelCh(object, func_data)
GtkObject *object;
gpointer func_data;
{
	prop_t *p = NULL;
	gchar *t = gettext("(none)");

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		gtk_clist_get_text(GTK_CLIST(picture_list),
			GTK_CLIST(picture_list)->focus_row, 0, &t);

		p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row);
	}
	if (p)
	{
		set_propcfg(p, &pic_propinfo);
	}
	else
		ResetProp(NULL, NULL);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have), p != NULL);
	gtk_label_set_text(GTK_LABEL(prop_pname), t);
}

static void KillProp(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_signal_disconnect_by_func(GTK_OBJECT(picture_list),
		GTK_SIGNAL_FUNC(SelCh), NULL);
}


static void ClearProp(object, func_data)
GtkObject *object;
gpointer func_data;
{
	prop_t *p = NULL;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row);

		if (p)
		{
			gtk_clist_set_row_data(GTK_CLIST(picture_list),
				GTK_CLIST(picture_list)->focus_row, NULL);
			prop_free(p);
		}
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have),
			FALSE);
	}
	else gdk_beep();
}

static void SetProp(row, type)
int row;
rendering_type type;
{
	prop_t *p;
	gint have_prop = TRUE;

	p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,row);

	if (!p)
	{
		have_prop = FALSE;
		p = g_malloc(sizeof(prop_t));
		memset(p, '\0', sizeof(prop_t));
	}

	get_propcfg(p, &pic_propinfo);

	if (!have_prop)
		gtk_clist_set_row_data_full(GTK_CLIST(picture_list) ,
			row, p, (GtkDestroyNotify)prop_free);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have), TRUE);
}

static void ApplyAllProp(object, func_data)
GtkObject *object;
gpointer func_data;
{
	GList *ptr;

	for (ptr = GTK_CLIST(picture_list)->selection; ptr; ptr = ptr->next)
	{
		SetProp((int)ptr->data, ((prop_t *)func_data)->type);
	}

	if (!GTK_CLIST(picture_list)->selection)
		gdk_beep();
}


static void ApplyProp(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		SetProp(GTK_CLIST(picture_list)->focus_row,
			((prop_t *)func_data)->type);
	}
	else
		gdk_beep();
}

static void PropDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static prop_t *pprop = NULL;
	prop_t *p = NULL;
	GtkWidget *box, *hbox, *button, *f, *notebook;
	gchar *t = gettext("(none)");
	static gboolean frst = TRUE;

	if (!pprop)
	{
		pprop = prop_dup(&cfg.properties);
	}

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}
	w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(w), gettext("ChBg: Picture properties"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(KillProp), &w);
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	prop_copy(pprop, &cfg.properties);

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		gtk_clist_get_text(GTK_CLIST(picture_list),
			GTK_CLIST(picture_list)->focus_row, 0, &t);

		if ((p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row)))
		{
			prop_copy(pprop, p);
		}
	}

	box = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(w), box);
	gtk_widget_show(box);

	f = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(box), f, FALSE, TRUE, 3);
	gtk_widget_show(f);

	prop_pname = gtk_label_new(t);
	gtk_container_add(GTK_CONTAINER(f), prop_pname);
	gtk_widget_show(prop_pname);

	prop_have = gtk_check_button_new_with_label(gettext("Own properties"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have), p != NULL);
	gtk_widget_set_sensitive(prop_have, FALSE);
	gtk_box_pack_start(GTK_BOX(box), prop_have, FALSE, TRUE, 0);
	gtk_widget_show(prop_have);

	notebook = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(box), notebook, TRUE, TRUE, 1);
	gtk_widget_show (notebook);

	memset(&pic_propinfo, '\0', sizeof(pic_propinfo));
	pic_propinfo.ismain = FALSE;
	pic_propinfo.notebook = notebook;
	pic_propinfo.prop = pprop;

	build_propt(&pic_propinfo);

	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX(box), hbox, FALSE, TRUE, 0);
	gtk_widget_show(hbox);

	button = guitl_pixmap_button(stock_apply_xpm, gettext("Apply"));
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ApplyProp), &pprop);

	button = guitl_pixmap_button(stock_apply_xpm,
		gettext("Apply to selected"));
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ApplyAllProp), &pprop);

	button = guitl_pixmap_button(stock_clear_xpm, gettext("Clear"));
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ClearProp), NULL);

	button = guitl_pixmap_button(stock_restart_xpm, gettext("Reset"));
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ResetProp), NULL);

	button = guitl_pixmap_button(stock_close_xpm, gettext("Close"));
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(KillWin), w);

	gtk_signal_connect(GTK_OBJECT(picture_list), "select_row" ,
		GTK_SIGNAL_FUNC(SelCh), NULL);
	gtk_signal_connect(GTK_OBJECT(picture_list), "unselect_row" ,
		GTK_SIGNAL_FUNC(SelCh), NULL);
	gtk_signal_connect(GTK_OBJECT(picture_list), "scroll_vertical" ,
		GTK_SIGNAL_FUNC(SelCh), NULL);

	gtk_widget_show(w);

	frst = FALSE;

	SelCh(NULL, NULL);
}

static void ToggleTooltips(w, data)
GtkWidget *w;
gpointer *data;
{
	if (GTK_CHECK_MENU_ITEM(w)->active)
		gtk_tooltips_enable(chbg_tooltips);
	else
		gtk_tooltips_disable(chbg_tooltips);
}

static void ToolLaunch(w, data)
GtkWidget *w;
gpointer data;
{
	void (*func)(gboolean, GSList *);

	func = data;

	func(TRUE, NULL);
}

static void build_menu(parent)
GtkWidget *parent;
{
	GtkWidget *mbar,*menu,*mbb,*mi;

	menu_accel_group = NULL;

        mbar = gtk_menu_bar_new();
        gtk_widget_show (mbar);

	gtk_box_pack_start(GTK_BOX(parent), mbar, FALSE, TRUE, 1);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("Open scenario ..."));
	gaccel_bind_widget("file/open", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(LoadScn), (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Save scenario ..."));
	gaccel_bind_widget("file/save", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(SaveScn), (gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);


	mi = gtk_menu_item_new_with_label(gettext("Last scenarios"));
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	lastscn_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi), lastscn_menu);
	gtk_widget_show(lastscn_menu);

	lastscn_update_menu();

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	mi = gtk_menu_item_new_with_label(gettext("Quit"));
	gaccel_bind_widget("file/quit", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(QuitReal), (gpointer)NULL);

	mbb = menubar_item(gettext("_File"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);
	
	run_mi = gtk_menu_item_new_with_label(gettext("Run"));
	gaccel_bind_widget("action/run", "activate", run_mi, NULL, toplevel_window);
	gtk_widget_set_sensitive(run_mi, TRUE);
	gtk_menu_append(GTK_MENU(menu), run_mi);
	gtk_widget_show(run_mi);

	gtk_signal_connect(GTK_OBJECT(run_mi), "activate",
		GTK_SIGNAL_FUNC(Run), (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Hide window & run"));
	gaccel_bind_widget("action/run_hide", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(RunTerm), (gpointer)NULL);

	stop_mi = gtk_menu_item_new_with_label(gettext("Stop"));
	gaccel_bind_widget("action_stop", "activate", stop_mi, NULL, toplevel_window);
	gtk_widget_set_sensitive(stop_mi, FALSE);
	gtk_menu_append(GTK_MENU(menu) ,stop_mi);
	gtk_widget_show(stop_mi);

	gtk_signal_connect(GTK_OBJECT(stop_mi), "activate",
		GTK_SIGNAL_FUNC(Stop), (gpointer)NULL);

	mbb = menubar_item(gettext("_Action"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	enable_tooltips = gtk_check_menu_item_new_with_label(
		gettext("Enable tooltips"));
	gaccel_bind_widget("config/tooltips", "activate", enable_tooltips, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), enable_tooltips);
	gtk_widget_show(enable_tooltips);

	gtk_signal_connect(GTK_OBJECT(enable_tooltips), "toggled" ,
		GTK_SIGNAL_FUNC(ToggleTooltips), NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	mi = gtk_menu_item_new_with_label(gettext("Apply changes"));
	gaccel_bind_widget("config/apply", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ApplyChanges), (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Reset configuration"));
	gaccel_bind_widget("config/reset", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ResetConfig), (gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	mi = gtk_menu_item_new_with_label(gettext("Settings ..."));
	gaccel_bind_widget("config/setings", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(SetingsDo), (gpointer)NULL);

	mbb = menubar_item(gettext("_Config"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("Shaders preview page ..."));
	gaccel_bind_widget("tools/shader", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ShadersPreview), NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	mi = gtk_menu_item_new_with_label(
		gettext("All thumbnails preview ..."));
	gaccel_bind_widget("tools/allthumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ThumbPreview), NULL);

	mi = gtk_menu_item_new_with_label(
		gettext("Page thumbnails preview ..."));
	gaccel_bind_widget("tools/pagethumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ThumbPreviewPerPage), NULL);

	mi = gtk_menu_item_new_with_label(gettext("Dir thumbnails preview ..."));
	gaccel_bind_widget("tools/dirthumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ThumbPreviewPerDir), NULL);

	mbb = menubar_item(gettext("_Preview"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("Batch rescaling ..."));
	gaccel_bind_widget("tools/batch_scale", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ToolLaunch), ext_scale_image_dlg);

	mi = gtk_menu_item_new_with_label(gettext("Batch conversion ..."));
	gaccel_bind_widget("tools/batch_convert", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate" ,
		GTK_SIGNAL_FUNC(ToolLaunch), ext_convert_image_dlg);


	mbb = menubar_item(gettext("_Tools"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("About ..."));
	gaccel_bind_widget("help/about", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(About),
			(gpointer)NULL);

	mbb = menubar_item(gettext("_Help"));
	gtk_widget_show (mbb);
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mbb));
	gtk_menu_bar_append(GTK_MENU_BAR(mbar), mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb), menu);

	gtk_accel_group_attach (menu_accel_group, GTK_OBJECT (toplevel_window));
}

static void Delete(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_freeze(GTK_CLIST(picture_list));

	while (GTK_CLIST(picture_list)->selection)
	{
		gtk_clist_remove (GTK_CLIST(picture_list),
			GPOINTER_TO_INT(GTK_CLIST(picture_list)->selection->data));
	}
	
	gtk_clist_thaw(GTK_CLIST(picture_list));
}


static void UnSelect(object, func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_unselect_all(GTK_CLIST(picture_list));
}

static gint PopupMenu(widget, event, menu)
GtkWidget *widget;
GdkEvent  *event;
GtkWidget *menu;
{
	GdkEventButton *bevent;

	switch (event->type)
	{
	    case GDK_BUTTON_PRESS:
		bevent = (GdkEventButton *) event;
		if (bevent->button == 3)
		{
			gtk_menu_popup (GTK_MENU(menu),
				NULL, NULL, NULL, NULL, 3, bevent->time);
		}
		break;
	    default:
		break;
	}

	return FALSE;
}

static void window_drop_str(widget, context, x, y, seldata, info, time, data)
GtkWidget *widget;
GdkDragContext *context;
gint x;
gint y;
GtkSelectionData *seldata;
guint info;
guint time;
gpointer data;
{
	gchar *p;
	gchar *drag_str;
	gchar *p_seldata;

	if (!seldata || !seldata->data) 
	{
		gtk_drag_finish(context, FALSE, FALSE, time);
		return;
	}

	p_seldata = (gchar *) seldata->data;

	/* strip away '\n' */
	p = strchr(p_seldata, '\n');
	if (p)
		drag_str = g_strndup(p_seldata, p - p_seldata); 	
	else
		drag_str = g_strdup(p_seldata);

	gtk_clist_append(GTK_CLIST(picture_list), (gchar **)&drag_str);

	g_free(drag_str);

	gtk_drag_finish(context, TRUE, FALSE, time);
}

static void ToggleBool(w, fdata)
GtkWidget *w;
gpointer fdata;
{
	gtk_widget_set_sensitive(GTK_WIDGET(fdata),
		GTK_TOGGLE_BUTTON(w)->active);
}

static void build_picture_list(notebook)
GtkWidget *notebook;
{
	GtkWidget *box, *label, *swin, *mi, *button;
	GtkWidget *pbox, *frame, *col, *list_menu;
	GList *ptr;
	GList *ptrn;
	gint row,i;

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Picture list"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);
	gtk_box_pack_start(GTK_BOX(box), swin, TRUE, TRUE, 1);

	picture_list = gtk_clist_new(1);
	gtk_clist_set_selection_mode(GTK_CLIST(picture_list),
		GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_title (GTK_CLIST(picture_list), 0,
			gettext("Background pictures"));
	gtk_clist_column_titles_show (GTK_CLIST(picture_list));
	gtk_clist_set_column_auto_resize (GTK_CLIST (picture_list), 0, TRUE);
	gtk_container_add (GTK_CONTAINER (swin), picture_list);

  	gtk_drag_dest_set(picture_list, GTK_DEST_DEFAULT_ALL,
			dragtypes, sizeof(dragtypes)/sizeof(dragtypes[0]) ,
               		GDK_ACTION_COPY | GDK_ACTION_MOVE);
  	gtk_signal_connect(GTK_OBJECT(picture_list) ,
			"drag_data_received" ,
			GTK_SIGNAL_FUNC(window_drop_str),
			NULL);

	ptr = cfg.pics;
	while (ptr)
	{
		picentry_t *pe = ptr->data;

		row = gtk_clist_append(GTK_CLIST(picture_list),
			(gchar **)&pe->name);

		if (pe->prop)
			gtk_clist_set_row_data_full(GTK_CLIST(picture_list),
				row, prop_dup(pe->prop),
				(GtkDestroyNotify)prop_free);
									
		ptr = ptr->next;
	}
	gtk_widget_show(picture_list);

	list_menu =  gtk_menu_new();
	gtk_widget_realize (list_menu);

	gtk_signal_connect (GTK_OBJECT (picture_list), "button_press_event",
			(GtkSignalFunc) PopupMenu,
			(gpointer)list_menu);

	mi = gtk_menu_item_new_with_label(gettext("Set properties ..."));
	gaccel_bind_widget("piclist/properties", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(PropDlg),
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Delete selected"));
	gaccel_bind_widget("piclist/delete", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(Delete),
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Select All"));
	gaccel_bind_widget("piclist/selectall", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(SelectAll),
			(gpointer)picture_list);

	mi = gtk_menu_item_new_with_label(gettext("Unselect"));
	gaccel_bind_widget("piclist/unselect", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(UnSelect),
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Preview image ..."));
	gaccel_bind_widget("piclist/preview", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(PreviewDlg), (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Preview image fullscreen ..."));
	gaccel_bind_widget("piclist/preview_full", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(PreviewFullDlg), (gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);

	mi = gtk_menu_item_new_with_label(gettext("All thumbnails ..."));
	gaccel_bind_widget("piclist/allthumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ThumbPreview),
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Page thumbnails ..."));
	gaccel_bind_widget("piclist/pagethumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ThumbPreviewPerPage),
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Dir thumbnails ..."));
	gaccel_bind_widget("piclist/dirthumbnails", "activate", mi, NULL, toplevel_window);
	gtk_menu_append(GTK_MENU(list_menu), mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(ThumbPreviewPerDir),
			(gpointer)NULL);

	button = guitl_pixmap_button(stock_append_xpm,
		gettext("Append pictures ..."));
	SET_TOOLTIP(button, gettext(
		"Choose which images or directories of images "
		"you wish to add to your picture list."));
	gtk_box_pack_start(GTK_BOX(box), button, FALSE, TRUE, 1);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(AppendDlg),
			(gpointer)NULL);

	frame = gtk_frame_new(gettext("Recursion parameters"));

	sort_pics = gtk_check_button_new_with_label(gettext("Sort pictures"));
	SET_TOOLTIP(sort_pics, gettext("Show pictures in alphabetical order."));
	gtk_box_pack_start(GTK_BOX(box), sort_pics, FALSE, TRUE, 1);
	gtk_widget_show(sort_pics);

	recurse = gtk_check_button_new_with_label(
		gettext("Recurse through directories"));
	SET_TOOLTIP(recurse, gettext("Scans sub-directories for pictures."
		"Example: choose /home/photos only and it\'ll display all "
		"photos in /home/photos/family and /home/photos/friends."));
	gtk_box_pack_start(GTK_BOX(box), recurse, FALSE, TRUE, 1);
	gtk_widget_show(recurse);

	gtk_signal_connect(GTK_OBJECT(recurse), "toggled",
			GTK_SIGNAL_FUNC(ToggleBool), (gpointer)frame);

	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 1);
	gtk_widget_show(frame);

	col = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(frame), col);
	gtk_widget_show(col);

	pbox = gtk_hbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(col), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Pattern for recursion: "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 1);
	gtk_widget_show(label);

	patternw = gtk_combo_new();
	SET_TOOLTIP(GTK_COMBO(patternw)->entry, gettext(
		"which type(s) of image(s) you wish to display "
		"(case-insensitive) "
		"(you can enter multiple space separated wildcard patterns)"));

	gtk_box_pack_start(GTK_BOX(pbox), patternw, TRUE, TRUE, 1);
	gtk_widget_show(patternw);
	ptrn = NULL;
	for (i = 0; combo_patterns[i] ; i++)
		ptrn = g_list_append(ptrn, combo_patterns[i]);
	gtk_combo_set_popdown_strings(GTK_COMBO(patternw), ptrn);
	while (ptrn) ptrn = g_list_remove_link(ptrn, ptrn);
	patternw = GTK_COMBO(patternw)->entry;

	pbox = gtk_table_new(3, 1, FALSE);
	gtk_box_pack_start(GTK_BOX(col), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	min_psize = guitl_tab_add_numentry(pbox,
		gettext("Minimal picture size when recursing directories: "),
		gettext("kB"),
		0, 0, 0, 1.0, 10.0, 0.0, 1000000.0,(gfloat)cfg.min_size);
	SET_TOOLTIP(min_psize, gettext(
		"Useful for excluding small pictures or thumbnails."));

	ToggleBool(recurse, frame);
}

static GtkWidget * toolbar_button(parent, label, help, pmap_data, cb, cb_data)
GtkWidget *parent;
char *label;
char *help;
char **pmap_data;
GtkSignalFunc cb;
gpointer cb_data;
{
	GtkWidget *button = NULL;
	GtkWidget *pixmap = NULL;
	GdkPixmap *pmap;
	GdkBitmap *shape;

	if (pmap_data)
	{
		pmap = gdk_pixmap_create_from_xpm_d(GDK_ROOT_PARENT(),
			&shape, NULL, pmap_data);
		pixmap = gtk_pixmap_new(pmap, shape);
	}

	button = gtk_toolbar_append_item(GTK_TOOLBAR(parent), label,
		help, "", pixmap, cb , cb_data);

	return button;
}

static void build_toolbar(col)
GtkWidget *col;
{
	GtkWidget *tb, *hbox, *button;

	hbox = gtk_handle_box_new ();
	gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(hbox), GTK_SHADOW_NONE);
	gtk_box_pack_start(GTK_BOX(col), hbox, FALSE, TRUE, 0);
	gtk_widget_show(hbox);
	
	tb = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief(GTK_TOOLBAR(tb), GTK_RELIEF_NONE);
	gtk_container_add(GTK_CONTAINER(hbox), tb);
	gtk_toolbar_set_space_size (GTK_TOOLBAR (tb), 15);
	gtk_widget_show (tb);

	gtk_toolbar_append_space (GTK_TOOLBAR(tb));

	button = toolbar_button(tb, NULL, gettext("Open scenario") ,
			stock_open_xpm, LoadScn, NULL);

	button = toolbar_button(tb, NULL, gettext("Save scenario"),
			stock_save_as_xpm, SaveScn, NULL);

	gtk_toolbar_append_space (GTK_TOOLBAR(tb));

	button = toolbar_button(tb, NULL, gettext("Apply setup changes"),
			stock_apply_xpm, ApplyChanges, NULL);

	button = toolbar_button(tb, NULL, gettext("Reset configuration"),
			stock_restart_xpm, ResetConfig, NULL);

	gtk_toolbar_append_space (GTK_TOOLBAR(tb));

	run_button = toolbar_button(tb, NULL, gettext("Run with actual settings") ,
			stock_exec_xpm, Run, NULL);
	gtk_widget_set_sensitive(run_button, TRUE);

	button = toolbar_button(tb, NULL, gettext("Hide Setup window and run with actual settings") ,
			stock_exec_term_xpm, RunTerm, NULL);

	stop_button = toolbar_button(tb, NULL, gettext("Stop changing pictures") ,
			stock_stop_xpm, Stop, NULL);
	gtk_widget_set_sensitive(stop_button, FALSE);

	button = toolbar_button(tb, NULL, gettext("Immediately quit") ,
			stock_exit_xpm, QuitReal, NULL);

}

static void set_color_label(w, color, fdata)
GtkWidget *w;
GdkColor *color;
gpointer fdata;
{
	gtk_label_set_text(GTK_LABEL(fdata), cfg_get_color_str(color, NULL));
}

static void ClrSetSensitive(w, row, col, event, propinfo)
GtkWidget *w;
gint row;
gint col;
GdkEvent *event;
prop_dlg_info_t *propinfo;
{
	int i;

	for (i = 0; i < 5; i++)
	{
		if (propinfo->clr_sens[i])
			gtk_widget_set_sensitive(propinfo->clr_sens[i], row);
	}
}

static void update_prop_tiles_combo()
{
	GList *lst;
	int i;
	char *saved;

	if (!pic_propinfo.tiles)
		return;

	saved = g_strdup(gtk_entry_get_text(
		GTK_ENTRY(GTK_COMBO(pic_propinfo.tiles)->entry)));

	lst = g_list_append(NULL, "");
	for (i = 0; i < GTK_CLIST(main_propinfo.tiles)->rows; i++)
	{
		char *p;
		gtk_clist_get_text(GTK_CLIST(main_propinfo.tiles), i, 0, &p);
		lst = g_list_append(lst, p);
	}

	gtk_combo_set_popdown_strings(GTK_COMBO(pic_propinfo.tiles), lst);
	g_list_free(lst);

	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(pic_propinfo.tiles)->entry),
		saved);
	g_free(saved);
}

static void AppendTiles(object, func_data)
GtkObject *object;
gpointer func_data;
{
	GList *ptr;
	gchar *p;
	gchar pom[PATH_MAX];
	gchar dir[PATH_MAX];

	ptr = GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list)->selection;

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));
	strcpy(dir, p);
	p = strrchr(dir, '/');
	if (p) *p = '\0';

	gtk_clist_freeze(GTK_CLIST(main_propinfo.tiles));

	while (ptr)
	{
		gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list),
			GPOINTER_TO_INT(ptr->data), 0, &p);
		sprintf(pom, "%s/%s", dir, p);
		p = pom;
		if (!listed(main_propinfo.tiles, p))
		{
			gtk_clist_append(GTK_CLIST(main_propinfo.tiles),(gchar **)&p);
		}
		ptr = ptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(main_propinfo.tiles));
	update_prop_tiles_combo();
}

static void AppendTileDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static guitl_picsel_t spicsel = {NULL, NULL, NULL, NULL, NULL, NULL};
	guitl_picsel_t *picsel;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	picsel = &spicsel;

	guitl_picsel_new(picsel, gettext("ChBg: Get new tiles"));

	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->filesel), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(picsel->filesel), dir);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(AppendTiles), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->button_append), "clicked",
			GTK_SIGNAL_FUNC(AppendTiles),
			(gpointer)picsel->filesel);

	frst = FALSE;
}

static void ClearTiles(object, func_data)
GtkObject *object;
gpointer func_data;
{
	char *p;

	gtk_clist_freeze(GTK_CLIST(main_propinfo.tiles));
	gtk_clist_clear(GTK_CLIST(main_propinfo.tiles));
	p = gettext("Random");
	gtk_clist_append(GTK_CLIST(main_propinfo.tiles), (gchar **)&p);
	gtk_clist_thaw(GTK_CLIST(main_propinfo.tiles));
	update_prop_tiles_combo();
}

static void DeleteTile(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(main_propinfo.tiles)->selection)
	{
		int row = (guint)
			(GTK_CLIST(main_propinfo.tiles)->selection->data);

		if (row > 0)
		{
			gtk_clist_remove(GTK_CLIST(main_propinfo.tiles), row);
			update_prop_tiles_combo();
		}
		else
			gdk_beep();
	}
	else
	{
		gdk_beep();
	}
}

static void update_prop_banners_combo()
{
	GList *lst;
	int i;
	char *saved;

	if (!pic_propinfo.banners)
		return;

	saved = g_strdup(gtk_entry_get_text(
		GTK_ENTRY(GTK_COMBO(pic_propinfo.banners)->entry)));

	lst = g_list_append(NULL, "");
	for (i = 0; i < GTK_CLIST(main_propinfo.banners)->rows; i++)
	{
		char *p;
		gtk_clist_get_text(GTK_CLIST(main_propinfo.banners), i, 0, &p);
		lst = g_list_append(lst, p);
	}

	gtk_combo_set_popdown_strings(GTK_COMBO(pic_propinfo.banners), lst);
	g_list_free(lst);

	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(pic_propinfo.banners)->entry),
		saved);
	g_free(saved);
}

static void AppendBanners(object, func_data)
GtkObject *object;
gpointer func_data;
{
	GList *ptr;
	gchar *p;
	gchar pom[PATH_MAX];
	gchar dir[PATH_MAX];

	ptr = GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list)->selection;

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));
	strcpy(dir, p);
	p = strrchr(dir, '/');
	if (p) *p = '\0';

	gtk_clist_freeze(GTK_CLIST(main_propinfo.banners));

	while (ptr)
	{
		gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list),
			GPOINTER_TO_INT(ptr->data), 0, &p);
		sprintf(pom, "%s/%s", dir, p);
		p = pom;
		if (!listed(main_propinfo.banners, p))
		{
			gtk_clist_append(GTK_CLIST(main_propinfo.banners),(gchar **)&p);
		}
		ptr = ptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(main_propinfo.banners));
	update_prop_banners_combo();
}

static void AppendBannersDlg(object, func_data)
GtkObject *object;
gpointer func_data;
{
	static guitl_picsel_t spicsel = {NULL, NULL, NULL, NULL, NULL, NULL};
	guitl_picsel_t *picsel;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	picsel = &spicsel;

	guitl_picsel_new(picsel, gettext("ChBg: Get new tiles"));

	if (frst)
		gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->filesel), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(picsel->filesel), dir);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(AppendBanners), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), picsel->filesel);

	gtk_signal_connect(GTK_OBJECT(picsel->button_append), "clicked",
			GTK_SIGNAL_FUNC(AppendBanners),
			(gpointer)picsel->filesel);

	frst = FALSE;
}

static void ClearBanners(object, func_data)
GtkObject *object;
gpointer func_data;
{
	char *p;

	gtk_clist_freeze(GTK_CLIST(main_propinfo.banners));
	gtk_clist_clear(GTK_CLIST(main_propinfo.banners));
	p = gettext("Random");
	gtk_clist_append(GTK_CLIST(main_propinfo.banners), (gchar **)&p);
	gtk_clist_thaw(GTK_CLIST(main_propinfo.banners));
	update_prop_banners_combo();
}

static void DeleteBanner(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(main_propinfo.banners)->selection)
	{
		int row = (guint)
			(GTK_CLIST(main_propinfo.banners)->selection->data);

		if (row > 0)
		{
			gtk_clist_remove(GTK_CLIST(main_propinfo.banners), row);
			update_prop_banners_combo();
		}
		else
			gdk_beep();
	}
	else
	{
		gdk_beep();
	}
}


static void build_banner_props(box, propinfo)
GtkWidget *box;
banner_prop_dlg_info_t *propinfo;
{
	GtkWidget *prow,*frame,*label,*menu,*mi;
	int i;
	char *banner_modes[] = {
		gettext_nop("Normal"),
		gettext_nop("Average"),
		gettext_nop("Lighten only"),
		gettext_nop("Darken only"),
		gettext_nop("Divide"),
		gettext_nop("Multiply"),
		gettext_nop("Multiply bg value"),
		gettext_nop("Multiply fg value"),
		gettext_nop("Add"),
		gettext_nop("Subtract bg"),
		gettext_nop("Subtract fg"),
		gettext_nop("Grayscale"),
		gettext_nop("Bumpmap to bg"),
		gettext_nop("Bumpmap self"),
		gettext_nop("Emboss"),
		NULL,
	};

	frame = gtk_frame_new(gettext("Default banner properties"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 5);
	gtk_widget_show(frame);

	prow = gtk_table_new(4, 4, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), prow);
	gtk_widget_show(prow);

	propinfo->max_grow = guitl_tab_add_numentry(prow,
		gettext("Max grow ratio for banner: "), gettext("x"),
		0, 0, 1, 0.1, 1.0, 0.0, 1000.0,
		propinfo->prop->max_grow);
	SET_TOOLTIP(propinfo->max_grow, gettext(
		"Maximal allowed banner scaling factor. (default 1.0)\n"
		"Real scaling factor depends on picture and screen size\n"));

	propinfo->max_size = guitl_tab_add_numentry(prow,
		gettext("Maximal size of screen taken by banner: "),
		gettext("%"),
		0, 1, 0, 1.0, 5.0, 10.0, 100.0,
		(gfloat)propinfo->prop->max_size);
	SET_TOOLTIP(propinfo->max_size, gettext(
		"Set to below 100% to see background banner background "
		"in all cases. (default 90%)"));

	propinfo->xpos = guitl_tab_add_numentry(prow,
		gettext("Horizontal banner position: "), NULL,
		0, 2, 3, .01, .1, 0.0, 1.0,
		(gfloat)propinfo->prop->xpos);

	propinfo->ypos = guitl_tab_add_numentry(prow,
		gettext("Vertical picture position: "), NULL,
		0, 3, 3, .01, .1, 0.0, 1.0,
		(gfloat)propinfo->prop->ypos);

	label = gtk_label_new(gettext("Banner painting mode: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(prow), label, 0, 1, 4, 5,
		 GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	propinfo->mode = gtk_option_menu_new();

	menu = gtk_menu_new();

	for (i = 0; banner_modes[i]; i++)
	{
		mi = gtk_menu_item_new_with_label(gettext(banner_modes[i]));
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_widget_show(mi);

		gtk_object_set_user_data(GTK_OBJECT(mi), (gpointer)i);
	}

	gtk_option_menu_set_menu(GTK_OPTION_MENU(propinfo->mode), menu);
	gtk_table_attach(GTK_TABLE(prow), propinfo->mode, 1, 2, 4, 5,
		 GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(propinfo->mode);
}

static void ApplyBannerProp()
{
	int row = 0;

	if (GTK_CLIST(main_propinfo.banners)->selection)
		row = (int)GTK_CLIST(main_propinfo.banners)->selection->data;

	if (row > 0)
	{
		banner_prop_t *bp;
		bp = gtk_clist_get_row_data(GTK_CLIST(main_propinfo.banners),
			row);

		if (!bp)
		{
			bp = banner_prop_new();
			get_banner_propcfg(bp, &perbanner_props);
			gtk_clist_set_row_data_full(GTK_CLIST(main_propinfo.banners),
				row, bp, (GtkDestroyNotify)banner_prop_free);
		}
		else
		{
			get_banner_propcfg(bp, &perbanner_props);
		}
	}
	else
		gdk_beep();
}

static void ClearBannerProp()
{
	int row = 0;

	if (GTK_CLIST(main_propinfo.banners)->selection)
		row = (int)GTK_CLIST(main_propinfo.banners)->selection->data;

	if (row > 0)
	{
		gtk_clist_set_row_data_full(GTK_CLIST(main_propinfo.banners),
			row, NULL, (GtkDestroyNotify)banner_prop_free);
	}
}

static void ResetBannerProp()
{
	banner_prop_t *bp = banner_prop_new();
	get_banner_propcfg(bp, &main_propinfo.banner_prop);
	set_banner_propcfg(bp, &perbanner_props);
	banner_prop_free(bp);
}

static void SelBanner(w, row, col)
GtkWidget *w;
int row;
int col;
{
	banner_prop_t *bp;

	if (!perbanner_props.max_grow)
		return;

	bp = gtk_clist_get_row_data(GTK_CLIST(w), row);

	if (!bp)
		bp = &cfg.properties.banner_prop;

	set_banner_propcfg(bp, &perbanner_props);
}

static void KillBannerProp()
{
	gtk_signal_disconnect_by_func(GTK_OBJECT(main_propinfo.banners),
		GTK_SIGNAL_FUNC(SelBanner), NULL);
}

static void BannerSetProperties()
{
	static GtkWidget *tl = NULL;
	static gboolean frst = TRUE;

	if (!tl)
	{
		GtkWidget *box, *hbox, *button;

		tl = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_window_set_title(GTK_WINDOW(tl),
			gettext("Banner properties"));
		gtk_signal_connect(GTK_OBJECT(tl), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &tl);
		gtk_signal_connect(GTK_OBJECT(tl), "destroy",
			GTK_SIGNAL_FUNC(KillBannerProp), NULL);

		if (frst)
			gtk_signal_connect(GTK_OBJECT(toplevel_window),
				"destroy", GTK_SIGNAL_FUNC(KillAll), &tl);

		box = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(tl), box);
		gtk_widget_show(box);

		perbanner_props.prop = &cfg.properties.banner_prop;
		build_banner_props(box, &perbanner_props);

		hbox = gtk_hbox_new(TRUE, 2);
		gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 2);
		gtk_widget_show(hbox);

		button = guitl_pixmap_button(stock_apply_xpm, gettext("Apply"));
		gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ApplyBannerProp), NULL);

		button = guitl_pixmap_button(stock_clear_xpm, gettext("Clear"));
		gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ClearBannerProp), NULL);

		button = guitl_pixmap_button(stock_restart_xpm, gettext("Reset"));
		gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ResetBannerProp), NULL);

		button = guitl_pixmap_button(stock_close_xpm, gettext("Close"));
		gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 2);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(KillWin), tl);

		gtk_signal_connect(GTK_OBJECT(main_propinfo.banners),
			"select_row", GTK_SIGNAL_FUNC(SelBanner), NULL);

	}
	gtk_widget_show(tl);
	if (GTK_WIDGET_REALIZED(tl))
		gdk_window_raise(tl->window);
}

static void BannerView(w, list)
GtkWidget *w;
GtkWidget *list;
{
	int row = 0;

	if (GTK_CLIST(list)->selection)
		row = (int)(GTK_CLIST(list)->selection->data);

	if (row > 0)
	{
		char *p;

		gtk_clist_get_text(GTK_CLIST(list), row, 0, &p);
		ThumbViewPictureList(p, list);
	}
	else
		gdk_beep();
}

static void build_propt(propinfo)
prop_dlg_info_t *propinfo;
{
	GtkWidget *frame, *pbox, *label, *chb ,*swin, *box, *ntbk;
	GtkWidget *mi,*menu, *prow, *button;
	GtkAdjustment *adj;
	GSList *rg,*ptr;
	guint i;
	char *p;
	struct {
		char	*label;
		rendering_type	type;
	} type_info[] = {
		{gettext_nop("Tile picture"), RENDERT_TILE},
		{gettext_nop("Tile mirrored picture"), RENDERT_MIRROR},
		{gettext_nop("Maximize picture"), RENDERT_MAXIMIZE},
		{gettext_nop("Center picture"), RENDERT_CENTER},
		{gettext_nop("Center tiled picture"), RENDERT_CENTER_TILE},
		{gettext_nop("Integer tiled picture"), RENDERT_INT_TILE},
		{gettext_nop("Symmetrical tiled picture"), RENDERT_SYM_TILE},
		{gettext_nop("Integer mirrored picture"), RENDERT_INT_MIRROR},
		{gettext_nop("Symmetrical mirrored picture"), RENDERT_SYM_MIRROR},
		{gettext_nop("Smart resized centered picture"), RENDERT_SMART},
		{NULL, 0}
	};

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Properties"));
	gtk_notebook_append_page(GTK_NOTEBOOK(propinfo->notebook), box, label);

	pbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Interval: "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 5);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)0.0, 0.0,
				1000000.0, 1.0, 60.0, 0.0);
	propinfo->interval_m = gtk_spin_button_new(adj, 0, 0);
	gtk_widget_set_usize(propinfo->interval_m,
		gdk_string_width(propinfo->interval_m->style->font, "wwwww"),
		-1);
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->interval_m, FALSE, TRUE, 2);
	gtk_widget_show(propinfo->interval_m);

	label = gtk_label_new(gettext(": "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 2);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)0.0, 0.0,
				59.0, 1.0, 10.0, 0.0);
	propinfo->interval_s = gtk_spin_button_new(adj, 0, 0);
	gtk_widget_set_usize(propinfo->interval_s,
		gdk_string_width(propinfo->interval_s->style->font, "wwwww"),
		-1);
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->interval_s, FALSE, TRUE, 2);
	gtk_widget_show(propinfo->interval_s);

	label = gtk_label_new(gettext("-- "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 2);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)0.0, 0.0,
				1000000.0, 1.0, 60.0, 0.0);
	propinfo->interval_end_m = gtk_spin_button_new(adj, 0, 0);
	gtk_widget_set_usize(propinfo->interval_end_m,
		gdk_string_width(propinfo->interval_end_m->style->font,
			"wwwww"),
		-1);
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->interval_end_m,
		FALSE, TRUE, 2);
	gtk_widget_show(propinfo->interval_end_m);

	label = gtk_label_new(gettext(": "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 2);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)0.0, 0.0,
				59.0, 1.0, 10.0, 0.0);
	propinfo->interval_end_s = gtk_spin_button_new(adj, 0, 0);
	gtk_widget_set_usize(propinfo->interval_end_s,
		gdk_string_width(propinfo->interval_end_s->style->font,
			"wwwww"),
		-1);
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->interval_end_s,
		FALSE, TRUE, 5);
	gtk_widget_show(propinfo->interval_end_s);

	frame = gtk_frame_new(gettext("Rendering Mode"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX (box), frame, FALSE, FALSE, 5);

	pbox = gtk_table_new(2, 5, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), pbox);
	gtk_widget_show(pbox);
	
	rg = NULL;

	for (i = 0; type_info[i].label; i++)
	{
		chb = gtk_radio_button_new_with_label(rg,
			gettext(type_info[i].label));
		rg = gtk_radio_button_group(GTK_RADIO_BUTTON(chb));
		gtk_object_set_user_data(GTK_OBJECT(chb),
			(gpointer)type_info[i].type);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb),
			propinfo->prop->type == type_info[i].type);
		gtk_table_attach(GTK_TABLE(pbox), chb,
			i%2, i%2 + 1, i/2, i/2 + 1,
			GTK_FILL, GTK_FILL, 1, 1);
		gtk_signal_connect(GTK_OBJECT(chb), "toggled",
				GTK_SIGNAL_FUNC(SwitchMode), propinfo);
		gtk_widget_show(chb);
		propinfo->type[type_info[i].type] = chb;
	}

	frame = propinfo->smart_frame =
		gtk_frame_new(gettext("Smart rendering mode setup"));
	gtk_signal_connect(GTK_OBJECT(frame), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &propinfo->smart_frame);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX (box), frame, FALSE, FALSE, 5);

	pbox = gtk_table_new(3, 4, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), pbox);
	gtk_widget_show(pbox);

	propinfo->max_grow = guitl_tab_add_numentry(pbox,
		gettext("Max grow ratio for picture: "), gettext("x"),
		0, 0, 1, 0.1, 1.0, 0.0, 1000.0, propinfo->prop->max_grow);
	SET_TOOLTIP(propinfo->max_grow, gettext(
		"Maximal allowed picture scaling factor. (default 1.0)\n"
		"Real scaling factor depends on picture and screen size\n"));


	propinfo->max_size = guitl_tab_add_numentry(pbox,
		gettext("Maximal size of screen taken by picture: "),
		gettext("%"),
		0, 1, 0, 1.0, 5.0, 10.0, 100.0,
		(gfloat)propinfo->prop->max_size);
	SET_TOOLTIP(propinfo->max_size, gettext(
		"Set to below 100% to see background shading effects "
		"in all cases. (default 90%)"));

	propinfo->xpos = guitl_tab_add_numentry(pbox,
		gettext("Horizontal picture position: "), NULL,
		0, 2, 3, .01, .1, 0.0, 1.0,
		(gfloat)propinfo->prop->xpos);

	propinfo->ypos = guitl_tab_add_numentry(pbox,
		gettext("Vertical picture position: "), NULL,
		0, 3, 3, .01, .1, 0.0, 1.0,
		(gfloat)propinfo->prop->ypos);

	gtk_widget_set_sensitive(propinfo->smart_frame,
		propinfo->prop->type == RENDERT_SMART);

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Effects"));
	gtk_notebook_append_page(GTK_NOTEBOOK(propinfo->notebook), box, label);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box), swin, TRUE, TRUE, 5);
	gtk_widget_show (swin);

	propinfo->efect = gtk_clist_new(1);
	gtk_clist_set_column_title(GTK_CLIST(propinfo->efect), 0,
			gettext("Picture changing effect "));
	gtk_clist_column_titles_show(GTK_CLIST(propinfo->efect));
	SET_TOOLTIP((gtk_clist_get_column_widget(GTK_CLIST(propinfo->efect), 0))->parent,
		gettext("[0-29] various transition effects between pictures."));
	gtk_clist_set_selection_mode(GTK_CLIST(propinfo->efect),
		GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(swin), propinfo->efect);
	for (i = 0 ; i <= CHBG_EFECTS ; i++)
	{
		char *p = gettext(effect_texts[i]);
		guint row;

		row = gtk_clist_append(GTK_CLIST(propinfo->efect),
			(gchar **)&p);
		gtk_clist_set_row_data(GTK_CLIST(propinfo->efect),
			row, (gpointer)i);
	}
	gtk_widget_show(propinfo->efect);
	gtk_clist_select_row(GTK_CLIST(propinfo->efect),
		propinfo->prop->efect, 0);
	gtk_clist_moveto(GTK_CLIST(propinfo->efect),
		propinfo->prop->efect, 0, 0.0 ,0.0);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box), swin, TRUE, TRUE, 5);
	gtk_widget_show (swin);

	propinfo->shader = gtk_clist_new(1);
	gtk_clist_set_column_title(GTK_CLIST(propinfo->shader), 0,
			gettext("Background shading effect"));
	gtk_clist_column_titles_show(GTK_CLIST(propinfo->shader));
	SET_TOOLTIP((gtk_clist_get_column_widget(GTK_CLIST(propinfo->shader), 0))->parent,
		gettext("[0-527] Blends color1 & color2 to create various "
			"background shades.(see Randomize background colors)"));
	gtk_clist_set_selection_mode(GTK_CLIST(propinfo->shader),
		GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(swin), propinfo->shader);
	for (i = 0 ; i <= shader_get_cnt() ; i++)
	{
		char pom[100];
		char *p = pom;
		guint row;

		if (i == 0)
			sprintf(pom, "%s",  gettext("None"));
		else if (i == 1)
			sprintf(pom, "%s",  gettext("Random"));
		else
			sprintf(pom, "%d", i);

		row = gtk_clist_append(GTK_CLIST(propinfo->shader),
			(gchar **)&p);
		gtk_clist_set_row_data(GTK_CLIST(propinfo->shader),
			row, (gpointer)i);
	}
	gtk_widget_show(propinfo->shader);
	gtk_clist_select_row(GTK_CLIST(propinfo->shader),
		propinfo->prop->shade, 0);
	gtk_clist_moveto(GTK_CLIST(propinfo->shader),
		propinfo->prop->shade, 0, 0.0 ,0.0);

	gtk_signal_connect(GTK_OBJECT(propinfo->shader), "select_row",
		GTK_SIGNAL_FUNC(ClrSetSensitive), propinfo);

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Background"));
	gtk_notebook_append_page(GTK_NOTEBOOK(propinfo->notebook), box, label);

	pbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);
/*
	propinfo->clr_sens[0] = pbox;
*/

	label = gtk_label_new(gettext("Background coloring mode: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, FALSE, 1);
	gtk_widget_show(label);

	propinfo->use_grad = gtk_option_menu_new();
	SET_TOOLTIP(propinfo->use_grad, gettext(
		"Choose if for shading backround use only two "
		"blended colors, free colored GIMP gradients or "
		"tiled pictures."));

	menu = gtk_menu_new();

	mi = gtk_menu_item_new_with_label(gettext("Colors"));
	gtk_widget_show(mi);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_object_set_user_data(GTK_OBJECT(mi), (gpointer) SHADE_COLORS);

	mi = gtk_menu_item_new_with_label(gettext("Tiles"));
	gtk_widget_show(mi);
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_object_set_user_data(GTK_OBJECT(mi), (gpointer) SHADE_TILES);

	if (cfg.grads)
	{
		mi = gtk_menu_item_new_with_label(gettext("Gradient"));
		gtk_widget_show(mi);
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_object_set_user_data(GTK_OBJECT(mi), (gpointer) SHADE_GRADIENTS);
	}

	gtk_option_menu_set_menu(GTK_OPTION_MENU(propinfo->use_grad), menu);
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->use_grad, FALSE, FALSE, 1);
	gtk_widget_show(propinfo->use_grad);
	
	propinfo->rand_colors = gtk_check_button_new_with_label(
		gettext("Randomize background colors"));
	SET_TOOLTIP(propinfo->rand_colors, gettext(
		"Hint: Choose this option, hit checkmark Apply Setup Changes "
		",choose Tools/Shaders preview page to see random two colored "
		"shading effects each time it's open."));
	gtk_box_pack_start(GTK_BOX(box), propinfo->rand_colors, FALSE, TRUE, 1);
	gtk_widget_show(propinfo->rand_colors);

	pbox = gtk_table_new(4, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Background color: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(pbox), label, 0, 1, 0, 1,
		GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	propinfo->background = gtk_color_button_new();
	gtk_color_button_set_title(GTK_COLOR_BUTTON(propinfo->background),
		gettext(propinfo->ismain ?
			"ChBg: Select background color 1" :
			"ChBg: Properties - select background color 1"));
	gtk_table_attach(GTK_TABLE(pbox), propinfo->background, 1, 2, 0, 1,
		GTK_EXPAND | GTK_FILL, GTK_EXPAND, 2, 2);
	gtk_widget_show(propinfo->background);

	label = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(pbox), label, 2, 3, 0, 1, GTK_FILL|GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	gtk_signal_connect(GTK_OBJECT(propinfo->background), "color_changed" ,
		GTK_SIGNAL_FUNC(set_color_label), label);

	label = gtk_label_new(gettext("Background color2: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(pbox), label, 0, 1, 1, 2, GTK_FILL|GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	propinfo->clr_sens[1] = label;

	propinfo->background2 = gtk_color_button_new();
	gtk_color_button_set_title(GTK_COLOR_BUTTON(propinfo->background2),
		gettext(propinfo->ismain ?
			"ChBg: Select background color 2" :
			"ChBg: Properties - select background color 2"));
	SET_TOOLTIP(propinfo->background2, gettext(
		"This background color applies only "
		"when background shading is enabled."));
	gtk_table_attach(GTK_TABLE(pbox), propinfo->background2, 1, 2, 1, 2,
		GTK_EXPAND | GTK_FILL, GTK_EXPAND, 2, 2);
	gtk_widget_show(propinfo->background2);

	propinfo->clr_sens[2] = propinfo->background2;

	label = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(pbox), label, 2, 3, 1, 2,
		GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	propinfo->clr_sens[3] = label;

	gtk_signal_connect(GTK_OBJECT(propinfo->background2), "color_changed" ,
		GTK_SIGNAL_FUNC(set_color_label), label);

	ntbk = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(ntbk), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(ntbk), TRUE);
	gtk_box_pack_start(GTK_BOX(box), ntbk, TRUE, TRUE, 5);
	gtk_widget_show(ntbk);

	if (cfg.grads)
	{
		
		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		gtk_widget_show (swin);
		label = gtk_label_new(gettext("GIMP gradients"));
		gtk_notebook_append_page(GTK_NOTEBOOK(ntbk), swin, label);

		propinfo->clr_sens[4] = swin;

		propinfo->grad = gtk_clist_new(1);
		gtk_clist_set_column_title(GTK_CLIST(propinfo->grad), 0,
				gettext("Gradient"));
		gtk_clist_column_titles_show(GTK_CLIST(propinfo->grad));
		SET_TOOLTIP((gtk_clist_get_column_widget(GTK_CLIST(propinfo->grad), 0))->parent,
			gettext("Various GIMP gradients which should be used for coloring background shading effects."));
		gtk_clist_set_selection_mode(GTK_CLIST(propinfo->grad),
			GTK_SELECTION_BROWSE);
		gtk_container_add(GTK_CONTAINER(swin), propinfo->grad);

		p = gettext("Random");
		gtk_clist_append(GTK_CLIST(propinfo->grad), (gchar **)&p);
		for (ptr = cfg.grads ; ptr ; ptr = ptr->next)
		{
			guint row;
			gradient_t *gr = (gradient_t *)ptr->data;
			GdkPixmap *gpm;

			p = strrchr(gr->filename, '/');
			if (p) p++;
			else p = gr->filename;

			row = gtk_clist_append(GTK_CLIST(propinfo->grad),
				(gchar **)&p);

			gpm = grad_render(gr, 13);

			gtk_clist_set_pixtext(GTK_CLIST(propinfo->grad),
				row, 0, p, 15, gpm, NULL);
			gdk_pixmap_unref(gpm);
			gtk_clist_set_row_data(GTK_CLIST(propinfo->grad), row,
				ptr->data);
		}
		gtk_widget_show(propinfo->grad);
		gtk_clist_select_row(GTK_CLIST(propinfo->grad),
			propinfo->prop->gradnr, 0);
		gtk_clist_moveto(GTK_CLIST(propinfo->grad),
			propinfo->prop->gradnr, 0, 0.0 ,0.0);
	}
	else
	{
		propinfo->clr_sens[4] = NULL;
	}

	pbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(pbox);
	label = gtk_label_new(gettext("Tiles"));
	gtk_notebook_append_page(GTK_NOTEBOOK(ntbk), pbox, label);

	if (propinfo->ismain)
	{
		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start(GTK_BOX(pbox), swin, TRUE, TRUE, 0);
		gtk_widget_show(swin);

		propinfo->tiles = gtk_clist_new(1);
		gtk_clist_set_column_title(GTK_CLIST(propinfo->tiles), 0,
				gettext("Tiles"));
		gtk_clist_column_titles_show(GTK_CLIST(propinfo->tiles));
		SET_TOOLTIP((gtk_clist_get_column_widget(GTK_CLIST(propinfo->tiles), 0))->parent,
			gettext("Various tilable pixmaps for picture background."));
		gtk_clist_set_selection_mode(GTK_CLIST(propinfo->tiles),
			GTK_SELECTION_BROWSE);
		gtk_container_add(GTK_CONTAINER(swin), propinfo->tiles);
		gtk_widget_show(propinfo->tiles);

		prow = gtk_hbutton_box_new();
		gtk_box_pack_start(GTK_BOX(pbox), prow, FALSE, FALSE, 5);
		gtk_widget_show(prow);

		button = guitl_pixmap_button(stock_append_xpm,
			gettext("Append"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(AppendTileDlg), NULL);

		button = guitl_pixmap_button(stock_delete_xpm, gettext("Delete"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(DeleteTile), NULL);

		button = guitl_pixmap_button(stock_clear_xpm, gettext("Clear"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ClearTiles), NULL);

		menu = gtk_menu_new();
		gtk_widget_realize(menu);
		guitl_menu_attach(menu, toplevel_window);

		mi = gtk_menu_item_new_with_label(gettext("View picture ..."));
		gaccel_bind_widget("tile_list/view", "activate", mi,
			NULL, toplevel_window);
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(BannerView),
			propinfo->tiles);

		gtk_signal_connect(GTK_OBJECT(propinfo->tiles),
			"button_press_event", GTK_SIGNAL_FUNC(PopupMenu),
			(gpointer)menu);
	}
	else
	{
		prow = gtk_hbox_new(FALSE, 3);
		gtk_box_pack_start(GTK_BOX(pbox), prow, FALSE, FALSE, 5);
		gtk_widget_show(prow);

		label = gtk_label_new(gettext("Tile: "));
		gtk_box_pack_start(GTK_BOX(prow), label, FALSE, FALSE, 0);
		gtk_widget_show(label);
		
		propinfo->tiles = gtk_combo_new();
		update_prop_tiles_combo();
		gtk_box_pack_start(GTK_BOX(prow), propinfo->tiles,
			TRUE, TRUE, 0);
		gtk_widget_show(propinfo->tiles);

		gtk_signal_connect(GTK_OBJECT(propinfo->tiles), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &propinfo->tiles);
	}

	pbox = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(pbox);
	label = gtk_label_new(gettext("Banners"));
	gtk_notebook_append_page(GTK_NOTEBOOK(propinfo->notebook), pbox, label);

	propinfo->use_banner = gtk_check_button_new_with_label(
		gettext("Use banners"));
	gtk_box_pack_start(GTK_BOX(pbox), propinfo->use_banner, FALSE, FALSE, 0);
	gtk_widget_show(propinfo->use_banner);

	if (propinfo->ismain)
	{
		propinfo->banner_prop.prop = &cfg.properties.banner_prop;
		build_banner_props(pbox, &propinfo->banner_prop);

		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start(GTK_BOX(pbox), swin, TRUE, TRUE, 0);
		gtk_widget_show(swin);

		propinfo->banners = gtk_clist_new(1);
		gtk_clist_set_column_title(GTK_CLIST(propinfo->banners), 0, gettext("Banners"));
		gtk_clist_column_titles_show(GTK_CLIST(propinfo->banners));
		SET_TOOLTIP((gtk_clist_get_column_widget(GTK_CLIST(propinfo->banners), 0))->parent,
			gettext("Banners which will be drawn on top of background picture."));
		gtk_clist_set_selection_mode(GTK_CLIST(propinfo->banners),
			GTK_SELECTION_BROWSE);
		gtk_container_add(GTK_CONTAINER(swin), propinfo->banners);
		gtk_widget_show(propinfo->banners);

		prow = gtk_hbutton_box_new();
		gtk_box_pack_start(GTK_BOX(pbox), prow, FALSE, FALSE, 5);
		gtk_widget_show(prow);

		button = guitl_pixmap_button(stock_append_xpm,
			gettext("Append"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(AppendBannersDlg), NULL);

		button = guitl_pixmap_button(stock_delete_xpm, gettext("Delete"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(DeleteBanner), NULL);

		button = guitl_pixmap_button(stock_clear_xpm, gettext("Clear"));
		gtk_container_add(GTK_CONTAINER(prow), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(ClearBanners), NULL);

		menu = gtk_menu_new();
		gtk_widget_realize(menu);
		guitl_menu_attach(menu, toplevel_window);

		mi = gtk_menu_item_new_with_label(gettext("Set properties ..."));
		gaccel_bind_widget("banner_list/properties", "activate", mi,
			NULL, toplevel_window);
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(BannerSetProperties),
			propinfo->banners);

		mi = gtk_menu_item_new_with_label(gettext("View picture ..."));
		gaccel_bind_widget("banner_list/view", "activate", mi,
			NULL, toplevel_window);
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_widget_show(mi);

		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(BannerView),
			propinfo->banners);

		gtk_signal_connect(GTK_OBJECT(propinfo->banners),
			"button_press_event", GTK_SIGNAL_FUNC(PopupMenu),
			(gpointer)menu);
	}
	else
	{
		prow = gtk_hbox_new(FALSE, 3);
		gtk_box_pack_start(GTK_BOX(pbox), prow, FALSE, FALSE, 5);
		gtk_widget_show(prow);

		label = gtk_label_new(gettext("Tile: "));
		gtk_box_pack_start(GTK_BOX(prow), label, FALSE, FALSE, 0);
		gtk_widget_show(label);
		
		propinfo->banners = gtk_combo_new();
		update_prop_banners_combo();
		gtk_box_pack_start(GTK_BOX(prow), propinfo->banners,
			TRUE, TRUE, 0);
		gtk_widget_show(propinfo->banners);

		gtk_signal_connect(GTK_OBJECT(propinfo->banners), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &propinfo->banners);
	}
}

static void choose_window(w, entry)
GtkWidget *w;
GtkWidget *entry;
{
	glong win;
	char pom[32];

	win = chwin_get_window();
	sprintf(pom, "0x%08lx", win);
	gtk_entry_set_text(GTK_ENTRY(entry), pom);
}

static void build_mode(notebook)
GtkWidget *notebook;
{
	GSList *rg;
	GtkWidget *rb, *frame, *col, *button;
	GtkWidget *box, *label, *pbox;

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Mode"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	frame = gtk_frame_new(gettext("Display mode"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 1);
	gtk_widget_show(frame);

	col = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(frame), col);
	gtk_widget_show(col);

	rg = NULL;
	rb = gtk_radio_button_new_with_label(rg,
		gettext("Run in desktop background (root) window"));
	SET_TOOLTIP(rb, gettext("Enable this option to let "
				"ChBg manage your desktop background."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_box_pack_start(GTK_BOX(col), rb, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(rb), TRUE);
	gtk_widget_show(rb);

	inwindow = gtk_radio_button_new_with_label(rg,
		gettext("Run in own window"));
	SET_TOOLTIP(inwindow, gettext(
		"Runs in it's own window and doesn't change "
		"the root background (X11 Wallpaper).\n"
		"Use spacebar to skip forward to next picture, "
		"and Q key to hide the window."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(inwindow));
	gtk_box_pack_start(GTK_BOX(col), inwindow, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(inwindow), cfg.inwindow);
	gtk_widget_show(inwindow);

	infwindow = gtk_radio_button_new_with_label(rg,
		gettext("Run in foreign window"));
	SET_TOOLTIP(infwindow, gettext(
		"Runs in any selected window in your desktop"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(infwindow));
	gtk_box_pack_start(GTK_BOX(col), infwindow, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(infwindow), cfg.infwindow);
	gtk_widget_show(infwindow);


	screensaver = gtk_radio_button_new_with_label(rg,
		gettext("Act as screensaver"));
	SET_TOOLTIP(screensaver, gettext(
		"Click mouse once to quit screensaver mode. "
		"Runs in full-screen mode."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(screensaver));
	gtk_box_pack_start(GTK_BOX(col), screensaver, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(screensaver),
		cfg.screensaver);
	gtk_widget_show(screensaver);

#ifdef HAVE_XSS_SUPPORT
	xscreensaver = gtk_radio_button_new_with_label(rg,
		gettext("Act as xscreensaver hack"));
	SET_TOOLTIP(xscreensaver, gettext(
		"This option is usable to generate ChBg scenario files "
		"for use with Xscreensaver.\n"
		"When using directly from this ChBg setup, it will "
		"not work."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(xscreensaver));
	gtk_box_pack_start(GTK_BOX(col), xscreensaver, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(xscreensaver),
		cfg.xscreensaver);
	gtk_widget_show(xscreensaver);
#endif

#ifdef HAVE_ENLIGHTENMENT_SUPPORT
	enlightenment = gtk_radio_button_new_with_label(rg,
		gettext("Set desktop background via Enlightenment (0.16<)"));
	SET_TOOLTIP(enlightenment, gettext(
		"When you will select this option, "
		"ChBg will attempt to use Enlightenemnt WM capabilities "
		"to manage background of your desktop."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(enlightenment));
	gtk_box_pack_start(GTK_BOX(col), enlightenment, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enlightenment),
		cfg.use_ebg);
	gtk_widget_show(enlightenment);
	gtk_widget_set_sensitive(enlightenment, check_for_enlightenment());
#endif

	tofile = gtk_radio_button_new_with_label(rg,
		gettext("Generate picture into PNG file"));
	SET_TOOLTIP(tofile, gettext(
		"Store composed picture to file instead of setting "
		"desktop window background\n"
		"Don't forget to set the file informations below."));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(tofile));
	gtk_box_pack_start(GTK_BOX(col), tofile, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tofile), cfg.tofile);
	gtk_widget_show(tofile);

	frame = gtk_frame_new(gettext("PNG file rendering infos"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 1);
	gtk_widget_show(frame);

	gtk_signal_connect(GTK_OBJECT(tofile), "toggled",
			GTK_SIGNAL_FUNC(ToggleBool), (gpointer)frame);

	pbox = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), pbox);
	gtk_widget_show(pbox);

	outfile = guitl_tab_add_path_entry(pbox, gettext("File name: "),
			0, 0, FALSE);

	outfile_width = guitl_tab_add_numentry(pbox, gettext("Width: "), NULL,
			0, 1, 0, 1, 10, 1, 9999, cfg.outfile_width);

	outfile_height = guitl_tab_add_numentry(pbox, gettext("Height: "), NULL,
			0, 2, 0, 1, 10, 1, 9999, cfg.outfile_height);

	ToggleBool(tofile, frame);

	frame = gtk_frame_new(gettext("Foreign window infos"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 1);
	gtk_widget_show(frame);

	gtk_signal_connect(GTK_OBJECT(infwindow), "toggled",
			GTK_SIGNAL_FUNC(ToggleBool), (gpointer)frame);

	pbox = gtk_table_new(3, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), pbox);
	gtk_widget_show(pbox);

	windowid = guitl_tab_add_entry(pbox, gettext("Window ID: "),
			0, 0, FALSE);

	button = guitl_pixmap_button(stock_choose_xpm, gettext("Choose ..."));
	gtk_table_attach(GTK_TABLE(pbox), button, 2, 3, 0, 1,
			GTK_FILL, GTK_FILL, 2, 2);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(choose_window), (gpointer)windowid);

	gtk_widget_show(button);

#ifdef HAVE_XSS_SUPPORT
	send_expose = gtk_check_button_new_with_label(
		gettext("Send expose event to window"));
	gtk_table_attach(GTK_TABLE(pbox), send_expose, 0, 3, 1, 2,
			GTK_FILL, GTK_FILL, 2, 2);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(send_expose),
		cfg.send_expose);
	gtk_widget_show(send_expose);
#endif

	ToggleBool(infwindow, frame);
}

static void build_setup(notebook)
GtkWidget *notebook;
{
	GtkWidget *box, *label, *pbox, *frame;
	GtkWidget *menu, *mi;
	gint i;

	box = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Setup"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	frame = gtk_frame_new(gettext("Miscelanous settings"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	box = gtk_vbox_new (FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame), box);
	gtk_widget_show(box);

	fake_nautilus = gtk_check_button_new_with_label(
		gettext("Force background to Nautilus "));
	gtk_box_pack_start(GTK_BOX(box), fake_nautilus, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(fake_nautilus),
		cfg.fake_nautilus);
	gtk_widget_show(fake_nautilus);

	randomized = gtk_check_button_new_with_label(
		gettext("Randomize picture order"));
	gtk_box_pack_start(GTK_BOX(box), randomized, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(randomized),
		cfg.randomize);
	gtk_widget_show(randomized);

	blank = gtk_check_button_new_with_label(
		gettext("Show blank screen when unable to load picture"));
	SET_TOOLTIP(blank, gettext(
		"Useful for determining whether you "
		"have files in your picture list "
		"which either images which imlib can\'t "
		"handle or the files are not "
		"images such as html, text, etc."));
	gtk_box_pack_start(GTK_BOX(box), blank, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(blank), cfg.blank);
	gtk_widget_show(blank);

	cycle_blank = gtk_check_button_new_with_label(
		gettext("Cycle blank screens"));
	SET_TOOLTIP(cycle_blank, gettext(
		"HINT: To see only pure shading effects, "
		"enable this option, clear picture list and "
		"select random shading effect."));

	gtk_box_pack_start(GTK_BOX(box), cycle_blank, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cycle_blank),
		cfg.cycle_blank);
	gtk_widget_show(cycle_blank);

	remember_last = gtk_check_button_new_with_label(
		gettext("Remember last picture"));
	SET_TOOLTIP(remember_last, gettext(
		"Usefull when you maintain long picture lists "
		"and you want to start next time where you stops"));

	gtk_box_pack_start(GTK_BOX(box), remember_last, FALSE, TRUE, 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(remember_last),
		cfg.remember_last);
	gtk_widget_show(remember_last);

	pbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Picture changing effect speed ratio: "));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, TRUE, 5);
	gtk_widget_show(label);

	speed = gtk_option_menu_new();
	SET_TOOLTIP(speed, gettext(
		"Used to change the speed of picture changing effects.\n"
		"On slow machines choose faster and on very fast machines "
		"choose slower."));
	gtk_box_pack_start(GTK_BOX(pbox), speed, FALSE, TRUE, 5);

	menu = gtk_menu_new();

	for (i = 0 ; i < sizeof(speed_table)/sizeof(*speed_table); i++)
	{
		mi = gtk_menu_item_new_with_label(gettext(speed_table[i].label));
		gtk_widget_show(mi);
		gtk_menu_append(GTK_MENU(menu), mi);
		gtk_object_set_user_data(GTK_OBJECT(mi),
			(gpointer)speed_table[i].speed);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(speed), menu);
	gtk_widget_show(speed);

	pbox = gtk_table_new(3, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, TRUE, 1);
	gtk_widget_show(pbox);

	fract_iter = guitl_tab_add_numentry(pbox,
		gettext("Number of iterations in fractal-based effects: "),
		NULL, 0, 0, 0, 1.0, 10.0, 2.0, 1000000.0,
		(gfloat)cfg.fract_iter);
	SET_TOOLTIP(fract_iter, gettext(
		"Useful for speedup all fractalbased background "
		"shading effects or to generate more detailed fractals."));

	box_size = guitl_tab_add_numentry(pbox,
		gettext("Picture changing effects rectangle size: "),
		NULL, 0, 1, 0, 1.0, 10.0, 1.0, 1000000.0,
		(gfloat)cfg.box_size);
	SET_TOOLTIP(box_size, gettext(
		"Useful for speedup picture changing "
		"effects which uses rectangles."));
}

static void ListSet(w, v)
GtkWidget *w;
gboolean v;
{
	GList *ptr;

	for (ptr = GTK_LIST(w)->children; ptr; ptr = ptr->next)
	{
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(GTK_BIN(ptr->data)->child), v);
	}

}

static void ListSelAll(w, list)
GtkWidget *w;
GtkWidget *list;
{
	ListSet(list, TRUE);
}

static void ListUnselAll(w, list)
GtkWidget *w;
GtkWidget *list;
{
	ListSet(list, FALSE);
}

void build_effects(notebook)
GtkWidget *notebook;
{
	GtkWidget *box, *swin, *frame, *li, *chb, *label;
	GtkWidget *menu, *mi;
	int i;

	box = gtk_vbox_new (TRUE, 5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Random effects"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	frame = gtk_frame_new(gettext("Enabled changing effects in random mode"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 5);
	gtk_widget_show(frame);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(frame), swin);
	gtk_widget_show (swin);

	d_efect = gtk_list_new();

	menu = gtk_menu_new();
	gtk_widget_realize(menu);

	mi = gtk_menu_item_new_with_label(gettext("Select all"));
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ListSelAll), (gpointer) d_efect);

	mi = gtk_menu_item_new_with_label(gettext("Unselect all"));
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ListUnselAll), (gpointer) d_efect);

	SET_TOOLTIP(d_efect, gettext(
		"Eliminate unwanted Picture changing "
		"effects [2-29] when randomizing."));
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin),
		d_efect);
	for (i = 2 ; i <= CHBG_EFECTS ; i++)
	{
		li = gtk_list_item_new();
		gtk_object_set_user_data(GTK_OBJECT(li), (gpointer)i);
		gtk_container_add(GTK_CONTAINER(d_efect), li);
		gtk_widget_show(li);

		chb = gtk_check_button_new_with_label(gettext(effect_texts[i]));
		gtk_container_add(GTK_CONTAINER(li), chb);
		gtk_widget_show(chb);

		gtk_signal_connect(GTK_OBJECT(chb), "button_press_event",
			GTK_SIGNAL_FUNC(PopupMenu), menu);
	}
	gtk_widget_show(d_efect);

	frame = gtk_frame_new(gettext("Enabled shading effects in random mode"));
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 5);
	gtk_widget_show(frame);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(frame), swin);
	gtk_widget_show (swin);

	d_shader = gtk_list_new();

	menu = gtk_menu_new();
	gtk_widget_realize(menu);

	mi = gtk_menu_item_new_with_label(gettext("Select all"));
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ListSelAll), (gpointer) d_shader);

	mi = gtk_menu_item_new_with_label(gettext("Unselect all"));
	gtk_menu_append(GTK_MENU(menu), mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi), "activate",
		GTK_SIGNAL_FUNC(ListUnselAll), (gpointer) d_shader);

	SET_TOOLTIP(d_shader, gettext(
		"Eliminate unwanted Background shading "
		"effects [2-62] when randomizing."));
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin),
		d_shader);
	for (i = 2 ; i <= shader_get_cnt() ; i++)
	{
		char pom[100];

		sprintf(pom, "%d", i);

		li = gtk_list_item_new();
		gtk_object_set_user_data(GTK_OBJECT(li), (gpointer)i);
		gtk_container_add(GTK_CONTAINER(d_shader), li);
		gtk_widget_show(li);

		chb = gtk_check_button_new_with_label(pom);
		gtk_container_add(GTK_CONTAINER(li), chb);
		gtk_widget_show(chb);

		gtk_signal_connect(GTK_OBJECT(chb), "button_press_event",
			GTK_SIGNAL_FUNC(PopupMenu), menu);
	}
	gtk_widget_show(d_shader);
}

static void build_prop(notebook)
GtkWidget *notebook;
{
	memset(&main_propinfo, '\0', sizeof(main_propinfo));
	main_propinfo.ismain = TRUE;
	main_propinfo.notebook = notebook;
	main_propinfo.prop = &cfg.properties;

	build_propt(&main_propinfo);
}

static void build_statusbar(notebook)
GtkWidget *notebook;
{
	GtkWidget *row,*col,*label,*frame;

	col = gtk_vbox_new (FALSE, 5);
	gtk_widget_show(col);
	label = gtk_label_new(gettext("Status"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), col, label);

	frame = gtk_frame_new(gettext("Picture informations"));
	gtk_box_pack_start(GTK_BOX(col), frame, FALSE, FALSE, 1);
	gtk_widget_show(frame);
	
	row = gtk_table_new(2, 6, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), row);
	gtk_widget_show(row);

	label = gtk_label_new(gettext("Status:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status,
		1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status);


	label = gtk_label_new(gettext("Image:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 1, 2, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status_image = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status_image), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status_image,
		1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status_image);


	label = gtk_label_new(gettext("Effect: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 2, 3, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status_effect = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status_effect), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status_effect,
		1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status_effect);


	label = gtk_label_new(gettext("Shader: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 3, 4, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status_shader = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status_shader), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status_shader,
		1, 2, 3, 4, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status_shader);

	if (cfg.grads)
	{
		label = gtk_label_new(gettext("Gradient: "));
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_table_attach(GTK_TABLE(row), label,
			0, 1, 4, 5, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
		gtk_widget_show(label);

		status_grad = gtk_label_new("");
		gtk_misc_set_alignment(GTK_MISC(status_grad), 0.0, 0.5);
		gtk_table_attach(GTK_TABLE(row), status_grad,
			1, 2, 4, 5, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
		gtk_widget_show(status_grad);
	}
	else
		status_grad = NULL;

	label = gtk_label_new(gettext("Banner: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 5, 6, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status_banner = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status_banner), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status_banner,
		1, 2, 5, 6, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status_banner);

	label = gtk_label_new(gettext("Tille: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), label,
		0, 1, 6, 7, GTK_FILL | GTK_SHRINK, GTK_FILL, 5, 5);
	gtk_widget_show(label);

	status_tile = gtk_label_new("");
	gtk_misc_set_alignment(GTK_MISC(status_tile), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(row), status_tile,
		1, 2, 6, 7, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(status_tile);

	progres = gtk_progress_bar_new();
	gtk_table_attach(GTK_TABLE(row), progres,
		0, 2, 7, 8, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5);
	gtk_widget_show(progres);
}

#define ServeEvents if (stop_changing) return; else while (gtk_events_pending()) gtk_main_iteration();

static int status_clear(ptid)
gint *ptid;
{
	if (*ptid)
	{
		gtk_timeout_remove(*ptid);
		*ptid = 0;
	}
	gtk_label_set_text(GTK_LABEL(status), "");

	return FALSE;
}

void chbg_status_what(str, timeout)
char *str;
int timeout;
{
	static gint stid = 0;

	if (stid)
		gtk_timeout_remove(stid);

	if (!toplevel_window) return;

	if (str)
		gtk_label_set_text(GTK_LABEL(status), str);

	ServeEvents

	if (timeout)
		stid = gtk_timeout_add(timeout * 1000,
			(GtkFunction) status_clear, &stid); 
}

void chbg_status_set(image, prop)
char *image;
prop_t *prop;
{
	char pom[1000];
	char *p;
	GSList *ptr;
	
	if (!toplevel_window) return;

	if (prop->use_grad && cfg.grads)
	{
		ptr = g_slist_nth(cfg.grads, prop->gradnr-1);
		p = ((gradient_t *)ptr->data)->filename;

		sprintf(pom, gettext("%s"), p);
	}
	else
	{
		sprintf(pom, gettext("none"));
	}
	gtk_label_set_text(GTK_LABEL(status_grad), pom);

	
	if (prop->efect)
		sprintf(pom, "%d", prop->efect);
	else
		sprintf(pom, gettext("none"));

	gtk_label_set_text(GTK_LABEL(status_effect), pom);

	if (prop->shade)
		sprintf(pom, "%d", prop->shade);
	else
		sprintf(pom, gettext("none"));
	gtk_label_set_text(GTK_LABEL(status_shader), pom);

	
	gtk_label_set_text(GTK_LABEL(status_tile),
		(prop->tile && prop->use_tiles) ? prop->tile : gettext("none"));

	gtk_label_set_text(GTK_LABEL(status_banner),
		(prop->banner && prop->use_banners) ? prop->banner : gettext("none"));

	gtk_label_set_text(GTK_LABEL(status_image), image ? image : gettext("none"));

	ServeEvents
}

void chbg_status_clear()
{
	if (!toplevel_window) return;

	gtk_label_set_text(GTK_LABEL(status_image), "");
	gtk_label_set_text(GTK_LABEL(status_effect), "");
	gtk_label_set_text(GTK_LABEL(status_shader), "");
	gtk_label_set_text(GTK_LABEL(status_banner), "");
	gtk_label_set_text(GTK_LABEL(status_tile), "");
	if (status_grad) gtk_label_set_text(GTK_LABEL(status_grad), "");
	ServeEvents
}

void chbg_status_progress(n, from)
int n;
int from;
{
	if (!toplevel_window) return;

	gtk_progress_bar_update(GTK_PROGRESS_BAR(progres),
		((gfloat)n)/(gfloat)from);
	ServeEvents
}

void run_setup(argc, argv)
guint *argc;
gchar ***argv;
{
	GtkWidget *col, *notebook, *sep;

	gtk_init(argc, argv);

	cfg_load_prop();
	cfg_add_default_prop();
	lastscn_fill();
	cfg.once = FALSE;

	toplevel_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	set_title();
	gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
		GTK_SIGNAL_FUNC(Quit), NULL);
	gtk_signal_connect(GTK_OBJECT(toplevel_window), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &toplevel_window);

	chbg_tooltips = gtk_tooltips_new();

	col = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(toplevel_window), col);
	gtk_widget_show(col);

	build_menu(col);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_start(GTK_BOX(col), sep, FALSE, TRUE, 1);

	build_toolbar(col);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
	gtk_box_pack_start(GTK_BOX(col), notebook, TRUE, TRUE, 1);
	gtk_widget_show (notebook);

	build_mode(notebook);
	build_setup(notebook);
	build_prop(notebook);
	build_picture_list(notebook);
	build_effects(notebook);
	build_statusbar(notebook);

	if (!cfg.thumb)
	{
		gtk_widget_show(toplevel_window);	
		set_cfg();

		if (cfg.runit)
			Run(NULL);
	}
	else
	{
		set_cfg();

		switch (cfg.thumb)
		{
			case THUMB_ALL:
				ThumbPreview();
			break;
			case THUMB_DIR:
				ThumbPreviewPerDir();
			break;
			case THUMB_PAGE:
				ThumbPreviewPerPage();
			break;
			default:
			break;
		}
	}

	gtk_main();

	lastscn_flush();
	cfg_save_prop();

	if (toplevel_window)
	{
		get_cfg();
 		gtk_widget_destroy(toplevel_window);
	}

}

