#!/bin/sh

# this script assumes you have QT/Mac built with "./configure -prefix /usr/local/qt -platform macx-g++"
# and that you are using libsigc++ installed from Fink (http://fink.sf.net/).  If this is not your config,
# modify these exports accordingly

export QTDIR=/usr/local/qt
export FINKDIR="/sw"

scons || exit 1

mkdir -p CheeseTracker.app/Contents/MacOS
mkdir -p CheeseTracker.app/Contents/Resources
cp icons/cheesetracker.icns CheeseTracker.app/Contents/Resources

APP_VERSION=`grep '#define APP_VERSION_' ./interface__QT/mdi_main_window.cpp | cut -d\" -f2 | sed -e 's,^v,,'`

cat <<END > CheeseTracker.app/Contents/Info.plist
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist SYSTEM "file://localhost/System/Library/DTDs/PropertyList.dtd">
<plist version="0.9">
<dict>
        <key>CFBundleIconFile</key>
        <string>cheesetracker.icns</string>
        <key>CFBundlePackageType</key>
        <string>APPL</string>
        <key>CFBundleGetInfoString</key>
        <string>CheeseTracker</string>
        <key>CFBundleSignature</key>
        <string>ttxt</string>
        <key>CFBundleName</key>
        <string>CheeseTracker</string>
        <key>CFBundleVersion</key>
        <string>$APP_VERSION</string>
        <key>CFBundleShortVersionString</key>
        <string>CheeseTracker $APP_VERSION</string>
        <key>CSResourcesFileMapped</key>
        <true/>
</dict>
</plist>
END

echo "APPL????" > CheeseTracker.app/Contents/PkgInfo

# copy the dynamic libraries and executable
install -m 755 $QTDIR/lib/libqt-mt.3.dylib CheeseTracker.app/Contents/MacOS/libqt-mt.3.dylib || exit 2
install -m 755 $FINKDIR/lib/libsigc-1.2.5.dylib CheeseTracker.app/Contents/MacOS/libsigc-1.2.5.dylib || exit 3
install -m 755 $FINKDIR/lib/libdl.0.dylib CheeseTracker.app/Contents/MacOS/libdl.0.dylib || :
install -m 755 program__QT/cheesetracker_qt CheeseTracker.app/Contents/MacOS/cheesetracker || exit 4

# fix the install_name of the libraries
install_name_tool -id libqt-mt.3.dylib CheeseTracker.app/Contents/MacOS/libqt-mt.3.dylib || exit 5
install_name_tool -id libsigc-1.2.5.dylib CheeseTracker.app/Contents/MacOS/libsigc-1.2.5.dylib || exit 6
install_name_tool -id libdl.0.dylib CheeseTracker.app/Contents/MacOS/libdl.0.dylib || exit 7

# fix the references to the libraries in the executable
old_qt_name=`otool -L CheeseTracker.app/Contents/MacOS/cheesetracker 2>/dev/null | grep libqt | awk '{ print $1 }'`
old_sigc_name=`otool -L CheeseTracker.app/Contents/MacOS/cheesetracker 2>/dev/null | grep libsigc | awk '{ print $1 }'`
old_dl_name=`otool -L CheeseTracker.app/Contents/MacOS/cheesetracker 2>/dev/null | grep libdl | awk '{ print $1 }'`

[ -n "$old_qt_name"   ] && install_name_tool -change "$old_qt_name" '@executable_path/libqt-mt.3.dylib' CheeseTracker.app/Contents/MacOS/cheesetracker || exit 20
[ -n "$old_sigc_name" ] && install_name_tool -change "$old_sigc_name" '@executable_path/libsigc-1.2.5.dylib' CheeseTracker.app/Contents/MacOS/cheesetracker || exit 21
[ -n "$old_dl_name"   ] && install_name_tool -change "$old_dl_name" '@executable_path/libdl.0.dylib' CheeseTracker.app/Contents/MacOS/cheesetracker || exit 22

# copy the ladspa plugins to the bundle
install -m 755 -d CheeseTracker.app/Contents/Resources/ladspa
if [ -d "$FINKDIR/lib/ladspa" ]; then
	for FILE in $FINKDIR/lib/ladspa/*; do
		install -m 755 "$FILE" CheeseTracker.app/Contents/Resources/ladspa/
	done
fi

echo fin.
