/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          midi_voice.h  -  description
                             -------------------
    begin                : vie nov 1 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDI_VOICE_H
#define MIDI_VOICE_H

#include "voice.h"

/**
  *@author Juan Linietsky
  */

class Midi_Voice : public Voice  {
public:
       	virtual void set_channel(int p_channel)=0;

	virtual void set_note_on(char p_note,char p_volume)=0;
	virtual void set_note_off(char p_note,char p_volume)=0;

	virtual void set_pitch_bender(int p_bender)=0;
	virtual void set_channel_aftertouch(char p_aftertouch)=0;
	virtual void set_note_aftertouch(char p_aftertouch)=0;

	virtual void set_controller(char p_cc_index,char p_cc_val)=0;

	virtual void set_rpn(int p_index,int p_data)=0; //both index & data 14 bits
	virtual void set_nrpn(int p_index,int p_data)=0; //both index & data 14 bits
	
	

};

#endif
