/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          engine_manager.h  -  description
                             -------------------
    begin                : vie nov 1 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENGINE_MANAGER_H
#define ENGINE_MANAGER_H

#include "engine.h"

#include <vector>

	using std::vector;
/**
  *@author Juan Linietsky
  */

class Engine_Manager {

	vector<Engine*> engine_list;

	
	struct Bank { //relationship table bank -> engine

		int engine_index;
		int engine_bank_index;
	};

	vector<Bank> bank_list;

public:

	int get_engine_count(); //get how many engines are aviable
	string get_engine_name(int p_index); //get the name of each
	
	void add_bank(int p_engine_index); //create a new bank in one
	int get_bank_count();

//	void load_bank(string p_filename); //functions like this can be added

        Midi_Voice *get_midi_voice(int p_bank,int p_patch); //if bank or patch are invalid, returns null
	Midi_Voice * get_midi_drum_voice(int p_bank,int p_drum_bank,char p_instrument);


	void register_engine(Engine *p_engine);
	Engine_Manager();
	~Engine_Manager();
};

#endif
