//
// C++ Implementation: effect_amp
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "effect_amp.h"


#define FIXED_BITS 8
#define FIXED_LENGTH (1<<FIXED_BITS)
#define FIXED_MASK (FIXED_LENGTH-1)

void Effect_Amp::reset() {


}


void Effect_Amp::process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq) {

	int multiplier;
	multiplier=(percent * FIXED_LENGTH) / 100;

	if (p_stereo_samples)
		p_length*=2;

	while (p_length--) {

		*p_buffer>>=FIXED_BITS;
		*p_buffer*=multiplier;
		p_buffer++;
	}

}


string Effect_Amp::get_name() {

	return "amplifier";
}
string Effect_Amp::get_display_name() {

	return "Amplifier";
}
list<Property_Bridge*> Effect_Amp::get_properties() {

	list<Property_Bridge*> pipio;
	pipio.push_back(&prop_percent);
	return pipio;
}

Effect_Amp::Effect_Amp() : prop_percent("Amp%",&percent,0,32767,"amp") {

	percent=100;
}


Effect_Amp::~Effect_Amp()
{
}


