//
// C++ Interface: freeverb_effect
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FREEVERB_EFFECT_H
#define FREEVERB_EFFECT_H

#include "plugins/effects/freeverb/revmodel.h"
#include "common/components/audio/effect.h"
#include <vector>
	using std::vector;
/**
@author Juan Linietsky
*/
class Freeverb_Effect : public Effect {

	revmodel freeverb; //freeverb object

	struct Params {
		int room_size;
		int damp;
		int wet;
		int dry;
		int width;
		int old_freq;
	} current_parm,bridge_parm;

	Int_Property_Bridge room_size_bridge;
	Int_Property_Bridge damp_bridge;
	Int_Property_Bridge wet_bridge;
	Int_Property_Bridge dry_bridge;
	Int_Property_Bridge width_bridge;

	enum {
		INTERNAL_BUFFER_SIZE=8192
	};

        vector<float> buffer_in_r;
        vector<float> buffer_in_l;
        vector<float> buffer_out_r;
        vector<float> buffer_out_l;

	void check_params_changed();

public:
	void reset();
        void process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq);
	string get_name();
	string get_display_name();
	list<Property_Bridge*> get_properties();

        static Effect * create_this() { return new Freeverb_Effect; }


	Freeverb_Effect();
	~Freeverb_Effect();

};

#endif
