require 'fileutils'
require 'tmpdir'

require 'gem2deb/rake/spectask'

blacklist_file = File.join(File.dirname(__FILE__), 'ruby-tests.blacklist')
blacklist = File.readlines(blacklist_file).map(&:strip)
blacklist.each do |f|
  puts "Blacklisted test file: #{f}"
end

tmpdir = Dir.mktmpdir
ENV['HOME'] = tmpdir
at_exit do
  FileUtils.rm_rf tmpdir
end

Gem2Deb::Rake::RSpecTask.new do |spec|
  spec.pattern = Dir['spec/**/*_spec.rb'].reject { |f| blacklist.include?(f) }
end
