/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2008-06-03 04:56
   Version 3.2.0 - linux-unix-gnu-x86	[ manyargs dload ptables applyhook hostpcre ]
   SVN rev. 10674	compiled 2008-04-30 on debian (Linux)
   command line: posixwin.scm -quiet -no-trace -optimize-level 2 -include-path . -explicit-use -unsafe -no-lambda-info -output-file uposixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)	    (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)	    C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)	    C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)	    C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[399];
static double C_possibly_force_alignment;


/* from k3974 */
static C_word C_fcall stub654(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub654(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from close-handle in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall stub642(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub642(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
C_r=C_fix((C_word)close_handle(t0));
return C_r;}

/* from current-process-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall stub630(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub630(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k3616 */
static C_word C_fcall stub533(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub533(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k3610 */
static C_word C_fcall stub523(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub523(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from ex0 */
static C_word C_fcall stub452(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub452(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub447(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub447(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (daylight ? _tzname[1] : _tzname[0]);return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub427(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub427(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub421(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub421(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub412(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub412(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from get */
static C_word C_fcall stub395(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub395(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from strerror */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1162)
static void C_ccall f_1162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1165)
static void C_ccall f_1165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1168)
static void C_ccall f_1168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1171)
static void C_ccall f_1171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1174)
static void C_ccall f_1174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1548)
static void C_ccall f_1548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1552)
static void C_ccall f_1552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1556)
static void C_ccall f_1556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1560)
static void C_ccall f_1560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1564)
static void C_ccall f_1564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1568)
static void C_ccall f_1568(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2773)
static void C_ccall f_2773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4931)
static void C_ccall f_4931(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4928)
static void C_ccall f_4928(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4921)
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4915)
static void C_ccall f_4915(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4909)
static void C_ccall f_4909(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4903)
static void C_ccall f_4903(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4897)
static void C_ccall f_4897(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4891)
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4885)
static void C_ccall f_4885(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4879)
static void C_ccall f_4879(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4867)
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4861)
static void C_ccall f_4861(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4849)
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4843)
static void C_ccall f_4843(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4837)
static void C_ccall f_4837(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4831)
static void C_ccall f_4831(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4825)
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4819)
static void C_ccall f_4819(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4813)
static void C_ccall f_4813(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4807)
static void C_ccall f_4807(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4801)
static void C_ccall f_4801(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4795)
static void C_ccall f_4795(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4789)
static void C_ccall f_4789(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4783)
static void C_ccall f_4783(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4777)
static void C_ccall f_4777(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4771)
static void C_ccall f_4771(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4765)
static void C_ccall f_4765(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4759)
static void C_ccall f_4759(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4753)
static void C_ccall f_4753(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4747)
static void C_ccall f_4747(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4741)
static void C_ccall f_4741(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4735)
static void C_ccall f_4735(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4729)
static void C_ccall f_4729(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4723)
static void C_ccall f_4723(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4717)
static void C_ccall f_4717(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4705)
static void C_ccall f_4705(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4699)
static void C_ccall f_4699(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4693)
static void C_ccall f_4693(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4687)
static void C_ccall f_4687(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4681)
static void C_ccall f_4681(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4675)
static void C_ccall f_4675(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4669)
static void C_ccall f_4669(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4663)
static void C_ccall f_4663(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4440)
static void C_ccall f_4440(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4440)
static void C_ccall f_4440r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4597)
static void C_fcall f_4597(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4603)
static void C_ccall f_4603(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4592)
static void C_fcall f_4592(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4587)
static void C_fcall f_4587(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4442)
static void C_fcall f_4442(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4574)
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4582)
static void C_ccall f_4582(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4449)
static void C_fcall f_4449(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4562)
static void C_ccall f_4562(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4459)
static void C_ccall f_4459(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4461)
static void C_fcall f_4461(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4480)
static void C_ccall f_4480(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4548)
static void C_ccall f_4548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4555)
static void C_ccall f_4555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4542)
static void C_ccall f_4542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4495)
static void C_ccall f_4495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4529)
static void C_ccall f_4529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4515)
static void C_ccall f_4515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4527)
static void C_ccall f_4527(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4523)
static void C_ccall f_4523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4507)
static void C_ccall f_4507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4505)
static void C_ccall f_4505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4566)
static void C_ccall f_4566(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4425)
static void C_ccall f_4425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4435)
static void C_ccall f_4435(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4394)
static void C_ccall f_4394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4420)
static void C_ccall f_4420(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4405)
static void C_ccall f_4405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4409)
static void C_ccall f_4409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4413)
static void C_ccall f_4413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4417)
static void C_ccall f_4417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4382)
static void C_ccall f_4382(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4379)
static void C_ccall f_4379(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4322)
static void C_ccall f_4322(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4322)
static void C_ccall f_4322r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4346)
static void C_ccall f_4346(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4356)
static void C_ccall f_4356(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4340)
static void C_ccall f_4340(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4310)
static void C_ccall f_4310(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4233)
static void C_ccall f_4233(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4233)
static void C_ccall f_4233r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4250)
static void C_fcall f_4250(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4245)
static void C_fcall f_4245(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4240)
static void C_fcall f_4240(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4235)
static void C_fcall f_4235(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4156)
static void C_ccall f_4156(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4156)
static void C_ccall f_4156r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4173)
static void C_fcall f_4173(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4168)
static void C_fcall f_4168(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4163)
static void C_fcall f_4163(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4158)
static void C_fcall f_4158(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4094)
static void C_fcall f_4094(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4150)
static void C_ccall f_4150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4154)
static void C_ccall f_4154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4115)
static void C_ccall f_4115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4129)
static void C_ccall f_4129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4123)
static void C_ccall f_4123(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4096)
static void C_fcall f_4096(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4105)
static void C_ccall f_4105(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3998)
static void C_ccall f_3998(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_3998)
static void C_ccall f_3998r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_4077)
static void C_ccall f_4077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4005)
static void C_ccall f_4005(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4045)
static void C_ccall f_4045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4053)
static void C_ccall f_4053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4057)
static void C_ccall f_4057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3956)
static void C_ccall f_3956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4038)
static void C_ccall f_4038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4022)
static void C_ccall f_4022(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4026)
static void C_ccall f_4026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3944)
static void C_ccall f_3944(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3915)
static void C_ccall f_3915(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3915)
static void C_ccall f_3915r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3932)
static void C_ccall f_3932(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3936)
static void C_ccall f_3936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3909)
static void C_ccall f_3909(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3888)
static void C_ccall f_3888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3892)
static void C_ccall f_3892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3904)
static void C_ccall f_3904(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3885)
static void C_ccall f_3885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3801)
static void C_ccall f_3801(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3801)
static void C_ccall f_3801r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3825)
static void C_fcall f_3825(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3820)
static void C_fcall f_3820(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3815)
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3803)
static void C_fcall f_3803(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3807)
static void C_ccall f_3807(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3717)
static void C_ccall f_3717(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3717)
static void C_ccall f_3717r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3741)
static void C_fcall f_3741(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3736)
static void C_fcall f_3736(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3731)
static void C_fcall f_3731(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3719)
static void C_fcall f_3719(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3723)
static void C_ccall f_3723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3702)
static void C_fcall f_3702(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3706)
static void C_ccall f_3706(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3669)
static void C_fcall f_3669(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3679)
static void C_ccall f_3679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3696)
static void C_ccall f_3696(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3682)
static void C_ccall f_3682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3685)
static void C_ccall f_3685(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3692)
static void C_ccall f_3692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3619)
static void C_fcall f_3619(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3631)
static void C_fcall f_3631(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3650)
static void C_ccall f_3650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3613)
static void C_ccall f_3613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3607)
static void C_ccall f_3607(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3528)
static void C_fcall f_3528(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3571)
static void C_fcall f_3571(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3602)
static void C_ccall f_3602(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3599)
static void C_ccall f_3599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3533)
static void C_fcall f_3533(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3537)
static void C_ccall f_3537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3542)
static void C_fcall f_3542(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3566)
static void C_ccall f_3566(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3555)
static void C_ccall f_3555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3413)
static void C_ccall f_3413(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3413)
static void C_ccall f_3413r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3419)
static void C_fcall f_3419(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3440)
static void C_ccall f_3440(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3517)
static void C_ccall f_3517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3444)
static void C_ccall f_3444(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3447)
static void C_ccall f_3447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3450)
static void C_ccall f_3450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3457)
static void C_ccall f_3457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3459)
static void C_fcall f_3459(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3476)
static void C_ccall f_3476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3486)
static void C_ccall f_3486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3490)
static void C_ccall f_3490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3434)
static void C_ccall f_3434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3354)
static void C_ccall f_3354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3354)
static void C_ccall f_3354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3358)
static void C_ccall f_3358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3364)
static void C_ccall f_3364(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3338)
static void C_ccall f_3338(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3338)
static void C_ccall f_3338r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3330)
static void C_ccall f_3330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3302)
static void C_ccall f_3302(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3309)
static void C_ccall f_3309(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3239)
static void C_ccall f_3239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3261)
static void C_ccall f_3261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3258)
static void C_ccall f_3258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3196)
static void C_ccall f_3196(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3200)
static void C_ccall f_3200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3182)
static void C_ccall f_3182(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3173)
static void C_ccall f_3173(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3108)
static void C_ccall f_3108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3114)
static void C_fcall f_3114(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3126)
static void C_fcall f_3126(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3152)
static void C_ccall f_3152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3156)
static void C_ccall f_3156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3144)
static void C_ccall f_3144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3093)
static void C_ccall f_3093(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3101)
static void C_ccall f_3101(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3087)
static void C_ccall f_3087(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3091)
static void C_ccall f_3091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3046)
static void C_ccall f_3046(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3046)
static void C_ccall f_3046r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3053)
static void C_fcall f_3053(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3062)
static void C_ccall f_3062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3056)
static void C_ccall f_3056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3011)
static void C_ccall f_3011(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3044)
static void C_ccall f_3044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3030)
static void C_ccall f_3030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3024)
static void C_ccall f_3024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2997)
static void C_ccall f_2997(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2997)
static void C_ccall f_2997r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3009)
static void C_ccall f_3009(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2983)
static void C_ccall f_2983(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2983)
static void C_ccall f_2983r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2995)
static void C_ccall f_2995(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2965)
static void C_fcall f_2965(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2969)
static void C_ccall f_2969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2981)
static void C_ccall f_2981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2928)
static void C_fcall f_2928(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2936)
static void C_ccall f_2936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2919)
static void C_ccall f_2919(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2907)
static void C_ccall f_2907(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2883)
static void C_fcall f_2883(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2905)
static void C_ccall f_2905(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2901)
static void C_ccall f_2901(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2893)
static void C_ccall f_2893(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2853)
static void C_ccall f_2853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2881)
static void C_ccall f_2881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2877)
static void C_ccall f_2877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2869)
static void C_ccall f_2869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2797)
static void C_ccall f_2797(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2807)
static void C_ccall f_2807(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2784)
static void C_ccall f_2784(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2775)
static void C_ccall f_2775(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2706)
static void C_ccall f_2706(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2706)
static void C_ccall f_2706r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2722)
static void C_ccall f_2722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2713)
static void C_ccall f_2713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2690)
static void C_ccall f_2690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2696)
static void C_ccall f_2696(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2696)
static void C_ccall f_2696r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2700)
static void C_ccall f_2700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2676)
static void C_ccall f_2676(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2676)
static void C_ccall f_2676r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2680)
static void C_ccall f_2680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2642)
static void C_ccall f_2642(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2642)
static void C_ccall f_2642r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2646)
static void C_ccall f_2646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2657)
static void C_ccall f_2657(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2657)
static void C_ccall f_2657r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2661)
static void C_ccall f_2661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2651)
static void C_ccall f_2651(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2618)
static void C_ccall f_2618(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2618)
static void C_ccall f_2618r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2622)
static void C_ccall f_2622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2633)
static void C_ccall f_2633(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2633)
static void C_ccall f_2633r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2637)
static void C_ccall f_2637(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2627)
static void C_ccall f_2627(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2599)
static void C_ccall f_2599(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2603)
static void C_ccall f_2603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2606)
static void C_ccall f_2606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2563)
static void C_ccall f_2563(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2563)
static void C_ccall f_2563r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2594)
static void C_ccall f_2594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2584)
static void C_ccall f_2584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2577)
static void C_ccall f_2577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2558)
static void C_ccall f_2558(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2548)
static void C_ccall f_2548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2541)
static void C_ccall f_2541(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2509)
static void C_fcall f_2509(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2525)
static void C_ccall f_2525(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2503)
static void C_fcall f_2503(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2491)
static C_word C_fcall f_2491(C_word t0);
C_noret_decl(f_2134)
static void C_ccall f_2134(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2481)
static void C_ccall f_2481(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2280)
static void C_fcall f_2280(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2467)
static void C_ccall f_2467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2456)
static void C_ccall f_2456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2463)
static void C_ccall f_2463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2310)
static void C_fcall f_2310(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2449)
static void C_ccall f_2449(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2428)
static void C_ccall f_2428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2445)
static void C_ccall f_2445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2434)
static void C_ccall f_2434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2441)
static void C_ccall f_2441(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2352)
static void C_fcall f_2352(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2425)
static void C_ccall f_2425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2404)
static void C_ccall f_2404(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2421)
static void C_ccall f_2421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2410)
static void C_ccall f_2410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2417)
static void C_ccall f_2417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2358)
static void C_ccall f_2358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2401)
static void C_ccall f_2401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2397)
static void C_ccall f_2397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2386)
static void C_ccall f_2386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2365)
static void C_ccall f_2365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2369)
static void C_ccall f_2369(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2346)
static void C_ccall f_2346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2333)
static void C_ccall f_2333(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2317)
static void C_ccall f_2317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2321)
static void C_ccall f_2321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2304)
static void C_ccall f_2304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2291)
static void C_ccall f_2291(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2287)
static void C_ccall f_2287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2274)
static void C_ccall f_2274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2141)
static void C_ccall f_2141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2260)
static void C_ccall f_2260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2148)
static void C_ccall f_2148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2150)
static void C_fcall f_2150(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2157)
static void C_ccall f_2157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2232)
static void C_ccall f_2232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2241)
static void C_ccall f_2241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2229)
static void C_fcall f_2229(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2163)
static void C_ccall f_2163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2210)
static void C_ccall f_2210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2206)
static void C_ccall f_2206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2202)
static void C_ccall f_2202(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2179)
static void C_ccall f_2179(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2187)
static void C_ccall f_2187(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2183)
static void C_ccall f_2183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2078)
static void C_fcall f_2078(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2087)
static void C_ccall f_2087(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2111)
static void C_ccall f_2111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2123)
static void C_ccall f_2123(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2123)
static void C_ccall f_2123r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2129)
static void C_ccall f_2129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2117)
static void C_ccall f_2117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2093)
static void C_ccall f_2093(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2099)
static void C_ccall f_2099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2085)
static void C_ccall f_2085(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2067)
static C_word C_fcall f_2067(C_word t0);
C_noret_decl(f_2062)
static void C_fcall f_2062(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2018)
static void C_ccall f_2018(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2018)
static void C_ccall f_2018r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2031)
static void C_ccall f_2031(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2034)
static void C_ccall f_2034(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1991)
static void C_ccall f_1991(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2016)
static void C_ccall f_2016(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2012)
static void C_ccall f_2012(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1998)
static void C_ccall f_1998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1834)
static void C_ccall f_1834(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1834)
static void C_ccall f_1834r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1942)
static void C_fcall f_1942(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1950)
static void C_ccall f_1950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1937)
static void C_fcall f_1937(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1836)
static void C_fcall f_1836(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1843)
static void C_ccall f_1843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1846)
static void C_ccall f_1846(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1849)
static void C_ccall f_1849(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1936)
static void C_ccall f_1936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1853)
static void C_ccall f_1853(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1870)
static void C_fcall f_1870(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1880)
static void C_ccall f_1880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1892)
static void C_fcall f_1892(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1902)
static void C_ccall f_1902(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1862)
static void C_ccall f_1862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1807)
static void C_ccall f_1807(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1832)
static void C_ccall f_1832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1820)
static void C_ccall f_1820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1780)
static void C_ccall f_1780(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1805)
static void C_ccall f_1805(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1801)
static void C_ccall f_1801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1793)
static void C_ccall f_1793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1674)
static void C_ccall f_1674(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1674)
static void C_ccall f_1674r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1749)
static void C_ccall f_1749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1766)
static void C_ccall f_1766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1758)
static void C_ccall f_1758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1687)
static void C_ccall f_1687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1698)
static void C_ccall f_1698(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1703)
static void C_ccall f_1703(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1729)
static void C_ccall f_1729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1732)
static void C_ccall f_1732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1709)
static void C_fcall f_1709(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1726)
static void C_ccall f_1726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1718)
static void C_ccall f_1718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1623)
static void C_ccall f_1623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1638)
static void C_ccall f_1638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1629)
static void C_ccall f_1629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1632)
static void C_ccall f_1632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1570)
static void C_ccall f_1570(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1589)
static void C_ccall f_1589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1574)
static void C_ccall f_1574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1583)
static void C_ccall f_1583(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1577)
static void C_ccall f_1577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1537)
static void C_fcall f_1537(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1539)
static void C_ccall f_1539(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1532)
static void C_ccall f_1532(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1509)
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1530)
static void C_ccall f_1530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1516)
static void C_ccall f_1516(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1503)
static void C_ccall f_1503(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1507)
static void C_ccall f_1507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1497)
static void C_ccall f_1497(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1501)
static void C_ccall f_1501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1491)
static void C_ccall f_1491(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1495)
static void C_ccall f_1495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1485)
static void C_ccall f_1485(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1489)
static void C_ccall f_1489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1479)
static void C_ccall f_1479(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1483)
static void C_ccall f_1483(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1473)
static void C_ccall f_1473(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1477)
static void C_ccall f_1477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1449)
static void C_ccall f_1449(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1449)
static void C_ccall f_1449r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1456)
static void C_ccall f_1456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1411)
static void C_fcall f_1411(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1444)
static void C_ccall f_1444(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1440)
static void C_ccall f_1440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1415)
static void C_ccall f_1415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1424)
static void C_ccall f_1424(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1373)
static void C_ccall f_1373(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1380)
static void C_ccall f_1380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1383)
static void C_ccall f_1383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1403)
static void C_ccall f_1403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1386)
static void C_ccall f_1386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1393)
static void C_ccall f_1393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1331)
static void C_ccall f_1331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1331)
static void C_ccall f_1331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1338)
static void C_ccall f_1338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1353)
static void C_ccall f_1353(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1347)
static void C_ccall f_1347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1286)
static void C_ccall f_1286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1286)
static void C_ccall f_1286r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1296)
static void C_ccall f_1296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1299)
static void C_ccall f_1299(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1311)
static void C_ccall f_1311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1302)
static void C_ccall f_1302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1268)
static void C_ccall f_1268(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1281)
static void C_ccall f_1281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1227)
static void C_ccall f_1227(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1227)
static void C_ccall f_1227r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1260)
static void C_ccall f_1260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1244)
static void C_ccall f_1244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1253)
static void C_ccall f_1253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1247)
static void C_ccall f_1247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1181)
static void C_ccall f_1181(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1181)
static void C_ccall f_1181r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1185)
static void C_ccall f_1185(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1196)
static void C_ccall f_1196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1192)
static void C_ccall f_1192(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_4597)
static void C_fcall trf_4597(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4597(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4597(t0,t1);}

C_noret_decl(trf_4592)
static void C_fcall trf_4592(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4592(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4592(t0,t1,t2);}

C_noret_decl(trf_4587)
static void C_fcall trf_4587(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4587(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4587(t0,t1,t2,t3);}

C_noret_decl(trf_4442)
static void C_fcall trf_4442(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4442(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4442(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4449)
static void C_fcall trf_4449(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4449(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4449(t0,t1);}

C_noret_decl(trf_4461)
static void C_fcall trf_4461(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4461(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4461(t0,t1,t2,t3);}

C_noret_decl(trf_4250)
static void C_fcall trf_4250(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4250(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4250(t0,t1);}

C_noret_decl(trf_4245)
static void C_fcall trf_4245(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4245(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4245(t0,t1,t2);}

C_noret_decl(trf_4240)
static void C_fcall trf_4240(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4240(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4240(t0,t1,t2,t3);}

C_noret_decl(trf_4235)
static void C_fcall trf_4235(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4235(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4235(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4173)
static void C_fcall trf_4173(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4173(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4173(t0,t1);}

C_noret_decl(trf_4168)
static void C_fcall trf_4168(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4168(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4168(t0,t1,t2);}

C_noret_decl(trf_4163)
static void C_fcall trf_4163(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4163(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4163(t0,t1,t2,t3);}

C_noret_decl(trf_4158)
static void C_fcall trf_4158(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4158(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4158(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4094)
static void C_fcall trf_4094(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4094(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4094(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4096)
static void C_fcall trf_4096(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4096(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4096(t0,t1,t2);}

C_noret_decl(trf_3825)
static void C_fcall trf_3825(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3825(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3825(t0,t1);}

C_noret_decl(trf_3820)
static void C_fcall trf_3820(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3820(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3820(t0,t1,t2);}

C_noret_decl(trf_3815)
static void C_fcall trf_3815(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3815(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3815(t0,t1,t2,t3);}

C_noret_decl(trf_3803)
static void C_fcall trf_3803(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3803(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3803(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3741)
static void C_fcall trf_3741(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3741(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3741(t0,t1);}

C_noret_decl(trf_3736)
static void C_fcall trf_3736(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3736(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3736(t0,t1,t2);}

C_noret_decl(trf_3731)
static void C_fcall trf_3731(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3731(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3731(t0,t1,t2,t3);}

C_noret_decl(trf_3719)
static void C_fcall trf_3719(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3719(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3719(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3702)
static void C_fcall trf_3702(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3702(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3702(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3669)
static void C_fcall trf_3669(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3669(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_3669(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3619)
static void C_fcall trf_3619(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3619(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3619(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3631)
static void C_fcall trf_3631(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3631(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3631(t0,t1,t2,t3);}

C_noret_decl(trf_3528)
static void C_fcall trf_3528(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3528(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3528(t0,t1,t2,t3);}

C_noret_decl(trf_3571)
static void C_fcall trf_3571(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3571(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3571(t0,t1,t2,t3);}

C_noret_decl(trf_3533)
static void C_fcall trf_3533(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3533(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3533(t0,t1,t2);}

C_noret_decl(trf_3542)
static void C_fcall trf_3542(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3542(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3542(t0,t1,t2);}

C_noret_decl(trf_3419)
static void C_fcall trf_3419(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3419(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3419(t0,t1,t2);}

C_noret_decl(trf_3459)
static void C_fcall trf_3459(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3459(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3459(t0,t1,t2);}

C_noret_decl(trf_3114)
static void C_fcall trf_3114(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3114(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3114(t0,t1,t2);}

C_noret_decl(trf_3126)
static void C_fcall trf_3126(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3126(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3126(t0,t1,t2);}

C_noret_decl(trf_3053)
static void C_fcall trf_3053(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3053(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3053(t0,t1);}

C_noret_decl(trf_2965)
static void C_fcall trf_2965(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2965(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2965(t0,t1,t2,t3);}

C_noret_decl(trf_2928)
static void C_fcall trf_2928(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2928(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2928(t0,t1,t2);}

C_noret_decl(trf_2883)
static void C_fcall trf_2883(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2883(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2883(t0,t1,t2,t3);}

C_noret_decl(trf_2509)
static void C_fcall trf_2509(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2509(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2509(t0,t1,t2,t3);}

C_noret_decl(trf_2503)
static void C_fcall trf_2503(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2503(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2503(t0,t1);}

C_noret_decl(trf_2280)
static void C_fcall trf_2280(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2280(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2280(t0,t1);}

C_noret_decl(trf_2310)
static void C_fcall trf_2310(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2310(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2310(t0,t1);}

C_noret_decl(trf_2352)
static void C_fcall trf_2352(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2352(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2352(t0,t1);}

C_noret_decl(trf_2150)
static void C_fcall trf_2150(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2150(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2150(t0,t1,t2,t3);}

C_noret_decl(trf_2229)
static void C_fcall trf_2229(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2229(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2229(t0,t1);}

C_noret_decl(trf_2078)
static void C_fcall trf_2078(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2078(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2078(t0,t1);}

C_noret_decl(trf_2062)
static void C_fcall trf_2062(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2062(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2062(t0,t1);}

C_noret_decl(trf_1942)
static void C_fcall trf_1942(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1942(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1942(t0,t1);}

C_noret_decl(trf_1937)
static void C_fcall trf_1937(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1937(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1937(t0,t1,t2);}

C_noret_decl(trf_1836)
static void C_fcall trf_1836(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1836(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1836(t0,t1,t2,t3);}

C_noret_decl(trf_1870)
static void C_fcall trf_1870(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1870(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1870(t0,t1);}

C_noret_decl(trf_1892)
static void C_fcall trf_1892(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1892(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1892(t0,t1);}

C_noret_decl(trf_1709)
static void C_fcall trf_1709(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1709(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1709(t0,t1);}

C_noret_decl(trf_1537)
static void C_fcall trf_1537(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1537(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1537(t0,t1);}

C_noret_decl(trf_1411)
static void C_fcall trf_1411(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1411(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1411(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr9rv)
static void C_fcall tr9rv(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9rv(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n+1);
t9=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3120)){
C_save(t1);
C_rereclaim2(3120*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,399);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],15,"\003sysposix-error");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"open/rdonly");
lf[13]=C_h_intern(&lf[13],11,"open/wronly");
lf[14]=C_h_intern(&lf[14],9,"open/rdwr");
lf[15]=C_h_intern(&lf[15],9,"open/read");
lf[16]=C_h_intern(&lf[16],10,"open/write");
lf[17]=C_h_intern(&lf[17],10,"open/creat");
lf[18]=C_h_intern(&lf[18],11,"open/append");
lf[19]=C_h_intern(&lf[19],9,"open/excl");
lf[20]=C_h_intern(&lf[20],10,"open/trunc");
lf[21]=C_h_intern(&lf[21],11,"open/binary");
lf[22]=C_h_intern(&lf[22],9,"open/text");
lf[23]=C_h_intern(&lf[23],14,"open/noinherit");
lf[24]=C_h_intern(&lf[24],10,"perm/irusr");
lf[25]=C_h_intern(&lf[25],10,"perm/iwusr");
lf[26]=C_h_intern(&lf[26],10,"perm/ixusr");
lf[27]=C_h_intern(&lf[27],10,"perm/irgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iwgrp");
lf[29]=C_h_intern(&lf[29],10,"perm/ixgrp");
lf[30]=C_h_intern(&lf[30],10,"perm/iroth");
lf[31]=C_h_intern(&lf[31],10,"perm/iwoth");
lf[32]=C_h_intern(&lf[32],10,"perm/ixoth");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxu");
lf[34]=C_h_intern(&lf[34],10,"perm/irwxg");
lf[35]=C_h_intern(&lf[35],10,"perm/irwxo");
lf[36]=C_h_intern(&lf[36],9,"file-open");
lf[37]=C_h_intern(&lf[37],11,"\000file-error");
lf[38]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[39]=C_h_intern(&lf[39],17,"\003sysmake-c-string");
lf[40]=C_h_intern(&lf[40],20,"\003sysexpand-home-path");
lf[41]=C_h_intern(&lf[41],10,"file-close");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[43]=C_h_intern(&lf[43],11,"make-string");
lf[44]=C_h_intern(&lf[44],9,"file-read");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[46]=C_h_intern(&lf[46],11,"\000type-error");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[48]=C_h_intern(&lf[48],10,"file-write");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[51]=C_h_intern(&lf[51],13,"string-length");
lf[52]=C_h_intern(&lf[52],12,"file-mkstemp");
lf[53]=C_h_intern(&lf[53],13,"\003syssubstring");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[55]=C_h_intern(&lf[55],8,"seek/set");
lf[56]=C_h_intern(&lf[56],8,"seek/end");
lf[57]=C_h_intern(&lf[57],8,"seek/cur");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[61]=C_h_intern(&lf[61],9,"file-stat");
lf[62]=C_h_intern(&lf[62],9,"file-size");
lf[63]=C_h_intern(&lf[63],22,"file-modification-time");
lf[64]=C_h_intern(&lf[64],16,"file-access-time");
lf[65]=C_h_intern(&lf[65],16,"file-change-time");
lf[66]=C_h_intern(&lf[66],10,"file-owner");
lf[67]=C_h_intern(&lf[67],16,"file-permissions");
lf[68]=C_h_intern(&lf[68],13,"regular-file\077");
lf[69]=C_h_intern(&lf[69],13,"\003sysfile-info");
lf[70]=C_h_intern(&lf[70],14,"symbolic-link\077");
lf[71]=C_h_intern(&lf[71],13,"stat-regular\077");
lf[72]=C_h_intern(&lf[72],15,"stat-directory\077");
lf[73]=C_h_intern(&lf[73],17,"stat-char-device\077");
lf[74]=C_h_intern(&lf[74],18,"stat-block-device\077");
lf[75]=C_h_intern(&lf[75],10,"stat-fifo\077");
lf[76]=C_h_intern(&lf[76],13,"stat-symlink\077");
lf[77]=C_h_intern(&lf[77],12,"stat-socket\077");
lf[78]=C_h_intern(&lf[78],13,"file-position");
lf[79]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[80]=C_h_intern(&lf[80],6,"stream");
lf[81]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[82]=C_h_intern(&lf[82],5,"port\077");
lf[83]=C_h_intern(&lf[83],18,"set-file-position!");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[86]=C_h_intern(&lf[86],13,"\000bounds-error");
lf[87]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[88]=C_h_intern(&lf[88],20,"g107-1212508573.0700");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[90]=C_h_intern(&lf[90],20,"g126-1212508573.0563");
lf[91]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[92]=C_h_intern(&lf[92],20,"g125-1212508573.0875");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[94]=C_h_intern(&lf[94],16,"create-directory");
lf[95]=C_h_intern(&lf[95],12,"file-exists\077");
lf[96]=C_h_intern(&lf[96],12,"\003sysfor-each");
lf[97]=C_h_intern(&lf[97],12,"string-split");
lf[98]=C_h_intern(&lf[98],14,"canonical-path");
lf[99]=C_h_intern(&lf[99],16,"change-directory");
lf[100]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[101]=C_h_intern(&lf[101],16,"delete-directory");
lf[102]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[103]=C_h_intern(&lf[103],6,"string");
lf[104]=C_h_intern(&lf[104],9,"directory");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[106]=C_h_intern(&lf[106],16,"\003sysmake-pointer");
lf[107]=C_h_intern(&lf[107],17,"current-directory");
lf[108]=C_h_intern(&lf[108],10,"directory\077");
lf[109]=C_h_intern(&lf[109],27,"\003sysplatform-fixup-pathname");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[111]=C_h_intern(&lf[111],5,"null\077");
lf[112]=C_h_intern(&lf[112],6,"char=\077");
lf[113]=C_h_intern(&lf[113],8,"string=\077");
lf[114]=C_h_intern(&lf[114],16,"char-alphabetic\077");
lf[115]=C_h_intern(&lf[115],10,"string-ref");
lf[116]=C_h_intern(&lf[116],18,"string-intersperse");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[118]=C_h_intern(&lf[118],17,"current-user-name");
lf[119]=C_h_intern(&lf[119],9,"condition");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\003c:\134");
lf[121]=C_h_intern(&lf[121],22,"with-exception-handler");
lf[122]=C_h_intern(&lf[122],30,"call-with-current-continuation");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[124]=C_h_intern(&lf[124],7,"reverse");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[127]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[130]=C_decode_literal(C_heaptop,"\376B\000\000\027Documents and Settings\134");
lf[131]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[134]=C_h_intern(&lf[134],5,"\000text");
lf[135]=C_h_intern(&lf[135],9,"\003syserror");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[137]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[138]=C_h_intern(&lf[138],13,"\003sysmake-port");
lf[139]=C_h_intern(&lf[139],21,"\003sysstream-port-class");
lf[140]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[141]=C_h_intern(&lf[141],15,"open-input-pipe");
lf[142]=C_h_intern(&lf[142],7,"\000binary");
lf[143]=C_h_intern(&lf[143],16,"open-output-pipe");
lf[144]=C_h_intern(&lf[144],16,"close-input-pipe");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[146]=C_h_intern(&lf[146],14,"\003syscheck-port");
lf[147]=C_h_intern(&lf[147],17,"close-output-pipe");
lf[148]=C_h_intern(&lf[148],20,"call-with-input-pipe");
lf[149]=C_h_intern(&lf[149],21,"call-with-output-pipe");
lf[150]=C_h_intern(&lf[150],20,"with-input-from-pipe");
lf[151]=C_h_intern(&lf[151],18,"\003sysstandard-input");
lf[152]=C_h_intern(&lf[152],19,"with-output-to-pipe");
lf[153]=C_h_intern(&lf[153],19,"\003sysstandard-output");
lf[154]=C_h_intern(&lf[154],11,"create-pipe");
lf[155]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[156]=C_h_intern(&lf[156],11,"signal/term");
lf[157]=C_h_intern(&lf[157],10,"signal/int");
lf[158]=C_h_intern(&lf[158],10,"signal/fpe");
lf[159]=C_h_intern(&lf[159],10,"signal/ill");
lf[160]=C_h_intern(&lf[160],11,"signal/segv");
lf[161]=C_h_intern(&lf[161],11,"signal/abrt");
lf[162]=C_h_intern(&lf[162],12,"signal/break");
lf[163]=C_h_intern(&lf[163],11,"signal/alrm");
lf[164]=C_h_intern(&lf[164],11,"signal/chld");
lf[165]=C_h_intern(&lf[165],11,"signal/cont");
lf[166]=C_h_intern(&lf[166],10,"signal/hup");
lf[167]=C_h_intern(&lf[167],9,"signal/io");
lf[168]=C_h_intern(&lf[168],11,"signal/kill");
lf[169]=C_h_intern(&lf[169],11,"signal/pipe");
lf[170]=C_h_intern(&lf[170],11,"signal/prof");
lf[171]=C_h_intern(&lf[171],11,"signal/quit");
lf[172]=C_h_intern(&lf[172],11,"signal/stop");
lf[173]=C_h_intern(&lf[173],11,"signal/trap");
lf[174]=C_h_intern(&lf[174],11,"signal/tstp");
lf[175]=C_h_intern(&lf[175],10,"signal/urg");
lf[176]=C_h_intern(&lf[176],11,"signal/usr1");
lf[177]=C_h_intern(&lf[177],11,"signal/usr2");
lf[178]=C_h_intern(&lf[178],13,"signal/vtalrm");
lf[179]=C_h_intern(&lf[179],12,"signal/winch");
lf[180]=C_h_intern(&lf[180],11,"signal/xcpu");
lf[181]=C_h_intern(&lf[181],11,"signal/xfsz");
lf[182]=C_h_intern(&lf[182],12,"signals-list");
lf[183]=C_h_intern(&lf[183],18,"\003sysinterrupt-hook");
lf[184]=C_h_intern(&lf[184],14,"signal-handler");
lf[185]=C_h_intern(&lf[185],19,"set-signal-handler!");
lf[186]=C_h_intern(&lf[186],10,"errno/perm");
lf[187]=C_h_intern(&lf[187],11,"errno/noent");
lf[188]=C_h_intern(&lf[188],10,"errno/srch");
lf[189]=C_h_intern(&lf[189],10,"errno/intr");
lf[190]=C_h_intern(&lf[190],8,"errno/io");
lf[191]=C_h_intern(&lf[191],12,"errno/noexec");
lf[192]=C_h_intern(&lf[192],10,"errno/badf");
lf[193]=C_h_intern(&lf[193],11,"errno/child");
lf[194]=C_h_intern(&lf[194],11,"errno/nomem");
lf[195]=C_h_intern(&lf[195],11,"errno/acces");
lf[196]=C_h_intern(&lf[196],11,"errno/fault");
lf[197]=C_h_intern(&lf[197],10,"errno/busy");
lf[198]=C_h_intern(&lf[198],11,"errno/exist");
lf[199]=C_h_intern(&lf[199],12,"errno/notdir");
lf[200]=C_h_intern(&lf[200],11,"errno/isdir");
lf[201]=C_h_intern(&lf[201],11,"errno/inval");
lf[202]=C_h_intern(&lf[202],11,"errno/mfile");
lf[203]=C_h_intern(&lf[203],11,"errno/nospc");
lf[204]=C_h_intern(&lf[204],11,"errno/spipe");
lf[205]=C_h_intern(&lf[205],10,"errno/pipe");
lf[206]=C_h_intern(&lf[206],11,"errno/again");
lf[207]=C_h_intern(&lf[207],10,"errno/rofs");
lf[208]=C_h_intern(&lf[208],10,"errno/nxio");
lf[209]=C_h_intern(&lf[209],10,"errno/2big");
lf[210]=C_h_intern(&lf[210],10,"errno/xdev");
lf[211]=C_h_intern(&lf[211],11,"errno/nodev");
lf[212]=C_h_intern(&lf[212],11,"errno/nfile");
lf[213]=C_h_intern(&lf[213],11,"errno/notty");
lf[214]=C_h_intern(&lf[214],10,"errno/fbig");
lf[215]=C_h_intern(&lf[215],11,"errno/mlink");
lf[216]=C_h_intern(&lf[216],9,"errno/dom");
lf[217]=C_h_intern(&lf[217],11,"errno/range");
lf[218]=C_h_intern(&lf[218],12,"errno/deadlk");
lf[219]=C_h_intern(&lf[219],17,"errno/nametoolong");
lf[220]=C_h_intern(&lf[220],11,"errno/nolck");
lf[221]=C_h_intern(&lf[221],11,"errno/nosys");
lf[222]=C_h_intern(&lf[222],14,"errno/notempty");
lf[223]=C_h_intern(&lf[223],11,"errno/ilseq");
lf[224]=C_h_intern(&lf[224],16,"change-file-mode");
lf[225]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[226]=C_h_intern(&lf[226],17,"file-read-access\077");
lf[227]=C_h_intern(&lf[227],18,"file-write-access\077");
lf[228]=C_h_intern(&lf[228],20,"file-execute-access\077");
lf[229]=C_h_intern(&lf[229],12,"fileno/stdin");
lf[230]=C_h_intern(&lf[230],13,"fileno/stdout");
lf[231]=C_h_intern(&lf[231],13,"fileno/stderr");
lf[232]=C_h_intern(&lf[232],7,"\000append");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[237]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[240]=C_h_intern(&lf[240],16,"open-input-file*");
lf[241]=C_h_intern(&lf[241],17,"open-output-file*");
lf[242]=C_h_intern(&lf[242],12,"port->fileno");
lf[243]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[244]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[245]=C_h_intern(&lf[245],25,"\003syspeek-unsigned-integer");
lf[246]=C_h_intern(&lf[246],16,"duplicate-fileno");
lf[247]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[248]=C_h_intern(&lf[248],6,"setenv");
lf[249]=C_h_intern(&lf[249],8,"unsetenv");
lf[250]=C_h_intern(&lf[250],9,"substring");
lf[251]=C_h_intern(&lf[251],19,"current-environment");
lf[252]=C_h_intern(&lf[252],19,"seconds->local-time");
lf[253]=C_h_intern(&lf[253],18,"\003sysdecode-seconds");
lf[254]=C_h_intern(&lf[254],17,"seconds->utc-time");
lf[255]=C_h_intern(&lf[255],15,"seconds->string");
lf[256]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[257]=C_h_intern(&lf[257],12,"time->string");
lf[258]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[259]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[260]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[261]=C_h_intern(&lf[261],19,"local-time->seconds");
lf[262]=C_h_intern(&lf[262],15,"\003syscons-flonum");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[265]=C_h_intern(&lf[265],27,"local-timezone-abbreviation");
lf[266]=C_h_intern(&lf[266],5,"_exit");
lf[267]=C_h_intern(&lf[267],19,"set-buffering-mode!");
lf[268]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[269]=C_h_intern(&lf[269],5,"\000full");
lf[270]=C_h_intern(&lf[270],5,"\000line");
lf[271]=C_h_intern(&lf[271],5,"\000none");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[273]=C_h_intern(&lf[273],6,"regexp");
lf[274]=C_h_intern(&lf[274],21,"make-anchored-pattern");
lf[275]=C_h_intern(&lf[275],12,"string-match");
lf[276]=C_h_intern(&lf[276],12,"glob->regexp");
lf[277]=C_h_intern(&lf[277],13,"make-pathname");
lf[278]=C_h_intern(&lf[278],18,"decompose-pathname");
lf[279]=C_h_intern(&lf[279],4,"glob");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[281]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[282]=C_h_intern(&lf[282],13,"spawn/overlay");
lf[283]=C_h_intern(&lf[283],10,"spawn/wait");
lf[284]=C_h_intern(&lf[284],12,"spawn/nowait");
lf[285]=C_h_intern(&lf[285],13,"spawn/nowaito");
lf[286]=C_h_intern(&lf[286],12,"spawn/detach");
lf[287]=C_h_intern(&lf[287],16,"char-whitespace\077");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[290]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[291]=C_h_intern(&lf[291],24,"pathname-strip-directory");
lf[294]=C_h_intern(&lf[294],15,"process-execute");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[296]=C_h_intern(&lf[296],13,"process-spawn");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[298]=C_h_intern(&lf[298],18,"current-process-id");
lf[299]=C_h_intern(&lf[299],17,"\003sysshell-command");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[301]=C_h_intern(&lf[301],6,"getenv");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[303]=C_h_intern(&lf[303],27,"\003sysshell-command-arguments");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[305]=C_h_intern(&lf[305],11,"process-run");
lf[307]=C_h_intern(&lf[307],11,"\003sysprocess");
lf[308]=C_h_intern(&lf[308],14,"\000process-error");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[310]=C_h_intern(&lf[310],17,"\003sysmake-locative");
lf[311]=C_h_intern(&lf[311],8,"location");
lf[312]=C_h_intern(&lf[312],7,"process");
lf[313]=C_h_intern(&lf[313],8,"process*");
lf[314]=C_h_intern(&lf[314],16,"\003sysprocess-wait");
lf[315]=C_h_intern(&lf[315],12,"process-wait");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[317]=C_h_intern(&lf[317],5,"sleep");
lf[318]=C_h_intern(&lf[318],13,"get-host-name");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[320]=C_h_intern(&lf[320],18,"system-information");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[324]=C_h_intern(&lf[324],10,"find-files");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[327]=C_h_intern(&lf[327],19,"\003sysundefined-value");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[329]=C_h_intern(&lf[329],16,"\003sysdynamic-wind");
lf[330]=C_h_intern(&lf[330],13,"pathname-file");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[332]=C_h_intern(&lf[332],17,"change-file-owner");
lf[333]=C_h_intern(&lf[333],5,"error");
lf[334]=C_h_intern(&lf[334],11,"create-fifo");
lf[335]=C_h_intern(&lf[335],14,"create-session");
lf[336]=C_h_intern(&lf[336],20,"create-symbolic-link");
lf[337]=C_h_intern(&lf[337],26,"current-effective-group-id");
lf[338]=C_h_intern(&lf[338],25,"current-effective-user-id");
lf[339]=C_h_intern(&lf[339],27,"current-effective-user-name");
lf[340]=C_h_intern(&lf[340],16,"current-group-id");
lf[341]=C_h_intern(&lf[341],15,"current-user-id");
lf[342]=C_h_intern(&lf[342],18,"map-file-to-memory");
lf[343]=C_h_intern(&lf[343],9,"file-link");
lf[344]=C_h_intern(&lf[344],9,"file-lock");
lf[345]=C_h_intern(&lf[345],18,"file-lock/blocking");
lf[346]=C_h_intern(&lf[346],11,"file-select");
lf[347]=C_h_intern(&lf[347],14,"file-test-lock");
lf[348]=C_h_intern(&lf[348],13,"file-truncate");
lf[349]=C_h_intern(&lf[349],11,"file-unlock");
lf[350]=C_h_intern(&lf[350],10,"get-groups");
lf[351]=C_h_intern(&lf[351],17,"group-information");
lf[352]=C_h_intern(&lf[352],17,"initialize-groups");
lf[353]=C_h_intern(&lf[353],26,"memory-mapped-file-pointer");
lf[354]=C_h_intern(&lf[354],17,"parent-process-id");
lf[355]=C_h_intern(&lf[355],12,"process-fork");
lf[356]=C_h_intern(&lf[356],16,"process-group-id");
lf[357]=C_h_intern(&lf[357],14,"process-signal");
lf[358]=C_h_intern(&lf[358],18,"read-symbolic-link");
lf[359]=C_h_intern(&lf[359],10,"set-alarm!");
lf[360]=C_h_intern(&lf[360],13,"set-group-id!");
lf[361]=C_h_intern(&lf[361],11,"set-groups!");
lf[362]=C_h_intern(&lf[362],21,"set-process-group-id!");
lf[363]=C_h_intern(&lf[363],19,"set-root-directory!");
lf[364]=C_h_intern(&lf[364],16,"set-signal-mask!");
lf[365]=C_h_intern(&lf[365],12,"set-user-id!");
lf[366]=C_h_intern(&lf[366],11,"signal-mask");
lf[367]=C_h_intern(&lf[367],12,"signal-mask!");
lf[368]=C_h_intern(&lf[368],14,"signal-masked\077");
lf[369]=C_h_intern(&lf[369],14,"signal-unmask!");
lf[370]=C_h_intern(&lf[370],13,"terminal-name");
lf[371]=C_h_intern(&lf[371],14,"terminal-port\077");
lf[372]=C_h_intern(&lf[372],13,"terminal-size");
lf[373]=C_h_intern(&lf[373],22,"unmap-file-from-memory");
lf[374]=C_h_intern(&lf[374],16,"user-information");
lf[375]=C_h_intern(&lf[375],17,"utc-time->seconds");
lf[376]=C_h_intern(&lf[376],12,"string->time");
lf[377]=C_h_intern(&lf[377],16,"errno/wouldblock");
lf[378]=C_h_intern(&lf[378],5,"fifo\077");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],13,"map/anonymous");
lf[381]=C_h_intern(&lf[381],8,"map/file");
lf[382]=C_h_intern(&lf[382],9,"map/fixed");
lf[383]=C_h_intern(&lf[383],11,"map/private");
lf[384]=C_h_intern(&lf[384],10,"map/shared");
lf[385]=C_h_intern(&lf[385],10,"open/fsync");
lf[386]=C_h_intern(&lf[386],11,"open/noctty");
lf[387]=C_h_intern(&lf[387],13,"open/nonblock");
lf[388]=C_h_intern(&lf[388],9,"open/sync");
lf[389]=C_h_intern(&lf[389],10,"perm/isgid");
lf[390]=C_h_intern(&lf[390],10,"perm/isuid");
lf[391]=C_h_intern(&lf[391],10,"perm/isvtx");
lf[392]=C_h_intern(&lf[392],9,"prot/exec");
lf[393]=C_h_intern(&lf[393],9,"prot/none");
lf[394]=C_h_intern(&lf[394],9,"prot/read");
lf[395]=C_h_intern(&lf[395],10,"prot/write");
lf[396]=C_h_intern(&lf[396],11,"make-vector");
lf[397]=C_h_intern(&lf[397],17,"register-feature!");
lf[398]=C_h_intern(&lf[398],5,"posix");
C_register_lf2(lf,399,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=C_mutate(&lf[2],lf[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1162,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t4);}

/* k1160 */
static void C_ccall f_1162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1162,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1165,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1163 in k1160 */
static void C_ccall f_1165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1165,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1168,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1166 in k1163 in k1160 */
static void C_ccall f_1168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1168,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1171,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1171,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1174,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 944  register-feature! */
t3=*((C_word*)lf[397]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[398]);}

/* k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word ab[46],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1174,2,t0,t1);}
t2=*((C_word*)lf[4]+1);
t3=C_mutate(&lf[5],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1181,a[2]=t2,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[10]+1,lf[5]);
t5=C_mutate((C_word*)lf[11]+1,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=(C_word)C_u_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[36]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1227,a[2]=t31,tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[41]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1268,tmp=(C_word)a,a+=2,tmp));
t34=*((C_word*)lf[43]+1);
t35=C_mutate((C_word*)lf[44]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1286,a[2]=t34,tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1331,tmp=(C_word)a,a+=2,tmp));
t37=*((C_word*)lf[51]+1);
t38=C_mutate((C_word*)lf[52]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1373,a[2]=t37,tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[55]+1,C_fix((C_word)SEEK_SET));
t40=C_mutate((C_word*)lf[56]+1,C_fix((C_word)SEEK_END));
t41=C_mutate((C_word*)lf[57]+1,C_fix((C_word)SEEK_CUR));
t42=C_mutate(&lf[58],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1411,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1449,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[62]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1473,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1479,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1485,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[65]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1491,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[66]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1497,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1503,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1509,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[70]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1532,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1537,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[71]+1,*((C_word*)lf[68]+1));
t54=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1548,a[2]=t52,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1129 stat-type */
f_1537(t54,lf[72]);}

/* k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1548,2,t0,t1);}
t2=C_mutate((C_word*)lf[72]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1552,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1130 stat-type */
f_1537(t3,lf[73]);}

/* k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1552,2,t0,t1);}
t2=C_mutate((C_word*)lf[73]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1556,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1131 stat-type */
f_1537(t3,lf[74]);}

/* k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1556,2,t0,t1);}
t2=C_mutate((C_word*)lf[74]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1560,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1132 stat-type */
f_1537(t3,lf[75]);}

/* k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1560,2,t0,t1);}
t2=C_mutate((C_word*)lf[75]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1133 stat-type */
f_1537(t3,lf[76]);}

/* k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1564,2,t0,t1);}
t2=C_mutate((C_word*)lf[76]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1568,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1134 stat-type */
f_1537(t3,lf[77]);}

/* k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word ab[98],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1568,2,t0,t1);}
t2=C_mutate((C_word*)lf[77]+1,t1);
t3=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1570,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1610,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[88]+1,lf[89]);
t6=C_mutate((C_word*)lf[90]+1,lf[91]);
t7=C_mutate((C_word*)lf[92]+1,lf[93]);
t8=C_mutate((C_word*)lf[94]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1674,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1780,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[101]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1807,tmp=(C_word)a,a+=2,tmp));
t11=*((C_word*)lf[4]+1);
t12=*((C_word*)lf[43]+1);
t13=*((C_word*)lf[103]+1);
t14=C_mutate((C_word*)lf[104]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1834,a[2]=t12,tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1991,tmp=(C_word)a,a+=2,tmp));
t16=*((C_word*)lf[43]+1);
t17=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2018,a[2]=t16,tmp=(C_word)a,a+=3,tmp));
t18=*((C_word*)lf[111]+1);
t19=*((C_word*)lf[112]+1);
t20=*((C_word*)lf[113]+1);
t21=*((C_word*)lf[114]+1);
t22=*((C_word*)lf[115]+1);
t23=*((C_word*)lf[4]+1);
t24=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2062,tmp=(C_word)a,a+=2,tmp);
t25=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2067,tmp=(C_word)a,a+=2,tmp);
t26=*((C_word*)lf[118]+1);
t27=*((C_word*)lf[107]+1);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2078,a[2]=t27,tmp=(C_word)a,a+=3,tmp);
t29=C_mutate((C_word*)lf[98]+1,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2134,a[2]=t21,a[3]=t19,a[4]=t26,a[5]=t28,a[6]=t20,a[7]=t18,a[8]=t22,a[9]=t24,a[10]=t23,a[11]=t25,tmp=(C_word)a,a+=12,tmp));
t30=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2491,tmp=(C_word)a,a+=2,tmp);
t31=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2503,tmp=(C_word)a,a+=2,tmp);
t32=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2509,tmp=(C_word)a,a+=2,tmp);
t33=C_mutate((C_word*)lf[141]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2527,a[2]=t31,a[3]=t32,a[4]=t30,tmp=(C_word)a,a+=5,tmp));
t34=C_mutate((C_word*)lf[143]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2563,a[2]=t31,a[3]=t32,a[4]=t30,tmp=(C_word)a,a+=5,tmp));
t35=C_mutate((C_word*)lf[144]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2599,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[147]+1,*((C_word*)lf[144]+1));
t37=*((C_word*)lf[141]+1);
t38=*((C_word*)lf[143]+1);
t39=*((C_word*)lf[144]+1);
t40=*((C_word*)lf[147]+1);
t41=C_mutate((C_word*)lf[148]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2618,a[2]=t37,a[3]=t39,tmp=(C_word)a,a+=4,tmp));
t42=C_mutate((C_word*)lf[149]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2642,a[2]=t38,a[3]=t40,tmp=(C_word)a,a+=4,tmp));
t43=C_mutate((C_word*)lf[150]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2666,a[2]=t37,a[3]=t39,tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2686,a[2]=t38,a[3]=t40,tmp=(C_word)a,a+=4,tmp));
t45=C_mutate((C_word*)lf[154]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2706,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGTERM));
t47=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGINT));
t48=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGFPE));
t49=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGILL));
t50=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGSEGV));
t51=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGABRT));
t52=C_mutate((C_word*)lf[162]+1,C_fix((C_word)SIGBREAK));
t53=C_set_block_item(lf[163],0,C_fix(0));
t54=C_set_block_item(lf[164],0,C_fix(0));
t55=C_set_block_item(lf[165],0,C_fix(0));
t56=C_set_block_item(lf[166],0,C_fix(0));
t57=C_set_block_item(lf[167],0,C_fix(0));
t58=C_set_block_item(lf[168],0,C_fix(0));
t59=C_set_block_item(lf[169],0,C_fix(0));
t60=C_set_block_item(lf[170],0,C_fix(0));
t61=C_set_block_item(lf[171],0,C_fix(0));
t62=C_set_block_item(lf[172],0,C_fix(0));
t63=C_set_block_item(lf[173],0,C_fix(0));
t64=C_set_block_item(lf[174],0,C_fix(0));
t65=C_set_block_item(lf[175],0,C_fix(0));
t66=C_set_block_item(lf[176],0,C_fix(0));
t67=C_set_block_item(lf[177],0,C_fix(0));
t68=C_set_block_item(lf[178],0,C_fix(0));
t69=C_set_block_item(lf[179],0,C_fix(0));
t70=C_set_block_item(lf[180],0,C_fix(0));
t71=C_set_block_item(lf[181],0,C_fix(0));
t72=(C_word)C_a_i_list(&a,7,*((C_word*)lf[156]+1),*((C_word*)lf[157]+1),*((C_word*)lf[158]+1),*((C_word*)lf[159]+1),*((C_word*)lf[160]+1),*((C_word*)lf[161]+1),*((C_word*)lf[162]+1));
t73=C_mutate((C_word*)lf[182]+1,t72);
t74=*((C_word*)lf[183]+1);
t75=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2773,a[2]=((C_word*)t0)[2],a[3]=t74,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1482 make-vector */
t76=*((C_word*)lf[396]+1);
((C_proc4)(void*)(*((C_word*)t76+1)))(4,t76,t75,C_fix(256),C_SCHEME_FALSE);}

/* k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word ab[226],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2773,2,t0,t1);}
t2=C_mutate((C_word*)lf[184]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2775,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[185]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2784,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[183]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2797,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[186]+1,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[187]+1,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[188]+1,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[190]+1,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[191]+1,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[193]+1,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[194]+1,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[195]+1,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[196]+1,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[197]+1,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[199]+1,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[200]+1,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[201]+1,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[203]+1,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[204]+1,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[205]+1,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[206]+1,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[207]+1,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[208]+1,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[209]+1,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[210]+1,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[211]+1,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[212]+1,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[213]+1,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[214]+1,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[215]+1,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[216]+1,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[217]+1,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[218]+1,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[219]+1,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[220]+1,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[221]+1,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[222]+1,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[223]+1,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[224]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2853,tmp=(C_word)a,a+=2,tmp));
t44=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2883,tmp=(C_word)a,a+=2,tmp);
t45=C_mutate((C_word*)lf[226]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2907,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2913,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2919,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[229]+1,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[230]+1,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[231]+1,C_fix((C_word)2));
t51=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2928,tmp=(C_word)a,a+=2,tmp);
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2965,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2983,a[2]=t51,a[3]=t52,tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2997,a[2]=t51,a[3]=t52,tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3011,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[246]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3046,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3076,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[249]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3093,tmp=(C_word)a,a+=2,tmp));
t59=*((C_word*)lf[250]+1);
t60=C_mutate((C_word*)lf[251]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3108,a[2]=t59,tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3173,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3182,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[255]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3196,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[257]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3229,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[261]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3302,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3330,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[266]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3338,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3354,tmp=(C_word)a,a+=2,tmp));
t69=*((C_word*)lf[273]+1);
t70=*((C_word*)lf[274]+1);
t71=*((C_word*)lf[275]+1);
t72=*((C_word*)lf[276]+1);
t73=*((C_word*)lf[104]+1);
t74=*((C_word*)lf[277]+1);
t75=*((C_word*)lf[278]+1);
t76=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3413,a[2]=t72,a[3]=t70,a[4]=t69,a[5]=t73,a[6]=t71,a[7]=t74,a[8]=t75,tmp=(C_word)a,a+=9,tmp));
t77=C_mutate((C_word*)lf[282]+1,C_fix((C_word)P_OVERLAY));
t78=C_mutate((C_word*)lf[283]+1,C_fix((C_word)P_WAIT));
t79=C_mutate((C_word*)lf[284]+1,C_fix((C_word)P_NOWAIT));
t80=C_mutate((C_word*)lf[285]+1,C_fix((C_word)P_NOWAITO));
t81=C_mutate((C_word*)lf[286]+1,C_fix((C_word)P_DETACH));
t82=*((C_word*)lf[287]+1);
t83=*((C_word*)lf[51]+1);
t84=*((C_word*)lf[115]+1);
t85=*((C_word*)lf[4]+1);
t86=C_mutate(&lf[288],(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3528,a[2]=t85,a[3]=t83,a[4]=t84,a[5]=t82,tmp=(C_word)a,a+=6,tmp));
t87=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3607,tmp=(C_word)a,a+=2,tmp);
t88=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3613,tmp=(C_word)a,a+=2,tmp);
t89=*((C_word*)lf[291]+1);
t90=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3619,tmp=(C_word)a,a+=2,tmp);
t91=C_mutate(&lf[292],(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3669,a[2]=t89,a[3]=t87,a[4]=t88,a[5]=t90,tmp=(C_word)a,a+=6,tmp));
t92=C_mutate(&lf[293],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3702,tmp=(C_word)a,a+=2,tmp));
t93=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3717,tmp=(C_word)a,a+=2,tmp));
t94=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3801,tmp=(C_word)a,a+=2,tmp));
t95=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3885,tmp=(C_word)a,a+=2,tmp));
t96=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3888,tmp=(C_word)a,a+=2,tmp));
t97=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3909,tmp=(C_word)a,a+=2,tmp));
t98=*((C_word*)lf[296]+1);
t99=*((C_word*)lf[301]+1);
t100=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3915,a[2]=t98,tmp=(C_word)a,a+=3,tmp));
t101=C_mutate(&lf[306],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3944,tmp=(C_word)a,a+=2,tmp));
t102=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3998,tmp=(C_word)a,a+=2,tmp));
t103=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4094,tmp=(C_word)a,a+=2,tmp);
t104=C_mutate((C_word*)lf[312]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4156,a[2]=t103,tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4233,a[2]=t103,tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4310,tmp=(C_word)a,a+=2,tmp));
t107=C_mutate((C_word*)lf[315]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4322,tmp=(C_word)a,a+=2,tmp));
t108=C_mutate((C_word*)lf[317]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4379,tmp=(C_word)a,a+=2,tmp));
t109=C_mutate((C_word*)lf[318]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4382,tmp=(C_word)a,a+=2,tmp));
t110=C_mutate((C_word*)lf[320]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4394,tmp=(C_word)a,a+=2,tmp));
t111=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4425,tmp=(C_word)a,a+=2,tmp));
t112=*((C_word*)lf[279]+1);
t113=*((C_word*)lf[275]+1);
t114=*((C_word*)lf[277]+1);
t115=*((C_word*)lf[108]+1);
t116=C_mutate((C_word*)lf[324]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4440,a[2]=t115,a[3]=t114,a[4]=t112,a[5]=t113,tmp=(C_word)a,a+=6,tmp));
t117=C_mutate((C_word*)lf[332]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4663,tmp=(C_word)a,a+=2,tmp));
t118=C_mutate((C_word*)lf[334]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4669,tmp=(C_word)a,a+=2,tmp));
t119=C_mutate((C_word*)lf[335]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4675,tmp=(C_word)a,a+=2,tmp));
t120=C_mutate((C_word*)lf[336]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4681,tmp=(C_word)a,a+=2,tmp));
t121=C_mutate((C_word*)lf[337]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4687,tmp=(C_word)a,a+=2,tmp));
t122=C_mutate((C_word*)lf[338]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4693,tmp=(C_word)a,a+=2,tmp));
t123=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4699,tmp=(C_word)a,a+=2,tmp));
t124=C_mutate((C_word*)lf[340]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4705,tmp=(C_word)a,a+=2,tmp));
t125=C_mutate((C_word*)lf[341]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4711,tmp=(C_word)a,a+=2,tmp));
t126=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4717,tmp=(C_word)a,a+=2,tmp));
t127=C_mutate((C_word*)lf[343]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4723,tmp=(C_word)a,a+=2,tmp));
t128=C_mutate((C_word*)lf[344]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4729,tmp=(C_word)a,a+=2,tmp));
t129=C_mutate((C_word*)lf[345]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4735,tmp=(C_word)a,a+=2,tmp));
t130=C_mutate((C_word*)lf[346]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4741,tmp=(C_word)a,a+=2,tmp));
t131=C_mutate((C_word*)lf[347]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4747,tmp=(C_word)a,a+=2,tmp));
t132=C_mutate((C_word*)lf[348]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4753,tmp=(C_word)a,a+=2,tmp));
t133=C_mutate((C_word*)lf[349]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4759,tmp=(C_word)a,a+=2,tmp));
t134=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4765,tmp=(C_word)a,a+=2,tmp));
t135=C_mutate((C_word*)lf[351]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4771,tmp=(C_word)a,a+=2,tmp));
t136=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4777,tmp=(C_word)a,a+=2,tmp));
t137=C_mutate((C_word*)lf[353]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4783,tmp=(C_word)a,a+=2,tmp));
t138=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4789,tmp=(C_word)a,a+=2,tmp));
t139=C_mutate((C_word*)lf[355]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4795,tmp=(C_word)a,a+=2,tmp));
t140=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4801,tmp=(C_word)a,a+=2,tmp));
t141=C_mutate((C_word*)lf[357]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4807,tmp=(C_word)a,a+=2,tmp));
t142=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4813,tmp=(C_word)a,a+=2,tmp));
t143=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4819,tmp=(C_word)a,a+=2,tmp));
t144=C_mutate((C_word*)lf[360]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4825,tmp=(C_word)a,a+=2,tmp));
t145=C_mutate((C_word*)lf[361]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4831,tmp=(C_word)a,a+=2,tmp));
t146=C_mutate((C_word*)lf[362]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4837,tmp=(C_word)a,a+=2,tmp));
t147=C_mutate((C_word*)lf[363]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4843,tmp=(C_word)a,a+=2,tmp));
t148=C_mutate((C_word*)lf[364]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4849,tmp=(C_word)a,a+=2,tmp));
t149=C_mutate((C_word*)lf[365]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4855,tmp=(C_word)a,a+=2,tmp));
t150=C_mutate((C_word*)lf[366]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4861,tmp=(C_word)a,a+=2,tmp));
t151=C_mutate((C_word*)lf[367]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4867,tmp=(C_word)a,a+=2,tmp));
t152=C_mutate((C_word*)lf[368]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4873,tmp=(C_word)a,a+=2,tmp));
t153=C_mutate((C_word*)lf[369]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4879,tmp=(C_word)a,a+=2,tmp));
t154=C_mutate((C_word*)lf[370]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4885,tmp=(C_word)a,a+=2,tmp));
t155=C_mutate((C_word*)lf[371]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4891,tmp=(C_word)a,a+=2,tmp));
t156=C_mutate((C_word*)lf[372]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4897,tmp=(C_word)a,a+=2,tmp));
t157=C_mutate((C_word*)lf[373]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4903,tmp=(C_word)a,a+=2,tmp));
t158=C_mutate((C_word*)lf[374]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4909,tmp=(C_word)a,a+=2,tmp));
t159=C_mutate((C_word*)lf[375]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4915,tmp=(C_word)a,a+=2,tmp));
t160=C_mutate((C_word*)lf[376]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4921,tmp=(C_word)a,a+=2,tmp));
t161=C_set_block_item(lf[377],0,C_fix(0));
t162=C_mutate((C_word*)lf[378]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4928,tmp=(C_word)a,a+=2,tmp));
t163=C_mutate((C_word*)lf[379]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4931,tmp=(C_word)a,a+=2,tmp));
t164=C_set_block_item(lf[380],0,C_fix(0));
t165=C_set_block_item(lf[381],0,C_fix(0));
t166=C_set_block_item(lf[382],0,C_fix(0));
t167=C_set_block_item(lf[383],0,C_fix(0));
t168=C_set_block_item(lf[384],0,C_fix(0));
t169=C_set_block_item(lf[385],0,C_fix(0));
t170=C_set_block_item(lf[386],0,C_fix(0));
t171=C_set_block_item(lf[387],0,C_fix(0));
t172=C_set_block_item(lf[388],0,C_fix(0));
t173=C_set_block_item(lf[389],0,C_fix(0));
t174=C_set_block_item(lf[390],0,C_fix(0));
t175=C_set_block_item(lf[391],0,C_fix(0));
t176=C_set_block_item(lf[392],0,C_fix(0));
t177=C_set_block_item(lf[393],0,C_fix(0));
t178=C_set_block_item(lf[394],0,C_fix(0));
t179=C_set_block_item(lf[395],0,C_fix(0));
t180=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t180+1)))(2,t180,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4931(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4931,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4928(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4928,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4921,2,t0,t1);}
/* posixwin.scm: 2124 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[376],lf[0]);}

/* utc-time->seconds in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4915(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4915,2,t0,t1);}
/* posixwin.scm: 2123 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[375],lf[0]);}

/* user-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4909(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4909,2,t0,t1);}
/* posixwin.scm: 2122 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[374],lf[0]);}

/* unmap-file-from-memory in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4903(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4903,2,t0,t1);}
/* posixwin.scm: 2121 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[373],lf[0]);}

/* terminal-size in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4897(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4897,2,t0,t1);}
/* posixwin.scm: 2120 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[372],lf[0]);}

/* terminal-port? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4891,2,t0,t1);}
/* posixwin.scm: 2119 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* terminal-name in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4885(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4885,2,t0,t1);}
/* posixwin.scm: 2118 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* signal-unmask! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4879(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4879,2,t0,t1);}
/* posixwin.scm: 2117 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* signal-masked? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4873,2,t0,t1);}
/* posixwin.scm: 2116 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* signal-mask! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4867,2,t0,t1);}
/* posixwin.scm: 2115 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* signal-mask in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4861(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4861,2,t0,t1);}
/* posixwin.scm: 2114 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* set-user-id! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4855,2,t0,t1);}
/* posixwin.scm: 2113 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* set-signal-mask! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4849,2,t0,t1);}
/* posixwin.scm: 2112 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* set-root-directory! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4843(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4843,2,t0,t1);}
/* posixwin.scm: 2111 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* set-process-group-id! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4837(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4837,2,t0,t1);}
/* posixwin.scm: 2110 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* set-groups! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4831(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4831,2,t0,t1);}
/* posixwin.scm: 2109 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-group-id! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4825,2,t0,t1);}
/* posixwin.scm: 2108 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* set-alarm! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4819(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4819,2,t0,t1);}
/* posixwin.scm: 2107 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* read-symbolic-link in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4813(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4813,2,t0,t1);}
/* posixwin.scm: 2106 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* process-signal in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4807(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4807,2,t0,t1);}
/* posixwin.scm: 2105 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* process-group-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4801(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4801,2,t0,t1);}
/* posixwin.scm: 2104 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* process-fork in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4795(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4795,2,t0,t1);}
/* posixwin.scm: 2103 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* parent-process-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4789(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4789,2,t0,t1);}
/* posixwin.scm: 2102 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* memory-mapped-file-pointer in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4783(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4783,2,t0,t1);}
/* posixwin.scm: 2101 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* initialize-groups in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4777(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4777,2,t0,t1);}
/* posixwin.scm: 2100 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* group-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4771(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4771,2,t0,t1);}
/* posixwin.scm: 2099 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* get-groups in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4765(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4765,2,t0,t1);}
/* posixwin.scm: 2098 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* file-unlock in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4759(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4759,2,t0,t1);}
/* posixwin.scm: 2097 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* file-truncate in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4753(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4753,2,t0,t1);}
/* posixwin.scm: 2096 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* file-test-lock in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4747(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4747,2,t0,t1);}
/* posixwin.scm: 2095 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* file-select in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4741(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4741,2,t0,t1);}
/* posixwin.scm: 2094 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-lock/blocking in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4735(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4735,2,t0,t1);}
/* posixwin.scm: 2093 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* file-lock in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4729(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4729,2,t0,t1);}
/* posixwin.scm: 2092 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* file-link in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4723(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4723,2,t0,t1);}
/* posixwin.scm: 2091 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* map-file-to-memory in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4717(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4717,2,t0,t1);}
/* posixwin.scm: 2090 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* current-user-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
/* posixwin.scm: 2089 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* current-group-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4705(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4705,2,t0,t1);}
/* posixwin.scm: 2088 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* current-effective-user-name in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4699(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4699,2,t0,t1);}
/* posixwin.scm: 2087 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* current-effective-user-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4693(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4693,2,t0,t1);}
/* posixwin.scm: 2086 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* current-effective-group-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4687(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4687,2,t0,t1);}
/* posixwin.scm: 2085 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* create-symbolic-link in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4681(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4681,2,t0,t1);}
/* posixwin.scm: 2084 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* create-session in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4675(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4675,2,t0,t1);}
/* posixwin.scm: 2083 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[335],lf[0]);}

/* create-fifo in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4669(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4669,2,t0,t1);}
/* posixwin.scm: 2082 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* change-file-owner in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4663(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4663,2,t0,t1);}
/* posixwin.scm: 2081 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[332],lf[0]);}

/* find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4440(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4440r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4440r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4440r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4442,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4587,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4592,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4597,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action825859 */
t9=t8;
f_4597(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id826857 */
t11=t7;
f_4592(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit827854 */
t13=t6;
f_4587(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body823829 */
t15=t5;
f_4442(t15,t1,t9,t11,t13);}}}}

/* def-action825 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4597(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4597,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4603,tmp=(C_word)a,a+=2,tmp);
/* def-id826857 */
t3=((C_word*)t0)[2];
f_4592(t3,t1,t2);}

/* a4602 in def-action825 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4603(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4603,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id826 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4592(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4592,NULL,3,t0,t1,t2);}
/* def-limit827854 */
t3=((C_word*)t0)[2];
f_4587(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit827 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4587(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4587,NULL,4,t0,t1,t2,t3);}
/* body823829 */
t4=((C_word*)t0)[2];
f_4442(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4442(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4442,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[324]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4449,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_4449(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4582,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_4449(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4574,tmp=(C_word)a,a+=2,tmp));}}

/* f_4574 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4574,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_4582 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4582(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4582,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4449(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4449,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4566,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4459,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4562,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2059 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[331]);}

/* k4560 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2059 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4459,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4461,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4461(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4461(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4461,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4480,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 2065 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4480,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4542,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 2066 pathname-file */
t3=*((C_word*)lf[330]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4548,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 2072 pproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k4546 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4548,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4555,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2072 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 2073 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4461(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k4553 in k4546 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2072 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4461(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4542,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[325]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[326]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 2066 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4461(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4495,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 2067 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4495,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4505,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4507,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4515,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4529,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2069 ##sys#dynamic-wind */
t11=*((C_word*)lf[329]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 2071 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4461(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a4528 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4529,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[327]+1));}

/* a4514 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4515,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4523,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4527,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2070 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[328]);}

/* k4525 in a4514 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4527(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2070 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4521 in a4514 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2070 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4461(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a4506 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4507,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[327]+1));}

/* k4503 in k4493 in k4540 in k4478 in loop in k4457 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2068 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4461(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_4566 in k4447 in body823 in find-files in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4566(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4566,3,t0,t1,t2);}
/* posixwin.scm: 2057 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* current-user-name in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4425,2,t0,t1);}
if(C_truep((C_word)C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4435,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2033 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4433 in current-user-name in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4435(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2034 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[118],lf[323]);}

/* system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4394,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4405,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4420,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2024 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4418 in system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4420(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2025 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[320],lf[322]);}

/* k4403 in system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4405,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4409,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k4407 in k4403 in system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4409,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4413,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k4411 in k4407 in k4403 in system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4413,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4417,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k4415 in k4411 in k4407 in k4403 in system-information in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4417,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[321],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4382(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4382,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 2014 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[318],lf[319]);}}

/* sleep in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4379(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4379,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4322(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_4322r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4322r(t0,t1,t2,t3);}}

static void C_ccall f_4322r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(7);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_check_exact_2(t2,lf[315]);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4340,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4346,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1993 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t9,t10);}

/* a4345 in process-wait in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4346(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4346,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4356,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1996 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
/* posixwin.scm: 1998 values */
C_values(5,0,t1,t2,t3,t4);}}

/* k4354 in a4345 in process-wait in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4356(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1997 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[308],lf[315],lf[316],((C_word*)t0)[2]);}

/* a4339 in process-wait in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4340(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4340,2,t0,t1);}
/* posixwin.scm: 1993 ##sys#process-wait */
t2=*((C_word*)lf[314]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4310(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4310,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_process_wait(t2,t3))){
/* posixwin.scm: 1986 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm: 1987 values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4233(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_4233r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4233r(t0,t1,t2,t3);}}

static void C_ccall f_4233r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4235,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4240,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4245,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4250,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args774787 */
t8=t7;
f_4250(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env775785 */
t10=t6;
f_4245(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf776782 */
t12=t5;
f_4240(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body772778 */
t14=t4;
f_4235(t14,t1,t8,t10,t12);}}}}

/* def-args774 in process* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4250(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4250,NULL,2,t0,t1);}
/* def-env775785 */
t2=((C_word*)t0)[2];
f_4245(t2,t1,C_SCHEME_FALSE);}

/* def-env775 in process* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4245(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4245,NULL,3,t0,t1,t2);}
/* def-exactf776782 */
t3=((C_word*)t0)[2];
f_4240(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf776 in process* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4240(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4240,NULL,4,t0,t1,t2,t3);}
/* body772778 */
t4=((C_word*)t0)[2];
f_4235(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body772 in process* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4235(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4235,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1980 %process */
f_4094(t1,lf[313],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4156(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_4156r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4156r(t0,t1,t2,t3);}}

static void C_ccall f_4156r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4158,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4163,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4168,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4173,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args746759 */
t8=t7;
f_4173(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env747757 */
t10=t6;
f_4168(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf748754 */
t12=t5;
f_4163(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body744750 */
t14=t4;
f_4158(t14,t1,t8,t10,t12);}}}}

/* def-args746 in process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4173(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4173,NULL,2,t0,t1);}
/* def-env747757 */
t2=((C_word*)t0)[2];
f_4168(t2,t1,C_SCHEME_FALSE);}

/* def-env747 in process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4168(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4168,NULL,3,t0,t1,t2);}
/* def-exactf748754 */
t3=((C_word*)t0)[2];
f_4163(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf748 in process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4163(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4163,NULL,4,t0,t1,t2,t3);}
/* body744750 */
t4=((C_word*)t0)[2];
f_4158(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body744 in process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4158(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4158,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1977 %process */
f_4094(t1,lf[312],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4094(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4094,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4096,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t12=(C_word)C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4115,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm: 1965 chkstrlst */
t14=t11;
f_4096(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4150,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1968 ##sys#shell-command-arguments */
t16=*((C_word*)lf[303]+1);
((C_proc3)(void*)(*((C_word*)t16+1)))(3,t16,t15,((C_word*)t8)[1]);}}

/* k4148 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4150,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4154,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1969 ##sys#shell-command */
t4=*((C_word*)lf[299]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4152 in k4148 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_4115(2,t3,t2);}

/* k4113 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4115,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4118,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm: 1970 chkstrlst */
t3=((C_word*)t0)[2];
f_4096(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_4118(2,t3,C_SCHEME_UNDEFINED);}}

/* k4116 in k4113 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4118,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4123,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4129,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1971 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4128 in k4116 in k4113 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4129,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm: 1973 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm: 1974 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a4122 in k4116 in k4113 in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4123,2,t0,t1);}
/* posixwin.scm: 1971 ##sys#process */
t2=*((C_word*)lf[307]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4096(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4096,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4105,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t5=*((C_word*)lf[96]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a4104 in chkstrlst in %process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4105(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4105,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3998(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(!C_demand(c*C_SIZEOF_PAIR+14)){
C_save_and_reclaim((void*)tr9rv,(void*)f_3998r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest_vector(a,C_rest_count(0));
f_3998r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_3998r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(14);
t10=(C_word)C_vemptyp(t9);
t11=(C_truep(t10)?C_SCHEME_FALSE:(C_word)C_slot(t9,C_fix(0)));
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4005,a[2]=t2,a[3]=t6,a[4]=t7,a[5]=t8,a[6]=t1,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4077,a[2]=t12,tmp=(C_word)a,a+=3,tmp);
t14=(C_word)C_a_i_cons(&a,2,t3,t4);
/* posixwin.scm: 1937 $quote-args-list */
t15=lf[288];
f_3528(t15,t13,t14,t11);}

/* k4075 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1937 string-intersperse */
t2=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4005,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=((*(int *)C_data_pointer(t2))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t5=((*(int *)C_data_pointer(t4))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t6=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t7=((*(int *)C_data_pointer(t6))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t8=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t9=((*(int *)C_data_pointer(t8))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t10=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4045,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
t11=*((C_word*)lf[310]+1);
((C_proc6)(void*)(*((C_word*)t11+1)))(6,t11,t10,t2,C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4045,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4049,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4049,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4053,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4053,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_4057,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4057,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_4061,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
t5=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(4));
/* posixwin.scm: 1944 + */
C_plus(5,0,t2,t3,t4,t5);}

/* k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4061,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_3952,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t9=t8;
f_3952(2,t9,C_SCHEME_FALSE);}}

/* k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3952,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_3956,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_3956(2,t3,C_SCHEME_FALSE);}}

/* k3954 in k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3956,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
if(C_truep((C_word)stub654(C_SCHEME_UNDEFINED,((C_word*)t0)[13],t1,C_SCHEME_FALSE,t2,t3,t4,t5,((C_word*)t0)[12]))){
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4018,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm: 1947 open-input-file* */
t7=*((C_word*)lf[240]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t7=t6;
f_4018(2,t7,C_SCHEME_FALSE);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4038,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1952 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k4036 in k3954 in k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1953 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[308],((C_word*)t0)[3],lf[309],((C_word*)t0)[2]);}

/* k4016 in k3954 in k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4022,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1948 open-output-file* */
t3=*((C_word*)lf[241]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4022(2,t3,C_SCHEME_FALSE);}}

/* k4020 in k4016 in k3954 in k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4022,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4026,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1950 open-input-file* */
t3=*((C_word*)lf[240]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4026(2,t3,C_SCHEME_FALSE);}}

/* k4024 in k4020 in k4016 in k3954 in k3950 in k4059 in k4055 in k4051 in k4047 in k4043 in k4003 in ##sys#process in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1946 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* close-handle in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3944(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3944,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub642(C_SCHEME_UNDEFINED,t2));}

/* process-run in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3915(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3915r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3915r(t0,t1,t2,t3);}}

static void C_ccall f_3915r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1905 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,*((C_word*)lf[284]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3932,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command */
t7=*((C_word*)lf[299]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k3930 in process-run in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3932(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3932,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3936,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command-arguments */
t3=*((C_word*)lf[303]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3934 in k3930 in process-run in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1906 process-spawn */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],*((C_word*)lf[284]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3909(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3909,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[304],t2));}

/* ##sys#shell-command in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3888,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3892,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1889 getenv */
t3=*((C_word*)lf[301]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[302]);}

/* k3890 in ##sys#shell-command in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3892,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
if(C_truep((C_word)C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3904,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1893 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}}

/* k3902 in k3890 in ##sys#shell-command in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3904(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1894 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[299],lf[300]);}

/* current-process-id in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3885,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub630(C_SCHEME_UNDEFINED));}

/* process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3801(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr4r,(void*)f_3801r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3801r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3801r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(13);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3803,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3815,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3820,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3825,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-arglst609623 */
t9=t8;
f_3825(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-envlst610621 */
t11=t7;
f_3820(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-exactf611618 */
t13=t6;
f_3815(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body607613 */
t15=t5;
f_3803(t15,t1,t9,t11,t13);}}}}

/* def-arglst609 in process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3825(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3825,NULL,2,t0,t1);}
/* def-envlst610621 */
t2=((C_word*)t0)[2];
f_3820(t2,t1,C_SCHEME_FALSE);}

/* def-envlst610 in process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3820(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3820,NULL,3,t0,t1,t2);}
/* def-exactf611618 */
t3=((C_word*)t0)[2];
f_3815(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf611 in process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3815,NULL,4,t0,t1,t2,t3);}
/* body607613 */
t4=((C_word*)t0)[2];
f_3803(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body607 in process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3803(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3803,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3807,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1880 $exec-setup */
t6=lf[292];
f_3669(t6,t5,lf[296],((C_word*)t0)[2],t2,t3,t4);}

/* k3805 in body607 in process-spawn in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?(C_word)C_spawnvpe(((C_word*)t0)[4],t1):(C_word)C_spawnvp(((C_word*)t0)[4],t1));
/* posixwin.scm: 1881 $exec-teardown */
f_3702(((C_word*)t0)[3],lf[296],lf[297],((C_word*)t0)[2],t2);}

/* process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3717(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_3717r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3717r(t0,t1,t2,t3);}}

static void C_ccall f_3717r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3719,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3731,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3736,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3741,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglst579593 */
t8=t7;
f_3741(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-envlst580591 */
t10=t6;
f_3736(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf581588 */
t12=t5;
f_3731(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body577583 */
t14=t4;
f_3719(t14,t1,t8,t10,t12);}}}}

/* def-arglst579 in process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3741(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3741,NULL,2,t0,t1);}
/* def-envlst580591 */
t2=((C_word*)t0)[2];
f_3736(t2,t1,C_SCHEME_FALSE);}

/* def-envlst580 in process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3736(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3736,NULL,3,t0,t1,t2);}
/* def-exactf581588 */
t3=((C_word*)t0)[2];
f_3731(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf581 in process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3731(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3731,NULL,4,t0,t1,t2,t3);}
/* body577583 */
t4=((C_word*)t0)[2];
f_3719(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body577 in process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3719(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3719,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3723,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1875 $exec-setup */
t6=lf[292];
f_3669(t6,t5,lf[294],((C_word*)t0)[2],t2,t3,t4);}

/* k3721 in body577 in process-execute in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
/* posixwin.scm: 1876 $exec-teardown */
f_3702(((C_word*)t0)[3],lf[294],lf[295],((C_word*)t0)[2],t2);}

/* $exec-teardown in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3702(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3702,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3706,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1867 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k3704 in $exec-teardown in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3706(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_free_exec_args();
t3=(C_word)C_free_exec_env();
t4=(C_word)C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm: 1871 ##sys#error */
t5=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[6]);}}

/* $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3669(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3669,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(C_word)C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3676,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t5,a[7]=t2,a[8]=((C_word*)t0)[5],a[9]=t3,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1859 pathname-strip-directory */
t9=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t3);}

/* k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3676,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3679,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=(C_word)C_block_size(t1);
/* posixwin.scm: 1860 setarg */
t4=((C_word*)t0)[4];
f_3607(5,t4,t2,C_fix(0),t1,t3);}

/* k3677 in k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3679,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3682,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3696,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1861 $quote-args-list */
t4=lf[288];
f_3528(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3694 in k3677 in k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1861 build-exec-argvec */
f_3619(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k3680 in k3677 in k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3682,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3685,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1862 build-exec-argvec */
f_3619(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k3683 in k3680 in k3677 in k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3685,2,t0,t1);}
t2=(C_word)C_flushall();
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3692,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1864 ##sys#expand-home-path */
t4=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3690 in k3683 in k3680 in k3677 in k3674 in $exec-setup in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1864 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* build-exec-argvec in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3619(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3619,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=(C_word)C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3631,a[2]=t8,a[3]=t2,a[4]=t4,tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_3631(t10,t1,t3,t5);}
else{
/* posixwin.scm: 1856 argvec-setter */
t6=t4;
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* do544 in build-exec-argvec in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3631(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3631,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1852 argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3650,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=(C_word)C_block_size(t4);
/* posixwin.scm: 1855 argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,t3,t4,t7);}}

/* k3648 in do544 in build-exec-argvec in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_3631(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3613,5,t0,t1,t2,t3,t4);}
t5=(C_truep(t3)?t3:C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub533(C_SCHEME_UNDEFINED,t2,t5,t4));}

/* setarg in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3607(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3607,5,t0,t1,t2,t3,t4);}
t5=(C_truep(t3)?t3:C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub523(C_SCHEME_UNDEFINED,t2,t5,t4));}

/* $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3528(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3528,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3533,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3571,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_3571(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3571(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3571,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1833 reverse */
t4=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3599,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3602,a[2]=t4,a[3]=t6,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1838 needs-quoting? */
t8=((C_word*)t0)[2];
f_3533(t8,t7,t4);}}

/* k3600 in loop in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1838 string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[289],((C_word*)t0)[2],lf[290]);}
else{
t2=((C_word*)t0)[3];
f_3599(2,t2,((C_word*)t0)[2]);}}

/* k3597 in loop in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3599,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm: 1835 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3571(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3533(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3533,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3537,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1825 string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k3535 in needs-quoting? in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3537,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3542,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_3542(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k3535 in needs-quoting? in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3542(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3542,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3555,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3566,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1829 string-ref */
t6=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k3564 in loop in k3535 in needs-quoting? in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1829 char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3553 in loop in k3535 in needs-quoting? in $quote-args-list in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1830 loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3542(t3,((C_word*)t0)[4],t2);}}

/* glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3413(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_3413r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3413r(t0,t1,t2);}}

static void C_ccall f_3413r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3419,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_3419(t6,t1,t2);}

/* conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3419(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3419,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3434,a[2]=t3,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3440,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3440(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3440,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3444,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3517,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[281]);
/* posixwin.scm: 1786 make-pathname */
t8=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3515 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1786 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3444(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3444,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3447,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 1787 make-anchored-pattern */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3447,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3450,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1788 regexp */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3450,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3457,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[280]);
/* posixwin.scm: 1789 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k3455 in k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3457,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3459,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_3459(t5,((C_word*)t0)[2],t1);}

/* loop in k3455 in k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3459(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3459,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[8],C_fix(1));
/* posixwin.scm: 1790 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_3419(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3476,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixwin.scm: 1791 string-match */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3474 in loop in k3455 in k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3476,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3486,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixwin.scm: 1792 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixwin.scm: 1793 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3459(t3,((C_word*)t0)[6],t2);}}

/* k3484 in k3474 in loop in k3455 in k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3486,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3490,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1792 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3459(t4,t2,t3);}

/* k3488 in k3484 in k3474 in loop in k3455 in k3448 in k3445 in k3442 in a3439 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3490,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3433 in conc-loop in glob in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3434,2,t0,t1);}
/* posixwin.scm: 1785 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3354r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3354r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3358,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1756 ##sys#check-port */
t6=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[267]);}

/* k3356 in set-buffering-mode! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3358,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3364,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[269]);
if(C_truep(t6)){
t7=t5;
f_3364(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[270]);
if(C_truep(t7)){
t8=t5;
f_3364(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[271]);
if(C_truep(t8)){
t9=t5;
f_3364(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1762 ##sys#error */
t9=*((C_word*)lf[135]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[267],lf[272],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3362 in k3356 in set-buffering-mode! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[267]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[80],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm: 1768 ##sys#error */
t6=*((C_word*)lf[135]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[267],lf[268],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* _exit in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3338(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3338r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3338r(t0,t1,t2);}}

static void C_ccall f_3338r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_slot(t2,C_fix(0)):C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub452(C_SCHEME_UNDEFINED,t4));}

/* local-timezone-abbreviation in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3330,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub447(t2),C_fix(0));}

/* local-time->seconds in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3302(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3302,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[261]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3309,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1732 ##sys#error */
t6=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[261],lf[264],t2);}
else{
t6=t4;
f_3309(2,t6,C_SCHEME_UNDEFINED);}}

/* k3307 in local-time->seconds in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1734 ##sys#cons-flonum */
t2=*((C_word*)lf[262]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1735 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[261],lf[263],((C_word*)t0)[3]);}}

/* time->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3229(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3229r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3229r(t0,t1,t2,t3);}}

static void C_ccall f_3229r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_vector_2(t2,lf[257]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3239,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(10)))){
/* posixwin.scm: 1719 ##sys#error */
t9=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t7,lf[257],lf[260],t2);}
else{
t9=t7;
f_3239(2,t9,C_SCHEME_UNDEFINED);}}

/* k3237 in time->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3239,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[257]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3248,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3258,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1723 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3261,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub421(t4,t3),C_fix(0));}}

/* k3259 in k3237 in time->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1727 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1728 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[259],((C_word*)t0)[2]);}}

/* k3256 in k3237 in time->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3258,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub427(t3,t2,t1),C_fix(0));}

/* k3246 in k3237 in time->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm: 1724 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[258],((C_word*)t0)[2]);}}

/* seconds->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3196(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3196,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3200,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub412(t5,t4),C_fix(0));}

/* k3198 in seconds->string in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1711 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1712 ##sys#error */
t2=*((C_word*)lf[135]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[255],lf[256],((C_word*)t0)[2]);}}

/* seconds->utc-time in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3182(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3182,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[254]);
/* posixwin.scm: 1704 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3173(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3173,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[252]);
/* posixwin.scm: 1700 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3108,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3114,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3114(t5,t1,C_fix(0));}

/* loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3114(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3114,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3118,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub395(t5,t4),C_fix(0));}

/* k3116 in loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3118,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3126,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_3126(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3116 in loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3126(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3126,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3152,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1692 substring */
t5=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1693 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3150 in scan in k3116 in loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3152,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3156,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1692 substring */
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3154 in k3150 in scan in k3116 in loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3156,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3144,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1692 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3114(t5,t3,t4);}

/* k3142 in k3154 in k3150 in scan in k3116 in loop in current-environment in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3144,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3093(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3093,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[249]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3101,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1680 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3099 in unsetenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3101(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3076(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3076,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[248]);
t5=(C_word)C_i_check_string_2(t3,lf[248]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3087,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1675 ##sys#make-c-string */
t7=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3085 in setenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3087,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3091,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1675 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3089 in k3085 in setenv in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3046(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3046r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3046r(t0,t1,t2,t3);}}

static void C_ccall f_3046r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[246]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3053,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_3053(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_slot(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[246]);
t8=t5;
f_3053(t8,(C_word)C_dup2(t2,t6));}}

/* k3051 in duplicate-fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3053(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3053,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3056,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3062,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1665 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_3056(2,t3,C_SCHEME_UNDEFINED);}}

/* k3060 in k3051 in duplicate-fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1666 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[246],lf[247],((C_word*)t0)[2]);}

/* k3054 in k3051 in duplicate-fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3011(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3011,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3015,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1647 ##sys#check-port */
t4=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[242]);}

/* k3013 in port->fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3015,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3044,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1648 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[245]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k3042 in k3013 in port->fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3044,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1654 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[46],lf[242],lf[243],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3024,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3030,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1651 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3024(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3028 in k3042 in k3013 in port->fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1652 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[242],lf[244],((C_word*)t0)[2]);}

/* k3022 in k3042 in k3013 in port->fileno in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2997(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2997r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2997r(t0,t1,t2,t3);}}

static void C_ccall f_2997r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[241]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3009,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1643 mode */
f_2928(t5,C_SCHEME_FALSE,t3);}

/* k3007 in open-output-file* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3009,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1643 check */
f_2965(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2983(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2983r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2983r(t0,t1,t2,t3);}}

static void C_ccall f_2983r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[240]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2995,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1639 mode */
f_2928(t5,C_SCHEME_TRUE,t3);}

/* k2993 in open-input-file* in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2995,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1639 check */
f_2965(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2965(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2965,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2969,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1630 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k2967 in check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2969,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1632 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[238],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2981,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1633 ##sys#make-port */
t3=*((C_word*)lf[138]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[139]+1),lf[239],lf[80]);}}

/* k2979 in k2967 in check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2928(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2928,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2936,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[232]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1625 ##sys#error */
t8=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[233],t5);}
else{
t8=t4;
f_2936(2,t8,lf[234]);}}
else{
/* posixwin.scm: 1626 ##sys#error */
t7=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[235],t5);}}
else{
t5=t4;
f_2936(2,t5,(C_truep(t2)?lf[236]:lf[237]));}}

/* k2934 in mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1621 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2919(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2919,3,t0,t1,t2);}
/* posixwin.scm: 1605 check */
f_2883(t1,t2,C_fix((C_word)2),lf[228]);}

/* file-write-access? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2913(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2913,3,t0,t1,t2);}
/* posixwin.scm: 1604 check */
f_2883(t1,t2,C_fix((C_word)4),lf[227]);}

/* file-read-access? in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2907(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2907,3,t0,t1,t2);}
/* posixwin.scm: 1603 check */
f_2883(t1,t2,C_fix((C_word)2),lf[226]);}

/* check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2883(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2883,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2901,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2905,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1600 ##sys#expand-home-path */
t8=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k2903 in check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2905(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1600 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2899 in check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2901(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2901,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2893,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2893(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1601 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2891 in k2899 in check in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2853,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[224]);
t5=(C_word)C_i_check_exact_2(t3,lf[224]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2877,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2881,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1589 ##sys#expand-home-path */
t8=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k2879 in change-file-mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1589 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2875 in change-file-mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2877,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2869,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1590 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2867 in k2875 in change-file-mode in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1591 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[224],lf[225],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2797(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2797,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2807,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1497 h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1499 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k2805 in ##sys#interrupt-hook in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1498 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2784(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2784,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[185]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k2771 in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2775(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2775,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[184]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2706(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2706r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2706r(t0,t1,t2);}}

static void C_ccall f_2706r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?(C_word)C_u_fixnum_or(*((C_word*)lf[21]+1),*((C_word*)lf[23]+1)):(C_word)C_slot(t2,C_fix(0)));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2713,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE,t4),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2722,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1434 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_2713(2,t6,C_SCHEME_UNDEFINED);}}

/* k2720 in create-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1435 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[37],lf[154],lf[155]);}

/* k2711 in create-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1436 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2686r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2686r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2686r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[153]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2690,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2688 in with-output-to-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2690,2,t0,t1);}
t2=C_mutate((C_word*)lf[153]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2696,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1419 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2695 in k2688 in with-output-to-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2696(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2696r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2696r(t0,t1,t2);}}

static void C_ccall f_2696r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2700,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1421 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2698 in a2695 in k2688 in with-output-to-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[153]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2666r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2666r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[151]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2670,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2668 in with-input-from-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2670,2,t0,t1);}
t2=C_mutate((C_word*)lf[151]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2676,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1409 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2675 in k2668 in with-input-from-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2676(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2676r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2676r(t0,t1,t2);}}

static void C_ccall f_2676r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2680,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1411 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2678 in a2675 in k2668 in with-input-from-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[151]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2642(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2642r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2642r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2642r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2646,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2644 in call-with-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2646,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2651,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2657,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1399 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2656 in k2644 in call-with-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2657(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2657r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2657r(t0,t1,t2);}}

static void C_ccall f_2657r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2661,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1402 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2659 in a2656 in k2644 in call-with-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2650 in k2644 in call-with-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2651,2,t0,t1);}
/* posixwin.scm: 1400 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2618(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2618r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2618r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2618r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2622,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2620 in call-with-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2622,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2627,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2633,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1391 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2632 in k2620 in call-with-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2633(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2633r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2633r(t0,t1,t2);}}

static void C_ccall f_2633r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2637,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1394 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2635 in a2632 in k2620 in call-with-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2637(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2626 in k2620 in call-with-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2627,2,t0,t1);}
/* posixwin.scm: 1392 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2599(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2599,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2603,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1378 ##sys#check-port */
t4=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[144]);}

/* k2601 in close-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2603,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2606,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1380 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2604 in k2601 in close-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 1381 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[37],lf[144],lf[145],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2563(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2563r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2563r(t0,t1,t2,t3);}}

static void C_ccall f_2563r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[143]);
t5=f_2491(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2577,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2584,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1373 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[142]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2594,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1374 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1375 badmode */
f_2503(t6,t5);}}}

/* k2592 in open-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2594,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2577(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2582 in open-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2584,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2577(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2575 in open-output-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1370 check */
f_2509(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2527(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2527r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2527r(t0,t1,t2,t3);}}

static void C_ccall f_2527r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[141]);
t5=f_2491(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2541,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2548,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1363 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[142]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2558,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1364 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1365 badmode */
f_2503(t6,t5);}}}

/* k2556 in open-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2558,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2541(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2546 in open-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2548,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2541(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2539 in open-input-pipe in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1360 check */
f_2509(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2509(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2509,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2513,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1350 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k2511 in check in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2513,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1352 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[137],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2525,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1353 ##sys#make-port */
t3=*((C_word*)lf[138]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[139]+1),lf[140],lf[80]);}}

/* k2523 in k2511 in check in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2503(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2503,NULL,2,t1,t2);}
/* posixwin.scm: 1348 ##sys#error */
t3=*((C_word*)lf[135]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[136],t2);}

/* mode in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall f_2491(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[134]));}

/* canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2134(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[28],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2134,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[98]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2141,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2274,a[2]=t4,a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1287 cwd */
t8=((C_word*)t0)[5];
f_2078(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2280,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,a[9]=t4,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2481,a[2]=((C_word*)t0)[11],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1289 sref */
t10=((C_word*)t0)[8];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_2280(t9,C_SCHEME_FALSE);}}}

/* k2479 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2481(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1289 sep? */
t2=((C_word*)t0)[3];
f_2280(t2,f_2067(t1));}

/* k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2280(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2280,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2287,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2291,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1291 cwd */
t4=((C_word*)t0)[7];
f_2078(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2304,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1294 cwd */
t5=((C_word*)t0)[7];
f_2078(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2310,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2456,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2467,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1295 sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k2465 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1295 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k2454 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2456,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2463,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1296 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2310(t2,C_SCHEME_FALSE);}}

/* k2461 in k2454 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1296 sep? */
t2=((C_word*)t0)[3];
f_2310(t2,f_2067(t1));}

/* k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2310(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[35],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2310,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2317,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2333,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1298 cwd */
t4=((C_word*)t0)[6];
f_2078(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2346,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1304 cwd */
t5=((C_word*)t0)[6];
f_2078(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2352,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2428,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2449,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1305 sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k2447 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1305 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2426 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2428,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2434,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2445,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1306 sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_2352(t2,C_SCHEME_FALSE);}}

/* k2443 in k2426 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1306 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k2432 in k2426 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2434,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2441,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1307 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_2352(t2,C_SCHEME_FALSE);}}

/* k2439 in k2432 in k2426 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1307 sep? */
t2=((C_word*)t0)[3];
f_2352(t2,f_2067(t1));}

/* k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2352(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2352,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[9];
f_2141(2,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2358,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2404,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2425,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1309 sref */
t5=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[8],C_fix(0));}}

/* k2423 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1309 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k2402 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2404,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2410,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2421,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1310 sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2358(2,t2,C_SCHEME_FALSE);}}

/* k2419 in k2402 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1310 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2408 in k2402 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2410,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2417,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1311 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_2358(2,t2,C_SCHEME_FALSE);}}

/* k2415 in k2408 in k2402 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1311 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2358,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2365,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1313 ##sys#substring */
t3=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,((C_word*)t0)[5],C_fix(1),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2401,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1317 sref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[5],C_fix(0));}}

/* k2399 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2401,2,t0,t1);}
t2=f_2067(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2386,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2390,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1319 cwd */
t5=((C_word*)t0)[2];
f_2078(t5,t4);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2397,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1322 cwd */
t4=((C_word*)t0)[2];
f_2078(t4,t3);}}

/* k2395 in k2399 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1322 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[133],((C_word*)t0)[2]);}

/* k2388 in k2399 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1319 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k2384 in k2399 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1318 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k2363 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2365,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2369,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1315 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(3),t3);}

/* k2367 in k2363 in k2356 in k2350 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1312 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[132],t1);}

/* k2344 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1304 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[131],((C_word*)t0)[2]);}

/* k2331 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2333(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1298 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(3));}

/* k2315 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2317,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2321,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1300 user */
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2319 in k2315 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2321,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2325,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1301 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k2323 in k2319 in k2315 in k2308 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1297 sappend */
t2=((C_word*)t0)[5];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],lf[130],((C_word*)t0)[2],t1);}

/* k2302 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1294 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[129],((C_word*)t0)[2]);}

/* k2289 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1291 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k2285 in k2278 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1290 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k2272 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1287 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[128]);}

/* k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2141,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2148,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2260,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_block_size(t1);
/* posixwin.scm: 1323 ##sys#substring */
t5=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,t1,C_fix(3),t4);}

/* k2258 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* string-split */
t2=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[127]);}

/* k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2148,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2150,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_2150(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2150(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2150,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2157,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1325 null? */
t5=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2157,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2163,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1326 null? */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2229,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2232,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_u_i_car(((C_word*)t0)[4]);
/* posixwin.scm: 1337 string=? */
t6=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[126],t5);}}

/* k2230 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2232,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_2229(t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2241,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(((C_word*)t0)[3]);
/* posixwin.scm: 1339 string=? */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[125],t3);}}

/* k2239 in k2230 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2241,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_2229(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_u_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_2229(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k2227 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2229(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1335 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2150(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2163,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1327 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[8],((C_word*)t0)[7],C_fix(0),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2210,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[7]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixwin.scm: 1328 sref */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,((C_word*)t0)[7],t4);}}

/* k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2210,2,t0,t1);}
t2=f_2067(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2179,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1330 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2198,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1333 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}}

/* k2196 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2198,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2202,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2206,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1334 reverse */
t4=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2204 in k2196 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1334 isperse */
f_2062(((C_word*)t0)[2],t1);}

/* k2200 in k2196 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1332 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2177 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2179,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2183,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2187,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_a_i_cons(&a,2,lf[123],((C_word*)t0)[2]);
/* posixwin.scm: 1331 reverse */
t5=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k2185 in k2177 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1331 isperse */
f_2062(((C_word*)t0)[2],t1);}

/* k2181 in k2177 in k2208 in k2161 in k2155 in loop in k2146 in k2139 in canonical-path in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1329 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2078(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2078,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2085,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2087,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2087(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2087,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2093,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2111,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[121]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t3,t4);}

/* a2110 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2111,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2117,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2123,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t2,t3);}

/* a2122 in a2110 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2123(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2123r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2123r(t0,t1,t2);}}

static void C_ccall f_2123r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2129,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g226228 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2128 in a2122 in a2110 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2129,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2116 in a2110 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2117,2,t0,t1);}
/* posixwin.scm: 1282 cw */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a2092 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2093(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2093,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2099,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g226228 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2098 in a2092 in a2086 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2099,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[119]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[120]);}

/* k2083 in cwd in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* sep? in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall f_2067(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2062(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2062,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[116]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,lf[117]);}

/* current-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2018(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2018r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2018r(t0,t1,t2);}}

static void C_ccall f_2018r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_slot(t2,C_fix(0)));
if(C_truep(t4)){
/* posixwin.scm: 1260 change-directory */
t5=*((C_word*)lf[99]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2031,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1261 make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}}

/* k2029 in current-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2031,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2034,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1263 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2032 in k2029 in current-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 1265 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 1266 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[107],lf[110]);}}

/* directory? in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1991(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1991,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[108]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1998,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2012,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2016,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1253 ##sys#expand-home-path */
t7=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2014 in directory? in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1253 ##sys#platform-fixup-pathname */
t2=*((C_word*)lf[109]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2010 in directory? in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2012(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1252 ##sys#file-info */
t2=*((C_word*)lf[69]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1996 in directory? in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1834(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_1834r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1834r(t0,t1,t2);}}

static void C_ccall f_1834r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1836,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1937,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1942,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec162188 */
t6=t5;
f_1942(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?163186 */
t8=t4;
f_1937(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body160165 */
t10=t3;
f_1836(t10,t1,t6,t8);}}}

/* def-spec162 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1942(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1942,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1950,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1223 current-directory */
t3=*((C_word*)lf[107]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1948 in def-spec162 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?163186 */
t2=((C_word*)t0)[3];
f_1937(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?163 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1937(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1937,NULL,3,t0,t1,t2);}
/* body160165 */
t3=((C_word*)t0)[2];
f_1836(t3,t1,t2,C_SCHEME_FALSE);}

/* body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1836(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1836,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[104]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1843,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1225 make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}

/* k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1843,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1846,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1226 ##sys#make-pointer */
t3=*((C_word*)lf[106]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1846,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1849,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1227 ##sys#make-pointer */
t3=*((C_word*)lf[106]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1849(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1849,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1853,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1936,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1228 ##sys#expand-home-path */
t4=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1934 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1228 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1853,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1862,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1231 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1870,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_1870(t6,((C_word*)t0)[6]);}}

/* loop in k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1870(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1870,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1880,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1240 ##sys#substring */
t5=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1878 in loop in k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1880,2,t0,t1);}
t2=(C_word)C_subchar(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_subchar(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1892,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1892(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1892(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1892(t7,C_SCHEME_FALSE);}}

/* k1890 in k1878 in loop in k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1892(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1892,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1247 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1870(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1902,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1248 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1870(t3,t2);}}

/* k1900 in k1890 in k1878 in loop in k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1902(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1902,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k1860 in k1851 in k1847 in k1844 in k1841 in body160 in directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1232 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[104],lf[105],((C_word*)t0)[2]);}

/* delete-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1807(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1807,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[101]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1828,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1832,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1215 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1830 in delete-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1215 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1826 in delete-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1828,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1820,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1216 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1818 in k1826 in delete-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1217 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[101],lf[102],((C_word*)t0)[2]);}

/* change-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1780(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1780,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[99]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1801,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1805,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1208 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1803 in change-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1208 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1799 in change-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1801,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1793,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1209 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1791 in k1799 in change-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1210 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[99],lf[100],((C_word*)t0)[2]);}

/* create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1674(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_1674r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_1674r(t0,t1,t2,t3);}}

static void C_ccall f_1674r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(6);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[94]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1687,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1196 canonical-path */
t8=*((C_word*)lf[98]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1749,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1197 canonical-path */
t8=*((C_word*)lf[98]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}}

/* k1747 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1749,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1766,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k1764 in k1747 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1766,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1758,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1756 in k1764 in k1747 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[94],*((C_word*)lf[88]+1),((C_word*)t0)[2]);}

/* k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1687,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1690,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* string-split */
t3=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,t1,*((C_word*)lf[92]+1));}

/* k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1690,2,t0,t1);}
t2=(C_word)C_u_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1698,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_slot(t1,C_fix(1));
/* for-each */
t7=*((C_word*)lf[96]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,((C_word*)t0)[2],t5,t6);}

/* a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1698(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1698,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1703,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-append */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],*((C_word*)lf[90]+1),t2);}

/* k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1703(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1703,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1709,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1729,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* file-exists? */
t6=*((C_word*)lf[95]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

/* k1727 in k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1729,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1732,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* ##sys#file-info */
t3=*((C_word*)lf[69]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_1709(t2,C_SCHEME_FALSE);}}

/* k1730 in k1727 in k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_1709(t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_1709(t2,C_SCHEME_FALSE);}}

/* k1707 in k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1709(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1709,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1726,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k1724 in k1707 in k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1726,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1718,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1716 in k1724 in k1707 in k1701 in a1697 in k1688 in k1685 in create-directory in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[94],*((C_word*)lf[88]+1),((C_word*)t0)[2]);}

/* set-file-position! in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1610r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1610r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[83]);
t8=(C_word)C_i_check_exact_2(t6,lf[83]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1623,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 1154 ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[86],lf[83],lf[87],t3,t2);}
else{
t10=t9;
f_1623(2,t10,C_SCHEME_UNDEFINED);}}

/* k1621 in set-file-position! in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1623,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1629,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1155 port? */
t4=*((C_word*)lf[82]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1636 in k1621 in set-file-position! in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[80]);
t4=((C_word*)t0)[4];
f_1629(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1629(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 1159 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[46],lf[83],lf[85],((C_word*)t0)[5]);}}}

/* k1627 in k1621 in set-file-position! in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1629,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1632,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1630 in k1627 in k1621 in set-file-position! in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[83],lf[84],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1570(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1570,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1574,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1589,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1138 port? */
t5=*((C_word*)lf[82]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1587 in file-position in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[80]);
t4=((C_word*)t0)[2];
f_1574(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1574(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 1143 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[78],lf[81],((C_word*)t0)[3]);}}}

/* k1572 in file-position in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1574,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1577,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1583,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1145 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1577(2,t3,C_SCHEME_UNDEFINED);}}

/* k1581 in k1572 in file-position in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1146 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[78],lf[79],((C_word*)t0)[2]);}

/* k1575 in k1572 in file-position in k1566 in k1562 in k1558 in k1554 in k1550 in k1546 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* stat-type in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1537(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1537,NULL,2,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1539,a[2]=t2,tmp=(C_word)a,a+=3,tmp));}

/* f_1539 in stat-type in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1539(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1539,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1532(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1532,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[70]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1509,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[68]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1516,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1530,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1116 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1528 in regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1116 ##sys#file-info */
t2=*((C_word*)lf[69]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1514 in regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1516(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1503(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1503,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1507,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1112 ##sys#stat */
f_1411(t3,t2);}

/* k1505 in file-permissions in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1497(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1497,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1501,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1111 ##sys#stat */
f_1411(t3,t2);}

/* k1499 in file-owner in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1491(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1491,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1495,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1110 ##sys#stat */
f_1411(t3,t2);}

/* k1493 in file-change-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1495,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1485(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1485,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1489,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1109 ##sys#stat */
f_1411(t3,t2);}

/* k1487 in file-access-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1489,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1479(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1479,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1483,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1108 ##sys#stat */
f_1411(t3,t2);}

/* k1481 in file-modification-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1483,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1473(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1473,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1477,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1107 ##sys#stat */
f_1411(t3,t2);}

/* k1475 in file-size in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1449(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_1449r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_1449r(t0,t1,t2,t3);}}

static void C_ccall f_1449r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1456,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1101 ##sys#stat */
f_1411(t6,t2);}

/* k1454 in file-stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1456,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(0),C_fix(0),C_fix(0),C_fix(0)));}

/* ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1411(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1411,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1415,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_1415(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1440,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1444,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1094 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1095 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[46],lf[60],t2);}}}

/* k1442 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1444(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1094 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1438 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_1415(2,t2,(C_word)C_stat(t1));}

/* k1413 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1415,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1424,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1097 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k1422 in k1413 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1424(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1098 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[59],((C_word*)t0)[2]);}

/* file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1373(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1373,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[52]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1380,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1063 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1378 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1380,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1383,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1065 string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k1381 in k1378 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1383,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1386,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1403,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1067 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_1386(2,t4,C_SCHEME_UNDEFINED);}}

/* k1401 in k1381 in k1378 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1068 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[52],lf[54],((C_word*)t0)[2]);}

/* k1384 in k1381 in k1378 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1386,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1393,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1069 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1391 in k1384 in k1381 in k1378 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1069 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1331r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1331r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[48]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1338,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1338(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1050 ##sys#signal-hook */
t8=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[46],lf[48],lf[50],t3);}}

/* k1336 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1338,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[48]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1347,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1353,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1055 ##sys#update-errno */
t9=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_1347(2,t8,C_SCHEME_UNDEFINED);}}

/* k1351 in k1336 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1056 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[48],lf[49],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1345 in k1336 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1286r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1286r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1286r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[44]);
t6=(C_word)C_i_check_exact_2(t3,lf[44]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1296,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1296(2,t8,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixwin.scm: 1037 make-string */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}}

/* k1294 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1296,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1299,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1299(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1039 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[46],lf[44],lf[47],t1);}}

/* k1297 in k1294 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1299,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1302,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1311,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1042 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1302(2,t5,C_SCHEME_UNDEFINED);}}

/* k1309 in k1297 in k1294 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1043 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[44],lf[45],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1300 in k1297 in k1294 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1302,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1268(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1268,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[41]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1281,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1029 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1279 in file-close in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1030 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[41],lf[42],((C_word*)t0)[2]);}

/* file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1227(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1227r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1227r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1227r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[36]);
t8=(C_word)C_i_check_exact_2(t3,lf[36]);
t9=(C_word)C_i_check_exact_2(t6,lf[36]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1244,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1260,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1019 ##sys#expand-home-path */
t12=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1258 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1019 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1242 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1244,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1247,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1253,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1021 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1247(2,t5,C_SCHEME_UNDEFINED);}}

/* k1251 in k1242 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1022 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[37],lf[36],lf[38],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1245 in k1242 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1181(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1181r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1181r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1181r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1185,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 950  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1183 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1185(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1185,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1192,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1196,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub3(t4,t1),C_fix(0));}

/* k1194 in k1183 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 951  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1190 in k1183 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[452] = {
{"toplevelposixwin.scm",(void*)C_posix_toplevel},
{"f_1162posixwin.scm",(void*)f_1162},
{"f_1165posixwin.scm",(void*)f_1165},
{"f_1168posixwin.scm",(void*)f_1168},
{"f_1171posixwin.scm",(void*)f_1171},
{"f_1174posixwin.scm",(void*)f_1174},
{"f_1548posixwin.scm",(void*)f_1548},
{"f_1552posixwin.scm",(void*)f_1552},
{"f_1556posixwin.scm",(void*)f_1556},
{"f_1560posixwin.scm",(void*)f_1560},
{"f_1564posixwin.scm",(void*)f_1564},
{"f_1568posixwin.scm",(void*)f_1568},
{"f_2773posixwin.scm",(void*)f_2773},
{"f_4931posixwin.scm",(void*)f_4931},
{"f_4928posixwin.scm",(void*)f_4928},
{"f_4921posixwin.scm",(void*)f_4921},
{"f_4915posixwin.scm",(void*)f_4915},
{"f_4909posixwin.scm",(void*)f_4909},
{"f_4903posixwin.scm",(void*)f_4903},
{"f_4897posixwin.scm",(void*)f_4897},
{"f_4891posixwin.scm",(void*)f_4891},
{"f_4885posixwin.scm",(void*)f_4885},
{"f_4879posixwin.scm",(void*)f_4879},
{"f_4873posixwin.scm",(void*)f_4873},
{"f_4867posixwin.scm",(void*)f_4867},
{"f_4861posixwin.scm",(void*)f_4861},
{"f_4855posixwin.scm",(void*)f_4855},
{"f_4849posixwin.scm",(void*)f_4849},
{"f_4843posixwin.scm",(void*)f_4843},
{"f_4837posixwin.scm",(void*)f_4837},
{"f_4831posixwin.scm",(void*)f_4831},
{"f_4825posixwin.scm",(void*)f_4825},
{"f_4819posixwin.scm",(void*)f_4819},
{"f_4813posixwin.scm",(void*)f_4813},
{"f_4807posixwin.scm",(void*)f_4807},
{"f_4801posixwin.scm",(void*)f_4801},
{"f_4795posixwin.scm",(void*)f_4795},
{"f_4789posixwin.scm",(void*)f_4789},
{"f_4783posixwin.scm",(void*)f_4783},
{"f_4777posixwin.scm",(void*)f_4777},
{"f_4771posixwin.scm",(void*)f_4771},
{"f_4765posixwin.scm",(void*)f_4765},
{"f_4759posixwin.scm",(void*)f_4759},
{"f_4753posixwin.scm",(void*)f_4753},
{"f_4747posixwin.scm",(void*)f_4747},
{"f_4741posixwin.scm",(void*)f_4741},
{"f_4735posixwin.scm",(void*)f_4735},
{"f_4729posixwin.scm",(void*)f_4729},
{"f_4723posixwin.scm",(void*)f_4723},
{"f_4717posixwin.scm",(void*)f_4717},
{"f_4711posixwin.scm",(void*)f_4711},
{"f_4705posixwin.scm",(void*)f_4705},
{"f_4699posixwin.scm",(void*)f_4699},
{"f_4693posixwin.scm",(void*)f_4693},
{"f_4687posixwin.scm",(void*)f_4687},
{"f_4681posixwin.scm",(void*)f_4681},
{"f_4675posixwin.scm",(void*)f_4675},
{"f_4669posixwin.scm",(void*)f_4669},
{"f_4663posixwin.scm",(void*)f_4663},
{"f_4440posixwin.scm",(void*)f_4440},
{"f_4597posixwin.scm",(void*)f_4597},
{"f_4603posixwin.scm",(void*)f_4603},
{"f_4592posixwin.scm",(void*)f_4592},
{"f_4587posixwin.scm",(void*)f_4587},
{"f_4442posixwin.scm",(void*)f_4442},
{"f_4574posixwin.scm",(void*)f_4574},
{"f_4582posixwin.scm",(void*)f_4582},
{"f_4449posixwin.scm",(void*)f_4449},
{"f_4562posixwin.scm",(void*)f_4562},
{"f_4459posixwin.scm",(void*)f_4459},
{"f_4461posixwin.scm",(void*)f_4461},
{"f_4480posixwin.scm",(void*)f_4480},
{"f_4548posixwin.scm",(void*)f_4548},
{"f_4555posixwin.scm",(void*)f_4555},
{"f_4542posixwin.scm",(void*)f_4542},
{"f_4495posixwin.scm",(void*)f_4495},
{"f_4529posixwin.scm",(void*)f_4529},
{"f_4515posixwin.scm",(void*)f_4515},
{"f_4527posixwin.scm",(void*)f_4527},
{"f_4523posixwin.scm",(void*)f_4523},
{"f_4507posixwin.scm",(void*)f_4507},
{"f_4505posixwin.scm",(void*)f_4505},
{"f_4566posixwin.scm",(void*)f_4566},
{"f_4425posixwin.scm",(void*)f_4425},
{"f_4435posixwin.scm",(void*)f_4435},
{"f_4394posixwin.scm",(void*)f_4394},
{"f_4420posixwin.scm",(void*)f_4420},
{"f_4405posixwin.scm",(void*)f_4405},
{"f_4409posixwin.scm",(void*)f_4409},
{"f_4413posixwin.scm",(void*)f_4413},
{"f_4417posixwin.scm",(void*)f_4417},
{"f_4382posixwin.scm",(void*)f_4382},
{"f_4379posixwin.scm",(void*)f_4379},
{"f_4322posixwin.scm",(void*)f_4322},
{"f_4346posixwin.scm",(void*)f_4346},
{"f_4356posixwin.scm",(void*)f_4356},
{"f_4340posixwin.scm",(void*)f_4340},
{"f_4310posixwin.scm",(void*)f_4310},
{"f_4233posixwin.scm",(void*)f_4233},
{"f_4250posixwin.scm",(void*)f_4250},
{"f_4245posixwin.scm",(void*)f_4245},
{"f_4240posixwin.scm",(void*)f_4240},
{"f_4235posixwin.scm",(void*)f_4235},
{"f_4156posixwin.scm",(void*)f_4156},
{"f_4173posixwin.scm",(void*)f_4173},
{"f_4168posixwin.scm",(void*)f_4168},
{"f_4163posixwin.scm",(void*)f_4163},
{"f_4158posixwin.scm",(void*)f_4158},
{"f_4094posixwin.scm",(void*)f_4094},
{"f_4150posixwin.scm",(void*)f_4150},
{"f_4154posixwin.scm",(void*)f_4154},
{"f_4115posixwin.scm",(void*)f_4115},
{"f_4118posixwin.scm",(void*)f_4118},
{"f_4129posixwin.scm",(void*)f_4129},
{"f_4123posixwin.scm",(void*)f_4123},
{"f_4096posixwin.scm",(void*)f_4096},
{"f_4105posixwin.scm",(void*)f_4105},
{"f_3998posixwin.scm",(void*)f_3998},
{"f_4077posixwin.scm",(void*)f_4077},
{"f_4005posixwin.scm",(void*)f_4005},
{"f_4045posixwin.scm",(void*)f_4045},
{"f_4049posixwin.scm",(void*)f_4049},
{"f_4053posixwin.scm",(void*)f_4053},
{"f_4057posixwin.scm",(void*)f_4057},
{"f_4061posixwin.scm",(void*)f_4061},
{"f_3952posixwin.scm",(void*)f_3952},
{"f_3956posixwin.scm",(void*)f_3956},
{"f_4038posixwin.scm",(void*)f_4038},
{"f_4018posixwin.scm",(void*)f_4018},
{"f_4022posixwin.scm",(void*)f_4022},
{"f_4026posixwin.scm",(void*)f_4026},
{"f_3944posixwin.scm",(void*)f_3944},
{"f_3915posixwin.scm",(void*)f_3915},
{"f_3932posixwin.scm",(void*)f_3932},
{"f_3936posixwin.scm",(void*)f_3936},
{"f_3909posixwin.scm",(void*)f_3909},
{"f_3888posixwin.scm",(void*)f_3888},
{"f_3892posixwin.scm",(void*)f_3892},
{"f_3904posixwin.scm",(void*)f_3904},
{"f_3885posixwin.scm",(void*)f_3885},
{"f_3801posixwin.scm",(void*)f_3801},
{"f_3825posixwin.scm",(void*)f_3825},
{"f_3820posixwin.scm",(void*)f_3820},
{"f_3815posixwin.scm",(void*)f_3815},
{"f_3803posixwin.scm",(void*)f_3803},
{"f_3807posixwin.scm",(void*)f_3807},
{"f_3717posixwin.scm",(void*)f_3717},
{"f_3741posixwin.scm",(void*)f_3741},
{"f_3736posixwin.scm",(void*)f_3736},
{"f_3731posixwin.scm",(void*)f_3731},
{"f_3719posixwin.scm",(void*)f_3719},
{"f_3723posixwin.scm",(void*)f_3723},
{"f_3702posixwin.scm",(void*)f_3702},
{"f_3706posixwin.scm",(void*)f_3706},
{"f_3669posixwin.scm",(void*)f_3669},
{"f_3676posixwin.scm",(void*)f_3676},
{"f_3679posixwin.scm",(void*)f_3679},
{"f_3696posixwin.scm",(void*)f_3696},
{"f_3682posixwin.scm",(void*)f_3682},
{"f_3685posixwin.scm",(void*)f_3685},
{"f_3692posixwin.scm",(void*)f_3692},
{"f_3619posixwin.scm",(void*)f_3619},
{"f_3631posixwin.scm",(void*)f_3631},
{"f_3650posixwin.scm",(void*)f_3650},
{"f_3613posixwin.scm",(void*)f_3613},
{"f_3607posixwin.scm",(void*)f_3607},
{"f_3528posixwin.scm",(void*)f_3528},
{"f_3571posixwin.scm",(void*)f_3571},
{"f_3602posixwin.scm",(void*)f_3602},
{"f_3599posixwin.scm",(void*)f_3599},
{"f_3533posixwin.scm",(void*)f_3533},
{"f_3537posixwin.scm",(void*)f_3537},
{"f_3542posixwin.scm",(void*)f_3542},
{"f_3566posixwin.scm",(void*)f_3566},
{"f_3555posixwin.scm",(void*)f_3555},
{"f_3413posixwin.scm",(void*)f_3413},
{"f_3419posixwin.scm",(void*)f_3419},
{"f_3440posixwin.scm",(void*)f_3440},
{"f_3517posixwin.scm",(void*)f_3517},
{"f_3444posixwin.scm",(void*)f_3444},
{"f_3447posixwin.scm",(void*)f_3447},
{"f_3450posixwin.scm",(void*)f_3450},
{"f_3457posixwin.scm",(void*)f_3457},
{"f_3459posixwin.scm",(void*)f_3459},
{"f_3476posixwin.scm",(void*)f_3476},
{"f_3486posixwin.scm",(void*)f_3486},
{"f_3490posixwin.scm",(void*)f_3490},
{"f_3434posixwin.scm",(void*)f_3434},
{"f_3354posixwin.scm",(void*)f_3354},
{"f_3358posixwin.scm",(void*)f_3358},
{"f_3364posixwin.scm",(void*)f_3364},
{"f_3338posixwin.scm",(void*)f_3338},
{"f_3330posixwin.scm",(void*)f_3330},
{"f_3302posixwin.scm",(void*)f_3302},
{"f_3309posixwin.scm",(void*)f_3309},
{"f_3229posixwin.scm",(void*)f_3229},
{"f_3239posixwin.scm",(void*)f_3239},
{"f_3261posixwin.scm",(void*)f_3261},
{"f_3258posixwin.scm",(void*)f_3258},
{"f_3248posixwin.scm",(void*)f_3248},
{"f_3196posixwin.scm",(void*)f_3196},
{"f_3200posixwin.scm",(void*)f_3200},
{"f_3182posixwin.scm",(void*)f_3182},
{"f_3173posixwin.scm",(void*)f_3173},
{"f_3108posixwin.scm",(void*)f_3108},
{"f_3114posixwin.scm",(void*)f_3114},
{"f_3118posixwin.scm",(void*)f_3118},
{"f_3126posixwin.scm",(void*)f_3126},
{"f_3152posixwin.scm",(void*)f_3152},
{"f_3156posixwin.scm",(void*)f_3156},
{"f_3144posixwin.scm",(void*)f_3144},
{"f_3093posixwin.scm",(void*)f_3093},
{"f_3101posixwin.scm",(void*)f_3101},
{"f_3076posixwin.scm",(void*)f_3076},
{"f_3087posixwin.scm",(void*)f_3087},
{"f_3091posixwin.scm",(void*)f_3091},
{"f_3046posixwin.scm",(void*)f_3046},
{"f_3053posixwin.scm",(void*)f_3053},
{"f_3062posixwin.scm",(void*)f_3062},
{"f_3056posixwin.scm",(void*)f_3056},
{"f_3011posixwin.scm",(void*)f_3011},
{"f_3015posixwin.scm",(void*)f_3015},
{"f_3044posixwin.scm",(void*)f_3044},
{"f_3030posixwin.scm",(void*)f_3030},
{"f_3024posixwin.scm",(void*)f_3024},
{"f_2997posixwin.scm",(void*)f_2997},
{"f_3009posixwin.scm",(void*)f_3009},
{"f_2983posixwin.scm",(void*)f_2983},
{"f_2995posixwin.scm",(void*)f_2995},
{"f_2965posixwin.scm",(void*)f_2965},
{"f_2969posixwin.scm",(void*)f_2969},
{"f_2981posixwin.scm",(void*)f_2981},
{"f_2928posixwin.scm",(void*)f_2928},
{"f_2936posixwin.scm",(void*)f_2936},
{"f_2919posixwin.scm",(void*)f_2919},
{"f_2913posixwin.scm",(void*)f_2913},
{"f_2907posixwin.scm",(void*)f_2907},
{"f_2883posixwin.scm",(void*)f_2883},
{"f_2905posixwin.scm",(void*)f_2905},
{"f_2901posixwin.scm",(void*)f_2901},
{"f_2893posixwin.scm",(void*)f_2893},
{"f_2853posixwin.scm",(void*)f_2853},
{"f_2881posixwin.scm",(void*)f_2881},
{"f_2877posixwin.scm",(void*)f_2877},
{"f_2869posixwin.scm",(void*)f_2869},
{"f_2797posixwin.scm",(void*)f_2797},
{"f_2807posixwin.scm",(void*)f_2807},
{"f_2784posixwin.scm",(void*)f_2784},
{"f_2775posixwin.scm",(void*)f_2775},
{"f_2706posixwin.scm",(void*)f_2706},
{"f_2722posixwin.scm",(void*)f_2722},
{"f_2713posixwin.scm",(void*)f_2713},
{"f_2686posixwin.scm",(void*)f_2686},
{"f_2690posixwin.scm",(void*)f_2690},
{"f_2696posixwin.scm",(void*)f_2696},
{"f_2700posixwin.scm",(void*)f_2700},
{"f_2666posixwin.scm",(void*)f_2666},
{"f_2670posixwin.scm",(void*)f_2670},
{"f_2676posixwin.scm",(void*)f_2676},
{"f_2680posixwin.scm",(void*)f_2680},
{"f_2642posixwin.scm",(void*)f_2642},
{"f_2646posixwin.scm",(void*)f_2646},
{"f_2657posixwin.scm",(void*)f_2657},
{"f_2661posixwin.scm",(void*)f_2661},
{"f_2651posixwin.scm",(void*)f_2651},
{"f_2618posixwin.scm",(void*)f_2618},
{"f_2622posixwin.scm",(void*)f_2622},
{"f_2633posixwin.scm",(void*)f_2633},
{"f_2637posixwin.scm",(void*)f_2637},
{"f_2627posixwin.scm",(void*)f_2627},
{"f_2599posixwin.scm",(void*)f_2599},
{"f_2603posixwin.scm",(void*)f_2603},
{"f_2606posixwin.scm",(void*)f_2606},
{"f_2563posixwin.scm",(void*)f_2563},
{"f_2594posixwin.scm",(void*)f_2594},
{"f_2584posixwin.scm",(void*)f_2584},
{"f_2577posixwin.scm",(void*)f_2577},
{"f_2527posixwin.scm",(void*)f_2527},
{"f_2558posixwin.scm",(void*)f_2558},
{"f_2548posixwin.scm",(void*)f_2548},
{"f_2541posixwin.scm",(void*)f_2541},
{"f_2509posixwin.scm",(void*)f_2509},
{"f_2513posixwin.scm",(void*)f_2513},
{"f_2525posixwin.scm",(void*)f_2525},
{"f_2503posixwin.scm",(void*)f_2503},
{"f_2491posixwin.scm",(void*)f_2491},
{"f_2134posixwin.scm",(void*)f_2134},
{"f_2481posixwin.scm",(void*)f_2481},
{"f_2280posixwin.scm",(void*)f_2280},
{"f_2467posixwin.scm",(void*)f_2467},
{"f_2456posixwin.scm",(void*)f_2456},
{"f_2463posixwin.scm",(void*)f_2463},
{"f_2310posixwin.scm",(void*)f_2310},
{"f_2449posixwin.scm",(void*)f_2449},
{"f_2428posixwin.scm",(void*)f_2428},
{"f_2445posixwin.scm",(void*)f_2445},
{"f_2434posixwin.scm",(void*)f_2434},
{"f_2441posixwin.scm",(void*)f_2441},
{"f_2352posixwin.scm",(void*)f_2352},
{"f_2425posixwin.scm",(void*)f_2425},
{"f_2404posixwin.scm",(void*)f_2404},
{"f_2421posixwin.scm",(void*)f_2421},
{"f_2410posixwin.scm",(void*)f_2410},
{"f_2417posixwin.scm",(void*)f_2417},
{"f_2358posixwin.scm",(void*)f_2358},
{"f_2401posixwin.scm",(void*)f_2401},
{"f_2397posixwin.scm",(void*)f_2397},
{"f_2390posixwin.scm",(void*)f_2390},
{"f_2386posixwin.scm",(void*)f_2386},
{"f_2365posixwin.scm",(void*)f_2365},
{"f_2369posixwin.scm",(void*)f_2369},
{"f_2346posixwin.scm",(void*)f_2346},
{"f_2333posixwin.scm",(void*)f_2333},
{"f_2317posixwin.scm",(void*)f_2317},
{"f_2321posixwin.scm",(void*)f_2321},
{"f_2325posixwin.scm",(void*)f_2325},
{"f_2304posixwin.scm",(void*)f_2304},
{"f_2291posixwin.scm",(void*)f_2291},
{"f_2287posixwin.scm",(void*)f_2287},
{"f_2274posixwin.scm",(void*)f_2274},
{"f_2141posixwin.scm",(void*)f_2141},
{"f_2260posixwin.scm",(void*)f_2260},
{"f_2148posixwin.scm",(void*)f_2148},
{"f_2150posixwin.scm",(void*)f_2150},
{"f_2157posixwin.scm",(void*)f_2157},
{"f_2232posixwin.scm",(void*)f_2232},
{"f_2241posixwin.scm",(void*)f_2241},
{"f_2229posixwin.scm",(void*)f_2229},
{"f_2163posixwin.scm",(void*)f_2163},
{"f_2210posixwin.scm",(void*)f_2210},
{"f_2198posixwin.scm",(void*)f_2198},
{"f_2206posixwin.scm",(void*)f_2206},
{"f_2202posixwin.scm",(void*)f_2202},
{"f_2179posixwin.scm",(void*)f_2179},
{"f_2187posixwin.scm",(void*)f_2187},
{"f_2183posixwin.scm",(void*)f_2183},
{"f_2078posixwin.scm",(void*)f_2078},
{"f_2087posixwin.scm",(void*)f_2087},
{"f_2111posixwin.scm",(void*)f_2111},
{"f_2123posixwin.scm",(void*)f_2123},
{"f_2129posixwin.scm",(void*)f_2129},
{"f_2117posixwin.scm",(void*)f_2117},
{"f_2093posixwin.scm",(void*)f_2093},
{"f_2099posixwin.scm",(void*)f_2099},
{"f_2085posixwin.scm",(void*)f_2085},
{"f_2067posixwin.scm",(void*)f_2067},
{"f_2062posixwin.scm",(void*)f_2062},
{"f_2018posixwin.scm",(void*)f_2018},
{"f_2031posixwin.scm",(void*)f_2031},
{"f_2034posixwin.scm",(void*)f_2034},
{"f_1991posixwin.scm",(void*)f_1991},
{"f_2016posixwin.scm",(void*)f_2016},
{"f_2012posixwin.scm",(void*)f_2012},
{"f_1998posixwin.scm",(void*)f_1998},
{"f_1834posixwin.scm",(void*)f_1834},
{"f_1942posixwin.scm",(void*)f_1942},
{"f_1950posixwin.scm",(void*)f_1950},
{"f_1937posixwin.scm",(void*)f_1937},
{"f_1836posixwin.scm",(void*)f_1836},
{"f_1843posixwin.scm",(void*)f_1843},
{"f_1846posixwin.scm",(void*)f_1846},
{"f_1849posixwin.scm",(void*)f_1849},
{"f_1936posixwin.scm",(void*)f_1936},
{"f_1853posixwin.scm",(void*)f_1853},
{"f_1870posixwin.scm",(void*)f_1870},
{"f_1880posixwin.scm",(void*)f_1880},
{"f_1892posixwin.scm",(void*)f_1892},
{"f_1902posixwin.scm",(void*)f_1902},
{"f_1862posixwin.scm",(void*)f_1862},
{"f_1807posixwin.scm",(void*)f_1807},
{"f_1832posixwin.scm",(void*)f_1832},
{"f_1828posixwin.scm",(void*)f_1828},
{"f_1820posixwin.scm",(void*)f_1820},
{"f_1780posixwin.scm",(void*)f_1780},
{"f_1805posixwin.scm",(void*)f_1805},
{"f_1801posixwin.scm",(void*)f_1801},
{"f_1793posixwin.scm",(void*)f_1793},
{"f_1674posixwin.scm",(void*)f_1674},
{"f_1749posixwin.scm",(void*)f_1749},
{"f_1766posixwin.scm",(void*)f_1766},
{"f_1758posixwin.scm",(void*)f_1758},
{"f_1687posixwin.scm",(void*)f_1687},
{"f_1690posixwin.scm",(void*)f_1690},
{"f_1698posixwin.scm",(void*)f_1698},
{"f_1703posixwin.scm",(void*)f_1703},
{"f_1729posixwin.scm",(void*)f_1729},
{"f_1732posixwin.scm",(void*)f_1732},
{"f_1709posixwin.scm",(void*)f_1709},
{"f_1726posixwin.scm",(void*)f_1726},
{"f_1718posixwin.scm",(void*)f_1718},
{"f_1610posixwin.scm",(void*)f_1610},
{"f_1623posixwin.scm",(void*)f_1623},
{"f_1638posixwin.scm",(void*)f_1638},
{"f_1629posixwin.scm",(void*)f_1629},
{"f_1632posixwin.scm",(void*)f_1632},
{"f_1570posixwin.scm",(void*)f_1570},
{"f_1589posixwin.scm",(void*)f_1589},
{"f_1574posixwin.scm",(void*)f_1574},
{"f_1583posixwin.scm",(void*)f_1583},
{"f_1577posixwin.scm",(void*)f_1577},
{"f_1537posixwin.scm",(void*)f_1537},
{"f_1539posixwin.scm",(void*)f_1539},
{"f_1532posixwin.scm",(void*)f_1532},
{"f_1509posixwin.scm",(void*)f_1509},
{"f_1530posixwin.scm",(void*)f_1530},
{"f_1516posixwin.scm",(void*)f_1516},
{"f_1503posixwin.scm",(void*)f_1503},
{"f_1507posixwin.scm",(void*)f_1507},
{"f_1497posixwin.scm",(void*)f_1497},
{"f_1501posixwin.scm",(void*)f_1501},
{"f_1491posixwin.scm",(void*)f_1491},
{"f_1495posixwin.scm",(void*)f_1495},
{"f_1485posixwin.scm",(void*)f_1485},
{"f_1489posixwin.scm",(void*)f_1489},
{"f_1479posixwin.scm",(void*)f_1479},
{"f_1483posixwin.scm",(void*)f_1483},
{"f_1473posixwin.scm",(void*)f_1473},
{"f_1477posixwin.scm",(void*)f_1477},
{"f_1449posixwin.scm",(void*)f_1449},
{"f_1456posixwin.scm",(void*)f_1456},
{"f_1411posixwin.scm",(void*)f_1411},
{"f_1444posixwin.scm",(void*)f_1444},
{"f_1440posixwin.scm",(void*)f_1440},
{"f_1415posixwin.scm",(void*)f_1415},
{"f_1424posixwin.scm",(void*)f_1424},
{"f_1373posixwin.scm",(void*)f_1373},
{"f_1380posixwin.scm",(void*)f_1380},
{"f_1383posixwin.scm",(void*)f_1383},
{"f_1403posixwin.scm",(void*)f_1403},
{"f_1386posixwin.scm",(void*)f_1386},
{"f_1393posixwin.scm",(void*)f_1393},
{"f_1331posixwin.scm",(void*)f_1331},
{"f_1338posixwin.scm",(void*)f_1338},
{"f_1353posixwin.scm",(void*)f_1353},
{"f_1347posixwin.scm",(void*)f_1347},
{"f_1286posixwin.scm",(void*)f_1286},
{"f_1296posixwin.scm",(void*)f_1296},
{"f_1299posixwin.scm",(void*)f_1299},
{"f_1311posixwin.scm",(void*)f_1311},
{"f_1302posixwin.scm",(void*)f_1302},
{"f_1268posixwin.scm",(void*)f_1268},
{"f_1281posixwin.scm",(void*)f_1281},
{"f_1227posixwin.scm",(void*)f_1227},
{"f_1260posixwin.scm",(void*)f_1260},
{"f_1244posixwin.scm",(void*)f_1244},
{"f_1253posixwin.scm",(void*)f_1253},
{"f_1247posixwin.scm",(void*)f_1247},
{"f_1181posixwin.scm",(void*)f_1181},
{"f_1185posixwin.scm",(void*)f_1185},
{"f_1196posixwin.scm",(void*)f_1196},
{"f_1192posixwin.scm",(void*)f_1192},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
