/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2008-09-23 22:55
   Version 3.3.0 - linux-unix-gnu-x86	[ manyargs dload ptables applyhook ]
   SVN rev. 11106	compiled 2008-07-08 on galinha (Linux)
   command line: posixunix.scm -quiet -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>
#include <math.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)
#define C_isdir             ((C_statbuf.st_mode & S_IFMT) == S_IFDIR)
#define C_ischr             ((C_statbuf.st_mode & S_IFMT) == S_IFCHR)
#define C_isblk             ((C_statbuf.st_mode & S_IFMT) == S_IFBLK)
#define C_isfifo            ((C_statbuf.st_mode & S_IFMT) == S_IFIFO)
#ifdef S_IFSOCK
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == S_IFSOCK)
#else
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == 0140000)
#endif

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set_9(v) \
        (C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)))

#define C_tm_get_08(v) \
        (C_set_block_item(v, 0, C_fix(C_tm.tm_sec)), \
        C_set_block_item(v, 1, C_fix(C_tm.tm_min)), \
        C_set_block_item(v, 2, C_fix(C_tm.tm_hour)), \
        C_set_block_item(v, 3, C_fix(C_tm.tm_mday)), \
        C_set_block_item(v, 4, C_fix(C_tm.tm_mon)), \
        C_set_block_item(v, 5, C_fix(C_tm.tm_year)), \
        C_set_block_item(v, 6, C_fix(C_tm.tm_wday)), \
        C_set_block_item(v, 7, C_fix(C_tm.tm_yday)), \
        C_set_block_item(v, 8, (C_tm.tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define C_tm_get_9(v) \
        (C_set_block_item(v, 9, C_fix(C_tm.tm_gmtoff)))

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  return v;
}

#else

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  C_tm_set_9 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  C_tm_get_9 (v);
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)
#define C_timegm(v)     ((C_temporary_flonum = timegm(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[473];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,38),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,32,108,111,99,56,32,109,115,103,57,32,46,32,97,114,103,115,49,48,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,97,49,50,49,53,41,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,97,49,54,49,57,41,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,51,48,32,99,109,100,51,49,32,46,32,103,50,57,51,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,52,49,32,102,108,97,103,115,52,50,32,46,32,109,111,100,101,52,51,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,99,108,111,115,101,32,102,100,53,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,114,101,97,100,32,102,100,53,51,32,115,105,122,101,53,52,32,46,32,98,117,102,102,101,114,53,53,41,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,119,114,105,116,101,32,102,100,54,50,32,98,117,102,102,101,114,54,51,32,46,32,115,105,122,101,54,52,41,0,0,0,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,9),40,102,100,95,122,101,114,111,41,0,0,0,0,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,14),40,102,100,95,115,101,116,32,97,56,52,56,57,41,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,15),40,102,100,95,116,101,115,116,32,97,57,48,57,53,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,13),40,97,50,48,56,52,32,102,100,49,50,49,41,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,13),40,97,50,49,48,57,32,102,100,49,49,56,41,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,13),40,97,50,49,52,57,32,102,100,49,49,49,41,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,13),40,97,50,49,55,53,32,102,100,49,48,52,41,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,57,54,32,102,100,115,119,57,55,32,46,32,116,105,109,101,111,117,116,57,56,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,49,50,55,32,108,105,110,107,49,50,56,32,108,111,99,49,50,57,41,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,115,116,97,116,32,102,49,51,50,32,46,32,108,105,110,107,49,51,51,41,0,0,0,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,51,55,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,29),40,102,105,108,101,45,109,111,100,105,102,105,99,97,116,105,111,110,45,116,105,109,101,32,102,49,51,57,41,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,52,49,41,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,52,51,41,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,52,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,52,55,41,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,24),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,110,97,109,101,49,52,57,41};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,49,53,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,24),40,115,116,97,116,45,114,101,103,117,108,97,114,63,32,102,110,97,109,101,49,53,55,41};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,26),40,115,116,97,116,45,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,49,54,49,41,0,0,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,28),40,115,116,97,116,45,99,104,97,114,45,100,101,118,105,99,101,63,32,102,110,97,109,101,49,54,53,41,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,29),40,115,116,97,116,45,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,110,97,109,101,49,54,57,41,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,21),40,115,116,97,116,45,102,105,102,111,63,32,102,110,97,109,101,49,55,51,41,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,24),40,115,116,97,116,45,115,121,109,108,105,110,107,63,32,102,110,97,109,101,49,55,55,41};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,23),40,115,116,97,116,45,115,111,99,107,101,116,63,32,102,110,97,109,101,49,56,49,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,49,56,53,32,112,111,115,49,56,54,32,46,32,119,104,101,110,99,101,49,56,55,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,15),40,97,50,52,54,54,32,120,50,49,48,50,50,57,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,36),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,50,50,32,46,32,103,50,50,49,50,50,51,41,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,51,55,41,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,50,52,56,32,115,112,101,99,50,53,52,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,53,53,41,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,53,49,32,37,115,112,101,99,50,52,54,50,55,52,41,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,50,53,48,41,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,32,46,32,103,50,52,52,50,52,53,41,0,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,50,56,48,41,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,103,50,56,52,50,56,53,41,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,17),40,105,115,112,101,114,115,101,32,103,51,48,53,51,48,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,6),40,115,101,112,63,41,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,50,56,54,57,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,15),40,97,50,56,54,51,32,103,51,49,49,51,49,54,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,50,56,56,55,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,7),40,97,50,56,57,57,41,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,17),40,97,50,56,57,51,32,46,32,103,51,49,52,51,49,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,7),40,97,50,56,56,49,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,15),40,97,50,56,53,55,32,103,51,49,51,51,49,53,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,5),40,99,119,100,41,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,51,50,53,32,114,51,50,54,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,24),40,99,97,110,111,110,105,99,97,108,45,112,97,116,104,32,112,97,116,104,51,50,48,41};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,6),40,109,111,100,101,41,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,14),40,98,97,100,109,111,100,101,32,109,51,51,51,41,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,51,51,52,32,99,109,100,51,51,53,32,105,110,112,51,51,54,32,114,51,51,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,51,52,48,32,46,32,109,51,52,49,41,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,51,52,54,32,46,32,109,51,52,55,41};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,51,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,7),40,97,51,51,53,49,41,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,20),40,97,51,51,53,55,32,46,32,114,101,115,117,108,116,115,51,55,48,41,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,51,54,54,32,112,114,111,99,51,54,55,32,46,32,109,111,100,101,51,54,56,41,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,7),40,97,51,51,55,53,41,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,20),40,97,51,51,56,49,32,46,32,114,101,115,117,108,116,115,51,55,54,41,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,51,55,50,32,112,114,111,99,51,55,51,32,46,32,109,111,100,101,51,55,52,41};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,20),40,97,51,52,48,48,32,46,32,114,101,115,117,108,116,115,51,56,51,41,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,51,55,56,32,116,104,117,110,107,51,55,57,32,46,32,109,111,100,101,51,56,48,41};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,20),40,97,51,52,50,48,32,46,32,114,101,115,117,108,116,115,51,57,50,41,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,51,56,55,32,116,104,117,110,107,51,56,56,32,46,32,109,111,100,101,51,56,57,41,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,52,48,50,41,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,52,48,52,32,112,114,111,99,52,48,53,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,52,48,56,32,115,116,97,116,101,52,48,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,12),40,97,51,53,51,53,32,115,52,49,53,41,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,52,49,52,41,0,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,115,105,103,115,52,50,49,32,109,97,115,107,52,50,50,41,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,13),40,115,105,103,110,97,108,45,109,97,115,107,41,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,52,50,53,41,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,21),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,52,50,55,41,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,52,51,48,41,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,20),40,115,101,116,45,117,115,101,114,45,105,100,33,32,105,100,52,51,54,41,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,21),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,105,100,52,52,52,41,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,36),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,52,53,51,32,46,32,103,52,53,50,52,53,52,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,52,55,52,41,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,38),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,52,54,54,32,46,32,103,52,54,53,52,54,55,41,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,16),40,95,101,110,115,117,114,101,45,103,114,111,117,112,115,41};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,52,57,48,41,0,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,19),40,100,111,52,57,54,32,108,115,116,52,57,56,32,105,52,57,57,41,0,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,21),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,52,57,53,41,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,33),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,53,49,53,32,105,100,53,49,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,53,50,48,32,109,53,50,49,41};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,39),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,53,50,52,32,117,105,100,53,50,53,32,103,105,100,53,50,54,41,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,53,51,49,32,97,99,99,53,51,50,32,108,111,99,53,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,51,55,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,51,56,41};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,38),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,112,105,100,53,52,54,32,112,103,105,100,53,52,55,41,0,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,36),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,53,53,54,32,110,101,119,53,53,55,41,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,53,54,50,41,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,108,105,110,107,32,111,108,100,53,55,55,32,110,101,119,53,55,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,18),40,109,111,100,101,32,105,110,112,53,56,51,32,109,53,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,53,56,56,32,102,100,53,56,57,32,105,110,112,53,57,48,32,114,53,57,49,41};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,53,57,52,32,46,32,109,53,57,53,41,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,53,57,55,32,46,32,109,53,57,56,41};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,54,48,51,41,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,54,48,55,32,46,32,110,101,119,54,48,56,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,7),40,97,52,54,50,51,41,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,7),40,97,52,54,51,54,41,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,7),40,97,52,54,52,56,41,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,7),40,97,52,54,54,57,41,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,25),40,108,111,111,112,32,110,54,54,55,32,109,54,54,56,32,115,116,97,114,116,54,54,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,37),40,97,52,54,55,56,32,112,111,114,116,54,54,50,32,110,54,54,51,32,100,101,115,116,54,54,52,32,115,116,97,114,116,54,54,53,41,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,22),40,98,117,109,112,101,114,32,99,117,114,54,56,51,32,112,116,114,54,56,52,41,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,7),40,97,52,56,52,48,41,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,30),40,97,52,56,52,54,32,100,101,115,116,54,57,54,54,57,56,32,99,111,110,116,63,54,57,55,54,57,57,41,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,115,116,114,54,56,49,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,24),40,97,52,55,53,52,32,112,111,114,116,54,55,56,32,108,105,109,105,116,54,55,57,41};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,54),40,98,111,100,121,54,50,53,32,110,111,110,98,108,111,99,107,105,110,103,63,54,51,51,32,98,117,102,105,54,51,52,32,111,110,45,99,108,111,115,101,54,51,53,32,109,111,114,101,63,54,51,54,41,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,62),40,100,101,102,45,109,111,114,101,63,54,51,48,32,37,110,111,110,98,108,111,99,107,105,110,103,63,54,50,49,55,48,56,32,37,98,117,102,105,54,50,50,55,48,57,32,37,111,110,45,99,108,111,115,101,54,50,51,55,49,48,41,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,49),40,100,101,102,45,111,110,45,99,108,111,115,101,54,50,57,32,37,110,111,110,98,108,111,99,107,105,110,103,63,54,50,49,55,49,50,32,37,98,117,102,105,54,50,50,55,49,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,33),40,100,101,102,45,98,117,102,105,54,50,56,32,37,110,111,110,98,108,111,99,107,105,110,103,63,54,50,49,55,49,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,21),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,54,50,55,41,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,55),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,54,49,55,32,110,97,109,54,49,56,32,102,100,54,49,57,32,46,32,103,54,49,54,54,50,48,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,20),40,112,111,107,101,32,115,116,114,55,52,55,32,108,101,110,55,52,56,41,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,14),40,97,53,48,51,55,32,115,116,114,55,54,54,41,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,7),40,97,53,48,52,51,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,7),40,97,53,48,54,52,41,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,15),40,102,95,53,48,55,51,32,115,116,114,55,53,50,41,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,29),40,108,111,111,112,32,114,101,109,55,53,55,32,115,116,97,114,116,55,53,56,32,108,101,110,55,53,57,41,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,15),40,102,95,53,48,56,56,32,115,116,114,55,53,53,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,45),40,98,111,100,121,55,51,53,32,110,111,110,98,108,111,99,107,105,110,103,63,55,52,50,32,98,117,102,105,55,52,51,32,111,110,45,99,108,111,115,101,55,52,52,41,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,49),40,100,101,102,45,111,110,45,99,108,111,115,101,55,51,57,32,37,110,111,110,98,108,111,99,107,105,110,103,63,55,51,50,55,55,52,32,37,98,117,102,105,55,51,51,55,55,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,33),40,100,101,102,45,98,117,102,105,55,51,56,32,37,110,111,110,98,108,111,99,107,105,110,103,63,55,51,50,55,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,21),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,55,51,55,41,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,56),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,55,50,56,32,110,97,109,55,50,57,32,102,100,55,51,48,32,46,32,103,55,50,55,55,51,49,41};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,55,56,53,32,111,102,102,55,56,54,41,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,30),40,115,101,116,117,112,32,112,111,114,116,55,57,48,32,97,114,103,115,55,57,49,32,108,111,99,55,57,50,41,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,27),40,101,114,114,32,109,115,103,56,48,53,32,108,111,99,107,56,48,54,32,108,111,99,56,48,55,41,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,29),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,56,48,56,32,46,32,97,114,103,115,56,48,57,41,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,56,49,49,32,46,32,97,114,103,115,56,49,50,41,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,56,49,52,32,46,32,97,114,103,115,56,49,53,41,0,0,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,21),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,56,50,52,41,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,32),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,56,50,55,32,46,32,109,111,100,101,56,50,56,41};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,19),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,56,51,50,41,0,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,56,51,53,32,118,97,108,56,51,54,41,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,56,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,56,53,51,41,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,53,48,41,0,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,21),40,99,117,114,114,101,110,116,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,66),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,56,55,52,32,108,101,110,56,55,53,32,112,114,111,116,56,55,54,32,102,108,97,103,56,55,55,32,102,100,56,55,56,32,46,32,111,102,102,56,55,57,41,0,0,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,41),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,56,57,52,32,46,32,108,101,110,56,57,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,36),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,56,57,56,41,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,26),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,57,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,115,101,99,115,57,48,49,41,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,27),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,115,101,99,115,57,48,51,41,0,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,25),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,115,101,99,115,57,49,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,30),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,57,50,56,32,46,32,103,57,50,55,57,50,57,41,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,31),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,57,52,57,32,46,32,103,57,52,56,57,53,48,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,57,53,54,41,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,25),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,57,53,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,17),40,95,101,120,105,116,32,46,32,99,111,100,101,57,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,20),40,115,101,116,45,97,108,97,114,109,33,32,97,57,55,49,57,55,52,41,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,57,55,53,32,109,111,100,101,57,55,54,32,46,32,115,105,122,101,57,55,55,41,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,57,56,52,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,57,56,55,32,112,111,114,116,57,56,56,41};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,23),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,57,57,54,41,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,48,48,55,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,7),40,97,54,50,52,54,41,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,102,110,115,49,48,52,55,41,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,43),40,97,54,50,53,50,32,100,105,114,49,48,51,50,49,48,51,53,32,102,105,108,49,48,51,51,49,48,51,54,32,101,120,116,49,48,51,52,49,48,51,55,41,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,21),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,49,48,51,48,41,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,18),40,103,108,111,98,32,46,32,112,97,116,104,115,49,48,50,56,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,18),40,102,95,54,51,54,52,32,97,49,48,54,48,49,48,54,51,41,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,104,117,110,107,49,48,53,56,41,0,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,28),40,115,101,116,97,114,103,32,97,49,48,55,49,49,48,55,55,32,97,49,48,55,48,49,48,55,56,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,28),40,115,101,116,101,110,118,32,97,49,48,56,51,49,48,56,57,32,97,49,48,56,50,49,48,57,48,41,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,14),40,100,111,49,49,49,50,32,105,49,49,49,53,41,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,21),40,100,111,49,49,48,56,32,97,108,49,49,49,48,32,105,49,49,49,49,41,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,49,48,57,57,32,97,114,103,108,105,115,116,49,49,48,53,32,101,110,118,108,105,115,116,49,49,48,54,41,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,34),40,100,101,102,45,101,110,118,108,105,115,116,49,49,48,50,32,37,97,114,103,108,105,115,116,49,48,57,55,49,49,51,53,41,0,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,17),40,100,101,102,45,97,114,103,108,105,115,116,49,49,48,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,42),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,48,57,53,32,46,32,103,49,48,57,52,49,48,57,54,41,0,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,49,52,49,32,110,111,104,97,110,103,49,49,52,50,41,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,7),40,97,54,54,52,54,41,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,36),40,97,54,54,53,50,32,101,112,105,100,49,49,53,55,32,101,110,111,114,109,49,49,53,56,32,101,99,111,100,101,49,49,53,57,41,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,25),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,49,49,52,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,17),40,115,108,101,101,112,32,97,49,49,54,53,49,49,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,49,54,57,32,46,32,115,105,103,49,49,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,49,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,49,56,49,32,46,32,97,114,103,115,49,49,56,50,41,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,7),40,97,54,56,50,50,41,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,29),40,97,54,56,50,56,32,95,49,50,48,54,32,102,108,103,49,50,48,55,32,99,111,100,49,50,48,56,41,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,8),40,102,95,54,56,48,56,41};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,49,50,48,48,32,112,105,100,49,50,48,49,32,99,108,115,118,101,99,49,50,48,50,32,105,100,120,49,50,48,51,32,105,100,120,97,49,50,48,52,32,105,100,120,98,49,50,48,53,41,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,7),40,97,54,56,53,49,41,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,19),40,97,54,56,53,55,32,105,49,50,49,50,32,111,49,50,49,51,41,0,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,49,50,49,49,41,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,49,50,49,53,32,112,111,114,116,49,50,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,49,50,50,50,32,112,111,114,116,49,50,50,51,32,115,116,100,102,100,49,50,50,52,41,0,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,14),40,115,119,97,112,112,101,100,45,101,110,100,115,41,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,7),40,97,54,57,51,50,41,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,49,50,51,52,32,97,114,103,115,49,50,51,53,32,101,110,118,49,50,51,54,32,115,116,100,111,117,116,102,49,50,51,55,32,115,116,100,105,110,102,49,50,51,56,32,115,116,100,101,114,114,102,49,50,51,57,41,0,0,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,50,52,54,32,99,109,100,49,50,52,56,32,112,105,112,101,49,50,52,57,32,115,116,100,102,49,50,53,48,32,111,110,45,99,108,111,115,101,49,50,53,50,41,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,50,53,52,32,99,109,100,49,50,53,54,32,112,105,112,101,49,50,53,55,32,115,116,100,102,49,50,53,56,32,111,110,45,99,108,111,115,101,49,50,54,48,41,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,7),40,97,54,57,56,50,41,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,50),40,97,54,57,56,56,32,105,110,112,105,112,101,49,50,54,57,32,111,117,116,112,105,112,101,49,50,55,48,32,101,114,114,112,105,112,101,49,50,55,49,32,112,105,100,49,50,55,50,41,0,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,50,54,50,32,99,109,100,49,50,54,51,32,97,114,103,115,49,50,54,52,32,101,110,118,49,50,54,53,32,115,116,100,111,117,116,102,49,50,54,54,32,115,116,100,105,110,102,49,50,54,55,32,115,116,100,101,114,114,102,49,50,54,56,41,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,17),40,97,55,48,53,49,32,103,49,50,56,50,49,50,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,50,56,49,41,0,0,0,0,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,7),40,97,55,48,54,57,41,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,38),40,97,55,48,55,53,32,105,110,49,50,56,54,32,111,117,116,49,50,56,55,32,112,105,100,49,50,56,56,32,101,114,114,49,50,56,57,41,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,52),40,37,112,114,111,99,101,115,115,32,108,111,99,49,50,55,53,32,101,114,114,63,49,50,55,54,32,99,109,100,49,50,55,55,32,97,114,103,115,49,50,55,56,32,101,110,118,49,50,55,57,41,0,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,49,50,57,56,32,97,114,103,115,49,51,48,52,32,101,110,118,49,51,48,53,41,0,0,0,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,51,48,49,32,37,97,114,103,115,49,50,57,54,49,51,48,55,41,0,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,51,48,48,41,0,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,29),40,112,114,111,99,101,115,115,32,99,109,100,49,50,57,52,32,46,32,103,49,50,57,51,49,50,57,53,41,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,49,51,49,56,32,97,114,103,115,49,51,50,52,32,101,110,118,49,51,50,53,41,0,0,0,0,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,51,50,49,32,37,97,114,103,115,49,51,49,54,49,51,50,55,41,0,0,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,51,50,48,41,0,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,42,32,99,109,100,49,51,49,52,32,46,32,103,49,51,49,51,49,51,49,53,41,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,14),40,102,95,55,51,55,49,32,120,49,51,54,49,41,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,7),40,97,55,50,56,56,41,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,7),40,97,55,50,57,54,41,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,7),40,97,55,51,50,48,41,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,19),40,108,111,111,112,32,102,115,49,51,54,51,32,114,49,51,54,52,41,0,0,0,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,16),40,102,95,55,51,57,48,32,46,32,95,49,51,53,55,41};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,16),40,102,95,55,51,56,50,32,46,32,95,49,51,53,54,41};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,51,52,52,32,97,99,116,105,111,110,49,51,53,49,32,105,100,49,51,53,50,32,108,105,109,105,116,49,51,53,51,41,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,108,105,109,105,116,49,51,52,56,32,37,97,99,116,105,111,110,49,51,52,49,49,51,55,56,32,37,105,100,49,51,52,50,49,51,55,57,41,0,0,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,28),40,100,101,102,45,105,100,49,51,52,55,32,37,97,99,116,105,111,110,49,51,52,49,49,51,56,49,41,0,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,19),40,97,55,52,49,48,32,120,49,51,56,51,32,121,49,51,56,52,41,0,0,0,0,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,99,116,105,111,110,49,51,52,54,41};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,51),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,49,51,51,56,32,112,114,101,100,49,51,51,57,32,46,32,97,99,116,105,111,110,45,105,100,45,108,105,109,105,116,49,51,52,48,41,0,0,0,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,49,51,57,56,41,0,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,14),40,97,55,53,48,57,32,112,105,100,53,53,49,41,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,7),40,97,55,53,50,55,41,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,13),40,97,55,53,51,48,32,105,100,52,53,48,41,0,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,7),40,97,55,53,52,53,41,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,7),40,97,55,53,52,56,41,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,13),40,97,55,53,53,49,32,105,100,52,52,50,41,0,0,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,7),40,97,55,53,54,54,41,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,12),40,97,55,53,54,57,32,110,52,51,51,41,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,15),40,97,55,53,55,53,32,112,111,114,116,49,57,50,41,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k7477 in set-root-directory! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1393(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1393(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k6704 */
static C_word C_fcall stub1166(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1166(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1163(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1163(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub1161(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1161(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub1092(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1092(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k6410 */
static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub1080(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1080(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k6391 */
static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k6367 */
static C_word C_fcall stub1061(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1061(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub1056(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1056(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1016(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1016(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);else return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k6176 */
static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k6153 */
static C_word C_fcall stub992(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub992(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k6042 */
static C_word C_fcall stub972(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub972(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k6020 */
static C_word C_fcall stub967(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub967(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub962(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub962(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub916(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub916(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k5791 */
static C_word C_fcall stub907(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub907(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k5710 */
static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k5648 */
static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k5548 */
static C_word C_fcall stub845(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub845(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4307 in k4303 in file-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k4023 */
static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k3892 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub482(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_ret:
#undef return

return C_r;}

/* from k3885 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub478(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub478(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

/* from k3799 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub461(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub461(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a7527 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub448(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub448(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a7545 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub446(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub446(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a7548 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub440(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub440(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a7566 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall stub438(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub438(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2000 */
static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1990 */
static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1980 */
static C_word C_fcall stub81(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub81(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1762 */
static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k1711 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub17(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub17(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

/* from k1704 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub13(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub13(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k1680 */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1656)
static void C_ccall f_1656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1659)
static void C_ccall f_1659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1662)
static void C_ccall f_1662(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1665)
static void C_ccall f_1665(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1668)
static void C_ccall f_1668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1671)
static void C_ccall f_1671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7576)
static void C_ccall f_7576(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7592)
static void C_ccall f_7592(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7580)
static void C_ccall f_7580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7583)
static void C_ccall f_7583(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2441)
static void C_ccall f_2441(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3476)
static void C_ccall f_3476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7570)
static void C_ccall f_7570(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3611)
static void C_ccall f_3611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7567)
static void C_ccall f_7567(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3668)
static void C_ccall f_3668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7552)
static void C_ccall f_7552(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7562)
static void C_ccall f_7562(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7549)
static void C_ccall f_7549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3672)
static void C_ccall f_3672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7546)
static void C_ccall f_7546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3691)
static void C_ccall f_3691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7531)
static void C_ccall f_7531(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7541)
static void C_ccall f_7541(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7528)
static void C_ccall f_7528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3695)
static void C_ccall f_3695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7510)
static void C_ccall f_7510(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7523)
static void C_ccall f_7523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7517)
static void C_ccall f_7517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4234)
static void C_ccall f_4234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4273)
static void C_ccall f_4273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7487)
static void C_ccall f_7487(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7479)
static void C_ccall f_7479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7222)
static void C_ccall f_7222(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_7222)
static void C_ccall f_7222r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7405)
static void C_fcall f_7405(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7411)
static void C_ccall f_7411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7400)
static void C_fcall f_7400(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7395)
static void C_fcall f_7395(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7224)
static void C_fcall f_7224(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7382)
static void C_ccall f_7382(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7390)
static void C_ccall f_7390(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7231)
static void C_fcall f_7231(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7370)
static void C_ccall f_7370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7364)
static void C_ccall f_7364(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7241)
static void C_ccall f_7241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7243)
static void C_fcall f_7243(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7262)
static void C_ccall f_7262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7350)
static void C_ccall f_7350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7357)
static void C_ccall f_7357(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7344)
static void C_ccall f_7344(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7277)
static void C_ccall f_7277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7337)
static void C_ccall f_7337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7334)
static void C_ccall f_7334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7321)
static void C_ccall f_7321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7297)
static void C_ccall f_7297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7319)
static void C_ccall f_7319(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7305)
static void C_ccall f_7305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7312)
static void C_ccall f_7312(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7309)
static void C_ccall f_7309(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7289)
static void C_ccall f_7289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7287)
static void C_ccall f_7287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7371)
static void C_ccall f_7371(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7162)
static void C_ccall f_7162(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7162)
static void C_ccall f_7162r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7174)
static void C_fcall f_7174(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7169)
static void C_fcall f_7169(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7164)
static void C_fcall f_7164(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7102)
static void C_ccall f_7102(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7102)
static void C_ccall f_7102r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7114)
static void C_fcall f_7114(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7109)
static void C_fcall f_7109(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7104)
static void C_fcall f_7104(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7041)
static void C_fcall f_7041(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7096)
static void C_ccall f_7096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7100)
static void C_ccall f_7100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7062)
static void C_ccall f_7062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7065)
static void C_ccall f_7065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7076)
static void C_ccall f_7076(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7070)
static void C_ccall f_7070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7043)
static void C_fcall f_7043(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7052)
static void C_ccall f_7052(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6977)
static void C_ccall f_6977(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_6989)
static void C_ccall f_6989(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7020)
static void C_ccall f_7020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7000)
static void C_ccall f_7000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7016)
static void C_ccall f_7016(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7004)
static void C_ccall f_7004(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7012)
static void C_ccall f_7012(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7008)
static void C_ccall f_7008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6983)
static void C_ccall f_6983(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6966)
static void C_fcall f_6966(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6970)
static void C_ccall f_6970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6955)
static void C_fcall f_6955(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6959)
static void C_ccall f_6959(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6910)
static void C_fcall f_6910(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6914)
static void C_ccall f_6914(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6917)
static void C_ccall f_6917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6920)
static void C_ccall f_6920(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6933)
static void C_ccall f_6933(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6937)
static void C_ccall f_6937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6940)
static void C_ccall f_6940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6943)
static void C_ccall f_6943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6931)
static void C_ccall f_6931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6894)
static C_word C_fcall f_6894(C_word *a,C_word t0);
C_noret_decl(f_6877)
static void C_fcall f_6877(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6890)
static void C_ccall f_6890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6802)
static void C_ccall f_6802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6863)
static void C_fcall f_6863(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6876)
static void C_ccall f_6876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6843)
static void C_fcall f_6843(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6858)
static void C_ccall f_6858(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6852)
static void C_ccall f_6852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6806)
static void C_fcall f_6806(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6808)
static void C_ccall f_6808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6829)
static void C_ccall f_6829(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6823)
static void C_ccall f_6823(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6750)
static void C_ccall f_6750(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6750)
static void C_ccall f_6750r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6757)
static void C_ccall f_6757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6776)
static void C_ccall f_6776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6780)
static void C_ccall f_6780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6744)
static void C_ccall f_6744(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6735)
static void C_ccall f_6735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6739)
static void C_ccall f_6739(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6708)
static void C_ccall f_6708(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6708)
static void C_ccall f_6708r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6701)
static void C_ccall f_6701(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6698)
static void C_ccall f_6698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6695)
static void C_ccall f_6695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6617)
static void C_ccall f_6617(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6617)
static void C_ccall f_6617r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6653)
static void C_ccall f_6653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6647)
static void C_ccall f_6647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6600)
static void C_ccall f_6600(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6418)
static void C_ccall f_6418(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6418)
static void C_ccall f_6418r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6552)
static void C_fcall f_6552(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6547)
static void C_fcall f_6547(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6420)
static void C_fcall f_6420(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6430)
static void C_ccall f_6430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6438)
static void C_fcall f_6438(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6484)
static C_word C_fcall f_6484(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6451)
static void C_fcall f_6451(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6476)
static void C_ccall f_6476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6454)
static void C_ccall f_6454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6399)
static C_word C_fcall f_6399(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6380)
static C_word C_fcall f_6380(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6338)
static void C_ccall f_6338(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6338)
static void C_ccall f_6338r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6360)
static void C_ccall f_6360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6364)
static void C_ccall f_6364(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6226)
static void C_ccall f_6226(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6226)
static void C_ccall f_6226r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6232)
static void C_fcall f_6232(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6253)
static void C_ccall f_6253(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6330)
static void C_ccall f_6330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6257)
static void C_ccall f_6257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6260)
static void C_ccall f_6260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6263)
static void C_ccall f_6263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6272)
static void C_fcall f_6272(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6289)
static void C_ccall f_6289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6299)
static void C_ccall f_6299(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6303)
static void C_ccall f_6303(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6247)
static void C_ccall f_6247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6214)
static void C_ccall f_6214(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6218)
static void C_ccall f_6218(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6221)
static void C_ccall f_6221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6179)
static void C_ccall f_6179(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6183)
static void C_ccall f_6183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6203)
static void C_ccall f_6203(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6207)
static void C_ccall f_6207(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6156)
static void C_ccall f_6156(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6160)
static void C_ccall f_6160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6124)
static void C_fcall f_6124(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6128)
static void C_ccall f_6128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6105)
static void C_ccall f_6105(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6109)
static void C_ccall f_6109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6112)
static void C_ccall f_6112(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6046)
static void C_ccall f_6046(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6046)
static void C_ccall f_6046r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6050)
static void C_ccall f_6050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6039)
static void C_ccall f_6039(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6011)
static void C_ccall f_6011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5983)
static void C_ccall f_5983(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5990)
static void C_ccall f_5990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5955)
static void C_ccall f_5955(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5962)
static void C_ccall f_5962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5909)
static void C_ccall f_5909(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5909)
static void C_ccall f_5909r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5913)
static void C_ccall f_5913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5926)
static void C_ccall f_5926(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5930)
static void C_ccall f_5930(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5827)
static void C_ccall f_5827(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5827)
static void C_ccall f_5827r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5831)
static void C_ccall f_5831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5837)
static void C_ccall f_5837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5859)
static void C_ccall f_5859(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5856)
static void C_ccall f_5856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5846)
static void C_ccall f_5846(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5794)
static void C_ccall f_5794(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5798)
static void C_ccall f_5798(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5775)
static void C_ccall f_5775(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5766)
static void C_ccall f_5766(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5760)
static void C_ccall f_5760(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5751)
static void C_ccall f_5751(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5716)
static void C_ccall f_5716(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5716)
static void C_ccall f_5716r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5654)
static void C_ccall f_5654(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_5654)
static void C_ccall f_5654r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_5658)
static void C_ccall f_5658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5664)
static void C_ccall f_5664(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5683)
static void C_ccall f_5683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5670)
static void C_ccall f_5670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5551)
static void C_ccall f_5551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5557)
static void C_fcall f_5557(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5561)
static void C_ccall f_5561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5569)
static void C_fcall f_5569(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5595)
static void C_ccall f_5595(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5599)
static void C_ccall f_5599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5587)
static void C_ccall f_5587(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5531)
static void C_ccall f_5531(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5539)
static void C_ccall f_5539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5514)
static void C_ccall f_5514(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5525)
static void C_ccall f_5525(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5529)
static void C_ccall f_5529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5488)
static void C_ccall f_5488(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5512)
static void C_ccall f_5512(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5495)
static void C_ccall f_5495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5445)
static void C_ccall f_5445(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5445)
static void C_ccall f_5445r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5452)
static void C_fcall f_5452(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5473)
static void C_ccall f_5473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5469)
static void C_ccall f_5469(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5417)
static void C_ccall f_5417(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5395)
static void C_ccall f_5395(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5395)
static void C_ccall f_5395r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5399)
static void C_ccall f_5399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5380)
static void C_ccall f_5380(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5380)
static void C_ccall f_5380r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5384)
static void C_ccall f_5384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5365)
static void C_ccall f_5365(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5365)
static void C_ccall f_5365r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5369)
static void C_ccall f_5369(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5347)
static void C_fcall f_5347(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5273)
static void C_fcall f_5273(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5295)
static void C_ccall f_5295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5301)
static void C_fcall f_5301(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5234)
static void C_ccall f_5234(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5262)
static void C_ccall f_5262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5258)
static void C_ccall f_5258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5251)
static void C_ccall f_5251(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4975)
static void C_ccall f_4975(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4975)
static void C_ccall f_4975r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5171)
static void C_fcall f_5171(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5166)
static void C_fcall f_5166(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5161)
static void C_fcall f_5161(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4977)
static void C_fcall f_4977(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4981)
static void C_ccall f_4981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5087)
static void C_ccall f_5087(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5088)
static void C_ccall f_5088(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5105)
static void C_fcall f_5105(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5115)
static void C_ccall f_5115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5073)
static void C_ccall f_5073(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5029)
static void C_fcall f_5029(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5065)
static void C_ccall f_5065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5044)
static void C_ccall f_5044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5054)
static void C_ccall f_5054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5038)
static void C_ccall f_5038(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5033)
static void C_ccall f_5033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5036)
static void C_ccall f_5036(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4983)
static void C_fcall f_4983(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5018)
static void C_ccall f_5018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4999)
static void C_ccall f_4999(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_4897)
static void C_fcall f_4897(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4892)
static void C_fcall f_4892(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4887)
static void C_fcall f_4887(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4882)
static void C_fcall f_4882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4503)
static void C_fcall f_4503(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4507)
static void C_ccall f_4507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4513)
static void C_ccall f_4513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4755)
static void C_ccall f_4755(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4761)
static void C_fcall f_4761(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4857)
static void C_ccall f_4857(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4847)
static void C_ccall f_4847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4841)
static void C_ccall f_4841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4763)
static void C_ccall f_4763(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4813)
static void C_ccall f_4813(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4770)
static void C_ccall f_4770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4780)
static void C_ccall f_4780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4679)
static void C_ccall f_4679(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4687)
static void C_fcall f_4687(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4689)
static void C_fcall f_4689(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4737)
static void C_ccall f_4737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4670)
static void C_ccall f_4670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4674)
static void C_ccall f_4674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4649)
static void C_ccall f_4649(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4637)
static void C_ccall f_4637(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4624)
static void C_ccall f_4624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4628)
static void C_ccall f_4628(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4619)
static void C_ccall f_4619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4622)
static void C_ccall f_4622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4537)
static void C_fcall f_4537(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void C_fcall f_4549(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4586)
static void C_ccall f_4586(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4595)
static void C_ccall f_4595(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4589)
static void C_ccall f_4589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4565)
static void C_ccall f_4565(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4568)
static void C_ccall f_4568(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4529)
static C_word C_fcall f_4529(C_word t0);
C_noret_decl(f_4514)
static void C_fcall f_4514(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4528)
static void C_ccall f_4528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4474)
static void C_ccall f_4474(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4474)
static void C_ccall f_4474r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4481)
static void C_fcall f_4481(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4484)
static void C_ccall f_4484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4429)
static void C_ccall f_4429(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4433)
static void C_ccall f_4433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4468)
static void C_ccall f_4468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4451)
static void C_ccall f_4451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4415)
static void C_ccall f_4415(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4415)
static void C_ccall f_4415r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4427)
static void C_ccall f_4427(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4401)
static void C_ccall f_4401(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4401)
static void C_ccall f_4401r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4413)
static void C_ccall f_4413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4386)
static void C_fcall f_4386(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4399)
static void C_ccall f_4399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4349)
static void C_fcall f_4349(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4357)
static void C_ccall f_4357(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4324)
static void C_ccall f_4324(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4305)
static void C_ccall f_4305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4309)
static void C_ccall f_4309(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4274)
static void C_ccall f_4274(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4285)
static void C_ccall f_4285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4236)
static void C_ccall f_4236(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4269)
static void C_ccall f_4269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4257)
static void C_ccall f_4257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4265)
static void C_ccall f_4265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4261)
static void C_ccall f_4261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4211)
static void C_ccall f_4211(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4227)
static void C_ccall f_4227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4196)
static void C_ccall f_4196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4206)
static void C_ccall f_4206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4200)
static void C_ccall f_4200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4190)
static void C_ccall f_4190(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4184)
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4178)
static void C_ccall f_4178(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4154)
static void C_fcall f_4154(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4176)
static void C_ccall f_4176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4172)
static void C_ccall f_4172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4164)
static void C_ccall f_4164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4124)
static void C_ccall f_4124(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4152)
static void C_ccall f_4152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4097)
static void C_ccall f_4097(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4122)
static void C_ccall f_4122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4033)
static void C_ccall f_4033(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4021)
static void C_ccall f_4021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3959)
static void C_ccall f_3959(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3963)
static void C_ccall f_3963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3968)
static void C_fcall f_3968(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3984)
static void C_ccall f_3984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3896)
static void C_ccall f_3896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3954)
static void C_ccall f_3954(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3900)
static void C_ccall f_3900(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3903)
static void C_ccall f_3903(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3935)
static void C_ccall f_3935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3906)
static void C_ccall f_3906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3911)
static void C_fcall f_3911(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3925)
static void C_ccall f_3925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3889)
static C_word C_fcall f_3889(C_word t0);
C_noret_decl(f_3803)
static void C_ccall f_3803(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3803)
static void C_ccall f_3803r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3807)
static void C_ccall f_3807(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3861)
static void C_ccall f_3861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3810)
static void C_fcall f_3810(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3820)
static void C_ccall f_3820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3824)
static void C_ccall f_3824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3833)
static void C_fcall f_3833(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3837)
static void C_ccall f_3837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3847)
static void C_ccall f_3847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3828)
static void C_ccall f_3828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3778)
static void C_ccall f_3778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3790)
static void C_ccall f_3790(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3786)
static void C_ccall f_3786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3764)
static void C_ccall f_3764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3776)
static void C_ccall f_3776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3772)
static void C_ccall f_3772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3697)
static void C_ccall f_3697(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3697)
static void C_ccall f_3697r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3701)
static void C_ccall f_3701(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3743)
static void C_ccall f_3743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3704)
static void C_fcall f_3704(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3714)
static void C_ccall f_3714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3718)
static void C_ccall f_3718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3722)
static void C_ccall f_3722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3726)
static void C_ccall f_3726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3730)
static void C_ccall f_3730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3674)
static void C_ccall f_3674(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3684)
static void C_ccall f_3684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3651)
static void C_ccall f_3651(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3661)
static void C_ccall f_3661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3613)
static void C_ccall f_3613(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3617)
static void C_ccall f_3617(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3624)
static void C_ccall f_3624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3628)
static void C_ccall f_3628(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3632)
static void C_ccall f_3632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3636)
static void C_ccall f_3636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3640)
static void C_ccall f_3640(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3595)
static void C_ccall f_3595(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3580)
static void C_ccall f_3580(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3574)
static void C_ccall f_3574(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3542)
static void C_ccall f_3542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3548)
static void C_fcall f_3548(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3518)
static void C_ccall f_3518(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3536)
static void C_ccall f_3536(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3525)
static void C_ccall f_3525(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3500)
static void C_ccall f_3500(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3510)
static void C_ccall f_3510(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3487)
static void C_ccall f_3487(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3478)
static void C_ccall f_3478(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3431)
static void C_ccall f_3431(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3435)
static void C_ccall f_3435(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3411)
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3411)
static void C_ccall f_3411r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3415)
static void C_ccall f_3415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3421)
static void C_ccall f_3421(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3421)
static void C_ccall f_3421r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3425)
static void C_ccall f_3425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3391)
static void C_ccall f_3391(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3391)
static void C_ccall f_3391r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3395)
static void C_ccall f_3395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3401)
static void C_ccall f_3401(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3401)
static void C_ccall f_3401r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3405)
static void C_ccall f_3405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3367)
static void C_ccall f_3367(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3367)
static void C_ccall f_3367r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3371)
static void C_ccall f_3371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3382)
static void C_ccall f_3382(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3382)
static void C_ccall f_3382r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3386)
static void C_ccall f_3386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3376)
static void C_ccall f_3376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3343)
static void C_ccall f_3343(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3343)
static void C_ccall f_3343r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3347)
static void C_ccall f_3347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3358)
static void C_ccall f_3358(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3358)
static void C_ccall f_3358r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3362)
static void C_ccall f_3362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3352)
static void C_ccall f_3352(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3334)
static void C_ccall f_3334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3322)
static void C_ccall f_3322(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3312)
static void C_ccall f_3312(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3305)
static void C_ccall f_3305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3286)
static void C_ccall f_3286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3269)
static void C_ccall f_3269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3240)
static void C_fcall f_3240(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3253)
static void C_ccall f_3253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3234)
static void C_fcall f_3234(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3222)
static C_word C_fcall f_3222(C_word t0);
C_noret_decl(f_2905)
static void C_ccall f_2905(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3212)
static void C_ccall f_3212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3032)
static void C_fcall f_3032(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3198)
static void C_ccall f_3198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3187)
static void C_ccall f_3187(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3194)
static void C_ccall f_3194(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3051)
static void C_fcall f_3051(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3180)
static void C_ccall f_3180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3159)
static void C_ccall f_3159(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3176)
static void C_ccall f_3176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3165)
static void C_ccall f_3165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3172)
static void C_ccall f_3172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3095)
static void C_fcall f_3095(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3156)
static void C_ccall f_3156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3135)
static void C_ccall f_3135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3152)
static void C_ccall f_3152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3141)
static void C_ccall f_3141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3148)
static void C_ccall f_3148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3108)
static void C_ccall f_3108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3132)
static void C_ccall f_3132(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3128)
static void C_ccall f_3128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3089)
static void C_ccall f_3089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3058)
static void C_ccall f_3058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3061)
static void C_ccall f_3061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3026)
static void C_ccall f_3026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2912)
static void C_ccall f_2912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2919)
static void C_ccall f_2919(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2921)
static void C_fcall f_2921(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2928)
static void C_ccall f_2928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3001)
static void C_ccall f_3001(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2989)
static void C_fcall f_2989(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2934)
static void C_ccall f_2934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2970)
static void C_ccall f_2970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2966)
static void C_ccall f_2966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2962)
static void C_ccall f_2962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2947)
static void C_ccall f_2947(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2849)
static void C_fcall f_2849(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2858)
static void C_ccall f_2858(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2882)
static void C_ccall f_2882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2894)
static void C_ccall f_2894(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2894)
static void C_ccall f_2894r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2900)
static void C_ccall f_2900(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2888)
static void C_ccall f_2888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2864)
static void C_ccall f_2864(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2856)
static void C_ccall f_2856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2838)
static C_word C_fcall f_2838(C_word t0);
C_noret_decl(f_2833)
static void C_fcall f_2833(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2789)
static void C_ccall f_2789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2762)
static void C_ccall f_2762(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2783)
static void C_ccall f_2783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2769)
static void C_ccall f_2769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2710)
static void C_fcall f_2710(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2718)
static void C_ccall f_2718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2705)
static void C_fcall f_2705(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2607)
static void C_fcall f_2607(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2614)
static void C_ccall f_2614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2617)
static void C_ccall f_2617(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2620)
static void C_ccall f_2620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2624)
static void C_ccall f_2624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2638)
static void C_fcall f_2638(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2648)
static void C_ccall f_2648(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2651)
static void C_ccall f_2651(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2654)
static void C_ccall f_2654(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2660)
static void C_fcall f_2660(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2581)
static void C_ccall f_2581(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2603)
static void C_ccall f_2603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2599)
static void C_ccall f_2599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2579)
static void C_ccall f_2579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2575)
static void C_ccall f_2575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2449)
static void C_ccall f_2449(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2449)
static void C_ccall f_2449r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2453)
static void C_ccall f_2453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2522)
static void C_ccall f_2522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2536)
static void C_ccall f_2536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2462)
static void C_ccall f_2462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2519)
static void C_ccall f_2519(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2467)
static void C_ccall f_2467(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2472)
static void C_ccall f_2472(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2495)
static void C_ccall f_2495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2515)
static void C_ccall f_2515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2478)
static void C_ccall f_2478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2492)
static void C_ccall f_2492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2381)
static void C_ccall f_2381(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2381)
static void C_ccall f_2381r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2394)
static void C_ccall f_2394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2406)
static void C_ccall f_2406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2400)
static void C_ccall f_2400(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2372)
static void C_ccall f_2372(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2379)
static void C_ccall f_2379(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2363)
static void C_ccall f_2363(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2370)
static void C_ccall f_2370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2354)
static void C_ccall f_2354(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2361)
static void C_ccall f_2361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2345)
static void C_ccall f_2345(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2352)
static void C_ccall f_2352(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2336)
static void C_ccall f_2336(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2343)
static void C_ccall f_2343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2327)
static void C_ccall f_2327(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2334)
static void C_ccall f_2334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2318)
static void C_ccall f_2318(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2309)
static void C_ccall f_2309(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2316)
static void C_ccall f_2316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2300)
static void C_ccall f_2300(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2294)
static void C_ccall f_2294(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2298)
static void C_ccall f_2298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2288)
static void C_ccall f_2288(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2292)
static void C_ccall f_2292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2282)
static void C_ccall f_2282(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2286)
static void C_ccall f_2286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2276)
static void C_ccall f_2276(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2280)
static void C_ccall f_2280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2270)
static void C_ccall f_2270(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2274)
static void C_ccall f_2274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2264)
static void C_ccall f_2264(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2268)
static void C_ccall f_2268(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2232)
static void C_ccall f_2232(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2232)
static void C_ccall f_2232r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2243)
static void C_ccall f_2243(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2236)
static void C_ccall f_2236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2195)
static void C_fcall f_2195(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2220)
static void C_ccall f_2220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2199)
static void C_ccall f_2199(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2003)
static void C_ccall f_2003(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2003)
static void C_ccall f_2003r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2176)
static void C_ccall f_2176(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2019)
static void C_ccall f_2019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2150)
static void C_ccall f_2150(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2025)
static void C_ccall f_2025(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2028)
static void C_fcall f_2028(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2110)
static void C_ccall f_2110(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2108)
static void C_ccall f_2108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2067)
static void C_fcall f_2067(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2085)
static void C_ccall f_2085(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2083)
static void C_ccall f_2083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2071)
static void C_fcall f_2071(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1993)
static C_word C_fcall f_1993(C_word t0,C_word t1);
C_noret_decl(f_1983)
static C_word C_fcall f_1983(C_word t0,C_word t1);
C_noret_decl(f_1977)
static C_word C_fcall f_1977(C_word t0);
C_noret_decl(f_1945)
static void C_ccall f_1945(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1952)
static void C_ccall f_1952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1958)
static void C_ccall f_1958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1965)
static void C_ccall f_1965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1906)
static void C_ccall f_1906(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1906)
static void C_ccall f_1906r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1913)
static void C_ccall f_1913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1922)
static void C_ccall f_1922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1864)
static void C_ccall f_1864(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1864)
static void C_ccall f_1864r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1874)
static void C_ccall f_1874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1877)
static void C_ccall f_1877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1880)
static void C_ccall f_1880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1849)
static void C_ccall f_1849(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1811)
static void C_ccall f_1811(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1811)
static void C_ccall f_1811r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1841)
static void C_ccall f_1841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1831)
static void C_ccall f_1831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1765)
static void C_ccall f_1765(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1765)
static void C_ccall f_1765r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1769)
static void C_ccall f_1769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1708)
static void C_ccall f_1708(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1701)
static void C_ccall f_1701(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1683)
static void C_ccall f_1683(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1683)
static void C_ccall f_1683r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1687)
static void C_ccall f_1687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1698)
static void C_ccall f_1698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1694)
static void C_ccall f_1694(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_7405)
static void C_fcall trf_7405(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7405(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7405(t0,t1);}

C_noret_decl(trf_7400)
static void C_fcall trf_7400(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7400(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7400(t0,t1,t2);}

C_noret_decl(trf_7395)
static void C_fcall trf_7395(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7395(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7395(t0,t1,t2,t3);}

C_noret_decl(trf_7224)
static void C_fcall trf_7224(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7224(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_7224(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7231)
static void C_fcall trf_7231(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7231(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7231(t0,t1);}

C_noret_decl(trf_7243)
static void C_fcall trf_7243(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7243(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7243(t0,t1,t2,t3);}

C_noret_decl(trf_7174)
static void C_fcall trf_7174(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7174(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7174(t0,t1);}

C_noret_decl(trf_7169)
static void C_fcall trf_7169(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7169(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7169(t0,t1,t2);}

C_noret_decl(trf_7164)
static void C_fcall trf_7164(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7164(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7164(t0,t1,t2,t3);}

C_noret_decl(trf_7114)
static void C_fcall trf_7114(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7114(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7114(t0,t1);}

C_noret_decl(trf_7109)
static void C_fcall trf_7109(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7109(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7109(t0,t1,t2);}

C_noret_decl(trf_7104)
static void C_fcall trf_7104(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7104(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7104(t0,t1,t2,t3);}

C_noret_decl(trf_7041)
static void C_fcall trf_7041(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7041(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_7041(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_7043)
static void C_fcall trf_7043(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7043(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7043(t0,t1,t2);}

C_noret_decl(trf_6966)
static void C_fcall trf_6966(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6966(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6966(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6955)
static void C_fcall trf_6955(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6955(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6955(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6910)
static void C_fcall trf_6910(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6910(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6910(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6877)
static void C_fcall trf_6877(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6877(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6877(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6863)
static void C_fcall trf_6863(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6863(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6863(t0,t1,t2,t3);}

C_noret_decl(trf_6843)
static void C_fcall trf_6843(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6843(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6843(t0,t1,t2);}

C_noret_decl(trf_6806)
static void C_fcall trf_6806(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6806(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6806(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6552)
static void C_fcall trf_6552(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6552(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6552(t0,t1);}

C_noret_decl(trf_6547)
static void C_fcall trf_6547(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6547(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6547(t0,t1,t2);}

C_noret_decl(trf_6420)
static void C_fcall trf_6420(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6420(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6420(t0,t1,t2,t3);}

C_noret_decl(trf_6438)
static void C_fcall trf_6438(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6438(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6438(t0,t1,t2,t3);}

C_noret_decl(trf_6451)
static void C_fcall trf_6451(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6451(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6451(t0,t1);}

C_noret_decl(trf_6232)
static void C_fcall trf_6232(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6232(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6232(t0,t1,t2);}

C_noret_decl(trf_6272)
static void C_fcall trf_6272(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6272(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6272(t0,t1,t2);}

C_noret_decl(trf_6124)
static void C_fcall trf_6124(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6124(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6124(t0,t1,t2);}

C_noret_decl(trf_5557)
static void C_fcall trf_5557(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5557(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5557(t0,t1,t2);}

C_noret_decl(trf_5569)
static void C_fcall trf_5569(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5569(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5569(t0,t1,t2);}

C_noret_decl(trf_5452)
static void C_fcall trf_5452(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5452(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5452(t0,t1);}

C_noret_decl(trf_5347)
static void C_fcall trf_5347(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5347(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5347(t0,t1,t2,t3);}

C_noret_decl(trf_5273)
static void C_fcall trf_5273(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5273(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5273(t0,t1,t2,t3);}

C_noret_decl(trf_5301)
static void C_fcall trf_5301(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5301(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5301(t0,t1);}

C_noret_decl(trf_5171)
static void C_fcall trf_5171(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5171(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5171(t0,t1);}

C_noret_decl(trf_5166)
static void C_fcall trf_5166(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5166(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5166(t0,t1,t2);}

C_noret_decl(trf_5161)
static void C_fcall trf_5161(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5161(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5161(t0,t1,t2,t3);}

C_noret_decl(trf_4977)
static void C_fcall trf_4977(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4977(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4977(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5105)
static void C_fcall trf_5105(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5105(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5105(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5029)
static void C_fcall trf_5029(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5029(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5029(t0,t1);}

C_noret_decl(trf_4983)
static void C_fcall trf_4983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4983(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4983(t0,t1,t2,t3);}

C_noret_decl(trf_4897)
static void C_fcall trf_4897(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4897(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4897(t0,t1);}

C_noret_decl(trf_4892)
static void C_fcall trf_4892(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4892(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4892(t0,t1,t2);}

C_noret_decl(trf_4887)
static void C_fcall trf_4887(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4887(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4887(t0,t1,t2,t3);}

C_noret_decl(trf_4882)
static void C_fcall trf_4882(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4882(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4882(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4503)
static void C_fcall trf_4503(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4503(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_4503(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_4761)
static void C_fcall trf_4761(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4761(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4761(t0,t1,t2);}

C_noret_decl(trf_4687)
static void C_fcall trf_4687(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4687(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4687(t0,t1);}

C_noret_decl(trf_4689)
static void C_fcall trf_4689(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4689(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4689(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4537)
static void C_fcall trf_4537(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4537(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4537(t0,t1);}

C_noret_decl(trf_4549)
static void C_fcall trf_4549(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4549(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4549(t0,t1);}

C_noret_decl(trf_4514)
static void C_fcall trf_4514(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4514(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4514(t0,t1);}

C_noret_decl(trf_4481)
static void C_fcall trf_4481(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4481(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4481(t0,t1);}

C_noret_decl(trf_4386)
static void C_fcall trf_4386(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4386(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4386(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4349)
static void C_fcall trf_4349(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4349(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4349(t0,t1,t2);}

C_noret_decl(trf_4154)
static void C_fcall trf_4154(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4154(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4154(t0,t1,t2,t3);}

C_noret_decl(trf_3968)
static void C_fcall trf_3968(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3968(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3968(t0,t1,t2,t3);}

C_noret_decl(trf_3911)
static void C_fcall trf_3911(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3911(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3911(t0,t1,t2);}

C_noret_decl(trf_3810)
static void C_fcall trf_3810(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3810(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3810(t0,t1);}

C_noret_decl(trf_3833)
static void C_fcall trf_3833(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3833(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3833(t0,t1,t2);}

C_noret_decl(trf_3704)
static void C_fcall trf_3704(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3704(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3704(t0,t1);}

C_noret_decl(trf_3548)
static void C_fcall trf_3548(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3548(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3548(t0,t1,t2,t3);}

C_noret_decl(trf_3240)
static void C_fcall trf_3240(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3240(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3240(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3234)
static void C_fcall trf_3234(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3234(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3234(t0,t1);}

C_noret_decl(trf_3032)
static void C_fcall trf_3032(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3032(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3032(t0,t1);}

C_noret_decl(trf_3051)
static void C_fcall trf_3051(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3051(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3051(t0,t1);}

C_noret_decl(trf_3095)
static void C_fcall trf_3095(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3095(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3095(t0,t1);}

C_noret_decl(trf_2921)
static void C_fcall trf_2921(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2921(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2921(t0,t1,t2,t3);}

C_noret_decl(trf_2989)
static void C_fcall trf_2989(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2989(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2989(t0,t1);}

C_noret_decl(trf_2849)
static void C_fcall trf_2849(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2849(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2849(t0,t1);}

C_noret_decl(trf_2833)
static void C_fcall trf_2833(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2833(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2833(t0,t1);}

C_noret_decl(trf_2710)
static void C_fcall trf_2710(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2710(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2710(t0,t1);}

C_noret_decl(trf_2705)
static void C_fcall trf_2705(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2705(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2705(t0,t1,t2);}

C_noret_decl(trf_2607)
static void C_fcall trf_2607(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2607(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2607(t0,t1,t2,t3);}

C_noret_decl(trf_2638)
static void C_fcall trf_2638(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2638(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2638(t0,t1);}

C_noret_decl(trf_2660)
static void C_fcall trf_2660(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2660(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2660(t0,t1);}

C_noret_decl(trf_2195)
static void C_fcall trf_2195(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2195(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2195(t0,t1,t2,t3);}

C_noret_decl(trf_2028)
static void C_fcall trf_2028(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2028(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2028(t0,t1);}

C_noret_decl(trf_2067)
static void C_fcall trf_2067(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2067(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2067(t0,t1);}

C_noret_decl(trf_2071)
static void C_fcall trf_2071(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2071(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2071(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3410)){
C_save(t1);
C_rereclaim2(3410*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,473);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[9]=C_h_intern(&lf[9],21,"\003sysfile-nonblocking!");
lf[10]=C_h_intern(&lf[10],19,"\003sysfile-select-one");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"fcntl/dupfd");
lf[13]=C_h_intern(&lf[13],11,"fcntl/getfd");
lf[14]=C_h_intern(&lf[14],11,"fcntl/setfd");
lf[15]=C_h_intern(&lf[15],11,"fcntl/getfl");
lf[16]=C_h_intern(&lf[16],11,"fcntl/setfl");
lf[17]=C_h_intern(&lf[17],11,"open/rdonly");
lf[18]=C_h_intern(&lf[18],11,"open/wronly");
lf[19]=C_h_intern(&lf[19],9,"open/rdwr");
lf[20]=C_h_intern(&lf[20],9,"open/read");
lf[21]=C_h_intern(&lf[21],10,"open/write");
lf[22]=C_h_intern(&lf[22],10,"open/creat");
lf[23]=C_h_intern(&lf[23],11,"open/append");
lf[24]=C_h_intern(&lf[24],9,"open/excl");
lf[25]=C_h_intern(&lf[25],11,"open/noctty");
lf[26]=C_h_intern(&lf[26],13,"open/nonblock");
lf[27]=C_h_intern(&lf[27],10,"open/trunc");
lf[28]=C_h_intern(&lf[28],9,"open/sync");
lf[29]=C_h_intern(&lf[29],10,"open/fsync");
lf[30]=C_h_intern(&lf[30],11,"open/binary");
lf[31]=C_h_intern(&lf[31],9,"open/text");
lf[32]=C_h_intern(&lf[32],10,"perm/irusr");
lf[33]=C_h_intern(&lf[33],10,"perm/iwusr");
lf[34]=C_h_intern(&lf[34],10,"perm/ixusr");
lf[35]=C_h_intern(&lf[35],10,"perm/irgrp");
lf[36]=C_h_intern(&lf[36],10,"perm/iwgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/ixgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/iroth");
lf[39]=C_h_intern(&lf[39],10,"perm/iwoth");
lf[40]=C_h_intern(&lf[40],10,"perm/ixoth");
lf[41]=C_h_intern(&lf[41],10,"perm/irwxu");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxg");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxo");
lf[44]=C_h_intern(&lf[44],10,"perm/isvtx");
lf[45]=C_h_intern(&lf[45],10,"perm/isuid");
lf[46]=C_h_intern(&lf[46],10,"perm/isgid");
lf[47]=C_h_intern(&lf[47],12,"file-control");
lf[48]=C_h_intern(&lf[48],11,"\000file-error");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[50]=C_h_intern(&lf[50],9,"\003syserror");
lf[51]=C_h_intern(&lf[51],9,"file-open");
lf[52]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[53]=C_h_intern(&lf[53],17,"\003sysmake-c-string");
lf[54]=C_h_intern(&lf[54],20,"\003sysexpand-home-path");
lf[55]=C_h_intern(&lf[55],10,"file-close");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[57]=C_h_intern(&lf[57],11,"make-string");
lf[58]=C_h_intern(&lf[58],9,"file-read");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[60]=C_h_intern(&lf[60],11,"\000type-error");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[62]=C_h_intern(&lf[62],10,"file-write");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[65]=C_h_intern(&lf[65],12,"file-mkstemp");
lf[66]=C_h_intern(&lf[66],13,"\003syssubstring");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[68]=C_h_intern(&lf[68],11,"file-select");
lf[69]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[70]=C_h_intern(&lf[70],12,"\003sysfor-each");
lf[71]=C_h_intern(&lf[71],8,"seek/set");
lf[72]=C_h_intern(&lf[72],8,"seek/end");
lf[73]=C_h_intern(&lf[73],8,"seek/cur");
lf[75]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[76]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[77]=C_h_intern(&lf[77],9,"file-stat");
lf[78]=C_h_intern(&lf[78],9,"file-size");
lf[79]=C_h_intern(&lf[79],22,"file-modification-time");
lf[80]=C_h_intern(&lf[80],16,"file-access-time");
lf[81]=C_h_intern(&lf[81],16,"file-change-time");
lf[82]=C_h_intern(&lf[82],10,"file-owner");
lf[83]=C_h_intern(&lf[83],16,"file-permissions");
lf[84]=C_h_intern(&lf[84],13,"regular-file\077");
lf[85]=C_h_intern(&lf[85],14,"symbolic-link\077");
lf[86]=C_h_intern(&lf[86],13,"stat-regular\077");
lf[87]=C_h_intern(&lf[87],15,"stat-directory\077");
lf[88]=C_h_intern(&lf[88],17,"stat-char-device\077");
lf[89]=C_h_intern(&lf[89],18,"stat-block-device\077");
lf[90]=C_h_intern(&lf[90],10,"stat-fifo\077");
lf[91]=C_h_intern(&lf[91],13,"stat-symlink\077");
lf[92]=C_h_intern(&lf[92],12,"stat-socket\077");
lf[93]=C_h_intern(&lf[93],18,"set-file-position!");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[95]=C_h_intern(&lf[95],6,"stream");
lf[96]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[97]=C_h_intern(&lf[97],5,"port\077");
lf[98]=C_h_intern(&lf[98],13,"\000bounds-error");
lf[99]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[100]=C_h_intern(&lf[100],13,"file-position");
lf[101]=C_h_intern(&lf[101],20,"g196-1222221336.0399");
lf[102]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[103]=C_h_intern(&lf[103],20,"g202-1222221336.0570");
lf[104]=C_decode_literal(C_heaptop,"\376B\000\000\026path segment is a file");
lf[105]=C_h_intern(&lf[105],20,"g201-1222221336.0539");
lf[106]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot stat file");
lf[107]=C_h_intern(&lf[107],20,"g218-1222221336.0976");
lf[108]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[109]=C_h_intern(&lf[109],20,"g217-1222221336.0595");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[111]=C_h_intern(&lf[111],20,"g216-1222221336.0544");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[113]=C_h_intern(&lf[113],16,"create-directory");
lf[114]=C_h_intern(&lf[114],12,"file-exists\077");
lf[115]=C_h_intern(&lf[115],12,"string-split");
lf[116]=C_h_intern(&lf[116],14,"canonical-path");
lf[117]=C_h_intern(&lf[117],16,"change-directory");
lf[118]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[119]=C_h_intern(&lf[119],16,"delete-directory");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[121]=C_h_intern(&lf[121],10,"string-ref");
lf[122]=C_h_intern(&lf[122],6,"string");
lf[123]=C_h_intern(&lf[123],9,"directory");
lf[124]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[125]=C_h_intern(&lf[125],16,"\003sysmake-pointer");
lf[126]=C_h_intern(&lf[126],17,"current-directory");
lf[127]=C_h_intern(&lf[127],10,"directory\077");
lf[128]=C_h_intern(&lf[128],13,"\003sysfile-info");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[130]=C_h_intern(&lf[130],5,"null\077");
lf[131]=C_h_intern(&lf[131],6,"char=\077");
lf[132]=C_h_intern(&lf[132],8,"string=\077");
lf[133]=C_h_intern(&lf[133],16,"char-alphabetic\077");
lf[134]=C_h_intern(&lf[134],18,"string-intersperse");
lf[135]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[136]=C_h_intern(&lf[136],6,"getenv");
lf[137]=C_h_intern(&lf[137],17,"current-user-name");
lf[138]=C_h_intern(&lf[138],9,"condition");
lf[139]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[140]=C_h_intern(&lf[140],22,"with-exception-handler");
lf[141]=C_h_intern(&lf[141],30,"call-with-current-continuation");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[144]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[145]=C_h_intern(&lf[145],7,"reverse");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[148]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[149]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[151]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\006/home/");
lf[153]=C_decode_literal(C_heaptop,"\376B\000\000\004HOME");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[155]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[156]=C_h_intern(&lf[156],5,"\000text");
lf[157]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[158]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[159]=C_h_intern(&lf[159],13,"\003sysmake-port");
lf[160]=C_h_intern(&lf[160],21,"\003sysstream-port-class");
lf[161]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[162]=C_h_intern(&lf[162],15,"open-input-pipe");
lf[163]=C_h_intern(&lf[163],7,"\000binary");
lf[164]=C_h_intern(&lf[164],16,"open-output-pipe");
lf[165]=C_h_intern(&lf[165],16,"close-input-pipe");
lf[166]=C_h_intern(&lf[166],23,"close-input/output-pipe");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[168]=C_h_intern(&lf[168],14,"\003syscheck-port");
lf[169]=C_h_intern(&lf[169],17,"close-output-pipe");
lf[170]=C_h_intern(&lf[170],20,"call-with-input-pipe");
lf[171]=C_h_intern(&lf[171],21,"call-with-output-pipe");
lf[172]=C_h_intern(&lf[172],20,"with-input-from-pipe");
lf[173]=C_h_intern(&lf[173],18,"\003sysstandard-input");
lf[174]=C_h_intern(&lf[174],19,"with-output-to-pipe");
lf[175]=C_h_intern(&lf[175],19,"\003sysstandard-output");
lf[176]=C_h_intern(&lf[176],11,"create-pipe");
lf[177]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[178]=C_h_intern(&lf[178],11,"signal/term");
lf[179]=C_h_intern(&lf[179],11,"signal/kill");
lf[180]=C_h_intern(&lf[180],10,"signal/int");
lf[181]=C_h_intern(&lf[181],10,"signal/hup");
lf[182]=C_h_intern(&lf[182],10,"signal/fpe");
lf[183]=C_h_intern(&lf[183],10,"signal/ill");
lf[184]=C_h_intern(&lf[184],11,"signal/segv");
lf[185]=C_h_intern(&lf[185],11,"signal/abrt");
lf[186]=C_h_intern(&lf[186],11,"signal/trap");
lf[187]=C_h_intern(&lf[187],11,"signal/quit");
lf[188]=C_h_intern(&lf[188],11,"signal/alrm");
lf[189]=C_h_intern(&lf[189],13,"signal/vtalrm");
lf[190]=C_h_intern(&lf[190],11,"signal/prof");
lf[191]=C_h_intern(&lf[191],9,"signal/io");
lf[192]=C_h_intern(&lf[192],10,"signal/urg");
lf[193]=C_h_intern(&lf[193],11,"signal/chld");
lf[194]=C_h_intern(&lf[194],11,"signal/cont");
lf[195]=C_h_intern(&lf[195],11,"signal/stop");
lf[196]=C_h_intern(&lf[196],11,"signal/tstp");
lf[197]=C_h_intern(&lf[197],11,"signal/pipe");
lf[198]=C_h_intern(&lf[198],11,"signal/xcpu");
lf[199]=C_h_intern(&lf[199],11,"signal/xfsz");
lf[200]=C_h_intern(&lf[200],11,"signal/usr1");
lf[201]=C_h_intern(&lf[201],11,"signal/usr2");
lf[202]=C_h_intern(&lf[202],12,"signal/winch");
lf[203]=C_h_intern(&lf[203],12,"signals-list");
lf[204]=C_h_intern(&lf[204],18,"\003sysinterrupt-hook");
lf[205]=C_h_intern(&lf[205],14,"signal-handler");
lf[206]=C_h_intern(&lf[206],19,"set-signal-handler!");
lf[207]=C_h_intern(&lf[207],16,"set-signal-mask!");
lf[208]=C_h_intern(&lf[208],14,"\000process-error");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[210]=C_h_intern(&lf[210],11,"signal-mask");
lf[211]=C_h_intern(&lf[211],14,"signal-masked\077");
lf[212]=C_h_intern(&lf[212],12,"signal-mask!");
lf[213]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[214]=C_h_intern(&lf[214],14,"signal-unmask!");
lf[215]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[216]=C_h_intern(&lf[216],18,"system-information");
lf[217]=C_h_intern(&lf[217],25,"\003syspeek-nonnull-c-string");
lf[218]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[219]=C_h_intern(&lf[219],12,"set-user-id!");
lf[220]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[221]=C_h_intern(&lf[221],15,"current-user-id");
lf[222]=C_h_intern(&lf[222],25,"current-effective-user-id");
lf[223]=C_h_intern(&lf[223],13,"set-group-id!");
lf[224]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[225]=C_h_intern(&lf[225],16,"current-group-id");
lf[226]=C_h_intern(&lf[226],26,"current-effective-group-id");
lf[227]=C_h_intern(&lf[227],16,"user-information");
lf[228]=C_h_intern(&lf[228],6,"vector");
lf[229]=C_h_intern(&lf[229],4,"list");
lf[230]=C_h_intern(&lf[230],27,"current-effective-user-name");
lf[231]=C_h_intern(&lf[231],17,"group-information");
lf[233]=C_h_intern(&lf[233],10,"get-groups");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[237]=C_h_intern(&lf[237],11,"set-groups!");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[240]=C_h_intern(&lf[240],17,"initialize-groups");
lf[241]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[242]=C_h_intern(&lf[242],10,"errno/perm");
lf[243]=C_h_intern(&lf[243],11,"errno/noent");
lf[244]=C_h_intern(&lf[244],10,"errno/srch");
lf[245]=C_h_intern(&lf[245],10,"errno/intr");
lf[246]=C_h_intern(&lf[246],8,"errno/io");
lf[247]=C_h_intern(&lf[247],12,"errno/noexec");
lf[248]=C_h_intern(&lf[248],10,"errno/badf");
lf[249]=C_h_intern(&lf[249],11,"errno/child");
lf[250]=C_h_intern(&lf[250],11,"errno/nomem");
lf[251]=C_h_intern(&lf[251],11,"errno/acces");
lf[252]=C_h_intern(&lf[252],11,"errno/fault");
lf[253]=C_h_intern(&lf[253],10,"errno/busy");
lf[254]=C_h_intern(&lf[254],12,"errno/notdir");
lf[255]=C_h_intern(&lf[255],11,"errno/isdir");
lf[256]=C_h_intern(&lf[256],11,"errno/inval");
lf[257]=C_h_intern(&lf[257],11,"errno/mfile");
lf[258]=C_h_intern(&lf[258],11,"errno/nospc");
lf[259]=C_h_intern(&lf[259],11,"errno/spipe");
lf[260]=C_h_intern(&lf[260],10,"errno/pipe");
lf[261]=C_h_intern(&lf[261],11,"errno/again");
lf[262]=C_h_intern(&lf[262],10,"errno/rofs");
lf[263]=C_h_intern(&lf[263],11,"errno/exist");
lf[264]=C_h_intern(&lf[264],16,"errno/wouldblock");
lf[265]=C_h_intern(&lf[265],10,"errno/2big");
lf[266]=C_h_intern(&lf[266],12,"errno/deadlk");
lf[267]=C_h_intern(&lf[267],9,"errno/dom");
lf[268]=C_h_intern(&lf[268],10,"errno/fbig");
lf[269]=C_h_intern(&lf[269],11,"errno/ilseq");
lf[270]=C_h_intern(&lf[270],11,"errno/mlink");
lf[271]=C_h_intern(&lf[271],17,"errno/nametoolong");
lf[272]=C_h_intern(&lf[272],11,"errno/nfile");
lf[273]=C_h_intern(&lf[273],11,"errno/nodev");
lf[274]=C_h_intern(&lf[274],11,"errno/nolck");
lf[275]=C_h_intern(&lf[275],11,"errno/nosys");
lf[276]=C_h_intern(&lf[276],14,"errno/notempty");
lf[277]=C_h_intern(&lf[277],11,"errno/notty");
lf[278]=C_h_intern(&lf[278],10,"errno/nxio");
lf[279]=C_h_intern(&lf[279],11,"errno/range");
lf[280]=C_h_intern(&lf[280],10,"errno/xdev");
lf[281]=C_h_intern(&lf[281],16,"change-file-mode");
lf[282]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[283]=C_h_intern(&lf[283],17,"change-file-owner");
lf[284]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[285]=C_h_intern(&lf[285],17,"file-read-access\077");
lf[286]=C_h_intern(&lf[286],18,"file-write-access\077");
lf[287]=C_h_intern(&lf[287],20,"file-execute-access\077");
lf[288]=C_h_intern(&lf[288],14,"create-session");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[290]=C_h_intern(&lf[290],21,"set-process-group-id!");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[292]=C_h_intern(&lf[292],16,"process-group-id");
lf[293]=C_h_intern(&lf[293],20,"create-symbolic-link");
lf[294]=C_h_intern(&lf[294],18,"create-symbol-link");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[296]=C_h_intern(&lf[296],9,"substring");
lf[297]=C_h_intern(&lf[297],18,"read-symbolic-link");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[299]=C_h_intern(&lf[299],9,"file-link");
lf[300]=C_h_intern(&lf[300],9,"hard-link");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[302]=C_h_intern(&lf[302],12,"fileno/stdin");
lf[303]=C_h_intern(&lf[303],13,"fileno/stdout");
lf[304]=C_h_intern(&lf[304],13,"fileno/stderr");
lf[305]=C_h_intern(&lf[305],7,"\000append");
lf[306]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[308]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[312]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[313]=C_h_intern(&lf[313],16,"open-input-file*");
lf[314]=C_h_intern(&lf[314],17,"open-output-file*");
lf[315]=C_h_intern(&lf[315],12,"port->fileno");
lf[316]=C_h_intern(&lf[316],6,"socket");
lf[317]=C_h_intern(&lf[317],20,"\003systcp-port->fileno");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[320]=C_h_intern(&lf[320],25,"\003syspeek-unsigned-integer");
lf[321]=C_h_intern(&lf[321],16,"duplicate-fileno");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[323]=C_h_intern(&lf[323],15,"make-input-port");
lf[324]=C_h_intern(&lf[324],14,"set-port-name!");
lf[325]=C_h_intern(&lf[325],21,"\003syscustom-input-port");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[327]=C_h_intern(&lf[327],17,"\003systhread-yield!");
lf[328]=C_h_intern(&lf[328],25,"\003systhread-block-for-i/o!");
lf[329]=C_h_intern(&lf[329],18,"\003syscurrent-thread");
lf[330]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[334]=C_h_intern(&lf[334],17,"\003sysstring-append");
lf[335]=C_h_intern(&lf[335],15,"\003sysmake-string");
lf[336]=C_h_intern(&lf[336],20,"\003sysscan-buffer-line");
lf[337]=C_h_intern(&lf[337],4,"noop");
lf[338]=C_h_intern(&lf[338],16,"make-output-port");
lf[339]=C_h_intern(&lf[339],22,"\003syscustom-output-port");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[342]=C_h_intern(&lf[342],13,"file-truncate");
lf[343]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[345]=C_h_intern(&lf[345],4,"lock");
lf[346]=C_h_intern(&lf[346],9,"file-lock");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[348]=C_h_intern(&lf[348],18,"file-lock/blocking");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[350]=C_h_intern(&lf[350],14,"file-test-lock");
lf[351]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[352]=C_h_intern(&lf[352],11,"file-unlock");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[354]=C_h_intern(&lf[354],11,"create-fifo");
lf[355]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[356]=C_h_intern(&lf[356],5,"fifo\077");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[358]=C_h_intern(&lf[358],6,"setenv");
lf[359]=C_h_intern(&lf[359],8,"unsetenv");
lf[360]=C_h_intern(&lf[360],19,"current-environment");
lf[361]=C_h_intern(&lf[361],9,"prot/read");
lf[362]=C_h_intern(&lf[362],10,"prot/write");
lf[363]=C_h_intern(&lf[363],9,"prot/exec");
lf[364]=C_h_intern(&lf[364],9,"prot/none");
lf[365]=C_h_intern(&lf[365],9,"map/fixed");
lf[366]=C_h_intern(&lf[366],10,"map/shared");
lf[367]=C_h_intern(&lf[367],11,"map/private");
lf[368]=C_h_intern(&lf[368],13,"map/anonymous");
lf[369]=C_h_intern(&lf[369],8,"map/file");
lf[370]=C_h_intern(&lf[370],18,"map-file-to-memory");
lf[371]=C_h_intern(&lf[371],4,"mmap");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[373]=C_h_intern(&lf[373],20,"\003syspointer->address");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[375]=C_h_intern(&lf[375],16,"\003sysnull-pointer");
lf[376]=C_h_intern(&lf[376],22,"unmap-file-from-memory");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[378]=C_h_intern(&lf[378],26,"memory-mapped-file-pointer");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],19,"seconds->local-time");
lf[381]=C_h_intern(&lf[381],18,"\003sysdecode-seconds");
lf[382]=C_h_intern(&lf[382],17,"seconds->utc-time");
lf[383]=C_h_intern(&lf[383],15,"seconds->string");
lf[384]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[385]=C_h_intern(&lf[385],12,"time->string");
lf[386]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[388]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[389]=C_h_intern(&lf[389],12,"string->time");
lf[390]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[391]=C_h_intern(&lf[391],19,"local-time->seconds");
lf[392]=C_h_intern(&lf[392],15,"\003syscons-flonum");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[395]=C_h_intern(&lf[395],17,"utc-time->seconds");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[398]=C_h_intern(&lf[398],27,"local-timezone-abbreviation");
lf[399]=C_h_intern(&lf[399],5,"_exit");
lf[400]=C_h_intern(&lf[400],10,"set-alarm!");
lf[401]=C_h_intern(&lf[401],19,"set-buffering-mode!");
lf[402]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[403]=C_h_intern(&lf[403],5,"\000full");
lf[404]=C_h_intern(&lf[404],5,"\000line");
lf[405]=C_h_intern(&lf[405],5,"\000none");
lf[406]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[407]=C_h_intern(&lf[407],14,"terminal-port\077");
lf[409]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[410]=C_h_intern(&lf[410],13,"terminal-name");
lf[411]=C_h_intern(&lf[411],13,"terminal-size");
lf[412]=C_h_intern(&lf[412],6,"\000error");
lf[413]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[414]=C_h_intern(&lf[414],17,"\003sysmake-locative");
lf[415]=C_h_intern(&lf[415],8,"location");
lf[416]=C_h_intern(&lf[416],13,"get-host-name");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[418]=C_h_intern(&lf[418],6,"regexp");
lf[419]=C_h_intern(&lf[419],21,"make-anchored-pattern");
lf[420]=C_h_intern(&lf[420],12,"string-match");
lf[421]=C_h_intern(&lf[421],12,"glob->regexp");
lf[422]=C_h_intern(&lf[422],13,"make-pathname");
lf[423]=C_h_intern(&lf[423],18,"decompose-pathname");
lf[424]=C_h_intern(&lf[424],4,"glob");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[426]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[427]=C_h_intern(&lf[427],12,"process-fork");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[429]=C_h_intern(&lf[429],24,"pathname-strip-directory");
lf[430]=C_h_intern(&lf[430],15,"process-execute");
lf[431]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[432]=C_h_intern(&lf[432],16,"\003sysprocess-wait");
lf[433]=C_h_intern(&lf[433],12,"process-wait");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[435]=C_h_intern(&lf[435],18,"current-process-id");
lf[436]=C_h_intern(&lf[436],17,"parent-process-id");
lf[437]=C_h_intern(&lf[437],5,"sleep");
lf[438]=C_h_intern(&lf[438],14,"process-signal");
lf[439]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[440]=C_h_intern(&lf[440],17,"\003sysshell-command");
lf[441]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[443]=C_h_intern(&lf[443],27,"\003sysshell-command-arguments");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[445]=C_h_intern(&lf[445],11,"process-run");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[447]=C_h_intern(&lf[447],11,"\003sysprocess");
lf[448]=C_h_intern(&lf[448],19,"\003sysundefined-value");
lf[449]=C_h_intern(&lf[449],7,"process");
lf[450]=C_h_intern(&lf[450],8,"process*");
lf[451]=C_h_intern(&lf[451],10,"find-files");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[455]=C_h_intern(&lf[455],16,"\003sysdynamic-wind");
lf[456]=C_h_intern(&lf[456],13,"pathname-file");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[458]=C_h_intern(&lf[458],7,"regexp\077");
lf[459]=C_h_intern(&lf[459],19,"set-root-directory!");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[462]=C_h_intern(&lf[462],18,"getter-with-setter");
lf[463]=C_h_intern(&lf[463],26,"effective-group-id!-setter");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[465]=C_h_intern(&lf[465],25,"effective-user-id!-setter");
lf[466]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[467]=C_h_intern(&lf[467],23,"\003sysuser-interrupt-hook");
lf[468]=C_h_intern(&lf[468],11,"make-vector");
lf[469]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[470]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[471]=C_h_intern(&lf[471],17,"register-feature!");
lf[472]=C_h_intern(&lf[472],5,"posix");
C_register_lf2(lf,473,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1656,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1654 */
static void C_ccall f_1656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1659,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1657 in k1654 */
static void C_ccall f_1659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1659,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1662,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1660 in k1657 in k1654 */
static void C_ccall f_1662(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1662,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1665,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1665,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1668,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1668,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1671,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 508  register-feature! */
t3=*((C_word*)lf[471]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[472]);}

/* k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word ab[113],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1671,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1683,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[8]+1,lf[3]);
t5=C_mutate((C_word*)lf[9]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1701,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[10]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1708,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[11]+1,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[12]+1,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[13]+1,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[14]+1,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[15]+1,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[16]+1,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1765,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[51]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1811,a[2]=t45,a[3]=((C_word)li4),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1849,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t48=*((C_word*)lf[57]+1);
t49=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1864,a[2]=t48,a[3]=((C_word)li6),tmp=(C_word)a,a+=4,tmp));
t50=C_mutate((C_word*)lf[62]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1906,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[65]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1945,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1977,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp);
t53=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1983,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp);
t54=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1993,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp);
t55=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2003,a[2]=t53,a[3]=t54,a[4]=t52,a[5]=((C_word)li16),tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[71]+1,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[72]+1,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[73]+1,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[74],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2195,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2232,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2264,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2270,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2276,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[81]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2282,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[82]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2288,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2294,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2300,a[2]=((C_word)li25),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2309,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[86]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2318,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2327,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2336,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2345,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2354,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[91]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2363,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2372,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2381,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t77=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2441,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t78=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7576,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 848  getter-with-setter */
t79=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t79))(4,t79,t77,t78,*((C_word*)lf[93]+1));}

/* a7575 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7576(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7576,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7580,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7592,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 850  port? */
t5=*((C_word*)lf[97]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7590 in a7575 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[95]);
t4=((C_word*)t0)[2];
f_7580(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_7580(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 855  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[60],lf[100],lf[470],((C_word*)t0)[3]);}}}

/* k7578 in a7575 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7580,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7583,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 857  posix-error */
t3=lf[3];
f_1683(6,t3,t2,lf[48],lf[100],lf[469],((C_word*)t0)[2]);}
else{
t3=t2;
f_7583(2,t3,C_SCHEME_UNDEFINED);}}

/* k7581 in k7578 in a7575 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[171],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2441,2,t0,t1);}
t2=C_mutate((C_word*)lf[100]+1,t1);
t3=C_mutate((C_word*)lf[101]+1,lf[102]);
t4=C_mutate((C_word*)lf[103]+1,lf[104]);
t5=C_mutate((C_word*)lf[105]+1,lf[106]);
t6=C_mutate((C_word*)lf[107]+1,lf[108]);
t7=C_mutate((C_word*)lf[109]+1,lf[110]);
t8=C_mutate((C_word*)lf[111]+1,lf[112]);
t9=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2449,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2557,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2581,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t12=*((C_word*)lf[121]+1);
t13=*((C_word*)lf[57]+1);
t14=*((C_word*)lf[122]+1);
t15=C_mutate((C_word*)lf[123]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2605,a[2]=t13,a[3]=t12,a[4]=((C_word)li43),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate((C_word*)lf[127]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2762,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp));
t17=*((C_word*)lf[57]+1);
t18=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2785,a[2]=t17,a[3]=((C_word)li45),tmp=(C_word)a,a+=4,tmp));
t19=*((C_word*)lf[130]+1);
t20=*((C_word*)lf[131]+1);
t21=*((C_word*)lf[132]+1);
t22=*((C_word*)lf[133]+1);
t23=*((C_word*)lf[121]+1);
t24=*((C_word*)lf[2]+1);
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2833,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2838,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
t27=*((C_word*)lf[136]+1);
t28=*((C_word*)lf[137]+1);
t29=*((C_word*)lf[126]+1);
t30=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2849,a[2]=t29,a[3]=((C_word)li55),tmp=(C_word)a,a+=4,tmp);
t31=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_2905,a[2]=t22,a[3]=t20,a[4]=t27,a[5]=t28,a[6]=t30,a[7]=t21,a[8]=t19,a[9]=t23,a[10]=t25,a[11]=t24,a[12]=t26,a[13]=((C_word)li57),tmp=(C_word)a,a+=14,tmp));
t32=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3222,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp);
t33=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3234,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp);
t34=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3240,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp);
t35=C_mutate((C_word*)lf[162]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3255,a[2]=t33,a[3]=t34,a[4]=t32,a[5]=((C_word)li61),tmp=(C_word)a,a+=6,tmp));
t36=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3291,a[2]=t33,a[3]=t34,a[4]=t32,a[5]=((C_word)li62),tmp=(C_word)a,a+=6,tmp));
t37=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3327,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[169]+1,*((C_word*)lf[165]+1));
t39=*((C_word*)lf[162]+1);
t40=*((C_word*)lf[164]+1);
t41=*((C_word*)lf[165]+1);
t42=*((C_word*)lf[169]+1);
t43=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3343,a[2]=t39,a[3]=t41,a[4]=((C_word)li66),tmp=(C_word)a,a+=5,tmp));
t44=C_mutate((C_word*)lf[171]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3367,a[2]=t40,a[3]=t42,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp));
t45=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3391,a[2]=t39,a[3]=t41,a[4]=((C_word)li71),tmp=(C_word)a,a+=5,tmp));
t46=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3411,a[2]=t40,a[3]=t42,a[4]=((C_word)li73),tmp=(C_word)a,a+=5,tmp));
t47=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3431,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[178]+1,C_fix((C_word)SIGTERM));
t49=C_mutate((C_word*)lf[179]+1,C_fix((C_word)SIGKILL));
t50=C_mutate((C_word*)lf[180]+1,C_fix((C_word)SIGINT));
t51=C_mutate((C_word*)lf[181]+1,C_fix((C_word)SIGHUP));
t52=C_mutate((C_word*)lf[182]+1,C_fix((C_word)SIGFPE));
t53=C_mutate((C_word*)lf[183]+1,C_fix((C_word)SIGILL));
t54=C_mutate((C_word*)lf[184]+1,C_fix((C_word)SIGSEGV));
t55=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGABRT));
t56=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGTRAP));
t57=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGQUIT));
t58=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGALRM));
t59=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGVTALRM));
t60=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGPROF));
t61=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGIO));
t62=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGURG));
t63=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGCHLD));
t64=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGCONT));
t65=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGSTOP));
t66=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGTSTP));
t67=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGPIPE));
t68=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGXCPU));
t69=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGXFSZ));
t70=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGUSR1));
t71=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGUSR2));
t72=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGWINCH));
t73=(C_word)C_a_i_list(&a,25,*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1),*((C_word*)lf[201]+1),*((C_word*)lf[202]+1));
t74=C_mutate((C_word*)lf[203]+1,t73);
t75=*((C_word*)lf[204]+1);
t76=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3476,a[2]=((C_word*)t0)[2],a[3]=t75,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1181 make-vector */
t77=*((C_word*)lf[468]+1);
((C_proc4)(void*)(*((C_word*)t77+1)))(4,t77,t76,C_fix(256),C_SCHEME_FALSE);}

/* k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3476,2,t0,t1);}
t2=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3478,a[2]=t1,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[206]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3487,a[2]=t1,a[3]=((C_word)li76),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[204]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3500,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li77),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3518,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3542,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3574,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3580,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3595,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3611,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7570,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1237 set-signal-handler! */
t12=*((C_word*)lf[206]+1);
((C_proc4)C_retrieve_proc(t12))(4,t12,t10,*((C_word*)lf[180]+1),t11);}

/* a7569 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7570(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7570,3,t0,t1,t2);}
/* posixunix.scm: 1239 ##sys#user-interrupt-hook */
t3=*((C_word*)lf[467]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3611,2,t0,t1);}
t2=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3613,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3651,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3668,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7567,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1269 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,t5,*((C_word*)lf[219]+1));}

/* a7566 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7567(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7567,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub438(C_SCHEME_UNDEFINED));}

/* k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3668,2,t0,t1);}
t2=C_mutate((C_word*)lf[221]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3672,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7549,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7552,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1274 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t3,t4,t5);}

/* a7551 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7552(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7552,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7562,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1278 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7560 in a7551 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1279 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[465],lf[466],((C_word*)t0)[2]);}

/* a7548 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7549,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub440(C_SCHEME_UNDEFINED));}

/* k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3672,2,t0,t1);}
t2=C_mutate((C_word*)lf[222]+1,t1);
t3=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3674,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3691,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7546,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1289 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,t5,*((C_word*)lf[223]+1));}

/* a7545 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7546,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub446(C_SCHEME_UNDEFINED));}

/* k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3691,2,t0,t1);}
t2=C_mutate((C_word*)lf[225]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3695,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7528,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7531,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1294 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t3,t4,t5);}

/* a7530 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7531(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7531,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7541,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1298 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7539 in a7530 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1299 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[463],lf[464],((C_word*)t0)[2]);}

/* a7527 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7528,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub448(C_SCHEME_UNDEFINED));}

/* k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[57],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3695,2,t0,t1);}
t2=C_mutate((C_word*)lf[226]+1,t1);
t3=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3697,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[137]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3764,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3778,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[231]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3803,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate(&lf[232],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3889,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3896,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3959,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4033,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[242]+1,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[243]+1,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[244]+1,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[245]+1,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[246]+1,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[247]+1,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[248]+1,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[249]+1,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[250]+1,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[251]+1,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[252]+1,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[253]+1,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[254]+1,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[255]+1,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[256]+1,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[257]+1,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[258]+1,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[259]+1,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[260]+1,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[261]+1,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[263]+1,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[265],0,C_fix(0));
t35=C_set_block_item(lf[266],0,C_fix(0));
t36=C_set_block_item(lf[267],0,C_fix(0));
t37=C_set_block_item(lf[268],0,C_fix(0));
t38=C_set_block_item(lf[269],0,C_fix(0));
t39=C_set_block_item(lf[270],0,C_fix(0));
t40=C_set_block_item(lf[271],0,C_fix(0));
t41=C_set_block_item(lf[272],0,C_fix(0));
t42=C_set_block_item(lf[273],0,C_fix(0));
t43=C_set_block_item(lf[274],0,C_fix(0));
t44=C_set_block_item(lf[275],0,C_fix(0));
t45=C_set_block_item(lf[276],0,C_fix(0));
t46=C_set_block_item(lf[277],0,C_fix(0));
t47=C_set_block_item(lf[278],0,C_fix(0));
t48=C_set_block_item(lf[279],0,C_fix(0));
t49=C_set_block_item(lf[280],0,C_fix(0));
t50=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4097,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[283]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4124,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4154,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4178,a[2]=t52,a[3]=((C_word)li102),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4184,a[2]=t52,a[3]=((C_word)li103),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4190,a[2]=t52,a[3]=((C_word)li104),tmp=(C_word)a,a+=4,tmp));
t56=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4196,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4211,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4234,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7510,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1521 getter-with-setter */
t60=*((C_word*)lf[462]+1);
((C_proc4)C_retrieve_proc(t60))(4,t60,t58,t59,*((C_word*)lf[290]+1));}

/* a7509 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7510(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7510,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[292]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7517,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7523,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1526 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_7517(2,t6,C_SCHEME_UNDEFINED);}}

/* k7521 in a7509 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1527 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[292],lf[461],((C_word*)t0)[2]);}

/* k7515 in a7509 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4234,2,t0,t1);}
t2=C_mutate((C_word*)lf[292]+1,t1);
t3=C_mutate((C_word*)lf[293]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4236,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t4=*((C_word*)lf[296]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4273,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1548 make-string */
t7=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word ab[259],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4273,2,t0,t1);}
t2=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4274,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li108),tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4324,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[302]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[303]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[304]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4349,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4386,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4401,a[2]=t7,a[3]=t8,a[4]=((C_word)li112),tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4415,a[2]=t7,a[3]=t8,a[4]=((C_word)li113),tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[315]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4429,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[321]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4474,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[323]+1);
t14=*((C_word*)lf[324]+1);
t15=C_mutate((C_word*)lf[325]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4501,a[2]=t13,a[3]=t14,a[4]=((C_word)li135),tmp=(C_word)a,a+=5,tmp));
t16=*((C_word*)lf[338]+1);
t17=*((C_word*)lf[324]+1);
t18=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4975,a[2]=t16,a[3]=t17,a[4]=((C_word)li147),tmp=(C_word)a,a+=5,tmp));
t19=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5234,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5273,a[2]=((C_word)li149),tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5347,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp);
t22=C_mutate((C_word*)lf[346]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5365,a[2]=t20,a[3]=t21,a[4]=((C_word)li151),tmp=(C_word)a,a+=5,tmp));
t23=C_mutate((C_word*)lf[348]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5380,a[2]=t20,a[3]=t21,a[4]=((C_word)li152),tmp=(C_word)a,a+=5,tmp));
t24=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5395,a[2]=t20,a[3]=t21,a[4]=((C_word)li153),tmp=(C_word)a,a+=5,tmp));
t25=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5417,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5445,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5488,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5514,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5531,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[360]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5551,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[361]+1,C_fix((C_word)PROT_READ));
t32=C_mutate((C_word*)lf[362]+1,C_fix((C_word)PROT_WRITE));
t33=C_mutate((C_word*)lf[363]+1,C_fix((C_word)PROT_EXEC));
t34=C_mutate((C_word*)lf[364]+1,C_fix((C_word)PROT_NONE));
t35=C_mutate((C_word*)lf[365]+1,C_fix((C_word)MAP_FIXED));
t36=C_mutate((C_word*)lf[366]+1,C_fix((C_word)MAP_SHARED));
t37=C_mutate((C_word*)lf[367]+1,C_fix((C_word)MAP_PRIVATE));
t38=C_mutate((C_word*)lf[368]+1,C_fix((C_word)MAP_ANON));
t39=C_mutate((C_word*)lf[369]+1,C_fix((C_word)MAP_FILE));
t40=C_mutate((C_word*)lf[370]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5654,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[376]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5716,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[378]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5751,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[379]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5760,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[380]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5766,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[382]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5775,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[383]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5794,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[385]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5827,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[389]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5909,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[391]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5955,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[395]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5983,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[398]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6011,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[399]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6023,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[400]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6039,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[401]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6046,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[407]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6105,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate(&lf[408],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6124,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[410]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6156,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[411]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6179,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[416]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6214,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t60=*((C_word*)lf[418]+1);
t61=*((C_word*)lf[419]+1);
t62=*((C_word*)lf[420]+1);
t63=*((C_word*)lf[421]+1);
t64=*((C_word*)lf[123]+1);
t65=*((C_word*)lf[422]+1);
t66=*((C_word*)lf[423]+1);
t67=C_mutate((C_word*)lf[424]+1,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6226,a[2]=t63,a[3]=t61,a[4]=t60,a[5]=t64,a[6]=t62,a[7]=t65,a[8]=t66,a[9]=((C_word)li186),tmp=(C_word)a,a+=10,tmp));
t68=C_mutate((C_word*)lf[427]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6338,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t69=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6380,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp);
t70=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6399,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp);
t71=*((C_word*)lf[429]+1);
t72=C_mutate((C_word*)lf[430]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6418,a[2]=t71,a[3]=t70,a[4]=t69,a[5]=((C_word)li196),tmp=(C_word)a,a+=6,tmp));
t73=C_mutate((C_word*)lf[432]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6600,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[433]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6617,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[435]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6695,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[436]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6698,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[437]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6701,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[438]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6708,a[2]=((C_word)li204),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[440]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6735,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp));
t80=C_mutate((C_word*)lf[443]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6744,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp));
t81=*((C_word*)lf[427]+1);
t82=*((C_word*)lf[430]+1);
t83=*((C_word*)lf[136]+1);
t84=C_mutate((C_word*)lf[445]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6750,a[2]=t81,a[3]=t82,a[4]=((C_word)li207),tmp=(C_word)a,a+=5,tmp));
t85=*((C_word*)lf[176]+1);
t86=*((C_word*)lf[433]+1);
t87=*((C_word*)lf[427]+1);
t88=*((C_word*)lf[430]+1);
t89=*((C_word*)lf[321]+1);
t90=*((C_word*)lf[55]+1);
t91=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6806,a[2]=t86,a[3]=((C_word)li211),tmp=(C_word)a,a+=4,tmp);
t92=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6843,a[2]=t85,a[3]=((C_word)li214),tmp=(C_word)a,a+=4,tmp);
t93=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6863,a[2]=t90,a[3]=((C_word)li215),tmp=(C_word)a,a+=4,tmp);
t94=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6877,a[2]=t90,a[3]=((C_word)li216),tmp=(C_word)a,a+=4,tmp);
t95=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6894,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp);
t96=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6910,a[2]=t92,a[3]=t87,a[4]=t94,a[5]=t88,a[6]=t95,a[7]=((C_word)li219),tmp=(C_word)a,a+=8,tmp);
t97=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6955,a[2]=t93,a[3]=((C_word)li220),tmp=(C_word)a,a+=4,tmp);
t98=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6966,a[2]=t93,a[3]=((C_word)li221),tmp=(C_word)a,a+=4,tmp);
t99=C_mutate((C_word*)lf[447]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6977,a[2]=t98,a[3]=t91,a[4]=t97,a[5]=t96,a[6]=((C_word)li224),tmp=(C_word)a,a+=7,tmp));
t100=*((C_word*)lf[448]+1);
t101=C_mutate((C_word*)lf[449]+1,t100);
t102=*((C_word*)lf[448]+1);
t103=C_mutate((C_word*)lf[450]+1,t102);
t104=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7041,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp);
t105=C_mutate((C_word*)lf[449]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7102,a[2]=t104,a[3]=((C_word)li233),tmp=(C_word)a,a+=4,tmp));
t106=C_mutate((C_word*)lf[450]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7162,a[2]=t104,a[3]=((C_word)li237),tmp=(C_word)a,a+=4,tmp));
t107=*((C_word*)lf[424]+1);
t108=*((C_word*)lf[420]+1);
t109=*((C_word*)lf[422]+1);
t110=*((C_word*)lf[127]+1);
t111=C_mutate((C_word*)lf[451]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7222,a[2]=t110,a[3]=t109,a[4]=t107,a[5]=t108,a[6]=((C_word)li250),tmp=(C_word)a,a+=7,tmp));
t112=C_mutate((C_word*)lf[459]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7487,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp));
t113=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t113+1)))(2,t113,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7487(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7487,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[459]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7479,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=(C_word)C_i_foreign_string_argumentp(t4);
/* ##sys#make-c-string */
t7=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}
else{
t6=t5;
f_7479(2,t6,C_SCHEME_FALSE);}}

/* k7477 in set-root-directory! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1393(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2401 posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[459],lf[460],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7222(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_7222r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_7222r(t0,t1,t2,t3,t4);}}

static void C_ccall f_7222r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7224,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=((C_word)li245),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7395,a[2]=t5,a[3]=((C_word)li246),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7400,a[2]=t6,a[3]=((C_word)li247),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7405,a[2]=t7,a[3]=((C_word)li249),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action13461382 */
t9=t8;
f_7405(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id13471380 */
t11=t7;
f_7400(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit13481377 */
t13=t6;
f_7395(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body13441350 */
t15=t5;
f_7224(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action1346 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7405(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7405,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7411,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp);
/* def-id13471380 */
t3=((C_word*)t0)[2];
f_7400(t3,t1,t2);}

/* a7410 in def-action1346 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7411,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1347 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7400(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7400,NULL,3,t0,t1,t2);}
/* def-limit13481377 */
t3=((C_word*)t0)[2];
f_7395(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1348 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7395(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7395,NULL,4,t0,t1,t2,t3);}
/* body13441350 */
t4=((C_word*)t0)[2];
f_7224(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7224(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7224,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[451]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7231,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t2,a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_7231(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7390,a[2]=t4,a[3]=t7,a[4]=((C_word)li243),tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_7231(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7382,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp));}}

/* f_7382 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7382(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7382,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_7390 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7390(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7390,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7231(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7231,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7370,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
if(C_truep(t2)){
t4=t3;
f_7370(2,t4,t2);}
else{
/* posixunix.scm: 2373 regexp? */
t4=*((C_word*)lf[458]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[11]);}}

/* k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7370,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7371,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[12],a[4]=((C_word)li238),tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7241,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t2,a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7364,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2376 make-pathname */
t5=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],lf[457]);}

/* k7362 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2376 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7241,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7243,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=((C_word)li242),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_7243(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7243(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7243,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7262,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2382 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7262,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7344,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2383 pathname-file */
t3=*((C_word*)lf[456]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7350,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2390 pproc */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7348 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7350,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7357,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2390 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2391 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_7243(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k7355 in k7348 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7357(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2390 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7243(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7344(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7344,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[452]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[453]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2383 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_7243(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7277,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 2384 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[42],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7277,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7287,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7289,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,a[5]=((C_word)li239),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7297,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word)li240),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7321,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,a[5]=((C_word)li241),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2386 ##sys#dynamic-wind */
t11=*((C_word*)lf[455]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7334,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7337,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2389 pproc */
t4=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[6]);}}

/* k7335 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2389 action */
t2=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7334(2,t2,((C_word*)t0)[2]);}}

/* k7332 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2389 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7243(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7320 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7321,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* a7296 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7297,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7305,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7319,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2387 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[6],lf[454]);}

/* k7317 in a7296 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7319(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k7303 in a7296 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7305,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7309,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7312,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2388 pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k7310 in k7303 in a7296 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7312(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2388 action */
t2=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7309(2,t2,((C_word*)t0)[2]);}}

/* k7307 in k7303 in a7296 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7243(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7288 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7289,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* k7285 in k7275 in k7342 in k7260 in loop in k7239 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7243(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_7371 in k7368 in k7229 in body1344 in find-files in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7371(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7371,3,t0,t1,t2);}
/* posixunix.scm: 2374 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7162(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_7162r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7162r(t0,t1,t2,t3);}}

static void C_ccall f_7162r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7164,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li234),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7169,a[2]=t4,a[3]=((C_word)li235),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7174,a[2]=t5,a[3]=((C_word)li236),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13201328 */
t7=t6;
f_7174(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13211326 */
t9=t5;
f_7169(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body13181323 */
t11=t4;
f_7164(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1320 in process* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7174(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7174,NULL,2,t0,t1);}
/* def-env13211326 */
t2=((C_word*)t0)[2];
f_7169(t2,t1,C_SCHEME_FALSE);}

/* def-env1321 in process* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7169(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7169,NULL,3,t0,t1,t2);}
/* body13181323 */
t3=((C_word*)t0)[2];
f_7164(t3,t1,t2,C_SCHEME_FALSE);}

/* body1318 in process* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7164(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7164,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2351 %process */
f_7041(t1,lf[450],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7102(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_7102r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7102r(t0,t1,t2,t3);}}

static void C_ccall f_7102r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7104,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li230),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7109,a[2]=t4,a[3]=((C_word)li231),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7114,a[2]=t5,a[3]=((C_word)li232),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13001308 */
t7=t6;
f_7114(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13011306 */
t9=t5;
f_7109(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body12981303 */
t11=t4;
f_7104(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1300 in process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7114(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7114,NULL,2,t0,t1);}
/* def-env13011306 */
t2=((C_word*)t0)[2];
f_7109(t2,t1,C_SCHEME_FALSE);}

/* def-env1301 in process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7109(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7109,NULL,3,t0,t1,t2);}
/* body12981303 */
t3=((C_word*)t0)[2];
f_7104(t3,t1,t2,C_SCHEME_FALSE);}

/* body1298 in process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7104(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7104,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2348 %process */
f_7041(t1,lf[449],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7041(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7041,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7043,a[2]=t2,a[3]=((C_word)li226),tmp=(C_word)a,a+=4,tmp);
t10=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7062,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm: 2337 chkstrlst */
t12=t9;
f_7043(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7096,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2339 ##sys#shell-command-arguments */
t13=*((C_word*)lf[443]+1);
((C_proc3)C_retrieve_proc(t13))(3,t13,t12,((C_word*)t7)[1]);}}

/* k7094 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7096,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7100,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2340 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k7098 in k7094 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_7062(2,t3,t2);}

/* k7060 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7062,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7065,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2341 chkstrlst */
t3=((C_word*)t0)[2];
f_7043(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_7065(2,t3,C_SCHEME_UNDEFINED);}}

/* k7063 in k7060 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7065,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7070,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li227),tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7076,a[2]=((C_word*)t0)[3],a[3]=((C_word)li228),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2342 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a7075 in k7063 in k7060 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7076(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7076,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2344 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2345 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a7069 in k7063 in k7060 in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7070,2,t0,t1);}
/* posixunix.scm: 2342 ##sys#process */
t2=*((C_word*)lf[447]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_7043(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7043,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7052,a[2]=((C_word*)t0)[2],a[3]=((C_word)li225),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a7051 in chkstrlst in %process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7052(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7052,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6977(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_6977,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6983,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word)li222),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6989,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,a[10]=((C_word)li223),tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6989(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6989,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_7000,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7020,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2318 make-on-close */
t12=((C_word*)t0)[3];
f_6806(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k7018 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2317 input-port */
t2=((C_word*)t0)[7];
f_6955(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6998 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7000,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7004,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7016,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2320 make-on-close */
t4=((C_word*)t0)[6];
f_6806(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k7014 in k6998 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2319 output-port */
t2=((C_word*)t0)[7];
f_6966(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7002 in k6998 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7004,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7008,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7012,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2323 make-on-close */
t4=((C_word*)t0)[3];
f_6806(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k7010 in k7002 in k6998 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7012(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2322 input-port */
t2=((C_word*)t0)[7];
f_6955(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7006 in k7002 in k6998 in a6988 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_7008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2316 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a6982 in ##sys#process in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6983,2,t0,t1);}
/* posixunix.scm: 2311 spawn */
t2=((C_word*)t0)[8];
f_6910(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6966(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6966,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6970,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2307 connect-parent */
t8=((C_word*)t0)[2];
f_6863(t8,t7,t4,t5);}

/* k6968 in output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2308 ##sys#custom-output-port */
t2=*((C_word*)lf[339]+1);
((C_proc8)C_retrieve_proc(t2))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6955(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6955,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6959,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2303 connect-parent */
t8=((C_word*)t0)[2];
f_6863(t8,t7,t4,t5);}

/* k6957 in input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6959(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2304 ##sys#custom-input-port */
t2=*((C_word*)lf[325]+1);
((C_proc8)C_retrieve_proc(t2))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6910(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6910,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6914,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,a[13]=((C_word*)t0)[6],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2290 needed-pipe */
t9=((C_word*)t0)[2];
f_6843(t9,t8,t6);}

/* k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6914,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6917,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2291 needed-pipe */
t3=((C_word*)t0)[2];
f_6843(t3,t2,((C_word*)t0)[5]);}

/* k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6917,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6920,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2292 needed-pipe */
t3=((C_word*)t0)[2];
f_6843(t3,t2,((C_word*)t0)[6]);}

/* k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6920,2,t0,t1);}
t2=f_6894(C_a_i(&a,3),((C_word*)t0)[13]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6931,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6933,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=((C_word*)t0)[14],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=((C_word)li218),tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2295 process-fork */
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t3,t4);}

/* a6932 in k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6933(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6933,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_6937,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2297 connect-child */
t3=((C_word*)t0)[7];
f_6877(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[302]+1));}

/* k6935 in a6932 in k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6937,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6940,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_6894(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2298 connect-child */
t4=((C_word*)t0)[5];
f_6877(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[303]+1));}

/* k6938 in k6935 in a6932 in k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6940,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6943,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_6894(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2299 connect-child */
t4=((C_word*)t0)[3];
f_6877(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[304]+1));}

/* k6941 in k6938 in k6935 in a6932 in k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2300 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k6929 in k6918 in k6915 in k6912 in spawn in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2293 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swapped-ends in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6894(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_check;
if(C_truep(t1)){
t2=(C_word)C_i_cdr(t1);
t3=(C_word)C_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6877(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6877,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_i_car(t2);
t6=(C_word)C_i_cdr(t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6890,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2281 file-close */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k6888 in connect-child in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6890,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6802,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2255 duplicate-fileno */
t6=*((C_word*)lf[321]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k6800 in k6888 in connect-child in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2256 file-close */
t2=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6863(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6863,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6876,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2275 file-close */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k6874 in connect-parent in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6843(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6843,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6852,a[2]=((C_word*)t0)[2],a[3]=((C_word)li212),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6858,a[2]=((C_word)li213),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2270 ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a6857 in needed-pipe in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6858(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6858,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a6851 in needed-pipe in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6852,2,t0,t1);}
/* posixunix.scm: 2270 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* make-on-close in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6806(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6806,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6808,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,a[9]=((C_word)li210),tmp=(C_word)a,a+=10,tmp));}

/* f_6808 in make-on-close in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6808,2,t0,t1);}
t2=(C_word)C_i_vector_set(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6823,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word)li208),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6829,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word)li209),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2263 ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a6828 */
static void C_ccall f_6829(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6829,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2265 ##sys#signal-hook */
t5=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[208],((C_word*)t0)[3],lf[446],((C_word*)t0)[2],t4);}}

/* a6822 */
static void C_ccall f_6823(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6823,2,t0,t1);}
/* posixunix.scm: 2263 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6750(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6750r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6750r(t0,t1,t2,t3);}}

static void C_ccall f_6750r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6757,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2219 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k6755 in process-run in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6757,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2221 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6776,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k6774 in k6755 in process-run in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6776,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6780,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command-arguments */
t3=*((C_word*)lf[443]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k6778 in k6774 in k6755 in process-run in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2223 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6744(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6744,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[444],t2));}

/* ##sys#shell-command in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6735,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6739,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2208 getenv */
t3=*((C_word*)lf[136]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[442]);}

/* k6737 in ##sys#shell-command in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6739(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[441]));}

/* process-signal in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6708(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6708r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6708r(t0,t1,t2,t3);}}

static void C_ccall f_6708r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[438]);
t7=(C_word)C_i_check_exact_2(t5,lf[438]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 2205 posix-error */
t10=lf[3];
f_1683(7,t10,t1,lf[208],lf[438],lf[439],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6701(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6701,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub1166(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6698,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1163(C_SCHEME_UNDEFINED));}

/* current-process-id in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6695,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1161(C_SCHEME_UNDEFINED));}

/* process-wait in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6617(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_6617r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6617r(t0,t1,t2);}}

static void C_ccall f_6617r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[433]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6647,a[2]=t8,a[3]=t11,a[4]=((C_word)li198),tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6653,a[2]=t11,a[3]=((C_word)li199),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2189 ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* a6652 in process-wait in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6653,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 2191 posix-error */
t6=lf[3];
f_1683(6,t6,t1,lf[208],lf[433],lf[434],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2192 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a6646 in process-wait in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6647,2,t0,t1);}
/* posixunix.scm: 2189 ##sys#process-wait */
t2=*((C_word*)lf[432]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6600(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6600,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 2176 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6418(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_6418r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6418r(t0,t1,t2,t3);}}

static void C_ccall f_6418r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6420,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li193),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6547,a[2]=t4,a[3]=((C_word)li194),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6552,a[2]=t5,a[3]=((C_word)li195),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist11011136 */
t7=t6;
f_6552(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist11021134 */
t9=t5;
f_6547(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body10991104 */
t11=t4;
f_6420(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist1101 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6552(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6552,NULL,2,t0,t1);}
/* def-envlist11021134 */
t2=((C_word*)t0)[2];
f_6547(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist1102 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6547(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6547,NULL,3,t0,t1,t2);}
/* body10991104 */
t3=((C_word*)t0)[2];
f_6420(t3,t1,t2,C_SCHEME_FALSE);}

/* body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6420(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6420,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[430]);
t5=(C_word)C_i_check_list_2(t2,lf[430]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6430,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2144 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6430,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_6380(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6438,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li192),tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_6438(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do1108 in k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6438(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6438,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_6380(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6451,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(C_word)C_i_check_list_2(((C_word*)t0)[5],lf[430]);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6484,a[2]=((C_word*)t0)[3],a[3]=((C_word)li191),tmp=(C_word)a,a+=4,tmp);
t8=t5;
f_6451(t8,f_6484(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_6451(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[430]);
t6=(C_word)C_block_size(t4);
t7=f_6380(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* do1112 in do1108 in k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6484(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep((C_word)C_i_nullp(t1))){
return(f_6399(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[430]);
t5=(C_word)C_block_size(t3);
t6=f_6399(t2,t3,t5);
t7=(C_word)C_i_cdr(t1);
t8=(C_word)C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k6449 in do1108 in k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6451(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6451,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6454,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6476,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2158 ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k6474 in k6449 in do1108 in k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2158 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6452 in k6449 in do1108 in k6428 in body1099 in process-execute in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub1080(C_SCHEME_UNDEFINED);
t5=(C_word)stub1092(C_SCHEME_UNDEFINED);
/* posixunix.scm: 2165 posix-error */
t6=lf[3];
f_1683(6,t6,((C_word*)t0)[3],lf[208],lf[430],lf[431],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6399(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub1085(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_6380(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub1073(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6338(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_6338r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_6338r(t0,t1,t2);}}

static void C_ccall f_6338r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub1056(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 2129 posix-error */
t5=lf[3];
f_1683(5,t5,t1,lf[208],lf[427],lf[428]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6360,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_i_vector_ref(t2,C_fix(0));
t9=t8;
((C_proc2)C_retrieve_proc(t9))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k6358 in process-fork in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6360,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6364,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_6364 in k6358 in process-fork in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6364(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6364,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub1061(C_SCHEME_UNDEFINED,t3));}

/* glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6226(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr2r,(void*)f_6226r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6226r(t0,t1,t2);}}

static void C_ccall f_6226r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(13);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6232,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[8],a[10]=((C_word)li185),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];
f_6232(t6,t1,t2);}

/* conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6232(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6232,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6247,a[2]=t3,a[3]=((C_word*)t0)[9],a[4]=((C_word)li182),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6253,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word)li184),tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6253(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6253,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6257,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6330,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[426]);
/* posixunix.scm: 2113 make-pathname */
t8=((C_word*)t0)[7];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k6328 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2113 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6257,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6260,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 2114 make-anchored-pattern */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6260,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6263,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 2115 regexp */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6263,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6270,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[425]);
/* posixunix.scm: 2116 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k6268 in k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6270,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6272,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li183),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_6272(t5,((C_word*)t0)[2],t1);}

/* loop in k6268 in k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6272(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6272,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[8]);
/* posixunix.scm: 2117 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_6232(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6289,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixunix.scm: 2118 string-match */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k6287 in loop in k6268 in k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6289,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6299,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixunix.scm: 2119 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixunix.scm: 2120 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6272(t3,((C_word*)t0)[6],t2);}}

/* k6297 in k6287 in loop in k6268 in k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6299,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6303,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm: 2119 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6272(t4,t2,t3);}

/* k6301 in k6297 in k6287 in loop in k6268 in k6261 in k6258 in k6255 in a6252 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6303(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6303,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a6246 in conc-loop in glob in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6247,2,t0,t1);}
/* posixunix.scm: 2112 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6214(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6214,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6218,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub1016(t3),C_fix(0));}

/* k6216 in get-host-name in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6218(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6218,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6221,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_6221(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2093 posix-error */
t3=lf[3];
f_1683(5,t3,t2,lf[412],lf[416],lf[417]);}}

/* k6219 in k6216 in get-host-name in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6179(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6179,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6183,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2074 ##sys#terminal-check */
f_6124(t3,lf[411],t2);}

/* k6181 in terminal-size in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6183,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6203,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
t5=*((C_word*)lf[414]+1);
((C_proc6)C_retrieve_proc(t5))(6,t5,t4,t2,C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6201 in k6181 in terminal-size in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6203,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6207,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[414]+1);
((C_proc6)C_retrieve_proc(t3))(6,t3,t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6205 in k6201 in k6181 in terminal-size in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
t2=(C_word)C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
t5=(C_word)C_i_foreign_pointer_argumentp(t3);
t6=(C_word)C_i_foreign_pointer_argumentp(t1);
t7=(C_word)stub1002(C_SCHEME_UNDEFINED,t4,t5,t6);
t8=(C_word)C_eqp(C_fix(0),t7);
if(C_truep(t8)){
/* posixunix.scm: 2081 values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm: 2082 posix-error */
t9=lf[3];
f_1683(6,t9,((C_word*)t0)[4],lf[412],lf[411],lf[413],((C_word*)t0)[6]);}}

/* terminal-name in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6156(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6156,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6160,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2066 ##sys#terminal-check */
f_6124(t3,lf[410],t2);}

/* k6158 in terminal-name in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6160,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub992(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* ##sys#terminal-check in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_6124(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6124,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6128,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2058 ##sys#check-port */
t5=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,t3,t2);}

/* k6126 in ##sys#terminal-check in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[95],t2);
t4=(C_truep(t3)?(C_word)C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2061 ##sys#error */
t5=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[409],((C_word*)t0)[4]);}}

/* terminal-port? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6105(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6105,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6109,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2053 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[407]);}

/* k6107 in terminal-port? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6109,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6112,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2054 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k6110 in k6107 in terminal-port? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6112(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6046(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_6046r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_6046r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6046r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6050,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2038 ##sys#check-port */
t6=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[401]);}

/* k6048 in set-buffering-mode! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6050,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6056,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[403]);
if(C_truep(t6)){
t7=t5;
f_6056(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[404]);
if(C_truep(t7)){
t8=t5;
f_6056(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[405]);
if(C_truep(t8)){
t9=t5;
f_6056(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 2044 ##sys#error */
t9=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[401],lf[406],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k6054 in k6048 in set-buffering-mode! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[401]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[95],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 2050 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[401],lf[402],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6039(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6039,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub972(C_SCHEME_UNDEFINED,t3));}

/* _exit in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6023(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_6023r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_6023r(t0,t1,t2);}}

static void C_ccall f_6023r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(t2,C_fix(0)):C_fix(0));
t5=(C_word)C_i_foreign_fixnum_argumentp(t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub967(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_6011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6011,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub962(t2),C_fix(0));}

/* utc-time->seconds in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5983(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5983,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[395]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5990,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 2006 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[395],lf[397],t2);}
else{
t6=t4;
f_5990(2,t6,C_SCHEME_UNDEFINED);}}

/* k5988 in utc-time->seconds in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 2008 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2009 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[395],lf[396],((C_word*)t0)[3]);}}

/* local-time->seconds in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5955(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5955,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[391]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5962,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1999 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[391],lf[394],t2);}
else{
t6=t4;
f_5962(2,t6,C_SCHEME_UNDEFINED);}}

/* k5960 in local-time->seconds in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 2001 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2002 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[391],lf[393],((C_word*)t0)[3]);}}

/* string->time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5909(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5909r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5909r(t0,t1,t2,t3);}}

static void C_ccall f_5909r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5913,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_5913(2,t5,lf[390]);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_5913(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k5911 in string->time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5913,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[389]);
t3=(C_word)C_i_check_string_2(t1,lf[389]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5926,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[3]);}

/* k5924 in k5911 in string->time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5926(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5926,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5930,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5928 in k5924 in k5911 in string->time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5930(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5930,2,t0,t1);}
t2=(C_word)C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub943(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5827(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5827r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5827r(t0,t1,t2,t3);}}

static void C_ccall f_5827r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5831,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_5831(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_5831(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k5829 in time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5831,2,t0,t1);}
t2=(C_word)C_i_check_vector_2(((C_word*)t0)[3],lf[385]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5837,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_block_size(((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(10)))){
/* posixunix.scm: 1979 ##sys#error */
t5=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,lf[385],lf[388],((C_word*)t0)[3]);}
else{
t5=t3;
f_5837(2,t5,C_SCHEME_UNDEFINED);}}

/* k5835 in k5829 in time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5837,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[385]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5846,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5856,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1983 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5859,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub916(t4,t3),C_fix(0));}}

/* k5857 in k5835 in k5829 in time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5859(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1987 ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1988 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[387],((C_word*)t0)[2]);}}

/* k5854 in k5835 in k5829 in time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5856,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub922(t3,t2,t1),C_fix(0));}

/* k5844 in k5835 in k5829 in time->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm: 1984 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[386],((C_word*)t0)[2]);}}

/* seconds->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5794(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5794,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5798,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub907(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k5796 in seconds->string in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5798(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1971 ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1972 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[383],lf[384],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5775(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5775,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[382]);
/* posixunix.scm: 1964 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5766(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5766,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[380]);
/* posixunix.scm: 1960 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5760(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5760,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[371]));}

/* memory-mapped-file-pointer in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5751(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5751,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[371],lf[378]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5716(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5716r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5716r(t0,t1,t2,t3);}}

static void C_ccall f_5716r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=(C_word)C_i_check_structure_2(t2,lf[371],lf[376]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub888(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1947 posix-error */
t12=lf[3];
f_1683(7,t12,t1,lf[48],lf[376],lf[377],t2,t6);}}

/* map-file-to-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5654(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_5654r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_5654r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_5654r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5658,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_5658(2,t10,t2);}
else{
/* posixunix.scm: 1932 ##sys#null-pointer */
t10=*((C_word*)lf[375]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k5656 in map-file-to-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5658,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5664,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_5664(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1935 ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[60],lf[370],lf[374],t1);}}

/* k5662 in k5656 in map-file-to-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5664,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub863(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5670,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5683,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1937 ##sys#pointer->address */
t17=*((C_word*)lf[373]+1);
((C_proc3)(void*)(*((C_word*)t17+1)))(3,t17,t16,t14);}

/* k5681 in k5662 in k5656 in map-file-to-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1938 posix-error */
t3=lf[3];
f_1683(11,t3,((C_word*)t0)[8],lf[48],lf[370],lf[372],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_5670(2,t3,C_SCHEME_UNDEFINED);}}

/* k5668 in k5662 in k5656 in map-file-to-memory in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5670,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[371],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5551,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5557,a[2]=t3,a[3]=((C_word)li160),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_5557(t5,t1,C_fix(0));}

/* loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5557(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5557,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5561,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub845(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k5559 in loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5561,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5569,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word)li159),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_5569(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k5559 in loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5569(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5569,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5595,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1899 ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1902 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k5593 in scan in k5559 in loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5595,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5599,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1900 ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k5597 in k5593 in scan in k5559 in loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5599,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5587,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1901 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_5557(t5,t3,t4);}

/* k5585 in k5597 in k5593 in scan in k5559 in loop in current-environment in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5587(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5587,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5531(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5531,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[359]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5539,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1888 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k5537 in unsetenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5514(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5514,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[358]);
t5=(C_word)C_i_check_string_2(t3,lf[358]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5525,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t7=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k5523 in setenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5525,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5529,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5527 in k5523 in setenv in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5488(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5488,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[356]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5495,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5512,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1872 ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k5510 in fifo? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5512(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1872 ##sys#file-info */
t2=*((C_word*)lf[128]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5493 in fifo? in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1875 posix-error */
t2=lf[3];
f_1683(6,t2,((C_word*)t0)[3],lf[48],lf[356],lf[357],((C_word*)t0)[2]);}}

/* create-fifo in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5445(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5445r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5445r(t0,t1,t2,t3);}}

static void C_ccall f_5445r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[354]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5452,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_5452(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_5452(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k5450 in create-fifo in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5452(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5452,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[354]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5469,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5473,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1866 ##sys#expand-home-path */
t5=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k5471 in k5450 in create-fifo in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1866 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5467 in k5450 in create-fifo in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1867 posix-error */
t3=lf[3];
f_1683(7,t3,((C_word*)t0)[3],lf[48],lf[354],lf[355],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5417(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5417,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[345],lf[352]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1856 posix-error */
t9=lf[3];
f_1683(6,t9,t1,lf[48],lf[352],lf[353],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5395(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5395r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5395r(t0,t1,t2,t3);}}

static void C_ccall f_5395r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5399,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1847 setup */
f_5273(t4,t2,t3,lf[350]);}

/* k5397 in file-test-lock in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1849 err */
f_5347(((C_word*)t0)[3],lf[351],t1,lf[350]);}}

/* file-lock/blocking in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5380(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5380r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5380r(t0,t1,t2,t3);}}

static void C_ccall f_5380r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5384,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1841 setup */
f_5273(t4,t2,t3,lf[348]);}

/* k5382 in file-lock/blocking in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1843 err */
f_5347(((C_word*)t0)[2],lf[349],t1,lf[348]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5365(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5365r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5365r(t0,t1,t2,t3);}}

static void C_ccall f_5365r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5369,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1835 setup */
f_5273(t4,t2,t3,lf[346]);}

/* k5367 in file-lock in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1837 err */
f_5347(((C_word*)t0)[2],lf[347],t1,lf[346]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5347(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5347,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1832 posix-error */
t8=lf[3];
f_1683(8,t8,t1,lf[48],t4,t2,t5,t6,t7);}

/* setup in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5273(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5273,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5295,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1824 ##sys#check-port */
t16=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k5293 in setup in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5295,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5301,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_5301(t6,t5);}
else{
t5=t3;
f_5301(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k5299 in k5293 in setup in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5301(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5301,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[345],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5234(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5234,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[342]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5251,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5258,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5262,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1807 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_5251(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1809 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[342],lf[344],t2);}}}

/* k5260 in file-truncate in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1807 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5256 in file-truncate in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_5251(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k5249 in file-truncate in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5251(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1811 posix-error */
t2=lf[3];
f_1683(7,t2,((C_word*)t0)[4],lf[48],lf[342],lf[343],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4975(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+20)){
C_save_and_reclaim((void*)tr5r,(void*)f_4975r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4975r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4975r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(20);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4977,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,a[7]=((C_word)li143),tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5161,a[2]=t6,a[3]=((C_word)li144),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5166,a[2]=t7,a[3]=((C_word)li145),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5171,a[2]=t8,a[3]=((C_word)li146),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?737778 */
t10=t9;
f_5171(t10,t1);}
else{
t10=(C_word)C_i_car(t5);
t11=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-bufi738776 */
t12=t8;
f_5166(t12,t1,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* def-on-close739773 */
t14=t7;
f_5161(t14,t1,t10,t12);}
else{
t14=(C_word)C_i_car(t13);
t15=(C_word)C_i_cdr(t13);
if(C_truep((C_word)C_i_nullp(t15))){
/* body735741 */
t16=t6;
f_4977(t16,t1,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t1,lf[0],t15);}}}}}

/* def-nonblocking?737 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5171(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5171,NULL,2,t0,t1);}
/* def-bufi738776 */
t2=((C_word*)t0)[2];
f_5166(t2,t1,C_SCHEME_FALSE);}

/* def-bufi738 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5166(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5166,NULL,3,t0,t1,t2);}
/* def-on-close739773 */
t3=((C_word*)t0)[2];
f_5161(t3,t1,t2,C_fix(0));}

/* def-on-close739 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5161(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5161,NULL,4,t0,t1,t2,t3);}
/* body735741 */
t4=((C_word*)t0)[2];
f_4977(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4977(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4977,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4981,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1749 ##sys#file-nonblocking! */
t6=*((C_word*)lf[9]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,((C_word*)t0)[6]);}
else{
t6=t5;
f_4981(2,t6,C_SCHEME_UNDEFINED);}}

/* k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4981,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4983,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=t3,a[5]=((C_word*)t0)[9],a[6]=((C_word)li136),tmp=(C_word)a,a+=7,tmp));
t7=(C_word)C_fixnump(((C_word*)t0)[6]);
t8=(C_truep(t7)?((C_word*)t0)[6]:(C_word)C_block_size(((C_word*)t0)[6]));
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5029,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t10=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_5029(t11,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5073,a[2]=t3,a[3]=((C_word)li140),tmp=(C_word)a,a+=4,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5087,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
/* posixunix.scm: 1768 ##sys#make-string */
t12=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,((C_word*)t0)[6]);}
else{
t12=t11;
f_5087(2,t12,((C_word*)t0)[6]);}}}

/* k5085 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5087,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_5029(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5088,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word)li142),tmp=(C_word)a,a+=7,tmp));}

/* f_5088 in k5085 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5088(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5088,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5105,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word)li141),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_5105(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1784 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4983(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_5105(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5105,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5115,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1774 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_4983(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_difference(t4,t2);
/* posixunix.scm: 1779 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k5113 in loop */
static void C_ccall f_5115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1776 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_5105(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_5073 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5073(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5073,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1767 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4983(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_5029(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5029,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5033,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5038,a[2]=((C_word*)t0)[9],a[3]=((C_word)li137),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5044,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,a[7]=((C_word)li138),tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5065,a[2]=((C_word*)t0)[9],a[3]=((C_word)li139),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1787 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t9))(5,t9,t5,t6,t7,t8);}

/* a5064 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5065,2,t0,t1);}
/* posixunix.scm: 1797 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* a5043 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5044,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5054,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1794 posix-error */
t3=lf[3];
f_1683(7,t3,t2,lf[48],((C_word*)t0)[3],lf[341],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_5054(2,t3,C_SCHEME_UNDEFINED);}}}

/* k5052 in a5043 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1795 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a5037 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5038(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5038,3,t0,t1,t2);}
/* posixunix.scm: 1789 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t3))(3,t3,t1,t2);}

/* k5031 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5033,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5036,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1798 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k5034 in k5031 in k5027 in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4983(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4983,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4999,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1757 ##sys#thread-yield! */
t8=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1759 posix-error */
t7=lf[3];
f_1683(7,t7,t1,((C_word*)t0)[3],lf[48],lf[340],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5018,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1761 ##sys#substring */
t7=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k5016 in poke in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_5018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1761 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4983(t3,((C_word*)t0)[2],t1,t2);}

/* k4997 in poke in k4979 in body735 in ##sys#custom-output-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4999(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1758 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_4983(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4501(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+24)){
C_save_and_reclaim((void*)tr5r,(void*)f_4501r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4501r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4501r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(24);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4503,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,a[7]=((C_word)li130),tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4882,a[2]=t6,a[3]=((C_word)li131),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4887,a[2]=t7,a[3]=((C_word)li132),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4892,a[2]=t8,a[3]=((C_word)li133),tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4897,a[2]=t9,a[3]=((C_word)li134),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?627716 */
t11=t10;
f_4897(t11,t1);}
else{
t11=(C_word)C_i_car(t5);
t12=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-bufi628714 */
t13=t9;
f_4892(t13,t1,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* def-on-close629711 */
t15=t8;
f_4887(t15,t1,t11,t13);}
else{
t15=(C_word)C_i_car(t14);
t16=(C_word)C_i_cdr(t14);
if(C_truep((C_word)C_i_nullp(t16))){
/* def-more?630707 */
t17=t7;
f_4882(t17,t1,t11,t13,t15);}
else{
t17=(C_word)C_i_car(t16);
t18=(C_word)C_i_cdr(t16);
if(C_truep((C_word)C_i_nullp(t18))){
/* body625632 */
t19=t6;
f_4503(t19,t1,t11,t13,t15,t17);}
else{
/* ##sys#error */
t19=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t19+1)))(4,t19,t1,lf[0],t18);}}}}}}

/* def-nonblocking?627 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4897(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4897,NULL,2,t0,t1);}
/* def-bufi628714 */
t2=((C_word*)t0)[2];
f_4892(t2,t1,C_SCHEME_FALSE);}

/* def-bufi628 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4892(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4892,NULL,3,t0,t1,t2);}
/* def-on-close629711 */
t3=((C_word*)t0)[2];
f_4887(t3,t1,t2,C_fix(1));}

/* def-on-close629 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4887(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4887,NULL,4,t0,t1,t2,t3);}
/* def-more?630707 */
t4=((C_word*)t0)[2];
f_4882(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* def-more?630 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4882,NULL,5,t0,t1,t2,t3,t4);}
/* body625632 */
t5=((C_word*)t0)[2];
f_4503(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4503(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4503,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4507,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=t3,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1627 ##sys#file-nonblocking! */
t7=*((C_word*)lf[9]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}
else{
t7=t6;
f_4507(2,t7,C_SCHEME_UNDEFINED);}}

/* k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4507,2,t0,t1);}
t2=(C_word)C_fixnump(((C_word*)t0)[10]);
t3=(C_truep(t2)?((C_word*)t0)[10]:(C_word)C_block_size(((C_word*)t0)[10]));
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4513,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[10]))){
/* posixunix.scm: 1629 ##sys#make-string */
t5=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[10]);}
else{
t5=t4;
f_4513(2,t5,((C_word*)t0)[10]);}}

/* k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[73],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4513,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4514,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word)li116),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4529,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4537,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,a[10]=((C_word)li118),tmp=(C_word)a,a+=11,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4619,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4624,a[2]=t8,a[3]=t5,a[4]=t7,a[5]=((C_word)li119),tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4637,a[2]=t6,a[3]=t3,a[4]=t5,a[5]=((C_word)li120),tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4649,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,a[7]=((C_word)li121),tmp=(C_word)a,a+=8,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4670,a[2]=t8,a[3]=t7,a[4]=((C_word)li122),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4679,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,a[6]=((C_word)li124),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4755,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,a[6]=((C_word)li129),tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1673 make-input-port */
t18=((C_word*)t0)[2];
((C_proc8)C_retrieve_proc(t18))(8,t18,t11,t12,t13,t14,t15,t16,t17);}

/* a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4755(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4755,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4761,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word)li128),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f_4761(t7,t1,C_SCHEME_FALSE);}

/* loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4761(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4761,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4763,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li125),tmp=(C_word)a,a+=9,tmp);
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4841,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word)li126),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4847,a[2]=((C_word*)t0)[2],a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1732 ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4857,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1738 fetch */
t5=((C_word*)t0)[5];
f_4537(t5,t4);}}

/* k4855 in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm: 1740 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4761(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a4846 in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4847,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm: 1735 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4761(t4,t1,t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a4840 in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4841,2,t0,t1);}
/* posixunix.scm: 1733 ##sys#scan-buffer-line */
t2=*((C_word*)lf[336]+1);
((C_proc6)C_retrieve_proc(t2))(6,t2,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4763(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4763,4,t0,t1,t2,t3);}
t4=(C_word)C_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4770,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_4770(2,t8,(C_truep(t7)?t7:lf[333]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4813,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1715 ##sys#make-string */
t8=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t4);}}

/* k4811 in bumper in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4813(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(5));
t4=(C_word)C_fixnum_plus(t3,((C_word*)t0)[4]);
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm: 1721 ##sys#string-append */
t6=*((C_word*)lf[334]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=((C_word*)t0)[2];
f_4770(2,t6,t1);}}

/* k4768 in bumper in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4770,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=(C_word)C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4780,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1725 fetch */
t5=((C_word*)t0)[3];
f_4537(t5,t4);}
else{
t4=(C_word)C_slot(((C_word*)t0)[2],C_fix(4));
t5=(C_word)C_fixnum_plus(t4,C_fix(1));
t6=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm: 1730 values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k4778 in k4768 in bumper in loop in a4754 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm: 1726 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a4678 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4679(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4679,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4687,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_4687(t7,t3);}
else{
t7=(C_word)C_block_size(t4);
t8=t6;
f_4687(t8,(C_word)C_fixnum_difference(t7,t5));}}

/* k4685 in a4678 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4687(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4687,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4689,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li123),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_4689(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k4685 in a4678 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4689(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4689,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}
else{
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=(C_word)C_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=(C_word)C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=(C_word)C_fixnum_difference(t2,t8);
t14=(C_word)C_fixnum_plus(t3,t8);
t15=(C_word)C_fixnum_plus(t4,t8);
/* posixunix.scm: 1701 loop */
t18=t1;
t19=t13;
t20=t14;
t21=t15;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4737,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1703 fetch */
t7=((C_word*)t0)[2];
f_4537(t7,t6);}}}

/* k4735 in loop in k4685 in a4678 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm: 1706 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4689(t3,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* a4669 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4670,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4674,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1691 fetch */
t3=((C_word*)t0)[2];
f_4537(t3,t2);}

/* k4672 in a4669 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1692 peek */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,f_4529(((C_word*)t0)[2]));}

/* a4648 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4649(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4649,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4659,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1688 posix-error */
t3=lf[3];
f_1683(7,t3,t2,lf[48],((C_word*)t0)[3],lf[332],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_4659(2,t3,C_SCHEME_UNDEFINED);}}}

/* k4657 in a4648 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1689 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a4636 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4637(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4637,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1683 ready? */
t3=((C_word*)t0)[2];
f_4514(t3,t1);}}

/* a4623 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4624,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4628,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1675 fetch */
t3=((C_word*)t0)[2];
f_4537(t3,t2);}

/* k4626 in a4623 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4628(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_4529(((C_word*)t0)[4]);
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k4617 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4619,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4622,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1742 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k4620 in k4617 in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4537(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4537,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4549,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word)li117),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_4549(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4549(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4549,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4565,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1650 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[328]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[329]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1653 posix-error */
t5=lf[3];
f_1683(7,t5,t1,lf[48],((C_word*)t0)[6],lf[330],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4586,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1657 more? */
t6=((C_word*)t0)[4];
((C_proc2)C_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k4584 in loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4586,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4589,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1659 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4595,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_4595(2,t8,t7);}
else{
/* posixunix.scm: 1665 posix-error */
t7=lf[3];
f_1683(7,t7,t4,lf[48],((C_word*)t0)[3],lf[331],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_4595(2,t6,C_SCHEME_UNDEFINED);}}}

/* k4593 in k4584 in loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4587 in k4584 in loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1660 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4549(t2,((C_word*)t0)[2]);}

/* k4563 in loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4565,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4568,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1651 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4566 in k4563 in loop in fetch in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1652 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4549(t2,((C_word*)t0)[2]);}

/* peek in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_4529(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_check;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4514(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4514,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4528,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1635 ##sys#file-select-one */
t3=*((C_word*)lf[10]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}

/* k4526 in ready? in k4511 in k4505 in body625 in ##sys#custom-input-port in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1636 posix-error */
t3=lf[3];
f_1683(7,t3,((C_word*)t0)[5],lf[48],((C_word*)t0)[4],lf[326],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4474(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4474r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4474r(t0,t1,t2,t3);}}

static void C_ccall f_4474r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[321]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4481,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_4481(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[321]);
t8=t5;
f_4481(t8,(C_word)C_dup2(t2,t6));}}

/* k4479 in duplicate-fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4481(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4481,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4484,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1620 posix-error */
t3=lf[3];
f_1683(6,t3,t2,lf[48],lf[321],lf[322],((C_word*)t0)[2]);}
else{
t3=t2;
f_4484(2,t3,C_SCHEME_UNDEFINED);}}

/* k4482 in k4479 in duplicate-fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4429(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4429,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4433,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1602 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[315]);}

/* k4431 in port->fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4433,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[316],t2);
if(C_truep(t3)){
/* posixunix.scm: 1603 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[317]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4468,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1604 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k4466 in k4431 in port->fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4468,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1609 posix-error */
t2=lf[3];
f_1683(6,t2,((C_word*)t0)[3],lf[60],lf[315],lf[318],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4451,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1607 posix-error */
t4=lf[3];
f_1683(6,t4,t3,lf[48],lf[315],lf[319],((C_word*)t0)[2]);}
else{
t4=t3;
f_4451(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4449 in k4466 in k4431 in port->fileno in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4415(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4415r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4415r(t0,t1,t2,t3);}}

static void C_ccall f_4415r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[314]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4427,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1598 mode */
f_4349(t5,C_SCHEME_FALSE,t3);}

/* k4425 in open-output-file* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4427(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4427,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1598 check */
f_4386(((C_word*)t0)[2],lf[314],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4401(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4401r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4401r(t0,t1,t2,t3);}}

static void C_ccall f_4401r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[313]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4413,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1594 mode */
f_4349(t5,C_SCHEME_TRUE,t3);}

/* k4411 in open-input-file* in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4413,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1594 check */
f_4386(((C_word*)t0)[2],lf[313],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4386(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4386,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1587 posix-error */
t6=lf[3];
f_1683(6,t6,t1,lf[48],t2,lf[311],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4399,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1588 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[312],lf[95]);}}

/* k4397 in check in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4349(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4349,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4357,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[305]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1581 ##sys#error */
t8=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[306],t5);}
else{
t8=t4;
f_4357(2,t8,lf[307]);}}
else{
/* posixunix.scm: 1582 ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[308],t5);}}
else{
t5=t4;
f_4357(2,t5,(C_truep(t2)?lf[309]:lf[310]));}}

/* k4355 in mode in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4357(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1577 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4324(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4324,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[299]);
t5=(C_word)C_i_check_string_2(t3,lf[299]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4305,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_4305(2,t9,C_SCHEME_FALSE);}}

/* k4303 in file-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4305,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4309,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_4309(2,t3,C_SCHEME_FALSE);}}

/* k4307 in k4303 in file-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub569(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1562 posix-error */
t3=lf[3];
f_1683(7,t3,((C_word*)t0)[4],lf[48],lf[300],lf[301],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4274(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4274,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[297]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4282,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4298,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1551 ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4296 in read-symbolic-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1551 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4280 in read-symbolic-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4282,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4285,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1553 posix-error */
t4=lf[3];
f_1683(6,t4,t3,lf[48],lf[297],lf[298],((C_word*)t0)[2]);}
else{
t4=t3;
f_4285(2,t4,C_SCHEME_UNDEFINED);}}

/* k4283 in k4280 in read-symbolic-link in k4271 in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1554 substring */
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4236(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4236,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[293]);
t5=(C_word)C_i_check_string_2(t3,lf[293]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4257,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4269,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1539 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4267 in create-symbolic-link in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1539 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4255 in create-symbolic-link in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4257,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4261,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4265,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1540 ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4263 in k4255 in create-symbolic-link in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1540 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4259 in k4255 in create-symbolic-link in k4232 in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1542 posix-error */
t3=lf[3];
f_1683(7,t3,((C_word*)t0)[4],lf[48],lf[294],lf[295],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4211(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4211,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[290]);
t5=(C_word)C_i_check_exact_2(t3,lf[290]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4227,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1517 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k4225 in set-process-group-id! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1518 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[290],lf[291],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-session in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4196,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4200,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4206,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1509 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_4200(2,t4,C_SCHEME_UNDEFINED);}}

/* k4204 in create-session in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1510 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[288],lf[289]);}

/* k4198 in create-session in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4190(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4190,3,t0,t1,t2);}
/* posixunix.scm: 1504 check */
f_4154(t1,t2,C_fix((C_word)X_OK),lf[287]);}

/* file-write-access? in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4184,3,t0,t1,t2);}
/* posixunix.scm: 1503 check */
f_4154(t1,t2,C_fix((C_word)W_OK),lf[286]);}

/* file-read-access? in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4178(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4178,3,t0,t1,t2);}
/* posixunix.scm: 1502 check */
f_4154(t1,t2,C_fix((C_word)R_OK),lf[285]);}

/* check in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_4154(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4154,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4172,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4176,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1499 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4174 in check in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1499 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4170 in check in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4172,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4164,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_4164(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1500 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4162 in k4170 in check in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4124(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4124,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[283]);
t6=(C_word)C_i_check_exact_2(t3,lf[283]);
t7=(C_word)C_i_check_exact_2(t4,lf[283]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4148,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4152,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1489 ##sys#expand-home-path */
t10=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k4150 in change-file-owner in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1489 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4146 in change-file-owner in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1490 posix-error */
t3=lf[3];
f_1683(8,t3,((C_word*)t0)[3],lf[48],lf[283],lf[284],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4097(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4097,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[281]);
t5=(C_word)C_i_check_exact_2(t3,lf[281]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4118,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4122,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1481 ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4120 in change-file-mode in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1481 ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4116 in change-file-mode in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1482 posix-error */
t3=lf[3];
f_1683(7,t3,((C_word*)t0)[3],lf[48],lf[281],lf[282],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4033(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4033,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[240]);
t5=(C_word)C_i_check_exact_2(t3,lf[240]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4021,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_4021(2,t9,C_SCHEME_FALSE);}}

/* k4019 in initialize-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4021,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub509(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4049,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1402 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k4047 in k4019 in initialize-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_4049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1403 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[240],lf[241],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3959(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3959,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3963,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_3889(t4);
if(C_truep(t5)){
t6=t3;
f_3963(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1385 ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[237],lf[239]);}}

/* k3961 in set-groups! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3963,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3968,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3968(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do496 in k3961 in set-groups! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3968(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3968,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3984,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1390 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[237]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k3982 in do496 in k3961 in set-groups! in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1391 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[237],lf[238],((C_word*)t0)[2]);}

/* get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3896,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3900,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3954,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1371 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3900(2,t4,C_SCHEME_UNDEFINED);}}

/* k3952 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1372 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[236]);}

/* k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3900(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3900,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3903,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_3889(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_3903(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1374 ##sys#error */
t4=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[233],lf[235]);}}

/* k3901 in k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3903(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3903,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3906,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub478(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3935,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1376 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_3906(2,t5,C_SCHEME_UNDEFINED);}}

/* k3933 in k3901 in k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1377 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[234]);}

/* k3904 in k3901 in k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3906,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3911,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li94),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3911(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k3904 in k3901 in k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3911(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3911,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3925,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1381 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k3923 in loop in k3904 in k3901 in k3898 in get-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3925,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_3889(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub482(C_SCHEME_UNDEFINED,t2));}

/* group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3803(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3803r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3803r(t0,t1,t2,t3);}}

static void C_ccall f_3803r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3807,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_3807(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_3807(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3807,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3810,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_3810(t3,(C_word)C_getgrgid(((C_word*)t0)[2]));}
else{
t3=(C_word)C_i_check_string_2(((C_word*)t0)[2],lf[231]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3861,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1345 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k3859 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3810(t2,(C_word)C_getgrnam(t1));}

/* k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3810(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3810,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3820,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3820,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3824,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k3822 in k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3824,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3828,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3833,a[2]=t4,a[3]=((C_word)li91),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3833(t6,t2,C_fix(0));}

/* loop in k3822 in k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3833(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3833,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3837,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub461(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3835 in loop in k3822 in k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3837,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3847,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1354 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3833(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k3845 in k3835 in loop in k3822 in k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3847,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k3826 in k3822 in k3818 in k3808 in k3805 in group-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc6)C_retrieve_proc(t3))(6,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3778,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3786,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3790,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1330 current-effective-user-id */
t4=*((C_word*)lf[222]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3788 in current-effective-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3790(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1330 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3784 in current-effective-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_list_ref(t1,C_fix(0)));}

/* current-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3764,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3772,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3776,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1327 current-user-id */
t4=*((C_word*)lf[221]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3774 in current-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1327 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3770 in current-user-name in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_list_ref(t1,C_fix(0)));}

/* user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3697(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3697r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3697r(t0,t1,t2,t3);}}

static void C_ccall f_3697r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3701,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_3701(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_3701(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3701,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3704,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_3704(t3,(C_word)C_getpwuid(((C_word*)t0)[2]));}
else{
t3=(C_word)C_i_check_string_2(((C_word*)t0)[2],lf[227]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3743,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1315 ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k3741 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3704(t2,(C_word)C_getpwnam(t1));}

/* k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3704(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3704,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3714,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3712 in k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3714,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3718,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k3716 in k3712 in k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3718,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3722,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k3720 in k3716 in k3712 in k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3722,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3726,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k3724 in k3720 in k3716 in k3712 in k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3726,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3730,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k3728 in k3724 in k3720 in k3716 in k3712 in k3702 in k3699 in user-information in k3693 in k3689 in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[7])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc9)C_retrieve_proc(t3))(9,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-group-id! in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3674(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3674,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3684,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1285 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3682 in set-group-id! in k3670 in k3666 in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1286 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[224],((C_word*)t0)[2]);}

/* set-user-id! in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3651(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3651,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3661,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1265 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3659 in set-user-id! in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1266 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[220],((C_word*)t0)[2]);}

/* system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3613,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3617,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3646,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1254 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_3617(2,t3,C_SCHEME_UNDEFINED);}}

/* k3644 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1255 ##sys#error */
t2=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[216],lf[218]);}

/* k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3617,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3624,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k3622 in k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3624,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3628,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k3626 in k3622 in k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3628(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3628,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3632,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k3630 in k3626 in k3622 in k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3632,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3636,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k3634 in k3630 in k3626 in k3622 in k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3636,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3640,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k3638 in k3634 in k3630 in k3626 in k3622 in k3615 in system-information in k3609 in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3640(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3640,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3595(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3595,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[214]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1233 posix-error */
t5=lf[3];
f_1683(5,t5,t1,lf[208],lf[214],lf[215]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3580(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3580,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1227 posix-error */
t5=lf[3];
f_1683(5,t5,t1,lf[208],lf[212],lf[213]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3574(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3574,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[211]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3542,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3548,a[2]=t3,a[3]=((C_word)li80),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3548(t5,t1,*((C_word*)lf[203]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3548(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3548,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1217 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3518(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3518,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[207]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3525,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3536,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp);
/* for-each */
t7=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a3535 in set-signal-mask! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3536(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3536,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[207]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k3523 in set-signal-mask! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1210 posix-error */
t2=lf[3];
f_1683(5,t2,((C_word*)t0)[2],lf[208],lf[207],lf[209]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3500(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3500,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3510,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1196 h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixunix.scm: 1198 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k3508 in ##sys#interrupt-hook in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3510(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1197 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3487(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3487,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[206]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k3474 in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3478(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3478,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[205]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3431(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3431,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3435,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 1113 posix-error */
t3=lf[3];
f_1683(5,t3,t2,lf[48],lf[176],lf[177]);}
else{
t3=t2;
f_3435(2,t3,C_SCHEME_UNDEFINED);}}

/* k3433 in create-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3435(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1114 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3411r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3411r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3411r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[175]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3415,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3413 in with-output-to-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3415,2,t0,t1);}
t2=C_mutate((C_word*)lf[175]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3421,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li72),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1101 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3420 in k3413 in with-output-to-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3421(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3421r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3421r(t0,t1,t2);}}

static void C_ccall f_3421r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3425,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1103 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3423 in a3420 in k3413 in with-output-to-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[175]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3391(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3391r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3391r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3391r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[173]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3395,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3393 in with-input-from-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3395,2,t0,t1);}
t2=C_mutate((C_word*)lf[173]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3401,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li70),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1091 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3400 in k3393 in with-input-from-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3401(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3401r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3401r(t0,t1,t2);}}

static void C_ccall f_3401r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3405,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1093 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3403 in a3400 in k3393 in with-input-from-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[173]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3367(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3367r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3367r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3367r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3371,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3369 in call-with-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3371,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3376,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li67),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3382,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li68),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1081 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3381 in k3369 in call-with-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3382(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3382r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3382r(t0,t1,t2);}}

static void C_ccall f_3382r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3386,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1084 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3384 in a3381 in k3369 in call-with-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3375 in k3369 in call-with-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3376,2,t0,t1);}
/* posixunix.scm: 1082 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3343(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3343r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3343r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3343r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3347,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3345 in call-with-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3347,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3352,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li64),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3358,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li65),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1073 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3357 in k3345 in call-with-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3358(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3358r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3358r(t0,t1,t2);}}

static void C_ccall f_3358r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3362,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1076 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3360 in a3357 in k3345 in call-with-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3351 in k3345 in call-with-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3352(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3352,2,t0,t1);}
/* posixunix.scm: 1074 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3327(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3327,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3331,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1060 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[165]);}

/* k3329 in close-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3331,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3334,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 1062 posix-error */
t5=lf[3];
f_1683(6,t5,t3,lf[48],lf[166],lf[167],((C_word*)t0)[3]);}
else{
t5=t3;
f_3334(2,t5,C_SCHEME_UNDEFINED);}}

/* k3332 in k3329 in close-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3291(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3291r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3291r(t0,t1,t2,t3);}}

static void C_ccall f_3291r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[164]);
t5=f_3222(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3305,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[156]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3312,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1055 ##sys#make-c-string */
t9=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3322,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1056 ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1057 badmode */
f_3234(t6,t5);}}}

/* k3320 in open-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3322,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3305(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k3310 in open-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3312(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3312,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3305(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k3303 in open-output-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1051 check */
f_3240(((C_word*)t0)[3],lf[164],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3255(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3255r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3255r(t0,t1,t2,t3);}}

static void C_ccall f_3255r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[162]);
t5=f_3222(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3269,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[156]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3276,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1044 ##sys#make-c-string */
t9=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3286,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1045 ##sys#make-c-string */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1046 badmode */
f_3234(t6,t5);}}}

/* k3284 in open-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3286,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3269(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k3274 in open-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3276,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3269(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k3267 in open-input-pipe in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1040 check */
f_3240(((C_word*)t0)[3],lf[162],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3240(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3240,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1032 posix-error */
t6=lf[3];
f_1683(6,t6,t1,lf[48],t2,lf[158],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3253,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1033 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[161],lf[95]);}}

/* k3251 in check in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3234(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3234,NULL,2,t1,t2);}
/* posixunix.scm: 1029 ##sys#error */
t3=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[157],t2);}

/* mode in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_3222(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[156]));}

/* canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2905(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2905,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[116]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2912,a[2]=t1,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3026,a[2]=t4,a[3]=((C_word*)t0)[11],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 977  cwd */
t8=((C_word*)t0)[6];
f_2849(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3032,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[12],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[11],a[10]=t2,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3212,a[2]=((C_word*)t0)[12],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 979  sref */
t10=((C_word*)t0)[9];
((C_proc4)C_retrieve_proc(t10))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_3032(t9,C_SCHEME_FALSE);}}}

/* k3210 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 979  sep? */
t2=((C_word*)t0)[3];
f_3032(t2,f_2838(t1));}

/* k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3032(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3032,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[11];
f_2912(2,t2,((C_word*)t0)[10]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[10]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3045,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[11],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 982  cwd */
t5=((C_word*)t0)[8];
f_2849(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3051,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[9],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3187,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3198,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 983  sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[10],C_fix(0));}}}

/* k3196 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 983  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3185 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3187,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3194,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 984  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3051(t2,C_SCHEME_FALSE);}}

/* k3192 in k3185 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 984  sep? */
t2=((C_word*)t0)[3];
f_3051(t2,f_2838(t1));}

/* k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3051(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[32],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3051,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3058,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 986  getenv */
t3=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[153]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[9]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3089,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 991  cwd */
t5=((C_word*)t0)[6];
f_2849(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3095,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3159,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3180,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 992  sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[9],C_fix(0));}}}

/* k3178 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 992  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3157 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3159,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3165,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3176,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 993  sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_3095(t2,C_SCHEME_FALSE);}}

/* k3174 in k3157 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 993  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3163 in k3157 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3165,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3172,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 994  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_3095(t2,C_SCHEME_FALSE);}}

/* k3170 in k3163 in k3157 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 994  sep? */
t2=((C_word*)t0)[3];
f_3095(t2,f_2838(t1));}

/* k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_3095(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3095,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[9]);
/* posixunix.scm: 995  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3108,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3135,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3156,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 996  sref */
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[9],C_fix(0));}}

/* k3154 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 996  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3133 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3135,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3141,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3152,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 997  sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3108(2,t2,C_SCHEME_FALSE);}}

/* k3150 in k3133 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 997  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3139 in k3133 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3141,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3148,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 998  sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3108(2,t2,C_SCHEME_FALSE);}}

/* k3146 in k3139 in k3133 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 998  char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3106 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3108,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[7]);
/* posixunix.scm: 999  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3132,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1000 sref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[7],C_fix(0));}}

/* k3130 in k3106 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3132(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3132,2,t0,t1);}
t2=f_2838(t1);
if(C_truep(t2)){
t3=((C_word*)t0)[5];
f_2912(2,t3,((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3128,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1003 cwd */
t4=((C_word*)t0)[2];
f_2849(t4,t3);}}

/* k3126 in k3130 in k3106 in k3093 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1003 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[155],((C_word*)t0)[2]);}

/* k3087 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 991  sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[154],((C_word*)t0)[2]);}

/* k3056 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3058,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3061,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;
f_3061(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3076,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 987  user */
t4=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}}

/* k3074 in k3056 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 987  sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[152],t1);}

/* k3059 in k3056 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3061,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3065,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 988  ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k3063 in k3059 in k3056 in k3049 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 985  sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3043 in k3030 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 982  sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[151],((C_word*)t0)[2]);}

/* k3024 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 977  sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[150]);}

/* k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2912,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2919,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=t1;
/* string-split */
t4=*((C_word*)lf[115]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,lf[149]);}

/* k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2919(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2919,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2921,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word)li56),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_2921(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2921(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2921,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2928,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1006 null? */
t5=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2928,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2934,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1007 null? */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2989,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2992,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[8],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_i_car(((C_word*)t0)[4]);
/* posixunix.scm: 1018 string=? */
t6=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,lf[148],t5);}}

/* k2990 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2992,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_2989(t2,(C_word)C_i_cdr(((C_word*)t0)[4]));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3001,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(((C_word*)t0)[3]);
/* posixunix.scm: 1020 string=? */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,lf[147],t3);}}

/* k2999 in k2990 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_3001(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3001,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_2989(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_2989(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k2987 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2989(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1016 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2921(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2934,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[142]);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2970,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[3]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixunix.scm: 1009 sref */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,((C_word*)t0)[3],t4);}}

/* k2968 in k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2970,2,t0,t1);}
t2=f_2838(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2947,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2951,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_a_i_cons(&a,2,lf[144],((C_word*)t0)[2]);
/* posixunix.scm: 1012 reverse */
t6=*((C_word*)lf[145]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2962,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2966,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1015 reverse */
t5=*((C_word*)lf[145]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k2964 in k2968 in k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1015 isperse */
f_2833(((C_word*)t0)[2],t1);}

/* k2960 in k2968 in k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1013 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[146],t1);}

/* k2949 in k2968 in k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1012 isperse */
f_2833(((C_word*)t0)[2],t1);}

/* k2945 in k2968 in k2932 in k2926 in loop in k2917 in k2910 in canonical-path in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2947(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1010 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[143],t1);}

/* cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2849(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2849,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2856,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2858,a[2]=((C_word*)t0)[2],a[3]=((C_word)li54),tmp=(C_word)a,a+=4,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[141]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2858(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2858,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2864,a[2]=t2,a[3]=((C_word)li49),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2882,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li53),tmp=(C_word)a,a+=5,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[140]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t3,t4);}

/* a2881 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2882,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2888,a[2]=((C_word*)t0)[3],a[3]=((C_word)li50),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2894,a[2]=((C_word*)t0)[2],a[3]=((C_word)li52),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t2,t3);}

/* a2893 in a2881 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2894(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2894r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2894r(t0,t1,t2);}}

static void C_ccall f_2894r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2900,a[2]=t2,a[3]=((C_word)li51),tmp=(C_word)a,a+=4,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2899 in a2893 in a2881 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2900(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2900,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2887 in a2881 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2888,2,t0,t1);}
/* posixunix.scm: 972  cw */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a2863 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2864(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2864,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2870,a[2]=t2,a[3]=((C_word)li48),tmp=(C_word)a,a+=4,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2869 in a2863 in a2857 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2870,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[138]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[139]);}

/* k2854 in cwd in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* sep? in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_2838(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2833(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2833,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[134]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,t2,lf[135]);}

/* current-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2785(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2785r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2785r(t0,t1,t2);}}

static void C_ccall f_2785r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2789,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2789(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2789(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k2787 in current-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2789,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 950  change-directory */
t2=*((C_word*)lf[117]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2798,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 951  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2796 in k2787 in current-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2798(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 954  ##sys#substring */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 955  posix-error */
t3=lf[3];
f_1683(5,t3,((C_word*)t0)[2],lf[48],lf[126],lf[129]);}}

/* directory? in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2762(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2762,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[127]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2769,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2783,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 943  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2781 in directory? in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 943  ##sys#file-info */
t2=*((C_word*)lf[128]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2767 in directory? in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr2r,(void*)f_2605r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2605r(t0,t1,t2);}}

static void C_ccall f_2605r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(13);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2607,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word)li40),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2705,a[2]=t3,a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2710,a[2]=t4,a[3]=((C_word)li42),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec250275 */
t6=t5;
f_2710(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?251273 */
t8=t4;
f_2705(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body248253 */
t10=t3;
f_2607(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec250 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2710(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2710,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2718,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 916  current-directory */
t3=*((C_word*)lf[126]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2716 in def-spec250 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?251273 */
t2=((C_word*)t0)[3];
f_2705(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?251 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2705(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2705,NULL,3,t0,t1,t2);}
/* body248253 */
t3=((C_word*)t0)[2];
f_2607(t3,t1,t2,C_SCHEME_FALSE);}

/* body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2607(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2607,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[123]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2614,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 918  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2614,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2617,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 919  ##sys#make-pointer */
t3=*((C_word*)lf[125]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2617,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2620,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 920  ##sys#make-pointer */
t3=*((C_word*)lf[125]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2620,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2624,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2704,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 921  ##sys#expand-home-path */
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[5]);}

/* k2702 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 921  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2624,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[8]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[8]))){
/* posixunix.scm: 923  posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[7],lf[48],lf[123],lf[124],((C_word*)t0)[6]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[8],a[8]=((C_word)li39),tmp=(C_word)a,a+=9,tmp));
t6=((C_word*)t4)[1];
f_2638(t6,((C_word*)t0)[7]);}}

/* loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2638(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2638,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[7],((C_word*)t0)[6]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[6]))){
t3=(C_word)C_closedir(((C_word*)t0)[7]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[6],((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2648,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 931  ##sys#substring */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t3);}}

/* k2646 in loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2648,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2651,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 932  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,t1,C_fix(0));}

/* k2649 in k2646 in loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2651,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2654,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
/* posixunix.scm: 933  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[5],C_fix(1));}
else{
t3=t2;
f_2654(2,t3,C_SCHEME_FALSE);}}

/* k2652 in k2649 in k2646 in loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2654(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2654,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2660,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_make_character(46),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(C_word)C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_2660(t5,t4);}
else{
t5=(C_word)C_eqp(C_make_character(46),t1);
t6=(C_truep(t5)?(C_word)C_eqp(C_fix(2),((C_word*)t0)[3]):C_SCHEME_FALSE);
t7=t2;
f_2660(t7,(C_truep(t6)?t6:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t4=t2;
f_2660(t4,C_SCHEME_FALSE);}}

/* k2658 in k2652 in k2649 in k2646 in loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2660(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2660,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 938  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2638(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2670,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 939  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2638(t3,t2);}}

/* k2668 in k2658 in k2652 in k2649 in k2646 in loop in k2622 in k2618 in k2615 in k2612 in body248 in directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2670,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2581(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2581,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[119]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2599,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2603,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 909  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2601 in delete-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 909  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2597 in delete-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 910  posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[119],lf[120],((C_word*)t0)[2]);}}

/* change-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2557,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[117]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2575,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2579,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 903  ##sys#expand-home-path */
t6=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2577 in change-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 903  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2573 in change-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 904  posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[117],lf[118],((C_word*)t0)[2]);}}

/* create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2449(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2449r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2449r(t0,t1,t2,t3);}}

static void C_ccall f_2449r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2453,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_2453(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_2453(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2453,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[113]);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2462,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 895  canonical-path */
t4=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2522,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 896  canonical-path */
t4=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}}

/* k2520 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2522,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2536,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k2534 in k2520 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[113],*((C_word*)lf[101]+1),((C_word*)t0)[2]);}}

/* k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2462,2,t0,t1);}
t2=*((C_word*)lf[111]+1);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2467,a[2]=t3,a[3]=((C_word)li35),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2519,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-split */
t6=*((C_word*)lf[115]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,t1,*((C_word*)lf[107]+1));}

/* k2517 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2519(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* for-each */
t2=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2467(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2467,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2472,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-append */
t4=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],*((C_word*)lf[109]+1),t2);}

/* k2470 in a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2472(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2472,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2478,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2495,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* file-exists? */
t6=*((C_word*)lf[114]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t3);}

/* k2493 in k2470 in a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2495,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2515,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2478(2,t2,C_SCHEME_FALSE);}}

/* k2513 in k2493 in k2470 in a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_stat(t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[113],*((C_word*)lf[105]+1),((C_word*)t0)[2]);}
else{
t3=C_mk_bool(C_isdir);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
f_2478(2,t4,t3);}
else{
/* posix-error */
t4=lf[3];
f_1683(6,t4,((C_word*)t0)[3],lf[48],lf[113],*((C_word*)lf[103]+1),((C_word*)t0)[2]);}}}

/* k2476 in k2470 in a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2478,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2492,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k2490 in k2476 in k2470 in a2466 in k2460 in k2451 in create-directory in k2439 in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1683(6,t3,((C_word*)t0)[3],lf[48],lf[113],*((C_word*)lf[101]+1),((C_word*)t0)[2]);}}

/* set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2381(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2381r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2381r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2381r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[93]);
t8=(C_word)C_i_check_exact_2(t6,lf[93]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2394,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 839  ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[98],lf[93],lf[99],t3,t2);}
else{
t10=t9;
f_2394(2,t10,C_SCHEME_UNDEFINED);}}

/* k2392 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2394,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2400,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2406,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 840  port? */
t4=*((C_word*)lf[97]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2404 in k2392 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[95]);
t4=((C_word*)t0)[4];
f_2400(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_2400(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 844  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[60],lf[93],lf[96],((C_word*)t0)[5]);}}}

/* k2398 in k2392 in set-file-position! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2400(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 845  posix-error */
t2=lf[3];
f_1683(7,t2,((C_word*)t0)[4],lf[48],lf[93],lf[94],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* stat-socket? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2372(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2372,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[92]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2379,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 831  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[92]);}

/* k2377 in stat-socket? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_issock));}

/* stat-symlink? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2363(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2363,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[91]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2370,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#stat */
f_2195(t4,t2,C_SCHEME_TRUE,lf[91]);}

/* k2368 in stat-symlink? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* stat-fifo? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2354(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2354,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2361,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 821  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[90]);}

/* k2359 in stat-fifo? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isfifo));}

/* stat-block-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2345(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2345,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[89]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2352,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 816  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[89]);}

/* k2350 in stat-block-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2352(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isblk));}

/* stat-char-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2336(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2336,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[88]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2343,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 811  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[88]);}

/* k2341 in stat-char-device? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_ischr));}

/* stat-directory? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2327(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2327,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[87]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2334,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 806  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[87]);}

/* k2332 in stat-directory? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isdir));}

/* stat-regular? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2318(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2318,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[86]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2325,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 801  ##sys#stat */
f_2195(t4,t2,C_SCHEME_FALSE,lf[86]);}

/* k2323 in stat-regular? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* symbolic-link? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2309(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2309,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2316,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 796  ##sys#stat */
f_2195(t4,t2,C_SCHEME_TRUE,lf[85]);}

/* k2314 in symbolic-link? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2300(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2300,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[84]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2307,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 791  ##sys#stat */
f_2195(t4,t2,C_SCHEME_TRUE,lf[84]);}

/* k2305 in regular-file? in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2294(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2294,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2298,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 787  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[83]);}

/* k2296 in file-permissions in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2288(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2288,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2292,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 786  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[82]);}

/* k2290 in file-owner in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2282(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2282,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2286,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 785  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[81]);}

/* k2284 in file-change-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2286,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2276(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2276,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2280,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 784  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[80]);}

/* k2278 in file-access-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2280,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2270(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2270,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2274,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 783  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[79]);}

/* k2272 in file-modification-time in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2274,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2264(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2264,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2268,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 782  ##sys#stat */
f_2195(t3,t2,C_SCHEME_FALSE,lf[78]);}

/* k2266 in file-size in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2268(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2268,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2232(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_2232r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2232r(t0,t1,t2,t3);}}

static void C_ccall f_2232r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2236,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2243,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_2243(2,t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_2243(2,t7,(C_word)C_i_car(t3));}
else{
/* posixunix.scm: 775  ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t3);}}}

/* k2241 in file-stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2243(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 775  ##sys#stat */
f_2195(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[77]);}

/* k2234 in file-stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2236,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2195(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2195,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2199,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_2199(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2220,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2227,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 766  ##sys#expand-home-path */
t8=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 770  ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[60],lf[76],t2);}}}

/* k2225 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 766  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2218 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2199(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k2197 in ##sys#stat in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2199(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 772  posix-error */
t2=lf[3];
f_1683(6,t2,((C_word*)t0)[4],lf[48],((C_word*)t0)[3],lf[75],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2003(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2003r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2003r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2003r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1977(C_fix(0));
t10=f_1977(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2019,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_2019(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 695  fd_set */
t14=t12;
f_2019(2,t14,f_1983(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[68]);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2176,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=((C_word)li15),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t15=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a2175 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2176(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2176,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[68]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 702  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1983(C_fix(0),t2));}

/* k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2019,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2025,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_2025(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 707  fd_set */
t5=t3;
f_2025(2,t5,f_1983(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[68]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2150,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word)li14),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t6=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a2149 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2150(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2150,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[68]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 714  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1983(C_fix(1),t2));}

/* k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2025,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2028,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_number_2(((C_word*)t0)[3],lf[68]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_2028(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_2028(t4,(C_word)C_C_select(t3));}}

/* k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2028(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2028,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 721  posix-error */
t2=lf[3];
f_1683(7,t2,((C_word*)t0)[5],lf[48],lf[68],lf[69],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 722  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2067,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 727  fd_test */
t4=t3;
f_2067(t4,f_1993(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2108,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2110,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=((C_word)li13),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t8=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_2067(t4,C_SCHEME_FALSE);}}}}

/* a2109 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2110(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2110,3,t0,t1,t2);}
t3=f_1993(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2106 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2067(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2065 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2067(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2067,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2071,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 733  fd_test */
t3=t2;
f_2071(t3,f_1993(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2083,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2085,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=((C_word)li12),tmp=(C_word)a,a+=5,tmp);
/* for-each */
t7=*((C_word*)lf[70]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_2071(t3,C_SCHEME_FALSE);}}

/* a2084 in k2065 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2085(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2085,3,t0,t1,t2);}
t3=f_1993(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2081 in k2065 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_2083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2071(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2069 in k2065 in k2026 in k2023 in k2017 in file-select in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_fcall f_2071(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 724  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1993(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub92(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1983(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub86(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static C_word C_fcall f_1977(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub81(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1945(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1945,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[65]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1952,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 673  ##sys#make-c-string */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1950 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1952,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1958,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 677  posix-error */
t6=lf[3];
f_1683(6,t6,t4,lf[48],lf[65],lf[67],((C_word*)t0)[2]);}
else{
t6=t4;
f_1958(2,t6,C_SCHEME_UNDEFINED);}}

/* k1956 in k1950 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1958,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1965,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 678  ##sys#substring */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1963 in k1956 in k1950 in file-mkstemp in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 678  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1906(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1906r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1906r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1906r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[62]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1913,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1913(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 662  ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[60],lf[62],lf[64],t3);}}

/* k1911 in file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1913,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[62]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1922,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 667  posix-error */
t8=lf[3];
f_1683(7,t8,t6,lf[48],lf[62],lf[63],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_1922(2,t8,C_SCHEME_UNDEFINED);}}

/* k1920 in k1911 in file-write in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1864(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1864r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1864r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1864r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[58]);
t6=(C_word)C_i_check_exact_2(t3,lf[58]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1874,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1874(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixunix.scm: 650  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1872 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1874,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1877,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1877(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 652  ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[60],lf[58],lf[61],t1);}}

/* k1875 in k1872 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1877,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1880,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 655  posix-error */
t5=lf[3];
f_1683(7,t5,t3,lf[48],lf[58],lf[59],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_1880(2,t5,C_SCHEME_UNDEFINED);}}

/* k1878 in k1875 in k1872 in file-read in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1880,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1849(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1849,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[55]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 643  posix-error */
t4=lf[3];
f_1683(6,t4,t1,lf[48],lf[55],lf[56],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1811(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1811r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1811r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1811r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[51]);
t8=(C_word)C_i_check_exact_2(t3,lf[51]);
t9=(C_word)C_i_check_exact_2(t6,lf[51]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1828,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1841,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 634  ##sys#expand-home-path */
t12=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1839 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 634  ##sys#make-c-string */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1826 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1828,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1831,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 636  posix-error */
t5=lf[3];
f_1683(8,t5,t3,lf[48],lf[51],lf[52],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_1831(2,t5,C_SCHEME_UNDEFINED);}}

/* k1829 in k1826 in file-open in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1765(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1765r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1765r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1765r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1769,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
t6=t5;
f_1769(2,t6,C_fix(0));}
else{
t6=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_1769(2,t7,(C_word)C_i_car(t4));}
else{
/* ##sys#error */
t7=*((C_word*)lf[50]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t4);}}}

/* k1767 in file-control in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[47]);
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[47]);
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[3];
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)C_i_foreign_fixnum_argumentp(t5);
t8=(C_word)C_i_foreign_integer_argumentp(t1);
t9=(C_word)stub24(C_SCHEME_UNDEFINED,t6,t7,t8);
t10=(C_word)C_eqp(t9,C_fix(-1));
if(C_truep(t10)){
/* posixunix.scm: 624  posix-error */
t11=lf[3];
f_1683(7,t11,((C_word*)t0)[2],lf[48],lf[47],lf[49],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t11=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t9);}}

/* ##sys#file-select-one in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1708(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1708,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub17(C_SCHEME_UNDEFINED,t3));}

/* ##sys#file-nonblocking! in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1701(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1701,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub13(C_SCHEME_UNDEFINED,t3));}

/* posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1683(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1683r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1683r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1683r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1687,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 514  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1685 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1687,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1694,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1698,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub3(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1696 in k1685 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 515  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k1692 in k1685 in posix-error in k1669 in k1666 in k1663 in k1660 in k1657 in k1654 */
static void C_ccall f_1694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[617] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1656posixunix.scm",(void*)f_1656},
{"f_1659posixunix.scm",(void*)f_1659},
{"f_1662posixunix.scm",(void*)f_1662},
{"f_1665posixunix.scm",(void*)f_1665},
{"f_1668posixunix.scm",(void*)f_1668},
{"f_1671posixunix.scm",(void*)f_1671},
{"f_7576posixunix.scm",(void*)f_7576},
{"f_7592posixunix.scm",(void*)f_7592},
{"f_7580posixunix.scm",(void*)f_7580},
{"f_7583posixunix.scm",(void*)f_7583},
{"f_2441posixunix.scm",(void*)f_2441},
{"f_3476posixunix.scm",(void*)f_3476},
{"f_7570posixunix.scm",(void*)f_7570},
{"f_3611posixunix.scm",(void*)f_3611},
{"f_7567posixunix.scm",(void*)f_7567},
{"f_3668posixunix.scm",(void*)f_3668},
{"f_7552posixunix.scm",(void*)f_7552},
{"f_7562posixunix.scm",(void*)f_7562},
{"f_7549posixunix.scm",(void*)f_7549},
{"f_3672posixunix.scm",(void*)f_3672},
{"f_7546posixunix.scm",(void*)f_7546},
{"f_3691posixunix.scm",(void*)f_3691},
{"f_7531posixunix.scm",(void*)f_7531},
{"f_7541posixunix.scm",(void*)f_7541},
{"f_7528posixunix.scm",(void*)f_7528},
{"f_3695posixunix.scm",(void*)f_3695},
{"f_7510posixunix.scm",(void*)f_7510},
{"f_7523posixunix.scm",(void*)f_7523},
{"f_7517posixunix.scm",(void*)f_7517},
{"f_4234posixunix.scm",(void*)f_4234},
{"f_4273posixunix.scm",(void*)f_4273},
{"f_7487posixunix.scm",(void*)f_7487},
{"f_7479posixunix.scm",(void*)f_7479},
{"f_7222posixunix.scm",(void*)f_7222},
{"f_7405posixunix.scm",(void*)f_7405},
{"f_7411posixunix.scm",(void*)f_7411},
{"f_7400posixunix.scm",(void*)f_7400},
{"f_7395posixunix.scm",(void*)f_7395},
{"f_7224posixunix.scm",(void*)f_7224},
{"f_7382posixunix.scm",(void*)f_7382},
{"f_7390posixunix.scm",(void*)f_7390},
{"f_7231posixunix.scm",(void*)f_7231},
{"f_7370posixunix.scm",(void*)f_7370},
{"f_7364posixunix.scm",(void*)f_7364},
{"f_7241posixunix.scm",(void*)f_7241},
{"f_7243posixunix.scm",(void*)f_7243},
{"f_7262posixunix.scm",(void*)f_7262},
{"f_7350posixunix.scm",(void*)f_7350},
{"f_7357posixunix.scm",(void*)f_7357},
{"f_7344posixunix.scm",(void*)f_7344},
{"f_7277posixunix.scm",(void*)f_7277},
{"f_7337posixunix.scm",(void*)f_7337},
{"f_7334posixunix.scm",(void*)f_7334},
{"f_7321posixunix.scm",(void*)f_7321},
{"f_7297posixunix.scm",(void*)f_7297},
{"f_7319posixunix.scm",(void*)f_7319},
{"f_7305posixunix.scm",(void*)f_7305},
{"f_7312posixunix.scm",(void*)f_7312},
{"f_7309posixunix.scm",(void*)f_7309},
{"f_7289posixunix.scm",(void*)f_7289},
{"f_7287posixunix.scm",(void*)f_7287},
{"f_7371posixunix.scm",(void*)f_7371},
{"f_7162posixunix.scm",(void*)f_7162},
{"f_7174posixunix.scm",(void*)f_7174},
{"f_7169posixunix.scm",(void*)f_7169},
{"f_7164posixunix.scm",(void*)f_7164},
{"f_7102posixunix.scm",(void*)f_7102},
{"f_7114posixunix.scm",(void*)f_7114},
{"f_7109posixunix.scm",(void*)f_7109},
{"f_7104posixunix.scm",(void*)f_7104},
{"f_7041posixunix.scm",(void*)f_7041},
{"f_7096posixunix.scm",(void*)f_7096},
{"f_7100posixunix.scm",(void*)f_7100},
{"f_7062posixunix.scm",(void*)f_7062},
{"f_7065posixunix.scm",(void*)f_7065},
{"f_7076posixunix.scm",(void*)f_7076},
{"f_7070posixunix.scm",(void*)f_7070},
{"f_7043posixunix.scm",(void*)f_7043},
{"f_7052posixunix.scm",(void*)f_7052},
{"f_6977posixunix.scm",(void*)f_6977},
{"f_6989posixunix.scm",(void*)f_6989},
{"f_7020posixunix.scm",(void*)f_7020},
{"f_7000posixunix.scm",(void*)f_7000},
{"f_7016posixunix.scm",(void*)f_7016},
{"f_7004posixunix.scm",(void*)f_7004},
{"f_7012posixunix.scm",(void*)f_7012},
{"f_7008posixunix.scm",(void*)f_7008},
{"f_6983posixunix.scm",(void*)f_6983},
{"f_6966posixunix.scm",(void*)f_6966},
{"f_6970posixunix.scm",(void*)f_6970},
{"f_6955posixunix.scm",(void*)f_6955},
{"f_6959posixunix.scm",(void*)f_6959},
{"f_6910posixunix.scm",(void*)f_6910},
{"f_6914posixunix.scm",(void*)f_6914},
{"f_6917posixunix.scm",(void*)f_6917},
{"f_6920posixunix.scm",(void*)f_6920},
{"f_6933posixunix.scm",(void*)f_6933},
{"f_6937posixunix.scm",(void*)f_6937},
{"f_6940posixunix.scm",(void*)f_6940},
{"f_6943posixunix.scm",(void*)f_6943},
{"f_6931posixunix.scm",(void*)f_6931},
{"f_6894posixunix.scm",(void*)f_6894},
{"f_6877posixunix.scm",(void*)f_6877},
{"f_6890posixunix.scm",(void*)f_6890},
{"f_6802posixunix.scm",(void*)f_6802},
{"f_6863posixunix.scm",(void*)f_6863},
{"f_6876posixunix.scm",(void*)f_6876},
{"f_6843posixunix.scm",(void*)f_6843},
{"f_6858posixunix.scm",(void*)f_6858},
{"f_6852posixunix.scm",(void*)f_6852},
{"f_6806posixunix.scm",(void*)f_6806},
{"f_6808posixunix.scm",(void*)f_6808},
{"f_6829posixunix.scm",(void*)f_6829},
{"f_6823posixunix.scm",(void*)f_6823},
{"f_6750posixunix.scm",(void*)f_6750},
{"f_6757posixunix.scm",(void*)f_6757},
{"f_6776posixunix.scm",(void*)f_6776},
{"f_6780posixunix.scm",(void*)f_6780},
{"f_6744posixunix.scm",(void*)f_6744},
{"f_6735posixunix.scm",(void*)f_6735},
{"f_6739posixunix.scm",(void*)f_6739},
{"f_6708posixunix.scm",(void*)f_6708},
{"f_6701posixunix.scm",(void*)f_6701},
{"f_6698posixunix.scm",(void*)f_6698},
{"f_6695posixunix.scm",(void*)f_6695},
{"f_6617posixunix.scm",(void*)f_6617},
{"f_6653posixunix.scm",(void*)f_6653},
{"f_6647posixunix.scm",(void*)f_6647},
{"f_6600posixunix.scm",(void*)f_6600},
{"f_6418posixunix.scm",(void*)f_6418},
{"f_6552posixunix.scm",(void*)f_6552},
{"f_6547posixunix.scm",(void*)f_6547},
{"f_6420posixunix.scm",(void*)f_6420},
{"f_6430posixunix.scm",(void*)f_6430},
{"f_6438posixunix.scm",(void*)f_6438},
{"f_6484posixunix.scm",(void*)f_6484},
{"f_6451posixunix.scm",(void*)f_6451},
{"f_6476posixunix.scm",(void*)f_6476},
{"f_6454posixunix.scm",(void*)f_6454},
{"f_6399posixunix.scm",(void*)f_6399},
{"f_6380posixunix.scm",(void*)f_6380},
{"f_6338posixunix.scm",(void*)f_6338},
{"f_6360posixunix.scm",(void*)f_6360},
{"f_6364posixunix.scm",(void*)f_6364},
{"f_6226posixunix.scm",(void*)f_6226},
{"f_6232posixunix.scm",(void*)f_6232},
{"f_6253posixunix.scm",(void*)f_6253},
{"f_6330posixunix.scm",(void*)f_6330},
{"f_6257posixunix.scm",(void*)f_6257},
{"f_6260posixunix.scm",(void*)f_6260},
{"f_6263posixunix.scm",(void*)f_6263},
{"f_6270posixunix.scm",(void*)f_6270},
{"f_6272posixunix.scm",(void*)f_6272},
{"f_6289posixunix.scm",(void*)f_6289},
{"f_6299posixunix.scm",(void*)f_6299},
{"f_6303posixunix.scm",(void*)f_6303},
{"f_6247posixunix.scm",(void*)f_6247},
{"f_6214posixunix.scm",(void*)f_6214},
{"f_6218posixunix.scm",(void*)f_6218},
{"f_6221posixunix.scm",(void*)f_6221},
{"f_6179posixunix.scm",(void*)f_6179},
{"f_6183posixunix.scm",(void*)f_6183},
{"f_6203posixunix.scm",(void*)f_6203},
{"f_6207posixunix.scm",(void*)f_6207},
{"f_6156posixunix.scm",(void*)f_6156},
{"f_6160posixunix.scm",(void*)f_6160},
{"f_6124posixunix.scm",(void*)f_6124},
{"f_6128posixunix.scm",(void*)f_6128},
{"f_6105posixunix.scm",(void*)f_6105},
{"f_6109posixunix.scm",(void*)f_6109},
{"f_6112posixunix.scm",(void*)f_6112},
{"f_6046posixunix.scm",(void*)f_6046},
{"f_6050posixunix.scm",(void*)f_6050},
{"f_6056posixunix.scm",(void*)f_6056},
{"f_6039posixunix.scm",(void*)f_6039},
{"f_6023posixunix.scm",(void*)f_6023},
{"f_6011posixunix.scm",(void*)f_6011},
{"f_5983posixunix.scm",(void*)f_5983},
{"f_5990posixunix.scm",(void*)f_5990},
{"f_5955posixunix.scm",(void*)f_5955},
{"f_5962posixunix.scm",(void*)f_5962},
{"f_5909posixunix.scm",(void*)f_5909},
{"f_5913posixunix.scm",(void*)f_5913},
{"f_5926posixunix.scm",(void*)f_5926},
{"f_5930posixunix.scm",(void*)f_5930},
{"f_5827posixunix.scm",(void*)f_5827},
{"f_5831posixunix.scm",(void*)f_5831},
{"f_5837posixunix.scm",(void*)f_5837},
{"f_5859posixunix.scm",(void*)f_5859},
{"f_5856posixunix.scm",(void*)f_5856},
{"f_5846posixunix.scm",(void*)f_5846},
{"f_5794posixunix.scm",(void*)f_5794},
{"f_5798posixunix.scm",(void*)f_5798},
{"f_5775posixunix.scm",(void*)f_5775},
{"f_5766posixunix.scm",(void*)f_5766},
{"f_5760posixunix.scm",(void*)f_5760},
{"f_5751posixunix.scm",(void*)f_5751},
{"f_5716posixunix.scm",(void*)f_5716},
{"f_5654posixunix.scm",(void*)f_5654},
{"f_5658posixunix.scm",(void*)f_5658},
{"f_5664posixunix.scm",(void*)f_5664},
{"f_5683posixunix.scm",(void*)f_5683},
{"f_5670posixunix.scm",(void*)f_5670},
{"f_5551posixunix.scm",(void*)f_5551},
{"f_5557posixunix.scm",(void*)f_5557},
{"f_5561posixunix.scm",(void*)f_5561},
{"f_5569posixunix.scm",(void*)f_5569},
{"f_5595posixunix.scm",(void*)f_5595},
{"f_5599posixunix.scm",(void*)f_5599},
{"f_5587posixunix.scm",(void*)f_5587},
{"f_5531posixunix.scm",(void*)f_5531},
{"f_5539posixunix.scm",(void*)f_5539},
{"f_5514posixunix.scm",(void*)f_5514},
{"f_5525posixunix.scm",(void*)f_5525},
{"f_5529posixunix.scm",(void*)f_5529},
{"f_5488posixunix.scm",(void*)f_5488},
{"f_5512posixunix.scm",(void*)f_5512},
{"f_5495posixunix.scm",(void*)f_5495},
{"f_5445posixunix.scm",(void*)f_5445},
{"f_5452posixunix.scm",(void*)f_5452},
{"f_5473posixunix.scm",(void*)f_5473},
{"f_5469posixunix.scm",(void*)f_5469},
{"f_5417posixunix.scm",(void*)f_5417},
{"f_5395posixunix.scm",(void*)f_5395},
{"f_5399posixunix.scm",(void*)f_5399},
{"f_5380posixunix.scm",(void*)f_5380},
{"f_5384posixunix.scm",(void*)f_5384},
{"f_5365posixunix.scm",(void*)f_5365},
{"f_5369posixunix.scm",(void*)f_5369},
{"f_5347posixunix.scm",(void*)f_5347},
{"f_5273posixunix.scm",(void*)f_5273},
{"f_5295posixunix.scm",(void*)f_5295},
{"f_5301posixunix.scm",(void*)f_5301},
{"f_5234posixunix.scm",(void*)f_5234},
{"f_5262posixunix.scm",(void*)f_5262},
{"f_5258posixunix.scm",(void*)f_5258},
{"f_5251posixunix.scm",(void*)f_5251},
{"f_4975posixunix.scm",(void*)f_4975},
{"f_5171posixunix.scm",(void*)f_5171},
{"f_5166posixunix.scm",(void*)f_5166},
{"f_5161posixunix.scm",(void*)f_5161},
{"f_4977posixunix.scm",(void*)f_4977},
{"f_4981posixunix.scm",(void*)f_4981},
{"f_5087posixunix.scm",(void*)f_5087},
{"f_5088posixunix.scm",(void*)f_5088},
{"f_5105posixunix.scm",(void*)f_5105},
{"f_5115posixunix.scm",(void*)f_5115},
{"f_5073posixunix.scm",(void*)f_5073},
{"f_5029posixunix.scm",(void*)f_5029},
{"f_5065posixunix.scm",(void*)f_5065},
{"f_5044posixunix.scm",(void*)f_5044},
{"f_5054posixunix.scm",(void*)f_5054},
{"f_5038posixunix.scm",(void*)f_5038},
{"f_5033posixunix.scm",(void*)f_5033},
{"f_5036posixunix.scm",(void*)f_5036},
{"f_4983posixunix.scm",(void*)f_4983},
{"f_5018posixunix.scm",(void*)f_5018},
{"f_4999posixunix.scm",(void*)f_4999},
{"f_4501posixunix.scm",(void*)f_4501},
{"f_4897posixunix.scm",(void*)f_4897},
{"f_4892posixunix.scm",(void*)f_4892},
{"f_4887posixunix.scm",(void*)f_4887},
{"f_4882posixunix.scm",(void*)f_4882},
{"f_4503posixunix.scm",(void*)f_4503},
{"f_4507posixunix.scm",(void*)f_4507},
{"f_4513posixunix.scm",(void*)f_4513},
{"f_4755posixunix.scm",(void*)f_4755},
{"f_4761posixunix.scm",(void*)f_4761},
{"f_4857posixunix.scm",(void*)f_4857},
{"f_4847posixunix.scm",(void*)f_4847},
{"f_4841posixunix.scm",(void*)f_4841},
{"f_4763posixunix.scm",(void*)f_4763},
{"f_4813posixunix.scm",(void*)f_4813},
{"f_4770posixunix.scm",(void*)f_4770},
{"f_4780posixunix.scm",(void*)f_4780},
{"f_4679posixunix.scm",(void*)f_4679},
{"f_4687posixunix.scm",(void*)f_4687},
{"f_4689posixunix.scm",(void*)f_4689},
{"f_4737posixunix.scm",(void*)f_4737},
{"f_4670posixunix.scm",(void*)f_4670},
{"f_4674posixunix.scm",(void*)f_4674},
{"f_4649posixunix.scm",(void*)f_4649},
{"f_4659posixunix.scm",(void*)f_4659},
{"f_4637posixunix.scm",(void*)f_4637},
{"f_4624posixunix.scm",(void*)f_4624},
{"f_4628posixunix.scm",(void*)f_4628},
{"f_4619posixunix.scm",(void*)f_4619},
{"f_4622posixunix.scm",(void*)f_4622},
{"f_4537posixunix.scm",(void*)f_4537},
{"f_4549posixunix.scm",(void*)f_4549},
{"f_4586posixunix.scm",(void*)f_4586},
{"f_4595posixunix.scm",(void*)f_4595},
{"f_4589posixunix.scm",(void*)f_4589},
{"f_4565posixunix.scm",(void*)f_4565},
{"f_4568posixunix.scm",(void*)f_4568},
{"f_4529posixunix.scm",(void*)f_4529},
{"f_4514posixunix.scm",(void*)f_4514},
{"f_4528posixunix.scm",(void*)f_4528},
{"f_4474posixunix.scm",(void*)f_4474},
{"f_4481posixunix.scm",(void*)f_4481},
{"f_4484posixunix.scm",(void*)f_4484},
{"f_4429posixunix.scm",(void*)f_4429},
{"f_4433posixunix.scm",(void*)f_4433},
{"f_4468posixunix.scm",(void*)f_4468},
{"f_4451posixunix.scm",(void*)f_4451},
{"f_4415posixunix.scm",(void*)f_4415},
{"f_4427posixunix.scm",(void*)f_4427},
{"f_4401posixunix.scm",(void*)f_4401},
{"f_4413posixunix.scm",(void*)f_4413},
{"f_4386posixunix.scm",(void*)f_4386},
{"f_4399posixunix.scm",(void*)f_4399},
{"f_4349posixunix.scm",(void*)f_4349},
{"f_4357posixunix.scm",(void*)f_4357},
{"f_4324posixunix.scm",(void*)f_4324},
{"f_4305posixunix.scm",(void*)f_4305},
{"f_4309posixunix.scm",(void*)f_4309},
{"f_4274posixunix.scm",(void*)f_4274},
{"f_4298posixunix.scm",(void*)f_4298},
{"f_4282posixunix.scm",(void*)f_4282},
{"f_4285posixunix.scm",(void*)f_4285},
{"f_4236posixunix.scm",(void*)f_4236},
{"f_4269posixunix.scm",(void*)f_4269},
{"f_4257posixunix.scm",(void*)f_4257},
{"f_4265posixunix.scm",(void*)f_4265},
{"f_4261posixunix.scm",(void*)f_4261},
{"f_4211posixunix.scm",(void*)f_4211},
{"f_4227posixunix.scm",(void*)f_4227},
{"f_4196posixunix.scm",(void*)f_4196},
{"f_4206posixunix.scm",(void*)f_4206},
{"f_4200posixunix.scm",(void*)f_4200},
{"f_4190posixunix.scm",(void*)f_4190},
{"f_4184posixunix.scm",(void*)f_4184},
{"f_4178posixunix.scm",(void*)f_4178},
{"f_4154posixunix.scm",(void*)f_4154},
{"f_4176posixunix.scm",(void*)f_4176},
{"f_4172posixunix.scm",(void*)f_4172},
{"f_4164posixunix.scm",(void*)f_4164},
{"f_4124posixunix.scm",(void*)f_4124},
{"f_4152posixunix.scm",(void*)f_4152},
{"f_4148posixunix.scm",(void*)f_4148},
{"f_4097posixunix.scm",(void*)f_4097},
{"f_4122posixunix.scm",(void*)f_4122},
{"f_4118posixunix.scm",(void*)f_4118},
{"f_4033posixunix.scm",(void*)f_4033},
{"f_4021posixunix.scm",(void*)f_4021},
{"f_4049posixunix.scm",(void*)f_4049},
{"f_3959posixunix.scm",(void*)f_3959},
{"f_3963posixunix.scm",(void*)f_3963},
{"f_3968posixunix.scm",(void*)f_3968},
{"f_3984posixunix.scm",(void*)f_3984},
{"f_3896posixunix.scm",(void*)f_3896},
{"f_3954posixunix.scm",(void*)f_3954},
{"f_3900posixunix.scm",(void*)f_3900},
{"f_3903posixunix.scm",(void*)f_3903},
{"f_3935posixunix.scm",(void*)f_3935},
{"f_3906posixunix.scm",(void*)f_3906},
{"f_3911posixunix.scm",(void*)f_3911},
{"f_3925posixunix.scm",(void*)f_3925},
{"f_3889posixunix.scm",(void*)f_3889},
{"f_3803posixunix.scm",(void*)f_3803},
{"f_3807posixunix.scm",(void*)f_3807},
{"f_3861posixunix.scm",(void*)f_3861},
{"f_3810posixunix.scm",(void*)f_3810},
{"f_3820posixunix.scm",(void*)f_3820},
{"f_3824posixunix.scm",(void*)f_3824},
{"f_3833posixunix.scm",(void*)f_3833},
{"f_3837posixunix.scm",(void*)f_3837},
{"f_3847posixunix.scm",(void*)f_3847},
{"f_3828posixunix.scm",(void*)f_3828},
{"f_3778posixunix.scm",(void*)f_3778},
{"f_3790posixunix.scm",(void*)f_3790},
{"f_3786posixunix.scm",(void*)f_3786},
{"f_3764posixunix.scm",(void*)f_3764},
{"f_3776posixunix.scm",(void*)f_3776},
{"f_3772posixunix.scm",(void*)f_3772},
{"f_3697posixunix.scm",(void*)f_3697},
{"f_3701posixunix.scm",(void*)f_3701},
{"f_3743posixunix.scm",(void*)f_3743},
{"f_3704posixunix.scm",(void*)f_3704},
{"f_3714posixunix.scm",(void*)f_3714},
{"f_3718posixunix.scm",(void*)f_3718},
{"f_3722posixunix.scm",(void*)f_3722},
{"f_3726posixunix.scm",(void*)f_3726},
{"f_3730posixunix.scm",(void*)f_3730},
{"f_3674posixunix.scm",(void*)f_3674},
{"f_3684posixunix.scm",(void*)f_3684},
{"f_3651posixunix.scm",(void*)f_3651},
{"f_3661posixunix.scm",(void*)f_3661},
{"f_3613posixunix.scm",(void*)f_3613},
{"f_3646posixunix.scm",(void*)f_3646},
{"f_3617posixunix.scm",(void*)f_3617},
{"f_3624posixunix.scm",(void*)f_3624},
{"f_3628posixunix.scm",(void*)f_3628},
{"f_3632posixunix.scm",(void*)f_3632},
{"f_3636posixunix.scm",(void*)f_3636},
{"f_3640posixunix.scm",(void*)f_3640},
{"f_3595posixunix.scm",(void*)f_3595},
{"f_3580posixunix.scm",(void*)f_3580},
{"f_3574posixunix.scm",(void*)f_3574},
{"f_3542posixunix.scm",(void*)f_3542},
{"f_3548posixunix.scm",(void*)f_3548},
{"f_3518posixunix.scm",(void*)f_3518},
{"f_3536posixunix.scm",(void*)f_3536},
{"f_3525posixunix.scm",(void*)f_3525},
{"f_3500posixunix.scm",(void*)f_3500},
{"f_3510posixunix.scm",(void*)f_3510},
{"f_3487posixunix.scm",(void*)f_3487},
{"f_3478posixunix.scm",(void*)f_3478},
{"f_3431posixunix.scm",(void*)f_3431},
{"f_3435posixunix.scm",(void*)f_3435},
{"f_3411posixunix.scm",(void*)f_3411},
{"f_3415posixunix.scm",(void*)f_3415},
{"f_3421posixunix.scm",(void*)f_3421},
{"f_3425posixunix.scm",(void*)f_3425},
{"f_3391posixunix.scm",(void*)f_3391},
{"f_3395posixunix.scm",(void*)f_3395},
{"f_3401posixunix.scm",(void*)f_3401},
{"f_3405posixunix.scm",(void*)f_3405},
{"f_3367posixunix.scm",(void*)f_3367},
{"f_3371posixunix.scm",(void*)f_3371},
{"f_3382posixunix.scm",(void*)f_3382},
{"f_3386posixunix.scm",(void*)f_3386},
{"f_3376posixunix.scm",(void*)f_3376},
{"f_3343posixunix.scm",(void*)f_3343},
{"f_3347posixunix.scm",(void*)f_3347},
{"f_3358posixunix.scm",(void*)f_3358},
{"f_3362posixunix.scm",(void*)f_3362},
{"f_3352posixunix.scm",(void*)f_3352},
{"f_3327posixunix.scm",(void*)f_3327},
{"f_3331posixunix.scm",(void*)f_3331},
{"f_3334posixunix.scm",(void*)f_3334},
{"f_3291posixunix.scm",(void*)f_3291},
{"f_3322posixunix.scm",(void*)f_3322},
{"f_3312posixunix.scm",(void*)f_3312},
{"f_3305posixunix.scm",(void*)f_3305},
{"f_3255posixunix.scm",(void*)f_3255},
{"f_3286posixunix.scm",(void*)f_3286},
{"f_3276posixunix.scm",(void*)f_3276},
{"f_3269posixunix.scm",(void*)f_3269},
{"f_3240posixunix.scm",(void*)f_3240},
{"f_3253posixunix.scm",(void*)f_3253},
{"f_3234posixunix.scm",(void*)f_3234},
{"f_3222posixunix.scm",(void*)f_3222},
{"f_2905posixunix.scm",(void*)f_2905},
{"f_3212posixunix.scm",(void*)f_3212},
{"f_3032posixunix.scm",(void*)f_3032},
{"f_3198posixunix.scm",(void*)f_3198},
{"f_3187posixunix.scm",(void*)f_3187},
{"f_3194posixunix.scm",(void*)f_3194},
{"f_3051posixunix.scm",(void*)f_3051},
{"f_3180posixunix.scm",(void*)f_3180},
{"f_3159posixunix.scm",(void*)f_3159},
{"f_3176posixunix.scm",(void*)f_3176},
{"f_3165posixunix.scm",(void*)f_3165},
{"f_3172posixunix.scm",(void*)f_3172},
{"f_3095posixunix.scm",(void*)f_3095},
{"f_3156posixunix.scm",(void*)f_3156},
{"f_3135posixunix.scm",(void*)f_3135},
{"f_3152posixunix.scm",(void*)f_3152},
{"f_3141posixunix.scm",(void*)f_3141},
{"f_3148posixunix.scm",(void*)f_3148},
{"f_3108posixunix.scm",(void*)f_3108},
{"f_3132posixunix.scm",(void*)f_3132},
{"f_3128posixunix.scm",(void*)f_3128},
{"f_3089posixunix.scm",(void*)f_3089},
{"f_3058posixunix.scm",(void*)f_3058},
{"f_3076posixunix.scm",(void*)f_3076},
{"f_3061posixunix.scm",(void*)f_3061},
{"f_3065posixunix.scm",(void*)f_3065},
{"f_3045posixunix.scm",(void*)f_3045},
{"f_3026posixunix.scm",(void*)f_3026},
{"f_2912posixunix.scm",(void*)f_2912},
{"f_2919posixunix.scm",(void*)f_2919},
{"f_2921posixunix.scm",(void*)f_2921},
{"f_2928posixunix.scm",(void*)f_2928},
{"f_2992posixunix.scm",(void*)f_2992},
{"f_3001posixunix.scm",(void*)f_3001},
{"f_2989posixunix.scm",(void*)f_2989},
{"f_2934posixunix.scm",(void*)f_2934},
{"f_2970posixunix.scm",(void*)f_2970},
{"f_2966posixunix.scm",(void*)f_2966},
{"f_2962posixunix.scm",(void*)f_2962},
{"f_2951posixunix.scm",(void*)f_2951},
{"f_2947posixunix.scm",(void*)f_2947},
{"f_2849posixunix.scm",(void*)f_2849},
{"f_2858posixunix.scm",(void*)f_2858},
{"f_2882posixunix.scm",(void*)f_2882},
{"f_2894posixunix.scm",(void*)f_2894},
{"f_2900posixunix.scm",(void*)f_2900},
{"f_2888posixunix.scm",(void*)f_2888},
{"f_2864posixunix.scm",(void*)f_2864},
{"f_2870posixunix.scm",(void*)f_2870},
{"f_2856posixunix.scm",(void*)f_2856},
{"f_2838posixunix.scm",(void*)f_2838},
{"f_2833posixunix.scm",(void*)f_2833},
{"f_2785posixunix.scm",(void*)f_2785},
{"f_2789posixunix.scm",(void*)f_2789},
{"f_2798posixunix.scm",(void*)f_2798},
{"f_2762posixunix.scm",(void*)f_2762},
{"f_2783posixunix.scm",(void*)f_2783},
{"f_2769posixunix.scm",(void*)f_2769},
{"f_2605posixunix.scm",(void*)f_2605},
{"f_2710posixunix.scm",(void*)f_2710},
{"f_2718posixunix.scm",(void*)f_2718},
{"f_2705posixunix.scm",(void*)f_2705},
{"f_2607posixunix.scm",(void*)f_2607},
{"f_2614posixunix.scm",(void*)f_2614},
{"f_2617posixunix.scm",(void*)f_2617},
{"f_2620posixunix.scm",(void*)f_2620},
{"f_2704posixunix.scm",(void*)f_2704},
{"f_2624posixunix.scm",(void*)f_2624},
{"f_2638posixunix.scm",(void*)f_2638},
{"f_2648posixunix.scm",(void*)f_2648},
{"f_2651posixunix.scm",(void*)f_2651},
{"f_2654posixunix.scm",(void*)f_2654},
{"f_2660posixunix.scm",(void*)f_2660},
{"f_2670posixunix.scm",(void*)f_2670},
{"f_2581posixunix.scm",(void*)f_2581},
{"f_2603posixunix.scm",(void*)f_2603},
{"f_2599posixunix.scm",(void*)f_2599},
{"f_2557posixunix.scm",(void*)f_2557},
{"f_2579posixunix.scm",(void*)f_2579},
{"f_2575posixunix.scm",(void*)f_2575},
{"f_2449posixunix.scm",(void*)f_2449},
{"f_2453posixunix.scm",(void*)f_2453},
{"f_2522posixunix.scm",(void*)f_2522},
{"f_2536posixunix.scm",(void*)f_2536},
{"f_2462posixunix.scm",(void*)f_2462},
{"f_2519posixunix.scm",(void*)f_2519},
{"f_2467posixunix.scm",(void*)f_2467},
{"f_2472posixunix.scm",(void*)f_2472},
{"f_2495posixunix.scm",(void*)f_2495},
{"f_2515posixunix.scm",(void*)f_2515},
{"f_2478posixunix.scm",(void*)f_2478},
{"f_2492posixunix.scm",(void*)f_2492},
{"f_2381posixunix.scm",(void*)f_2381},
{"f_2394posixunix.scm",(void*)f_2394},
{"f_2406posixunix.scm",(void*)f_2406},
{"f_2400posixunix.scm",(void*)f_2400},
{"f_2372posixunix.scm",(void*)f_2372},
{"f_2379posixunix.scm",(void*)f_2379},
{"f_2363posixunix.scm",(void*)f_2363},
{"f_2370posixunix.scm",(void*)f_2370},
{"f_2354posixunix.scm",(void*)f_2354},
{"f_2361posixunix.scm",(void*)f_2361},
{"f_2345posixunix.scm",(void*)f_2345},
{"f_2352posixunix.scm",(void*)f_2352},
{"f_2336posixunix.scm",(void*)f_2336},
{"f_2343posixunix.scm",(void*)f_2343},
{"f_2327posixunix.scm",(void*)f_2327},
{"f_2334posixunix.scm",(void*)f_2334},
{"f_2318posixunix.scm",(void*)f_2318},
{"f_2325posixunix.scm",(void*)f_2325},
{"f_2309posixunix.scm",(void*)f_2309},
{"f_2316posixunix.scm",(void*)f_2316},
{"f_2300posixunix.scm",(void*)f_2300},
{"f_2307posixunix.scm",(void*)f_2307},
{"f_2294posixunix.scm",(void*)f_2294},
{"f_2298posixunix.scm",(void*)f_2298},
{"f_2288posixunix.scm",(void*)f_2288},
{"f_2292posixunix.scm",(void*)f_2292},
{"f_2282posixunix.scm",(void*)f_2282},
{"f_2286posixunix.scm",(void*)f_2286},
{"f_2276posixunix.scm",(void*)f_2276},
{"f_2280posixunix.scm",(void*)f_2280},
{"f_2270posixunix.scm",(void*)f_2270},
{"f_2274posixunix.scm",(void*)f_2274},
{"f_2264posixunix.scm",(void*)f_2264},
{"f_2268posixunix.scm",(void*)f_2268},
{"f_2232posixunix.scm",(void*)f_2232},
{"f_2243posixunix.scm",(void*)f_2243},
{"f_2236posixunix.scm",(void*)f_2236},
{"f_2195posixunix.scm",(void*)f_2195},
{"f_2227posixunix.scm",(void*)f_2227},
{"f_2220posixunix.scm",(void*)f_2220},
{"f_2199posixunix.scm",(void*)f_2199},
{"f_2003posixunix.scm",(void*)f_2003},
{"f_2176posixunix.scm",(void*)f_2176},
{"f_2019posixunix.scm",(void*)f_2019},
{"f_2150posixunix.scm",(void*)f_2150},
{"f_2025posixunix.scm",(void*)f_2025},
{"f_2028posixunix.scm",(void*)f_2028},
{"f_2110posixunix.scm",(void*)f_2110},
{"f_2108posixunix.scm",(void*)f_2108},
{"f_2067posixunix.scm",(void*)f_2067},
{"f_2085posixunix.scm",(void*)f_2085},
{"f_2083posixunix.scm",(void*)f_2083},
{"f_2071posixunix.scm",(void*)f_2071},
{"f_1993posixunix.scm",(void*)f_1993},
{"f_1983posixunix.scm",(void*)f_1983},
{"f_1977posixunix.scm",(void*)f_1977},
{"f_1945posixunix.scm",(void*)f_1945},
{"f_1952posixunix.scm",(void*)f_1952},
{"f_1958posixunix.scm",(void*)f_1958},
{"f_1965posixunix.scm",(void*)f_1965},
{"f_1906posixunix.scm",(void*)f_1906},
{"f_1913posixunix.scm",(void*)f_1913},
{"f_1922posixunix.scm",(void*)f_1922},
{"f_1864posixunix.scm",(void*)f_1864},
{"f_1874posixunix.scm",(void*)f_1874},
{"f_1877posixunix.scm",(void*)f_1877},
{"f_1880posixunix.scm",(void*)f_1880},
{"f_1849posixunix.scm",(void*)f_1849},
{"f_1811posixunix.scm",(void*)f_1811},
{"f_1841posixunix.scm",(void*)f_1841},
{"f_1828posixunix.scm",(void*)f_1828},
{"f_1831posixunix.scm",(void*)f_1831},
{"f_1765posixunix.scm",(void*)f_1765},
{"f_1769posixunix.scm",(void*)f_1769},
{"f_1708posixunix.scm",(void*)f_1708},
{"f_1701posixunix.scm",(void*)f_1701},
{"f_1683posixunix.scm",(void*)f_1683},
{"f_1687posixunix.scm",(void*)f_1687},
{"f_1698posixunix.scm",(void*)f_1698},
{"f_1694posixunix.scm",(void*)f_1694},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
