# rules.make - basic build rules -*- Makefile -*-
#
# Copyright (c) 2000-2007, Felix L. Winkelmann
# Copyright (c) 2008, The Chicken Team
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
# conditions are met:
#
#   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
#     disclaimer. 
#   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
#     disclaimer in the documentation and/or other materials provided with the distribution. 
#   Neither the name of the author nor the names of its contributors may be used to endorse or promote
#     products derived from this software without specific prior written permission. 
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

VPATH=$(SRCDIR):$(SRCDIR)/pcre

# object files

LIBCHICKEN_OBJECTS_1 = \
       library eval data-structures ports files extras lolevel utils tcp srfi-1 srfi-4 srfi-13 \
       srfi-14 srfi-18 srfi-69 $(POSIXFILE) regex scheduler \
       profiler stub match runtime
LIBCHICKEN_SHARED_OBJECTS = $(LIBCHICKEN_OBJECTS_1:=$(O))
LIBCHICKEN_STATIC_OBJECTS = $(LIBCHICKEN_OBJECTS_1:=-static$(O))

LIBUCHICKEN_OBJECTS_1 = \
       ulibrary ueval udata-structures uports ufiles uextras ulolevel uutils utcp usrfi-1 usrfi-4 \
       usrfi-13 usrfi-14 usrfi-18 usrfi-69 u$(POSIXFILE) uregex scheduler \
       profiler stub match uruntime
LIBUCHICKEN_SHARED_OBJECTS = $(LIBUCHICKEN_OBJECTS_1:=$(O))
LIBUCHICKEN_STATIC_OBJECTS = $(LIBUCHICKEN_OBJECTS_1:=-static$(O))

LIBCHICKENGUI_OBJECTS_1 = \
       library eval data-structures ports files extras lolevel utils tcp srfi-1 srfi-4 srfi-13 \
       srfi-14 srfi-18 srfi-69 $(POSIXFILE) regex scheduler \
       profiler stub match gui-runtime
LIBCHICKENGUI_SHARED_OBJECTS = $(LIBCHICKENGUI_OBJECTS_1:=$(O))
LIBCHICKENGUI_STATIC_OBJECTS = $(LIBCHICKENGUI_OBJECTS_1:=-static$(O))

ifeq ($(USE_HOST_PCRE),)
PCRE_OBJECTS_1 ?= \
       $(PCRE_DIR)pcre_compile \
       $(PCRE_DIR)pcre_config \
       $(PCRE_DIR)pcre_dfa_exec \
       $(PCRE_DIR)pcre_exec \
       $(PCRE_DIR)pcre_fullinfo \
       $(PCRE_DIR)pcre_get \
       $(PCRE_DIR)pcre_globals \
       $(PCRE_DIR)pcre_info \
       $(PCRE_DIR)pcre_maketables \
       $(PCRE_DIR)pcre_newline \
       $(PCRE_DIR)pcre_ord2utf8 \
       $(PCRE_DIR)pcre_refcount \
       $(PCRE_DIR)pcre_study \
       $(PCRE_DIR)pcre_tables \
       $(PCRE_DIR)pcre_try_flipped \
       $(PCRE_DIR)pcre_ucp_searchfuncs \
       $(PCRE_DIR)pcre_valid_utf8 \
       $(PCRE_DIR)pcre_version \
       $(PCRE_DIR)pcre_xclass \
       $(PCRE_DIR)pcre_chartables
PCRE_SHARED_OBJECTS = $(PCRE_OBJECTS_1:=$(O))
PCRE_STATIC_OBJECTS = $(PCRE_OBJECTS_1:=-static$(O))
endif

COMPILER_OBJECTS_1 = \
       chicken batch-driver compiler optimizer support \
       c-platform c-backend
COMPILER_OBJECTS        = $(COMPILER_OBJECTS_1:=$(O))
COMPILER_STATIC_OBJECTS = $(COMPILER_OBJECTS_1:=-static$(O))

# library objects

runtime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
gui-runtime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_GUI_RUNTIME_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
eval$(O): eval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
data-structures$(O): data-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ports$(O): ports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
files$(O): files.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
extras$(O): extras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
library$(O): library.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
lolevel$(O): lolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
match$(O): match.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixunix$(O): posixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixwin$(O): posixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
profiler$(O): profiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
regex$(O): regex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(PCRE_INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_PCRE_OPTIONS) $< $(C_COMPILER_OUTPUT)
scheduler$(O): scheduler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-1$(O): srfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-13$(O): srfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-14$(O): srfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-18$(O): srfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-69$(O): srfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-4$(O): srfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
stub$(O): stub.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
tcp$(O): tcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utils$(O): utils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

uruntime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ueval$(O): ueval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
udata-structures$(O): udata-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uports$(O): uports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ufiles$(O): ufiles.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uextras$(O): uextras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulibrary$(O): ulibrary.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulolevel$(O): ulolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixunix$(O): uposixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixwin$(O): uposixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uregex$(O): uregex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(PCRE_INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $(C_COMPILER_PCRE_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-1$(O): usrfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(PCRE_INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-13$(O): usrfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-14$(O): usrfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-18$(O): usrfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-69$(O): usrfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-4$(O): usrfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utcp$(O): utcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uutils$(O): uutils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

runtime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
gui-runtime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_GUI_RUNTIME_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
eval-static$(O): eval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
data-structures-static$(O): data-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ports-static$(O): ports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
files-static$(O): files.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
extras-static$(O): extras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
library-static$(O): library.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
lolevel-static$(O): lolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
match-static$(O): match.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixunix-static$(O): posixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixwin-static$(O): posixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
profiler-static$(O): profiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
regex-static$(O): regex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(PCRE_INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_PCRE_OPTIONS) $< $(C_COMPILER_OUTPUT)
scheduler-static$(O): scheduler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-1-static$(O): srfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-13-static$(O): srfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-14-static$(O): srfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-18-static$(O): srfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-69-static$(O): srfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-4-static$(O): srfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
stub-static$(O): stub.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
tcp-static$(O): tcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utils-static$(O): utils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

uruntime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ueval-static$(O): ueval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
udata-structures-static$(O): udata-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uports-static$(O): uports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ufiles-static$(O): ufiles.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uextras-static$(O): uextras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulibrary-static$(O): ulibrary.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulolevel-static$(O): ulolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixunix-static$(O): uposixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixwin-static$(O): uposixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uregex-static$(O): uregex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(PCRE_INCLUDES) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $(C_COMPILER_PCRE_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-1-static$(O): usrfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-13-static$(O): usrfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-14-static$(O): usrfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-18-static$(O): usrfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-69-static$(O): usrfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-4-static$(O): usrfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utcp-static$(O): utcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uutils-static$(O): uutils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

# compiler objects

batch-driver$(O): batch-driver.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
c-backend$(O): c-backend.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
c-platform$(O): c-platform.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
optimizer$(O): optimizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
chicken$(O): chicken.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
compiler$(O): compiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
support$(O): support.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)

# static compiler objects

batch-driver-static$(O): batch-driver.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
c-backend-static$(O): c-backend.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
c-platform-static$(O): c-platform.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-static$(O): chicken.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
compiler-static$(O): compiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
support-static$(O): support.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
optimizer-static$(O): optimizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# pcre objects

$(PCRE_DIR)pcre_compile$(O): pcre_compile.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_config$(O): pcre_config.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_dfa_exec$(O): pcre_dfa_exec.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_exec$(O): pcre_exec.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_fullinfo$(O): pcre_fullinfo.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_get$(O): pcre_get.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_globals$(O): pcre_globals.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_info$(O): pcre_info.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_maketables$(O): pcre_maketables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_newline$(O): pcre_newline.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_ord2utf8$(O): pcre_ord2utf8.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_refcount$(O): pcre_refcount.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_study$(O): pcre_study.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_tables$(O): pcre_tables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_try_flipped$(O): pcre_try_flipped.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_ucp_searchfuncs$(O): pcre_ucp_searchfuncs.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h ucptable.h ucpinternal.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_valid_utf8$(O): pcre_valid_utf8.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_version$(O): pcre_version.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_xclass$(O): pcre_xclass.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_chartables$(O): pcre_chartables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)

# static pcre objects

$(PCRE_DIR)pcre_compile-static$(O): pcre_compile.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_config-static$(O): pcre_config.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_dfa_exec-static$(O): pcre_dfa_exec.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_exec-static$(O): pcre_exec.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_fullinfo-static$(O): pcre_fullinfo.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_get-static$(O): pcre_get.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_globals-static$(O): pcre_globals.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_info-static$(O): pcre_info.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_maketables-static$(O): pcre_maketables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_newline-static$(O): pcre_newline.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_ord2utf8-static$(O): pcre_ord2utf8.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_refcount-static$(O): pcre_refcount.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_study-static$(O): pcre_study.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_tables-static$(O): pcre_tables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_try_flipped-static$(O): pcre_try_flipped.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_ucp_searchfuncs-static$(O): pcre_ucp_searchfuncs.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h ucptable.h ucpinternal.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_valid_utf8-static$(O): pcre_valid_utf8.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_version-static$(O): pcre_version.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_xclass-static$(O): pcre_xclass.c pcre_internal.h config.h $(CHICKEN_CONFIG_H) pcre.h ucp.h
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)
$(PCRE_DIR)pcre_chartables-static$(O): pcre_chartables.c pcre_internal.h config.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(PCRE_INCLUDES) $(C_COMPILER_COMPILE_OPTION) \
	  $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< $(C_COMPILER_OUTPUT) \
	  $(C_COMPILER_PCRE_OPTIONS)

# assembler objects

ifneq ($(HACKED_APPLY),)
$(APPLY_HACK_OBJECT): $(SRCDIR)apply-hack.$(ARCH).s
	$(ASSEMBLER) $(ASSEMBLER_OPTIONS) $(ASSEMBLER_COMPILE_OPTION) $< $(ASSEMBLER_OUTPUT)
endif

# program objects

chicken-profile$(O): chicken-profile.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-setup$(O): chicken-setup.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
csc$(O): csc.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
csi$(O): csi.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# static program objects

csi-static$(O): csi.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-bug$(O): chicken-bug.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# libchicken

.PHONY: libs

libs: $(TARGETLIBS)

libchicken$(SO)$(SONAME_VERSION): $(LIBCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_LINKER_OPTIONS) \
	  $(LINKER_OUTPUT) $^ $(LIBCHICKEN_SO_LIBRARIES)
ifdef SONAME_VERSION
	ln -sf $(LIBCHICKEN_SO_FILE) libchicken$(SO)
endif


libuchicken$(SO)$(SONAME_VERSION): $(LIBUCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_LINKER_OPTIONS) \
	  $(LINKER_OUTPUT) $^ $(LIBUCHICKEN_SO_LIBRARIES)
ifdef SONAME_VERSION
	ln -sf $(LIBUCHICKEN_SO_FILE) libuchicken$(SO)
endif

cygchicken-0.dll: $(LIBCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	gcc -shared -o $(LIBCHICKEN_SO_FILE) -Wl,--dll -Wl,--add-stdcall-alias \
	    -Wl,--enable-stdcall-fixup -Wl,--warn-unresolved-symbols \
	    -Wl,--dll-search-prefix=cyg -Wl,--allow-multiple-definition \
	    -Wl,--allow-shlib-undefined -Wl,--export-dynamic \
	    -Wl,--out-implib=libchicken.dll.a -Wl,--export-all-symbols \
	    -Wl,--enable-auto-import \
	    -Wl,--whole-archive $(LIBCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT) \
	    -Wl,--no-whole-archive $(LIBCHICKEN_SO_LIBRARIES)

cyguchicken-0.dll: $(LIBUCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	gcc -shared -o $(LIBUCHICKEN_SO_FILE) -Wl,--dll -Wl,--add-stdcall-alias \
	    -Wl,--enable-stdcall-fixup -Wl,--warn-unresolved-symbols \
	    -Wl,--dll-search-prefix=cyg -Wl,--allow-multiple-definition \
	    -Wl,--allow-shlib-undefined -Wl,--export-dynamic \
	    -Wl,--out-implib=libuchicken.dll.a -Wl,--export-all-symbols \
	    -Wl,--enable-auto-import \
	    -Wl,--whole-archive $(LIBUCHICKEN_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) $(APPLY_HACK_OBJECT) \
	    -Wl,--no-whole-archive $(LIBUCHICKEN_SO_LIBRARIES)


libchickengui$(SO): $(APPLY_HACK_OBJECT) $(LIBCHICKENGUI_SHARED_OBJECTS) $(PCRE_SHARED_OBJECTS) 
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBCHICKENGUI_SO_LINKER_OPTIONS) \
	$(LINKER_OUTPUT) $^ $(LIBCHICKENGUI_SO_LIBRARIES)

libchicken$(A): $(APPLY_HACK_OBJECT) $(LIBCHICKEN_STATIC_OBJECTS) $(PCRE_STATIC_OBJECTS) 
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

libuchicken$(A): $(APPLY_HACK_OBJECT) $(LIBUCHICKEN_STATIC_OBJECTS) $(PCRE_STATIC_OBJECTS) 
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

libchickengui$(A): $(APPLY_HACK_OBJECT) $(LIBCHICKENGUI_STATIC_OBJECTS) $(PCRE_STATIC_OBJECTS) 
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

# executables

$(CHICKEN_SHARED_EXECUTABLE): $(COMPILER_OBJECTS) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $(COMPILER_OBJECTS) $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CSI_SHARED_EXECUTABLE): csi$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CHICKEN_SETUP_PROGRAM)$(EXE): chicken-setup$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CHICKEN_PROFILE_PROGRAM)$(EXE): chicken-profile$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CSC_PROGRAM)$(EXE): csc$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

# static executables

$(CHICKEN_STATIC_EXECUTABLE): $(COMPILER_STATIC_OBJECTS) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $(COMPILER_STATIC_OBJECTS) \
	  $(LINKER_OUTPUT) libchicken$(A) $(LIBRARIES)
$(CSI_STATIC_EXECUTABLE): csi$(O) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $< $(LINKER_OUTPUT) \
	  libchicken$(A) $(LIBRARIES)
$(CHICKEN_BUG_PROGRAM)$(EXE): chicken-bug$(O) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $< $(LINKER_OUTPUT) \
          libchicken$(A) $(LIBRARIES)

# info documentation

chicken.info: chicken.texi
	$(MAKEINFO_PROGRAM) $(MAKEINFO_PROGRAM_OPTIONS) $<

# installation

.PHONY: install uninstall install-libs install-manifests

install-libs:
ifneq ($(DESTDIR),)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)
endif
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ILIBDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ICHICKENLIBDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IEGGDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libchicken$(A) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libuchicken$(A) $(DESTDIR)$(ILIBDIR)
ifneq ($(LIBCHICKEN_IMPORT_LIBRARY),) 
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBCHICKEN_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBUCHICKEN_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
ifdef WINDOWS
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libchickengui$(A) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBCHICKENGUI_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
endif
endif
ifneq ($(POSTINSTALL_STATIC_LIBRARY),true)
ifdef WINDOWS
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)\\libchicken$(A)
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)\\libuchicken$(A)
else
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)/libchicken$(A)
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)/libuchicken$(A)
endif
endif
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken.h $(DESTDIR)$(IINCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(CHICKEN_CONFIG_H) $(DESTDIR)$(IINCDIR)
ifndef STATICBUILD
ifdef DLLSINPATH
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_FILE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_FILE) $(DESTDIR)$(IBINDIR)
else
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_FILE) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_FILE) $(DESTDIR)$(ILIBDIR)
endif
ifdef SONAME_VERSION
	cd $(DESTDIR)$(ILIBDIR)  && ln -sf $(LIBCHICKEN_SO_FILE) libchicken$(SO)
	cd $(DESTDIR)$(ILIBDIR)  && ln -sf $(LIBUCHICKEN_SO_FILE) libuchicken$(SO)
endif
ifdef WINDOWS
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) libchickengui$(SO) \
	  $(DESTDIR)$(IBINDIR)
endif
endif

install-manifests:
ifneq ($(CHICKEN_MANIFEST),)
# ignore missing manifests since they don't exist for MSVC versions < 8.0
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CHICKEN_MANIFEST) $(DESTDIR)$(IBINDIR)
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CSI_MANIFEST) $(DESTDIR)$(IBINDIR)
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CHICKEN_PROFILE_MANIFEST) $(DESTDIR)$(IBINDIR)
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CSC_MANIFEST) $(DESTDIR)$(IBINDIR)
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CHICKEN_BUG_MANIFEST) $(DESTDIR)$(IBINDIR)
ifndef STATICBUILD
	-$(INSTALL_PROGRAM) $(INSTALL_MANIFEST_OPTIONS) $(CHICKEN_SETUP_MANIFEST) $(DESTDIR)$(IBINDIR)
endif
endif

ifeq ($(NEEDS_RELINKING),yes)
install:
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(CHICKEN_PROGRAM)$(EXE) \
	  $(CSI_PROGRAM)$(EXE) $(CSC_PROGRAM)$(EXE) $(CHICKEN_PROFILE_PROGRAM)$(EXE) \
	  $(CHICKEN_SETUP_PROGRAM)$(EXE)
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) NEEDS_RELINKING=no RUNTIME_LINKER_PATH=$(LIBDIR) install
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_PROGRAM)$(EXE) $(CSI_PROGRAM)$(EXE) \
	  $(CSC_PROGRAM)$(EXE) $(CHICKEN_PROFILE_PROGRAM)$(EXE)
ifndef STATICBUILD
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_SETUP_PROGRAM)$(EXE)
endif
else
install: $(TARGETS) install-libs install-manifests
ifneq ($(DESTDIR),)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR) 
endif
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ITOPMANDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IMANDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IINFODIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IDOCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CSI_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_PROFILE_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CSC_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_BUG_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
ifneq ($(POSTINSTALL_PROGRAM),true)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CSI_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROFILE_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CSC_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_BUG_PROGRAM)
endif
ifndef STATICBUILD
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_SETUP_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)
ifneq ($(POSTINSTALL_PROGRAM),true)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_SETUP_PROGRAM)
endif
endif
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)csi.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)csc.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-setup.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-profile.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-bug.1 $(DESTDIR)$(IMANDIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IDOCDIR)/html
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)html/* $(DESTDIR)$(IDOCDIR)/html
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken.pdf $(DESTDIR)$(IDOCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)README $(DESTDIR)$(IDOCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)LICENSE $(DESTDIR)$(IDOCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-more-macros.scm $(DESTDIR)$(IDATADIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-ffi-macros.scm $(DESTDIR)$(IDATADIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-sys-macros.scm $(DESTDIR)$(IDATADIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) *.exports $(DESTDIR)$(IDATADIR)
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) chicken.info $(DESTDIR)$(IINFODIR)
	$(INSTALLINFO_PROGRAM) $(INSTALLINFO_PROGRAM_OPTIONS) --infodir=$(DESTDIR)$(IINFODIR) chicken.info
ifdef WINDOWS
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(SRCDIR)csibatch.bat $(DESTDIR)$(IBINDIR)
endif
endif

uninstall:
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CSI_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROFILE_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_SETUP_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)/$(CSC_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_BUG_PROGRAM)$(EXE)
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(ILIBDIR)/libchicken*.* $(DESTDIR)$(ILIBDIR)/libuchicken*.* $(DESTDIR)$(IBINDIR)/libchicken*.* $(DESTDIR)$(IBINDIR)/libuchicken*.*
ifdef ($(PLATFORM),cygwin)
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/cygchicken* $(DESTDIR)$(IBINDIR)/cyguchicken*
endif
ifneq ($(CHICKEN_MANIFEST),)
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_MANIFEST) \
	$(DESTDIR)$(IBINDIR)/$(CSI_MANIFEST) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROFILE_MANIFEST) \
	$(DESTDIR)$(IBINDIR)/$(CSC_MANIFEST) $(DESTDIR)$(IBINDIR)/$(CHICKEN_BUG_MANIFEST) \
	$(DESTDIR)$(IBINDIR)/$(CHICKEN_SETUP_MANIFEST)
endif
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IMANDIR)/chicken.1 $(DESTDIR)$(IMANDIR)/csi.1 \
	  $(DESTDIR)$(IMANDIR)/csc.1 $(DESTDIR)$(IMANDIR)/chicken-profile.1 $(DESTDIR)$(IMANDIR)/chicken-setup.1 \
	  $(DESTDIR)$(IMANDIR)/chicken-bug.1
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)/chicken.h $(DESTDIR)$(IINCDIR)/chicken-config.h
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)/chicken.gch 
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_RECURSIVE_OPTIONS) $(DESTDIR)$(IDATADIR)
	$(UNINSTALLINFO_PROGRAM) $(UNINSTALLINFO_PROGRAM_OPTIONS) --infodir=$(DESTDIR)$(IINFODIR) chicken.info
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IINFODIR)/chicken.info
ifdef WINDOWS
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/csibatch.bat
endif

# bootstrapping c sources

.SUFFIXES: .scm

library.c: $(SRCDIR)library.scm $(SRCDIR)version.scm $(SRCDIR)banner.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
eval.c: $(SRCDIR)eval.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
data-structures.c: $(SRCDIR)data-structures.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend private-namespace.scm
ports.c: $(SRCDIR)ports.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend private-namespace.scm
files.c: $(SRCDIR)files.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend private-namespace.scm
extras.c: $(SRCDIR)extras.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend private-namespace.scm
lolevel.c: $(SRCDIR)lolevel.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
tcp.c: $(SRCDIR)tcp.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-1.c: $(SRCDIR)srfi-1.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-4.c: $(SRCDIR)srfi-4.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-13.c: $(SRCDIR)srfi-13.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-14.c: $(SRCDIR)srfi-14.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-18.c: $(SRCDIR)srfi-18.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-69.c: $(SRCDIR)srfi-69.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend private-namespace.scm
utils.c: $(SRCDIR)utils.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
posixunix.c: $(SRCDIR)posixunix.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
posixwin.c: $(SRCDIR)posixwin.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
regex.c: $(SRCDIR)regex.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_PCRE_LIBRARY_OPTIONS) -output-file $@ 
scheduler.c: $(SRCDIR)scheduler.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
profiler.c: $(SRCDIR)profiler.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
stub.c: $(SRCDIR)stub.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
match.c: $(SRCDIR)match.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 

ulibrary.c: $(SRCDIR)library.scm $(SRCDIR)version.scm $(SRCDIR)banner.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
ueval.c: $(SRCDIR)eval.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
udata-structures.c: $(SRCDIR)data-structures.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend private-namespace.scm
uports.c: $(SRCDIR)ports.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend private-namespace.scm
ufiles.c: $(SRCDIR)files.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend private-namespace.scm
uextras.c: $(SRCDIR)extras.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend private-namespace.scm
ulolevel.c: $(SRCDIR)lolevel.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
utcp.c: $(SRCDIR)tcp.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-1.c: $(SRCDIR)srfi-1.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-4.c: $(SRCDIR)srfi-4.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-13.c: $(SRCDIR)srfi-13.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-14.c: $(SRCDIR)srfi-14.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-18.c: $(SRCDIR)srfi-18.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-69.c: $(SRCDIR)srfi-69.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend private-namespace.scm 
uutils.c: $(SRCDIR)utils.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uposixunix.c: $(SRCDIR)posixunix.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uposixwin.c: $(SRCDIR)posixwin.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uregex.c: $(SRCDIR)regex.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_PCRE_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 

chicken.c: $(SRCDIR)chicken.scm $(SRCDIR)chicken-more-macros.scm $(SRCDIR)chicken-ffi-macros.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
support.c: $(SRCDIR)support.scm $(SRCDIR)banner.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
compiler.c: $(SRCDIR)compiler.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
optimizer.c: $(SRCDIR)optimizer.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
batch-driver.c: $(SRCDIR)batch-driver.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
c-platform.c: $(SRCDIR)c-platform.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
c-backend.c: $(SRCDIR)c-backend.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 

csi.c: $(SRCDIR)csi.scm $(SRCDIR)banner.scm $(SRCDIR)chicken-more-macros.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ -extend private-namespace.scm
chicken-profile.c: $(SRCDIR)chicken-profile.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 
chicken-setup.c: $(SRCDIR)chicken-setup.scm $(SRCDIR)chicken-more-macros.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 
csc.c: $(SRCDIR)csc.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 
chicken-bug.c: $(SRCDIR)chicken-bug.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 

# distribution files

.PHONY: distfiles

distfiles: buildsvnrevision library.c eval.c data-structures.c ports.c files.c extras.c lolevel.c utils.c \
	tcp.c srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c \
	posixunix.c posixwin.c regex.c scheduler.c profiler.c stub.c match.c \
	ulibrary.c ueval.c udata-structures.c uports.c ufiles.c uextras.c ulolevel.c \
	uutils.c utcp.c usrfi-1.c usrfi-4.c usrfi-13.c usrfi-14.c \
	usrfi-18.c usrfi-69.c uposixunix.c uposixwin.c uregex.c \
	chicken-profile.c chicken-setup.c csc.c csi.c \
	chicken.c batch-driver.c compiler.c optimizer.c support.c \
	c-platform.c c-backend.c chicken-bug.c

# cleaning up

.PHONY: clean distclean spotless confclean

ifeq ($(PLATFORM),mingw)
CLEAN_PCRE = $(PCRE_DIR)*$(O)
CLEAN_MINGW_LIBS = libchickengui.a libchickengui.dll libchickengui.dll.a
else
CLEAN_PCRE = $(PCRE_DIR)*$(O)
CLEAN_MINGW_LIBS =
endif

clean:
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) chicken$(EXE) csi$(EXE) csc$(EXE) \
	  chicken-setup$(EXE) chicken-profile$(EXE) csi-static$(EXE) \
	  csc-static$(EXE) chicken-static$(EXE) chicken-bug$(EXE) chicken.info *$(O) \
	  $(LIBCHICKEN_SO_FILE) $(LIBUCHICKEN_SO_FILE) $(LIBCHICKENGUI_SO_FILE) \
	  libchicken$(A) libuchicken$(A) libchickengui$(A) libchicken$(SO) libuchicken$(SO) \
          $(PROGRAM_IMPORT_LIBRARIES) $(LIBCHICKEN_IMPORT_LIBRARY) $(LIBUCHICKEN_IMPORT_LIBRARY) \
          $(LIBCHICKENGUI_IMPORT_LIBRARY)  $(MSVC_CHICKEN_EXPORT_FILES) \
          chicken.info $(CLEAN_PCRE) $(CLEAN_MINGW_LIBS) $(CLEAN_MANIFESTS)
confclean:
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) chicken-config.h chicken-defaults.h buildsvnrevision

spotless: distclean
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) library.c eval.c data-structures.c ports.c files.c \
	  extras.c lolevel.c utils.c tcp.c srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c \
	  posixunix.c posixwin.c regex.c scheduler.c profiler.c stub.c match.c \
	  ulibrary.c ueval.c udata-structures.c uports.c ufiles.c uextras.c ulolevel.c \
	  uutils.c utcp.c usrfi-1.c usrfi-4.c usrfi-13.c usrfi-14.c \
	  usrfi-18.c usrfi-69.c uposixunix.c uposixwin.c uregex.c chicken-profile.c chicken-setup.c chicken-bug.c \
	  csc.c csi.c \
	  chicken.c batch-driver.c compiler.c optimizer.c support.c \
	  c-platform.c c-backend.c *.exports

distclean: clean confclean

# run tests

.PHONY: check fullcheck compiler-check

check: all
	cd tests; sh runtests.sh

# Only for UNIX, yet:

fullcheck: check compiler-check

compiler-check:
	@echo "======================================== packing ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) dist
	$(REMOVE_COMMAND $(REMOVE_COMMAND_RECURSIVE_OPTIONS) tests/chicken-*
	tar -C tests -xzf `ls -t chicken-*.tar.gz | head -1`
	@echo "======================================== building stage 1 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all
	touch tests/chicken-*/*.scm
	@echo "======================================== building stage 2 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all
	cat tests/chicken-*/*.c >tests/stage2.out
	@echo "======================================== building stage 3 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all	
	cat tests/chicken-*/*.c >tests/stage3.out
	diff tests/stage2.out tests/stage3.out >tests/stages.diff
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_RECURSIVE_OPTIONS) tests/chicken-*


# bootstrap from C source tarball

.PHONY: bootstrap bootstrap.tar.gz

bootstrap: $(SRCDIR)bootstrap.tar.gz
	gzip -d -c $(SRCDIR)bootstrap.tar.gz | tar xvf -
	touch *.c
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 chicken$(EXE)
	cp chicken$(EXE) chicken-boot$(EXE)
	touch *.scm

$(SRCDIR)bootstrap.tar.gz: distfiles
	tar cfz $(SRCDIR)bootstrap.tar.gz library.c eval.c data-structures.c ports.c files.c extras.c \
        lolevel.c utils.c tcp.c srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c \
        posixunix.c posixwin.c regex.c scheduler.c profiler.c stub.c match.c $(COMPILER_OBJECTS_1:=.c)

