# rules.make - basic build rules -*- Makefile -*-
#
# Copyright (c) 2000-2007, Felix L. Winkelmann
# Copyright (c) 2008-2009, The Chicken Team
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
# conditions are met:
#
#   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
#     disclaimer. 
#   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
#     disclaimer in the documentation and/or other materials provided with the distribution. 
#   Neither the name of the author nor the names of its contributors may be used to endorse or promote
#     products derived from this software without specific prior written permission. 
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

VPATH=$(SRCDIR)

# object files

LIBCHICKEN_OBJECTS_1 = \
       library eval data-structures ports files extras lolevel utils tcp srfi-1 srfi-4 srfi-13 \
       srfi-14 srfi-18 srfi-69 $(POSIXFILE) regex scheduler \
       profiler stub expand chicken-syntax runtime
LIBCHICKEN_SHARED_OBJECTS = $(LIBCHICKEN_OBJECTS_1:=$(O))
LIBCHICKEN_STATIC_OBJECTS = $(LIBCHICKEN_OBJECTS_1:=-static$(O))

LIBUCHICKEN_OBJECTS_1 = \
       ulibrary ueval udata-structures uports ufiles uextras ulolevel uutils utcp usrfi-1 usrfi-4 \
       usrfi-13 usrfi-14 usrfi-18 usrfi-69 u$(POSIXFILE) uregex scheduler \
       profiler stub expand chicken-syntax uruntime
LIBUCHICKEN_SHARED_OBJECTS = $(LIBUCHICKEN_OBJECTS_1:=$(O))
LIBUCHICKEN_STATIC_OBJECTS = $(LIBUCHICKEN_OBJECTS_1:=-static$(O))

LIBCHICKENGUI_OBJECTS_1 = \
       library eval data-structures ports files extras lolevel utils tcp srfi-1 srfi-4 srfi-13 \
       srfi-14 srfi-18 srfi-69 $(POSIXFILE) regex scheduler \
       profiler stub expand chicken-syntax gui-runtime
LIBCHICKENGUI_SHARED_OBJECTS = $(LIBCHICKENGUI_OBJECTS_1:=$(O))
LIBCHICKENGUI_STATIC_OBJECTS = $(LIBCHICKENGUI_OBJECTS_1:=-static$(O))

COMPILER_OBJECTS_1 = \
       chicken batch-driver compiler optimizer scrutinizer support \
       c-platform c-backend
COMPILER_OBJECTS        = $(COMPILER_OBJECTS_1:=$(O))
COMPILER_STATIC_OBJECTS = $(COMPILER_OBJECTS_1:=-static$(O))


# library objects

runtime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
gui-runtime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_GUI_RUNTIME_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
eval$(O): eval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
expand$(O): expand.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-syntax$(O): chicken-syntax.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
data-structures$(O): data-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ports$(O): ports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
files$(O): files.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
extras$(O): extras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
library$(O): library.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
lolevel$(O): lolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixunix$(O): posixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixwin$(O): posixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
profiler$(O): profiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
regex$(O): regex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
scheduler$(O): scheduler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-1$(O): srfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-13$(O): srfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-14$(O): srfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-18$(O): srfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-69$(O): srfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-4$(O): srfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
stub$(O): stub.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
tcp$(O): tcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utils$(O): utils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

uruntime$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ueval$(O): ueval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
udata-structures$(O): udata-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uports$(O): uports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ufiles$(O): ufiles.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uextras$(O): uextras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulibrary$(O): ulibrary.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulolevel$(O): ulolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixunix$(O): uposixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixwin$(O): uposixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uregex$(O): uregex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-1$(O): usrfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-13$(O): usrfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-14$(O): usrfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-18$(O): usrfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-69$(O): usrfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-4$(O): usrfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utcp$(O): utcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uutils$(O): uutils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

runtime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
gui-runtime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $(C_COMPILER_GUI_RUNTIME_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
eval-static$(O): eval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
expand-static$(O): expand.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-syntax-static$(O): chicken-syntax.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
data-structures-static$(O): data-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ports-static$(O): ports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
files-static$(O): files.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
extras-static$(O): extras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
library-static$(O): library.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
lolevel-static$(O): lolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixunix-static$(O): posixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
posixwin-static$(O): posixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
profiler-static$(O): profiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
regex-static$(O): regex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
scheduler-static$(O): scheduler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-1-static$(O): srfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-13-static$(O): srfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-14-static$(O): srfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-18-static$(O): srfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-69-static$(O): srfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
srfi-4-static$(O): srfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
stub-static$(O): stub.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
tcp-static$(O): tcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utils-static$(O): utils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

uruntime-static$(O): runtime.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ueval-static$(O): ueval.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
udata-structures-static$(O): udata-structures.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uports-static$(O): uports.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ufiles-static$(O): ufiles.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uextras-static$(O): uextras.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulibrary-static$(O): ulibrary.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
ulolevel-static$(O): ulolevel.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixunix-static$(O): uposixunix.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uposixwin-static$(O): uposixwin.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uregex-static$(O): uregex.c chicken.h $(CHICKEN_CONFIG_H) 
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-1-static$(O): usrfi-1.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-13-static$(O): usrfi-13.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-14-static$(O): usrfi-14.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-18-static$(O): usrfi-18.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-69-static$(O): usrfi-69.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
usrfi-4-static$(O): usrfi-4.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
utcp-static$(O): utcp.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)
uutils-static$(O): uutils.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_BUILD_UNSAFE_RUNTIME_OPTIONS) $< $(C_COMPILER_OUTPUT)

# import library objects

scheme.import$(O): scheme.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(HOST_INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
csi.import$(O): csi.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
chicken.import$(O): chicken.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
lolevel.import$(O): lolevel.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-1.import$(O): srfi-1.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-4.import$(O): srfi-4.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
data-structures.import$(O): data-structures.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
ports.import$(O): ports.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
files.import$(O): files.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
posix.import$(O): posix.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-13.import$(O): srfi-13.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-69.import$(O): srfi-69.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
extras.import$(O): extras.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
regex.import$(O): regex.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
irregex.import$(O): irregex.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-14.import$(O): srfi-14.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
tcp.import$(O): tcp.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
foreign.import$(O): foreign.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
srfi-18.import$(O): srfi-18.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
utils.import$(O): utils.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
setup-api.import$(O): setup-api.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
setup-download.import$(O): setup-download.import.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)

# setup extension objects
setup-api$(O): setup-api.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)
setup-download$(O): setup-download.c chicken.h $(CHICKEN_CONFIG_H)
	$(HOST_C_COMPILER) $(HOST_C_COMPILER_OPTIONS) $(HOST_C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) -DC_SHARED \
	  $(HOST_C_COMPILER_COMPILE_OPTION) $(HOST_C_COMPILER_OPTIMIZATION_OPTIONS) $(HOST_C_COMPILER_SHARED_OPTIONS) \
	  $(HOST_C_COMPILER_BUILD_RUNTIME_OPTIONS) $< $(HOST_C_COMPILER_OUTPUT)

# compiler objects

batch-driver$(O): batch-driver.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
c-backend$(O): c-backend.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
c-platform$(O): c-platform.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
optimizer$(O): optimizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
scrutinizer$(O): scrutinizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
chicken$(O): chicken.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
compiler$(O): compiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)
support$(O): support.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $(C_COMPILER_SHARED_OPTIONS) $< \
	  $(C_COMPILER_OUTPUT)

# static compiler objects

batch-driver-static$(O): batch-driver.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
c-backend-static$(O): c-backend.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
c-platform-static$(O): c-platform.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-static$(O): chicken.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
compiler-static$(O): compiler.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
support-static$(O): support.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
optimizer-static$(O): optimizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
scrutinizer-static$(O): scrutinizer.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# assembler objects

ifneq ($(HACKED_APPLY),)
$(APPLY_HACK_OBJECT): $(SRCDIR)apply-hack.$(ARCH).s
	$(ASSEMBLER) $(ASSEMBLER_OPTIONS) $(ASSEMBLER_COMPILE_OPTION) $< $(ASSEMBLER_OUTPUT)
endif

# program objects

chicken-profile$(O): chicken-profile.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-install$(O): chicken-install.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-uninstall$(O): chicken-uninstall.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-status$(O): chicken-status.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-setup$(O): chicken-setup.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
csc$(O): csc.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
csi$(O): csi.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) $(C_COMPILER_SHARED_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# static program objects

csi-static$(O): csi.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)
chicken-bug$(O): chicken-bug.c chicken.h $(CHICKEN_CONFIG_H)
	$(C_COMPILER) $(C_COMPILER_OPTIONS) $(C_COMPILER_PTABLES_OPTIONS) $(INCLUDES) \
	  $(C_COMPILER_STATIC_OPTIONS) \
	  $(C_COMPILER_COMPILE_OPTION) $(C_COMPILER_OPTIMIZATION_OPTIONS) $< $(C_COMPILER_OUTPUT)

# libraries

.PHONY: libs

libs: $(TARGETLIBS)

libchicken$(SO): $(LIBCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_LINKER_OPTIONS) \
	  $(LINKER_OUTPUT) $^ $(LIBCHICKEN_SO_LIBRARIES)


libuchicken$(SO): $(LIBUCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_LINKER_OPTIONS) \
	  $(LINKER_OUTPUT) $^ $(LIBUCHICKEN_SO_LIBRARIES)

cygchicken-0.dll: $(LIBCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	gcc -shared -o $(LIBCHICKEN_SO_FILE) -Wl,--dll -Wl,--add-stdcall-alias \
	    -Wl,--enable-stdcall-fixup -Wl,--warn-unresolved-symbols \
	    -Wl,--dll-search-prefix=cyg -Wl,--allow-multiple-definition \
	    -Wl,--allow-shlib-undefined -Wl,--export-dynamic \
	    -Wl,--out-implib=libchicken.dll.a -Wl,--export-all-symbols \
	    -Wl,--enable-auto-import \
	    -Wl,--whole-archive $(LIBCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT) \
	    -Wl,--no-whole-archive $(LIBCHICKEN_SO_LIBRARIES)

cyguchicken-0.dll: $(LIBUCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT)
	gcc -shared -o $(LIBUCHICKEN_SO_FILE) -Wl,--dll -Wl,--add-stdcall-alias \
	    -Wl,--enable-stdcall-fixup -Wl,--warn-unresolved-symbols \
	    -Wl,--dll-search-prefix=cyg -Wl,--allow-multiple-definition \
	    -Wl,--allow-shlib-undefined -Wl,--export-dynamic \
	    -Wl,--out-implib=libuchicken.dll.a -Wl,--export-all-symbols \
	    -Wl,--enable-auto-import \
	    -Wl,--whole-archive $(LIBUCHICKEN_SHARED_OBJECTS) $(APPLY_HACK_OBJECT) \
	    -Wl,--no-whole-archive $(LIBUCHICKEN_SO_LIBRARIES)


libchickengui$(SO): $(APPLY_HACK_OBJECT) $(LIBCHICKENGUI_SHARED_OBJECTS)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_LINK_SHARED_LIBRARY_OPTIONS) $(LIBCHICKENGUI_SO_LINKER_OPTIONS) \
	$(LINKER_OUTPUT) $^ $(LIBCHICKENGUI_SO_LIBRARIES)

libchicken$(A): $(APPLY_HACK_OBJECT) $(LIBCHICKEN_STATIC_OBJECTS)
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

libuchicken$(A): $(APPLY_HACK_OBJECT) $(LIBUCHICKEN_STATIC_OBJECTS)
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

libchickengui$(A): $(APPLY_HACK_OBJECT) $(LIBCHICKENGUI_STATIC_OBJECTS)
	$(LIBRARIAN) $(LIBRARIAN_OPTIONS) $(LIBRARIAN_OUTPUT) $^

# import libraries and extensions

.SUFFIXES: .so

%.so: %.o
	$(HOST_LINKER) $(HOST_LINKER_OPTIONS) $(HOST_LINKER_LINK_SHARED_DLOADABLE_OPTIONS) $^ $(HOST_LINKER_OUTPUT_OPTION) $@ \
	  $(HOST_LINKER_LIBRARY_PREFIX)chicken$(HOST_LINKER_LIBRARY_SUFFIX) \
	  $(HOST_LIBRARIES)

# executables

$(CHICKEN_SHARED_EXECUTABLE): $(COMPILER_OBJECTS) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $(COMPILER_OBJECTS) $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CSI_SHARED_EXECUTABLE): csi$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CHICKEN_INSTALL_PROGRAM)$(EXE): chicken-install$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)
$(CHICKEN_UNINSTALL_PROGRAM)$(EXE): chicken-uninstall$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)
$(CHICKEN_STATUS_PROGRAM)$(EXE): chicken-status$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)
$(CHICKEN_SETUP_PROGRAM)$(EXE): chicken-setup$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CHICKEN_PROFILE_PROGRAM)$(EXE): chicken-profile$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

$(CSC_PROGRAM)$(EXE): csc$(O) $(PRIMARY_LIBCHICKEN)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_EXECUTABLE_OPTIONS) $< $(LINKER_OUTPUT) \
          $(LINKER_LIBRARY_PREFIX)chicken$(LINKER_LIBRARY_SUFFIX) $(LINKER_LINK_SHARED_PROGRAM_OPTIONS) $(LIBRARIES)

# static executables

$(CHICKEN_STATIC_EXECUTABLE): $(COMPILER_STATIC_OBJECTS) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $(COMPILER_STATIC_OBJECTS) \
	  $(LINKER_OUTPUT) libchicken$(A) $(LIBRARIES)
$(CSI_STATIC_EXECUTABLE): csi$(O) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $< $(LINKER_OUTPUT) \
	  libchicken$(A) $(LIBRARIES)
$(CHICKEN_BUG_PROGRAM)$(EXE): chicken-bug$(O) libchicken$(A)
	$(LINKER) $(LINKER_OPTIONS) $(LINKER_STATIC_OPTIONS) $< $(LINKER_OUTPUT) \
          libchicken$(A) $(LIBRARIES)

# installation

.PHONY: install uninstall install-libs install-import-libs install-setup-files \
	install-dirs

install-libs:
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libchicken$(A) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libuchicken$(A) $(DESTDIR)$(ILIBDIR)
ifneq ($(LIBCHICKEN_IMPORT_LIBRARY),) 
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBCHICKEN_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBUCHICKEN_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
ifdef WINDOWS
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) libchickengui$(A) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_STATIC_LIBRARY_OPTIONS) $(LIBCHICKENGUI_IMPORT_LIBRARY) $(DESTDIR)$(ILIBDIR)
endif
endif
ifneq ($(POSTINSTALL_STATIC_LIBRARY),true)
ifdef WINDOWS
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)\\libchicken$(A)
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)\\libuchicken$(A)
else
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)/libchicken$(A)
	$(POSTINSTALL_STATIC_LIBRARY) $(POSTINSTALL_STATIC_LIBRARY_FLAGS) \
	  $(ILIBDIR)/libuchicken$(A)
endif
endif
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken.h $(DESTDIR)$(IINCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(CHICKEN_CONFIG_H) $(DESTDIR)$(IINCDIR)
ifndef STATICBUILD
ifdef DLLSINPATH
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_FILE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_FILE) $(DESTDIR)$(IBINDIR)
else
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBCHICKEN_SO_FILE) $(DESTDIR)$(ILIBDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) $(LIBUCHICKEN_SO_FILE) $(DESTDIR)$(ILIBDIR)
endif
ifdef WINDOWS
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_SHARED_LIBRARY_OPTIONS) libchickengui$(SO) $(DESTDIR)$(IBINDIR)
endif
endif

install-dirs:
ifneq ($(DESTDIR),)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)
endif
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ILIBDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ICHICKENLIBDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IEGGDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IDATADIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IMANDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(ITOPMANDIR) 
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IDOCDIR)

ifeq ($(NEEDS_RELINKING),yes)
install:
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(CHICKEN_PROGRAM)$(EXE) \
	  $(CSI_PROGRAM)$(EXE) $(CSC_PROGRAM)$(EXE) $(CHICKEN_PROFILE_PROGRAM)$(EXE) \
	  $(CHICKEN_INSTALL_PROGRAM)$(EXE) $(CHICKEN_UNINSTALL_PROGRAM)$(EXE) \
	  $(CHICKEN_STATUS_PROGRAM)$(EXE) $(CHICKEN_SETUP_PROGRAM)$(EXE) \
	  $(IMPORT_LIBRARIES:%=%.so) $(IMPORT_LIBRARIES:%=%.import.so)
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) NEEDS_RELINKING=no RUNTIME_LINKER_PATH=$(LIBDIR) install
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_PROGRAM)$(EXE) $(CSI_PROGRAM)$(EXE) \
	  $(CSC_PROGRAM)$(EXE) $(CHICKEN_PROFILE_PROGRAM)$(EXE)
ifndef STATICBUILD
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_INSTALL_PROGRAM)$(EXE)
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_UNINSTALL_PROGRAM)$(EXE)
	$(MAKE_WRITABLE_COMMAND) $(CHICKEN_STATUS_PROGRAM)$(EXE)
endif
else
install: $(TARGETS) install-dirs install-libs install-import-libs \
         install-setup-files
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CSI_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_PROFILE_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CSC_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_BUG_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
ifneq ($(POSTINSTALL_PROGRAM),true)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CSI_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROFILE_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CSC_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_BUG_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/setup-api.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/setup-download.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/setup-api.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/setup-download.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/chicken.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/lolevel.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-1.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-4.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/data-structures.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/ports.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/files.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/posix.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-13.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-69.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/extras.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/regex.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/irregex.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-14.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/tcp.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/foreign.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/scheme.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/csi.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/srfi-18.import.so
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IEGGDIR)/utils.import.so
endif
ifndef STATICBUILD
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_INSTALL_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_UNINSTALL_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_STATUS_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(CHICKEN_SETUP_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)
ifneq ($(POSTINSTALL_PROGRAM),true)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_INSTALL_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_UNINSTALL_PROGRAM)
	$(POSTINSTALL_PROGRAM) $(POSTINSTALL_PROGRAM_FLAGS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_STATUS_PROGRAM)
endif
# this might be left over from older version and will break `chicken-install -update-db'
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IEGGDIR)/compiler.import.so
ifneq ($(CROSS_CHICKEN),1)
ifeq ($(DESTDIR),)
	-$(DESTDIR)$(IBINDIR)$(SEP)$(CHICKEN_INSTALL_PROGRAM) -update-db
else
	@echo
	@echo "Warning: cannot run chicken-install -update-db when DESTDIR is set"
	@echo
endif
endif
endif
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)csi.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)csc.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-install.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-uninstall.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-status.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-profile.1 $(DESTDIR)$(IMANDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)chicken-bug.1 $(DESTDIR)$(IMANDIR)
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(DESTDIR)$(IDOCDIR)$(SEP)html
	-$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)html$(SEP)* $(DESTDIR)$(IDOCDIR)$(SEP)html
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)README $(DESTDIR)$(IDOCDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)LICENSE $(DESTDIR)$(IDOCDIR)
ifdef WINDOWS_SHELL
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) $(SRCDIR)csibatch.bat $(DESTDIR)$(IBINDIR)
endif
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)types.db $(DESTDIR)$(IEGGDIR)
endif

ifdef STATICBUILD
# copy/xcopy is too dumb on Windows
install-import-libs:
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) scheme.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) chicken.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) lolevel.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-1.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-4.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) data-structures.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) ports.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) files.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) posix.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-13.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-69.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) extras.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) regex.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-14.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) tcp.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) foreign.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) srfi-18.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) utils.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) csi.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) irregex.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) setup-api.import.scm $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) setup-download.import.scm $(DESTDIR)$(IEGGDIR)
else
install-import-libs:
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) scheme.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) chicken.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) lolevel.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-1.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-4.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) data-structures.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) ports.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) files.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) posix.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-13.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-69.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) extras.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) regex.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-14.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) tcp.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) foreign.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) srfi-18.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) utils.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) csi.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) irregex.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) setup-api.import.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) setup-download.import.so $(DESTDIR)$(IEGGDIR)
endif

install-setup-files:
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_FILE_OPTIONS) $(SRCDIR)setup.defaults $(DESTDIR)$(IDATADIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) setup-api.so $(DESTDIR)$(IEGGDIR)
	$(INSTALL_PROGRAM) $(INSTALL_PROGRAM_EXECUTABLE_OPTIONS) setup-download.so $(DESTDIR)$(IEGGDIR)

uninstall:
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CSI_PROGRAM)$(EXE) $(DESTDIR)$(IBINDIR)/$(CHICKEN_PROFILE_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_INSTALL_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_UNINSTALL_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_STATUS_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CSC_PROGRAM)$(EXE) \
	  $(DESTDIR)$(IBINDIR)/$(CHICKEN_BUG_PROGRAM)$(EXE)
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(ILIBDIR)/libchicken*.* $(DESTDIR)$(ILIBDIR)/libuchicken*.* $(DESTDIR)$(IBINDIR)/libchicken*.* $(DESTDIR)$(IBINDIR)/libuchicken*.*
ifdef ($(PLATFORM),cygwin)
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)/cygchicken* $(DESTDIR)$(IBINDIR)/cyguchicken*
endif
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IMANDIR)/chicken.1 $(DESTDIR)$(IMANDIR)/csi.1 \
	  $(DESTDIR)$(IMANDIR)/csc.1 $(DESTDIR)$(IMANDIR)/chicken-profile.1 $(DESTDIR)$(IMANDIR)/chicken-install.1 \
	  $(DESTDIR)$(IMANDIR)/chicken-bug.1 $(DESTDIR)$(IMANDIR)/chicken-uninstall.1 \
	  $(DESTDIR)$(IMANDIR)/chicken-status.1
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)/chicken.h $(DESTDIR)$(IINCDIR)/chicken-config.h
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IINCDIR)/chicken.gch 
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_RECURSIVE_OPTIONS) $(DESTDIR)$(IDATADIR)
ifdef WINDOWS_SHELL
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(DESTDIR)$(IBINDIR)$(SEP)csibatch.bat
endif

# bootstrapping c sources

.SUFFIXES: .scm
.SECONDARY: setup-api.import.scm setup-download.import.scm

setup-api.import.scm: setup-api.c
setup-download.import.scm: setup-download.c

library.c: $(SRCDIR)library.scm $(SRCDIR)version.scm $(SRCDIR)banner.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
eval.c: $(SRCDIR)eval.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
expand.c: $(SRCDIR)expand.scm $(SRCDIR)synrules.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@
chicken-syntax.c: $(SRCDIR)chicken-syntax.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@
data-structures.c: $(SRCDIR)data-structures.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
ports.c: $(SRCDIR)ports.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
files.c: $(SRCDIR)files.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
extras.c: $(SRCDIR)extras.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
lolevel.c: $(SRCDIR)lolevel.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
tcp.c: $(SRCDIR)tcp.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-1.c: $(SRCDIR)srfi-1.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-4.c: $(SRCDIR)srfi-4.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-13.c: $(SRCDIR)srfi-13.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-14.c: $(SRCDIR)srfi-14.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-18.c: $(SRCDIR)srfi-18.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
srfi-69.c: $(SRCDIR)srfi-69.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
utils.c: $(SRCDIR)utils.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
posixunix.c: $(SRCDIR)posixunix.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
posixwin.c: $(SRCDIR)posixwin.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
regex.c: $(SRCDIR)regex.scm $(SRCDIR)irregex.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
scheduler.c: $(SRCDIR)scheduler.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
profiler.c: $(SRCDIR)profiler.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 
stub.c: $(SRCDIR)stub.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) -output-file $@ 

ulibrary.c: $(SRCDIR)library.scm $(SRCDIR)version.scm $(SRCDIR)banner.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
ueval.c: $(SRCDIR)eval.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
udata-structures.c: $(SRCDIR)data-structures.scm $(SRCDIR)private-namespace.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
uports.c: $(SRCDIR)ports.scm $(SRCDIR)private-namespace.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@
ufiles.c: $(SRCDIR)files.scm $(SRCDIR)private-namespace.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@
uextras.c: $(SRCDIR)extras.scm $(SRCDIR)private-namespace.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
ulolevel.c: $(SRCDIR)lolevel.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
utcp.c: $(SRCDIR)tcp.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-1.c: $(SRCDIR)srfi-1.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-4.c: $(SRCDIR)srfi-4.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-13.c: $(SRCDIR)srfi-13.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-14.c: $(SRCDIR)srfi-14.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-18.c: $(SRCDIR)srfi-18.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
usrfi-69.c: $(SRCDIR)srfi-69.scm $(SRCDIR)private-namespace.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm 
uutils.c: $(SRCDIR)utils.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uposixunix.c: $(SRCDIR)posixunix.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uposixwin.c: $(SRCDIR)posixwin.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 
uregex.c: $(SRCDIR)regex.scm $(SRCDIR)irregex.scm $(SRCDIR)unsafe-declarations.scm
	$(CHICKEN) $< $(CHICKEN_LIBRARY_OPTIONS) $(CHICKEN_UNSAFE_OPTIONS) -output-file $@ 

chicken.import.c: $(SRCDIR)chicken.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
lolevel.import.c: $(SRCDIR)lolevel.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-1.import.c: $(SRCDIR)srfi-1.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-4.import.c: $(SRCDIR)srfi-4.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
data-structures.import.c: $(SRCDIR)data-structures.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
ports.import.c: $(SRCDIR)ports.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
files.import.c: $(SRCDIR)files.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
posix.import.c: $(SRCDIR)posix.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-13.import.c: $(SRCDIR)srfi-13.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-69.import.c: $(SRCDIR)srfi-69.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
extras.import.c: $(SRCDIR)extras.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
regex.import.c: $(SRCDIR)regex.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
irregex.import.c: $(SRCDIR)irregex.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-14.import.c: $(SRCDIR)srfi-14.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
tcp.import.c: $(SRCDIR)tcp.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
foreign.import.c: $(SRCDIR)foreign.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
scheme.import.c: $(SRCDIR)scheme.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
csi.import.c: $(SRCDIR)csi.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
srfi-18.import.c: $(SRCDIR)srfi-18.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
utils.import.c: $(SRCDIR)utils.import.scm
	$(CHICKEN) $< $(CHICKEN_IMPORT_LIBRARY_OPTIONS) -output-file $@ 
setup-api.import.c: $(SRCDIR)setup-api.scm
	$(CHICKEN) $(SRCDIR)setup-api.import.scm $(CHICKEN_IMPORT_LIBRARY_OPTIONS) \
	  -ignore-repository -output-file $@ 
setup-download.import.c: $(SRCDIR)setup-download.scm
	$(CHICKEN) $(SRCDIR)setup-download.import.scm $(CHICKEN_IMPORT_LIBRARY_OPTIONS) \
	  -ignore-repository -output-file $@ 

chicken.c: $(SRCDIR)chicken.scm $(SRCDIR)chicken-ffi-syntax.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
support.c: $(SRCDIR)support.scm $(SRCDIR)banner.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
compiler.c: $(SRCDIR)compiler.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
optimizer.c: $(SRCDIR)optimizer.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
scrutinizer.c: $(SRCDIR)scrutinizer.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
batch-driver.c: $(SRCDIR)batch-driver.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
c-platform.c: $(SRCDIR)c-platform.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 
c-backend.c: $(SRCDIR)c-backend.scm $(SRCDIR)compiler-namespace.scm \
	  $(SRCDIR)private-namespace.scm $(SRCDIR)tweaks.scm
	$(CHICKEN) $< $(CHICKEN_COMPILER_OPTIONS) -output-file $@ 

csi.c: $(SRCDIR)csi.scm $(SRCDIR)banner.scm $(SRCDIR)private-namespace.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ -extend $(SRCDIR)private-namespace.scm
chicken-profile.c: $(SRCDIR)chicken-profile.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 
chicken-install.c: $(SRCDIR)chicken-install.scm setup-download.c
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -ignore-repository -output-file $@ 
chicken-uninstall.c: $(SRCDIR)chicken-uninstall.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -ignore-repository -output-file $@ 
chicken-status.c: $(SRCDIR)chicken-status.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -ignore-repository -output-file $@ 
chicken-setup.c: $(SRCDIR)chicken-setup.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -ignore-repository -output-file $@ 
csc.c: $(SRCDIR)csc.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 
chicken-bug.c: $(SRCDIR)chicken-bug.scm
	$(CHICKEN) $< $(CHICKEN_PROGRAM_OPTIONS) -output-file $@ 

setup-api.c: $(SRCDIR)setup-api.scm
	$(CHICKEN) $< $(CHICKEN_DYNAMIC_OPTIONS) -emit-import-library setup-api \
	  -ignore-repository -output-file $@ 
setup-download.c: $(SRCDIR)setup-download.scm setup-api.c
	$(CHICKEN) $< $(CHICKEN_DYNAMIC_OPTIONS) -emit-import-library setup-download \
	  -ignore-repository -output-file $@ 

# distribution files

.PHONY: distfiles dist html

distfiles: buildsvnrevision library.c eval.c expand.c chicken-syntax.c \
	data-structures.c ports.c files.c extras.c lolevel.c utils.c \
	tcp.c srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c \
	posixunix.c posixwin.c regex.c scheduler.c profiler.c stub.c \
	ulibrary.c ueval.c udata-structures.c uports.c ufiles.c uextras.c ulolevel.c \
	uutils.c utcp.c usrfi-1.c usrfi-4.c usrfi-13.c usrfi-14.c \
	usrfi-18.c usrfi-69.c uposixunix.c uposixwin.c uregex.c \
	chicken-profile.c chicken-install.c chicken-uninstall.c chicken-status.c chicken-setup.c \
	csc.c csi.c chicken.c batch-driver.c compiler.c optimizer.c scrutinizer.c support.c \
	c-platform.c c-backend.c chicken-bug.c $(IMPORT_LIBRARIES:=.import.c)

dist: distfiles
	CSI=$(CSI) $(CSI) -s $(SRCDIR)scripts/makedist.scm --platform=$(PLATFORM) CHICKEN=$(CHICKEN)

html:
	$(MAKEDIR_COMMAND) $(MAKEDIR_COMMAND_OPTIONS) $(SRCDIR)html
	$(COPY_COMMAND) $(SRCDIR)misc/manual.css $(SRCDIR)html
	$(CSI) -s $(SRCDIR)scripts/wiki2html.scm --outdir=html manual/*

# cleaning up

.PHONY: clean distclean spotless confclean testclean

ifeq ($(PLATFORM),mingw)
CLEAN_MINGW_LIBS = libchickengui.a libchickengui.dll libchickengui.dll.a
else
CLEAN_MINGW_LIBS =
endif

clean:
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) chicken$(EXE) csi$(EXE) csc$(EXE) \
	  chicken-profile$(EXE) csi-static$(EXE) \
	  chicken-install$(EXE) chicken-uninstall$(EXE) chicken-status$(EXE) chicken-setup$(EXE) \
	  csc-static$(EXE) chicken-static$(EXE) chicken-bug$(EXE) *$(O) \
	  $(LIBCHICKEN_SO_FILE) $(LIBUCHICKEN_SO_FILE) $(LIBCHICKENGUI_SO_FILE) \
	  libchicken$(A) libuchicken$(A) libchickengui$(A) libchicken$(SO) $(PROGRAM_IMPORT_LIBRARIES) \
	  $(IMPORT_LIBRARIES:=.import.so) $(LIBCHICKEN_IMPORT_LIBRARY) $(LIBUCHICKEN_IMPORT_LIBRARY) \
	  $(LIBCHICKENGUI_IMPORT_LIBRARY) setup-api.so setup-download.so setup-api.c setup-download.c \
	  $(CLEAN_MINGW_LIBS)

confclean:
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) chicken-config.h chicken-defaults.h buildsvnrevision

spotless: distclean testclean
	-$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) library.c eval.c data-structures.c \
	  ports.c files.c extras.c lolevel.c utils.c chicken-syntax.c \
	  tcp.c srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c expand.c \
	  posixunix.c posixwin.c regex.c scheduler.c profiler.c stub.c \
	  ulibrary.c ueval.c udata-structures.c uports.c ufiles.c uextras.c ulolevel.c \
	  uutils.c utcp.c usrfi-1.c usrfi-4.c usrfi-13.c usrfi-14.c \
	  usrfi-18.c usrfi-69.c uposixunix.c uposixwin.c uregex.c chicken-profile.c chicken-bug.c \
	  csc.c csi.c chicken-install.c chicken-setup.c chicken-uninstall.c chicken-status.c \
	  chicken.c batch-driver.c compiler.c optimizer.c scrutinizer.c support.c \
	  c-platform.c c-backend.c chicken-boot$(EXE) \
	  $(IMPORT_LIBRARIES:=.import.c)

distclean: clean confclean

testclean:
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_OPTIONS) $(SRCDIR)tests/*.out $(SRCDIR)tests/tmp* \
	  $(SRCDIR)tests/*.so $(SRCDIR)tests/*.import.scm $(SRCDIR)tests/repository

# run tests

.PHONY: check fullcheck compiler-check

check: $(CHICKEN_SHARED_EXECUTABLE) $(CSI_SHARED_EXECUTABLE) $(CSC_PROGRAM)
	cd tests; sh runtests.sh

# Only for UNIX, yet:

fullcheck: check compiler-check

compiler-check:
	@echo "======================================== packing ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) dist
	$(REMOVE_COMMAND $(REMOVE_COMMAND_RECURSIVE_OPTIONS) tests/chicken-*
	tar -C tests -xzf `ls -t chicken-*.tar.gz | head -1`
	@echo "======================================== building stage 1 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all
	touch tests/chicken-*/*.scm
	@echo "======================================== building stage 2 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all
	cat tests/chicken-*/*.c >tests/stage2.out
	@echo "======================================== building stage 3 ..."
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 -C tests/chicken-* confclean all	
	cat tests/chicken-*/*.c >tests/stage3.out
	diff tests/stage2.out tests/stage3.out >tests/stages.diff
	$(REMOVE_COMMAND) $(REMOVE_COMMAND_RECURSIVE_OPTIONS) tests/chicken-*


# bootstrap from C source tarball

.PHONY: bootstrap bootstrap.tar.gz

bootstrap: 
	gzip -d -c $(SRCDIR)bootstrap.tar.gz | tar xvf -
	touch *.c
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) STATICBUILD=1 DEBUGBUILD=1 PLATFORM=$(PLATFORM) \
	  chicken$(EXE)
	$(COPY_COMMAND) chicken$(EXE) chicken-boot$(EXE)
	touch *.scm
	$(MAKE) -f $(SRCDIR)Makefile.$(PLATFORM) PLATFORM=$(PLATFORM) confclean

$(SRCDIR)bootstrap.tar.gz: distfiles
	tar cfz $@ library.c eval.c data-structures.c ports.c files.c extras.c lolevel.c utils.c tcp.c \
	  srfi-1.c srfi-4.c srfi-13.c srfi-14.c srfi-18.c srfi-69.c posixunix.c posixwin.c regex.c \
	  scheduler.c profiler.c stub.c expand.c chicken-syntax.c \
	  $(COMPILER_OBJECTS_1:=.c)


# benchmarking

.PHONY: bench

bench:
	here=`pwd`; \
	cd $(SRCDIR)benchmarks; \
	LD_LIBRARY_PATH=$$here DYLD_LIBRARY_PATH=$$here PATH=$$here:$$PATH \
	$(CSI) -s cscbench.scm $(BENCHMARK_OPTIONS)
