/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-cc.org
   2012-09-24 17:50
   Version 4.8.0 (rev 0db1908)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2012-09-24 on debian (Linux)
   command line: posixunix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"


#include <signal.h>
#include <errno.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_fchdir(fd)        C_fix(fchdir(C_unfix(fd)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)    (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_do_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep
#define C_umask(m)          C_fix(umask(C_unfix(m)))

#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))

#ifdef C_GNU_ENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
    /* Can't barf() here, so the NUL byte check happens in Scheme */
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    (memset((ptm), 0, sizeof(struct tm)), \
    (ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_set_08(v)  cpy_tmvec_to_tmstc08( &C_tm, (v) )
#define C_tm_set_9(v)   cpy_tmvec_to_tmstc9( &C_tm, (v) )

#define C_tm_get_08(v)  cpy_tmstc08_to_tmvec( (v), &C_tm )
#define C_tm_get_9(v)   cpy_tmstc9_to_tmvec( (v), &C_tm )

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  return v;
}

#else

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  C_tm_set_9( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  C_tm_get_9( v );
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_a_mktime(ptr, c, v)  C_flonum(ptr, mktime(C_tm_set(v)))
#define C_a_timegm(ptr, c, v)  C_flonum(ptr, C_timegm(C_tm_set(v)))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif

static int set_file_mtime(char *filename, C_word tm)
{
  struct utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return utime(filename, &tb);
}

static C_word C_i_fifo_p(C_word name) 
{
  struct stat buf;
  int res;

  res = stat(C_c_string(name), &buf);

  if(res != 0) {
#ifdef __CYGWIN__
    return C_SCHEME_FALSE;
#else
    if(errno == ENOENT) return C_fix(0);
    else return C_fix(res);
#endif
  }

  if((buf.st_mode & S_IFMT) == S_IFIFO) return C_SCHEME_TRUE;
  else return C_SCHEME_FALSE;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[463];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,14),40,102,95,50,54,48,55,32,97,54,52,54,55,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,54,57,32,108,111,99,55,48,32,109,115,103,55,49,32,46,32,97,114,103,115,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,52,32,108,105,110,107,56,53,32,101,114,114,56,54,32,108,111,99,56,55,41,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,115,116,97,116,32,102,57,57,32,46,32,116,109,112,57,56,49,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,53,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,52,41,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,51,55,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,53,32,46,32,116,109,112,49,52,52,49,52,54,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,52,41,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,54,41};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,54,56,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,48,41,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,16),40,102,95,50,56,52,53,32,102,105,108,101,49,55,50,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,54,41,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,49,56,50,32,109,49,56,51,32,108,111,99,49,56,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,49,57,52,32,102,100,49,57,53,32,105,110,112,49,57,54,32,114,49,57,55,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,50,48,48,32,46,32,109,50,48,49,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,50,48,51,32,46,32,109,50,48,52,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,50,49,48,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,50,49,56,32,46,32,110,101,119,50,49,57,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,51,48,50,51,49,41,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,53,56,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,13),40,102,95,51,48,55,57,32,102,50,55,52,41,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,54,52,32,103,50,55,49,50,56,49,41,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,53,48,32,46,32,116,109,112,50,52,57,50,53,49,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,57,51,50,57,52,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,8),40,102,95,51,50,55,55,41};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,13),40,102,95,51,51,49,50,32,109,51,53,55,41,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,51,52,57,41,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,47),40,102,95,51,50,56,50,32,100,105,114,51,51,50,51,51,51,51,51,56,32,102,105,108,51,51,52,51,51,53,51,51,57,32,101,120,116,51,51,54,51,51,55,51,52,48,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,51,51,48,41,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,51,50,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,8),40,102,95,51,52,50,56,41};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,8),40,102,95,51,52,51,51,41};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,8),40,102,95,51,52,53,51,41};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,51,56,54,32,114,51,56,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,13),40,102,95,51,53,48,54,32,120,51,56,52,41,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,15),40,102,95,51,53,50,54,32,46,32,95,51,55,56,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,15),40,102,95,51,53,49,55,32,46,32,95,51,55,55,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,53,49,41};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,53,52,41};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,53,55,41};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,54,48,41};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,18),40,102,95,51,53,54,53,32,120,52,50,48,32,121,52,50,49,41,0,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,54,51,41};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,15),40,102,95,51,53,55,50,32,46,32,95,52,49,56,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,8),40,102,95,51,53,55,48,41};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,49,53,32,46,32,116,109,112,52,49,52,52,49,54,41,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,52,52,52,32,116,109,52,52,53,41};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,52,53,50,52,53,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,52,54,53,52,54,54,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,16),40,102,95,51,54,51,57,32,97,52,55,53,52,55,56,41};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,52,56,52,52,56,53,41,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,52,57,52,41,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,16),40,102,95,51,54,57,56,32,97,53,48,48,53,48,51,41};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,24),40,102,95,51,55,48,52,32,97,53,48,54,53,48,57,32,97,53,48,53,53,49,48,41};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,26),40,102,95,51,55,49,48,32,116,109,53,49,55,32,46,32,116,109,112,53,49,54,53,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,53,51,49,32,112,114,111,99,53,51,50,41,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,8),40,102,95,51,56,48,48,41};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,34),40,102,95,51,56,48,53,32,101,112,105,100,53,53,54,32,101,110,111,114,109,53,53,55,32,101,99,111,100,101,53,53,56,41,0,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,53,52,49,41};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,97,54,48,49,54,48,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,97,54,48,54,54,48,57,41,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,32),40,102,95,51,56,57,51,32,97,54,53,48,54,53,51,32,97,54,52,57,54,53,52,32,97,54,52,56,54,53,53,41};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,54,54,49,32,99,109,100,54,54,50,32,46,32,116,109,112,54,54,48,54,54,51,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,54,55,52,32,102,108,97,103,115,54,55,53,32,46,32,109,111,100,101,54,55,54,41,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,54,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,54,56,55,32,115,105,122,101,54,56,56,32,46,32,98,117,102,102,101,114,54,56,57,41,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,54,57,56,32,98,117,102,102,101,114,54,57,57,32,46,32,115,105,122,101,55,48,48,41,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,16),40,102,95,52,48,55,55,32,97,55,49,57,55,50,50,41};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,24),40,102,95,52,48,56,50,32,97,55,50,52,55,50,55,32,97,55,50,51,55,50,56,41};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,24),40,102,95,52,48,57,48,32,97,55,51,48,55,51,51,32,97,55,50,57,55,51,52,41};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,14),40,102,95,52,49,54,55,32,102,100,56,51,57,41,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,50,57,32,103,56,51,54,56,52,49,41,0,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,14),40,102,95,52,50,49,50,32,102,100,56,49,56,41,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,48,56,32,103,56,49,53,56,50,48,41,0,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,14),40,102,95,52,50,54,56,32,102,100,55,56,55,41,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,55,55,32,103,55,56,52,55,57,49,41,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,14),40,102,95,52,51,49,49,32,102,100,55,53,57,41,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,52,57,32,103,55,53,54,55,54,51,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,55,51,53,32,102,100,115,119,55,51,54,32,46,32,116,105,109,101,111,117,116,55,51,55,41,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,56,53,52,32,112,111,115,56,53,53,32,46,32,119,104,101,110,99,101,56,53,54,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,23),40,102,95,52,52,52,49,32,108,111,99,56,57,52,32,110,97,109,101,56,57,53,41,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,56,57,48,41,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,8),40,102,95,52,52,54,56,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,48),40,102,95,52,52,55,51,32,100,105,114,56,57,56,56,57,57,57,48,52,32,102,105,108,101,57,48,48,57,48,49,57,48,53,32,101,120,116,57,48,50,57,48,51,57,48,54,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,23),40,102,95,52,52,56,49,32,108,111,99,57,49,50,32,110,97,109,101,57,49,51,41,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,56,55,56,32,46,32,116,109,112,56,55,55,56,55,57,41,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,57,49,55,41,0,0,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,25),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,102,100,57,50,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,57,51,48,32,99,109,100,57,51,49,32,105,110,112,57,51,50,32,114,57,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,57,51,54,32,46,32,109,57,51,55,41,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,57,52,53,32,46,32,109,57,52,54,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,57,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,57,53,56,41,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,8),40,102,95,52,54,56,57,41};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,21),40,102,95,52,54,57,52,32,46,32,114,101,115,117,108,116,115,57,55,51,41,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,57,54,57,32,112,114,111,99,57,55,48,32,46,32,109,111,100,101,57,55,49,41,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,49,49,41};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,21),40,102,95,52,55,49,54,32,46,32,114,101,115,117,108,116,115,57,56,48,41,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,57,55,54,32,112,114,111,99,57,55,55,32,46,32,109,111,100,101,57,55,56,41};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,51,51,41};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,21),40,102,95,52,55,52,51,32,46,32,114,101,115,117,108,116,115,57,57,53,41,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,51,56,41};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,53,49,41};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,57,56,51,32,116,104,117,110,107,57,56,52,32,46,32,109,111,100,101,57,56,53,41};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,54,53,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,22),40,102,95,52,55,55,53,32,46,32,114,101,115,117,108,116,115,49,48,49,50,41,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,55,48,41};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,8),40,102,95,52,55,56,51,41};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,50),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,49,48,48,48,32,116,104,117,110,107,49,48,48,49,32,46,32,109,111,100,101,49,48,48,50,41,0,0,0,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,14),40,102,95,52,56,51,56,32,115,49,48,53,56,41,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,29),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,48,52,56,32,103,49,48,53,53,49,48,54,49,41,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,49,48,52,53,41,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,115,105,103,115,49,48,55,48,32,109,97,115,107,49,48,55,49,41};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,13),40,115,105,103,110,97,108,45,109,97,115,107,41,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,49,48,55,53,41};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,22),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,49,48,55,56,41,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,49,48,56,50,41};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,41),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,49,49,49,52,32,46,32,116,109,112,49,49,49,51,49,49,49,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,49,53,51,41,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,43),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,49,49,52,48,32,46,32,116,109,112,49,49,51,57,49,49,52,49,41,0,0,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,49,55,50,41,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,26),40,100,111,108,111,111,112,49,49,55,57,32,108,115,116,49,49,56,49,32,105,49,49,56,50,41,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,49,49,55,56,41,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,28),40,102,95,53,50,53,50,32,97,49,49,57,50,49,49,57,54,32,97,49,49,57,49,49,49,57,55,41,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,35),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,49,49,57,57,32,105,100,49,50,48,48,41,0,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,50,52,52,32,109,49,50,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,42),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,49,50,52,57,32,117,105,100,49,50,53,48,32,103,105,100,49,50,53,49,41,0,0,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,50,53,54,32,97,99,99,49,50,53,55,32,108,111,99,49,50,53,56,41,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,50,54,50,41};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,50,54,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,50,54,52,41,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,49,50,56,52,32,110,101,119,49,50,56,53,41,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,44),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,50,57,53,32,46,32,116,109,112,49,50,57,52,49,50,57,54,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,28),40,102,95,53,53,49,51,32,97,49,51,48,57,49,51,49,52,32,97,49,51,48,56,49,51,49,53,41,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,105,110,107,32,111,108,100,49,51,49,56,32,110,101,119,49,51,49,57,41,0,0,0,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,8),40,102,95,53,53,56,48,41};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,8),40,102,95,53,54,48,55,41};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,8),40,102,95,53,54,49,52,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,8),40,102,95,53,55,49,53,41};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,8),40,102,95,53,55,50,54,41};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,8),40,102,95,53,55,51,55,41};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,8),40,102,95,53,55,53,55,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,51,57,53,32,109,49,51,57,54,32,115,116,97,114,116,49,51,57,55,41,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,42),40,102,95,53,55,54,53,32,112,111,114,116,49,51,57,48,32,110,49,51,57,49,32,100,101,115,116,49,51,57,50,32,115,116,97,114,116,49,51,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,24),40,102,95,53,56,52,48,32,99,117,114,49,52,49,53,32,112,116,114,49,52,49,54,41};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,8),40,102,95,53,57,48,54,41};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,43),40,102,95,53,57,49,49,32,100,101,115,116,49,52,51,53,49,52,51,54,49,52,51,57,32,99,111,110,116,63,49,52,51,55,49,52,51,56,49,52,52,48,41,0,0,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,115,116,114,49,52,49,51,41,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,27),40,102,95,53,56,51,50,32,112,111,114,116,49,52,49,48,32,108,105,109,105,116,49,52,49,49,41,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,17),40,102,95,53,57,51,49,32,112,111,114,116,49,52,52,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,62),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,51,50,56,32,110,97,109,49,51,50,57,32,102,100,49,51,51,48,32,46,32,116,109,112,49,51,50,55,49,51,51,49,41,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,22),40,112,111,107,101,32,115,116,114,49,52,55,53,32,108,101,110,49,52,55,54,41,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,16),40,102,95,54,48,57,52,32,115,116,114,49,53,48,57,41};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,8),40,102,95,54,48,57,57,41};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,8),40,102,95,54,49,49,57,41};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,16),40,102,95,54,49,50,54,32,115,116,114,49,52,57,50,41};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,52,57,55,32,115,116,97,114,116,49,52,57,56,32,108,101,110,49,52,57,57,41};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,16),40,102,95,54,49,51,57,32,115,116,114,49,52,57,53,41};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,52,53,55,32,110,97,109,49,52,53,56,32,102,100,49,52,53,57,32,46,32,116,109,112,49,52,53,54,49,52,54,48,41,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,53,49,55,32,111,102,102,49,53,49,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,53,50,53,32,97,114,103,115,49,53,50,54,32,108,111,99,49,53,50,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,53,52,50,32,108,111,99,107,49,53,52,51,32,108,111,99,49,53,52,52,41,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,49,53,52,53,32,46,32,97,114,103,115,49,53,52,54,41,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,49,53,52,56,32,46,32,97,114,103,115,49,53,52,57,41};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,14),40,102,95,54,51,57,52,32,99,49,53,54,49,41,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,49,53,53,49,32,46,32,97,114,103,115,49,53,53,50,41,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,49,53,54,56,41,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,49,53,55,50,32,46,32,109,111,100,101,49,53,55,51,41,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,49,53,55,56,41,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,24),40,115,101,116,101,110,118,32,118,97,114,49,53,56,54,32,118,97,108,49,53,56,55,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,18),40,117,110,115,101,116,101,110,118,32,118,97,114,49,53,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,18),40,102,95,54,53,51,55,32,97,49,53,57,55,49,54,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,12),40,115,99,97,110,32,106,49,54,48,54,41,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,54,48,51,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,68),40,102,95,54,54,49,51,32,97,49,54,50,53,49,54,50,57,32,97,49,54,50,52,49,54,51,48,32,97,49,54,50,51,49,54,51,49,32,97,49,54,50,50,49,54,51,50,32,97,49,54,50,49,49,54,51,51,32,97,49,54,50,48,49,54,51,52,41,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,54,51,55,32,108,101,110,49,54,51,56,32,112,114,111,116,49,54,51,57,32,102,108,97,103,49,54,52,48,32,102,100,49,54,52,49,32,46,32,111,102,102,49,54,52,50,41};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,28),40,102,95,54,54,55,57,32,97,49,54,53,50,49,54,53,54,32,97,49,54,53,49,49,54,53,55,41,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,54,53,57,32,46,32,108,101,110,49,54,54,48,41,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,54,54,52,41,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,54,54,55,41,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,18),40,102,95,54,55,51,54,32,97,49,54,55,49,49,54,55,52,41,0,0,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,28),40,102,95,54,55,52,50,32,97,49,54,55,55,49,54,56,48,32,97,49,54,55,54,49,54,56,49,41,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,35),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,49,54,56,56,32,46,32,116,109,112,49,54,56,55,49,54,56,57,41,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,38),40,102,95,54,55,57,54,32,97,49,55,48,53,49,55,48,56,32,97,49,55,48,52,49,55,48,57,32,97,49,55,48,51,49,55,49,48,41,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,49,55,49,54,32,46,32,116,109,112,49,55,49,53,49,55,49,55,41,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,55,50,54,41,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,18),40,102,95,54,56,53,48,32,97,49,55,51,53,49,55,51,56,41,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,55,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,97,108,97,114,109,33,32,97,49,55,52,49,49,55,52,52,41,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,55,52,54,32,109,111,100,101,49,55,52,55,32,46,32,115,105,122,101,49,55,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,55,53,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,49,55,54,52,32,112,111,114,116,49,55,54,53,41,0,0,0,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,18),40,102,95,54,57,55,50,32,97,49,55,55,48,49,55,55,51,41,0,0,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,49,55,55,53,41};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,38),40,102,95,54,57,57,49,32,97,49,55,56,49,49,55,56,52,32,97,49,55,56,48,49,55,56,53,32,97,49,55,55,57,49,55,56,54,41,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,55,56,55,41};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,8),40,102,95,55,48,51,48,41};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,8),40,102,95,55,48,52,55,41};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,18),40,102,95,55,48,55,52,32,97,49,56,50,48,49,56,50,51,41,0,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,104,117,110,107,49,56,49,48,41,0,0,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,38),40,102,95,55,48,56,57,32,97,49,56,51,51,49,56,51,55,32,97,49,56,51,50,49,56,51,56,32,97,49,56,51,49,49,56,51,57,41,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,8),40,102,95,55,49,48,55,41};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,38),40,102,95,55,49,48,57,32,97,49,56,52,53,49,56,52,57,32,97,49,56,52,52,49,56,53,48,32,97,49,56,52,51,49,56,53,49,41,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,8),40,102,95,55,49,50,55,41};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,56,55,55,32,101,108,49,56,55,57,32,105,49,56,56,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,56,55,51,32,97,108,49,56,55,53,32,105,49,56,55,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,56,54,48,32,46,32,116,109,112,49,56,53,57,49,56,54,49,41,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,57,48,48,32,110,111,104,97,110,103,49,57,48,49,41,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,17),40,115,108,101,101,112,32,97,49,57,49,49,49,57,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,57,49,54,32,46,32,115,105,103,49,57,49,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,57,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,57,50,57,32,46,32,97,114,103,115,49,57,51,48,41,0,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,33),40,102,95,55,51,54,55,32,108,111,99,49,57,51,56,32,102,100,49,57,51,57,32,115,116,100,102,100,49,57,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,8),40,102,95,55,51,57,53,41};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,30),40,102,95,55,52,48,48,32,95,49,57,53,51,32,102,108,103,49,57,53,52,32,99,111,100,49,57,53,53,41,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,8),40,102,95,55,51,56,49,41};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,61),40,102,95,55,51,55,57,32,108,111,99,49,57,52,54,32,112,105,100,49,57,52,55,32,99,108,115,118,101,99,49,57,52,56,32,105,100,120,49,57,52,57,32,105,100,120,97,49,57,53,48,32,105,100,120,98,49,57,53,49,41,0,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,8),40,102,95,55,52,50,49,41};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,20),40,102,95,55,52,50,54,32,105,49,57,54,48,32,111,49,57,54,49,41,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,25),40,102,95,55,52,49,51,32,108,111,99,49,57,53,55,32,112,111,114,116,49,57,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,41),40,102,95,55,52,51,48,32,108,111,99,49,57,54,50,32,112,105,112,101,49,57,54,51,32,112,111,114,116,49,57,54,52,32,102,100,49,57,54,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,44),40,102,95,55,52,51,57,32,108,111,99,49,57,55,48,32,112,105,112,101,49,57,55,49,32,112,111,114,116,49,57,55,50,32,115,116,100,102,100,49,57,55,51,41,0,0,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,17),40,102,95,55,52,53,49,32,112,105,112,101,49,57,56,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,8),40,102,95,55,52,56,50,41};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,75),40,115,112,97,119,110,32,108,111,99,49,57,56,51,32,99,109,100,49,57,56,52,32,97,114,103,115,49,57,56,53,32,101,110,118,49,57,56,54,32,115,116,100,111,117,116,102,49,57,56,55,32,115,116,100,105,110,102,49,57,56,56,32,115,116,100,101,114,114,102,49,57,56,57,41,0,0,0,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,73),40,102,95,55,52,57,57,32,108,111,99,49,57,57,54,32,112,105,100,49,57,57,55,32,99,109,100,49,57,57,56,32,112,105,112,101,49,57,57,57,32,115,116,100,102,50,48,48,48,32,115,116,100,102,100,50,48,48,49,32,111,110,45,99,108,111,115,101,50,48,48,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,73),40,102,95,55,53,48,57,32,108,111,99,50,48,48,52,32,112,105,100,50,48,48,53,32,99,109,100,50,48,48,54,32,112,105,112,101,50,48,48,55,32,115,116,100,102,50,48,48,56,32,115,116,100,102,100,50,48,48,57,32,111,110,45,99,108,111,115,101,50,48,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,8),40,102,95,55,53,50,53,41};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,51),40,102,95,55,53,51,48,32,105,110,112,105,112,101,50,48,49,57,32,111,117,116,112,105,112,101,50,48,50,48,32,101,114,114,112,105,112,101,50,48,50,49,32,112,105,100,50,48,50,50,41,0,0,0,0,0};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,50,48,49,50,32,99,109,100,50,48,49,51,32,97,114,103,115,50,48,49,52,32,101,110,118,50,48,49,53,32,115,116,100,111,117,116,102,50,48,49,54,32,115,116,100,105,110,102,50,48,49,55,32,115,116,100,101,114,114,102,50,48,49,56,41,0,0,0,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,22),40,102,95,55,53,55,48,32,103,50,48,53,48,50,48,53,49,50,48,53,50,41,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,29),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,48,51,55,32,103,50,48,52,52,50,48,53,54,41,0,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,16),40,102,95,55,53,54,54,32,108,115,116,50,48,51,52,41};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,8),40,102,95,55,54,48,56,41};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,56),40,102,95,55,53,54,52,32,108,111,99,50,48,50,55,32,101,114,114,63,50,48,50,56,32,99,109,100,50,48,50,57,32,97,114,103,115,50,48,51,48,32,101,110,118,50,48,51,49,32,107,50,48,51,50,41};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,32),40,102,95,55,54,52,50,32,105,50,48,56,50,32,111,50,48,56,51,32,112,50,48,56,52,32,101,50,48,56,53,41};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,50,48,55,48,32,46,32,116,109,112,50,48,54,57,50,48,55,49,41,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,50,48,57,49,32,46,32,116,109,112,50,48,57,48,50,48,57,50,41};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,18),40,102,95,55,55,49,48,32,97,50,49,48,54,50,49,49,48,41,0,0,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,50,49,49,50,41,0,0,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,16),40,102,95,55,55,52,51,32,112,105,100,49,50,55,51,41};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,25),40,102,95,55,55,53,56,32,112,105,100,49,50,55,56,32,112,103,105,100,49,50,55,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,8),40,102,95,55,55,55,55,41};
static C_char C_TLS li264[] C_aligned={C_lihdr(0,0,15),40,102,95,55,55,56,48,32,105,100,49,49,48,54,41,0};
static C_char C_TLS li265[] C_aligned={C_lihdr(0,0,8),40,102,95,55,55,57,52,41};
static C_char C_TLS li266[] C_aligned={C_lihdr(0,0,15),40,102,95,55,55,57,55,32,105,100,49,49,48,49,41,0};
static C_char C_TLS li267[] C_aligned={C_lihdr(0,0,8),40,102,95,55,56,49,49,41};
static C_char C_TLS li268[] C_aligned={C_lihdr(0,0,15),40,102,95,55,56,49,52,32,105,100,49,48,57,54,41,0};
static C_char C_TLS li269[] C_aligned={C_lihdr(0,0,8),40,102,95,55,56,50,56,41};
static C_char C_TLS li270[] C_aligned={C_lihdr(0,0,15),40,102,95,55,56,51,49,32,105,100,49,48,57,49,41,0};
static C_char C_TLS li271[] C_aligned={C_lihdr(0,0,16),40,102,95,55,56,52,53,32,112,111,114,116,56,54,54,41};
static C_char C_TLS li272[] C_aligned={C_lihdr(0,0,15),40,102,95,55,56,56,50,32,115,105,103,53,51,55,41,0};
static C_char C_TLS li273[] C_aligned={C_lihdr(0,0,20),40,102,95,55,56,57,48,32,46,32,116,109,112,52,51,49,52,51,50,41,0,0,0,0};
static C_char C_TLS li274[] C_aligned={C_lihdr(0,0,14),40,102,95,55,57,49,48,32,117,109,52,52,49,41,0,0};
static C_char C_TLS li275[] C_aligned={C_lihdr(0,0,13),40,102,95,55,57,49,53,32,102,49,48,56,41,0,0,0};
static C_char C_TLS li276[] C_aligned={C_lihdr(0,0,24),40,102,95,55,57,50,52,32,97,49,49,54,49,50,48,32,97,49,49,53,49,50,49,41};
static C_char C_TLS li277[] C_aligned={C_lihdr(0,0,18),40,102,95,55,57,50,48,32,102,49,49,48,32,116,49,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li278[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k7713 */
static C_word C_fcall stub2107(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2107(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k7290 */
static C_word C_fcall stub1912(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1912(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1908(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1908(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from f_7127 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1853(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1853(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k7119 */
static C_word C_fcall stub1846(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1846(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from f_7107 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1841(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1841(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k7099 */
static C_word C_fcall stub1834(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1834(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k7077 */
static C_word C_fcall stub1821(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1821(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from f_7047 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1808(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1808(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1801(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1801(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) C_return(NULL);else C_return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7000 */
static C_word C_fcall stub1782(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1782(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k6979 */
static C_word C_fcall stub1771(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1771(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k6872 */
static C_word C_fcall stub1742(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1742(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k6853 */
static C_word C_fcall stub1736(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1736(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1730(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1730(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = time(NULL);struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
C_return(z);
C_ret:
#undef return

return C_r;}

/* from f_6796 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1706(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1706(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from f_6742 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1678(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1678(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from f_6736 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1672(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1672(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k6686 */
static C_word C_fcall stub1653(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1653(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k6632 */
static C_word C_fcall stub1626(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub1626(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k6544 */
static C_word C_fcall stub1598(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1598(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k5520 in k5516 */
static C_word C_fcall stub1310(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1310(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5259 */
static C_word C_fcall stub1193(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1193(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub1163(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1163(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) C_return(0);else C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1158(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1158(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
C_return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1130(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1130(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
C_return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from f_7777 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1104(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1104(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from f_7794 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1099(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1099(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from f_7811 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1094(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1094(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from f_7828 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub1089(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1089(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k4096 */
static C_word C_fcall stub731(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub731(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k4088 */
static C_word C_fcall stub725(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub725(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k4080 */
static C_word C_fcall stub720(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub720(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k3902 */
static C_word C_fcall stub651(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub651(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub607(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub607(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) C_return(-1);else C_return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub602(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub602(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) C_return(0);C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from f_3704 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub507(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub507(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from f_3698 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static C_word C_fcall stub501(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub501(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3646 */
static C_word C_fcall stub476(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub476(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k7927 */
static C_word C_fcall stub117(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub117(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2614 */
static C_word C_fcall stub65(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub65(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_3532)
static void C_ccall f_3532(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3532)
static void C_ccall f_3532r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6875)
static void C_ccall f_6875(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6875)
static void C_ccall f_6875r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4760)
static void C_ccall f_4760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3321)
static void C_ccall f_3321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3506)
static void C_ccall f_3506(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4765)
static void C_ccall f_4765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3182)
static void C_fcall f_3182(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6879)
static void C_ccall f_6879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3318)
static void C_ccall f_3318(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7710)
static void C_ccall f_7710(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4494)
static void C_ccall f_4494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7715)
static void C_ccall f_7715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4751)
static void C_ccall f_4751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3312)
static void C_ccall f_3312(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4756)
static void C_ccall f_4756(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4756)
static void C_ccall f_4756r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6868)
static void C_ccall f_6868(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3188)
static void C_fcall f_3188(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7722)
static void C_ccall f_7722(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7738)
static void C_ccall f_7738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7226)
static void C_ccall f_7226(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3178)
static void C_ccall f_3178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7748)
static void C_ccall f_7748(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3113)
static void C_ccall f_3113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6442)
static void C_fcall f_6442(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7743)
static void C_ccall f_7743(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7758)
static void C_ccall f_7758(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7753)
static void C_ccall f_7753(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3133)
static void C_ccall f_3133(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3133)
static void C_ccall f_3133r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5718)
static void C_ccall f_5718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3149)
static void C_ccall f_3149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5711)
static void C_ccall f_5711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3147)
static void C_ccall f_3147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5713)
static void C_ccall f_5713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5715)
static void C_ccall f_5715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7777)
static void C_ccall f_7777(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5765)
static void C_ccall f_5765(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5760)
static void C_ccall f_5760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3137)
static void C_ccall f_3137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3947)
static void C_ccall f_3947(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7771)
static void C_ccall f_7771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7788)
static void C_ccall f_7788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5774)
static void C_fcall f_5774(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5772)
static void C_fcall f_5772(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3934)
static void C_ccall f_3934(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3934)
static void C_ccall f_3934r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3949)
static void C_ccall f_3949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7780)
static void C_ccall f_7780(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5745)
static void C_ccall f_5745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3964)
static void C_ccall f_3964(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3938)
static void C_fcall f_3938(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6255)
static void C_fcall f_6255(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7845)
static void C_ccall f_7845(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7848)
static void C_ccall f_7848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5607)
static void C_ccall f_5607(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6245)
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7859)
static void C_ccall f_7859(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7850)
static void C_ccall f_7850(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5726)
static void C_ccall f_5726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5720)
static void C_ccall f_5720(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3904)
static void C_ccall f_3904(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3904)
static void C_ccall f_3904r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3958)
static void C_ccall f_3958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5614)
static void C_ccall f_5614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7828)
static void C_ccall f_7828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7822)
static void C_ccall f_7822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5737)
static void C_ccall f_5737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5625)
static void C_ccall f_5625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4833)
static void C_ccall f_4833(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7208)
static void C_ccall f_7208(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4838)
static void C_ccall f_4838(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7882)
static void C_ccall f_7882(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3915)
static void C_ccall f_3915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5645)
static void C_ccall f_5645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5643)
static void C_ccall f_5643(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7890)
static void C_ccall f_7890(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7890)
static void C_ccall f_7890r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5675)
static void C_ccall f_5675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5677)
static void C_ccall f_5677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4280)
static void C_fcall f_4280(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4289)
static void C_ccall f_4289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5682)
static void C_ccall f_5682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7073)
static void C_ccall f_7073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7074)
static void C_ccall f_7074(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3780)
static void C_ccall f_3780(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3780)
static void C_ccall f_3780r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3980)
static void C_ccall f_3980(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3980)
static void C_ccall f_3980r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3772)
static void C_ccall f_3772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3774)
static void C_ccall f_3774(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3988)
static void C_ccall f_3988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6297)
static void C_fcall f_6297(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6293)
static void C_ccall f_6293(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3992)
static void C_ccall f_3992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3990)
static void C_ccall f_3990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4402)
static void C_ccall f_4402(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4404)
static void C_ccall f_4404(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4404)
static void C_ccall f_4404r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6281)
static void C_fcall f_6281(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7089)
static void C_ccall f_7089(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4429)
static void C_ccall f_4429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7097)
static void C_ccall f_7097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4420)
static void C_ccall f_4420(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4212)
static void C_ccall f_4212(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4218)
static void C_ccall f_4218(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4415)
static void C_ccall f_4415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4413)
static void C_ccall f_4413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4441)
static void C_ccall f_4441(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4440)
static void C_ccall f_4440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4238)
static void C_ccall f_4238(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2723)
static void C_ccall f_2723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6457)
static void C_ccall f_6457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4438)
static void C_fcall f_4438(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4431)
static void C_fcall f_4431(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4229)
static void C_fcall f_4229(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4227)
static void C_ccall f_4227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4460)
static void C_ccall f_4460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4468)
static void C_ccall f_4468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4466)
static void C_ccall f_4466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3724)
static void C_ccall f_3724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2955)
static void C_ccall f_2955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6479)
static void C_ccall f_6479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4454)
static void C_ccall f_4454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6472)
static void C_ccall f_6472(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4481)
static void C_ccall f_4481(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6460)
static void C_ccall f_6460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4591)
static void C_ccall f_4591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4597)
static void C_ccall f_4597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3735)
static void C_ccall f_3735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2911)
static void C_fcall f_2911(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4473)
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3733)
static void C_ccall f_3733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6411)
static void C_ccall f_6411(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2705)
static void C_ccall f_2705(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2707)
static void C_ccall f_2707(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2701)
static void C_ccall f_2701(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6436)
static void C_ccall f_6436(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6436)
static void C_ccall f_6436r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6154)
static void C_fcall f_6154(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2936)
static void C_ccall f_2936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2938)
static void C_ccall f_2938(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2938)
static void C_ccall f_2938r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5386)
static void C_ccall f_5386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7042)
static void C_ccall f_7042(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7040)
static void C_ccall f_7040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7049)
static void C_ccall f_7049(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7049)
static void C_ccall f_7049r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7047)
static void C_ccall f_7047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6139)
static void C_ccall f_6139(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5854)
static void C_ccall f_5854(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6138)
static void C_ccall f_6138(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5393)
static void C_ccall f_5393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2949)
static void C_ccall f_2949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5396)
static void C_ccall f_5396(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7053)
static void C_ccall f_7053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5398)
static void C_ccall f_5398(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6267)
static void C_ccall f_6267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6261)
static void C_ccall f_6261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6126)
static void C_ccall f_6126(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2741)
static void C_ccall f_2741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3717)
static void C_ccall f_3717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7021)
static void C_ccall f_7021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6938)
static void C_ccall f_6938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3710)
static void C_ccall f_3710(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3710)
static void C_ccall f_3710r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7025)
static void C_ccall f_7025(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7028)
static void C_ccall f_7028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2713)
static void C_ccall f_2713(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2717)
static void C_ccall f_2717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2719)
static void C_ccall f_2719(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6119)
static void C_ccall f_6119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6934)
static void C_ccall f_6934(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6107)
static void C_ccall f_6107(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2972)
static void C_ccall f_2972(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4268)
static void C_ccall f_4268(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3698)
static void C_ccall f_3698(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2987)
static void C_ccall f_2987(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5352)
static void C_ccall f_5352(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5350)
static void C_ccall f_5350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7554)
static void C_ccall f_7554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7551)
static void C_ccall f_7551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3683)
static void C_ccall f_3683(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3687)
static void C_ccall f_3687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3758)
static void C_ccall f_3758(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5328)
static void C_ccall f_5328(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7564)
static void C_ccall f_7564(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_7566)
static void C_ccall f_7566(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4926)
static void C_ccall f_4926(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2925)
static void C_ccall f_2925(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2925)
static void C_ccall f_2925r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5195)
static void C_ccall f_5195(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2923)
static void C_ccall f_2923(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3704)
static void C_ccall f_3704(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5845)
static void C_ccall f_5845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6709)
static void C_ccall f_6709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5840)
static void C_ccall f_5840(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3293)
static void C_fcall f_3293(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5170)
static void C_ccall f_5170(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5178)
static void C_ccall f_5178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5092)
static void C_ccall f_5092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5095)
static void C_ccall f_5095(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5097)
static void C_fcall f_5097(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6730)
static void C_ccall f_6730(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7030)
static void C_ccall f_7030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7036)
static void C_ccall f_7036(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5881)
static void C_ccall f_5881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6742)
static void C_ccall f_6742(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6748)
static void C_ccall f_6748(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6748)
static void C_ccall f_6748r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6721)
static void C_ccall f_6721(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3257)
static void C_ccall f_3257(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3257)
static void C_ccall f_3257r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7002)
static void C_ccall f_7002(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7006)
static void C_ccall f_7006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6736)
static void C_ccall f_6736(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7381)
static void C_ccall f_7381(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2998)
static void C_fcall f_2998(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6163)
static void C_ccall f_6163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3442)
static void C_ccall f_3442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3445)
static void C_ccall f_3445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6771)
static void C_ccall f_6771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3433)
static void C_ccall f_3433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7379)
static void C_ccall f_7379(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6762)
static void C_ccall f_6762(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5071)
static void C_ccall f_5071(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5071)
static void C_ccall f_5071r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5078)
static void C_fcall f_5078(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7502)
static void C_ccall f_7502(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6773)
static void C_ccall f_6773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7375)
static void C_ccall f_7375(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3465)
static void C_ccall f_3465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3462)
static void C_ccall f_3462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5089)
static void C_ccall f_5089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7509)
static void C_ccall f_7509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_4537)
static void C_ccall f_4537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4531)
static void C_ccall f_4531(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3451)
static void C_ccall f_3451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4529)
static void C_ccall f_4529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6755)
static void C_ccall f_6755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7395)
static void C_ccall f_7395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3483)
static void C_ccall f_3483(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5373)
static void C_ccall f_5373(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5376)
static void C_ccall f_5376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5378)
static void C_fcall f_5378(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3489)
static void C_ccall f_3489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4519)
static void C_ccall f_4519(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4517)
static void C_ccall f_4517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4511)
static void C_ccall f_4511(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7367)
static void C_ccall f_7367(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3471)
static void C_ccall f_3471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5121)
static void C_ccall f_5121(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3477)
static void C_ccall f_3477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4578)
static void C_ccall f_4578(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4578)
static void C_ccall f_4578r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4576)
static void C_ccall f_4576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3495)
static void C_ccall f_3495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6796)
static void C_ccall f_6796(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6798)
static void C_ccall f_6798(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6798)
static void C_ccall f_6798r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3639)
static void C_ccall f_3639(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4564)
static void C_fcall f_4564(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7950)
static void C_ccall f_7950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3623)
static void C_ccall f_3623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7570)
static void C_ccall f_7570(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3653)
static void C_ccall f_3653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7579)
static void C_fcall f_7579(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3657)
static void C_ccall f_3657(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7512)
static void C_ccall f_7512(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7588)
static void C_ccall f_7588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3648)
static void C_ccall f_3648(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3648)
static void C_ccall f_3648r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7525)
static void C_ccall f_7525(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7519)
static void C_ccall f_7519(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_5028)
static void C_ccall f_5028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7910)
static void C_ccall f_7910(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7530)
static void C_ccall f_7530(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_3405)
static void C_ccall f_3405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5020)
static void C_ccall f_5020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3408)
static void C_ccall f_3408(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7337)
static void C_ccall f_7337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7335)
static void C_fcall f_7335(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5036)
static void C_ccall f_5036(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7920)
static void C_ccall f_7920(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7545)
static void C_ccall f_7545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7542)
static void C_ccall f_7542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7539)
static void C_ccall f_7539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7331)
static void C_ccall f_7331(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7331)
static void C_ccall f_7331r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3618)
static void C_ccall f_3618(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3618)
static void C_ccall f_3618r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7918)
static void C_ccall f_7918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7915)
static void C_ccall f_7915(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7191)
static void C_fcall f_7191(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5046)
static void C_ccall f_5046(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5048)
static void C_ccall f_5048(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3428)
static void C_ccall f_3428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3426)
static void C_ccall f_3426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5043)
static void C_ccall f_5043(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4372)
static void C_ccall f_4372(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3602)
static void C_ccall f_3602(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7548)
static void C_ccall f_7548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7929)
static void C_ccall f_7929(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7924)
static void C_ccall f_7924(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7355)
static void C_ccall f_7355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7358)
static void C_ccall f_7358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3277)
static void C_ccall f_3277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3417)
static void C_ccall f_3417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7938)
static void C_ccall f_7938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3263)
static void C_fcall f_3263(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5110)
static void C_ccall f_5110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7325)
static void C_ccall f_7325(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7320)
static void C_ccall f_7320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3285)
static void C_ccall f_3285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7153)
static void C_fcall f_7153(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7839)
static void C_ccall f_7839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7148)
static void C_ccall f_7148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6358)
static void C_ccall f_6358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7145)
static void C_ccall f_7145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6354)
static void C_ccall f_6354(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6354)
static void C_ccall f_6354r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7831)
static void C_ccall f_7831(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5149)
static void C_ccall f_5149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5147)
static void C_ccall f_5147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5143)
static void C_ccall f_5143(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5017)
static void C_ccall f_5017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5011)
static void C_ccall f_5011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5014)
static void C_ccall f_5014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4360)
static void C_ccall f_4360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4366)
static void C_ccall f_4366(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7805)
static void C_ccall f_7805(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5156)
static void C_fcall f_5156(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5151)
static void C_ccall f_5151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3227)
static void C_ccall f_3227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6339)
static void C_fcall f_6339(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7814)
static void C_ccall f_7814(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7811)
static void C_ccall f_7811(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7109)
static void C_ccall f_7109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7107)
static void C_ccall f_7107(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5055)
static void C_ccall f_5055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5058)
static void C_ccall f_5058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7117)
static void C_ccall f_7117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7129)
static void C_ccall f_7129(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7129)
static void C_ccall f_7129r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7127)
static void C_ccall f_7127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2695)
static void C_ccall f_2695(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2699)
static void C_ccall f_2699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5008)
static void C_ccall f_5008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2693)
static void C_ccall f_2693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2665)
static void C_ccall f_2665(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2668)
static void C_ccall f_2668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7316)
static void C_ccall f_7316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2680)
static void C_ccall f_2680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6697)
static void C_fcall f_6697(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6691)
static void C_ccall f_6691(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6691)
static void C_ccall f_6691r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4323)
static void C_fcall f_4323(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4354)
static void C_fcall f_4354(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4350)
static void C_ccall f_4350(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4350)
static void C_ccall f_4350r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3893)
static void C_ccall f_3893(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5267)
static void C_ccall f_5267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7162)
static void C_ccall f_7162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7164)
static void C_ccall f_7164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7166)
static void C_ccall f_7166(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6679)
static void C_ccall f_6679(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7176)
static void C_ccall f_7176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6390)
static void C_ccall f_6390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5281)
static void C_ccall f_5281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5287)
static void C_ccall f_5287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7184)
static void C_ccall f_7184(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7178)
static void C_ccall f_7178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2659)
static void C_ccall f_2659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6613)
static void C_ccall f_6613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6394)
static void C_ccall f_6394(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6370)
static void C_ccall f_6370(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6370)
static void C_ccall f_6370r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2629)
static void C_ccall f_2629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2626)
static void C_ccall f_2626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5920)
static void C_ccall f_5920(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2620)
static void C_ccall f_2620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6643)
static void C_fcall f_6643(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6645)
static void C_ccall f_6645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6647)
static void C_ccall f_6647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6649)
static void C_ccall f_6649(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6386)
static void C_ccall f_6386(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6386)
static void C_ccall f_6386r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6641)
static void C_ccall f_6641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5931)
static void C_ccall f_5931(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5939)
static void C_ccall f_5939(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6637)
static void C_ccall f_6637(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_6637)
static void C_ccall f_6637r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_6374)
static void C_ccall f_6374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5906)
static void C_ccall f_5906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6661)
static void C_ccall f_6661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5911)
static void C_ccall f_5911(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4332)
static void C_ccall f_4332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4082)
static void C_ccall f_4082(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4311)
static void C_ccall f_4311(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3850)
static void C_ccall f_3850(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5815)
static void C_ccall f_5815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5257)
static void C_ccall f_5257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6991)
static void C_ccall f_6991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6985)
static void C_ccall f_6985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6047)
static void C_ccall f_6047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6981)
static void C_ccall f_6981(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5224)
static void C_ccall f_5224(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7601)
static void C_ccall f_7601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7603)
static void C_ccall f_7603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7608)
static void C_ccall f_7608(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5832)
static void C_ccall f_5832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5837)
static void C_fcall f_5837(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4077)
static void C_ccall f_4077(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6972)
static void C_ccall f_6972(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4060)
static void C_ccall f_4060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4066)
static void C_ccall f_4066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3800)
static void C_ccall f_3800(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3805)
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4090)
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2616)
static void C_ccall f_2616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2616)
static void C_ccall f_2616r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6951)
static void C_fcall f_6951(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6955)
static void C_ccall f_6955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4098)
static void C_ccall f_4098(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4098)
static void C_ccall f_4098r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6005)
static void C_ccall f_6005(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6005)
static void C_ccall f_6005r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6940)
static void C_ccall f_6940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7642)
static void C_ccall f_7642(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6813)
static void C_ccall f_6813(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6816)
static void C_ccall f_6816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2636)
static void C_ccall f_2636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2632)
static void C_fcall f_2632(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6029)
static void C_ccall f_6029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2603)
static void C_ccall f_2603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2607)
static void C_ccall f_2607(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6021)
static void C_ccall f_6021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6023)
static void C_fcall f_6023(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2601)
static void C_ccall f_2601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7621)
static void C_ccall f_7621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7625)
static void C_ccall f_7625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7627)
static void C_ccall f_7627(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7627)
static void C_ccall f_7627r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3843)
static void C_ccall f_3843(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6831)
static void C_ccall f_6831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6837)
static void C_ccall f_6837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6535)
static void C_ccall f_6535(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6537)
static void C_ccall f_6537(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7671)
static void C_ccall f_7671(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7671)
static void C_ccall f_7671r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6827)
static void C_ccall f_6827(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5597)
static void C_ccall f_5597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5209)
static void C_fcall f_5209(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4029)
static void C_ccall f_4029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4025)
static void C_fcall f_4025(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5200)
static void C_ccall f_5200(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5204)
static void C_ccall f_5204(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4056)
static void C_ccall f_4056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2863)
static void C_ccall f_2863(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2861)
static void C_ccall f_2861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4050)
static void C_ccall f_4050(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5575)
static void C_ccall f_5575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2875)
static void C_fcall f_2875(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5579)
static void C_ccall f_5579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7495)
static void C_ccall f_7495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7499)
static void C_ccall f_7499(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_7498)
static void C_ccall f_7498(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6077)
static void C_ccall f_6077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2882)
static void C_ccall f_2882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4844)
static void C_ccall f_4844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5490)
static void C_ccall f_5490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5496)
static void C_ccall f_5496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4876)
static void C_ccall f_4876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4865)
static void C_ccall f_4865(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4882)
static void C_fcall f_4882(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4856)
static void C_fcall f_4856(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4193)
static void C_ccall f_4193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2827)
static void C_ccall f_2827(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2825)
static void C_ccall f_2825(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6094)
static void C_ccall f_6094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6099)
static void C_ccall f_6099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6092)
static void C_ccall f_6092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6090)
static void C_ccall f_6090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4182)
static void C_ccall f_4182(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4184)
static void C_fcall f_4184(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2836)
static void C_ccall f_2836(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2834)
static void C_ccall f_2834(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6086)
static void C_fcall f_6086(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4173)
static void C_ccall f_4173(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2845)
static void C_ccall f_2845(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6556)
static void C_ccall f_6556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6552)
static void C_fcall f_6552(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4167)
static void C_ccall f_4167(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6589)
static void C_ccall f_6589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6586)
static void C_ccall f_6586(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6580)
static void C_ccall f_6580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3030)
static void C_ccall f_3030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3028)
static void C_ccall f_3028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6564)
static void C_fcall f_6564(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5505)
static void C_ccall f_5505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4694)
static void C_ccall f_4694(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4694)
static void C_ccall f_4694r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4697)
static void C_ccall f_4697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6512)
static void C_ccall f_6512(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6514)
static void C_ccall f_6514(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2818)
static void C_ccall f_2818(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3048)
static void C_ccall f_3048(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3048)
static void C_ccall f_3048r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6546)
static void C_ccall f_6546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3073)
static void C_ccall f_3073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3079)
static void C_ccall f_3079(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3078)
static void C_ccall f_3078(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7400)
static void C_ccall f_7400(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6523)
static void C_ccall f_6523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6526)
static void C_ccall f_6526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6528)
static void C_ccall f_6528(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4652)
static void C_ccall f_4652(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4658)
static void C_ccall f_4658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4656)
static void C_ccall f_4656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5518)
static void C_ccall f_5518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5513)
static void C_ccall f_5513(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2852)
static void C_ccall f_2852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2854)
static void C_ccall f_2854(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3088)
static void C_ccall f_3088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7430)
static void C_ccall f_7430(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7439)
static void C_ccall f_7439(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7438)
static void C_ccall f_7438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5522)
static void C_ccall f_5522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7447)
static void C_ccall f_7447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3560)
static void C_ccall f_3560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3563)
static void C_ccall f_3563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3565)
static void C_ccall f_3565(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3579)
static void C_fcall f_3579(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4792)
static void C_ccall f_4792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7413)
static void C_ccall f_7413(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5583)
static void C_ccall f_5583(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5580)
static void C_ccall f_5580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3597)
static void C_ccall f_3597(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3597)
static void C_ccall f_3597r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3055)
static void C_fcall f_3055(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3059)
static void C_ccall f_3059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7421)
static void C_ccall f_7421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7426)
static void C_ccall f_7426(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5553)
static void C_ccall f_5553(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5404)
static void C_ccall f_5404(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7471)
static void C_ccall f_7471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7477)
static void C_ccall f_7477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5416)
static void C_ccall f_5416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5410)
static void C_ccall f_5410(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7485)
static void C_ccall f_7485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7482)
static void C_ccall f_7482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7480)
static void C_ccall f_7480(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7489)
static void C_ccall f_7489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7487)
static void C_ccall f_7487(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5535)
static void C_ccall f_5535(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7797)
static void C_ccall f_7797(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7794)
static void C_ccall f_7794(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5420)
static void C_ccall f_5420(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5425)
static void C_ccall f_5425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7451)
static void C_ccall f_7451(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3099)
static void C_ccall f_3099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5432)
static void C_ccall f_5432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5434)
static void C_ccall f_5434(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3094)
static void C_ccall f_3094(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2597)
static void C_ccall f_2597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7463)
static void C_fcall f_7463(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_2595)
static void C_ccall f_2595(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2599)
static void C_ccall f_2599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7467)
static void C_ccall f_7467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7469)
static void C_ccall f_7469(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3197)
static void C_ccall f_3197(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5456)
static void C_ccall f_5456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3570)
static void C_ccall f_3570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3572)
static void C_ccall f_3572(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5453)
static void C_ccall f_5453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3577)
static void C_ccall f_3577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5459)
static void C_ccall f_5459(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4976)
static void C_ccall f_4976(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5465)
static void C_ccall f_5465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4969)
static void C_ccall f_4969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4961)
static void C_ccall f_4961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4964)
static void C_ccall f_4964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5476)
static void C_ccall f_5476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4958)
static void C_ccall f_4958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4955)
static void C_ccall f_4955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4952)
static void C_ccall f_4952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4606)
static void C_ccall f_4606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3154)
static void C_ccall f_3154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4946)
static void C_ccall f_4946(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3151)
static void C_ccall f_3151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3168)
static void C_fcall f_3168(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4942)
static void C_ccall f_4942(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4116)
static void C_ccall f_4116(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4118)
static void C_fcall f_4118(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4111)
static void C_ccall f_4111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4102)
static void C_fcall f_4102(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4104)
static void C_ccall f_4104(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4106)
static void C_ccall f_4106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7293)
static void C_ccall f_7293(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7293)
static void C_ccall f_7293r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7297)
static void C_fcall f_7297(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5757)
static void C_ccall f_5757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3345)
static void C_ccall f_3345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4997)
static void C_fcall f_4997(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4990)
static void C_ccall f_4990(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4990)
static void C_ccall f_4990r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4988)
static void C_ccall f_4988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4984)
static void C_ccall f_4984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3367)
static void C_fcall f_3367(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4980)
static void C_ccall f_4980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4157)
static void C_ccall f_4157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4154)
static void C_ccall f_4154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4672)
static void C_ccall f_4672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4670)
static void C_ccall f_4670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7282)
static void C_ccall f_7282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7286)
static void C_ccall f_7286(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3365)
static void C_ccall f_3365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3359)
static void C_fcall f_3359(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3357)
static void C_fcall f_3357(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4666)
static void C_ccall f_4666(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4615)
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4615)
static void C_ccall f_4615r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7266)
static void C_ccall f_7266(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4706)
static void C_ccall f_4706(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4702)
static void C_ccall f_4702(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4702)
static void C_ccall f_4702r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3384)
static void C_ccall f_3384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4689)
static void C_ccall f_4689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4684)
static void C_ccall f_4684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4634)
static void C_ccall f_4634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3104)
static void C_fcall f_3104(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4628)
static void C_ccall f_4628(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3536)
static void C_ccall f_3536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3538)
static void C_ccall f_3538(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3554)
static void C_ccall f_3554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3551)
static void C_ccall f_3551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6892)
static void C_fcall f_6892(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4743)
static void C_ccall f_4743(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4743)
static void C_ccall f_4743r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3526)
static void C_ccall f_3526(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4746)
static void C_ccall f_4746(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3544)
static void C_ccall f_3544(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3542)
static void C_ccall f_3542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3540)
static void C_ccall f_3540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4643)
static void C_ccall f_4643(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6881)
static void C_fcall f_6881(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6884)
static void C_ccall f_6884(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4733)
static void C_ccall f_4733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3557)
static void C_ccall f_3557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4738)
static void C_ccall f_4738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4724)
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4724)
static void C_ccall f_4724r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4728)
static void C_ccall f_4728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3546)
static void C_ccall f_3546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4716)
static void C_ccall f_4716(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4716)
static void C_ccall f_4716r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4719)
static void C_ccall f_4719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3308)
static void C_ccall f_3308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6850)
static void C_ccall f_6850(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6855)
static void C_ccall f_6855(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6855)
static void C_ccall f_6855r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4788)
static void C_ccall f_4788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4783)
static void C_ccall f_4783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3505)
static void C_ccall f_3505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3503)
static void C_ccall f_3503(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6842)
static void C_ccall f_6842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4770)
static void C_ccall f_4770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3517)
static void C_ccall f_3517(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4778)
static void C_ccall f_4778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4775)
static void C_ccall f_4775(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4775)
static void C_ccall f_4775r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_3182)
static void C_fcall trf_3182(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3182(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3182(t0,t1);}

C_noret_decl(trf_3188)
static void C_fcall trf_3188(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3188(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3188(t0,t1);}

C_noret_decl(trf_6442)
static void C_fcall trf_6442(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6442(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6442(t0,t1);}

C_noret_decl(trf_5774)
static void C_fcall trf_5774(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5774(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5774(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5772)
static void C_fcall trf_5772(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5772(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5772(t0,t1);}

C_noret_decl(trf_3938)
static void C_fcall trf_3938(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3938(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3938(t0,t1);}

C_noret_decl(trf_6255)
static void C_fcall trf_6255(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6255(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6255(t0,t1);}

C_noret_decl(trf_4280)
static void C_fcall trf_4280(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4280(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4280(t0,t1,t2);}

C_noret_decl(trf_6297)
static void C_fcall trf_6297(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6297(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6297(t0,t1);}

C_noret_decl(trf_6281)
static void C_fcall trf_6281(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6281(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6281(t0,t1,t2,t3);}

C_noret_decl(trf_4438)
static void C_fcall trf_4438(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4438(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4438(t0,t1);}

C_noret_decl(trf_4431)
static void C_fcall trf_4431(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4431(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4431(t0,t1,t2);}

C_noret_decl(trf_4229)
static void C_fcall trf_4229(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4229(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4229(t0,t1,t2);}

C_noret_decl(trf_2911)
static void C_fcall trf_2911(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2911(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2911(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6154)
static void C_fcall trf_6154(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6154(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6154(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3293)
static void C_fcall trf_3293(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3293(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3293(t0,t1,t2);}

C_noret_decl(trf_5097)
static void C_fcall trf_5097(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5097(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5097(t0,t1,t2);}

C_noret_decl(trf_2998)
static void C_fcall trf_2998(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2998(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2998(t0,t1);}

C_noret_decl(trf_5078)
static void C_fcall trf_5078(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5078(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5078(t0,t1);}

C_noret_decl(trf_5378)
static void C_fcall trf_5378(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5378(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5378(t0,t1,t2,t3);}

C_noret_decl(trf_4564)
static void C_fcall trf_4564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4564(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4564(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7579)
static void C_fcall trf_7579(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7579(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7579(t0,t1,t2);}

C_noret_decl(trf_7335)
static void C_fcall trf_7335(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7335(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7335(t0,t1);}

C_noret_decl(trf_7191)
static void C_fcall trf_7191(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7191(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7191(t0,t1,t2,t3);}

C_noret_decl(trf_3263)
static void C_fcall trf_3263(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3263(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3263(t0,t1,t2);}

C_noret_decl(trf_7153)
static void C_fcall trf_7153(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7153(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7153(t0,t1,t2,t3);}

C_noret_decl(trf_5156)
static void C_fcall trf_5156(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5156(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5156(t0,t1,t2);}

C_noret_decl(trf_6339)
static void C_fcall trf_6339(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6339(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6339(t0,t1,t2,t3);}

C_noret_decl(trf_6697)
static void C_fcall trf_6697(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6697(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6697(t0,t1);}

C_noret_decl(trf_4323)
static void C_fcall trf_4323(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4323(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4323(t0,t1,t2);}

C_noret_decl(trf_4354)
static void C_fcall trf_4354(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4354(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4354(t0,t1);}

C_noret_decl(trf_6643)
static void C_fcall trf_6643(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6643(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6643(t0,t1);}

C_noret_decl(trf_5837)
static void C_fcall trf_5837(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5837(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5837(t0,t1,t2);}

C_noret_decl(trf_6951)
static void C_fcall trf_6951(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6951(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6951(t0,t1,t2);}

C_noret_decl(trf_2632)
static void C_fcall trf_2632(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2632(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2632(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6023)
static void C_fcall trf_6023(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6023(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6023(t0,t1,t2,t3);}

C_noret_decl(trf_5209)
static void C_fcall trf_5209(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5209(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5209(t0,t1,t2,t3);}

C_noret_decl(trf_4025)
static void C_fcall trf_4025(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4025(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4025(t0,t1);}

C_noret_decl(trf_2875)
static void C_fcall trf_2875(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2875(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2875(t0,t1,t2,t3);}

C_noret_decl(trf_4882)
static void C_fcall trf_4882(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4882(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4882(t0,t1,t2,t3);}

C_noret_decl(trf_4856)
static void C_fcall trf_4856(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4856(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4856(t0,t1,t2);}

C_noret_decl(trf_4184)
static void C_fcall trf_4184(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4184(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4184(t0,t1,t2);}

C_noret_decl(trf_6086)
static void C_fcall trf_6086(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6086(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6086(t0,t1);}

C_noret_decl(trf_6552)
static void C_fcall trf_6552(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6552(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6552(t0,t1,t2);}

C_noret_decl(trf_6564)
static void C_fcall trf_6564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6564(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6564(t0,t1,t2);}

C_noret_decl(trf_3579)
static void C_fcall trf_3579(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3579(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3579(t0,t1,t2);}

C_noret_decl(trf_3055)
static void C_fcall trf_3055(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3055(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3055(t0,t1);}

C_noret_decl(trf_7463)
static void C_fcall trf_7463(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7463(void *dummy){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
f_7463(t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(trf_3168)
static void C_fcall trf_3168(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3168(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3168(t0,t1);}

C_noret_decl(trf_4118)
static void C_fcall trf_4118(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4118(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4118(t0,t1);}

C_noret_decl(trf_4102)
static void C_fcall trf_4102(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4102(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4102(t0,t1);}

C_noret_decl(trf_7297)
static void C_fcall trf_7297(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7297(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7297(t0,t1);}

C_noret_decl(trf_4997)
static void C_fcall trf_4997(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4997(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4997(t0,t1);}

C_noret_decl(trf_3367)
static void C_fcall trf_3367(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3367(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3367(t0,t1,t2,t3);}

C_noret_decl(trf_3359)
static void C_fcall trf_3359(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3359(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3359(t0,t1);}

C_noret_decl(trf_3357)
static void C_fcall trf_3357(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3357(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3357(t0,t1);}

C_noret_decl(trf_3104)
static void C_fcall trf_3104(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3104(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3104(t0,t1,t2);}

C_noret_decl(trf_6892)
static void C_fcall trf_6892(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6892(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6892(t0,t1);}

C_noret_decl(trf_6881)
static void C_fcall trf_6881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6881(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6881(t0,t1);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr8)
static void C_fcall tr8(C_proc8 k) C_regparm C_noret;
C_regparm static void C_fcall tr8(C_proc8 k){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
(k)(8,t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr7r)
static void C_fcall tr7r(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7r(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

/* find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3532(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3532r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3532r(t0,t1,t2,t3);}}

static void C_ccall f_3532r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(8);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3536,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3570,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t4,lf[97],t3,t5);}

/* set-buffering-mode! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6875(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_6875r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_6875r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6875r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6879,a[2]=t3,a[3]=t1,a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1697: ##sys#check-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[355]+1)))(4,*((C_word*)lf[355]+1),t5,t2,lf[399]);}

/* k4759 in with-output-to-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4760,2,t0,t1);}
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4765,a[2]=t5,a[3]=t3,a[4]=((C_word)li112),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4770,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li114),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4783,a[2]=t3,a[3]=t5,a[4]=((C_word)li115),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:869: ##sys#dynamic-wind */
t9=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,((C_word*)t0)[3],t6,t7,t8);}

/* k3320 in k3317 */
static void C_ccall f_3321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3321,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* f_3506 in k3504 in k3501 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3506(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3506,3,t0,t1,t2);}
/* posix-common.scm:399: irregex-match */
t3=*((C_word*)lf[80]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* f_4765 in k4759 in with-output-to-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4765,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[211]+1));
t3=C_mutate((C_word*)lf[211]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3181 in k3177 in loop in k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3182(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3182,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3188,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=C_eqp(C_make_character(46),((C_word*)t0)[5]);
if(C_truep(t3)){
t4=C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_3188(t5,t4);}
else{
t5=C_eqp(C_make_character(46),t1);
if(C_truep(t5)){
t6=C_eqp(C_fix(2),((C_word*)t0)[6]);
t7=t2;
f_3188(t7,(C_truep(t6)?t6:C_i_not(((C_word*)t0)[7])));}
else{
t6=t2;
f_3188(t6,C_i_not(((C_word*)t0)[7]));}}}
else{
t4=t2;
f_3188(t4,C_SCHEME_FALSE);}}

/* k6878 in set-buffering-mode! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6879,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6881,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_6881(t4,C_u_i_car(t3));}
else{
t3=t2;
f_6881(t3,C_fix((C_word)BUFSIZ));}}

/* k3317 */
static void C_ccall f_3318(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3318,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3321,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:382: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_3293(t4,t2,t3);}

/* f_7710 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7710(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7710,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7715,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t2)){
t4=C_i_foreign_string_argumentp(t2);
/* posixunix.scm:1977: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub2107(C_SCHEME_UNDEFINED,C_SCHEME_FALSE));}}

/* k4493 */
static void C_ccall f_4494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posixunix.scm:762: posix-error */
t4=lf[2];
f_2616(6,t4,((C_word*)t0)[2],lf[8],((C_word*)t0)[3],lf[187],((C_word*)t0)[4]);}}

/* k7713 */
static void C_ccall f_7715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub2107(C_SCHEME_UNDEFINED,t1));}

/* f_4751 in k4727 in with-input-from-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4751,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[209]+1));
t3=C_mutate((C_word*)lf[209]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* f_3312 in k3307 in loop in k3290 in k3284 */
static void C_ccall f_3312(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3312,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3318,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3327,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:381: irregex-match-substring */
t5=*((C_word*)lf[79]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* with-output-to-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4756(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4756r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4756r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4756r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4760,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[199]+1),t2,t4);}

/* set-alarm! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6868(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6868,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1742(C_SCHEME_UNDEFINED,t3));}

/* k3186 in k3181 in k3177 in loop in k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3188(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3188,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:362: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3168(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3197,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:363: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3168(t3,t2);}}

/* set-root-directory! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7722(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7722,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[438]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7738,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1980: chroot */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7737 in set-root-directory! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1981: posix-error */
t2=lf[2];
f_2616(6,t2,((C_word*)t0)[2],lf[8],lf[438],lf[439],((C_word*)t0)[3]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k7224 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7226(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7153(t5,((C_word*)t0)[5],t3,t4);}

/* k3177 in loop in k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3178,2,t0,t1);}
t2=C_i_string_ref(t1,C_fix(0));
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3182,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
t4=t1;
t5=t3;
f_3182(t5,C_subchar(t4,C_fix(1)));}
else{
t4=t3;
f_3182(t4,C_SCHEME_FALSE);}}

/* k7747 */
static void C_ccall f_7748(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3112 in for-each-loop264 in k3077 in k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3104(t3,((C_word*)t0)[4],t2);}

/* k6441 in create-fifo in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6442(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6442,NULL,2,t0,t1);}
t2=C_i_check_exact_2(t1,lf[364]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6457,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6460,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1540: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t4,((C_word*)t0)[3]);}

/* f_7743 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7743(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7743,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[318]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7748,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7753,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1235: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t4);}}

/* f_7758 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7758(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7758,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[441]);
t5=C_i_check_exact_2(t3,lf[441]);
t6=C_setpgid(t2,t3);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7771,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1242: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t7);}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* k7752 */
static void C_ccall f_7753(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1236: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[318],lf[440],((C_word*)t0)[3]);}

/* directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3133(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3133r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3133r(t0,t1,t2);}}

static void C_ccall f_3133r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3137,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:338: current-directory */
t4=*((C_word*)lf[62]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_3137(2,t4,C_i_car(t2));}}

/* k5717 */
static void C_ccall f_5718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5718,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5720,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1344: peek */
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3149,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3151,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:342: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[75]+1)))(2,*((C_word*)lf[75]+1),t2);}

/* k5709 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5711,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5713,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1417: set-port-name! */
t4=*((C_word*)lf[340]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[4]);}

/* k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3147,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3149,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:341: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[75]+1)))(2,*((C_word*)lf[75]+1),t2);}

/* k5712 in k5709 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[3])[1]);}

/* f_5715 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5715,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5718,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1343: fetch */
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* f_7777 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7777,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1104(C_SCHEME_UNDEFINED));}

/* f_5765 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5765(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5765,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5772,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=t1,a[8]=t5,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_5772(t7,t3);}
else{
t7=C_block_size(t4);
t8=t6;
f_5772(t8,C_fixnum_difference(t7,t5));}}

/* k5759 */
static void C_ccall f_5760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1360: peek */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3137,2,t0,t1);}
t2=C_i_nullp(((C_word*)t0)[2]);
t3=(C_truep(t2)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_check_string_2(t1,lf[25]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3147,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(4,*((C_word*)lf[66]+1),t9,C_fix(256),C_make_character(32));}

/* k3946 in k3937 in file-open in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3947(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3947,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3949,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:612: posix-error */
t5=lf[2];
f_2616(8,t5,t3,lf[8],lf[162],lf[163],((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k7770 */
static void C_ccall f_7771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1243: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[441],lf[442],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k7787 */
static void C_ccall f_7788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1040: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[445],lf[446],((C_word*)t0)[3]);}

/* loop in k5770 */
static void C_fcall f_5774(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5774,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t3;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_substring_copy(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[2])+1,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* posixunix.scm:1369: loop */
t19=t1;
t20=t13;
t21=t14;
t22=t15;
t1=t19;
t2=t20;
t3=t21;
t4=t22;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5815,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1371: fetch */
t7=((C_word*)t0)[7];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k5770 */
static void C_fcall f_5772(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5772,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5774,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=((C_word)li157),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_5774(t5,((C_word*)t0)[7],t1,C_fix(0),((C_word*)t0)[8]);}

/* file-open in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3934(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3934r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3934r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3934r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3938,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3938(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3938(t6,((C_word*)t0)[2]);}}

/* k3948 in k3946 in k3937 in file-open in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* f_7780 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7780(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7780,3,t0,t1,t2);}
t3=C_setegid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7788,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1039: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k5744 */
static void C_ccall f_5745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1357: on-close */
t2=((C_word*)t0)[2];
((C_proc2)C_fast_retrieve_proc(t2))(2,t2,((C_word*)t0)[3]);}

/* file-close in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3964(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3964,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[164]);
t4=C_close(t2);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
/* posixunix.scm:619: posix-error */
t5=lf[2];
f_2616(6,t5,t1,lf[8],lf[164],lf[165],t2);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k3937 in file-open in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3938(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3938,NULL,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[2],lf[162]);
t3=C_i_check_exact_2(((C_word*)t0)[3],lf[162]);
t4=C_i_check_exact_2(t1,lf[162]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3947,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3958,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:610: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t6,((C_word*)t0)[2]);}

/* k6253 in file-truncate in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6255(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1485: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],lf[351],lf[352],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* f_7845 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7845(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7845,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7848,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7859,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:743: port? */
t5=*((C_word*)lf[182]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7847 */
static void C_ccall f_7848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7848,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7850,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posixunix.scm:752: posix-error */
t3=lf[2];
f_2616(6,t3,t2,lf[8],lf[185],lf[456],((C_word*)t0)[3]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* f_5607 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5607,2,t0,t1);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=C_subchar(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* file-truncate in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6245,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[351]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6255,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6261,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6267,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6270,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1481: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}
else{
if(C_truep(C_fixnump(t2))){
t7=C_ftruncate(t2,t3);
t8=t5;
f_6255(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
/* posixunix.scm:1483: ##sys#error */
t7=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,lf[351],lf[353],t2);}}}

/* k7857 */
static void C_ccall f_7859(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[51]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];
f_7848(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
f_7848(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];
f_7848(2,t3,t2);}
else{
/* posixunix.scm:750: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[185],lf[457],((C_word*)t0)[2]);}}}

/* k7849 in k7847 */
static void C_ccall f_7850(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* f_5726 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5726,2,t0,t1);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:1351: ready? */
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5719 in k5717 */
static void C_ccall f_5720(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t1);}

/* file-control in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3904(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3904r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3904r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3904r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_fix(0):C_i_car(t4));
t7=C_i_check_exact_2(t2,lf[160]);
t8=C_i_check_exact_2(t3,lf[160]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3915,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:598: fcntl */
t10=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t9,t2,t3,t6);}

/* k3957 in k3937 in file-open in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:610: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[162]);}

/* f_5614 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5614,2,t0,t1);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5625,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t3,a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[3],a[10]=((C_word*)t0)[2],a[11]=((C_word)li151),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_5625(2,t5,t1);}
else{
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* f_7828 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7828,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1089(C_SCHEME_UNDEFINED));}

/* k7821 */
static void C_ccall f_7822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1021: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[451],lf[452],((C_word*)t0)[3]);}

/* f_5737 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5737,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5745,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1356: posix-error */
t4=lf[2];
f_2616(7,t4,t2,lf[8],((C_word*)t0)[5],lf[341],((C_word*)t0)[4],((C_word*)t0)[6]);}
else{
/* posixunix.scm:1357: on-close */
t4=((C_word*)t0)[3];
((C_proc2)C_fast_retrieve_proc(t4))(2,t4,t1);}}}

/* loop */
static void C_ccall f_5625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5625,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5643,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1316: ##sys#thread-block-for-i/o! */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[334]+1)))(5,*((C_word*)lf[334]+1),t7,*((C_word*)lf[335]+1),((C_word*)t0)[2],lf[336]);}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1320: ##sys#dispatch-interrupt */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[337]+1)))(3,*((C_word*)lf[337]+1),t1,((C_word*)((C_word*)t0)[5])[1]);}
else{
/* posixunix.scm:1321: posix-error */
t7=lf[2];
f_2616(7,t7,t1,lf[8],((C_word*)t0)[6],lf[338],((C_word*)t0)[2],((C_word*)t0)[7]);}}}
else{
t4=(C_truep(((C_word*)t0)[8])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5675,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1325: more? */
t6=((C_word*)t0)[8];
((C_proc2)C_fast_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[9])+1,t2);
t6=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* set-signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4833(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[13],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4833,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,lf[240]);
t4=C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4838,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp);
t6=t2;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4844,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4856,a[2]=t9,a[3]=t5,a[4]=((C_word)li119),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_4856(t11,t7,t6);}

/* k7206 in doloop1877 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_7208(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7191(t5,((C_word*)t0)[5],t3,t4);}

/* f_4838 in set-signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4838(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4838,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[240]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_sigaddset(t2));}

/* f_7882 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7882(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7882,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[116]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(*((C_word*)lf[115]+1),t2));}

/* k3914 in file-control in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(t1,C_fix(-1));
if(C_truep(t2)){
/* posixunix.scm:600: posix-error */
t3=lf[2];
f_2616(7,t3,((C_word*)t0)[2],lf[8],lf[160],lf[161],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5644 in k5642 in loop */
static void C_ccall f_5645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1318: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_5625(2,t2,((C_word*)t0)[3]);}

/* k5642 in loop */
static void C_ccall f_5643(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5643,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5645,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1317: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[333]+1)))(2,*((C_word*)lf[333]+1),t2);}

/* f_7890 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7890(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_7890r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7890r(t0,t1,t2);}}

static void C_ccall f_7890r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[98]):C_SCHEME_UNDEFINED);
t6=C_umask(t4);
if(C_truep(t4)){
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}

/* k5673 in loop */
static void C_ccall f_5675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5675,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5677,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1327: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[333]+1)))(2,*((C_word*)lf[333]+1),t2);}
else{
t2=C_read(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5682,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t7=(C_truep(t6)?t6:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t7)){
t8=C_set_block_item(t3,0,C_fix(0));
t9=C_mutate(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t10=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t11=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t10);}
else{
/* posixunix.scm:1334: posix-error */
t8=lf[2];
f_2616(7,t8,t4,lf[8],((C_word*)t0)[9],lf[339],((C_word*)t0)[4],((C_word*)t0)[10]);}}
else{
t6=C_mutate(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t7=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t8=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}}

/* k5676 in k5673 in loop */
static void C_ccall f_5677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1328: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_5625(2,t2,((C_word*)t0)[3]);}

/* for-each-loop777 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4280(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4280,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4289,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:685: g778 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4288 in for-each-loop777 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4280(t3,((C_word*)t0)[4],t2);}

/* k5681 in k5673 in loop */
static void C_ccall f_5682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k7071 in k7052 in process-fork in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7073,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7074,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1759: g1818 */
t3=t2;
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[2],C_fix(0));}

/* f_7074 in k7071 in k7052 in process-fork in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7074(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7074,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1821(C_SCHEME_UNDEFINED,t3));}

/* process-wait in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3780(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3780r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3780r(t0,t1,t2);}}

static void C_ccall f_3780r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=C_i_check_exact_2(t11,lf[118]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3800,a[2]=t11,a[3]=t8,a[4]=((C_word)li63),tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3805,a[2]=t11,a[3]=((C_word)li64),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:515: ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}

/* file-read in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3980(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3980r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3980r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3980r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[166]);
t6=C_i_check_exact_2(t3,lf[166]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3988,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_3988(2,t9,C_u_i_car(t8));}
else{
t8=t3;
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(4,*((C_word*)lf[66]+1),t7,t8,C_make_character(32));}}

/* k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word ab[67],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3772,2,t0,t1);}
t2=C_mutate((C_word*)lf[116]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate((C_word*)lf[117]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3774,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[118]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3780,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[122]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3843,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[123]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3850,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[124]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[125]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[126]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[127]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[128]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[129]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[130]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[131]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[132]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[133]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[134]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[135]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[136]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[137]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[138]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[139]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[140]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[141]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[142]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[143]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[144]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[145]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[146]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[147]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[148]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[149]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[150]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[151]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[152]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[153]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[154]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[155]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[156]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[157]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[158]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[159]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t43=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3893,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp);
t44=C_mutate((C_word*)lf[160]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3904,a[2]=t43,a[3]=((C_word)li69),tmp=(C_word)a,a+=4,tmp));
t45=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t46=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t45);
t47=C_mutate((C_word*)lf[162]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3934,a[2]=t46,a[3]=((C_word)li70),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[164]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3964,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[166]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3980,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[169]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4017,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[172]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4050,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4077,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp);
t53=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4082,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp);
t54=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4090,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp);
t55=C_mutate((C_word*)lf[174]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4098,a[2]=t54,a[3]=t53,a[4]=t52,a[5]=((C_word)li86),tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[176]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[177]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[178]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t59=C_mutate((C_word*)lf[179]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4350,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4402,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t61=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7845,a[2]=((C_word)li271),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:741: getter-with-setter */
t62=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t62+1)))(5,t62,t60,t61,*((C_word*)lf[179]+1),lf[458]);}

/* current-process-id in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3774,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fudge(C_fix(33)));}

/* k3987 in file-read in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3988,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3990,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_byteblockp(t1))){
t3=t2;
f_3990(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:627: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[13],lf[166],lf[168],t1);}}
else{
/* posixunix.scm:627: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[13],lf[166],lf[168],t1);}}

/* k6296 in k6292 in setup in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6297(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6297,NULL,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=C_flock_setup(t3,((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_record4(&a,4,lf[354],((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]));}

/* k6292 in setup in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6293,2,t0,t1);}
t2=C_i_check_number_2(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6297,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[5])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[5],0,C_fix(0));
t6=t3;
f_6297(t6,t5);}
else{
t5=t3;
f_6297(t5,C_i_check_number_2(((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[3]));}}

/* k3991 in k3989 in k3987 in file-read in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3992,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]));}

/* k3989 in k3987 in file-read in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3990,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3992,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:630: posix-error */
t5=lf[2];
f_2616(7,t5,t3,lf[8],lf[166],lf[167],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list2(&a,2,((C_word*)t0)[3],t2));}}

/* k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word ab[143],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4402,2,t0,t1);}
t2=C_mutate((C_word*)lf[185]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[186]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4404,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[63]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4511,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[191]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4531,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4564,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp);
t7=C_mutate((C_word*)lf[195]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4578,a[2]=t6,a[3]=((C_word)li97),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[199]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4615,a[2]=t6,a[3]=((C_word)li98),tmp=(C_word)a,a+=4,tmp));
t9=C_mutate((C_word*)lf[200]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4652,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[203]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4666,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[206]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4680,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[207]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4702,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[208]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4724,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[210]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4756,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[212]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4788,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[214]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t17=C_mutate((C_word*)lf[215]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t18=C_mutate((C_word*)lf[216]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t19=C_mutate((C_word*)lf[217]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t20=C_mutate((C_word*)lf[218]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t21=C_mutate((C_word*)lf[219]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t22=C_mutate((C_word*)lf[220]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t23=C_mutate((C_word*)lf[221]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t24=C_mutate((C_word*)lf[222]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t25=C_mutate((C_word*)lf[223]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t26=C_mutate((C_word*)lf[224]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t27=C_mutate((C_word*)lf[225]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t28=C_mutate((C_word*)lf[226]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t29=C_mutate((C_word*)lf[227]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t30=C_mutate((C_word*)lf[228]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t31=C_mutate((C_word*)lf[229]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t32=C_mutate((C_word*)lf[230]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t33=C_mutate((C_word*)lf[231]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t34=C_mutate((C_word*)lf[232]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t35=C_mutate((C_word*)lf[233]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t36=C_mutate((C_word*)lf[234]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t37=C_mutate((C_word*)lf[235]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t38=C_mutate((C_word*)lf[236]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t39=C_mutate((C_word*)lf[237]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t40=C_mutate((C_word*)lf[238]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t41=C_a_i_list(&a,25,*((C_word*)lf[214]+1),*((C_word*)lf[215]+1),*((C_word*)lf[216]+1),*((C_word*)lf[217]+1),*((C_word*)lf[218]+1),*((C_word*)lf[219]+1),*((C_word*)lf[220]+1),*((C_word*)lf[221]+1),*((C_word*)lf[222]+1),*((C_word*)lf[223]+1),*((C_word*)lf[224]+1),*((C_word*)lf[225]+1),*((C_word*)lf[226]+1),*((C_word*)lf[227]+1),*((C_word*)lf[228]+1),*((C_word*)lf[229]+1),*((C_word*)lf[230]+1),*((C_word*)lf[231]+1),*((C_word*)lf[232]+1),*((C_word*)lf[233]+1),*((C_word*)lf[234]+1),*((C_word*)lf[235]+1),*((C_word*)lf[236]+1),*((C_word*)lf[237]+1),*((C_word*)lf[238]+1));
t42=C_mutate((C_word*)lf[239]+1 /* (set! signals-list ...) */,t41);
t43=C_mutate((C_word*)lf[240]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4833,a[2]=((C_word)li120),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[242]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4876,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[243]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4904,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[244]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4910,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[246]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4926,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[248]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4942,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t49=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4976,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t50=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7828,a[2]=((C_word)li269),tmp=(C_word)a,a+=3,tmp);
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7831,a[2]=((C_word)li270),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1007: getter-with-setter */
t52=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t52+1)))(5,t52,t49,t50,t51,lf[455]);}

/* create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4404(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4404r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4404r(t0,t1,t2,t3);}}

static void C_ccall f_4404r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[186]);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4413,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:767: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* setup in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6281(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6281,NULL,4,t1,t2,t3,t4);}
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):C_i_car(t3));
t7=C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:C_i_car(t8));
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6293,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t11,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1498: ##sys#check-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[355]+1)))(4,*((C_word*)lf[355]+1),t14,t2,t4);}

/* f_7089 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7089(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7089,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7097,a[2]=t4,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t7=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1772: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t6,t7);}
else{
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub1834(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE,t7));}}

/* k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4429,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4431,a[2]=t3,a[3]=((C_word)li89),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4431(t5,((C_word*)t0)[2],t1);}

/* k7095 */
static void C_ccall f_7097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1834(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4420(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4420,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}
else{
if(C_truep(((C_word*)t0)[4])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4429,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4468,a[2]=((C_word*)t0)[3],a[3]=((C_word)li90),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4473,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:771: ##sys#call-with-values */
C_call_with_values(4,0,t2,t3,t4);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4481,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:776: g910 */
t3=t2;
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[5],lf[186],((C_word*)t0)[3]);}}}

/* f_4212 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4212(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4212,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4218,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:704: fd_test */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_fix(0),t2);}

/* k4216 */
static void C_ccall f_4218(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4218,2,t0,t1);}
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4414 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4413,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4415,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_block_size(t1);
t4=C_eqp(C_fix(0),t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4420,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
t6=t5;
f_4420(2,t6,t4);}
else{
/* posixunix.scm:769: file-exists? */
t6=*((C_word*)lf[189]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t1);}}

/* f_4441 in k4439 in k4436 in loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4441(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4441,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4454,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:761: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t3,t2);}

/* k4439 in k4436 in loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4440,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4441,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:775: g892 */
t3=t2;
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[2],lf[186],((C_word*)t0)[3]);}

/* k4237 in for-each-loop808 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4238(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4229(t3,((C_word*)t0)[4],t2);}

/* file-type in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2725r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2725r(t0,t1,t2,t3);}}

static void C_ccall f_2725r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2741,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:206: ##sys#stat */
f_2632(t12,t2,t5,t9,lf[22]);}

/* k2722 in file-size in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2723,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* k6456 in k6441 in create-fifo in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mkfifo(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1541: posix-error */
t3=lf[2];
f_2616(7,t3,((C_word*)t0)[3],lf[8],lf[364],lf[365],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4436 in loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4438(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4438,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4440,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4460,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:774: pathname-directory */
t4=*((C_word*)lf[188]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4431(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4431,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4438,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4466,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:773: directory? */
t5=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
t4=t3;
f_4438(t4,C_SCHEME_FALSE);}}

/* for-each-loop808 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4229(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4229,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4238,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:703: g809 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4225 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=((C_word*)((C_word*)t0)[2])[1];
t3=((C_word*)t0)[3];
f_4154(2,t3,t2);}

/* k4459 in k4436 in loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:774: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_4431(t2,((C_word*)t0)[3],t1);}

/* f_4468 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4468,2,t0,t1);}
/* posixunix.scm:771: decompose-pathname */
t2=*((C_word*)lf[77]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* k4465 in loop in k4428 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_4438(t2,C_i_not(t1));}

/* k3723 in k3716 */
static void C_ccall f_3724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posix-common.scm:484: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[111],lf[112],((C_word*)t0)[3]);}}

/* k2954 in port->fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2955,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(lf[29],t2);
if(C_truep(t3)){
/* posix-common.scm:278: ##sys#tcp-port->fileno */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[55]+1)))(3,*((C_word*)lf[55]+1),((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2987,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:279: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[58]+1)))(4,*((C_word*)lf[58]+1),t4,((C_word*)t0)[2],C_fix(0));}}

/* k6478 in fifo? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_fifo_p(t1);
switch(t2){
case C_SCHEME_TRUE:
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_TRUE);
case C_SCHEME_FALSE:
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);
case C_fix(0):
/* posixunix.scm:1551: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[2],lf[8],lf[34],lf[366],((C_word*)t0)[3]);
default:
/* posixunix.scm:1553: posix-error */
t3=lf[2];
f_2616(6,t3,((C_word*)t0)[2],lf[8],lf[34],lf[367],((C_word*)t0)[3]);}}

/* k4453 */
static void C_ccall f_4454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posixunix.scm:762: posix-error */
t4=lf[2];
f_2616(6,t4,((C_word*)t0)[2],lf[8],((C_word*)t0)[3],lf[187],((C_word*)t0)[4]);}}

/* fifo? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6472(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6472,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[34]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6479,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6512,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1548: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t5,t2);}

/* f_4481 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4481(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4481,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4494,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:761: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t3,t2);}

/* k6459 in k6441 in create-fifo in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1540: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[364]);}

/* k4589 in open-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:809: check */
f_4564(((C_word*)t0)[3],lf[195],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k4596 in open-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4597,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixunix.scm:809: check */
f_4564(((C_word*)t0)[3],lf[195],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k3734 in k3716 */
static void C_ccall f_3735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:487: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:488: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[111],lf[113],((C_word*)t0)[3]);}}

/* check in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_2911(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2911,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:262: posix-error */
t6=lf[2];
f_2616(6,t6,t1,lf[8],t2,lf[47],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2923,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:263: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[48]+1)))(6,*((C_word*)lf[48]+1),t6,t4,*((C_word*)lf[49]+1),lf[50],lf[51]);}}

/* f_4473 in k4418 in k4412 in create-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4473,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
/* posixunix.scm:772: make-pathname */
t5=*((C_word*)lf[78]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,t2,t3,t4);}
else{
t5=t2;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k3732 in k3716 */
static void C_ccall f_3733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:483: strftime */
t2=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* file-unlock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6411(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6411,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[354],lf[362]);
t4=C_slot(t2,C_fix(2));
t5=C_slot(t2,C_fix(3));
t6=C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=C_slot(t2,C_fix(1));
t8=C_flock_lock(t7);
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:1530: posix-error */
t9=lf[2];
f_2616(6,t9,t1,lf[8],lf[362],lf[363],t2);}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}}

/* k2704 in file-change-time in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2705,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-owner in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2707(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2707,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2711,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:201: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[19]);}

/* file-change-time in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2701(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2701,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2705,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:200: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[18]);}

/* create-fifo in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6436(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_6436r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6436r(t0,t1,t2,t3);}}

static void C_ccall f_6436r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[364]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6442,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_6442(t7,C_u_i_car(t6));}
else{
t6=C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_6442(t7,C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* loop */
static void C_fcall f_6154(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6154,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6163,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1450: poke */
t7=((C_word*)((C_word*)t0)[5])[1];
f_6023(t7,t6,((C_word*)t0)[6],((C_word*)t0)[4]);}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t2,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_difference(t4,t2);
/* posixunix.scm:1455: loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t4,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[2])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k2935 in open-input-file* in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2936,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:269: check */
f_2911(((C_word*)t0)[4],lf[52],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* open-output-file* in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2938(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2938r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2938r(t0,t1,t2,t3);}}

static void C_ccall f_2938r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[53]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2949,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:273: mode */
f_2875(t5,C_SCHEME_FALSE,t3,lf[53]);}

/* k5385 in k5392 in check in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k7041 in k7039 in get-host-name in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k7039 in get-host-name in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7040,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7042,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}
else{
/* posixunix.scm:1752: posix-error */
t3=lf[2];
f_2616(5,t3,t2,lf[410],lf[414],lf[415]);}}

/* port->fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2951(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2951,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2955,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:277: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[59]+1)))(4,*((C_word*)lf[59]+1),t3,t2,lf[54]);}

/* process-fork in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7049(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_7049r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7049r(t0,t1,t2);}}

static void C_ccall f_7049r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7053,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1761: fork */
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* f_7047 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7047,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1808(C_SCHEME_UNDEFINED));}

/* f_6139 in k6137 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6139(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6139,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_fixnum_difference(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6154,a[2]=((C_word*)t0)[3],a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t2,a[8]=((C_word)li172),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_6154(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1460: poke */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6023(t3,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[3])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6269 in file-truncate in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1481: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[351]);}

/* k5853 in k5844 */
static void C_ccall f_5854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
/* posixunix.scm:1394: values */
C_values(4,0,((C_word*)t0)[4],((C_word*)t0)[5],t2);}

/* k6137 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6138,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[2];
f_6086(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6139,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word)li173),tmp=(C_word)a,a+=7,tmp));}

/* k5392 in check in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5393,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5386,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}
else{
/* posixunix.scm:1216: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}}

/* k2948 in open-output-file* in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2949,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:273: check */
f_2911(((C_word*)t0)[4],lf[53],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k5395 in check in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1215: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k7052 in process-fork in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7053,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1762: posix-error */
t3=lf[2];
f_2616(5,t3,((C_word*)t0)[2],lf[120],lf[416],lf[417]);}
else{
t3=C_i_pairp(((C_word*)t0)[3]);
t4=(C_truep(t3)?C_eqp(t1,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_i_car(((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7073,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1759: g1816 */
t7=t5;
((C_proc2)C_fast_retrieve_proc(t7))(2,t7,t6);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t1);}}}

/* file-read-access? in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5398(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5398,3,t0,t1,t2);}
/* posixunix.scm:1218: check */
f_5378(t1,t2,C_fix((C_word)R_OK),lf[313]);}

/* k6266 in file-truncate in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_truncate(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
f_6255(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* k6260 in file-truncate in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_6255(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* f_6126 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6126(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6126,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_block_size(t2);
/* posixunix.scm:1443: poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6023(t4,t1,t2,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2739 in file-type in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[23]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[24]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[25]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[26]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[27]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[28]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[29]:lf[23]));}}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3716 */
static void C_ccall f_3717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3717,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[111]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3724,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3733,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:483: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,((C_word*)t0)[2],lf[111]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3735,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:485: asctime */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[4]);}}

/* k7020 in k7005 in terminal-size in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
/* posixunix.scm:1740: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
/* posixunix.scm:1741: posix-error */
t3=lf[2];
f_2616(6,t3,((C_word*)t0)[2],lf[410],lf[409],lf[411],((C_word*)t0)[5]);}}

/* k6937 in terminal-port? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6938,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6940,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1713: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[58]+1)))(4,*((C_word*)lf[58]+1),t2,((C_word*)t0)[3],C_fix(0));}

/* f_3710 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3710(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_3710r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3710r(t0,t1,t2,t3);}}

static void C_ccall f_3710r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3717,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:479: check-time-vector */
f_3579(t6,lf[111],t2);}

/* k7024 in k7005 in terminal-size in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7025,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7028,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1739: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[412]+1)))(6,*((C_word*)lf[412]+1),t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[413]);}

/* k7027 in k7024 in k7005 in terminal-size in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1737: ttysize */
t2=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* file-permissions in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2713(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2713,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2717,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:202: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* k2716 in file-permissions in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-size in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2719(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2719,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2723,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:203: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* f_6119 in k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6119,2,t0,t1);}
/* posixunix.scm:1471: store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* k2710 in file-owner in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* terminal-port? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6934(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6934,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6938,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1712: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[59]+1)))(4,*((C_word*)lf[59]+1),t3,t2,lf[405]);}

/* k6106 */
static void C_ccall f_6107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1469: on-close */
t2=((C_word*)t0)[2];
((C_proc2)C_fast_retrieve_proc(t2))(2,t2,((C_word*)t0)[3]);}

/* k5346 in change-file-mode in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1198: posix-error */
t3=lf[2];
f_2616(7,t3,((C_word*)t0)[3],lf[8],lf[309],lf[310],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2971 in k2986 in k2954 in port->fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2972(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3691 in k3686 in local-time->seconds in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:472: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[107],lf[108],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* f_4268 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4268(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4268,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[174]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
/* posixunix.scm:689: fd_set */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,C_fix(1),t2);}

/* f_3698 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3698(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3698,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub501(t3,t2);
/* posix-common.scm:476: ##sys#peek-c-string */
t5=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,C_fix(0));}

/* k2986 in k2954 in port->fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2987(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2987,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:284: posix-error */
t2=lf[2];
f_2616(6,t2,((C_word*)t0)[2],lf[13],lf[54],lf[56],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2972,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:282: posix-error */
t4=lf[2];
f_2616(6,t4,t3,lf[8],lf[54],lf[57],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* change-file-owner in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5352(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5352,5,t0,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,lf[311]);
t6=C_i_check_exact_2(t3,lf[311]);
t7=C_i_check_exact_2(t4,lf[311]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5373,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5376,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1205: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t2);}

/* k5349 in change-file-mode in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1197: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[309]);}

/* k7553 */
static void C_ccall f_7554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1933: input-port */
t2=((C_word*)t0)[2];
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8],*((C_word*)lf[37]+1),t1);}

/* k7550 in k7538 */
static void C_ccall f_7551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1935: output-port */
t2=((C_word*)t0)[2];
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8],*((C_word*)lf[38]+1),t1);}

/* local-time->seconds in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3683(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3683,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3687,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:469: check-time-vector */
f_3579(t3,lf[107],t2);}

/* k3686 in local-time->seconds in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3687,2,t0,t1);}
t2=C_a_mktime(&a,1,((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3693,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:471: fp= */
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[110],t2);}

/* set-signal-handler! in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3758(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3758,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[114]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(*((C_word*)lf[115]+1),t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(*((C_word*)lf[115]+1),t2,t3));}}

/* change-file-mode in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5328(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5328,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[309]);
t5=C_i_check_exact_2(t3,lf[309]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5347,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5350,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1197: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* f_7564 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7564(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[23],*a=ab;
if(c!=8) C_bad_argc_2(c,8,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr8,(void*)f_7564,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7566,a[2]=t2,a[3]=((C_word)li253),tmp=(C_word)a,a+=4,tmp);
t11=C_i_check_string_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7601,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t1,a[8]=t7,a[9]=t10,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixunix.scm:1954: chkstrlst */
t13=t10;
((C_proc3)(void*)(*((C_word*)t13+1)))(3,t13,t12,((C_word*)t9)[1]);}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7621,a[2]=t9,a[3]=t8,a[4]=t12,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1956: ##sys#shell-command-arguments */
t14=*((C_word*)lf[429]+1);
((C_proc3)(void*)(*((C_word*)t14+1)))(3,t14,t13,((C_word*)t8)[1]);}}

/* f_7566 */
static void C_ccall f_7566(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7566,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7570,a[2]=((C_word*)t0)[2],a[3]=((C_word)li251),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7579,a[2]=t7,a[3]=t4,a[4]=((C_word)li252),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_7579(t9,t1,t5);}

/* signal-unmask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4926(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4926,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[246]);
t4=C_sigdelset(t2);
t5=C_sigprocmask_unblock(C_fix(0));
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:983: posix-error */
t6=lf[2];
f_2616(5,t6,t1,lf[120],lf[246],lf[247]);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* open-input-file* in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2925(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2925r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2925r(t0,t1,t2,t3);}}

static void C_ccall f_2925r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[52]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2936,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:269: mode */
f_2875(t5,C_SCHEME_TRUE,t3,lf[52]);}

/* k5194 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5195(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1114: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[261],lf[264]);}

/* k2922 in check in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2923(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* f_3704 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3704(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3704,4,t0,t1,t2,t3);}
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=stub507(t4,t2,t3);
/* posix-common.scm:477: ##sys#peek-c-string */
t6=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* k5844 */
static void C_ccall f_5845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5845,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[3]);
t3=C_eqp(((C_word*)t0)[4],((C_word*)t0)[3]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5854,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1393: fetch */
t5=((C_word*)t0)[7];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(((C_word*)t0)[8],C_fix(4));
t5=C_fixnum_plus(t4,C_fix(1));
t6=C_i_set_i_slot(((C_word*)t0)[8],C_fix(4),t5);
t7=C_i_set_i_slot(((C_word*)t0)[8],C_fix(5),C_fix(0));
/* posixunix.scm:1398: values */
C_values(4,0,((C_word*)t0)[6],t1,C_SCHEME_FALSE);}}

/* k6708 in k6696 in unmap-file-from-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
/* posixunix.scm:1629: posix-error */
t3=lf[2];
f_2616(7,t3,((C_word*)t0)[2],lf[8],lf[386],lf[387],((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* f_5840 in loop */
static void C_ccall f_5840(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5840,4,t0,t1,t2,t3);}
t4=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5845,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=t1,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
t6=C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[6];
t8=t5;
f_5845(2,t8,(C_truep(t7)?t7:lf[342]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5881,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[5],a[6]=t4,a[7]=((C_word*)t0)[6],a[8]=t5,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1383: ##sys#make-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(3,*((C_word*)lf[66]+1),t7,t4);}}

/* signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4910(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4910,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[244]);
t4=C_sigaddset(t2);
t5=C_sigprocmask_block(C_fix(0));
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:977: posix-error */
t6=lf[2];
f_2616(5,t6,t1,lf[120],lf[244],lf[245]);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k3290 in k3284 */
static void C_ccall f_3291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3291,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3293,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li32),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3293(t5,((C_word*)t0)[6],t1);}

/* loop in k3290 in k3284 */
static void C_fcall f_3293(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3293,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:377: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3263(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3308,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:378: irregex-match */
t5=*((C_word*)lf[80]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[6],t4);}}

/* signal-masked? in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4904(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4904,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[243]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_sigismember(t2));}

/* k5169 in loop in k5150 in k5148 in k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5170,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k5177 in k5148 in k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1119: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[261],lf[262]);}

/* k5091 in k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5092,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5095,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5097,a[2]=t4,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_5097(t6,t2,C_fix(0));}

/* k5094 in k5091 in k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1082: g1150 */
t2=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_fix((C_word)C_group->gr_gid),t1);}

/* loop in k5091 in k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_5097(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5097,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5101,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub1130(t5,t6);
/* posixunix.scm:1079: ##sys#peek-c-string */
t8=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* memory-mapped-file? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6730(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6730,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_i_structurep(t2,lf[381]));}

/* f_7030 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7030,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1801(t2);
/* posixunix.scm:1746: ##sys#peek-c-string */
t4=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t3,C_fix(0));}

/* get-host-name in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7036,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7040,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1750: getit */
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k5880 */
static void C_ccall f_5881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=C_substring_copy(((C_word*)t0)[2],t1,((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4],C_fix(0));
t3=C_slot(((C_word*)t0)[5],C_fix(5));
t4=C_fixnum_plus(t3,((C_word*)t0)[6]);
t5=C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[7])){
/* posixunix.scm:1389: ##sys#string-append */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[343]+1)))(4,*((C_word*)lf[343]+1),((C_word*)t0)[8],((C_word*)t0)[7],t1);}
else{
t6=t1;
t7=((C_word*)t0)[8];
f_5845(2,t7,t6);}}

/* f_6742 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6742(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6742,4,t0,t1,t2,t3);}
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=stub1678(t4,t2,t3);
/* posixunix.scm:1642: ##sys#peek-c-string */
t6=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* time->string in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6748(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_6748r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6748r(t0,t1,t2,t3);}}

static void C_ccall f_6748r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6755,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1644: check-time-vector */
f_3579(t6,lf[111],t2);}

/* memory-mapped-file-pointer in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6721(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6721,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[381],lf[388]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(t2,C_fix(1)));}

/* glob in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3257(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_3257r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3257r(t0,t1,t2);}}

static void C_ccall f_3257r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3263,a[2]=t4,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3263(t6,t1,t2);}

/* terminal-size in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7002(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7002,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7006,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1733: ##sys#terminal-check */
f_6951(t3,lf[409],t2);}

/* k7005 in terminal-size in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7006,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7021,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_C_fileno(((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7025,a[2]=((C_word*)t0)[4],a[3]=t4,a[4]=t5,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1738: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[412]+1)))(6,*((C_word*)lf[412]+1),t6,t2,C_fix(0),C_SCHEME_FALSE,lf[413]);}

/* f_6736 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6736(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6736,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub1672(t3,t2);
/* posixunix.scm:1641: ##sys#peek-c-string */
t5=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,C_fix(0));}

/* f_7381 */
static void C_ccall f_7381(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7381,2,t0,t1);}
t2=C_i_vector_set(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE);
t3=C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[4]);
t4=(C_truep(t3)?C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7395,a[2]=((C_word*)t0)[6],a[3]=((C_word)li234),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7400,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[6],a[4]=((C_word)li235),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1879: ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k2997 in duplicate-fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_2998(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2998,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3000,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:295: posix-error */
t3=lf[2];
f_2616(6,t3,t2,lf[8],lf[60],lf[61],((C_word*)t0)[3]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k6162 in loop */
static void C_ccall f_6163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* posixunix.scm:1452: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6154(t3,((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);}

/* duplicate-fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2992(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2992r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2992r(t0,t1,t2,t3);}}

static void C_ccall f_2992r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[60]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2998,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_2998(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[60]);
t8=t5;
f_2998(t8,C_dup2(t2,t6));}}

/* k3441 in k3438 */
static void C_ccall f_3442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:414: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3443 in k3438 */
static void C_ccall f_3445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:415: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:414: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3367(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k6770 in k6754 in time->string in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1648: strftime */
t2=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* f_3433 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3433,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3439,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3451,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:414: make-pathname */
t4=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[86]);}

/* f_7379 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7379(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(c!=8) C_bad_argc_2(c,8,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr8,(void*)f_7379,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7381,a[2]=t4,a[3]=t5,a[4]=t6,a[5]=t7,a[6]=t3,a[7]=t2,a[8]=((C_word)li236),tmp=(C_word)a,a+=9,tmp));}

/* k6761 in k6754 in time->string in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm:1649: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[111],lf[390],((C_word*)t0)[3]);}}

/* group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5071(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_5071r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5071r(t0,t1,t2,t3);}}

static void C_ccall f_5071r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5078,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_5078(t7,C_getgrgid(t2));}
else{
t7=C_i_check_string_2(t2,lf[260]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5121,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1087: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t8,t2,lf[260]);}}

/* k3438 */
static void C_ccall f_3439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3439,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3442,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3445,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:415: pproc */
t4=((C_word*)t0)[7];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[5]);}

/* k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_5078(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5078,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[256]+1):*((C_word*)lf[257]+1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5089,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k7501 */
static void C_ccall f_7502(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1920: ##sys#custom-input-port */
t2=*((C_word*)lf[329]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k6772 in k6754 in time->string in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm:1652: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posixunix.scm:1653: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[111],lf[391],((C_word*)t0)[3]);}}

/* k7374 */
static void C_ccall f_7375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1872: file-close */
t2=*((C_word*)lf[164]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k3463 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:416: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:416: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3367(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3461 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:416: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5089,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5092,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* f_7509 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_7509,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7512,a[2]=t1,a[3]=t2,a[4]=t4,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1923: connect-parent */
t10=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t10+1)))(6,t10,t9,t2,t5,t6,t7);}

/* k4536 in change-directory* in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* change-directory* in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4531(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4531,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[191]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4537,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_fchdir(t2);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t2);}
else{
/* posixunix.scm:790: posix-error */
t7=lf[2];
f_2616(6,t7,t4,lf[8],lf[191],lf[192],t2);}}

/* f_3453 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3453,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3450 */
static void C_ccall f_3451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:414: glob */
t2=*((C_word*)lf[76]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4528 in change-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:782: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[63]);}

/* k6754 in time->string in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6755,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[111]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6762,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6771,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1648: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,((C_word*)t0)[2],lf[111]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6773,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1650: asctime */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[4]);}}

/* f_7395 */
static void C_ccall f_7395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7395,2,t0,t1);}
/* posixunix.scm:1879: process-wait */
t2=*((C_word*)lf[118]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* k3481 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3483,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3489,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:417: action */
t3=((C_word*)t0)[5];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
/* posix-common.scm:418: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k5372 in change-file-owner in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5373(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chown(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1206: posix-error */
t3=lf[2];
f_2616(8,t3,((C_word*)t0)[4],lf[8],lf[311],lf[312],((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5375 in change-file-owner in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1205: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[311]);}

/* check in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_5378(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5378,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5393,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5396,a[2]=t6,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1215: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k3488 in k3481 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:417: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k4518 in k4516 in change-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4519(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4516 in change-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4517,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4519,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[3]);}
else{
/* posixunix.scm:784: posix-error */
t5=lf[2];
f_2616(6,t5,t2,lf[8],lf[63],lf[190],((C_word*)t0)[3]);}}

/* change-directory in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4511(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4511,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[63]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4517,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4529,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:782: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t5,t2);}

/* f_7367 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7367(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7367,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t4,t3);
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7375,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1871: duplicate-fileno */
t7=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,t3,t4);}}

/* k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3471,2,t0,t1);}
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3405,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3408,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:410: pproc */
t5=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t5))(3,t5,t4,((C_word*)t0)[7]);}
else{
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3417,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:411: lproc */
t4=((C_word*)t0)[11];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* k5120 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5078(t2,C_getgrnam(t1));}

/* k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3477,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[84]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[85]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:408: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3471,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:409: symbolic-link? */
t3=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* open-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4578(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_4578r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4578r(t0,t1,t2,t3);}}

static void C_ccall f_4578r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[195]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[196]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4591,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[196]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4597,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:813: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[195]);}
else{
t9=C_eqp(t6,lf[197]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4606,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:814: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t10,t2,lf[195]);}
else{
/* posixunix.scm:798: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[198],t6);}}}

/* k4575 in check in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3494 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:401: glob */
t2=*((C_word*)lf[76]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* f_6796 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6796(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6796,5,t0,t1,t2,t3,t4);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1706(C_SCHEME_UNDEFINED,t2,t3,t4));}

/* string->time in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6798(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6798r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6798r(t0,t1,t2,t3);}}

static void C_ccall f_6798r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?lf[393]:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[392]);
t7=C_i_check_string_2(t5,lf[392]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6813,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1660: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t8,t2,lf[392]);}

/* f_3639 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3639(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3639,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_integer_argumentp(t2);
t5=stub476(t3,t4);
/* posix-common.scm:460: ##sys#peek-c-string */
t6=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* check in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4564(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4564,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:801: posix-error */
t6=lf[2];
f_2616(6,t6,t1,lf[8],t2,lf[193],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4576,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:802: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[48]+1)))(6,*((C_word*)lf[48]+1),t6,t4,*((C_word*)lf[49]+1),lf[194],lf[51]);}}

/* k7949 */
static void C_ccall f_7950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:191: g113 */
t2=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[4]);}

/* k3621 in seconds->utc-time in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[104]);
/* posix-common.scm:457: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[102]+1)))(4,*((C_word*)lf[102]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* f_7570 */
static void C_ccall f_7570(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7570,3,t0,t1,t2);}
t3=*((C_word*)lf[434]+1);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* k3651 in seconds->string in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3653,2,t0,t1);}
t2=C_i_check_number_2(t1,lf[105]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3657,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:463: ctime */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* for-each-loop2037 */
static void C_fcall f_7579(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7579,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7588,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:1951: g2038 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3656 in k3651 in seconds->string in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:465: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:466: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[105],lf[106],((C_word*)t0)[3]);}}

/* k7511 */
static void C_ccall f_7512(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1924: ##sys#custom-output-port */
t2=*((C_word*)lf[347]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k7587 in for-each-loop2037 */
static void C_ccall f_7588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_7579(t3,((C_word*)t0)[4],t2);}

/* seconds->string in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3648(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3648r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3648r(t0,t1,t2);}}

static void C_ccall f_3648r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3653,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:461: current-seconds */
t4=*((C_word*)lf[103]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_3653(2,t4,C_i_car(t2));}}

/* f_7525 in process in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7525,2,t0,t1);}
/* posixunix.scm:1927: spawn */
t2=((C_word*)t0)[2];
f_7463(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9]);}

/* ##sys#process in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7519(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_7519,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7525,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=t4,a[6]=t5,a[7]=t6,a[8]=t7,a[9]=t8,a[10]=((C_word)li248),tmp=(C_word)a,a+=11,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7530,a[2]=t7,a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word)li249),tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1867: ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* k5027 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_4997(t2,C_getpwnam(t1));}

/* f_7910 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7910(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7910,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[98]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_umask(t2));}

/* f_7530 in process in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7530(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[27],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7530,6,t0,t1,t2,t3,t4,t5);}
t6=C_i_not(((C_word*)t0)[2]);
t7=C_i_not(((C_word*)t0)[3]);
t8=C_i_not(((C_word*)t0)[4]);
t9=C_a_i_vector3(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_7539,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[8],a[10]=t9,a[11]=((C_word*)t0)[9],a[12]=t3,a[13]=((C_word*)t0)[3],tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7554,a[2]=((C_word*)t0)[5],a[3]=t10,a[4]=((C_word*)t0)[6],a[5]=t5,a[6]=((C_word*)t0)[7],a[7]=t2,a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1934: make-on-close */
t12=((C_word*)t0)[8];
((C_proc8)(void*)(*((C_word*)t12+1)))(8,t12,t11,((C_word*)t0)[6],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k3404 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_3405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:410: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k5019 in k5016 in k5013 in k5010 in k5007 in k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1052: g1124 */
t2=((C_word*)t0)[2];
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k3406 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_3408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:410: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:410: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3367(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k7336 in k7334 in process-run in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7337,2,t0,t1);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:1843: process-execute */
t3=*((C_word*)lf[419]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7355,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1845: ##sys#shell-command */
t4=*((C_word*)lf[425]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7334 in process-run in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_7335(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7335,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7337,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1841: process-fork */
t3=*((C_word*)lf[416]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* current-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5036,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5043,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5046,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1069: current-user-id */
t4=*((C_word*)lf[251]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* f_7920 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7920(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[13],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7920,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[460]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7924,a[2]=((C_word)li276),tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7938,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7950,a[2]=t5,a[3]=t6,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:192: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k7544 in k7541 in k7538 */
static void C_ccall f_7545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1932: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k7541 in k7538 */
static void C_ccall f_7542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7542,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7545,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7548,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1939: make-on-close */
t4=((C_word*)t0)[10];
((C_proc8)(void*)(*((C_word*)t4+1)))(8,t4,t3,((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[11],C_fix(2),C_fix(0),C_fix(1));}

/* k7538 */
static void C_ccall f_7539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7539,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7542,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7551,a[2]=((C_word*)t0)[11],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[12],a[8]=((C_word*)t0)[13],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1936: make-on-close */
t4=((C_word*)t0)[9];
((C_proc8)(void*)(*((C_word*)t4+1)))(8,t4,t3,((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[10],C_fix(1),C_fix(0),C_fix(2));}

/* process-run in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7331(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7331r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7331r(t0,t1,t2,t3);}}

static void C_ccall f_7331r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7335,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_7335(t6,C_u_i_car(t5));}
else{
t5=t4;
f_7335(t5,C_SCHEME_FALSE);}}

/* seconds->utc-time in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3618(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3618r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3618r(t0,t1,t2);}}

static void C_ccall f_3618r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3623,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:455: current-seconds */
t4=*((C_word*)lf[103]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[104]);
/* posix-common.scm:457: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[102]+1)))(4,*((C_word*)lf[102]+1),t1,t4,C_SCHEME_TRUE);}}

/* k7917 */
static void C_ccall f_7918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7918,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* f_7915 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7915(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7915,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7918,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:188: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[16]);}

/* doloop1877 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_fcall f_7191(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7191,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1790: setenv */
t4=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[419]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7208,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1793: setenv */
t8=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,t3,t4,t7);}}

/* k5045 in current-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1069: user-information */
t2=*((C_word*)lf[255]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* current-effective-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5048,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5055,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5058,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1072: current-effective-user-id */
t4=*((C_word*)lf[252]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* f_3428 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3428,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3424 in k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_3426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:412: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3367(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k5042 in current-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5043(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* k4370 in k4359 in k4353 in set-file-position! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4372(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[51]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];
f_4366(2,t5,t4);}
else{
t4=((C_word*)t0)[5];
f_4366(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];
f_4366(2,t3,t2);}
else{
/* posixunix.scm:737: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[5],lf[13],lf[179],lf[181],((C_word*)t0)[2]);}}}

/* k3600 in seconds->local-time in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[101]);
/* posix-common.scm:453: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[102]+1)))(4,*((C_word*)lf[102]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* k7547 in k7541 in k7538 */
static void C_ccall f_7548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1938: input-port */
t2=((C_word*)t0)[2];
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8],*((C_word*)lf[39]+1),t1);}

/* k7927 */
static void C_ccall f_7929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub117(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]));}

/* f_7924 */
static void C_ccall f_7924(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7924,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7929,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t5=C_i_foreign_string_argumentp(t2);
/* posix-common.scm:191: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t4,t5);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub117(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t3));}}

/* k7354 in k7336 in k7334 in process-run in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7355,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7358,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1845: ##sys#shell-command-arguments */
t3=*((C_word*)lf[429]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k5100 in loop in k5091 in k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5101(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5101,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5110,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:1096: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_5097(t4,t2,t3);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k7357 in k7354 in k7336 in k7334 in process-run in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1845: process-execute */
t2=*((C_word*)lf[419]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* f_3277 in conc-loop in glob in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3277,2,t0,t1);}
/* posix-common.scm:374: decompose-pathname */
t2=*((C_word*)lf[77]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* k3415 in k3469 in k3476 in k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_3417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3417,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3426,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3428,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word)li36),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3433,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word)li37),tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3453,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=((C_word)li38),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:413: ##sys#dynamic-wind */
t10=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t6,t7,t8,t9);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3462,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3465,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:416: pproc */
t4=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* k7936 */
static void C_ccall f_7938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:194: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],lf[460],lf[461],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* conc-loop in glob in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3263(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3263,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3277,a[2]=t3,a[3]=((C_word)li30),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3282,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li33),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:373: ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* k5109 in k5100 in loop in k5091 in k5088 in k5077 in group-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5110,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* ##sys#shell-command-arguments in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7325(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7325,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list2(&a,2,lf[430],t2));}

/* k7319 in shell-command in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[426]);}}

/* k3284 */
static void C_ccall f_3285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3285,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3291,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
t3=((C_word*)t0)[4];
/* posix-common.scm:376: directory */
t4=*((C_word*)lf[25]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}
else{
/* posix-common.scm:376: directory */
t3=*((C_word*)lf[25]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[81],C_SCHEME_TRUE);}}

/* doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_7153(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7153,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7162,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1785: setarg */
t5=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[419]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7226,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1804: setarg */
t8=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,t3,t4,t7);}}

/* f_3282 in conc-loop in glob in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3282,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3285,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3345,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t7=t3;
/* posix-common.scm:375: make-pathname */
t8=*((C_word*)lf[78]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}
else{
/* posix-common.scm:375: make-pathname */
t7=*((C_word*)lf[78]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,C_SCHEME_FALSE,lf[83],t4);}}

/* k7838 */
static void C_ccall f_7839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1012: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[448],lf[454],((C_word*)t0)[3]);}

/* k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7148,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7153,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t3,a[9]=((C_word)li224),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_7153(t5,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(1));}

/* k6357 in file-lock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_flock_lock(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1511: err */
f_6339(((C_word*)t0)[4],lf[357],t1,lf[356]);}
else{
t3=t1;
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7145,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7148,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=C_block_size(t1);
/* posixunix.scm:1781: setarg */
t4=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,C_fix(0),t1,t3);}

/* file-lock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6354(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6354r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6354r(t0,t1,t2,t3);}}

static void C_ccall f_6354r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6358,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1509: setup */
f_6281(t4,t2,t3,lf[356]);}

/* f_7831 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7831(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7831,3,t0,t1,t2);}
t3=C_setuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7839,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1011: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k5148 in k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5149,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5151,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=stub1158(C_SCHEME_UNDEFINED,t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5178,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1118: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t5);}
else{
t5=t2;
f_5151(2,t5,C_SCHEME_UNDEFINED);}}

/* k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5147,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5149,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
if(C_truep(stub1163(C_SCHEME_UNDEFINED,t3))){
t4=t2;
f_5149(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1116: ##sys#error */
t4=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[261],lf[263]);}}

/* get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5143(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5143,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5147,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5195,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1113: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=t3;
f_5147(2,t4,C_SCHEME_UNDEFINED);}}

/* k5016 in k5013 in k5010 in k5007 in k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5017,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5020,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k5010 in k5007 in k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5011,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5014,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k5013 in k5010 in k5007 in k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5014,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5017,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k4359 in k4353 in set-file-position! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4360,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4366,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4372,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:731: port? */
t4=*((C_word*)lf[182]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* k4364 in k4359 in k4353 in set-file-position! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4366(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:738: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],lf[179],lf[180],((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k7804 */
static void C_ccall f_7805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1031: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[448],lf[449],((C_word*)t0)[3]);}

/* loop in k5150 in k5148 in k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_5156(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5156,NULL,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_get_gid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5170,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:1123: loop */
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

/* k5150 in k5148 in k5146 in get-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5151,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5156,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li132),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5156(t5,((C_word*)t0)[3],C_fix(0));}

/* k3226 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:345: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[25]);}

/* err in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6339(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6339,NULL,4,t1,t2,t3,t4);}
t5=C_slot(t3,C_fix(1));
t6=C_slot(t3,C_fix(2));
t7=C_slot(t3,C_fix(3));
/* posixunix.scm:1506: posix-error */
t8=lf[2];
f_2616(8,t8,t1,lf[8],t4,t2,t5,t6,t7);}

/* f_7814 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7814(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7814,3,t0,t1,t2);}
t3=C_seteuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7822,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1020: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* f_7811 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7811(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7811,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1094(C_SCHEME_UNDEFINED));}

/* f_7109 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7109,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7117,a[2]=t4,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t7=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1774: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t6,t7);}
else{
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub1846(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE,t7));}}

/* f_7107 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7107,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1841(C_SCHEME_UNDEFINED));}

/* k5054 in current-effective-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* k5057 in current-effective-user-name in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1072: user-information */
t2=*((C_word*)lf[255]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7115 */
static void C_ccall f_7117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1846(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* file-stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2673(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2673r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2673r(t0,t1,t2,t3);}}

static void C_ccall f_2673r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2680,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:178: ##sys#stat */
f_2632(t6,t2,t5,C_SCHEME_TRUE,lf[15]);}

/* process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7129(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_7129r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7129r(t0,t1,t2,t3);}}

static void C_ccall f_7129r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(10);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_END_OF_LIST:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_check_string_2(t2,lf[419]);
t13=C_i_check_list_2(t5,lf[419]);
t14=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7145,a[2]=t9,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t1,a[9]=t5,tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm:1780: pathname-strip-directory */
t15=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t15+1)))(3,t15,t14,t2);}

/* f_7127 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7127,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1853(C_SCHEME_UNDEFINED));}

/* file-access-time in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2695(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2695,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2699,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:199: ##sys#stat */
f_2632(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[17]);}

/* k2698 in file-access-time in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2699,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* k5007 in k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5008,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5011,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2693,2,t0,t1);}
t2=C_mutate((C_word*)lf[16]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate((C_word*)lf[17]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2695,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[18]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2701,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[19]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2707,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[20]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2713,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[21]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2719,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[22]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2725,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[30]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2809,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[31]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2818,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[32]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2827,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[33]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2836,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[34]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2845,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[35]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2854,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[36]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2863,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[37]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t17=C_mutate((C_word*)lf[38]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t18=C_mutate((C_word*)lf[39]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t19=C_SCHEME_UNDEFINED;
t20=(*a=C_VECTOR_TYPE|1,a[1]=t19,tmp=(C_word)a,a+=2,tmp);
t21=C_SCHEME_UNDEFINED;
t22=(*a=C_VECTOR_TYPE|1,a[1]=t21,tmp=(C_word)a,a+=2,tmp);
t23=C_set_block_item(t20,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2875,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t24=C_set_block_item(t22,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2911,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[52]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2925,a[2]=t22,a[3]=t20,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t26=C_mutate((C_word*)lf[53]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2938,a[2]=t22,a[3]=t20,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t27=C_mutate((C_word*)lf[54]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2951,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[60]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2992,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[62]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3015,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[67]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3048,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[25]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3133,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[76]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3257,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[71]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3532,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t34=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3577,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t35=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7890,a[2]=((C_word)li273),tmp=(C_word)a,a+=3,tmp);
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7910,a[2]=((C_word)li274),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:432: getter-with-setter */
t37=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t37+1)))(5,t37,t34,t35,t36,lf[459]);}

/* k2664 in stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:161: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k2667 in stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:162: ##sys#platform-fixup-pathname */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[11]+1)))(3,*((C_word*)lf[11]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7316,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7320,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1833: get-environment-variable */
t3=*((C_word*)lf[427]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[428]);}

/* k2679 in file-stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2680,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* k6696 in unmap-file-from-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6697(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6697,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6709,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_slot(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:1628: munmap */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,t1);}

/* unmap-file-from-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6691(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6691r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6691r(t0,t1,t2,t3);}}

static void C_ccall f_6691r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=C_i_check_structure_2(t2,lf[381],lf[386]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6697,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_6697(t7,C_u_i_car(t6));}
else{
t6=t5;
f_6697(t6,C_slot(t2,C_fix(2)));}}

/* for-each-loop749 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4323(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4323,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4332,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:673: g750 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4353 in set-file-position! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4354(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4354,NULL,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[179]);
t3=C_i_check_exact_2(t1,lf[179]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4360,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:730: ##sys#signal-hook */
t6=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,t4,lf[183],lf[179],lf[184],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t6=t4;
f_4360(2,t6,C_SCHEME_UNDEFINED);}}

/* set-file-position! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4350(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4350r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4350r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4350r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4354,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4354(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4354(t6,C_fix((C_word)SEEK_SET));}}

/* f_3893 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3893(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3893,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=C_i_foreign_fixnum_argumentp(t3);
t7=C_i_foreign_integer_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub651(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3384)){
C_save(t1);
C_rereclaim2(3384*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,463);
lf[0]=C_h_intern(&lf[0],17,"\003syspeek-c-string");
lf[1]=C_h_intern(&lf[1],13,"string-append");
lf[3]=C_h_intern(&lf[3],15,"\003syssignal-hook");
lf[4]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[5]=C_h_intern(&lf[5],16,"\003sysupdate-errno");
lf[6]=C_h_intern(&lf[6],15,"\003sysposix-error");
lf[8]=C_h_intern(&lf[8],11,"\000file-error");
lf[9]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[10]=C_h_intern(&lf[10],17,"\003sysmake-c-string");
lf[11]=C_h_intern(&lf[11],27,"\003sysplatform-fixup-pathname");
lf[12]=C_h_intern(&lf[12],20,"\003sysexpand-home-path");
lf[13]=C_h_intern(&lf[13],11,"\000type-error");
lf[14]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[15]=C_h_intern(&lf[15],9,"file-stat");
lf[16]=C_h_intern(&lf[16],22,"file-modification-time");
lf[17]=C_h_intern(&lf[17],16,"file-access-time");
lf[18]=C_h_intern(&lf[18],16,"file-change-time");
lf[19]=C_h_intern(&lf[19],10,"file-owner");
lf[20]=C_h_intern(&lf[20],16,"file-permissions");
lf[21]=C_h_intern(&lf[21],9,"file-size");
lf[22]=C_h_intern(&lf[22],9,"file-type");
lf[23]=C_h_intern(&lf[23],12,"regular-file");
lf[24]=C_h_intern(&lf[24],13,"symbolic-link");
lf[25]=C_h_intern(&lf[25],9,"directory");
lf[26]=C_h_intern(&lf[26],16,"character-device");
lf[27]=C_h_intern(&lf[27],12,"block-device");
lf[28]=C_h_intern(&lf[28],4,"fifo");
lf[29]=C_h_intern(&lf[29],6,"socket");
lf[30]=C_h_intern(&lf[30],13,"regular-file\077");
lf[31]=C_h_intern(&lf[31],14,"symbolic-link\077");
lf[32]=C_h_intern(&lf[32],13,"block-device\077");
lf[33]=C_h_intern(&lf[33],17,"character-device\077");
lf[34]=C_h_intern(&lf[34],5,"fifo\077");
lf[35]=C_h_intern(&lf[35],7,"socket\077");
lf[36]=C_h_intern(&lf[36],10,"directory\077");
lf[37]=C_h_intern(&lf[37],12,"fileno/stdin");
lf[38]=C_h_intern(&lf[38],13,"fileno/stdout");
lf[39]=C_h_intern(&lf[39],13,"fileno/stderr");
lf[40]=C_h_intern(&lf[40],7,"\000append");
lf[41]=C_h_intern(&lf[41],9,"\003syserror");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[43]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[44]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[48]=C_h_intern(&lf[48],13,"\003sysmake-port");
lf[49]=C_h_intern(&lf[49],21,"\003sysstream-port-class");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[51]=C_h_intern(&lf[51],6,"stream");
lf[52]=C_h_intern(&lf[52],16,"open-input-file\052");
lf[53]=C_h_intern(&lf[53],17,"open-output-file\052");
lf[54]=C_h_intern(&lf[54],12,"port->fileno");
lf[55]=C_h_intern(&lf[55],20,"\003systcp-port->fileno");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[57]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[58]=C_h_intern(&lf[58],25,"\003syspeek-unsigned-integer");
lf[59]=C_h_intern(&lf[59],19,"\003syscheck-open-port");
lf[60]=C_h_intern(&lf[60],16,"duplicate-fileno");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[62]=C_h_intern(&lf[62],17,"current-directory");
lf[63]=C_h_intern(&lf[63],16,"change-directory");
lf[64]=C_h_intern(&lf[64],13,"\003syssubstring");
lf[65]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[66]=C_h_intern(&lf[66],15,"\003sysmake-string");
lf[67]=C_h_intern(&lf[67],16,"delete-directory");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[69]=C_h_intern(&lf[69],11,"delete-file");
lf[70]=C_h_intern(&lf[70],8,"for-each");
lf[71]=C_h_intern(&lf[71],10,"find-files");
lf[72]=C_h_intern(&lf[72],9,"\000dotfiles");
lf[73]=C_h_intern(&lf[73],16,"\000follow-symlinks");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[75]=C_h_intern(&lf[75],16,"\003sysmake-pointer");
lf[76]=C_h_intern(&lf[76],4,"glob");
lf[77]=C_h_intern(&lf[77],18,"decompose-pathname");
lf[78]=C_h_intern(&lf[78],13,"make-pathname");
lf[79]=C_h_intern(&lf[79],23,"irregex-match-substring");
lf[80]=C_h_intern(&lf[80],13,"irregex-match");
lf[81]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[82]=C_h_intern(&lf[82],16,"\003sysglob->regexp");
lf[83]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[87]=C_h_intern(&lf[87],16,"\003sysdynamic-wind");
lf[88]=C_h_intern(&lf[88],13,"pathname-file");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[91]=C_h_intern(&lf[91],7,"irregex");
lf[92]=C_h_intern(&lf[92],8,"irregex\077");
lf[93]=C_h_intern(&lf[93],15,"\003sysget-keyword");
lf[94]=C_h_intern(&lf[94],6,"\000limit");
lf[95]=C_h_intern(&lf[95],5,"\000seed");
lf[96]=C_h_intern(&lf[96],7,"\000action");
lf[97]=C_h_intern(&lf[97],5,"\000test");
lf[98]=C_h_intern(&lf[98],18,"file-creation-mode");
lf[100]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[101]=C_h_intern(&lf[101],19,"seconds->local-time");
lf[102]=C_h_intern(&lf[102],18,"\003sysdecode-seconds");
lf[103]=C_h_intern(&lf[103],15,"current-seconds");
lf[104]=C_h_intern(&lf[104],17,"seconds->utc-time");
lf[105]=C_h_intern(&lf[105],15,"seconds->string");
lf[106]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[107]=C_h_intern(&lf[107],19,"local-time->seconds");
lf[108]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[109]=C_h_intern(&lf[109],3,"fp=");
lf[110]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[111]=C_h_intern(&lf[111],12,"time->string");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[113]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[114]=C_h_intern(&lf[114],19,"set-signal-handler!");
lf[115]=C_h_intern(&lf[115],17,"\003syssignal-vector");
lf[116]=C_h_intern(&lf[116],14,"signal-handler");
lf[117]=C_h_intern(&lf[117],18,"current-process-id");
lf[118]=C_h_intern(&lf[118],12,"process-wait");
lf[119]=C_h_intern(&lf[119],16,"\003sysprocess-wait");
lf[120]=C_h_intern(&lf[120],14,"\000process-error");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[122]=C_h_intern(&lf[122],21,"\003sysfile-nonblocking!");
lf[123]=C_h_intern(&lf[123],19,"\003sysfile-select-one");
lf[124]=C_h_intern(&lf[124],8,"pipe/buf");
lf[125]=C_h_intern(&lf[125],11,"fcntl/dupfd");
lf[126]=C_h_intern(&lf[126],11,"fcntl/getfd");
lf[127]=C_h_intern(&lf[127],11,"fcntl/setfd");
lf[128]=C_h_intern(&lf[128],11,"fcntl/getfl");
lf[129]=C_h_intern(&lf[129],11,"fcntl/setfl");
lf[130]=C_h_intern(&lf[130],11,"open/rdonly");
lf[131]=C_h_intern(&lf[131],11,"open/wronly");
lf[132]=C_h_intern(&lf[132],9,"open/rdwr");
lf[133]=C_h_intern(&lf[133],9,"open/read");
lf[134]=C_h_intern(&lf[134],10,"open/write");
lf[135]=C_h_intern(&lf[135],10,"open/creat");
lf[136]=C_h_intern(&lf[136],11,"open/append");
lf[137]=C_h_intern(&lf[137],9,"open/excl");
lf[138]=C_h_intern(&lf[138],11,"open/noctty");
lf[139]=C_h_intern(&lf[139],13,"open/nonblock");
lf[140]=C_h_intern(&lf[140],10,"open/trunc");
lf[141]=C_h_intern(&lf[141],9,"open/sync");
lf[142]=C_h_intern(&lf[142],10,"open/fsync");
lf[143]=C_h_intern(&lf[143],11,"open/binary");
lf[144]=C_h_intern(&lf[144],9,"open/text");
lf[145]=C_h_intern(&lf[145],10,"perm/irusr");
lf[146]=C_h_intern(&lf[146],10,"perm/iwusr");
lf[147]=C_h_intern(&lf[147],10,"perm/ixusr");
lf[148]=C_h_intern(&lf[148],10,"perm/irgrp");
lf[149]=C_h_intern(&lf[149],10,"perm/iwgrp");
lf[150]=C_h_intern(&lf[150],10,"perm/ixgrp");
lf[151]=C_h_intern(&lf[151],10,"perm/iroth");
lf[152]=C_h_intern(&lf[152],10,"perm/iwoth");
lf[153]=C_h_intern(&lf[153],10,"perm/ixoth");
lf[154]=C_h_intern(&lf[154],10,"perm/irwxu");
lf[155]=C_h_intern(&lf[155],10,"perm/irwxg");
lf[156]=C_h_intern(&lf[156],10,"perm/irwxo");
lf[157]=C_h_intern(&lf[157],10,"perm/isvtx");
lf[158]=C_h_intern(&lf[158],10,"perm/isuid");
lf[159]=C_h_intern(&lf[159],10,"perm/isgid");
lf[160]=C_h_intern(&lf[160],12,"file-control");
lf[161]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[162]=C_h_intern(&lf[162],9,"file-open");
lf[163]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[164]=C_h_intern(&lf[164],10,"file-close");
lf[165]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[166]=C_h_intern(&lf[166],9,"file-read");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[168]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[169]=C_h_intern(&lf[169],10,"file-write");
lf[170]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[171]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[172]=C_h_intern(&lf[172],12,"file-mkstemp");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[174]=C_h_intern(&lf[174],11,"file-select");
lf[175]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[176]=C_h_intern(&lf[176],8,"seek/set");
lf[177]=C_h_intern(&lf[177],8,"seek/end");
lf[178]=C_h_intern(&lf[178],8,"seek/cur");
lf[179]=C_h_intern(&lf[179],18,"set-file-position!");
lf[180]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[181]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[182]=C_h_intern(&lf[182],5,"port\077");
lf[183]=C_h_intern(&lf[183],13,"\000bounds-error");
lf[184]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[185]=C_h_intern(&lf[185],13,"file-position");
lf[186]=C_h_intern(&lf[186],16,"create-directory");
lf[187]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[188]=C_h_intern(&lf[188],18,"pathname-directory");
lf[189]=C_h_intern(&lf[189],12,"file-exists\077");
lf[190]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[191]=C_h_intern(&lf[191],17,"change-directory\052");
lf[192]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[193]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[194]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[195]=C_h_intern(&lf[195],15,"open-input-pipe");
lf[196]=C_h_intern(&lf[196],5,"\000text");
lf[197]=C_h_intern(&lf[197],7,"\000binary");
lf[198]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[199]=C_h_intern(&lf[199],16,"open-output-pipe");
lf[200]=C_h_intern(&lf[200],16,"close-input-pipe");
lf[201]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[202]=C_h_intern(&lf[202],20,"\003syscheck-input-port");
lf[203]=C_h_intern(&lf[203],17,"close-output-pipe");
lf[204]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[205]=C_h_intern(&lf[205],21,"\003syscheck-output-port");
lf[206]=C_h_intern(&lf[206],20,"call-with-input-pipe");
lf[207]=C_h_intern(&lf[207],21,"call-with-output-pipe");
lf[208]=C_h_intern(&lf[208],20,"with-input-from-pipe");
lf[209]=C_h_intern(&lf[209],18,"\003sysstandard-input");
lf[210]=C_h_intern(&lf[210],19,"with-output-to-pipe");
lf[211]=C_h_intern(&lf[211],19,"\003sysstandard-output");
lf[212]=C_h_intern(&lf[212],11,"create-pipe");
lf[213]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[214]=C_h_intern(&lf[214],11,"signal/term");
lf[215]=C_h_intern(&lf[215],11,"signal/kill");
lf[216]=C_h_intern(&lf[216],10,"signal/int");
lf[217]=C_h_intern(&lf[217],10,"signal/hup");
lf[218]=C_h_intern(&lf[218],10,"signal/fpe");
lf[219]=C_h_intern(&lf[219],10,"signal/ill");
lf[220]=C_h_intern(&lf[220],11,"signal/segv");
lf[221]=C_h_intern(&lf[221],11,"signal/abrt");
lf[222]=C_h_intern(&lf[222],11,"signal/trap");
lf[223]=C_h_intern(&lf[223],11,"signal/quit");
lf[224]=C_h_intern(&lf[224],11,"signal/alrm");
lf[225]=C_h_intern(&lf[225],13,"signal/vtalrm");
lf[226]=C_h_intern(&lf[226],11,"signal/prof");
lf[227]=C_h_intern(&lf[227],9,"signal/io");
lf[228]=C_h_intern(&lf[228],10,"signal/urg");
lf[229]=C_h_intern(&lf[229],11,"signal/chld");
lf[230]=C_h_intern(&lf[230],11,"signal/cont");
lf[231]=C_h_intern(&lf[231],11,"signal/stop");
lf[232]=C_h_intern(&lf[232],11,"signal/tstp");
lf[233]=C_h_intern(&lf[233],11,"signal/pipe");
lf[234]=C_h_intern(&lf[234],11,"signal/xcpu");
lf[235]=C_h_intern(&lf[235],11,"signal/xfsz");
lf[236]=C_h_intern(&lf[236],11,"signal/usr1");
lf[237]=C_h_intern(&lf[237],11,"signal/usr2");
lf[238]=C_h_intern(&lf[238],12,"signal/winch");
lf[239]=C_h_intern(&lf[239],12,"signals-list");
lf[240]=C_h_intern(&lf[240],16,"set-signal-mask!");
lf[241]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[242]=C_h_intern(&lf[242],11,"signal-mask");
lf[243]=C_h_intern(&lf[243],14,"signal-masked\077");
lf[244]=C_h_intern(&lf[244],12,"signal-mask!");
lf[245]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[246]=C_h_intern(&lf[246],14,"signal-unmask!");
lf[247]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[248]=C_h_intern(&lf[248],18,"system-information");
lf[249]=C_h_intern(&lf[249],25,"\003syspeek-nonnull-c-string");
lf[250]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[251]=C_h_intern(&lf[251],15,"current-user-id");
lf[252]=C_h_intern(&lf[252],25,"current-effective-user-id");
lf[253]=C_h_intern(&lf[253],16,"current-group-id");
lf[254]=C_h_intern(&lf[254],26,"current-effective-group-id");
lf[255]=C_h_intern(&lf[255],16,"user-information");
lf[256]=C_h_intern(&lf[256],6,"vector");
lf[257]=C_h_intern(&lf[257],4,"list");
lf[258]=C_h_intern(&lf[258],17,"current-user-name");
lf[259]=C_h_intern(&lf[259],27,"current-effective-user-name");
lf[260]=C_h_intern(&lf[260],17,"group-information");
lf[261]=C_h_intern(&lf[261],10,"get-groups");
lf[262]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[265]=C_h_intern(&lf[265],11,"set-groups!");
lf[266]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[267]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[268]=C_h_intern(&lf[268],17,"initialize-groups");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[270]=C_h_intern(&lf[270],10,"errno/perm");
lf[271]=C_h_intern(&lf[271],11,"errno/noent");
lf[272]=C_h_intern(&lf[272],10,"errno/srch");
lf[273]=C_h_intern(&lf[273],10,"errno/intr");
lf[274]=C_h_intern(&lf[274],8,"errno/io");
lf[275]=C_h_intern(&lf[275],12,"errno/noexec");
lf[276]=C_h_intern(&lf[276],10,"errno/badf");
lf[277]=C_h_intern(&lf[277],11,"errno/child");
lf[278]=C_h_intern(&lf[278],11,"errno/nomem");
lf[279]=C_h_intern(&lf[279],11,"errno/acces");
lf[280]=C_h_intern(&lf[280],11,"errno/fault");
lf[281]=C_h_intern(&lf[281],10,"errno/busy");
lf[282]=C_h_intern(&lf[282],12,"errno/notdir");
lf[283]=C_h_intern(&lf[283],11,"errno/isdir");
lf[284]=C_h_intern(&lf[284],11,"errno/inval");
lf[285]=C_h_intern(&lf[285],11,"errno/mfile");
lf[286]=C_h_intern(&lf[286],11,"errno/nospc");
lf[287]=C_h_intern(&lf[287],11,"errno/spipe");
lf[288]=C_h_intern(&lf[288],10,"errno/pipe");
lf[289]=C_h_intern(&lf[289],11,"errno/again");
lf[290]=C_h_intern(&lf[290],10,"errno/rofs");
lf[291]=C_h_intern(&lf[291],11,"errno/exist");
lf[292]=C_h_intern(&lf[292],16,"errno/wouldblock");
lf[293]=C_h_intern(&lf[293],10,"errno/2big");
lf[294]=C_h_intern(&lf[294],12,"errno/deadlk");
lf[295]=C_h_intern(&lf[295],9,"errno/dom");
lf[296]=C_h_intern(&lf[296],10,"errno/fbig");
lf[297]=C_h_intern(&lf[297],11,"errno/ilseq");
lf[298]=C_h_intern(&lf[298],11,"errno/mlink");
lf[299]=C_h_intern(&lf[299],17,"errno/nametoolong");
lf[300]=C_h_intern(&lf[300],11,"errno/nfile");
lf[301]=C_h_intern(&lf[301],11,"errno/nodev");
lf[302]=C_h_intern(&lf[302],11,"errno/nolck");
lf[303]=C_h_intern(&lf[303],11,"errno/nosys");
lf[304]=C_h_intern(&lf[304],14,"errno/notempty");
lf[305]=C_h_intern(&lf[305],11,"errno/notty");
lf[306]=C_h_intern(&lf[306],10,"errno/nxio");
lf[307]=C_h_intern(&lf[307],11,"errno/range");
lf[308]=C_h_intern(&lf[308],10,"errno/xdev");
lf[309]=C_h_intern(&lf[309],16,"change-file-mode");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[311]=C_h_intern(&lf[311],17,"change-file-owner");
lf[312]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[313]=C_h_intern(&lf[313],17,"file-read-access\077");
lf[314]=C_h_intern(&lf[314],18,"file-write-access\077");
lf[315]=C_h_intern(&lf[315],20,"file-execute-access\077");
lf[316]=C_h_intern(&lf[316],14,"create-session");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[318]=C_h_intern(&lf[318],16,"process-group-id");
lf[319]=C_h_intern(&lf[319],20,"create-symbolic-link");
lf[320]=C_h_intern(&lf[320],18,"create-symbol-link");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[322]=C_h_intern(&lf[322],18,"read-symbolic-link");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[324]=C_h_intern(&lf[324],12,"canonicalize");
lf[325]=C_h_intern(&lf[325],9,"substring");
lf[326]=C_h_intern(&lf[326],9,"file-link");
lf[327]=C_h_intern(&lf[327],9,"hard-link");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[329]=C_h_intern(&lf[329],21,"\003syscustom-input-port");
lf[330]=C_h_intern(&lf[330],4,"void");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[332]=C_h_intern(&lf[332],3,"rx=");
lf[333]=C_h_intern(&lf[333],17,"\003systhread-yield!");
lf[334]=C_h_intern(&lf[334],25,"\003systhread-block-for-i/o!");
lf[335]=C_h_intern(&lf[335],18,"\003syscurrent-thread");
lf[336]=C_h_intern(&lf[336],6,"\000input");
lf[337]=C_h_intern(&lf[337],22,"\003sysdispatch-interrupt");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[339]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[340]=C_h_intern(&lf[340],14,"set-port-name!");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[342]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[343]=C_h_intern(&lf[343],17,"\003sysstring-append");
lf[344]=C_h_intern(&lf[344],20,"\003sysscan-buffer-line");
lf[345]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[346]=C_h_intern(&lf[346],15,"make-input-port");
lf[347]=C_h_intern(&lf[347],22,"\003syscustom-output-port");
lf[348]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[350]=C_h_intern(&lf[350],16,"make-output-port");
lf[351]=C_h_intern(&lf[351],13,"file-truncate");
lf[352]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[354]=C_h_intern(&lf[354],4,"lock");
lf[355]=C_h_intern(&lf[355],14,"\003syscheck-port");
lf[356]=C_h_intern(&lf[356],9,"file-lock");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[358]=C_h_intern(&lf[358],18,"file-lock/blocking");
lf[359]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[360]=C_h_intern(&lf[360],14,"file-test-lock");
lf[361]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[362]=C_h_intern(&lf[362],11,"file-unlock");
lf[363]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[364]=C_h_intern(&lf[364],11,"create-fifo");
lf[365]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[366]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[367]=C_decode_literal(C_heaptop,"\376B\000\000(system error while trying to access file");
lf[368]=C_h_intern(&lf[368],6,"setenv");
lf[369]=C_h_intern(&lf[369],8,"unsetenv");
lf[370]=C_h_intern(&lf[370],25,"get-environment-variables");
lf[371]=C_h_intern(&lf[371],9,"prot/read");
lf[372]=C_h_intern(&lf[372],10,"prot/write");
lf[373]=C_h_intern(&lf[373],9,"prot/exec");
lf[374]=C_h_intern(&lf[374],9,"prot/none");
lf[375]=C_h_intern(&lf[375],9,"map/fixed");
lf[376]=C_h_intern(&lf[376],10,"map/shared");
lf[377]=C_h_intern(&lf[377],11,"map/private");
lf[378]=C_h_intern(&lf[378],13,"map/anonymous");
lf[379]=C_h_intern(&lf[379],8,"map/file");
lf[380]=C_h_intern(&lf[380],18,"map-file-to-memory");
lf[381]=C_h_intern(&lf[381],4,"mmap");
lf[382]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[383]=C_h_intern(&lf[383],20,"\003syspointer->address");
lf[384]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[385]=C_h_intern(&lf[385],16,"\003sysnull-pointer");
lf[386]=C_h_intern(&lf[386],22,"unmap-file-from-memory");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[388]=C_h_intern(&lf[388],26,"memory-mapped-file-pointer");
lf[389]=C_h_intern(&lf[389],19,"memory-mapped-file\077");
lf[390]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[391]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[392]=C_h_intern(&lf[392],12,"string->time");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[394]=C_h_intern(&lf[394],17,"utc-time->seconds");
lf[395]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[396]=C_h_intern(&lf[396],27,"local-timezone-abbreviation");
lf[397]=C_h_intern(&lf[397],5,"_exit");
lf[398]=C_h_intern(&lf[398],10,"set-alarm!");
lf[399]=C_h_intern(&lf[399],19,"set-buffering-mode!");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[401]=C_h_intern(&lf[401],5,"\000full");
lf[402]=C_h_intern(&lf[402],5,"\000line");
lf[403]=C_h_intern(&lf[403],5,"\000none");
lf[404]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[405]=C_h_intern(&lf[405],14,"terminal-port\077");
lf[407]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[408]=C_h_intern(&lf[408],13,"terminal-name");
lf[409]=C_h_intern(&lf[409],13,"terminal-size");
lf[410]=C_h_intern(&lf[410],6,"\000error");
lf[411]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[412]=C_h_intern(&lf[412],17,"\003sysmake-locative");
lf[413]=C_h_intern(&lf[413],8,"location");
lf[414]=C_h_intern(&lf[414],13,"get-host-name");
lf[415]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[416]=C_h_intern(&lf[416],12,"process-fork");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[418]=C_h_intern(&lf[418],24,"pathname-strip-directory");
lf[419]=C_h_intern(&lf[419],15,"process-execute");
lf[420]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[421]=C_h_intern(&lf[421],17,"parent-process-id");
lf[422]=C_h_intern(&lf[422],5,"sleep");
lf[423]=C_h_intern(&lf[423],14,"process-signal");
lf[424]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[425]=C_h_intern(&lf[425],17,"\003sysshell-command");
lf[426]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[427]=C_h_intern(&lf[427],24,"get-environment-variable");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[429]=C_h_intern(&lf[429],27,"\003sysshell-command-arguments");
lf[430]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[431]=C_h_intern(&lf[431],11,"process-run");
lf[432]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[433]=C_h_intern(&lf[433],11,"\003sysprocess");
lf[434]=C_h_intern(&lf[434],16,"\003syscheck-string");
lf[435]=C_h_intern(&lf[435],7,"process");
lf[436]=C_h_intern(&lf[436],8,"process\052");
lf[437]=C_h_intern(&lf[437],6,"values");
lf[438]=C_h_intern(&lf[438],19,"set-root-directory!");
lf[439]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[440]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[441]=C_h_intern(&lf[441],21,"set-process-group-id!");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[443]=C_h_intern(&lf[443],18,"getter-with-setter");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\026(process-group-id pid)");
lf[445]=C_h_intern(&lf[445],26,"effective-group-id!-setter");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000\034(current-effective-group-id)");
lf[448]=C_h_intern(&lf[448],12,"set-user-id!");
lf[449]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[450]=C_decode_literal(C_heaptop,"\376B\000\000\022(current-group-id)");
lf[451]=C_h_intern(&lf[451],25,"effective-user-id!-setter");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\033(current-effective-used-id)");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[455]=C_decode_literal(C_heaptop,"\376B\000\000\021(current-user-id)");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[458]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[459]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[460]=C_h_intern(&lf[460],26,"set-file-modification-time");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[462]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,463,create_ptable());
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2595,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* initialize-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5267,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[268]);
t5=C_i_check_exact_2(t3,lf[268]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5287,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1143: init */
t7=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,t2,t3);}

/* k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7162,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7164,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_check_list_2(((C_word*)t0)[2],lf[419]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7191,a[2]=((C_word*)t0)[7],a[3]=t5,a[4]=((C_word)li223),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_7191(t7,t2,((C_word*)t0)[2],C_fix(0));}
else{
t3=t2;
f_7164(2,t3,C_SCHEME_UNDEFINED);}}

/* k7163 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_7164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7164,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7166,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7184,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1794: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,((C_word*)t0)[4]);}

/* k7165 in k7163 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_7166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7166,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[2])?C_execve(t1):C_execvp(t1));
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7176,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1799: freeargs */
t5=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* f_6679 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6679(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6679,4,t0,t1,t2,t3);}
if(C_truep(t2)){
t4=C_i_foreign_pointer_argumentp(t2);
t5=C_i_foreign_integer_argumentp(t3);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub1653(C_SCHEME_UNDEFINED,t4,t5));}
else{
t4=C_i_foreign_integer_argumentp(t3);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1653(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t4));}}

/* k7175 in k7165 in k7163 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in ... */
static void C_ccall f_7176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7176,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7178,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1800: freeenv */
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k6389 in file-test-lock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6390,2,t0,t1);}
t2=C_flock_test(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6394,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1520: g1559 */
t4=t3;
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,((C_word*)t0)[3],t2);}
else{
/* posixunix.scm:1523: err */
f_6339(((C_word*)t0)[3],lf[361],t1,lf[360]);}}

/* k5280 in k5286 in initialize-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1145: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[268],lf[269],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k5286 in initialize-groups in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5287,2,t0,t1);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5281,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1144: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t2);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k7183 in k7163 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_7184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1794: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[419]);}

/* k7177 in k7175 in k7165 in k7163 in k7161 in doloop1873 in k7146 in k7144 in process-execute in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in ... */
static void C_ccall f_7178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1801: posix-error */
t2=lf[2];
f_2616(6,t2,((C_word*)t0)[2],lf[120],lf[419],lf[420],((C_word*)t0)[3]);}

/* k2658 in stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2636(2,t2,(C_truep(((C_word*)t0)[3])?C_lstat(t1):C_stat(t1)));}

/* f_6613 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6613(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[5],*a=ab;
if(c!=8) C_bad_argc_2(c,8,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr8,(void*)f_6613,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=C_a_i_bytevector(&a,1,C_fix(3));
t9=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t10=C_i_foreign_integer_argumentp(t3);
t11=C_i_foreign_fixnum_argumentp(t4);
t12=C_i_foreign_fixnum_argumentp(t5);
t13=C_i_foreign_fixnum_argumentp(t6);
t14=C_i_foreign_integer_argumentp(t7);
t15=t1;
((C_proc2)(void*)(*((C_word*)t15+1)))(2,t15,stub1626(t8,t9,t10,t11,t12,t13,t14));}

/* f_6394 in k6389 in file-test-lock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6394(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6394,3,t0,t1,t2);}
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* file-lock/blocking in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6370(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6370r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6370r(t0,t1,t2,t3);}}

static void C_ccall f_6370r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6374,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1515: setup */
f_6281(t4,t2,t3,lf[358]);}

/* k2628 in k2619 in posix-error in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:120: string-append */
t2=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],lf[4],t1);}

/* k2625 in k2619 in posix-error in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[2],*((C_word*)lf[3]+1),((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5]);}

/* k5919 in loop */
static void C_ccall f_5920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1408: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5837(t2,((C_word*)t0)[5],((C_word*)t0)[6]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* k2619 in posix-error in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2620,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2626,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2629,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:120: strerror */
t4=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k6642 in k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6643(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6643,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6645,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t1,a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_blockp(((C_word*)t0)[4]))){
if(C_truep(C_specialp(((C_word*)t0)[4]))){
t3=t2;
f_6645(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1617: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[13],lf[380],lf[384],((C_word*)t0)[4]);}}
else{
/* posixunix.scm:1617: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[13],lf[380],lf[384],((C_word*)t0)[4]);}}

/* k6644 in k6642 in k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6645,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6647,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1618: mmap */
t3=((C_word*)t0)[9];
((C_proc8)(void*)(*((C_word*)t3+1)))(8,t3,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}

/* k6646 in k6644 in k6642 in k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6647,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6649,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6661,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[2],a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1619: ##sys#pointer->address */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[383]+1)))(3,*((C_word*)lf[383]+1),t3,t1);}

/* k6648 in k6646 in k6644 in k6642 in k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_6649(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6649,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_record3(&a,3,lf[381],((C_word*)t0)[3],((C_word*)t0)[4]));}

/* file-test-lock in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6386(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6386r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6386r(t0,t1,t2,t3);}}

static void C_ccall f_6386r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6390,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1521: setup */
f_6281(t4,t2,t3,lf[360]);}

/* k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6643,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[8]))){
t3=((C_word*)t0)[8];
t4=t2;
f_6643(t4,C_u_i_car(t3));}
else{
t3=t2;
f_6643(t3,C_fix(0));}}

/* f_5931 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5931(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5931,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[345]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5939,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1413: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);}}

/* k5938 */
static void C_ccall f_5939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6637(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr7r,(void*)f_6637r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest(a,C_rest_count(0));
f_6637r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_6637r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t8=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6641,a[2]=t1,a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=((C_word*)t0)[2],a[8]=t7,tmp=(C_word)a,a+=9,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_6641(2,t10,t2);}
else{
/* posixunix.scm:1614: ##sys#null-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[385]+1)))(2,*((C_word*)lf[385]+1),t8);}}

/* k6373 in file-lock/blocking in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_flock_lockw(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1517: err */
f_6339(((C_word*)t0)[4],lf[359],t1,lf[358]);}
else{
t3=t1;
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* f_5906 in loop */
static void C_ccall f_5906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5906,2,t0,t1);}
/* posixunix.scm:1401: ##sys#scan-buffer-line */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[344]+1)))(6,*((C_word*)lf[344]+1),t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5]);}

/* k6660 in k6646 in k6644 in k6642 in k6640 in map-file-to-memory in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_6661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6661,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1620: posix-error */
t3=lf[2];
f_2616(11,t3,((C_word*)t0)[2],lf[8],lf[380],lf[382],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}
else{
t3=((C_word*)t0)[9];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_record3(&a,3,lf[381],((C_word*)t0)[10],((C_word*)t0)[4]));}}

/* f_5911 in loop */
static void C_ccall f_5911(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5911,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm:1403: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5837(t4,t1,t2);}
else{
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4331 in for-each-loop749 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4323(t3,((C_word*)t0)[4],t2);}

/* f_4082 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4082(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4082,4,t0,t1,t2,t3);}
t4=C_i_foreign_fixnum_argumentp(t2);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub725(C_SCHEME_UNDEFINED,t4,t5));}

/* f_4311 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4311(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4311,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[174]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
/* posixunix.scm:677: fd_set */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,C_fix(0),t2);}

/* ##sys#file-select-one in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3850(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3850,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub607(C_SCHEME_UNDEFINED,t3));}

/* k5814 in loop in k5770 */
static void C_ccall f_5815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
/* posixunix.scm:1374: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_5774(t3,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[7]);}}

/* k5255 */
static void C_ccall f_5257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1193(C_SCHEME_UNDEFINED,t1,t2));}

/* f_6991 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6991,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=C_i_foreign_pointer_argumentp(t3);
t7=C_i_foreign_pointer_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub1782(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* f_5252 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5252(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5252,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5257,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t5=C_i_foreign_string_argumentp(t2);
/* posixunix.scm:1139: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t4,t5);}
else{
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub1193(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t5));}}

/* k6984 in terminal-name in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_C_fileno(((C_word*)t0)[2]);
/* posixunix.scm:1726: ttyname */
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[4],t2);}

/* k6046 in loop in poke in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1431: poke */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6023(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* terminal-name in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6981(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6981,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6985,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1725: ##sys#terminal-check */
f_6951(t3,lf[408],t2);}

/* k5223 in doloop1179 in k5203 in set-groups! in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1133: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[265],lf[266],((C_word*)t0)[3]);}

/* k7600 */
static void C_ccall f_7601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7601,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7603,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm:1958: chkstrlst */
t3=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_7603(2,t3,C_SCHEME_UNDEFINED);}}

/* k7602 in k7600 */
static void C_ccall f_7603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7603,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7608,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li254),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1959: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[7],t2,((C_word*)t0)[8]);}

/* f_7608 in k7602 in k7600 */
static void C_ccall f_7608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7608,2,t0,t1);}
/* posixunix.scm:1960: ##sys#process */
t2=*((C_word*)lf[433]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[6]);}

/* f_5832 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5832,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5837,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=t5,a[8]=((C_word)li162),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f_5837(t7,t1,C_SCHEME_FALSE);}

/* loop */
static void C_fcall f_5837(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5837,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5840,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word)li159),tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5906,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=((C_word)li160),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5911,a[2]=((C_word*)t0)[7],a[3]=((C_word)li161),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1400: ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5920,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[7],a[5]=t1,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1406: fetch */
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* f_4077 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4077(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4077,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub720(C_SCHEME_UNDEFINED,t3));}

/* f_6972 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6972(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6972,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub1771(t3,t4);
/* posixunix.scm:1723: ##sys#peek-nonnull-c-string */
t6=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* k4059 in k4055 in file-mkstemp in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4060,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4066,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixunix.scm:653: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t2,((C_word*)t0)[5],C_fix(0),t3);}

/* k4065 in k4059 in k4055 in file-mkstemp in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:653: values */
C_values(4,0,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* f_3800 in process-wait in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3800(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3800,2,t0,t1);}
/* posix-common.scm:515: ##sys#process-wait */
t2=*((C_word*)lf[119]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* f_3805 in process-wait in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3805,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:517: posix-error */
t6=lf[2];
f_2616(6,t6,t1,lf[120],lf[118],lf[121],((C_word*)t0)[2]);}
else{
/* posix-common.scm:518: values */
C_values(5,0,t1,t2,t3,t4);}}

/* f_4090 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4090,4,t0,t1,t2,t3);}
t4=C_i_foreign_fixnum_argumentp(t2);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub731(C_SCHEME_UNDEFINED,t4,t5));}

/* posix-error in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_2616r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2616r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2616r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2620,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:119: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t6);}

/* ##sys#terminal-check in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6951(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6951,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6955,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1717: ##sys#check-open-port */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[59]+1)))(4,*((C_word*)lf[59]+1),t4,t3,t2);}

/* k6954 in terminal-check in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(lf[51],t2);
t4=(C_truep(t3)?C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixunix.scm:1720: ##sys#error */
t5=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[4],lf[407],((C_word*)t0)[2]);}}

/* file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4098(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr4r,(void*)f_4098r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4098r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4098r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(11);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4102,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t6,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_4102(t9,C_u_i_car(t8));}
else{
t8=t7;
f_4102(t8,C_SCHEME_FALSE);}}

/* ##sys#custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6005(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_6005r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6005r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6005r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(8);
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(0):C_i_car(t9));
t12=C_i_nullp(t9);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t14=C_i_nullp(t13);
t15=(C_truep(t14)?*((C_word*)lf[330]+1):C_i_car(t13));
t16=C_i_nullp(t13);
t17=(C_truep(t16)?C_SCHEME_END_OF_LIST:C_i_cdr(t13));
t18=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6021,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t11,a[6]=t1,a[7]=t15,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t7)){
/* posixunix.scm:1422: ##sys#file-nonblocking! */
t19=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t19+1)))(3,t19,t18,t4);}
else{
t19=t18;
f_6021(2,t19,C_SCHEME_UNDEFINED);}}

/* k6939 in k6937 in terminal-port? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* f_7642 in process in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7642(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7642,6,t0,t1,t2,t3,t4,t5);}
/* posixunix.scm:1966: values */
C_values(5,0,t1,t2,t3,t4);}

/* k6812 in string->time in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6813(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6813,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6816,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1660: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t2,((C_word*)t0)[4]);}

/* k6815 in k6812 in string->time in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6816,2,t0,t1);}
t2=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
/* posixunix.scm:1660: strptime */
t3=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[3],((C_word*)t0)[4],t1,t2);}

/* k2635 in stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:173: posix-error */
t2=lf[2];
f_2616(6,t2,((C_word*)t0)[3],lf[8],((C_word*)t0)[4],lf[9],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* ##sys#stat in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_2632(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2632,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2636,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_2636(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2659,a[2]=t6,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2665,a[2]=t7,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2668,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:163: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t2);}
else{
/* posix-common.scm:169: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],t5,lf[14],t2);}}}

/* k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2605(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2605,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2607,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[1]+1);
t4=C_mutate(&lf[2] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2616,a[2]=t2,a[3]=((C_word)li1),tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[6]+1 /* (set! ##sys#posix-error ...) */,lf[2]);
t6=C_mutate(&lf[7] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2632,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[15]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2673,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2693,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7915,a[2]=((C_word)li275),tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7920,a[2]=((C_word)li277),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:186: getter-with-setter */
t11=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t8,t9,t10,lf[462]);}

/* loop in poke in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6029,2,t0,t1);}
t2=C_write(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6047,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1430: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[333]+1)))(2,*((C_word*)lf[333]+1),t7);}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1433: ##sys#dispatch-interrupt */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[337]+1)))(3,*((C_word*)lf[337]+1),t1,((C_word*)((C_word*)t0)[6])[1]);}
else{
/* posixunix.scm:1435: posix-error */
t7=lf[2];
f_2616(7,t7,t1,((C_word*)t0)[7],lf[8],lf[348],((C_word*)t0)[2],((C_word*)t0)[8]);}}}
else{
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[4]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6077,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1437: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t4,((C_word*)t0)[3],t2,((C_word*)t0)[4]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2603,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2605,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* f_2607 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2607(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2607,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub65(t3,t4);
/* posix-common.scm:116: ##sys#peek-c-string */
t6=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6021,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6023,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li167),tmp=(C_word)a,a+=7,tmp));
t7=C_fixnump(((C_word*)t0)[5]);
t8=(C_truep(t7)?((C_word*)t0)[5]:C_block_size(((C_word*)t0)[5]));
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6086,a[2]=t5,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],tmp=(C_word)a,a+=8,tmp);
t10=C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_6086(t11,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6126,a[2]=t3,a[3]=((C_word)li171),tmp=(C_word)a,a+=4,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6138,a[2]=t9,a[3]=t8,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
/* posixunix.scm:1444: ##sys#make-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(3,*((C_word*)lf[66]+1),t11,((C_word*)t0)[5]);}
else{
t12=t11;
f_6138(2,t12,((C_word*)t0)[5]);}}}

/* poke in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6023(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6023,NULL,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6029,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word)li166),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];
f_6029(2,t7,t1);}

/* k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2601,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2603,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k7619 */
static void C_ccall f_7621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7621,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7625,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1957: ##sys#shell-command */
t4=*((C_word*)lf[425]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k7623 in k7619 */
static void C_ccall f_7625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_7601(2,t3,t2);}

/* process in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7627(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_7627r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7627r(t0,t1,t2,t3);}}

static void C_ccall f_7627r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7642,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1964: %process */
t13=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t13+1)))(8,t13,t1,lf[435],C_SCHEME_FALSE,t2,t5,t9,t12);}

/* ##sys#file-nonblocking! in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3843(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3843,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub602(C_SCHEME_UNDEFINED,t3));}

/* k6830 in utc-time->seconds in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6831,2,t0,t1);}
t2=C_a_timegm(&a,1,((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6837,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1665: fp= */
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[110],t2);}

/* k6835 in k6830 in utc-time->seconds in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1666: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[394],lf[395],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* k6534 in unsetenv in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* f_6537 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6537(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6537,3,t0,t1,t2);}
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub1598(t3,t4);
/* posixunix.scm:1573: ##sys#peek-c-string */
t6=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,t5,C_fix(0));}

/* process* in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7671(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_7671r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7671r(t0,t1,t2,t3);}}

static void C_ccall f_7671r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
if(C_truep(C_i_nullp(t7))){
/* posixunix.scm:1969: %process */
t10=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t10+1)))(8,t10,t1,lf[436],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[437]+1));}
else{
t10=C_i_cdr(t7);
/* posixunix.scm:1969: %process */
t11=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t11+1)))(8,t11,t1,lf[436],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[437]+1));}}

/* utc-time->seconds in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6827(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6827,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6831,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1663: check-time-vector */
f_3579(t3,lf[394],t2);}

/* k5595 in k5582 */
static void C_ccall f_5597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}
else{
/* posixunix.scm:1301: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],((C_word*)t0)[3],lf[331],((C_word*)t0)[4],((C_word*)t0)[5]);}}

/* doloop1179 in k5203 in set-groups! in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_5209(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5209,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=C_set_groups(t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5224,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1132: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t5);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_exact_2(t4,lf[265]);
t6=C_set_gid(t3,t4);
t7=C_slot(t2,C_fix(1));
t8=C_fixnum_plus(t3,C_fix(1));
t12=t1;
t13=t7;
t14=t8;
t1=t12;
t2=t13;
t3=t14;
goto loop;}}

/* k4028 in k4024 in k4022 in file-write in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4024 in k4022 in file-write in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4025(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4025,NULL,2,t0,t1);}
t2=C_i_check_exact_2(t1,lf[169]);
t3=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4029,a[2]=((C_word*)t0)[4],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm:642: posix-error */
t6=lf[2];
f_2616(7,t6,t4,lf[8],lf[169],lf[170],((C_word*)t0)[2],t1);}
else{
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}}

/* k4022 in file-write in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4023,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4025,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4025(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4025(t3,C_block_size(((C_word*)t0)[3]));}}

/* set-groups! in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5200(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5200,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5204,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_i_length(t2);
t5=C_i_foreign_fixnum_argumentp(t4);
if(C_truep(stub1163(C_SCHEME_UNDEFINED,t5))){
t6=t3;
f_5204(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1127: ##sys#error */
t6=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[265],lf[267]);}}

/* k5203 in set-groups! in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5204,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5209,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li134),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5209(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k4055 in file-mkstemp in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4056,2,t0,t1);}
t2=C_mkstemp(t1);
t3=C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4060,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm:652: posix-error */
t6=lf[2];
f_2616(6,t6,t4,lf[8],lf[172],lf[173],((C_word*)t0)[3]);}
else{
t6=t4;
f_4060(2,t6,C_SCHEME_UNDEFINED);}}

/* directory? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2863(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2863,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2870,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:236: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2860 in socket? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[29],t1));}

/* file-mkstemp in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4050(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4050,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[172]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4056,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:648: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t2,lf[172]);}

/* k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5575,2,t0,t1);}
t2=C_fixnump(((C_word*)t0)[2]);
t3=(C_truep(t2)?((C_word*)t0)[2]:C_block_size(((C_word*)t0)[2]));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5579,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
/* posixunix.scm:1291: ##sys#make-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(3,*((C_word*)lf[66]+1),t4,((C_word*)t0)[2]);}
else{
t5=t4;
f_5579(2,t5,((C_word*)t0)[2]);}}

/* mode in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_2875(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2875,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2882,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[40]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:255: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[42],t7);}
else{
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[43],t4);}}
else{
/* posix-common.scm:256: ##sys#error */
t9=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[44],t7);}}
else{
if(C_truep(t2)){
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[45],t4);}
else{
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[46],t4);}}}

/* k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word ab[79],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5579,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5580,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li149),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5607,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=((C_word)li150),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5614,a[2]=t5,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[2],a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[6],a[10]=((C_word)li152),tmp=(C_word)a,a+=11,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5711,a[2]=t10,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5715,a[2]=t5,a[3]=t7,a[4]=t8,a[5]=((C_word)li153),tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5726,a[2]=t5,a[3]=t3,a[4]=t6,a[5]=((C_word)li154),tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5737,a[2]=t10,a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word)li155),tmp=(C_word)a,a+=8,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5757,a[2]=t7,a[3]=t8,a[4]=((C_word)li156),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5765,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=t8,a[6]=((C_word)li158),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5832,a[2]=t5,a[3]=t3,a[4]=t8,a[5]=t1,a[6]=((C_word)li163),tmp=(C_word)a,a+=7,tmp);
t18=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5931,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=((C_word)li164),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1341: make-input-port */
t19=*((C_word*)lf[346]+1);
((C_proc9)(void*)(*((C_word*)t19+1)))(9,t19,t11,t12,t13,t14,t15,t16,t17,t18);}

/* k2869 in directory? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[25],t1));}

/* k7494 in k7486 in k7484 */
static void C_ccall f_7495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1915: connect-child */
t2=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5],*((C_word*)lf[39]+1));}

/* f_7499 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7499(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_7499,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7502,a[2]=t1,a[3]=t2,a[4]=t4,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1919: connect-parent */
t10=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t10+1)))(6,t10,t9,t2,t5,t6,t7);}

/* k7497 in k7484 */
static void C_ccall f_7498(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1914: connect-child */
t2=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5],*((C_word*)lf[38]+1));}

/* k6076 in loop in poke in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
/* posixunix.scm:1437: poke */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6023(t3,((C_word*)t0)[5],t1,t2);}

/* k2881 in mode in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:251: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k4842 in set-signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_sigprocmask_set(C_fix(0));
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:960: posix-error */
t3=lf[2];
f_2616(5,t3,((C_word*)t0)[2],lf[120],lf[240],lf[241]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5489 in k5475 in read-symbolic-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5490,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5496,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm:1274: symbolic-link? */
t3=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5494 in k5489 in k5475 in read-symbolic-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1275: read-symbolic-link */
t2=*((C_word*)lf[322]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],lf[324]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}}

/* signal-mask in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4876,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4882,a[2]=t3,a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4882(t5,t1,*((C_word*)lf[239]+1),C_SCHEME_END_OF_LIST);}

/* k4864 in for-each-loop1048 in set-signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4856(t3,((C_word*)t0)[4],t2);}

/* loop in signal-mask in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4882(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4882,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
if(C_truep(C_sigismember(t4))){
t7=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:967: loop */
t11=t1;
t12=t6;
t13=t7;
t1=t11;
t2=t12;
t3=t13;
goto loop;}
else{
t7=t3;
/* posixunix.scm:967: loop */
t11=t1;
t12=t6;
t13=t7;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}}

/* for-each-loop1048 in set-signal-mask! in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4856(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4856,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4865,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:954: g1049 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4192 in for-each-loop829 in k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4184(t3,((C_word*)t0)[4],t2);}

/* block-device? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2827(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2827,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2834,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:224: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2824 in symbolic-link? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[24],t1));}

/* f_6094 in k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6094,3,t0,t1,t2);}
/* posixunix.scm:1464: store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_fast_retrieve_proc(t3))(3,t3,t1,t2);}

/* f_6099 in k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6099,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6107,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1468: posix-error */
t4=lf[2];
f_2616(7,t4,t2,lf[8],((C_word*)t0)[5],lf[349],((C_word*)t0)[4],((C_word*)t0)[6]);}
else{
/* posixunix.scm:1469: on-close */
t4=((C_word*)t0)[3];
((C_proc2)C_fast_retrieve_proc(t4))(2,t4,t1);}}}

/* file-write in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4017(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4017r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4017r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4017r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[169]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4023,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_4023(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:637: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],lf[169],lf[171],t3);}}
else{
/* posixunix.scm:637: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],lf[169],lf[171],t3);}}

/* k6091 in k6088 in k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[3])[1]);}

/* k6088 in k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6090,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6092,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1472: set-port-name! */
t4=*((C_word*)lf[340]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[4]);}

/* k4180 in k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4182(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=((C_word*)((C_word*)t0)[2])[1];
/* posixunix.scm:699: values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[4],t2);}

/* for-each-loop829 in k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4184(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4184,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4193,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixunix.scm:709: g830 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* character-device? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2836(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2836,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2843,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:227: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2833 in block-device? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2834(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[27],t1));}

/* k6084 in k6020 in custom-output-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6086(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6086,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6090,a[2]=t4,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6094,a[2]=((C_word*)t0)[2],a[3]=((C_word)li168),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6099,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[4],a[7]=((C_word)li169),tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6119,a[2]=((C_word*)t0)[2],a[3]=((C_word)li170),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1462: make-output-port */
t9=*((C_word*)lf[350]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t5,t6,t7,t8);}

/* k4171 */
static void C_ccall f_4173(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4173,2,t0,t1);}
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* f_2845 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2845(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2845,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2852,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:230: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2842 in character-device? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[26],t1));}

/* k6555 in loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6556,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6564,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=((C_word)li188),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_6564(t5,((C_word*)t0)[4],C_fix(0));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6552(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6552,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6556,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1576: get */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* f_4167 in k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4167(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4167,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4173,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:710: fd_test */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_fix(1),t2);}

/* k6588 in k6585 in scan in k6555 in loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_6589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6589,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6580,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posixunix.scm:1582: loop */
t5=((C_word*)((C_word*)t0)[5])[1];
f_6552(t5,t3,t4);}

/* k2999 in k2997 in duplicate-fileno in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k6585 in scan in k6555 in loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6586,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6589,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t4=C_block_size(((C_word*)t0)[6]);
/* posixunix.scm:1581: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t2,((C_word*)t0)[6],t3,t4);}

/* k6579 in k6588 in k6585 in scan in k6555 in loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in ... */
static void C_ccall f_6580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6580,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k3029 in k3027 in current-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:309: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0),((C_word*)t0)[2]);}
else{
/* posix-common.scm:310: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[8],lf[62],lf[65]);}}

/* k3027 in current-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3028,2,t0,t1);}
t2=C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3030,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:307: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t3);}

/* scan in k6555 in loop in get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6564(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6564,NULL,3,t0,t1,t2);}
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6586,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1580: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t4,((C_word*)t0)[2],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:1583: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k5504 in read-symbolic-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1268: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[322]);}

/* f_4694 in k4683 in call-with-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4694(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4694r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4694r(t0,t1,t2);}}

static void C_ccall f_4694r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4697,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:848: close-input-pipe */
t4=*((C_word*)lf[200]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4696 */
static void C_ccall f_4697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k6511 in fifo? in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6512(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1548: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[34]);}

/* setenv in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6514(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6514,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[368]);
t5=C_i_check_string_2(t3,lf[368]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6523,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t6,t2,lf[368]);}

/* k2815 in regular-file? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[23],t1));}

/* symbolic-link? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2818(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2818,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2825,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:221: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3048(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3048r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3048r(t0,t1,t2,t3);}}

static void C_ccall f_3048r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3055,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp);
t7=C_i_check_string_2(t2,lf[67]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3073,a[2]=t5,a[3]=t6,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:321: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}

/* get-environment-variables in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6546,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6552,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li189),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_6552(t5,t1,C_fix(0));}

/* k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3073,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3078,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:323: find-files */
t3=*((C_word*)lf[71]+1);
((C_proc7)(void*)(*((C_word*)t3+1)))(7,t3,t2,t1,lf[72],C_SCHEME_TRUE,lf[73],C_SCHEME_FALSE);}
else{
/* posix-common.scm:335: rmdir */
f_3055(((C_word*)t0)[4],t1);}}

/* f_3079 in k3077 in k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3079(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3079,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3088,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:329: symbolic-link? */
t4=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k3077 in k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3078(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3078,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3079,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t3=C_i_check_list_2(t1,lf[70]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3099,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3104,a[2]=t6,a[3]=t2,a[4]=((C_word)li26),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_3104(t8,t4,t1);}

/* f_7400 */
static void C_ccall f_7400(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7400,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixunix.scm:1881: ##sys#signal-hook */
t5=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[120],((C_word*)t0)[2],lf[432],((C_word*)t0)[3],t4);}}

/* k6522 in setenv in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6523,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6526,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t2,((C_word*)t0)[3],lf[368]);}

/* k6525 in k6522 in setenv in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* unsetenv in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6528(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6528,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[369]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6535,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1569: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t2,lf[369]);}

/* close-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4652(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4652,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4656,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:829: ##sys#check-input-port */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[202]+1)))(5,*((C_word*)lf[202]+1),t3,t2,C_SCHEME_TRUE,lf[200]);}

/* current-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3015(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3015r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3015r(t0,t1,t2);}}

static void C_ccall f_3015r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:303: change-directory */
t5=*((C_word*)lf[63]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3028,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(4,*((C_word*)lf[66]+1),t5,C_fix(1024),C_make_character(32));}}

/* k4657 in k4655 in close-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4655 in close-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4656,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4658,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:832: posix-error */
t5=lf[2];
f_2616(6,t5,t3,lf[8],lf[200],lf[201],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k5516 */
static void C_ccall f_5518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5518,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5522,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t4=C_i_foreign_string_argumentp(t2);
/* posixunix.scm:1279: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,t4);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1310(C_SCHEME_UNDEFINED,t1,C_SCHEME_FALSE));}}

/* f_5513 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5513(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5513,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5518,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t5=C_i_foreign_string_argumentp(t2);
/* posixunix.scm:1279: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t4,t5);}
else{
t5=t4;
f_5518(2,t5,C_SCHEME_FALSE);}}

/* k2851 */
static void C_ccall f_2852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[28],t1));}

/* socket? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2854(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2854,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2861,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:233: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k3086 */
static void C_ccall f_3088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3088,2,t0,t1);}
if(C_truep(t1)){
t2=*((C_word*)lf[69]+1);
/* posix-common.scm:328: g275 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(3,*((C_word*)lf[69]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3094,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:330: directory? */
t3=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* f_7430 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7430(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7430,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(t4)){
t6=C_i_car(t3);
t7=t3;
t8=C_u_i_cdr(t7);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7438,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1891: file-close */
t10=*((C_word*)lf[164]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t8);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_FALSE);}}

/* f_7439 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7439(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[7],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7439,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(t4)){
t6=C_i_car(t3);
t7=t3;
t8=C_u_i_cdr(t7);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7447,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t6,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1897: file-close */
t10=*((C_word*)lf[164]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t8);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k7437 */
static void C_ccall f_7438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5520 in k5516 */
static void C_ccall f_5522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1310(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1));}

/* k7446 */
static void C_ccall f_7447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1898: replace-fd */
t2=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}

/* f_3560 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3560,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* f_3563 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3563,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3565,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));}

/* f_3565 */
static void C_ccall f_3565(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3565,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* check-time-vector in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3579(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3579,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:449: ##sys#error */
t6=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[100],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k4791 in create-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:884: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* f_7413 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7413(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7413,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7421,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7426,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1884: ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k5582 */
static void C_ccall f_5583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5583,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5597,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t3)){
t5=t4;
f_5597(2,t5,t3);}
else{
/* posixunix.scm:1299: rx= */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[332]+1)))(4,*((C_word*)lf[332]+1),t4,C_fix((C_word)errno),C_fix((C_word)EAGAIN));}}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(1),t1));}}

/* f_5580 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5580,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5583,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1296: ##sys#file-select-one */
t3=*((C_word*)lf[123]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* seconds->local-time in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3597(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3597r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3597r(t0,t1,t2);}}

static void C_ccall f_3597r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3602,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:451: current-seconds */
t4=*((C_word*)lf[103]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[101]);
/* posix-common.scm:453: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[102]+1)))(4,*((C_word*)lf[102]+1),t1,t4,C_SCHEME_FALSE);}}

/* regular-file? in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2809,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2816,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:218: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* rmdir in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3055(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3055,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3059,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:317: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,t2);}

/* k3058 in rmdir in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posix-common.scm:319: posix-error */
t4=lf[2];
f_2616(6,t4,((C_word*)t0)[2],lf[8],lf[67],lf[68],((C_word*)t0)[3]);}}

/* f_7421 */
static void C_ccall f_7421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7421,2,t0,t1);}
/* posixunix.scm:1886: create-pipe */
t2=*((C_word*)lf[212]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* f_7426 */
static void C_ccall f_7426(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7426,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* ##sys#custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5555(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr5r,(void*)f_5555r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_5555r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_5555r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a=C_alloc(9);
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(1):C_i_car(t9));
t12=C_i_nullp(t9);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t14=C_i_nullp(t13);
t15=(C_truep(t14)?*((C_word*)lf[330]+1):C_i_car(t13));
t16=C_i_nullp(t13);
t17=(C_truep(t16)?C_SCHEME_END_OF_LIST:C_i_cdr(t13));
t18=C_i_nullp(t17);
t19=(C_truep(t18)?C_SCHEME_FALSE:C_i_car(t17));
t20=C_i_nullp(t17);
t21=(C_truep(t20)?C_SCHEME_END_OF_LIST:C_i_cdr(t17));
t22=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5575,a[2]=t11,a[3]=t2,a[4]=t4,a[5]=t3,a[6]=t19,a[7]=t1,a[8]=t15,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t7)){
/* posixunix.scm:1289: ##sys#file-nonblocking! */
t23=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t23+1)))(3,t23,t22,t4);}
else{
t23=t22;
f_5575(2,t23,C_SCHEME_UNDEFINED);}}

/* k5552 in file-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1284: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],lf[327],lf[328],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* file-write-access? in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5404(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5404,3,t0,t1,t2);}
/* posixunix.scm:1219: check */
f_5378(t1,t2,C_fix((C_word)W_OK),lf[314]);}

/* k7470 in k7468 in k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7471,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_7477,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm:1910: swapped-ends */
t3=((C_word*)t0)[10];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[12]);}

/* k7476 in k7470 in k7468 in k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7477,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7480,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_7482,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[3],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],a[14]=((C_word)li244),tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm:1911: process-fork */
t4=*((C_word*)lf[416]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* create-session in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5416,2,t0,t1);}
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5420,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5425,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1225: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* file-execute-access? in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5410(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5410,3,t0,t1,t2);}
/* posixunix.scm:1220: check */
f_5378(t1,t2,C_fix((C_word)X_OK),lf[315]);}

/* k7484 */
static void C_ccall f_7485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7485,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7487,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7498,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1914: swapped-ends */
t4=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[12]);}

/* f_7482 in k7476 in k7470 in k7468 in k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_7482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7482,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7485,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1913: connect-child */
t3=((C_word*)t0)[5];
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[6],((C_word*)t0)[12],((C_word*)t0)[13],*((C_word*)lf[37]+1));}

/* k7479 in k7476 in k7470 in k7468 in k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 in ... */
static void C_ccall f_7480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1909: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k7488 in k7486 in k7484 */
static void C_ccall f_7489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1916: process-execute */
t2=*((C_word*)lf[419]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k7486 in k7484 */
static void C_ccall f_7487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7487,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7489,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7495,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1915: swapped-ends */
t4=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[10]);}

/* file-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5535(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5535,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[326]);
t5=C_i_check_string_2(t3,lf[326]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5553,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1283: link */
t7=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,t2,t3);}

/* f_7797 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7797(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7797,3,t0,t1,t2);}
t3=C_setgid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7805,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1030: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* f_7794 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7794(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7794,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1099(C_SCHEME_UNDEFINED));}

/* k5419 in create-session in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5420(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5424 in create-session in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1226: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[316],lf[317]);}

/* f_7451 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7451(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7451,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_i_cdr(t2);
t4=t2;
t5=C_u_i_car(t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_a_i_cons(&a,2,t3,t5));}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* k3097 in k3077 in k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:334: rmdir */
f_3055(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5432,2,t0,t1);}
t2=C_mutate((C_word*)lf[318]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[319]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5434,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5465,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[66]+1)))(4,*((C_word*)lf[66]+1),t4,t5,C_make_character(32));}

/* create-symbolic-link in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5434(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5434,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[319]);
t5=C_i_check_string_2(t3,lf[319]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5453,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5462,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1255: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k3092 in k3086 */
static void C_ccall f_3094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:328: g275 */
f_3055(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[69]+1);
/* posix-common.scm:328: g275 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(3,*((C_word*)lf[69]+1),((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k2596 in k2594 */
static void C_ccall f_2597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2597,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2599,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_7463(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7463,NULL,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7467,a[2]=t1,a[3]=t3,a[4]=t4,a[5]=t5,a[6]=((C_word*)t0)[2],a[7]=t2,a[8]=t8,a[9]=((C_word*)t0)[3],a[10]=t6,a[11]=t7,a[12]=((C_word*)t0)[4],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1906: needed-pipe */
t10=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,t7);}

/* k2594 */
static void C_ccall f_2595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2595,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2597,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_irregex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2598 in k2596 in k2594 */
static void C_ccall f_2599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2599,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2601,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7467,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_7469,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm:1907: needed-pipe */
t3=((C_word*)t0)[12];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[7],((C_word*)t0)[10]);}

/* k7468 in k7466 in spawn in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7469,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_7471,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm:1908: needed-pipe */
t3=((C_word*)t0)[13];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[8],((C_word*)t0)[9]);}

/* k3196 in k3186 in k3181 in k3177 in loop in k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3197,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k5455 in k5452 in create-symbolic-link in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_symlink(((C_word*)t0)[2],t1);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1258: posix-error */
t3=lf[2];
f_2616(7,t3,((C_word*)t0)[3],lf[8],lf[320],lf[321],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* f_3570 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3570,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3572,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp));}

/* f_3572 */
static void C_ccall f_3572(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3572,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k5452 in create-symbolic-link in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5453,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5456,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5459,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1256: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,((C_word*)t0)[4]);}

/* k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[39],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3577,2,t0,t1);}
t2=C_mutate((C_word*)lf[98]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate(&lf[99] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3579,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[101]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3597,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[104]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3618,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3639,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp);
t7=C_mutate((C_word*)lf[105]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3648,a[2]=t6,a[3]=((C_word)li56),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[107]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3683,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3698,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3704,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp);
t11=C_mutate((C_word*)lf[111]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3710,a[2]=t10,a[3]=t9,a[4]=((C_word)li60),tmp=(C_word)a,a+=5,tmp));
t12=C_mutate((C_word*)lf[114]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3758,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3772,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7882,a[2]=((C_word)li272),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:499: getter-with-setter */
t15=*((C_word*)lf[443]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t13,t14,*((C_word*)lf[114]+1));}

/* k5458 in k5452 in create-symbolic-link in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1256: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[319]);}

/* k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4976(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4976,2,t0,t1);}
t2=C_mutate((C_word*)lf[251]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4980,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7811,a[2]=((C_word)li267),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7814,a[2]=((C_word)li268),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1016: getter-with-setter */
t6=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[453]);}

/* k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word ab[257],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5465,2,t0,t1);}
t2=C_mutate((C_word*)lf[322]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5466,a[2]=t1,a[3]=((C_word)li146),tmp=(C_word)a,a+=4,tmp));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5513,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp);
t4=C_mutate((C_word*)lf[326]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5535,a[2]=t3,a[3]=((C_word)li148),tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[329]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5555,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[347]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6005,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[351]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6245,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6281,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t13=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6339,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[356]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6354,a[2]=t11,a[3]=t9,a[4]=((C_word)li178),tmp=(C_word)a,a+=5,tmp));
t15=C_mutate((C_word*)lf[358]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6370,a[2]=t11,a[3]=t9,a[4]=((C_word)li179),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate((C_word*)lf[360]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6386,a[2]=t11,a[3]=t9,a[4]=((C_word)li181),tmp=(C_word)a,a+=5,tmp));
t17=C_mutate((C_word*)lf[362]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6411,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[364]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6436,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[34]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6472,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[368]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6514,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[369]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6528,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t22=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6537,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp);
t23=C_mutate((C_word*)lf[370]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6546,a[2]=t22,a[3]=((C_word)li190),tmp=(C_word)a,a+=4,tmp));
t24=C_mutate((C_word*)lf[371]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t25=C_mutate((C_word*)lf[372]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t26=C_mutate((C_word*)lf[373]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t27=C_mutate((C_word*)lf[374]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t28=C_mutate((C_word*)lf[375]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t29=C_mutate((C_word*)lf[376]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t30=C_mutate((C_word*)lf[377]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t31=C_mutate((C_word*)lf[378]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t32=C_mutate((C_word*)lf[379]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t33=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6613,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp);
t34=C_mutate((C_word*)lf[380]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6637,a[2]=t33,a[3]=((C_word)li192),tmp=(C_word)a,a+=4,tmp));
t35=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6679,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp);
t36=C_mutate((C_word*)lf[386]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6691,a[2]=t35,a[3]=((C_word)li194),tmp=(C_word)a,a+=4,tmp));
t37=C_mutate((C_word*)lf[388]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6721,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[389]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6730,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t39=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6736,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp);
t40=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6742,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp);
t41=C_mutate((C_word*)lf[111]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6748,a[2]=t40,a[3]=t39,a[4]=((C_word)li199),tmp=(C_word)a,a+=5,tmp));
t42=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6796,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp);
t43=C_mutate((C_word*)lf[392]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6798,a[2]=t42,a[3]=((C_word)li201),tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[394]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6827,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[396]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6842,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6850,a[2]=((C_word)li204),tmp=(C_word)a,a+=3,tmp);
t47=C_mutate((C_word*)lf[397]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6855,a[2]=t46,a[3]=((C_word)li205),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[398]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6868,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[399]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6875,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[405]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6934,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate(&lf[406] /* (set! ##sys#terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6951,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6972,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[408]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6981,a[2]=t52,a[3]=((C_word)li211),tmp=(C_word)a,a+=4,tmp));
t54=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6991,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp);
t55=C_mutate((C_word*)lf[409]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7002,a[2]=t54,a[3]=((C_word)li213),tmp=(C_word)a,a+=4,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7030,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp);
t57=C_mutate((C_word*)lf[414]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7036,a[2]=t56,a[3]=((C_word)li215),tmp=(C_word)a,a+=4,tmp));
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7047,a[2]=((C_word)li216),tmp=(C_word)a,a+=3,tmp);
t59=C_mutate((C_word*)lf[416]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7049,a[2]=t58,a[3]=((C_word)li218),tmp=(C_word)a,a+=4,tmp));
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7089,a[2]=((C_word)li219),tmp=(C_word)a,a+=3,tmp);
t61=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7107,a[2]=((C_word)li220),tmp=(C_word)a,a+=3,tmp);
t62=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7109,a[2]=((C_word)li221),tmp=(C_word)a,a+=3,tmp);
t63=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7127,a[2]=((C_word)li222),tmp=(C_word)a,a+=3,tmp);
t64=*((C_word*)lf[418]+1);
t65=C_mutate((C_word*)lf[419]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7129,a[2]=t63,a[3]=t61,a[4]=t62,a[5]=t60,a[6]=t64,a[7]=((C_word)li225),tmp=(C_word)a,a+=8,tmp));
t66=C_mutate((C_word*)lf[119]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7266,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[421]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7282,a[2]=((C_word)li227),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[422]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7286,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[423]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7293,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[425]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7316,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[429]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7325,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[431]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7331,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp));
t73=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7367,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp);
t74=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7379,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp);
t75=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7413,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7430,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp);
t77=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7439,a[2]=t73,a[3]=((C_word)li242),tmp=(C_word)a,a+=4,tmp);
t78=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7451,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp);
t79=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7463,a[2]=t77,a[3]=t78,a[4]=t75,a[5]=((C_word)li245),tmp=(C_word)a,a+=6,tmp);
t80=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7499,a[2]=t76,a[3]=((C_word)li246),tmp=(C_word)a,a+=4,tmp);
t81=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7509,a[2]=t76,a[3]=((C_word)li247),tmp=(C_word)a,a+=4,tmp);
t82=C_mutate((C_word*)lf[433]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7519,a[2]=t79,a[3]=t80,a[4]=t74,a[5]=t81,a[6]=((C_word)li250),tmp=(C_word)a,a+=7,tmp));
t83=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7564,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp);
t84=C_mutate((C_word*)lf[435]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7627,a[2]=t83,a[3]=((C_word)li257),tmp=(C_word)a,a+=4,tmp));
t85=C_mutate((C_word*)lf[436]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7671,a[2]=t83,a[3]=((C_word)li258),tmp=(C_word)a,a+=4,tmp));
t86=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7710,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp);
t87=C_mutate((C_word*)lf[438]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7722,a[2]=t86,a[3]=((C_word)li260),tmp=(C_word)a,a+=4,tmp));
t88=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t88+1)))(2,t88,C_SCHEME_UNDEFINED);}

/* read-symbolic-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5466(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3r,(void*)f_5466r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5466r(t0,t1,t2,t3);}}

static void C_ccall f_5466r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(9);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[322]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5476,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5505,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1268: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}

/* k5461 in create-symbolic-link in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1255: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[319]);}

/* k4968 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:999: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[248],lf[250]);}

/* k4960 in k4957 in k4954 in k4951 in k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4961,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4964,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k4963 in k4960 in k4957 in k4954 in k4951 in k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4964,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list5(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1));}

/* k5475 in read-symbolic-link in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5476,2,t0,t1);}
t2=C_do_readlink(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
if(C_truep(((C_word*)t0)[3])){
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm:1272: posix-error */
t3=lf[2];
f_2616(6,t3,((C_word*)t0)[4],lf[8],lf[322],lf[323],((C_word*)t0)[5]);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5490,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1273: substring */
t4=*((C_word*)lf[325]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[2],C_fix(0),t2);}}

/* k4957 in k4954 in k4951 in k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4958,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4961,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k4954 in k4951 in k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4955,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4958,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k4951 in k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4952,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4955,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k4605 in open-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4606,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixunix.scm:809: check */
f_4564(((C_word*)t0)[3],lf[195],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3154,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:347: posix-error */
t3=lf[2];
f_2616(6,t3,((C_word*)t0)[3],lf[8],lf[25],lf[74],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3168,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li28),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3168(t6,((C_word*)t0)[3]);}}

/* k4945 in system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4946(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4946,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4952,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3151,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3154,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3227,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:345: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,((C_word*)t0)[4]);}

/* loop in k3153 in k3150 in k3148 in k3146 in k3136 in directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3168(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3168,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3178,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:355: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[64]+1)))(5,*((C_word*)lf[64]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* system-information in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4942(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4942,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4946,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4969,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:998: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t3);}
else{
t3=t2;
f_4946(2,t3,C_SCHEME_UNDEFINED);}}

/* k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4116(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4116,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4118,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[6])){
t3=C_i_check_number_2(((C_word*)t0)[6],lf[174]);
t4=C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],C_fix(1));
t5=t2;
f_4118(t5,C_C_select_t(t4,((C_word*)t0)[6]));}
else{
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],C_fix(1));
t4=t2;
f_4118(t4,C_C_select(t3));}}

/* k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4118(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4118,NULL,2,t0,t1);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:696: posix-error */
t2=lf[2];
f_2616(7,t2,((C_word*)t0)[2],lf[8],lf[174],lf[175],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=C_i_pairp(((C_word*)t0)[3]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[4]))){
/* posixunix.scm:697: values */
C_values(4,0,((C_word*)t0)[2],t4,C_SCHEME_END_OF_LIST);}
else{
/* posixunix.scm:697: values */
C_values(4,0,((C_word*)t0)[2],t4,C_SCHEME_FALSE);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4154,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm:702: fd_test */
t4=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_fix(0),((C_word*)t0)[3]);}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4212,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word)li80),tmp=(C_word)a,a+=5,tmp);
t7=((C_word*)t0)[3];
t8=C_i_check_list_2(t7,lf[70]);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4227,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4229,a[2]=t11,a[3]=t6,a[4]=((C_word)li81),tmp=(C_word)a,a+=5,tmp));
t13=((C_word*)t11)[1];
f_4229(t13,t9,t7);}}
else{
t4=t3;
f_4154(2,t4,C_SCHEME_FALSE);}}}}

/* k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4111,2,t0,t1);}
t2=C_i_not(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4116,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_4116(2,t4,t2);}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t4=C_mutate(((C_word *)((C_word*)t0)[7])+1,((C_word*)t0)[2]);
/* posixunix.scm:682: fd_set */
t5=((C_word*)t0)[8];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,C_fix(1),((C_word*)t0)[2]);}
else{
t4=C_i_check_list_2(((C_word*)t0)[2],lf[174]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4268,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word)li82),tmp=(C_word)a,a+=5,tmp);
t6=((C_word*)t0)[2];
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4280,a[2]=t8,a[3]=t5,a[4]=((C_word)li83),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_4280(t10,t3,t6);}}}

/* k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4102(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4102,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4104,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm:665: fd_zero */
t3=((C_word*)t0)[8];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(0));}

/* k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4104,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4106,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:666: fd_zero */
t3=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(1));}

/* k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4106,2,t0,t1);}
t2=C_i_not(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4111,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t2)){
t4=t3;
f_4111(2,t4,t2);}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t4=C_mutate(((C_word *)((C_word*)t0)[7])+1,((C_word*)t0)[2]);
/* posixunix.scm:670: fd_set */
t5=((C_word*)t0)[8];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,C_fix(0),((C_word*)t0)[2]);}
else{
t4=C_i_check_list_2(((C_word*)t0)[2],lf[174]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4311,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word)li84),tmp=(C_word)a,a+=5,tmp);
t6=((C_word*)t0)[2];
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4323,a[2]=t8,a[3]=t5,a[4]=((C_word)li85),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_4323(t10,t3,t6);}}}

/* process-signal in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7293(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7293r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7293r(t0,t1,t2,t3);}}

static void C_ccall f_7293r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7297,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_7297(t6,C_u_i_car(t5));}
else{
t5=t4;
f_7297(t5,C_fix((C_word)SIGTERM));}}

/* k7296 in process-signal in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_7297(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[423]);
t3=C_i_check_exact_2(t1,lf[423]);
t4=C_kill(((C_word*)t0)[2],t1);
t5=C_eqp(t4,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1830: posix-error */
t6=lf[2];
f_2616(7,t6,((C_word*)t0)[3],lf[120],lf[423],lf[424],((C_word*)t0)[2],t1);}
else{
t6=C_SCHEME_UNDEFINED;
t7=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* f_5757 in k5578 in k5574 in custom-input-port in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_5757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5757,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5760,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1359: fetch */
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3344 */
static void C_ccall f_3345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:375: ##sys#glob->regexp */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[82]+1)))(3,*((C_word*)lf[82]+1),((C_word*)t0)[2],t1);}

/* k4996 in user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_4997(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4997,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[256]+1):*((C_word*)lf[257]+1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5008,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[249]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* user-information in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4990(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_4990r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4990r(t0,t1,t2,t3);}}

static void C_ccall f_4990r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4997,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_4997(t7,C_getpwuid(t2));}
else{
t7=C_i_check_string_2(t2,lf[255]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5028,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1057: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t8,t2,lf[255]);}}

/* k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[58],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4988,2,t0,t1);}
t2=C_mutate((C_word*)lf[254]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[255]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4990,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[258]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5036,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[259]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5048,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[260]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5071,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[261]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5143,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[265]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5200,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp));
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5252,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp);
t10=C_mutate((C_word*)lf[268]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5267,a[2]=t9,a[3]=((C_word)li137),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[270]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[271]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[272]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[273]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[274]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[275]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[276]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[277]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[278]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[279]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[280]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[281]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[282]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[283]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[284]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[285]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[286]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[287]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[288]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[289]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[290]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[291]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[292]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[293] /* errno/2big */,0,C_fix(0));
t35=C_set_block_item(lf[294] /* errno/deadlk */,0,C_fix(0));
t36=C_set_block_item(lf[295] /* errno/dom */,0,C_fix(0));
t37=C_set_block_item(lf[296] /* errno/fbig */,0,C_fix(0));
t38=C_set_block_item(lf[297] /* errno/ilseq */,0,C_fix(0));
t39=C_set_block_item(lf[298] /* errno/mlink */,0,C_fix(0));
t40=C_set_block_item(lf[299] /* errno/nametoolong */,0,C_fix(0));
t41=C_set_block_item(lf[300] /* errno/nfile */,0,C_fix(0));
t42=C_set_block_item(lf[301] /* errno/nodev */,0,C_fix(0));
t43=C_set_block_item(lf[302] /* errno/nolck */,0,C_fix(0));
t44=C_set_block_item(lf[303] /* errno/nosys */,0,C_fix(0));
t45=C_set_block_item(lf[304] /* errno/notempty */,0,C_fix(0));
t46=C_set_block_item(lf[305] /* errno/notty */,0,C_fix(0));
t47=C_set_block_item(lf[306] /* errno/nxio */,0,C_fix(0));
t48=C_set_block_item(lf[307] /* errno/range */,0,C_fix(0));
t49=C_set_block_item(lf[308] /* errno/xdev */,0,C_fix(0));
t50=C_mutate((C_word*)lf[309]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5328,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[311]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5352,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5378,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[313]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5398,a[2]=t52,a[3]=((C_word)li141),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[314]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5404,a[2]=t52,a[3]=((C_word)li142),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[315]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5410,a[2]=t52,a[3]=((C_word)li143),tmp=(C_word)a,a+=4,tmp));
t56=C_mutate((C_word*)lf[316]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5416,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5432,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7743,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7758,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1230: getter-with-setter */
t60=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t60+1)))(5,t60,t57,t58,t59,lf[444]);}

/* k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4984,2,t0,t1);}
t2=C_mutate((C_word*)lf[253]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4988,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7777,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7780,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1035: getter-with-setter */
t6=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[447]);}

/* loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3367(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3367,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3384,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:407: directory? */
t7=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4980,2,t0,t1);}
t2=C_mutate((C_word*)lf[252]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4984,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7794,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7797,a[2]=((C_word)li266),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1026: getter-with-setter */
t6=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[450]);}

/* k4156 in k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:699: values */
C_values(4,0,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k4153 in k4117 in k4114 in k4109 in k4105 in k4103 in k4101 in file-select in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4154,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4157,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm:708: fd_test */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_fix(1),((C_word*)t0)[3]);}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4167,a[2]=t4,a[3]=((C_word*)t0)[4],a[4]=((C_word)li78),tmp=(C_word)a,a+=5,tmp);
t6=((C_word*)t0)[3];
t7=C_i_check_list_2(t6,lf[70]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4182,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4184,a[2]=t10,a[3]=t5,a[4]=((C_word)li79),tmp=(C_word)a,a+=5,tmp));
t12=((C_word*)t10)[1];
f_4184(t12,t8,t6);}}
else{
/* posixunix.scm:699: values */
C_values(4,0,((C_word*)t0)[2],t1,C_SCHEME_FALSE);}}

/* k4671 in k4669 in close-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4669 in close-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4670,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4672,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:839: posix-error */
t5=lf[2];
f_2616(6,t5,t3,lf[8],lf[203],lf[204],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* parent-process-id in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7282,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1908(C_SCHEME_UNDEFINED));}

/* sleep in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7286(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7286,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1912(C_SCHEME_UNDEFINED,t3));}

/* k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3365,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3367,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word)li39),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_3367(t5,((C_word*)t0)[7],t1,((C_word*)t0)[8]);}

/* k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3359(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3359,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3365,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3495,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[8])){
/* posix-common.scm:401: make-pathname */
t4=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[9],lf[89]);}
else{
/* posix-common.scm:401: make-pathname */
t4=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[9],lf[90]);}}

/* k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3357(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3357,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3359,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=C_i_stringp(((C_word*)t0)[9]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3503,a[2]=t2,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_3503(2,t5,t3);}
else{
/* posix-common.scm:397: irregex? */
t5=*((C_word*)lf[92]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[9]);}}

/* close-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4666(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4666,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4670,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:836: ##sys#check-output-port */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[205]+1)))(5,*((C_word*)lf[205]+1),t3,t2,C_SCHEME_TRUE,lf[203]);}

/* open-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_4615r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4615r(t0,t1,t2,t3);}}

static void C_ccall f_4615r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[199]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[196]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4628,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[196]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4634,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:824: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[199]);}
else{
t9=C_eqp(t6,lf[197]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4643,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:825: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t10,t2,lf[199]);}
else{
/* posixunix.scm:798: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[198],t6);}}}

/* ##sys#process-wait in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_7266(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7266,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
if(C_truep(t6)){
t7=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
/* posixunix.scm:1812: values */
C_values(5,0,t1,t5,t6,t7);}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
t7=C_WTERMSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1812: values */
C_values(5,0,t1,t5,t6,t7);}
else{
t7=C_WSTOPSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1812: values */
C_values(5,0,t1,t5,t6,t7);}}}

/* k4705 in call-with-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4706(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4706,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4711,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4716,a[2]=t1,a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:854: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t2,t3);}

/* call-with-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4702(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4702r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4702r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4702r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4706,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[199]+1),t2,t4);}

/* k3382 in loop in k3364 in k3358 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3384,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3477,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:408: pathname-file */
t3=*((C_word*)lf[88]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3483,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:417: pproc */
t3=((C_word*)t0)[9];
((C_proc3)C_fast_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[8]);}}

/* call-with-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4680(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4680r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4680r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4680r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4684,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[195]+1),t2,t4);}

/* f_4689 in k4683 in call-with-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4689,2,t0,t1);}
/* posixunix.scm:846: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k4683 in call-with-input-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4684,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4689,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4694,a[2]=t1,a[3]=((C_word)li102),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:845: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t2,t3);}

/* k4633 in open-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4634,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixunix.scm:820: check */
f_4564(((C_word*)t0)[3],lf[199],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* for-each-loop264 in k3077 in k3072 in delete-directory in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_3104(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3104,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3113,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:323: g265 */
t5=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4626 in open-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4628(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:820: check */
f_4564(((C_word*)t0)[3],lf[199],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3536,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3538,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3563,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t2,lf[96],((C_word*)t0)[4],t3);}

/* k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3538(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3538,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3540,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3560,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t2,lf[95],((C_word*)t0)[5],t3);}

/* f_3554 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3554,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* f_3551 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3551,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k6890 in k6882 in k6880 in k6878 in set-buffering-mode! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6892(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1709: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[399],lf[400],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* f_4743 */
static void C_ccall f_4743(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4743r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4743r(t0,t1,t2);}}

static void C_ccall f_4743r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4746,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:866: close-input-pipe */
t4=*((C_word*)lf[200]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* f_3526 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3526(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3526,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));}

/* k4745 */
static void C_ccall f_4746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3544,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3546,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3551,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t2,lf[73],((C_word*)t0)[8],t3);}

/* k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3542,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3544,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3554,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t2,lf[72],((C_word*)t0)[7],t3);}

/* k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3540,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3542,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3557,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:420: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[93]+1)))(5,*((C_word*)lf[93]+1),t2,lf[94],((C_word*)t0)[6],t3);}

/* k4642 in open-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4643(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4643,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixunix.scm:820: check */
f_4564(((C_word*)t0)[3],lf[199],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k6880 in k6878 in set-buffering-mode! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_fcall f_6881(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6881,NULL,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6884,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(t2,lf[401]);
if(C_truep(t4)){
t5=t3;
f_6884(2,t5,C_fix((C_word)_IOFBF));}
else{
t5=C_eqp(t2,lf[402]);
if(C_truep(t5)){
t6=C_fix((C_word)_IOLBF);
t7=t3;
f_6884(2,t7,t6);}
else{
t6=C_eqp(t2,lf[403]);
if(C_truep(t6)){
t7=t3;
f_6884(2,t7,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm:1703: ##sys#error */
t7=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t3,lf[399],lf[404],((C_word*)t0)[2],((C_word*)t0)[4]);}}}}

/* k6882 in k6880 in k6878 in set-buffering-mode! in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6884,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[399]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6892,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t4=C_slot(((C_word*)t0)[4],C_fix(7));
t5=C_eqp(lf[51],t4);
if(C_truep(t5)){
t6=C_setvbuf(((C_word*)t0)[4],t1,((C_word*)t0)[2]);
t7=t3;
f_6892(t7,C_fixnum_lessp(t6,C_fix(0)));}
else{
t6=t3;
f_6892(t6,C_SCHEME_TRUE);}}

/* f_4733 in k4727 in with-input-from-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4733,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[209]+1));
t3=C_mutate((C_word*)lf[209]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* f_3557 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3557,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* f_4738 in k4727 in with-input-from-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4738,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4743,a[2]=((C_word*)t0)[2],a[3]=((C_word)li108),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:864: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* with-input-from-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4724r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4724r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4724r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4728,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[195]+1),t2,t4);}

/* k4727 in with-input-from-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4728,2,t0,t1);}
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4733,a[2]=t5,a[3]=t3,a[4]=((C_word)li107),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4738,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li109),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4751,a[2]=t3,a[3]=t5,a[4]=((C_word)li110),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:861: ##sys#dynamic-wind */
t9=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,((C_word*)t0)[3],t6,t7,t8);}

/* k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3546,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=((C_word*)t0)[8];
t9=C_i_check_string_2(t3,lf[71]);
t10=C_fix(0);
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3357,a[2]=t1,a[3]=t5,a[4]=t11,a[5]=t2,a[6]=t6,a[7]=t8,a[8]=t3,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3526,a[2]=t11,a[3]=t7,a[4]=((C_word)li41),tmp=(C_word)a,a+=5,tmp);
t14=t12;
f_3357(t14,t13);}
else{
t13=t12;
f_3357(t13,t7);}}
else{
t13=t12;
f_3357(t13,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3517,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp));}}

/* f_4716 in k4705 in call-with-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4716(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4716r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4716r(t0,t1,t2);}}

static void C_ccall f_4716r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4719,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:857: close-output-pipe */
t4=*((C_word*)lf[203]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4718 */
static void C_ccall f_4719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* f_4711 in k4705 in call-with-output-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
/* posixunix.scm:855: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k3307 in loop in k3290 in k3284 */
static void C_ccall f_3308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3308,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3312,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li31),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:373: g355 */
t3=t2;
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:383: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3293(t4,((C_word*)t0)[5],t3);}}

/* f_6850 in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6850(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6850,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1736(C_SCHEME_UNDEFINED,t3));}

/* _exit in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6855(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_6855r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6855r(t0,t1,t2);}}

static void C_ccall f_6855r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
/* posixunix.scm:1686: ex0 */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
/* posixunix.scm:1686: ex0 */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t1,C_fix(0));}}

/* create-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4788,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4792,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_pipe(C_SCHEME_FALSE);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:883: posix-error */
t4=lf[2];
f_2616(5,t4,t2,lf[8],lf[212],lf[213]);}
else{
/* posixunix.scm:884: values */
C_values(4,0,t1,C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* f_4783 in k4759 in with-output-to-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4783,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[211]+1));
t3=C_mutate((C_word*)lf[211]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3504 in k3501 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3505,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3359(t2,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3506,a[2]=t1,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp));}

/* k3501 in k3356 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3503,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3505,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:398: irregex */
t3=*((C_word*)lf[91]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
f_3359(t2,((C_word*)t0)[3]);}}

/* local-timezone-abbreviation in k5464 in k5430 in k4986 in k4982 in k4978 in k4974 in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_6842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6842,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1730(t2);
/* posixunix.scm:1670: ##sys#peek-c-string */
t4=*((C_word*)lf[0]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t3,C_fix(0));}

/* f_4770 in k4759 in with-output-to-pipe in k4400 in k3770 in k3575 in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_4770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4770,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4775,a[2]=((C_word*)t0)[2],a[3]=((C_word)li113),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:872: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* f_3517 in k3545 in k3543 in k3541 in k3539 in k3537 in k3535 in find-files in k2691 in k2604 in k2602 in k2600 in k2598 in k2596 in k2594 */
static void C_ccall f_3517(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3517,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k4777 */
static void C_ccall f_4778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* f_4775 */
static void C_ccall f_4775(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4775r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4775r(t0,t1,t2);}}

static void C_ccall f_4775r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4778,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:874: close-output-pipe */
t4=*((C_word*)lf[203]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3326 */
static void C_ccall f_3327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:381: make-pathname */
t2=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[659] = {
{"f_3532:posixunix_2escm",(void*)f_3532},
{"f_6875:posixunix_2escm",(void*)f_6875},
{"f_4760:posixunix_2escm",(void*)f_4760},
{"f_3321:posixunix_2escm",(void*)f_3321},
{"f_3506:posixunix_2escm",(void*)f_3506},
{"f_4765:posixunix_2escm",(void*)f_4765},
{"f_3182:posixunix_2escm",(void*)f_3182},
{"f_6879:posixunix_2escm",(void*)f_6879},
{"f_3318:posixunix_2escm",(void*)f_3318},
{"f_7710:posixunix_2escm",(void*)f_7710},
{"f_4494:posixunix_2escm",(void*)f_4494},
{"f_7715:posixunix_2escm",(void*)f_7715},
{"f_4751:posixunix_2escm",(void*)f_4751},
{"f_3312:posixunix_2escm",(void*)f_3312},
{"f_4756:posixunix_2escm",(void*)f_4756},
{"f_6868:posixunix_2escm",(void*)f_6868},
{"f_3188:posixunix_2escm",(void*)f_3188},
{"f_7722:posixunix_2escm",(void*)f_7722},
{"f_7738:posixunix_2escm",(void*)f_7738},
{"f_7226:posixunix_2escm",(void*)f_7226},
{"f_3178:posixunix_2escm",(void*)f_3178},
{"f_7748:posixunix_2escm",(void*)f_7748},
{"f_3113:posixunix_2escm",(void*)f_3113},
{"f_6442:posixunix_2escm",(void*)f_6442},
{"f_7743:posixunix_2escm",(void*)f_7743},
{"f_7758:posixunix_2escm",(void*)f_7758},
{"f_7753:posixunix_2escm",(void*)f_7753},
{"f_3133:posixunix_2escm",(void*)f_3133},
{"f_5718:posixunix_2escm",(void*)f_5718},
{"f_3149:posixunix_2escm",(void*)f_3149},
{"f_5711:posixunix_2escm",(void*)f_5711},
{"f_3147:posixunix_2escm",(void*)f_3147},
{"f_5713:posixunix_2escm",(void*)f_5713},
{"f_5715:posixunix_2escm",(void*)f_5715},
{"f_7777:posixunix_2escm",(void*)f_7777},
{"f_5765:posixunix_2escm",(void*)f_5765},
{"f_5760:posixunix_2escm",(void*)f_5760},
{"f_3137:posixunix_2escm",(void*)f_3137},
{"f_3947:posixunix_2escm",(void*)f_3947},
{"f_7771:posixunix_2escm",(void*)f_7771},
{"f_7788:posixunix_2escm",(void*)f_7788},
{"f_5774:posixunix_2escm",(void*)f_5774},
{"f_5772:posixunix_2escm",(void*)f_5772},
{"f_3934:posixunix_2escm",(void*)f_3934},
{"f_3949:posixunix_2escm",(void*)f_3949},
{"f_7780:posixunix_2escm",(void*)f_7780},
{"f_5745:posixunix_2escm",(void*)f_5745},
{"f_3964:posixunix_2escm",(void*)f_3964},
{"f_3938:posixunix_2escm",(void*)f_3938},
{"f_6255:posixunix_2escm",(void*)f_6255},
{"f_7845:posixunix_2escm",(void*)f_7845},
{"f_7848:posixunix_2escm",(void*)f_7848},
{"f_5607:posixunix_2escm",(void*)f_5607},
{"f_6245:posixunix_2escm",(void*)f_6245},
{"f_7859:posixunix_2escm",(void*)f_7859},
{"f_7850:posixunix_2escm",(void*)f_7850},
{"f_5726:posixunix_2escm",(void*)f_5726},
{"f_5720:posixunix_2escm",(void*)f_5720},
{"f_3904:posixunix_2escm",(void*)f_3904},
{"f_3958:posixunix_2escm",(void*)f_3958},
{"f_5614:posixunix_2escm",(void*)f_5614},
{"f_7828:posixunix_2escm",(void*)f_7828},
{"f_7822:posixunix_2escm",(void*)f_7822},
{"f_5737:posixunix_2escm",(void*)f_5737},
{"f_5625:posixunix_2escm",(void*)f_5625},
{"f_4833:posixunix_2escm",(void*)f_4833},
{"f_7208:posixunix_2escm",(void*)f_7208},
{"f_4838:posixunix_2escm",(void*)f_4838},
{"f_7882:posixunix_2escm",(void*)f_7882},
{"f_3915:posixunix_2escm",(void*)f_3915},
{"f_5645:posixunix_2escm",(void*)f_5645},
{"f_5643:posixunix_2escm",(void*)f_5643},
{"f_7890:posixunix_2escm",(void*)f_7890},
{"f_5675:posixunix_2escm",(void*)f_5675},
{"f_5677:posixunix_2escm",(void*)f_5677},
{"f_4280:posixunix_2escm",(void*)f_4280},
{"f_4289:posixunix_2escm",(void*)f_4289},
{"f_5682:posixunix_2escm",(void*)f_5682},
{"f_7073:posixunix_2escm",(void*)f_7073},
{"f_7074:posixunix_2escm",(void*)f_7074},
{"f_3780:posixunix_2escm",(void*)f_3780},
{"f_3980:posixunix_2escm",(void*)f_3980},
{"f_3772:posixunix_2escm",(void*)f_3772},
{"f_3774:posixunix_2escm",(void*)f_3774},
{"f_3988:posixunix_2escm",(void*)f_3988},
{"f_6297:posixunix_2escm",(void*)f_6297},
{"f_6293:posixunix_2escm",(void*)f_6293},
{"f_3992:posixunix_2escm",(void*)f_3992},
{"f_3990:posixunix_2escm",(void*)f_3990},
{"f_4402:posixunix_2escm",(void*)f_4402},
{"f_4404:posixunix_2escm",(void*)f_4404},
{"f_6281:posixunix_2escm",(void*)f_6281},
{"f_7089:posixunix_2escm",(void*)f_7089},
{"f_4429:posixunix_2escm",(void*)f_4429},
{"f_7097:posixunix_2escm",(void*)f_7097},
{"f_4420:posixunix_2escm",(void*)f_4420},
{"f_4212:posixunix_2escm",(void*)f_4212},
{"f_4218:posixunix_2escm",(void*)f_4218},
{"f_4415:posixunix_2escm",(void*)f_4415},
{"f_4413:posixunix_2escm",(void*)f_4413},
{"f_4441:posixunix_2escm",(void*)f_4441},
{"f_4440:posixunix_2escm",(void*)f_4440},
{"f_4238:posixunix_2escm",(void*)f_4238},
{"f_2725:posixunix_2escm",(void*)f_2725},
{"f_2723:posixunix_2escm",(void*)f_2723},
{"f_6457:posixunix_2escm",(void*)f_6457},
{"f_4438:posixunix_2escm",(void*)f_4438},
{"f_4431:posixunix_2escm",(void*)f_4431},
{"f_4229:posixunix_2escm",(void*)f_4229},
{"f_4227:posixunix_2escm",(void*)f_4227},
{"f_4460:posixunix_2escm",(void*)f_4460},
{"f_4468:posixunix_2escm",(void*)f_4468},
{"f_4466:posixunix_2escm",(void*)f_4466},
{"f_3724:posixunix_2escm",(void*)f_3724},
{"f_2955:posixunix_2escm",(void*)f_2955},
{"f_6479:posixunix_2escm",(void*)f_6479},
{"f_4454:posixunix_2escm",(void*)f_4454},
{"f_6472:posixunix_2escm",(void*)f_6472},
{"f_4481:posixunix_2escm",(void*)f_4481},
{"f_6460:posixunix_2escm",(void*)f_6460},
{"f_4591:posixunix_2escm",(void*)f_4591},
{"f_4597:posixunix_2escm",(void*)f_4597},
{"f_3735:posixunix_2escm",(void*)f_3735},
{"f_2911:posixunix_2escm",(void*)f_2911},
{"f_4473:posixunix_2escm",(void*)f_4473},
{"f_3733:posixunix_2escm",(void*)f_3733},
{"f_6411:posixunix_2escm",(void*)f_6411},
{"f_2705:posixunix_2escm",(void*)f_2705},
{"f_2707:posixunix_2escm",(void*)f_2707},
{"f_2701:posixunix_2escm",(void*)f_2701},
{"f_6436:posixunix_2escm",(void*)f_6436},
{"f_6154:posixunix_2escm",(void*)f_6154},
{"f_2936:posixunix_2escm",(void*)f_2936},
{"f_2938:posixunix_2escm",(void*)f_2938},
{"f_5386:posixunix_2escm",(void*)f_5386},
{"f_7042:posixunix_2escm",(void*)f_7042},
{"f_7040:posixunix_2escm",(void*)f_7040},
{"f_2951:posixunix_2escm",(void*)f_2951},
{"f_7049:posixunix_2escm",(void*)f_7049},
{"f_7047:posixunix_2escm",(void*)f_7047},
{"f_6139:posixunix_2escm",(void*)f_6139},
{"f_6270:posixunix_2escm",(void*)f_6270},
{"f_5854:posixunix_2escm",(void*)f_5854},
{"f_6138:posixunix_2escm",(void*)f_6138},
{"f_5393:posixunix_2escm",(void*)f_5393},
{"f_2949:posixunix_2escm",(void*)f_2949},
{"f_5396:posixunix_2escm",(void*)f_5396},
{"f_7053:posixunix_2escm",(void*)f_7053},
{"f_5398:posixunix_2escm",(void*)f_5398},
{"f_6267:posixunix_2escm",(void*)f_6267},
{"f_6261:posixunix_2escm",(void*)f_6261},
{"f_6126:posixunix_2escm",(void*)f_6126},
{"f_2741:posixunix_2escm",(void*)f_2741},
{"f_3717:posixunix_2escm",(void*)f_3717},
{"f_7021:posixunix_2escm",(void*)f_7021},
{"f_6938:posixunix_2escm",(void*)f_6938},
{"f_3710:posixunix_2escm",(void*)f_3710},
{"f_7025:posixunix_2escm",(void*)f_7025},
{"f_7028:posixunix_2escm",(void*)f_7028},
{"f_2713:posixunix_2escm",(void*)f_2713},
{"f_2717:posixunix_2escm",(void*)f_2717},
{"f_2719:posixunix_2escm",(void*)f_2719},
{"f_6119:posixunix_2escm",(void*)f_6119},
{"f_2711:posixunix_2escm",(void*)f_2711},
{"f_6934:posixunix_2escm",(void*)f_6934},
{"f_6107:posixunix_2escm",(void*)f_6107},
{"f_5347:posixunix_2escm",(void*)f_5347},
{"f_2972:posixunix_2escm",(void*)f_2972},
{"f_3693:posixunix_2escm",(void*)f_3693},
{"f_4268:posixunix_2escm",(void*)f_4268},
{"f_3698:posixunix_2escm",(void*)f_3698},
{"f_2987:posixunix_2escm",(void*)f_2987},
{"f_5352:posixunix_2escm",(void*)f_5352},
{"f_5350:posixunix_2escm",(void*)f_5350},
{"f_7554:posixunix_2escm",(void*)f_7554},
{"f_7551:posixunix_2escm",(void*)f_7551},
{"f_3683:posixunix_2escm",(void*)f_3683},
{"f_3687:posixunix_2escm",(void*)f_3687},
{"f_3758:posixunix_2escm",(void*)f_3758},
{"f_5328:posixunix_2escm",(void*)f_5328},
{"f_7564:posixunix_2escm",(void*)f_7564},
{"f_7566:posixunix_2escm",(void*)f_7566},
{"f_4926:posixunix_2escm",(void*)f_4926},
{"f_2925:posixunix_2escm",(void*)f_2925},
{"f_5195:posixunix_2escm",(void*)f_5195},
{"f_2923:posixunix_2escm",(void*)f_2923},
{"f_3704:posixunix_2escm",(void*)f_3704},
{"f_5845:posixunix_2escm",(void*)f_5845},
{"f_6709:posixunix_2escm",(void*)f_6709},
{"f_5840:posixunix_2escm",(void*)f_5840},
{"f_4910:posixunix_2escm",(void*)f_4910},
{"f_3291:posixunix_2escm",(void*)f_3291},
{"f_3293:posixunix_2escm",(void*)f_3293},
{"f_4904:posixunix_2escm",(void*)f_4904},
{"f_5170:posixunix_2escm",(void*)f_5170},
{"f_5178:posixunix_2escm",(void*)f_5178},
{"f_5092:posixunix_2escm",(void*)f_5092},
{"f_5095:posixunix_2escm",(void*)f_5095},
{"f_5097:posixunix_2escm",(void*)f_5097},
{"f_6730:posixunix_2escm",(void*)f_6730},
{"f_7030:posixunix_2escm",(void*)f_7030},
{"f_7036:posixunix_2escm",(void*)f_7036},
{"f_5881:posixunix_2escm",(void*)f_5881},
{"f_6742:posixunix_2escm",(void*)f_6742},
{"f_6748:posixunix_2escm",(void*)f_6748},
{"f_6721:posixunix_2escm",(void*)f_6721},
{"f_3257:posixunix_2escm",(void*)f_3257},
{"f_7002:posixunix_2escm",(void*)f_7002},
{"f_7006:posixunix_2escm",(void*)f_7006},
{"f_6736:posixunix_2escm",(void*)f_6736},
{"f_7381:posixunix_2escm",(void*)f_7381},
{"f_2998:posixunix_2escm",(void*)f_2998},
{"f_6163:posixunix_2escm",(void*)f_6163},
{"f_2992:posixunix_2escm",(void*)f_2992},
{"f_3442:posixunix_2escm",(void*)f_3442},
{"f_3445:posixunix_2escm",(void*)f_3445},
{"f_6771:posixunix_2escm",(void*)f_6771},
{"f_3433:posixunix_2escm",(void*)f_3433},
{"f_7379:posixunix_2escm",(void*)f_7379},
{"f_6762:posixunix_2escm",(void*)f_6762},
{"f_5071:posixunix_2escm",(void*)f_5071},
{"f_3439:posixunix_2escm",(void*)f_3439},
{"f_5078:posixunix_2escm",(void*)f_5078},
{"f_7502:posixunix_2escm",(void*)f_7502},
{"f_6773:posixunix_2escm",(void*)f_6773},
{"f_7375:posixunix_2escm",(void*)f_7375},
{"f_3465:posixunix_2escm",(void*)f_3465},
{"f_3462:posixunix_2escm",(void*)f_3462},
{"f_5089:posixunix_2escm",(void*)f_5089},
{"f_7509:posixunix_2escm",(void*)f_7509},
{"f_4537:posixunix_2escm",(void*)f_4537},
{"f_4531:posixunix_2escm",(void*)f_4531},
{"f_3453:posixunix_2escm",(void*)f_3453},
{"f_3451:posixunix_2escm",(void*)f_3451},
{"f_4529:posixunix_2escm",(void*)f_4529},
{"f_6755:posixunix_2escm",(void*)f_6755},
{"f_7395:posixunix_2escm",(void*)f_7395},
{"f_3483:posixunix_2escm",(void*)f_3483},
{"f_5373:posixunix_2escm",(void*)f_5373},
{"f_5376:posixunix_2escm",(void*)f_5376},
{"f_5378:posixunix_2escm",(void*)f_5378},
{"f_3489:posixunix_2escm",(void*)f_3489},
{"f_4519:posixunix_2escm",(void*)f_4519},
{"f_4517:posixunix_2escm",(void*)f_4517},
{"f_4511:posixunix_2escm",(void*)f_4511},
{"f_7367:posixunix_2escm",(void*)f_7367},
{"f_3471:posixunix_2escm",(void*)f_3471},
{"f_5121:posixunix_2escm",(void*)f_5121},
{"f_3477:posixunix_2escm",(void*)f_3477},
{"f_4578:posixunix_2escm",(void*)f_4578},
{"f_4576:posixunix_2escm",(void*)f_4576},
{"f_3495:posixunix_2escm",(void*)f_3495},
{"f_6796:posixunix_2escm",(void*)f_6796},
{"f_6798:posixunix_2escm",(void*)f_6798},
{"f_3639:posixunix_2escm",(void*)f_3639},
{"f_4564:posixunix_2escm",(void*)f_4564},
{"f_7950:posixunix_2escm",(void*)f_7950},
{"f_3623:posixunix_2escm",(void*)f_3623},
{"f_7570:posixunix_2escm",(void*)f_7570},
{"f_3653:posixunix_2escm",(void*)f_3653},
{"f_7579:posixunix_2escm",(void*)f_7579},
{"f_3657:posixunix_2escm",(void*)f_3657},
{"f_7512:posixunix_2escm",(void*)f_7512},
{"f_7588:posixunix_2escm",(void*)f_7588},
{"f_3648:posixunix_2escm",(void*)f_3648},
{"f_7525:posixunix_2escm",(void*)f_7525},
{"f_7519:posixunix_2escm",(void*)f_7519},
{"f_5028:posixunix_2escm",(void*)f_5028},
{"f_7910:posixunix_2escm",(void*)f_7910},
{"f_7530:posixunix_2escm",(void*)f_7530},
{"f_3405:posixunix_2escm",(void*)f_3405},
{"f_5020:posixunix_2escm",(void*)f_5020},
{"f_3408:posixunix_2escm",(void*)f_3408},
{"f_7337:posixunix_2escm",(void*)f_7337},
{"f_7335:posixunix_2escm",(void*)f_7335},
{"f_5036:posixunix_2escm",(void*)f_5036},
{"f_7920:posixunix_2escm",(void*)f_7920},
{"f_7545:posixunix_2escm",(void*)f_7545},
{"f_7542:posixunix_2escm",(void*)f_7542},
{"f_7539:posixunix_2escm",(void*)f_7539},
{"f_7331:posixunix_2escm",(void*)f_7331},
{"f_3618:posixunix_2escm",(void*)f_3618},
{"f_7918:posixunix_2escm",(void*)f_7918},
{"f_7915:posixunix_2escm",(void*)f_7915},
{"f_7191:posixunix_2escm",(void*)f_7191},
{"f_5046:posixunix_2escm",(void*)f_5046},
{"f_5048:posixunix_2escm",(void*)f_5048},
{"f_3428:posixunix_2escm",(void*)f_3428},
{"f_3426:posixunix_2escm",(void*)f_3426},
{"f_5043:posixunix_2escm",(void*)f_5043},
{"f_4372:posixunix_2escm",(void*)f_4372},
{"f_3602:posixunix_2escm",(void*)f_3602},
{"f_7548:posixunix_2escm",(void*)f_7548},
{"f_7929:posixunix_2escm",(void*)f_7929},
{"f_7924:posixunix_2escm",(void*)f_7924},
{"f_7355:posixunix_2escm",(void*)f_7355},
{"f_5101:posixunix_2escm",(void*)f_5101},
{"f_7358:posixunix_2escm",(void*)f_7358},
{"f_3277:posixunix_2escm",(void*)f_3277},
{"f_3417:posixunix_2escm",(void*)f_3417},
{"f_7938:posixunix_2escm",(void*)f_7938},
{"f_3263:posixunix_2escm",(void*)f_3263},
{"f_5110:posixunix_2escm",(void*)f_5110},
{"f_7325:posixunix_2escm",(void*)f_7325},
{"f_7320:posixunix_2escm",(void*)f_7320},
{"f_3285:posixunix_2escm",(void*)f_3285},
{"f_7153:posixunix_2escm",(void*)f_7153},
{"f_3282:posixunix_2escm",(void*)f_3282},
{"f_7839:posixunix_2escm",(void*)f_7839},
{"f_7148:posixunix_2escm",(void*)f_7148},
{"f_6358:posixunix_2escm",(void*)f_6358},
{"f_7145:posixunix_2escm",(void*)f_7145},
{"f_6354:posixunix_2escm",(void*)f_6354},
{"f_7831:posixunix_2escm",(void*)f_7831},
{"f_5149:posixunix_2escm",(void*)f_5149},
{"f_5147:posixunix_2escm",(void*)f_5147},
{"f_5143:posixunix_2escm",(void*)f_5143},
{"f_5017:posixunix_2escm",(void*)f_5017},
{"f_5011:posixunix_2escm",(void*)f_5011},
{"f_5014:posixunix_2escm",(void*)f_5014},
{"f_4360:posixunix_2escm",(void*)f_4360},
{"f_4366:posixunix_2escm",(void*)f_4366},
{"f_7805:posixunix_2escm",(void*)f_7805},
{"f_5156:posixunix_2escm",(void*)f_5156},
{"f_5151:posixunix_2escm",(void*)f_5151},
{"f_3227:posixunix_2escm",(void*)f_3227},
{"f_6339:posixunix_2escm",(void*)f_6339},
{"f_7814:posixunix_2escm",(void*)f_7814},
{"f_7811:posixunix_2escm",(void*)f_7811},
{"f_7109:posixunix_2escm",(void*)f_7109},
{"f_7107:posixunix_2escm",(void*)f_7107},
{"f_5055:posixunix_2escm",(void*)f_5055},
{"f_5058:posixunix_2escm",(void*)f_5058},
{"f_7117:posixunix_2escm",(void*)f_7117},
{"f_2673:posixunix_2escm",(void*)f_2673},
{"f_7129:posixunix_2escm",(void*)f_7129},
{"f_7127:posixunix_2escm",(void*)f_7127},
{"f_2695:posixunix_2escm",(void*)f_2695},
{"f_2699:posixunix_2escm",(void*)f_2699},
{"f_5008:posixunix_2escm",(void*)f_5008},
{"f_2693:posixunix_2escm",(void*)f_2693},
{"f_2665:posixunix_2escm",(void*)f_2665},
{"f_2668:posixunix_2escm",(void*)f_2668},
{"f_7316:posixunix_2escm",(void*)f_7316},
{"f_2680:posixunix_2escm",(void*)f_2680},
{"f_6697:posixunix_2escm",(void*)f_6697},
{"f_6691:posixunix_2escm",(void*)f_6691},
{"f_4323:posixunix_2escm",(void*)f_4323},
{"f_4354:posixunix_2escm",(void*)f_4354},
{"f_4350:posixunix_2escm",(void*)f_4350},
{"f_3893:posixunix_2escm",(void*)f_3893},
{"toplevel:posixunix_2escm",(void*)C_posix_toplevel},
{"f_5267:posixunix_2escm",(void*)f_5267},
{"f_7162:posixunix_2escm",(void*)f_7162},
{"f_7164:posixunix_2escm",(void*)f_7164},
{"f_7166:posixunix_2escm",(void*)f_7166},
{"f_6679:posixunix_2escm",(void*)f_6679},
{"f_7176:posixunix_2escm",(void*)f_7176},
{"f_6390:posixunix_2escm",(void*)f_6390},
{"f_5281:posixunix_2escm",(void*)f_5281},
{"f_5287:posixunix_2escm",(void*)f_5287},
{"f_7184:posixunix_2escm",(void*)f_7184},
{"f_7178:posixunix_2escm",(void*)f_7178},
{"f_2659:posixunix_2escm",(void*)f_2659},
{"f_6613:posixunix_2escm",(void*)f_6613},
{"f_6394:posixunix_2escm",(void*)f_6394},
{"f_6370:posixunix_2escm",(void*)f_6370},
{"f_2629:posixunix_2escm",(void*)f_2629},
{"f_2626:posixunix_2escm",(void*)f_2626},
{"f_5920:posixunix_2escm",(void*)f_5920},
{"f_2620:posixunix_2escm",(void*)f_2620},
{"f_6643:posixunix_2escm",(void*)f_6643},
{"f_6645:posixunix_2escm",(void*)f_6645},
{"f_6647:posixunix_2escm",(void*)f_6647},
{"f_6649:posixunix_2escm",(void*)f_6649},
{"f_6386:posixunix_2escm",(void*)f_6386},
{"f_6641:posixunix_2escm",(void*)f_6641},
{"f_5931:posixunix_2escm",(void*)f_5931},
{"f_5939:posixunix_2escm",(void*)f_5939},
{"f_6637:posixunix_2escm",(void*)f_6637},
{"f_6374:posixunix_2escm",(void*)f_6374},
{"f_5906:posixunix_2escm",(void*)f_5906},
{"f_6661:posixunix_2escm",(void*)f_6661},
{"f_5911:posixunix_2escm",(void*)f_5911},
{"f_4332:posixunix_2escm",(void*)f_4332},
{"f_4082:posixunix_2escm",(void*)f_4082},
{"f_4311:posixunix_2escm",(void*)f_4311},
{"f_3850:posixunix_2escm",(void*)f_3850},
{"f_5815:posixunix_2escm",(void*)f_5815},
{"f_5257:posixunix_2escm",(void*)f_5257},
{"f_6991:posixunix_2escm",(void*)f_6991},
{"f_5252:posixunix_2escm",(void*)f_5252},
{"f_6985:posixunix_2escm",(void*)f_6985},
{"f_6047:posixunix_2escm",(void*)f_6047},
{"f_6981:posixunix_2escm",(void*)f_6981},
{"f_5224:posixunix_2escm",(void*)f_5224},
{"f_7601:posixunix_2escm",(void*)f_7601},
{"f_7603:posixunix_2escm",(void*)f_7603},
{"f_7608:posixunix_2escm",(void*)f_7608},
{"f_5832:posixunix_2escm",(void*)f_5832},
{"f_5837:posixunix_2escm",(void*)f_5837},
{"f_4077:posixunix_2escm",(void*)f_4077},
{"f_6972:posixunix_2escm",(void*)f_6972},
{"f_4060:posixunix_2escm",(void*)f_4060},
{"f_4066:posixunix_2escm",(void*)f_4066},
{"f_3800:posixunix_2escm",(void*)f_3800},
{"f_3805:posixunix_2escm",(void*)f_3805},
{"f_4090:posixunix_2escm",(void*)f_4090},
{"f_2616:posixunix_2escm",(void*)f_2616},
{"f_6951:posixunix_2escm",(void*)f_6951},
{"f_6955:posixunix_2escm",(void*)f_6955},
{"f_4098:posixunix_2escm",(void*)f_4098},
{"f_6005:posixunix_2escm",(void*)f_6005},
{"f_6940:posixunix_2escm",(void*)f_6940},
{"f_7642:posixunix_2escm",(void*)f_7642},
{"f_6813:posixunix_2escm",(void*)f_6813},
{"f_6816:posixunix_2escm",(void*)f_6816},
{"f_2636:posixunix_2escm",(void*)f_2636},
{"f_2632:posixunix_2escm",(void*)f_2632},
{"f_2605:posixunix_2escm",(void*)f_2605},
{"f_6029:posixunix_2escm",(void*)f_6029},
{"f_2603:posixunix_2escm",(void*)f_2603},
{"f_2607:posixunix_2escm",(void*)f_2607},
{"f_6021:posixunix_2escm",(void*)f_6021},
{"f_6023:posixunix_2escm",(void*)f_6023},
{"f_2601:posixunix_2escm",(void*)f_2601},
{"f_7621:posixunix_2escm",(void*)f_7621},
{"f_7625:posixunix_2escm",(void*)f_7625},
{"f_7627:posixunix_2escm",(void*)f_7627},
{"f_3843:posixunix_2escm",(void*)f_3843},
{"f_6831:posixunix_2escm",(void*)f_6831},
{"f_6837:posixunix_2escm",(void*)f_6837},
{"f_6535:posixunix_2escm",(void*)f_6535},
{"f_6537:posixunix_2escm",(void*)f_6537},
{"f_7671:posixunix_2escm",(void*)f_7671},
{"f_6827:posixunix_2escm",(void*)f_6827},
{"f_5597:posixunix_2escm",(void*)f_5597},
{"f_5209:posixunix_2escm",(void*)f_5209},
{"f_4029:posixunix_2escm",(void*)f_4029},
{"f_4025:posixunix_2escm",(void*)f_4025},
{"f_4023:posixunix_2escm",(void*)f_4023},
{"f_5200:posixunix_2escm",(void*)f_5200},
{"f_5204:posixunix_2escm",(void*)f_5204},
{"f_4056:posixunix_2escm",(void*)f_4056},
{"f_2863:posixunix_2escm",(void*)f_2863},
{"f_2861:posixunix_2escm",(void*)f_2861},
{"f_4050:posixunix_2escm",(void*)f_4050},
{"f_5575:posixunix_2escm",(void*)f_5575},
{"f_2875:posixunix_2escm",(void*)f_2875},
{"f_5579:posixunix_2escm",(void*)f_5579},
{"f_2870:posixunix_2escm",(void*)f_2870},
{"f_7495:posixunix_2escm",(void*)f_7495},
{"f_7499:posixunix_2escm",(void*)f_7499},
{"f_7498:posixunix_2escm",(void*)f_7498},
{"f_6077:posixunix_2escm",(void*)f_6077},
{"f_2882:posixunix_2escm",(void*)f_2882},
{"f_4844:posixunix_2escm",(void*)f_4844},
{"f_5490:posixunix_2escm",(void*)f_5490},
{"f_5496:posixunix_2escm",(void*)f_5496},
{"f_4876:posixunix_2escm",(void*)f_4876},
{"f_4865:posixunix_2escm",(void*)f_4865},
{"f_4882:posixunix_2escm",(void*)f_4882},
{"f_4856:posixunix_2escm",(void*)f_4856},
{"f_4193:posixunix_2escm",(void*)f_4193},
{"f_2827:posixunix_2escm",(void*)f_2827},
{"f_2825:posixunix_2escm",(void*)f_2825},
{"f_6094:posixunix_2escm",(void*)f_6094},
{"f_6099:posixunix_2escm",(void*)f_6099},
{"f_4017:posixunix_2escm",(void*)f_4017},
{"f_6092:posixunix_2escm",(void*)f_6092},
{"f_6090:posixunix_2escm",(void*)f_6090},
{"f_4182:posixunix_2escm",(void*)f_4182},
{"f_4184:posixunix_2escm",(void*)f_4184},
{"f_2836:posixunix_2escm",(void*)f_2836},
{"f_2834:posixunix_2escm",(void*)f_2834},
{"f_6086:posixunix_2escm",(void*)f_6086},
{"f_4173:posixunix_2escm",(void*)f_4173},
{"f_2845:posixunix_2escm",(void*)f_2845},
{"f_2843:posixunix_2escm",(void*)f_2843},
{"f_6556:posixunix_2escm",(void*)f_6556},
{"f_6552:posixunix_2escm",(void*)f_6552},
{"f_4167:posixunix_2escm",(void*)f_4167},
{"f_6589:posixunix_2escm",(void*)f_6589},
{"f_3000:posixunix_2escm",(void*)f_3000},
{"f_6586:posixunix_2escm",(void*)f_6586},
{"f_6580:posixunix_2escm",(void*)f_6580},
{"f_3030:posixunix_2escm",(void*)f_3030},
{"f_3028:posixunix_2escm",(void*)f_3028},
{"f_6564:posixunix_2escm",(void*)f_6564},
{"f_5505:posixunix_2escm",(void*)f_5505},
{"f_4694:posixunix_2escm",(void*)f_4694},
{"f_4697:posixunix_2escm",(void*)f_4697},
{"f_6512:posixunix_2escm",(void*)f_6512},
{"f_6514:posixunix_2escm",(void*)f_6514},
{"f_2816:posixunix_2escm",(void*)f_2816},
{"f_2818:posixunix_2escm",(void*)f_2818},
{"f_3048:posixunix_2escm",(void*)f_3048},
{"f_6546:posixunix_2escm",(void*)f_6546},
{"f_3073:posixunix_2escm",(void*)f_3073},
{"f_3079:posixunix_2escm",(void*)f_3079},
{"f_3078:posixunix_2escm",(void*)f_3078},
{"f_7400:posixunix_2escm",(void*)f_7400},
{"f_6523:posixunix_2escm",(void*)f_6523},
{"f_6526:posixunix_2escm",(void*)f_6526},
{"f_6528:posixunix_2escm",(void*)f_6528},
{"f_4652:posixunix_2escm",(void*)f_4652},
{"f_3015:posixunix_2escm",(void*)f_3015},
{"f_4658:posixunix_2escm",(void*)f_4658},
{"f_4656:posixunix_2escm",(void*)f_4656},
{"f_5518:posixunix_2escm",(void*)f_5518},
{"f_5513:posixunix_2escm",(void*)f_5513},
{"f_2852:posixunix_2escm",(void*)f_2852},
{"f_2854:posixunix_2escm",(void*)f_2854},
{"f_3088:posixunix_2escm",(void*)f_3088},
{"f_7430:posixunix_2escm",(void*)f_7430},
{"f_7439:posixunix_2escm",(void*)f_7439},
{"f_7438:posixunix_2escm",(void*)f_7438},
{"f_5522:posixunix_2escm",(void*)f_5522},
{"f_7447:posixunix_2escm",(void*)f_7447},
{"f_3560:posixunix_2escm",(void*)f_3560},
{"f_3563:posixunix_2escm",(void*)f_3563},
{"f_3565:posixunix_2escm",(void*)f_3565},
{"f_3579:posixunix_2escm",(void*)f_3579},
{"f_4792:posixunix_2escm",(void*)f_4792},
{"f_7413:posixunix_2escm",(void*)f_7413},
{"f_5583:posixunix_2escm",(void*)f_5583},
{"f_5580:posixunix_2escm",(void*)f_5580},
{"f_3597:posixunix_2escm",(void*)f_3597},
{"f_2809:posixunix_2escm",(void*)f_2809},
{"f_3055:posixunix_2escm",(void*)f_3055},
{"f_3059:posixunix_2escm",(void*)f_3059},
{"f_7421:posixunix_2escm",(void*)f_7421},
{"f_7426:posixunix_2escm",(void*)f_7426},
{"f_5555:posixunix_2escm",(void*)f_5555},
{"f_5553:posixunix_2escm",(void*)f_5553},
{"f_5404:posixunix_2escm",(void*)f_5404},
{"f_7471:posixunix_2escm",(void*)f_7471},
{"f_7477:posixunix_2escm",(void*)f_7477},
{"f_5416:posixunix_2escm",(void*)f_5416},
{"f_5410:posixunix_2escm",(void*)f_5410},
{"f_7485:posixunix_2escm",(void*)f_7485},
{"f_7482:posixunix_2escm",(void*)f_7482},
{"f_7480:posixunix_2escm",(void*)f_7480},
{"f_7489:posixunix_2escm",(void*)f_7489},
{"f_7487:posixunix_2escm",(void*)f_7487},
{"f_5535:posixunix_2escm",(void*)f_5535},
{"f_7797:posixunix_2escm",(void*)f_7797},
{"f_7794:posixunix_2escm",(void*)f_7794},
{"f_5420:posixunix_2escm",(void*)f_5420},
{"f_5425:posixunix_2escm",(void*)f_5425},
{"f_7451:posixunix_2escm",(void*)f_7451},
{"f_3099:posixunix_2escm",(void*)f_3099},
{"f_5432:posixunix_2escm",(void*)f_5432},
{"f_5434:posixunix_2escm",(void*)f_5434},
{"f_3094:posixunix_2escm",(void*)f_3094},
{"f_2597:posixunix_2escm",(void*)f_2597},
{"f_7463:posixunix_2escm",(void*)f_7463},
{"f_2595:posixunix_2escm",(void*)f_2595},
{"f_2599:posixunix_2escm",(void*)f_2599},
{"f_7467:posixunix_2escm",(void*)f_7467},
{"f_7469:posixunix_2escm",(void*)f_7469},
{"f_3197:posixunix_2escm",(void*)f_3197},
{"f_5456:posixunix_2escm",(void*)f_5456},
{"f_3570:posixunix_2escm",(void*)f_3570},
{"f_3572:posixunix_2escm",(void*)f_3572},
{"f_5453:posixunix_2escm",(void*)f_5453},
{"f_3577:posixunix_2escm",(void*)f_3577},
{"f_5459:posixunix_2escm",(void*)f_5459},
{"f_4976:posixunix_2escm",(void*)f_4976},
{"f_5465:posixunix_2escm",(void*)f_5465},
{"f_5466:posixunix_2escm",(void*)f_5466},
{"f_5462:posixunix_2escm",(void*)f_5462},
{"f_4969:posixunix_2escm",(void*)f_4969},
{"f_4961:posixunix_2escm",(void*)f_4961},
{"f_4964:posixunix_2escm",(void*)f_4964},
{"f_5476:posixunix_2escm",(void*)f_5476},
{"f_4958:posixunix_2escm",(void*)f_4958},
{"f_4955:posixunix_2escm",(void*)f_4955},
{"f_4952:posixunix_2escm",(void*)f_4952},
{"f_4606:posixunix_2escm",(void*)f_4606},
{"f_3154:posixunix_2escm",(void*)f_3154},
{"f_4946:posixunix_2escm",(void*)f_4946},
{"f_3151:posixunix_2escm",(void*)f_3151},
{"f_3168:posixunix_2escm",(void*)f_3168},
{"f_4942:posixunix_2escm",(void*)f_4942},
{"f_4116:posixunix_2escm",(void*)f_4116},
{"f_4118:posixunix_2escm",(void*)f_4118},
{"f_4111:posixunix_2escm",(void*)f_4111},
{"f_4102:posixunix_2escm",(void*)f_4102},
{"f_4104:posixunix_2escm",(void*)f_4104},
{"f_4106:posixunix_2escm",(void*)f_4106},
{"f_7293:posixunix_2escm",(void*)f_7293},
{"f_7297:posixunix_2escm",(void*)f_7297},
{"f_5757:posixunix_2escm",(void*)f_5757},
{"f_3345:posixunix_2escm",(void*)f_3345},
{"f_4997:posixunix_2escm",(void*)f_4997},
{"f_4990:posixunix_2escm",(void*)f_4990},
{"f_4988:posixunix_2escm",(void*)f_4988},
{"f_4984:posixunix_2escm",(void*)f_4984},
{"f_3367:posixunix_2escm",(void*)f_3367},
{"f_4980:posixunix_2escm",(void*)f_4980},
{"f_4157:posixunix_2escm",(void*)f_4157},
{"f_4154:posixunix_2escm",(void*)f_4154},
{"f_4672:posixunix_2escm",(void*)f_4672},
{"f_4670:posixunix_2escm",(void*)f_4670},
{"f_7282:posixunix_2escm",(void*)f_7282},
{"f_7286:posixunix_2escm",(void*)f_7286},
{"f_3365:posixunix_2escm",(void*)f_3365},
{"f_3359:posixunix_2escm",(void*)f_3359},
{"f_3357:posixunix_2escm",(void*)f_3357},
{"f_4666:posixunix_2escm",(void*)f_4666},
{"f_4615:posixunix_2escm",(void*)f_4615},
{"f_7266:posixunix_2escm",(void*)f_7266},
{"f_4706:posixunix_2escm",(void*)f_4706},
{"f_4702:posixunix_2escm",(void*)f_4702},
{"f_3384:posixunix_2escm",(void*)f_3384},
{"f_4680:posixunix_2escm",(void*)f_4680},
{"f_4689:posixunix_2escm",(void*)f_4689},
{"f_4684:posixunix_2escm",(void*)f_4684},
{"f_4634:posixunix_2escm",(void*)f_4634},
{"f_3104:posixunix_2escm",(void*)f_3104},
{"f_4628:posixunix_2escm",(void*)f_4628},
{"f_3536:posixunix_2escm",(void*)f_3536},
{"f_3538:posixunix_2escm",(void*)f_3538},
{"f_3554:posixunix_2escm",(void*)f_3554},
{"f_3551:posixunix_2escm",(void*)f_3551},
{"f_6892:posixunix_2escm",(void*)f_6892},
{"f_4743:posixunix_2escm",(void*)f_4743},
{"f_3526:posixunix_2escm",(void*)f_3526},
{"f_4746:posixunix_2escm",(void*)f_4746},
{"f_3544:posixunix_2escm",(void*)f_3544},
{"f_3542:posixunix_2escm",(void*)f_3542},
{"f_3540:posixunix_2escm",(void*)f_3540},
{"f_4643:posixunix_2escm",(void*)f_4643},
{"f_6881:posixunix_2escm",(void*)f_6881},
{"f_6884:posixunix_2escm",(void*)f_6884},
{"f_4733:posixunix_2escm",(void*)f_4733},
{"f_3557:posixunix_2escm",(void*)f_3557},
{"f_4738:posixunix_2escm",(void*)f_4738},
{"f_4724:posixunix_2escm",(void*)f_4724},
{"f_4728:posixunix_2escm",(void*)f_4728},
{"f_3546:posixunix_2escm",(void*)f_3546},
{"f_4716:posixunix_2escm",(void*)f_4716},
{"f_4719:posixunix_2escm",(void*)f_4719},
{"f_4711:posixunix_2escm",(void*)f_4711},
{"f_3308:posixunix_2escm",(void*)f_3308},
{"f_6850:posixunix_2escm",(void*)f_6850},
{"f_6855:posixunix_2escm",(void*)f_6855},
{"f_4788:posixunix_2escm",(void*)f_4788},
{"f_4783:posixunix_2escm",(void*)f_4783},
{"f_3505:posixunix_2escm",(void*)f_3505},
{"f_3503:posixunix_2escm",(void*)f_3503},
{"f_6842:posixunix_2escm",(void*)f_6842},
{"f_4770:posixunix_2escm",(void*)f_4770},
{"f_3517:posixunix_2escm",(void*)f_3517},
{"f_4778:posixunix_2escm",(void*)f_4778},
{"f_4775:posixunix_2escm",(void*)f_4775},
{"f_3327:posixunix_2escm",(void*)f_3327},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		7
o|eliminated procedure checks: 273 
o|specializations:
o|  1 (negative? fixnum)
o|  4 (##sys#check-list (or pair list) *)
o|  6 (cdr pair)
o|  1 (string-ref string fixnum)
o|  4 (make-string fixnum)
o|  11 (eqv? * (not float))
o|  14 (car pair)
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error) 
o|Removed `not' forms: 7 
o|inlining procedure: k2637 
o|inlining procedure: k2637 
o|inlining procedure: k2652 
o|inlining procedure: k2652 
o|inlining procedure: k2736 
o|inlining procedure: k2748 
o|inlining procedure: k2748 
o|inlining procedure: k2760 
o|inlining procedure: k2760 
o|inlining procedure: k2772 
o|inlining procedure: k2772 
o|inlining procedure: k2736 
o|inlining procedure: k2881 
o|contracted procedure: k2896 
o|inlining procedure: k2893 
o|inlining procedure: k2893 
o|substituted constant variable: a2906 
o|inlining procedure: k2881 
o|inlining procedure: k2914 
o|inlining procedure: k2914 
o|inlining procedure: k2956 
o|inlining procedure: k2956 
o|inlining procedure: k2971 
o|inlining procedure: k2971 
o|inlining procedure: k2999 
o|inlining procedure: k2999 
o|inlining procedure: k3021 
o|inlining procedure: k3021 
o|substituted constant variable: a3040 
o|inlining procedure: k3060 
o|inlining procedure: k3060 
o|inlining procedure: k3081 
o|propagated global variable: g2752767979 delete-file 
o|inlining procedure: k3081 
o|inlining procedure: k3074 
o|inlining procedure: k3107 
o|inlining procedure: k3107 
o|inlining procedure: k3074 
o|inlining procedure: k3155 
o|inlining procedure: k3155 
o|inlining procedure: k3171 
o|inlining procedure: k3171 
o|inlining procedure: k3203 
o|inlining procedure: k3203 
o|substituted constant variable: a3224 
o|substituted constant variable: a3228 
o|inlining procedure: k3266 
o|inlining procedure: k3266 
o|inlining procedure: k3296 
o|inlining procedure: k3296 
o|inlining procedure: k3340 
o|inlining procedure: k3340 
o|inlining procedure: k3347 
o|inlining procedure: k3347 
o|contracted procedure: "(posix-common.scm:426) find-files" 
o|inlining procedure: k3370 
o|inlining procedure: k3370 
o|inlining procedure: k3385 
o|inlining procedure: k3385 
o|inlining procedure: k3404 
o|inlining procedure: k3404 
o|inlining procedure: k3412 
o|inlining procedure: k3441 
o|inlining procedure: k3441 
o|inlining procedure: k3412 
o|inlining procedure: k3461 
o|inlining procedure: k3461 
o|inlining procedure: k3478 
o|inlining procedure: k3478 
o|inlining procedure: k3497 
o|inlining procedure: k3497 
o|contracted procedure: k3514 
o|inlining procedure: k3520 
o|inlining procedure: k3520 
o|inlining procedure: k3584 
o|inlining procedure: k3584 
o|inlining procedure: k3658 
o|inlining procedure: k3658 
o|inlining procedure: k3688 
o|inlining procedure: k3688 
o|inlining procedure: k3718 
o|inlining procedure: k3718 
o|inlining procedure: k3807 
o|inlining procedure: k3807 
o|inlining procedure: k3916 
o|inlining procedure: k3916 
o|inlining procedure: k3948 
o|inlining procedure: k3948 
o|inlining procedure: k3969 
o|inlining procedure: k3969 
o|inlining procedure: k3991 
o|inlining procedure: k3991 
o|inlining procedure: k4028 
o|inlining procedure: k4028 
o|inlining procedure: k4119 
o|inlining procedure: k4119 
o|inlining procedure: k4141 
o|inlining procedure: k4141 
o|inlining procedure: k4156 
o|inlining procedure: k4169 
o|inlining procedure: k4169 
o|inlining procedure: k4187 
o|inlining procedure: k4187 
o|inlining procedure: k4156 
o|inlining procedure: k4203 
o|inlining procedure: k4214 
o|inlining procedure: k4214 
o|inlining procedure: k4203 
o|inlining procedure: k4232 
o|inlining procedure: k4232 
o|inlining procedure: k4256 
o|inlining procedure: k4256 
o|inlining procedure: k4283 
o|inlining procedure: k4283 
o|inlining procedure: k4299 
o|inlining procedure: k4299 
o|inlining procedure: k4326 
o|inlining procedure: k4326 
o|inlining procedure: k4361 
o|inlining procedure: k4361 
o|inlining procedure: k4373 
o|inlining procedure: k4373 
o|inlining procedure: k4382 
o|inlining procedure: k4382 
o|inlining procedure: k4414 
o|inlining procedure: k4414 
o|inlining procedure: k4443 
o|inlining procedure: k4443 
o|inlining procedure: k4434 
o|inlining procedure: k4434 
o|inlining procedure: k4475 
o|inlining procedure: k4475 
o|inlining procedure: k4483 
o|inlining procedure: k4483 
o|inlining procedure: k4518 
o|inlining procedure: k4518 
o|inlining procedure: k4536 
o|inlining procedure: k4536 
o|inlining procedure: k4549 
o|inlining procedure: k4549 
o|inlining procedure: k4567 
o|inlining procedure: k4567 
o|inlining procedure: k4589 
o|inlining procedure: k4589 
o|inlining procedure: "(posixunix.scm:815) badmode926" 
o|substituted constant variable: a4611 
o|substituted constant variable: a4613 
o|inlining procedure: k4626 
o|inlining procedure: k4626 
o|inlining procedure: "(posixunix.scm:826) badmode926" 
o|substituted constant variable: a4648 
o|substituted constant variable: a4650 
o|inlining procedure: k4657 
o|inlining procedure: k4657 
o|inlining procedure: k4671 
o|inlining procedure: k4671 
o|inlining procedure: k4791 
o|inlining procedure: k4791 
o|inlining procedure: k4845 
o|inlining procedure: k4845 
o|inlining procedure: k4859 
o|inlining procedure: k4859 
o|inlining procedure: k4885 
o|inlining procedure: k4885 
o|inlining procedure: k4898 
o|inlining procedure: k4898 
o|inlining procedure: k4915 
o|inlining procedure: k4915 
o|inlining procedure: k4931 
o|inlining procedure: k4931 
o|inlining procedure: k4998 
o|inlining procedure: k4998 
o|inlining procedure: k5079 
o|inlining procedure: k5102 
o|inlining procedure: k5102 
o|contracted procedure: "(posixunix.scm:1094) group-member" 
o|inlining procedure: k5079 
o|inlining procedure: k5159 
o|inlining procedure: k5159 
o|contracted procedure: "(posixunix.scm:1117) _get-groups" 
o|inlining procedure: "(posixunix.scm:1115) _ensure-groups" 
o|inlining procedure: k5212 
o|inlining procedure: k5212 
o|inlining procedure: "(posixunix.scm:1126) _ensure-groups" 
o|inlining procedure: k5274 
o|inlining procedure: k5274 
o|inlining procedure: k5335 
o|inlining procedure: k5335 
o|inlining procedure: k5361 
o|inlining procedure: k5361 
o|inlining procedure: k5385 
o|inlining procedure: k5385 
o|inlining procedure: k5419 
o|inlining procedure: k5419 
o|inlining procedure: k5441 
o|inlining procedure: k5441 
o|inlining procedure: k5477 
o|inlining procedure: k5477 
o|inlining procedure: k5520 
o|inlining procedure: k5520 
o|inlining procedure: k5542 
o|inlining procedure: k5542 
o|inlining procedure: k5584 
o|inlining procedure: k5584 
o|inlining procedure: k5609 
o|inlining procedure: k5609 
o|inlining procedure: k5616 
o|inlining procedure: k5628 
o|inlining procedure: k5649 
o|inlining procedure: k5649 
o|inlining procedure: k5628 
o|inlining procedure: k5670 
o|inlining procedure: k5670 
o|inlining procedure: k5688 
o|inlining procedure: k5688 
o|inlining procedure: k5616 
o|inlining procedure: k5730 
o|inlining procedure: k5730 
o|inlining procedure: k5739 
o|inlining procedure: k5739 
o|inlining procedure: k5777 
o|inlining procedure: k5777 
o|inlining procedure: k5816 
o|inlining procedure: k5816 
o|inlining procedure: k5847 
o|inlining procedure: k5847 
o|inlining procedure: k5877 
o|inlining procedure: k5877 
o|inlining procedure: k5884 
o|inlining procedure: k5884 
o|inlining procedure: k5896 
o|inlining procedure: k5913 
o|inlining procedure: k5913 
o|inlining procedure: k5896 
o|inlining procedure: k5933 
o|inlining procedure: k5933 
o|inlining procedure: k6032 
o|inlining procedure: k6051 
o|inlining procedure: k6051 
o|inlining procedure: k6032 
o|inlining procedure: k6101 
o|inlining procedure: k6101 
o|inlining procedure: k6129 
o|inlining procedure: k6129 
o|inlining procedure: k6142 
o|inlining procedure: k6157 
o|inlining procedure: k6157 
o|inlining procedure: k6142 
o|inlining procedure: k6250 
o|inlining procedure: k6250 
o|inlining procedure: k6260 
o|inlining procedure: k6260 
o|inlining procedure: k6359 
o|inlining procedure: k6359 
o|inlining procedure: k6375 
o|inlining procedure: k6375 
o|inlining procedure: k6396 
o|inlining procedure: k6396 
o|inlining procedure: k6391 
o|inlining procedure: k6391 
o|inlining procedure: k6422 
o|inlining procedure: k6422 
o|inlining procedure: k6445 
o|inlining procedure: k6445 
o|inlining procedure: k6480 
o|inlining procedure: k6480 
o|inlining procedure: k6492 
o|inlining procedure: k6492 
o|substituted constant variable: a6505 
o|substituted constant variable: a6507 
o|substituted constant variable: a6509 
o|inlining procedure: k6557 
o|inlining procedure: k6567 
o|inlining procedure: k6567 
o|inlining procedure: k6557 
o|inlining procedure: k6648 
o|inlining procedure: k6648 
o|contracted procedure: k6672 
o|inlining procedure: k6698 
o|inlining procedure: k6698 
o|inlining procedure: k6756 
o|inlining procedure: k6756 
o|inlining procedure: k6832 
o|inlining procedure: k6832 
o|inlining procedure: k6861 
o|inlining procedure: k6861 
o|inlining procedure: k6887 
o|inlining procedure: k6887 
o|inlining procedure: k6897 
o|inlining procedure: k6897 
o|inlining procedure: k6908 
o|inlining procedure: k6908 
o|substituted constant variable: a6924 
o|substituted constant variable: a6926 
o|substituted constant variable: a6928 
o|inlining procedure: k6941 
o|inlining procedure: k6941 
o|inlining procedure: k6956 
o|inlining procedure: k6956 
o|inlining procedure: k7007 
o|inlining procedure: k7007 
o|inlining procedure: k7041 
o|inlining procedure: k7041 
o|inlining procedure: k7054 
o|inlining procedure: k7054 
o|inlining procedure: k7156 
o|inlining procedure: k7194 
o|inlining procedure: k7194 
o|inlining procedure: k7156 
o|inlining procedure: k7276 
o|inlining procedure: k7276 
o|inlining procedure: k7302 
o|inlining procedure: k7302 
o|inlining procedure: k7321 
o|inlining procedure: k7321 
o|inlining procedure: k7338 
o|inlining procedure: k7338 
o|inlining procedure: k7369 
o|inlining procedure: k7369 
o|inlining procedure: k7385 
o|inlining procedure: k7402 
o|inlining procedure: k7402 
o|inlining procedure: k7385 
o|inlining procedure: k7415 
o|inlining procedure: k7415 
o|inlining procedure: k7432 
o|inlining procedure: k7432 
o|inlining procedure: k7441 
o|inlining procedure: k7441 
o|inlining procedure: k7453 
o|inlining procedure: k7453 
o|inlining procedure: k7503 
o|inlining procedure: k7503 
o|inlining procedure: k7513 
o|inlining procedure: k7513 
o|inlining procedure: k7582 
o|inlining procedure: k7582 
o|inlining procedure: k7713 
o|inlining procedure: k7713 
o|inlining procedure: k7727 
o|inlining procedure: k7727 
o|inlining procedure: k7747 
o|inlining procedure: k7747 
o|inlining procedure: k7764 
o|inlining procedure: k7764 
o|inlining procedure: k7782 
o|inlining procedure: k7782 
o|inlining procedure: k7799 
o|inlining procedure: k7799 
o|inlining procedure: k7816 
o|inlining procedure: k7816 
o|inlining procedure: k7833 
o|inlining procedure: k7833 
o|inlining procedure: k7849 
o|inlining procedure: k7849 
o|inlining procedure: k7860 
o|inlining procedure: k7860 
o|inlining procedure: k7869 
o|inlining procedure: k7869 
o|inlining procedure: k7897 
o|inlining procedure: k7897 
o|inlining procedure: k7927 
o|inlining procedure: k7927 
o|inlining procedure: k7939 
o|inlining procedure: k7939 
o|replaced variables: 701 
o|removed binding forms: 334 
o|substituted constant variable: r26387952 
o|substituted constant variable: r27497956 
o|substituted constant variable: r27617958 
o|substituted constant variable: r27737960 
o|substituted constant variable: r27377962 
o|inlining procedure: k2881 
o|substituted constant variable: r28947965 
o|inlining procedure: k2881 
o|inlining procedure: k2881 
o|inlining procedure: k3081 
o|inlining procedure: k3081 
o|propagated global variable: g2752768356 delete-file 
o|converted assignments to bindings: (rmdir257) 
o|substituted constant variable: r31727993 
o|substituted constant variable: f_32657997 
o|substituted constant variable: r33418003 
o|substituted constant variable: r33418003 
o|substituted constant variable: r33488007 
o|substituted constant variable: r33488007 
o|substituted constant variable: a34968023 
o|substituted constant variable: a34968024 
o|substituted constant variable: loc371 
o|substituted constant variable: a41408055 
o|substituted constant variable: a41408056 
o|inlining procedure: k4156 
o|substituted constant variable: a41558062 
o|substituted constant variable: r43748080 
o|substituted constant variable: f_45488098 
o|removed side-effect free assignment to unused variable: badmode926 
o|inlining procedure: k4589 
o|inlining procedure: k4626 
o|substituted constant variable: r49998144 
o|substituted constant variable: r51038147 
o|substituted constant variable: r50808148 
o|removed side-effect free assignment to unused variable: _ensure-groups 
o|substituted constant variable: f_51588149 
o|substituted constant variable: r55218179 
o|substituted constant variable: r55218179 
o|substituted constant variable: f_56088185 
o|inlining procedure: k5681 
o|inlining procedure: k5681 
o|inlining procedure: k5744 
o|substituted constant variable: r58788208 
o|substituted constant variable: f_59328215 
o|inlining procedure: k6106 
o|inlining procedure: k6260 
o|substituted constant variable: f_63958237 
o|substituted constant variable: r64818245 
o|substituted constant variable: r65588252 
o|substituted constant variable: a68608268 
o|substituted constant variable: a68968272 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r69428275 
o|inlining procedure: k7276 
o|inlining procedure: k7276 
o|substituted constant variable: r73228294 
o|substituted constant variable: f_74148304 
o|substituted constant variable: f_74318306 
o|substituted constant variable: f_74528310 
o|substituted constant variable: r75048312 
o|substituted constant variable: r75148314 
o|substituted constant variable: r77148319 
o|substituted constant variable: r77148319 
o|converted assignments to bindings: (check1255) 
o|substituted constant variable: r78618338 
o|substituted constant variable: r79288345 
o|substituted constant variable: r79288345 
o|simplifications: ((let . 2)) 
o|replaced variables: 31 
o|removed binding forms: 702 
o|substituted constant variable: a28808349 
o|substituted constant variable: a28808350 
o|substituted constant variable: a28808351 
o|inlining procedure: k3206 
o|inlining procedure: k3764 
o|inlining procedure: k3764 
o|inlining procedure: k4002 
o|inlining procedure: k4002 
o|inlining procedure: k4043 
o|inlining procedure: k4043 
o|inlining procedure: k5183 
o|inlining procedure: k5185 
o|inlining procedure: k5242 
o|inlining procedure: k5255 
o|inlining procedure: k5494 
o|inlining procedure: k6662 
o|inlining procedure: k6662 
o|inlining procedure: k6682 
o|inlining procedure: k7680 
o|replaced variables: 3 
o|removed binding forms: 92 
o|substituted constant variable: tmp3193218472 
o|substituted constant variable: tmp3193218472 
o|substituted constant variable: a37638483 
o|substituted constant variable: r40038486 
o|substituted constant variable: r40448488 
o|substituted constant variable: r52568512 
o|substituted constant variable: r54958516 
o|substituted constant variable: r66638532 
o|substituted constant variable: r66838533 
o|simplifications: ((let . 5)) 
o|removed binding forms: 14 
o|removed conditional forms: 5 
o|removed binding forms: 8 
o|simplifications: ((if . 77) (##core#call . 638)) 
o|  call simplifications:
o|    bitwise-ior	2
o|    <
o|    vector-ref	2
o|    make-vector
o|    ##sys#structure?
o|    ##sys#foreign-pointer-argument	4
o|    char=?
o|    fxior	2
o|    ##sys#check-structure	3
o|    ##sys#make-structure	3
o|    ##sys#setislot	3
o|    ##sys#foreign-string-argument	7
o|    length
o|    fx>=	4
o|    list	5
o|    values	18
o|    ##sys#fudge
o|    vector-set!	3
o|    fx-	11
o|    ##sys#foreign-integer-argument	6
o|    ##sys#check-number	8
o|    ##sys#check-vector
o|    ##sys#size	16
o|    member
o|    fx+	20
o|    ##sys#call-with-values	12
o|    string-ref
o|    fx>
o|    not	10
o|    cons	12
o|    ##sys#check-string	35
o|    ##sys#check-list	9
o|    fx=	28
o|    ##sys#slot	39
o|    zero?
o|    ##sys#check-exact	39
o|    ##sys#null-pointer?	4
o|    pair?	24
o|    eq?	41
o|    cdr	24
o|    ##sys#eqv?	13
o|    null?	65
o|    car	47
o|    vector	2
o|    fixnum?	15
o|    string?	3
o|    fx<	49
o|    apply	9
o|    ##sys#foreign-fixnum-argument	30
o|contracted procedure: k2614 
o|contracted procedure: k2640 
o|contracted procedure: k2649 
o|contracted procedure: k2655 
o|contracted procedure: k2684 
o|contracted procedure: k2676 
o|contracted procedure: k2802 
o|contracted procedure: k2728 
o|contracted procedure: k2796 
o|contracted procedure: k2730 
o|contracted procedure: k2790 
o|contracted procedure: k2732 
o|contracted procedure: k2784 
o|contracted procedure: k2734 
o|contracted procedure: k2745 
o|contracted procedure: k2751 
o|contracted procedure: k2757 
o|contracted procedure: k2763 
o|contracted procedure: k2769 
o|contracted procedure: k2775 
o|contracted procedure: k2781 
o|contracted procedure: k2883 
o|contracted procedure: k2890 
o|contracted procedure: k2916 
o|contracted procedure: k2928 
o|contracted procedure: k2941 
o|contracted procedure: k2989 
o|contracted procedure: k2959 
o|contracted procedure: k2968 
o|contracted procedure: k2973 
o|contracted procedure: k2995 
o|contracted procedure: k3001 
o|contracted procedure: k3007 
o|contracted procedure: k3010 
o|contracted procedure: k3012 
o|contracted procedure: k3041 
o|contracted procedure: k3018 
o|contracted procedure: k3126 
o|contracted procedure: k3051 
o|contracted procedure: k3063 
o|contracted procedure: k3070 
o|contracted procedure: k3095 
o|contracted procedure: k3109 
o|contracted procedure: k3118 
o|contracted procedure: k3121 
o|contracted procedure: k3241 
o|contracted procedure: k3138 
o|contracted procedure: k3235 
o|contracted procedure: k3140 
o|contracted procedure: k3229 
o|contracted procedure: k3142 
o|contracted procedure: k3144 
o|contracted procedure: k3158 
o|contracted procedure: k3174 
o|contracted procedure: k3179 
o|contracted procedure: k3198 
o|contracted procedure: k3201 
o|contracted procedure: k3214 
o|contracted procedure: k3206 
o|contracted procedure: k3220 
o|contracted procedure: k3247 
o|contracted procedure: k3268 
o|contracted procedure: k3271 
o|contracted procedure: k3298 
o|contracted procedure: k3305 
o|contracted procedure: k3323 
o|contracted procedure: k3337 
o|contracted procedure: k3354 
o|contracted procedure: k3372 
o|contracted procedure: k3375 
o|contracted procedure: k3377 
o|contracted procedure: k3388 
o|contracted procedure: k3397 
o|contracted procedure: k3422 
o|contracted procedure: k3499 
o|contracted procedure: k3523 
o|contracted procedure: k3582 
o|contracted procedure: k3594 
o|contracted procedure: k3587 
o|contracted procedure: k3603 
o|contracted procedure: k3608 
o|contracted procedure: k3624 
o|contracted procedure: k3629 
o|contracted procedure: k3646 
o|contracted procedure: k3654 
o|contracted procedure: k3668 
o|contracted procedure: k3665 
o|contracted procedure: k3673 
o|contracted procedure: k3751 
o|contracted procedure: k3713 
o|contracted procedure: k3721 
o|contracted procedure: k3746 
o|contracted procedure: k3743 
o|contracted procedure: k3761 
o|contracted procedure: k3836 
o|contracted procedure: k3783 
o|contracted procedure: k3830 
o|contracted procedure: k3785 
o|contracted procedure: k3824 
o|contracted procedure: k3787 
o|contracted procedure: k3818 
o|contracted procedure: k3789 
o|contracted procedure: k3791 
o|contracted procedure: k3794 
o|contracted procedure: k3809 
o|contracted procedure: k3847 
o|contracted procedure: k3854 
o|contracted procedure: k3896 
o|contracted procedure: k3899 
o|contracted procedure: k3902 
o|contracted procedure: k3925 
o|contracted procedure: k3907 
o|contracted procedure: k3910 
o|contracted procedure: k3912 
o|contracted procedure: k3919 
o|contracted procedure: k7879 
o|contracted procedure: k3932 
o|contracted procedure: k3939 
o|contracted procedure: k3941 
o|contracted procedure: k3943 
o|contracted procedure: k3950 
o|contracted procedure: k3959 
o|contracted procedure: k3967 
o|contracted procedure: k3972 
o|contracted procedure: k3983 
o|contracted procedure: k3985 
o|contracted procedure: k3996 
o|contracted procedure: k4008 
o|contracted procedure: k4020 
o|contracted procedure: k4026 
o|contracted procedure: k4030 
o|contracted procedure: k4036 
o|contracted procedure: k4053 
o|contracted procedure: k4057 
o|contracted procedure: k4068 
o|contracted procedure: k4070 
o|contracted procedure: k4080 
o|contracted procedure: k4085 
o|contracted procedure: k4088 
o|contracted procedure: k4093 
o|contracted procedure: k4096 
o|contracted procedure: k4107 
o|contracted procedure: k4112 
o|contracted procedure: k4122 
o|contracted procedure: k4131 
o|contracted procedure: k4146 
o|contracted procedure: k4138 
o|contracted procedure: k4143 
o|contracted procedure: k4161 
o|contracted procedure: k4175 
o|contracted procedure: k4178 
o|contracted procedure: k4189 
o|contracted procedure: k4198 
o|contracted procedure: k4201 
o|contracted procedure: k4206 
o|contracted procedure: k4220 
o|contracted procedure: k4223 
o|contracted procedure: k4234 
o|contracted procedure: k4243 
o|contracted procedure: k4246 
o|contracted procedure: k4248 
o|contracted procedure: k4251 
o|contracted procedure: k4254 
o|contracted procedure: k4259 
o|contracted procedure: k4266 
o|contracted procedure: k4270 
o|contracted procedure: k4285 
o|contracted procedure: k4294 
o|contracted procedure: k4297 
o|contracted procedure: k4302 
o|contracted procedure: k4309 
o|contracted procedure: k4313 
o|contracted procedure: k4328 
o|contracted procedure: k4337 
o|contracted procedure: k4340 
o|contracted procedure: k4342 
o|contracted procedure: k4355 
o|contracted procedure: k4357 
o|contracted procedure: k4380 
o|contracted procedure: k4376 
o|contracted procedure: k4385 
o|contracted procedure: k4395 
o|contracted procedure: k4504 
o|contracted procedure: k4407 
o|contracted procedure: k4410 
o|contracted procedure: k4502 
o|contracted procedure: k4416 
o|contracted procedure: k4445 
o|contracted procedure: k4485 
o|contracted procedure: k4514 
o|contracted procedure: k4520 
o|contracted procedure: k4534 
o|contracted procedure: k4538 
o|contracted procedure: k4551 
o|contracted procedure: k4569 
o|contracted procedure: k4581 
o|contracted procedure: k4592 
o|contracted procedure: k4601 
o|contracted procedure: k4618 
o|contracted procedure: k4629 
o|contracted procedure: k4638 
o|contracted procedure: k4659 
o|contracted procedure: k4673 
o|contracted procedure: k4796 
o|contracted procedure: k4829 
o|contracted procedure: k4836 
o|contracted procedure: k4840 
o|contracted procedure: k4848 
o|contracted procedure: k4861 
o|contracted procedure: k4870 
o|contracted procedure: k4873 
o|contracted procedure: k4887 
o|contracted procedure: k4890 
o|contracted procedure: k4898 
o|contracted procedure: k4907 
o|contracted procedure: k4913 
o|contracted procedure: k4918 
o|contracted procedure: k4929 
o|contracted procedure: k4934 
o|contracted procedure: k4965 
o|contracted procedure: k5029 
o|contracted procedure: k4993 
o|contracted procedure: k5001 
o|contracted procedure: k5021 
o|contracted procedure: k5024 
o|contracted procedure: k5122 
o|contracted procedure: k5074 
o|contracted procedure: k5082 
o|contracted procedure: k5112 
o|contracted procedure: k5068 
o|contracted procedure: k5114 
o|contracted procedure: k5117 
o|contracted procedure: k5161 
o|contracted procedure: k5172 
o|contracted procedure: k5133 
o|contracted procedure: k5174 
o|contracted procedure: k51408155 
o|contracted procedure: k5191 
o|contracted procedure: k5214 
o|contracted procedure: k5220 
o|contracted procedure: k5229 
o|contracted procedure: k5231 
o|contracted procedure: k5237 
o|contracted procedure: k5240 
o|contracted procedure: k5249 
o|contracted procedure: k51408162 
o|contracted procedure: k5259 
o|contracted procedure: k5265 
o|contracted procedure: k52598515 
o|contracted procedure: k5270 
o|contracted procedure: k5272 
o|contracted procedure: k5277 
o|contracted procedure: k5331 
o|contracted procedure: k5333 
o|contracted procedure: k5338 
o|contracted procedure: k5355 
o|contracted procedure: k5357 
o|contracted procedure: k5359 
o|contracted procedure: k5364 
o|contracted procedure: k5381 
o|contracted procedure: k5383 
o|contracted procedure: k5421 
o|contracted procedure: k5437 
o|contracted procedure: k5439 
o|contracted procedure: k5444 
o|contracted procedure: k5506 
o|contracted procedure: k5469 
o|contracted procedure: k5472 
o|contracted procedure: k5480 
o|contracted procedure: k5527 
o|contracted procedure: k5533 
o|contracted procedure: k5538 
o|contracted procedure: k5540 
o|contracted procedure: k5545 
o|contracted procedure: k5998 
o|contracted procedure: k5558 
o|contracted procedure: k5992 
o|contracted procedure: k5560 
o|contracted procedure: k5986 
o|contracted procedure: k5562 
o|contracted procedure: k5980 
o|contracted procedure: k5564 
o|contracted procedure: k5974 
o|contracted procedure: k5566 
o|contracted procedure: k5968 
o|contracted procedure: k5568 
o|contracted procedure: k5962 
o|contracted procedure: k5570 
o|contracted procedure: k5956 
o|contracted procedure: k5572 
o|contracted procedure: k5947 
o|contracted procedure: k5576 
o|contracted procedure: k5587 
o|contracted procedure: k5593 
o|contracted procedure: k5611 
o|contracted procedure: k5618 
o|contracted procedure: k5631 
o|contracted procedure: k5637 
o|contracted procedure: k5639 
o|contracted procedure: k5652 
o|contracted procedure: k5667 
o|contracted procedure: k5685 
o|contracted procedure: k5691 
o|contracted procedure: k5693 
o|contracted procedure: k5722 
o|contracted procedure: k5728 
o|contracted procedure: k5741 
o|contracted procedure: k5749 
o|contracted procedure: k5779 
o|contracted procedure: k5785 
o|contracted procedure: k5788 
o|contracted procedure: k5811 
o|contracted procedure: k5790 
o|contracted procedure: k5793 
o|contracted procedure: k5796 
o|contracted procedure: k5803 
o|contracted procedure: k5806 
o|contracted procedure: k5809 
o|contracted procedure: k5819 
o|contracted procedure: k5829 
o|contracted procedure: k5842 
o|contracted procedure: k5850 
o|contracted procedure: k5859 
o|contracted procedure: k5872 
o|contracted procedure: k5869 
o|contracted procedure: k5861 
o|contracted procedure: k5863 
o|contracted procedure: k5874 
o|contracted procedure: k5894 
o|contracted procedure: k5891 
o|contracted procedure: k5882 
o|contracted procedure: k5899 
o|contracted procedure: k5924 
o|contracted procedure: k5935 
o|contracted procedure: k5941 
o|contracted procedure: k6238 
o|contracted procedure: k6008 
o|contracted procedure: k6232 
o|contracted procedure: k6010 
o|contracted procedure: k6226 
o|contracted procedure: k6012 
o|contracted procedure: k6220 
o|contracted procedure: k6014 
o|contracted procedure: k6214 
o|contracted procedure: k6016 
o|contracted procedure: k6208 
o|contracted procedure: k6018 
o|contracted procedure: k6035 
o|contracted procedure: k6041 
o|contracted procedure: k6043 
o|contracted procedure: k6054 
o|contracted procedure: k6069 
o|contracted procedure: k6079 
o|contracted procedure: k6199 
o|contracted procedure: k6082 
o|contracted procedure: k6103 
o|contracted procedure: k6111 
o|contracted procedure: k6123 
o|contracted procedure: k6135 
o|contracted procedure: k6148 
o|contracted procedure: k6151 
o|contracted procedure: k6159 
o|contracted procedure: k6171 
o|contracted procedure: k6178 
o|contracted procedure: k6181 
o|contracted procedure: k6187 
o|contracted procedure: k6193 
o|contracted procedure: k6248 
o|contracted procedure: k6262 
o|contracted procedure: k6274 
o|contracted procedure: k6332 
o|contracted procedure: k6284 
o|contracted procedure: k6326 
o|contracted procedure: k6286 
o|contracted procedure: k6320 
o|contracted procedure: k6288 
o|contracted procedure: k6314 
o|contracted procedure: k6290 
o|contracted procedure: k6294 
o|contracted procedure: k6304 
o|contracted procedure: k6299 
o|contracted procedure: k6307 
o|contracted procedure: k6345 
o|contracted procedure: k6348 
o|contracted procedure: k6351 
o|contracted procedure: k6362 
o|contracted procedure: k6378 
o|contracted procedure: k6398 
o|contracted procedure: k6414 
o|contracted procedure: k6417 
o|contracted procedure: k6420 
o|contracted procedure: k6433 
o|contracted procedure: k6425 
o|contracted procedure: k6439 
o|contracted procedure: k6443 
o|contracted procedure: k6448 
o|contracted procedure: k6461 
o|contracted procedure: k6469 
o|contracted procedure: k6475 
o|contracted procedure: k6483 
o|contracted procedure: k6489 
o|contracted procedure: k6495 
o|contracted procedure: k6517 
o|contracted procedure: k6519 
o|contracted procedure: k6531 
o|contracted procedure: k6544 
o|contracted procedure: k6569 
o|contracted procedure: k6576 
o|contracted procedure: k6582 
o|contracted procedure: k6591 
o|contracted procedure: k6594 
o|contracted procedure: k6600 
o|contracted procedure: k6616 
o|contracted procedure: k6620 
o|contracted procedure: k6623 
o|contracted procedure: k6626 
o|contracted procedure: k6629 
o|contracted procedure: k6632 
o|contracted procedure: k6653 
o|contracted procedure: k6668 
o|contracted procedure: k6682 
o|contracted procedure: k6686 
o|contracted procedure: k66868536 
o|contracted procedure: k6694 
o|contracted procedure: k6701 
o|contracted procedure: k6711 
o|contracted procedure: k6713 
o|contracted procedure: k6724 
o|contracted procedure: k6789 
o|contracted procedure: k6751 
o|contracted procedure: k6759 
o|contracted procedure: k6784 
o|contracted procedure: k6781 
o|contracted procedure: k6820 
o|contracted procedure: k6801 
o|contracted procedure: k6804 
o|contracted procedure: k6806 
o|contracted procedure: k6818 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|substituted constant variable: g8738 
o|contracted procedure: k6853 
o|contracted procedure: k6863 
o|contracted procedure: k6872 
o|contracted procedure: k6885 
o|contracted procedure: k6903 
o|contracted procedure: k6899 
o|contracted procedure: k6905 
o|contracted procedure: k6911 
o|contracted procedure: k6917 
o|contracted procedure: k6929 
o|contracted procedure: k6944 
o|contracted procedure: k6969 
o|contracted procedure: k6965 
o|contracted procedure: k6959 
o|contracted procedure: k6979 
o|contracted procedure: k6994 
o|contracted procedure: k6997 
o|contracted procedure: k7000 
o|contracted procedure: k7010 
o|contracted procedure: k7057 
o|contracted procedure: k7082 
o|contracted procedure: k7066 
o|contracted procedure: k7069 
o|contracted procedure: k7077 
o|contracted procedure: k7092 
o|contracted procedure: k7099 
o|contracted procedure: k7105 
o|contracted procedure: k7112 
o|contracted procedure: k7119 
o|contracted procedure: k7125 
o|contracted procedure: k7259 
o|contracted procedure: k7132 
o|contracted procedure: k7253 
o|contracted procedure: k7134 
o|contracted procedure: k7247 
o|contracted procedure: k7136 
o|contracted procedure: k7241 
o|contracted procedure: k7138 
o|contracted procedure: k7140 
o|contracted procedure: k7142 
o|contracted procedure: k7158 
o|contracted procedure: k7167 
o|contracted procedure: k7172 
o|contracted procedure: k7185 
o|contracted procedure: k7196 
o|contracted procedure: k7202 
o|contracted procedure: k7204 
o|contracted procedure: k7215 
o|contracted procedure: k7218 
o|contracted procedure: k7220 
o|contracted procedure: k7222 
o|contracted procedure: k7233 
o|contracted procedure: k7236 
o|contracted procedure: k7239 
o|contracted procedure: k7270 
o|contracted procedure: k7290 
o|contracted procedure: k7298 
o|contracted procedure: k7300 
o|contracted procedure: k7305 
o|contracted procedure: k7311 
o|contracted procedure: k7341 
o|contracted procedure: k7362 
o|contracted procedure: k7371 
o|contracted procedure: k7383 
o|contracted procedure: k7407 
o|contracted procedure: k7388 
o|contracted procedure: k7434 
o|contracted procedure: k7443 
o|contracted procedure: k7459 
o|contracted procedure: k7556 
o|contracted procedure: k7559 
o|contracted procedure: k7562 
o|contracted procedure: k7532 
o|contracted procedure: k7568 
o|contracted procedure: k7584 
o|contracted procedure: k7593 
o|contracted procedure: k7596 
o|contracted procedure: k7598 
o|contracted procedure: k7664 
o|contracted procedure: k7630 
o|contracted procedure: k7658 
o|contracted procedure: k7632 
o|contracted procedure: k7652 
o|contracted procedure: k7634 
o|contracted procedure: k7646 
o|contracted procedure: k7636 
o|contracted procedure: k7703 
o|contracted procedure: k7674 
o|contracted procedure: k7697 
o|contracted procedure: k7676 
o|contracted procedure: k7691 
o|contracted procedure: k7678 
o|contracted procedure: k7685 
o|contracted procedure: k7680 
o|contracted procedure: k7720 
o|contracted procedure: k7725 
o|contracted procedure: k7730 
o|contracted procedure: k7740 
o|contracted procedure: k7745 
o|contracted procedure: k7749 
o|contracted procedure: k7760 
o|contracted procedure: k7762 
o|contracted procedure: k7767 
o|contracted procedure: k7784 
o|contracted procedure: k7801 
o|contracted procedure: k7818 
o|contracted procedure: k7835 
o|contracted procedure: k7851 
o|contracted procedure: k7867 
o|contracted procedure: k7863 
o|contracted procedure: k7872 
o|contracted procedure: k7884 
o|contracted procedure: k7903 
o|contracted procedure: k7892 
o|contracted procedure: k7895 
o|contracted procedure: k7912 
o|contracted procedure: k7922 
o|contracted procedure: k7934 
o|contracted procedure: k7942 
o|simplifications: ((if . 1) (let . 115)) 
o|removed binding forms: 557 
o|inlining procedure: k3600 
o|inlining procedure: k3621 
o|inlining procedure: "(posixunix.scm:808) mode925" 
o|inlining procedure: "(posixunix.scm:819) mode925" 
o|inlining procedure: k7095 
o|inlining procedure: k7115 
o|replaced variables: 11 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: mode925 
o|substituted constant variable: r70968850 
o|substituted constant variable: r71168852 
o|replaced variables: 6 
o|removed binding forms: 7 
o|converted assignments to bindings: (check927) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 8 
o|contracted procedure: k4583 
o|contracted procedure: k4620 
o|removed binding forms: 2 
o|replaced variables: 6 
o|removed binding forms: 4 
o|customizable procedures: (for-each-loop20372055 spawn1977 k7334 k7296 doloop18731874 doloop18771878 ##sys#terminal-check k6880 k6890 k6696 k6642 scan1605 loop1602 k6441 setup1523 err1524 k6296 k6253 loop1496 k6084 poke1473 loop1412 k5770 loop1394 check1255 doloop11791180 loop1171 k5077 loop1152 k4996 loop1069 for-each-loop10481060 check927 k4436 loop889 k4353 k4101 for-each-loop749762 for-each-loop777790 k4117 for-each-loop808819 for-each-loop829840 k4024 k3937 check-time-vector k3356 k3358 loop385 loop348 conc-loop329 k3181 k3186 loop308 for-each-loop264280 rmdir257 k2997 mode180 check181 ##sys#stat) 
o|calls to known targets: 254 
o|unused rest argument: _378 f_3526 
o|unused rest argument: _377 f_3517 
o|unused rest argument: _418 f_3572 
o|identified direct recursive calls: f_4882 2 
o|identified direct recursive calls: f_5156 1 
o|identified direct recursive calls: f_5209 1 
o|identified direct recursive calls: f_5774 1 
o|identified direct recursive calls: f_6154 1 
o|identified direct recursive calls: f_6564 1 
o|fast box initializations: 30 
o|fast global references: 68 
o|fast global assignments: 4 
o|dropping unused closure argument: f_6281 
o|dropping unused closure argument: f_2911 
o|dropping unused closure argument: f_5378 
o|dropping unused closure argument: f_4564 
o|dropping unused closure argument: f_6339 
o|dropping unused closure argument: f_6951 
o|dropping unused closure argument: f_2632 
o|dropping unused closure argument: f_2875 
o|dropping unused closure argument: f_3579 
o|dropping unused closure argument: f_3055 
*/
/* end of file */
