// Chip's Workshop - a level editor for Chip's Challenge.
// Copyright 2008-2009 Christopher Elsby <glarbex@glarbex.com>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of version 2 of the GNU General Public License as
// published by the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CHIPW_BUFFERSCROLL_H_INCLUDED
#define CHIPW_BUFFERSCROLL_H_INCLUDED

#include <wx/scrolwin.h>
#include <wx/event.h>

namespace ChipW {

class BufferedScrolledWindow : public wxScrolledWindow {
public:
    BufferedScrolledWindow();
    BufferedScrolledWindow(wxWindow* parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
        long style = wxHSCROLL | wxVSCROLL, const wxString& name = wxT("scrolledWindow"));
    bool Create(wxWindow* parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
        long style = wxHSCROLL | wxVSCROLL, const wxString& name = wxT("scrolledWindow"));
private:
    void OnPaint(wxPaintEvent& event);
    DECLARE_EVENT_TABLE()
};

}

#endif // !CHIPW_BUFFERSCROLL_H_INCLUDED
