# Copyright (c) 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# GNU Makefile based on shared rules provided by the Native Client SDK.
# See README.Makefiles for more details.

VALID_TOOLCHAINS := {{' '.join(tools)}}
{{pre}}
NACL_SDK_ROOT ?= $(abspath $(CURDIR)/{{rel_sdk}})
include $(NACL_SDK_ROOT)/tools/common.mk

TARGET = {{targets[0]['NAME']}}
[[if targets[0].get('DEPS'):]]
DEPS = {{' '.join(targets[0].get('DEPS', []))}}
LIBS = $(DEPS) {{' '.join(targets[0].get('LIBS'))}}
[[else:]]
LIBS = {{' '.join(targets[0].get('LIBS'))}}
[[]]
[[for target in targets:]]
[[  source_list = (s for s in sorted(target['SOURCES']) if not s.endswith('.h'))]]
[[  source_list = ' \\\n  '.join(source_list)]]
[[  sources = target['NAME'] + '_SOURCES']]
[[  cflags = target['NAME'] + '_CFLAGS']]
[[  flags = ' '.join(target.get('CCFLAGS', []))]]
[[  flags += ' '.join(target.get('CXXFLAGS', []))]]
[[  if len(targets) == 1:]]
[[    sources = 'SOURCES']]
[[    cflags = 'CFLAGS']]
[[  ]]
[[  if flags:]]
{{cflags}} = {{flags}}
[[  ]]
{{sources}} = {{source_list}}
[[]]

# Build rules generated by macros from common.mk:

[[if targets[0].get('DEPS'):]]
$(foreach dep,$(DEPS),$(eval $(call DEPEND_RULE,$(dep))))
[[if len(targets) > 1:]]
[[  for target in targets:]]
[[    name = target['NAME'] ]]
$(foreach src,$({{name}}_SOURCES),$(eval $(call COMPILE_RULE,$(src),$({{name}}_CFLAGS))))
[[else:]]
$(foreach src,$(SOURCES),$(eval $(call COMPILE_RULE,$(src),$(CFLAGS))))
[[]]

[[for target in targets:]]
[[  sources = target['NAME'] + '_SOURCES']]
[[  name = target['NAME'] ]]
[[  if len(targets) == 1:]]
[[    sources = 'SOURCES']]
[[    name = '$(TARGET)']]
[[  if target['TYPE'] == 'so':]]
$(eval $(call SO_RULE,{{name}},$({{sources}})))
[[  elif target['TYPE'] == 'so-standalone':]]
$(eval $(call SO_RULE,{{name}},$({{sources}}),,,1))
[[  else:]]
ifeq ($(CONFIG),Release)
$(eval $(call LINK_RULE,{{name}}_unstripped,$({{sources}}),$(LIBS),$(DEPS)))
$(eval $(call STRIP_RULE,{{name}},{{name}}_unstripped))
else
$(eval $(call LINK_RULE,{{name}},$({{sources}}),$(LIBS),$(DEPS)))
endif
[[]]

$(eval $(call NMF_RULE,$(TARGET),)){{post}}
