/*
 * MetaSound decoder
 * Copyright (c) 2013 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "metasound_data.h"

static const int16_t cb0808l0[] = {
       164,  -3637,  -3563,   -243,   -123,    -47,    -87,    -32,
        62,    129,     -2,    131,    -36,   -202,   -197,     37,
       -35,   -442,   -139,    -69,    -59,     29,    -62,    -67,
       -17,    -42,     74,     10,    107,     74,   -109,     40,
    -10210,    -33,  -3210,   -410,   -106,    512,     40,    -17,
       109,     67,     99,    170,     53,     34,    -68,    -16,
      3895,    -71,   -116,      1,    608,     66,   -215,     34,
        77,     50,    -45,    -73,      3,     11,    -33,     18,
       -34,     58,     25,   4420,     96,     77,    -67,     23,
       -83,  -6724,    226,    -32,   -150,   -154,     30,    -12,
        -8,     -7,     89,     42,    173,    -51,     38,  -1852,
        40,    -48,    -40,     81,     34,     81,     66,     16,
        20,      3,     99,     41,    123,     52,    154,     20,
       -38,      6,  10889,    -44,     22,    -39,     55,    -34,
        25,    -45,    -22,    139,     19,    -20,    -64,  -2242,
      -473,   -113,    316,    127,    -31,    128,   -363,   -124,
       196,    259,    -60,  -3792,    -41,   -103,    104,    -80,
      -389,    179,    110,     83,   3174,     60,   -197,    101,
        66,    -47,   -107,     96,    -27,     45,    -21,      6,
       116,    -51,     -8,   -594,    377,   -279,    158,   -159,
      4595,   -163,   -210,     19,      3,   -292,    -67,     14,
       115,    -41,   -125,   -154,   -263,   -101,      4,    -11,
       -89,    130,     58,     32,     92,     16,    126,    -93,
       -99,  -4239,    -69,     88,      5,   -113,    -18,     35,
        31,    -48,    -16,     35,     62,  -2839,     14,    121,
        19,     41,    125,   -102,     26, -13144,      6,    -30,
        -7,     60,      4,     36,    -40,    -26,     54,    -57,
        -9,    -30,     13,     -1,     73,   -131,     29,    256,
        39,    -51,    -12,   1788,      4,     10,    -58,     17,
       -36,     -2,     13,     59,    -20,    -21,    173,    129,
      -435,   -107,   -214,     33,   3078,     13,     31,    148,
     -2975,   -311,     38,     25,   -247,   -542,     34,    106,
      -392,     85,   -203,    182,   -232,    423,    629,   -183,
       800,   -466,   3145,  -2498,   -305,     39,     22,     41,
         0,    -14,    671,   -181,   3197,    109,   2900,     72,
       -64,      8,    414,    133,    244,   -263,     53,    -69,
        70, -13756,    -13,     21,     50,     12,    -14,    -12,
        -7,     97,    -32,     24,     51,    -24,    -29,     53,
        34,    -19,  -2341,    976,     25,    -58,     18,    -48,
     -2490,    -55,    -31,   -165,    -36,     28,    -26,     92,
        60,    137,     69,  -5341,   -125,   1966,   -154,    -66,
       -13,    -84,    -13,     81,    -46,    -96,     50,    -50,
      -114,     15,     30,   -211,   -147,   -555,   3998,     88,
       358,   -159,   -105,    -51,   -109,    -16,     70,     91,
       268,    125,    -95,    -62,     38,  -3227,   3591,    -15,
        92,    -72,    115,    144,    -40,    142,    172,     72,
       -17,     23,      1,     28,    -38,   -135,    220,    -80,
      -179,      9,    -32,     -6,     37,    -33,     -3,    -89,
      7314,      5,    194,    -13,     23,     31,     42,     84,
       197,   -163,   -251,   -273,    193,    206,   -613,    394,
      3469,   2587,   -701,     62,    301,   -104,    200,    164,
      -201,   -473,     52,   -473,    128,   -381,    404,    -69,
      -230,   -537,    157,    389,     -7,   2783,   3058,     95,
       -59,   1618,      1,      4,     53,     -6,     28,     10,
         2,     82,     28,     -8,    -14,     25,     59,     10,
        -4,     36,   -777,  -4984,     29,      8,     85,    -43,
      -137,    -34,     53,    -58,      1,    -27,     91,     15,
        80,    -19,   -186,    467,     94,   -382,    129,    327,
      3053,   -221,    399,  -2821,   1090,    278,     -2,   -163,
      -398,    126,   -266,    180,   -235,     70,    -18,    -34,
       -45,    159,    -32,     66,     11,   3177,   -188,     27,
        35,    -52,    114,    -28,   -136,    186,   2146,    100,
        92,      6,     58,    -70,    159,    -14,    -32,      9,
         6,    -27,    -73,     28,     23,    -24,    101,    148,
        80,    -52,    -27,    -53,    -36,      4,    -74,     47,
       -30,   -108,     34,   7213,     12,     31,    -17,   -185,
      3318,    199,    192,   3450,    -87,      3,     47,     46,
      -141,     49,     83,    -82,   -132,    -82,     68,    138,
     -1031,   -236,    390,    -37,     23,    -94,     -7,      9,
     -2958,  -1846,    -43,     23,     25,    -79,   -193,    -77,
     -3332,  -3355,   -139,     56,    163,  -3302,    -82,    -25,
        35,     96,     73,    166,   -154,    174,   -121,     14,
       -89,    101,  -3751,   -344,   -240,    -35,    401,    -14,
        47,    -49,     24,    -78,     24,      6,     68,     51,
      -145,     20,     83,     57,    147,   -100,     60,     33,
       -53,     11,     37,  -5793,    -93,    -67,     -9,    117,
       112,    -51,     60,     48,     49,    328,    293,    127,
      -314,  -3022,    374,   3283,    -86,    588,   -346,    436,
        -7,    -26,    -88,    104,    205,    150,    147,     34,
       126,     85,     46,   -125,   -119,     75,     13,    144,
      3721,    275,    -71,     43,    163,    -73,   -292,   -381,
       -79,     33,     79,    -79,     34,    -94,     18,    229,
        63,     28,    -44,     97,  -3606,     77,    -95,   -162,
       163,     62,   6180,     81,    -51,    -19,     -5,    109,
        71,      7,    -37,   -100,    -31,    -94,    188,    169,
       -14,   2606,   -417,     18,  -4371,    -25,    180,    108,
        17,     33,     48,    -46,    -93,    -77,     32,    -37,
       -71,   -271,    -48,   -273,    -14,    115,    -59,   -312,
     -3334,  -3046,     71,   -166,    379,    209,   -142,     22,
        89,    -41,    -40,     -7,    -50,      8,    -15,     12,
       -70,    -27,    -27,     25,    -31,     38,     -5,   2831,
       -89,     -8,    -50,   -110,   1368,    -59,  -2307,      6,
       179,     75,    189,    170,    -55,    330,    -70,    172,
        67,   -492,    -57,  -3408,      9,    -93, -11400,     14,
        -1,    -21,     65,    -15,     45,    -22,     40,    -10,
       -41,     23,    -29,    -96,    -55,    -66,    -57,    -61,
       -29,    -15,   -101,  -9831,     33,     42,    -35,     42,
       -44,    -58,     11,    -40,     27,     21,    715,   -315,
      -255,   -115,   1736,      4,     41,    -70,    -51,   -108,
       160,     -9,     87,     -6,     36,    -20,    -68,     10,
        82,    -33,    -42,     15,    -57,    -40,    -31,     21,
     10023,     62,    -41,    -10,     85,    -65,    -12,    -61,
       -72,   -610,    128,    -76,    198,    367,  -4564,     60,
       158,    -13,   -134,    -45,    -33,    -11,    -51,    -72,
       111,   -188,    232,   -494,    -27,     42,     46,    -23,
       137,   3174,  -3598,    211,    152,    155,   -299,     56,
       -23,   -123,    132,     50,     28,    -64,     28,      9,
       -17,     31,    112,    -19,      4,     45,  -7175,     54,
       -61,     -7,     87,    164,    195,    -29,    -48,     28,
       -60,     70,    -69,    112,   -295,      5,    -89,     38,
        36, -11501,     17,    -26,    -64,   -222,     91,    -23,
       -89,      0,    -94,   2191,    -74,    -84,    -61,    -41,
        57,     24,    -35,    -28,    -37,    486,    131,   3699,
      -277,     64,   -125,   -243,    270,    313,   -112,    145,
        47,  -2862,   -254,   -110,    -27,    -69,   -342,   -120,
       216,     35,     24,     62,    -39,    -29,   2402,     -7,
        -3,     14,    -47,    -27,      4,     27,     20,     81,
       138,     75,    178,    421,  -2943,  -3080,    -84,    -40,
       -58,   -195,   -182,    101,   -187,      6,    -83,    269,
       -32,    -99,     51,    -38,     44,     82,    -14,    -35,
         0,      8,    -23,  10754,    -73,    -57,     68,    107,
        85,     77,    101,      1,    -28,    103,    -10,     48,
        55,     33,    -93,    -18,      8,     28,    -14,   -575,
        28, -11712,     90,   -186,     58,     38,    -42,   2156,
       -82,     28,    -23,     43,     43,      8,     25,     65,
         0,    -53,     28,    -88,    388,    -36,    363,     64,
      3068,     56,    320,   -202,  -3433,     73,   -339,   -157,
       373,   -216,    -43,    171,    140,   -437,   -143,  -2820,
      -101,     53,   -111,     65,    -39,     65,    -30,     69,
       -55,     49,     45,    126,    174,    220,     73,   -101,
       -60,   -151,    -13,    -41,    -48,     -9,     25,   -122,
       -80,  -2450,     19,     94,     14,    -18,    -19,     60,
     -3252,    -10,   3390,    -15,   -365,    -15,    -73,   -222,
       307,     70,    -95,    237,   -142,   -163,    -44,   -138,
        -7,      6,    -36,    -67,      9,    -22,  10235,    -56,
        -8,     44,   -155,   -117,    -22,    -32,    -74,    -14,
};

static const int16_t cb0808l1[] = {
       -58,    222,   -154,    -74,    -53,   4939,    421,     67,
        26,    132,     60,    -97,     -1,    -43,    328,      2,
       460,    -66,    -11,    -45,    -56,    -86, -10569,   -129,
        58,    -25,     39,     28,     26,     45,    -61,   -139,
       -22,   -135,   -282,   -517,   -368,     55,    -47,     30,
      -110,     47,     75,    -13,     65,    -41,    104,   4745,
      -149,    -99,     28,    421,    517,    -56,     81,   -309,
        67,    -42,     -6,     17,    -60,   -151,     50,    -84,
        -9,     29,    -72,  -3019,     82,   -195,     41,    -14,
      -206,    -34,    -58,    -18,     30,   2154,    -20,      2,
        -1,     41,    -10,      7,     86,    494,    123,    328,
        73,    213,    -29,     17,     43,    -92,    -61,     -9,
      -130,   -113,     33,    -28,  -6677,   -198,   -185,   -236,
       183,   -108,    739,     60,     98,   -314,     66,     10,
     -3161,   -159,  -2850,    118,     37,    -41,   -119,   3087,
        43,    -36,     42,    106,   -174,  -3379,    -92,   -142,
      -237,     94,    -59,   -123,   -117,    144,    -75,    146,
      -268,    561,  -1160,    336,   1477,    207,     89,    130,
       127,   3763,   -372,     48,     99,    204,     84,    209,
       103,    118,    125,    326,    -29,   -206,    139,    -61,
        94,     77,   6624,   -163,     23,     27,   -104,    150,
       -76,   -205,   -186,    -30,   -227,    -58,     17,     25,
     -6536,    -19,    -66,    -45,    -72,     41,     49,    -79,
       105,     -4,   -117,    -37,   -183,    216,    -27,    -23,
       -31,  -2720,     53,    -23,    -46,     -9,    -10,     50,
       -12,    -50,    -56,     35,   5498,   -110,     -2,     44,
        -1,     13,     52,    -18,    -61,    -80,    -29,     25,
        61,    -37,     93,    -19,     67,     75,    -41,    254,
       161,    118,  -3379,    398,     -9,   -208,   -143,    207,
      -135,    -32,    171,    187,   -194,    466,    -55,    158,
        34,    105,   4986,     27,    -41,     20,     87,   -110,
        39,     80,    -37,      8,    -25,    -44,   -108,   -171,
      -366,    208,   -225,      1,   -124,     21,     81, -10349,
       -51,     33,    -51,    141,    -36,    106,   -100,    320,
       122,      3,    266,     72,     -8,   -112,     55,   -107,
     -4154,    -69,      0,     71,   -153,    -80,    -50,     20,
      -112,    225,  -1982,    273,    -19,   -127,    109,    -25,
        47,     57,    -98,    -10,     42,    -25,     10,     24,
        41,    -73,     45,  -3523,   -370,   3213,     54,    -87,
        67,   -185,    100,    -33,    -41,      3,    -38,     70,
      -108,   -120,    -67,   -144,   -181,    -33,   -104,    429,
        89,    849,   3022,  -2765,   -341,    184,   -248,    610,
       408,   -222,    184,     84,    -64,    479,   -146,     47,
      -100,     13,     17,     -7,     58,    -13,    -36,    -23,
        -1,    -25,     10,   2666,   -113,    -41,   -140,   3064,
       105,     31,   3042,    -75,   -132,   -113,     80,   -100,
       -39,    216,     -4,      7,    -43,    242,     19,  -1031,
       731,  -3659,    -24,    -20,    109,    126,   2980,     19,
       -11,    -48,     57,   -138,    -11,   -211,   -151,    540,
      -113,   -110,      0,   -415,    150,    -80,    -80,    209,
       -82,  -5212,   -125,    376,      8,    131,   -138,     30,
      -922,   -320,    181,    -75,    138,   -112,    146,    -72,
        64,    -75,   -262,   4872,    -11,    -61,     37,   -205,
        48,  -2257,     82,    106,     93,    -66,     48,     71,
        29,     72,     32,     29,     17,      5,     34,     29,
       -29,    -72,     50,  -7702,   -114,   -117,     47,     11,
        19,    100,     48,    -28,     -8,     53,     21,     80,
       -43,     37,    164,     22,    -15,  -5258,    -23,    -32,
       108,     52,      7,   -161,     11,     84,    141,     -8,
       -12,    -25,    111,    146,    -96,     66,   7388,     54,
        17,    -54,     62,     44,    -66,    -13,     26,     13,
        85,    -79,    -21,     98,    156,    181,   -103,   -188,
       -35,   -179,     83,    117,    -92,     49,   -185,   3800,
       -90,     14,     42,     94,    -83,   -178,   -156,     -8,
        33,     42,    204,     42,      1,    -85,     47,     10,
     10804,     36,      8,     26,    -47,    -51,   -189,     83,
       -47,    -23,    104,  -7142,    -67,     55,     21,     68,
         8,    -84,    -60,    -43,    142,    -41,     27,    -72,
       -70,   -170,   -141,    202,   -198,   -105,     41,  -3553,
       -34,   -148,     34,    -62,   -161,    -20,    -73,    128,
       162,  -8343,      4,    -71,    -46,     12,     27,     48,
       -41,     50,    -19,    -88,      7,     79,     29,    -19,
       -31,    -49,   -147,  -1886,   -103,   -213,     28,   -183,
      4119,     87,      6,     -6,     51,   -190,   -167,   -116,
        23,    -26,      7,    -38,   5442,  -1869,    -81,    197,
       105,   -122,     65,    220,     32,    -57,    -39,    -15,
         4,    112,    -55,   -139,   -825,    985,   -109,   2558,
       218,     94,     65,   -184,   3269,    101,    -65,     42,
       372,    -38,     58,      8,   -143,   -544,   -268,    121,
        38,     61,    -63,    -10,    -30,    -52,    -76,    -74,
     -6690,     -5,   -160,     76,    -77,     74,    374,   -917,
       239,   -203,    550,    -84,   -305,    292,    -51,     36,
       135,    -79,     27,    -69,   -309,   4561,    -67,     11,
       -60,     43,     18,     -2,      8,    -15,     20,     22,
        -2,    -41,  -2396,     37,    -79,     67,     27,    -84,
       353,   -213,  -2336,     58,     39,    126,    -78,    -98,
       -90,     -3,     -9,    -43,     -2,    -29,     -5,   -149,
        42,     98,   -109,    137,     58,    -83,    -38,     51,
      6525,     50,     97,    -31,      8,    132,    -71,    -55,
        11,    120,      2,    -43,    136,    -37,    -85,    150,
       133,     67,    -41,   -452,   -104,      4,    126,    100,
     -2660,   -108,   -109,    -64,    615,    -75,     45,     10,
       -57,    -57,   -108,    167,   -218,    -10,   -331,    -26,
       -21,   6561,     73,   -599,    126,    -23,    250,   -103,
        -4,    -28,    -20,    -35,    -19,     51,      9,    -25,
       -40, -11220,     -2,     28,    -12,     23,   3481,    169,
       159,   -217,    -48,    114,    -93,    -34,   -191,    -63,
        31,    182,     79,     90,     55,     67,   -145,    409,
       190,  -7791,    -26,     18,     71,   -113,    -80,     69,
       -21,    -27,   -121,     51,   -148,    103,    196,   2726,
       -67,   3022,    -28,     26,    -99,     51,     24,     61,
       104,     89,    -57,    -23,   -112,     43,      6,     13,
      -184,   -168,    117,    -29,   1865,     -3,     20,      8,
        30,     32,    -81,     80,    -20,    -59,     37,     19,
      -107,  -3920,   -259,     44,     23,   -129,     24,    -66,
       -27,  -3071,    116,      9,    -76,     56,    -83,     25,
        54,    -20,      2,    230,     56,    -41,    131,    -15,
       -62,     61,     56,     74,    -34,    110,   4606,     -4,
        18,    -47,    331,   -106,    -78,     70,     53,     70,
       -22,     77,    -71,    -60,   -101,     70,      7,    104,
        -7,     39,    -27,   7210,    253,    -15,      0,    -96,
        32,     50,    -10,     33,   2058,     11,    -15,     42,
       -14,     51,      4,     -3,    -11,    -86,     10,     33,
        21,    -18,    -31,     -7,     53,     -7,     95,      7,
        75, -11314,      7,     17,    -16,    -83,   -475,   -887,
     -1141,      1,   -101,      5,    -46,    110,    -90,    -47,
       -15,     19,     66,  -4078,    104,     43,    105,   -126,
       181,     43,  -1655,    -81,    -11,     33,    -33,     33,
        28,    -44,     35,     -6,    -38,     68,    -40,     67,
        73,    -29,    171,  11982,     42,     -8,    -66,    -66,
        40,    -19,     14,     33,    -63,     24,     94,    -94,
      -106,    584,    330,   -108,  -3841,    782,   -300,    -11,
      -303,   -174,   -217,     -3,     24,    168,    187,   -166,
        54,    238,   -269,    -27,    182,     -4,    -72,    -47,
        32,     39,   7622,    -46,    -67,    -53,     56,    123,
       -50,     69,    -36,   -275,    628,    -55,    195,    -56,
      -265,   -132,    -39,     -4,    169,    113,   -180,    -19,
        88,  -6427,     42,   -257,   1180,    359,    335,   3821,
       116,     79,      3,    -93,     67,    -44,     58,    -16,
       265,    172,    -39,    -44,     18,     92,      4,    218,
       122,  -2993,    150,    138,    618,     66,   -618,    402,
      2227,     10,     38,    308,    338,    -70,    265,   1047,
      -104,   -182,    305,   -162,    -99,    510,    -20,   -114,
       529,    -42,  -3569,     52,    -80,   -314,    716,    -31,
       259,     59,    -73,   -117,     38,    -44,    -16,    -74,
     -5060,     35,     10,    -30,     54,    217,     36,   -205,
};

static const int16_t cb0808s0[] = {
     -2191,   -865,  -1906,   -251,    274,    594,  -1214,    677,
       482,  -1176,     43,  -1098,   -203,   -537,   1834,   1332,
       308,    432,   -191,   3091,   1892,    926,   -446,  -1206,
      -613,    198,    575,    -38,    264,    375,    278,   -691,
      -107,     17,   -239,    261,    848,   -620,    183,    624,
       122,   -358,    -50,   1017,  -1075,   -705,   -346,    337,
      -121,    100,   -218,  -1051,   -463,  -4728,   -513,  -1151,
       737,   4356,    684,  -1374,   1630,    521,   -520,    -52,
        90,    119,    -43,   -131,     24,     -2,   -184,    -65,
       614,    371,   -448,   -414,   1415,   -687,   -224,    584,
      -768,  -1210,   2941,  -3057,    132,    406,   -952,    291,
       295,   -798,    608,  -1476,   -516,     21,   -302,   2085,
     -1700,  -2655,   -355,    175,   -409,    662,     46,   -247,
      -201,   -580,    179,    -54,    458,    836,   1543,   1829,
      -282,   -278,    412,   2422,   2077,    197,   -897,    451,
       595,   1547,    538,    825,    563,    443,   -576,   -854,
      -572,    241,   -471,    201,   -311,   -529,    112,  -5128,
      -173,   -233,   -435,    340,    158,    -41,    273,   -224,
       919,  -1570,   1075,    265,   -282,   1256,   1007,    231,
       720,    417,   -401,  -4589,   -747,   -453,  -1112,     54,
       156,   -561,   2746,   -422,    -83,    -91,   -381,   -270,
     -1226,    987,   -965,    625,   -474,    565,   2890,    -85,
      1291,   -280,    626,    -26,    840,   1122,  -1915,    780,
      -702,    792,   -578,   -122,     -9,   1175,   -194,   -571,
      2940,    540,     31,   1817,   -352,    264,    953,  -2035,
       238,   3250,  -1561,    653,   -331,   -393,    827,   -382,
       323,    281,  -1339,   -819,    545,    207,     14,    338,
       432,    860,   1691,    142,    711,    381,  -1151,   4164,
      -867,   -241,    111,   -513,   -863,     78,   1453,   -363,
      -128,   -232,  -1853,   2373,  -1156,    210,    698,   1134,
      -869,   -177,   -352,   1514,  -1370,   -789,  -1193,    819,
       348,     80,    492,    179,   -909,    591,   -600,   -377,
     -1709,     59,   -539,    557,    -45,   -362,    778,  -4919,
      -647,    203,    865,   -313,   -257,    173,  -2415,   1005,
     -1771,    843,   -474,   1619,   1193,   -186,    305,    636,
      -662,   1976,    546,    -82,   -108,   -751,    850,    521,
     -1625,  -3135,   -388,     64,    249,  -1189,  -1552,   2629,
         2,   -221,   -105,    754,    251,    219,   -270,   -202,
       545,    147,   1019,    108,  -1358,  -1317,   1362,  -1323,
     -3322,   -405,   -371,   -554,   -334,    296,    493,    248,
        -4,   1340,    123,   -584,   -804,   -766,   -164,   -470,
       295,    218,     -3,     62,   -194,   -657,   5016,    280,
        -4,    -69,   -281,   -994,    209,    307,   8648,    -37,
      -138,     45,   -329,   -101,    -65,     98,     58,    714,
        56,   -170,     60,   -203,   -248,    103,    107,   -408,
       596,    170,     61,    584,    727,   -434,   -181,  -5116,
      -502,    494,     52,     83,   -105,    325,     68,   -561,
      -274,    371,  -1833,    -78,  -2990,    320,    141,   -748,
      1764,   1157,   -538,   -276,  -1594,   -152,    838,    -45,
      1137,     13,   -803,   -162,   -838,  -1199,   2003,    580,
      3687,   -844,   -552,   -271,   -462,  -1034,    -29,    273,
       862,    269,     95,    186,   -222,   -124,     79,    -34,
      -684,    808,  -1061,   -916,    610,    539,   1289,    782,
      1216,   3213,    -38,   -546,  -1209,   -398,     98,    -39,
        58,  -1271,   -611,    573,    499,  -2170,   -157,   -943,
      -595,    436,   1203,    487,  -1419,   -570,   1468,    711,
      -589,   -101,   3299,    -45,  -1432,   -453,   1820,    677,
      1052,  -1793,   1071,   -400,    268,   -464,    443,    508,
      -273,   -736,   -233,    270,  -1187,  -1931,  -1208,   -519,
      -879,    325,   1032,    280,    565,    294,   2588,   -303,
       640,  -1398,   1070,    674,     57,   -165,    -46,    512,
       757,  -3471,   -812,   -854,     45,    101,   3195,   -786,
       -61,    122,  -1234,    -74,    119,   -389,    254,    -84,
       829,   1465,   -930,    171,   -248,    201,    939,      1,
        52,  -3517,  -1854,    147,   -843,    310,    502,    729,
       191,    525,    333,   -669,  -3358,    215,    552,    156,
     -1771,    982,   -746,    523,   -187,   -684,    456,    123,
     -1544,   -145,     58,  -1083,  -1646,  -1309,    775,   1436,
      1409,  -1114,   -171,     26,  -1775,   1103,   -392,  -2053,
     -1221,    100,  -1120,     25,   -295,    306,   -105,   -514,
     -4362,    156,  -2172,   -191,    -90,      7,    -62,    244,
      -107,    521,    309,     22,   -663,    239,   -213,   -226,
       100,   2228,   -330,   -197,  -1247,   -876,   1561,     -1,
      -354,    439,   -163,   -318,    -61,  -1184,  -3022,   1434,
        65,     87,    806,  -2093,   3016,   1022,   -779,   -391,
       -18,  -1371,   -548,    910,   -910,   -438,    673,     48,
      1028,    548,    153,   -337,    554,    353,   1686,    468,
      -190,   -113,   -560,    542,     94,   -140,   -194,    -58,
       165,   -154,   -311,   4744,   -148,     49,   -253,    180,
       -65,   -125,   -139,    -49,   -115,   -270,    439,    139,
       210,    202,   -207,    -65,   -477,    168,  -4720,    -96,
     -1091,  -2071,   -567,  -1330,    237,    411,   -123,   1197,
      2625,   1348,   -230,    362,   -147,   -139,   -699,   1210,
      -299,     92,   2835,    -36,   -296,    287,   2426,  -1171,
      -218,    884,   -320,   1130,  -1085,   1177,   -953,   -776,
       609,    827,    -90,    131,  -2757,    567,    885,  -2359,
       955,   -200,  -1883,    131,    282,    -80,    141,     -8,
       -33,    333,    809,    357,    -13,    499,    597,    923,
     -1725,  -1533,    465,    -93,   2187,   -841,    751,     74,
     -2158,     99,  -1078,   -459,    648,   -258,    349,   -917,
      1200,    374,  -1741,  -1013,    724,    -61,    182,   4032,
      -581,   1123,   -400,   -459,   -443,   -316,      3,   -271,
      -248,    -17,    595,    206,  -1188,   2869,   1338,   -253,
       316,   -474,   1680,   -856,  -1487,    547,    679,    425,
      -258,     92,     -4,    -24,    117,   -157,    385,   -257,
      -332,  -5597,    -68,   -329,    -65,   -108,   -277,    202,
      -400,    124,    -51,      5,     71,     90,   -927,    966,
       780,    305,    703,    802,  -1661,  -1415,    -66,    437,
      -610,    317,    795,    599,   -189,    322,   -519,  -4010,
       729,   -620,  -2127,    351,    506,    -68,    162,   -983,
      -288,   3167,   -140,    991,   -599,    128,   1868,     64,
       -63,     -1,   2047,    155,   -871,   -130,    226,    508,
       499,    882,   3762,   -383,    -23,      0,   -345,   -488,
       167,    648,    395,    114,   1121,    343,    232,   -538,
        15,    342,   -820,     38,    435,   -468,   -282,   -415,
     -5021,   -293,    147,    533,   -128,    -70,    503,    844,
       -86,   1836,  -2103,  -1143,    -70,   -510,    576,   -689,
       410,  -2101,    433,    339,   -417,    820,    157,    173,
       454,   -586,   1219,    -73,  -5123,    344,    397,     53,
       105,    501,    -59,    515,    194,    356,     78,    706,
       303,    332,   4532,    739,    961,   -521,   -392,     20,
      -697,    823,    607,   -243,    332,    365,   -330,    307,
       429,   -865,     -8,    545,     -3,   6041,   -310,    272,
       464,     22,   -156,    142,    -63,    -87,    297,    -24,
       562,     -9,    147,    341,    -21,    119,   1386,    947,
     -1738,   -500,   -655,     95,     32,     32,    187,    518,
      1330,     95,   -324,   3620,    737,    -54,     55,    670,
     -1252,    995,    484,   1347,   -745,    244,    262,    -83,
      -122,   1194,   -653,  -1111,   -327,   -325,   3579,   -214,
       -37,   -412,   -267,   -377,    -62,    131,    360,    203,
     -5713,    -42,     94,    279,    406,   -355,     34,   -144,
       156,   -256,    -48,    -98,  -1392,   1273,    202,  -1249,
     -3457,   -710,   1007,     37,  -1788,     86,   -570,    535,
        17,   -369,   1640,    816,   -117,    128,   -969,  -1381,
       224,   1519,   -996,   -833,    931,    185,    804,    465,
        82,     69,   -247,   3312,   -430,    -23,    173,   -223,
      3080,   1848,  -1187,  -1494,   -485,  -1131,    496,   -517,
      -596,    320,   -853,  -1303,    240,   -298,    159,    527,
      -257,    412,    839,  -1020,    706,  -3499,   -175,  -1089,
      -717,   -325,    261,    310,  -1740,  -1035,   -403,   -229,
      -861,   -970,    -62,   -192,    535,  -2154,   -364,  -1133,
       979,  -3299,    353,    982,   -517,   1144,   -563,    675,
       285,     63,     17,  -1957,     82,     28,   -513,    501,
     -1183,   1476,   -813,   -254,  -1584,  -1181,   -426,    -56,
      -916,    203,  -2693,    209,  -1066,  -1174,    279,    439,
       201,   1179,    797,    407,    851,    927,    316,   -640,
      1398,   -128,   2741,    563,  -1789,    989,    932,    247,
         6,   -617,    268,   -691,   1112,   -569,    883,    298,
        37,   -362,   -661,    -17,   -154,   -574,    721,   4578,
       205,    507,     77,    -90,   -433,  -1613,    270,   -500,
     -1061,   1634,   -388,   -432,   -648,  -1985,    629,   2887,
      -201,    -32,    223,    621,    143,    446,   1384,   1109,
       299,    329,  -1002,   -356,   1504,    -77,     49,    952,
      4166,   -544,    -85,   -412,   -249,    474,     27,   -107,
};

static const int16_t cb0808s1[] = {
      2632,   1511,    944,   -180,  -2377,     54,   -470,   -187,
      -710,   -998,   -516,   -916,   -440,   -842,    285,     22,
      -282,   -459,   -299,  -2769,  -2285,   -380,  -2194,    801,
      -595,   -252,    504,    -69,   -752,    972,    639,    277,
       502,    117,  -1072,   -145,   1462,   -528,   2165,    880,
      -182,  -2953,    750,  -1090,    596,    105,    187,    555,
      -153,   -113,    830,    161,    308,    -44,   -250,    -58,
      -507,   -406,   -626,   1453,   1357,    116,   -456,   3242,
      -607,     94,    390,    393,    114,   1069,     -2,      2,
      2497,   1405,   -755,   1353,    192,   1288,   -187,    262,
      1722,     91,    885,   -622,   -321,    246,  -1835,     17,
       213,    -80,   -658,  -1940,    275,    845,   -365,    276,
      2142,   -216,  -3402,   -646,    549,    -78,   -176,    -52,
       785,  -1335,     44,    163,   -409,   1273,    679,   -377,
       788,  -1355,  -1721,    332,    223,   1409,   -104,    165,
       354,    322,   2414,  -1611,    216,     -6,   -232,  -1770,
     -1931,   2496,   -530,    228,   -924,   -173,   -329,   -575,
     -1709,   -900,    199,    223,    690,   -636,     73,   -367,
       460,   -823,  -5105,    435,    957,    224,    246,    406,
      -673,    752,    412,   -158,   -267,      4,    694,     10,
       -45,    219,   1040,    778,  -1910,   1886,   -691,    674,
      1085,   -537,    376,   1048,    858,   -161,    613,    376,
       535,  -1349,  -1913,   -518,   -850,    665,    772,  -2985,
       -66,    -42,   2142,   -848,  -1151,    237,   -211,   -161,
     -2753,    603,    507,     39,   -575,    -61,  -1053,   -273,
       290,   -258,   -162,    139,     95,    -12,   -201,   -236,
       709,   -328,   -314,   -130,  -5337,    100,    -18,    -97,
      -206,   1827,   1722,    302,    924,   -203,    761,   -715,
       -24,    372,   -600,   2115,   1197,  -1406,    676,  -2068,
      -167,   -221,   -936,   1419,    353,   -317,    245,  -2890,
       623,    265,   -622,    204,   2549,    596,    239,    -25,
      -672,    583,    117,    -13,  -2251,  -1325,   1984,   1431,
     -1335,  -1268,    735,    245,    105,    593,   -193,   -614,
       909,   -339,  -1033,    383,    102,    363,    732,   1439,
      1028,   1275,    442,    987,  -3901,   -257,    -36,    224,
      -116,   -402,    200,   -596,   -125,    372,   -572,    398,
      -543,   1024,   1746,   -736,  -1056,  -1736,    953,   1026,
      -965,    442,  -1565,   -448,    -96,   1498,     30,   -231,
      -483,     73,  -3185,   1765,   1313,   -100,    477,   -198,
       782,    316,    364,   -107,   -431,  -1795,   -244,    122,
      -423,   -385,    457,   -872,   -535,  -1098,     80,   -110,
      1420,    646,     33,  -3226,    648,    861,    328,  -1269,
      -558,    495,    881,    112,    479,    170,   -309,   1904,
     -1412,   -768,  -1220,    -34,    995,   -649,    162,      1,
       153,    985,    762,   -263,   -188,     77,    760,  -2346,
      3430,   -450,   1677,   1090,   1771,   2109,    -14,   -119,
      -995,    268,    141,     33,     35,     31,    537,     65,
      -345,     69,    192,    763,    -18,   1078,   3829,    274,
       442,   -173,   -412,    434,   -695,    924,      2,   1551,
       566,    -85,    217,    976,   2196,   -503,  -1401,    759,
       922,  -3024,   -963,     -3,    600,   -452,   -193,   -787,
         7,    186,    828,    515,    148,   -225,  -1250,   -985,
       443,   -511,   2037,   1560,   3230,    647,   1418,   -165,
      -261,   -369,    224,    450,   -100,   -271,   -122,   -511,
      -691,  -1444,    906,   -144,    248,    452,    957,    -70,
      -517,    116,  -3559,   -877,   -399,    418,  -1300,   -415,
      -177,    770,  -2566,   -371,  -1673,  -1042,   -500,   -290,
      -708,   -631,    193,   2494,    319,    545,    767,    102,
       231,    -43,   -139,    -97,   -700,  -1592,    282,   1325,
     -1419,   -647,    449,   1995,   -737,    661,   1617,    725,
     -1464,    615,    906,    202,   -154,   -228,  -2194,   -231,
       299,    110,   1318,   1053,   -312,    843,   -937,  -1697,
      -592,  -1224,   -633,    -50,    792,   1600,  -1187,   -171,
       211,   -744,   -306,    186,   1914,  -3119,   -904,   -159,
       178,   -596,   -654,    817,     94,   -242,  -2376,   -218,
      -421,   -365,   -699,    177,   -427,    -32,    265,    -33,
       245,    -34,   5309,   -307,   -262,   -299,     86,    278,
        33,   -200,   -180,    -56,    337,   1034,   -229,   4952,
       306,   -609,    189,    -22,    280,   -160,   -507,    135,
     -1265,   -252,    434,   -427,    158,   -546,   -130,  -2500,
       597,    908,    918,    706,   1227,   3390,    995,    298,
      -558,   1307,    765,   -144,    -37,   -286,    122,    215,
     -1251,   1090,     85,   -914,    522,    316,   1829,   -701,
      -365,  -3311,    312,     22,    680,  -1351,    220,    243,
       166,    -36,    780,   2395,    -64,    836,   1037,    735,
       966,    173,   1114,    192,    510,  -1054,   1341,   -616,
      1559,    897,    338,     -3,   -194,   -214,   -573,   -265,
       328,   -365,    433,   -505,    -86,     33,   -156,   -129,
      -137,    119,    143,   5773,    -76,     68,    820,   1215,
      1315,    713,     12,   1590,    131,   -193,   -881,   -227,
       736,    581,    736,    -37,   -434,   -449,   -348,   4189,
      2180,  -1360,  -1663,    -74,   1215,    278,   2092,    -66,
       313,    388,  -1373,     25,    599,    888,    -87,    293,
        30,    367,   1010,   -883,    818,   -910,  -1918,    864,
       482,   -968,  -1249,    222,   1100,     23,    -87,   2493,
      -248,   -622,    240,    151,    873,  -2735,   1325,   -700,
      -411,    282,  -2361,  -1843,   -631,   -208,    103,   -411,
       831,   -446,   -292,    450,    184,   -158,    484,  -1964,
      4663,    123,     18,    174,    621,    158,   -788,    233,
       302,    441,   -339,    200,    -62,   -197,     -9,   -236,
       984,    584,   -521,   -373,   -205,    910,    392,    850,
     -2968,     68,   -727,   1330,    578,     36,   -385,    754,
      -538,    -36,    271,    418,   -548,   1775,  -1045,   -879,
     -1407,    524,  -1085,  -1479,    371,     19,    873,    171,
      2932,   -216,     42,     71,  -1187,   -570,   -524,    344,
      -770,  -4086,   -735,   -515,   1055,   -551,    945,  -1408,
       913,  -1005,   -222,   -443,     60,   -194,   -734,   1908,
      -534,  -1351,     72,   -938,    -66,  -2756,   1313,   -169,
     -1550,    450,   -610,    893,   1100,   -583,     87,   -145,
      -210,    281,   1402,    674,      0,    -38,    874,   -363,
      2436,   2156,  -1659,   -481,   -130,    -63,   -669,   -316,
      -761,   -413,    108,   2362,    354,     76,  -1725,   -924,
     -1443,   1251,    871,  -2058,    518,    955,   -283,    680,
       -85,   -560,   -464,    127,   -216,  -1382,   1908,    238,
      -182,    459,  -1227,   1144,   2266,    -96,    595,   -750,
       912,   -198,   1786,  -1423,   -618,   -450,    185,  -1212,
       706,   -689,   -154,   -365,   -681,  -1378,    914,  -1200,
      -253,   -532,   3244,    444,      1,    -96,   -404,    -64,
      -412,  -1400,  -2830,   -785,    940,   -217,    358,    618,
       208,  -2974,   -365,    -32,    -63,   -233,   -868,   -413,
       358,   -451,   1310,   -751,  -1329,  -2480,     63,    458,
      -273,   1270,    316,     93,   -453,   -463,  -1258,    -57,
     -1073,  -2037,     46,   -160,   4609,  -1193,    192,   -355,
      -963,    -92,    752,    593,    102,    -80,   -121,    166,
      -606,   -274,     28,    258,     45,    -45,    928,   -949,
      -134,   -268,    -77,    242,   1623,  -1290,    739,    109,
       285,    175,    -92,  -4053,   -482,    366,    217,   -126,
      -843,    950,  -1068,    777,   1818,    550,   -891,    -34,
      -995,   1976,   2677,   -764,     45,    -40,  -1800,    569,
      -323,   -102,  -1064,   4000,   -109,   -423,   -289,    738,
      -872,    808,   -977,    504,   -901,     41,    -45,   -287,
      -140,   -444,    477,   -271,   -876,    301,  -2421,   1633,
      -918,   -660,   -149,  -2542,   -503,   -265,   -107,   -623,
      -447,   -782,   -858,   -535,   -220,    442,    661,   -209,
       878,  -1601,   3610,    149,   -331,    190,    102,    270,
      1451,    237,     13,  -1026,    178,   1290,   -281,   -217,
        11,  -1728,   1043,  -2992,   -718,   -776,    357,   -615,
      -231,    813,   -473,   1634,    539,   -513,    240,   1158,
       144,     57,   1249,   1479,   -481,   -733,   1663,   -757,
       641,    680,   -468,  -2697,    -29,    -62,   1253,   1142,
       292,    245,    -96,    295,   -664,   -264,   -308,   -670,
      -705,    155,  -4024,    330,    191,    -77,  -1502,    326,
         9,    295,   -567,     34,   -104,   -123,   -320,   -255,
      1124,    320,     98,   1299,   -436,   1491,   -341,    908,
        11,      8,    988,  -1921,      5,  -1391,    859,  -1291,
      -581,    546,    -95,    272,   -441,    185,   -256,    313,
       466,   -393,    -50,   4430,   -940,     87,   -224,    390,
      -539,   -290,  -1046,    531,  -2329,   1275,   -586,  -1046,
     -1682,   1159,    908,   2023,    951,   -273,    -68,    713,
      -556,    770,    783,    223,     60,   -881,    -97,    760,
       556,   -237,   -263,   -246,   -240,    165,    526,    832,
     -4761,    432,   -339,    186,    492,     81,   -136,   -827,
      -390,  -1026,   -371,   -292,    937,   -243,   -136,      6,
        49,   -223,   -600,   -355,   5306,    140,     34,    -84,
};

static const int16_t cb0808m0[] = {
     -3555,   -106,   -131,    -53,   -156,    196,   -206,   -104,
        18,  -2948,    122,    146,   -520,      2,    294,   -419,
        -1,    -25,   -257,   9334,     87,    -55,    -42,     30,
        92,     35,    195,     31,     59,     88,     47,     47,
      -220,    564,  -1686,    426,    106,    396,     97,   1315,
      2331,    167,  -1261,   1003,    732,   -300,   -342,    418,
        87,    236,   -245,   2235,     11,    725,    -24,   -169,
      -480,   2845,     96,    -34,     67,    857,     28,     50,
        92,   2100,    -84,   -600,  -1990,  -2208,   -163,    299,
       431,   -825,   -283,    299,    -98,    391,    -65,    -92,
      -200,   -689,   2236,    -82,    -81,    -52,    127,     86,
      -137,   -319,  -2561,    -90,    547,   -198,     10,    195,
      -366,  -2688,    -77,   -234,   -112,   -245,    270,    199,
      2674,    -57,   -673,     -9,   1029,    -31,    311,    -50,
      -160,   -175,   2371,   2711,    409,    -19,     22,   -244,
       312,   -158,    270,   -125,   -247,    118,    -91,   -602,
        86,    174,   -216,     18,   3048,  -1953,    171,  -1985,
      -297,    295,    -38,   -198,   -229,    363,    -13,    127,
        13,   -202,   -117,     65,     74,     63,    125,    -62,
        -2,   -543,   -680,  -4269,   -130,    325,    -49,   -245,
       -50,   -509,   -151,    -19,      3,    152,   -980,   -129,
      -234,    399,    349,    171,   -196,   4952,     -2,     36,
       288,    771,   2313,    231,    -39,    572,  -3012,     77,
      -501,   -215,   -228,   -444,    830,    200,   -188,   -157,
      3248,    279,  -3319,      0,     76,     10,    160,    -80,
       135,    102,   -349,    174,    -30,    -88,   -145,   -205,
        10,   -185,    177,    -34,     25,     31,    218,     -4,
       191,    172,    228,   -136,   -178,    268,    638,   3559,
        55,    198,    145,    342,    -25,  -1940,   2866,   -334,
      -921,   1941,   -464,    273,   -181,   -506,    -21,   -410,
       116,   -179,    -49,   -273,    -22,    -36,  -1298,    274,
     -1831,    321,   -382,    238,  -3464,    -68,   -194,     32,
       -95,   -506,     72,     64,   -329,     19,    -39,    347,
      -302,    204,    145,    -72,    855,   -112,  -3596,    989,
     -2801,    386,  -2623,   -471,    101,   -155,    257,    291,
        30,   -153,    185,    172,    511,     20,    166,    274,
        29,  -3023,    129,     33,   -219,   -205,      6,     47,
      -407,    137,    563,   -106,  -2065,     76,    201,    -99,
      -170,    -77,    170,  -4536,   -440,    -96,   -940,  -1066,
        81,    205,    358,    435,    -78,   -148,   -201,    -85,
      -307,   -306,     14,    -47,   -101,   -187,   -136,    380,
        -4,    -32,    -34,    -54,    528,    -58,   6389,    302,
       -79,     52,    -28,    -65,    -77,    -12,   9024,   -100,
       262,     20,    -67,    -31,     50,    -33,    -30,   -140,
       326,  -1170,   -304,   -136,   -233,    170,     60,    314,
      -166,   -208,   -105,   -245,   -169,    -72,    137,  -7173,
        -2,    375,    152,    226,   -206,   -341,    303,     47,
      1010,   -188,    577,   -292,  -3581,    -12,   -195,     20,
      2165,   -206,    -88,    -83,   -132,    -40,   -443,    236,
      -333,    179,   -211,    -56,    318,   -409,   3106,     95,
     11636,    340,    204,   -323,    167,     76,     61,     65,
      -157,     71,    -21,     38,     66,    391,    -52,     20,
       -17,     11,    259,     45,   -194,    440,   3432,    122,
       468,   -595,  -1856,     94,   -427,   -133,    149,   -273,
        61,  -6622,     48,     97,   -162,     93,    402,   -104,
      -207,     64,   -278,     92,    387,      3,     96,     -2,
       -27,    -30,     84,     64,     35,    -65,     98,     85,
       -16,   -248,   7930,     74,      4,   -104,     83,    -48,
        40,  -2104,    -86,    -89,     99,   -142,     65,  -2713,
        63,   -431,    523,    687,    212,  -1515,      3,     59,
        55,     -6,     22,     -8,   -148,    180,     78,   7833,
       -63,    -83,     13,   -187,   -116,    156,    -29,   -186,
      -160,    148,    -82,   -303,   -166,    112,   -103,    -39,
      -165,   2827,    -54,    -26,     24,  -3055,     78,     21,
       128,    -81,    -25,   -122,     51,    -54,    -19,    188,
       -18,     -1,   -140,    -18,  -8085,    124,    -46,     45,
      -574,     12,   -150,    147,     65,   -209,   -396,   -444,
     -3882,   -291,   -231,    296,    244,     76,    180,     36,
     -2575,    659,    -63,   3277,    -85,     48,   -518,   -353,
       130,     50,     13,    338,   -343,   -276,    -16,    353,
     -6036,    -77,     18,    139,     43,    335,    294,     99,
       219,    442,    -25,    -53,     40,    271,    175,   -282,
       -91,    430,  -4428,    -15,  -2857,    -62,    -27,   -170,
        33,   -681,   -110,    -76,    153,     42,   -134,   -145,
       222,   -177,    -39,    314,   2270,    526,    500,   2417,
       339,   1808,    -17,    464,   -525,    -97,    124,    -32,
       370,     48,  -1675,    -62,   -169,   2642,   2511,    -43,
     -1037,   -184,     54,   -569,   -504,   -247,    -40,    327,
         7,     82,   -197,   2774,    -34,  -2931,   -204,   -112,
       194,   -362,    187,     65,   -166,    115,   -125,     14,
       210,    144,    -75,     57,   -255,   -151,  -3566,   -153,
       182,     89,  -2530,     98,   -265,   -173,   -133,    260,
       -25,  -1292,     35,    131,    -98,    -85,   -237,     82,
      1353,     47,   3842,    148,    171,    183,    234,     89,
       -93,     47,    102,     -4,     90,   2980,    289,   -231,
       353,    497,   -109,    190,  -2869,    697,    136,     90,
      -244,    298,   -119,   -519,    -50,    207,    -43,  -1376,
       356,   1934,    701,  -2323,    671,     71,    -56,   -167,
     -3793,  -3749,   -103,    134,   -228,    -13,     27,    -45,
      -105,    172,    -77,    -23,     53,    110,   -118,    -80,
      -164,   -192,   -563,    393,    -58,   -428,   -360,   3696,
       162,   -173,   1683,   -430,    452,    -92,    107,    -41,
        28,    -85,    421,    -66,    354,    -88,    723,   2751,
     -2955,   -481,   -134,   -231,   -145,      3,     65,    -88,
       189,    187,    151,    174,    -36,    240,   -253,   -235,
      -194,  -5410,    -47,    -98,    338,   -487,    -81,    -35,
       -82,   -440,     31,    109,    217,    276,  -1805,    278,
       273,   -369,    629,   -293,   -525,  -3832,     73,    -56,
      -363,   1709,    177,  -2813,    796,   -162,   -341,   1176,
       -75,    533,    854,    719,    242,   -194,     90,   -147,
       203,   -136,   -138,   -764,      6,  -2787,    -13,   1104,
      1497,   1097,     90,   -867,   -718,   -317,    119,    180,
       160,    257,   2532,   -557,    -62,     14,    665,   1520,
       456,    826,    394,   -605,    908,    222,   -140,    121,
       121,    232,    124,     96,    -87,     48,    -51,     41,
     -7821,    -37,    130,    -11,    -33,   -137,     16,     42,
      1509,     -8,    119,    -83,    -18,     64,     41,   -178,
       -28,    182,    532,    678,    -75,    277,   -230,    -70,
       -71,     -8,   -150,    321,  -6298,    -20,   -131,    -65,
       139,   -215,   -155,    -27,   -110,   -257,     32,    201,
       215,    184,   8932,   -106,    -50,     66,     15,    -44,
       203,    -38,     19,    -78,     65,    135,   -123,    166,
       117,     76,      4,     34,    -90,   5984,     59,    -72,
       356,    -64,      6,    -62,     43,    -86,   -175,   -106,
        10,     25,   3812,   -135,  -3313,    142,    348,   -101,
       -35,    378,   -250,   -106,   -299,    237,     40,    -32,
       236,   -521,     63,   -143,    538,   -256,     43,    -45,
      1642,    726,  -3225,    109,   -997,      3,   -256,    -27,
      -182,    -78,  -4092,     -9,    231,     34,      9,     -6,
       155,   2842,     53,   -130,   -390,   -146,    168,    -74,
     -2023,   -955,    576,   -629,    -76,     70,    140,   -287,
      -401,    966,    359,   1185,   -226,    713,    753,   -739,
     -4238,   3364,     75,   -213,     27,   -172,    -34,    171,
      -118,    -46,   -164,    -13,    -54,   -203,   -154,    -12,
        65,  -3777,  -3452,    297,   -104,    -93,    -81,     69,
      -179,   -321,     51,     47,    242,    -15,   -144,    -43,
      2827,     67,   -305,     54,  -3044,     57,    -15,   -427,
       311,   -205,    226,   -490,     37,    363,    -88,   -408,
};

static const int16_t cb0808m1[] = {
      3329,     59,    195,    -91,    -70,   3262,   -132,    360,
       157,   -410,    184,    -99,   -138,    337,    289,    317,
       156,   -589,   -127,   -204,     37,   -175,  -5661,    -52,
       942,    156,     -1,   -197,    353,     90,     57,   -287,
      -218,    438,     -4,   -262,      9,    322,   -167,   2904,
       -12,  -2647,   -248,   -203,   -267,   -116,   -135,    333,
      -220,   -200,     40,    228,   2677,   -462,   -183,   -129,
      2898,   -728,    793,    422,    541,   -350,     28,    222,
      2790,   -231,   -195,   -191,   3002,    182,   -610,    145,
      -226,   -102,    285,    344,   -357,    217,   -146,    -98,
        18,   -255,     96,   -151,    266,    208,   -459,   -132,
      -345,   4059,   -371,     79,     44,    -63,   -233,    334,
        44,   3884,     49,  -3303,     88,    -23,   -287,   -461,
        57,     94,    -53,   -129,    104,    167,    -25,    -79,
      -125,   -630,  -2352,    150,   -419,     40,    -63,    603,
        67,    209,    321,  -1765,   -200,     68,    473,    622,
         5,  -2883,    112,    188,   -189,  -2765,    169,    397,
      -330,   -642,   -798,    129,   -110,   -164,    -20,    176,
      -213,  -5415,     39,     31,     13,    270,   -477,    166,
       167,      4,    216,    -12,   -528,    -75,   -291,    396,
      -499,  -2011,   -172,   -265,     96,     83,   -279,    114,
      -166,    833,     30,   2493,     94,    130,   -183,   -659,
         1,   -227,     75,    349,  -2757,     82,   -116,      9,
       952,   -112,  -2444,   -333,   -206,   -406,    201,     15,
      -768,     88,   1390,    -33,   -558,     97,   -201,     29,
      3470,     50,    -40,   -271,   -171,    -26,     47,    485,
      -250,   3318,    112,    639,  -2911,    123,   -264,      3,
         8,    379,     73,     54,     88,    227,     73,     58,
      -572,    782,   -183,    305,     49,    -23,  -2968,    -41,
       291,    -25,    157,    295,  -2118,    125,      5,   -193,
      -159,   -543,    -75,   1181,   -191,   -547,    -93,    117,
     -1831,    265,   -607,    -30,    194,  -3929,    -70,    159,
        79,  -1519,     38,    201,     14,    -24,    -76,   -366,
        14,  -2748,      0,   -372,    405,     39,   -170,    320,
      -257,   2153,    -12,    158,    322,  -4013,     22,   -101,
       217,    637,    273,   -430,    228,   -428,    102,   -356,
      -266,     82,    -31,     14,   -223,  -2595,   -360,   2094,
      -379,    624,   -192,    245,    294,   1484,   -117,    156,
       -53,   3668,  -3573,   -118,   -213,    257,   -211,     66,
       -62,   -173,   -166,   -123,    163,    -81,    -39,    -74,
       -21,    126,    722,   -136,   2050,   -206,     86,    275,
        76,   -249,     55,  -2508,     95,    -60,    -34,   -360,
        -9,    187,     34,    -87,    -30,    137,     48,   4761,
       109,    511,   -496,    104,    399,   -361,    162,     78,
       -29,    159,   -112,    182,    246,     52,    255,    338,
       -35,     -1,    -68,      5,    182,   7675,   -119,    -14,
     -1901,   -111,   -106,     22,    -16,     81,    159,  -2423,
       -71,    -24,   -153,   -520,    126,    370,   -186,    230,
       -51,   -401,    206,    -32,     52,    -71,    -79,    503,
      -239,   -231,     55,   -133,   5226,    -45,   -165,     57,
      2314,   -209,    302,     78,    154,  -3092,   -605,   -498,
       410,    159,    336,   -147,   -120,    143,     36,    587,
      -182,   -182,   1457,   1008,   2524,   -446,   2333,   -497,
      -761,   -162,    125,    420,    225,   -117,   -324,    437,
       -50,    190,    129,    259,     33,     -2,     -9,     32,
       -24,     91,     97,    201,     19,    169,   3535,    485,
      -144,    330,   -193,  -2715,    603,    303,   1124,    107,
     -1386,  -1437,   -203,    180,    -81,    303,    209,    -21,
       -65,     26,     91,     98,  -1349,    196,   2103,    917,
      -732,    834,   1456,    -92,   -455,   -130,   -732,   -288,
        39,    -85,   -557,    -39,   3213,    297,    392,   -378,
      -520,    795,  -2407,      6,      7,    406,    203,    -73,
      -247,    317,  -3336,   3166,    206,    -36,    159,   -279,
       442,     54,   -324,    -18,    544,   -250,    142,   -440,
       100,   -145,  -3772,   -199,    139,   -156,    -11,     34,
      -178,   -233,   -370,    601,    -58,   1679,   -170,     76,
       684,    -35,    -73,    -52,    -33,     -3,    -89,     -5,
       -82,     73,    -11,     51,    -48,    -12,   -376,   4348,
      -203,   -432,    189,    -35,    144,     31,    181,   -106,
     -5112,    552,    480,      0,     63,     31,     33,    504,
      1055,  -3007,   -214,    154,   -100,    246,    269,   -423,
       579,     63,   1668,   -296,    390,    109,     21,     -6,
        71,   3321,    246,    197,    355,   -198,    472,    135,
       437,  -1734,   1299,    227,   -618,    -48,   -199,    217,
      -230,     70,     99,   2632,   -203,   3105,    -87,    149,
       303,    124,    362,   -322,    -44,     38,    104,    -28,
        48,   -175,   -468,   -410,  -4451,   -152,   2157,     26,
      -281,   -581,     36,   -205,    101,    230,    192,   -129,
       319,     20,     65,   4879,    123,   -236,   -178,   -128,
      -387,   -124,    528,    142,   -775,   -301,    -88,   -380,
       120,    -42,    -17,     64,  -1074,  -3350,   1335,  -1078,
       -14,   -462,   -113,    253,    450,     36,     -8,   -346,
       -54,     -7,     52,   -100,     74,   8266,   -193,    -36,
       -51,     12,     59,    -68,    190,    -36,     89,     38,
       -59,     13,    269,    109,    -15,   -141,    -64,    -60,
       238,      6,  -4338,    381,   1252,    354,    -41,     41,
       191,   -236,    122,  -2712,    352,   -117,   -121,   -284,
      1516,    473,   -332,   -277,  -1792,   -335,     84,     64,
      9595,   -246,   -278,    446,    -95,    -32,     60,   -146,
       104,    -84,     -3,    107,   -116,   -377,    101,   -149,
       -45,    364,    104,   -193,   -254,   2929,   -164,    -93,
       324,    749,   -928,    435,   2357,    350,    -40,   -153,
       -48,   -626,    390,    -48,  -4248,   -458,   -930,   -218,
      -486,   1769,    335,    152,    165,    111,    118,   -407,
       -87,   -373,   -333,   -134,     86,    -32,   -144,    -18,
       -16,  -7549,   -146,     49,   -184,    116,    -28,    -51,
       190,    115,     80,     68,    129,    206,    294,    331,
       179,   -270,    174,   2444,     55,  -3271,     70,   -124,
       228,    330,    -21,   -419,     62,   -140,  -2388,      7,
     -2683,   -129,  -1050,   -548,    811,    189,    359,   -385,
       -82,   9031,     95,     77,    -69,    164,    261,     61,
       -73,    230,   -163,    141,    -38,    -43,   -150,    164,
        28,    164,     59,    -58,   -312,   -134,    102,    -67,
       166,   -163,     63,  -6795,   -103,   -147,     81,    273,
       133,    122,   -162,   -207,    127,    -60,   4628,     -1,
      1315,    518,   -163,   -246,     54,    239,    154,   -154,
       265,   2000,     25,    227,     42,    179,     88,  -3446,
      -214,    182,    438,     90,    196,    -69,    134,    -56,
      -451,    716,  -1120,   -287,    118,    230,    -37,    145,
       284,   -250,    139,   -947,    203,  -3176,    -57,    151,
      3201,    818,    -87,    347,   -486,   -201,   1176,   -325,
      -966,   -263,   -184,    238,   -156,   -396,    152,    959,
       -59,    -33,   -159,     -3,   9394,   -119,    -81,    -50,
        67,      9,     27,    -62,   -121,   -210,     48,   -211,
         5,    396,    633,     34,    -16,     67,   -247,    -77,
       128,    441,   3896,    251,    970,    119,   -387,    -35,
       124,    -64,   -664,  -6550,    101,    -52,     19,     44,
      -132,     79,    731,   -155,   -262,   -140,    -31,   -191,
      -110,    276,   -162,    -49,     81,   -117,     15,   -570,
       420,  -1232,   -125,   3737,    -95,    544,   -149,    463,
      -129,   -345,    350,    183,    173,    197,    464,    180,
      -249,   -365,   -785,     -9,  -3411,   -235,   -124,    225,
     -4516,    196,   -150,    -89,    -89,     54,   -110,    137,
      -431,    272,    -12,     -7,    114,   -201,    166,   1570,
       -74,    -88,   6019,    350,    -75,     68,    -29,    -81,
       -50,     57,    -62,    103,     61,    276,     22,   -131,
      -134,  -3347,    -60,  -3397,   -311,   -105,     90,   -159,
      -222,    151,    224,   -210,    264,    192,     29,    -84,
};

static const int16_t cb1616l0[] = {
       -15,  -7707,    115,     30,    -36,    -27,    -22,    -43,
         2,      5,     31,     -1,     87,      2,     41,     21,
       270,     16,   3747,   -773,   3027,    224,     92,   -168,
        -7,    -62,    -79,    -44,     -9,     -4,    -58,    -78,
      1063,    203,     -2,     76,    289,    -36,     92,    -29,
       -78,   -148,  -5176,    137,    219,    299,     89,   -233,
        62,   -129,     33,    123,    -30,    197,   4018,    -37,
       -38,    139,     41,    153,     71,    -26,     27,     53,
        72,   3358,    -68,   -122,    293,    -19,   -355,    104,
        34,   3121,     16,     29,   -344,     37,    174,    -28,
       -43,   -102,    -59,  -1661,     14,      5,    -62,     -1,
        14,     15,    -42,      4,    -31,     -2,     13,     23,
       957,   -419,     20,     31,    -14,     51,     24,    -46,
         8,    -16,     27,    -75,    -27,    -33,    -28,     18,
       -67,   -152,    -48,     47,     90,     48,    -74,   -103,
       -18,   4863,      3,    132,    414,    -86,    -60,    285,
        16,     32,    -44,      0,     22,   -163,     23,     -3,
        23,    -61,  13224,     52,   -139,    -13,    171,    215,
       -51,    -21,    -48,     33,    -10,    -17,    -21,  -7662,
       -57,    -44,    -51,     35,     35,     34,    105,    178,
       -77,     77,    147,     67,   -816,   2913,  -3087,    516,
      -112,   -296,     21,    133,    211,    162,     87,    -25,
      -535,   -830,    -12,     46,    -59,    -10,     -4,     42,
         0,    -91,     -9,     47,    -90,    -29,     74,    322,
      -106,     83,     44,   4693,   -788,    -73,    -85,   -105,
       -76,  -1031,     34,      6,     78,    -34,    160,    -48,
      -707,    -12,     -9,     39,     14,     23,     88,  -2286,
        21,    -25,     42,    130,     39,    251,     16,    -50,
       397,   -226,  -2570,     88,   -129,   -347,    159,     92,
         0,    -44,    -49,    235,   -196,    -24,    -36,    113,
     13387,     45,     22,     54,    -20,     29,     27,    -27,
        54,     38,    -63,    -12,    -74,     45,     -8,   -115,
       591,     46,      5,   -234,     57,    124,     86,  -3794,
       -51,    292,   -160,   -152,     96,   -334,    348,     96,
      -186,  -3870,  -3715,     54,      0,    -29,    -65,    -68,
         6,    132,     47,   -155,     62,     26,     66,    -10,
       -46,  -3093,     66,   3633,    183,   -171,   -132,    -24,
       154,    157,    129,   -185,     12,    -26,     96,    -12,
        88,    -34,     42,    -15,     37,  -6625,    -27,     13,
        41,    -30,     62,    142,    -93,   -168,     84,    -22,
       139,    -19,     18,  10590,   -111,     36,     13,    -44,
         4,    -45,     -3,     -3,     28,    -25,     -4,    115,
       119,    -49,     41,     33,     87,    -85,  12444,     73,
        71,   -111,     61,    -15,    117,     23,    -24,     -5,
       131,    -31,     -1,    -22,    -57,    -12,     50,     35,
     -1555,    -20,     38,     82,    -52,     27,   -128, -14106,
       808,    190,     89,    595,     63,   -291,    282,    -48,
        32,   -706,   -433,   -673,   3285,   1311,    830,   3745,
      -204,  -1185,   -584,    -51,    952,   1005,   -566,   1764,
       186,   1211,   -495,   -112,   1213,    192,   2320,    -43,
       -30,     24,  -1152,      2,      2,     32,    -55,    -25,
        -2,    -17,    -14,     -6,     22,    -54,     32,     45,
        10,    -85,    -26,    -16,    -66,    -60,   -210,   -104,
       208,   -248,     62,    -28, -14552,    -11,    -44,   1601,
        47,   -138,     46,    -35,   2647,    -81,     -3,    -38,
       -66,    -59,    -33,    -19,     43,    -17,    -79,     53,
      1821,  -1572,   2582,     85,     48,   -140,     78,   -155,
      -173,     96,    -32,    121,    -58,    201,   -174,    -54,
        74,  -2442,   -282,   -771,     37,  -2930,     15,   1762,
       154,    263,    -15,    -19,    139,    246,   -243,    -31,
        84,    145,      8,    152,     43,    128,    679,   1828,
      3476,     17,     92,    102,    258,    -29,   -275,    -39,
      -187,     88,     70,     28,      2,   2143,    274,    202,
       -67,    -13,    -22,     68,    -35,    135,    114,    108,
        27,      1, -11248,   -100,     14,     26,     59,     10,
       -24,     30,      1,    -38,     -9,     21,     18,     -1,
      2029,    -83,   -342,   3443,    -25,      7,      0,     54,
        78,    198,     45,    233,     -6,      0,   -109,   -172,
     -2250,     41,    -79,   2820,     44,    216,     39,     59,
       -41,     52,     79,    -52,     12,     23,    -72,   -125,
        83,     17,    -28,    -32,     13,      2,     28,      0,
       -26,     75,    -81,     66,     25,    -81,   6516,      9,
       -93,     49,  -4036,  -2484,    -42,    -71,    178,     99,
      -133,     79,    -41,   -112,     57,     66,    -28,     13,
        39,     64,   -123,   3174,   3061,    259,     55,    123,
      -123,    246,   -138,    139,     75,     31,   -215,   -154,
      -218,     26,     16,     21,    126,     26,    -33,    -10,
       -15,     16,    -20,    -53,     21,  15526,    -35,    -59,
       -50,    -11,    -58,     67,    -11,    107,    -24,    -37,
      8155,     31,   -111,    -62,    138,    -60,    -10,     84,
      -128,     37,     24,    -45,    -10,    129,    -68,    -37,
        42,    -80,   -205,    -79,   5994,    -93,   -270,   -400,
        20,    -89,    -39,   -200,    230,    197,    325,   -305,
      -294,     94,   3207,    128,   3119,    226,     28,    -49,
       264,    186,      8,    -29,    -13,     27,     22,    -63,
        43,     84,    -19,     57,  -2605,    316,    259,    -43,
        50,  -2241,    105,    -12,    -23,    -36,     89,     41,
       -15,    145,     10,    -81,      7,    -50,     70,     60,
       -23,     55,    -62,      0,     52,    -77,    180,     74,
        79, -14297,      6,     24,    299,   -107,      4,    -29,
     -3252,    -51,     40,   -143,   3550,    -28,    102,     24,
       215,    147,   -169,    -60,    -43,   -486,      5,     -1,
        62,   -116,  -2917,    430,     50,   2927,    139,    127,
        63,    -53,    141,   -255,    -85,     95,   -101,   -176,
       195,    104,  -3066,    -56,   3239,   -161,   -214,     57,
        24,   -375,   -181,      0,   -259,    130,   -120,     -2,
        -6,    175,   -147,   -185,     68,    219,    425,   2685,
     -3120,    266,    246,   -270,    -70,    273,    168,    121,
      -143,   2641,   -553,   -547,    638,    113,   2965,   -161,
        29,   -374,    105,   -869,    108,     70,     15,    230,
       -54,   -106,    -21,     -4,     86,     85,    155,   -120,
       -17,    -21,  -2534,     57,    149,   -129,     21,   -169,
     -2289,   -127,    -19,    -26,      3,     60,     35,      1,
       -28,     -7,     36,   -180,    -13,     87,    -68,     56,
        80,     64,     -8,    -73,   6691,    -32,     47,     48,
        -6,     61,     36,     -8,    -41,     -1,     13,     68,
       140,    -51,     25,     12,      3,     57,    -54,    -33,
       -19,     12,     28,    -60,    -56,  -2399,    -14,    127,
      1935,     84,    127,   -193,     -3,   3307,    -56,     15,
        31,   -116,   -187,    236,   -289,    261,     69,    144,
      1723,     79,    -68,    102,    727,     69,    654,    -60,
        21,    124,   3497,    248,   -684,   1469,    368,   -254,
      -211,  -2600,    771,   -138,    368,   3089,     52,   -206,
       147,    200,    -15,   -136,    194,   -164,   -352,   -152,
     -4870,      5,    191,     -3,    -97,     28,    -41,    107,
         2,     11,     60,    -76,    -35,    -42,    129,    -77,
     -2610,   -295,   -218,   -369,     10,    253,     15,   -125,
        74,    -87,    -70,   3366,    115,    240,   -106,    -93,
       121,     10,     36,      9,    -18,    -66,    -77,      7,
        37,    -76,    -22,   2913,    242,     22,    172,    102,
       186,   -231,     90,    -11,    -57,     45,    -10,    -44,
       -84,     44,   -117,    -43,     49,   5585,     18,   -166,
       -43,     64,     28,     -9,     26,   -160,     31,    -28,
        29,     56,     29,    -57,    109,    -25,   3140,   -131,
        57,    -20,     27,    -27,     -5,    -42,    -52,     18,
        23,    -56,    -38,    -14,    213,    -33,    -86,  -4741,
      -151,    -46,      1,    -17,     46,      7,    -13,      0,
        50,     28,    -57,  -7291,    -20,     12,     66,    214,
};

static const int16_t cb1616l1[] = {
       -81,      5,    -16,     34,     19,  10938,    141,    -21,
        27,   -105,   -110,     32,    -67,    -75,     19,   -138,
         3,    -14,   -408,   -302,     36,  -4612,     23,   -579,
       -35,     19,   -312,     35,    120,     97,     82,   -109,
        41,  -1745,   -158,    299,  -3069,     84,     18,   -447,
       -33,     65,    -32,     45,     -7,    144,     86,    100,
     -1738,    250,   -226,   -137,    159,    -45,    134,    438,
       102,     37,    -15,   -161,    -23,   4221,    174,     47,
      -264,   -182,   -182,    686,   -248,     89,    -41,     80,
     -2687,   -194,   2552,    407,  -1106,   -970,   -181,   -228,
      4395,    118,   1027,   -255,    136,    100,    -43,    246,
        80,     15,     34,     82,    -54,   -367,    698,    232,
      -177,     45,    -67,     49,    138,   -158,    168,    202,
        43,    -70,   -101,     20,    -97,  -3465,   -342,   -255,
       127,     25,    -52,     -5,      7,     76,     -3,     19,
       -19,     42,     10,    -63,     16,    121,    732,  -3127,
       -43,    116,     36,  -2519,     23,     18,    181,     41,
       -32,    -11,     22,     51,     35,     16,    -34,    -62,
      1744,     94,    173,  -1243,   -262,     11,   3218,    239,
       149,   -219,     29,    118,   -382,   -289,    -42,    161,
        17,     -1,   2551,    -83,     90,   -128,    138,   3238,
        43,    -29,   -112,    110,   -268,    293,     23,   -117,
       -64,   -137,     79,    -70, -10747,    -66,     73,     90,
        35,     90,    -29,    -78,   -111,     75,     48,      8,
      -169,   2944,     16,     89,    186,    -34,     82,    241,
       -46,    257,   -243,     93,   2966,    178,   -256,    -18,
       -33,    103,   -320,   -271,   3088,   2893,   -250,    102,
       696,    124,   -211,     18,   -143,     97,    216,    -99,
       195,     40,    -35,    144,     26,    135,   -152,   -215,
       120,     25,   -254,  -1875,    657,    197,  -3527,   -332,
       310,    -11,   1958,    102,    -12,    -45,      2,   -127,
         4,      1,    -19,     47,    -20,    -52,     97,    -30,
     -7738,     51,     26,      5,    -21,     18,     15,     15,
        66,     30,     -8,     -7,    -31,     -1,    -33,     38,
       164,     90,   6798,    -33,    -90,    -17,     -5,     14,
       -42,     21,    -20,    -41,     48,     -6,    -36,      6,
      -207,  -4363,   5075,     31,      6,    100,     65,     86,
        19,   -158,     28,   -134,    -91,    -68,      9,    -26,
       -37,   2588,    307,   3467,   -451,    101,   -441,    323,
        62,    188,   -132,   -294,     98,    -22,    152,    -46,
        65,    -39,    -37,    -82,     -9,     18,     43,     17,
         8,     56,     97, -11564,     21,     15,     75,     85,
       155,     15,     32,      0,     20,    -45,   7412,     48,
         3,     38,     72,     30,     23,     42,    -20,   -110,
      -454,   -233,    653,   -325,   -276,    504,   -481,    583,
       270,   -649,    481,  -3166,   1619,    164,    -90,    150,
        32,    -96,    -47,     49,    -13,    115,   -183,     75,
        62,  -9026,     12,    -93,   -715,      6,    137,   -338,
       810,    -39,   -277,   -108,    -20,    315,    572,     -3,
     -4570,   1053,   -132,     13,    388,   -223,   -355,     31,
       -47,     61,   -113,      5,    -38,     43,    -47,    -80,
      2550,     27,    247,    277,    -86,    336,    139,    146,
      -111,    -73,    187,   -312,     68,   -276,     72,    638,
        73,    792,   -170,   1383,    421,   -703,  -3813,    112,
       391,   -195,   -162,    -28,    -25,    317,    228,    -83,
      4611,    654,    353,   -380,   -283,   -627,   -301,    161,
      -156,    -81,      5,    -15,    -13,    -17,     53,    -50,
        36,    -66,  -7921,     -2,    -54,    -41,    -26,     47,
        -3,     22,     -6,     11,     63,      2,     42,     71,
       -50,    -87,    -39,      2,    -56,     -2,  11165,     44,
      -119,    -74,    131,    134,      5,    115,    -39,    144,
       -23,      0,    186,   4648,    351,     36,    -70,    -71,
      1706,   2131,   -228,     42,      6,      8,      4,    -43,
       -12,    -40,    -44,     -7,    -14,     11,     83,    -93,
      -144,    186,    -46,     -9,     13,    -87,   -120,     70,
      -209,    115,  -3513,    139,    -46,    133,     96,     25,
       215,    -35,   -437,    126,    403,   -115,    145,    203,
       -69,   -334,     37,    934,   -481,   3163,  -2528,    -49,
        57,    100,     76,     82,    251,    288,   -114,     46,
      -201,   -161,   -161,   -716,  -4080,    378,   -830,   -254,
        12,  -2110,   -300,     78,    288,     48,    -90,    -99,
       -31,   -110,    201,     66,    327,    119,   -180,    148,
       633,     71,  -4100,     33,     57,     -9,    -48,    151,
       -20,     72,     71,    -11,     39,    -67,    176,     27,
       143,    198,    383,    155,   3182,   -128,   -152,  -3209,
      -172,   -262,    -13,    129,   -167,   -128,     55,     46,
       -37,     70,    107,      7,    -23,  -2082,    241,    236,
       -47,    -85,    105,    -47,   -202,    208,    201,     30,
      -106,    -14,    -38,     14,    -45,     24,    -24,  12083,
        22,    151,    -58,     -9,     59,    170,    113,    -82,
       369,   -155,     53,     97,   -185,    -57,    203,    311,
       236,   4789,    -24,   -591,  -1463,    118,     94,   -274,
      3188,   -145,   -406,    183,      0,    -54,     17,    -22,
        37,    -55,    -34,     63,   -340,    175,   -300,    106,
      -190,    -38,     67,     -2,     19,    -46,    -42,     11,
       -33,    -33,    -28,    -10,    -27,  -9235,     29,     62,
      -927,   1285,     49,     72,     65,     89,     57,    -44,
        -9,    -15,     85,     -1,     74,     81,   -123,    160,
        69,  -2803,    -22,     47,   -467,    -74,    748,    168,
        -9,    235,  -3155,   -154,     48,    483,   -341,     74,
      2403,     97,     93,   -106,    219,    136,   -191,    -50,
         7,     71,   -103,    261,   3283,   -124,   -624,  -2570,
        73,    -31,     10,    -73,     30,    -15,  -2256,     -2,
       -73,     55,     73,     14,    -74,    -81,     38,    352,
       108,    -18,     25,     61,     54,      1,     -5,    109,
        25,  -2676,    -25,    -52,   -316,      2,     36,    -36,
      -355,     40,    -19,    120,     27,     -4,    -51,     -8,
        42,    -10,    -28,    -90,   -143,     29,    -10,  -8442,
       -22,   -566,     59,    -39,     -1,     27,     29,    -20,
         6,     19,      0,    -36,     38,     68,    -43,     35,
        22,    -47,   -146,   3567,     13,     12,   3230,    -18,
       -32,     75,   -112,     -8,   -157,    -23,    101,    165,
       198,     93,    383,   1236,   1077,  -3592,  -1401,   1135,
       844,   -266,    -74,    -70,   -280,    -98,     67,   -109,
        38,  -5109,    -66,    -57,     89,    -21,      6,     19,
       -21,     70,     60,     76,     35,     18,     44,     51,
        45,     40,     54,  -6685,    -67,      9,    113,    -29,
       -10,    -96,     80,     98,    103,    -40,     -8,    -20,
      -131,     15,    262,     47,   -253,   -116,    -12,  -4807,
         2,    -81,     76,    -46,     37,    353,   -130,   -191,
      -127,    -10,    -35,     91,   -122,    173,   -165,     -8,
    -15179,     86,   -186,    123,   -295,    -25,     21,     63,
       -93,    730,     20,   -120,  -4624,    340,   -253,   -473,
        44,    -18,    -99,    -37,    -54,   -317,     65,    -52,
      2167,     68,   -245,    224,    117,   -180,  -4695,   -276,
       118,    142,   -101,    202,   -301,    -33,   -129,   -303,
       -90,    -75,     50,     98,    -56,    -68,   -153,    -38,
       168,   -278,    -22,    -64,   9757,    -91,    -23,   1284,
        53,     56,    -11,    -46,  -1645,     11,     15,     12,
         8,    -40,     -2,     84,    -56,     17,     -7,    -30,
     -4010,  -3557,   -252,     56,    -79,    -87,     -7,      8,
        79,     16,     21,     51,    -63,    -22,    118,    228,
     -1525,    -78,    -22,     -2,     16,    -49,     17,    -37,
        -3,    -14,     10,     31,     17,   -111,     32,   -144,
     -3612,   3473,     79,     23,    -89,     74,     33,    -29,
        11,    -42,    -42,   -129,    -41,    155,     52,     31,
      -162,  12609,    147,     17,     68,      2,     15,    -12,
       -39,     50,   -108,    -66,    121,     69,    -27,     94,
};

static const int16_t cb1616s0[] = {
      1213,  -1302,  -1130,     90,    -69,     22,   -360,    360,
       -55,    453,   -705,   4416,    227,    173,     -8,    149,
       210,   -118,     51,  -3759,    949,   2418,   -238,    201,
      -597,     94,   -253,     24,    225,   -497,    -59,    273,
       576,    651,    608,   -483,    335,   -125,    256,  -2873,
       318,   -146,   -650,   -306,  -2021,   1044,     41,   -455,
     -1120,    832,    978,    212,   -463,   -209,     12,   -275,
       -20,    118,     31,    639,   5933,   -180,   -121,   -285,
        65,    212,    439,   -135,    538,    116,   -302,   -245,
      2534,   -623,   1549,    -34,    727,  -1750,   1477,     79,
      1669,   -828,    618,   -856,    773,   -286,    343,    -94,
       107,   -320,  -3144,   -380,    694,    -80,    843,    103,
      -700,   -269,    452,  -6847,    -12,   -527,     97,    -21,
       -76,   -246,      2,   -104,    -68,     98,    312,    117,
      -342,   1025,    207,    838,    -71,   2463,     60,  -1294,
      1549,  -1310,   -202,  -1585,    682,    327,    608,    649,
       664,   -801,    588,    137,   -468,    286,    234,  -6726,
      -107,    177,   -147,    278,    118,    -81,   -242,     97,
      -235,   1599,   -877,   1985,    448,   -319,   -745,   -504,
      -433,  -1859,    -35,    286,   -665,  -1449,   -124,    -97,
       930,   2622,    682,    698,   1898,   1120,   -323,   -142,
      -679,    294,   -162,   -539,  -1649,    152,     23,   -414,
      1493,    602,    913,   1428,  -3212,   -103,   -330,    557,
       463,     92,    251,    339,     16,    936,   -116,    229,
      -827,   -504,   2015,   1553,   -503,   -350,    214,    386,
       295,   2697,    429,     72,   -705,   -120,    427,   -139,
      -334,   -318,  -6613,   -468,     10,   -122,     59,   -322,
      -165,   -144,     45,   -427,    -12,    -79,   -202,   -266,
       981,   -273,    240,   -454,    -30,   -119,    340,     92,
      -251,    247,    189,     71,    243,  -5648,   -601,   -434,
      -674,    867,   -713,   -428,   -101,   -231,   1144,    -89,
       -10,     57,    302,    154,    362,   -425,   2014,   2577,
     -8659,    389,    -90,     76,     15,    147,     30,   -202,
       -99,   -255,   -242,   -165,    257,     97,     41,    -72,
       263,    613,    272,    400,   5020,   -199,   -196,   -177,
      -276,    -25,     28,     97,   -155,    119,    763,     33,
     -3540,  -1447,     16,   -169,    148,   -143,    707,  -2483,
       178,     83,    -83,    154,    -75,    -15,    153,    283,
      -323,   -139,  -1390,     69,    725,  -1744,    331,  -3665,
       415,   -514,   -366,    124,    660,   -295,    180,     77,
      -228,    192,    684,   -193,      4,   4409,    298,    427,
       591,    290,   -159,   -166,   -372,   -514,  -1840,   -562,
       795,  -1765,   -349,   1178,  -1619,   -391,    615,   -784,
      1353,    746,   -871,   -994,    182,   -464,   -498,    -96,
      -306,   -729,    743,    270,    223,   -731,     73,   2692,
      1110,  -2354,   -328,    -21,   -172,   -339,   -528,     93,
      -338,    548,   1498,    309,   -134,    160,   -247,   -619,
      1127,    783,  -1557,    400,   1035,   -445,   -155,  -2443,
       590,   -790,    137,    388,   1188,    844,   -395,   1005,
        55,   1141,   -122,  -3174,    138,    155,   -506,    306,
     -3255,   2432,   -116,  -1289,   -744,   -350,      3,    192,
      -156,     95,   -552,    -57,    329,   -405,    737,    138,
      -835,   4096,  -1037,    797,   -417,   -418,   -507,   -694,
      -256,     78,    -94,    -63,    -93,    754,   -555,    -90,
     -1518,   -878,    167,   -392,   -100,    -78,    -80,    -45,
      4774,    114,   -284,   -560,    -21,    275,     15,   -195,
     -1692,   -711,  -1057,    167,  -1555,   -690,   -263,   -267,
       310,   -229,    -14,   -880,    426,  -2826,    320,    -49,
     -1223,   -725,   3538,   -270,   -606,  -1812,    481,   -703,
       176,   -284,   -173,    271,    847,    711,    239,    314,
      1233,    -61,    477,    429,   -691,   -156,   6712,    850,
       365,    229,   -197,   -355,    298,    250,    207,   -437,
     -1647,   -261,    165,    114,    165,   1165,    -58,   -597,
     -3290,   -517,   -478,   -842,   -187,   -448,   -302,   -204,
       410,    544,    669,  -2012,    476,    434,    214,    698,
       302,    100,     61,     63,   -386,    918,   4434,   -230,
       157,  -1019,  -1487,   2239,   -774,   -234,   -378,    772,
      -190,    270,    -61,    -19,    322,    488,    937,  -3582,
      -415,   2091,   1862,     81,   -134,   1285,  -2732,    221,
      -235,    388,   -216,    -63,    664,   -105,    -37,    165,
       899,   -373,    284,   -375,    286,   -263,   -295,    276,
      -246,    188,   5285,   -303,    290,    -60,     -1,     95,
      -703,   -288,     74,   -717,   -127,    -53,   -422,   -452,
       166,    -54,    -15,    268,    238,    -31,   -279,  -5872,
       863,   -907,   -101,    885,    552,    442,  -2336,  -2142,
      -804,   -147,   -791,   1000,     96,    250,   -306,    134,
       743,  -1648,   -867,    673,   1594,   3725,    527,   -676,
      -661,    238,    262,    560,    277,    -58,    444,    166,
     -1039,   -702,    558,   -970,  -1763,  -1198,    580,    378,
      -421,   -972,    630,   -279,  -2456,  -1222,   -232,   -749,
     -3325,    174,    789,    729,   -487,    583,   -157,   1503,
      -801,    -38,    -11,    556,     81,   1508,   -140,     74,
      1373,    912,   1471,      4,  -1080,   -105,    -58,   -104,
       -54,   -544,  -2392,   1550,    318,   -506,    -11,   -180,
     -1891,   -230,   -259,  -1182,   -154,    524,   -568,   1972,
       546,    469,   -720,   1089,  -1530,   -680,   1349,    429,
        82,  -1524,   1894,    -90,    188,   -145,     15,  -1113,
        15,     53,    282,   2212,   -736,   -941,  -1148,   -344,
      1473,    344,    392,   -333,   -556,   -480,  -3833,     35,
      -160,   -525,    151,   -534,   -782,     38,    520,   -416,
      -384,   7582,   -158,    -29,     74,    -57,    -23,     73,
      -393,   -245,    -12,   -260,   -154,   -319,    357,    247,
      -306,    351,    273,    755,    227,     89,    283,   -152,
        17,   5129,    191,   -213,   -531,    255,   -468,   -209,
      1128,     72,   -807,    225,   -319,   1638,     42,     20,
       935,    -52,   -326,    541,  -1174,    130,    284,   -112,
       444,   3959,    262,   -631,   -262,    275,   1025,    190,
      1125,   -265,    -95,    265,     35,    270,    -92,    -30,
      -141,    325,   -435,     45,   -659,    149,   3648,    339,
     -1701,  -1338,   -144,   -989,   -604,     84,   -394,    168,
      -302,  -1294,   -433,   -921,   1271,     77,    374,   -604,
      -230,     97,    206,   -138,   2909,    478,    707,      0,
      1242,   -340,  -1659,    349,   2751,  -1175,   -146,   1038,
        65,   -775,   -423,     14,     22,     41,   -905,    287,
       280,   -933,    195,  -1817,    540,  -2374,   -661,  -1102,
       879,   1232,     29,  -1683,    286,   -136,    658,   -395,
     -1782,  -2823,   -624,   -223,   -299,   2859,   -103,    -45,
       544,     82,    -21,   -263,   -666,   -362,   -732,    249,
      1087,   -242,     30,    663,   -386,   -350,   1240,   -492,
      -868,     69,    -41,     35,     30,  -1791,   3870,   -455,
      1355,   1098,   2933,    347,    361,     79,   2855,    -26,
       -66,   -598,    -43,     21,   -386,   -802,    -81,   -436,
       846,   -673,    377,   -326,  -1217,   1465,   -480,   -205,
     -2168,  -1689,    690,    355,   1192,    734,   -113,     39,
      -486,   -644,    438,   1096,   -723,   -524,  -1634,   -621,
      -394,    226,    167,   -625,   -709,    854,   3005,   -910,
        13,   -793,  -1517,  -1254,     18,   -440,   -836,    651,
       -31,    229,  -1081,   -126,   -191,  -3612,    487,    451,
      -292,    943,  -2018,   -618,   -259,   -649,   -723,   -447,
      -238,   1096,  -2228,    675,    563,   -316,  -1248,     32,
       -28,    293,  -1817,    226,    267,   1291,    624,  -2279,
       143,    650,      5,   -563,   -504,  -2124,    -94,  -1613,
     -3050,    708,  -3458,    442,     30,     65,    -80,     89,
       204,   -245,     94,     28,     -2,   -231,    623,   -189,
      -405,  -2147,   1147,   3124,    806,   1048,   1145,    653,
        47,     86,     -4,     46,    437,    229,   -190,    310,
      1995,    -48,  -1015,  -1806,   -266,   -941,    361,    179,
       172,    397,    182,    323,   -516,   3435,      7,     -5,
};

static const int16_t cb1616s1[] = {
     -2521,   -518,   1830,    985,   -500,    109,   -807,   -197,
       543,  -1036,    104,   1989,    428,    740,   1110,   -366,
      1482,    899,  -1828,    159,  -3015,   -311,   -792,    -42,
         3,   -412,   -157,    -13,    863,   -248,    261,   -187,
      -409,    156,    772,    271,    318,   -262,     78,   -571,
        28,    370,    119,    302,  -4794,    106,   -123,   -153,
      1857,   -702,   1090,   -319,    415,   -327,   2124,   -170,
      -411,    174,     62,     -7,    921,   -128,    735,   -127,
       972,   1678,    166,  -1471,   -208,   -224,    871,   -900,
      -223,   -817,    288,   -472,     10,     31,   -401,  -3201,
     -1290,     -3,   -301,    183,    730,    473,    438,    -81,
       882,    -64,   2898,   -242,    408,   -211,   -333,   -254,
      -820,    612,  -1128,    -60,    -73,  -2516,     45,    637,
      -130,    459,   -312,   -223,   -629,   1490,   1792,   -199,
       -21,   -545,   1772,  -1084,   -173,    381,    380,   1289,
      -117,    483,    138,  -1200,   -519,    598,  -3453,    349,
     -3102,   1260,   -170,    238,   -684,     48,   -483,   -883,
      -879,    139,    298,   -110,   -203,   -955,    195,     57,
      -550,   1945,   -711,   -688,  -1470,   1527,     58,    317,
       656,    310,     57,    162,   2006,   1387,    845,   -127,
      -398,    318,   2520,   2002,   -906,   -323,   -194,    907,
       588,   -228,   -357,   -316,    557,   -596,  -1559,     -3,
      1614,   1317,  -1701,    936,    -89,  -2270,   1327,   1046,
       400,   -233,     18,   -730,    -23,   -181,   -593,     74,
      -570,   -969,    432,   -261,   -833,    -90,  -4675,    786,
      -566,   -183,   -859,   -554,    346,   -493,   -201,   -220,
       241,   -919,  -1896,    265,   -802,   1380,   -718,  -1103,
      -574,    307,    138,  -1260,    175,   2540,    -82,     58,
      1046,  -1381,   2486,    582,    455,    485,   -824,   -150,
        57,    -45,   -155,   -490,  -1108,  -2191,    833,    423,
     -2011,    267,    779,    140,    -28,     57,     94,      6,
      -301,      5,   -833,  -1226,   -193,   1110,    -63,     79,
      -492,  -1465,  -2733,    444,     56,  -1116,   -601,     20,
      -618,  -1315,   -695,   1146,    -66,    336,   -166,    158,
       530,    -53,   -371,   -594,   -685,    114,   -146,    373,
       174,     -1,     47,    119,   -124,   -121,  -6697,    -94,
     -3544,   1506,   1221,   -101,   2160,    558,   -254,   -728,
       511,    378,   -383,     12,    626,    172,    183,    354,
        49,   1669,   1188,   3810,    409,    152,    694,  -2520,
       342,     61,    -85,    -38,   -170,      5,    305,    154,
      -348,    699,    332,   2542,    673,  -1130,  -2601,    554,
      1483,    466,    271,    490,   -644,    822,    -96,    477,
       131,  -2051,   -111,     43,    -31,    -62,   -767,  -3257,
       663,    488,   1823,    522,   -525,   -249,    481,     -7,
     -1298,   -941,   -335,   -566,    305,    534,   -735,    207,
       709,  -3170,     19,    -20,  -1888,    271,  -1697,    117,
      1837,   2690,    305,   -483,   -463,    407,   -706,    467,
       518,   1806,    244,    -80,   -453,   -505,    882,    843,
      1328,   -280,    175,    319,   -842,    192,   -680,   -469,
      5440,   -205,   -187,     53,    332,    204,   -184,     96,
      1026,   -525,     20,    975,    125,  -1562,  -1873,   -757,
      -137,    133,    -10,   -340,   -783,  -1484,  -2206,   1238,
     -5212,   -466,    129,   -224,     17,    497,    -41,    846,
        88,    -41,    285,    284,   -155,     21,   -225,    150,
       223,   -807,   -444,  -1141,   -908,    292,   -326,    559,
      -446,   -283,    -41,   -277,  -3479,   -667,    532,     83,
       257,    383,  -2986,   1685,    697,    777,   1551,   -142,
      1786,    579,   -531,    787,    712,   -984,    603,   -174,
      -459,   1303,   -943,    741,   1103,    -73,    600,   -403,
       -42,   -169,    -90,    220,    208,    105,  -4083,  -1069,
       981,   -926,    124,    273,   -145,   -133,    307,   4720,
       209,    324,    -79,     12,    -41,   -220,    211,   -184,
       435,    307,  -1544,     83,   1565,   -445,   -217,   -648,
      -379,  -1270,  -1590,  -2337,   -860,    348,    648,   -157,
      -785,   3318,   -123,   -138,   -412,   -876,    358,   -173,
      -280,    -81,   -149,   -167,   -160,  -2113,     20,    -40,
      1022,    432,   -721,     55,   -651,     17,  -1135,   -380,
      -542,  -1128,   2919,   -475,   -143,    -53,    176,   -152,
         7,    -29,   -172,    174,    195,  -8005,    277,    105,
        35,    115,   -314,    137,   -253,     75,   -278,     90,
     -1508,     79,   -153,   -560,   1027,   -349,   -292,   -466,
     -1101,   -324,    -84,   4251,    822,   -420,     55,     43,
      1886,    281,    964,   2408,    425,   1187,    -27,    -84,
     -1277,     63,   -978,   -143,    506,    727,   -155,   -384,
      3434,    592,   -262,   -438,    -30,   2849,    -69,    -58,
      -181,    -87,     20,    299,    412,   -263,    702,    131,
      -271,    -10,    736,    121,  -6299,   -132,   -116,     26,
      -253,   -586,     32,   -145,   -251,    -12,    471,    135,
       585,    604,     29,    873,    363,     -2,  -1595,     41,
     -1147,   -142,    665,  -2752,   1302,   -358,   -134,     29,
      -691,    -12,   -702,   -459,    100,    278,      9,     54,
        66,   -458,     53,    213,    193,     14,   -400,   4870,
      -950,   -209,     50,    470,    449,      3,   -118,   2287,
      -469,    -58,    126,   1011,   -826,    386,  -1019,  -2390,
      -586,  -1401,    137,    760,    141,    -89,    117,   -252,
      3106,   -936,   -198,    390,    463,   -245,   -509,   -123,
      3057,   1200,   3451,    282,   -332,   -585,   -662,   -955,
       165,   -276,     73,    373,    202,    506,    356,    125,
       141,   -613,   -670,    446,   2031,   1521,   -446,   1339,
       198,   -112,    214,     70,    265,  -1310,   2492,   -133,
     -1880,   -347,   -961,    312,  -3714,   -475,    102,    391,
        64,   1091,   -686,   -101,    144,    447,    173,     66,
      -374,    342,     69,  -3379,  -1331,   1160,   -889,   -858,
       982,  -1613,   -223,     57,    186,    428,    226,   -477,
       449,  -1052,   -661,   -382,    459,    277,   -277,   -250,
        12,   4077,   -260,   -161,   -163,     38,    159,    243,
       131,    457,  -2253,   -301,  -1626,     37,    806,    104,
       191,   1899,    346,    398,  -1108,   -623,   -391,   1092,
      1252,   1126,     81,   -116,   1192,    674,  -1321,    -32,
      1739,   -708,   -230,   -844,   -507,    415,    261,    211,
      -619,   -191,   5460,      8,    139,    197,    392,   -556,
      -215,     66,     64,   -808,      0,   -136,    151,    156,
       260,     94,    418,  -1446,   1815,   -540,   -793,    451,
      -477,   1788,   -124,    330,   1638,    342,   -503,   -384,
     -1201,   -762,    929,  -2886,    888,    -63,    318,    598,
        42,  -1226,   -400,   -462,   -136,    321,   1872,    376,
      1260,    142,    -79,   4377,      9,    294,    -71,   -190,
       -21,  -2612,   -240,     26,    -18,   -227,    864,     79,
      2588,   -882,     87,  -2976,      9,    480,  -1573,   -170,
      -429,    201,   -124,    171,    632,    -60,   -447,     64,
       -37,  -1182,    -86,   -105,   2901,  -3557,   -134,    486,
       141,   -259,    239,    465,    467,   1009,   -409,     34,
       254,   2469,   1002,    834,    557,   -845,    149,   -747,
      -504,    494,   1382,   1067,    353,    191,  -1105,   1705,
      -586,   1472,   -444,  -1303,    198,    602,    471,    468,
      4855,    127,   -141,    487,   -454,   -138,   -392,   -118,
      -491,   -948,     58,   -290,     -7,   -662,    229,   -268,
        -2,   -537,   -620,  -4770,   1152,   -173,    166,    -69,
        32,  -2555,    433,   -583,  -2219,   1107,   1082,   -942,
      -173,    399,   -601,    250,    423,    125,   -448,    352,
      -571,   -406,      0,   4735,   -264,   -174,  -1020,   1105,
     -1149,   -171,   -252,   -130,   -202,    -74,    601,    601,
       570,  -2742,  -1403,   3129,   -349,    194,    309,    130,
       261,     93,    154,   -117,   -418,   -657,    270,   -160,
      1660,   -818,    613,  -1458,   -653,  -3763,   -232,     90,
      -265,    -99,    -28,    -13,   -281,   -553,     11,   -142,
     -1764,  -4548,    936,    -21,   -683,    -88,   -806,   -187,
        28,     78,    -70,    -99,     -2,   -493,    -16,     48,
};

static const int16_t cb1616m0[] = {
     -3821,  -3397,    203,    -25,    -22,     68,    189,    -13,
      -286,     94,     18,    288,     29,     -5,      3,   -414,
      1483,   -172,  -1275,   -180,  -3792,    360,    145,   -143,
       444,   -139,   -198,     70,    -17,   -353,   -121,     -6,
        76,    -50,   2987,    173,  -3070,   -229,    -16,    192,
       134,    -55,    -86,   -200,    128,  -2052,    -59,    -11,
        -4,    309,    179,    494,   -138,   -363,   -336,    119,
      -127,   2497,   -169,   -316,    -87,   -538,     42,   -534,
       315,   2364,     61,    269,    -87,    -94,     82,  -2069,
        18,   1238,     -7,     79,     -9,     41,     70,     50,
       209,   -158,   -136,     28,   -275,     62,    296,     77,
      6269,   -184,     73,    -19,    -25,    -57,    134,    -52,
      8569,   -176,     -8,     17,     15,     79,     36,   -137,
        12,     44,   -270,   2335,    111,    517,    -83,    207,
      -276,   2577,   -198,     83,    376,    -75,   -273,     62,
       109,      4,    -48,    122,    -41,     99,    -87,     14,
     -7696,   -118,    -66,    171,     96,    -31,    123,   -217,
      -676,   -439,    407,     97,   -281,   1873,    626,   -148,
      -548,   1634,    704,     97,  -2076,   -336,    632,   -371,
       113,    544,    -88,    184,  -2200,   -420,   -592,   -168,
       759,    291,   2215,    704,   -140,   -145,  -4088,    295,
       186,   -270,    283,    294,    -42,     76,     69,     41,
      -140,   1635,   -200,   -682,    302,   -192,    902,   -540,
      -843,   -494,   -529,    102,   -759,   -165,   3160,   -180,
     -1450,   -424,    -16,      6,   -548,    296,  -3056,    219,
     -1883,   -109,   -566,   -431,     95,   -422,   -532,    -26,
       120,    -46,     23,    174,    175,   -369,    110,     -2,
        25,    132,     -1,  -3338,    -67,   2140,    -25,    566,
      -129,     35,   1187,    337,   1999,   2712,    -71,     45,
      -177,     94,   -321,   -197,   -573,     98,    225,     46,
        53,     78,    -40,     82,     23,   2718,   2534,     89,
       -65,     77,    206,    343,    527,    102,   -191,     94,
       463,    111,  -4529,     97,    876,   -205,   -944,    181,
      -132,    467,    366,     85,   -302,   -100,    -33,    -76,
     -3087,  -2546,    215,    277,    -52,    352,    137,    -45,
       162,    590,    406,    382,     85,  -2824,    141,    219,
     -3790,     40,    126,     32,     30,    100,    121,   -210,
       196,   -268,    178,    102,   1229,    -80,   -750,    -11,
       -57,     84,    238,   3571,    274,   -254,     55,  -1616,
      -176,   -755,     46,  -1306,   -201,   -228,    101,    197,
       -93,   -156,    319,     82,   -385,    -17,  -4660,    180,
      1278,   -113,   -215,    103,    832,   -233,    412,    249,
      -900,   -132,  -3427,     52,    416,    267,    317,   -384,
       130,     78,     91,   -360,     75,    386,   2219,   -360,
     -2975,     17,    286,   -294,   -213,    231,    131,    821,
      -358,    222,   -230,    -44,    -93,  -1151,    294,   -316,
        -8,    129,    231,   -993,    -58,   3319,     48,  -2546,
      -213,    -14,   3208,    162,   -240,   -176,    307,   -165,
       -20,    348,   -113,    -78,    -91,     -8,   -261,   8033,
      -179,     64,     -7,   -113,    -59,    -32,   -170,     52,
        55,    -80,    140,     64,    -39,    915,     28,    416,
        38,  -2328,    206,    115,    366,    -92,    652,    110,
     -2838,    -59,    613,     23,    109,   -151,   -198,    185,
      3033,   -122,   2863,   -273,     86,     41,    114,    -99,
       315,    372,     14,   2191,   -171,    531,    -18,    -34,
      -352,    130,   -360,    117,  -2896,      2,   -564,     51,
       223,     57,   -257,   3161,   3130,   -384,    126,    -40,
      -160,   -232,   -138,     81,    -34,    -96,     82,      9,
        62,   -161,    344,    100,    790,   -243,   -344,   -393,
      -531,    401,     90,    171,    144,   -329,      7,  -4639,
      -135,     -6,    351,    -21,   -195,    224,    -25,   6027,
       224,    -14,    344,    170,   -169,    -97,    252,   -488,
      -379,    -73,    629,     -9,    266,    152,    -64,    330,
        -8,   2080,    -91,  -3315,    229,     25,     45,   -528,
      -123,   2951,     40,    -85,     -4,  -2695,    -38,   -112,
        84,    -30,     79,    762,    151,  -4089,    -95,   -151,
         9,    138,   -206,     -3,  -2114,     99,   -100,    116,
      -403,    -56,     -8,    -36,    115,    -18,   -195,    -38,
      -240,      8,    -32,    122,    125,  -7406,     45,   -210,
       111,   -152,   -152,    -35,    -72,     28,   -154,    303,
     -3147,    459,  -2881,    -14,    -13,    -56,   -126,    -69,
      -213,    -97,    202,    -88,   -277,   -557,    451,   -376,
       -91,    319,    141,   2728,     23,   2506,   -101,    632,
        62,   -314,    159,     44,   1231,    -65,    -37,    192,
      3118,   -186,   -396,   -108,     71,   2111,    586,     95,
        15,    -28,    176,     20,    -67,      3,   -265,    101,
      -182,    -21,   -455,    -15,  -6225,    -45,   -353,   -384,
       -22,    113,    -40,    -47,     57,    -73,   -503,    134,
       736,    -70,   -125,     -5,   -250,     62,    165,    182,
       185,   -132,    426,   -276,    100,   -497,    -23,     81,
      -112,  -3528,  -1997,   -234,   -154,    -91,   -125,    -26,
       179,   -611,    655,    767,  -1064,    130,   -264,    107,
      2811,  -1391,    298,    -20,     37,    -74,    -12,   -157,
      -270,   -106,   2559,    -89,  -3107,     55,    187,   -265,
       195,    140,      1,   -484,    713,    171,  -1123,   -226,
      3666,   -367,   -516,   -249,     38,    195,    236,   -378,
      -383,   -205,    -72,     -7,     15,  -9329,     -6,    -26,
        56,    141,     48,      6,   -141,    -95,    -69,    -40,
       -99,    -80,     73,   -253,    456,   -174,     51,   -250,
       -48,  -2115,    -63,  -2555,    -25,  -2058,    -58,     66,
       176,     14, -10053,    -23,    -39,    -37,    -15,     38,
        82,     11,     97,    169,      5,    -67,     57,     61,
     -2248,    108,    -19,    256,   -169,   -122,   -336,   -431,
       -77,   -250,   -156,   -745,    184,    684,  10559,   -199,
       -34,    -37,     96,    -82,    -17,     60,     65,     21,
       -67,   -337,     62,     35,     74,   -214,     38,     47,
      -129,   6139,   -139,    -57,   -154,    261,      7,   -127,
       109,     40,    179,    -99,    198,    -51,     48,    -36,
     -2377,   -194,   -334,  -2826,    103,   -220,    -57,     41,
       979,   -895,     68,   -217,  -1712,   -430,    -98,     91,
      -107,  -1755,   2615,     84,   -500,    231,    480,    -31,
       146,   -157,   -120,    152,   2342,    -36,  -1969,     57,
      -109,    476,   -243,    261,    -58,   1998,      4,   1388,
       -98,     45,   -140,    400,    -76,   -321,    -22,     -9,
       210,    517,      5,  -4708,     66,   -330,   -405,    -19,
      2158,    -65,  -2163,    244,    -16,   -192,    494,   -381,
      -194,    413,     89,    220,    455,    -54,      4,    206,
       221,  -4998,     63,   -365,    354,    364,    677,    207,
       -66,    -27,   -477,   -182,    841,     85,    -40,    166,
      -185,    321,   -293,   -181,   -429,   -231,   1401,   -122,
       938,     67,   -185,     51,   3188,   -802,    421,  -3230,
      1432,   -432,   -658,   -587,   -843,    421,    177,    446,
       510,   -140,    -90,   -127,    -78,      2,   1089,   -185,
       301,   -393,   4100,   -152,    265,    224,     25,     95,
       534,    280,   -254,    -45,     -5,   -207,     49,   -126,
      8922,     43,      9,     21,     28,     21,    -42,    -84,
        38,     90,  -2014,     61,   -149,    188,  -3350,   -120,
       -43,     10,     14,    155,   -225,   -351,   -114,     28,
       -23,  -4400,    367,    -51,     76,    -89,   -113,    122,
      2007,     25,   -348,   -227,   -370,    -61,    135,    -79,
};

static const int16_t cb1616m1[] = {
      -321,     -7,  -6725,    -36,     77,    -20,   -101,   -529,
      -166,     97,    -76,   -232,    -70,     16,     13,     93,
       -50,    222,   -258,  -4424,   -125,    125,     83,    313,
      -246,   -325,    108,   -331,    484,   -188,    192,   -964,
      2603,    -38,  -2236,     58,    337,   -254,    -17,    -90,
       -88,     40,   -141,  -1293,    -56,   -811,    247,    -78,
       -34,    144,    112,     43,    142,   -137,   -147,     56,
      -406,     12,    210,    132,   3707,    109,   -896,   -268,
     -2295,   -509,     32,   -219,    113,   -104,    141,    273,
        18,   -358,     16,  -3354,   3474,   -167,    220,     10,
       104,   -175,     -8,    -71,    -77,    -48,    277,     82,
        86,     35,   -712,    -32,     36,    -65,    213,    121,
       -76,   -742,    291,  -4587,   -169,   -122,    -77,   -285,
        54,   -120,     89,     71,     12,   -133,     54,   -215,
     -1906,   -115,   3220,   -194,   -391,     87,    415,   -212,
      -210,   -138,    182,    590,    713,    944,    320,    142,
     -1970,    197,    -79,   -548,    458,   2836,     33,    -62,
      -183,   -149,   -640,    147,   -427,   -113,   -178,  -1631,
      -108,   2666,    -58,   2210,   -251,    288,     16,    382,
      2123,    636,     -4,   1118,    232,    335,    -33,   -114,
        24,    -68,   1309,    -38,   2080,    534,    288,   -162,
      -630,   -360,   -643,     10,     62,  -2229,    263,     19,
       310,    -44,    419,   2846,  -2579,   -159,   -246,    685,
       -67,    394,    314,   -356,   -158,     19,     90,    116,
     -2261,    163,    664,    163,   -191,    -49,    -18,   -308,
       -15,   2508,   -370,    693,    -62,    818,   -307,   -658,
       133,   1858,  -4900,     53,  -2485,    -48,     -9,    126,
       159,      6,    -71,    291,    102,   -367,    -62,     27,
        88,     -6,    204,    -65,   -725,     31,   -159,     -1,
        -5,     45,   -133,   -146,    261,  -4481,    -19,    694,
      -261,   -478,   -177,     88,    214,   -836,    -14,   -762,
      -111,    501,      0,    254,   1971,  -1024,   2678,   -141,
     -6064,     76,    430,    160,   -195,   -582,    280,    580,
       183,   -315,    -13,    665,    -53,    315,   -199,    438,
       220,   3267,    194,      2,   2808,    -88,     42,    150,
      -179,    237,   -155,    143,     46,     99,     27,     30,
     -6137,    -51,    -89,    201,    145,   -179,     13,   -358,
        55,     71,     -3,     28,     -9,    -16,    125,    160,
       159,    -21,  -5407,   -485,     -4,    -88,    -89,     44,
         3,    166,     22,   -413,    993,     80,    485,   -107,
       446,   -943,   1025,    261,     -3,   2991,    547,   -268,
      -109,    536,    -10,    187,     17,    388,   -120,    -71,
      -343,   -416,    162,     69,     -9,     46,   -477,     83,
      6134,    146,   -236,   -125,    -94,    -55,   -274,   -231,
      1120,    171,   -139,  -2714,     80,   -111,     20,   2475,
      -135,  -1710,    317,   -762,    155,   1222,     68,   1192,
       -15,   1825,    -36,    -45,   -120,   -484,   -131,   -162,
      -128,    163,   -407,     72,   -222,    -46,   -222,  -5319,
       278,   -373,   -436,    284,    138,   -243,   -104,     28,
       -77,   3022,     93,    -15,   -581,   -498,    292,   -165,
     -1740,    121,    195,  -1368,   -134,    -68,    -20,    -75,
       -10,    113,    128,   -381,   -507,   -237,   -709,     13,
       -22,    155,  -5065,    -95,    246,   -226,    193,    687,
      1839,    246,   -232,   -359,    475,    106,    297,    205,
     -2702,   -378,   -219,    -20,    140,  -3198,    192,  -3077,
      -135,    -38,    -23,    213,    -72,    255,    -90,   -130,
      -150,     62,   -484,    -94,  -2625,    -89,    344,   -129,
      2655,    369,    -35,     17,   -697,    251,   -343,     68,
        53,    176,   3104,    237,    -75,  -3020,    178,     45,
       -86,     45,   -115,    183,     49,     26,    140,     77,
        40,  -2315,    249,   1791,     48,   -755,    -12,    201,
      -455,   -250,    -62,   1729,   -113,   -959,    238,   -114,
       289,   -135,  -2208,   2748,     65,    306,    -83,      3,
      -513,   -481,    -49,   -163,   -568,    -88,    668,    -51,
     -2586,    106,    -22,    584,   -453,   -350,    333,   -177,
      -236,   -657,    536,   -349,    394,    -56,     14,    133,
       -55,    -84,    210,    -19,  -8647,    154,     80,     27,
        -7,    -76,   -117,    100,   -201,      1,    296,   -101,
        -6,   5642,    137,    -59,    -93,     95,   -110,   -280,
       -61,   -300,     25,    887,     43,    -30,   2493,     76,
       -22,   -343,    489,    266,    308,    163,    132,   -349,
      2021,     18,  15536,     61,     11,    -41,    -42,     41,
        -4,   -183,    -40,    -24,     26,    241,   -102,   -115,
      -164,   2044,    -35,   -217,   -226,    734,   -228,  -2546,
       218,      0,    122,   -150,   -528,   -188,  -1273,    155,
       107,    -33,    -37,   -293,      6,    112,   -155,   -228,
       192,  -2378,    153,  -1045,    213,   2975,     39,   -159,
       -10,    -41,     34,   -125,      4,    -30,   3907,    -41,
       848,   -346,    191,   -195,   -292,   -126,   3421,    -24,
      -244,     92,    693,     64,   -193,    192,    121,    -33,
      -141,    523,   -162,   2754,     71,     59,     40,    -63,
      -142,   -100,   -338,    379,   -136,    -64,   -196,     11,
      3198,    162,   2097,   -132,  -2359,   -193,   -398,   -318,
       842,   -635,   -168,    425,   2001,   -136,    290,    206,
       562,    -96,     -8,   -214,    -45,    -11,      4,     52,
       177,   -148,    229,     33,    -48,    -46,   6538,   -106,
       -27,    -22,   6527,     20,   -405,    157,     87,    208,
      -117,     -4,     30,     87,     28,   -356,    -76,   -108,
       -33,   -568,   -270,    177,     49,   -457,  -3210,    119,
       103,    256,   -180,    211,  -1209,   -369,   -256,     37,
       -47,   4976,     84,    207,    225,    224,   -425,    396,
       921,     58,   -150,    104,   1509,     15,    -58,   1724,
        47,    -24,     21,    376,    353,    482,   -236,    634,
       306,   3179,     73,    -33,    -54,   -169,   -214,    146,
      4322,   -216,   -644,    305,    305,   -453,     53,    143,
        -9,  -1472,   -141,   1314,     57,     40,    -55,    -80,
        67,   9264,     57,     86,     22,   -147,      1,     -6,
         0,     39,      7,    114,    -51,   -137,    155,    -15,
      -122,      5,    137,    125,    213,     -6,   7158,     36,
       -52,    -54,    149,    901,    859,    703,    366,    673,
       -13,   1186,    588,   -202,   -451,     18,   -585,   -250,
     -2632,   -134,     61,  -3038,   1022,     78,   -672,   -276,
        96,    838,    533,   -254,   -525,   -106,   -378,   1627,
        12,     31,    317,   -118,     81,    313,   -186,    197,
       452,  -2971,     83,   1326,    419,  -2366,   -328,    -87,
      -103,   -243,   -280,     25,   -240,    590,   -232,    105,
     -2966,  -2391,   -326,    338,     80,   -392,   -243,    271,
        -7,   1127,      1,   1901,  -2279,   -207,     32,    -99,
       560,   -193,    371,    494,    506,    255,    332,  10737,
        48,      8,    -33,    -33,     32,    -33,     45,   -104,
      -259,    -99,    -37,   -134,     72,    -50,    138,    428,
     -2258,     77,    744,      5,     96,   3020,   -269,     49,
       112,   -223,    186,     48,    224,   2571,    340,   -129,
       -39,  -1900,    -45,   1978,   -261,    223,    294,     22,
      -108,    -58,    109,    -31,  -3252,   -138,  -2969,    -19,
      -133,    190,    -36,    132,   -136,     63,   -175,    351,
       -76,    232,  -2708,    -17,    -24,   -130,   -474,     74,
     -2978,     45,   -139,    -23,    227,    -42,   -141,    278,
        81,      8,  -2491,   -446,    315,    -64,   -167,   -643,
      -275,    100,      0,   2484,   -482,   -128,   -144,   -206,
};

static const int16_t cb4432l0[] = {
     -3764,   -227,    184,   -258,  -1713,    122,    410,    -32,
      -244,  -1337,   -328,    -20,   -236,   -359,    -13,    -52,
       -75,   -260,    426,    -96,    -37,    -38,    117,   -938,
       487,     60,    286,    571,    368,   -551,    198,   -102,
        15,    -11,   4535,   -127,   -241,    114,    -77,   -316,
       302,    195,   -149,    -73,    357,   -128,    -23,     34,
       319,    -97,    189,   5918,    -20,   -134,    -47,   -249,
         7,      3,    116,      7,     48,     47,     92,     19,
        14,     31,   -388,   -329,  -1878,   -944,    958,    632,
      1973,    182,   -130,   -193,   2309,   -868,     63,    260,
       -12,    -89,    -88,   -208,    127,   -168,    237,     74,
      1153,    925,   2292,   2992,    -35,    204,    766,   -930,
       -87,    341,   -101,    501,     35,   -182,    112,     91,
       -28,     79,    193,    -73,    -71,     52,     82,   -427,
      -147,    -69,   4722,    468,   -187,     98,   -295,    292,
      -991,     43,     98,    225,   -555,   -595,    -66,   -181,
        91,   -152,     -3,     89,   -219,    356,   -375,   -114,
     -1546,   -620,    648,   1946,     39,   -608,   -942,    103,
       179,    170,  -2350,    157,   1132,   -944,   -283,     64,
      -393,     15,    -90,    761,   -185,    644,   -360,      5,
     -5212,    106,   -136,    -40,   -159,    -40,   -120,    -43,
        -8,   -195,    208,   -179,   -295,    -63,     19,     32,
      -104,    -23,    132,    660,   -460,    237,    523,   -676,
      -378,    -81,   -184,   2718,     64,    531,   2119,  -1564,
       614,    933,      6,     65,    -50,     55,    243,   -539,
      1168,    953,   -283,     45,    476,   -346,   2285,   1892,
       615,   -521,     23,  -2079,     57,    -11,    208,   1029,
       371,     28,    170,    -63,   -167,    184,   -217,     76,
      -320,  -2747,    542,  -2098,   -407,    -10,   -876,  -1477,
      -306,    565,     57,    -49,   -111,    185,   -250,    120,
      -186,    214,   -520,    463,    792,  -2420,   2760,   -383,
      -783,  -1097,   -441,   -535,   1070,     78,     96,    122,
      -193,    516,    114,    100,   -413,    100,    -23,   -153,
      1267,  -4210,   -742,    228,    659,    399,   -169,    412,
       -81,   1056,      4,   -254,    173,    109,   -218,    196,
        64,     26,   -113,    -60,     -8,     15,   5497,    -76,
       169,   -294,   -394,    596,    379,     12,    -64,   -203,
      -138,     41,   -249,    -53,    -44,    -19,     55,    -34,
        99,     36,    -70,      8,     46,   2787,    842,   1917,
      -693,   -424,    151,    464,  -1162,   1027,    148,  -1027,
      -173,    328,     23,    792,   -184,    395,   -684,    229,
      -139,     -7,   2788,    404,     43,  -1508,   -590,      6,
      -184,    904,    475,    -37,    276,   -361,   1924,   -188,
      -113,  -1334,   -176,     11,    -34,    -70,    -68,     95,
      -433,    225,    437,   -451,    471,   -272,   -385,   2793,
     -2685,    544,    881,    409,   -789,    700,     -5,   -144,
        66,    -17,    504,   -397,    264,     74,    -81,  -1803,
       444,   -573,    633,   -391,  -3339,    192,    484,   1126,
      -306,    153,    303,     61,   -253,   -255,    -57,   -277,
       -88,   -100,     32,     79,  -1320,   -857,   3080,   1178,
       323,    353,   -149,   1316,   -399,    236,   -129,    231,
       323,    696,     59,   1217,   -567,   -268,    642,    384,
      -327,    -47,    466,   1530,   1092,  -1176,    612,    257,
      -143,   -270,    487,    -62,    332,   1089,    961,   -706,
       938,     78,     97,  -2805,  -1088,   -871,   -273,     87,
      -345,    148,    113,    167,     97,     31,     68,    -47,
       -53,     53,     29,  -5723,    -53,    -12,    241,     92,
       131,    139,     48,    102,    -26,    -47,    664,   -580,
        -7,   1287,   2531,   1061,   -710,     24,   1389,  -1742,
       254,  -1147,    539,   -150,    -24,    495,   -204,   -171,
       955,    202,   -111,    147,  -1458,  -3973,    421,   -416,
      -544,    392,   1419,   -178,   -168,    -53,     50,   -537,
        -7,   -346,   -289,    -52,    -38,   -259,   -115,   -136,
      -138,    -89,   -205,   -661,  -4429,   -110,    380,   -721,
      -180,    127,  -1371,    -78,    276,    319,    229,   -934,
       267,   -353,     44,     65,    449,    -32,    159,    -11,
       -22,   -571,    100,   -676,   2892,  -2740,    907,    511,
       248,    441,    -62,   -517,   -347,   -235,    319,     -8,
      -140,    309,    258,   -106,    215,      1,  -3252,    426,
       455,  -2213,   1031,    430,    746,    367,    602,    187,
      -147,   -200,     97,    555,   -107,   -249,    -71,    101,
        59,    -94,    -64,    -33,    221,    184,   -791,    671,
      -191,    284,  -1311,    402,    -29,    250,   -190,   -503,
        38,    106,    586,   4767,    526,    147,   -182,    249,
       146,     17,    293,  -1095,   1079,   -161,    141,     -2,
       681,   -275,   -171,  -4504,     61,   -105,   -306,    -66,
       229,     20,   -102,    -93,    334,   -189,      5,     -6,
       417,   2551,    -63,   -852,   1608,   1820,    670,   1592,
       102,    203,    147,   -767,   -147,    310,   -718,    175,
       551,    -98,   -202,    309,     70,     81,    -55,   1518,
       222,    338,   -356,    349,     97,     86,    495,   -233,
      -121,   2936,    200,    935,   -381,   2474,     53,    494,
       248,   -139,    -45,    100,  -1287,   -181,   -370,    311,
       287,   3016,    -96,   -128,   2146,    567,   -383,   -551,
       -96,    144,    495,    428,    -32,    137,     27,   -272,
      -149,      9,    -61,    177,  -5236,     91,   -837,    611,
      -279,    -74,    652,     14,   -178,    -82,    -89,    347,
      -245,    647,    -62,     49,   -215,     29,    -55,    -27,
       178,     79,    -19,    -59,    177,   -152,      0,    189,
       -10,    128,   -115,     33,     61,   -106,     56,    -13,
       135,    116,  -5772,    157,     43,     26,    -11,    102,
        -4,    -52,    208,   -186,    198,     99,     81,    -29,
      -103,    193,    -35,    -84,     -4,   -111,  -5251,     84,
        71,    -85,    -77,     55,    234,     38,      0,    -35,
        60,   5875,     98,     36,   -219,    -17,   -419,   -136,
        47,     34,     55,    -21,    -17,     -1,     72,     94,
        52,     -3,   -703,  -1437,   -518,    557,    121,    356,
      -345,   -717,   -438,   -279,     13,     70,    -95,     -2,
     -4170,     40,    136,     17,   -153,      8,   -149,    -27,
      -559,    268,   -237,    -82,   -220,   -921,   -588,   -150,
      3481,  -1906,    647,    675,   -455,    598,   -386,    -52,
        -7,    222,   -201,     90,     54,     75,   -283,    118,
      -375,   5768,     20,   -126,   -141,    -99,     64,    116,
        16,    -58,      0,    -31,    -15,    250,   -104,    -30,
      -144,    115,     12,    117,   -482,  -1709,   -436,    122,
      -246,     -7,    271,   1961,    154,    149,    -86,    147,
       258,    531,   1760,    914,  -1196,  -1800,    812,   -621,
       125,   -161,   1361,     50,   -651,  -1307,    360,   -785,
       205,   -156,    294,     21,  -3484,    -18,    -79,   -266,
       770,    307,     29,   -765,   -250,    183,     55,    131,
      1452,    260,    224,    221,   -347,    360,   -352,  -2188,
      -664,   -503,    313,    406,   -251,   3268,    210,    -46,
       129,   -276,    343,   -143,    104,    -55,    461,     17,
      -576,   -287,   -289,     33,  -2500,    -85,   -428,  -1137,
       918,   -245,   -490,   -260,   -270,   -133,   -591,    199,
      -294,   2784,    102,     19,   -109,   -745,     91,   -524,
       -44,     28,    252,   -511,    -80,   -146,    271,    519,
      -216,  -2280,   -411,   3699,   -368,   -538,    427,   -158,
       114,    -50,   -589,   -340,   -180,    703,   -186,    487,
      -649,    668,   -916,   -436,  -3684,  -1016,    877,    -65,
      -153,    -62,   -148,    -17,   -106,    142,    -73,     -1,
       -68,    567,   -658,    815,   2270,   -563,   -519,   -226,
      -223,   -282,    584,    240,  -1522,  -1935,   1169,    880,
       127,  -1276,   -127,    399,     63,     25,  -1297,   2131,
       592,   1652,   2609,     69,   -581,   -179,    947,    597,
       150,     35,      0,   -255,   -232,   -728,    239,     91,
       130,   -234,    231,     56,  -2181,   1774,  -2196,   1633,
     -1065,   -662,    777,   -175,   -128,    267,     -7,     51,
        27,   -133,     95,   -500,    188,   -167,     94,   -176,
       -29,    -65,   -161,   -141,   -694,   -968,    594,   -269,
      -422,   -472,   -731,   1210,   -816,   2142,  -1321,  -1746,
      -149,   -983,   1310,   -839,    762,    284,     99,    -31,
     -1169,    -84,  -1119,    -55,   -720,   -944,  -1115,   -271,
     -1032,   1064,    187,  -1013,   2987,     26,   -209,    516,
        -8,    107,    -24,    188,    278,    -53,    624,    460,
      -275,  -1881,  -2001,    851,  -1740,   -407,   1643,   -352,
       -17,   -528,   -538,   -175,    179,    416,   -297,     54,
       132,   -491,    -76,     34,   -440,    175,   2065,  -2006,
      -164,     38,   -403,    902,   -129,    215,   1545,   -414,
     -1183,   -532,    578,    248,   -308,    189,   -563,   -345,
      -949,   -279,   1693,   -959,    101,    783,      9,   1641,
      1494,    167,   -294,   -538,    951,    115,    590,    105,
      -847,  -1003,    464,   -368,  -1268,    641,    254,    243,
       488,   2636,  -1209,   -272,    437,    445,    781,   -463,
      -415,    538,   -811,    588,   1083,    206,   -547,    171,
      -585,   -744,    343,   -604,    395,    -76,    910,   -523,
      -108,   -449,    625,   -325,  -1079,    273,  -1473,  -1096,
      -137,   -565,   2077,   -623,    214,   -342,   -273,    769,
      1137,   -879,   -731,     56,  -1098,    211,    822,    579,
      -839,    164,   -600,    -80,     61,    316,    644,   1445,
       891,  -1796,  -1798,   -162,  -1631,   -492,   -626,    593,
       544,     66,     63,   -857,  -1273,    406,   1665,    899,
      -467,     87,   -117,   -469,    126,     30,   -931,   1446,
      -190,    388,  -1608,   -316,  -2199,   -127,    484,    -51,
        56,   -524,   1524,   -103,   1231,   -740,    717,   -861,
       823,   -665,  -1790,    411,   -690,    303,  -1615,     63,
      -232,     19,   1090,    -96,    137,     80,  -1027,    581,
       -61,    672,    133,    444,   -767,    766,    -42,  -3174,
      -270,    -23,   -126,  -1111,     67,  -1367,      4,    315,
       -53,    -90,   -165,     48,  -1657,   -117,    392,    356,
       792,   -610,   -618,   -219,    446,    102,    374,    207,
      1026,   2480,   -461,   -782,   1161,  -1351,   1032,    486,
      -308,    290,   -272,    899,   1912,     36,   -624,    286,
      -428,   -623,   -665,     12,   -621,  -1985,    -34,    468,
       318,   -467,    127,   -972,    -39,   -663,   2307,    -26,
       406,   -468,   -657,  -1404,   -342,   2356,   -395,  -1422,
     -1243,    465,     90,   -665,   -280,   -290,    -21,  -1752,
       280,    271,    395,    240,   -402,     55,   1077,    148,
      -309,   1818,    483,  -1293,     43,    261,    566,   -131,
       947,   -815,   -872,  -1021,  -1001,   -395,    263,   -555,
        78,  -2193,   -360,    -76,  -1029,   -493,   -464,   1339,
       -53,    750,   -671,  -1349,    133,    -70,    114,    501,
       766,   -816,    703,   -992,   -122,   -520,  -1323,  -2539,
      -365,    -35,   -555,   -888,   1515,   -191,   1322,   1633,
      -674,    451,  -1246,    270,   -868,    703,   -394,    106,
      -779,    754,    650,   1066,   -417,  -1305,    149,   -165,
};

static const int16_t cb4432l1[] = {
     -3867,   -448,   2202,    129,   -100,    393,     37,   -267,
      -156,     23,   -274,    222,     33,   -191,    104,   -140,
       -50,    -28,   -148,   -181,    -22,      6,    489,    993,
     -2764,   1191,   -773,    781,   -460,    843,    -77,  -1417,
       390,    124,   -203,    205,    662,    -16,    569,   -963,
       609,   -155,     64,   -293,   2649,  -2533,     70,   -472,
      -482,  -1732,    235,     -5,   -485,    116,   -177,   -104,
       314,   -355,    118,     25,    921,    285,    130,    -94,
        77,    121,   1068,   -435,   1407,    447,   -427,  -1096,
      -757,    258,     19,   3236,    702,    362,   -928,   -348,
      -150,   -784,   -687,   -388,   -176,    -38,     16,    -14,
      1017,    879,    935,   1280,   1014,    -85,   -256,   -103,
     -3384,   -928,   -200,   -406,   -175,    304,    -54,    195,
       -78,    676,   -356,   -167,   -165,    -56,  -3133,    156,
      -171,   -684,   -698,   -135,    230,    -30,     32,    542,
      1959,   -124,    -76,    162,    182,   -174,   1011,    -97,
       678,     10,    188,     30,   1086,   -262,   -157,    250,
       241,    233,   -584,   3276,   2126,    -50,   -207,    637,
      -440,    331,   -434,    251,   -267,    269,   -392,     68,
      -244,      8,    928,    827,  -1096,   -309,   -356,   -375,
     -3204,    422,    695,      2,    240,    595,    641,    582,
       342,     42,      7,    539,    -64,   -116,     82,     16,
        26,   -136,   -122,   -114,  -5814,     22,   -272,     10,
       113,    186,   -422,    -95,    309,    308,   -118,   -208,
        52,   -175,     12,   -106,     -6,     20,     58,   6053,
      -101,    -20,     10,     70,    189,     57,    -11,    210,
        83,    239,     -6,    -79,   -233,    -59,     31,    -30,
       -62,     64,    -38,     25,    -78,   -202,   -215,   -115,
      1477,    255,    101,  -2575,    186,   3140,    -46,    -45,
        53,   -183,    -89,   -412,    183,   -222,     50,   -237,
        96,     35,   1684,   -521,   -169,   -436,   -295,   1390,
       261,     27,    163,    352,     68,  -3677,     12,    310,
      -599,    331,    138,   -333,   -269,   -130,    -44,    -14,
       265,   -626,    258,    -59,     31,    -17,    222,    -10,
      -364,    280,   -183,   -235,   -217,     73,    -67,    114,
       196,  -5132,    269,    159,     -6,    -36,   -248,    274,
      -328,   2712,   -393,   2763,    507,   -110,   -166,    -84,
       -72,  -1111,    -19,    370,     25,      5,    156,    -32,
       237,    -57,   -106,    -22,    370,   -229,   1099,   4297,
       152,     72,    -56,    347,     64,   -501,    -57,    178,
       175,    -14,    -84,   -626,    555,    155,     20,    -75,
        20,    -33,   -254,   -125,     -9,    150,     91,     -7,
       -45,    239,   -109,     72,    -66,   -172,   -211,   6063,
      -205,    171,    -75,     50,    -75,     22,    109,     21,
       -58,     58,   -105,   -432,    310,   3782,    -18,  -1071,
        19,     20,   1455,    337,   -257,   -288,    -52,    519,
        43,     80,   -175,   -218,      9,    176,    -28,   -418,
       200,   -514,    351,    119,  -5920,    -96,    -33,   -289,
        74,     26,    120,    -37,    113,     47,   -145,    -17,
       334,     46,     47,     19,    274,    172,    159,   -404,
      3151,   -408,   -559,    987,   -178,    253,    -90,   -498,
      1454,   1183,    392,    762,    220,  -1207,   -220,    -69,
       -85,     22,   1644,   1858,    725,   1084,      0,   -257,
       290,   1712,   -151,   -188,   -390,    638,   -327,  -2185,
      -322,  -1116,   -150,    120,   -140,    198,    162,    -83,
      1321,    232,    242,    -52,   -456,    778,   -288,     65,
      2431,     37,     85,   -489,    862,   2776,    260,    -72,
       792,    100,     17,   -210,    588,     49,    600,    246,
      -258,    128,    -51,   -492,   -395,   -489,     50,  -5308,
       -67,    314,    124,     46,   -188,    -64,   -101,     51,
      -535,    108,     56,     -4,   -191,   -923,    485,    578,
      1320,    228,   -535,    310,    227,    395,  -1441,   2660,
       226,   -392,    221,   -686,   1749,   -175,   -904,   -571,
      -129,    154,   2622,    609,   -247,   -240,   -893,     98,
       291,  -2277,    411,    260,   -160,   2061,   -203,   -437,
       359,     21,   -101,     19,     49,     15,    -98,     82,
         3,   -555,    164,   -152,    -58,     38,    175,   -439,
       -37,     68,    -21,   -181,  -5556,    -27,      8,     48,
        21,   -151,    381,      3,   -152,    -74,    202,    -29,
      1863,   1713,   -922,  -1976,    551,  -1522,    525,   -116,
       146,  -1730,   -238,    -72,   -183,    126,    234,   -240,
        82,    138,    -60,   -131,  -2226,    226,   -702,    183,
       -81,    462,  -2851,  -1419,  -1005,    124,    -81,   -252,
       -65,    147,    -58,   -179,    306,    154,    122,    -69,
        69,     11,    115,    296,   3340,   -501,  -2580,   -804,
         9,    591,    -86,     88,    127,    588,    183,     48,
        79,    -38,   -199,     63,   -140,     29,     88,    -28,
       259,     69,   1743,   -531,    110,    -18,    776,    -18,
      -177,    112,     36,   -243,   -208,    528,    -47,   4709,
       107,   -125,    140,     -1,     22,     15,    416,   -194,
      -267,    -49,     43,     -3,   -308,    214,   -128,    140,
      5372,   -123,     70,    275,    210,    182,   -147,   -131,
       -84,     69,    116,     29,   -401,   -162,   -236,   -173,
       378,     45,    -12,    -77,  -6209,   -103,    126,     54,
       -19,    -20,     43,     64,     92,     -8,    -12,    118,
      -123,     58,  -3628,   -414,  -2147,     76,     95,    -99,
       357,    -10,    278,      4,   -608,    504,    105,    -72,
      -109,    -92,    -55,    367,   -167,     40,    -34,     76,
       220,   3434,   -366,    191,    248,     29,    187,   -177,
       155,   -348,   -341,  -2466,    272,   -136,    510,    139,
        81,    184,     33,   -299,     92,    -44,   -402,   -583,
      -725,   -400,   -159,    751,   -225,    377,   -160,   1556,
     -2652,    685,  -1077,   1276,    332,   -257,  -1449,   -282,
      -231,   -145,     58,    173,    421,    271,    401,   -186,
        79,   -258,    127,    252,    214,     96,    157,    195,
       205,    118,  -4771,    -95,   -164,    217,    477,    -51,
        -4,      8,   1450,    -51,    -52,    952,    675,    929,
      -273,    475,      9,    282,   -249,    236,    746,  -1407,
      -272,   1845,    692,   -105,   2690,    168,      1,     -1,
       157,   -599,    305,    255,  -2252,     45,   -199,    119,
     -3489,   -161,      6,   -263,   -259,    338,   -251,     61,
       153,   -124,    432,     -7,    131,      5,    305,   -322,
     -3283,    -32,   -336,   -273,   2243,    863,     -1,    681,
      -365,   -246,   -152,    375,   -133,    -15,   -208,   -104,
        89,    128,   -135,     44,   -255,    549,  -2751,    -48,
       270,  -2584,   -549,   -631,    445,    182,   -198,    743,
      -215,    -60,   -400,   1383,    167,    -65,    250,    146,
       185,     22,   -484,   -161,     86,   1758,    964,    404,
     -2574,   1026,      6,   -516,   -724,    315,  -1891,    311,
         2,    339,    -39,    324,    299,   -497,    -12,    179,
     -1242,    364,   -185,   -197,  -1474,    232,   -490,   4042,
      -105,    887,     31,    539,    235,     75,   -112,   -200,
       -31,     74,    -76,    -16,    -20,     38,   -159,   -143,
       114,    -77,   -110,     28,    -18,    -84,    -27,    -53,
       -82,   -224,     75,      0,    -46,    -64,     44,   -112,
        84,    -85,  -6030,    -24,    661,   -474,   -178,      8,
     -1023,   -396,    199,    -19,    -50,    -93,    385,    209,
     -1227,   2492,   2163,    986,  -1359,    399,    848,    681,
      -829,    211,    696,   -599,  -1398,   1951,   -113,    374,
       -17,  -1113,  -1708,   1294,    666,   1774,    623,    259,
       105,    961,    -87,     43,   -463,     65,    155,    -26,
       -31,  -1477,   -508,   1091,  -1463,   -524,  -1853,   1354,
       434,     86,    893,   -871,    151,  -1887,    205,    423,
       857,    -55,    -11,    -39,    341,     61,   1158,   2650,
       899,  -2491,   -593,   -843,  -1399,    -15,   -713,   -171,
      -195,   -523,    -46,    243,    117,    241,     -8,    140,
      -149,   -191,     70,    134,  -1158,   1933,   1135,  -2284,
     -1049,   1717,    378,   -155,    -37,    171,   -692,   -280,
       918,   -786,   -123,    558,    571,     39,   -315,     62,
        27,     59,    708,   -134,   -200,   -168,   -134,    148,
      -142,     25,    164,   -282,    284,    -95,    -35,    376,
       165,    367,   -335,    271,    249,  -4520,    176,    -36,
      -216,  -1303,    375,     92,    602,   -889,   -390,    284,
        78,  -1318,   1259,   1865,   1498,   2063,   -234,   -840,
      -391,     88,    168,   -235,    -74,     31,   -239,   1221,
        71,  -1637,   1513,     68,   2201,   1513,  -1099,   -622,
       426,    343,   -330,   -648,    381,   -156,     27,    -31,
       -92,    133,    210,    103,   -155,   2061,   -366,  -1173,
       -31,   -274,   -713,   -471,    509,   1044,    208,    403,
       486,    -66,   -521,  -1883,   -180,   -537,   1283,    -98,
     -1464,   -456,    508,   -619,   -546,    685,    944,    -85,
       311,   1172,   -194,   1406,    -99,   -827,   1506,    396,
       196,  -1534,  -1181,   1588,   1250,     47,   1034,   -171,
     -1247,    -98,   -120,   1181,  -2195,   -384,    945,    627,
        26,   -248,   1372,   -671,    214,   -649,    -17,    -44,
      -500,   -559,    577,   -601,     32,    421,    531,    344,
     -1233,    145,    348,    614,   -560,   -244,   -357,   -202,
       814,   -494,  -2320,    308,  -2277,   -481,   -518,   -431,
      -851,     43,   -204,    -26,   -742,   1083,   -130,   2002,
      1642,  -1156,   1746,   -529,    937,   -544,    416,   -741,
       763,   -232,    509,    243,   -458,     78,   -130,    143,
      -123,     71,   -666,   -105,     31,  -1061,    441,    -48,
       411,  -1547,    155,   -730,    439,   1624,    873,   -611,
      -470,   2348,   -157,   1184,    678,   -174,    542,    -95,
       -12,   -405,    237,    322,  -1194,   1903,   1496,    357,
       -34,   -661,  -1024,   2236,    860,   -256,    617,    756,
      -485,   -273,   -589,    536,    214,   -286,    782,    418,
       346,   -462,    443,   1056,   -914,   -304,   -564,   -332,
      1823,   2079,     93,   -975,   -891,  -1089,   -720,  -1127,
       702,    300,    787,    374,    -78,   1070,    691,   1339,
      -797,     57,    482,    432,    748,   1538,    673,   1885,
      -504,   1913,   -190,   -135,    881,   -139,     84,    379,
      -176,   -129,   -331,    -34,   -690,    282,   -563,     51,
        71,   -714,   -103,   1074,   -651,   -582,   1388,   -320,
     -1115,   1547,  -1088,    -65,  -2634,   -201,   -653,    116,
      -238,   -218,    476,   1417,   1671,   1135,  -1025,    614,
      -662,    127,    863,   -117,    726,   -971,   1382,   -286,
       465,   1195,   -715,    862,  -1256,    105,     37,  -1190,
      -442,  -1777,     50,    162,   1577,    580,    762,    253,
        92,   -308,  -1238,   -161,    295,   -150,   1733,   1831,
      -527,   -527,    -28,     70,   -359,  -1590,    860,   -221,
        47,  -1201,   -254,     39,    780,   -326,   1097,  -1019,
       834,    362,    357,     41,    693,  -1099,  -2687,    614,
       270,   -128,   -322,  -1149,    631,    -46,   -343,   1495,
      -896,   -864,   1545,    200,   -922,  -1133,   -637,  -1231,
       484,   -796,   -743,   -371,    999,   1300,    173,    -19,
};

static const int16_t cb4432s0[] = {
     -2558,   2751,   -440,   1200,   1067,   -725,   -492,    588,
       234,   -209,   -108,   -230,    223,   -231,   -235,   -132,
       -51,     88,   -290,   -214,    -99,    -60,    175,   2546,
      -991,    907,    446,    635,    284,    707,    238,    220,
      -308,    259,      8,   -435,  -2207,  -1487,  -1579,     46,
       285,   -249,    154,   -370,     37,     42,   1524,  -1853,
      1393,   1204,    126,   1751,     82,    136,    363,  -2411,
      -782,   -128,   -818,   -232,    765,   -173,   -127,    732,
       260,   -101,    868,   -249,    290,     32,    645,     55,
     -1742,  -1077,    392,   -568,    629,   -920,   -243,    791,
      -604,   -363,    117,  -1360,    -15,   -245,  -3655,     54,
      -297,     10,    124,     11,  -1114,   -567,   3882,  -2042,
     -1120,    -42,   -114,   -914,    419,    307,     44,    277,
      -101,    429,    170,    187,   -528,   -705,    348,    -19,
       180,    -76,     91,  -1861,   -181,   -171,    804,   -730,
       222,   -184,    349,    191,   -125,     14,   4270,   -467,
      -272,     29,   -216,    212,    426,   -222,     11,    -16,
      -852,    101,    576,    178,    351,    647,     90,    179,
      -681,   -187,     77,   4115,   -976,   -726,    711,    763,
       572,  -1166,    -46,   -445,   -103,    135,    294,    300,
        10,    737,    386,   -399,   -349,    -52,   5393,   -107,
       -32,   -229,   -154,   -181,     82,    -68,    -13,    -77,
        48,     75,    117,    -50,    254,    233,     98,     75,
     -2218,  -2214,   1491,    832,    225,  -1057,    267,    539,
      1963,   -245,   -353,    454,   -430,    -54,   -747,    -58,
      -438,    -90,    -64,    277,    214,   -105,    -47,  -1301,
      -404,  -1179,    682,  -4093,    764,   -270,   -342,   -367,
     -1378,      6,    -83,    429,    398,     61,   -149,    180,
        31,    169,   -218,    152,    -71,    -38,   2605,    679,
      -175,   -533,   1787,    611,    484,   -322,    158,   -561,
       125,    -35,    -42,   -190,    529,    449,    157,  -3105,
       106,    168,     -8,    -66,    -80,   1463,   1136,   4793,
       -98,   -432,    538,   -145,    241,   -158,    105,   -372,
        39,   -160,     92,   -223,     81,    245,   -142,   -162,
      -167,   -297,    -49,    -98,    582,  -5178,   1130,   -271,
       567,   -251,     55,    487,   -303,     31,    -25,     87,
       -70,    154,    -23,   -221,     70,    208,     48,   -137,
        46,     59,     -9,  -1397,   -970,    224,    714,    161,
        24,   -307,   1295,   1467,   -155,   -505,   -521,   -244,
       503,    -25,   -989,   3664,   -148,     12,   -135,    218,
      -159,   -156,   -769,   -421,    553,    715,    697,   -181,
      1426,    425,    -39,   -103,  -4558,    171,    347,    161,
       170,    128,   -210,    -35,     31,    125,   -264,   -135,
      -100,   2685,   -230,   2062,   1618,    -99,   -874,    926,
       757,    380,    404,    -73,     30,     29,    462,    725,
      -389,   -246,     20,    150,   -234,    -58,   -183,     10,
       156,    482,   -232,    124,    115,    180,   -615,   -395,
       330,    -85,   -435,   3279,   1493,    686,   1157,    245,
     -1067,  -1953,     23,    796,   -540,    175,     56,  -1931,
        89,    705,   -342,    551,  -1999,   1951,  -2305,   -497,
      -266,    275,  -1503,    351,   -355,   -353,    236,   -358,
      -271,    -40,    136,    217,    -13,    -45,  -2091,   1141,
       730,  -1888,   1131,    660,   1271,    439,   2597,     92,
       319,    -91,     62,    316,    287,   -260,    121,    -33,
      -117,    -22,    -79,   -170,   -164,   1486,    134,    -62,
       -36,  -3367,   -235,   1221,   1239,     78,    -54,   -489,
       268,   -560,   -774,    851,   -973,    -62,   -174,   -138,
      -459,    390,    -22,    -42,     83,   1339,   1307,    462,
     -3768,    511,    300,   -525,   -787,    -89,    675,  -2074,
        37,    -48,    252,    598,   -332,     67,   -187,      2,
      -106,    -35,   -148,   -186,   -542,    799,   2363,   -155,
      -665,  -2867,   -209,   -200,    -80,   1682,   1082,      2,
       516,   -481,    276,     -1,   -220,     54,    -12,    259,
       161,   -148,    566,  -1489,   -731,   1262,    499,   -816,
       115,   4057,    -71,    701,     39,   -132,   -223,    -16,
       229,     -2,    -40,    -61,    234,    405,    108,    304,
       -62,   -396,   1369,  -1438,  -2045,   1954,    759,    969,
      -166,   -235,   -115,    -68,   1923,   1815,   -776,   -855,
        34,    -63,     17,     87,    223,   -145,   -130,    -16,
      -313,  -1704,   -458,   -332,    420,   1332,    676,    878,
     -3847,   -360,    427,    537,    651,   -167,   -451,   -197,
       277,    136,   -201,    517,     10,   -156,     35,   -927,
      1250,   -173,   1004,   -169,    322,   -140,   -559,  -4656,
      -343,   -264,    -61,    -12,    195,    -10,   -123,    -23,
       -20,     -6,   -367,   -102,   -215,     41,    838,   1513,
       552,  -1609,   -753,   -763,   -656,   -633,     14,     35,
       141,    117,   -121,    857,  -1494,    578,   2546,   1034,
      -676,    571,    817,   -218,   -111,   1424,    -51,    878,
     -2860,   -257,    104,   -526,    782,    708,   2350,   -500,
      -342,    219,   -406,    836,   -117,    288,   -415,    798,
        14,   -311,   -455,      3,   -410,   -144,    -30,   -977,
      -145,  -2466,   -957,   1370,  -3201,   -327,    -85,    149,
      -580,    198,    350,    140,   -104,    327,   -128,   -178,
        58,    294,     50,   1814,    581,   -909,    287,   -267,
     -3992,     61,   -860,    258,   -271,   -223,    237,   -291,
        -3,     66,    110,   -620,    319,    -62,    177,    364,
       110,   -163,   -921,   -863,    251,   4922,    280,    121,
       128,    209,   -126,    578,    -56,     41,    124,    350,
       245,   -465,    -67,      5,    651,    147,    200,      0,
        21,   -609,   -332,     -3,    247,   -412,    128,     42,
     -1405,   -301,   -341,   -484,   -491,    -55,    361,   -100,
       -30,   -405,    643,   4249,    -31,    -91,    -10,      6,
       425,   -350,  -1501,    817,  -1348,   -201,   -345,  -3643,
       235,    691,    332,    219,    199,   -398,    130,    -50,
      -190,     89,    -23,    100,   1327,   -200,    146,    482,
      -624,   -479,   -391,    188,    129,    614,   -335,   -564,
      1021,   -107,   -199,    145,    201,    571,   1276,   4253,
        58,    121,    295,     38,     26,     47,  -1333,   1138,
      3125,    357,    -72,    347,    276,   -272,    120,    -77,
       535,    247,    -71,  -2054,  -1860,    -73,    -62,    266,
       -30,    183,     17,    -46,     -7,   -140,    997,    526,
       -47,    -59,   1540,    373,    162,   -150,   -107,    -74,
      -278,    -37,   4268,    -21,   -269,    359,    111,   -115,
        -5,   -206,    -87,    -44,   -517,     54,  -2859,    189,
      -297,   -863,   -918,   -929,   -543,     25,  -2866,    -79,
     -1101,   -275,   -410,   -458,    -75,   -211,   -420,     96,
       467,    -66,    -15,   -580,   -420,   -586,     -7,    109,
       236,    227,   -488,    106,    258,     76,     78,     -8,
      -199,  -4888,   -134,   -205,    -33,   -243,    -19,    -10,
       157,    129,    120,   -928,    604,   -345,    -47,   -430,
      -257,    273,     81,   1949,    490,    272,   -205,   2460,
       -54,    103,  -2924,   -529,   -211,    -60,    279,    220,
       -57,    342,    209,    984,  -1410,  -3363,  -1028,  -1301,
     -1293,    227,   1142,  -1068,   -512,    758,    364,     46,
      -358,     16,    257,   -158,   -253,   -182,     -2,    181,
      1475,   1574,    215,   -968,    246,    369,   -273,   -717,
       546,     74,  -3872,    293,     98,    130,   -244,     41,
       143,    699,    -56,   -126,     67,     54,     -2,   -878,
      2334,    883,    215,  -1979,    246,   -759,    499,    248,
       751,   -202,    580,  -3018,    359,   -139,    210,    -47,
      -168,     89,   -659,    259,    -54,    -40,   -490,   -169,
      -769,    569,   -171,     64,   -845,    519,   1251,    -71,
      -459,  -4436,    257,   -334,   -826,   -183,    115,   -408,
       -77,    544,    173,   -258,     48,    331,   1735,   1035,
      2793,   1154,  -1901,    275,   -109,  -1185,   -403,   1332,
      -282,     36,   -367,     21,     27,    362,   -425,    217,
       150,   -304,    192,     53,  -1100,     27,    628,    698,
      -634,    -25,     84,      8,   -103,    533,   -301,    218,
      4350,    119,   -109,    309,     24,   -352,   -147,   -274,
       156,     85,      9,   1706,   -854,   2012,  -1573,    112,
      -673,  -1538,    -91,    415,  -1525,    866,   1493,   -621,
      -396,    277,   -604,   -363,    114,   -360,   -252,    -18,
       -31,    -77,   -591,   2483,    535,  -1520,  -1057,  -2189,
       -51,    798,    276,  -1426,     72,   -303,    402,    111,
       327,    272,     -8,   -216,    189,   1282,    152,    -45,
       -33,   1524,   2301,   -341,   1992,    939,   1678,   1011,
       114,    167,    586,   -500,     40,   -473,   -274,    596,
      1237,   -126,    205,    254,   -284,   -367,   -119,     64,
      1915,    437,   -585,      1,    402,   -271,   -984,    530,
       267,   3634,    495,   -219,   -728,    -67,  -1340,    983,
       122,      6,    110,   -166,    111,    102,   -139,  -2499,
       753,   1011,   1755,  -1252,    872,   -510,  -1844,   1388,
      -782,    287,    461,     36,     77,    437,   -361,   -216,
      -415,    158,    -77,   -123,     57,    -93,   3408,    504,
      -942,    434,   -648,   -251,   -420,   -387,   1373,   -229,
       236,   -191,      3,    204,    612,    393,   -285,    560,
      -164,   -199,    303,    146,     93,   1248,   2425,   1001,
      1261,   -239,   1085,  -1878,   -375,   -544,   -995,   -192,
      -319,    542,    280,   -716,  -1323,    -67,    -34,    252,
       -36,    206,   -126,    -28,     26,  -1135,   2799,    527,
       -47,  -2008,    509,   -232,   -953,    332,   -386,   -108,
       290,    507,    578,   -809,    375,    850,  -1413,    831,
      -137,    259,     25,  -1075,    407,   1784,  -1539,   1658,
      1450,   -969,    467,      4,    785,   -595,    912,     34,
        91,    286,   1035,   -524,    276,   -322,     11,    651,
       733,    243,     45,   -145,    357,    524,   -697,   -259,
      -757,  -1057,    181,   1324,    148,   -502,    -64,   -379,
      -746,   1385,    395,    184,   -749,   -197,  -3375,   -546,
        -4,    532,   -270,    687,    501,    285,    401,    431,
     -1888,   -639,    655,   -325,   1896,  -1883,     53,  -1018,
     -1475,    802,   -486,    -68,    232,   1337,    428,    232,
      1754,  -1687,   -518,   -372,    508,  -1269,    327,   -900,
      -468,   1127,   1397,   1597,    837,    659,   -617,     99,
       264,   -460,    296,     44,   -295,   -209,   -174,   1105,
       896,   1065,   -174,      5,    845,   1311,   1370,  -2548,
       351,   -660,    -24,  -1089,   -787,  -1312,    -22,   -585,
      -197,    749,    293,   -112,   -169,    -23,      3,   1151,
       529,   1173,    224,  -1517,    930,    -52,    268,  -1282,
      -559,    466,   -528,   1506,   -231,   -337,    993,  -1314,
      -250,  -3042,     57,     19,     15,   1812,    697,   -389,
      -201,    647,   -723,  -1098,   -177,   -225,  -2694,   -495,
      -431,   -238,    388,  -1731,    997,    227,   -765,   -222,
        94,   -611,     35,    187,   -935,  -1470,   1013,   1051,
      -378,    311,   -710,   -566,   -532,   -369,  -1599,    553,
       167,    450,  -1068,   2834,   -125,    601,   -113,   -503,
        40,     14,    -36,   -220,  -1543,    867,   -612,  -1834,
       888,  -1791,   1296,   -229,   -593,   -760,   -197,    428,
     -1290,    892,    -62,   1113,  -1228,   -965,    -90,   -300,
       288,   -133,    779,  -1211,   -627,    268,    180,    913,
      2230,   -413,   -146,   -217,    170,  -1157,  -1551,    877,
        75,   1784,   -174,   -230,   -757,   1243,    625,    -49,
       114,   -218,   -409,    195,  -1165,   1492,    213,   1100,
      -101,   -957,   1016,    663,   -704,    817,     94,   -279,
      -256,    469,    -75,   -123,  -2954,    948,   -407,    275,
};

static const int16_t cb4432s1[] = {
      5416,   -223,   -123,    156,    -33,    185,   -144,   -108,
      -199,    -68,    -36,     11,     37,    124,   -301,     58,
       -21,    155,     99,    -10,    -78,    -26,    -70,  -3160,
     -1037,     98,    155,   -373,    834,    652,   -277,   -429,
      -529,   -103,   -358,    187,   1161,   -157,    147,   -400,
       461,    156,    237,    481,    -67,     99,    939,   1179,
      -659,   1337,    578,   -489,   -481,   -427,   -622,    131,
      1826,   -734,   -995,     -5,   -461,    514,    -83,   -271,
     -2928,    -86,   -382,   -205,   -133,   -386,   -195,    -67,
       508,    586,    607,   -910,   -181,  -2046,   1212,   -179,
        23,    408,  -1929,   2044,   2160,   -879,     74,    179,
        72,   -164,     47,    162,   1497,    826,   2978,   -912,
       454,   -618,  -1907,   -501,   -494,   -299,     96,   -138,
      -114,    -51,   -171,    445,   1144,   -187,    217,    224,
       402,     13,     42,    -58,  -1692,   4162,   1272,    970,
      -278,    327,     88,    -31,   -182,    279,   -610,     78,
      -432,   -147,   -142,   -725,    -17,    -95,    388,    133,
       -61,     28,  -1365,   1441,    606,    411,    923,   -332,
      1843,   1934,  -1451,   -514,   -283,    768,    940,   -428,
        31,   1105,    248,    -78,  -1477,   -367,    404,     68,
      -178,     17,    691,   -265,   -105,   1681,   -476,  -1307,
     -3434,  -1700,   -524,   -871,    472,   -171,    237,    104,
      -142,   -231,   -292,   -285,    266,   -259,   -166,    -97,
      -432,   4003,   1220,   -356,   2110,   -220,   -465,    -48,
       117,   -178,    290,    -21,    205,    -19,    321,   -343,
      -328,    -57,    215,   -345,    304,      2,     10,  -2071,
       185,    433,    212,  -1165,    112,    242,   -294,   -162,
      1107,   1176,   -396,   1400,  -2600,   -434,   -640,    457,
       100,   -268,    809,    128,   -236,    -66,    -94,   -842,
        82,    163,    227,  -2641,   -485,    291,   -326,     42,
       234,   -648,   1355,   3016,  -1403,    -71,    188,    792,
        15,    -16,   -522,    -75,    106,   -824,   1133,    947,
       477,   -642,   -531,   -808,   4100,    -34,   -407,    133,
        33,     15,     63,     72,   -223,    -15,   -491,     38,
        47,    258,   -236,    192,   1628,    173,  -2116,    687,
       295,    -74,   -183,     95,    529,    149,   -372,    182,
      1317,     21,  -1424,  -3156,   -111,    -96,    580,    284,
      -274,     41,    145,   1314,     79,   1830,    262,   -325,
       -16,    169,   -245,  -2038,   1959,    892,    946,    303,
      -171,   -432,    883,     34,   -238,   2463,   -294,     25,
        24,   -106,    -45,    509,   -154,    496,    109,    115,
       169,    702,    396,    -97,    657,   -251,   -112,   -114,
      -144,   -230,    517,   -190,   4885,    -45,   -152,     -9,
      -170,  -2021,    541,   -905,  -2015,   2588,   -936,    -20,
      -300,    384,    433,   -123,    119,   -505,   -126,    295,
       526,  -1352,    450,    142,   -126,   -115,      1,   -140,
      -734,    672,   -147,   -660,   -747,    652,    161,   -163,
        51,   -616,  -1974,   1413,  -3145,    922,  -1289,    215,
       182,   -838,   -171,    107,   -333,     34,    216,   -307,
      -359,    496,   -343,   -325,  -2552,  -1573,    588,   -441,
      1296,  -3075,    119,   -131,     54,    206,    278,    106,
      -100,    112,    220,    -49,    -80,   -229,   1051,   3271,
     -1300,    324,    -31,  -1025,   1659,   1526,   -161,    669,
       -56,    430,    201,   -535,   -126,     -9,   -380,    222,
       212,   -345,   -282,    195,    -41,  -1235,   -593,   -593,
      1557,     71,   1023,   -831,    545,   -875,    161,   -772,
        99,   -190,   1616,    338,   -251,   -201,  -3104,   -774,
         4,   -121,    178,    -80,    652,  -1018,   -441,   -343,
      -236,   -240,   -244,    -26,   2192,     75,  -1348,   3771,
       -22,   -850,   -251,    316,    132,    -21,     63,    104,
       152,    185,    -40,    275,  -1356,    482,   3081,    571,
      -481,  -1387,    815,   1285,   -352,    -98,    -41,    573,
      -307,  -1879,    427,    196,    169,    -26,   -232,    -98,
      -411,   -231,  -2034,   -969,    271,   1421,  -1485,   -407,
      1404,   -343,    861,    888,    -11,    202,   -245,   -397,
       104,    229,    309,  -2757,    315,    416,    393,    194,
      -176,   -663,   -166,   -229,    244,   -152,    183,     24,
      -205,     97,   -255,   -299,    123,    -12,     53,    102,
      -362,    371,    223,     46,    132,  -5177,    157,    -92,
     -1114,    -28,    135,   -831,    627,   -428,  -1116,    421,
       761,    458,   3256,   -167,    355,   2045,    113,    234,
      -154,     20,    -39,     61,    -81,     63,     98,   -171,
      1727,  -1193,   2103,    416,   -421,   -575,   -636,   -114,
       700,   -260,   1610,   -336,    521,   2591,   -738,     43,
       103,    -63,   -335,    168,    110,     41,   1995,   3554,
      1443,    -53,   -206,    992,    767,   -372,    141,    -24,
       173,     60,   -237,     69,   -173,    -73,    137,    167,
      -164,   -159,    312,   -151,    -78,    619,   -192,    689,
       -69,  -2805,   -259,   -288,   -231,     28,  -1682,   2316,
      2298,   -336,   -131,     59,    542,   -218,   -281,   -214,
       -41,    116,    138,      8,   -297,    -45,   -215,   -167,
      1587,  -1061,  -1976,   -445,    401,  -2392,    -42,    581,
      -519,   -230,   1461,    542,    113,   -634,   1776,    332,
       191,      5,    174,   1939,    -26,   -242,    120,    230,
      -986,   3501,  -1125,    -89,      3,   -580,   -219,   -255,
        37,   -119,     94,    -17,   -297,   -176,   -434,   -234,
        55,    -63,  -1167,   -492,  -1753,  -3397,    185,   -794,
       689,    819,    -32,   -836,    335,   -133,    724,   -299,
      -318,    424,    558,   -654,    119,   -447,    140,   -100,
        72,   -872,  -1432,   -203,    -40,    -14,    -59,    550,
        85,    -53,   5007,    258,    401,   -184,   -313,   -170,
        66,   -185,    -82,    -61,    210,     48,   -204,    -96,
       130,   -562,  -1700,  -1037,  -3926,   -884,   1115,     -6,
      -100,    842,   -450,    877,     76,    568,   -623,     27,
        73,   -195,    328,     41,    -24,    124,    -77,   1499,
       540,  -1064,   4517,    -22,    -35,    839,    -48,    253,
      -259,     96,    409,     90,     26,   -177,    365,    -48,
      -324,    -26,    -23,    -83,    -77,    -80,   1599,   1486,
       266,    659,    236,    231,    -16,    359,   -163,    455,
      -999,  -1169,   2453,   -599,   -945,      4,  -2110,   -174,
      -736,    344,    232,    142,     32,    -99,    763,    133,
      -325,    -56,   1635,   -439,    843,      2,  -1704,    -13,
       771,   3680,    -89,    182,      4,     42,    394,    404,
        82,    312,     91,    141,  -1577,   1765,   3141,    625,
      -271,  -2122,    423,    353,    489,    606,   -290,   -190,
       486,   -131,    118,    236,    248,   -209,     -2,   -162,
       -95,     95,    170,    278,  -2233,    549,     34,   -846,
      3595,    445,   -400,    -65,    131,    -14,    -16,    611,
      -116,   1293,     98,   -680,    189,    217,    -15,   -549,
       131,      8,   -768,  -1082,    841,   -346,    129,    -33,
      -778,    322,  -2508,  -2128,  -1895,  -2021,    -27,    -42,
       -51,   -536,    239,     -1,     78,    105,     48,     79,
       207,    422,   -181,     18,    -94,   -152,   -181,  -5012,
      -187,     -3,   -118,   -397,    -84,    -49,    129,   -276,
       188,     45,   -146,   -235,   -109,     83,     32,    -79,
      2039,   -616,    257,  -1575,  -1756,  -2364,    222,    195,
     -1138,   -290,     58,   -641,   -252,    -11,    402,    -31,
     -1040,   -592,    676,   -118,   -231,     94,   -123,   1642,
      1404,   -334,   -728,  -3425,    382,    111,   -194,    677,
       177,   -182,    434,    860,  -1022,     84,   1214,   -733,
       300,     -2,   -259,    140,     35,     96,   1164,  -1476,
      -757,    -74,    239,   -203,   1796,   1207,   1732,  -3029,
      -610,    658,    490,   -465,    136,     56,   -614,   -612,
      -123,     93,   -151,    162,     56,    502,   1634,  -1825,
        45,   1033,   1554,  -2380,   1615,   1317,    786,    387,
      -255,   -423,    -44,   -246,   -213,   -149,    107,    -74,
       -94,     45,   -204,     13,  -1959,    936,   2023,   1000,
      1031,    112,    574,    323,    163,    947,   -657,    492,
     -2624,    -44,    739,   -305,    -31,    247,    270,    213,
       -46,    -90,     43,  -1504,    931,    -61,   4045,   -863,
       389,   -386,   -130,   -374,   -583,   -800,   -900,    158,
      -455,    169,    134,   -164,     54,   -117,   -185,    -90,
      -203,    -41,   -811,  -2082,    169,    287,   -378,    -15,
       231,     83,     89,   -187,    198,     18,    178,    -18,
       527,    -40,     94,     54,     79,  -4356,    248,    162,
       -94,  -1431,    -31,  -2048,    651,   1231,   -508,  -1089,
     -1255,    766,   1673,    357,     13,   -813,  -2403,    179,
      -470,     65,   -339,    154,      9,     56,    246,     66,
     -2308,   1443,   -947,   -744,  -2473,  -1248,   -113,   1017,
      -608,    149,   -182,     41,   -524,     16,    285,   -268,
      -781,    -57,   -346,    194,    256,    -51,    107,   -484,
      -190,   -125,   -645,    487,    314,     74,   -555,  -1012,
       325,     76,    233,   -205,   -189,    -48,  -4593,   -122,
        10,    121,    -91,    108,    -49,    254,  -1662,   2500,
        87,  -1540,   -200,    287,   -329,    -50,   -401,    182,
     -1300,    689,    915,   -224,   -768,    471,   -339,    133,
       407,   -344,     99,     96,    111,   1224,  -1431,   2069,
      -282,    127,    397,   -119,   1332,  -1299,    744,   -535,
       800,    327,    874,    700,   -424,  -1596,   1365,   -651,
      -151,    113,    102,    -24,    464,    125,    911,  -1583,
      -372,    747,      2,    429,    -47,    -64,     34,   1700,
      -741,    343,    728,   -226,   1889,     78,   -515,   2827,
        77,    -66,    108,    515,     90,   2227,   -678,   1301,
      -974,    122,   -983,   2357,     64,  -1479,    186,   1436,
      -245,    204,    460,    191,   -677,   -335,   -200,   -135,
      -106,   -101,   1112,  -2733,   -641,     73,   1265,  -1281,
     -1332,   -743,    675,    129,  -1144,  -1169,    331,   -143,
       -87,    809,   -891,   -848,    246,    243,     97,   -170,
        36,  -1109,    102,   1055,  -1395,   1384,   1155,    439,
     -1549,   -300,  -2069,   1014,    187,   -782,    980,   -971,
      -345,   -583,    -66,   -138,   -317,   -124,     48,   -152,
       -98,     92,   2446,    128,  -1232,   2148,   -337,   -615,
       467,   1573,   -613,    857,    303,    422,  -1340,   -420,
       305,   -626,     94,   -496,   -386,   -129,    243,     27,
      -200,  -1373,   1468,  -2040,    151,   -675,     65,   1464,
      -432,    545,    269,   -510,    584,  -1935,    970,   -319,
      1465,    490,    263,    555,   -256,    -49,    315,   -242,
      -394,   -312,    -88,    201,   -121,   -302,    172,     49,
       234,     59,    327,    155,    199,   -187,    -41,    -74,
        52,    -31,    -59,  -5574,   -121,    282,    343,   -125,
      -200,   -575,   1328,    155,  -1928,    250,    702,     21,
     -2718,   -153,   -102,   2131,    612,    432,  -1072,   -457,
       222,    427,    144,    149,   -433,  -1573,   1337,   -650,
       176,     13,  -1273,    280,   -751,   -236,    453,    204,
     -1595,  -2896,   -272,    233,    485,     82,   -139,   -528,
      -140,   -399,    -56,   -274,   -335,    176,   -756,    243,
      2250,   -305,    721,   1711,      7,  -1230,  -1590,  -1872,
      -137,   -714,    263,  -1643,    362,   -266,   -176,     64,
       -36,    -63,    687,   -483,  -1488,    709,    929,   1349,
     -1245,    645,  -1619,    735,   -651,   1850,   1031,    159,
      -625,    838,    242,   -396,   -397,    -41,   1237,    304,
        81,    -94,   -736,    578,   1279,   1064,     81,   1900,
      -179,    224,    266,   -429,    734,    500,    995,   -882,
      1563,   1813,   -519,    758,    532,    -27,     27,    453,
};

static const int16_t cb4432m0[] = {
     -6132,   -262,   -273,  -1250,   -577,    984,   -430,   -410,
      -464,    577,   -578,   -178,    -32,    369,   -624,    267,
       -68,    474,   -480,   -225,    166,   -409,    437,   4633,
        98,  -1560,   -464,   -869,    103,    193,    461,     72,
       292,   -245,   1102,    417,   -325,    461,     74,     43,
      -120,   -213,    333,    160,   -468,   -212,     31,    -81,
      6516,    182,    201,   -212,    -66,    -49,   -266,    148,
      -108,     98,    -46,    -11,    -59,    -20,    -20,   2332,
      -294,   -560,    198,   -647,    -47,   -638,  -3877,     11,
       834,    547,     47,   2541,   -126,     -5,   -366,    339,
         3,      2,    -66,     60,   -526,    914,    321,   -658,
      3605,     59,  -2392,   -655,    384,    775,    366,    327,
       356,    386,    751,   -375,     38,   -205,    -15,   -442,
      -212,  -1241,   1913,   -421,   -755,     45,  -1637,    -36,
     -2435,   1504,  -1248,   -763,   -664,    133,   -123,    814,
       241,   -243,   -446,     66,   -131,   -213,   2036,   1294,
     -2138,    677,  -1042,   -771,    294,    371,    474,     85,
      1403,  -2618,   -478,   -537,    275,   -826,    349,     84,
       264,   -272,    -61,   -705,    175,   -972,    868,     25,
      4183,    881,   -639,   -833,   -757,  -1063,   -991,   -257,
      -137,   -619,   -285,   -454,     77,   -169,    316,    -45,
      4362,   -203,  -2132,   -424,   -820,   -503,    340,    340,
      -612,    648,      2,   -342,     81,    630,  -1518,    235,
       216,    210,    665,    231,    130,   -879,     38,    675,
      -136,    -48,    540,   -234,   -152,   -169,  -5745,   -294,
       -24,      8,   -129,     -8,    308,    -14,    -16,    147,
        62,     70,    248,  -2014,     76,   -190,   -328,  -1899,
      -353,   -140,    836,   -365,   -112,  -3945,   -736,    467,
      -258,    601,    617,     74,     62,    394,    180,   1151,
      -810,     36,    457,    406,     75,     -8,  -5004,   2335,
      -108,   -123,    299,   -335,    112,   -499,   -268,   -185,
       461,    208,    -38,   -164,    764,   -504,    272,   4853,
       396,    265,  -1133,   -433,    769,   -458,   1005,    645,
        81,   -172,    385,    -56,   -130,   -393,    128,    -73,
        31,   2038,    127,   -436,    123,  -2525,    282,   -448,
      -489,   -295,    -14,     85,   -462,    -49,    262,    -93,
       238,   -148,  -3953,   -414,   -259,     33,   -892,    459,
     -2186,     60,    444,   -610,    844,   -486,   -299,    219,
      -433,     19,  -1183,    276,    -29,    388,   3327,    102,
      -914,   -221,    486,   -892,   -550,    190,    151,   -141,
      -336,    194,   -242,   -224,    405,    879,   1600,    349,
     -2082,    -38,   -514,     18,  -3574,    161,   -142,    -38,
     -1815,    540,    228,     33,    164,   1074,      4,   -278,
       -58,   4085,   -295,   -795,     31,    494,    555,   -250,
        22,   -202,   -312,     92,    109,   -238,   -448,   -622,
     -1511,  -4346,   -417,   -706,     37,   1157,    -96,   -199,
       -59,    285,    -43,   -217,    -22,    -95,    103,   2242,
       244,     45,    -74,     -7,    366,    -79,   -359,   -286,
       188,    -14,     34,     49,    245,   -108,    -84,     88,
      -333,   -216,    -79,     15,  -5710,    -36,   -102,   -552,
      -213,     -8,   -356,    515,    212,   -265,     80,    316,
     -1163,   -561,   -517,   -714,   -375,  -4176,     73,   -666,
      -363,    -28,   1248,    -68,    478,   2648,    642,   -710,
      -555,   -744,   -166,   -744,   -596,    138,    499,     59,
       453,   -583,   -290,    -11,    -48,   4174,   -252,    -74,
       -78,    -62,    449,   -265,   -818,   -357,    171,   -513,
        72,    106,    -45,    649,    145,   5558,    -60,   -136,
        69,   -172,   -134,    -66,    -68,    100,    683,   -427,
       795,   -407,    345,   4930,   -838,    361,    279,   -190,
       173,   -341,     -9,    722,    383,   -140,    123,   -269,
       154,     31,    335,   -465,    311,     46,   4535,   -131,
        90,    151,    287,    -11,   -526,   -614,  -2253,   -321,
       -93,   -550,   -128,     25,    303,   -139,     19,      0,
     -3255,   -161,    276,    103,   -245,   -515,    816,  -1042,
     -1449,   1693,   -627,   1287,   -837,   -727,    -80,   -478,
      -337,    116,      1,   -270,   -567,   -311,   -407,  -1656,
      -216,    196,   3004,   -285,   -521,   1510,   1818,   1392,
        42,    -44,   -244,   -349,    959,   -183,     25,     58,
        43,   -345,   -310,  -8192,    -84,    311,    -60,   -348,
       125,     33,    -79,   -138,     88,    138,   -121,    -37,
      -211,   -118,   -142,    -37,   -132,    181,    162,  -1423,
      1781,  -3453,   1261,    134,    670,   1218,    761,    292,
      -146,   -825,    672,    737,    293,    433,    245,   -392,
        46,    598,    257,   -234,  -1201,    718,  -4549,   -573,
      -696,   -224,    -85,     75,   -268,    244,   1817,    341,
      -166,    436,   -386,  -1247,     22,   -112,    -55,   -451,
       106,    388,    -32,   -254,  -2400,   -373,    892,    334,
     -4114,   -307,   -107,   -316,     41,   -214,   -403,    -56,
      -469,   -246,    120,   -237,    266,     43,   3257,  -3925,
       291,    239,    752,   -411,    162,    437,    159,    256,
        37,     71,    -79,   -136,   -475,    124,   -208,   -216,
      -245,     16,     40,   -459,  -4320,    340,  -1462,    914,
        10,    490,    436,    162,    271,   -238,    -38,   2219,
        25,   -141,    405,    107,    235,    282,    -55,     -7,
     -3429,    565,  -1095,   -678,   1979,    233,   -874,    592,
      -474,    680,    402,   -738,     21,    274,   -321,    655,
      -348,   -546,    510,     62,     23,   4722,    572,    423,
      -256,    473,   1240,   -997,   -899,    -53,    -73,    332,
      -902,   -771,   -335,      0,    769,   -587,    592,   -703,
      -600,    -77,    -94,   -207,    792,   -133,   -758,    500,
       -14,    330,     22,   -281,  -5460,    152,    607,    337,
       -39,   -118,    -80,    -51,    228,     65,     -6,    540,
     -3515,  -1712,   -449,   -157,   -164,   -195,  -1655,  -1285,
        90,   -517,   -116,     11,   1402,   -162,    -64,   -103,
        46,    302,     37,     71,   2903,   2952,    780,   -487,
      -297,   -426,   -369,    150,   -129,   -233,    813,   1639,
       190,    310,   -311,    320,     94,   -247,   1484,    -32,
        70,   -220,    560,    372,     54,    205,     96,  -3567,
      -680,   1683,  -2377,     17,    548,   -266,    257,    656,
       331,    205,   -121,   -814,    139,    326,   -370,    625,
      2035,    818,    775,  -1165,    -41,  -4258,     41,   1109,
       984,   -885,    -43,   -314,    204,    204,     95,    407,
      -351,    101,    133,   -929,    899,     -6,    384,   -177,
      -330,    240,     90,     78,   -318,   -455,     -5,   -365,
       -61,    -80,    -72,  -4850,   -338,   -384,     30,    181,
     -2721,   -767,   3217,    453,   -226,   -582,    283,    135,
      -103,    265,    494,  -1444,   -120,     70,   -976,    -67,
       -90,    660,    366,   -609,     32,    205,     73,     51,
       346,     -6,   -120,    -10,    300,     32,    270,    139,
       -55,    453,   5712,    353,   -145,    176,   -168,    216,
       205,    -30,   -304,   1085,    221,    464,   -426,   1662,
     -1397,  -1114,    301,  -1058,   3553,   -388,    743,    696,
      -893,   -296,    -57,   -254,   -251,   -178,    417,     82,
      -988,  -3566,   2171,  -1312,   -954,    -23,  -1349,    480,
       566,     24,   -643,   -292,    -68,    303,     73,    -81,
       296,      7,    371,     94,   1718,    498,   -774,    857,
      1014,    358,    436,    210,  -3481,   -202,   -416,     59,
      1987,    137,   -476,     32,   -627,    193,    368,     -3,
      -290,  -3035,   -352,   -455,   -609,   -175,     -5,   -600,
      -181,   -249,  -2551,    226,    105,   -249,   1851,    -86,
     -1203,    214,    -57,   -505,   -522,   -247,   -154,    -40,
       -17,   -523,    333,  -1777,   -354,  -1568,  -3492,   1032,
      1577,     90,    153,    534,   -106,   -538,    102,      3,
      -198,    -99,    -23,    835,   3495,  -1099,     44,    732,
      -350,    926,   -472,    533,   1529,     54,   -844,   1295,
       573,    414,    -23,    -71,    279,   -891,    287,    126,
      1456,    973,    456,   1608,   -646,  -1244,    452,    651,
       694,    855,   -235,   -503,    745,   -544,  -3512,   -138,
       678,    473,    220,   -273,     -9,    265,  -1874,    397,
      1196,    284,   -963,    298,    318,  -2309,   -162,    322,
     -1250,    -16,  -1004,     -5,   2800,    -64,     72,   -482,
      -162,   -412,  -2922,    774,   -335,    238,  -1144,   -134,
      1428,    558,   1969,   -659,    902,  -1698,    793,   -858,
      -613,    998,    253,   -336,   -348,    -80,   -117,   -264,
       355,    808,    784,   -559,   2030,   1952,   -244,  -1130,
      -986,   1883,   1171,   -493,   -326,   -880,   2588,   -243,
      -204,    194,   -172,    -65,   2026,    424,    587,   -317,
      2550,   -601,    203,   -669,    475,   -676,  -1492,     27,
        41,  -1078,   -299,   -630,    177,   -164,   -429,   -246,
      -357,   1191,   -867,  -1363,   1621,   -110,    916,    217,
     -1269,    622,   -434,  -1113,    888,    -41,   1020,  -1774,
        46,     80,   -483,   -892,    -61,   -472,    193,   -192,
      2000,   -103,    740,   -223,   2493,    422,   2508,   -331,
       470,  -1233,     47,    595,    795,   -465,   -320,   -163,
       128,      6,   -209,    603,    536,   -416,  -1455,    -87,
     -1191,    -98,   -281,   1003,   1421,    388,   1163,  -1146,
       -81,   -299,   2518,  -1072,    207,   -443,    506,   -220,
      -346,     98,   2119,   -416,  -2268,   -498,    109,  -1342,
      -335,   1125,   -712,    156,  -1088,  -2092,   1164,   -500,
       113,    -17,    551,   -199,    262,    -27,   -692,   -629,
       204,  -1448,  -1606,  -1554,    289,    382,   -691,   1229,
       414,  -1746,  -1198,   1113,   -386,    310,   1354,    -12,
      -284,   -569,     46,   -558,   1495,    172,   -899,    617,
       827,   -365,    100,   1008,    136,   2111,     10,   2320,
      -291,    364,   -401,   -408,   -528,   -612,    127,   1218,
      -384,    129,  -1603,    438,   1029,   2536,   -150,  -1432,
      -856,   1068,    773,   -762,   -808,    676,   -693,    404,
       145,      4,     27,   -148,   -318,  -1019,   -277,   1404,
       880,  -1135,    861,    903,    739,    303,    139,   1918,
      -952,    801,   -306,  -2439,     -3,    442,   -590,  -1034,
       178,    430,    153,   1853,   1997,    742,   1745,   -608,
      -237,    160,    523,    950,     82,  -1468,  -1592,    807,
       719,    618,    319,     57,    235,    287,   1344,    -50,
       324,   -182,   -365,   -381,   -377,   1989,    147,   -573,
      1246,   1769,   -473,   -178,    961,  -1297,   -750,  -1428,
     -1246,    789,    158,    612,     17,   -292,   -227,   -142,
        64,     51,    -16,   -301,   -287,    -60,   -404,   -267,
       109,   -108,    189,   -438,     48,     95,  -5059,    -42,
};

static const int16_t cb4432m1[] = {
      7567,    273,    268,    -74,    201,    274,   -149,   -146,
      -262,    243,   -273,     63,   -127,    135,   -160,    231,
       120,    209,    -91,   -218,    -38,  -1206,   -468,   -159,
       278,    536,   -995,    -60,     22,   1041,   -550,   -121,
      -241,   -664,    427,   -416,  -1395,   -732,    152,   3247,
       -67,   -154,  -2430,    421,   -405,   -558,    -73,  -2887,
      -272,    -60,    365,    745,    287,   -622,  -1103,    412,
       266,     82,     61,  -2172,   -379,    529,   -125,  -1482,
       319,    643,    222,   -508,   2451,   -970,     71,    237,
      -280,    202,    983,   -223,   -307,   -130,    217,   3209,
        49,    -30,    275,    -12,   -260,  -3959,   1219,   -104,
     -2700,   -201,     54,    851,   -590,    691,   -254,    408,
       296,    -48,   -364,    216,     16,    220,   -415,    218,
        83,     43,  -4032,  -1359,     25,     15,   -279,  -2092,
       794,   -433,   -195,   -162,    606,    166,     87,   -316,
       508,    242,   -359,    687,   -178,     14,  -2969,   -500,
     -1041,   3234,    679,    170,   -791,   -127,   -630,    -16,
       -19,    181,     -2,   -185,   -172,    -88,   -118,   -167,
       128,    121,    239,    321,   -125,    217,  -7260,   -157,
      -161,   -347,   -257,    102,  -1181,     71,   -379,   -205,
      -268,    144,   -174,   -106,    305,     23,    -47,    202,
      -110,    660,     54,  -2963,   -119,  -1371,  -2823,   1171,
      -726,    690,    534,    161,   -435,    753,     58,    227,
       241,    138,    -76,    473,    193,  -1926,  -2183,  -2526,
     -1428,    284,  -1270,    336,  -1458,    208,     41,   -356,
       345,    153,   -273,   -166,    500,     42,    120,    -35,
       -81,     56,   1747,  -3050,  -2029,   -764,   -947,    888,
       422,    374,    143,   -318,   -225,    604,    343,    -91,
      1626,     75,   -211,    160,   -667,   -195,     38,   -446,
     -1269,   -108,   -959,   -616,   -530,    554,   2865,   -156,
      -358,   -429,   -261,     23,    511,    340,   -548,   2347,
       105,     12,    -32,    164,    170,   -168,    268,   2587,
      3511,    612,    329,    159,    456,    273,   -452,    168,
      -394,    799,    -58,    160,   -480,   -257,    242,    167,
        46,  -1433,  -1631,     50,    852,    509,    864,   -381,
      -306,   -698,    261,   -702,    -19,   4113,    -38,   -153,
       -11,    405,   -441,   -120,    139,   -265,    225,    342,
       199,   2085,    237,    278,    252,   1537,    119,    182,
      -174,   -193,   2486,     87,   2903,   -311,   -304,    273,
      -217,   -256,   -264,   -675,   -819,   -188,   -615,  -1183,
       495,   -154,   -687,   2423,    197,    -63,   -146,   1151,
       896,  -1129,    -58,   1114,  -1644,   1219,   -648,    -71,
      -130,  -2643,    533,   -218,   3942,    -83,    208,   -724,
       198,   -643,    590,   -944,    -56,   -420,    115,     23,
      -414,   -144,    295,    219,    -36,    393,   -174,     91,
       290,  -7066,    158,   -275,    -70,   -119,     -1,    302,
      -262,    -73,    -61,    110,   -196,    -25,     87,   -446,
      -159,     -6,   -107,    115,  -7562,      5,    -33,    284,
      -106,     34,   -140,    160,   -304,   -272,   -169,     25,
        93,   -205,     28,    169,   -165,    -34,    -50,    343,
      2204,   1440,    817,  -1921,   -590,   -527,     81,   -364,
      -354,    163,  -1058,   1977,    244,    -75,   1201,   -207,
       293,   -289,   -105,   -121,   3588,    925,     -2,   -201,
      -860,    917,    100,    265,   -200,    -44,   -529,    351,
      -579,   -103,    186,  -3622,     52,    181,   -259,   -411,
        -4,   -328,    380,    517,    306,     57,    340,    -65,
      -263,   -311,    494,    326,  -6136,    747,   -141,    296,
       217,     -2,   -125,      8,    -88,    254,  -2934,   -259,
       946,   -905,    653,    436,   3393,   -147,   -157,     27,
       166,    299,      8,    -16,    643,    114,    217,     57,
       -21,   -298,     19,    129,   1721,   -134,   2337,    781,
      -483,   -748,    118,   -330,   -226,  -3762,    222,   -417,
      -154,    -24,    -13,   1138,    210,    357,   -122,    257,
      -369,    863,     13,   -320,   -439,   -433,   3469,   -869,
       116,  -2772,    202,   1065,   -130,   -287,    142,   -288,
        54,    318,    131,    -16,     84,    238,   -361,    934,
      1341,     37,    130,   -412,    146,   -724,     -3,   -823,
      2555,  -1263,     11,   -147,   3164,    -83,    -39,   -127,
       258,     26,  -1181,   3339,   -676,    -30,    -56,    691,
       867,    715,   -903,    293,   -205,   -392,    -22,    529,
       -76,   2201,    433,    134,   1338,    -18,     85,   3128,
        33,    924,    257,   1662,   -769,    321,   -449,   -374,
       -58,   -597,  -1670,     97,    222,   -998,    404,   -155,
       133,    358,   -250,   -125,    163,   6027,   -228,   -116,
       -61,   -878,   -693,    710,   -516,   -191,    -27,    443,
        83,   -174,   -695,   -117,   -107,    -53,   -142,     92,
      -145,   -114,    -62,   -710,  -3192,   -872,   3284,   -521,
       -36,   -948,    252,   -253,   -143,    260,    109,    -24,
       262,   -169,   -196,    195,    105,     27,   -135,   1722,
      1862,   -513,   -270,   -144,   -414,    -59,     91,   -288,
       -96,    -56,   -204,    273,    170,   -171,    -62,  -4993,
      -125,    -67,    -50,    226,   -275,    600,    105,   -217,
      -450,    -87,    -20,   -353,     24,    -74,    167,   1881,
     -4260,   -144,     48,     92,    187,    319,    341,     22,
        -4,    405,    147,    237,   -120,    122,   -237,     56,
      -515,   -153,    333,    834,    401,    210,  -5516,      7,
       127,    147,   -140,   -479,    -26,  -1669,    -21,   -147,
        60,    387,    565,   -140,  -5827,   -269,  -1119,   -324,
       118,   -199,    -11,    105,    -49,    150,   -148,    178,
       182,    162,    150,     68,   -227,      3,    221,   -330,
       -23,     65,   6262,     71,     48,    -41,    -10,     -1,
       -44,   -255,    -50,   -138,   -109,    -54,    -31,    492,
      -214,    239,   -194,     35,  -6348,   -148,      9,     25,
      -123,     84,   -448,    241,    148,    -35,     52,     35,
         7,     99,    -16,     57,    -43,   -256,   3336,    373,
       211,   -513,   2328,     86,   -274,    386,     74,   -174,
       624,  -1037,  -1154,     36,   -209,  -1028,   -101,   -412,
      -103,   -267,   -107,   -126,    163,   -394,  -1097,   -100,
     -1575,   -542,   3326,  -2149,    547,    626,   -278,   -414,
      -781,    486,   -186,   -159,    138,   -187,   -821,    419,
       393,  -4266,    828,    431,     86,    745,   1313,   1484,
       260,     52,    163,   -455,  -1071,    186,    522,    288,
       421,     18,     97,   1267,    200,   2637,   -189,    729,
       746,    203,   -639,   -843,   2164,    671,     84,  -2384,
       430,   -161,    404,    166,    -33,    -17,    591,   -227,
     -3849,   1579,    175,   -718,     99,   -410,   -844,   -239,
        32,    212,    163,    480,    843,   -379,   -621,   -317,
      -424,    113,   -262,     44,    -93,    529,    144,   -218,
       140,   3257,   -575,  -2697,    144,    -83,   -186,    -44,
       977,    153,   -230,  -1530,    234,    212,    212,    331,
       412,   -125,     -3,    422,   -329,  -2181,   1406,    363,
       -90,    -86,    329,   -267,  -4462,   -189,    -87,    154,
        66,   -200,     37,     80,   -109,   -199,    125,   1983,
       260,   -438,  -2417,   3259,   -974,    453,     41,    -77,
      -538,   1123,    119,    120,    254,   -239,   -134,     33,
      -384,   -407,     27,    465,   1810,   -910,    980,    -15,
     -1307,   -919,   1880,   -327,   -303,   -198,    149,    413,
      2176,   2269,   -707,    343,    360,    169,    148,    182,
       104,    163,    857,    291,   -153,    303,   -679,   -386,
      -868,   2283,   -320,    167,   3257,   1741,    338,    467,
       209,    207,    834,   -226,   -479,   -120,   1674,    -61,
       696,    -93,  -1327,   2176,    716,    402,   1688,   2219,
      -339,    779,    366,    358,    241,   -695,   -272,   -136,
       -48,     36,   -269,    862,   -616,   -118,  -2028,   1678,
      1971,    115,    290,     71,   -765,     31,  -2874,    122,
        13,   -424,   -281,   -320,    233,  -1032,     40,   -186,
      1208,    274,  -2310,  -1594,    289,    230,   1264,    962,
      -310,     23,   -548,     12,    -38,  -2734,    664,     37,
       346,   -620,    266,    -98,     82,   2369,    963,  -1391,
      -451,    833,     82,    175,    448,   1874,    345,   -440,
       155,    130,     94,    326,   3223,    234,   -163,   -384,
      -354,   -539,    827,     -9,    530,   -226,    -21,    332,
     -2298,   3221,   1470,   -282,   -800,    231,    314,   -998,
     -1051,   -648,   -434,    743,    -72,    119,     91,    414,
       379,   1370,   -637,   -998,    851,  -2904,   -266,  -1652,
     -1356,  -1339,  -1679,   -181,    245,    731,   -231,     -2,
       221,   -182,   -325,   -411,    346,    246,  -2629,   1736,
      -361,     24,    229,   1168,    747,    309,    425,   -128,
      -320,   -496,    109,   1496,    -70,   -797,     37,   -271,
       -39,    906,    -62,   -194,   1753,    311,    689,   1354,
     -1035,   -973,   -438,   1166,   2197,    -99,   -380,   -274,
     -1565,    447,    100,    349,    485,    653,    744,     50,
      -582,   -123,  -1396,    156,    -27,    349,  -1067,  -1382,
      1388,  -1061,   -554,    894,    -80,   -783,  -1500,   -736,
       897,   1158,  -1386,    -40,   -280,   -819,   -672,   -895,
       994,   -308,   -466,   -578,    455,  -1536,    879,   -448,
       542,   1508,    850,  -2465,    816,    641,   -427,    310,
      -168,    -41,   -908,   -302,   1513,    -29,  -1144,    588,
     -1703,   1144,   2623,     90,    284,    866,    335,   -351,
       419,   -745,    879,   -183,   -824,  -1713,    -34,    -15,
      -913,     37,   -460,    778,   2130,   -145,   -153,   1761,
      1420,   -243,    -32,   -877,    140,   -700,    612,  -2053,
       321,    -78,   -165,    200,    526,  -1002,   2176,  -1022,
      1436,    298,    -21,  -1378,    515,    304,    974,   1722,
      2054,    661,    425,    282,    471,    438,     70,    169,
      1587,  -2076,    -40,   -702,    264,   -146,  -1499,   -863,
     -1775,  -1059,   -490,     92,    631,  -1194,  -1031,    335,
       257,  -1299,    241,   -270,   -325,   -322,    -37,      0,
      -685,    897,    984,   -909,   1556,   1281,   1367,  -1269,
     -1591,    415,  -1156,   -374,   -110,   1552,   -695,     74,
      -167,   -473,   1421,   -611,    175,   1521,   1322,    436,
      1969,   -787,   1041,   -730,   -598,    188,   -794,   -531,
     -2198,   -317,    -11,     -8,   -407,    198,  -1180,  -1675,
       174,    981,    467,   -149,   -890,    263,   1030,   -121,
      2147,   -135,   1975,   -634,    431,   -238,   -695,   1338,
      -172,    110,    147,   -334,   -726,     65,   -873,    667,
       997,  -1118,   -339,    144,   -700,   1303,   -207,   -609,
     -1617,   -765,    839,    505,    -36,    -58,  -2894,    226,
};

static const int16_t cb4448sl0[] = {
     -3850,  -1289,   -449,    -36,  -1178,  -1175,    705,    -97,
        37,   -650,    426,   -477,   -145,    124,      6,    207,
       -96,  -3145,   2917,   -260,    349,    668,    -72,      6,
       157,    -62,   -128,     20,    -82,  -1357,   -707,   -619,
      -313,   -229,   3010,   -169,    -27,    738,    971,  -1450,
       246,    154,   -163,    -15,    -93,      5,    -35,    -42,
        24,     31,    -25,   6803,     33,    -32,    -68,    -68,
       -44,    317,     43,   -106,    608,   -999,   -699,    582,
        46,   1631,    830,  -1570,  -2645,    992,   2126,    132,
      2377,   1551,    247,   -247,   1508,    -34,    162,   -275,
       -81,   -654,   -625,    125,    -33,   -210,    309,    900,
       571,    726,   2691,   2821,   -698,     60,     46,   -483,
        14,   -210,   -295,    102,    214,    226,   2622,    -82,
      -390,   1436,    107,    554,    381,   1307,   2283,   -190,
        27,    -35,   5557,    283,    103,    180,    104,    -89,
      -186,   -319,   -225,   -141,     92,      1,  -1942,   1025,
       906,     32,     -3,  -1089,    182,   -799,    483,   -368,
     -1734,   -103,   1680,    474,   -133,  -1067,   -545,   -219,
      -118,   -635,  -2559,   1002,   2554,   -640,   -505,    179,
      -344,    -81,    107,    -61,     79,    -12,    -29,    -37,
     -7574,    -92,     64,     92,   -164,    -20,    -61,    -35,
      -312,   -159,    333,  -3401,  -2596,   -344,     88,    604,
       535,    -87,    365,    -13,    -77,    131,    127,    588,
       302,    -94,   -506,   2427,     99,    304,   2653,  -1104,
      1380,    976,   -530,   -120,   -105,    293,      9,   -826,
       388,    -66,    421,   -202,    605,    675,   4060,    978,
       143,    -94,     21,  -2444,    -30,    554,    695,   2878,
       657,   -104,   -435,   -326,    307,     20,     20,    159,
       106,  -3473,    326,  -1029,   -304,    670,  -2109,   -431,
       573,    704,    293,    -45,   -169,   -119,   -191,    599,
      -910,   1976,   -165,    581,   1209,  -1689,   2365,   -370,
      -601,   -696,    374,    202,   -114,    -61,      3,    -63,
        30,    369,   -158,   -128,    198,     52,    -98,    -44,
      -323,  -5118,  -1100,   -669,   2256,     32,    -66,    206,
        65,   2801,    783,   -470,   -973,    471,   -211,    -27,
      1879,    302,   -388,   -249,    301,    537,   2761,    321,
       571,     20,    337,   1336,    522,    231,    368,   -363,
     -2065,    -57,  -2565,   -584,   -611,     56,    814,   -382,
      1671,    408,    492,     12,   1201,   1513,    247,   2165,
      -592,  -1246,   -493,  -1012,  -1330,   1251,     75,   -100,
       182,     52,    -47,    710,  -1137,   2420,   -559,    266,
      -801,   2523,   1229,    736,   -409,    -49,    269,   -174,
      -179,    -24,    348,   -661,    251,  -1039,   2647,    283,
       728,  -1850,  -2088,    196,     39,    -72,    -35,    -94,
      -540,    266,    340,   -450,    763,     -5,    113,   2618,
     -2737,   1047,   -246,   -522,   -182,    376,   1068,    203,
      1238,   -938,    211,   -308,   -395,   -629,    596,  -2634,
      1452,  -1155,     83,    -89,  -3121,    419,     40,   2691,
      -306,   -343,      4,   -347,   -725,   -117,   -315,    115,
      -215,     26,    429,   1074,  -1831,  -1850,   2609,     72,
       467,    191,    432,    857,   -186,      0,   -443,    -24,
       500,    541,     30,   2324,  -1160,  -1153,   1783,   1282,
     -1992,    101,   -108,   -108,    556,  -2012,    506,    691,
       -65,   -610,    402,    610,   1941,   -121,    942,    589,
      1879,     58,    312,  -2218,  -2056,  -2284,   -350,   -453,
       306,     38,   -579,   -185,   -101,   -196,   -150,    156,
       126,    -44,   -143,  -7923,    126,   -120,   -138,   -233,
        97,    -20,   -121,   -175,     -8,    -13,   -123,   -365,
       251,    730,   2883,    667,   -418,   -208,   2170,  -1442,
       196,   -389,   -516,    252,    -98,    525,  -1819,   -647,
      1575,    768,   1124,   -428,  -1010,  -2027,    411,   -473,
       863,    210,    908,     40,    145,     37,    192,    189,
        52,   -217,   -168,     63,     -7,    -53,   -121,     13,
      -145,      0,    -37,     61,  -7979,   -142,     32,    118,
       190,     -7,    -13,    113,     36,     31,   1461,  -2088,
      2391,   -939,    -66,    822,    280,    246,   -157,   -183,
      -433,   -356,     88,   -101,   3969,  -3388,    -84,     84,
       130,     35,     74,     37,    181,   -195,    219,    -29,
       -23,    -32,     69,    625,   2328,   -192,  -2617,    287,
       543,  -1604,    823,   -547,   -277,    764,    276,    156,
       198,     17,     84,    346,    -27,   -129,    143,    217,
       212,   -249,     20,   6449,      7,     51,   -889,    -88,
       265,    282,  -1956,   1327,  -1025,   1338,  -1709,  -1008,
       372,     57,   1404,    234,   2621,    -18,    663,    301,
         0,    167,   -372,  -2534,   1945,   -191,    198,    359,
       -43,     92,     24,  -5498,    -63,    189,     36,   -369,
       352,    381,   -205,   -144,   -119,   -267,    -60,    -10,
       387,   2388,   -155,   -450,    465,   1529,   -216,   2673,
      -146,    118,     50,    290,    147,     11,  -2912,    863,
      2184,   -689,    -44,     59,   -663,    663,    675,    295,
      1331,   -115,    -10,    -54,     -1,     31,   1699,    127,
       215,   2966,    163,    416,  -1053,   1216,    356,   1428,
      -166,   -172,     -2,   -355,   -169,   -331,    -94,    -78,
      -123,   4875,    311,     67,   1145,    397,   -288,    212,
      -344,   -290,    126,     16,    176,    485,    551,   -526,
        11,    120,   -274,     83,  -5399,   -154,  -1611,    887,
       321,   -446,   1166,   -333,    652,    310,   -895,     62,
      -219,   2840,   -753,    -34,  -3203,  -3600,    464,   -249,
       336,    297,    -85,    316,    144,    306,   -249,    149,
       112,     73,    192,    -89,     18,    197,    116,     51,
        37,    212,  -7248,    163,     31,    -52,    -31,   -101,
     -1366,   -353,   -325,  -1335,   -440,   1193,    670,  -2635,
       872,   1400,    733,    395,    122,    130,  -4146,      0,
      -382,   1486,    308,   1179,   -412,    288,    701,    161,
       147,    959,     60,     77,   -123,     17,    193,    204,
      -226,    388,    272,   -588,   -157,   2823,    735,   -745,
      2368,    359,  -1088,  -2004,  -1293,   2018,    483,    320,
     -1014,   -806,   -479,    -68,    -51,    168,    873,     27,
     -7906,     57,     19,    -23,     27,     43,    -13,    -50,
        93,     16,     29,     31,    -26,     32,    -22,    453,
      2922,  -2560,    138,    923,  -1245,   -405,     10,    228,
      -270,    145,   -192,     83,     48,    101,     77,   -226,
        36,   7792,    126,   -275,    -37,    -36,      9,     45,
       -89,     13,    148,    125,     24,   -442,    111,    -12,
       540,   1794,   3008,   1620,   -185,  -1394,   -161,    -25,
      -313,   -317,    591,   2507,    134,   -369,     77,    527,
      -619,   -236,   2681,     87,  -1060,    -34,   1894,  -1123,
       373,   -628,   1934,  -1279,  -1689,   -609,   -472,   -598,
       405,    229,    414,     12,  -2923,    -33,   -435,    -49,
      2380,    -34,   -344,  -2171,   -284,    274,    226,   -287,
       -84,    -57,     -1,   -169,    -50,    479,    707,  -2774,
      -532,   -640,   -244,     44,    458,   2519,   -590,   -472,
};

static const int16_t cb4448sl1[] = {
     -2878,   -714,   3098,    -76,    -51,    232,    118,   -780,
      -691,   -267,   -309,    105,   -179,     -5,    -84,    -11,
      -120,   -379,    458,  -3161,     65,   2994,     64,    374,
      -440,     62,   -183,     28,   -561,     73,     59,  -2565,
       445,   -451,  -1026,    437,     10,   -173,   1243,  -2278,
      -481,   -395,   -154,  -2402,    945,  -2789,    117,  -1184,
        75,   -704,    527,    478,   -589,     17,    131,   -110,
       574,  -1055,   -628,   -277,   2798,   1483,   -657,  -1996,
      -248,    194,   -284,    822,    225,   -170,    -10,   -302,
      -427,  -1700,    -90,   2756,   2124,    -49,   -964,    372,
      -637,    443,     13,    -69,    -71,    196,  -1971,    110,
      1147,    698,   1333,   1369,    527,    165,    903,    577,
     -2134,     56,    -33,     34,    183,    247,   -342,    974,
      1079,   2478,    -26,     80,  -2377,    430,  -1422,    428,
     -2187,   -469,  -1280,   -326,    -40,    188,    911,    405,
      2772,    279,   -493,    265,    768,     45,   5778,     44,
       121,   -257,   -135,    124,    263,     15,    197,   -114,
         5,    -14,     -8,    -82,   3989,   -511,    197,   2446,
      -292,   -205,   -919,    162,   -121,    145,    -40,     71,
      -105,     72,   2035,    960,   -145,   -467,   -518,    167,
     -2988,    421,    860,    320,     40,   -446,    319,    160,
       140,    511,    -55,    213,   -148,   -527,   -666,    687,
         9,     23,    344,   -156,  -4646,   -125,   -220,      9,
       134,    -25,     16,  -1319,    763,     58,  -1586,   -438,
       301,   -411,   -337,  -3398,    358,    -68,   -111,   5483,
       -36,   -456,    -94,   -116,    204,     95,     84,    -73,
      -163,     69,   -190,     64,  -3716,   -326,   1815,   -843,
       312,   -498,    684,   -641,   -766,   -104,    606,     70,
      2630,     51,   -170,  -3584,    167,    461,   -162,    132,
       496,     91,    171,    255,     48,      2,   -120,  -1196,
       534,   -431,   2669,   -403,      8,    287,   -391,   2557,
       849,    167,   -275,   -184,    605,  -3570,    113,     22,
     -2586,    668,    294,   -910,     67,   -141,      0,    418,
       271,     75,     90,   -124,    446,   -142,   -635,    631,
      -956,   1566,     25,  -1982,    790,   2770,     33,   -520,
        23,  -7488,     67,    -73,     60,     64,    -46,    -36,
        76,      3,     22,    149,     61,     34,    255,   -380,
      -284,  -2531,  -1423,   1507,   -926,  -1074,   -929,  -1430,
      -141,    165,    -80,   -268,     21,   -767,   1542,   3197,
      -191,   2014,   -304,    595,    536,   -906,   -126,   -354,
       -76,   -162,   -125,  -3139,   3197,    934,    366,   -923,
      -330,    277,   -284,   -163,    -12,    402,     15,   -146,
        20,     83,    111,    196,     23,     71,     77,   7287,
      -175,    -13,   -227,    -59,    -56,    -28,      1,    163,
       -50,     59,    635,    150,     95,   2750,    775,  -2057,
       423,  -1078,   1749,     -3,   -655,   -365,   -357,    145,
       -76,      5,    -93,    224,    150,    108,    -34,    173,
       148,   -371,     34,     48,  -8037,     65,     50,    103,
       -42,    -10,    -96,    -90,     -3,     60,     92,    -79,
       -76,    386,    114,  -1947,    833,  -1279,   -484,    217,
      3156,    226,    485,   1191,    425,     88,    -59,   -243,
      2292,   1681,    671,     62,    899,  -2453,   -100,   1039,
       713,   -104,    554,    219,    356,    963,    741,   -102,
       455,   2067,   -324,    172,     28,    772,    752,  -2351,
     -1438,   -865,  -1668,    105,   1034,   1195,     14,   -350,
      -425,   -648,   2086,   -532,    634,   1537,    -33,   -598,
      2888,    -85,    184,    158,   -164,   3339,    237,   -284,
       -54,   -246,     46,   -254,    365,     55,   1928,   -346,
      -357,    331,    139,     16,    674,   -384,    -67,  -3399,
       165,     76,    215,    137,  -3187,   -146,   -264,   -165,
     -3039,    235,   -541,   -630,    -32,    -33,   -211,    160,
      -121,   -111,  -1296,    -47,   -128,    292,  -1523,   1540,
       771,   -166,   -509,    212,   2758,   -327,   -418,   -305,
        -9,    465,   2513,    195,    -70,   -209,    -66,    127,
      -147,  -3161,   -192,   -541,   -555,    131,   -858,  -1609,
       973,   -156,  -1877,     60,   1011,     66,   -348,    912,
     -1731,  -1296,    305,   -369,   -560,    470,     46,   -863,
      -124,    -37,     40,   -395,  -4886,    -20,    221,    228,
       177,    182,     98,   -151,   -195,    854,   -194,   -374,
       301,    586,     58,   -908,    -19,  -4198,   -171,    330,
        48,  -3312,   -164,   1913,   1183,    -42,   1287,   -353,
       757,    620,   -547,    251,   -520,     59,     43,   -179,
      -191,   -131,  -2951,   -944,  -2479,    344,   -813,    104,
      -697,    -44,   -270,    198,    245,   2866,    208,    178,
      -248,     38,     19,    577,   2812,   -765,   -855,   -439,
       -60,    -30,   -352,   1521,  -1069,    457,    415,    572,
      -749,   -144,    100,    515,   -794,  -1554,   2507,   -270,
        10,     62,   2507,  -1550,    -75,     70,   2530,    562,
       132,   -141,    251,    156,    835,    102,    717,   3226,
      3327,    172,     84,   -205,    -11,    208,   -310,    164,
       -27,     11,    281,     37,   -518,     20,    -76,     82,
      5436,   -543,   -301,    112,    359,   -140,    -94,     78,
       -18,     38,   -196,    -92,     13,   -111,    -23,     30,
       -15,    -94,    101,    142,  -6455,    321,    322,     50,
      -216,   -321,    -10,   -465,    101,     45,   -585,   -969,
      1248,   -456,  -2523,   -852,  -2129,   -889,     33,  -1424,
      1462,    583,    749,    527,  -1737,   1262,   -594,    414,
      -215,  -1184,    412,   1758,  -1836,   1248,    440,   -178,
       784,   3591,   -227,     43,   -493,   -766,   -270,    150,
       151,    -56,   -110,  -2832,    -73,   -166,    470,   -179,
      -681,     71,   -114,  -2743,   -806,   -560,     63,   -244,
       -90,    182,   -143,    995,    404,    -13,  -1343,   1524,
     -2472,   1718,   -957,   1229,    458,   -395,  -2817,   -579,
       -99,    340,   1538,    684,   -492,   1156,    -45,    -65,
      -305,  -1408,   -325,   -270,   -358,   -127,     92,    -97,
       415,     85,  -4749,    173,   -296,   -203,    331,    315,
       184,    -46,   1315,   -146,    -55,    427,     37,    255,
      -209,    272,    735,    506,    105,    103,    902,  -3449,
       116,   2304,    616,  -1564,   1508,    478,    320,  -2418,
       244,   -176,    -32,    238,     92,    290,   -168,    -78,
     -3464,    270,  -1902,      2,    696,     92,  -1610,   -206,
       -49,    178,    121,     27,    119,     72,   -253,   -398,
     -2720,    -81,   -162,   -550,   2595,   1445,    249,   -104,
       218,   -310,    -95,     18,   -473,   1908,    432,   -227,
      -168,  -2725,   -240,  -1830,    199,    437,  -1392,    304,
      1461,  -2394,   -603,   -540,    769,    340,   -104,   1569,
       -21,    338,   -874,   1533,    281,    -59,    487,   2120,
       179,   -140,   -328,    -57,     63,   -110,  -1330,   -485,
     -2427,   1159,    355,    -26,  -2055,    154,   -563,   -132,
        49,   -329,   -187,    -24,    -71,  -3970,    276,    158,
        92,   -202,      7,   -422,   -578,    186,   -407,   4960,
      -595,   1027,    417,    691,     69,    133,    123,   -147,
};

static const int16_t cb4448ss0[] = {
     -2680,   2499,   -328,   2212,   1288,    -57,   -727,     76,
      -210,   -218,     41,   -343,    -26,    -38,     43,    606,
      -619,   -531,  -2082,     87,  -1127,   1282,    -23,   2272,
     -1816,    104,    -31,     85,    -22,     60,   1293,    138,
       382,    432,    489,   -372,  -1649,  -2809,  -2556,    -98,
      -232,   -233,    169,    186,     79,   1157,   2113,   -942,
       636,    877,   -601,   2277,   1411,   1165,   1029,   -613,
      -348,    -38,    -19,     45,   1318,  -1980,     12,   2762,
      1519,    184,   1980,    -49,   -270,    361,   -172,   -601,
      -196,    186,    -67,   -124,   1503,  -1011,    263,    223,
      -384,    153,    -21,  -1063,   -239,   1171,  -3501,    512,
      -162,   -180,    139,   -680,    609,  -1919,   2969,  -2321,
      -183,    194,   -558,     26,     91,    340,    -25,    -31,
       127,    662,    182,    191,  -2201,  -2603,   2252,   -523,
       277,     50,    355,    295,    -65,    355,    207,     82,
      -489,   -143,   -218,     89,    666,   -359,   2716,  -2310,
     -1912,    417,    400,     43,    110,    -93,   -142,     61,
     -3000,    454,   -153,      0,   -413,    469,    339,    318,
      -197,     75,    -80,   2894,   -129,     82,   1431,   1183,
       429,  -1556,  -1339,  -1573,    -92,   -911,   -230,    -12,
        -4,   -145,   -388,   -419,     -5,   -241,   7120,    165,
      -125,   -122,    126,   -150,    109,   -146,    -61,    -49,
        47,     70,    -43,     40,   1867,   1473,  -1278,   1229,
     -2256,    -90,     10,   -744,   1196,   -109,    402,    258,
       690,    -74,     26,   1294,  -1079,    142,  -2384,   -324,
     -1696,  -2741,    321,     66,     83,   -127,   -131,    156,
       166,    135,   1812,  -3445,     10,    535,   -547,    481,
     -2243,    287,   -335,    218,    195,     -1,    -25,    -94,
       195,   1433,  -1428,  -1444,    520,    219,   3363,   -388,
      -807,   -454,    -29,    316,    125,    159,   -144,   -156,
      -317,    752,    256,    216,    340,    488,    147,  -5662,
        55,   -110,    387,   -102,   -211,    -66,    -26,   3688,
      -172,  -2366,   -244,     -5,    353,     11,    503,     88,
       227,     69,   -240,   -187,    -58,   -389,  -1783,  -1427,
        20,   -618,    544,  -1337,    628,  -3180,    708,   -538,
      -423,    115,     49,   -161,    184,   -682,   -223,    689,
      1299,   -891,  -1073,  -1228,   -305,     47,  -2221,  -1559,
       598,   -380,    166,    143,   -366,    287,   2122,    509,
       629,    235,   1523,   2900,   -640,   -425,   -462,   -231,
       -53,    -27,   -263,   2090,  -1892,  -1147,    -42,    866,
     -2301,    461,  -1082,   -625,    -85,    148,    229,    -25,
        85,     53,    259,    -81,  -4072,   2577,    -12,     -7,
       335,   -151,   -691,   -137,     98,    372,    -37,   -192,
       -17,   3318,   -558,   2064,    396,    258,  -1067,    229,
      1122,    298,    -25,     40,     27,   -134,   -166,   -247,
     -2010,   -440,   1066,  -1400,  -3454,   -289,    428,    629,
      -158,    126,    129,    183,    -12,   -171,   -120,    421,
      -445,     66,   -900,   3680,   1583,   1985,     25,    229,
      -535,     -1,     45,    207,    -54,    -30,   1581,   -938,
      -703,    405,    878,   -398,  -1069,   1748,  -2587,  -1419,
      -375,   -441,   -487,    109,     21,  -1399,    648,   -271,
      -701,    635,    115,   -138,   -458,   -600,  -1891,    585,
       420,  -1916,   1135,      7,   1584,    910,   4267,   1328,
       279,    395,    -35,    -99,   -168,    503,    216,   -126,
       211,    212,    193,  -2205,    491,    696,     41,    283,
       649,  -3425,   -999,    200,    625,   -261,   -378,    -47,
       -15,    -30,  -1262,   1700,  -2191,    196,  -1773,   -251,
        84,    498,   -261,    150,    451,     41,    336,     27,
       -56,    562,    -86,     -1,  -1073,   1461,   2148,  -2961,
      -326,   -257,    440,    -42,    -48,   -320,    122,     94,
     -1267,   -830,   2810,    -94,   -201,    990,   2415,   -740,
      -166,   -267,   -157,     68,    301,    290,     65,    931,
      1969,   -170,      6,    149,   -272,   -105,    542,    -11,
     -3888,    105,    305,    333,    -14,    -39,   1944,  -1164,
        88,   3829,  -1190,   -535,   -644,   -330,    509,    -93,
      -314,   -228,   -294,   -342,    -26,   1143,  -2371,   -400,
        74,    101,    -68,   -583,  -1091,   3367,   1146,   -638,
      -436,    136,     41,    -92,   1518,   2818,  -2214,  -2044,
       636,     -2,     79,   -508,    676,   -439,   -358,   -198,
       -69,    271,     59,   1638,    468,     97,    264,     -8,
     -5152,   -152,    152,    252,    401,   -375,    -17,   -132,
        51,     63,    633,   -180,    367,    111,    -18,     15,
       -52,    128,    -54,     11,     96,   -122,    -26,  -7257,
       -42,  -1221,   -688,    197,   -107,   -217,    141,   -289,
       141,    269,    439,   -747,  -3743,   2098,    226,    137,
        26,  -1645,  -1735,    -80,     43,   -216,    245,    544,
       157,     40,    238,    237,   -989,    379,     88,    639,
     -1335,   1542,   1147,   -510,   1008,   -134,   -626,    696,
     -3034,    334,   -689,    115,   -168,     39,   1750,   -649,
      -233,    -99,   -231,    515,    112,    -11,   -162,   -133,
      -138,   -486,  -4137,    204,   -102,    867,  -1030,    219,
      -254,  -2787,   -128,    961,  -2837,   -482,   -195,    691,
      -170,   -178,    164,    -54,  -2008,   -116,     74,    398,
       -96,   -472,    407,     27,    287,    628,     97,  -1425,
     -3923,      6,    117,  -1081,    930,    396,    452,     87,
      -441,   -155,   -738,   1089,   2128,  -3133,    -21,   -622,
       -48,   -127,    506,    985,   -200,   3361,    184,   -522,
        41,    503,    209,     14,    -96,    791,   1263,    289,
      -101,  -1728,  -1073,   -517,   4156,   -685,    214,   -721,
      -608,   -102,   -295,   -114,    126,   -340,    109,     88,
     -1588,     82,   -549,   -376,     76,     84,   -210,     59,
      -130,    321,    678,   4704,    564,     -1,    100,    325,
      -296,    256,   -936,   -886,  -1088,   -191,    476,  -3684,
      1359,     12,   -397,    -70,    -17,     58,    569,    353,
       821,    -77,    253,    153,   5697,   -171,    181,      3,
       -90,   -413,   -265,    142,     62,    959,    151,   -103,
       845,   -340,   -280,   -733,   -592,   -244,   2534,   3089,
       935,   -393,   -105,    145,   -666,  -2865,  -1532,    717,
      2867,    206,   -800,   -125,    -34,   -189,   -138,     42,
       189,   -141,    107,  -3030,  -3795,   -494,    108,   -149,
       382,    760,   -142,    337,   -844,    228,    124,    232,
       -23,     -1,   2298,    750,    636,   -353,    157,    676,
      -191,    812,   3434,    759,    543,    -17,   -213,    -95,
       316,   -693,   -604,  -1059,     32,   -496,  -3334,   -272,
      -104,   -495,   -130,    627,   -376,     74,   -599,     55,
     -2185,   -968,    517,   -343,     21,   -249,   -963,    268,
      3339,    239,    771,   -134,     42,    231,     75,   1633,
       331,   -125,   -414,    457,   -316,    111,   -475,    363,
      -687,  -4105,    469,    443,    113,     72,   1498,    406,
       915,   -229,    564,   -377,     89,    137,     39,      2,
       -29,   -416,   -149,   3598,   -253,     12,  -1015,   3016,
       916,   -726,  -2286,    -99,  -1085,   -238,    690,    -44,
       -51,   -115,     25,     56,   -905,  -3050,  -1121,    -24,
     -2160,  -1424,   1009,   -180,   -424,    188,   -417,    -66,
       -86,     74,    -28,   -225,   -937,    -90,    251,  -1850,
      1939,   1843,    833,  -1879,   -192,   -318,    103,   -363,
       -22,    -57,  -2833,   -118,   -277,    -98,    -85,   -495,
      -874,   3027,   -141,  -1490,   -172,   -266,    -32,    190,
       -12,   -364,   -380,  -2107,    249,   -217,    662,   -584,
        89,   -563,   1153,  -3091,   -656,    463,    144,    -26,
};

static const int16_t cb4448ss1[] = {
      6475,    -60,    162,     42,    -71,     50,    -85,   -278,
       -14,    -60,    -53,    132,     28,    -65,    -71,    -62,
         6,    119,    195,   -140,     28,     37,   -603,  -4956,
      -290,    700,   -241,     11,   -301,    297,  -1009,    468,
       885,    192,     40,    495,    846,    -28,    201,   -255,
       927,   -644,   2424,   2882,    -82,  -1764,   1077,    315,
       946,    843,    399,    176,    567,    546,    377,    283,
      2469,  -1815,    -65,     12,    422,   -368,   -639,   -493,
     -5606,     84,    122,    241,    267,     -8,   -257,    -23,
      -220,   -118,    139,  -1582,   -218,  -2436,   2539,   -270,
       146,   -262,   -489,   1551,    604,   -225,    363,    234,
      -110,   -166,   1058,   2342,   1950,     43,   2362,  -1189,
       492,    172,   -296,    159,   -430,   -311,   -135,   -182,
        77,   -444,  -1995,   -855,   2080,   -457,    389,    872,
      2549,    935,   -128,    519,   -374,    310,     96,    119,
      -263,   1981,  -1019,   -628,    212,   -173,  -2292,   1066,
     -1985,   -426,    115,   -746,    147,      3,     94,    195,
     -1762,   1713,   -337,   1884,   -123,   -480,     95,    777,
      1073,   2117,   -969,     16,     11,    123,    374,   -394,
     -1419,    829,   1657,   1294,  -2770,    286,    813,   -290,
      -115,    111,    312,     53,     44,    896,     34,  -2288,
     -3443,  -2053,     98,    293,    429,   -168,     74,    -58,
       221,   -383,    100,     63,   1925,  -1207,    199,     94,
       -94,   3060,   1825,    611,    292,   -141,    382,    141,
       105,   -151,      0,   1448,   -267,    206,    932,   -682,
       251,   -183,   1080,    161,   4334,   -397,    525,    -91,
       127,   -104,    921,  -2282,   -274,  -1070,    387,   -312,
      1380,   2769,   -554,   1501,   -921,    102,   -183,   -104,
       -66,  -1656,   2049,    122,  -2271,     84,   -276,   -204,
       353,    380,   -414,  -1757,  -1035,   -318,   -130,    -10,
       163,   -471,   2425,   2864,  -1892,    294,    817,    754,
       277,    -29,   -214,    -39,   -312,    -57,    -54,    986,
      2286,   -574,     34,   -641,   3783,    214,   -399,   -155,
        38,   -148,    -42,    -89,     97,    -17,  -2192,    729,
       272,   1168,  -3593,    150,     96,   -473,    211,    -60,
       136,    -26,    142,   -285,     93,    666,   -465,   -181,
      2016,   -338,  -2186,  -2608,   -449,    107,    -18,     45,
        24,    245,   -119,    244,    442,   1509,    158,    242,
       169,    -16,   -221,    104,    115,     16,   -217,     23,
       -25,    130,   4076,    662,   -315,   3068,    -35,     36,
      2785,   -223,   -528,   -157,     43,    186,   -514,   -240,
        15,   -245,    520,   -110,   -781,   -641,    294,    -20,
        64,    -44,    400,   -109,   4756,   1334,   -421,   -195,
       130,  -2182,     64,   -897,  -1423,   3081,   -523,    378,
      -164,    968,    593,   -192,     71,    114,   -143,    -10,
      1961,  -3141,   3173,    -39,   -110,    -57,    144,    -68,
      -429,     30,    -10,    467,    159,     40,     67,    260,
       814,   -168,   -836,   1073,  -3562,   1786,  -1205,   -148,
      -105,     94,      5,    143,    138,     18,  -1384,     20,
       635,   -126,    -71,    -87,   -320,   -407,    559,   -151,
      1312,  -4395,   -755,   -263,    -77,   1657,    699,    426,
       469,   -469,    253,    -80,    317,    -71,    268,   3592,
     -2051,    304,    157,     43,   1872,   3794,  -1537,   1226,
      -159,   -335,    340,   -385,   -253,   -195,     21,    106,
       -31,   -187,    -63,  -2771,    446,   -708,    202,   -186,
       548,    832,   1757,  -1274,   1234,   -756,   -160,     76,
       -82,     64,   2169,     13,   -849,    244,  -2486,  -2138,
       844,   -178,    270,    297,    150,    202,    -41,   -188,
       121,  -1272,    371,   -319,   2848,   -469,  -2059,   1290,
      -457,   -380,    690,    148,    -51,   -340,    113,     57,
     -1259,   -396,  -1404,    336,   -511,    576,   4441,    124,
       143,   -483,     85,    138,    196,     38,   -188,   1177,
      -764,  -2067,    820,   -264,    218,   -300,   -501,   -230,
     -2529,   1349,  -1606,   -199,     92,    -55,  -1324,   -702,
      2078,  -1269,    414,    -50,     29,     12,     87,   -593,
       217,    -82,     94,  -2392,    308,   2315,   2188,    768,
     -1103,    -77,    579,   1706,   -826,   -224,   -297,    145,
      -640,    570,    146,   -199,   1187,   -872,    327,   -310,
      -122,    -23,    -13,    808,   -139,  -4425,   -670,    412,
        -4,    -70,   -162,  -1056,    685,   -312,   -957,    339,
       893,   -252,   4040,   -105,     76,    993,    281,    -79,
      -139,    168,   -298,    795,  -1107,    395,    386,   -524,
      1052,  -2341,   2537,    474,    726,  -1028,   -357,    -52,
       115,     -9,   1349,  -2240,    785,   2751,     77,    922,
       385,   -539,   -148,    410,    251,    -70,    199,     51,
      1728,   -206,   1181,   1182,   1388,   -791,    121,     -3,
         8,   -147,    -95,    101,    886,  -2412,     19,   2401,
      -116,    718,   -592,   -221,    724,    -33,    690,   -180,
       868,  -3330,    377,   -336,    128,    267,  -2075,   2848,
      2994,   -300,      3,   -153,     41,   -456,     38,    -31,
       309,   -106,    -92,    -14,     96,    672,    634,    207,
      1556,    438,  -2147,    282,   2443,  -1662,    511,    457,
      -259,   -505,    173,   -204,   -858,   -117,   2751,    852,
       220,   -512,  -2576,   1542,    357,    -77,     -4,    165,
       -63,    189,    302,   -699,   -764,  -1559,     25,   -233,
       405,    173,    698,    -73,   -300,  -1442,  -2923,  -1326,
       -25,     98,   -196,  -2915,  -1169,  -3392,    691,    353,
      -196,     96,     41,    180,    198,    280,    207,   -158,
       -19,   1556,    991,   -523,   -280,  -1599,   1368,  -3247,
      -996,    159,   -136,   -469,    -48,      0,     30,     95,
      -765,     33,   6580,   -180,    316,   -176,    105,    -21,
        -9,    166,    148,    -52,    -49,     42,      2,    318,
       -55,    -91,  -1461,  -1474,  -3086,   -756,   1479,    -29,
      -668,   -255,    -51,    241,    249,   -212,    132,   -129,
      -410,    113,     17,    301,    185,     96,     10,    188,
        38,   -772,   5152,    -13,    -10,   1527,    806,    -23,
       -79,   1102,    -77,    329,    -99,   -404,   2276,   -873,
     -2681,   -765,     71,     20,  -2448,   -803,   1827,   1115,
      -160,    -15,    288,    -46,    573,    100,   -726,   -694,
      -406,    288,     61,  -2216,   -904,     77,  -2983,   -962,
     -1438,    809,    -38,    -79,     95,     52,   -231,    518,
       115,     41,    908,    780,    805,   -207,  -2161,    554,
       968,   3111,    133,   -158,    -13,    -34,   -182,    -60,
       105,    718,  -1245,    227,   -818,   1184,    903,    603,
      -988,  -2647,   1847,    141,    817,   -337,    131,    393,
      1653,    839,   -261,    466,    465,   -297,   1440,   -431,
      2058,  -1857,  -1416,    310,   -722,    -54,    203,   -266,
      3770,    172,   -593,    -73,   -508,    -61,   1110,   1261,
       275,   1681,    447,   -147,    -95,     33,   1281,  -3119,
        24,   -308,    366,   -468,    232,    358,    667,   -942,
       696,   -924,  -2059,    -62,    151,  -2102,    332,    258,
      -186,   -636,    685,    214,  -3174,  -1243,    573,   -276,
         9,   -262,    -20,    158,   -174,    -21,    593,  -6198,
      -266,   -270,    -63,   -203,     63,   -396,   -100,    191,
       212,     85,    120,   -791,     37,    -47,   2108,    652,
       519,    346,    106,  -1840,  -2566,   -563,     14,    266,
        10,    214,    504,  -1269,     50,    164,    120,   -105,
      -546,   -212,    -79,     41,   -171,    675,   -252,   4373,
       -16,  -1697,  -1491,  -3588,   -587,    623,     67,    269,
       484,    -25,   1067,    580,   -598,    195,     47,    -17,
};

static const int16_t cb4448sm0[] = {
     -5114,    166,   -785,    635,   -528,   -102,    269,    492,
      -185,   -614,    122,   -124,     85,    145,    270,   -154,
        39,   2524,     58,    -57,    119,      5,    343,   2873,
      -278,   -787,    137,     62,   -169,   2049,   1476,   -325,
       130,   -702,   2882,    -19,    310,   -258,   -135,     88,
      -268,     69,     69,    695,  -1935,    815,    678,     44,
      3085,    278,   -587,  -1326,    360,    145,    -17,     66,
     -2475,   -594,    132,    358,    406,   -369,   -237,   3363,
       329,   -424,     52,     49,    291,   -236,  -2332,   -261,
        49,    -27,    170,   3656,   -214,   -603,    264,     60,
       -87,    145,    116,    179,    190,    679,    339,   -340,
      3272,    641,  -2631,    484,    159,    305,    290,    208,
       226,     68,    102,   -145,   -356,    153,    647,  -2046,
       937,  -1666,   1093,    -29,  -1161,    749,  -2360,    171,
     -2185,    841,  -1406,  -1057,  -1764,   -300,   -205,    452,
      2168,   -214,   -153,    291,   -106,     79,   1717,    -20,
     -1771,    286,   -466,    686,    167,    137,      5,     43,
      1075,  -2601,    261,    -86,   -333,   -724,    162,    186,
         4,   -334,   -412,   -309,    888,   -114,    531,    297,
      4284,    297,  -1695,   -212,     75,   -263,  -2313,    102,
      -434,    352,  -1813,   -472,    114,   -185,      6,     66,
      8061,    414,   -577,    672,   -152,    152,      1,     38,
       -66,     48,    -35,     62,    -98,    -19,  -3762,     98,
       242,    114,    359,   -162,    115,  -3038,    340,    253,
      -526,   -144,     14,   -147,     28,   -352,  -5858,     46,
      -597,   -392,    226,    -54,    -70,    -47,    -45,     16,
        53,    137,    172,  -3017,    -22,   -163,   -267,  -3289,
       -31,   -174,    110,    794,    425,     67,     58,    -72,
      -156,   3937,   -585,   2116,     99,  -1115,   -257,    801,
       270,   -329,   -257,    -18,    122,   -369,  -2196,   1746,
      -305,    599,    800,    749,   1466,   -299,  -1519,   -255,
      -233,    217,   -117,   -256,    301,   -249,   -327,   5530,
        86,    135,   -784,   -137,    610,     -7,     55,     93,
      -106,    -50,    267,   -229,    -26,  -1070,     13,    -75,
      1733,   2929,   -130,   -713,     15,  -2144,    104,   -318,
       282,     -8,   -285,   -468,   -124,     59,    520,    -78,
      -332,   -654,  -5048,    212,   -388,     97,  -1523,    227,
     -2545,   2159,   -127,   1020,     79,   -664,    403,    -31,
      -356,     -1,   -436,    -86,     75,    610,   3048,    235,
     -3133,  -1189,    -44,    -23,   -324,    260,    469,   -113,
        22,     53,    525,    427,    469,   1016,    420,    493,
     -1229,   -238,  -2671,    361,  -2745,    193,   -253,    -59,
        15,     53,    -57,     36,   -144,    127,     25,     11,
       -34,   6560,    -12,    -80,    -72,     70,    654,  -1135,
       158,    279,    298,    746,   -190,  -1382,    138,    527,
     -1504,  -2753,   -106,    -55,    225,     54,    136,     53,
       506,    174,    268,   -533,    -43,   -416,   -196,   6266,
       -81,     22,   -158,    350,   1177,   -728,    594,     34,
      -368,   -226,   -584,    247,    804,  -1141,     78,   3923,
       -53,    309,     58,    -45,  -7634,    -73,     39,   -152,
        55,    -77,    -45,    -62,    -25,   -247,   -161,     28,
     -2629,   -401,   -295,   -687,    298,  -3240,      0,   -251,
         7,    -49,    494,   -198,    202,   2201,   -301,     83,
        45,   -964,    256,  -1499,  -2394,     24,   -267,   -599,
        46,    161,   -370,     81,    636,   3146,  -2077,   -964,
       322,    400,   -635,   -688,   -630,    -92,   -235,    104,
       -77,   -541,    511,   2722,    441,   2757,    952,    739,
      -257,   -254,   -438,   -122,   -151,     12,    578,    -92,
      -440,    -63,     93,   4971,   -499,    419,   1374,   -165,
      -417,     64,    -13,   -235,   1080,    -77,    536,     68,
      -842,   -772,   1627,   -471,  -1350,   -144,   2849,    219,
       114,     68,    -55,    350,    -11,  -1334,  -3042,   1166,
      -147,   -891,   -483,   1461,    339,    808,    362,   -101,
     -2807,    -24,   -377,    518,   -438,    194,   -110,    194,
      -826,   3380,    -81,    -30,    -43,    103,    -99,   1539,
      -614,    -13,  -1154,    196,  -3122,   -521,   1454,   -319,
       159,   -428,    722,   -208,    162,   1871,   2534,   2287,
       946,    261,   -483,   -645,     26,   -170,    -31,     17,
       164,    104,    -44,  -8192,    -20,     94,   -235,     56,
        68,    -58,    380,    -25,   -170,     17,     16,   -154,
        63,    477,   1280,    614,   -529,  -2347,   -360,    159,
      1967,  -2085,    485,    335,    378,    178,   1633,   -437,
       -46,     23,    640,   1465,    -91,   1279,  -1025,  -1007,
      -236,   2632,   -257,    262,    177,   3029,  -3149,  -1001,
       231,   -262,     87,   -243,    -68,   -597,    109,     62,
      -264,     37,   -463,  -3105,   -633,    881,   1026,    -86,
       417,    705,  -1144,    -68,  -2084,     46,    124,    -36,
     -2461,    -73,   -126,   -303,   1079,   -358,  -2764,   -761,
     -1454,   -245,    203,      0,   -179,   -117,   2571,  -4751,
       -20,    194,    298,    258,    390,    270,    -36,    182,
       152,    -56,    -97,    -47,    138,   -233,   -111,  -1490,
      -490,   -329,    662,   -320,  -4697,    443,     66,    352,
       203,   -114,   -119,    186,    649,   -106,     -5,   2280,
      1132,   -376,   1168,    919,   1858,    271,  -1741,   -130,
     -3388,    264,    618,  -2375,    260,   1279,    110,    732,
       128,   -373,     54,   -182,     99,   -131,      9,     30,
       -83,     27,    204,    109,   -306,   6903,    130,     -7,
      -115,     92,   -241,    119,   -640,   -871,    -40,    372,
       -68,   -147,  -1503,    -58,    920,   -466,    311,    144,
     -3648,   -121,   -357,      5,   1968,   -737,  -1491,    596,
       818,    122,    688,   -137,  -2415,   -368,    236,     71,
      -597,   -193,   -395,    795,    855,    657,    -49,    844,
     -3320,  -1921,    846,     17,   -293,    -17,  -1676,  -1826,
      -138,    897,   -207,     -3,   1838,   -901,     86,    275,
       964,    230,    510,    -10,   2879,   3949,    332,    289,
       109,   -229,     18,    238,    244,    287,     44,    103,
       367,     21,  -1134,   -378,   1338,   -828,   3500,      5,
      1027,    475,    208,    654,    589,    -92,    236,    -85,
      -115,   1095,  -2504,    827,   -885,   -806,   -155,   2112,
      -346,   1120,   -350,   -911,   -234,    231,     55,     87,
      1957,    601,    755,  -1248,    753,  -2726,   -481,   2038,
        96,   -363,    309,    150,    299,   -561,   -698,  -1030,
       118,   1224,   3240,  -1523,   1476,    342,   -688,    -76,
       192,     -8,   -319,    350,    149,   -331,    155,   -436,
       286,   -994,    160,  -2696,   -423,  -2798,   -135,   -108,
     -2846,   -254,   3590,    350,    130,   -810,    463,   -123,
        59,   -256,    251,   -750,    -76,     -8,  -1633,    150,
      -931,   1958,   1523,  -2527,    239,   -287,    172,    332,
       -13,    486,    247,    -26,    149,     59,    130,    265,
        19,    209,   7220,    -23,    -99,    -69,    -66,    -70,
       -54,    -75,     60,   -264,   -102,   1079,   -535,   1587,
      -557,  -1499,    241,  -2596,   1157,   -140,    270,     33,
};

static const int16_t cb4448sm1[] = {
      7894,   -331,    383,   -556,     63,   -371,    -23,     73,
        46,   -145,    105,     43,   -199,    -52,    -85,    -85,
        13,    -21,   -230,   7379,    268,   -243,   -460,    251,
        73,     12,    115,    -18,   -247,    433,    -90,   -518,
       962,      0,   -960,    184,   -305,  -2003,    276,   1696,
      2418,    270,  -2140,   -215,   -534,   -389,   -403,  -3500,
       416,    567,   -393,   -183,    253,   -100,   -285,   -107,
       100,    281,   -527,  -2944,    -86,   2652,    311,   -785,
      -811,   -283,    425,    -77,    393,    136,    170,   1290,
      -765,    108,    676,   -213,  -1226,   -470,    427,   3499,
       616,  -1211,   -226,    -37,     88,  -2792,    351,     78,
     -2975,     99,    192,   1390,   -338,     47,     -8,     58,
      -255,     50,    221,    -49,   -788,   -207,  -2122,   -167,
      -692,    379,  -3239,   -965,   -698,   -463,    -45,     34,
      1785,   1026,  -1107,    113,    124,   -258,   -277,   -714,
      2764,   -178,   -200,    907,    -45,   -213,  -2575,   -530,
      -112,   3616,   -128,     76,   -366,   -135,    -22,    -51,
       125,   -100,    -79,    142,     54,    107,     87,    493,
       -34,   -221,   -448,   -243,    994,    845,  -4656,   -105,
      -487,     41,   -112,    349,  -4328,    -72,    513,   -112,
      -685,   -470,   -138,   -541,    340,  -1505,    -24,     37,
       169,   -405,   -434,  -2994,    -42,   -416,  -1927,   1551,
     -1488,    420,    179,    -66,     14,     92,    147,    141,
       497,    404,   -412,   2301,    336,  -2877,  -1845,   -948,
      -784,    262,   -211,      6,  -1678,   -434,  -1433,   -727,
      1254,    542,  -1430,   -302,   1558,    107,    617,   -833,
      -369,   -178,   1682,  -2569,  -1232,  -1556,    -87,   -178,
       400,   -178,   -427,   -124,    -63,    142,   -221,     33,
      2880,   -227,   -356,   -466,  -3362,   -398,   -167,    164,
       126,     59,     -1,      5,    212,     25,   2062,   -462,
       -33,    -46,     45,   -201,    823,   -268,   -302,   3623,
       389,    382,    136,    -30,    -64,      2,   -600,   3114,
      2720,    273,   -588,   -235,   -313,   -141,     37,    -28,
       355,    184,   -433,   -110,   -576,    -56,    134,   -623,
      -271,  -2529,  -2753,    947,   1319,     -2,    620,     36,
      -412,  -1986,    221,   -404,    514,   3223,   -106,   1497,
      -368,   -167,   -142,   -366,   -125,     16,    142,   -435,
      -160,   2845,   -153,    470,    387,   3117,    -75,   -375,
       658,    259,    755,     -3,   3744,   -517,  -1446,   -667,
      1372,  -1692,    117,    -96,    195,   -201,   -134,    -76,
       179,     97,     71,   1887,    161,    365,    228,   1177,
       235,   -834,    -48,   1667,  -1123,   2217,   -209,    100,
      -219,  -2778,     81,   -579,   3421,   -326,   -492,   -233,
        78,     32,    117,    -74,    -80,     85,   -282,    453,
       500,    721,    800,     83,   -624,   1000,    165,    -20,
      -516,  -4193,   -334,    107,   1221,  -1507,    -10,    523,
        85,    -44,     21,     34,    199,   -106,  -2233,    525,
      2138,     40,    -55,    -63,  -8179,    326,    333,   -152,
       -27,    137,    212,    130,    -10,     76,    -61,   -113,
      -544,   -179,   -187,      0,  -5308,    322,   -326,    513,
       415,    375,    -92,   -354,     69,     77,     65,     93,
      -352,   -165,  -1837,   1790,    914,   -276,   2215,  -1418,
       343,    281,      4,    283,   4398,   1695,   -248,    153,
      -166,    751,    822,   -406,   -456,   -251,    185,   -251,
      -222,   -169,   -266,  -6323,    249,    -40,    -45,   -203,
        47,    -83,   -621,   -174,    327,     30,    114,    -29,
      -505,   -224,   1804,   1582,  -2292,   2102,   -746,   -421,
       170,    438,   -171,    153,     84,   -157,  -2937,   -123,
       -81,   -227,    -98,    263,   3531,     36,    105,   -479,
       -94,   -357,    -22,   -124,    279,   -116,    543,    201,
      -393,   -226,  -2255,   -133,   1613,   -123,   2687,     70,
       191,    240,   -996,   -676,    606,  -1245,   -306,    413,
      -272,   -539,    485,   3583,   -224,    432,    389,     31,
      -888,    318,   -149,   -228,    764,   -426,   1608,  -2656,
       254,  -2193,    252,    484,    -90,   -117,   -257,  -2210,
      -156,    553,    559,    680,    298,    -16,   -519,   1172,
      2172,   1288,   -113,    186,   -199,  -1415,    -83,  -1984,
       667,  -1013,    344,   -399,   2889,  -1175,   -908,    186,
       185,    -22,   -328,   3132,  -1166,    209,   -213,    386,
      2140,    552,   1023,    719,    529,   -169,    421,    196,
        76,   1995,    532,    -75,   2060,   -526,    396,   2974,
      -264,   -348,    149,    586,     22,     97,   -337,   -252,
       357,    103,  -2308,  -2578,  -1836,   -277,    346,   -314,
      -989,    185,   -314,    102,     56,   3779,   -265,  -1029,
       -12,   -126,   -431,    356,  -2493,    -86,    172,    116,
        61,   -146,  -2220,    211,   -165,    233,   -327,     73,
        -7,   -104,   -546,    253,  -2406,    361,   2252,    486,
       675,   -177,   2643,    603,    300,   1123,   -642,    361,
       684,  -2151,    569,  -1014,    120,    -50,    321,   3174,
      3080,   -733,   -427,    299,    169,   -123,   -140,    -13,
      -315,     21,   -120,    -24,    174,   -191,   -350,  -7842,
      -145,   -169,   -419,    -15,    150,   -130,    -73,    162,
        -9,     38,   -287,    109,    390,    147,    151,   1907,
     -4243,      7,   -207,   -147,   -230,   -343,   -117,   -111,
       107,    132,   1457,    -88,     -8,   -445,   -176,   -172,
     -1799,   -813,    486,   1150,  -3026,   -168,  -2620,   -584,
       178,   -543,  -1868,   -359,   -113,  -1783,    214,   -663,
       473,    866,   -136,    169,  -3324,   -129,  -3404,   -249,
       234,    422,    251,    340,   -343,    231,    134,    -42,
        32,     64,   -209,     12,    236,   -267,   -419,      1,
       260,   -109,   6508,    105,      7,   -273,   -123,   -107,
      -152,   -274,   -157,     75,     74,   -201,     46,     37,
       338,    -21,   -180,    208,  -6417,    794,    250,    -81,
      -585,      4,   -119,   -314,    529,    219,    159,   -132,
      -277,     76,   -613,   4933,     15,    213,   2461,    286,
       542,    177,   2767,    389,    136,    750,    559,   -994,
       684,    -12,  -2081,   -546,    -89,  -3733,    548,   -620,
       675,    118,   -121,    190,    -52,     19,    -19,     25,
     -1224,    344,   3094,  -2067,      7,    273,  -1268,   -375,
      -297,   -201,    271,   -191,    123,      6,   -260,   2284,
      -308,  -3062,    242,    668,   -221,   1146,   1218,    473,
      -133,     82,     57,    112,  -1677,     78,   -229,    354,
      -463,    763,   1628,   2243,   1386,   1630,   -145,    255,
       -60,    228,    195,   -864,   2539,   -466,    985,  -3075,
         2,    118,    221,   -395,   -450,   -256,   -158,    -32,
     -3829,   2012,    -50,   -465,    146,  -1091,   -318,    271,
       -12,    596,    160,    120,     92,   -209,   -335,    104,
       -28,    689,    305,   -548,   -849,   1617,    605,    185,
      -414,   3899,   -273,     51,    182,   -192,    121,    616,
      1219,    414,   -959,  -4219,   1319,     60,    246,   -468,
       -32,    225,    338,    -39,   1235,  -2079,   2250,    626,
       121,    296,   -137,   -339,  -1870,    -47,   -397,    124,
};

static const int16_t fcb8l[] = {
     -1239,  -1310,  -1240,  -1146,  -1337,   1303,   -482,   2215,
      2026,   2222,  -1144,  -1188,  -1209,   2535,  -1111,   -844,
      1485,    625,   1254,   1204,   5932,  -1116,  -1235,  -1208,
      -801,  -1020,   -558,   1387,   1513,  -1079,   3220,   -896,
     -1083,  -1166,   2246,  -1210,   -838,   -950,   -960,    764,
     13941,  -1307,   -817,  -1253,   1850,  -1320,  -1361,  -1218,
      -671,    780,   -839,  -1068,   -776,   2977,   -714,   -944,
      -823,   -580,    357,    591,    302,  -1078,   -895,  -1020,
      3116,  -1144,   1438,   -891,    -71,   1528,   -238,  -1297,
     -1020,   4616,  -1185,   -514,  -1154,  -1157,   1901,   2372,
     -1131,  -1289,  -1273,  -1289,  -1311,  -1331,  -1340,    439,
       455,   2395,   -537,  -1180,   2409,  -1084,   -580,   1937,
       846,    -51,    615,   1099,   3854,  -1177,   -912,  -1095,
       656,   -995,   -647,   3298,   -976,   -436,  12323,  -1291,
     -1187,  -1341,   4779,  -1368,  -1357,  -1317,   -985,   1407,
      -513,  -1387,  -1224,  -1069,  -1218,  -1117,   -181,  -1209,
      5376,   4256,    -22,  -1232,  -1173,   -834,  -1054,   -947,
      -611,   -822,   -206,   5572,   -988,   1067,   -837,    738,
      -332,    -38,    -59,    143,    248,    386,   -447,  -1233,
     -1258,  -1169,   3653,  -1045,   -657,   -926,   2004,   2201,
     -1164,   7042,  -1302,  -1313,   -812,    150,   -129,    305,
       442,    742,  -1185,  -1293,  -1220,   -872,  -1304,  -1260,
      -853,  -1293,   2962,   3011,   -178,  -1187,  -1087,   -896,
      -895,  -1053,   3788,     59,   -169,   1632,  -1201,  -1289,
      5263,   -896,    331,   -852,    218,    825,   1129,   1024,
       -39,  -1186,  -1054,   1862,  -1198,   2010,  -1075,  -1005,
       702,   1550,   4491,  -1055,   -890,   -645,   -987,   2465,
       529,    194,    -72,    370,   1547,   -968,   -849,  -1153,
      6459,  -1164,  -1061,  -1020,   -838,    125,   3698,  -1168,
     -1066,   1882,  -1159,   -439,  -1017,   -759,    744,   1302,
      -812,   -985,  -1002,  -1029,   -871,   3690,   -170,    604,
       623,   1272,   6135,  -1012,  -1231,  -1066,   -927,  -1082,
      2393,   -843,   1537,   1240,   -866,  -1161,   -866,   6639,
      -994,   -860,   -264,   -298,    469,   1184,   -868,  -1262,
      2167,  -1177,   2132,   -987,   -563,    969,   1145,   1508,
      -735,  -1232,  -1090,  -1204,   1507,  -1101,   -393,    755,
       975,   1246,   1944,  -1068,  -1169,  -1040,   -987,  -1301,
      5488,  -1057,   3150,   1890,  -1133,   2725,  -1123,   -963,
      1901,    260,   -484,    449,    564,   1144,    679,  -1118,
      -989,   -702,   -556,    162,    689,    712,    673,    443,
      -695,  -1247,  -1019,  -1065,   -406,  -1143,   1750,   -743,
      2644,   2402,  -1171,  -1157,  -1059,   -823,   -688,   1314,
      1458,    629,    857,    856,   -875,  -1316,   3470,  -1061,
      -846,   -761,   -712,   -955,    978,   1967,   -980,   3517,
      -994,   -953,   -903,     56,    228,    -30,    359,    560,
      9926,  -1178,  -1056,   -627,   -952,   -481,  -1168,   -268,
      -701,   -555,   -887,  -1212,   1768,  -1156,   -396,   -755,
      -119,   1594,    949,   1201,   -844,   1734,   1312,   -331,
      -500,   -280,   -125,   -219,   -139,    496,  -1121,  -1227,
     -1145,   -215,  -1123,   -765,   -173,   4055,   1086,   1465,
      -714,   -904,   -901,   -713,  -1073,   1233,   -797,    645,
        58,    897,   -518,   -624,   -441,   -554,   1139,    549,
       147,     72,    127,    428,  -1104,   -979,   2433,   1867,
      -237,   -745,   -280,    110,    794,    631,  -1049,   1141,
      -974,   -920,   -849,   -392,    634,    414,    614,    797,
     -1162,  -1344,  -1192,  -1259,  -1079,   -912,   2717,   2548,
      1847,   1920,  -1004,  -1091,  -1006,   -692,    -85,    -24,
      1014,   1427,    751,   -584,   6057,  -1206,  -1072,   -795,
      -921,  -1103,  -1157,   -623,   -818,   2641,   3121,  -1084,
     -1095,   -939,   -664,   -694,    884,    555,    144,    593,
      -874,  -1074,    417,  -1027,     -6,   -790,   1687,     80,
      1018,    738,   -527,   -958,   -701,   -377,     -4,    155,
       304,   -348,   -947,   -342,   2269,  -1040,   1124,   -494,
       -76,     76,      2,    114,   -194,    348,    904,    466,
      -577,   -717,    107,    -39,    -29,    158,    101,    149,
      -968,   -921,    558,   -264,   -445,    138,   -121,    -33,
       105,    243,   -478,  -1047,   -937,   -751,   -609,   -822,
      -709,   -976,  -1006,   2800,  -1108,  -1292,  -1055,  -1272,
     -1295,  -1152,    305,  -1144,    635,   2067,   -584,  -1135,
      -663,  -1130,   -754,  -1009,   -937,   -515,   1473,    841,
     -1235,  -1338,  -1305,  -1141,  -1109,  -1217,   -238,   1915,
      3550,   2306,   -963,   -985,   -874,    763,   -826,   -694,
        19,    391,    379,    776,   -582,  -1216,  -1285,  -1164,
     -1276,  -1305,  -1273,   2631,   -579,   2487,   1058,   -655,
      -808,   -878,   -910,  -1006,  -1122,   -590,   -663,    428,
      2185,  -1125,  -1032,  -1076,   -873,  -1139,  -1029,   -477,
      1720,   1238,  -1111,  -1311,  -1343,   1074,  -1328,  -1181,
      -970,   -386,   2359,   1777,  -1045,  -1189,  -1117,  -1053,
      -942,   -329,    501,   1237,    808,   1022,   -866,  -1048,
      -678,   1597,   1528,   -262,   -256,    231,    418,    728,
};

static const int16_t fcb8s[] = {
     -1022,   -858,   -773,    304,   -881,   -771,   -341,    937,
       270,    420,   -684,  -1000,   -795,   -903,   -671,   -575,
        14,   3327,    528,    893,    965,   -541,   -947,  -1027,
      4008,  -1081,   -743,   -991,   -808,    933,  -1406,  -1173,
      7513,   -824,   -213,   -797,   -648,    -40,    176,    217,
     -1298,   6743,   -755,   -232,   -440,   -680,   -269,    -60,
       -80,    -85,   -893,  -1044,   -726,   -733,   -834,   -641,
       231,   -779,   -501,   1832,  -1296,   2548,   2754,     19,
      -210,   -708,   -205,    -74,     18,     55,  -1225,  -1123,
     -1239,   6991,   -689,    272,   -290,     56,    356,    675,
      1623,  -1134,   -607,   1426,   -872,    511,  -1060,    408,
       253,    423,   1960,  -1337,  -1152,   -985,   -924,   2020,
      -398,    348,   4188,   1044,   -650,   -831,   2909,   2083,
      -457,     -5,  -1037,   -964,   -128,    -40,   6019,   -858,
      -937,   -559,   -624,   -601,   -411,    120,   -289,    412,
     -1271,  -1351,   3858,  -1214,   2224,   -325,   -165,    535,
       559,    386,   1868,    649,    269,    245,   -708,   -778,
      -179,    -12,    101,    -12,  -1235,   -892,   -829,   2570,
      -574,   -431,    170,    167,    492,    531,   -930,  -1093,
     -1037,  -1177,  -1151,   -912,   -466,    303,   1601,   4089,
     -1234,   3160,   -631,  -1090,   -741,   -274,    103,     13,
       356,    289,   2709,  -1115,  -1011,   -965,   -948,   -563,
      1939,    870,   1187,    550,  -1028,  -1217,   -726,   -954,
      -694,   -753,   3729,    141,    518,    854,  -1102,   1138,
      -947,   -620,   -379,   -436,     72,    449,    432,    428,
     -1112,   1276,    544,   -334,   -445,    179,    -32,    -37,
         9,     28,  -1252,   2983,   -963,   1256,    419,    -10,
        17,    211,    218,    191,    126,   -942,   -691,   -529,
      -533,   -193,   1216,    150,    389,    152,  -1191,   -987,
      -942,   -860,   -463,   -705,   -159,    184,   1893,   1080,
      1753,   -694,   -609,   -699,     61,    269,   -126,     93,
       236,    380,   -527,   -966,   -334,    163,   -662,   3295,
      -477,    591,    259,    638,    397,    181,   -598,   -129,
        35,    -51,   -122,     64,    -32,    -98,  -1351,  -1140,
      3372,   -753,   -776,    718,    513,    134,    420,    354,
     -1128,   -546,   -743,    297,   1819,    -77,    179,     17,
       181,    206,  -1028,  -1027,   -757,   -755,   -389,   1035,
       227,    249,    315,    395,   -931,   -881,   1207,   -777,
      -165,   -531,   -375,     73,    346,    332,  -1159,   -788,
      1196,    959,   -432,   -337,    243,    176,    321,     -7,
};

static const int16_t fcb8m[] = {
     -1379,  -1331,  -1277,  -1266,   -927,      0,   2552,   2575,
       425,     48,   2568,    -26,   -841,   -762,   -679,   -562,
      -420,    186,     68,     69,   -743,   -193,    266,     92,
      1714,   -241,   -357,    -93,   -252,   -222,   -884,   -385,
      2436,   -446,   -150,   -533,   -192,    -33,    226,      8,
      -756,  -1180,  -1238,  -1258,  -1250,  -1147,   -764,    141,
      3075,   4136,  -1255,  -1288,  -1202,  -1188,  -1222,  -1257,
      -500,   1989,   4062,   1328,   -300,   -186,   -399,   -329,
      -330,   -533,   -313,   2030,    193,   -128,   -933,  -1016,
        66,   1648,   -228,   -321,    236,    114,    356,    212,
      -677,   -826,   -784,   -670,   -484,   -423,   -188,    215,
      2476,    652,   3424,   1991,    940,   -576,   -942,  -1038,
     -1097,  -1161,  -1120,   -956,   -763,   -416,   2824,   1429,
      -693,   -755,   -455,   -670,   -535,   -225,   4814,    116,
      -940,   -953,  -1008,   -856,   -797,   -582,   -531,   -213,
      -412,   2479,   -156,   -218,   -319,   -168,   -236,   -248,
      -305,   -515,   -224,   -382,   -501,   -759,    139,   1789,
      -258,   -343,   -167,    721,  -1014,  -1092,   -975,  -1070,
     -1126,   -778,   -178,     36,    522,   5371,   -402,  -1351,
     -1577,  -1662,  -1642,  -1560,  -1249,   -870,    602,   8968,
     -1126,  -1102,  -1118,  -1072,   -946,   -511,    482,   1635,
      1108,   2471,   -935,   -748,   -302,   -445,   -810,   -359,
      1433,    -83,    336,   1834,   -712,   -773,   -752,   -609,
      -391,    625,   2550,    403,   -447,    -18,   -261,     91,
      5096,   -199,   -887,  -1018,   -728,   -930,   -921,   -684,
       -22,   2422,   2118,   -417,   -757,   -789,   -732,   -794,
      -785,   -664,   -627,    885,    471,    798,   -429,   -684,
      -454,   -185,    185,    -26,   -990,   -369,   1048,    -25,
       -98,    720,     41,    -60,     -3,    -92,   -790,   -147,
       846,   4007,   -346,   -907,   -849,   -730,   -639,   -842,
      9096,    617,  -1164,  -1275,  -1380,  -1396,  -1391,  -1364,
     -1342,  -1080,    655,   5687,    505,   -818,  -1134,  -1125,
     -1136,  -1123,  -1088,   -996,      3,     36,    -48,    -28,
       121,    -55,    172,    -43,     21,    -74,   1537,    -69,
       378,    -38,   -113,    159,   -149,   -609,   -693,   -796,
      -715,    588,    376,   -744,   -659,   -316,    145,    448,
       659,    320,    787,   -315,   -956,   -682,   -595,   -327,
       146,    348,    837,    577,  -1011,  -1014,   -647,   -159,
       679,    158,    294,    670,    507,    540,    418,    558,
        12,   -674,   -901,   -897,   -827,   -682,    323,   2580,
};

static const int16_t fcb16l[] = {
       -13,   -798,   -772,    235,    515,   -181,   -120,   -509,
      -392,  -1159,   -844,  -1041,   -881,  -1193,   1103,  -1080,
       214,   1615,   1819,   1510,   -914,  -1190,   -273,  -1099,
      -522,   -996,   -206,   3946,    996,   1678,  -1220,  -1201,
      2850,  -1022,   1101,   -814,   -188,    879,   1549,   1279,
     -1129,   1928,   1550,     38,   -356,   -574,   -157,    286,
       481,    475,  -1079,  -1176,   -861,   -548,   -657,   -381,
       538,    948,   -838,    779,  -1149,   -962,   1788,   -779,
      -742,   -311,    205,    299,    472,    715,    702,   -843,
      -931,   -790,   -624,   -332,    324,    778,    785,    670,
     -1137,  -1205,   -103,  -1182,  -1071,   -950,    101,    527,
      1596,   1004,    682,   -564,  -1053,   -844,  -1184,   1732,
      -862,   1994,   -988,   1131,  -1069,  -1276,  -1053,   6414,
     -1259,   -186,   -930,    118,    375,   1092,   6215,   -900,
      -920,   -935,   -981,   -970,   -766,   -902,   -334,   1629,
     -1094,  -1142,  -1155,   -779,  -1092,   1011,   -490,   1063,
      1569,   1340,   2242,  -1313,   6027,  -1319,  -1337,   -789,
     -1296,   -457,    819,   2276,  -1071,  -1065,   -715,    802,
      -996,    397,   2396,    -27,   1225,    935,   1400,   -862,
      -802,   1846,   -513,   -249,   -704,    515,    872,    662,
     -1141,   5876,   -691,   -404,   -603,   -148,    -57,    187,
       649,    788,  -1116,   -915,   -551,   3843,   -737,   -133,
       498,    155,    227,    718,   1798,   1397,   -868,   -716,
      -586,   -580,    -71,    -67,    311,    536,   2465,   -524,
      1837,   -231,   -210,    263,    231,    -10,   -164,   -324,
      -951,  -1130,   5206,   -525,   -603,   -401,    223,    438,
      1011,   1077,   -726,  -1102,  -1013,   -386,   -786,   4281,
      -329,    262,    550,   1292,   -629,   -943,   -976,    773,
      -867,    908,   -680,   -154,    362,   1056,  -1051,   -703,
     -1333,  -1424,  -1026,   -793,   -859,   -882,   -148,   9958,
     -1193,  -1156,  -1077,   1241,  -1013,   -726,   -139,    551,
      1150,   1019,   -733,   -997,   -651,   -625,    -54,    722,
        73,    -14,    361,    435,   4013,  -1260,  -1195,   1452,
     -1105,   1273,   -670,   1546,   1038,   1680,   -812,  -1060,
      -853,  -1058,   2094,   -801,   -457,   -320,    683,    960,
     -1019,  -1158,  -1118,  -1034,   -617,    404,   1376,    847,
      1014,    951,    -12,  -1004,  -1221,  -1131,    649,  -1052,
       442,   -167,   -859,   3868,  -1216,  -1298,  -1311,   2866,
     -1310,   -639,  -1079,   1576,   1760,   1837,    118,  -1080,
      -862,   -845,  -1065,  -1069,   2199,   -766,    495,   1309,
      -996,  -1040,   -741,   1357,   1726,    382,    264,     92,
       659,    665,   -781,  -1356,   2055,  -1198,     15,   2143,
       631,    569,    918,   1120,   -948,  -1253,  -1234,   2442,
     -1062,   2206,     48,    660,   1822,   1480,   -639,    627,
      -432,   -477,    845,    216,    228,    152,    157,    295,
      2444,   -908,   -465,   -768,    109,    251,     72,    -59,
       169,    405,   4395,   -837,   -931,   -839,   -215,   -564,
       655,    359,    503,    296,   3514,  -1082,  -1185,   -827,
      2879,  -1224,   -811,   -970,    804,    911,   3028,  -1284,
      -688,  -1226,  -1251,   -551,  -1247,   -275,   3441,   2322,
      -630,  -1213,   -108,  -1191,   1129,   -854,   2848,   1609,
      1048,   1535,   2784,  -1245,    772,  -1230,  -1298,   -686,
     -1293,   -639,    278,   2455,   9975,  -1077,  -1233,  -1055,
      -139,   -853,    -48,     24,   -720,    533,  -1191,   2809,
     -1015,   -899,    -28,   -765,   -147,    146,    592,    814,
     12493,  -1274,  -1072,  -1297,    877,  -1068,  -1179,  -1032,
      1023,  -1178,   -840,    930,   -660,   1216,   -366,   -406,
       -97,     77,    179,    340,   -973,   -993,   2280,   1775,
      -631,    -17,   -186,    507,    459,    645,   2095,  -1019,
     -1067,   -949,   -857,  -1202,   -904,    -48,   1156,   1273,
     -1230,  -1245,  -1203,  -1036,  -1150,   -955,   1193,   1943,
      1437,   1329,   -618,  -1055,   -730,  -1014,   4953,  -1125,
      1089,   1085,   1047,   1045,    813,  -1036,   1270,   -715,
      -684,    -96,   -131,    289,    782,    628,   -979,   1060,
      -975,   -964,   -811,    -14,    223,    422,    563,    696,
      -901,   -633,    496,   -136,     22,    -83,    -52,    264,
        24,    147,   -446,  -1197,  -1258,   -687,  -1239,   -795,
     -1066,  -1196,    147,   2653,  -1231,  -1275,  -1240,  -1041,
     -1260,  -1159,   1961,    -34,   2937,   2128,  -1318,  -1355,
     -1326,  -1300,  -1345,  -1326,   -870,   -298,   2014,   3890,
      -933,  -1014,   -859,  -1074,   -506,  -1163,   -954,   -819,
       440,    732,   -582,  -1268,  -1206,  -1037,  -1081,  -1255,
     -1150,   -835,   2360,   1469,  -1232,  -1384,  -1388,    542,
     -1359,   -606,  -1335,   1852,   2142,   3722,  -1218,  -1321,
     -1268,  -1207,  -1203,  -1316,   -954,   -696,   4730,   2920,
     -1225,  -1306,  -1131,  -1273,  -1276,  -1238,  -1040,   2079,
      2652,   1931,  -1167,  -1302,    659,   -532,   -650,   -560,
     -1028,    186,   1224,   2811,   -896,   -449,   -999,   -823,
       -81,   -876,    502,   -293,    680,    733,   -836,  -1111,
     -1132,   -865,  -1141,   -938,   -980,   1287,    581,   1438,
};

static const int16_t fcb16s[] = {
      1260,  -1427,  -1400,   -996,   -958,  -1195,   6261,     31,
       967,    752,   3776,   -975,   -840,   -707,   -696,   -555,
        45,   1159,      4,    358,   4718,  -1471,  -1464,  -1291,
     -1364,   -934,   -878,   5198,   -273,   1555,  -1438,  -1729,
     -1579,  -1470,  -1820,  -1436,  -1255,   -631,   4287,   4025,
      1233,   -684,   -748,   -742,   -547,   -229,    321,    126,
       794,    670,   6689,  -1041,  -1160,   -861,  -1002,   -976,
       147,   -668,    521,    940,  -1186,   2097,   -570,   1759,
      -251,   -442,    -92,     46,     99,     12,  -1336,  -1061,
      4427,   -945,   -861,   -460,   -306,    494,    481,    536,
     -1101,  -1105,   2695,    316,   -801,   -159,   1042,   -577,
       -78,    340,   2347,   1448,    135,   -381,   -688,   -493,
      -254,   -234,    -74,    -80,  -1047,  -1246,   -729,   -985,
      5399,  -1018,    643,    822,    889,    432,   -328,  -1386,
     -1420,   -702,  -1450,   6927,  -1107,    465,   1625,   1116,
     -1258,   2847,   -893,   -895,   -521,   -263,    112,    157,
       556,    500,    182,   -652,   -226,    258,   -638,   -566,
      -419,   -669,   -224,   -221,  -1197,   -227,   -582,     92,
      1914,   -184,    -11,    -18,    270,    166,  -1294,    -62,
      1536,   2470,   -413,   -619,   -399,     24,    106,     54,
     -1223,   2672,   2400,    -54,   -577,   -692,   -301,     -3,
       206,     89,  -1424,  -1491,   8425,  -1072,   -242,   -420,
      -194,     -1,    489,    331,   -938,  -1319,   2493,  -1355,
       551,   2297,    197,     -9,    717,    434,  -1237,   -773,
     -1021,   3945,   -566,    116,    246,    150,    510,    370,
     11804,   -457,  -1006,  -1231,  -1175,  -1086,  -1221,    589,
      -679,   -757,  -1183,   6502,   -584,   -454,   -629,   -570,
      -413,   -352,   -279,    -32,  -1236,   -946,   -760,   1535,
      -865,   -712,   -224,    343,    647,    613,  -1348,   -938,
      -961,   8273,  -1130,   -591,   -225,    210,    420,    140,
     -1247,  -1166,   -966,   -986,  -1120,   -907,   -181,    470,
      1888,   1161,  -1076,  -1298,   3479,  -1151,   2410,   -396,
         1,    -44,    357,    594,   -896,    745,    -33,   -422,
      -332,   -259,      0,     48,    143,    190,  -1009,   -837,
      -876,   -371,   -370,   1520,   -150,    251,    240,    448,
     -1024,  -1008,   -568,   -450,   -611,   -536,   1763,    -34,
       355,    454,   -769,   -599,   -639,   -737,   -912,   -725,
      -504,   -230,    532,   3294,  -1077,   -289,   -875,   -542,
      -574,   -604,   -339,   2511,    479,    742,  -1218,   -946,
      1321,   -522,   -544,   -950,   -765,    632,    639,    497,
};

static const int16_t fcb16m[] = {
      -940,  -1197,  -1190,  -1200,  -1192,   -960,   -718,    610,
      3300,   3253,  -1515,  -1689,  -1798,  -1798,  -1793,  -1764,
     -1616,     33,   2377,   7778,   -668,   1745,   1501,    785,
      -336,   -823,   -708,   -446,   -455,   -812,   8862,    159,
     -1141,  -1261,  -1323,  -1299,  -1261,  -1227,  -1214,  -1090,
      3584,   2092,    688,   -531,   -848,  -1000,  -1047,  -1192,
     -1104,   -887,   5163,   -347,  -1129,  -1285,  -1336,  -1291,
     -1249,  -1109,   -498,   2511,   -611,   -703,   -516,   -240,
       -68,    399,   1570,    252,     -5,     43,  -1163,  -1168,
     -1008,   -921,   -995,   -569,    925,   1511,   1001,   2023,
     12926,    135,  -1598,  -1778,  -1847,  -1850,  -1836,  -1734,
     -1695,  -1690,    621,   4647,    588,   -752,   -973,   -996,
      -953,  -1081,  -1060,   -672,   -868,    259,   4940,   -117,
      -718,   -907,   -828,   -776,   -606,   -981,  -1002,   -526,
      -385,    527,   1501,   -239,     38,     25,    112,    -77,
      1122,   -250,   -352,  -1113,  -1101,   -942,   -681,   5156,
      -800,   -636,   5814,   -160,   -777,   -825,   -844,   -747,
      -697,   -645,   -668,   -492,   -936,    491,   -280,   2573,
      -269,   -736,   -375,   -265,    -98,   -243,   -920,   -236,
       446,   1095,   -666,   -600,   -246,    783,    282,      0,
     -1064,   -116,   2271,   -118,   -482,   -240,   -187,   -271,
        36,     91,   -695,   -254,   -383,   -948,    745,   2722,
      -129,   -799,    238,   -379,   2872,   -516,   -868,   -623,
      -551,   -275,     22,    379,   -185,   -230,   1524,   -672,
     -1062,  -1164,  -1177,  -1137,  -1058,   -790,      6,   4928,
      -551,   -389,   -460,   -394,   -674,   -586,   -327,   -178,
       615,   2868,  -1467,  -1203,  -1316,  -1120,   -996,    747,
      -219,   2023,   1875,    254,   -871,   -992,  -1062,  -1110,
     -1149,   -992,   -492,     40,    528,   5374,     83,   -559,
      -862,   -760,   -541,     28,    207,    629,    502,   1260,
      -473,  -1110,  -1336,  -1390,  -1412,  -1379,  -1329,  -1081,
      -238,   9844,  -1332,  -1306,  -1275,   -881,  -1267,  -1249,
      -237,   2882,   3535,    584,    -13,     52,    -50,     -4,
         7,      5,     20,    -55,      5,     45,   1587,    350,
       191,    617,    153,   -236,   -336,   -649,   -798,  -1063,
      1451,    707,    253,   -733,   -923,   -859,   -621,   -738,
      -555,   1623,   1727,   -411,   -724,   -772,   -746,   -675,
      -688,   -209,    915,    622,  -1038,   -474,   -343,    -91,
      -173,   -104,    255,     96,   1547,    773,   -625,   2272,
       -90,   -509,   -527,   -247,   -147,   -234,    -45,    166,
};

static const int16_t fcb44sl[] = {
      2433,   -925,  -1015,  -1009,   -875,   -276,    378,    464,
       694,    795,  -1044,   -601,   -658,    257,   -898,   -509,
      -346,   2160,    694,    952,  -1302,   -619,    502,   -378,
      -624,   -178,    349,   -100,    204,    546,  -1450,  -1127,
     -1302,  -1297,  -1051,   -840,   3426,   1346,   1577,   1723,
     -1267,   -710,   -872,    448,  -1023,   -728,   -521,   -134,
       874,    936,  -1134,   -549,    203,   -932,  -1051,    755,
      -608,   -199,    858,   1008,   1819,   -842,   -773,   -739,
       818,   -371,    289,    293,    656,    704,    308,  -1009,
      -959,  -1089,    466,   -468,    279,    897,    764,    797,
     -1433,  -1276,  -1253,  -1326,  -1182,   -992,    -85,   4339,
      2135,   2136,   1131,   -917,   -966,   -859,   -889,   1178,
        62,    659,    771,    882,   1844,   -607,   1184,   -766,
      -805,   -385,    -61,    502,    648,    732,  -1245,   1315,
      -818,   -827,    621,   -588,    193,    480,    649,    776,
     -1178,  -1202,  -1152,  -1088,   -857,   -191,    -49,    129,
      1950,   1237,  -1461,  -1290,  -1342,  -1401,  -1338,  -1213,
      -623,    224,   4086,   2517,  -1150,   -814,   -747,    916,
       807,   -288,    319,    436,    560,    718,    392,   -973,
      -988,    411,   -954,   -502,    214,    621,    856,    831,
     -1268,   4012,   -852,  -1002,  -1014,   -577,     32,    552,
       987,   1138,  -1205,  -1319,  -1145,   -928,     80,    371,
       277,    779,    859,    902,  -1141,   -991,   -957,    707,
      -892,   1098,    126,    381,    668,    870,  -1254,   -995,
     -1163,   -926,  -1149,   2572,    -17,    747,   1456,   1509,
     -1004,   -867,   1205,   -797,    938,   -657,    346,    520,
       782,    872,  -1328,  -1080,  -1111,  -1067,   2227,   -892,
       665,   1604,   1425,   1477,   1869,   -668,   -712,   1044,
      -800,   -139,      0,    355,    609,    717,  -1192,   -632,
      3546,   -780,   -870,   -501,    141,    504,    921,   1027,
     -1125,  -1087,   1154,   -660,   -987,    937,     82,   1390,
      1360,   1243,   1259,   -550,   -769,   -787,   -743,   -362,
       -12,    177,    321,    505,  -1147,   -899,   -947,   -849,
      1371,   -462,   -127,     16,    752,    954,  -1405,    448,
     -1181,  -1259,  -1204,   -868,   -468,    110,   1293,   1263,
     -1267,  -1180,  -1238,   -930,   -940,    916,   1793,    653,
      1070,   1137,   -216,   -997,   -845,   -659,   -699,   -174,
       758,    961,    417,    630,  -1123,   1691,   1229,   -732,
      -937,   -491,    -78,    265,    744,    864,   4771,   -856,
     -1005,  -1007,   -934,   -484,    -17,    579,    861,    959,
     -1264,     70,   -961,   -864,   -860,   -302,    314,    788,
       487,    686,  -1133,   -790,   -466,    561,   -812,   -256,
      2078,    -58,    757,    953,  -1133,   -286,   -655,   -476,
       -23,   -629,      7,    182,    426,    504,  -1110,    314,
       497,   -822,   -662,   -754,   1179,   1726,    696,    955,
      1793,  -1143,  -1268,  -1279,  -1207,   -873,   -183,   1546,
      1440,   1305,  -1278,   1396,   -779,    558,   -840,    -32,
       -18,    257,    616,    757,    265,   -906,    499,   -897,
      -846,   -435,    362,    434,    752,    732,    453,    150,
     -1029,  -1182,  -1195,   -940,   -297,    876,   1084,   1051,
     -1377,   1354,  -1148,  -1313,  -1211,   -937,   -366,   1942,
      1323,   1410,    311,   -270,    -81,   -159,     42,     42,
         7,    357,    255,    285,   1973,   1386,   -752,   -873,
      -916,   -466,    -39,    493,    638,    759,  -1338,   1107,
     -1081,  -1165,  -1038,   -484,   1722,    534,   1038,   1102,
     -1446,  -1212,  -1337,  -1452,  -1422,  -1291,   -690,   1634,
      1348,   1640,  -1044,   -184,   -757,   -683,   -100,   1044,
       369,    349,    432,    584,  -1137,   -528,   1425,   1294,
      -842,   -257,    -32,    289,    639,    796,  -1418,  -1229,
     -1282,  -1391,  -1421,  -1234,   -852,   -765,    737,   2076,
     -1104,   -928,   -936,  -1088,    378,   -765,   1603,    581,
       753,    925,  -1191,   -841,   -919,   2886,   -907,   -232,
       180,    543,    956,   1070,  -1314,   -843,    804,  -1094,
     -1209,  -1031,   -626,    698,   1049,   1152,    256,    831,
      -841,   -814,   -841,    -54,    134,    347,    535,    658,
       104,   -801,   -959,   -519,   -406,    156,     12,     13,
       380,    494,  -1144,  -1112,   -973,   -965,   -916,   -474,
      -225,    460,    402,    734,  -1448,  -1316,  -1278,    231,
     -1086,   -578,    584,   1115,   1275,   1260,  -1321,   -963,
     -1127,  -1288,     41,  -1102,    -31,   1331,   1003,   1145,
       112,  -1270,  -1343,  -1376,  -1114,   -778,    392,   1918,
      1165,   1246,  -1247,   -870,  -1232,  -1147,  -1075,    570,
       181,   1983,    971,   1216,  -1309,  -1199,    260,  -1136,
      -950,   -742,   1067,    703,   1150,   1144,  -1405,  -1533,
     -1564,  -1549,  -1264,   -737,   1085,   1706,   1806,   1785,
       282,  -1173,  -1128,  -1188,   -971,   -885,   -291,    254,
       841,    987,   -142,  -1068,  -1264,  -1232,  -1058,    138,
       546,    521,   1096,    987,    890,   -936,  -1020,  -1051,
      -871,   -521,   1686,    625,    930,    936,  -1343,   -924,
     -1231,  -1247,  -1052,   -951,   1110,    125,    826,   1116,
};

static const int16_t fcb44ss[] = {
      6575,   -881,  -1291,  -1258,  -1090,   -517,   -268,    -56,
       106,    295,   -303,  -1134,  -1113,   -650,   -508,   1843,
      -235,   -141,    454,    832,  -1212,    856,   -404,   -620,
      -682,   -487,    -69,    865,    341,     95,   3626,  -1037,
     -1366,  -1349,  -1126,   -558,    187,    343,    657,    765,
      -410,   -735,  -1046,  -1023,   -897,   -673,   -366,   3174,
      1264,    720,   -730,   -922,   -523,   -821,   4042,   -463,
        45,    329,    213,    -93,    301,  -1011,    277,   -840,
      -820,   -451,    417,    470,    739,    953,  -1219,  -1286,
     -1545,  -1426,  -1209,   -803,   1156,   1311,   1329,   1329,
      -643,  -1136,  -1200,   -912,   1221,   -695,    342,    910,
       905,    812,   -996,   -365,   4868,   -738,   -591,   -621,
        17,    -42,      0,    100,   2085,  -1214,  -1434,  -1432,
     -1243,   -577,   -626,    140,   1357,   1821,  -1064,  -1261,
     -1629,  -1525,  -1488,  -1101,   -631,    551,   3556,   3974,
      -635,   -846,  -1005,   -646,   -803,    123,   -151,    357,
      2137,    953,  -1168,  -1055,  -1115,  -1061,   -823,   -651,
      3842,    606,    491,    491,  -1297,  -1063,   -990,  -1051,
     -1202,   -983,   -468,    -47,    163,    336,  -1131,   -446,
      -683,    644,   -660,   -675,   1251,    373,    195,   -123,
     -1109,   -430,   1820,   1883,   -862,   -743,   -265,    119,
        66,    -41,  -1281,   -768,   1941,   -955,  -1054,   -856,
       528,    363,    488,    545,   -936,   -682,   -814,   5534,
      -826,   -347,     58,    -38,    168,     14,   1224,   -719,
      -300,   -766,   -407,    630,    269,     39,   -230,   -701,
      1601,   -958,   -945,   -955,   -734,   -487,    -20,   1392,
       544,    282,   -118,  -1133,  -1161,  -1065,   -939,   -213,
      -129,   -271,    451,   2570,   -895,   -805,   -536,   1455,
      1496,   -647,   -199,    114,     95,    -42,   2230,   -855,
      -715,   -819,   1762,   -699,    -50,   -109,    163,    207,
      -334,   -759,   3297,   -645,   2561,     77,   -239,   -259,
      -275,   -445,  -1304,   3536,   1610,   -526,   -926,   -582,
       -12,     44,   -180,    -69,   -804,   1107,   1451,   -868,
      -851,   -589,   -354,    -85,     88,    336,   -537,   -444,
        40,    231,   -715,   -523,   -351,   -379,   -123,    171,
      1223,   -328,   -567,   2182,   -291,   -352,     20,   -157,
      -338,   -635,   2194,   -476,   1624,   -802,   -762,   -585,
      -245,     48,     63,    -45,    -32,   -646,    847,   -556,
      -727,   -259,   1309,    239,   -128,   -755,  -1018,   -640,
       876,   -642,   -906,   1394,    -26,    338,    204,    148,
      -988,   -521,    135,   -807,   1065,   -525,    -80,   -248,
       383,    836,    521,     13,   -553,   -865,   -928,   -631,
      -137,    -83,    446,    221,   1924,     48,   -621,   -845,
      -782,   -544,   -531,   -418,    -79,    915,   -711,   1247,
      -938,   -766,   -995,   1459,     31,    199,    261,    190,
      -670,  -1207,  -1013,    108,   -670,    204,    407,    266,
       473,    998,   -606,   -923,   1845,  -1061,    910,   -774,
       268,    493,    178,     61,   1938,  -1237,  -1010,  -1097,
      -780,   -368,   1125,    354,    398,    550,   1032,  -1128,
     -1196,   -908,   -767,    529,   2326,    728,    227,    -13,
     -1113,   -367,    382,   -939,  -1094,   -896,   -463,    446,
       896,   1128,   -591,   -823,   -894,   3052,   -968,   2157,
      -153,    -71,    111,    118,  -1106,   -930,   -911,   1663,
      -905,   -691,   -226,    503,    665,    702,   2067,  -1149,
      -828,    990,   -850,   -426,   -159,    148,    379,    512,
     -1268,  -1390,  -1492,  -1343,  -1419,   2246,   -224,   2124,
      1523,   1338,    522,   1613,   -344,   -694,   -487,   -325,
       293,     96,   -374,   -679,   -364,    124,  -1201,  -1274,
     -1078,   -513,     15,   1045,    529,    680,    131,  -1067,
     -1030,   -888,   -806,   -122,   1002,   1302,    757,   -473,
      -530,   -538,   -821,   -373,     72,    797,    864,    265,
      -542,  -1090,   -241,  -1095,  -1205,   -991,  -1172,   5025,
      -420,    728,    461,    103,   2325,   -915,  -1012,   -854,
     -1117,   2018,   -377,    -35,    266,    443,   -949,  -1163,
     -1064,  -1057,   -802,    721,   1278,    470,    308,    263,
       474,   -773,  -1033,   -892,    227,    -30,     39,    101,
       456,    476,  -1263,   7275,   -946,  -1157,  -1304,   -922,
       248,    143,    -98,    312,   3419,   -402,   -649,   -629,
      -554,    -48,    487,     72,   -171,   -687,  -1167,   1869,
      -524,   1490,   -869,   -236,    111,     68,     77,    -85,
      1481,    906,  -1189,  -1321,  -1124,   -554,    429,    321,
       814,    699,  -1048,    486,   -858,  -1096,  -1072,   -744,
      1676,    -73,    593,    632,    779,  -1265,  -1470,  -1379,
     -1050,   -548,    781,    524,   1022,   1079,  -1149,   3719,
     -1064,  -1180,  -1159,   -775,   -211,    241,    492,    555,
      3025,   2828,   -849,  -1133,  -1063,   -567,    -70,   -142,
      -176,    -62,   -614,   1745,   -684,   -610,   1478,   -619,
      -235,   -361,    -84,    -44,  -1155,   1494,  -1183,  -1210,
     -1294,  -1017,   -330,    210,    931,   1368,  -1306,   2714,
     -1052,  -1128,  -1220,   -908,   2409,    441,    310,    318,
};

static const int16_t fcb44sm[] = {
      5619,   -163,  -1005,   -856,   -831,   -644,   -612,   -759,
      -770,   -456,    199,   -551,  -1348,    -80,    131,   -481,
       334,    202,    366,   1246,  -1245,    499,  -1454,   -396,
      -675,   -257,    525,   1001,    878,   1075,  -1004,  -1010,
     -1127,   -947,   -976,    332,   3533,   1315,    265,   -683,
     -1114,   1056,  -1009,   1154,   -728,   -212,    620,    169,
       102,   -110,   -658,   -902,  -1238,  -1213,  -1238,   -926,
      -735,   -455,   1130,   5139,  -1184,    190,   1590,   -604,
      -800,   -373,   -366,    251,    720,    571,     -6,    304,
     -1228,   -369,   -659,   -506,    -25,   -234,    313,   2366,
       623,   1473,   -315,    780,   1048,   -416,   -586,   -737,
     -1029,  -1094,    483,   -725,   -771,   -379,   -268,    -15,
       697,   1774,     -1,   -999,   -987,   -867,  -1339,  -1255,
     -1018,   -652,   -125,    643,   3006,   2417,   -543,   1629,
      1557,   -684,   -568,   -474,   -132,   -291,   -338,   -321,
     -1250,    641,   -158,   -935,   -575,   -575,    154,    415,
       798,   1421,   3147,   1903,   -335,   -767,   -729,   -627,
      -611,   -752,   -836,   -735,    678,    502,   -946,    556,
      -821,    -51,   -256,     94,    151,     70,   -808,   -324,
      -359,   3637,    286,    -90,   -365,   -613,   -782,   -871,
        75,   1051,   -780,   -487,     47,    273,   1768,   -102,
      -828,  -1267,  -1093,   1420,   -624,    225,   1307,     85,
       239,   -152,   -649,   -853,  -1072,   -796,   -644,   1383,
      1143,   -199,     94,    -25,     70,     52,  -1064,   2487,
      -844,   -607,   -587,    148,    726,    224,   -238,   -484,
      -957,   -729,   1517,   1334,   -475,   -317,   -253,   -186,
         1,     17,   -832,   1450,    423,   1408,   -576,   -825,
      -630,   -579,   -312,    314,    788,    382,  -1000,  -1060,
      -763,    968,   -135,     56,    143,    477,   -736,     30,
      4023,     68,   -266,   -420,   -538,   -751,   -893,   -879,
      -935,     59,    465,    887,   -351,   1396,    176,   -250,
      -684,  -1019,   -515,   -815,   -957,   -439,    188,   3794,
        86,    -98,   -245,   -829,   1894,   -386,   -865,   1513,
        24,   -506,   -281,   -615,   -476,   -364,  -1283,   -963,
      -339,   -133,   -161,   -480,     25,    230,   1364,   1815,
      1766,   -844,  -1423,  -1185,   -972,   -458,   -275,    138,
      1317,   1778,  -1295,   -874,  -1211,   -792,   -601,   -500,
      2301,    901,   1336,    842,   1355,   -426,  -1160,   -959,
      -801,   -433,   1852,    144,    284,    169,  -1122,   -851,
      -957,    272,   -393,    817,    862,    262,    333,    802,
       320,   -576,   1615,   -615,   -886,   -311,    108,     13,
         1,    320,  -1205,    962,   -483,   -791,   -749,   1158,
       677,    -57,    166,    279,   -860,   1237,   -971,  -1057,
      -598,   -285,    884,   1174,    657,   -303,   2254,   -706,
     -1113,   -655,    719,    234,   -124,   -199,   -135,   -360,
      -758,   -623,   -385,    -18,   3243,    470,   -139,   -286,
      -520,   -953,  -1193,  -1140,  -1297,  -1137,   -764,     25,
       235,   2217,   1501,   1369,   2024,    781,  -1353,   -835,
      -824,   -601,   -259,   -140,    387,    671,      3,   -974,
      -760,   -884,   -485,    709,   1505,    -95,    321,    739,
      1610,   -156,   1515,    -76,   -420,   -369,   -189,   -506,
      -705,   -907,  -1052,   -516,  -1048,   -996,   -471,   1195,
       212,    184,    800,   1665,    747,  -1029,  -1013,    789,
      -703,    559,   -139,    -98,    380,    523,   -355,   2047,
      -766,   -991,   -809,   -566,   -257,   -242,    485,   1322,
      1989,   -330,   -945,   -559,   -448,   1241,    811,     10,
      -767,  -1218,   1600,   -755,    428,   -729,   -355,   -665,
      -416,   -120,    381,    548,   -717,    -14,   1587,   -886,
        -9,    353,    839,    201,   -454,  -1112,  -1334,   -309,
       660,   -375,   -661,   -511,   1437,    540,    492,      0,
        95,   3911,   -237,   -301,   -562,   -483,   -569,   -799,
      -883,   -580,   -670,   -980,  -1056,   -896,   -797,   1551,
       267,   1000,   1617,     75,  -1132,   -403,   -988,   -830,
      -627,   1164,   1315,   1594,    310,   -564,  -1091,   -563,
      1195,   -442,   1086,   -344,   -176,   -258,    175,    476,
       923,    -37,   -629,   -919,   1278,   -610,    113,   -314,
       -81,    192,    731,   -944,  -1297,  -1108,   -934,   -259,
       640,   1164,   1326,    558,   -767,   -519,   -875,   -930,
      -817,   -533,    496,   2605,   1359,   -131,  -1010,    912,
     -1055,   -309,    768,   -198,   -166,    -76,    429,    640,
      3283,   -895,  -1229,   -853,   -853,   -399,    147,     44,
       237,    495,   -833,   -909,  -1004,   -811,   1039,   1627,
      -194,    295,    738,    290,   -771,    237,   -912,   -479,
      -648,   -518,   -226,    573,   2346,    419,   1013,   1510,
      -865,   -873,   -982,   -557,    598,     50,     81,    -81,
     -1150,   -640,  -1011,   1991,   -561,   -140,     42,    175,
       521,    799,   3231,    -46,  -1004,   -994,  -1140,  -1094,
      -957,   -860,      8,   2346,    212,   -499,    -55,   -997,
      -623,   -588,     38,    -58,    975,   1529,   -986,   -891,
     -1121,   -619,   1967,   -463,     -7,    632,    768,    953,
};

static const float lsp8[] = {
     0.2702,  0.5096,  0.6437,  0.7672,  0.9639,  1.0696,  1.2625,  1.5789,
     1.9285,  2.2383,  2.5129,  2.8470,  0.1740,  0.3677,  0.6082,  0.8387,
     1.1084,  1.3721,  1.6362,  1.8733,  2.0640,  2.3442,  2.6087,  2.8548,
     0.1536,  0.3279,  0.5143,  0.6859,  0.9763,  1.2744,  1.5605,  1.8566,
     2.1007,  2.3450,  2.6075,  2.8850,  0.2075,  0.4533,  0.7709,  1.0377,
     1.2953,  1.5132,  1.7826,  2.0351,  2.2590,  2.4996,  2.6795,  2.8748,
     0.1393,  0.2453,  0.3754,  0.5453,  0.8148,  1.1289,  1.4389,  1.7592,
     2.0353,  2.3215,  2.5934,  2.8588,  0.1250,  0.3627,  0.7613,  1.1380,
     1.4163,  1.5565,  1.6920,  1.8130,  1.8678,  2.0427,  2.4318,  2.8544,
     0.2256,  0.4223,  0.6452,  0.8599,  1.0673,  1.3118,  1.5486,  1.8366,
     2.0759,  2.3026,  2.5284,  2.8030,  0.2304,  0.4404,  0.6891,  0.8964,
     1.1510,  1.4202,  1.6483,  1.8580,  2.1181,  2.3686,  2.6078,  2.9128,
     0.2230,  0.3816,  0.5520,  0.6062,  0.7909,  1.0988,  1.4330,  1.7846,
     2.0713,  2.3457,  2.6048,  2.8708,  0.2447,  0.5800,  0.8249,  0.9905,
     1.1721,  1.3990,  1.6694,  1.9064,  2.1307,  2.4255,  2.6815,  2.9117,
     0.1974,  0.3812,  0.5802,  0.7759,  0.9280,  1.1547,  1.4170,  1.6369,
     1.8890,  2.2587,  2.5626,  2.8239,  0.1209,  0.2510,  0.4841,  0.8048,
     1.1197,  1.3563,  1.6073,  1.8926,  2.1350,  2.3669,  2.6291,  2.8985,
     0.2352,  0.4347,  0.6582,  0.8178,  0.9548,  1.1654,  1.4942,  1.8812,
     2.1703,  2.3779,  2.6412,  2.8871,  0.2091,  0.4084,  0.6730,  0.9151,
     1.1259,  1.3262,  1.5937,  1.8129,  2.0237,  2.3317,  2.5778,  2.8620,
     0.1167,  0.2406,  0.4520,  0.7298,  0.9848,  1.2448,  1.5137,  1.7874,
     2.0280,  2.3020,  2.5914,  2.8794,  0.3003,  0.4966,  0.6520,  0.8505,
     1.1600,  1.3981,  1.5805,  1.8346,  2.0757,  2.3102,  2.5760,  2.8499,
     0.2451,  0.4163,  0.5960,  0.7805,  0.9507,  1.2438,  1.5587,  1.8581,
     2.0735,  2.3198,  2.5704,  2.8220,  0.3112,  0.5517,  0.7032,  0.8528,
     1.1489,  1.4257,  1.6848,  1.9388,  2.1577,  2.4265,  2.6678,  2.9051,
     0.2249,  0.3897,  0.5559,  0.7473,  1.0158,  1.3581,  1.6914,  1.9930,
     2.1843,  2.3534,  2.5512,  2.8065,  0.2600,  0.4574,  0.7349,  0.9691,
     1.1696,  1.3848,  1.6335,  1.9021,  2.1174,  2.3481,  2.5902,  2.8390,
     0.2246,  0.3372,  0.4560,  0.5249,  0.7056,  1.0273,  1.3810,  1.7132,
     1.9819,  2.2574,  2.5410,  2.8491,  0.1419,  0.4834,  0.8835,  1.1453,
     1.2839,  1.4224,  1.5593,  1.7877,  2.1285,  2.4070,  2.6043,  2.8511,
     0.1886,  0.3677,  0.5617,  0.8099,  1.1277,  1.3841,  1.5804,  1.8136,
     2.0307,  2.2805,  2.5399,  2.8322,  0.2351,  0.4151,  0.6675,  0.8713,
     1.0464,  1.3292,  1.6586,  1.9281,  2.1355,  2.3495,  2.6222,  2.8782,
     0.2700,  0.4489,  0.6206,  0.7121,  0.7737,  0.9848,  1.3658,  1.7433,
     2.0139,  2.2243,  2.4806,  2.8175,  0.2479,  0.4425,  0.6490,  0.8745,
     1.1161,  1.3849,  1.6773,  1.9566,  2.1491,  2.3624,  2.5685,  2.8114,
     0.2035,  0.3701,  0.5567,  0.7953,  1.0082,  1.2758,  1.5373,  1.7822,
     2.0175,  2.2601,  2.4759,  2.7771,  0.1856,  0.3461,  0.5998,  0.9041,
     1.2383,  1.4612,  1.6667,  1.9305,  2.1617,  2.4107,  2.6477,  2.8656,
     0.2107,  0.3715,  0.5289,  0.6651,  0.8420,  1.1168,  1.4401,  1.7230,
     1.9901,  2.2687,  2.5452,  2.8655,  0.1218,  0.2999,  0.6348,  0.9482,
     1.2745,  1.5876,  1.9129,  2.2348,  2.4020,  2.4922,  2.6351,  2.8357,
     0.1617,  0.3483,  0.5869,  0.8163,  1.0366,  1.2344,  1.4609,  1.7029,
     1.9476,  2.2337,  2.5258,  2.8442,  0.2505,  0.4894,  0.7510,  0.9152,
     1.0845,  1.3657,  1.6528,  1.8346,  2.0160,  2.2811,  2.5338,  2.8136,
     0.0947,  0.1158,  0.0578, -0.0337, -0.0066,  0.0104, -0.0447, -0.0505,
    -0.0778, -0.0293,  0.0251, -0.0143,  0.0349, -0.0227, -0.0909,  0.0523,
     0.0325, -0.0410, -0.1045, -0.0899, -0.0009,  0.0075, -0.0575, -0.0855,
    -0.0129,  0.0575,  0.0597,  0.0391,  0.0371, -0.0184, -0.0083,  0.0287,
     0.0143,  0.0167,  0.0120, -0.0168,  0.0452,  0.0223, -0.0352,  0.0119,
    -0.0496, -0.0965, -0.0661, -0.0072,  0.1099,  0.0843, -0.0087, -0.0478,
    -0.0128, -0.0120, -0.0004,  0.0731,  0.1047,  0.0630,  0.0196, -0.0103,
    -0.0399, -0.0986, -0.0912, -0.0390, -0.0247, -0.0694, -0.0749, -0.0066,
     0.0223,  0.0634,  0.0343, -0.0134,  0.0727,  0.0241,  0.0066,  0.0437,
     0.0610,  0.0364,  0.0248, -0.0358, -0.0686, -0.0104,  0.0426,  0.0088,
    -0.0137, -0.0165,  0.0671,  0.0815, -0.0863, -0.0644, -0.0088,  0.0023,
     0.0482,  0.1174,  0.1270,  0.0594,  0.0165,  0.0949,  0.1098,  0.0137,
     0.4951,  0.4999,  0.4958,  0.4907,  0.4984,  0.4965,  0.4958,  0.4996,
     0.4987,  0.4958,  0.4986,  0.4977,  0.2841,  0.2186,  0.1474,  0.1687,
     0.2217,  0.2632,  0.2706,  0.2624,  0.2162,  0.2453,  0.2460,  0.2531
};

static const float lsp16[] = {
     0.1813,  0.3911,  0.6301,  0.8012,  1.0057,  1.2041,  1.4271,  1.6943,
     1.9402,  2.1733,  2.3521,  2.4989,  2.5839,  2.6846,  2.7634,  2.8950,
     0.1311,  0.3183,  0.4659,  0.5601,  0.6658,  0.7828,  1.0065,  1.2717,
     1.5185,  1.7339,  1.9530,  2.2189,  2.3739,  2.4991,  2.6984,  2.9256,
     0.1627,  0.4519,  0.6323,  0.7012,  0.7848,  0.9801,  1.1810,  1.3222,
     1.5413,  1.8129,  1.9338,  2.0809,  2.3180,  2.5189,  2.7066,  2.9514,
     0.1475,  0.2447,  0.4240,  0.5669,  0.7872,  0.9838,  1.1823,  1.3814,
     1.5358,  1.6820,  1.8794,  2.1419,  2.4132,  2.6112,  2.7911,  2.9511,
     0.1224,  0.2876,  0.5013,  0.6985,  0.8902,  1.0901,  1.2835,  1.4768,
     1.6596,  1.8538,  2.0467,  2.2304,  2.4124,  2.5942,  2.7729,  2.9531,
     0.1741,  0.3034,  0.4677,  0.5879,  0.7258,  0.9648,  1.1417,  1.3220,
     1.5081,  1.7151,  1.9212,  2.1286,  2.3208,  2.4938,  2.6765,  2.8891,
     0.1657,  0.3174,  0.4907,  0.6559,  0.8295,  1.0254,  1.2071,  1.3880,
     1.5737,  1.7845,  1.9027,  2.1139,  2.3323,  2.5157,  2.7323,  2.9015,
     0.1592,  0.2758,  0.4417,  0.6315,  0.8257,  0.9873,  1.1277,  1.2830,
     1.4337,  1.6315,  1.8899,  2.1356,  2.3572,  2.5632,  2.7468,  2.9420,
     0.1524,  0.4325,  0.5931,  0.7036,  0.7696,  0.8923,  1.1739,  1.4773,
     1.6609,  1.7911,  1.9666,  2.1972,  2.3754,  2.5045,  2.6613,  2.8882,
     0.2130,  0.3013,  0.3721,  0.4257,  0.5079,  0.7015,  0.9815,  1.2554,
     1.4648,  1.6966,  1.9138,  2.1075,  2.3318,  2.5292,  2.7453,  2.9347,
     0.1142,  0.3748,  0.6205,  0.7642,  0.8121,  0.9022,  0.9843,  1.1558,
     1.4467,  1.7422,  1.9574,  2.1302,  2.3812,  2.5898,  2.7720,  2.9583,
     0.1255,  0.2339,  0.3570,  0.5323,  0.7458,  1.0003,  1.1729,  1.3567,
     1.5217,  1.6977,  1.8924,  2.0942,  2.3145,  2.5408,  2.7553,  2.9337,
     0.1316,  0.2289,  0.4327,  0.6663,  0.8509,  0.9994,  1.1697,  1.3804,
     1.5609,  1.6903,  1.8572,  2.1019,  2.3687,  2.5789,  2.7715,  2.9472,
     0.1502,  0.2546,  0.3883,  0.5333,  0.6976,  0.9163,  1.1071,  1.3364,
     1.5420,  1.7525,  1.8948,  2.0839,  2.2819,  2.4651,  2.6875,  2.8987,
     0.1593,  0.3014,  0.4573,  0.6354,  0.8157,  0.9805,  1.1783,  1.3747,
     1.5678,  1.7326,  1.9286,  2.1340,  2.3253,  2.5280,  2.7180,  2.9298,
     0.1811,  0.3167,  0.4655,  0.6507,  0.8198,  1.0075,  1.1892,  1.3743,
     1.5227,  1.7090,  1.8849,  2.0743,  2.2750,  2.4830,  2.6896,  2.8953,
     0.1846,  0.3577,  0.5315,  0.7290,  0.9176,  1.1016,  1.2654,  1.4525,
     1.6315,  1.8268,  2.0238,  2.1934,  2.3868,  2.5753,  2.7682,  2.9469,
     0.0876,  0.1439,  0.2048,  0.3654,  0.6281,  0.8853,  1.0907,  1.2992,
     1.5227,  1.7373,  1.9395,  2.1419,  2.3488,  2.5486,  2.7466,  2.9348,
     0.1391,  0.4170,  0.6561,  0.7953,  0.8734,  0.9986,  1.1870,  1.4520,
     1.6042,  1.7910,  2.0135,  2.1870,  2.3358,  2.5066,  2.7409,  2.9955,
     0.0804,  0.1355,  0.2599,  0.4998,  0.7408,  0.9474,  1.1276,  1.3428,
     1.5556,  1.7712,  1.9699,  2.1535,  2.3605,  2.5548,  2.7489,  2.9325,
     0.1304,  0.3087,  0.4979,  0.6584,  0.8414,  1.0329,  1.2244,  1.4189,
     1.6118,  1.8200,  1.9985,  2.1893,  2.3915,  2.5794,  2.7647,  2.9344,
     0.1895,  0.2849,  0.3705,  0.4126,  0.6265,  0.9207,  1.1774,  1.3762,
     1.5757,  1.7728,  1.9568,  2.1662,  2.3615,  2.5575,  2.7561,  2.9416,
     0.1800,  0.3078,  0.4805,  0.6796,  0.8503,  1.0046,  1.1703,  1.3269,
     1.4862,  1.6502,  1.8454,  2.0873,  2.3175,  2.5356,  2.7516,  2.9469,
     0.1950,  0.3233,  0.4568,  0.5940,  0.7589,  0.9978,  1.1701,  1.3383,
     1.5017,  1.6565,  1.8243,  2.0605,  2.2938,  2.5147,  2.7419,  2.9396,
     0.2531,  0.4391,  0.5790,  0.7170,  0.8998,  1.1430,  1.3577,  1.5326,
     1.6328,  1.7627,  1.9726,  2.1762,  2.3563,  2.5478,  2.7385,  2.9067,
     0.1805,  0.2788,  0.3591,  0.3881,  0.5441,  0.8055,  1.0766,  1.3165,
     1.5316,  1.7508,  1.9477,  2.1374,  2.3438,  2.5484,  2.7501,  2.9410,
     0.2044,  0.3671,  0.5396,  0.7042,  0.8582,  0.9831,  1.1261,  1.3194,
     1.4769,  1.6979,  1.8717,  2.0463,  2.2620,  2.4739,  2.7054,  2.9208,
     0.1048,  0.2175,  0.4206,  0.5923,  0.7483,  0.9400,  1.1356,  1.3799,
     1.5958,  1.7320,  1.8984,  2.1296,  2.3594,  2.5492,  2.7387,  2.9305,
     0.0842,  0.1729,  0.3951,  0.6447,  0.8688,  1.0605,  1.2472,  1.4330,
     1.6232,  1.8144,  2.0216,  2.1915,  2.3878,  2.5763,  2.7685,  2.9464,
     0.1461,  0.2593,  0.4105,  0.5677,  0.7328,  0.8919,  1.0484,  1.2302,
     1.4386,  1.6635,  1.8873,  2.1024,  2.3116,  2.5268,  2.7273,  2.9269,
     0.1503,  0.3108,  0.4756,  0.6731,  0.8600,  1.0233,  1.2115,  1.3971,
     1.5915,  1.7892,  1.9517,  2.1603,  2.3487,  2.5460,  2.7308,  2.8998,
     0.2163,  0.3669,  0.5125,  0.6709,  0.8143,  0.9930,  1.2095,  1.4205,
     1.6176,  1.7112,  1.8398,  2.0896,  2.3513,  2.5290,  2.6667,  2.8960,
     0.2133,  0.4382,  0.6287,  0.8702,  1.1088,  1.3749,  1.6062,  1.7446,
     1.8333,  1.9122,  1.9614,  2.0669,  2.1789,  2.3449,  2.6038,  2.8849,
     0.1598,  0.2719,  0.3877,  0.4815,  0.5926,  0.7795,  1.0449,  1.3045,
     1.5210,  1.7391,  1.9462,  2.1397,  2.3553,  2.5458,  2.7540,  2.9392,
     0.2918,  0.5607,  0.6801,  0.7404,  0.8285,  0.9431,  1.1579,  1.4080,
     1.6332,  1.8472,  1.9738,  2.0771,  2.2890,  2.5178,  2.7445,  2.9830,
     0.1664,  0.2842,  0.3965,  0.5463,  0.8162,  1.0346,  1.1849,  1.3446,
     1.5122,  1.7563,  1.9960,  2.2002,  2.3796,  2.5689,  2.7712,  2.9550,
     0.0911,  0.2397,  0.5052,  0.7868,  1.0299,  1.1311,  1.2244,  1.3333,
     1.4395,  1.6790,  1.9369,  2.1717,  2.3689,  2.5538,  2.7340,  2.9326,
     0.1647,  0.2931,  0.3836,  0.4978,  0.6255,  0.9243,  1.1339,  1.3001,
     1.5269,  1.8010,  1.9715,  2.1419,  2.3784,  2.5503,  2.6719,  2.8745,
     0.2440,  0.3802,  0.4756,  0.6613,  0.8627,  1.0292,  1.2291,  1.4060,
     1.5198,  1.7354,  1.9044,  2.1010,  2.3147,  2.4996,  2.7171,  2.9041,
     0.1590,  0.2876,  0.4572,  0.5996,  0.7713,  0.9490,  1.1205,  1.2815,
     1.4516,  1.6385,  1.8179,  2.0457,  2.2759,  2.4785,  2.6861,  2.9080,
     0.2297,  0.4309,  0.5712,  0.6717,  0.8138,  1.0463,  1.2492,  1.4560,
     1.6796,  1.8458,  1.9642,  2.1452,  2.3636,  2.5395,  2.7456,  2.9495,
     0.2975,  0.4678,  0.4996,  0.5809,  0.6279,  0.6884,  0.8606,  1.1386,
     1.4412,  1.6876,  1.8760,  2.0932,  2.3178,  2.5166,  2.7345,  2.9280,
     0.1278,  0.3737,  0.6004,  0.7069,  0.8147,  1.0180,  1.2581,  1.3812,
     1.4855,  1.7268,  1.9970,  2.1258,  2.2936,  2.5702,  2.7563,  2.8983,
     0.1314,  0.2508,  0.3999,  0.5680,  0.7424,  0.9367,  1.1286,  1.3175,
     1.5336,  1.7404,  1.9317,  2.1404,  2.3514,  2.5562,  2.7510,  2.9402,
     0.1043,  0.2367,  0.4293,  0.6376,  0.8160,  0.9836,  1.1779,  1.3850,
     1.5835,  1.7875,  1.9765,  2.1593,  2.3654,  2.5577,  2.7465,  2.9398,
     0.1529,  0.2515,  0.3454,  0.4374,  0.7011,  0.9015,  1.0744,  1.3532,
     1.5699,  1.7545,  2.0021,  2.1259,  2.2278,  2.4546,  2.7264,  2.9425,
     0.1429,  0.2808,  0.4395,  0.6334,  0.8069,  0.9705,  1.1520,  1.3250,
     1.5109,  1.7285,  1.9356,  2.1469,  2.3479,  2.5554,  2.7512,  2.9348,
     0.1625,  0.3022,  0.4756,  0.6315,  0.8032,  0.9924,  1.1596,  1.3204,
     1.4994,  1.6929,  1.8955,  2.1090,  2.3025,  2.5018,  2.6908,  2.8980,
     0.1692,  0.3427,  0.5228,  0.7756,  0.9688,  1.0950,  1.3056,  1.4360,
     1.5675,  1.8049,  1.9376,  2.1151,  2.3407,  2.5012,  2.7192,  2.9258,
     0.0474,  0.1251,  0.1939,  0.3841,  0.6501,  0.9231,  1.1153,  1.3240,
     1.5478,  1.7599,  1.9651,  2.1510,  2.3645,  2.5552,  2.7542,  2.9393,
     0.2196,  0.4656,  0.7492,  0.9922,  1.1678,  1.2489,  1.3112,  1.3657,
     1.4223,  1.5302,  1.7212,  1.9996,  2.2523,  2.4844,  2.7036,  2.9145,
     0.1128,  0.2368,  0.3704,  0.5476,  0.7723,  0.9968,  1.1930,  1.3992,
     1.6013,  1.7957,  1.9888,  2.1857,  2.3825,  2.5705,  2.7616,  2.9434,
     0.1341,  0.2768,  0.4510,  0.6359,  0.8332,  1.0335,  1.2004,  1.3952,
     1.5762,  1.7681,  1.9815,  2.1735,  2.3657,  2.5552,  2.7514,  2.9498,
     0.1247,  0.2559,  0.3516,  0.4726,  0.6861,  0.9483,  1.1852,  1.3858,
     1.5851,  1.7815,  1.9778,  2.1737,  2.3729,  2.5664,  2.7620,  2.9429,
     0.1988,  0.3320,  0.4777,  0.6737,  0.8425,  1.0265,  1.1694,  1.3655,
     1.5463,  1.7135,  1.9385,  2.1650,  2.3529,  2.5367,  2.7545,  2.9585,
     0.1376,  0.2620,  0.4273,  0.6169,  0.7755,  0.9441,  1.1169,  1.3157,
     1.5179,  1.7020,  1.8931,  2.1059,  2.3112,  2.5136,  2.7169,  2.9198,
     0.2112,  0.4385,  0.6091,  0.7618,  0.9553,  1.1543,  1.3445,  1.5396,
     1.7153,  1.9192,  2.1263,  2.3593,  2.5958,  2.8171,  2.9394,  3.0409,
     0.1347,  0.2099,  0.2646,  0.3453,  0.5266,  0.7869,  1.0513,  1.2795,
     1.4880,  1.7181,  1.9294,  2.1332,  2.3362,  2.5442,  2.7433,  2.9362,
     0.3141,  0.5935,  0.7517,  0.8313,  0.8568,  0.9570,  1.0250,  1.1275,
     1.3422,  1.6303,  1.8577,  2.0705,  2.2957,  2.5095,  2.7244,  2.9262,
     0.0962,  0.2116,  0.3961,  0.5641,  0.7122,  0.8883,  1.1023,  1.3481,
     1.5623,  1.7554,  1.9618,  2.1675,  2.3706,  2.5556,  2.7430,  2.9337,
     0.0898,  0.1510,  0.3060,  0.5820,  0.8221,  1.0388,  1.2261,  1.4289,
     1.6054,  1.8103,  1.9941,  2.1844,  2.3742,  2.5711,  2.7632,  2.9474,
     0.1326,  0.2316,  0.3761,  0.5177,  0.6782,  0.8761,  1.0952,  1.3175,
     1.5078,  1.7034,  1.9051,  2.1245,  2.3424,  2.5484,  2.7444,  2.9389,
     0.1740,  0.3293,  0.5174,  0.6824,  0.8394,  1.0372,  1.2046,  1.3723,
     1.5656,  1.7444,  1.9442,  2.1386,  2.3139,  2.4960,  2.7071,  2.9297,
     0.2304,  0.3775,  0.4865,  0.6182,  0.7842,  0.9208,  1.1151,  1.2843,
     1.4641,  1.6988,  1.9209,  2.1260,  2.3099,  2.5229,  2.7414,  2.9276,
     0.0094,  0.0261, -0.0037,  0.0041, -0.0092, -0.0044, -0.0232, -0.0073,
    -0.0047, -0.0021,  0.0250, -0.0580, -0.0140, -0.0342, -0.0586,  0.0020,
     0.0449,  0.0155, -0.0523, -0.0279,  0.0299, -0.0183, -0.0736, -0.0639,
    -0.0017,  0.0336,  0.0209,  0.0046,  0.0077, -0.0148, -0.0114, -0.0120,
     0.0115, -0.0050,  0.0445,  0.0048,  0.0188, -0.0137, -0.0080,  0.0239,
    -0.0184, -0.0524, -0.0195, -0.0126,  0.0284,  0.0632,  0.0141, -0.0093,
    -0.0096,  0.0196,  0.0230,  0.0379,  0.0308,  0.0237, -0.0224, -0.0600,
    -0.0755, -0.1074, -0.0988, -0.0606, -0.1038, -0.1552, -0.1480, -0.0672,
     0.0504,  0.0676,  0.0336, -0.0042,  0.0729,  0.1013,  0.0868,  0.0846,
     0.0954,  0.0515, -0.0066, -0.0851, -0.0485,  0.0294,  0.0395,  0.0087,
     0.0078,  0.0446,  0.0881,  0.0672, -0.0384, -0.0025,  0.0415,  0.0353,
     0.0080,  0.0052,  0.0190,  0.0182,  0.0069,  0.0168,  0.0374,  0.0037,
    -0.0292, -0.0429,  0.0302,  0.0681, -0.0233, -0.0238, -0.0003, -0.0043,
     0.0054, -0.0029, -0.0149,  0.0642,  0.0622,  0.0341, -0.0232, -0.0461,
    -0.0082, -0.0469, -0.0618, -0.0326, -0.0452, -0.0649, -0.0597, -0.0398,
    -0.0318, -0.0116,  0.0011,  0.0009, -0.0384, -0.0384, -0.0156, -0.0260,
    -0.0007,  0.0473,  0.0111, -0.0358, -0.0484, -0.0204, -0.0029, -0.0090,
    -0.0285, -0.0495, -0.0376,  0.0917,  0.1192,  0.1026,  0.0745,  0.0397,
     0.0463,  0.0253,  0.0025,  0.0465,  0.0100,  0.0488,  0.0416,  0.0223,
     0.0263,  0.0072, -0.0053,  0.0595,  0.0060, -0.0518, -0.0316, -0.0043,
    -0.0133, -0.0233, -0.0075, -0.0251,  0.0277, -0.0067, -0.0136, -0.0004,
     0.0235,  0.0112, -0.0182, -0.0324, -0.0210, -0.0035, -0.0395, -0.0384,
     0.0005, -0.0150, -0.0356,  0.0127, -0.0033, -0.0034,  0.0205,  0.0747,
     0.1138,  0.1015,  0.0995, -0.0161, -0.0045,  0.0129,  0.0472,  0.0575,
     0.0222,  0.0091,  0.0037, -0.0471,  0.0371,  0.0132,  0.0208,  0.0247,
     0.0117,  0.0164,  0.0225,  0.0124, -0.0023,  0.0088, -0.0046,  0.0047,
    -0.0393,  0.0018,  0.0148,  0.0020,  0.0044,  0.0165,  0.0229, -0.0208,
    -0.0477, -0.0310, -0.0164, -0.0390, -0.0764, -0.0525, -0.0094,  0.0075,
    -0.0102, -0.0045, -0.0504, -0.0709,  0.0822,  0.0710,  0.0426,  0.0014,
    -0.0371, -0.0400, -0.0157, -0.0155, -0.0173, -0.0138, -0.0015,  0.0134,
    -0.0418, -0.0682, -0.0256,  0.0050,  0.0360,  0.0354,  0.0074, -0.0396,
    -0.0235,  0.0284,  0.0494,  0.0153,  0.0448,  0.0025, -0.0061,  0.0252,
     0.1000,  0.2260,  0.2158,  0.2116,  0.2198,  0.2055,  0.2110,  0.1873,
     0.1907,  0.2071,  0.2164,  0.2009,  0.2059,  0.2124,  0.2141,  0.2093,
     0.0875,  0.0981,  0.1177,  0.1071,  0.1033,  0.1248,  0.1048,  0.1238,
     0.1166,  0.1008,  0.1062,  0.0992,  0.0994,  0.1067,  0.0999,  0.1187,
     0.0750,  0.0794,  0.0828,  0.0854,  0.0859,  0.0801,  0.0891,  0.0933,
     0.0969,  0.0920,  0.0915,  0.0862,  0.0868,  0.0891,  0.0842,  0.0824,
     0.0625,  0.0930,  0.0815,  0.0853,  0.0898,  0.0828,  0.0822,  0.0910,
     0.0873,  0.0906,  0.0856,  0.0840,  0.0774,  0.0785,  0.0684,  0.0711,
     0.3319,  0.4219,  0.4588,  0.4090,  0.4092,  0.4014,  0.3548,  0.3353,
     0.3708,  0.3352,  0.3720,  0.3538,  0.4084,  0.4289,  0.4060,  0.4210,
     0.0588,  0.0209, -0.0082, -0.0115, -0.0343, -0.0621, -0.0541, -0.0346,
    -0.0346, -0.0366, -0.0220, -0.0265, -0.0102,  0.0374,  0.0306,  0.0404,
     0.0306,  0.0090, -0.0054,  0.0333,  0.0047,  0.0238,  0.0141,  0.0165,
     0.0306,  0.0420,  0.0159,  0.0124,  0.0414,  0.0158, -0.0237,  0.0141,
     0.0765,  0.0057, -0.0260, -0.0426, -0.0395, -0.0126, -0.0579, -0.0417,
    -0.0429, -0.0615, -0.0893, -0.0618, -0.0384, -0.0134, -0.0232, -0.0238
};

static const float lsp44s[] = {
     0.0927,  0.2291,  0.4059,  0.5779,  0.7288,  0.8821,  1.0377,  1.1915,
     1.3433,  1.4931,  1.6475,  1.7989,  1.9381,  2.0858,  2.2321,  2.3765,
     2.5187,  2.6530,  2.7895,  2.9354,  0.0944,  0.1974,  0.3046,  0.4714,
     0.6116,  0.7829,  0.9027,  1.0375,  1.1869,  1.3488,  1.5036,  1.6781,
     1.8276,  1.9983,  2.1449,  2.3089,  2.4534,  2.6113,  2.7553,  2.9062,
     0.1168,  0.2843,  0.4907,  0.6706,  0.8100,  0.9417,  1.0753,  1.2014,
     1.3151,  1.4496,  1.5832,  1.7379,  1.8642,  2.0230,  2.1681,  2.3250,
     2.4676,  2.6242,  2.7602,  2.9066,  0.1353,  0.2335,  0.3370,  0.4380,
     0.5819,  0.7353,  0.8671,  1.0160,  1.1435,  1.2977,  1.4860,  1.6739,
     1.8412,  2.0028,  2.1537,  2.3124,  2.4741,  2.6272,  2.7862,  2.9536,
     0.1003,  0.2226,  0.3584,  0.4971,  0.6291,  0.7710,  0.9157,  1.0669,
     1.2143,  1.3624,  1.5104,  1.6681,  1.8164,  1.9823,  2.1394,  2.3082,
     2.4677,  2.6306,  2.7909,  2.9382,  0.1056,  0.2027,  0.2956,  0.4005,
     0.5215,  0.6708,  0.8545,  1.0557,  1.2344,  1.4023,  1.5676,  1.7278,
     1.8808,  2.0381,  2.1846,  2.3376,  2.4887,  2.6377,  2.7878,  2.9504,
     0.1015,  0.2462,  0.4122,  0.5783,  0.7233,  0.8833,  1.0377,  1.1903,
     1.3341,  1.4727,  1.6138,  1.7582,  1.8912,  2.0370,  2.1701,  2.3125,
     2.4500,  2.6006,  2.7507,  2.9166,  0.1787,  0.2418,  0.3265,  0.5379,
     0.6584,  0.7681,  0.9545,  1.1050,  1.2125,  1.3528,  1.4763,  1.6705,
     1.8136,  1.9594,  2.0936,  2.2724,  2.4394,  2.5919,  2.7037,  2.8747,
     0.0859,  0.1600,  0.2980,  0.4933,  0.6696,  0.8285,  0.9958,  1.1545,
     1.3107,  1.4591,  1.6127,  1.7652,  1.9143,  2.0680,  2.2171,  2.3643,
     2.5141,  2.6611,  2.8143,  2.9691,  0.0910,  0.2110,  0.3364,  0.4718,
     0.5856,  0.7298,  0.8910,  1.0514,  1.1988,  1.3572,  1.5178,  1.6861,
     1.8399,  2.0099,  2.1639,  2.3225,  2.4774,  2.6321,  2.7863,  2.9412,
     0.1904,  0.2874,  0.3681,  0.4981,  0.6248,  0.7880,  0.9121,  1.0750,
     1.2185,  1.3809,  1.5296,  1.7007,  1.8592,  2.0470,  2.1913,  2.3250,
     2.4519,  2.5984,  2.7408,  2.9023,  0.0917,  0.2067,  0.3246,  0.4961,
     0.6310,  0.8024,  0.9438,  1.1008,  1.2362,  1.3892,  1.5407,  1.7033,
     1.8427,  2.0061,  2.1498,  2.3117,  2.4550,  2.6053,  2.7462,  2.9029,
     0.0989,  0.2193,  0.3756,  0.5410,  0.6929,  0.8368,  0.9801,  1.1250,
     1.2677,  1.4184,  1.5677,  1.7292,  1.8770,  2.0311,  2.1803,  2.3306,
     2.4836,  2.6339,  2.7943,  2.9549,  0.0861,  0.1943,  0.3057,  0.4867,
     0.6194,  0.7592,  0.9184,  1.1052,  1.2486,  1.4064,  1.5609,  1.7273,
     1.8703,  2.0291,  2.1686,  2.3225,  2.4628,  2.6115,  2.7471,  2.9005,
     0.0932,  0.2110,  0.3737,  0.5479,  0.7120,  0.8570,  0.9975,  1.1364,
     1.2772,  1.4220,  1.5612,  1.7089,  1.8410,  1.9827,  2.1263,  2.2859,
     2.4459,  2.6172,  2.7788,  2.9395,  0.1193,  0.2341,  0.3523,  0.5029,
     0.6437,  0.7803,  0.9367,  1.1007,  1.2392,  1.3869,  1.5425,  1.7168,
     1.8709,  2.0248,  2.1584,  2.2949,  2.4308,  2.5823,  2.7235,  2.9034,
     0.0834,  0.1988,  0.3557,  0.5261,  0.6767,  0.8427,  1.0029,  1.1683,
     1.3138,  1.4527,  1.6046,  1.7583,  1.9011,  2.0517,  2.1928,  2.3397,
     2.4839,  2.6291,  2.7771,  2.9329,  0.0938,  0.1967,  0.3213,  0.4675,
     0.6068,  0.7664,  0.9418,  1.1120,  1.2535,  1.3932,  1.5243,  1.6801,
     1.8346,  1.9931,  2.1376,  2.3035,  2.4636,  2.6244,  2.7829,  2.9371,
     0.1017,  0.2552,  0.4327,  0.6017,  0.7467,  0.8797,  1.0097,  1.1442,
     1.2628,  1.4049,  1.5541,  1.7090,  1.8461,  1.9982,  2.1486,  2.3029,
     2.4513,  2.6075,  2.7594,  2.9209,  0.1031,  0.2295,  0.3747,  0.5122,
     0.6596,  0.7935,  0.9345,  1.1050,  1.2384,  1.3543,  1.4739,  1.6136,
     1.7447,  1.8914,  2.0434,  2.1916,  2.3557,  2.5396,  2.7419,  2.9401,
     0.1007,  0.2374,  0.3715,  0.5173,  0.6465,  0.8069,  0.9553,  1.1145,
     1.2594,  1.4143,  1.5617,  1.7166,  1.8457,  2.0012,  2.1462,  2.2864,
     2.4258,  2.5910,  2.7372,  2.9018,  0.0808,  0.1726,  0.2849,  0.4592,
     0.6118,  0.7853,  0.9588,  1.1256,  1.2751,  1.4392,  1.5898,  1.7514,
     1.8977,  2.0554,  2.1937,  2.3430,  2.4831,  2.6249,  2.7601,  2.9155,
     0.1669,  0.2574,  0.3694,  0.5569,  0.6773,  0.8061,  1.0160,  1.1667,
     1.2791,  1.4041,  1.5452,  1.7207,  1.8524,  2.0038,  2.1414,  2.3338,
     2.4747,  2.6157,  2.7303,  2.8848,  0.1598,  0.2521,  0.3416,  0.5149,
     0.6703,  0.7941,  0.9408,  1.1164,  1.2017,  1.3293,  1.4908,  1.6783,
     1.8438,  1.9927,  2.1149,  2.2698,  2.4420,  2.6193,  2.7583,  2.9103,
     0.0902,  0.1978,  0.3265,  0.4578,  0.5878,  0.7439,  0.9110,  1.0906,
     1.2556,  1.4125,  1.5688,  1.7295,  1.8829,  2.0472,  2.2058,  2.3537,
     2.5075,  2.6548,  2.8058,  2.9538,  0.0818,  0.1695,  0.2794,  0.4470,
     0.6069,  0.7641,  0.9313,  1.0946,  1.2411,  1.4072,  1.5640,  1.7186,
     1.8651,  2.0254,  2.1726,  2.3286,  2.4784,  2.6287,  2.7750,  2.9339,
     0.1980,  0.3134,  0.4099,  0.4975,  0.6491,  0.8376,  0.9441,  1.0298,
     1.1795,  1.3866,  1.5784,  1.7209,  1.8137,  1.9271,  2.0863,  2.2930,
     2.4696,  2.6184,  2.7587,  2.9251,  0.1338,  0.2341,  0.3566,  0.4797,
     0.6129,  0.7580,  0.9093,  1.0491,  1.1911,  1.3313,  1.4841,  1.6503,
     1.8035,  1.9685,  2.1128,  2.2694,  2.4093,  2.5728,  2.7206,  2.8994,
     0.0937,  0.2034,  0.3447,  0.5032,  0.6370,  0.7993,  0.9674,  1.1323,
     1.2830,  1.4199,  1.5492,  1.7010,  1.8513,  2.0087,  2.1550,  2.3115,
     2.4643,  2.6237,  2.7812,  2.9392,  0.1085,  0.2152,  0.3126,  0.4569,
     0.5718,  0.7213,  0.8837,  1.0604,  1.2053,  1.3755,  1.5397,  1.7001,
     1.8409,  2.0039,  2.1498,  2.3080,  2.4535,  2.6063,  2.7505,  2.9110,
     0.0562,  0.2066,  0.4034,  0.5490,  0.6682,  0.7924,  0.9495,  1.0800,
     1.1869,  1.3156,  1.4834,  1.6619,  1.8404,  2.0199,  2.1509,  2.2755,
     2.4072,  2.5580,  2.6993,  2.8913,  0.0939,  0.2303,  0.3742,  0.5260,
     0.6662,  0.8294,  0.9769,  1.1315,  1.2792,  1.4153,  1.5436,  1.6701,
     1.8215,  1.9920,  2.1310,  2.3005,  2.4534,  2.5786,  2.7204,  2.9068,
     0.1005,  0.2442,  0.3898,  0.5398,  0.6958,  0.8474,  1.0008,  1.1556,
     1.3020,  1.4456,  1.5954,  1.7470,  1.8922,  2.0500,  2.2019,  2.3492,
     2.4963,  2.6412,  2.7890,  2.9423,  0.1022,  0.2031,  0.3213,  0.4402,
     0.5637,  0.7117,  0.8673,  1.0242,  1.1727,  1.3206,  1.4846,  1.6465,
     1.8015,  1.9655,  2.1233,  2.2873,  2.4464,  2.6074,  2.7685,  2.9409,
     0.1985,  0.3497,  0.4622,  0.5982,  0.7489,  0.8752,  0.9925,  1.1679,
     1.3288,  1.4606,  1.5820,  1.7492,  1.8922,  2.0511,  2.1780,  2.3373,
     2.4760,  2.6233,  2.7466,  2.8978,  0.1284,  0.2433,  0.3630,  0.4852,
     0.6117,  0.7460,  0.8904,  1.0360,  1.1738,  1.3142,  1.4696,  1.6185,
     1.7719,  1.9318,  2.0961,  2.2697,  2.4408,  2.6046,  2.7681,  2.9451,
     0.1042,  0.2286,  0.3598,  0.5064,  0.6438,  0.7899,  0.9350,  1.0891,
     1.2323,  1.3807,  1.5225,  1.6747,  1.8153,  1.9669,  2.1145,  2.2832,
     2.4430,  2.6085,  2.7748,  2.9346,  0.0780,  0.1724,  0.2440,  0.3489,
     0.5280,  0.7426,  0.9272,  1.0914,  1.2562,  1.4188,  1.5804,  1.7376,
     1.8909,  2.0473,  2.1946,  2.3457,  2.4950,  2.6424,  2.7926,  2.9549,
     0.1103,  0.2608,  0.4087,  0.5538,  0.6923,  0.8418,  0.9940,  1.1507,
     1.2919,  1.4406,  1.5802,  1.7262,  1.8638,  2.0085,  2.1572,  2.2975,
     2.4329,  2.5866,  2.7380,  2.9107,  0.1297,  0.2532,  0.4003,  0.5329,
     0.6733,  0.7950,  0.9557,  1.0859,  1.2235,  1.3538,  1.5037,  1.6389,
     1.7964,  1.9285,  2.0898,  2.2541,  2.4231,  2.5711,  2.6875,  2.8947,
     0.0871,  0.1968,  0.3425,  0.4949,  0.6424,  0.7959,  0.9534,  1.1132,
     1.2656,  1.4229,  1.5785,  1.7271,  1.8729,  2.0355,  2.1998,  2.3562,
     2.5151,  2.6663,  2.8145,  2.9534,  0.1038,  0.2204,  0.3248,  0.4566,
     0.5947,  0.7443,  0.8811,  1.0379,  1.2031,  1.3772,  1.5430,  1.7092,
     1.8625,  2.0322,  2.1904,  2.3417,  2.4960,  2.6458,  2.7979,  2.9485,
     0.1329,  0.2763,  0.3943,  0.5147,  0.6512,  0.8071,  0.9410,  1.0879,
     1.2298,  1.3850,  1.5282,  1.6674,  1.8137,  1.9993,  2.1344,  2.2749,
     2.4257,  2.5863,  2.7410,  2.9184,  0.1052,  0.2142,  0.3584,  0.5033,
     0.6387,  0.7804,  0.9320,  1.0780,  1.2172,  1.3764,  1.5421,  1.6887,
     1.8246,  1.9833,  2.1245,  2.2797,  2.4237,  2.5779,  2.7257,  2.9097,
     0.1092,  0.2676,  0.4071,  0.5355,  0.6661,  0.8142,  0.9621,  1.1173,
     1.2628,  1.4185,  1.5696,  1.7220,  1.8595,  2.0178,  2.1720,  2.3221,
     2.4718,  2.6259,  2.7775,  2.9334,  0.0929,  0.2017,  0.3073,  0.4570,
     0.5775,  0.7635,  0.9299,  1.0832,  1.2334,  1.3935,  1.5420,  1.7112,
     1.8601,  2.0309,  2.1735,  2.3230,  2.4543,  2.6034,  2.7418,  2.8988,
     0.0775,  0.2005,  0.3490,  0.5200,  0.6747,  0.8383,  0.9885,  1.1738,
     1.3141,  1.4236,  1.5892,  1.7402,  1.8474,  2.0210,  2.1593,  2.2730,
     2.4235,  2.5604,  2.7128,  2.9005,  0.1104,  0.2292,  0.3353,  0.4732,
     0.6152,  0.7675,  0.9164,  1.0907,  1.2594,  1.4064,  1.5218,  1.6426,
     1.8018,  1.9937,  2.1362,  2.2961,  2.4523,  2.6083,  2.7613,  2.9202,
     0.0826,  0.2000,  0.3384,  0.5144,  0.6694,  0.8377,  0.9870,  1.1461,
     1.2950,  1.4495,  1.5872,  1.7387,  1.8793,  2.0329,  2.1723,  2.3114,
     2.4415,  2.5908,  2.7354,  2.9028,  0.1063,  0.2268,  0.3442,  0.4735,
     0.6116,  0.7507,  0.9028,  1.0768,  1.2426,  1.4052,  1.5566,  1.7015,
     1.8243,  1.9742,  2.1276,  2.2824,  2.4262,  2.5953,  2.7627,  2.9290,
     0.1150,  0.2814,  0.4543,  0.6095,  0.7373,  0.8592,  0.9908,  1.1108,
     1.2339,  1.3590,  1.4864,  1.6168,  1.7392,  1.8752,  2.0212,  2.1688,
     2.3128,  2.4869,  2.7019,  2.9239,  0.0948,  0.2074,  0.3433,  0.4943,
     0.6346,  0.7645,  0.8809,  1.0610,  1.2307,  1.3487,  1.4655,  1.6186,
     1.7534,  1.8859,  2.0486,  2.2200,  2.3835,  2.5581,  2.7565,  2.9502,
     0.1062,  0.2239,  0.3683,  0.5197,  0.6704,  0.8184,  0.9642,  1.1127,
     1.2556,  1.3976,  1.5405,  1.6940,  1.8375,  1.9888,  2.1377,  2.2980,
     2.4555,  2.6184,  2.7849,  2.9452,  0.0888,  0.2005,  0.2847,  0.4322,
     0.5763,  0.7577,  0.9262,  1.1095,  1.2719,  1.4331,  1.5843,  1.7452,
     1.8845,  2.0385,  2.1805,  2.3345,  2.4750,  2.6217,  2.7555,  2.9013,
     0.1713,  0.2617,  0.3868,  0.5859,  0.7073,  0.8535,  1.0593,  1.1778,
     1.3109,  1.4508,  1.5910,  1.7463,  1.8911,  2.0651,  2.2035,  2.3355,
     2.4947,  2.6440,  2.7424,  2.8943,  0.1346,  0.2549,  0.4089,  0.5488,
     0.6949,  0.8394,  0.9810,  1.1145,  1.2528,  1.4044,  1.5423,  1.6872,
     1.8274,  1.9726,  2.1403,  2.2809,  2.4128,  2.5564,  2.6887,  2.8895,
     0.0776,  0.1621,  0.2553,  0.4191,  0.5988,  0.7921,  0.9651,  1.1350,
     1.2930,  1.4475,  1.6011,  1.7585,  1.9068,  2.0638,  2.2102,  2.3594,
     2.5096,  2.6581,  2.8099,  2.9654,  0.0864,  0.1778,  0.2854,  0.4235,
     0.5568,  0.7220,  0.8963,  1.0609,  1.2217,  1.3830,  1.5422,  1.7018,
     1.8551,  2.0206,  2.1783,  2.3328,  2.4869,  2.6366,  2.7923,  2.9539,
     0.1144,  0.2576,  0.4186,  0.5594,  0.6875,  0.8221,  0.9598,  1.0944,
     1.2273,  1.3713,  1.5152,  1.6628,  1.8070,  1.9525,  2.0965,  2.2535,
     2.4132,  2.5725,  2.7250,  2.9150,  0.1079,  0.2221,  0.3334,  0.4845,
     0.6083,  0.7516,  0.9018,  1.0594,  1.2060,  1.3673,  1.5212,  1.6880,
     1.8208,  1.9831,  2.1269,  2.2909,  2.4366,  2.6027,  2.7339,  2.8924,
     0.0994,  0.2233,  0.3634,  0.5145,  0.6568,  0.8131,  0.9746,  1.1296,
     1.2666,  1.4116,  1.5748,  1.7264,  1.8649,  2.0217,  2.1716,  2.3293,
     2.4900,  2.6455,  2.7818,  2.9362,  0.1120,  0.2079,  0.3128,  0.4124,
     0.5291,  0.6816,  0.8478,  1.0150,  1.1772,  1.3456,  1.5208,  1.6882,
     1.8458,  2.0078,  2.1627,  2.3198,  2.4733,  2.6251,  2.7796,  2.9489,
     0.0853,  0.2030,  0.3669,  0.5326,  0.6678,  0.8086,  0.9526,  1.1142,
     1.2551,  1.4158,  1.5694,  1.7073,  1.8431,  1.9686,  2.1153,  2.2376,
     2.3686,  2.5591,  2.7320,  2.9104,  0.0905,  0.2166,  0.3539,  0.5201,
     0.6700,  0.8346,  0.9883,  1.1457,  1.2714,  1.3845,  1.5172,  1.6688,
     1.8008,  1.9535,  2.1019,  2.2708,  2.4135,  2.5974,  2.7486,  2.9033,
     0.0084,  0.0374,  0.0164, -0.0153,  0.0288,  0.0107, -0.0255, -0.0242,
     0.0000, -0.0055, -0.0081, -0.0075, -0.0022, -0.0052, -0.0069, -0.0017,
     0.0003,  0.0091,  0.0028, -0.0027,  0.0085,  0.0043, -0.0235, -0.0411,
     0.0202,  0.0359,  0.0376,  0.0321,  0.0306, -0.0358, -0.0276, -0.0090,
     0.0032,  0.0048,  0.0309,  0.0332,  0.0284,  0.0237,  0.0051, -0.0101,
    -0.0233, -0.0428, -0.0585, -0.0387,  0.0039,  0.0081,  0.0029, -0.0017,
    -0.0006, -0.0068,  0.0044,  0.0182,  0.0376,  0.0387, -0.0334, -0.0269,
    -0.0182, -0.0069, -0.0026,  0.0035, -0.0049, -0.0212, -0.0408, -0.0245,
     0.0186,  0.0189,  0.0153,  0.0120,  0.0157,  0.0055, -0.0046,  0.0179,
     0.0284, -0.0032, -0.0261, -0.0205, -0.0039,  0.0174,  0.0299,  0.0207,
     0.0012, -0.0056,  0.0010,  0.0141, -0.0119,  0.0190,  0.0315,  0.0033,
    -0.0128,  0.0300,  0.0328,  0.0308,  0.0353,  0.0266,  0.0066, -0.0328,
    -0.0273,  0.0054,  0.0145,  0.0175,  0.0015, -0.0171,  0.0062, -0.0164,
     0.0045, -0.0071,  0.0025,  0.0278,  0.0283,  0.0117, -0.0026, -0.0285,
    -0.0408, -0.0366, -0.0059, -0.0208, -0.0354, -0.0334, -0.0263, -0.0064,
     0.0072, -0.0006, -0.0235, -0.0037, -0.0307, -0.0294, -0.0163, -0.0197,
    -0.0235,  0.0192,  0.0013, -0.0219, -0.0123, -0.0004, -0.0081, -0.0096,
    -0.0123, -0.0101,  0.0021,  0.0151,  0.0106,  0.0151,  0.0292,  0.0033,
     0.0283,  0.0124,  0.0058, -0.0017, -0.0038,  0.0152,  0.0141,  0.0132,
     0.0178,  0.0157,  0.0073,  0.0176,  0.0141,  0.0097, -0.0092, -0.0163,
    -0.0230, -0.0134, -0.0099, -0.0147,  0.0040, -0.0183, -0.0175, -0.0080,
    -0.0083, -0.0290, -0.0417, -0.0398, -0.0269, -0.0199, -0.0143, -0.0053,
    -0.0099, -0.0054, -0.0199, -0.0219, -0.0170,  0.0107,  0.0194,  0.0035,
     0.0437,  0.0406,  0.0215,  0.0120,  0.0053, -0.0028,  0.0238,  0.0337,
     0.0217,  0.0011,  0.0227,  0.0244,  0.0327,  0.0378,  0.0437,  0.0356,
    -0.0033,  0.0113,  0.0407,  0.0334, -0.0125, -0.0003, -0.0141, -0.0273,
    -0.0137, -0.0079, -0.0145, -0.0071,  0.0114,  0.0181,  0.0150,  0.0085,
    -0.0077, -0.0038, -0.0219, -0.0263, -0.0187, -0.0233,  0.0133,  0.0265,
    -0.0156, -0.0091, -0.0110, -0.0016,  0.0143,  0.0177,  0.0240,  0.0082,
    -0.0143, -0.0257, -0.0014,  0.0002,  0.0082,  0.0180,  0.0325,  0.0340,
    -0.0153, -0.0389, -0.0240,  0.0082,  0.0140,  0.0046, -0.0138, -0.0378,
    -0.0366,  0.0297,  0.0252,  0.0078,  0.0063,  0.0006,  0.0044,  0.0074,
     0.0094,  0.0113,  0.0105,  0.0137,  0.0438,  0.0262, -0.0078, -0.0185,
    -0.0215, -0.0407, -0.0435, -0.0208, -0.0004, -0.0144, -0.0205, -0.0248,
    -0.0159, -0.0069, -0.0153,  0.0132,  0.0355,  0.0298,  0.0120,  0.0072,
     0.0236,  0.0526,  0.0479,  0.0233, -0.0133, -0.0283, -0.0468, -0.0549,
    -0.0370,  0.0032,  0.0056,  0.0023,  0.0050,  0.0024,  0.0279,  0.0116,
    -0.0045, -0.0012,  0.0107,  0.0190,  0.0253,  0.0191,  0.0043,  0.0193,
    -0.0348, -0.0246,  0.0123,  0.0210,  0.0135, -0.0096, -0.0109, -0.0076,
    -0.0156, -0.0290,  0.0160,  0.0194,  0.0219,  0.0259,  0.0250,  0.0195,
     0.4948,  0.4961,  0.4940,  0.4878,  0.4849,  0.4727,  0.4571,  0.4551,
     0.4534,  0.4468,  0.4412,  0.4354,  0.4298,  0.4272,  0.4498,  0.4506,
     0.4560,  0.4592,  0.4758,  0.4941,  0.2476,  0.1771,  0.1974,  0.1881,
     0.1667,  0.1826,  0.2067,  0.2031,  0.1734,  0.1534,  0.1415,  0.1761,
     0.1897,  0.1772,  0.1651,  0.1247,  0.1041,  0.1231,  0.1809,  0.2234
};

static const int16_t shape8[] = {
      2765,   1262,   6624,    867,    688,   1884,   3245,   1248,
     -2160,    593,    182,  -1004,  -1067,    687,   1021,   -920,
      1396,   -242,  -2817,  -1838,  -3351,   1000,   5995,   2459,
      -283,   1909,   1452,  -4569,    556,  -2004,    -42,  -3393,
       -50,   -385,    597,    983,    420,   6311,  -1572,  -1665,
      6128,  -1688,  -5191,   -337,  -4199,    371,   1032,    -84,
      2169,    931,   -392,   -250,    137,    831,   8194,   -489,
       -92,    209,    115,   1453,    246,   -647,    936,   1097,
      -400,    597,    392,     93,  -7709,   -711,   -724,   2051,
       497,   1919,   -876,   -769,   -172,   2972,    952,    555,
       151,   -617,    773,   4840,  -3671,    841,    244,   -661,
     -3424,    958,     81,    532,   -315,    796,   5491,   -516,
        -1,  -1371,   -531,  -5538,    313,  -1749,   2413,   -835,
     -3143,   -244,  -3470,   -850,  -4241,   -859,    -74,   2141,
     -1005,   4643,   -339,   4089,   -861,  -6612,    483,  -2888,
      -580,    -45,   3662,    918,   -317,   3596,   -741,    897,
     -2578,   -654,  -1628,  -1865,    629,   3219,    214,  -1898,
      1173,  -4509,   1682,  -2161,    697,   -147,   9839,    751,
     -1094,   -341,   -669,  -1322,    649,   -832,   -382,  -5467,
       -44,   3510,   1312,   3104,   -202,   1870,   -155,    601,
       719,    -22,   -350,    394,     81,    397,  -9185,   -174,
       351,  -4717,  -4450,   3672,   1163,   2351,   1720,   1048,
     -1221,   -280,    -18,    -15,    678,  -3931,   4707,    -99,
      1823,   -535,  -1836,    138,   1166,  -3031,   5515,   1362,
      1235,    455,    595,  -3671,   1102,   -163,     62,   1104,
       813,    870,   -295,  -1088,   -299,  -3976,    805,  -7468,
      -412,  -2109,    236,     46,  -5764,    615,  -1475,    853,
       790,  -6197,    312,    637,  -3923,   -422,  -1086,  -5647,
       878,  -1410,   2085,    -51,  -2941,   -769,    -63,    838,
       823,    741,   2785,    450,  -7003,   -121,   -915,     60,
       -41,      0,    -39,   8774,    647,   -521,    379,   -342,
      -344,    818,   1316,   1056,    182,   2765,   -467,   7886,
        45,    791,   -415,   3864,  -2428,   2255,   -661,    -64,
      1693,    144,   1784,  -1194,    -46,  -1856,   1208,   4131,
       914,   8028,    -17,   1939,  -1415,    533,    291,   -466,
       186,   -705,    668,   -614,   -253,  -2190,    287,   3929,
      1472,  -1561,      5,    889,  -2020,    158,    -14,  -1419,
      1338,   -353,    622,    -54,     87,  -1104,  -2911,    513,
      -632,   1533,   -267,     22,   6567,    295,    325,   6883,
       963,   -373,   -349,    183,    896,   1845,  -1157,    351,
      -367,   1171,   4362,    508,   5632,    704,  -1420,  -1886,
       686,   5230,     -9,   2422,    230,    264,   3738,   -270,
      -344,   -528,   -936,   2286,   -540,   4274,    337,   -665,
       737,   1639,  -1307,   5827,    592,  -1372,   -412,   1419,
      4579,    335,    223,  -1067,   -112,   -446,    149,   1375,
      -155,   -392,  -1980,    561,    -67,    341,   6957,    475,
     11449,     39,     81,    766,  -1880,    558,   -134,  -7940,
      -489,    249,   -886,   -358,   6850,   2794,  -2217,   1111,
     -1222,  -1130,   -818,   1076,  -1823,    865,  -2220,   1179,
      4492,    224,  -2073,   -338,  -5351,   -390,    133,    496,
       -42,    -16,     46,    437,    322,   -275,    -72,     48,
      -325,    313,   1108,  -1044,   -851,  -5030,   1035,   4316,
     -1281,   -913,  -1419,   -941,   1914,    960,   1242,    202,
      5109,    475,   1254,   1725,  -1504,     -4,   -269,   -421,
      -150,  -4409,   -610,  -1548,  -1684,   -817,   -210,     72,
      -679,   -106,  -3809,  -1137,      4,   7220,    -95,    810,
      2432,   -331,    492,    -81,    138,    -62,   -613,   -636,
       106,  10908,    912,    144,    192,   1251,  -3970,   -954,
      1145,   1175,  -1721,   5326,  -1721,   -569,  -3661,  -1166,
      6605,   -744,  -1494,    853,    134,   3259,   -504,  -1740,
       180,   -207,   -659,    196,    179,   -106,    118,    789,
      -834,  10339,   -420,  -3002,   -456,    113,   6435,    949,
       721,  -2709,  -1599,   -684,  -8068,    174,  -1416,    -58,
       974,    308,   -726,   1237,  -1594,    519,   -131,   -198,
     -1395,   1180,   -173,    338,  -5584,   -279,   -236,   6817,
        89,   -220,   3967,   -107,     65,   2479,    -22,    642,
      7179,   1179,   -229,   -202,   4948,  -5465,   1632,  -1285,
      2188,  -2037,   1763,    636,   4247,    995,   1176,      2,
     -2398,   1236,   -661,    382,  -1075,    130,    103,   -187,
       604,   -306,  -2635,  -2185,    157,    775,   6373,   -924,
      1758,  -3043,   1707,   2852,  -2148,   6779,    376,  -1018,
     -2374,   -989,    249,  -5393,    -32,    538,   -416,  -5108,
      -658,   1839,    419,   1153,  -3956,   -617,  -1925,   5434,
       626,   1488,  -3824,    140,    370,  -2230,  -7031,   1989,
      -581,    639,  -4249,   -216,   1225,   -776,   -973,   -542,
     -2922,  -1783,  -2430,  -3251,    958,   3313,    636,  -6277,
       119,   -866,   -406,   -156,  -4839,    966,   -469,   5559,
       193,    376,  -4810,   -870,    163,   4130,   2596,   2203,
      -114,   2423,   -622,   -424,   2935,    749,   2500,   4230,
      -162,  -1489,   2169,  -5156,    751,   2748,   2240,  -1549,
      4821,    175,   2274,    854,   2993,    838,    322,  -2663,
      -794,   -283,    -98,   1393,   -709,    362,    285,  -1085,
      1075,    374,   1062,   6512,  -3375,  -3138,   3939,   3628,
      3926,  -2442,   1989,   -583,  -1282,  -1882,  -3920,  -4593,
       540,   2667,   -155,    156,  -2428,   1229,   -436,   1754,
      2815,  -1634,  -2299,   1155,    990,   3689,  -1242,   3145,
      3951,     45,    186,  -1110,    257,   -335,   8929,    533,
      -173,    813,     21,   1584,    541,    -44,   1349,    108,
     -5163,   -684,   5522,   -868,  -5795,    769,    583,   2827,
      -818,  -5551,   1485,     37,   -631,   -262,  -4352,   -532,
        61,    434,   1775,   8974,   -112,   -852,  -1227,  -1645,
       260,    298,   -430,    863,  -3860,    -97,   6467,   -328,
     -2418,    -61,  -1253,   1575,     30,  -5683,   2113,    973,
      -371,    -51,   5355,    471,   -584,   -492,  -2187,   2799,
      -506,   4435,   1950,  -3415,   -363,   -404,    941,   2628,
      -146,    434,   2853,    889,    634,   5749,    -54,    126,
       189,  -1384,   -379,  -3205,   -540,   1720,    942,  -6300,
      -286,    -58,  -1083,   3782,    251,   -334,   4172,    631,
        17,     83,    707,   1322,   3273,   -573,   1024,  -6112,
      -540,   4916,    155,  -1209,    308,   -738,  -2150,    786,
      -168,     68,   -201,    -64,   -752,  -1595,  -9188,    320,
      -426,    111,  -2183,    886,   -737,    193,   -837,   3219,
      5936,   4022,    764,    -82,   3344,   -855,   3705,  -2652,
      1533,   -206,  -3673,   1235,   1163,  -1217,   3183,   1313,
      -745,   6554,   7019,   1302,   2129,    268,    -70,    110,
       412,   -155,  -1703,  -4945,    105,  -1705,    412,  -6588,
      2905,   1279,     73,  -2446,  -5635,   1168,   2974,    404,
      -650,    265,  -1773,  -1857,   -108,   -651,    657,   -824,
      3352,    177,    155,   1275,   2012,     31,     -7,  -1065,
      2062,    411,  -2325,   -208,  -6306,    683,   1037,  -1060,
       191,   -187,   -585,   6103,   -459,    571,   1640,   -693,
       922,  -2291,    537,   1934,    263,   3847,   -202,   7060,
       136,   4368,   2963,  -1032,     18,   1836,   -144,  -3853,
       474,   2005,   1298,   2396,    825,  -2274,     12,   3759,
      -394,    907,    490,   2997,   2180,  -1570,  -1000,   5982,
      -129,   -820,  -3001,   2684,  -1132,  -2908,   1101,   5044,
       393,  -1637,    393,   1343,  -1231,    404,   1817,   1463,
      -443,   1053,   -584,  -7756,     45,    499,  -4109,    214,
       535,  -3348,     54,  -1594,   6913,      0,    -94,   8772,
       500,     13,    734,      5,    798,  -1521,    853,    -82,
      -263,   -619,   1558,    456,   5911,  -1376,   1054,   -971,
     -1275,   -147,   -111,   4964,    321,     67,   7024,   -525,
       620,    883,  -1058,  -1132,  -3313,    630,    226,  -6201,
     -1011,   1111,   -820,   -295,    580,    636,   2452,   -638,
      6840,   -285,    655,   1502,  -1049,   -567,    329,    -33,
      -249,    570,    186,    167,    780,   1104,     42,    197,
     10034,  -1295,   -208,     32,  -1473,    716,    159,  -6672,
       -45,    519,  -4300,   -246,   3692,   5062,   4305,   -748,
      -548,    181,   -382,   -881,  -1968,    580,    964,   -420,
      -327,  -3397,  -1584,   2770,  -3501,   1659,  -1252,   2352,
         6,     30,      0,   -273,     27,   -204,   -485,   -432,
        -6,    176,   -428,   1562,    104,  -6511,  -1084,   2205,
       -11,  -5254,   -132,   -508,    -69,    373,  -1503,    208,
       -58,   5311,     92,   -966,  -6563,   -480,    -24,   1424,
     -1498,   -165,   4594,   -903,  -1787,   -353,  -7284,    142,
      1008,    875,  -6109,    -16,    162,   4895,     30,   -188,
      2099,   1581,    300,   -259,   -921,   -386,   -488,    140,
      -482,   7135,    -77,    494,   -196,   3207,   -250,   -102,
       318,    978,    161,   7292,     55,  -1347,  -2605,    898,
      1833,    602,  -1988,    630,   -145,   -102,   -414,   -133,
       417,   -603,    156,  -1151,   -395,    625,  -1676,     86,
       680,  13321,    322,  -5816,   -292,   -223,   4205,   -361,
       903,   -224,   1745,     95,  -6598,     79,   2323,    -24,
       263,    778,    146,   -939,   1814,   1945,    720,    367,
     -2987,    899,  -4409,    136,  -3185,   -342,  -3304,   1016,
       284,   -345,   2313,   -403,    389,  -1403,   1835,    151,
      -132,  -1702,   -339,  -5679,   2026,  -2990,     47,   -564,
       399,  -2167,   1392,   1384,   5094,  -2954,   4467,    -22,
       -23,    408,   1620,   1381,   2380,    805,    380,    -36,
      -803,    765,   -778,    905,   -200,   -669,   3942,    289,
       176,  -4767,   2015,  -3554,   1206,   6071,    180,   2057,
       -48,    365,    -48,  -2423,    585,   -109,  -1298,   2519,
      -525,   -589,    374,    976,   3667,   2091,  -2890,   1371,
      -726,   -216,  -1027,   -116,   2122,   -619,  -3826,   4649,
      1167,      0,   1237,   1538,   2505,   -548,  -3093,   1344,
      -558,  -1927,    199,   2462,   1327,   4597,    833,  -3660,
      -341,  -1010,    428,    148,  -1682,    130,   1569,   8785,
      -752,  -1032,  -2407,    353,   -379,   3311,    892,    893,
     -2596,   -217,   -835,  -2291,   1137,  -4339,    -58,   2759,
       991,   3527,   -281,  -6050,  -1251,   1802,      8,  -3916,
};

static const int16_t shape16[] = {
      -855,   1549,  -4841,    629,    932,  -5896,    840,  -2041,
      -305,  -2574,    343,    -31,   -780,   -773,   -353,    403,
     -1907,  -2371,   -555,   -324,   -479,   6961,   -286,  -4290,
       626,   -953,    -14,  -1681,   -443,   1504,   -366,    513,
     -1206,    870,   9239,    112,   -213,    425,    381,   1802,
       750,    594,     61,   -152,  -2060,  -8997,   -752,    197,
      -493,   -176,   -389,   -591,   2988,    654,   2404,   -204,
       304,   -279,    202,     66,   -185,    415,    159,  -1514,
     -6775,    -37,  -2617,  -1246,  -4012,   1208,   -554,   3240,
      -655,   -394,  -1464,  -4448,    388,   1058,   -364,  -1760,
      1081,   -558,   -116,   -108,     99,   -925,    763,  -1301,
      -251,    258,    -33,    311,    555,    227,   -279,   -601,
      -135,   -675, -10615,   -937,    158,    503,  -2044,   1075,
      -114,   4278,  -9040,     67,  -1076,   -705,   -122,   -533,
      3299,  -1826,  -1316,    708,  -3840,   -740,   -370,  -1074,
        87,   -462,   2177,  -1177,     57,  -6311,   -170,   -777,
      -256,    435,    291,  10371,    -82,   -425,  -1757,   -196,
      3824,  -6289,     62,   4506,   -519,   -783,   1155,    878,
       295,  -2044,    305,    186,    263,  -1716,   -482,  -5678,
       415,   2709,    213,   7531,   1376,    813,   1803,    190,
       398,   6483,   1425,    235,   2713,    520,  -2892,  -1191,
      6074,    654,  -6535,    320,   -736,   -478,   2563,   -309,
     -3477,   -155,    275,   1024,    390,   -386,   -331,  14043,
       251,   -410,   1496,     24,   1272,   -816,    549,   -238,
     -2489,    158,    194,      1,   -306,  -3088,   -264,    200,
       -30,   -520,   -472,    -30,   -464,   -764,    440,   -659,
        88,    778,    -31,  -1794,  -3817,   -344,    887,   -551,
       115,   -763,  -5338,   2906,     50,    736,   5536,  -1101,
       330,   -405,    416,   1022,    -93,     71,  10034,   -200,
     -1258,  -3405,    480,    141,    399,    500,    311,   -503,
       301,   4398,    454,   -922,    975,   -101,   -775,    -81,
     -1723,   1077,    857,  -1682,    813,    847,    342,   -276,
      3582,   2991,   5571,    713,   1280,    596,  -1325,  -1087,
      -681,   1411,    391,  -1728,    492,    544,   1512,   -724,
     -7445,   -426,      6,   -534,  -3643,  -1598,   2650,   -834,
      2096,   -333,     67,   1746,  -1584,  -1003,   1272,   1710,
      1666,    176, -11716,    329,  -1829,    385,    802,   -382,
      2244,     -8,   -222,  -2351,    369,  -1067,  -9354,    293,
       -51,  -1849,   -500,  -2350,  -1824,   -826,   -450,  -2155,
       456,    245,   1796,    320,    -73,   -306,   -122,    290,
       118,   -298,   -675,   -180,   -828,     86,    -44,    165,
       435,  -8249,    769,    630,  -1670,   -762,    453,   5893,
       259,    -92,  -1003,   -358,    -32,  -1350,   -535,   -289,
       409,   -558,   -344,   -752,   6037,   -680,   2471,    581,
      -351,   1251,  -5827,    194,   -104,    815,   1257,   -619,
       243,    410,   4455,   -969,     50,   1286,  -1013,   -293,
     -7740,     73,    615,    523,   -149,   -824,   2235,   1571,
       970,    944,   4778,   -132,  -5082,     83,    129,   -820,
      -803,    694,   1615,   1163,    517,   -402,    -80,    762,
      -107,   -419,    142,   -294,  11298,    301,    484,   -513,
       105,    547,   1130,  -4253,   -742,    376,  -1545,   1076,
      4372,   2338,  -2847,    495,   -190,  -2444,    931,   6487,
       117,  -1273,   1488,    -75,   -322,   -487,  -2614,   -251,
      1233,   4111,   -321,   -219,  -7961,    -11,    107,   -808,
       450,    111,   4395,     89,    772,  -1878,  -1894,   1075,
      -544,  -9467,   -459,    637,    842,   -956,   -738,   4452,
       777,    -75,   -209,   -302,   -796,    785,  -7413,    321,
       649,    -55,    114,     43,  -1026,   -223,   -611,    209,
     -5543,   8206,    907,  -3358,   1452,   -543,  -3173,    525,
       -95,     35,   -475,   -525,   -705,   -569,    350,    206,
      -108,  -1523,   -680,   -283,  -2583,  -4992,    -59,   -968,
     -1719,  -2750,   5884,    455,     29,    436,    784,   -101,
      -216,    110,    612,   -511,    -12,     98,    -67,    177,
     -1210,    222,   -345,    243, -12670,   -472,    282,  -2149,
       687,  -2631,   4434,     77,   -521,   -404,   -934,    212,
      -695,   -369,   1138,   1348,   -905,    501,    299, -10467,
      1018,    818,   1941,     31,    257,   1219,    944,   -157,
      1968,  -1649,   -126,   -440,   -599,     -1,   6190,   2574,
      -332,    753,    195,   -131,   5972,   -297,    672,    -86,
      -143,   -303,      5,   -121,   -154,   -613,   5541,  -1516,
      -304,    962,     69,  -1857,   4142,   -134,    706,    896,
     -1226,   -135,   -310,  -9261,   1135,  -3437,    620,    802,
       -33,   -582,   1909,   1407,    242,   2599,  -1533,   -279,
       836,   8070,  -1207,   5745,    200,    -77,    162,    781,
      -466,  -1555,   3297,   -957,    225,   1290,      7,    677,
        41,   -549,  -2778,   1400,    379,  -3367,    369,    615,
     -6402,    527,     58,   5679,   -114,   -180,   2842,     88,
     -2611,    -50,    371,    161,   -444,   2062,    -38,    272,
     -8562,    769,     18,  -2593,   -226,   -503,   -959,  -1295,
       189,   -371,   -675,  -1528,    -98,    514,  -1236,    116,
       202,  13662,   1596,   -328,     61,   3567,   -486,  -3316,
     -8473,   -317,   2868,   -419,    -17,    535,   -965,   -503,
     -3848,   2222,    620,  -1740,      2,   6505,    473,   -297,
       -70,   3043,    -51,  -1520,    993,   1046,   1965,   3240,
      1971,    -60,   -650,    -53,   -248,  -4428,   -365,  -3723,
      1122,  -1681,   1629,   1358,    -17,   1136,   -256,   2344,
      -282,    156,    127,   -155,    318,  -1281,  -1066,     57,
      -889,   -253,  -1396,   -579,   -920,  -1006,  -9202,   -703,
       195,   5186,    241,   1742,    996,    118,   1431,   4415,
     -2452,   6837,  -1272,   -569,   3485,    328,    441,    832,
       553,     94,    648,     92,   -378,  11167,    775,    457,
      1712,    -24,    941,   5433,  -1645,   2166,    249,    -55,
     -1816,    383,    735,   -876,    443,   -568,    293,  -1266,
      6963,   -178,   -174,  -1186,   1119,   -208,    821,   1499,
     -1496,  -2171,   1434,    874,    133,  -7466,   -545,   2193,
      -775,  -1405,  -1205,   -575,  -1996,   -645,   -552,   -263,
      8861,   -517,     76,   -992,    278,   2417,  -1369,     35,
     -1461,  -1399,    517,    185,  -2895,    347,  -3871,   3644,
       284,   3284,    -12,   -169,  -1981,   1196,    -67,   2868,
       910,    134,   -530,    150,  -1328,   1902,   -746,    351,
      -222,    522,  -5702,    797,  -1900,    241,   2270,    764,
      -335,   1348,   -349,    784,  -1586,   -537,    148,   3211,
     -1692,     56,   1678,   -321,   -290,   7902,     69,     52,
       310,    337,    250,    596,   9998,    336,   1037,    163,
        64,   -441,   2894,  -1033,    730,   -718,  -1252,    459,
      -131,   7840,   -922,   -555,   5671,    299,    689,   1115,
      -646,   -505,   -263,    608,   -494,      0,    442,  -1802,
      -598,   -701,  -4184,     70,  -1319,    -90,   9155,   -339,
         0,    121,    462,    735,   -639,    481,    125,   6924,
      3379,    683,   3053,  -1219,   -499,   1067,   -148,  -2705,
       -11,    795,   1675,    898,    226,   1232,     49,   -572,
     -9309,   2223,    949,    767,   -821,    -91,   1075,   -352,
     -7829,    554,   -593,   1284,   -245,   1239,   1166,  -1157,
     -5274,    808,    871,  -1446,   7575,   -397,   -755,    752,
      4193,    179,   -205,    -37,   -750,  -2675,   -407,   -700,
       220,    -77,   1604,     63,    461,  -9994,   -645,  -1629,
       103,    576,    132,  10005,    -49,  -1005,     97,  -1608,
       515,    -10,   -146,  -1878,    880,    429,  -1271,    996,
      -365,     76,   -409,   2461,     29,   1159,    217,  -6240,
      -200,   -746,    118,  -1884,    457,   -816,   -608,   3215,
       244,    749,   2268,   -236,  -1276,   -278,   1392,  -1767,
      1255,  -1474,  -8136,   1388,   -770,    225,   -443,     10,
      -392,    659,  -1118,  -1651,   -514,   -935,   -111,   1112,
       973,   -247,   -235, -13010,   -737,     40,   -141,   5167,
      -910,    279,   -467,  -3762,    847,  -3935,   1018,   1922,
       830,    190,    253,  -1130,   -415,    371,    718,   3833,
      1036,  -5358,   -928,    866,   -514,   2724,   2354,    449,
       210,   1462,    680,  -1880,    -62,  10988,    809,   -602,
       145,   -536,    114,   -147,   -568,   3193,   -322,    892,
      -637,  -1381,    -65,    761,   1615,   5025,   -327,   4941,
      -631,  -5225,   1204,   3042,    998,  -1047,   -959,   -106,
      1610,   -151,    120,  -1152,    191,     30,  11963,    101,
        18,   -410,  -1288,    370,   -771,   1337,   -544,   -613,
       289,   -117,   1625,  -4506,   2582,  -1690,   -105,  -5324,
       -93,    285,  -1167,  -3564,   -729,  -4790,    595,    275,
      -216,   -217,  -6000,    682,   -171,   -875,    224,   -164,
      2919,    796,    -81,   1434,    186,   -375,  -4113,   -179,
       277,   1363,   -453,   2505,    388,  -1840,   -165,  -4800,
       -42,  -6632,     54,   -735,   -553,  -1679,    917,     -2,
      -632,    417,   -478,   -494,   -265,     73,   -372,   -360,
       179,   -448,    265,    299,   -152,   -211,  12730,    -77,
      1954,   -534,    773,    524,    438,   1901,  -4413,   -358,
      1552,   -248,  -1588,   -122,   -127,   5405,    226,   -849,
     -7495,   -357,    -89,    185,    746,    851,    669,    305,
      -247,   3457,   -193,   -161,    638,    600,    610,    855,
     -1292,    398,   1528,   2250,   1651,  -8414,    763,   1529,
      -346,   3769,   -111,  -6494,    347,   -742,   1941,   1967,
       582,  -5499,   -765,   -818,   1850,  -1604,   -243,   -943,
       -11,    884,  -2996,  -2375,   1010,   -374,   6605,   -287,
     -5073,    211,   -758,    703,  -2607,    747,   -130,   -429,
     -2481,   4894,   -457,   3225,    958,   8533,    542,   6177,
     -1069,  -1210,   -963,  -5943,    -86,   1424,   -567,    827,
      -510,  -6577,   -258,     -4,  -4430,    115,   5401,   1390,
       354,   1755,   -998,    852,    993,   -481,    218,   -987,
       779,   -417,    591,   6011,    528,    289,   -336,   -558,
        60,   9124,   -174,    235,   -239,   -144,   -260,  -3472,
       746,   4781,    652,  -4831,   -739,    -21,    864,  -2310,
       652,   7147,    116,   -318,    -50,  -3485,   -325,   -345,
     -5784,   1144,   2399,  -1443,    991,  -2318,   -785,   -281,
      -207,  -1448,    309,   1001,    952,   1472,  -5901,   -780,
     -2459,   1518,   9878,  -1229,    670,   -523,   1217,   -164,
       -55,    -95,    243,   7909,     86,  -4380,   -859,   -599,
      -183,  -2339,    774,  -1210,   -502,   -899,     53,   1039,
        34,  -7753,   -296,  -1951,  -4559,   1182,   -150,   2878,
     -4910,   2761,  -1481,   2048,   2600,   1808,  -2953,  -2257,
        62,    162,   1115,    214,  -4510,    926,  -6669,   1443,
      -124,    193,   -314,    302,    699,    -18,    745,    341,
       895,   -615,   -295,   -181,    143,   -427,   6528,   1074,
     -1126,    374,   -298,  -1274,     22,    887,   -511,  -1057,
      3228,    722,    607,    624,    -95,  11085,   1006,   -788,
      -285,    -92,   1342,   -325,   -828,     42,  -3588,   -631,
      -576,   4559,   -668,  -1294,   1739,   1697,   -647,   2336,
       376,   -120,   1350,    646,   -325,     95,   5974,    775,
       199,  -8557,    931,   -336,   -651,   -561,   -433,  -2266,
      -129,   -657,  -1184,     67,    577,    617,   1880,    552,
        90,   -617,   -273,  -1571,  -7481,    261,    -26,    -20,
      -459,  -1028,     57,  -8516,    -43,   2774,      1,  -4238,
       680,  -3310,    -56,   -152,    548,  -1983,    920,    899,
      2180,   -307,  -2230,  -1685,   -998,   2091,   -112,     21,
     -1551,   1182,   6649,   -326,    792,   1818,  -7596,    563,
      1076,   7422,   -908,   1524,   -223,   5798,   1318,  -3376,
       517,   4162,    756,  -4142,   1776,    390,    334,    -44,
       218,   5290,    792,     39,   1692,    542,    -62,   -595,
       590,     27,   8922,    989,    182,    725,    112,    458,
     -9170,  -1000,   1176,  -1290,  -1403,   -726,   5990,   -297,
      1234,  -1724,   -601,    528,   1072,    184,   -146,     61,
       685,   1208,    -88,   -211,    356,   9569,   -363,   -135,
      -159,  -1061,   -105,   -410,    -58,    335,  -9986,   -300,
      -211,    607,    443,   -410,  -1730,   -328,    275,    579,
       805,    899,   -464,    -18,    296,   -446,   2396,    -13,
       414,  -9662,   -385,   -808,  -1867,    154,   -572,   3351,
     -1839,    -80,   1157,   -326,    481,   8815,  -1039,   1065,
      2110,   1223,   -960,    -33,   -464,  -5660,    490,   -314,
       346,    730,   -387,  -1102,   6656,   -719,  -1173,    -57,
     -1186,   2394,  -1300,   -665,   -586,    -39,    -71,    155,
      1184,      4,  -3269,   -333,   -747,    580,    279,   -583,
      7164,   -185,    110,   2465,    428,    507,   4462,  -4461,
       199,    337,  -3597,   -249,    -70,   -680,  -5549,   1533,
       917,   -303,  -9230,   -431,   -124,  -1019,    369,    139,
      1367,    151,  -1047,   6820,   -151,    222,  -2934,   -817,
       971,  -7325,    556,   1035,  -1240,   3115,  -1326,   4012,
      2812,   1057,   2580,   -261,   3989,   1999,   1624,   2402,
      -310,    779,   -354,   -377,   -149,   1035,  -2363,    358,
      3666,   -246,  -1896,    375,   3919,  -1392,    683,    624,
     -5872,    644,    391,    288,   -198,   -237,     68,   -284,
        88,  -1016,    250,     32,   1188,   -243,   -608,   -320,
      -219, -11087,    543,    156,   1034,   -169,   -183,   -549,
       -66,    716,    996,   -928,   -309,   5577,    229,    125,
     -1328,   9027,   -698,   -485,  -1694,    839,    343,    449,
      1655,   1005,   1053,   -408,   9106,    186,    670,    774,
       314,    573,   3888,   -882,     26,   2518,   -533,   -195,
       555,    337,   -246, -10779,   -231,     31,   -314,   -941,
      1129,    333,  -7503,    168,   -551,    237,   -159,   4399,
       421,    693,    198,   -196,   -561,   1035,   -548,   1058,
       527,   3617,   -361,   1317,  -1975,  -2638,  -1966,   -120,
      -324,   5678,  -2252,   -663,    181,   -273,  -3073,   -282,
      -622,    363,     71,    184,   -776,    284,  -1516,   -430,
         3,    937,   8587,    258,  -1060,  -1555,   -830,   -338,
       318,  -9130,   -110,    459,   -572,     70,     93,    120,
      -534,   1296,   -168,     29,   -914,   -332,   -997,   -818,
       270,   -243,    523,     56, -11847,   -448,     11,   -154,
       164,   2115,    -13,   -635,    708,   -663,     43,   -248,
     -3244,    254,     19,  -1125,    508,    154,   8697,    191,
       595,   4393,  -2806,   -168,  -1916,    393,   3976,    897,
     -1716,    -35,   -180,    605,  -1057,  -1194,    100,   -384,
       -37,   -107,   2739,   -207,   6899,    176,     81,   -901,
      1280,  -1670,   -101,    281,   1147,     48,     21,   -151,
     -1236,    210,     98,   -114,   -573,   7940,   -153,   -302,
     -1331,    337,   -322,   6598,    477,    147,   -999,  -3166,
      -232,  -5104,   -799,  -1866,    -58,  -4213,   1376,    181,
       675,    562,    126,    235,   2260,  -5152,   -243,   -699,
     -1476,   4135,    569,    567,    737,  -4163,    613,  -1057,
      1778,    546,   -450,    -24,    325,    366,   2406,  -1319,
        60,  -5126,     49,    657,  -5937,   -194,    882,   3267,
       178,   -298,   1873,  12422,    459,    272,    195,  -1827,
       212,   -802,    730,    471,   1556,    422,    640,    236,
        71,    597,   5783,   5378,   -649,   1524,    829,    437,
      -351,   -122,  -1400,   2119,   -128,     75,  -1677,   -633,
      -322,  -6382,   -573,   -974,   1672,   -378,   -242,   3708,
        79,  -1325,    397,   -150,   1977,    442,    747,   -127,
};

static const int16_t shape44s[] = {
       -20,   -140,    683,   -586,  -1742,    177,   -538,   1900,
      2193,    -17,  -2096,    261,    645,    339,     77,   1136,
      -521,    537,   -924,   -156,   -261,    195,   1049,    -39,
       236,   -137,      0,   3199,    225,     46,     86,   -215,
       557,  -5394,     17,    911,  -1690,    -48,    -48,   -175,
       -11,   -631,   -153,   4474,   -347,    -39,   1759,    154,
       170,   -180,   -273,    603,   -590,  -5195,    -74,   1789,
       240,   -212,    431,   2447,    368,    -76,   -313,     11,
     -2926,     19,    -71,    208,    -51,   -728,  -6412,    -61,
       141,   -112,   5280,    -76,   4435,   -402,    -25,     46,
       210,   -104,    172,  -3830,   -366,    -23,    239,   -112,
       137,   6692,  -6288,   -720,   -132,   -136,    552,  -1688,
      -345,   -289,   -485,    149,    174,    180,    361,   -236,
        92,    407,      6,   2373,    380,   -167,    845,    444,
      -834,  -9358,    413,  -1302,    460,     77,     34,     56,
     -1516,   -143,    207,    -43,    -31,   -106,    -52,    403,
      -309,    298,    -88,   1552,   -240,   -776,    624,  -4181,
      -342,  -4804,     57,    -23,    160,    -44,    469,    -17,
     -3997,  -5079,   -263,     72,    181,   1085,    538,   -611,
      -368,     59,   -204,   -195,    -40,   -201,   -803,  -5093,
     -3216,    480,     46,   -729,    244,   3320,    185,    503,
      2979,   -416,    110,     25,    140,   -502,   2236,  -4420,
       -36,   -238,   -278,     60,    -82,   -597,    218,     69,
       -95,  -2102,  -2138,  -2308,  -3796,     20,   -211,   -229,
       297,   3665,     81,    148,   1315,  -4537,    -38,    186,
     -3106,   -526,     90,    -35,   -193,   -302,  -5860,    276,
      -308,    206,    645,      1,   -242,    580,   3025,  -2583,
       -90,    511,   -315,   -137,  -2033,  -4313,    693,    485,
      -211,   1486,   1180,    181,   -136,    204,     23,    383,
      1479,   -213,     42,     32,    -64,   -136,    -91,   -146,
       434,    231,     36,    -58,  -3254,  -2647,    -18,    345,
       171,    -60,     84,    209,    246,   -587,   9447,    -67,
      -187,   -108,   -226,   -458,   -519, -11089,   -422,   -502,
       132,     79,    298,   -475,   -412,    196,   -164,  -7347,
       185,   -131,    369,     18,   -500,    644,   -334,     93,
       -77,     71,    341,   3566,   -281,  -4191,   -145,     87,
        37,    306,  -3482,  -5739,    161,   -245,    293,    208,
       380,   2888,     31,    -23,  -2061,   -597,    -56,    350,
      -105,   1167,     64,    342,   3638,    -79,   -106,    148,
      5422,   -719,   -232,      8,   -395,   3249,  -5093,   -222,
      -707,    241,    318,    735,    376,     78,   -166,  -1614,
        -9,  -3373,    330,  -1540,   2028,   3400,     -9,    317,
         9,   4903,    262,     62,    222,    -95,   -208, -13376,
      -101,    121,    298,      5,    172,    406,   -164,     79,
       172,   1993,    235,    229,   1193,   -274,   5944,   -918,
       -15,   1304,    307,   1150,   -385,   -794,  -3467,    660,
      2143,    147,   -279,   -751,   -305,   1052,    205,   -108,
       572,   -212,     29,    -50,      6,   3749,    238,  -2016,
     -1118,  -1329,   -971,   2633,    519,    194,   3545,    -11,
        77,    -92,   1215,   -439,    152,   -863,   1604,    180,
      -514,    252,    308,   -131,   -938,    133,    378,     11,
     12153,     51,    486,     71,   -476,   -599,     57,   -127,
      2685,   -173,   -182,    468,  -3469,   -594,   -380,    265,
      -879,   -352,   -278,   -309,    575,    124,  10814,   -765,
       -64,    710,   -105,    296,   2562,     98,   -358,    556,
      2921,   -133,     -5,   -406,     42,    496,  -1053,  -1957,
       701,    266,    260,   -441,     43,   -192,     -1,  -2174,
      9894,    -90,   -181,     29,     50,   -858,     59,   -190,
        49,   -282,   1632,   1525,    100,  -3659,     13,    173,
      -240,   5304,   -383,    263,   -311,   1747,    169,  -2203,
       -29,   -106,    342,   -301,     66,     49,     23,    857,
      -607,    698,  -1198,   -191,   -450,  -1875,   -329,  -2156,
       156,     95,    145,    129,   -321,     88,   1049,   3980,
       -14,    321,  -1484,    895,    -30,  -2174,    289,    933,
      -933,     15,   2631,     68,   3054,    221,    -87,    175,
       200,    937,    -87,  -2032,    348,    146,   -372,     60,
     -2566,   3497,    -98,    313,    536,   -299,    -58,  -8949,
       323,   -524,   -331,    713,    -47,    360,    155,    168,
       687,  -1391,   1973,    670,    788,   -202,   -129,  -5113,
        54,   1178,   1218,    172,    630,   -154,  -1047,    840,
        71,   -337,     91,    214,   -474,    624,   -773,     16,
      -126,    340,   -631,   -482,   -155,    419,     50, -10976,
      -742,   -781,    169,    149,     33,   -169,     44,    354,
        26,    129,   -179,   1401,    776,   -155,  -3996,   -813,
       594,    238,    -61,    168,   -383,  -9261,    294,    470,
      -322,   -190,   -956,   -290,     27,   -438,   -254,  12571,
       344,   -393,   -568,     56,     81,    171,   -115,  -4370,
        49,   -322,   -237,   -692,    -55,    -49,   4317,     -6,
     -4837,   -156,    179,    247,   -338,    -48,    952,  -1061,
       -33,   -934,    250,   -256,  -1622,   1039,   -738,   2719,
       -20,   -190,    249,   -119,   -235,   6080,    123,   -502,
     -1443,     86,  -1684,   -177,   -128,    -58,   -237,   -641,
      -177,     64,  -2416,     15,   -116,  -6465,   -412,    161,
       419,    768,     36,    113,   -944,   -241,  -1424,    -95,
       635,   1798,  -2257,    -18,   3046,    173,    -33,   -207,
       -52,   -831,  -5730,    -54,   -199,    194,   -255,    467,
      -211,   -853,   -512,  11619,    148,   3681,  -4603,   -282,
       129,   -205,   -606,    167,    306,    464,    485,   -959,
      -203,    254,    151,  -6880,   -262,   5180,    658,  -1378,
      1174,    -53,    -59,    -33,  -3077,   -127,   -223,    -17,
       -31,  -2190,     23,    317,   -169,    203,   -223,   -222,
     -5295,    116,     80,  -2757,   -666,   3377,   -476,     85,
      -630,   -147,   1740,   -175,   -115,    207,    240,   -248,
       -95,  -1016,   3966,   3998,   -343,  -4751,    187,   -113,
      -250,    111,   -510,   -203,    130,     89,    311,    608,
      -221,   -381,   -253,   -359,  -2254,     45,    224,   -141,
        45,    -19,    480,  -5074,    797,  -4580,   -163,    110,
      -234,    337,      6,    707,    492,  -5493,  -2750,    -94,
      -363,    113,   2345,    344,    379,    464,  -3222,    -56,
      -269,   -262,    -10,   -609,    324,   3043,    209,   3092,
      -600,     42,   -615,    -17,    -53,     30,   1123,    224,
       593,    632,    -90,    428,   1117,  -1429,  -6741,    -95,
      -293,   -103,  -2784,    251,   1688,    621,   -349,   1059,
     -1093,   -148,    447,    149,     88,     92,    687,   1249,
        80,    289,  -1841,    221,    -10,    -92,  -1736,    118,
       136,    138,   -162,  -4162,   -111,     62,     95,    166,
      -172,   -695,  -3685,   5694,   -527,   2032,   -549,     43,
      -101,    221,    181,   -479,   7697,   2007,   -127,    805,
       -83,   -535,   1354,   -383,    253,   -622,   2910,   1249,
       782,     13,     42,    994,   -545,     75,   -485,    330,
       -16,    343,    272,   -781,    360,    -97,    -25,   -875,
    -12689,   -623,   -307,    195,   -256, -11644,    229,    180,
       -42,   -361,   -124,    -81,    -23,   -460,  -1993,    212,
      -634,   -847,   1616,   -546,   -583,     99,   3800,     10,
       177,    366,   6106,   -173,    265,   -213,     10,   1108,
      -288,  -1690,   -237,   -312,     38,  -2272,    431,    -26,
      -178,   -764,    507,    355,    677,   -214,   -816, -12411,
        47,     12,    294,   -295,  -3916,   -677,  -4885,   -250,
      -453,  -7716,    478,    231,     17,   -248,    147,   1064,
       637,    -80,    -41,    265,   -383,    142,    116,   2991,
     -3060,    809,   2056,   -119,   -866,    -22,   -660,    233,
       306,  -1873,  -1141,   6995,    186,  -8678,   -109,    -39,
      -105,    730,     18,   -846,    273,  -2922,    210,     26,
      -174,   -142,    990,    131,   -436,   1422,   -217,  -3152,
      3224,     35,    315,    -47,     48,   -221,    568,     44,
       182,   1696,  -1755,   -193,    527,    158,   -555,  -3485,
       171,  -4552,    -47,  -4680,     95,   -112,    184,     80,
       -36,   -915,     87,     24,   -259,  -1743,     68,   -117,
       405,     11,     40,   -320,    -17,   -158,   -134,   -186,
     -1206,   -466,   1262,    133,   -254,   -100,    210,  -1735,
      -636,    319,   -978,     69,    197,   -521,  -5503,    -78,
      -544,  -1011,    101,   -489,   -371,    -79,   -196,    -18,
      -839,   1091,    682,  -1441,  -2375,  -1127,     54,    829,
      -306,   -255,    641,  -3665,    473,   3504,  -1035,   -160,
      -467,   -275,   -437,     79, -13513,    326,    132,     82,
       188,    362,    -74,   1406,    -46,   2864,    351,   -558,
     -1277,    108,    -92,    -53,     72,    -41,    -31,    -97,
       353,     73,   1864,   -207,    106,    -81,  -3930,    173,
        41,   -539,   -497,    135,   -526,   -823,     69,    -10,
       176,    648,  -1710,    564,     80,    237,  -1956,    234,
        11,    142,   -849,   4116,   -473,    110,    129,   2137,
      -170,   3193,     10,    245,   -953,   -827,    -30,   1235,
       366,    -67,     54,   -567,  -7377,   2461,    582,     74,
     -1988,    -33,   -296,   3090,    -54,    145,    564,   -295,
};

static const uint16_t bark_tab_l8_512[] = {
    4,  5,  4,  5,  4,  5,  5,  5,  5,  6,  6,  6,  6,  8,  7,  9,
    9, 11, 11, 14, 15, 17, 20, 24, 28, 34, 41, 51, 64, 83,
};

static const uint16_t bark_tab_m8_256[] = {
    3, 4, 3, 4, 3, 4, 4, 5, 5, 6, 6, 8, 9, 11, 13, 17, 23, 29, 41, 58
};

static const uint16_t bark_tab_s8_64[] = {
    2, 1, 2, 2, 3, 4, 5, 7, 13, 25
};

static const uint16_t bark_tab_l16_1024[] = {
     5,  5,  5,  5,  5,  5,  5,  6,  6,  7,  7,   7,   8,   9, 10, 11,
    12, 14, 17, 19, 22, 27, 33, 40, 51, 64, 84, 114, 164, 257
};

static const uint16_t bark_tab_m16_512[] = {
     3,  3,  3,  3,  4,  3,  4,   4,  4,  5,  5,  6,  7,  8, 10, 12,
    14, 18, 24, 30, 42, 59, 89, 152
};

static const uint16_t bark_tab_s16_128[] = {
    2, 2, 2, 3, 3, 5, 7, 12, 25, 67
};

static const uint16_t bark_tab_s16_64[] = {
    1, 1, 2, 2, 3, 6, 11, 38
};

static const uint16_t bark_tab_l44_2048[] = {
     5,  6,  5,   6,   5,   6,   6,   6,  6,  6,  7,  7,  7,  8,  8,  9,
     9, 10, 11,  11,  13,  14,  16,  17, 19, 22, 25, 29, 33, 39, 46, 54,
    64, 79, 98, 123, 161, 220, 320, 512,
};

static const uint16_t bark_tab_m44_512[] = {
     3,  2,  3,   3,  3,  4,  3,  5,  4,  6,  7,  8, 10, 14, 18, 25,
    36, 55, 95, 208,
};

static const uint16_t bark_tab_s44_128[] = {
    1, 2, 1, 2, 3, 4, 6, 10, 23, 76
};

const TwinVQModeTab ff_metasound_mode0808 = {
    {
        { 8, bark_tab_s8_64,  10, fcb8s, 1, 5, cb0808s0, cb0808s1, 18 },
        { 2, bark_tab_m8_256, 20, fcb8m, 2, 5, cb0808m0, cb0808m1, 16 },
        { 1, bark_tab_l8_512, 30, fcb8l, 3, 6, cb0808l0, cb0808l1, 17 }
    },
    512, 12, lsp8, 1, 5, 3, 3, shape8, 8, 28, 20, 6, 200
};

const TwinVQModeTab ff_metasound_mode1616 = {
    {
        { 8, bark_tab_s16_128,  10, fcb16s, 1, 5, cb1616s0, cb1616s1, 16 },
        { 2, bark_tab_m16_512,  24, fcb16m, 2, 5, cb1616m0, cb1616m1, 15 },
        { 1, bark_tab_l16_1024, 30, fcb16l, 3, 6, cb1616l0, cb1616l1, 16 }
    },
    1024, 16, lsp16, 1, 6, 4, 3, shape16, 9, 28, 30, 7, 200
};

const TwinVQModeTab ff_metasound_mode4432 = {
    {
        { 16, bark_tab_s44_128,  10, fcb44ss, 1, 6, cb4432s0, cb4432s1, 23 },
        {  4, bark_tab_m44_512,  20, fcb44sm, 2, 6, cb4432m0, cb4432m1, 21 },
        {  1, bark_tab_l44_2048, 40, fcb44sl, 4, 6, cb4432l0, cb4432l1, 22 }
    },
    2048, 20, lsp44s, 1, 6, 4, 4, shape44s, 9, 84, 54, 7, 200,
};

const TwinVQModeTab ff_metasound_mode4448s = {
    {
        { 16, bark_tab_s44_128,  10, fcb44ss, 1, 6, cb4448ss0, cb4448ss1, 15 },
        {  4, bark_tab_m44_512,  20, fcb44sm, 2, 6, cb4448sm0, cb4448sm1, 14 },
        {  1, bark_tab_l44_2048, 40, fcb44sl, 4, 6, cb4448sl0, cb4448sl1, 14 }
    },
    2048, 20, lsp44s, 1, 6, 4, 4, shape44s, 9, 84, 54, 7, 200
};
