/*
 * Application.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  Application.cpp
*/
#include <FL/Fl.H>

#include "Application.hpp"
#include "Br.hpp"       // `Br'
#include "BrGUI.hpp"    // `BrGUI'


/**--------------------------------------------------------
 * run()
 *
 * I want to allow remaining of secondary windows (e.g. a tutorial) on 
 *   screen after primary window ("the program") was quit by user.
 *   Fltk's Fl::run()-loop finishes only if the last window created in a
 *   session has been closed. To avoid that data memory remains allocated until
 *   last window (tutorial) is closed, it should freed after closing of primary
 *   window. The form
 *      primeWindow = new PrimeWindow();
 *      Fl::run();
 *   would need doing that in the callback of PrimeWindow, what I don't like. 
 *   Furthermore the prime window itself couldn't be deleted so. Therefore
 *   the solution below with two "self-made" run-loops.
 *--------------------------------------------------------*/
int Application::run()
{
  // Create primary Window... (`show()' in Ctor)
  primeWindow = new PrimeWindow;
  
  // Fltk-Loop for prime window... (life time of the real application)
  while (primeWindow -> shown())
    Fl::wait();
     
  // Destroy prime window...
  delete primeWindow;  primeWindow=0;
  
  // Destroy non-remaining secondary windows...
  BrGUI.clear();
  
  // Free data memory...
  Br.clear();
  
  // Fltk-Loop for remaining secondary windows...
  while (BrGUI.rest_shown())
    Fl::wait();   
    
  // Destroy these rest windows...  
  BrGUI.clear_rest();  
  
  return 0;
}


// END OF FILE
