/*
 * CCDCurveMenu.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  CCDCurvePanel.hpp
*/
#ifndef CCDCurveMenu_hpp
#define CCDCurveMenu_hpp

#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_.H>

#include "br_types_plot.hpp"    // type CurvePlotClass
#include "YS/ys_dbg.hpp"        // macros CTOR(), DTOR()

#include "FollowCurveWindow.hpp"  // solange hier mal 'CurveWindow' dekl.


/**=====================================================================
 *
 * CCDCurvePanel  --  class 
 *
 * Gedacht als separates Hauptfenster. Dann nenn's doch "CCDCurveWindow".
 *
 *======================================================================*/
class CCDCurvePanel : public Fl_Group
{
  static const char*  default_title_;
  static const char*  outdated_str_;
  static Fl_Menu_Item  menu_menubar_[];
  CurvePlotClass*  plot_;
   
public:
  CCDCurvePanel (int X, int Y, int W, int H, const char* la=default_title_);
  ~CCDCurvePanel();
  
private:
  void build_plot();
  void update_plot()     {DB_ build_plot(); plot_->redraw();}
  
  // Fl_Callbacks...
  void        cb_window ();
  static void cb_window_(Fl_Widget* w, CCDCurvePanel* I)
    { I -> cb_window(); }

  void        cb_close (Fl_Menu_*)      { cb_window(); }
  static void cb_close_(Fl_Menu_* o, void*)
    { ((CCDCurvePanel*)o->user_data()) -> cb_close(o); }  
    
  void        cb_update (Fl_Menu_*);
  static void cb_update_(Fl_Menu_* o, void*)
    { ((CCDCurvePanel*)o->user_data()) -> cb_update(o); }  
  
  // Distributor Callback(s)...
  void        event_msg (BracketingCore::Event);
  static void event_msg_(BracketingCore::Event* e, CCDCurvePanel* I)
    { I -> event_msg (*e); }  
};


class CCDCurveWindow : public Fl_Window
{
  static const char*  default_title_;
  CCDCurvePanel*      panel_;
public:
  CCDCurveWindow (int W, int H, const char* la=default_title_); 
  CCDCurveWindow (int X, int Y, int W, int H, const char* la=default_title_);
  ~CCDCurveWindow()   {DTOR(label());}
};



class CurveWindow : public Fl_Window
{
  static const char* default_title_;
  FollowCurvePanel* followUp_;
  CCDCurvePanel*   response_;
public:
  CurveWindow(int X, int Y, int W, int H, const char* la=default_title_);
  CurveWindow(int W, int H, const char* la=default_title_ );
  ~CurveWindow()   {DTOR(label());}
};


#endif // CCDCurveMenu_hpp

// END OF FILE
